# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class RepositoryFile(pulumi.CustomResource):
    branch: pulumi.Output[str]
    """
    Git branch (defaults to `master`).
    The branch must already exist, it will not be created if it does not already exist.
    """
    commit_author: pulumi.Output[str]
    """
    Committer author name to use.
    """
    commit_email: pulumi.Output[str]
    """
    Committer email address to use.
    """
    commit_message: pulumi.Output[str]
    """
    Commit message when adding or updating the managed file.
    """
    content: pulumi.Output[str]
    """
    The file content.
    """
    file: pulumi.Output[str]
    """
    The path of the file to manage.
    """
    repository: pulumi.Output[str]
    """
    The repository name
    """
    sha: pulumi.Output[str]
    """
    The SHA blob of the file.
    """
    def __init__(__self__, resource_name, opts=None, branch=None, commit_author=None, commit_email=None, commit_message=None, content=None, file=None, repository=None, __props__=None, __name__=None, __opts__=None):
        """
        This resource allows you to create and manage files within a
        GitHub repository.


        ## Example Usage



        ```python
        import pulumi
        import pulumi_github as github

        gitignore = github.RepositoryFile("gitignore",
            content="**/*.tfstate",
            file=".gitignore",
            repository="example")
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] branch: Git branch (defaults to `master`).
               The branch must already exist, it will not be created if it does not already exist.
        :param pulumi.Input[str] commit_author: Committer author name to use.
        :param pulumi.Input[str] commit_email: Committer email address to use.
        :param pulumi.Input[str] commit_message: Commit message when adding or updating the managed file.
        :param pulumi.Input[str] content: The file content.
        :param pulumi.Input[str] file: The path of the file to manage.
        :param pulumi.Input[str] repository: The repository name
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['branch'] = branch
            __props__['commit_author'] = commit_author
            __props__['commit_email'] = commit_email
            __props__['commit_message'] = commit_message
            if content is None:
                raise TypeError("Missing required property 'content'")
            __props__['content'] = content
            if file is None:
                raise TypeError("Missing required property 'file'")
            __props__['file'] = file
            if repository is None:
                raise TypeError("Missing required property 'repository'")
            __props__['repository'] = repository
            __props__['sha'] = None
        super(RepositoryFile, __self__).__init__(
            'github:index/repositoryFile:RepositoryFile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, branch=None, commit_author=None, commit_email=None, commit_message=None, content=None, file=None, repository=None, sha=None):
        """
        Get an existing RepositoryFile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] branch: Git branch (defaults to `master`).
               The branch must already exist, it will not be created if it does not already exist.
        :param pulumi.Input[str] commit_author: Committer author name to use.
        :param pulumi.Input[str] commit_email: Committer email address to use.
        :param pulumi.Input[str] commit_message: Commit message when adding or updating the managed file.
        :param pulumi.Input[str] content: The file content.
        :param pulumi.Input[str] file: The path of the file to manage.
        :param pulumi.Input[str] repository: The repository name
        :param pulumi.Input[str] sha: The SHA blob of the file.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["branch"] = branch
        __props__["commit_author"] = commit_author
        __props__["commit_email"] = commit_email
        __props__["commit_message"] = commit_message
        __props__["content"] = content
        __props__["file"] = file
        __props__["repository"] = repository
        __props__["sha"] = sha
        return RepositoryFile(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

