# PyKrev: van Krevelen analysis and beyond

PyKrev is a Python 3 library to help with analysis of high resolution mass spectrometry data.

To install use:

```
pip install pykrev
```

Core tutorials: 

* [**PyKrev User Guide**](https://nbviewer.jupyter.org/github/Kzra/pykrev/blob/master/docs/user_guide/PyKrevUserGuide.ipynb)

* [**Batch Analysis with PyKrev**](https://nbviewer.jupyter.org/github/Kzra/pykrev/blob/master/docs/batch_analysis_with_pykrev/BatchAnalysisWithPyKrev.ipynb)

Other tutorials:

* [Making UpSet plots with PyKrev and UpSetPlot](https://nbviewer.jupyter.org/github/Kzra/pykrev/blob/master/docs/upset_plots_with_pykrev/UpSetplotswithPyKrev.ipynb)

* [Performing PCA with PyKrev and scikit-learn](https://nbviewer.jupyter.org/github/Kzra/pykrev/blob/master/docs/pca_with_pykrev/PCAwithPyKrev.ipynb)

* [PageRank and network visualisation on FT-ICR-MS data](https://nbviewer.jupyter.org/github/Kzra/pykrev/blob/master/docs/pagerank_and_networkvis/PageRankandNetworkVis.ipynb)

* [Raw FT-MS data processing with PyKrev and CoreMS](https://nbviewer.jupyter.org/github/Kzra/pykrev/blob/master/docs/corems_with_pykrev/CoreMsWithPykrev.ipynb)

Version 1.2.0 [*Changelog*](https://github.com/Kzra/pykrev/blob/master/CHANGELOG.md)

Citation: Kitson, E., Kew, W., Ding, W. & Bell, N. G. A. PyKrev: A Python Library for the Analysis of Complex Mixture FT-MS Data. J. Am. Soc. Mass Spectrom. jasms.1c00064 (2021) [doi:10.1021/jasms.1c00064](https://pubs.acs.org/doi/10.1021/jasms.1c00064)

Please send any feedback or comments to ezra.kitson@ed.ac.uk

<img src="https://github.com/Kzra/pykrev/blob/master/docs/user_guide/Pykrev_blue.png" alt="PyKrev" width="650"/>
