# Generated by Django 4.1 on 2023-01-24 10:09

from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("coreplus_notices", "0001_initial"),
    ]

    operations = [
        migrations.RemoveField(
            model_name="broadcast",
            name="recipient",
        ),
        migrations.AddField(
            model_name="broadcast",
            name="groups",
            field=models.ManyToManyField(
                blank=True,
                help_text="Group of recipients",
                related_name="broadcasts",
                to="auth.group",
                verbose_name="group",
            ),
        ),
        migrations.AddField(
            model_name="broadcast",
            name="image",
            field=models.ImageField(
                blank=True,
                help_text="Make sure your image size atleast 1366x768px and 72 DPI resolution.",
                null=True,
                upload_to="",
                verbose_name="image",
            ),
        ),
        migrations.AddField(
            model_name="broadcast",
            name="media",
            field=models.CharField(
                choices=[
                    ("notification", "Notification"),
                    ("email", "Email"),
                    ("android_notification", "Android Notification"),
                    ("all", "All"),
                ],
                default="notification",
                max_length=255,
                verbose_name="media",
            ),
        ),
        migrations.AddField(
            model_name="broadcast",
            name="users",
            field=models.ManyToManyField(
                blank=True,
                help_text="Recipients",
                related_name="broadcasts",
                to=settings.AUTH_USER_MODEL,
                verbose_name="user",
            ),
        ),
        migrations.AddField(
            model_name="notificationpreference",
            name="email",
            field=models.BooleanField(
                default=True, help_text="Receive notification by email"
            ),
        ),
        migrations.AddField(
            model_name="notificationpreference",
            name="push_notification",
            field=models.BooleanField(
                default=True, help_text="Receive notification by app"
            ),
        ),
        migrations.AlterField(
            model_name="broadcast",
            name="sent_counter",
            field=models.IntegerField(
                default=0, editable=False, verbose_name="Counter"
            ),
        ),
    ]
