# Generated by Django 4.1 on 2022-11-16 18:12

import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="NotificationPreference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "article_notification",
                    models.BooleanField(
                        default=True,
                        help_text="Receive article notification",
                        verbose_name="Article Notice",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="notice_preferences",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="User",
                    ),
                ),
            ],
            options={
                "verbose_name": "Notification Preference",
                "verbose_name_plural": "Notification Preferences",
            },
        ),
        migrations.CreateModel(
            name="Broadcast",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    models.CharField(
                        blank=True, max_length=255, null=True, verbose_name="title"
                    ),
                ),
                (
                    "message",
                    models.TextField(blank=True, null=True, verbose_name="Message"),
                ),
                ("action_url", models.URLField(verbose_name="Action URL")),
                (
                    "action_title",
                    models.CharField(max_length=255, verbose_name="Action Title"),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created at",
                    ),
                ),
                (
                    "last_sent_at",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="last sent",
                    ),
                ),
                (
                    "sent_counter",
                    models.IntegerField(default=0, verbose_name="Counter"),
                ),
                (
                    "recipient",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="notification_messages",
                        to="auth.group",
                        verbose_name="User",
                    ),
                ),
            ],
            options={
                "verbose_name": "Broadcast",
                "verbose_name_plural": "Broadcasts",
            },
        ),
    ]
