# Generated by Django 4.1 on 2022-11-16 18:12

import django.db.models.deletion
import django.utils.timezone
import filer.fields.file
from django.conf import settings
from django.db import migrations, models

import coreplus.utils.models.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("filer", "0015_alter_file_owner_alter_file_polymorphic_ctype_and_more"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="DirectMessage",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "reaction",
                    models.JSONField(
                        editable=False,
                        help_text='JSON fields contains {"like": 1, "love":2, "flap":3}',
                        verbose_name="reaction",
                    ),
                ),
                (
                    "created",
                    coreplus.utils.models.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    coreplus.utils.models.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "status",
                    coreplus.utils.models.fields.StatusField(
                        choices=[("read", "read"), ("unread", "unread")],
                        default="read",
                        max_length=100,
                        no_check_for_status=True,
                        verbose_name="status",
                    ),
                ),
                (
                    "status_changed",
                    coreplus.utils.models.fields.MonitorField(
                        default=django.utils.timezone.now,
                        editable=False,
                        monitor="status",
                        verbose_name="status changed",
                    ),
                ),
                ("content", models.TextField(max_length=1000, verbose_name="Content")),
                (
                    "content_html",
                    models.TextField(
                        blank=True,
                        editable=False,
                        null=True,
                        verbose_name="Content Html",
                    ),
                ),
                (
                    "recipient",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="recipient_direct_messages",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "sender",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="sender_direct_messages",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Direct Message",
                "verbose_name_plural": "Direct Messages",
                "ordering": ("created",),
            },
        ),
        migrations.CreateModel(
            name="DirectMessageAttachment",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "attachment",
                    filer.fields.file.FilerFileField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="direct_message_attachments",
                        to="filer.file",
                    ),
                ),
                (
                    "direct_message",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="attachments",
                        to="coreplus_heralds.directmessage",
                    ),
                ),
            ],
            options={
                "verbose_name": "Direct Message Attachment",
                "verbose_name_plural": "Direct Message Attachments",
            },
        ),
    ]
