from types import TracebackType
from typing import Any, Optional, Type

from .concurrent import Future

class _TimeoutGarbageCollector:
    def __init__(self) -> None: ...

class Condition(_TimeoutGarbageCollector):
    io_loop: Any
    def __init__(self) -> None: ...
    def wait(self, timeout: Optional[float] = ...) -> Future: ...
    def notify(self, n: int = ...) -> None: ...
    def notify_all(self) -> None: ...

class Event:
    def __init__(self) -> None: ...
    def is_set(self) -> bool: ...
    def set(self) -> None: ...
    def clear(self) -> None: ...
    def wait(self, timeout: Optional[Any] = ...): ...

class _ReleasingContextManager:
    def __init__(self, obj) -> None: ...
    def __enter__(self) -> None: ...
    def __exit__(self, exc_type, exc_val, exc_tb): ...

class Semaphore(_TimeoutGarbageCollector):
    def __init__(self, value: int = ...) -> None: ...
    def release(self) -> None: ...
    def acquire(self, timeout: Optional[float] = ...) -> Future: ...
    # __enter__ and __exit__ exist but always throw an error, so we
    # omit them to give better error message while type checking.
    def __aenter__(self) -> Future: ...
    def __aexit__(
        self, typ: Optional[Type[BaseException]], value: Optional[BaseException], tb: Optional[TracebackType]
    ) -> Future: ...

class BoundedSemaphore(Semaphore): ...

class Lock:
    def __init__(self) -> None: ...
    def acquire(self, timeout: Optional[float] = ...) -> Future: ...
    def release(self) -> None: ...
    # __enter__ and __exit__ exist but always throw an error, so we
    # omit them to give better error message while type checking.
    def __aenter__(self) -> Future: ...
    def __aexit__(
        self, typ: Optional[Type[BaseException]], value: Optional[BaseException], tb: Optional[TracebackType]
    ) -> Future: ...
