# coding: utf-8

"""
    EPIC API

    REST API for interacting with EPIC (https://epic.zenotech.com) services. <br />                             Used by the EPIC CLI (https://github.com/zenotech/epic-cli).                             Please note this API is in BETA and does not yet contain                             all EPIC functionality.  # noqa: E501

    The version of the OpenAPI document: v2
    Contact: support@zenotech.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from epiccore.configuration import Configuration


class Project(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'pk': 'int',
        'project_id': 'str',
        'description': 'str',
        'closed': 'bool'
    }

    attribute_map = {
        'pk': 'pk',
        'project_id': 'project_id',
        'description': 'description',
        'closed': 'closed'
    }

    def __init__(self, pk=None, project_id=None, description=None, closed=None, local_vars_configuration=None):  # noqa: E501
        """Project - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._pk = None
        self._project_id = None
        self._description = None
        self._closed = None
        self.discriminator = None

        if pk is not None:
            self.pk = pk
        self.project_id = project_id
        self.description = description
        if closed is not None:
            self.closed = closed

    @property
    def pk(self):
        """Gets the pk of this Project.  # noqa: E501


        :return: The pk of this Project.  # noqa: E501
        :rtype: int
        """
        return self._pk

    @pk.setter
    def pk(self, pk):
        """Sets the pk of this Project.


        :param pk: The pk of this Project.  # noqa: E501
        :type pk: int
        """

        self._pk = pk

    @property
    def project_id(self):
        """Gets the project_id of this Project.  # noqa: E501


        :return: The project_id of this Project.  # noqa: E501
        :rtype: str
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id):
        """Sets the project_id of this Project.


        :param project_id: The project_id of this Project.  # noqa: E501
        :type project_id: str
        """
        if self.local_vars_configuration.client_side_validation and project_id is None:  # noqa: E501
            raise ValueError("Invalid value for `project_id`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                project_id is not None and len(project_id) > 100):
            raise ValueError("Invalid value for `project_id`, length must be less than or equal to `100`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                project_id is not None and len(project_id) < 1):
            raise ValueError("Invalid value for `project_id`, length must be greater than or equal to `1`")  # noqa: E501

        self._project_id = project_id

    @property
    def description(self):
        """Gets the description of this Project.  # noqa: E501


        :return: The description of this Project.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Project.


        :param description: The description of this Project.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def closed(self):
        """Gets the closed of this Project.  # noqa: E501


        :return: The closed of this Project.  # noqa: E501
        :rtype: bool
        """
        return self._closed

    @closed.setter
    def closed(self, closed):
        """Sets the closed of this Project.


        :param closed: The closed of this Project.  # noqa: E501
        :type closed: bool
        """

        self._closed = closed

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Project):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Project):
            return True

        return self.to_dict() != other.to_dict()
