# coding: utf-8

"""
    EPIC API

    REST API for interacting with EPIC (https://epic.zenotech.com) services. <br />                             Used by the EPIC CLI (https://github.com/zenotech/epic-cli).                             Please note this API is in BETA and does not yet contain                             all EPIC functionality.  # noqa: E501

    The version of the OpenAPI document: v2
    Contact: support@zenotech.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from epiccore.configuration import Configuration


class JobSpec(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'application_version': 'int',
        'project': 'int',
        'tasks': 'list[JobTaskSpec]'
    }

    attribute_map = {
        'application_version': 'application_version',
        'project': 'project',
        'tasks': 'tasks'
    }

    def __init__(self, application_version=None, project=None, tasks=None, local_vars_configuration=None):  # noqa: E501
        """JobSpec - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._application_version = None
        self._project = None
        self._tasks = None
        self.discriminator = None

        self.application_version = application_version
        if project is not None:
            self.project = project
        self.tasks = tasks

    @property
    def application_version(self):
        """Gets the application_version of this JobSpec.  # noqa: E501

        ID of the application_version to launch. Valid values are obtained from the catalog/applications/ endpoint  # noqa: E501

        :return: The application_version of this JobSpec.  # noqa: E501
        :rtype: int
        """
        return self._application_version

    @application_version.setter
    def application_version(self, application_version):
        """Sets the application_version of this JobSpec.

        ID of the application_version to launch. Valid values are obtained from the catalog/applications/ endpoint  # noqa: E501

        :param application_version: The application_version of this JobSpec.  # noqa: E501
        :type application_version: int
        """
        if self.local_vars_configuration.client_side_validation and application_version is None:  # noqa: E501
            raise ValueError("Invalid value for `application_version`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                application_version is not None and application_version < 1):  # noqa: E501
            raise ValueError("Invalid value for `application_version`, must be a value greater than or equal to `1`")  # noqa: E501

        self._application_version = application_version

    @property
    def project(self):
        """Gets the project of this JobSpec.  # noqa: E501

        Project ID to bill this job against  # noqa: E501

        :return: The project of this JobSpec.  # noqa: E501
        :rtype: int
        """
        return self._project

    @project.setter
    def project(self, project):
        """Sets the project of this JobSpec.

        Project ID to bill this job against  # noqa: E501

        :param project: The project of this JobSpec.  # noqa: E501
        :type project: int
        """
        if (self.local_vars_configuration.client_side_validation and
                project is not None and project < -1):  # noqa: E501
            raise ValueError("Invalid value for `project`, must be a value greater than or equal to `-1`")  # noqa: E501

        self._project = project

    @property
    def tasks(self):
        """Gets the tasks of this JobSpec.  # noqa: E501

        List of task definitions that make up this job  # noqa: E501

        :return: The tasks of this JobSpec.  # noqa: E501
        :rtype: list[JobTaskSpec]
        """
        return self._tasks

    @tasks.setter
    def tasks(self, tasks):
        """Sets the tasks of this JobSpec.

        List of task definitions that make up this job  # noqa: E501

        :param tasks: The tasks of this JobSpec.  # noqa: E501
        :type tasks: list[JobTaskSpec]
        """
        if self.local_vars_configuration.client_side_validation and tasks is None:  # noqa: E501
            raise ValueError("Invalid value for `tasks`, must not be `None`")  # noqa: E501

        self._tasks = tasks

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, JobSpec):
            return True

        return self.to_dict() != other.to_dict()
