# coding: utf-8

"""
    EPIC API

    REST API for interacting with EPIC (https://epic.zenotech.com) services. <br />                             Used by the EPIC CLI (https://github.com/zenotech/epic-cli).                             Please note this API is in BETA and does not yet contain                             all EPIC functionality.  # noqa: E501

    The version of the OpenAPI document: v2
    Contact: support@zenotech.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from epiccore.configuration import Configuration


class JobAuthStatus(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'required': 'bool',
        'state': 'str',
        'job': 'JobSummary',
        'user_profile': 'UserName',
        'permissions': 'str'
    }

    attribute_map = {
        'required': 'required',
        'state': 'state',
        'job': 'job',
        'user_profile': 'user_profile',
        'permissions': 'permissions'
    }

    def __init__(self, required=None, state=None, job=None, user_profile=None, permissions=None, local_vars_configuration=None):  # noqa: E501
        """JobAuthStatus - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._required = None
        self._state = None
        self._job = None
        self._user_profile = None
        self._permissions = None
        self.discriminator = None

        if required is not None:
            self.required = required
        if state is not None:
            self.state = state
        if job is not None:
            self.job = job
        if user_profile is not None:
            self.user_profile = user_profile
        if permissions is not None:
            self.permissions = permissions

    @property
    def required(self):
        """Gets the required of this JobAuthStatus.  # noqa: E501

        Is authorisation required for this job?  # noqa: E501

        :return: The required of this JobAuthStatus.  # noqa: E501
        :rtype: bool
        """
        return self._required

    @required.setter
    def required(self, required):
        """Sets the required of this JobAuthStatus.

        Is authorisation required for this job?  # noqa: E501

        :param required: The required of this JobAuthStatus.  # noqa: E501
        :type required: bool
        """

        self._required = required

    @property
    def state(self):
        """Gets the state of this JobAuthStatus.  # noqa: E501


        :return: The state of this JobAuthStatus.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this JobAuthStatus.


        :param state: The state of this JobAuthStatus.  # noqa: E501
        :type state: str
        """
        allowed_values = ["PENDING", "AUTHORISED", "REJECTED"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and state not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def job(self):
        """Gets the job of this JobAuthStatus.  # noqa: E501


        :return: The job of this JobAuthStatus.  # noqa: E501
        :rtype: JobSummary
        """
        return self._job

    @job.setter
    def job(self, job):
        """Sets the job of this JobAuthStatus.


        :param job: The job of this JobAuthStatus.  # noqa: E501
        :type job: JobSummary
        """

        self._job = job

    @property
    def user_profile(self):
        """Gets the user_profile of this JobAuthStatus.  # noqa: E501


        :return: The user_profile of this JobAuthStatus.  # noqa: E501
        :rtype: UserName
        """
        return self._user_profile

    @user_profile.setter
    def user_profile(self, user_profile):
        """Sets the user_profile of this JobAuthStatus.


        :param user_profile: The user_profile of this JobAuthStatus.  # noqa: E501
        :type user_profile: UserName
        """

        self._user_profile = user_profile

    @property
    def permissions(self):
        """Gets the permissions of this JobAuthStatus.  # noqa: E501


        :return: The permissions of this JobAuthStatus.  # noqa: E501
        :rtype: str
        """
        return self._permissions

    @permissions.setter
    def permissions(self, permissions):
        """Sets the permissions of this JobAuthStatus.


        :param permissions: The permissions of this JobAuthStatus.  # noqa: E501
        :type permissions: str
        """

        self._permissions = permissions

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobAuthStatus):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, JobAuthStatus):
            return True

        return self.to_dict() != other.to_dict()
