# coding: utf-8

"""
    EPIC API

    REST API for interacting with EPIC (https://epic.zenotech.com) services. <br />                             Used by the EPIC CLI (https://github.com/zenotech/epic-cli).                             Please note this API is in BETA and does not yet contain                             all EPIC functionality.  # noqa: E501

    The version of the OpenAPI document: v2
    Contact: support@zenotech.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from epiccore.configuration import Configuration


class JobAuth(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'enabled': 'bool',
        'all_jobs': 'bool',
        'cost_threshold': 'str',
        'description_str': 'str'
    }

    attribute_map = {
        'enabled': 'enabled',
        'all_jobs': 'all_jobs',
        'cost_threshold': 'cost_threshold',
        'description_str': 'description_str'
    }

    def __init__(self, enabled=False, all_jobs=False, cost_threshold=None, description_str=None, local_vars_configuration=None):  # noqa: E501
        """JobAuth - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._enabled = None
        self._all_jobs = None
        self._cost_threshold = None
        self._description_str = None
        self.discriminator = None

        if enabled is not None:
            self.enabled = enabled
        if all_jobs is not None:
            self.all_jobs = all_jobs
        if cost_threshold is not None:
            self.cost_threshold = cost_threshold
        if description_str is not None:
            self.description_str = description_str

    @property
    def enabled(self):
        """Gets the enabled of this JobAuth.  # noqa: E501

        Is job authorisation enabled?  # noqa: E501

        :return: The enabled of this JobAuth.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this JobAuth.

        Is job authorisation enabled?  # noqa: E501

        :param enabled: The enabled of this JobAuth.  # noqa: E501
        :type enabled: bool
        """

        self._enabled = enabled

    @property
    def all_jobs(self):
        """Gets the all_jobs of this JobAuth.  # noqa: E501

        If authorisation is enabled, then does it apply to all jobs?  # noqa: E501

        :return: The all_jobs of this JobAuth.  # noqa: E501
        :rtype: bool
        """
        return self._all_jobs

    @all_jobs.setter
    def all_jobs(self, all_jobs):
        """Sets the all_jobs of this JobAuth.

        If authorisation is enabled, then does it apply to all jobs?  # noqa: E501

        :param all_jobs: The all_jobs of this JobAuth.  # noqa: E501
        :type all_jobs: bool
        """

        self._all_jobs = all_jobs

    @property
    def cost_threshold(self):
        """Gets the cost_threshold of this JobAuth.  # noqa: E501

        If job authorisation is enabled and all_jobs is false, jobs costing above this value will require authorisation.  # noqa: E501

        :return: The cost_threshold of this JobAuth.  # noqa: E501
        :rtype: str
        """
        return self._cost_threshold

    @cost_threshold.setter
    def cost_threshold(self, cost_threshold):
        """Sets the cost_threshold of this JobAuth.

        If job authorisation is enabled and all_jobs is false, jobs costing above this value will require authorisation.  # noqa: E501

        :param cost_threshold: The cost_threshold of this JobAuth.  # noqa: E501
        :type cost_threshold: str
        """

        self._cost_threshold = cost_threshold

    @property
    def description_str(self):
        """Gets the description_str of this JobAuth.  # noqa: E501

        A user readable description of the state of the job authorisation criteria  # noqa: E501

        :return: The description_str of this JobAuth.  # noqa: E501
        :rtype: str
        """
        return self._description_str

    @description_str.setter
    def description_str(self, description_str):
        """Sets the description_str of this JobAuth.

        A user readable description of the state of the job authorisation criteria  # noqa: E501

        :param description_str: The description_str of this JobAuth.  # noqa: E501
        :type description_str: str
        """
        if (self.local_vars_configuration.client_side_validation and
                description_str is not None and len(description_str) > 30):
            raise ValueError("Invalid value for `description_str`, length must be less than or equal to `30`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                description_str is not None and len(description_str) < 1):
            raise ValueError("Invalid value for `description_str`, length must be greater than or equal to `1`")  # noqa: E501

        self._description_str = description_str

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobAuth):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, JobAuth):
            return True

        return self.to_dict() != other.to_dict()
