# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['netests',
 'netests.comparators',
 'netests.converters',
 'netests.converters.bgp',
 'netests.converters.bgp.arista',
 'netests.converters.bgp.cumulus',
 'netests.converters.bgp.extreme_vsp',
 'netests.converters.bgp.ios',
 'netests.converters.bgp.iosxr',
 'netests.converters.bgp.juniper',
 'netests.converters.bgp.napalm',
 'netests.converters.bgp.nxos',
 'netests.converters.cdp',
 'netests.converters.cdp.cumulus',
 'netests.converters.cdp.ios',
 'netests.converters.cdp.iosxr',
 'netests.converters.cdp.napalm',
 'netests.converters.cdp.nxos',
 'netests.converters.facts',
 'netests.converters.facts.arista',
 'netests.converters.facts.cumulus',
 'netests.converters.facts.extreme_vsp',
 'netests.converters.facts.ios',
 'netests.converters.facts.iosxr',
 'netests.converters.facts.juniper',
 'netests.converters.facts.napalm',
 'netests.converters.facts.nxos',
 'netests.converters.lldp',
 'netests.converters.lldp.arista',
 'netests.converters.lldp.cumulus',
 'netests.converters.lldp.extreme_vsp',
 'netests.converters.lldp.ios',
 'netests.converters.lldp.iosxr',
 'netests.converters.lldp.juniper',
 'netests.converters.lldp.napalm',
 'netests.converters.lldp.nxos',
 'netests.converters.ospf',
 'netests.converters.ospf.arista',
 'netests.converters.ospf.cumulus',
 'netests.converters.ospf.extreme_vsp',
 'netests.converters.ospf.ios',
 'netests.converters.ospf.iosxr',
 'netests.converters.ospf.juniper',
 'netests.converters.ospf.nxos',
 'netests.converters.ping',
 'netests.converters.ping.arista',
 'netests.converters.ping.cumulus',
 'netests.converters.ping.extreme_vsp',
 'netests.converters.ping.ios',
 'netests.converters.ping.iosxr',
 'netests.converters.ping.juniper',
 'netests.converters.ping.nxos',
 'netests.converters.vrf',
 'netests.converters.vrf.arista',
 'netests.converters.vrf.cumulus',
 'netests.converters.vrf.extreme_vsp',
 'netests.converters.vrf.ios',
 'netests.converters.vrf.iosxr',
 'netests.converters.vrf.juniper',
 'netests.converters.vrf.napalm',
 'netests.converters.vrf.nxos',
 'netests.exceptions',
 'netests.getters',
 'netests.protocols',
 'netests.reports',
 'netests.tools',
 'netests.workers']

package_data = \
{'': ['*'],
 'netests': ['data_models/*',
             'templates/jinja2/ping/*',
             'templates/jinja2/ping/result/*',
             'templates/jinja2/socket/*',
             'templates/jinja2/socket/result/*',
             'templates/textfsm/*']}

install_requires = \
['click>=7.1.2,<8.0.0',
 'ipaddress>=1.0.23,<2.0.0',
 'mkdocs>=1.1.2,<2.0.0',
 'nornir>=2.4.0,<3.0.0',
 'pylint>=2.5.2,<3.0.0',
 'termcolor>=1.1.0,<2.0.0',
 'typing>=3.7.4,<4.0.0',
 'xmltodict>=0.12.0,<0.13.0']

entry_points = \
{'console_scripts': ['netests = netests.netests:main']}

setup_kwargs = {
    'name': 'netests',
    'version': '0.1.1',
    'description': 'Test your Network',
    'long_description': '# Netests.io\n\n###### <dylan.hamel@protonmail.com> - November 2019 - Copyright\n\n![logo.png](./docs/images/logo.png)\n\n## Install\n\nCreate your environnement :\n\n```shell\n» python3 -m venv .\n» source ./bin/activate\n\n(netests) ------------------------------------------------------------\n(master*) »\n\n» pip install --upgrade pip\n» pip --version\npip 19.2.3\n```\n\n\n\n## Devices used \n\n#### Cisco IOS-XE\n\n```shell\nROM: IOS-XE ROMMON\nBOOTLDR: System Bootstrap, Version 16.12.1r, RELEASE SOFTWARE (P)\n```\n\n#### Cisco Nexus NXOS\n\n```shell\nNexus 9000v is a demo version of the Nexus Operating System\n\nSoftware\n  BIOS: version\n  NXOS: version 7.0(3)I7(5a)\n  BIOS compile time:\n  NXOS image file is: bootflash:///nxos.7.0.3.I7.5a.bin\n  NXOS compile time:  10/12/2018 19:00:00 [10/13/2018 03:16:04]\n```\n\n#### Juniper VMX\n\n```shell\n> show version\nHostname: leaf04\nModel: vmx\nJunos: 18.3R1.9\n#----------------------\n> show version\nHostname: leaf04\nModel: vmx\nJunos: 19.4R1.10\n```\n\n#### Cumulus \n\n```\nVersion 3.7.9\nVersion 4.0.0\n```\n\n#### Arista\n\n```\nVersion 4.23.1F\n```\n\n#### Extreme Network VSP (VOSS)\n\n```\nVersion 8.1.0.0\n```\n\n\n\n## How to use ??\n\nThis tool contains two modes :\n\n* Integrity & Sanity checks\n* CLI \n\n\n\n### Integrity & Sanity checks\n\nThe idea of this project is to offer a test platform for the network to allow engineers to perform tests without having to write python code (or other languages :smile:).\n\nIn addition, this platform does not consider the OS, it is possible to run tests on Cisco, Cumulus, Juniper devices without changing the data structure.\n\n#### Define inventory\n\n1) You have to create a Nornir or an Ansible inventory (Example based on an Ansible Inventory)\n\n`hosts` file.\n\n```yaml\n[leaf]\nleaf01 # Cumulus Networks\nleaf02 # Cisco Nexus 9k\nleaf03 # Arista vEOS\nleaf04 # Juniper Networks\nleaf05 # Cisco IOS\n\n[spine]\nspine01 # Cumulus Networks\nspine02 # Extreme Networks VSP\nspine03 # Cisco IOS-XR\n```\n\n2) Define device parameters in ``host_vars/inventory_hostname.yml`` files\n\n```yaml\nhostname: 10.0.5.202\nplatform: linux        # <<=== specify device OS (Cumulus Linux)\nusername: admin\npassword: Ci$co123\nconnexion: ssh         # <<=== specify connexion method - check supported protocols \nport: 22\n```\n\n```yaml\nhostname: 10.0.5.204\nplatform: junos        # <<=== specify device OS (Juniper)\nusername: root\npassword: Jun1p3r\nconnexion: netconf     # <<=== specify connexion method - check supported protocols \nport: 830\n```\n\n```yaml\nhostname: 10.0.5.203\nplatform: eos          # <<=== specify device OS (Arista)\nusername: admin\npassword: admin123\nconnexion: api         # <<=== specify connexion method - check supported protocols \nport: 443\n```\n\n\n\n#### Define tests\n\nTests are defined in the file `netests.yml`. In this file you can define which test will be executed.\n\n```yaml\nconfig:\n  nornir_cfg: ./nornir/config_ansible.yml\n  inventory: ./inventory/ansible/hosts\n  protocols:\n    bgp:\n      test: false\n\n    cdp:\n      test: false\n\n    lldp:\n      test: true\n\n    facts:\n      test: false\n      \n    ping:\n      test: false\n```\n\nIn `truth_vars/` you need to define the configuration that you want on your production devices.\n\n### Exemple  :\n\nThere are three ways to define variables :\n\n1. For a specific host - define your configuration in `truth_vars/hosts/hostname/protocol.yml`\n\nLLDP configuration\n\n```yaml\n- local_name: leaf03\n  local_port: Ethernet1\n  neighbor_mgmt_ip: 192.168.1.148\n  neighbor_name: cumulus\n  neighbor_os: Cumulus Linux version 4.0.0\n  neighbor_port: swp1\n  neighbor_type: ["Bridge", "Router"]\n```\n\n> Will test that the neighbor on the port `Ethernet1` is a device named `cumulus` and the connexion is on the port `swp1`.\n\n2. For all hosts defined in a group - such as `spines` - define in `truth_vars/groups/group/protocol.yml`\n\nGroup is `spine-arista`.\nFacts configuration\n\n```yaml\ndomain: dh.local\nversion: 4.24.0F\n```\n\n>Will test if all devices linked to this group has `dh.local` as domain name, `4.24.0F` as version.\n\n3. for all devices - define `truth_vars/all/{{ protocol }}.yml`\n\n```\ndomain: dh.local\n```\n\n> Will test if all devices in your inventory have t domain `dh.local`.\n\n\n\nThe script will connect on each devices, retrieveinformations and campre them with the data define in your `truth_vars/` (source of truth).\n\nIf the informations are the same the tests is OK :smile:\n\n#### Run the script\n\n```shell\n./netests.py -x -i inventory/ansible/hosts -a netests.yml\n[netests - base_run.py](ping) is working = True\n\n# -x / Define that you will use an Ansible inventory\n# -i / Path to your Ansible inventory\n# -a / Path to your netests configuration file (default is netests.yml)\n```\n\n\n\n### Netests-CLI\n\nYou can get some informations regarding you network configuration directly from the CLI.\n\nThis tool will use your Ansible/Nornir/Netbox Inventory. For example :\n\n```shell\n[leaf]\nleaf01\nleaf02\nleaf03\nleaf04\nleaf05\n\n[spine]\nspine01\nspine02\nspine03\n```\n\n#### Run the CLI tool\n\n```shell\n⚡ ./netests.py -x -i inventory/ansible/hosts -a netests.yml -t\n*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*\nWelcome to Netests CLI\n*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*\n```\n\n#### Get HELP\n\n```\n> help\n+------------------------------------------------------------+\n|                       Netests Help                         |\n+------------------------------------------------------------+\n| [help]      Display help                                   |\n| [select]    Select devices on which on action will be exec |\n| [unselect]  Remove a device from the selected              |\n| [selected]  Show devices currently selected                |\n| [get xx]   Get XX protocols informations                   |\n| [options]   Set arguments that will retrieve for a Protocol|\n| [more xx]  Show XX Protocol class arguments selected       |\n| [show xx]  Show XX Protocol class arguments                |\n| [print yy]  Show YY devices informations                   |\n| [compare yy xx]  Compare device config with source of truth|\n| [exit]  Quit Netests CLI                                   |\n+------------------------------------------------------------+\n```\n\n\n\n#### Get help for a specific command\n\n```\n> help options\n+------------------------------------------------------------+\n|                 Netests - Options Commands                 |\n+------------------------------------------------------------+\n| This command is used to define which parameter will be     |\n| retrieve for a protocol.                                   |\n| It is possible to get a subset of protocols parameters.    |\n| Format :                                                   |\n|   > options  {{ protocol }}  {{ classArg1,classArg2  }}    |\n|   (To get all protocols parameters use the \'show\' command) |\n|                                                            |\n| Examples :                                                 |\n|   > options vrf vrf_name,rd,rt_imp,rt_exp                  |\n+------------------------------------------------------------+\n```\n\n\n\n#### Print hosts defined in your inventory :\n\n```\n{   \'leaf01\': {   \'connexion\': \'ssh\',\n                  \'hostname\': \'172.16.194.51\',\n                  \'platform\': \'linux\',\n                  \'port\': 22},\n    \'leaf02\': {   \'connexion\': \'api\',\n                  \'hostname\': \'sbx-nxos-mgmt.cisco.com\',\n                  \'platform\': \'nxos\',\n                  \'port\': 443},\n    \'leaf04\': {   \'connexion\': \'netconf\',\n                  \'hostname\': \'66.129.235.11\',\n                  \'platform\': \'junos\',\n                  \'port\': 40002},\n    \'leaf05\': {   \'connexion\': \'ssh\',\n                  \'hostname\': \'ios-xe-mgmt.cisco.com\',\n                  \'platform\': \'ios\',\n                  \'port\': 8181}}\n```\n\n\n\n#### Select devices\n\nAt the beginning if you use a command to get some network informations, nothing will happend. The reason is that no device is selected.\n\n```shell\n> get vrf\n[[netests - get_vrf]] no device selected.\n*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*\n@End GET\n*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-\n```\n\nYou have to select devices on which one you would get informations\n\n##### Select all devices in the inventory\n\n```shell\n> select *\n@Followings devices will be added to the list :\n@[\'leaf01\', \'leaf02\', \'leaf03\', \'leaf04\', \'leaf05\', \'spine01\', \'spine02\', \'spine03\']\n```\n\n##### Select only a subset of devices\n\n```\n> select leaf01,spine03\n@Followings devices will be added to the list :\n@[\'leaf01\', \'spine03\']\n```\n\n\n\n#### Print selected devices\n\n```\n> selected\n@Followings devices are selected :\n@[\'leaf01\', \'leaf02\', \'leaf04\', \'leaf05\']\n```\n\n\n\n#### Execute GET\n\nRun the command `get` and the protocols that you would like retrieve.\n\n```shell\n> select leaf01,spine03\n@Followings devices will be added to the list :\n@[\'leaf01\', \'spine03\']\n> get vrf\n*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*\n>>>>> spine03\n{   \'ListVRF\': [   {   \'VRF\': {   \'exp_targ\': \'NOT_SET\',\n                                  \'imp_targ\': \'NOT_SET\',\n                                  \'l3_vni\': \'NOT_SET\',\n                                  \'rd\': \'NOT_SET\',\n                                  \'rt_exp\': \'NOT_SET\',\n                                  \'rt_imp\': \'NOT_SET\',\n                                  \'vrf_id\': \'NOT_SET\',\n                                  \'vrf_name\': \'MGMT_VRF\',\n                                  \'vrf_type\': \'NOT_SET\'}},\n                   {   \'VRF\': {   \'exp_targ\': \'NOT_SET\',\n                                  \'imp_targ\': \'NOT_SET\',\n                                  \'l3_vni\': \'NOT_SET\',\n                                  \'rd\': \'NOT_SET\',\n                                  \'rt_exp\': \'65000:1\',\n                                  \'rt_imp\': \'65000:1\',\n                                  \'vrf_id\': \'NOT_SET\',\n                                  \'vrf_name\': \'EXTERNAL_PEERING\',\n                                  \'vrf_type\': \'NOT_SET\'}}]}\n*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*\n>>>>> leaf01\n{   \'ListVRF\': [   {   \'VRF\': {   \'exp_targ\': \'NOT_SET\',\n                                  \'imp_targ\': \'NOT_SET\',\n                                  \'l3_vni\': \'NOT_SET\',\n                                  \'rd\': \'NOT_SET\',\n                                  \'rt_exp\': \'NOT_SET\',\n                                  \'rt_imp\': \'NOT_SET\',\n                                  \'vrf_id\': \'1001\',\n                                  \'vrf_name\': \'mgmt\',\n                                  \'vrf_type\': \'NOT_SET\'}}]}\n*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*\n@End GET\n*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*\n```\n\n\n\n#### Compare config with `truth_vars/`\n\n```\n> compare facts\n*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-\n{   \'Facts\': {   \'base_mac\': \'NOT_SET\',\n                 \'build\': \'fc2\',\n                 \'domain\': \'NOT_SET\',\n                 \'hostname\': \'csr1000v\',\n                 \'interfaces_lst\': [   \'GigabitEthernet1\',\n                                       \'GigabitEthernet2\',\n                                       \'GigabitEthernet3\',\n                                       \'Loopback3\',\n                                       \'Loopback1234\',\n                                       \'Loopback9009\'],\n                 \'memory\': \'8113280\',\n                 \'model\': \'CSR1000V\',\n                 \'serial\': \'9OOFTICVAFM\',\n                 \'vendor\': \'Cisco\',\n                 \'version\': \'16.9.3\'}}\n[netests - compare_facts] Key infos_data is missingfor leaf05 or no Facts data has been found.\n*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-\n@The following devices have the same configuration that defined in the source of truth :\n@[leaf05].\n*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-\n>\n```\n\n\n\n#### Screenshot\n\n![docs/images/netests_cli.png](docs/images/netests_cli.png)\n\n\n\n#### Video\n\nhttps://www.youtube.com/watch?v=_WStUkQLWEU\n\n\n\n\n## Capabilities Supported by Protocols & Connexion modes\n\n|                     | VRF                | FACTS              | BGP                | BGP_UP             | LLDP               | CDP                | PING                     | OSPF               |\n| ------------------- | ------------------ | ------------------ | ------------------ | ------------------ | ------------------ | ------------------ | ------------------------ | ------------------ |\n| NAPALM              | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :no_entry:         | :no_entry:               | :no_entry:         |\n| Juniper SSH         | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :no_entry:         | :white_check_mark:       | :white_check_mark: |\n| Juniper Netconf     | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :no_entry:         | :white_check_mark:       | :white_check_mark: |\n| Juniper API         | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :no_entry:         | :white_check_mark:       | :white_check_mark: |\n| Cumulus SSH         | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark:       | :white_check_mark: |\n| Cumulus Netconf     | :no_entry:         | :no_entry:         | :no_entry:         | :no_entry:         | :no_entry:         | :no_entry:         | :no_entry:               | :no_entry:         |\n| Cumulus API         | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :no_entry:               | :white_check_mark: |\n| Arista SSH          | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :no_entry:         | :white_check_mark:       | :white_check_mark: |\n| Arista API          | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :no_entry:         | :white_check_mark:       | :white_check_mark: |\n| Arista Netconf      | :white_check_mark: | :warning:          | :warning:          | :warning:          | :warning:          | :no_entry:         | :warning:                | :warning:          |\n| Nexus SSH           | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark:       | :white_check_mark: |\n| Nexus Netconf       | :white_check_mark: | :warning:          | :warning:          | :warning:          | :warning:          | :warning:          | :no_entry:               | :warning:          |\n| Nexus API           | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark:       | :white_check_mark: |\n| IOS SSH             | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark:       | :white_check_mark: |\n| IOS API             | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :warning:          | :warning:          | :no_entry:               |                    |\n| IOS Netconf         | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :warning:          | :warning:          | :no_entry:               |                    |\n| Extreme VSP SSH     | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :no_entry:         | :white_check_mark:       | :white_check_mark: |\n| Extreme VSP API     | :no_entry:         | :white_check_mark: | :no_entry:         | :no_entry:         | :white_check_mark: | :no_entry:         | :no_entry:               | :no_entry:         |\n| Extreme VSP Netconf | :no_entry:         | :no_entry:         | :no_entry:         | :no_entry:         | :no_entry:         | :no_entry:         | :no_entry:               | :no_entry:         |\n| IOSXR SSH           | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark:       |                    |\n| IOSXR Netconf       | :white_check_mark: | :warning:          | :white_check_mark: | :white_check_mark: | :warning:          | :warning:          | :white_check_mark: \u200b6.2.1 |                    |\n| IOSXR API           | :no_entry:         | :no_entry:         | :no_entry:         | :no_entry:         | :no_entry:         | :no_entry:         | :no_entry:               | :no_entry:         |\n\n:warning: = Not Implemented\n\n:no_entry: = Not Supported\n\n\n\n## TextFSM templates\n\nSome templates have be retreieved on :\n\n**https://github.com/networktocode/ntc-templates/tree/master/templates**\n\n\n\n## Alternative to NAPALM ??\n\nThe answer is definitely NO !!\n\nNAPALM has many many more functions about configuration management.\n\nNetests only gets data from devices convert in object and compares to your source of truth.\n\nMoreover, Nestests uses NAPALM.\n\nTo have more informations about all posibilities offered by NAPALM have look on the following links :\n\nhttps://gitlab.com/DylanHamel/netests\n\nhttps://github.com/napalm-automation\n\nhttps://napalm.readthedocs.io/en/latest/\n\n\n\n## Contributor\n\nDylan Hamel - <dylan.hamle@protonmail.com>\n\n**Become a contributor** !!!',
    'author': 'Dylan Hamel',
    'author_email': 'dylan.hamel@protonmail.com',
    'maintainer': 'Netests Team',
    'maintainer_email': 'ping@netests.io',
    'url': 'https://gitlab.com/DylanHamel/netests',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
