"""Add AdminAPIKey model

Revision ID: 68546b741bdf
Revises: a43c2a95cbbf
Create Date: 2022-03-11 15:05:10.382246

"""
import sqlalchemy as sa
from alembic import op

import fief

# revision identifiers, used by Alembic.
revision = "68546b741bdf"
down_revision = "a43c2a95cbbf"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "admin_api_key",
        sa.Column("id", fief.models.generics.GUID(), nullable=False),
        sa.Column(
            "created_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column("name", sa.String(length=255), nullable=False),
        sa.Column("token", sa.String(length=255), nullable=False),
        sa.Column("account_id", fief.models.generics.GUID(), nullable=False),
        sa.ForeignKeyConstraint(["account_id"], ["accounts.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("token"),
    )
    op.create_index(
        op.f("ix_admin_api_key_created_at"),
        "admin_api_key",
        ["created_at"],
        unique=False,
    )
    op.create_index(
        op.f("ix_admin_api_key_updated_at"),
        "admin_api_key",
        ["updated_at"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_admin_api_key_updated_at"), table_name="admin_api_key")
    op.drop_index(op.f("ix_admin_api_key_created_at"), table_name="admin_api_key")
    op.drop_table("admin_api_key")
    # ### end Alembic commands ###
