"""Add SessionToken table

Revision ID: 978e795ec35b
Revises: 0863948660e4
Create Date: 2022-02-02 17:53:38.463938

"""
import sqlalchemy as sa
from alembic import op

import fief

# revision identifiers, used by Alembic.
revision = "978e795ec35b"
down_revision = "0863948660e4"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "fief_session_tokens",
        sa.Column("id", fief.models.generics.GUID(), nullable=False),
        sa.Column(
            "created_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column("token", sa.String(length=255), nullable=False),
        sa.Column("expires_at", sa.TIMESTAMP(timezone=True), nullable=False),
        sa.Column("user_id", fief.models.generics.GUID(), nullable=False),
        sa.ForeignKeyConstraint(["user_id"], ["fief_users.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_fief_session_tokens_created_at"),
        "fief_session_tokens",
        ["created_at"],
        unique=False,
    )
    op.create_index(
        op.f("ix_fief_session_tokens_expires_at"),
        "fief_session_tokens",
        ["expires_at"],
        unique=False,
    )
    op.create_index(
        op.f("ix_fief_session_tokens_token"),
        "fief_session_tokens",
        ["token"],
        unique=True,
    )
    op.create_index(
        op.f("ix_fief_session_tokens_updated_at"),
        "fief_session_tokens",
        ["updated_at"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        op.f("ix_fief_session_tokens_updated_at"), table_name="fief_session_tokens"
    )
    op.drop_index(
        op.f("ix_fief_session_tokens_token"), table_name="fief_session_tokens"
    )
    op.drop_index(
        op.f("ix_fief_session_tokens_expires_at"), table_name="fief_session_tokens"
    )
    op.drop_index(
        op.f("ix_fief_session_tokens_created_at"), table_name="fief_session_tokens"
    )
    op.drop_table("fief_session_tokens")
    # ### end Alembic commands ###
