# -*- coding: utf-8 -*-
"""`Concordance between SKD2008 and SKD2002 <https://www.stat.si/dokument/5637/SKD2008-SKD2002-EN.xls>`_.
"""
from ...types import Concordance, Standards
from ..skd2002 import SKD2002
from . import SKD2008

SKD2008_to_SKD2002 = Concordance(
    src=SKD2008,
    dst=SKD2002,
    concordances=[
        ((Standards.SKD2008, "01.110"), (Standards.SKD2002, "01.110")),
        ((Standards.SKD2008, "01.110"), (Standards.SKD2002, "01.120")),
        ((Standards.SKD2008, "01.120"), (Standards.SKD2002, "01.110")),
        ((Standards.SKD2008, "01.130"), (Standards.SKD2002, "01.110")),
        ((Standards.SKD2008, "01.130"), (Standards.SKD2002, "01.120")),
        ((Standards.SKD2008, "01.140"), (Standards.SKD2002, "01.110")),
        ((Standards.SKD2008, "01.150"), (Standards.SKD2002, "01.110")),
        ((Standards.SKD2008, "01.160"), (Standards.SKD2002, "01.110")),
        ((Standards.SKD2008, "01.190"), (Standards.SKD2002, "01.110")),
        ((Standards.SKD2008, "01.190"), (Standards.SKD2002, "01.120")),
        ((Standards.SKD2008, "01.210"), (Standards.SKD2002, "01.131")),
        ((Standards.SKD2008, "01.220"), (Standards.SKD2002, "01.132")),
        ((Standards.SKD2008, "01.230"), (Standards.SKD2002, "01.132")),
        ((Standards.SKD2008, "01.240"), (Standards.SKD2002, "01.132")),
        ((Standards.SKD2008, "01.250"), (Standards.SKD2002, "01.120")),
        ((Standards.SKD2008, "01.250"), (Standards.SKD2002, "01.132")),
        ((Standards.SKD2008, "01.260"), (Standards.SKD2002, "01.110")),
        ((Standards.SKD2008, "01.260"), (Standards.SKD2002, "01.132")),
        ((Standards.SKD2008, "01.270"), (Standards.SKD2002, "01.132")),
        ((Standards.SKD2008, "01.280"), (Standards.SKD2002, "01.110")),
        ((Standards.SKD2008, "01.280"), (Standards.SKD2002, "01.120")),
        ((Standards.SKD2008, "01.280"), (Standards.SKD2002, "01.132")),
        ((Standards.SKD2008, "01.290"), (Standards.SKD2002, "01.110")),
        ((Standards.SKD2008, "01.290"), (Standards.SKD2002, "02.010")),
        ((Standards.SKD2008, "01.300"), (Standards.SKD2002, "01.120")),
        ((Standards.SKD2008, "01.410"), (Standards.SKD2002, "01.210")),
        ((Standards.SKD2008, "01.420"), (Standards.SKD2002, "01.210")),
        ((Standards.SKD2008, "01.430"), (Standards.SKD2002, "01.220")),
        ((Standards.SKD2008, "01.440"), (Standards.SKD2002, "01.250")),
        ((Standards.SKD2008, "01.450"), (Standards.SKD2002, "01.220")),
        ((Standards.SKD2008, "01.460"), (Standards.SKD2002, "01.230")),
        ((Standards.SKD2008, "01.470"), (Standards.SKD2002, "01.240")),
        ((Standards.SKD2008, "01.490"), (Standards.SKD2002, "01.220")),
        ((Standards.SKD2008, "01.490"), (Standards.SKD2002, "01.250")),
        ((Standards.SKD2008, "01.500"), (Standards.SKD2002, "01.300")),
        ((Standards.SKD2008, "01.610"), (Standards.SKD2002, "01.412")),
        ((Standards.SKD2008, "01.620"), (Standards.SKD2002, "01.420")),
        ((Standards.SKD2008, "01.620"), (Standards.SKD2002, "92.720")),
        ((Standards.SKD2008, "01.630"), (Standards.SKD2002, "01.110")),
        ((Standards.SKD2008, "01.630"), (Standards.SKD2002, "01.132")),
        ((Standards.SKD2008, "01.630"), (Standards.SKD2002, "01.412")),
        ((Standards.SKD2008, "01.640"), (Standards.SKD2002, "01.110")),
        ((Standards.SKD2008, "01.640"), (Standards.SKD2002, "01.120")),
        ((Standards.SKD2008, "01.640"), (Standards.SKD2002, "01.132")),
        ((Standards.SKD2008, "01.640"), (Standards.SKD2002, "01.412")),
        ((Standards.SKD2008, "01.700"), (Standards.SKD2002, "01.500")),
        ((Standards.SKD2008, "02.100"), (Standards.SKD2002, "01.120")),
        ((Standards.SKD2008, "02.100"), (Standards.SKD2002, "02.010")),
        ((Standards.SKD2008, "02.200"), (Standards.SKD2002, "02.010")),
        ((Standards.SKD2008, "02.300"), (Standards.SKD2002, "01.120")),
        ((Standards.SKD2008, "02.300"), (Standards.SKD2002, "01.132")),
        ((Standards.SKD2008, "02.300"), (Standards.SKD2002, "02.010")),
        ((Standards.SKD2008, "02.400"), (Standards.SKD2002, "02.020")),
        ((Standards.SKD2008, "02.400"), (Standards.SKD2002, "74.140")),
        ((Standards.SKD2008, "03.110"), (Standards.SKD2002, "05.010")),
        ((Standards.SKD2008, "03.120"), (Standards.SKD2002, "05.010")),
        ((Standards.SKD2008, "03.210"), (Standards.SKD2002, "05.020")),
        ((Standards.SKD2008, "03.220"), (Standards.SKD2002, "01.250")),
        ((Standards.SKD2008, "03.220"), (Standards.SKD2002, "05.020")),
        ((Standards.SKD2008, "05.100"), (Standards.SKD2002, "10.100")),
        ((Standards.SKD2008, "05.200"), (Standards.SKD2002, "10.200")),
        ((Standards.SKD2008, "06.100"), (Standards.SKD2002, "11.100")),
        ((Standards.SKD2008, "06.200"), (Standards.SKD2002, "11.100")),
        ((Standards.SKD2008, "07.100"), (Standards.SKD2002, "13.100")),
        ((Standards.SKD2008, "07.210"), (Standards.SKD2002, "12.000")),
        ((Standards.SKD2008, "07.290"), (Standards.SKD2002, "13.200")),
        ((Standards.SKD2008, "08.110"), (Standards.SKD2002, "14.110")),
        ((Standards.SKD2008, "08.110"), (Standards.SKD2002, "14.120")),
        ((Standards.SKD2008, "08.110"), (Standards.SKD2002, "14.130")),
        ((Standards.SKD2008, "08.120"), (Standards.SKD2002, "14.210")),
        ((Standards.SKD2008, "08.120"), (Standards.SKD2002, "14.220")),
        ((Standards.SKD2008, "08.910"), (Standards.SKD2002, "14.300")),
        ((Standards.SKD2008, "08.920"), (Standards.SKD2002, "10.300")),
        ((Standards.SKD2008, "08.930"), (Standards.SKD2002, "14.400")),
        ((Standards.SKD2008, "08.990"), (Standards.SKD2002, "14.500")),
        ((Standards.SKD2008, "09.100"), (Standards.SKD2002, "11.100")),
        ((Standards.SKD2008, "09.100"), (Standards.SKD2002, "11.200")),
        ((Standards.SKD2008, "09.900"), (Standards.SKD2002, "10.100")),
        ((Standards.SKD2008, "09.900"), (Standards.SKD2002, "10.200")),
        ((Standards.SKD2008, "09.900"), (Standards.SKD2002, "10.300")),
        ((Standards.SKD2008, "09.900"), (Standards.SKD2002, "12.000")),
        ((Standards.SKD2008, "09.900"), (Standards.SKD2002, "13.100")),
        ((Standards.SKD2008, "09.900"), (Standards.SKD2002, "13.200")),
        ((Standards.SKD2008, "09.900"), (Standards.SKD2002, "14.110")),
        ((Standards.SKD2008, "09.900"), (Standards.SKD2002, "14.120")),
        ((Standards.SKD2008, "09.900"), (Standards.SKD2002, "14.130")),
        ((Standards.SKD2008, "09.900"), (Standards.SKD2002, "14.210")),
        ((Standards.SKD2008, "09.900"), (Standards.SKD2002, "14.220")),
        ((Standards.SKD2008, "09.900"), (Standards.SKD2002, "14.300")),
        ((Standards.SKD2008, "09.900"), (Standards.SKD2002, "14.400")),
        ((Standards.SKD2008, "09.900"), (Standards.SKD2002, "14.500")),
        ((Standards.SKD2008, "10.110"), (Standards.SKD2002, "15.110")),
        ((Standards.SKD2008, "10.110"), (Standards.SKD2002, "15.120")),
        ((Standards.SKD2008, "10.120"), (Standards.SKD2002, "15.120")),
        ((Standards.SKD2008, "10.130"), (Standards.SKD2002, "15.130")),
        ((Standards.SKD2008, "10.200"), (Standards.SKD2002, "15.200")),
        ((Standards.SKD2008, "10.310"), (Standards.SKD2002, "15.310")),
        ((Standards.SKD2008, "10.320"), (Standards.SKD2002, "15.320")),
        ((Standards.SKD2008, "10.390"), (Standards.SKD2002, "01.412")),
        ((Standards.SKD2008, "10.390"), (Standards.SKD2002, "15.330")),
        ((Standards.SKD2008, "10.390"), (Standards.SKD2002, "51.310")),
        ((Standards.SKD2008, "10.410"), (Standards.SKD2002, "01.132")),
        ((Standards.SKD2008, "10.410"), (Standards.SKD2002, "15.410")),
        ((Standards.SKD2008, "10.410"), (Standards.SKD2002, "15.420")),
        ((Standards.SKD2008, "10.420"), (Standards.SKD2002, "15.430")),
        ((Standards.SKD2008, "10.510"), (Standards.SKD2002, "15.510")),
        ((Standards.SKD2008, "10.520"), (Standards.SKD2002, "15.520")),
        ((Standards.SKD2008, "10.610"), (Standards.SKD2002, "15.610")),
        ((Standards.SKD2008, "10.620"), (Standards.SKD2002, "15.620")),
        ((Standards.SKD2008, "10.710"), (Standards.SKD2002, "15.810")),
        ((Standards.SKD2008, "10.720"), (Standards.SKD2002, "15.820")),
        ((Standards.SKD2008, "10.730"), (Standards.SKD2002, "15.850")),
        ((Standards.SKD2008, "10.810"), (Standards.SKD2002, "15.830")),
        ((Standards.SKD2008, "10.820"), (Standards.SKD2002, "15.840")),
        ((Standards.SKD2008, "10.830"), (Standards.SKD2002, "15.860")),
        ((Standards.SKD2008, "10.840"), (Standards.SKD2002, "14.400")),
        ((Standards.SKD2008, "10.840"), (Standards.SKD2002, "15.870")),
        ((Standards.SKD2008, "10.850"), (Standards.SKD2002, "15.130")),
        ((Standards.SKD2008, "10.850"), (Standards.SKD2002, "15.200")),
        ((Standards.SKD2008, "10.850"), (Standards.SKD2002, "15.330")),
        ((Standards.SKD2008, "10.850"), (Standards.SKD2002, "15.810")),
        ((Standards.SKD2008, "10.850"), (Standards.SKD2002, "15.850")),
        ((Standards.SKD2008, "10.860"), (Standards.SKD2002, "15.880")),
        ((Standards.SKD2008, "10.890"), (Standards.SKD2002, "15.130")),
        ((Standards.SKD2008, "10.890"), (Standards.SKD2002, "15.620")),
        ((Standards.SKD2008, "10.890"), (Standards.SKD2002, "15.810")),
        ((Standards.SKD2008, "10.890"), (Standards.SKD2002, "15.890")),
        ((Standards.SKD2008, "10.910"), (Standards.SKD2002, "15.710")),
        ((Standards.SKD2008, "10.920"), (Standards.SKD2002, "15.720")),
        ((Standards.SKD2008, "11.010"), (Standards.SKD2002, "15.910")),
        ((Standards.SKD2008, "11.010"), (Standards.SKD2002, "15.920")),
        ((Standards.SKD2008, "11.010"), (Standards.SKD2002, "51.340")),
        ((Standards.SKD2008, "11.020"), (Standards.SKD2002, "01.131")),
        ((Standards.SKD2008, "11.020"), (Standards.SKD2002, "15.930")),
        ((Standards.SKD2008, "11.020"), (Standards.SKD2002, "51.340")),
        ((Standards.SKD2008, "11.030"), (Standards.SKD2002, "15.940")),
        ((Standards.SKD2008, "11.040"), (Standards.SKD2002, "15.950")),
        ((Standards.SKD2008, "11.050"), (Standards.SKD2002, "15.960")),
        ((Standards.SKD2008, "11.060"), (Standards.SKD2002, "15.970")),
        ((Standards.SKD2008, "11.070"), (Standards.SKD2002, "15.980")),
        ((Standards.SKD2008, "12.000"), (Standards.SKD2002, "16.000")),
        ((Standards.SKD2008, "13.100"), (Standards.SKD2002, "17.100")),
        ((Standards.SKD2008, "13.200"), (Standards.SKD2002, "17.200")),
        ((Standards.SKD2008, "13.200"), (Standards.SKD2002, "18.300")),
        ((Standards.SKD2008, "13.300"), (Standards.SKD2002, "17.300")),
        ((Standards.SKD2008, "13.300"), (Standards.SKD2002, "52.740")),
        ((Standards.SKD2008, "13.910"), (Standards.SKD2002, "17.600")),
        ((Standards.SKD2008, "13.910"), (Standards.SKD2002, "18.300")),
        ((Standards.SKD2008, "13.920"), (Standards.SKD2002, "17.400")),
        ((Standards.SKD2008, "13.930"), (Standards.SKD2002, "17.510")),
        ((Standards.SKD2008, "13.940"), (Standards.SKD2002, "17.520")),
        ((Standards.SKD2008, "13.950"), (Standards.SKD2002, "17.530")),
        ((Standards.SKD2008, "13.960"), (Standards.SKD2002, "17.540")),
        ((Standards.SKD2008, "13.990"), (Standards.SKD2002, "17.540")),
        ((Standards.SKD2008, "13.990"), (Standards.SKD2002, "36.630")),
        ((Standards.SKD2008, "14.110"), (Standards.SKD2002, "18.100")),
        ((Standards.SKD2008, "14.120"), (Standards.SKD2002, "18.210")),
        ((Standards.SKD2008, "14.130"), (Standards.SKD2002, "18.220")),
        ((Standards.SKD2008, "14.140"), (Standards.SKD2002, "18.230")),
        ((Standards.SKD2008, "14.190"), (Standards.SKD2002, "17.710")),
        ((Standards.SKD2008, "14.190"), (Standards.SKD2002, "18.240")),
        ((Standards.SKD2008, "14.200"), (Standards.SKD2002, "18.300")),
        ((Standards.SKD2008, "14.310"), (Standards.SKD2002, "17.710")),
        ((Standards.SKD2008, "14.390"), (Standards.SKD2002, "17.720")),
        ((Standards.SKD2008, "15.110"), (Standards.SKD2002, "18.300")),
        ((Standards.SKD2008, "15.110"), (Standards.SKD2002, "19.100")),
        ((Standards.SKD2008, "15.120"), (Standards.SKD2002, "19.200")),
        ((Standards.SKD2008, "15.120"), (Standards.SKD2002, "36.630")),
        ((Standards.SKD2008, "15.200"), (Standards.SKD2002, "19.300")),
        ((Standards.SKD2008, "16.100"), (Standards.SKD2002, "02.010")),
        ((Standards.SKD2008, "16.100"), (Standards.SKD2002, "20.100")),
        ((Standards.SKD2008, "16.210"), (Standards.SKD2002, "20.200")),
        ((Standards.SKD2008, "16.220"), (Standards.SKD2002, "20.300")),
        ((Standards.SKD2008, "16.230"), (Standards.SKD2002, "20.300")),
        ((Standards.SKD2008, "16.240"), (Standards.SKD2002, "20.400")),
        ((Standards.SKD2008, "16.290"), (Standards.SKD2002, "19.300")),
        ((Standards.SKD2008, "16.290"), (Standards.SKD2002, "20.510")),
        ((Standards.SKD2008, "16.290"), (Standards.SKD2002, "20.520")),
        ((Standards.SKD2008, "16.290"), (Standards.SKD2002, "36.630")),
        ((Standards.SKD2008, "17.110"), (Standards.SKD2002, "21.110")),
        ((Standards.SKD2008, "17.120"), (Standards.SKD2002, "21.120")),
        ((Standards.SKD2008, "17.210"), (Standards.SKD2002, "21.210")),
        ((Standards.SKD2008, "17.220"), (Standards.SKD2002, "17.540")),
        ((Standards.SKD2008, "17.220"), (Standards.SKD2002, "21.220")),
        ((Standards.SKD2008, "17.230"), (Standards.SKD2002, "21.230")),
        ((Standards.SKD2008, "17.230"), (Standards.SKD2002, "22.220")),
        ((Standards.SKD2008, "17.240"), (Standards.SKD2002, "21.240")),
        ((Standards.SKD2008, "17.290"), (Standards.SKD2002, "21.250")),
        ((Standards.SKD2008, "17.290"), (Standards.SKD2002, "36.630")),
        ((Standards.SKD2008, "18.110"), (Standards.SKD2002, "22.210")),
        ((Standards.SKD2008, "18.120"), (Standards.SKD2002, "21.220")),
        ((Standards.SKD2008, "18.120"), (Standards.SKD2002, "21.250")),
        ((Standards.SKD2008, "18.120"), (Standards.SKD2002, "22.220")),
        ((Standards.SKD2008, "18.130"), (Standards.SKD2002, "22.240")),
        ((Standards.SKD2008, "18.130"), (Standards.SKD2002, "22.250")),
        ((Standards.SKD2008, "18.140"), (Standards.SKD2002, "22.230")),
        ((Standards.SKD2008, "18.200"), (Standards.SKD2002, "22.310")),
        ((Standards.SKD2008, "18.200"), (Standards.SKD2002, "22.320")),
        ((Standards.SKD2008, "18.200"), (Standards.SKD2002, "22.330")),
        ((Standards.SKD2008, "19.100"), (Standards.SKD2002, "23.100")),
        ((Standards.SKD2008, "19.100"), (Standards.SKD2002, "24.140")),
        ((Standards.SKD2008, "19.200"), (Standards.SKD2002, "10.100")),
        ((Standards.SKD2008, "19.200"), (Standards.SKD2002, "10.200")),
        ((Standards.SKD2008, "19.200"), (Standards.SKD2002, "10.300")),
        ((Standards.SKD2008, "19.200"), (Standards.SKD2002, "23.200")),
        ((Standards.SKD2008, "20.110"), (Standards.SKD2002, "24.110")),
        ((Standards.SKD2008, "20.120"), (Standards.SKD2002, "24.120")),
        ((Standards.SKD2008, "20.130"), (Standards.SKD2002, "23.300")),
        ((Standards.SKD2008, "20.130"), (Standards.SKD2002, "24.130")),
        ((Standards.SKD2008, "20.140"), (Standards.SKD2002, "15.920")),
        ((Standards.SKD2008, "20.140"), (Standards.SKD2002, "24.140")),
        ((Standards.SKD2008, "20.150"), (Standards.SKD2002, "24.150")),
        ((Standards.SKD2008, "20.160"), (Standards.SKD2002, "24.160")),
        ((Standards.SKD2008, "20.170"), (Standards.SKD2002, "24.170")),
        ((Standards.SKD2008, "20.200"), (Standards.SKD2002, "24.200")),
        ((Standards.SKD2008, "20.300"), (Standards.SKD2002, "24.300")),
        ((Standards.SKD2008, "20.410"), (Standards.SKD2002, "24.510")),
        ((Standards.SKD2008, "20.420"), (Standards.SKD2002, "24.510")),
        ((Standards.SKD2008, "20.420"), (Standards.SKD2002, "24.520")),
        ((Standards.SKD2008, "20.510"), (Standards.SKD2002, "24.610")),
        ((Standards.SKD2008, "20.510"), (Standards.SKD2002, "36.630")),
        ((Standards.SKD2008, "20.520"), (Standards.SKD2002, "24.620")),
        ((Standards.SKD2008, "20.530"), (Standards.SKD2002, "24.630")),
        ((Standards.SKD2008, "20.590"), (Standards.SKD2002, "24.620")),
        ((Standards.SKD2008, "20.590"), (Standards.SKD2002, "24.640")),
        ((Standards.SKD2008, "20.590"), (Standards.SKD2002, "24.660")),
        ((Standards.SKD2008, "20.600"), (Standards.SKD2002, "24.700")),
        ((Standards.SKD2008, "21.100"), (Standards.SKD2002, "24.410")),
        ((Standards.SKD2008, "21.200"), (Standards.SKD2002, "23.300")),
        ((Standards.SKD2008, "21.200"), (Standards.SKD2002, "24.420")),
        ((Standards.SKD2008, "22.110"), (Standards.SKD2002, "25.110")),
        ((Standards.SKD2008, "22.110"), (Standards.SKD2002, "25.120")),
        ((Standards.SKD2008, "22.190"), (Standards.SKD2002, "19.300")),
        ((Standards.SKD2008, "22.190"), (Standards.SKD2002, "25.130")),
        ((Standards.SKD2008, "22.190"), (Standards.SKD2002, "36.620")),
        ((Standards.SKD2008, "22.190"), (Standards.SKD2002, "36.630")),
        ((Standards.SKD2008, "22.210"), (Standards.SKD2002, "25.210")),
        ((Standards.SKD2008, "22.220"), (Standards.SKD2002, "25.220")),
        ((Standards.SKD2008, "22.230"), (Standards.SKD2002, "25.230")),
        ((Standards.SKD2008, "22.230"), (Standards.SKD2002, "36.630")),
        ((Standards.SKD2008, "22.290"), (Standards.SKD2002, "19.300")),
        ((Standards.SKD2008, "22.290"), (Standards.SKD2002, "25.240")),
        ((Standards.SKD2008, "22.290"), (Standards.SKD2002, "36.630")),
        ((Standards.SKD2008, "23.110"), (Standards.SKD2002, "26.110")),
        ((Standards.SKD2008, "23.120"), (Standards.SKD2002, "26.120")),
        ((Standards.SKD2008, "23.130"), (Standards.SKD2002, "26.130")),
        ((Standards.SKD2008, "23.140"), (Standards.SKD2002, "26.140")),
        ((Standards.SKD2008, "23.190"), (Standards.SKD2002, "26.150")),
        ((Standards.SKD2008, "23.200"), (Standards.SKD2002, "26.260")),
        ((Standards.SKD2008, "23.310"), (Standards.SKD2002, "26.300")),
        ((Standards.SKD2008, "23.320"), (Standards.SKD2002, "26.400")),
        ((Standards.SKD2008, "23.410"), (Standards.SKD2002, "26.210")),
        ((Standards.SKD2008, "23.420"), (Standards.SKD2002, "26.220")),
        ((Standards.SKD2008, "23.430"), (Standards.SKD2002, "26.230")),
        ((Standards.SKD2008, "23.440"), (Standards.SKD2002, "26.240")),
        ((Standards.SKD2008, "23.440"), (Standards.SKD2002, "31.620")),
        ((Standards.SKD2008, "23.490"), (Standards.SKD2002, "26.250")),
        ((Standards.SKD2008, "23.510"), (Standards.SKD2002, "26.510")),
        ((Standards.SKD2008, "23.520"), (Standards.SKD2002, "26.520")),
        ((Standards.SKD2008, "23.520"), (Standards.SKD2002, "26.530")),
        ((Standards.SKD2008, "23.610"), (Standards.SKD2002, "26.610")),
        ((Standards.SKD2008, "23.620"), (Standards.SKD2002, "26.620")),
        ((Standards.SKD2008, "23.630"), (Standards.SKD2002, "26.630")),
        ((Standards.SKD2008, "23.640"), (Standards.SKD2002, "26.640")),
        ((Standards.SKD2008, "23.650"), (Standards.SKD2002, "26.650")),
        ((Standards.SKD2008, "23.690"), (Standards.SKD2002, "26.660")),
        ((Standards.SKD2008, "23.700"), (Standards.SKD2002, "26.700")),
        ((Standards.SKD2008, "23.910"), (Standards.SKD2002, "26.810")),
        ((Standards.SKD2008, "23.990"), (Standards.SKD2002, "26.820")),
        ((Standards.SKD2008, "24.100"), (Standards.SKD2002, "27.100")),
        ((Standards.SKD2008, "24.200"), (Standards.SKD2002, "27.220")),
        ((Standards.SKD2008, "24.310"), (Standards.SKD2002, "27.310")),
        ((Standards.SKD2008, "24.320"), (Standards.SKD2002, "27.320")),
        ((Standards.SKD2008, "24.330"), (Standards.SKD2002, "27.330")),
        ((Standards.SKD2008, "24.330"), (Standards.SKD2002, "28.110")),
        ((Standards.SKD2008, "24.340"), (Standards.SKD2002, "27.340")),
        ((Standards.SKD2008, "24.410"), (Standards.SKD2002, "27.410")),
        ((Standards.SKD2008, "24.420"), (Standards.SKD2002, "27.420")),
        ((Standards.SKD2008, "24.430"), (Standards.SKD2002, "27.430")),
        ((Standards.SKD2008, "24.440"), (Standards.SKD2002, "27.440")),
        ((Standards.SKD2008, "24.450"), (Standards.SKD2002, "27.450")),
        ((Standards.SKD2008, "24.460"), (Standards.SKD2002, "23.300")),
        ((Standards.SKD2008, "24.510"), (Standards.SKD2002, "27.210")),
        ((Standards.SKD2008, "24.510"), (Standards.SKD2002, "27.510")),
        ((Standards.SKD2008, "24.520"), (Standards.SKD2002, "27.520")),
        ((Standards.SKD2008, "24.530"), (Standards.SKD2002, "27.530")),
        ((Standards.SKD2008, "24.540"), (Standards.SKD2002, "27.540")),
        ((Standards.SKD2008, "25.110"), (Standards.SKD2002, "28.110")),
        ((Standards.SKD2008, "25.120"), (Standards.SKD2002, "28.120")),
        ((Standards.SKD2008, "25.210"), (Standards.SKD2002, "28.220")),
        ((Standards.SKD2008, "25.290"), (Standards.SKD2002, "28.210")),
        ((Standards.SKD2008, "25.300"), (Standards.SKD2002, "28.300")),
        ((Standards.SKD2008, "25.400"), (Standards.SKD2002, "29.600")),
        ((Standards.SKD2008, "25.500"), (Standards.SKD2002, "28.400")),
        ((Standards.SKD2008, "25.611"), (Standards.SKD2002, "28.511")),
        ((Standards.SKD2008, "25.619"), (Standards.SKD2002, "28.512")),
        ((Standards.SKD2008, "25.620"), (Standards.SKD2002, "28.520")),
        ((Standards.SKD2008, "25.710"), (Standards.SKD2002, "28.610")),
        ((Standards.SKD2008, "25.710"), (Standards.SKD2002, "28.750")),
        ((Standards.SKD2008, "25.720"), (Standards.SKD2002, "28.630")),
        ((Standards.SKD2008, "25.731"), (Standards.SKD2002, "28.621")),
        ((Standards.SKD2008, "25.732"), (Standards.SKD2002, "28.622")),
        ((Standards.SKD2008, "25.732"), (Standards.SKD2002, "29.560")),
        ((Standards.SKD2008, "25.910"), (Standards.SKD2002, "28.710")),
        ((Standards.SKD2008, "25.920"), (Standards.SKD2002, "28.720")),
        ((Standards.SKD2008, "25.930"), (Standards.SKD2002, "28.730")),
        ((Standards.SKD2008, "25.930"), (Standards.SKD2002, "28.740")),
        ((Standards.SKD2008, "25.940"), (Standards.SKD2002, "28.740")),
        ((Standards.SKD2008, "25.990"), (Standards.SKD2002, "28.750")),
        ((Standards.SKD2008, "25.990"), (Standards.SKD2002, "31.620")),
        ((Standards.SKD2008, "25.990"), (Standards.SKD2002, "36.630")),
        ((Standards.SKD2008, "26.110"), (Standards.SKD2002, "24.660")),
        ((Standards.SKD2008, "26.110"), (Standards.SKD2002, "31.100")),
        ((Standards.SKD2008, "26.110"), (Standards.SKD2002, "31.200")),
        ((Standards.SKD2008, "26.110"), (Standards.SKD2002, "31.300")),
        ((Standards.SKD2008, "26.110"), (Standards.SKD2002, "32.100")),
        ((Standards.SKD2008, "26.110"), (Standards.SKD2002, "32.300")),
        ((Standards.SKD2008, "26.120"), (Standards.SKD2002, "32.100")),
        ((Standards.SKD2008, "26.200"), (Standards.SKD2002, "30.020")),
        ((Standards.SKD2008, "26.200"), (Standards.SKD2002, "32.300")),
        ((Standards.SKD2008, "26.300"), (Standards.SKD2002, "31.620")),
        ((Standards.SKD2008, "26.300"), (Standards.SKD2002, "32.200")),
        ((Standards.SKD2008, "26.300"), (Standards.SKD2002, "32.300")),
        ((Standards.SKD2008, "26.400"), (Standards.SKD2002, "32.300")),
        ((Standards.SKD2008, "26.400"), (Standards.SKD2002, "36.500")),
        ((Standards.SKD2008, "26.510"), (Standards.SKD2002, "31.620")),
        ((Standards.SKD2008, "26.510"), (Standards.SKD2002, "33.200")),
        ((Standards.SKD2008, "26.520"), (Standards.SKD2002, "33.500")),
        ((Standards.SKD2008, "26.600"), (Standards.SKD2002, "33.100")),
        ((Standards.SKD2008, "26.700"), (Standards.SKD2002, "32.300")),
        ((Standards.SKD2008, "26.700"), (Standards.SKD2002, "33.200")),
        ((Standards.SKD2008, "26.700"), (Standards.SKD2002, "33.400")),
        ((Standards.SKD2008, "26.800"), (Standards.SKD2002, "24.650")),
        ((Standards.SKD2008, "27.110"), (Standards.SKD2002, "31.100")),
        ((Standards.SKD2008, "27.110"), (Standards.SKD2002, "31.620")),
        ((Standards.SKD2008, "27.120"), (Standards.SKD2002, "31.200")),
        ((Standards.SKD2008, "27.200"), (Standards.SKD2002, "31.400")),
        ((Standards.SKD2008, "27.310"), (Standards.SKD2002, "31.300")),
        ((Standards.SKD2008, "27.310"), (Standards.SKD2002, "33.400")),
        ((Standards.SKD2008, "27.320"), (Standards.SKD2002, "31.300")),
        ((Standards.SKD2008, "27.330"), (Standards.SKD2002, "25.230")),
        ((Standards.SKD2008, "27.330"), (Standards.SKD2002, "25.240")),
        ((Standards.SKD2008, "27.330"), (Standards.SKD2002, "31.200")),
        ((Standards.SKD2008, "27.400"), (Standards.SKD2002, "31.500")),
        ((Standards.SKD2008, "27.400"), (Standards.SKD2002, "31.610")),
        ((Standards.SKD2008, "27.400"), (Standards.SKD2002, "31.620")),
        ((Standards.SKD2008, "27.510"), (Standards.SKD2002, "29.710")),
        ((Standards.SKD2008, "27.520"), (Standards.SKD2002, "29.720")),
        ((Standards.SKD2008, "27.900"), (Standards.SKD2002, "29.430")),
        ((Standards.SKD2008, "27.900"), (Standards.SKD2002, "31.200")),
        ((Standards.SKD2008, "27.900"), (Standards.SKD2002, "31.300")),
        ((Standards.SKD2008, "27.900"), (Standards.SKD2002, "31.620")),
        ((Standards.SKD2008, "27.900"), (Standards.SKD2002, "32.100")),
        ((Standards.SKD2008, "28.110"), (Standards.SKD2002, "29.110")),
        ((Standards.SKD2008, "28.110"), (Standards.SKD2002, "29.120")),
        ((Standards.SKD2008, "28.110"), (Standards.SKD2002, "34.300")),
        ((Standards.SKD2008, "28.120"), (Standards.SKD2002, "29.120")),
        ((Standards.SKD2008, "28.120"), (Standards.SKD2002, "29.130")),
        ((Standards.SKD2008, "28.130"), (Standards.SKD2002, "29.120")),
        ((Standards.SKD2008, "28.140"), (Standards.SKD2002, "29.130")),
        ((Standards.SKD2008, "28.150"), (Standards.SKD2002, "29.140")),
        ((Standards.SKD2008, "28.210"), (Standards.SKD2002, "29.210")),
        ((Standards.SKD2008, "28.210"), (Standards.SKD2002, "29.710")),
        ((Standards.SKD2008, "28.210"), (Standards.SKD2002, "29.720")),
        ((Standards.SKD2008, "28.220"), (Standards.SKD2002, "29.220")),
        ((Standards.SKD2008, "28.220"), (Standards.SKD2002, "35.500")),
        ((Standards.SKD2008, "28.230"), (Standards.SKD2002, "30.010")),
        ((Standards.SKD2008, "28.230"), (Standards.SKD2002, "32.300")),
        ((Standards.SKD2008, "28.230"), (Standards.SKD2002, "36.120")),
        ((Standards.SKD2008, "28.240"), (Standards.SKD2002, "29.410")),
        ((Standards.SKD2008, "28.250"), (Standards.SKD2002, "29.230")),
        ((Standards.SKD2008, "28.250"), (Standards.SKD2002, "29.710")),
        ((Standards.SKD2008, "28.290"), (Standards.SKD2002, "29.240")),
        ((Standards.SKD2008, "28.290"), (Standards.SKD2002, "29.430")),
        ((Standards.SKD2008, "28.290"), (Standards.SKD2002, "33.200")),
        ((Standards.SKD2008, "28.300"), (Standards.SKD2002, "29.310")),
        ((Standards.SKD2008, "28.300"), (Standards.SKD2002, "29.320")),
        ((Standards.SKD2008, "28.300"), (Standards.SKD2002, "29.530")),
        ((Standards.SKD2008, "28.410"), (Standards.SKD2002, "28.622")),
        ((Standards.SKD2008, "28.410"), (Standards.SKD2002, "29.420")),
        ((Standards.SKD2008, "28.490"), (Standards.SKD2002, "28.622")),
        ((Standards.SKD2008, "28.490"), (Standards.SKD2002, "29.430")),
        ((Standards.SKD2008, "28.490"), (Standards.SKD2002, "31.620")),
        ((Standards.SKD2008, "28.910"), (Standards.SKD2002, "29.510")),
        ((Standards.SKD2008, "28.920"), (Standards.SKD2002, "28.622")),
        ((Standards.SKD2008, "28.920"), (Standards.SKD2002, "29.520")),
        ((Standards.SKD2008, "28.920"), (Standards.SKD2002, "34.100")),
        ((Standards.SKD2008, "28.930"), (Standards.SKD2002, "29.530")),
        ((Standards.SKD2008, "28.940"), (Standards.SKD2002, "29.540")),
        ((Standards.SKD2008, "28.940"), (Standards.SKD2002, "29.560")),
        ((Standards.SKD2008, "28.950"), (Standards.SKD2002, "29.550")),
        ((Standards.SKD2008, "28.960"), (Standards.SKD2002, "29.560")),
        ((Standards.SKD2008, "28.990"), (Standards.SKD2002, "29.560")),
        ((Standards.SKD2008, "28.990"), (Standards.SKD2002, "31.620")),
        ((Standards.SKD2008, "28.990"), (Standards.SKD2002, "33.200")),
        ((Standards.SKD2008, "28.990"), (Standards.SKD2002, "33.400")),
        ((Standards.SKD2008, "28.990"), (Standards.SKD2002, "35.300")),
        ((Standards.SKD2008, "28.990"), (Standards.SKD2002, "36.500")),
        ((Standards.SKD2008, "28.990"), (Standards.SKD2002, "36.630")),
        ((Standards.SKD2008, "29.100"), (Standards.SKD2002, "34.100")),
        ((Standards.SKD2008, "29.200"), (Standards.SKD2002, "34.200")),
        ((Standards.SKD2008, "29.310"), (Standards.SKD2002, "31.610")),
        ((Standards.SKD2008, "29.310"), (Standards.SKD2002, "31.620")),
        ((Standards.SKD2008, "29.320"), (Standards.SKD2002, "34.300")),
        ((Standards.SKD2008, "29.320"), (Standards.SKD2002, "36.110")),
        ((Standards.SKD2008, "30.110"), (Standards.SKD2002, "35.110")),
        ((Standards.SKD2008, "30.110"), (Standards.SKD2002, "36.110")),
        ((Standards.SKD2008, "30.120"), (Standards.SKD2002, "35.120")),
        ((Standards.SKD2008, "30.200"), (Standards.SKD2002, "31.620")),
        ((Standards.SKD2008, "30.200"), (Standards.SKD2002, "35.200")),
        ((Standards.SKD2008, "30.200"), (Standards.SKD2002, "36.110")),
        ((Standards.SKD2008, "30.300"), (Standards.SKD2002, "29.600")),
        ((Standards.SKD2008, "30.300"), (Standards.SKD2002, "35.300")),
        ((Standards.SKD2008, "30.300"), (Standards.SKD2002, "36.110")),
        ((Standards.SKD2008, "30.400"), (Standards.SKD2002, "29.600")),
        ((Standards.SKD2008, "30.910"), (Standards.SKD2002, "34.100")),
        ((Standards.SKD2008, "30.910"), (Standards.SKD2002, "35.410")),
        ((Standards.SKD2008, "30.920"), (Standards.SKD2002, "35.420")),
        ((Standards.SKD2008, "30.920"), (Standards.SKD2002, "35.430")),
        ((Standards.SKD2008, "30.920"), (Standards.SKD2002, "36.630")),
        ((Standards.SKD2008, "30.990"), (Standards.SKD2002, "35.500")),
        ((Standards.SKD2008, "31.010"), (Standards.SKD2002, "35.500")),
        ((Standards.SKD2008, "31.010"), (Standards.SKD2002, "36.110")),
        ((Standards.SKD2008, "31.010"), (Standards.SKD2002, "36.120")),
        ((Standards.SKD2008, "31.020"), (Standards.SKD2002, "36.110")),
        ((Standards.SKD2008, "31.020"), (Standards.SKD2002, "36.130")),
        ((Standards.SKD2008, "31.030"), (Standards.SKD2002, "36.150")),
        ((Standards.SKD2008, "31.090"), (Standards.SKD2002, "36.110")),
        ((Standards.SKD2008, "31.090"), (Standards.SKD2002, "36.140")),
        ((Standards.SKD2008, "32.110"), (Standards.SKD2002, "36.210")),
        ((Standards.SKD2008, "32.120"), (Standards.SKD2002, "33.500")),
        ((Standards.SKD2008, "32.120"), (Standards.SKD2002, "36.220")),
        ((Standards.SKD2008, "32.130"), (Standards.SKD2002, "33.500")),
        ((Standards.SKD2008, "32.130"), (Standards.SKD2002, "36.610")),
        ((Standards.SKD2008, "32.200"), (Standards.SKD2002, "36.300")),
        ((Standards.SKD2008, "32.300"), (Standards.SKD2002, "36.400")),
        ((Standards.SKD2008, "32.400"), (Standards.SKD2002, "36.500")),
        ((Standards.SKD2008, "32.500"), (Standards.SKD2002, "17.400")),
        ((Standards.SKD2008, "32.500"), (Standards.SKD2002, "24.420")),
        ((Standards.SKD2008, "32.500"), (Standards.SKD2002, "25.130")),
        ((Standards.SKD2008, "32.500"), (Standards.SKD2002, "29.240")),
        ((Standards.SKD2008, "32.500"), (Standards.SKD2002, "33.100")),
        ((Standards.SKD2008, "32.500"), (Standards.SKD2002, "33.200")),
        ((Standards.SKD2008, "32.500"), (Standards.SKD2002, "33.400")),
        ((Standards.SKD2008, "32.910"), (Standards.SKD2002, "36.620")),
        ((Standards.SKD2008, "32.990"), (Standards.SKD2002, "18.100")),
        ((Standards.SKD2008, "32.990"), (Standards.SKD2002, "18.240")),
        ((Standards.SKD2008, "32.990"), (Standards.SKD2002, "19.200")),
        ((Standards.SKD2008, "32.990"), (Standards.SKD2002, "20.510")),
        ((Standards.SKD2008, "32.990"), (Standards.SKD2002, "20.520")),
        ((Standards.SKD2008, "32.990"), (Standards.SKD2002, "22.110")),
        ((Standards.SKD2008, "32.990"), (Standards.SKD2002, "25.130")),
        ((Standards.SKD2008, "32.990"), (Standards.SKD2002, "25.240")),
        ((Standards.SKD2008, "32.990"), (Standards.SKD2002, "28.750")),
        ((Standards.SKD2008, "32.990"), (Standards.SKD2002, "33.100")),
        ((Standards.SKD2008, "32.990"), (Standards.SKD2002, "36.400")),
        ((Standards.SKD2008, "32.990"), (Standards.SKD2002, "36.630")),
        ((Standards.SKD2008, "33.110"), (Standards.SKD2002, "28.110")),
        ((Standards.SKD2008, "33.110"), (Standards.SKD2002, "28.210")),
        ((Standards.SKD2008, "33.110"), (Standards.SKD2002, "28.220")),
        ((Standards.SKD2008, "33.110"), (Standards.SKD2002, "28.300")),
        ((Standards.SKD2008, "33.110"), (Standards.SKD2002, "28.610")),
        ((Standards.SKD2008, "33.110"), (Standards.SKD2002, "28.621")),
        ((Standards.SKD2008, "33.110"), (Standards.SKD2002, "28.630")),
        ((Standards.SKD2008, "33.110"), (Standards.SKD2002, "28.710")),
        ((Standards.SKD2008, "33.110"), (Standards.SKD2002, "28.750")),
        ((Standards.SKD2008, "33.110"), (Standards.SKD2002, "29.600")),
        ((Standards.SKD2008, "33.110"), (Standards.SKD2002, "34.200")),
        ((Standards.SKD2008, "33.110"), (Standards.SKD2002, "35.500")),
        ((Standards.SKD2008, "33.120"), (Standards.SKD2002, "28.520")),
        ((Standards.SKD2008, "33.120"), (Standards.SKD2002, "29.110")),
        ((Standards.SKD2008, "33.120"), (Standards.SKD2002, "29.120")),
        ((Standards.SKD2008, "33.120"), (Standards.SKD2002, "29.130")),
        ((Standards.SKD2008, "33.120"), (Standards.SKD2002, "29.140")),
        ((Standards.SKD2008, "33.120"), (Standards.SKD2002, "29.210")),
        ((Standards.SKD2008, "33.120"), (Standards.SKD2002, "29.220")),
        ((Standards.SKD2008, "33.120"), (Standards.SKD2002, "29.230")),
        ((Standards.SKD2008, "33.120"), (Standards.SKD2002, "29.240")),
        ((Standards.SKD2008, "33.120"), (Standards.SKD2002, "29.310")),
        ((Standards.SKD2008, "33.120"), (Standards.SKD2002, "29.320")),
        ((Standards.SKD2008, "33.120"), (Standards.SKD2002, "29.410")),
        ((Standards.SKD2008, "33.120"), (Standards.SKD2002, "29.420")),
        ((Standards.SKD2008, "33.120"), (Standards.SKD2002, "29.430")),
        ((Standards.SKD2008, "33.120"), (Standards.SKD2002, "29.510")),
        ((Standards.SKD2008, "33.120"), (Standards.SKD2002, "29.520")),
        ((Standards.SKD2008, "33.120"), (Standards.SKD2002, "29.530")),
        ((Standards.SKD2008, "33.120"), (Standards.SKD2002, "29.540")),
        ((Standards.SKD2008, "33.120"), (Standards.SKD2002, "29.550")),
        ((Standards.SKD2008, "33.120"), (Standards.SKD2002, "29.560")),
        ((Standards.SKD2008, "33.120"), (Standards.SKD2002, "72.500")),
        ((Standards.SKD2008, "33.130"), (Standards.SKD2002, "29.240")),
        ((Standards.SKD2008, "33.130"), (Standards.SKD2002, "31.100")),
        ((Standards.SKD2008, "33.130"), (Standards.SKD2002, "31.620")),
        ((Standards.SKD2008, "33.130"), (Standards.SKD2002, "32.100")),
        ((Standards.SKD2008, "33.130"), (Standards.SKD2002, "32.300")),
        ((Standards.SKD2008, "33.130"), (Standards.SKD2002, "33.100")),
        ((Standards.SKD2008, "33.130"), (Standards.SKD2002, "33.200")),
        ((Standards.SKD2008, "33.130"), (Standards.SKD2002, "33.400")),
        ((Standards.SKD2008, "33.130"), (Standards.SKD2002, "33.500")),
        ((Standards.SKD2008, "33.140"), (Standards.SKD2002, "29.710")),
        ((Standards.SKD2008, "33.140"), (Standards.SKD2002, "31.100")),
        ((Standards.SKD2008, "33.140"), (Standards.SKD2002, "31.200")),
        ((Standards.SKD2008, "33.140"), (Standards.SKD2002, "31.620")),
        ((Standards.SKD2008, "33.140"), (Standards.SKD2002, "33.100")),
        ((Standards.SKD2008, "33.140"), (Standards.SKD2002, "33.200")),
        ((Standards.SKD2008, "33.150"), (Standards.SKD2002, "35.110")),
        ((Standards.SKD2008, "33.150"), (Standards.SKD2002, "35.120")),
        ((Standards.SKD2008, "33.160"), (Standards.SKD2002, "35.300")),
        ((Standards.SKD2008, "33.170"), (Standards.SKD2002, "35.200")),
        ((Standards.SKD2008, "33.170"), (Standards.SKD2002, "35.430")),
        ((Standards.SKD2008, "33.170"), (Standards.SKD2002, "35.500")),
        ((Standards.SKD2008, "33.190"), (Standards.SKD2002, "17.400")),
        ((Standards.SKD2008, "33.190"), (Standards.SKD2002, "17.520")),
        ((Standards.SKD2008, "33.190"), (Standards.SKD2002, "20.400")),
        ((Standards.SKD2008, "33.190"), (Standards.SKD2002, "20.510")),
        ((Standards.SKD2008, "33.190"), (Standards.SKD2002, "25.130")),
        ((Standards.SKD2008, "33.190"), (Standards.SKD2002, "25.210")),
        ((Standards.SKD2008, "33.190"), (Standards.SKD2002, "25.240")),
        ((Standards.SKD2008, "33.190"), (Standards.SKD2002, "26.150")),
        ((Standards.SKD2008, "33.190"), (Standards.SKD2002, "26.400")),
        ((Standards.SKD2008, "33.190"), (Standards.SKD2002, "26.810")),
        ((Standards.SKD2008, "33.190"), (Standards.SKD2002, "36.300")),
        ((Standards.SKD2008, "33.190"), (Standards.SKD2002, "36.500")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "25.210")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "26.150")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "26.400")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "26.810")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "28.110")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "28.210")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "28.220")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "28.300")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "28.630")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "28.710")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "28.750")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "29.110")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "29.120")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "29.130")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "29.140")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "29.210")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "29.220")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "29.230")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "29.240")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "29.320")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "29.420")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "29.430")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "29.510")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "29.520")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "29.530")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "29.540")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "29.550")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "29.560")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "29.600")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "29.710")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "30.010")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "31.100")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "31.200")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "31.610")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "31.620")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "32.100")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "32.200")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "33.100")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "33.200")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "33.300")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "33.500")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "34.100")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "35.300")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "36.300")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "36.400")),
        ((Standards.SKD2008, "33.200"), (Standards.SKD2002, "36.500")),
        ((Standards.SKD2008, "35.111"), (Standards.SKD2002, "40.111")),
        ((Standards.SKD2008, "35.112"), (Standards.SKD2002, "40.112")),
        ((Standards.SKD2008, "35.119"), (Standards.SKD2002, "40.113")),
        ((Standards.SKD2008, "35.120"), (Standards.SKD2002, "40.120")),
        ((Standards.SKD2008, "35.130"), (Standards.SKD2002, "40.131")),
        ((Standards.SKD2008, "35.140"), (Standards.SKD2002, "40.132")),
        ((Standards.SKD2008, "35.210"), (Standards.SKD2002, "40.210")),
        ((Standards.SKD2008, "35.220"), (Standards.SKD2002, "40.221")),
        ((Standards.SKD2008, "35.230"), (Standards.SKD2002, "40.222")),
        ((Standards.SKD2008, "35.300"), (Standards.SKD2002, "40.300")),
        ((Standards.SKD2008, "36.000"), (Standards.SKD2002, "41.000")),
        ((Standards.SKD2008, "37.000"), (Standards.SKD2002, "90.010")),
        ((Standards.SKD2008, "38.110"), (Standards.SKD2002, "90.021")),
        ((Standards.SKD2008, "38.110"), (Standards.SKD2002, "90.032")),
        ((Standards.SKD2008, "38.120"), (Standards.SKD2002, "23.300")),
        ((Standards.SKD2008, "38.120"), (Standards.SKD2002, "40.112")),
        ((Standards.SKD2008, "38.120"), (Standards.SKD2002, "90.023")),
        ((Standards.SKD2008, "38.210"), (Standards.SKD2002, "14.500")),
        ((Standards.SKD2008, "38.210"), (Standards.SKD2002, "24.150")),
        ((Standards.SKD2008, "38.210"), (Standards.SKD2002, "90.022")),
        ((Standards.SKD2008, "38.220"), (Standards.SKD2002, "23.300")),
        ((Standards.SKD2008, "38.220"), (Standards.SKD2002, "90.023")),
        ((Standards.SKD2008, "38.310"), (Standards.SKD2002, "37.100")),
        ((Standards.SKD2008, "38.320"), (Standards.SKD2002, "37.100")),
        ((Standards.SKD2008, "38.320"), (Standards.SKD2002, "37.200")),
        ((Standards.SKD2008, "39.000"), (Standards.SKD2002, "90.031")),
        ((Standards.SKD2008, "41.100"), (Standards.SKD2002, "70.110")),
        ((Standards.SKD2008, "41.200"), (Standards.SKD2002, "20.300")),
        ((Standards.SKD2008, "41.200"), (Standards.SKD2002, "25.230")),
        ((Standards.SKD2008, "41.200"), (Standards.SKD2002, "28.110")),
        ((Standards.SKD2008, "41.200"), (Standards.SKD2002, "45.210")),
        ((Standards.SKD2008, "41.200"), (Standards.SKD2002, "45.230")),
        ((Standards.SKD2008, "42.110"), (Standards.SKD2002, "45.230")),
        ((Standards.SKD2008, "42.110"), (Standards.SKD2002, "70.110")),
        ((Standards.SKD2008, "42.120"), (Standards.SKD2002, "45.210")),
        ((Standards.SKD2008, "42.120"), (Standards.SKD2002, "45.230")),
        ((Standards.SKD2008, "42.120"), (Standards.SKD2002, "70.110")),
        ((Standards.SKD2008, "42.130"), (Standards.SKD2002, "45.210")),
        ((Standards.SKD2008, "42.130"), (Standards.SKD2002, "70.110")),
        ((Standards.SKD2008, "42.210"), (Standards.SKD2002, "45.210")),
        ((Standards.SKD2008, "42.210"), (Standards.SKD2002, "45.240")),
        ((Standards.SKD2008, "42.210"), (Standards.SKD2002, "45.250")),
        ((Standards.SKD2008, "42.210"), (Standards.SKD2002, "70.110")),
        ((Standards.SKD2008, "42.220"), (Standards.SKD2002, "45.210")),
        ((Standards.SKD2008, "42.220"), (Standards.SKD2002, "70.110")),
        ((Standards.SKD2008, "42.910"), (Standards.SKD2002, "45.240")),
        ((Standards.SKD2008, "42.910"), (Standards.SKD2002, "70.110")),
        ((Standards.SKD2008, "42.990"), (Standards.SKD2002, "45.210")),
        ((Standards.SKD2008, "42.990"), (Standards.SKD2002, "45.230")),
        ((Standards.SKD2008, "42.990"), (Standards.SKD2002, "70.110")),
        ((Standards.SKD2008, "43.110"), (Standards.SKD2002, "45.110")),
        ((Standards.SKD2008, "43.120"), (Standards.SKD2002, "45.110")),
        ((Standards.SKD2008, "43.130"), (Standards.SKD2002, "45.120")),
        ((Standards.SKD2008, "43.210"), (Standards.SKD2002, "45.310")),
        ((Standards.SKD2008, "43.210"), (Standards.SKD2002, "45.340")),
        ((Standards.SKD2008, "43.220"), (Standards.SKD2002, "45.310")),
        ((Standards.SKD2008, "43.220"), (Standards.SKD2002, "45.330")),
        ((Standards.SKD2008, "43.290"), (Standards.SKD2002, "29.220")),
        ((Standards.SKD2008, "43.290"), (Standards.SKD2002, "45.310")),
        ((Standards.SKD2008, "43.290"), (Standards.SKD2002, "45.320")),
        ((Standards.SKD2008, "43.290"), (Standards.SKD2002, "45.340")),
        ((Standards.SKD2008, "43.310"), (Standards.SKD2002, "45.410")),
        ((Standards.SKD2008, "43.320"), (Standards.SKD2002, "20.300")),
        ((Standards.SKD2008, "43.320"), (Standards.SKD2002, "25.230")),
        ((Standards.SKD2008, "43.320"), (Standards.SKD2002, "28.120")),
        ((Standards.SKD2008, "43.320"), (Standards.SKD2002, "45.420")),
        ((Standards.SKD2008, "43.330"), (Standards.SKD2002, "45.430")),
        ((Standards.SKD2008, "43.341"), (Standards.SKD2002, "45.441")),
        ((Standards.SKD2008, "43.342"), (Standards.SKD2002, "45.442")),
        ((Standards.SKD2008, "43.390"), (Standards.SKD2002, "45.450")),
        ((Standards.SKD2008, "43.910"), (Standards.SKD2002, "20.300")),
        ((Standards.SKD2008, "43.910"), (Standards.SKD2002, "45.220")),
        ((Standards.SKD2008, "43.990"), (Standards.SKD2002, "45.210")),
        ((Standards.SKD2008, "43.990"), (Standards.SKD2002, "45.220")),
        ((Standards.SKD2008, "43.990"), (Standards.SKD2002, "45.240")),
        ((Standards.SKD2008, "43.990"), (Standards.SKD2002, "45.250")),
        ((Standards.SKD2008, "43.990"), (Standards.SKD2002, "45.450")),
        ((Standards.SKD2008, "43.990"), (Standards.SKD2002, "45.500")),
        ((Standards.SKD2008, "45.110"), (Standards.SKD2002, "50.101")),
        ((Standards.SKD2008, "45.110"), (Standards.SKD2002, "50.102")),
        ((Standards.SKD2008, "45.110"), (Standards.SKD2002, "50.103")),
        ((Standards.SKD2008, "45.190"), (Standards.SKD2002, "50.101")),
        ((Standards.SKD2008, "45.190"), (Standards.SKD2002, "50.102")),
        ((Standards.SKD2008, "45.190"), (Standards.SKD2002, "50.103")),
        ((Standards.SKD2008, "45.200"), (Standards.SKD2002, "50.200")),
        ((Standards.SKD2008, "45.310"), (Standards.SKD2002, "50.301")),
        ((Standards.SKD2008, "45.310"), (Standards.SKD2002, "50.303")),
        ((Standards.SKD2008, "45.320"), (Standards.SKD2002, "50.302")),
        ((Standards.SKD2008, "45.400"), (Standards.SKD2002, "50.401")),
        ((Standards.SKD2008, "45.400"), (Standards.SKD2002, "50.402")),
        ((Standards.SKD2008, "45.400"), (Standards.SKD2002, "50.403")),
        ((Standards.SKD2008, "45.400"), (Standards.SKD2002, "50.404")),
        ((Standards.SKD2008, "46.110"), (Standards.SKD2002, "51.110")),
        ((Standards.SKD2008, "46.120"), (Standards.SKD2002, "51.120")),
        ((Standards.SKD2008, "46.130"), (Standards.SKD2002, "51.130")),
        ((Standards.SKD2008, "46.140"), (Standards.SKD2002, "51.140")),
        ((Standards.SKD2008, "46.150"), (Standards.SKD2002, "51.150")),
        ((Standards.SKD2008, "46.160"), (Standards.SKD2002, "51.160")),
        ((Standards.SKD2008, "46.170"), (Standards.SKD2002, "51.170")),
        ((Standards.SKD2008, "46.180"), (Standards.SKD2002, "51.180")),
        ((Standards.SKD2008, "46.190"), (Standards.SKD2002, "51.190")),
        ((Standards.SKD2008, "46.210"), (Standards.SKD2002, "51.210")),
        ((Standards.SKD2008, "46.210"), (Standards.SKD2002, "51.250")),
        ((Standards.SKD2008, "46.220"), (Standards.SKD2002, "51.220")),
        ((Standards.SKD2008, "46.230"), (Standards.SKD2002, "51.230")),
        ((Standards.SKD2008, "46.240"), (Standards.SKD2002, "51.240")),
        ((Standards.SKD2008, "46.310"), (Standards.SKD2002, "51.310")),
        ((Standards.SKD2008, "46.310"), (Standards.SKD2002, "51.380")),
        ((Standards.SKD2008, "46.320"), (Standards.SKD2002, "51.320")),
        ((Standards.SKD2008, "46.330"), (Standards.SKD2002, "51.330")),
        ((Standards.SKD2008, "46.340"), (Standards.SKD2002, "51.340")),
        ((Standards.SKD2008, "46.350"), (Standards.SKD2002, "51.350")),
        ((Standards.SKD2008, "46.360"), (Standards.SKD2002, "51.360")),
        ((Standards.SKD2008, "46.370"), (Standards.SKD2002, "51.370")),
        ((Standards.SKD2008, "46.380"), (Standards.SKD2002, "51.380")),
        ((Standards.SKD2008, "46.390"), (Standards.SKD2002, "51.390")),
        ((Standards.SKD2008, "46.410"), (Standards.SKD2002, "51.410")),
        ((Standards.SKD2008, "46.420"), (Standards.SKD2002, "51.420")),
        ((Standards.SKD2008, "46.430"), (Standards.SKD2002, "51.430")),
        ((Standards.SKD2008, "46.430"), (Standards.SKD2002, "51.470")),
        ((Standards.SKD2008, "46.440"), (Standards.SKD2002, "51.440")),
        ((Standards.SKD2008, "46.450"), (Standards.SKD2002, "51.450")),
        ((Standards.SKD2008, "46.460"), (Standards.SKD2002, "51.460")),
        ((Standards.SKD2008, "46.470"), (Standards.SKD2002, "51.430")),
        ((Standards.SKD2008, "46.470"), (Standards.SKD2002, "51.470")),
        ((Standards.SKD2008, "46.480"), (Standards.SKD2002, "51.470")),
        ((Standards.SKD2008, "46.490"), (Standards.SKD2002, "51.440")),
        ((Standards.SKD2008, "46.490"), (Standards.SKD2002, "51.470")),
        ((Standards.SKD2008, "46.510"), (Standards.SKD2002, "51.840")),
        ((Standards.SKD2008, "46.520"), (Standards.SKD2002, "51.430")),
        ((Standards.SKD2008, "46.520"), (Standards.SKD2002, "51.860")),
        ((Standards.SKD2008, "46.610"), (Standards.SKD2002, "51.880")),
        ((Standards.SKD2008, "46.620"), (Standards.SKD2002, "51.810")),
        ((Standards.SKD2008, "46.630"), (Standards.SKD2002, "51.820")),
        ((Standards.SKD2008, "46.640"), (Standards.SKD2002, "51.830")),
        ((Standards.SKD2008, "46.650"), (Standards.SKD2002, "51.850")),
        ((Standards.SKD2008, "46.660"), (Standards.SKD2002, "51.850")),
        ((Standards.SKD2008, "46.690"), (Standards.SKD2002, "51.870")),
        ((Standards.SKD2008, "46.710"), (Standards.SKD2002, "51.510")),
        ((Standards.SKD2008, "46.720"), (Standards.SKD2002, "51.520")),
        ((Standards.SKD2008, "46.730"), (Standards.SKD2002, "51.440")),
        ((Standards.SKD2008, "46.730"), (Standards.SKD2002, "51.470")),
        ((Standards.SKD2008, "46.730"), (Standards.SKD2002, "51.530")),
        ((Standards.SKD2008, "46.740"), (Standards.SKD2002, "51.540")),
        ((Standards.SKD2008, "46.750"), (Standards.SKD2002, "51.550")),
        ((Standards.SKD2008, "46.760"), (Standards.SKD2002, "51.550")),
        ((Standards.SKD2008, "46.760"), (Standards.SKD2002, "51.560")),
        ((Standards.SKD2008, "46.770"), (Standards.SKD2002, "51.570")),
        ((Standards.SKD2008, "46.900"), (Standards.SKD2002, "51.900")),
        ((Standards.SKD2008, "47.110"), (Standards.SKD2002, "52.110")),
        ((Standards.SKD2008, "47.190"), (Standards.SKD2002, "52.120")),
        ((Standards.SKD2008, "47.210"), (Standards.SKD2002, "52.210")),
        ((Standards.SKD2008, "47.210"), (Standards.SKD2002, "52.270")),
        ((Standards.SKD2008, "47.220"), (Standards.SKD2002, "52.220")),
        ((Standards.SKD2008, "47.230"), (Standards.SKD2002, "52.230")),
        ((Standards.SKD2008, "47.240"), (Standards.SKD2002, "52.240")),
        ((Standards.SKD2008, "47.250"), (Standards.SKD2002, "52.250")),
        ((Standards.SKD2008, "47.260"), (Standards.SKD2002, "52.260")),
        ((Standards.SKD2008, "47.290"), (Standards.SKD2002, "52.270")),
        ((Standards.SKD2008, "47.301"), (Standards.SKD2002, "50.501")),
        ((Standards.SKD2008, "47.302"), (Standards.SKD2002, "50.502")),
        ((Standards.SKD2008, "47.410"), (Standards.SKD2002, "52.488")),
        ((Standards.SKD2008, "47.420"), (Standards.SKD2002, "52.488")),
        ((Standards.SKD2008, "47.430"), (Standards.SKD2002, "52.450")),
        ((Standards.SKD2008, "47.510"), (Standards.SKD2002, "52.410")),
        ((Standards.SKD2008, "47.520"), (Standards.SKD2002, "52.461")),
        ((Standards.SKD2008, "47.520"), (Standards.SKD2002, "52.462")),
        ((Standards.SKD2008, "47.520"), (Standards.SKD2002, "52.463")),
        ((Standards.SKD2008, "47.530"), (Standards.SKD2002, "52.440")),
        ((Standards.SKD2008, "47.530"), (Standards.SKD2002, "52.488")),
        ((Standards.SKD2008, "47.540"), (Standards.SKD2002, "52.450")),
        ((Standards.SKD2008, "47.590"), (Standards.SKD2002, "52.440")),
        ((Standards.SKD2008, "47.590"), (Standards.SKD2002, "52.450")),
        ((Standards.SKD2008, "47.590"), (Standards.SKD2002, "52.488")),
        ((Standards.SKD2008, "47.610"), (Standards.SKD2002, "52.471")),
        ((Standards.SKD2008, "47.621"), (Standards.SKD2002, "52.472")),
        ((Standards.SKD2008, "47.622"), (Standards.SKD2002, "52.473")),
        ((Standards.SKD2008, "47.630"), (Standards.SKD2002, "52.450")),
        ((Standards.SKD2008, "47.640"), (Standards.SKD2002, "52.481")),
        ((Standards.SKD2008, "47.650"), (Standards.SKD2002, "52.487")),
        ((Standards.SKD2008, "47.710"), (Standards.SKD2002, "52.420")),
        ((Standards.SKD2008, "47.720"), (Standards.SKD2002, "52.430")),
        ((Standards.SKD2008, "47.730"), (Standards.SKD2002, "52.310")),
        ((Standards.SKD2008, "47.740"), (Standards.SKD2002, "52.320")),
        ((Standards.SKD2008, "47.750"), (Standards.SKD2002, "52.330")),
        ((Standards.SKD2008, "47.761"), (Standards.SKD2002, "52.482")),
        ((Standards.SKD2008, "47.762"), (Standards.SKD2002, "52.483")),
        ((Standards.SKD2008, "47.770"), (Standards.SKD2002, "52.485")),
        ((Standards.SKD2008, "47.781"), (Standards.SKD2002, "52.488")),
        ((Standards.SKD2008, "47.782"), (Standards.SKD2002, "52.486")),
        ((Standards.SKD2008, "47.789"), (Standards.SKD2002, "52.484")),
        ((Standards.SKD2008, "47.789"), (Standards.SKD2002, "52.488")),
        ((Standards.SKD2008, "47.790"), (Standards.SKD2002, "52.500")),
        ((Standards.SKD2008, "47.790"), (Standards.SKD2002, "52.630")),
        ((Standards.SKD2008, "47.810"), (Standards.SKD2002, "52.620")),
        ((Standards.SKD2008, "47.820"), (Standards.SKD2002, "52.620")),
        ((Standards.SKD2008, "47.890"), (Standards.SKD2002, "52.620")),
        ((Standards.SKD2008, "47.910"), (Standards.SKD2002, "52.610")),
        ((Standards.SKD2008, "47.910"), (Standards.SKD2002, "52.630")),
        ((Standards.SKD2008, "47.990"), (Standards.SKD2002, "52.630")),
        ((Standards.SKD2008, "49.100"), (Standards.SKD2002, "60.100")),
        ((Standards.SKD2008, "49.200"), (Standards.SKD2002, "60.100")),
        ((Standards.SKD2008, "49.310"), (Standards.SKD2002, "60.211")),
        ((Standards.SKD2008, "49.320"), (Standards.SKD2002, "60.220")),
        ((Standards.SKD2008, "49.391"), (Standards.SKD2002, "60.212")),
        ((Standards.SKD2008, "49.391"), (Standards.SKD2002, "60.230")),
        ((Standards.SKD2008, "49.392"), (Standards.SKD2002, "60.213")),
        ((Standards.SKD2008, "49.410"), (Standards.SKD2002, "60.240")),
        ((Standards.SKD2008, "49.420"), (Standards.SKD2002, "60.240")),
        ((Standards.SKD2008, "49.500"), (Standards.SKD2002, "60.300")),
        ((Standards.SKD2008, "50.100"), (Standards.SKD2002, "61.100")),
        ((Standards.SKD2008, "50.200"), (Standards.SKD2002, "61.100")),
        ((Standards.SKD2008, "50.300"), (Standards.SKD2002, "61.200")),
        ((Standards.SKD2008, "50.400"), (Standards.SKD2002, "61.200")),
        ((Standards.SKD2008, "51.100"), (Standards.SKD2002, "62.100")),
        ((Standards.SKD2008, "51.100"), (Standards.SKD2002, "62.200")),
        ((Standards.SKD2008, "51.210"), (Standards.SKD2002, "62.100")),
        ((Standards.SKD2008, "51.210"), (Standards.SKD2002, "62.200")),
        ((Standards.SKD2008, "52.100"), (Standards.SKD2002, "63.120")),
        ((Standards.SKD2008, "52.210"), (Standards.SKD2002, "11.100")),
        ((Standards.SKD2008, "52.210"), (Standards.SKD2002, "50.200")),
        ((Standards.SKD2008, "52.210"), (Standards.SKD2002, "60.100")),
        ((Standards.SKD2008, "52.210"), (Standards.SKD2002, "63.210")),
        ((Standards.SKD2008, "52.220"), (Standards.SKD2002, "11.100")),
        ((Standards.SKD2008, "52.220"), (Standards.SKD2002, "61.100")),
        ((Standards.SKD2008, "52.220"), (Standards.SKD2002, "61.200")),
        ((Standards.SKD2008, "52.220"), (Standards.SKD2002, "63.220")),
        ((Standards.SKD2008, "52.230"), (Standards.SKD2002, "63.230")),
        ((Standards.SKD2008, "52.240"), (Standards.SKD2002, "63.110")),
        ((Standards.SKD2008, "52.290"), (Standards.SKD2002, "63.400")),
        ((Standards.SKD2008, "53.100"), (Standards.SKD2002, "64.110")),
        ((Standards.SKD2008, "53.200"), (Standards.SKD2002, "64.120")),
        ((Standards.SKD2008, "55.100"), (Standards.SKD2002, "55.100")),
        ((Standards.SKD2008, "55.201"), (Standards.SKD2002, "55.231")),
        ((Standards.SKD2008, "55.202"), (Standards.SKD2002, "55.232")),
        ((Standards.SKD2008, "55.203"), (Standards.SKD2002, "55.233")),
        ((Standards.SKD2008, "55.204"), (Standards.SKD2002, "55.210")),
        ((Standards.SKD2008, "55.209"), (Standards.SKD2002, "55.239")),
        ((Standards.SKD2008, "55.300"), (Standards.SKD2002, "55.210")),
        ((Standards.SKD2008, "55.300"), (Standards.SKD2002, "55.220")),
        ((Standards.SKD2008, "55.900"), (Standards.SKD2002, "55.234")),
        ((Standards.SKD2008, "56.101"), (Standards.SKD2002, "55.301")),
        ((Standards.SKD2008, "56.102"), (Standards.SKD2002, "55.302")),
        ((Standards.SKD2008, "56.103"), (Standards.SKD2002, "55.303")),
        ((Standards.SKD2008, "56.104"), (Standards.SKD2002, "55.304")),
        ((Standards.SKD2008, "56.105"), (Standards.SKD2002, "55.305")),
        ((Standards.SKD2008, "56.210"), (Standards.SKD2002, "55.520")),
        ((Standards.SKD2008, "56.290"), (Standards.SKD2002, "55.510")),
        ((Standards.SKD2008, "56.290"), (Standards.SKD2002, "55.520")),
        ((Standards.SKD2008, "56.300"), (Standards.SKD2002, "55.400")),
        ((Standards.SKD2008, "58.110"), (Standards.SKD2002, "22.110")),
        ((Standards.SKD2008, "58.110"), (Standards.SKD2002, "72.400")),
        ((Standards.SKD2008, "58.120"), (Standards.SKD2002, "22.110")),
        ((Standards.SKD2008, "58.120"), (Standards.SKD2002, "72.400")),
        ((Standards.SKD2008, "58.130"), (Standards.SKD2002, "22.120")),
        ((Standards.SKD2008, "58.130"), (Standards.SKD2002, "72.400")),
        ((Standards.SKD2008, "58.140"), (Standards.SKD2002, "22.130")),
        ((Standards.SKD2008, "58.140"), (Standards.SKD2002, "72.400")),
        ((Standards.SKD2008, "58.190"), (Standards.SKD2002, "22.150")),
        ((Standards.SKD2008, "58.190"), (Standards.SKD2002, "22.220")),
        ((Standards.SKD2008, "58.190"), (Standards.SKD2002, "72.400")),
        ((Standards.SKD2008, "58.210"), (Standards.SKD2002, "72.210")),
        ((Standards.SKD2008, "58.210"), (Standards.SKD2002, "72.400")),
        ((Standards.SKD2008, "58.290"), (Standards.SKD2002, "72.210")),
        ((Standards.SKD2008, "58.290"), (Standards.SKD2002, "72.400")),
        ((Standards.SKD2008, "59.110"), (Standards.SKD2002, "92.110")),
        ((Standards.SKD2008, "59.110"), (Standards.SKD2002, "92.200")),
        ((Standards.SKD2008, "59.120"), (Standards.SKD2002, "92.110")),
        ((Standards.SKD2008, "59.130"), (Standards.SKD2002, "92.120")),
        ((Standards.SKD2008, "59.140"), (Standards.SKD2002, "92.130")),
        ((Standards.SKD2008, "59.200"), (Standards.SKD2002, "22.140")),
        ((Standards.SKD2008, "59.200"), (Standards.SKD2002, "72.400")),
        ((Standards.SKD2008, "59.200"), (Standards.SKD2002, "74.873")),
        ((Standards.SKD2008, "59.200"), (Standards.SKD2002, "92.110")),
        ((Standards.SKD2008, "59.200"), (Standards.SKD2002, "92.200")),
        ((Standards.SKD2008, "60.100"), (Standards.SKD2002, "64.200")),
        ((Standards.SKD2008, "60.100"), (Standards.SKD2002, "72.400")),
        ((Standards.SKD2008, "60.100"), (Standards.SKD2002, "92.200")),
        ((Standards.SKD2008, "60.200"), (Standards.SKD2002, "64.200")),
        ((Standards.SKD2008, "60.200"), (Standards.SKD2002, "72.400")),
        ((Standards.SKD2008, "60.200"), (Standards.SKD2002, "92.200")),
        ((Standards.SKD2008, "61.100"), (Standards.SKD2002, "64.200")),
        ((Standards.SKD2008, "61.200"), (Standards.SKD2002, "64.200")),
        ((Standards.SKD2008, "61.300"), (Standards.SKD2002, "64.200")),
        ((Standards.SKD2008, "61.900"), (Standards.SKD2002, "64.200")),
        ((Standards.SKD2008, "62.010"), (Standards.SKD2002, "72.210")),
        ((Standards.SKD2008, "62.010"), (Standards.SKD2002, "72.220")),
        ((Standards.SKD2008, "62.010"), (Standards.SKD2002, "72.400")),
        ((Standards.SKD2008, "62.020"), (Standards.SKD2002, "72.100")),
        ((Standards.SKD2008, "62.020"), (Standards.SKD2002, "72.220")),
        ((Standards.SKD2008, "62.030"), (Standards.SKD2002, "72.300")),
        ((Standards.SKD2008, "62.090"), (Standards.SKD2002, "30.020")),
        ((Standards.SKD2008, "62.090"), (Standards.SKD2002, "72.220")),
        ((Standards.SKD2008, "62.090"), (Standards.SKD2002, "72.600")),
        ((Standards.SKD2008, "63.110"), (Standards.SKD2002, "72.300")),
        ((Standards.SKD2008, "63.110"), (Standards.SKD2002, "72.400")),
        ((Standards.SKD2008, "63.120"), (Standards.SKD2002, "72.400")),
        ((Standards.SKD2008, "63.910"), (Standards.SKD2002, "92.400")),
        ((Standards.SKD2008, "63.990"), (Standards.SKD2002, "74.873")),
        ((Standards.SKD2008, "64.110"), (Standards.SKD2002, "65.110")),
        ((Standards.SKD2008, "64.190"), (Standards.SKD2002, "65.121")),
        ((Standards.SKD2008, "64.190"), (Standards.SKD2002, "65.122")),
        ((Standards.SKD2008, "64.200"), (Standards.SKD2002, "65.230")),
        ((Standards.SKD2008, "64.200"), (Standards.SKD2002, "74.150")),
        ((Standards.SKD2008, "64.300"), (Standards.SKD2002, "65.230")),
        ((Standards.SKD2008, "64.910"), (Standards.SKD2002, "65.210")),
        ((Standards.SKD2008, "64.920"), (Standards.SKD2002, "65.220")),
        ((Standards.SKD2008, "64.990"), (Standards.SKD2002, "65.220")),
        ((Standards.SKD2008, "64.990"), (Standards.SKD2002, "65.230")),
        ((Standards.SKD2008, "65.110"), (Standards.SKD2002, "66.010")),
        ((Standards.SKD2008, "65.120"), (Standards.SKD2002, "66.030")),
        ((Standards.SKD2008, "65.200"), (Standards.SKD2002, "66.010")),
        ((Standards.SKD2008, "65.200"), (Standards.SKD2002, "66.020")),
        ((Standards.SKD2008, "65.200"), (Standards.SKD2002, "66.030")),
        ((Standards.SKD2008, "65.300"), (Standards.SKD2002, "66.020")),
        ((Standards.SKD2008, "66.110"), (Standards.SKD2002, "67.110")),
        ((Standards.SKD2008, "66.120"), (Standards.SKD2002, "67.120")),
        ((Standards.SKD2008, "66.120"), (Standards.SKD2002, "67.130")),
        ((Standards.SKD2008, "66.190"), (Standards.SKD2002, "67.130")),
        ((Standards.SKD2008, "66.210"), (Standards.SKD2002, "67.200")),
        ((Standards.SKD2008, "66.220"), (Standards.SKD2002, "67.200")),
        ((Standards.SKD2008, "66.290"), (Standards.SKD2002, "67.200")),
        ((Standards.SKD2008, "66.300"), (Standards.SKD2002, "67.120")),
        ((Standards.SKD2008, "68.100"), (Standards.SKD2002, "70.120")),
        ((Standards.SKD2008, "68.200"), (Standards.SKD2002, "70.200")),
        ((Standards.SKD2008, "68.310"), (Standards.SKD2002, "70.310")),
        ((Standards.SKD2008, "68.320"), (Standards.SKD2002, "70.320")),
        ((Standards.SKD2008, "69.101"), (Standards.SKD2002, "74.110")),
        ((Standards.SKD2008, "69.102"), (Standards.SKD2002, "74.110")),
        ((Standards.SKD2008, "69.103"), (Standards.SKD2002, "74.110")),
        ((Standards.SKD2008, "69.200"), (Standards.SKD2002, "74.120")),
        ((Standards.SKD2008, "70.100"), (Standards.SKD2002, "74.150")),
        ((Standards.SKD2008, "70.210"), (Standards.SKD2002, "74.140")),
        ((Standards.SKD2008, "70.220"), (Standards.SKD2002, "05.010")),
        ((Standards.SKD2008, "70.220"), (Standards.SKD2002, "74.140")),
        ((Standards.SKD2008, "71.111"), (Standards.SKD2002, "74.203")),
        ((Standards.SKD2008, "71.111"), (Standards.SKD2002, "92.310")),
        ((Standards.SKD2008, "71.112"), (Standards.SKD2002, "74.202")),
        ((Standards.SKD2008, "71.121"), (Standards.SKD2002, "74.201")),
        ((Standards.SKD2008, "71.129"), (Standards.SKD2002, "74.204")),
        ((Standards.SKD2008, "71.129"), (Standards.SKD2002, "74.203")),
        ((Standards.SKD2008, "71.200"), (Standards.SKD2002, "74.300")),
        ((Standards.SKD2008, "72.110"), (Standards.SKD2002, "73.101")),
        ((Standards.SKD2008, "72.110"), (Standards.SKD2002, "73.102")),
        ((Standards.SKD2008, "72.110"), (Standards.SKD2002, "73.103")),
        ((Standards.SKD2008, "72.110"), (Standards.SKD2002, "73.104")),
        ((Standards.SKD2008, "72.190"), (Standards.SKD2002, "73.101")),
        ((Standards.SKD2008, "72.190"), (Standards.SKD2002, "73.102")),
        ((Standards.SKD2008, "72.190"), (Standards.SKD2002, "73.103")),
        ((Standards.SKD2008, "72.190"), (Standards.SKD2002, "73.104")),
        ((Standards.SKD2008, "72.200"), (Standards.SKD2002, "73.101")),
        ((Standards.SKD2008, "72.200"), (Standards.SKD2002, "73.201")),
        ((Standards.SKD2008, "72.200"), (Standards.SKD2002, "73.202")),
        ((Standards.SKD2008, "73.110"), (Standards.SKD2002, "74.400")),
        ((Standards.SKD2008, "73.120"), (Standards.SKD2002, "74.400")),
        ((Standards.SKD2008, "73.200"), (Standards.SKD2002, "74.130")),
        ((Standards.SKD2008, "74.100"), (Standards.SKD2002, "74.872")),
        ((Standards.SKD2008, "74.200"), (Standards.SKD2002, "74.201")),
        ((Standards.SKD2008, "74.200"), (Standards.SKD2002, "74.810")),
        ((Standards.SKD2008, "74.200"), (Standards.SKD2002, "92.400")),
        ((Standards.SKD2008, "74.300"), (Standards.SKD2002, "74.851")),
        ((Standards.SKD2008, "74.900"), (Standards.SKD2002, "63.400")),
        ((Standards.SKD2008, "74.900"), (Standards.SKD2002, "74.140")),
        ((Standards.SKD2008, "74.900"), (Standards.SKD2002, "74.201")),
        ((Standards.SKD2008, "74.900"), (Standards.SKD2002, "74.600")),
        ((Standards.SKD2008, "74.900"), (Standards.SKD2002, "74.873")),
        ((Standards.SKD2008, "75.000"), (Standards.SKD2002, "85.200")),
        ((Standards.SKD2008, "77.110"), (Standards.SKD2002, "71.100")),
        ((Standards.SKD2008, "77.120"), (Standards.SKD2002, "71.210")),
        ((Standards.SKD2008, "77.210"), (Standards.SKD2002, "71.401")),
        ((Standards.SKD2008, "77.220"), (Standards.SKD2002, "71.402")),
        ((Standards.SKD2008, "77.290"), (Standards.SKD2002, "71.403")),
        ((Standards.SKD2008, "77.310"), (Standards.SKD2002, "71.310")),
        ((Standards.SKD2008, "77.320"), (Standards.SKD2002, "71.320")),
        ((Standards.SKD2008, "77.330"), (Standards.SKD2002, "71.330")),
        ((Standards.SKD2008, "77.340"), (Standards.SKD2002, "71.220")),
        ((Standards.SKD2008, "77.350"), (Standards.SKD2002, "71.230")),
        ((Standards.SKD2008, "77.390"), (Standards.SKD2002, "71.210")),
        ((Standards.SKD2008, "77.390"), (Standards.SKD2002, "71.320")),
        ((Standards.SKD2008, "77.390"), (Standards.SKD2002, "71.340")),
        ((Standards.SKD2008, "77.400"), (Standards.SKD2002, "74.873")),
        ((Standards.SKD2008, "78.100"), (Standards.SKD2002, "74.500")),
        ((Standards.SKD2008, "78.100"), (Standards.SKD2002, "92.720")),
        ((Standards.SKD2008, "78.200"), (Standards.SKD2002, "74.500")),
        ((Standards.SKD2008, "78.300"), (Standards.SKD2002, "74.500")),
        ((Standards.SKD2008, "79.110"), (Standards.SKD2002, "63.300")),
        ((Standards.SKD2008, "79.120"), (Standards.SKD2002, "63.300")),
        ((Standards.SKD2008, "79.900"), (Standards.SKD2002, "63.300")),
        ((Standards.SKD2008, "79.900"), (Standards.SKD2002, "92.320")),
        ((Standards.SKD2008, "79.900"), (Standards.SKD2002, "92.340")),
        ((Standards.SKD2008, "79.900"), (Standards.SKD2002, "92.623")),
        ((Standards.SKD2008, "79.900"), (Standards.SKD2002, "92.720")),
        ((Standards.SKD2008, "80.100"), (Standards.SKD2002, "74.600")),
        ((Standards.SKD2008, "80.200"), (Standards.SKD2002, "45.310")),
        ((Standards.SKD2008, "80.200"), (Standards.SKD2002, "74.600")),
        ((Standards.SKD2008, "80.300"), (Standards.SKD2002, "74.600")),
        ((Standards.SKD2008, "81.100"), (Standards.SKD2002, "70.320")),
        ((Standards.SKD2008, "81.100"), (Standards.SKD2002, "75.140")),
        ((Standards.SKD2008, "81.210"), (Standards.SKD2002, "74.700")),
        ((Standards.SKD2008, "81.220"), (Standards.SKD2002, "74.700")),
        ((Standards.SKD2008, "81.290"), (Standards.SKD2002, "74.700")),
        ((Standards.SKD2008, "81.290"), (Standards.SKD2002, "90.032")),
        ((Standards.SKD2008, "81.300"), (Standards.SKD2002, "01.411")),
        ((Standards.SKD2008, "82.110"), (Standards.SKD2002, "74.853")),
        ((Standards.SKD2008, "82.190"), (Standards.SKD2002, "64.110")),
        ((Standards.SKD2008, "82.190"), (Standards.SKD2002, "74.852")),
        ((Standards.SKD2008, "82.200"), (Standards.SKD2002, "74.860")),
        ((Standards.SKD2008, "82.300"), (Standards.SKD2002, "74.871")),
        ((Standards.SKD2008, "82.910"), (Standards.SKD2002, "74.873")),
        ((Standards.SKD2008, "82.920"), (Standards.SKD2002, "74.820")),
        ((Standards.SKD2008, "82.990"), (Standards.SKD2002, "74.853")),
        ((Standards.SKD2008, "82.990"), (Standards.SKD2002, "74.873")),
        ((Standards.SKD2008, "82.990"), (Standards.SKD2002, "75.130")),
        ((Standards.SKD2008, "84.110"), (Standards.SKD2002, "75.110")),
        ((Standards.SKD2008, "84.110"), (Standards.SKD2002, "75.140")),
        ((Standards.SKD2008, "84.120"), (Standards.SKD2002, "75.120")),
        ((Standards.SKD2008, "84.130"), (Standards.SKD2002, "75.130")),
        ((Standards.SKD2008, "84.210"), (Standards.SKD2002, "75.210")),
        ((Standards.SKD2008, "84.220"), (Standards.SKD2002, "75.220")),
        ((Standards.SKD2008, "84.230"), (Standards.SKD2002, "75.230")),
        ((Standards.SKD2008, "84.240"), (Standards.SKD2002, "75.240")),
        ((Standards.SKD2008, "84.250"), (Standards.SKD2002, "75.250")),
        ((Standards.SKD2008, "84.300"), (Standards.SKD2002, "75.300")),
        ((Standards.SKD2008, "85.100"), (Standards.SKD2002, "80.101")),
        ((Standards.SKD2008, "85.200"), (Standards.SKD2002, "80.102")),
        ((Standards.SKD2008, "85.200"), (Standards.SKD2002, "80.103")),
        ((Standards.SKD2008, "85.310"), (Standards.SKD2002, "80.210")),
        ((Standards.SKD2008, "85.320"), (Standards.SKD2002, "63.220")),
        ((Standards.SKD2008, "85.320"), (Standards.SKD2002, "63.230")),
        ((Standards.SKD2008, "85.320"), (Standards.SKD2002, "80.220")),
        ((Standards.SKD2008, "85.320"), (Standards.SKD2002, "80.422")),
        ((Standards.SKD2008, "85.410"), (Standards.SKD2002, "80.301")),
        ((Standards.SKD2008, "85.421"), (Standards.SKD2002, "80.301")),
        ((Standards.SKD2008, "85.422"), (Standards.SKD2002, "80.302")),
        ((Standards.SKD2008, "85.422"), (Standards.SKD2002, "80.303")),
        ((Standards.SKD2008, "85.510"), (Standards.SKD2002, "80.422")),
        ((Standards.SKD2008, "85.510"), (Standards.SKD2002, "92.623")),
        ((Standards.SKD2008, "85.510"), (Standards.SKD2002, "93.050")),
        ((Standards.SKD2008, "85.520"), (Standards.SKD2002, "80.421")),
        ((Standards.SKD2008, "85.520"), (Standards.SKD2002, "92.340")),
        ((Standards.SKD2008, "85.530"), (Standards.SKD2002, "80.410")),
        ((Standards.SKD2008, "85.590"), (Standards.SKD2002, "80.422")),
        ((Standards.SKD2008, "85.600"), (Standards.SKD2002, "74.140")),
        ((Standards.SKD2008, "86.100"), (Standards.SKD2002, "85.110")),
        ((Standards.SKD2008, "86.210"), (Standards.SKD2002, "85.121")),
        ((Standards.SKD2008, "86.220"), (Standards.SKD2002, "85.122")),
        ((Standards.SKD2008, "86.230"), (Standards.SKD2002, "85.130")),
        ((Standards.SKD2008, "86.901"), (Standards.SKD2002, "85.142")),
        ((Standards.SKD2008, "86.909"), (Standards.SKD2002, "85.141")),
        ((Standards.SKD2008, "86.909"), (Standards.SKD2002, "85.143")),
        ((Standards.SKD2008, "87.100"), (Standards.SKD2002, "85.143")),
        ((Standards.SKD2008, "87.200"), (Standards.SKD2002, "85.110")),
        ((Standards.SKD2008, "87.200"), (Standards.SKD2002, "85.143")),
        ((Standards.SKD2008, "87.200"), (Standards.SKD2002, "85.319")),
        ((Standards.SKD2008, "87.300"), (Standards.SKD2002, "85.143")),
        ((Standards.SKD2008, "87.300"), (Standards.SKD2002, "85.311")),
        ((Standards.SKD2008, "87.900"), (Standards.SKD2002, "85.319")),
        ((Standards.SKD2008, "88.109"), (Standards.SKD2002, "85.321")),
        ((Standards.SKD2008, "88.109"), (Standards.SKD2002, "85.324")),
        ((Standards.SKD2008, "88.109"), (Standards.SKD2002, "85.329")),
        ((Standards.SKD2008, "88.910"), (Standards.SKD2002, "85.321")),
        ((Standards.SKD2008, "88.910"), (Standards.SKD2002, "93.050")),
        ((Standards.SKD2008, "88.991"), (Standards.SKD2002, "85.323")),
        ((Standards.SKD2008, "88.991"), (Standards.SKD2002, "75.210")),
        ((Standards.SKD2008, "88.999"), (Standards.SKD2002, "85.329")),
        ((Standards.SKD2008, "90.010"), (Standards.SKD2002, "92.310")),
        ((Standards.SKD2008, "90.010"), (Standards.SKD2002, "92.340")),
        ((Standards.SKD2008, "90.020"), (Standards.SKD2002, "92.310")),
        ((Standards.SKD2008, "90.020"), (Standards.SKD2002, "92.320")),
        ((Standards.SKD2008, "90.020"), (Standards.SKD2002, "92.340")),
        ((Standards.SKD2008, "90.030"), (Standards.SKD2002, "92.310")),
        ((Standards.SKD2008, "90.030"), (Standards.SKD2002, "92.400")),
        ((Standards.SKD2008, "90.040"), (Standards.SKD2002, "92.320")),
        ((Standards.SKD2008, "91.011"), (Standards.SKD2002, "92.511")),
        ((Standards.SKD2008, "91.012"), (Standards.SKD2002, "75.140")),
        ((Standards.SKD2008, "91.012"), (Standards.SKD2002, "92.512")),
        ((Standards.SKD2008, "91.020"), (Standards.SKD2002, "92.521")),
        ((Standards.SKD2008, "91.030"), (Standards.SKD2002, "92.522")),
        ((Standards.SKD2008, "91.040"), (Standards.SKD2002, "92.530")),
        ((Standards.SKD2008, "92.001"), (Standards.SKD2002, "92.712")),
        ((Standards.SKD2008, "92.002"), (Standards.SKD2002, "92.711")),
        ((Standards.SKD2008, "93.110"), (Standards.SKD2002, "92.610")),
        ((Standards.SKD2008, "93.110"), (Standards.SKD2002, "92.623")),
        ((Standards.SKD2008, "93.120"), (Standards.SKD2002, "92.623")),
        ((Standards.SKD2008, "93.130"), (Standards.SKD2002, "93.040")),
        ((Standards.SKD2008, "93.190"), (Standards.SKD2002, "92.623")),
        ((Standards.SKD2008, "93.210"), (Standards.SKD2002, "92.330")),
        ((Standards.SKD2008, "93.291"), (Standards.SKD2002, "92.621")),
        ((Standards.SKD2008, "93.292"), (Standards.SKD2002, "92.622")),
        ((Standards.SKD2008, "93.299"), (Standards.SKD2002, "92.340")),
        ((Standards.SKD2008, "93.299"), (Standards.SKD2002, "92.720")),
        ((Standards.SKD2008, "94.110"), (Standards.SKD2002, "91.110")),
        ((Standards.SKD2008, "94.120"), (Standards.SKD2002, "91.120")),
        ((Standards.SKD2008, "94.200"), (Standards.SKD2002, "91.200")),
        ((Standards.SKD2008, "94.910"), (Standards.SKD2002, "91.310")),
        ((Standards.SKD2008, "94.920"), (Standards.SKD2002, "91.320")),
        ((Standards.SKD2008, "94.991"), (Standards.SKD2002, "85.322")),
        ((Standards.SKD2008, "94.999"), (Standards.SKD2002, "01.500")),
        ((Standards.SKD2008, "94.999"), (Standards.SKD2002, "91.330")),
        ((Standards.SKD2008, "95.110"), (Standards.SKD2002, "72.500")),
        ((Standards.SKD2008, "95.120"), (Standards.SKD2002, "32.200")),
        ((Standards.SKD2008, "95.120"), (Standards.SKD2002, "52.740")),
        ((Standards.SKD2008, "95.210"), (Standards.SKD2002, "52.720")),
        ((Standards.SKD2008, "95.220"), (Standards.SKD2002, "29.320")),
        ((Standards.SKD2008, "95.220"), (Standards.SKD2002, "52.720")),
        ((Standards.SKD2008, "95.230"), (Standards.SKD2002, "52.710")),
        ((Standards.SKD2008, "95.230"), (Standards.SKD2002, "52.740")),
        ((Standards.SKD2008, "95.240"), (Standards.SKD2002, "36.110")),
        ((Standards.SKD2008, "95.240"), (Standards.SKD2002, "36.120")),
        ((Standards.SKD2008, "95.240"), (Standards.SKD2002, "36.130")),
        ((Standards.SKD2008, "95.240"), (Standards.SKD2002, "36.140")),
        ((Standards.SKD2008, "95.250"), (Standards.SKD2002, "52.730")),
        ((Standards.SKD2008, "95.290"), (Standards.SKD2002, "17.400")),
        ((Standards.SKD2008, "95.290"), (Standards.SKD2002, "36.300")),
        ((Standards.SKD2008, "95.290"), (Standards.SKD2002, "52.740")),
        ((Standards.SKD2008, "96.010"), (Standards.SKD2002, "93.010")),
        ((Standards.SKD2008, "96.021"), (Standards.SKD2002, "93.021")),
        ((Standards.SKD2008, "96.022"), (Standards.SKD2002, "93.022")),
        ((Standards.SKD2008, "96.022"), (Standards.SKD2002, "93.023")),
        ((Standards.SKD2008, "96.030"), (Standards.SKD2002, "93.030")),
        ((Standards.SKD2008, "96.040"), (Standards.SKD2002, "93.040")),
        ((Standards.SKD2008, "96.090"), (Standards.SKD2002, "93.050")),
        ((Standards.SKD2008, "97.000"), (Standards.SKD2002, "95.000")),
        ((Standards.SKD2008, "99.000"), (Standards.SKD2002, "99.000")),
    ],
)
