# -*- coding: utf-8 -*-
"""`Concordance between SIC and NAICS2017 <https://www.inegi.org.mx/app/scian/>`_.
"""
from ...types import Concordance, Standards
from ..naics2017 import NAICS2017
from . import SIC

SIC_to_NAICS2017 = Concordance(
    src=SIC,
    dst=NAICS2017,
    concordances=[
        ((Standards.SIC, "0111"), (Standards.NAICS2017, "111140")),
        ((Standards.SIC, "0112"), (Standards.NAICS2017, "111160")),
        ((Standards.SIC, "0115"), (Standards.NAICS2017, "111150")),
        ((Standards.SIC, "0116"), (Standards.NAICS2017, "111110")),
        ((Standards.SIC, "0119"), (Standards.NAICS2017, "111120")),
        ((Standards.SIC, "0119"), (Standards.NAICS2017, "111130")),
        ((Standards.SIC, "0119"), (Standards.NAICS2017, "111150")),
        ((Standards.SIC, "0119"), (Standards.NAICS2017, "111191")),
        ((Standards.SIC, "0119"), (Standards.NAICS2017, "111199")),
        ((Standards.SIC, "0131"), (Standards.NAICS2017, "111920")),
        ((Standards.SIC, "0132"), (Standards.NAICS2017, "111910")),
        ((Standards.SIC, "0133"), (Standards.NAICS2017, "111930")),
        ((Standards.SIC, "0133"), (Standards.NAICS2017, "111991")),
        ((Standards.SIC, "0134"), (Standards.NAICS2017, "111211")),
        ((Standards.SIC, "0139"), (Standards.NAICS2017, "111199")),
        ((Standards.SIC, "0139"), (Standards.NAICS2017, "111211")),
        ((Standards.SIC, "0139"), (Standards.NAICS2017, "111219")),
        ((Standards.SIC, "0139"), (Standards.NAICS2017, "111940")),
        ((Standards.SIC, "0139"), (Standards.NAICS2017, "111992")),
        ((Standards.SIC, "0139"), (Standards.NAICS2017, "111998")),
        ((Standards.SIC, "0139"), (Standards.NAICS2017, "112519")),
        ((Standards.SIC, "0161"), (Standards.NAICS2017, "111211")),
        ((Standards.SIC, "0161"), (Standards.NAICS2017, "111219")),
        ((Standards.SIC, "0171"), (Standards.NAICS2017, "111333")),
        ((Standards.SIC, "0171"), (Standards.NAICS2017, "111334")),
        ((Standards.SIC, "0172"), (Standards.NAICS2017, "111332")),
        ((Standards.SIC, "0173"), (Standards.NAICS2017, "111335")),
        ((Standards.SIC, "0174"), (Standards.NAICS2017, "111310")),
        ((Standards.SIC, "0174"), (Standards.NAICS2017, "111320")),
        ((Standards.SIC, "0175"), (Standards.NAICS2017, "111331")),
        ((Standards.SIC, "0175"), (Standards.NAICS2017, "111339")),
        ((Standards.SIC, "0179"), (Standards.NAICS2017, "111336")),
        ((Standards.SIC, "0179"), (Standards.NAICS2017, "111339")),
        ((Standards.SIC, "0181"), (Standards.NAICS2017, "111421")),
        ((Standards.SIC, "0181"), (Standards.NAICS2017, "111422")),
        ((Standards.SIC, "0182"), (Standards.NAICS2017, "111411")),
        ((Standards.SIC, "0182"), (Standards.NAICS2017, "111419")),
        ((Standards.SIC, "0191"), (Standards.NAICS2017, "111998")),
        ((Standards.SIC, "0191"), (Standards.NAICS2017, "112519")),
        ((Standards.SIC, "0211"), (Standards.NAICS2017, "112112")),
        ((Standards.SIC, "0212"), (Standards.NAICS2017, "112111")),
        ((Standards.SIC, "0213"), (Standards.NAICS2017, "112210")),
        ((Standards.SIC, "0214"), (Standards.NAICS2017, "112410")),
        ((Standards.SIC, "0214"), (Standards.NAICS2017, "112420")),
        ((Standards.SIC, "0219"), (Standards.NAICS2017, "112990")),
        ((Standards.SIC, "0241"), (Standards.NAICS2017, "112111")),
        ((Standards.SIC, "0241"), (Standards.NAICS2017, "112120")),
        ((Standards.SIC, "0251"), (Standards.NAICS2017, "112320")),
        ((Standards.SIC, "0252"), (Standards.NAICS2017, "112310")),
        ((Standards.SIC, "0253"), (Standards.NAICS2017, "112330")),
        ((Standards.SIC, "0254"), (Standards.NAICS2017, "112340")),
        ((Standards.SIC, "0259"), (Standards.NAICS2017, "112390")),
        ((Standards.SIC, "0271"), (Standards.NAICS2017, "112930")),
        ((Standards.SIC, "0272"), (Standards.NAICS2017, "112920")),
        ((Standards.SIC, "0273"), (Standards.NAICS2017, "112511")),
        ((Standards.SIC, "0273"), (Standards.NAICS2017, "112512")),
        ((Standards.SIC, "0273"), (Standards.NAICS2017, "112519")),
        ((Standards.SIC, "0279"), (Standards.NAICS2017, "112519")),
        ((Standards.SIC, "0279"), (Standards.NAICS2017, "112910")),
        ((Standards.SIC, "0279"), (Standards.NAICS2017, "112990")),
        ((Standards.SIC, "0291"), (Standards.NAICS2017, "112990")),
        ((Standards.SIC, "0711"), (Standards.NAICS2017, "115112")),
        ((Standards.SIC, "0721"), (Standards.NAICS2017, "115112")),
        ((Standards.SIC, "0722"), (Standards.NAICS2017, "115113")),
        ((Standards.SIC, "0723"), (Standards.NAICS2017, "115114")),
        ((Standards.SIC, "0723"), (Standards.NAICS2017, "311119")),
        ((Standards.SIC, "0724"), (Standards.NAICS2017, "115111")),
        ((Standards.SIC, "0741"), (Standards.NAICS2017, "541940")),
        ((Standards.SIC, "0742"), (Standards.NAICS2017, "541940")),
        ((Standards.SIC, "0751"), (Standards.NAICS2017, "115210")),
        ((Standards.SIC, "0751"), (Standards.NAICS2017, "311611")),
        ((Standards.SIC, "0752"), (Standards.NAICS2017, "115210")),
        ((Standards.SIC, "0752"), (Standards.NAICS2017, "812910")),
        ((Standards.SIC, "0761"), (Standards.NAICS2017, "115115")),
        ((Standards.SIC, "0762"), (Standards.NAICS2017, "115116")),
        ((Standards.SIC, "0781"), (Standards.NAICS2017, "541320")),
        ((Standards.SIC, "0781"), (Standards.NAICS2017, "541690")),
        ((Standards.SIC, "0782"), (Standards.NAICS2017, "561730")),
        ((Standards.SIC, "0783"), (Standards.NAICS2017, "561730")),
        ((Standards.SIC, "0811"), (Standards.NAICS2017, "111421")),
        ((Standards.SIC, "0811"), (Standards.NAICS2017, "113110")),
        ((Standards.SIC, "0831"), (Standards.NAICS2017, "111998")),
        ((Standards.SIC, "0831"), (Standards.NAICS2017, "112519")),
        ((Standards.SIC, "0831"), (Standards.NAICS2017, "113210")),
        ((Standards.SIC, "0851"), (Standards.NAICS2017, "115310")),
        ((Standards.SIC, "0912"), (Standards.NAICS2017, "114111")),
        ((Standards.SIC, "0913"), (Standards.NAICS2017, "114112")),
        ((Standards.SIC, "0919"), (Standards.NAICS2017, "111998")),
        ((Standards.SIC, "0919"), (Standards.NAICS2017, "112512")),
        ((Standards.SIC, "0919"), (Standards.NAICS2017, "112519")),
        ((Standards.SIC, "0919"), (Standards.NAICS2017, "114112")),
        ((Standards.SIC, "0919"), (Standards.NAICS2017, "114119")),
        ((Standards.SIC, "0921"), (Standards.NAICS2017, "112511")),
        ((Standards.SIC, "0921"), (Standards.NAICS2017, "112512")),
        ((Standards.SIC, "0971"), (Standards.NAICS2017, "114210")),
        ((Standards.SIC, "1011"), (Standards.NAICS2017, "212210")),
        ((Standards.SIC, "1021"), (Standards.NAICS2017, "212230")),
        ((Standards.SIC, "1031"), (Standards.NAICS2017, "212230")),
        ((Standards.SIC, "1041"), (Standards.NAICS2017, "212221")),
        ((Standards.SIC, "1044"), (Standards.NAICS2017, "212222")),
        ((Standards.SIC, "1061"), (Standards.NAICS2017, "212230")),
        ((Standards.SIC, "1061"), (Standards.NAICS2017, "212299")),
        ((Standards.SIC, "1081"), (Standards.NAICS2017, "213114")),
        ((Standards.SIC, "1081"), (Standards.NAICS2017, "238910")),
        ((Standards.SIC, "1081"), (Standards.NAICS2017, "541360")),
        ((Standards.SIC, "1094"), (Standards.NAICS2017, "212291")),
        ((Standards.SIC, "1099"), (Standards.NAICS2017, "212299")),
        ((Standards.SIC, "1221"), (Standards.NAICS2017, "212111")),
        ((Standards.SIC, "1222"), (Standards.NAICS2017, "212112")),
        ((Standards.SIC, "1231"), (Standards.NAICS2017, "212113")),
        ((Standards.SIC, "1241"), (Standards.NAICS2017, "213113")),
        ((Standards.SIC, "1241"), (Standards.NAICS2017, "238910")),
        ((Standards.SIC, "1311"), (Standards.NAICS2017, "211120")),
        ((Standards.SIC, "1321"), (Standards.NAICS2017, "211130")),
        ((Standards.SIC, "1381"), (Standards.NAICS2017, "213111")),
        ((Standards.SIC, "1382"), (Standards.NAICS2017, "213112")),
        ((Standards.SIC, "1382"), (Standards.NAICS2017, "541360")),
        ((Standards.SIC, "1389"), (Standards.NAICS2017, "213112")),
        ((Standards.SIC, "1389"), (Standards.NAICS2017, "237120")),
        ((Standards.SIC, "1389"), (Standards.NAICS2017, "238910")),
        ((Standards.SIC, "1411"), (Standards.NAICS2017, "212311")),
        ((Standards.SIC, "1422"), (Standards.NAICS2017, "212312")),
        ((Standards.SIC, "1423"), (Standards.NAICS2017, "212313")),
        ((Standards.SIC, "1429"), (Standards.NAICS2017, "212319")),
        ((Standards.SIC, "1442"), (Standards.NAICS2017, "212321")),
        ((Standards.SIC, "1446"), (Standards.NAICS2017, "212322")),
        ((Standards.SIC, "1455"), (Standards.NAICS2017, "212324")),
        ((Standards.SIC, "1459"), (Standards.NAICS2017, "212325")),
        ((Standards.SIC, "1474"), (Standards.NAICS2017, "212391")),
        ((Standards.SIC, "1475"), (Standards.NAICS2017, "212392")),
        ((Standards.SIC, "1479"), (Standards.NAICS2017, "212393")),
        ((Standards.SIC, "1481"), (Standards.NAICS2017, "213115")),
        ((Standards.SIC, "1481"), (Standards.NAICS2017, "238910")),
        ((Standards.SIC, "1481"), (Standards.NAICS2017, "541360")),
        ((Standards.SIC, "1499"), (Standards.NAICS2017, "212319")),
        ((Standards.SIC, "1499"), (Standards.NAICS2017, "212399")),
        ((Standards.SIC, "1521"), (Standards.NAICS2017, "236115")),
        ((Standards.SIC, "1521"), (Standards.NAICS2017, "236118")),
        ((Standards.SIC, "1522"), (Standards.NAICS2017, "236116")),
        ((Standards.SIC, "1522"), (Standards.NAICS2017, "236118")),
        ((Standards.SIC, "1522"), (Standards.NAICS2017, "236220")),
        ((Standards.SIC, "1531"), (Standards.NAICS2017, "236117")),
        ((Standards.SIC, "1531"), (Standards.NAICS2017, "236118")),
        ((Standards.SIC, "1531"), (Standards.NAICS2017, "236210")),
        ((Standards.SIC, "1531"), (Standards.NAICS2017, "236220")),
        ((Standards.SIC, "1541"), (Standards.NAICS2017, "236210")),
        ((Standards.SIC, "1541"), (Standards.NAICS2017, "236220")),
        ((Standards.SIC, "1542"), (Standards.NAICS2017, "236220")),
        ((Standards.SIC, "1611"), (Standards.NAICS2017, "237310")),
        ((Standards.SIC, "1622"), (Standards.NAICS2017, "237310")),
        ((Standards.SIC, "1622"), (Standards.NAICS2017, "237990")),
        ((Standards.SIC, "1623"), (Standards.NAICS2017, "237110")),
        ((Standards.SIC, "1623"), (Standards.NAICS2017, "237120")),
        ((Standards.SIC, "1623"), (Standards.NAICS2017, "237130")),
        ((Standards.SIC, "1629"), (Standards.NAICS2017, "236210")),
        ((Standards.SIC, "1629"), (Standards.NAICS2017, "237110")),
        ((Standards.SIC, "1629"), (Standards.NAICS2017, "237120")),
        ((Standards.SIC, "1629"), (Standards.NAICS2017, "237130")),
        ((Standards.SIC, "1629"), (Standards.NAICS2017, "237990")),
        ((Standards.SIC, "1629"), (Standards.NAICS2017, "238910")),
        ((Standards.SIC, "1711"), (Standards.NAICS2017, "238210")),
        ((Standards.SIC, "1711"), (Standards.NAICS2017, "238220")),
        ((Standards.SIC, "1711"), (Standards.NAICS2017, "238910")),
        ((Standards.SIC, "1721"), (Standards.NAICS2017, "237310")),
        ((Standards.SIC, "1721"), (Standards.NAICS2017, "238320")),
        ((Standards.SIC, "1731"), (Standards.NAICS2017, "238210")),
        ((Standards.SIC, "1741"), (Standards.NAICS2017, "238140")),
        ((Standards.SIC, "1742"), (Standards.NAICS2017, "238310")),
        ((Standards.SIC, "1743"), (Standards.NAICS2017, "238310")),
        ((Standards.SIC, "1743"), (Standards.NAICS2017, "238340")),
        ((Standards.SIC, "1751"), (Standards.NAICS2017, "238130")),
        ((Standards.SIC, "1751"), (Standards.NAICS2017, "238350")),
        ((Standards.SIC, "1752"), (Standards.NAICS2017, "238310")),
        ((Standards.SIC, "1752"), (Standards.NAICS2017, "238330")),
        ((Standards.SIC, "1761"), (Standards.NAICS2017, "238160")),
        ((Standards.SIC, "1761"), (Standards.NAICS2017, "238170")),
        ((Standards.SIC, "1761"), (Standards.NAICS2017, "238390")),
        ((Standards.SIC, "1771"), (Standards.NAICS2017, "238110")),
        ((Standards.SIC, "1771"), (Standards.NAICS2017, "238140")),
        ((Standards.SIC, "1771"), (Standards.NAICS2017, "238990")),
        ((Standards.SIC, "1781"), (Standards.NAICS2017, "237110")),
        ((Standards.SIC, "1791"), (Standards.NAICS2017, "238120")),
        ((Standards.SIC, "1791"), (Standards.NAICS2017, "238190")),
        ((Standards.SIC, "1791"), (Standards.NAICS2017, "238220")),
        ((Standards.SIC, "1791"), (Standards.NAICS2017, "238310")),
        ((Standards.SIC, "1793"), (Standards.NAICS2017, "238150")),
        ((Standards.SIC, "1794"), (Standards.NAICS2017, "238910")),
        ((Standards.SIC, "1795"), (Standards.NAICS2017, "238910")),
        ((Standards.SIC, "1796"), (Standards.NAICS2017, "238220")),
        ((Standards.SIC, "1796"), (Standards.NAICS2017, "238290")),
        ((Standards.SIC, "1799"), (Standards.NAICS2017, "236220")),
        ((Standards.SIC, "1799"), (Standards.NAICS2017, "237990")),
        ((Standards.SIC, "1799"), (Standards.NAICS2017, "238150")),
        ((Standards.SIC, "1799"), (Standards.NAICS2017, "238190")),
        ((Standards.SIC, "1799"), (Standards.NAICS2017, "238290")),
        ((Standards.SIC, "1799"), (Standards.NAICS2017, "238310")),
        ((Standards.SIC, "1799"), (Standards.NAICS2017, "238320")),
        ((Standards.SIC, "1799"), (Standards.NAICS2017, "238350")),
        ((Standards.SIC, "1799"), (Standards.NAICS2017, "238390")),
        ((Standards.SIC, "1799"), (Standards.NAICS2017, "238910")),
        ((Standards.SIC, "1799"), (Standards.NAICS2017, "238990")),
        ((Standards.SIC, "1799"), (Standards.NAICS2017, "561790")),
        ((Standards.SIC, "1799"), (Standards.NAICS2017, "562910")),
        ((Standards.SIC, "2011"), (Standards.NAICS2017, "311611")),
        ((Standards.SIC, "2013"), (Standards.NAICS2017, "311612")),
        ((Standards.SIC, "2013"), (Standards.NAICS2017, "311613")),
        ((Standards.SIC, "2015"), (Standards.NAICS2017, "311615")),
        ((Standards.SIC, "2015"), (Standards.NAICS2017, "311999")),
        ((Standards.SIC, "2021"), (Standards.NAICS2017, "311512")),
        ((Standards.SIC, "2022"), (Standards.NAICS2017, "311513")),
        ((Standards.SIC, "2023"), (Standards.NAICS2017, "311511")),
        ((Standards.SIC, "2023"), (Standards.NAICS2017, "311514")),
        ((Standards.SIC, "2024"), (Standards.NAICS2017, "311520")),
        ((Standards.SIC, "2026"), (Standards.NAICS2017, "311511")),
        ((Standards.SIC, "2026"), (Standards.NAICS2017, "311514")),
        ((Standards.SIC, "2032"), (Standards.NAICS2017, "311422")),
        ((Standards.SIC, "2032"), (Standards.NAICS2017, "311999")),
        ((Standards.SIC, "2033"), (Standards.NAICS2017, "311421")),
        ((Standards.SIC, "2034"), (Standards.NAICS2017, "311211")),
        ((Standards.SIC, "2034"), (Standards.NAICS2017, "311423")),
        ((Standards.SIC, "2034"), (Standards.NAICS2017, "311999")),
        ((Standards.SIC, "2035"), (Standards.NAICS2017, "311421")),
        ((Standards.SIC, "2035"), (Standards.NAICS2017, "311941")),
        ((Standards.SIC, "2037"), (Standards.NAICS2017, "311411")),
        ((Standards.SIC, "2038"), (Standards.NAICS2017, "311412")),
        ((Standards.SIC, "2041"), (Standards.NAICS2017, "311211")),
        ((Standards.SIC, "2043"), (Standards.NAICS2017, "311230")),
        ((Standards.SIC, "2043"), (Standards.NAICS2017, "311920")),
        ((Standards.SIC, "2044"), (Standards.NAICS2017, "311212")),
        ((Standards.SIC, "2045"), (Standards.NAICS2017, "311824")),
        ((Standards.SIC, "2046"), (Standards.NAICS2017, "311221")),
        ((Standards.SIC, "2046"), (Standards.NAICS2017, "311225")),
        ((Standards.SIC, "2047"), (Standards.NAICS2017, "311111")),
        ((Standards.SIC, "2048"), (Standards.NAICS2017, "311119")),
        ((Standards.SIC, "2048"), (Standards.NAICS2017, "311611")),
        ((Standards.SIC, "2051"), (Standards.NAICS2017, "311812")),
        ((Standards.SIC, "2052"), (Standards.NAICS2017, "311812")),
        ((Standards.SIC, "2052"), (Standards.NAICS2017, "311821")),
        ((Standards.SIC, "2052"), (Standards.NAICS2017, "311919")),
        ((Standards.SIC, "2053"), (Standards.NAICS2017, "311813")),
        ((Standards.SIC, "2061"), (Standards.NAICS2017, "311314")),
        ((Standards.SIC, "2062"), (Standards.NAICS2017, "311314")),
        ((Standards.SIC, "2063"), (Standards.NAICS2017, "311313")),
        ((Standards.SIC, "2064"), (Standards.NAICS2017, "311340")),
        ((Standards.SIC, "2064"), (Standards.NAICS2017, "311352")),
        ((Standards.SIC, "2066"), (Standards.NAICS2017, "311351")),
        ((Standards.SIC, "2066"), (Standards.NAICS2017, "311352")),
        ((Standards.SIC, "2067"), (Standards.NAICS2017, "311340")),
        ((Standards.SIC, "2068"), (Standards.NAICS2017, "311911")),
        ((Standards.SIC, "2074"), (Standards.NAICS2017, "311224")),
        ((Standards.SIC, "2074"), (Standards.NAICS2017, "311225")),
        ((Standards.SIC, "2075"), (Standards.NAICS2017, "311224")),
        ((Standards.SIC, "2075"), (Standards.NAICS2017, "311225")),
        ((Standards.SIC, "2076"), (Standards.NAICS2017, "311224")),
        ((Standards.SIC, "2076"), (Standards.NAICS2017, "311225")),
        ((Standards.SIC, "2077"), (Standards.NAICS2017, "311613")),
        ((Standards.SIC, "2077"), (Standards.NAICS2017, "311710")),
        ((Standards.SIC, "2079"), (Standards.NAICS2017, "311224")),
        ((Standards.SIC, "2079"), (Standards.NAICS2017, "311225")),
        ((Standards.SIC, "2082"), (Standards.NAICS2017, "311942")),
        ((Standards.SIC, "2082"), (Standards.NAICS2017, "312120")),
        ((Standards.SIC, "2083"), (Standards.NAICS2017, "311213")),
        ((Standards.SIC, "2084"), (Standards.NAICS2017, "312130")),
        ((Standards.SIC, "2085"), (Standards.NAICS2017, "312130")),
        ((Standards.SIC, "2085"), (Standards.NAICS2017, "312140")),
        ((Standards.SIC, "2086"), (Standards.NAICS2017, "312111")),
        ((Standards.SIC, "2086"), (Standards.NAICS2017, "312112")),
        ((Standards.SIC, "2087"), (Standards.NAICS2017, "311920")),
        ((Standards.SIC, "2087"), (Standards.NAICS2017, "311930")),
        ((Standards.SIC, "2087"), (Standards.NAICS2017, "311942")),
        ((Standards.SIC, "2087"), (Standards.NAICS2017, "311999")),
        ((Standards.SIC, "2091"), (Standards.NAICS2017, "311710")),
        ((Standards.SIC, "2092"), (Standards.NAICS2017, "311710")),
        ((Standards.SIC, "2095"), (Standards.NAICS2017, "311920")),
        ((Standards.SIC, "2096"), (Standards.NAICS2017, "311919")),
        ((Standards.SIC, "2097"), (Standards.NAICS2017, "312113")),
        ((Standards.SIC, "2098"), (Standards.NAICS2017, "311824")),
        ((Standards.SIC, "2099"), (Standards.NAICS2017, "111998")),
        ((Standards.SIC, "2099"), (Standards.NAICS2017, "112519")),
        ((Standards.SIC, "2099"), (Standards.NAICS2017, "311212")),
        ((Standards.SIC, "2099"), (Standards.NAICS2017, "311340")),
        ((Standards.SIC, "2099"), (Standards.NAICS2017, "311423")),
        ((Standards.SIC, "2099"), (Standards.NAICS2017, "311824")),
        ((Standards.SIC, "2099"), (Standards.NAICS2017, "311830")),
        ((Standards.SIC, "2099"), (Standards.NAICS2017, "311911")),
        ((Standards.SIC, "2099"), (Standards.NAICS2017, "311920")),
        ((Standards.SIC, "2099"), (Standards.NAICS2017, "311941")),
        ((Standards.SIC, "2099"), (Standards.NAICS2017, "311942")),
        ((Standards.SIC, "2099"), (Standards.NAICS2017, "311991")),
        ((Standards.SIC, "2099"), (Standards.NAICS2017, "311999")),
        ((Standards.SIC, "2111"), (Standards.NAICS2017, "312230")),
        ((Standards.SIC, "2121"), (Standards.NAICS2017, "312230")),
        ((Standards.SIC, "2131"), (Standards.NAICS2017, "312230")),
        ((Standards.SIC, "2141"), (Standards.NAICS2017, "312230")),
        ((Standards.SIC, "2211"), (Standards.NAICS2017, "313210")),
        ((Standards.SIC, "2221"), (Standards.NAICS2017, "313210")),
        ((Standards.SIC, "2231"), (Standards.NAICS2017, "313210")),
        ((Standards.SIC, "2231"), (Standards.NAICS2017, "313310")),
        ((Standards.SIC, "2241"), (Standards.NAICS2017, "313220")),
        ((Standards.SIC, "2251"), (Standards.NAICS2017, "313310")),
        ((Standards.SIC, "2251"), (Standards.NAICS2017, "315110")),
        ((Standards.SIC, "2252"), (Standards.NAICS2017, "313310")),
        ((Standards.SIC, "2252"), (Standards.NAICS2017, "315110")),
        ((Standards.SIC, "2253"), (Standards.NAICS2017, "313310")),
        ((Standards.SIC, "2253"), (Standards.NAICS2017, "315190")),
        ((Standards.SIC, "2254"), (Standards.NAICS2017, "313310")),
        ((Standards.SIC, "2254"), (Standards.NAICS2017, "315190")),
        ((Standards.SIC, "2257"), (Standards.NAICS2017, "313240")),
        ((Standards.SIC, "2257"), (Standards.NAICS2017, "313310")),
        ((Standards.SIC, "2258"), (Standards.NAICS2017, "313240")),
        ((Standards.SIC, "2258"), (Standards.NAICS2017, "313310")),
        ((Standards.SIC, "2259"), (Standards.NAICS2017, "313240")),
        ((Standards.SIC, "2259"), (Standards.NAICS2017, "313310")),
        ((Standards.SIC, "2259"), (Standards.NAICS2017, "315190")),
        ((Standards.SIC, "2261"), (Standards.NAICS2017, "313310")),
        ((Standards.SIC, "2262"), (Standards.NAICS2017, "313310")),
        ((Standards.SIC, "2269"), (Standards.NAICS2017, "313310")),
        ((Standards.SIC, "2273"), (Standards.NAICS2017, "314110")),
        ((Standards.SIC, "2281"), (Standards.NAICS2017, "313110")),
        ((Standards.SIC, "2282"), (Standards.NAICS2017, "313110")),
        ((Standards.SIC, "2284"), (Standards.NAICS2017, "313110")),
        ((Standards.SIC, "2284"), (Standards.NAICS2017, "313310")),
        ((Standards.SIC, "2295"), (Standards.NAICS2017, "313320")),
        ((Standards.SIC, "2296"), (Standards.NAICS2017, "314994")),
        ((Standards.SIC, "2297"), (Standards.NAICS2017, "313230")),
        ((Standards.SIC, "2298"), (Standards.NAICS2017, "313110")),
        ((Standards.SIC, "2298"), (Standards.NAICS2017, "314994")),
        ((Standards.SIC, "2299"), (Standards.NAICS2017, "313110")),
        ((Standards.SIC, "2299"), (Standards.NAICS2017, "313210")),
        ((Standards.SIC, "2299"), (Standards.NAICS2017, "313220")),
        ((Standards.SIC, "2299"), (Standards.NAICS2017, "313230")),
        ((Standards.SIC, "2299"), (Standards.NAICS2017, "313310")),
        ((Standards.SIC, "2299"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2311"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2311"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2311"), (Standards.NAICS2017, "315220")),
        ((Standards.SIC, "2321"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2321"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2321"), (Standards.NAICS2017, "315220")),
        ((Standards.SIC, "2322"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2322"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2322"), (Standards.NAICS2017, "315220")),
        ((Standards.SIC, "2323"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2323"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2323"), (Standards.NAICS2017, "315990")),
        ((Standards.SIC, "2325"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2325"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2325"), (Standards.NAICS2017, "315220")),
        ((Standards.SIC, "2326"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2326"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2326"), (Standards.NAICS2017, "315220")),
        ((Standards.SIC, "2329"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2329"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2329"), (Standards.NAICS2017, "315220")),
        ((Standards.SIC, "2329"), (Standards.NAICS2017, "315280")),
        ((Standards.SIC, "2331"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2331"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2331"), (Standards.NAICS2017, "315240")),
        ((Standards.SIC, "2335"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2335"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2335"), (Standards.NAICS2017, "315240")),
        ((Standards.SIC, "2337"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2337"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2337"), (Standards.NAICS2017, "315240")),
        ((Standards.SIC, "2339"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2339"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2339"), (Standards.NAICS2017, "315240")),
        ((Standards.SIC, "2339"), (Standards.NAICS2017, "315280")),
        ((Standards.SIC, "2339"), (Standards.NAICS2017, "315990")),
        ((Standards.SIC, "2341"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2341"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2341"), (Standards.NAICS2017, "315220")),
        ((Standards.SIC, "2341"), (Standards.NAICS2017, "315240")),
        ((Standards.SIC, "2342"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2342"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2342"), (Standards.NAICS2017, "315240")),
        ((Standards.SIC, "2353"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2353"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2353"), (Standards.NAICS2017, "315990")),
        ((Standards.SIC, "2361"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2361"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2361"), (Standards.NAICS2017, "315220")),
        ((Standards.SIC, "2361"), (Standards.NAICS2017, "315240")),
        ((Standards.SIC, "2369"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2369"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2369"), (Standards.NAICS2017, "315220")),
        ((Standards.SIC, "2369"), (Standards.NAICS2017, "315240")),
        ((Standards.SIC, "2371"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2371"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2371"), (Standards.NAICS2017, "315280")),
        ((Standards.SIC, "2381"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2381"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2381"), (Standards.NAICS2017, "315990")),
        ((Standards.SIC, "2384"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2384"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2384"), (Standards.NAICS2017, "315220")),
        ((Standards.SIC, "2384"), (Standards.NAICS2017, "315240")),
        ((Standards.SIC, "2385"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2385"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2385"), (Standards.NAICS2017, "315220")),
        ((Standards.SIC, "2385"), (Standards.NAICS2017, "315240")),
        ((Standards.SIC, "2385"), (Standards.NAICS2017, "315280")),
        ((Standards.SIC, "2385"), (Standards.NAICS2017, "315990")),
        ((Standards.SIC, "2386"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2386"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2386"), (Standards.NAICS2017, "315280")),
        ((Standards.SIC, "2387"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2387"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2387"), (Standards.NAICS2017, "315990")),
        ((Standards.SIC, "2389"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2389"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2389"), (Standards.NAICS2017, "315240")),
        ((Standards.SIC, "2389"), (Standards.NAICS2017, "315280")),
        ((Standards.SIC, "2389"), (Standards.NAICS2017, "315990")),
        ((Standards.SIC, "2391"), (Standards.NAICS2017, "314120")),
        ((Standards.SIC, "2392"), (Standards.NAICS2017, "314120")),
        ((Standards.SIC, "2392"), (Standards.NAICS2017, "314910")),
        ((Standards.SIC, "2392"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2392"), (Standards.NAICS2017, "339994")),
        ((Standards.SIC, "2393"), (Standards.NAICS2017, "314910")),
        ((Standards.SIC, "2394"), (Standards.NAICS2017, "314910")),
        ((Standards.SIC, "2395"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2395"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2396"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2396"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2396"), (Standards.NAICS2017, "315990")),
        ((Standards.SIC, "2396"), (Standards.NAICS2017, "323113")),
        ((Standards.SIC, "2396"), (Standards.NAICS2017, "336360")),
        ((Standards.SIC, "2397"), (Standards.NAICS2017, "313220")),
        ((Standards.SIC, "2399"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "2399"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "2399"), (Standards.NAICS2017, "315990")),
        ((Standards.SIC, "2399"), (Standards.NAICS2017, "336360")),
        ((Standards.SIC, "2411"), (Standards.NAICS2017, "113310")),
        ((Standards.SIC, "2421"), (Standards.NAICS2017, "321113")),
        ((Standards.SIC, "2421"), (Standards.NAICS2017, "321912")),
        ((Standards.SIC, "2421"), (Standards.NAICS2017, "321918")),
        ((Standards.SIC, "2421"), (Standards.NAICS2017, "321920")),
        ((Standards.SIC, "2421"), (Standards.NAICS2017, "321999")),
        ((Standards.SIC, "2426"), (Standards.NAICS2017, "321113")),
        ((Standards.SIC, "2426"), (Standards.NAICS2017, "321912")),
        ((Standards.SIC, "2426"), (Standards.NAICS2017, "321918")),
        ((Standards.SIC, "2426"), (Standards.NAICS2017, "337215")),
        ((Standards.SIC, "2429"), (Standards.NAICS2017, "321113")),
        ((Standards.SIC, "2429"), (Standards.NAICS2017, "321920")),
        ((Standards.SIC, "2429"), (Standards.NAICS2017, "321999")),
        ((Standards.SIC, "2431"), (Standards.NAICS2017, "321911")),
        ((Standards.SIC, "2431"), (Standards.NAICS2017, "321918")),
        ((Standards.SIC, "2434"), (Standards.NAICS2017, "337110")),
        ((Standards.SIC, "2435"), (Standards.NAICS2017, "321211")),
        ((Standards.SIC, "2436"), (Standards.NAICS2017, "321212")),
        ((Standards.SIC, "2439"), (Standards.NAICS2017, "321213")),
        ((Standards.SIC, "2439"), (Standards.NAICS2017, "321214")),
        ((Standards.SIC, "2441"), (Standards.NAICS2017, "321920")),
        ((Standards.SIC, "2448"), (Standards.NAICS2017, "321920")),
        ((Standards.SIC, "2449"), (Standards.NAICS2017, "321920")),
        ((Standards.SIC, "2451"), (Standards.NAICS2017, "321991")),
        ((Standards.SIC, "2452"), (Standards.NAICS2017, "321992")),
        ((Standards.SIC, "2491"), (Standards.NAICS2017, "321114")),
        ((Standards.SIC, "2493"), (Standards.NAICS2017, "321219")),
        ((Standards.SIC, "2499"), (Standards.NAICS2017, "321920")),
        ((Standards.SIC, "2499"), (Standards.NAICS2017, "321999")),
        ((Standards.SIC, "2499"), (Standards.NAICS2017, "333415")),
        ((Standards.SIC, "2499"), (Standards.NAICS2017, "337125")),
        ((Standards.SIC, "2499"), (Standards.NAICS2017, "339113")),
        ((Standards.SIC, "2499"), (Standards.NAICS2017, "339999")),
        ((Standards.SIC, "2511"), (Standards.NAICS2017, "337122")),
        ((Standards.SIC, "2511"), (Standards.NAICS2017, "337215")),
        ((Standards.SIC, "2512"), (Standards.NAICS2017, "337121")),
        ((Standards.SIC, "2514"), (Standards.NAICS2017, "337121")),
        ((Standards.SIC, "2514"), (Standards.NAICS2017, "337124")),
        ((Standards.SIC, "2514"), (Standards.NAICS2017, "337215")),
        ((Standards.SIC, "2515"), (Standards.NAICS2017, "337121")),
        ((Standards.SIC, "2515"), (Standards.NAICS2017, "337910")),
        ((Standards.SIC, "2517"), (Standards.NAICS2017, "321999")),
        ((Standards.SIC, "2519"), (Standards.NAICS2017, "337125")),
        ((Standards.SIC, "2521"), (Standards.NAICS2017, "337211")),
        ((Standards.SIC, "2522"), (Standards.NAICS2017, "337214")),
        ((Standards.SIC, "2531"), (Standards.NAICS2017, "336360")),
        ((Standards.SIC, "2531"), (Standards.NAICS2017, "337127")),
        ((Standards.SIC, "2531"), (Standards.NAICS2017, "339940")),
        ((Standards.SIC, "2541"), (Standards.NAICS2017, "337110")),
        ((Standards.SIC, "2541"), (Standards.NAICS2017, "337127")),
        ((Standards.SIC, "2541"), (Standards.NAICS2017, "337212")),
        ((Standards.SIC, "2541"), (Standards.NAICS2017, "337215")),
        ((Standards.SIC, "2542"), (Standards.NAICS2017, "337127")),
        ((Standards.SIC, "2542"), (Standards.NAICS2017, "337215")),
        ((Standards.SIC, "2591"), (Standards.NAICS2017, "337920")),
        ((Standards.SIC, "2599"), (Standards.NAICS2017, "333249")),
        ((Standards.SIC, "2599"), (Standards.NAICS2017, "333415")),
        ((Standards.SIC, "2599"), (Standards.NAICS2017, "333994")),
        ((Standards.SIC, "2599"), (Standards.NAICS2017, "333997")),
        ((Standards.SIC, "2599"), (Standards.NAICS2017, "333999")),
        ((Standards.SIC, "2599"), (Standards.NAICS2017, "337127")),
        ((Standards.SIC, "2599"), (Standards.NAICS2017, "339113")),
        ((Standards.SIC, "2611"), (Standards.NAICS2017, "322110")),
        ((Standards.SIC, "2611"), (Standards.NAICS2017, "322121")),
        ((Standards.SIC, "2611"), (Standards.NAICS2017, "322122")),
        ((Standards.SIC, "2611"), (Standards.NAICS2017, "322130")),
        ((Standards.SIC, "2621"), (Standards.NAICS2017, "322121")),
        ((Standards.SIC, "2621"), (Standards.NAICS2017, "322122")),
        ((Standards.SIC, "2631"), (Standards.NAICS2017, "322130")),
        ((Standards.SIC, "2652"), (Standards.NAICS2017, "322219")),
        ((Standards.SIC, "2653"), (Standards.NAICS2017, "322211")),
        ((Standards.SIC, "2655"), (Standards.NAICS2017, "322219")),
        ((Standards.SIC, "2656"), (Standards.NAICS2017, "322219")),
        ((Standards.SIC, "2657"), (Standards.NAICS2017, "322212")),
        ((Standards.SIC, "2671"), (Standards.NAICS2017, "322220")),
        ((Standards.SIC, "2671"), (Standards.NAICS2017, "326112")),
        ((Standards.SIC, "2672"), (Standards.NAICS2017, "322220")),
        ((Standards.SIC, "2673"), (Standards.NAICS2017, "322220")),
        ((Standards.SIC, "2673"), (Standards.NAICS2017, "326111")),
        ((Standards.SIC, "2674"), (Standards.NAICS2017, "322220")),
        ((Standards.SIC, "2675"), (Standards.NAICS2017, "322220")),
        ((Standards.SIC, "2675"), (Standards.NAICS2017, "322230")),
        ((Standards.SIC, "2675"), (Standards.NAICS2017, "322299")),
        ((Standards.SIC, "2676"), (Standards.NAICS2017, "322291")),
        ((Standards.SIC, "2677"), (Standards.NAICS2017, "322230")),
        ((Standards.SIC, "2678"), (Standards.NAICS2017, "322230")),
        ((Standards.SIC, "2679"), (Standards.NAICS2017, "322211")),
        ((Standards.SIC, "2679"), (Standards.NAICS2017, "322220")),
        ((Standards.SIC, "2679"), (Standards.NAICS2017, "322230")),
        ((Standards.SIC, "2679"), (Standards.NAICS2017, "322299")),
        ((Standards.SIC, "2711"), (Standards.NAICS2017, "511110")),
        ((Standards.SIC, "2711"), (Standards.NAICS2017, "519130")),
        ((Standards.SIC, "2721"), (Standards.NAICS2017, "511120")),
        ((Standards.SIC, "2721"), (Standards.NAICS2017, "519130")),
        ((Standards.SIC, "2731"), (Standards.NAICS2017, "511130")),
        ((Standards.SIC, "2731"), (Standards.NAICS2017, "512230")),
        ((Standards.SIC, "2731"), (Standards.NAICS2017, "519130")),
        ((Standards.SIC, "2732"), (Standards.NAICS2017, "323117")),
        ((Standards.SIC, "2741"), (Standards.NAICS2017, "511120")),
        ((Standards.SIC, "2741"), (Standards.NAICS2017, "511130")),
        ((Standards.SIC, "2741"), (Standards.NAICS2017, "511140")),
        ((Standards.SIC, "2741"), (Standards.NAICS2017, "511199")),
        ((Standards.SIC, "2741"), (Standards.NAICS2017, "512230")),
        ((Standards.SIC, "2741"), (Standards.NAICS2017, "519130")),
        ((Standards.SIC, "2752"), (Standards.NAICS2017, "323111")),
        ((Standards.SIC, "2754"), (Standards.NAICS2017, "323111")),
        ((Standards.SIC, "2759"), (Standards.NAICS2017, "323111")),
        ((Standards.SIC, "2759"), (Standards.NAICS2017, "323113")),
        ((Standards.SIC, "2761"), (Standards.NAICS2017, "323111")),
        ((Standards.SIC, "2771"), (Standards.NAICS2017, "323111")),
        ((Standards.SIC, "2771"), (Standards.NAICS2017, "323113")),
        ((Standards.SIC, "2771"), (Standards.NAICS2017, "511191")),
        ((Standards.SIC, "2771"), (Standards.NAICS2017, "519130")),
        ((Standards.SIC, "2782"), (Standards.NAICS2017, "323111")),
        ((Standards.SIC, "2789"), (Standards.NAICS2017, "323120")),
        ((Standards.SIC, "2791"), (Standards.NAICS2017, "323120")),
        ((Standards.SIC, "2796"), (Standards.NAICS2017, "323120")),
        ((Standards.SIC, "2812"), (Standards.NAICS2017, "325180")),
        ((Standards.SIC, "2813"), (Standards.NAICS2017, "325120")),
        ((Standards.SIC, "2816"), (Standards.NAICS2017, "325130")),
        ((Standards.SIC, "2816"), (Standards.NAICS2017, "325180")),
        ((Standards.SIC, "2819"), (Standards.NAICS2017, "211130")),
        ((Standards.SIC, "2819"), (Standards.NAICS2017, "325130")),
        ((Standards.SIC, "2819"), (Standards.NAICS2017, "325180")),
        ((Standards.SIC, "2819"), (Standards.NAICS2017, "325998")),
        ((Standards.SIC, "2819"), (Standards.NAICS2017, "331313")),
        ((Standards.SIC, "2821"), (Standards.NAICS2017, "325211")),
        ((Standards.SIC, "2822"), (Standards.NAICS2017, "325212")),
        ((Standards.SIC, "2823"), (Standards.NAICS2017, "325220")),
        ((Standards.SIC, "2824"), (Standards.NAICS2017, "325220")),
        ((Standards.SIC, "2833"), (Standards.NAICS2017, "325411")),
        ((Standards.SIC, "2834"), (Standards.NAICS2017, "325412")),
        ((Standards.SIC, "2835"), (Standards.NAICS2017, "325412")),
        ((Standards.SIC, "2835"), (Standards.NAICS2017, "325413")),
        ((Standards.SIC, "2836"), (Standards.NAICS2017, "325414")),
        ((Standards.SIC, "2841"), (Standards.NAICS2017, "325611")),
        ((Standards.SIC, "2842"), (Standards.NAICS2017, "325612")),
        ((Standards.SIC, "2843"), (Standards.NAICS2017, "325613")),
        ((Standards.SIC, "2844"), (Standards.NAICS2017, "325611")),
        ((Standards.SIC, "2844"), (Standards.NAICS2017, "325620")),
        ((Standards.SIC, "2851"), (Standards.NAICS2017, "325510")),
        ((Standards.SIC, "2861"), (Standards.NAICS2017, "325194")),
        ((Standards.SIC, "2865"), (Standards.NAICS2017, "325110")),
        ((Standards.SIC, "2865"), (Standards.NAICS2017, "325130")),
        ((Standards.SIC, "2865"), (Standards.NAICS2017, "325194")),
        ((Standards.SIC, "2869"), (Standards.NAICS2017, "325110")),
        ((Standards.SIC, "2869"), (Standards.NAICS2017, "325120")),
        ((Standards.SIC, "2869"), (Standards.NAICS2017, "325180")),
        ((Standards.SIC, "2869"), (Standards.NAICS2017, "325193")),
        ((Standards.SIC, "2869"), (Standards.NAICS2017, "325194")),
        ((Standards.SIC, "2869"), (Standards.NAICS2017, "325199")),
        ((Standards.SIC, "2869"), (Standards.NAICS2017, "325998")),
        ((Standards.SIC, "2873"), (Standards.NAICS2017, "325311")),
        ((Standards.SIC, "2874"), (Standards.NAICS2017, "325312")),
        ((Standards.SIC, "2875"), (Standards.NAICS2017, "325314")),
        ((Standards.SIC, "2879"), (Standards.NAICS2017, "325320")),
        ((Standards.SIC, "2891"), (Standards.NAICS2017, "325520")),
        ((Standards.SIC, "2892"), (Standards.NAICS2017, "325920")),
        ((Standards.SIC, "2893"), (Standards.NAICS2017, "325910")),
        ((Standards.SIC, "2895"), (Standards.NAICS2017, "325180")),
        ((Standards.SIC, "2899"), (Standards.NAICS2017, "311942")),
        ((Standards.SIC, "2899"), (Standards.NAICS2017, "325199")),
        ((Standards.SIC, "2899"), (Standards.NAICS2017, "325510")),
        ((Standards.SIC, "2899"), (Standards.NAICS2017, "325998")),
        ((Standards.SIC, "2911"), (Standards.NAICS2017, "324110")),
        ((Standards.SIC, "2951"), (Standards.NAICS2017, "324121")),
        ((Standards.SIC, "2952"), (Standards.NAICS2017, "324122")),
        ((Standards.SIC, "2992"), (Standards.NAICS2017, "324191")),
        ((Standards.SIC, "2999"), (Standards.NAICS2017, "324199")),
        ((Standards.SIC, "3011"), (Standards.NAICS2017, "326211")),
        ((Standards.SIC, "3021"), (Standards.NAICS2017, "316210")),
        ((Standards.SIC, "3052"), (Standards.NAICS2017, "326220")),
        ((Standards.SIC, "3053"), (Standards.NAICS2017, "339991")),
        ((Standards.SIC, "3061"), (Standards.NAICS2017, "326291")),
        ((Standards.SIC, "3061"), (Standards.NAICS2017, "326299")),
        ((Standards.SIC, "3069"), (Standards.NAICS2017, "313320")),
        ((Standards.SIC, "3069"), (Standards.NAICS2017, "314910")),
        ((Standards.SIC, "3069"), (Standards.NAICS2017, "315280")),
        ((Standards.SIC, "3069"), (Standards.NAICS2017, "315990")),
        ((Standards.SIC, "3069"), (Standards.NAICS2017, "326199")),
        ((Standards.SIC, "3069"), (Standards.NAICS2017, "326299")),
        ((Standards.SIC, "3069"), (Standards.NAICS2017, "336612")),
        ((Standards.SIC, "3069"), (Standards.NAICS2017, "339113")),
        ((Standards.SIC, "3069"), (Standards.NAICS2017, "339920")),
        ((Standards.SIC, "3069"), (Standards.NAICS2017, "339930")),
        ((Standards.SIC, "3081"), (Standards.NAICS2017, "326113")),
        ((Standards.SIC, "3082"), (Standards.NAICS2017, "326121")),
        ((Standards.SIC, "3083"), (Standards.NAICS2017, "326130")),
        ((Standards.SIC, "3084"), (Standards.NAICS2017, "326122")),
        ((Standards.SIC, "3085"), (Standards.NAICS2017, "326160")),
        ((Standards.SIC, "3086"), (Standards.NAICS2017, "326140")),
        ((Standards.SIC, "3086"), (Standards.NAICS2017, "326150")),
        ((Standards.SIC, "3087"), (Standards.NAICS2017, "325991")),
        ((Standards.SIC, "3088"), (Standards.NAICS2017, "326191")),
        ((Standards.SIC, "3089"), (Standards.NAICS2017, "326121")),
        ((Standards.SIC, "3089"), (Standards.NAICS2017, "326122")),
        ((Standards.SIC, "3089"), (Standards.NAICS2017, "326199")),
        ((Standards.SIC, "3089"), (Standards.NAICS2017, "336612")),
        ((Standards.SIC, "3089"), (Standards.NAICS2017, "337215")),
        ((Standards.SIC, "3089"), (Standards.NAICS2017, "339113")),
        ((Standards.SIC, "3111"), (Standards.NAICS2017, "316110")),
        ((Standards.SIC, "3131"), (Standards.NAICS2017, "316998")),
        ((Standards.SIC, "3131"), (Standards.NAICS2017, "321999")),
        ((Standards.SIC, "3131"), (Standards.NAICS2017, "339993")),
        ((Standards.SIC, "3142"), (Standards.NAICS2017, "316210")),
        ((Standards.SIC, "3143"), (Standards.NAICS2017, "316210")),
        ((Standards.SIC, "3144"), (Standards.NAICS2017, "316210")),
        ((Standards.SIC, "3149"), (Standards.NAICS2017, "316210")),
        ((Standards.SIC, "3151"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "3151"), (Standards.NAICS2017, "315210")),
        ((Standards.SIC, "3151"), (Standards.NAICS2017, "315990")),
        ((Standards.SIC, "3161"), (Standards.NAICS2017, "316998")),
        ((Standards.SIC, "3171"), (Standards.NAICS2017, "316992")),
        ((Standards.SIC, "3172"), (Standards.NAICS2017, "316998")),
        ((Standards.SIC, "3172"), (Standards.NAICS2017, "339910")),
        ((Standards.SIC, "3199"), (Standards.NAICS2017, "316998")),
        ((Standards.SIC, "3211"), (Standards.NAICS2017, "327211")),
        ((Standards.SIC, "3221"), (Standards.NAICS2017, "327213")),
        ((Standards.SIC, "3229"), (Standards.NAICS2017, "327212")),
        ((Standards.SIC, "3231"), (Standards.NAICS2017, "327215")),
        ((Standards.SIC, "3241"), (Standards.NAICS2017, "327310")),
        ((Standards.SIC, "3251"), (Standards.NAICS2017, "327120")),
        ((Standards.SIC, "3251"), (Standards.NAICS2017, "327331")),
        ((Standards.SIC, "3253"), (Standards.NAICS2017, "327120")),
        ((Standards.SIC, "3255"), (Standards.NAICS2017, "327120")),
        ((Standards.SIC, "3259"), (Standards.NAICS2017, "327120")),
        ((Standards.SIC, "3261"), (Standards.NAICS2017, "327110")),
        ((Standards.SIC, "3262"), (Standards.NAICS2017, "327110")),
        ((Standards.SIC, "3263"), (Standards.NAICS2017, "327110")),
        ((Standards.SIC, "3264"), (Standards.NAICS2017, "327110")),
        ((Standards.SIC, "3269"), (Standards.NAICS2017, "327110")),
        ((Standards.SIC, "3271"), (Standards.NAICS2017, "327331")),
        ((Standards.SIC, "3272"), (Standards.NAICS2017, "327332")),
        ((Standards.SIC, "3272"), (Standards.NAICS2017, "327390")),
        ((Standards.SIC, "3272"), (Standards.NAICS2017, "327999")),
        ((Standards.SIC, "3273"), (Standards.NAICS2017, "327320")),
        ((Standards.SIC, "3274"), (Standards.NAICS2017, "327410")),
        ((Standards.SIC, "3275"), (Standards.NAICS2017, "327420")),
        ((Standards.SIC, "3281"), (Standards.NAICS2017, "327991")),
        ((Standards.SIC, "3291"), (Standards.NAICS2017, "327910")),
        ((Standards.SIC, "3291"), (Standards.NAICS2017, "332999")),
        ((Standards.SIC, "3292"), (Standards.NAICS2017, "327999")),
        ((Standards.SIC, "3292"), (Standards.NAICS2017, "336340")),
        ((Standards.SIC, "3292"), (Standards.NAICS2017, "336350")),
        ((Standards.SIC, "3295"), (Standards.NAICS2017, "212324")),
        ((Standards.SIC, "3295"), (Standards.NAICS2017, "212325")),
        ((Standards.SIC, "3295"), (Standards.NAICS2017, "212393")),
        ((Standards.SIC, "3295"), (Standards.NAICS2017, "212399")),
        ((Standards.SIC, "3295"), (Standards.NAICS2017, "327992")),
        ((Standards.SIC, "3296"), (Standards.NAICS2017, "327993")),
        ((Standards.SIC, "3297"), (Standards.NAICS2017, "327120")),
        ((Standards.SIC, "3299"), (Standards.NAICS2017, "327110")),
        ((Standards.SIC, "3299"), (Standards.NAICS2017, "327420")),
        ((Standards.SIC, "3299"), (Standards.NAICS2017, "327999")),
        ((Standards.SIC, "3312"), (Standards.NAICS2017, "324199")),
        ((Standards.SIC, "3312"), (Standards.NAICS2017, "331110")),
        ((Standards.SIC, "3312"), (Standards.NAICS2017, "331221")),
        ((Standards.SIC, "3313"), (Standards.NAICS2017, "331110")),
        ((Standards.SIC, "3315"), (Standards.NAICS2017, "331222")),
        ((Standards.SIC, "3315"), (Standards.NAICS2017, "332618")),
        ((Standards.SIC, "3316"), (Standards.NAICS2017, "331221")),
        ((Standards.SIC, "3317"), (Standards.NAICS2017, "331210")),
        ((Standards.SIC, "3321"), (Standards.NAICS2017, "331511")),
        ((Standards.SIC, "3322"), (Standards.NAICS2017, "331511")),
        ((Standards.SIC, "3324"), (Standards.NAICS2017, "331512")),
        ((Standards.SIC, "3325"), (Standards.NAICS2017, "331513")),
        ((Standards.SIC, "3331"), (Standards.NAICS2017, "331410")),
        ((Standards.SIC, "3334"), (Standards.NAICS2017, "331313")),
        ((Standards.SIC, "3339"), (Standards.NAICS2017, "331410")),
        ((Standards.SIC, "3341"), (Standards.NAICS2017, "331314")),
        ((Standards.SIC, "3341"), (Standards.NAICS2017, "331420")),
        ((Standards.SIC, "3341"), (Standards.NAICS2017, "331492")),
        ((Standards.SIC, "3351"), (Standards.NAICS2017, "331420")),
        ((Standards.SIC, "3353"), (Standards.NAICS2017, "331315")),
        ((Standards.SIC, "3354"), (Standards.NAICS2017, "331318")),
        ((Standards.SIC, "3355"), (Standards.NAICS2017, "331318")),
        ((Standards.SIC, "3356"), (Standards.NAICS2017, "331491")),
        ((Standards.SIC, "3357"), (Standards.NAICS2017, "331318")),
        ((Standards.SIC, "3357"), (Standards.NAICS2017, "331420")),
        ((Standards.SIC, "3357"), (Standards.NAICS2017, "331491")),
        ((Standards.SIC, "3357"), (Standards.NAICS2017, "335921")),
        ((Standards.SIC, "3357"), (Standards.NAICS2017, "335929")),
        ((Standards.SIC, "3363"), (Standards.NAICS2017, "331523")),
        ((Standards.SIC, "3364"), (Standards.NAICS2017, "331523")),
        ((Standards.SIC, "3365"), (Standards.NAICS2017, "331524")),
        ((Standards.SIC, "3366"), (Standards.NAICS2017, "331529")),
        ((Standards.SIC, "3369"), (Standards.NAICS2017, "331529")),
        ((Standards.SIC, "3398"), (Standards.NAICS2017, "332811")),
        ((Standards.SIC, "3399"), (Standards.NAICS2017, "331110")),
        ((Standards.SIC, "3399"), (Standards.NAICS2017, "331221")),
        ((Standards.SIC, "3399"), (Standards.NAICS2017, "331314")),
        ((Standards.SIC, "3399"), (Standards.NAICS2017, "331420")),
        ((Standards.SIC, "3399"), (Standards.NAICS2017, "331492")),
        ((Standards.SIC, "3399"), (Standards.NAICS2017, "332618")),
        ((Standards.SIC, "3399"), (Standards.NAICS2017, "332813")),
        ((Standards.SIC, "3411"), (Standards.NAICS2017, "332431")),
        ((Standards.SIC, "3412"), (Standards.NAICS2017, "332439")),
        ((Standards.SIC, "3421"), (Standards.NAICS2017, "332215")),
        ((Standards.SIC, "3421"), (Standards.NAICS2017, "332216")),
        ((Standards.SIC, "3423"), (Standards.NAICS2017, "332216")),
        ((Standards.SIC, "3425"), (Standards.NAICS2017, "332216")),
        ((Standards.SIC, "3429"), (Standards.NAICS2017, "332439")),
        ((Standards.SIC, "3429"), (Standards.NAICS2017, "332510")),
        ((Standards.SIC, "3429"), (Standards.NAICS2017, "332722")),
        ((Standards.SIC, "3429"), (Standards.NAICS2017, "332919")),
        ((Standards.SIC, "3429"), (Standards.NAICS2017, "332999")),
        ((Standards.SIC, "3429"), (Standards.NAICS2017, "333923")),
        ((Standards.SIC, "3429"), (Standards.NAICS2017, "334519")),
        ((Standards.SIC, "3429"), (Standards.NAICS2017, "336390")),
        ((Standards.SIC, "3429"), (Standards.NAICS2017, "337215")),
        ((Standards.SIC, "3431"), (Standards.NAICS2017, "332999")),
        ((Standards.SIC, "3432"), (Standards.NAICS2017, "332913")),
        ((Standards.SIC, "3432"), (Standards.NAICS2017, "332919")),
        ((Standards.SIC, "3432"), (Standards.NAICS2017, "332999")),
        ((Standards.SIC, "3433"), (Standards.NAICS2017, "333414")),
        ((Standards.SIC, "3441"), (Standards.NAICS2017, "332312")),
        ((Standards.SIC, "3442"), (Standards.NAICS2017, "332321")),
        ((Standards.SIC, "3443"), (Standards.NAICS2017, "332313")),
        ((Standards.SIC, "3443"), (Standards.NAICS2017, "332410")),
        ((Standards.SIC, "3443"), (Standards.NAICS2017, "332420")),
        ((Standards.SIC, "3443"), (Standards.NAICS2017, "333415")),
        ((Standards.SIC, "3444"), (Standards.NAICS2017, "332321")),
        ((Standards.SIC, "3444"), (Standards.NAICS2017, "332322")),
        ((Standards.SIC, "3444"), (Standards.NAICS2017, "332439")),
        ((Standards.SIC, "3444"), (Standards.NAICS2017, "333415")),
        ((Standards.SIC, "3446"), (Standards.NAICS2017, "332323")),
        ((Standards.SIC, "3448"), (Standards.NAICS2017, "332311")),
        ((Standards.SIC, "3449"), (Standards.NAICS2017, "332114")),
        ((Standards.SIC, "3449"), (Standards.NAICS2017, "332312")),
        ((Standards.SIC, "3449"), (Standards.NAICS2017, "332323")),
        ((Standards.SIC, "3451"), (Standards.NAICS2017, "332721")),
        ((Standards.SIC, "3452"), (Standards.NAICS2017, "332722")),
        ((Standards.SIC, "3462"), (Standards.NAICS2017, "332111")),
        ((Standards.SIC, "3463"), (Standards.NAICS2017, "332112")),
        ((Standards.SIC, "3465"), (Standards.NAICS2017, "336370")),
        ((Standards.SIC, "3466"), (Standards.NAICS2017, "332119")),
        ((Standards.SIC, "3469"), (Standards.NAICS2017, "332119")),
        ((Standards.SIC, "3469"), (Standards.NAICS2017, "332215")),
        ((Standards.SIC, "3469"), (Standards.NAICS2017, "332439")),
        ((Standards.SIC, "3471"), (Standards.NAICS2017, "332813")),
        ((Standards.SIC, "3479"), (Standards.NAICS2017, "332812")),
        ((Standards.SIC, "3479"), (Standards.NAICS2017, "339910")),
        ((Standards.SIC, "3482"), (Standards.NAICS2017, "332992")),
        ((Standards.SIC, "3483"), (Standards.NAICS2017, "332993")),
        ((Standards.SIC, "3484"), (Standards.NAICS2017, "332994")),
        ((Standards.SIC, "3489"), (Standards.NAICS2017, "332994")),
        ((Standards.SIC, "3491"), (Standards.NAICS2017, "332911")),
        ((Standards.SIC, "3492"), (Standards.NAICS2017, "332912")),
        ((Standards.SIC, "3493"), (Standards.NAICS2017, "332613")),
        ((Standards.SIC, "3494"), (Standards.NAICS2017, "332919")),
        ((Standards.SIC, "3494"), (Standards.NAICS2017, "332999")),
        ((Standards.SIC, "3495"), (Standards.NAICS2017, "332613")),
        ((Standards.SIC, "3495"), (Standards.NAICS2017, "334519")),
        ((Standards.SIC, "3496"), (Standards.NAICS2017, "332215")),
        ((Standards.SIC, "3496"), (Standards.NAICS2017, "332618")),
        ((Standards.SIC, "3496"), (Standards.NAICS2017, "333924")),
        ((Standards.SIC, "3497"), (Standards.NAICS2017, "322220")),
        ((Standards.SIC, "3497"), (Standards.NAICS2017, "332999")),
        ((Standards.SIC, "3498"), (Standards.NAICS2017, "332996")),
        ((Standards.SIC, "3499"), (Standards.NAICS2017, "332117")),
        ((Standards.SIC, "3499"), (Standards.NAICS2017, "332439")),
        ((Standards.SIC, "3499"), (Standards.NAICS2017, "332510")),
        ((Standards.SIC, "3499"), (Standards.NAICS2017, "332919")),
        ((Standards.SIC, "3499"), (Standards.NAICS2017, "332999")),
        ((Standards.SIC, "3499"), (Standards.NAICS2017, "336360")),
        ((Standards.SIC, "3499"), (Standards.NAICS2017, "337215")),
        ((Standards.SIC, "3511"), (Standards.NAICS2017, "333611")),
        ((Standards.SIC, "3519"), (Standards.NAICS2017, "333618")),
        ((Standards.SIC, "3519"), (Standards.NAICS2017, "336390")),
        ((Standards.SIC, "3523"), (Standards.NAICS2017, "332216")),
        ((Standards.SIC, "3523"), (Standards.NAICS2017, "332323")),
        ((Standards.SIC, "3523"), (Standards.NAICS2017, "333111")),
        ((Standards.SIC, "3523"), (Standards.NAICS2017, "333922")),
        ((Standards.SIC, "3524"), (Standards.NAICS2017, "332216")),
        ((Standards.SIC, "3524"), (Standards.NAICS2017, "333112")),
        ((Standards.SIC, "3531"), (Standards.NAICS2017, "333120")),
        ((Standards.SIC, "3531"), (Standards.NAICS2017, "333923")),
        ((Standards.SIC, "3531"), (Standards.NAICS2017, "336510")),
        ((Standards.SIC, "3532"), (Standards.NAICS2017, "333131")),
        ((Standards.SIC, "3533"), (Standards.NAICS2017, "333132")),
        ((Standards.SIC, "3534"), (Standards.NAICS2017, "333921")),
        ((Standards.SIC, "3535"), (Standards.NAICS2017, "333922")),
        ((Standards.SIC, "3536"), (Standards.NAICS2017, "333923")),
        ((Standards.SIC, "3537"), (Standards.NAICS2017, "332439")),
        ((Standards.SIC, "3537"), (Standards.NAICS2017, "332999")),
        ((Standards.SIC, "3537"), (Standards.NAICS2017, "333924")),
        ((Standards.SIC, "3541"), (Standards.NAICS2017, "333517")),
        ((Standards.SIC, "3542"), (Standards.NAICS2017, "333517")),
        ((Standards.SIC, "3543"), (Standards.NAICS2017, "332999")),
        ((Standards.SIC, "3544"), (Standards.NAICS2017, "333511")),
        ((Standards.SIC, "3544"), (Standards.NAICS2017, "333514")),
        ((Standards.SIC, "3545"), (Standards.NAICS2017, "332216")),
        ((Standards.SIC, "3545"), (Standards.NAICS2017, "333515")),
        ((Standards.SIC, "3546"), (Standards.NAICS2017, "333991")),
        ((Standards.SIC, "3547"), (Standards.NAICS2017, "333519")),
        ((Standards.SIC, "3548"), (Standards.NAICS2017, "333992")),
        ((Standards.SIC, "3548"), (Standards.NAICS2017, "335311")),
        ((Standards.SIC, "3549"), (Standards.NAICS2017, "333519")),
        ((Standards.SIC, "3552"), (Standards.NAICS2017, "333249")),
        ((Standards.SIC, "3553"), (Standards.NAICS2017, "333243")),
        ((Standards.SIC, "3554"), (Standards.NAICS2017, "333243")),
        ((Standards.SIC, "3555"), (Standards.NAICS2017, "333244")),
        ((Standards.SIC, "3556"), (Standards.NAICS2017, "333241")),
        ((Standards.SIC, "3559"), (Standards.NAICS2017, "332410")),
        ((Standards.SIC, "3559"), (Standards.NAICS2017, "333111")),
        ((Standards.SIC, "3559"), (Standards.NAICS2017, "333242")),
        ((Standards.SIC, "3559"), (Standards.NAICS2017, "333249")),
        ((Standards.SIC, "3559"), (Standards.NAICS2017, "333318")),
        ((Standards.SIC, "3561"), (Standards.NAICS2017, "333914")),
        ((Standards.SIC, "3562"), (Standards.NAICS2017, "332991")),
        ((Standards.SIC, "3563"), (Standards.NAICS2017, "333912")),
        ((Standards.SIC, "3564"), (Standards.NAICS2017, "333413")),
        ((Standards.SIC, "3565"), (Standards.NAICS2017, "333993")),
        ((Standards.SIC, "3566"), (Standards.NAICS2017, "333612")),
        ((Standards.SIC, "3567"), (Standards.NAICS2017, "333994")),
        ((Standards.SIC, "3568"), (Standards.NAICS2017, "333613")),
        ((Standards.SIC, "3569"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "3569"), (Standards.NAICS2017, "333414")),
        ((Standards.SIC, "3569"), (Standards.NAICS2017, "333999")),
        ((Standards.SIC, "3571"), (Standards.NAICS2017, "334111")),
        ((Standards.SIC, "3572"), (Standards.NAICS2017, "334112")),
        ((Standards.SIC, "3575"), (Standards.NAICS2017, "334118")),
        ((Standards.SIC, "3577"), (Standards.NAICS2017, "333316")),
        ((Standards.SIC, "3577"), (Standards.NAICS2017, "334118")),
        ((Standards.SIC, "3577"), (Standards.NAICS2017, "334418")),
        ((Standards.SIC, "3577"), (Standards.NAICS2017, "334613")),
        ((Standards.SIC, "3578"), (Standards.NAICS2017, "333316")),
        ((Standards.SIC, "3578"), (Standards.NAICS2017, "333318")),
        ((Standards.SIC, "3578"), (Standards.NAICS2017, "334118")),
        ((Standards.SIC, "3579"), (Standards.NAICS2017, "333318")),
        ((Standards.SIC, "3579"), (Standards.NAICS2017, "334519")),
        ((Standards.SIC, "3579"), (Standards.NAICS2017, "339940")),
        ((Standards.SIC, "3581"), (Standards.NAICS2017, "333318")),
        ((Standards.SIC, "3582"), (Standards.NAICS2017, "333318")),
        ((Standards.SIC, "3585"), (Standards.NAICS2017, "333415")),
        ((Standards.SIC, "3585"), (Standards.NAICS2017, "336390")),
        ((Standards.SIC, "3586"), (Standards.NAICS2017, "333914")),
        ((Standards.SIC, "3589"), (Standards.NAICS2017, "333318")),
        ((Standards.SIC, "3592"), (Standards.NAICS2017, "336310")),
        ((Standards.SIC, "3593"), (Standards.NAICS2017, "333995")),
        ((Standards.SIC, "3594"), (Standards.NAICS2017, "333996")),
        ((Standards.SIC, "3596"), (Standards.NAICS2017, "333997")),
        ((Standards.SIC, "3599"), (Standards.NAICS2017, "332710")),
        ((Standards.SIC, "3599"), (Standards.NAICS2017, "332813")),
        ((Standards.SIC, "3599"), (Standards.NAICS2017, "332999")),
        ((Standards.SIC, "3599"), (Standards.NAICS2017, "333318")),
        ((Standards.SIC, "3599"), (Standards.NAICS2017, "333999")),
        ((Standards.SIC, "3599"), (Standards.NAICS2017, "334519")),
        ((Standards.SIC, "3599"), (Standards.NAICS2017, "336390")),
        ((Standards.SIC, "3612"), (Standards.NAICS2017, "335311")),
        ((Standards.SIC, "3613"), (Standards.NAICS2017, "335313")),
        ((Standards.SIC, "3621"), (Standards.NAICS2017, "335312")),
        ((Standards.SIC, "3624"), (Standards.NAICS2017, "335991")),
        ((Standards.SIC, "3625"), (Standards.NAICS2017, "335314")),
        ((Standards.SIC, "3629"), (Standards.NAICS2017, "335999")),
        ((Standards.SIC, "3631"), (Standards.NAICS2017, "335220")),
        ((Standards.SIC, "3632"), (Standards.NAICS2017, "335220")),
        ((Standards.SIC, "3633"), (Standards.NAICS2017, "335220")),
        ((Standards.SIC, "3634"), (Standards.NAICS2017, "333414")),
        ((Standards.SIC, "3634"), (Standards.NAICS2017, "335210")),
        ((Standards.SIC, "3634"), (Standards.NAICS2017, "339999")),
        ((Standards.SIC, "3635"), (Standards.NAICS2017, "335210")),
        ((Standards.SIC, "3639"), (Standards.NAICS2017, "333249")),
        ((Standards.SIC, "3639"), (Standards.NAICS2017, "335210")),
        ((Standards.SIC, "3639"), (Standards.NAICS2017, "335220")),
        ((Standards.SIC, "3641"), (Standards.NAICS2017, "335110")),
        ((Standards.SIC, "3643"), (Standards.NAICS2017, "335931")),
        ((Standards.SIC, "3644"), (Standards.NAICS2017, "332216")),
        ((Standards.SIC, "3644"), (Standards.NAICS2017, "335932")),
        ((Standards.SIC, "3645"), (Standards.NAICS2017, "335121")),
        ((Standards.SIC, "3646"), (Standards.NAICS2017, "335122")),
        ((Standards.SIC, "3647"), (Standards.NAICS2017, "336320")),
        ((Standards.SIC, "3648"), (Standards.NAICS2017, "335129")),
        ((Standards.SIC, "3651"), (Standards.NAICS2017, "334310")),
        ((Standards.SIC, "3652"), (Standards.NAICS2017, "334614")),
        ((Standards.SIC, "3652"), (Standards.NAICS2017, "512250")),
        ((Standards.SIC, "3661"), (Standards.NAICS2017, "334210")),
        ((Standards.SIC, "3661"), (Standards.NAICS2017, "334418")),
        ((Standards.SIC, "3663"), (Standards.NAICS2017, "334220")),
        ((Standards.SIC, "3663"), (Standards.NAICS2017, "334515")),
        ((Standards.SIC, "3669"), (Standards.NAICS2017, "334290")),
        ((Standards.SIC, "3671"), (Standards.NAICS2017, "334419")),
        ((Standards.SIC, "3672"), (Standards.NAICS2017, "334412")),
        ((Standards.SIC, "3674"), (Standards.NAICS2017, "334413")),
        ((Standards.SIC, "3675"), (Standards.NAICS2017, "334416")),
        ((Standards.SIC, "3676"), (Standards.NAICS2017, "334416")),
        ((Standards.SIC, "3677"), (Standards.NAICS2017, "334416")),
        ((Standards.SIC, "3678"), (Standards.NAICS2017, "334417")),
        ((Standards.SIC, "3679"), (Standards.NAICS2017, "334220")),
        ((Standards.SIC, "3679"), (Standards.NAICS2017, "334310")),
        ((Standards.SIC, "3679"), (Standards.NAICS2017, "334418")),
        ((Standards.SIC, "3679"), (Standards.NAICS2017, "334419")),
        ((Standards.SIC, "3679"), (Standards.NAICS2017, "334515")),
        ((Standards.SIC, "3691"), (Standards.NAICS2017, "335911")),
        ((Standards.SIC, "3692"), (Standards.NAICS2017, "335912")),
        ((Standards.SIC, "3694"), (Standards.NAICS2017, "336320")),
        ((Standards.SIC, "3695"), (Standards.NAICS2017, "334613")),
        ((Standards.SIC, "3699"), (Standards.NAICS2017, "333318")),
        ((Standards.SIC, "3699"), (Standards.NAICS2017, "333618")),
        ((Standards.SIC, "3699"), (Standards.NAICS2017, "333992")),
        ((Standards.SIC, "3699"), (Standards.NAICS2017, "335129")),
        ((Standards.SIC, "3699"), (Standards.NAICS2017, "335999")),
        ((Standards.SIC, "3711"), (Standards.NAICS2017, "336111")),
        ((Standards.SIC, "3711"), (Standards.NAICS2017, "336112")),
        ((Standards.SIC, "3711"), (Standards.NAICS2017, "336120")),
        ((Standards.SIC, "3711"), (Standards.NAICS2017, "336211")),
        ((Standards.SIC, "3711"), (Standards.NAICS2017, "336992")),
        ((Standards.SIC, "3713"), (Standards.NAICS2017, "336211")),
        ((Standards.SIC, "3714"), (Standards.NAICS2017, "336211")),
        ((Standards.SIC, "3714"), (Standards.NAICS2017, "336310")),
        ((Standards.SIC, "3714"), (Standards.NAICS2017, "336320")),
        ((Standards.SIC, "3714"), (Standards.NAICS2017, "336330")),
        ((Standards.SIC, "3714"), (Standards.NAICS2017, "336340")),
        ((Standards.SIC, "3714"), (Standards.NAICS2017, "336350")),
        ((Standards.SIC, "3714"), (Standards.NAICS2017, "336390")),
        ((Standards.SIC, "3715"), (Standards.NAICS2017, "336212")),
        ((Standards.SIC, "3716"), (Standards.NAICS2017, "336213")),
        ((Standards.SIC, "3721"), (Standards.NAICS2017, "336411")),
        ((Standards.SIC, "3721"), (Standards.NAICS2017, "541713")),
        ((Standards.SIC, "3724"), (Standards.NAICS2017, "336412")),
        ((Standards.SIC, "3724"), (Standards.NAICS2017, "541713")),
        ((Standards.SIC, "3728"), (Standards.NAICS2017, "332912")),
        ((Standards.SIC, "3728"), (Standards.NAICS2017, "336411")),
        ((Standards.SIC, "3728"), (Standards.NAICS2017, "336413")),
        ((Standards.SIC, "3728"), (Standards.NAICS2017, "541713")),
        ((Standards.SIC, "3731"), (Standards.NAICS2017, "336611")),
        ((Standards.SIC, "3731"), (Standards.NAICS2017, "488390")),
        ((Standards.SIC, "3732"), (Standards.NAICS2017, "336612")),
        ((Standards.SIC, "3732"), (Standards.NAICS2017, "811490")),
        ((Standards.SIC, "3743"), (Standards.NAICS2017, "333914")),
        ((Standards.SIC, "3743"), (Standards.NAICS2017, "336510")),
        ((Standards.SIC, "3751"), (Standards.NAICS2017, "336991")),
        ((Standards.SIC, "3761"), (Standards.NAICS2017, "336414")),
        ((Standards.SIC, "3761"), (Standards.NAICS2017, "541713")),
        ((Standards.SIC, "3764"), (Standards.NAICS2017, "336415")),
        ((Standards.SIC, "3764"), (Standards.NAICS2017, "541713")),
        ((Standards.SIC, "3769"), (Standards.NAICS2017, "336419")),
        ((Standards.SIC, "3769"), (Standards.NAICS2017, "541713")),
        ((Standards.SIC, "3792"), (Standards.NAICS2017, "336214")),
        ((Standards.SIC, "3795"), (Standards.NAICS2017, "336992")),
        ((Standards.SIC, "3799"), (Standards.NAICS2017, "333924")),
        ((Standards.SIC, "3799"), (Standards.NAICS2017, "336214")),
        ((Standards.SIC, "3799"), (Standards.NAICS2017, "336390")),
        ((Standards.SIC, "3799"), (Standards.NAICS2017, "336999")),
        ((Standards.SIC, "3812"), (Standards.NAICS2017, "334511")),
        ((Standards.SIC, "3821"), (Standards.NAICS2017, "333249")),
        ((Standards.SIC, "3821"), (Standards.NAICS2017, "333415")),
        ((Standards.SIC, "3821"), (Standards.NAICS2017, "333994")),
        ((Standards.SIC, "3821"), (Standards.NAICS2017, "333997")),
        ((Standards.SIC, "3821"), (Standards.NAICS2017, "333999")),
        ((Standards.SIC, "3821"), (Standards.NAICS2017, "337127")),
        ((Standards.SIC, "3821"), (Standards.NAICS2017, "339113")),
        ((Standards.SIC, "3822"), (Standards.NAICS2017, "334512")),
        ((Standards.SIC, "3823"), (Standards.NAICS2017, "334513")),
        ((Standards.SIC, "3824"), (Standards.NAICS2017, "334514")),
        ((Standards.SIC, "3825"), (Standards.NAICS2017, "334514")),
        ((Standards.SIC, "3825"), (Standards.NAICS2017, "334515")),
        ((Standards.SIC, "3826"), (Standards.NAICS2017, "334516")),
        ((Standards.SIC, "3827"), (Standards.NAICS2017, "333314")),
        ((Standards.SIC, "3829"), (Standards.NAICS2017, "334514")),
        ((Standards.SIC, "3829"), (Standards.NAICS2017, "334519")),
        ((Standards.SIC, "3829"), (Standards.NAICS2017, "339112")),
        ((Standards.SIC, "3841"), (Standards.NAICS2017, "332994")),
        ((Standards.SIC, "3841"), (Standards.NAICS2017, "333249")),
        ((Standards.SIC, "3841"), (Standards.NAICS2017, "333415")),
        ((Standards.SIC, "3841"), (Standards.NAICS2017, "333994")),
        ((Standards.SIC, "3841"), (Standards.NAICS2017, "333997")),
        ((Standards.SIC, "3841"), (Standards.NAICS2017, "333999")),
        ((Standards.SIC, "3841"), (Standards.NAICS2017, "337127")),
        ((Standards.SIC, "3841"), (Standards.NAICS2017, "339112")),
        ((Standards.SIC, "3841"), (Standards.NAICS2017, "339113")),
        ((Standards.SIC, "3842"), (Standards.NAICS2017, "322291")),
        ((Standards.SIC, "3842"), (Standards.NAICS2017, "334510")),
        ((Standards.SIC, "3842"), (Standards.NAICS2017, "339113")),
        ((Standards.SIC, "3842"), (Standards.NAICS2017, "339999")),
        ((Standards.SIC, "3843"), (Standards.NAICS2017, "339114")),
        ((Standards.SIC, "3844"), (Standards.NAICS2017, "334517")),
        ((Standards.SIC, "3845"), (Standards.NAICS2017, "334510")),
        ((Standards.SIC, "3845"), (Standards.NAICS2017, "334517")),
        ((Standards.SIC, "3851"), (Standards.NAICS2017, "339113")),
        ((Standards.SIC, "3851"), (Standards.NAICS2017, "339115")),
        ((Standards.SIC, "3861"), (Standards.NAICS2017, "325992")),
        ((Standards.SIC, "3861"), (Standards.NAICS2017, "333316")),
        ((Standards.SIC, "3873"), (Standards.NAICS2017, "334519")),
        ((Standards.SIC, "3911"), (Standards.NAICS2017, "339910")),
        ((Standards.SIC, "3914"), (Standards.NAICS2017, "332215")),
        ((Standards.SIC, "3914"), (Standards.NAICS2017, "332999")),
        ((Standards.SIC, "3914"), (Standards.NAICS2017, "339910")),
        ((Standards.SIC, "3915"), (Standards.NAICS2017, "334519")),
        ((Standards.SIC, "3915"), (Standards.NAICS2017, "339910")),
        ((Standards.SIC, "3931"), (Standards.NAICS2017, "339992")),
        ((Standards.SIC, "3942"), (Standards.NAICS2017, "339930")),
        ((Standards.SIC, "3944"), (Standards.NAICS2017, "336991")),
        ((Standards.SIC, "3944"), (Standards.NAICS2017, "339930")),
        ((Standards.SIC, "3949"), (Standards.NAICS2017, "339920")),
        ((Standards.SIC, "3951"), (Standards.NAICS2017, "339940")),
        ((Standards.SIC, "3952"), (Standards.NAICS2017, "325998")),
        ((Standards.SIC, "3952"), (Standards.NAICS2017, "337127")),
        ((Standards.SIC, "3952"), (Standards.NAICS2017, "339940")),
        ((Standards.SIC, "3953"), (Standards.NAICS2017, "339940")),
        ((Standards.SIC, "3955"), (Standards.NAICS2017, "339940")),
        ((Standards.SIC, "3961"), (Standards.NAICS2017, "339910")),
        ((Standards.SIC, "3961"), (Standards.NAICS2017, "339993")),
        ((Standards.SIC, "3965"), (Standards.NAICS2017, "339993")),
        ((Standards.SIC, "3991"), (Standards.NAICS2017, "339994")),
        ((Standards.SIC, "3993"), (Standards.NAICS2017, "323113")),
        ((Standards.SIC, "3993"), (Standards.NAICS2017, "339950")),
        ((Standards.SIC, "3995"), (Standards.NAICS2017, "339995")),
        ((Standards.SIC, "3996"), (Standards.NAICS2017, "326199")),
        ((Standards.SIC, "3999"), (Standards.NAICS2017, "316110")),
        ((Standards.SIC, "3999"), (Standards.NAICS2017, "321999")),
        ((Standards.SIC, "3999"), (Standards.NAICS2017, "325998")),
        ((Standards.SIC, "3999"), (Standards.NAICS2017, "326199")),
        ((Standards.SIC, "3999"), (Standards.NAICS2017, "332215")),
        ((Standards.SIC, "3999"), (Standards.NAICS2017, "332216")),
        ((Standards.SIC, "3999"), (Standards.NAICS2017, "332812")),
        ((Standards.SIC, "3999"), (Standards.NAICS2017, "332999")),
        ((Standards.SIC, "3999"), (Standards.NAICS2017, "333318")),
        ((Standards.SIC, "3999"), (Standards.NAICS2017, "335121")),
        ((Standards.SIC, "3999"), (Standards.NAICS2017, "335210")),
        ((Standards.SIC, "3999"), (Standards.NAICS2017, "336612")),
        ((Standards.SIC, "3999"), (Standards.NAICS2017, "337127")),
        ((Standards.SIC, "3999"), (Standards.NAICS2017, "339930")),
        ((Standards.SIC, "3999"), (Standards.NAICS2017, "339999")),
        ((Standards.SIC, "4011"), (Standards.NAICS2017, "482111")),
        ((Standards.SIC, "4013"), (Standards.NAICS2017, "482112")),
        ((Standards.SIC, "4013"), (Standards.NAICS2017, "488210")),
        ((Standards.SIC, "4111"), (Standards.NAICS2017, "485111")),
        ((Standards.SIC, "4111"), (Standards.NAICS2017, "485112")),
        ((Standards.SIC, "4111"), (Standards.NAICS2017, "485113")),
        ((Standards.SIC, "4111"), (Standards.NAICS2017, "485119")),
        ((Standards.SIC, "4111"), (Standards.NAICS2017, "485999")),
        ((Standards.SIC, "4119"), (Standards.NAICS2017, "485320")),
        ((Standards.SIC, "4119"), (Standards.NAICS2017, "485410")),
        ((Standards.SIC, "4119"), (Standards.NAICS2017, "485991")),
        ((Standards.SIC, "4119"), (Standards.NAICS2017, "485999")),
        ((Standards.SIC, "4119"), (Standards.NAICS2017, "487110")),
        ((Standards.SIC, "4119"), (Standards.NAICS2017, "621910")),
        ((Standards.SIC, "4121"), (Standards.NAICS2017, "485310")),
        ((Standards.SIC, "4131"), (Standards.NAICS2017, "485210")),
        ((Standards.SIC, "4141"), (Standards.NAICS2017, "485510")),
        ((Standards.SIC, "4142"), (Standards.NAICS2017, "485510")),
        ((Standards.SIC, "4151"), (Standards.NAICS2017, "485410")),
        ((Standards.SIC, "4173"), (Standards.NAICS2017, "488490")),
        ((Standards.SIC, "4212"), (Standards.NAICS2017, "484110")),
        ((Standards.SIC, "4212"), (Standards.NAICS2017, "484210")),
        ((Standards.SIC, "4212"), (Standards.NAICS2017, "484220")),
        ((Standards.SIC, "4212"), (Standards.NAICS2017, "562111")),
        ((Standards.SIC, "4212"), (Standards.NAICS2017, "562112")),
        ((Standards.SIC, "4212"), (Standards.NAICS2017, "562119")),
        ((Standards.SIC, "4213"), (Standards.NAICS2017, "484121")),
        ((Standards.SIC, "4213"), (Standards.NAICS2017, "484122")),
        ((Standards.SIC, "4213"), (Standards.NAICS2017, "484210")),
        ((Standards.SIC, "4213"), (Standards.NAICS2017, "484230")),
        ((Standards.SIC, "4214"), (Standards.NAICS2017, "484110")),
        ((Standards.SIC, "4214"), (Standards.NAICS2017, "484210")),
        ((Standards.SIC, "4214"), (Standards.NAICS2017, "484220")),
        ((Standards.SIC, "4215"), (Standards.NAICS2017, "492110")),
        ((Standards.SIC, "4215"), (Standards.NAICS2017, "492210")),
        ((Standards.SIC, "4221"), (Standards.NAICS2017, "493130")),
        ((Standards.SIC, "4222"), (Standards.NAICS2017, "493120")),
        ((Standards.SIC, "4225"), (Standards.NAICS2017, "493110")),
        ((Standards.SIC, "4225"), (Standards.NAICS2017, "531130")),
        ((Standards.SIC, "4226"), (Standards.NAICS2017, "493110")),
        ((Standards.SIC, "4226"), (Standards.NAICS2017, "493120")),
        ((Standards.SIC, "4226"), (Standards.NAICS2017, "493190")),
        ((Standards.SIC, "4231"), (Standards.NAICS2017, "488490")),
        ((Standards.SIC, "4311"), (Standards.NAICS2017, "491110")),
        ((Standards.SIC, "4412"), (Standards.NAICS2017, "483111")),
        ((Standards.SIC, "4424"), (Standards.NAICS2017, "483113")),
        ((Standards.SIC, "4432"), (Standards.NAICS2017, "483113")),
        ((Standards.SIC, "4449"), (Standards.NAICS2017, "483211")),
        ((Standards.SIC, "4481"), (Standards.NAICS2017, "483112")),
        ((Standards.SIC, "4481"), (Standards.NAICS2017, "483114")),
        ((Standards.SIC, "4482"), (Standards.NAICS2017, "483114")),
        ((Standards.SIC, "4482"), (Standards.NAICS2017, "483212")),
        ((Standards.SIC, "4489"), (Standards.NAICS2017, "483212")),
        ((Standards.SIC, "4489"), (Standards.NAICS2017, "487210")),
        ((Standards.SIC, "4491"), (Standards.NAICS2017, "488310")),
        ((Standards.SIC, "4491"), (Standards.NAICS2017, "488320")),
        ((Standards.SIC, "4492"), (Standards.NAICS2017, "488330")),
        ((Standards.SIC, "4493"), (Standards.NAICS2017, "713930")),
        ((Standards.SIC, "4499"), (Standards.NAICS2017, "483211")),
        ((Standards.SIC, "4499"), (Standards.NAICS2017, "488310")),
        ((Standards.SIC, "4499"), (Standards.NAICS2017, "488330")),
        ((Standards.SIC, "4499"), (Standards.NAICS2017, "488390")),
        ((Standards.SIC, "4499"), (Standards.NAICS2017, "532411")),
        ((Standards.SIC, "4499"), (Standards.NAICS2017, "541990")),
        ((Standards.SIC, "4512"), (Standards.NAICS2017, "481111")),
        ((Standards.SIC, "4512"), (Standards.NAICS2017, "481112")),
        ((Standards.SIC, "4513"), (Standards.NAICS2017, "492110")),
        ((Standards.SIC, "4522"), (Standards.NAICS2017, "481211")),
        ((Standards.SIC, "4522"), (Standards.NAICS2017, "481212")),
        ((Standards.SIC, "4522"), (Standards.NAICS2017, "481219")),
        ((Standards.SIC, "4522"), (Standards.NAICS2017, "487990")),
        ((Standards.SIC, "4522"), (Standards.NAICS2017, "621910")),
        ((Standards.SIC, "4581"), (Standards.NAICS2017, "488111")),
        ((Standards.SIC, "4581"), (Standards.NAICS2017, "488119")),
        ((Standards.SIC, "4581"), (Standards.NAICS2017, "488190")),
        ((Standards.SIC, "4581"), (Standards.NAICS2017, "561720")),
        ((Standards.SIC, "4581"), (Standards.NAICS2017, "811420")),
        ((Standards.SIC, "4612"), (Standards.NAICS2017, "486110")),
        ((Standards.SIC, "4613"), (Standards.NAICS2017, "486910")),
        ((Standards.SIC, "4619"), (Standards.NAICS2017, "486990")),
        ((Standards.SIC, "4724"), (Standards.NAICS2017, "561510")),
        ((Standards.SIC, "4725"), (Standards.NAICS2017, "561520")),
        ((Standards.SIC, "4729"), (Standards.NAICS2017, "488999")),
        ((Standards.SIC, "4729"), (Standards.NAICS2017, "561599")),
        ((Standards.SIC, "4731"), (Standards.NAICS2017, "488510")),
        ((Standards.SIC, "4731"), (Standards.NAICS2017, "541614")),
        ((Standards.SIC, "4741"), (Standards.NAICS2017, "488210")),
        ((Standards.SIC, "4741"), (Standards.NAICS2017, "532411")),
        ((Standards.SIC, "4783"), (Standards.NAICS2017, "488991")),
        ((Standards.SIC, "4785"), (Standards.NAICS2017, "488390")),
        ((Standards.SIC, "4785"), (Standards.NAICS2017, "488490")),
        ((Standards.SIC, "4789"), (Standards.NAICS2017, "487110")),
        ((Standards.SIC, "4789"), (Standards.NAICS2017, "488210")),
        ((Standards.SIC, "4789"), (Standards.NAICS2017, "488999")),
        ((Standards.SIC, "4789"), (Standards.NAICS2017, "722310")),
        ((Standards.SIC, "4812"), (Standards.NAICS2017, "517312")),
        ((Standards.SIC, "4812"), (Standards.NAICS2017, "517911")),
        ((Standards.SIC, "4813"), (Standards.NAICS2017, "517311")),
        ((Standards.SIC, "4813"), (Standards.NAICS2017, "517911")),
        ((Standards.SIC, "4822"), (Standards.NAICS2017, "517311")),
        ((Standards.SIC, "4832"), (Standards.NAICS2017, "515111")),
        ((Standards.SIC, "4832"), (Standards.NAICS2017, "515112")),
        ((Standards.SIC, "4833"), (Standards.NAICS2017, "515120")),
        ((Standards.SIC, "4841"), (Standards.NAICS2017, "515210")),
        ((Standards.SIC, "4841"), (Standards.NAICS2017, "517311")),
        ((Standards.SIC, "4899"), (Standards.NAICS2017, "485310")),
        ((Standards.SIC, "4899"), (Standards.NAICS2017, "517312")),
        ((Standards.SIC, "4899"), (Standards.NAICS2017, "517410")),
        ((Standards.SIC, "4899"), (Standards.NAICS2017, "517919")),
        ((Standards.SIC, "4899"), (Standards.NAICS2017, "812990")),
        ((Standards.SIC, "4911"), (Standards.NAICS2017, "221111")),
        ((Standards.SIC, "4911"), (Standards.NAICS2017, "221112")),
        ((Standards.SIC, "4911"), (Standards.NAICS2017, "221113")),
        ((Standards.SIC, "4911"), (Standards.NAICS2017, "221114")),
        ((Standards.SIC, "4911"), (Standards.NAICS2017, "221115")),
        ((Standards.SIC, "4911"), (Standards.NAICS2017, "221116")),
        ((Standards.SIC, "4911"), (Standards.NAICS2017, "221117")),
        ((Standards.SIC, "4911"), (Standards.NAICS2017, "221118")),
        ((Standards.SIC, "4911"), (Standards.NAICS2017, "221121")),
        ((Standards.SIC, "4911"), (Standards.NAICS2017, "221122")),
        ((Standards.SIC, "4922"), (Standards.NAICS2017, "486210")),
        ((Standards.SIC, "4923"), (Standards.NAICS2017, "221210")),
        ((Standards.SIC, "4923"), (Standards.NAICS2017, "486210")),
        ((Standards.SIC, "4924"), (Standards.NAICS2017, "221210")),
        ((Standards.SIC, "4925"), (Standards.NAICS2017, "221210")),
        ((Standards.SIC, "4931"), (Standards.NAICS2017, "221111")),
        ((Standards.SIC, "4931"), (Standards.NAICS2017, "221112")),
        ((Standards.SIC, "4931"), (Standards.NAICS2017, "221113")),
        ((Standards.SIC, "4931"), (Standards.NAICS2017, "221114")),
        ((Standards.SIC, "4931"), (Standards.NAICS2017, "221115")),
        ((Standards.SIC, "4931"), (Standards.NAICS2017, "221116")),
        ((Standards.SIC, "4931"), (Standards.NAICS2017, "221117")),
        ((Standards.SIC, "4931"), (Standards.NAICS2017, "221118")),
        ((Standards.SIC, "4931"), (Standards.NAICS2017, "221121")),
        ((Standards.SIC, "4931"), (Standards.NAICS2017, "221122")),
        ((Standards.SIC, "4931"), (Standards.NAICS2017, "221210")),
        ((Standards.SIC, "4932"), (Standards.NAICS2017, "221210")),
        ((Standards.SIC, "4939"), (Standards.NAICS2017, "221111")),
        ((Standards.SIC, "4939"), (Standards.NAICS2017, "221112")),
        ((Standards.SIC, "4939"), (Standards.NAICS2017, "221113")),
        ((Standards.SIC, "4939"), (Standards.NAICS2017, "221114")),
        ((Standards.SIC, "4939"), (Standards.NAICS2017, "221115")),
        ((Standards.SIC, "4939"), (Standards.NAICS2017, "221116")),
        ((Standards.SIC, "4939"), (Standards.NAICS2017, "221117")),
        ((Standards.SIC, "4939"), (Standards.NAICS2017, "221118")),
        ((Standards.SIC, "4939"), (Standards.NAICS2017, "221121")),
        ((Standards.SIC, "4939"), (Standards.NAICS2017, "221122")),
        ((Standards.SIC, "4939"), (Standards.NAICS2017, "221210")),
        ((Standards.SIC, "4941"), (Standards.NAICS2017, "221310")),
        ((Standards.SIC, "4952"), (Standards.NAICS2017, "221320")),
        ((Standards.SIC, "4953"), (Standards.NAICS2017, "562211")),
        ((Standards.SIC, "4953"), (Standards.NAICS2017, "562212")),
        ((Standards.SIC, "4953"), (Standards.NAICS2017, "562213")),
        ((Standards.SIC, "4953"), (Standards.NAICS2017, "562219")),
        ((Standards.SIC, "4953"), (Standards.NAICS2017, "562920")),
        ((Standards.SIC, "4959"), (Standards.NAICS2017, "488119")),
        ((Standards.SIC, "4959"), (Standards.NAICS2017, "488490")),
        ((Standards.SIC, "4959"), (Standards.NAICS2017, "561710")),
        ((Standards.SIC, "4959"), (Standards.NAICS2017, "561790")),
        ((Standards.SIC, "4959"), (Standards.NAICS2017, "562910")),
        ((Standards.SIC, "4959"), (Standards.NAICS2017, "562998")),
        ((Standards.SIC, "4961"), (Standards.NAICS2017, "221330")),
        ((Standards.SIC, "4971"), (Standards.NAICS2017, "221310")),
        ((Standards.SIC, "5012"), (Standards.NAICS2017, "423110")),
        ((Standards.SIC, "5012"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5012"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5013"), (Standards.NAICS2017, "423120")),
        ((Standards.SIC, "5013"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5013"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5013"), (Standards.NAICS2017, "441310")),
        ((Standards.SIC, "5014"), (Standards.NAICS2017, "423130")),
        ((Standards.SIC, "5014"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5014"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5014"), (Standards.NAICS2017, "441320")),
        ((Standards.SIC, "5015"), (Standards.NAICS2017, "423140")),
        ((Standards.SIC, "5015"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5015"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5015"), (Standards.NAICS2017, "441310")),
        ((Standards.SIC, "5021"), (Standards.NAICS2017, "423210")),
        ((Standards.SIC, "5021"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5021"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5021"), (Standards.NAICS2017, "442110")),
        ((Standards.SIC, "5023"), (Standards.NAICS2017, "423220")),
        ((Standards.SIC, "5023"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5023"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5023"), (Standards.NAICS2017, "442210")),
        ((Standards.SIC, "5031"), (Standards.NAICS2017, "423310")),
        ((Standards.SIC, "5031"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5031"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5031"), (Standards.NAICS2017, "444110")),
        ((Standards.SIC, "5032"), (Standards.NAICS2017, "423320")),
        ((Standards.SIC, "5032"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5032"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5032"), (Standards.NAICS2017, "444190")),
        ((Standards.SIC, "5033"), (Standards.NAICS2017, "423330")),
        ((Standards.SIC, "5033"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5033"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5033"), (Standards.NAICS2017, "444190")),
        ((Standards.SIC, "5039"), (Standards.NAICS2017, "423310")),
        ((Standards.SIC, "5039"), (Standards.NAICS2017, "423390")),
        ((Standards.SIC, "5039"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5039"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5039"), (Standards.NAICS2017, "444190")),
        ((Standards.SIC, "5043"), (Standards.NAICS2017, "423410")),
        ((Standards.SIC, "5043"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5043"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5044"), (Standards.NAICS2017, "423420")),
        ((Standards.SIC, "5044"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5044"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5044"), (Standards.NAICS2017, "453210")),
        ((Standards.SIC, "5045"), (Standards.NAICS2017, "423430")),
        ((Standards.SIC, "5045"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5045"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5045"), (Standards.NAICS2017, "443142")),
        ((Standards.SIC, "5046"), (Standards.NAICS2017, "423440")),
        ((Standards.SIC, "5046"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5046"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5047"), (Standards.NAICS2017, "423450")),
        ((Standards.SIC, "5047"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5047"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5047"), (Standards.NAICS2017, "446199")),
        ((Standards.SIC, "5048"), (Standards.NAICS2017, "423460")),
        ((Standards.SIC, "5048"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5048"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5049"), (Standards.NAICS2017, "423490")),
        ((Standards.SIC, "5049"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5049"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5049"), (Standards.NAICS2017, "453210")),
        ((Standards.SIC, "5051"), (Standards.NAICS2017, "423510")),
        ((Standards.SIC, "5051"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5051"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5052"), (Standards.NAICS2017, "423520")),
        ((Standards.SIC, "5052"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5052"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5063"), (Standards.NAICS2017, "423610")),
        ((Standards.SIC, "5063"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5063"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5063"), (Standards.NAICS2017, "444190")),
        ((Standards.SIC, "5064"), (Standards.NAICS2017, "423620")),
        ((Standards.SIC, "5064"), (Standards.NAICS2017, "423720")),
        ((Standards.SIC, "5064"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5064"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5064"), (Standards.NAICS2017, "443141")),
        ((Standards.SIC, "5064"), (Standards.NAICS2017, "443142")),
        ((Standards.SIC, "5064"), (Standards.NAICS2017, "444190")),
        ((Standards.SIC, "5065"), (Standards.NAICS2017, "423690")),
        ((Standards.SIC, "5065"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5065"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5065"), (Standards.NAICS2017, "443142")),
        ((Standards.SIC, "5072"), (Standards.NAICS2017, "423710")),
        ((Standards.SIC, "5072"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5072"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5072"), (Standards.NAICS2017, "444130")),
        ((Standards.SIC, "5074"), (Standards.NAICS2017, "423620")),
        ((Standards.SIC, "5074"), (Standards.NAICS2017, "423720")),
        ((Standards.SIC, "5074"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5074"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5074"), (Standards.NAICS2017, "444190")),
        ((Standards.SIC, "5075"), (Standards.NAICS2017, "423730")),
        ((Standards.SIC, "5075"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5075"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5078"), (Standards.NAICS2017, "423740")),
        ((Standards.SIC, "5078"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5078"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5082"), (Standards.NAICS2017, "423810")),
        ((Standards.SIC, "5082"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5082"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5083"), (Standards.NAICS2017, "423820")),
        ((Standards.SIC, "5083"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5083"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5083"), (Standards.NAICS2017, "444210")),
        ((Standards.SIC, "5084"), (Standards.NAICS2017, "423830")),
        ((Standards.SIC, "5084"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5084"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5085"), (Standards.NAICS2017, "423830")),
        ((Standards.SIC, "5085"), (Standards.NAICS2017, "423840")),
        ((Standards.SIC, "5085"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5085"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5085"), (Standards.NAICS2017, "453998")),
        ((Standards.SIC, "5087"), (Standards.NAICS2017, "423850")),
        ((Standards.SIC, "5087"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5087"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5087"), (Standards.NAICS2017, "446120")),
        ((Standards.SIC, "5088"), (Standards.NAICS2017, "423860")),
        ((Standards.SIC, "5088"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5088"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5091"), (Standards.NAICS2017, "423910")),
        ((Standards.SIC, "5091"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5091"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5091"), (Standards.NAICS2017, "451110")),
        ((Standards.SIC, "5092"), (Standards.NAICS2017, "423920")),
        ((Standards.SIC, "5092"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5092"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5092"), (Standards.NAICS2017, "451120")),
        ((Standards.SIC, "5093"), (Standards.NAICS2017, "423930")),
        ((Standards.SIC, "5093"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5093"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5094"), (Standards.NAICS2017, "423940")),
        ((Standards.SIC, "5094"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5094"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5094"), (Standards.NAICS2017, "448310")),
        ((Standards.SIC, "5099"), (Standards.NAICS2017, "423990")),
        ((Standards.SIC, "5099"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5099"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5099"), (Standards.NAICS2017, "443142")),
        ((Standards.SIC, "5099"), (Standards.NAICS2017, "444190")),
        ((Standards.SIC, "5099"), (Standards.NAICS2017, "451110")),
        ((Standards.SIC, "5099"), (Standards.NAICS2017, "451120")),
        ((Standards.SIC, "5111"), (Standards.NAICS2017, "424110")),
        ((Standards.SIC, "5111"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5111"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5111"), (Standards.NAICS2017, "453210")),
        ((Standards.SIC, "5112"), (Standards.NAICS2017, "424120")),
        ((Standards.SIC, "5112"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5112"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5112"), (Standards.NAICS2017, "453210")),
        ((Standards.SIC, "5113"), (Standards.NAICS2017, "424130")),
        ((Standards.SIC, "5113"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5113"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5113"), (Standards.NAICS2017, "453998")),
        ((Standards.SIC, "5122"), (Standards.NAICS2017, "424210")),
        ((Standards.SIC, "5122"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5122"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5122"), (Standards.NAICS2017, "446110")),
        ((Standards.SIC, "5122"), (Standards.NAICS2017, "446120")),
        ((Standards.SIC, "5122"), (Standards.NAICS2017, "446191")),
        ((Standards.SIC, "5131"), (Standards.NAICS2017, "313310")),
        ((Standards.SIC, "5131"), (Standards.NAICS2017, "424310")),
        ((Standards.SIC, "5131"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5131"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5131"), (Standards.NAICS2017, "451130")),
        ((Standards.SIC, "5136"), (Standards.NAICS2017, "423910")),
        ((Standards.SIC, "5136"), (Standards.NAICS2017, "424320")),
        ((Standards.SIC, "5136"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5136"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5136"), (Standards.NAICS2017, "448110")),
        ((Standards.SIC, "5136"), (Standards.NAICS2017, "448190")),
        ((Standards.SIC, "5137"), (Standards.NAICS2017, "423910")),
        ((Standards.SIC, "5137"), (Standards.NAICS2017, "424330")),
        ((Standards.SIC, "5137"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5137"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5137"), (Standards.NAICS2017, "448120")),
        ((Standards.SIC, "5137"), (Standards.NAICS2017, "448130")),
        ((Standards.SIC, "5137"), (Standards.NAICS2017, "448190")),
        ((Standards.SIC, "5139"), (Standards.NAICS2017, "424340")),
        ((Standards.SIC, "5139"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5139"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5139"), (Standards.NAICS2017, "448210")),
        ((Standards.SIC, "5141"), (Standards.NAICS2017, "424410")),
        ((Standards.SIC, "5141"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5141"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5141"), (Standards.NAICS2017, "445110")),
        ((Standards.SIC, "5142"), (Standards.NAICS2017, "424420")),
        ((Standards.SIC, "5142"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5142"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5142"), (Standards.NAICS2017, "454390")),
        ((Standards.SIC, "5143"), (Standards.NAICS2017, "424430")),
        ((Standards.SIC, "5143"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5143"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5143"), (Standards.NAICS2017, "445299")),
        ((Standards.SIC, "5144"), (Standards.NAICS2017, "424440")),
        ((Standards.SIC, "5144"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5144"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5144"), (Standards.NAICS2017, "445210")),
        ((Standards.SIC, "5145"), (Standards.NAICS2017, "424450")),
        ((Standards.SIC, "5145"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5145"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5145"), (Standards.NAICS2017, "445292")),
        ((Standards.SIC, "5146"), (Standards.NAICS2017, "424460")),
        ((Standards.SIC, "5146"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5146"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5146"), (Standards.NAICS2017, "445220")),
        ((Standards.SIC, "5147"), (Standards.NAICS2017, "311612")),
        ((Standards.SIC, "5147"), (Standards.NAICS2017, "424470")),
        ((Standards.SIC, "5147"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5147"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5147"), (Standards.NAICS2017, "445210")),
        ((Standards.SIC, "5148"), (Standards.NAICS2017, "424480")),
        ((Standards.SIC, "5148"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5148"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5148"), (Standards.NAICS2017, "445230")),
        ((Standards.SIC, "5149"), (Standards.NAICS2017, "312112")),
        ((Standards.SIC, "5149"), (Standards.NAICS2017, "424490")),
        ((Standards.SIC, "5149"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5149"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5149"), (Standards.NAICS2017, "445299")),
        ((Standards.SIC, "5149"), (Standards.NAICS2017, "453910")),
        ((Standards.SIC, "5153"), (Standards.NAICS2017, "424510")),
        ((Standards.SIC, "5153"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5153"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5153"), (Standards.NAICS2017, "444220")),
        ((Standards.SIC, "5154"), (Standards.NAICS2017, "424520")),
        ((Standards.SIC, "5154"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5154"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5159"), (Standards.NAICS2017, "424590")),
        ((Standards.SIC, "5159"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5159"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5159"), (Standards.NAICS2017, "444220")),
        ((Standards.SIC, "5162"), (Standards.NAICS2017, "424610")),
        ((Standards.SIC, "5162"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5162"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5162"), (Standards.NAICS2017, "453998")),
        ((Standards.SIC, "5169"), (Standards.NAICS2017, "424690")),
        ((Standards.SIC, "5169"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5169"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5171"), (Standards.NAICS2017, "424710")),
        ((Standards.SIC, "5171"), (Standards.NAICS2017, "454310")),
        ((Standards.SIC, "5172"), (Standards.NAICS2017, "424720")),
        ((Standards.SIC, "5172"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5172"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5181"), (Standards.NAICS2017, "424810")),
        ((Standards.SIC, "5181"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5181"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5181"), (Standards.NAICS2017, "445310")),
        ((Standards.SIC, "5182"), (Standards.NAICS2017, "424820")),
        ((Standards.SIC, "5182"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5182"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5182"), (Standards.NAICS2017, "445310")),
        ((Standards.SIC, "5191"), (Standards.NAICS2017, "424910")),
        ((Standards.SIC, "5191"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5191"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5191"), (Standards.NAICS2017, "444220")),
        ((Standards.SIC, "5192"), (Standards.NAICS2017, "424920")),
        ((Standards.SIC, "5192"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5192"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5192"), (Standards.NAICS2017, "451211")),
        ((Standards.SIC, "5193"), (Standards.NAICS2017, "424930")),
        ((Standards.SIC, "5193"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5193"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5193"), (Standards.NAICS2017, "444220")),
        ((Standards.SIC, "5194"), (Standards.NAICS2017, "424940")),
        ((Standards.SIC, "5194"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5194"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5194"), (Standards.NAICS2017, "453991")),
        ((Standards.SIC, "5198"), (Standards.NAICS2017, "424950")),
        ((Standards.SIC, "5198"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5198"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5199"), (Standards.NAICS2017, "424310")),
        ((Standards.SIC, "5199"), (Standards.NAICS2017, "424340")),
        ((Standards.SIC, "5199"), (Standards.NAICS2017, "424610")),
        ((Standards.SIC, "5199"), (Standards.NAICS2017, "424990")),
        ((Standards.SIC, "5199"), (Standards.NAICS2017, "425110")),
        ((Standards.SIC, "5199"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "5199"), (Standards.NAICS2017, "453220")),
        ((Standards.SIC, "5199"), (Standards.NAICS2017, "453910")),
        ((Standards.SIC, "5199"), (Standards.NAICS2017, "453991")),
        ((Standards.SIC, "5199"), (Standards.NAICS2017, "541890")),
        ((Standards.SIC, "5211"), (Standards.NAICS2017, "444110")),
        ((Standards.SIC, "5211"), (Standards.NAICS2017, "444190")),
        ((Standards.SIC, "5231"), (Standards.NAICS2017, "444120")),
        ((Standards.SIC, "5231"), (Standards.NAICS2017, "444190")),
        ((Standards.SIC, "5251"), (Standards.NAICS2017, "444130")),
        ((Standards.SIC, "5261"), (Standards.NAICS2017, "444210")),
        ((Standards.SIC, "5261"), (Standards.NAICS2017, "444220")),
        ((Standards.SIC, "5271"), (Standards.NAICS2017, "453930")),
        ((Standards.SIC, "5311"), (Standards.NAICS2017, "452210")),
        ((Standards.SIC, "5311"), (Standards.NAICS2017, "452311")),
        ((Standards.SIC, "5331"), (Standards.NAICS2017, "452319")),
        ((Standards.SIC, "5399"), (Standards.NAICS2017, "452210")),
        ((Standards.SIC, "5399"), (Standards.NAICS2017, "452311")),
        ((Standards.SIC, "5399"), (Standards.NAICS2017, "452319")),
        ((Standards.SIC, "5411"), (Standards.NAICS2017, "445110")),
        ((Standards.SIC, "5411"), (Standards.NAICS2017, "445120")),
        ((Standards.SIC, "5411"), (Standards.NAICS2017, "447110")),
        ((Standards.SIC, "5411"), (Standards.NAICS2017, "452210")),
        ((Standards.SIC, "5411"), (Standards.NAICS2017, "452311")),
        ((Standards.SIC, "5411"), (Standards.NAICS2017, "454390")),
        ((Standards.SIC, "5421"), (Standards.NAICS2017, "445210")),
        ((Standards.SIC, "5421"), (Standards.NAICS2017, "445220")),
        ((Standards.SIC, "5421"), (Standards.NAICS2017, "454390")),
        ((Standards.SIC, "5431"), (Standards.NAICS2017, "445230")),
        ((Standards.SIC, "5431"), (Standards.NAICS2017, "454390")),
        ((Standards.SIC, "5441"), (Standards.NAICS2017, "311340")),
        ((Standards.SIC, "5441"), (Standards.NAICS2017, "311352")),
        ((Standards.SIC, "5441"), (Standards.NAICS2017, "445292")),
        ((Standards.SIC, "5451"), (Standards.NAICS2017, "445299")),
        ((Standards.SIC, "5461"), (Standards.NAICS2017, "311811")),
        ((Standards.SIC, "5461"), (Standards.NAICS2017, "445291")),
        ((Standards.SIC, "5461"), (Standards.NAICS2017, "722515")),
        ((Standards.SIC, "5499"), (Standards.NAICS2017, "445210")),
        ((Standards.SIC, "5499"), (Standards.NAICS2017, "445299")),
        ((Standards.SIC, "5499"), (Standards.NAICS2017, "446191")),
        ((Standards.SIC, "5511"), (Standards.NAICS2017, "441110")),
        ((Standards.SIC, "5521"), (Standards.NAICS2017, "441120")),
        ((Standards.SIC, "5531"), (Standards.NAICS2017, "441310")),
        ((Standards.SIC, "5531"), (Standards.NAICS2017, "441320")),
        ((Standards.SIC, "5531"), (Standards.NAICS2017, "452319")),
        ((Standards.SIC, "5541"), (Standards.NAICS2017, "447110")),
        ((Standards.SIC, "5541"), (Standards.NAICS2017, "447190")),
        ((Standards.SIC, "5551"), (Standards.NAICS2017, "441222")),
        ((Standards.SIC, "5561"), (Standards.NAICS2017, "441210")),
        ((Standards.SIC, "5571"), (Standards.NAICS2017, "441228")),
        ((Standards.SIC, "5599"), (Standards.NAICS2017, "441228")),
        ((Standards.SIC, "5611"), (Standards.NAICS2017, "448110")),
        ((Standards.SIC, "5611"), (Standards.NAICS2017, "448150")),
        ((Standards.SIC, "5621"), (Standards.NAICS2017, "448120")),
        ((Standards.SIC, "5621"), (Standards.NAICS2017, "448190")),
        ((Standards.SIC, "5632"), (Standards.NAICS2017, "448150")),
        ((Standards.SIC, "5632"), (Standards.NAICS2017, "448190")),
        ((Standards.SIC, "5641"), (Standards.NAICS2017, "448130")),
        ((Standards.SIC, "5651"), (Standards.NAICS2017, "448140")),
        ((Standards.SIC, "5661"), (Standards.NAICS2017, "448210")),
        ((Standards.SIC, "5699"), (Standards.NAICS2017, "315220")),
        ((Standards.SIC, "5699"), (Standards.NAICS2017, "315240")),
        ((Standards.SIC, "5699"), (Standards.NAICS2017, "448150")),
        ((Standards.SIC, "5699"), (Standards.NAICS2017, "448190")),
        ((Standards.SIC, "5712"), (Standards.NAICS2017, "337110")),
        ((Standards.SIC, "5712"), (Standards.NAICS2017, "337121")),
        ((Standards.SIC, "5712"), (Standards.NAICS2017, "337122")),
        ((Standards.SIC, "5712"), (Standards.NAICS2017, "442110")),
        ((Standards.SIC, "5713"), (Standards.NAICS2017, "442210")),
        ((Standards.SIC, "5714"), (Standards.NAICS2017, "314120")),
        ((Standards.SIC, "5714"), (Standards.NAICS2017, "442291")),
        ((Standards.SIC, "5714"), (Standards.NAICS2017, "451130")),
        ((Standards.SIC, "5719"), (Standards.NAICS2017, "327110")),
        ((Standards.SIC, "5719"), (Standards.NAICS2017, "442291")),
        ((Standards.SIC, "5719"), (Standards.NAICS2017, "442299")),
        ((Standards.SIC, "5722"), (Standards.NAICS2017, "443141")),
        ((Standards.SIC, "5731"), (Standards.NAICS2017, "441310")),
        ((Standards.SIC, "5731"), (Standards.NAICS2017, "443142")),
        ((Standards.SIC, "5734"), (Standards.NAICS2017, "443142")),
        ((Standards.SIC, "5735"), (Standards.NAICS2017, "443142")),
        ((Standards.SIC, "5736"), (Standards.NAICS2017, "451140")),
        ((Standards.SIC, "5812"), (Standards.NAICS2017, "711110")),
        ((Standards.SIC, "5812"), (Standards.NAICS2017, "722310")),
        ((Standards.SIC, "5812"), (Standards.NAICS2017, "722320")),
        ((Standards.SIC, "5812"), (Standards.NAICS2017, "722511")),
        ((Standards.SIC, "5812"), (Standards.NAICS2017, "722513")),
        ((Standards.SIC, "5812"), (Standards.NAICS2017, "722514")),
        ((Standards.SIC, "5812"), (Standards.NAICS2017, "722515")),
        ((Standards.SIC, "5813"), (Standards.NAICS2017, "722410")),
        ((Standards.SIC, "5912"), (Standards.NAICS2017, "446110")),
        ((Standards.SIC, "5921"), (Standards.NAICS2017, "445310")),
        ((Standards.SIC, "5932"), (Standards.NAICS2017, "453310")),
        ((Standards.SIC, "5932"), (Standards.NAICS2017, "522298")),
        ((Standards.SIC, "5941"), (Standards.NAICS2017, "451110")),
        ((Standards.SIC, "5942"), (Standards.NAICS2017, "451211")),
        ((Standards.SIC, "5943"), (Standards.NAICS2017, "453210")),
        ((Standards.SIC, "5944"), (Standards.NAICS2017, "448310")),
        ((Standards.SIC, "5945"), (Standards.NAICS2017, "451120")),
        ((Standards.SIC, "5946"), (Standards.NAICS2017, "443142")),
        ((Standards.SIC, "5947"), (Standards.NAICS2017, "453220")),
        ((Standards.SIC, "5948"), (Standards.NAICS2017, "448320")),
        ((Standards.SIC, "5949"), (Standards.NAICS2017, "451130")),
        ((Standards.SIC, "5961"), (Standards.NAICS2017, "454110")),
        ((Standards.SIC, "5962"), (Standards.NAICS2017, "454210")),
        ((Standards.SIC, "5963"), (Standards.NAICS2017, "454390")),
        ((Standards.SIC, "5963"), (Standards.NAICS2017, "722330")),
        ((Standards.SIC, "5983"), (Standards.NAICS2017, "454310")),
        ((Standards.SIC, "5984"), (Standards.NAICS2017, "454310")),
        ((Standards.SIC, "5989"), (Standards.NAICS2017, "454310")),
        ((Standards.SIC, "5992"), (Standards.NAICS2017, "453110")),
        ((Standards.SIC, "5993"), (Standards.NAICS2017, "453991")),
        ((Standards.SIC, "5994"), (Standards.NAICS2017, "451212")),
        ((Standards.SIC, "5995"), (Standards.NAICS2017, "339115")),
        ((Standards.SIC, "5995"), (Standards.NAICS2017, "446130")),
        ((Standards.SIC, "5999"), (Standards.NAICS2017, "339113")),
        ((Standards.SIC, "5999"), (Standards.NAICS2017, "443142")),
        ((Standards.SIC, "5999"), (Standards.NAICS2017, "446120")),
        ((Standards.SIC, "5999"), (Standards.NAICS2017, "446199")),
        ((Standards.SIC, "5999"), (Standards.NAICS2017, "453910")),
        ((Standards.SIC, "5999"), (Standards.NAICS2017, "453920")),
        ((Standards.SIC, "5999"), (Standards.NAICS2017, "453998")),
        ((Standards.SIC, "6011"), (Standards.NAICS2017, "521110")),
        ((Standards.SIC, "6019"), (Standards.NAICS2017, "522298")),
        ((Standards.SIC, "6021"), (Standards.NAICS2017, "522110")),
        ((Standards.SIC, "6021"), (Standards.NAICS2017, "522210")),
        ((Standards.SIC, "6022"), (Standards.NAICS2017, "522110")),
        ((Standards.SIC, "6022"), (Standards.NAICS2017, "522190")),
        ((Standards.SIC, "6022"), (Standards.NAICS2017, "522210")),
        ((Standards.SIC, "6029"), (Standards.NAICS2017, "522110")),
        ((Standards.SIC, "6035"), (Standards.NAICS2017, "522120")),
        ((Standards.SIC, "6036"), (Standards.NAICS2017, "522120")),
        ((Standards.SIC, "6061"), (Standards.NAICS2017, "522130")),
        ((Standards.SIC, "6062"), (Standards.NAICS2017, "522130")),
        ((Standards.SIC, "6081"), (Standards.NAICS2017, "522110")),
        ((Standards.SIC, "6081"), (Standards.NAICS2017, "522293")),
        ((Standards.SIC, "6081"), (Standards.NAICS2017, "522298")),
        ((Standards.SIC, "6082"), (Standards.NAICS2017, "522293")),
        ((Standards.SIC, "6082"), (Standards.NAICS2017, "522298")),
        ((Standards.SIC, "6091"), (Standards.NAICS2017, "523991")),
        ((Standards.SIC, "6099"), (Standards.NAICS2017, "522320")),
        ((Standards.SIC, "6099"), (Standards.NAICS2017, "522390")),
        ((Standards.SIC, "6099"), (Standards.NAICS2017, "523130")),
        ((Standards.SIC, "6099"), (Standards.NAICS2017, "523991")),
        ((Standards.SIC, "6111"), (Standards.NAICS2017, "522292")),
        ((Standards.SIC, "6111"), (Standards.NAICS2017, "522293")),
        ((Standards.SIC, "6111"), (Standards.NAICS2017, "522294")),
        ((Standards.SIC, "6111"), (Standards.NAICS2017, "522298")),
        ((Standards.SIC, "6141"), (Standards.NAICS2017, "522210")),
        ((Standards.SIC, "6141"), (Standards.NAICS2017, "522220")),
        ((Standards.SIC, "6141"), (Standards.NAICS2017, "522291")),
        ((Standards.SIC, "6141"), (Standards.NAICS2017, "522298")),
        ((Standards.SIC, "6153"), (Standards.NAICS2017, "522210")),
        ((Standards.SIC, "6153"), (Standards.NAICS2017, "522220")),
        ((Standards.SIC, "6153"), (Standards.NAICS2017, "522298")),
        ((Standards.SIC, "6153"), (Standards.NAICS2017, "522320")),
        ((Standards.SIC, "6153"), (Standards.NAICS2017, "523910")),
        ((Standards.SIC, "6159"), (Standards.NAICS2017, "522220")),
        ((Standards.SIC, "6159"), (Standards.NAICS2017, "522292")),
        ((Standards.SIC, "6159"), (Standards.NAICS2017, "522293")),
        ((Standards.SIC, "6159"), (Standards.NAICS2017, "522294")),
        ((Standards.SIC, "6159"), (Standards.NAICS2017, "522298")),
        ((Standards.SIC, "6162"), (Standards.NAICS2017, "522292")),
        ((Standards.SIC, "6162"), (Standards.NAICS2017, "522390")),
        ((Standards.SIC, "6163"), (Standards.NAICS2017, "522310")),
        ((Standards.SIC, "6211"), (Standards.NAICS2017, "523110")),
        ((Standards.SIC, "6211"), (Standards.NAICS2017, "523120")),
        ((Standards.SIC, "6211"), (Standards.NAICS2017, "523910")),
        ((Standards.SIC, "6211"), (Standards.NAICS2017, "523999")),
        ((Standards.SIC, "6221"), (Standards.NAICS2017, "523130")),
        ((Standards.SIC, "6221"), (Standards.NAICS2017, "523140")),
        ((Standards.SIC, "6231"), (Standards.NAICS2017, "523210")),
        ((Standards.SIC, "6282"), (Standards.NAICS2017, "523920")),
        ((Standards.SIC, "6282"), (Standards.NAICS2017, "523930")),
        ((Standards.SIC, "6289"), (Standards.NAICS2017, "523991")),
        ((Standards.SIC, "6289"), (Standards.NAICS2017, "523999")),
        ((Standards.SIC, "6311"), (Standards.NAICS2017, "524113")),
        ((Standards.SIC, "6311"), (Standards.NAICS2017, "524128")),
        ((Standards.SIC, "6311"), (Standards.NAICS2017, "524130")),
        ((Standards.SIC, "6321"), (Standards.NAICS2017, "524113")),
        ((Standards.SIC, "6321"), (Standards.NAICS2017, "524114")),
        ((Standards.SIC, "6321"), (Standards.NAICS2017, "524130")),
        ((Standards.SIC, "6321"), (Standards.NAICS2017, "525190")),
        ((Standards.SIC, "6324"), (Standards.NAICS2017, "524114")),
        ((Standards.SIC, "6324"), (Standards.NAICS2017, "524130")),
        ((Standards.SIC, "6324"), (Standards.NAICS2017, "525190")),
        ((Standards.SIC, "6331"), (Standards.NAICS2017, "524126")),
        ((Standards.SIC, "6331"), (Standards.NAICS2017, "524128")),
        ((Standards.SIC, "6331"), (Standards.NAICS2017, "524130")),
        ((Standards.SIC, "6331"), (Standards.NAICS2017, "525190")),
        ((Standards.SIC, "6351"), (Standards.NAICS2017, "524126")),
        ((Standards.SIC, "6351"), (Standards.NAICS2017, "524128")),
        ((Standards.SIC, "6351"), (Standards.NAICS2017, "524130")),
        ((Standards.SIC, "6361"), (Standards.NAICS2017, "524127")),
        ((Standards.SIC, "6361"), (Standards.NAICS2017, "524130")),
        ((Standards.SIC, "6371"), (Standards.NAICS2017, "523920")),
        ((Standards.SIC, "6371"), (Standards.NAICS2017, "524292")),
        ((Standards.SIC, "6371"), (Standards.NAICS2017, "525110")),
        ((Standards.SIC, "6371"), (Standards.NAICS2017, "525120")),
        ((Standards.SIC, "6371"), (Standards.NAICS2017, "525990")),
        ((Standards.SIC, "6399"), (Standards.NAICS2017, "524128")),
        ((Standards.SIC, "6411"), (Standards.NAICS2017, "524210")),
        ((Standards.SIC, "6411"), (Standards.NAICS2017, "524291")),
        ((Standards.SIC, "6411"), (Standards.NAICS2017, "524292")),
        ((Standards.SIC, "6411"), (Standards.NAICS2017, "524298")),
        ((Standards.SIC, "6512"), (Standards.NAICS2017, "531120")),
        ((Standards.SIC, "6512"), (Standards.NAICS2017, "711310")),
        ((Standards.SIC, "6513"), (Standards.NAICS2017, "531110")),
        ((Standards.SIC, "6514"), (Standards.NAICS2017, "531110")),
        ((Standards.SIC, "6515"), (Standards.NAICS2017, "531190")),
        ((Standards.SIC, "6517"), (Standards.NAICS2017, "531190")),
        ((Standards.SIC, "6519"), (Standards.NAICS2017, "531190")),
        ((Standards.SIC, "6531"), (Standards.NAICS2017, "531110")),
        ((Standards.SIC, "6531"), (Standards.NAICS2017, "531210")),
        ((Standards.SIC, "6531"), (Standards.NAICS2017, "531311")),
        ((Standards.SIC, "6531"), (Standards.NAICS2017, "531312")),
        ((Standards.SIC, "6531"), (Standards.NAICS2017, "531320")),
        ((Standards.SIC, "6531"), (Standards.NAICS2017, "531390")),
        ((Standards.SIC, "6531"), (Standards.NAICS2017, "812220")),
        ((Standards.SIC, "6531"), (Standards.NAICS2017, "813990")),
        ((Standards.SIC, "6541"), (Standards.NAICS2017, "541191")),
        ((Standards.SIC, "6552"), (Standards.NAICS2017, "237210")),
        ((Standards.SIC, "6553"), (Standards.NAICS2017, "812220")),
        ((Standards.SIC, "6712"), (Standards.NAICS2017, "551111")),
        ((Standards.SIC, "6719"), (Standards.NAICS2017, "551112")),
        ((Standards.SIC, "6722"), (Standards.NAICS2017, "525910")),
        ((Standards.SIC, "6726"), (Standards.NAICS2017, "525990")),
        ((Standards.SIC, "6732"), (Standards.NAICS2017, "813211")),
        ((Standards.SIC, "6733"), (Standards.NAICS2017, "523920")),
        ((Standards.SIC, "6733"), (Standards.NAICS2017, "523991")),
        ((Standards.SIC, "6733"), (Standards.NAICS2017, "525190")),
        ((Standards.SIC, "6733"), (Standards.NAICS2017, "525920")),
        ((Standards.SIC, "6792"), (Standards.NAICS2017, "523910")),
        ((Standards.SIC, "6792"), (Standards.NAICS2017, "533110")),
        ((Standards.SIC, "6794"), (Standards.NAICS2017, "533110")),
        ((Standards.SIC, "6798"), (Standards.NAICS2017, "525990")),
        ((Standards.SIC, "6798"), (Standards.NAICS2017, "531110")),
        ((Standards.SIC, "6798"), (Standards.NAICS2017, "531120")),
        ((Standards.SIC, "6798"), (Standards.NAICS2017, "531130")),
        ((Standards.SIC, "6798"), (Standards.NAICS2017, "531190")),
        ((Standards.SIC, "6799"), (Standards.NAICS2017, "523130")),
        ((Standards.SIC, "6799"), (Standards.NAICS2017, "523910")),
        ((Standards.SIC, "6799"), (Standards.NAICS2017, "523920")),
        ((Standards.SIC, "7011"), (Standards.NAICS2017, "721110")),
        ((Standards.SIC, "7011"), (Standards.NAICS2017, "721120")),
        ((Standards.SIC, "7011"), (Standards.NAICS2017, "721191")),
        ((Standards.SIC, "7011"), (Standards.NAICS2017, "721199")),
        ((Standards.SIC, "7021"), (Standards.NAICS2017, "721310")),
        ((Standards.SIC, "7032"), (Standards.NAICS2017, "721214")),
        ((Standards.SIC, "7033"), (Standards.NAICS2017, "721211")),
        ((Standards.SIC, "7041"), (Standards.NAICS2017, "721110")),
        ((Standards.SIC, "7041"), (Standards.NAICS2017, "721310")),
        ((Standards.SIC, "7211"), (Standards.NAICS2017, "812320")),
        ((Standards.SIC, "7212"), (Standards.NAICS2017, "812320")),
        ((Standards.SIC, "7213"), (Standards.NAICS2017, "812331")),
        ((Standards.SIC, "7215"), (Standards.NAICS2017, "812310")),
        ((Standards.SIC, "7216"), (Standards.NAICS2017, "812320")),
        ((Standards.SIC, "7217"), (Standards.NAICS2017, "561740")),
        ((Standards.SIC, "7218"), (Standards.NAICS2017, "812332")),
        ((Standards.SIC, "7219"), (Standards.NAICS2017, "811490")),
        ((Standards.SIC, "7219"), (Standards.NAICS2017, "812320")),
        ((Standards.SIC, "7219"), (Standards.NAICS2017, "812331")),
        ((Standards.SIC, "7221"), (Standards.NAICS2017, "541921")),
        ((Standards.SIC, "7231"), (Standards.NAICS2017, "611511")),
        ((Standards.SIC, "7231"), (Standards.NAICS2017, "812112")),
        ((Standards.SIC, "7231"), (Standards.NAICS2017, "812113")),
        ((Standards.SIC, "7241"), (Standards.NAICS2017, "611511")),
        ((Standards.SIC, "7241"), (Standards.NAICS2017, "812111")),
        ((Standards.SIC, "7251"), (Standards.NAICS2017, "811430")),
        ((Standards.SIC, "7251"), (Standards.NAICS2017, "812320")),
        ((Standards.SIC, "7251"), (Standards.NAICS2017, "812990")),
        ((Standards.SIC, "7261"), (Standards.NAICS2017, "812210")),
        ((Standards.SIC, "7261"), (Standards.NAICS2017, "812220")),
        ((Standards.SIC, "7291"), (Standards.NAICS2017, "541213")),
        ((Standards.SIC, "7299"), (Standards.NAICS2017, "532281")),
        ((Standards.SIC, "7299"), (Standards.NAICS2017, "541990")),
        ((Standards.SIC, "7299"), (Standards.NAICS2017, "561311")),
        ((Standards.SIC, "7299"), (Standards.NAICS2017, "561990")),
        ((Standards.SIC, "7299"), (Standards.NAICS2017, "812191")),
        ((Standards.SIC, "7299"), (Standards.NAICS2017, "812199")),
        ((Standards.SIC, "7299"), (Standards.NAICS2017, "812930")),
        ((Standards.SIC, "7299"), (Standards.NAICS2017, "812990")),
        ((Standards.SIC, "7311"), (Standards.NAICS2017, "541810")),
        ((Standards.SIC, "7312"), (Standards.NAICS2017, "541850")),
        ((Standards.SIC, "7313"), (Standards.NAICS2017, "541840")),
        ((Standards.SIC, "7319"), (Standards.NAICS2017, "481219")),
        ((Standards.SIC, "7319"), (Standards.NAICS2017, "541830")),
        ((Standards.SIC, "7319"), (Standards.NAICS2017, "541850")),
        ((Standards.SIC, "7319"), (Standards.NAICS2017, "541870")),
        ((Standards.SIC, "7319"), (Standards.NAICS2017, "541890")),
        ((Standards.SIC, "7322"), (Standards.NAICS2017, "561440")),
        ((Standards.SIC, "7323"), (Standards.NAICS2017, "561450")),
        ((Standards.SIC, "7331"), (Standards.NAICS2017, "511140")),
        ((Standards.SIC, "7331"), (Standards.NAICS2017, "541860")),
        ((Standards.SIC, "7334"), (Standards.NAICS2017, "323111")),
        ((Standards.SIC, "7334"), (Standards.NAICS2017, "561439")),
        ((Standards.SIC, "7335"), (Standards.NAICS2017, "481219")),
        ((Standards.SIC, "7335"), (Standards.NAICS2017, "541922")),
        ((Standards.SIC, "7336"), (Standards.NAICS2017, "541430")),
        ((Standards.SIC, "7338"), (Standards.NAICS2017, "561410")),
        ((Standards.SIC, "7338"), (Standards.NAICS2017, "561492")),
        ((Standards.SIC, "7342"), (Standards.NAICS2017, "561710")),
        ((Standards.SIC, "7342"), (Standards.NAICS2017, "561720")),
        ((Standards.SIC, "7349"), (Standards.NAICS2017, "561720")),
        ((Standards.SIC, "7349"), (Standards.NAICS2017, "561790")),
        ((Standards.SIC, "7352"), (Standards.NAICS2017, "532283")),
        ((Standards.SIC, "7352"), (Standards.NAICS2017, "532490")),
        ((Standards.SIC, "7353"), (Standards.NAICS2017, "238910")),
        ((Standards.SIC, "7353"), (Standards.NAICS2017, "238990")),
        ((Standards.SIC, "7353"), (Standards.NAICS2017, "532412")),
        ((Standards.SIC, "7359"), (Standards.NAICS2017, "532210")),
        ((Standards.SIC, "7359"), (Standards.NAICS2017, "532289")),
        ((Standards.SIC, "7359"), (Standards.NAICS2017, "532310")),
        ((Standards.SIC, "7359"), (Standards.NAICS2017, "532411")),
        ((Standards.SIC, "7359"), (Standards.NAICS2017, "532412")),
        ((Standards.SIC, "7359"), (Standards.NAICS2017, "532420")),
        ((Standards.SIC, "7359"), (Standards.NAICS2017, "532490")),
        ((Standards.SIC, "7359"), (Standards.NAICS2017, "562991")),
        ((Standards.SIC, "7361"), (Standards.NAICS2017, "541612")),
        ((Standards.SIC, "7361"), (Standards.NAICS2017, "561311")),
        ((Standards.SIC, "7361"), (Standards.NAICS2017, "561312")),
        ((Standards.SIC, "7363"), (Standards.NAICS2017, "561320")),
        ((Standards.SIC, "7363"), (Standards.NAICS2017, "561330")),
        ((Standards.SIC, "7371"), (Standards.NAICS2017, "541511")),
        ((Standards.SIC, "7372"), (Standards.NAICS2017, "334614")),
        ((Standards.SIC, "7372"), (Standards.NAICS2017, "511210")),
        ((Standards.SIC, "7373"), (Standards.NAICS2017, "541512")),
        ((Standards.SIC, "7374"), (Standards.NAICS2017, "518210")),
        ((Standards.SIC, "7375"), (Standards.NAICS2017, "517311")),
        ((Standards.SIC, "7375"), (Standards.NAICS2017, "517919")),
        ((Standards.SIC, "7376"), (Standards.NAICS2017, "541513")),
        ((Standards.SIC, "7377"), (Standards.NAICS2017, "532420")),
        ((Standards.SIC, "7378"), (Standards.NAICS2017, "443142")),
        ((Standards.SIC, "7378"), (Standards.NAICS2017, "811212")),
        ((Standards.SIC, "7379"), (Standards.NAICS2017, "518210")),
        ((Standards.SIC, "7379"), (Standards.NAICS2017, "541512")),
        ((Standards.SIC, "7379"), (Standards.NAICS2017, "541519")),
        ((Standards.SIC, "7381"), (Standards.NAICS2017, "561611")),
        ((Standards.SIC, "7381"), (Standards.NAICS2017, "561612")),
        ((Standards.SIC, "7381"), (Standards.NAICS2017, "561613")),
        ((Standards.SIC, "7382"), (Standards.NAICS2017, "561621")),
        ((Standards.SIC, "7383"), (Standards.NAICS2017, "519110")),
        ((Standards.SIC, "7383"), (Standards.NAICS2017, "711510")),
        ((Standards.SIC, "7384"), (Standards.NAICS2017, "812921")),
        ((Standards.SIC, "7384"), (Standards.NAICS2017, "812922")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "312230")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "313310")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "314999")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "325998")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "425120")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "488490")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "491110")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "512240")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "512290")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "518210")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "519190")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "522320")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "541199")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "541340")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "541350")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "541370")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "541410")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "541420")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "541490")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "541870")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "541890")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "541930")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "541990")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "561410")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "561421")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "561422")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "561431")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "561439")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "561440")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "561491")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "561499")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "561591")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "561599")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "561790")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "561910")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "561920")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "561990")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "711310")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "711320")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "711410")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "812320")),
        ((Standards.SIC, "7389"), (Standards.NAICS2017, "812990")),
        ((Standards.SIC, "7513"), (Standards.NAICS2017, "532120")),
        ((Standards.SIC, "7514"), (Standards.NAICS2017, "532111")),
        ((Standards.SIC, "7515"), (Standards.NAICS2017, "532112")),
        ((Standards.SIC, "7519"), (Standards.NAICS2017, "532120")),
        ((Standards.SIC, "7521"), (Standards.NAICS2017, "812930")),
        ((Standards.SIC, "7532"), (Standards.NAICS2017, "811121")),
        ((Standards.SIC, "7533"), (Standards.NAICS2017, "811112")),
        ((Standards.SIC, "7534"), (Standards.NAICS2017, "326212")),
        ((Standards.SIC, "7534"), (Standards.NAICS2017, "811198")),
        ((Standards.SIC, "7536"), (Standards.NAICS2017, "811122")),
        ((Standards.SIC, "7537"), (Standards.NAICS2017, "811113")),
        ((Standards.SIC, "7538"), (Standards.NAICS2017, "811111")),
        ((Standards.SIC, "7539"), (Standards.NAICS2017, "811118")),
        ((Standards.SIC, "7539"), (Standards.NAICS2017, "811198")),
        ((Standards.SIC, "7542"), (Standards.NAICS2017, "811192")),
        ((Standards.SIC, "7549"), (Standards.NAICS2017, "488410")),
        ((Standards.SIC, "7549"), (Standards.NAICS2017, "811122")),
        ((Standards.SIC, "7549"), (Standards.NAICS2017, "811191")),
        ((Standards.SIC, "7549"), (Standards.NAICS2017, "811198")),
        ((Standards.SIC, "7622"), (Standards.NAICS2017, "238290")),
        ((Standards.SIC, "7622"), (Standards.NAICS2017, "443142")),
        ((Standards.SIC, "7622"), (Standards.NAICS2017, "811211")),
        ((Standards.SIC, "7622"), (Standards.NAICS2017, "811213")),
        ((Standards.SIC, "7623"), (Standards.NAICS2017, "443141")),
        ((Standards.SIC, "7623"), (Standards.NAICS2017, "811310")),
        ((Standards.SIC, "7623"), (Standards.NAICS2017, "811412")),
        ((Standards.SIC, "7629"), (Standards.NAICS2017, "443141")),
        ((Standards.SIC, "7629"), (Standards.NAICS2017, "811211")),
        ((Standards.SIC, "7629"), (Standards.NAICS2017, "811212")),
        ((Standards.SIC, "7629"), (Standards.NAICS2017, "811213")),
        ((Standards.SIC, "7629"), (Standards.NAICS2017, "811219")),
        ((Standards.SIC, "7629"), (Standards.NAICS2017, "811412")),
        ((Standards.SIC, "7631"), (Standards.NAICS2017, "448310")),
        ((Standards.SIC, "7631"), (Standards.NAICS2017, "811490")),
        ((Standards.SIC, "7641"), (Standards.NAICS2017, "811420")),
        ((Standards.SIC, "7692"), (Standards.NAICS2017, "811310")),
        ((Standards.SIC, "7694"), (Standards.NAICS2017, "335312")),
        ((Standards.SIC, "7694"), (Standards.NAICS2017, "811310")),
        ((Standards.SIC, "7699"), (Standards.NAICS2017, "115210")),
        ((Standards.SIC, "7699"), (Standards.NAICS2017, "238220")),
        ((Standards.SIC, "7699"), (Standards.NAICS2017, "442299")),
        ((Standards.SIC, "7699"), (Standards.NAICS2017, "444130")),
        ((Standards.SIC, "7699"), (Standards.NAICS2017, "444210")),
        ((Standards.SIC, "7699"), (Standards.NAICS2017, "451110")),
        ((Standards.SIC, "7699"), (Standards.NAICS2017, "488390")),
        ((Standards.SIC, "7699"), (Standards.NAICS2017, "561622")),
        ((Standards.SIC, "7699"), (Standards.NAICS2017, "561790")),
        ((Standards.SIC, "7699"), (Standards.NAICS2017, "562991")),
        ((Standards.SIC, "7699"), (Standards.NAICS2017, "562998")),
        ((Standards.SIC, "7699"), (Standards.NAICS2017, "711510")),
        ((Standards.SIC, "7699"), (Standards.NAICS2017, "811211")),
        ((Standards.SIC, "7699"), (Standards.NAICS2017, "811212")),
        ((Standards.SIC, "7699"), (Standards.NAICS2017, "811219")),
        ((Standards.SIC, "7699"), (Standards.NAICS2017, "811310")),
        ((Standards.SIC, "7699"), (Standards.NAICS2017, "811411")),
        ((Standards.SIC, "7699"), (Standards.NAICS2017, "811412")),
        ((Standards.SIC, "7699"), (Standards.NAICS2017, "811430")),
        ((Standards.SIC, "7699"), (Standards.NAICS2017, "811490")),
        ((Standards.SIC, "7812"), (Standards.NAICS2017, "512110")),
        ((Standards.SIC, "7819"), (Standards.NAICS2017, "334614")),
        ((Standards.SIC, "7819"), (Standards.NAICS2017, "512191")),
        ((Standards.SIC, "7819"), (Standards.NAICS2017, "512199")),
        ((Standards.SIC, "7819"), (Standards.NAICS2017, "532281")),
        ((Standards.SIC, "7819"), (Standards.NAICS2017, "532490")),
        ((Standards.SIC, "7819"), (Standards.NAICS2017, "541214")),
        ((Standards.SIC, "7819"), (Standards.NAICS2017, "541690")),
        ((Standards.SIC, "7819"), (Standards.NAICS2017, "561311")),
        ((Standards.SIC, "7819"), (Standards.NAICS2017, "711510")),
        ((Standards.SIC, "7822"), (Standards.NAICS2017, "423990")),
        ((Standards.SIC, "7822"), (Standards.NAICS2017, "512120")),
        ((Standards.SIC, "7829"), (Standards.NAICS2017, "512120")),
        ((Standards.SIC, "7829"), (Standards.NAICS2017, "512199")),
        ((Standards.SIC, "7829"), (Standards.NAICS2017, "519120")),
        ((Standards.SIC, "7832"), (Standards.NAICS2017, "512131")),
        ((Standards.SIC, "7833"), (Standards.NAICS2017, "512132")),
        ((Standards.SIC, "7841"), (Standards.NAICS2017, "532282")),
        ((Standards.SIC, "7911"), (Standards.NAICS2017, "611610")),
        ((Standards.SIC, "7911"), (Standards.NAICS2017, "713990")),
        ((Standards.SIC, "7922"), (Standards.NAICS2017, "512290")),
        ((Standards.SIC, "7922"), (Standards.NAICS2017, "532490")),
        ((Standards.SIC, "7922"), (Standards.NAICS2017, "561311")),
        ((Standards.SIC, "7922"), (Standards.NAICS2017, "561599")),
        ((Standards.SIC, "7922"), (Standards.NAICS2017, "711110")),
        ((Standards.SIC, "7922"), (Standards.NAICS2017, "711120")),
        ((Standards.SIC, "7922"), (Standards.NAICS2017, "711310")),
        ((Standards.SIC, "7922"), (Standards.NAICS2017, "711320")),
        ((Standards.SIC, "7922"), (Standards.NAICS2017, "711410")),
        ((Standards.SIC, "7922"), (Standards.NAICS2017, "711510")),
        ((Standards.SIC, "7929"), (Standards.NAICS2017, "711130")),
        ((Standards.SIC, "7929"), (Standards.NAICS2017, "711190")),
        ((Standards.SIC, "7929"), (Standards.NAICS2017, "711510")),
        ((Standards.SIC, "7933"), (Standards.NAICS2017, "713950")),
        ((Standards.SIC, "7941"), (Standards.NAICS2017, "711211")),
        ((Standards.SIC, "7941"), (Standards.NAICS2017, "711310")),
        ((Standards.SIC, "7941"), (Standards.NAICS2017, "711320")),
        ((Standards.SIC, "7941"), (Standards.NAICS2017, "711410")),
        ((Standards.SIC, "7948"), (Standards.NAICS2017, "711212")),
        ((Standards.SIC, "7948"), (Standards.NAICS2017, "711219")),
        ((Standards.SIC, "7991"), (Standards.NAICS2017, "713940")),
        ((Standards.SIC, "7992"), (Standards.NAICS2017, "713910")),
        ((Standards.SIC, "7993"), (Standards.NAICS2017, "713120")),
        ((Standards.SIC, "7993"), (Standards.NAICS2017, "713290")),
        ((Standards.SIC, "7993"), (Standards.NAICS2017, "713990")),
        ((Standards.SIC, "7996"), (Standards.NAICS2017, "713110")),
        ((Standards.SIC, "7997"), (Standards.NAICS2017, "481219")),
        ((Standards.SIC, "7997"), (Standards.NAICS2017, "488119")),
        ((Standards.SIC, "7997"), (Standards.NAICS2017, "713910")),
        ((Standards.SIC, "7997"), (Standards.NAICS2017, "713940")),
        ((Standards.SIC, "7997"), (Standards.NAICS2017, "713990")),
        ((Standards.SIC, "7999"), (Standards.NAICS2017, "487110")),
        ((Standards.SIC, "7999"), (Standards.NAICS2017, "487210")),
        ((Standards.SIC, "7999"), (Standards.NAICS2017, "487990")),
        ((Standards.SIC, "7999"), (Standards.NAICS2017, "532284")),
        ((Standards.SIC, "7999"), (Standards.NAICS2017, "561599")),
        ((Standards.SIC, "7999"), (Standards.NAICS2017, "611620")),
        ((Standards.SIC, "7999"), (Standards.NAICS2017, "611699")),
        ((Standards.SIC, "7999"), (Standards.NAICS2017, "711190")),
        ((Standards.SIC, "7999"), (Standards.NAICS2017, "711219")),
        ((Standards.SIC, "7999"), (Standards.NAICS2017, "711310")),
        ((Standards.SIC, "7999"), (Standards.NAICS2017, "711320")),
        ((Standards.SIC, "7999"), (Standards.NAICS2017, "712190")),
        ((Standards.SIC, "7999"), (Standards.NAICS2017, "713210")),
        ((Standards.SIC, "7999"), (Standards.NAICS2017, "713290")),
        ((Standards.SIC, "7999"), (Standards.NAICS2017, "713920")),
        ((Standards.SIC, "7999"), (Standards.NAICS2017, "713940")),
        ((Standards.SIC, "7999"), (Standards.NAICS2017, "713990")),
        ((Standards.SIC, "7999"), (Standards.NAICS2017, "812990")),
        ((Standards.SIC, "8011"), (Standards.NAICS2017, "621111")),
        ((Standards.SIC, "8011"), (Standards.NAICS2017, "621112")),
        ((Standards.SIC, "8011"), (Standards.NAICS2017, "621491")),
        ((Standards.SIC, "8011"), (Standards.NAICS2017, "621493")),
        ((Standards.SIC, "8021"), (Standards.NAICS2017, "621210")),
        ((Standards.SIC, "8031"), (Standards.NAICS2017, "621111")),
        ((Standards.SIC, "8031"), (Standards.NAICS2017, "621112")),
        ((Standards.SIC, "8041"), (Standards.NAICS2017, "621310")),
        ((Standards.SIC, "8042"), (Standards.NAICS2017, "621320")),
        ((Standards.SIC, "8043"), (Standards.NAICS2017, "621391")),
        ((Standards.SIC, "8049"), (Standards.NAICS2017, "621330")),
        ((Standards.SIC, "8049"), (Standards.NAICS2017, "621340")),
        ((Standards.SIC, "8049"), (Standards.NAICS2017, "621399")),
        ((Standards.SIC, "8051"), (Standards.NAICS2017, "623110")),
        ((Standards.SIC, "8051"), (Standards.NAICS2017, "623210")),
        ((Standards.SIC, "8051"), (Standards.NAICS2017, "623311")),
        ((Standards.SIC, "8052"), (Standards.NAICS2017, "623110")),
        ((Standards.SIC, "8052"), (Standards.NAICS2017, "623210")),
        ((Standards.SIC, "8052"), (Standards.NAICS2017, "623311")),
        ((Standards.SIC, "8059"), (Standards.NAICS2017, "623110")),
        ((Standards.SIC, "8059"), (Standards.NAICS2017, "623210")),
        ((Standards.SIC, "8059"), (Standards.NAICS2017, "623311")),
        ((Standards.SIC, "8062"), (Standards.NAICS2017, "622110")),
        ((Standards.SIC, "8063"), (Standards.NAICS2017, "622210")),
        ((Standards.SIC, "8069"), (Standards.NAICS2017, "622110")),
        ((Standards.SIC, "8069"), (Standards.NAICS2017, "622210")),
        ((Standards.SIC, "8069"), (Standards.NAICS2017, "622310")),
        ((Standards.SIC, "8071"), (Standards.NAICS2017, "621511")),
        ((Standards.SIC, "8071"), (Standards.NAICS2017, "621512")),
        ((Standards.SIC, "8072"), (Standards.NAICS2017, "339116")),
        ((Standards.SIC, "8082"), (Standards.NAICS2017, "621610")),
        ((Standards.SIC, "8092"), (Standards.NAICS2017, "621492")),
        ((Standards.SIC, "8093"), (Standards.NAICS2017, "621399")),
        ((Standards.SIC, "8093"), (Standards.NAICS2017, "621410")),
        ((Standards.SIC, "8093"), (Standards.NAICS2017, "621420")),
        ((Standards.SIC, "8093"), (Standards.NAICS2017, "621498")),
        ((Standards.SIC, "8099"), (Standards.NAICS2017, "541430")),
        ((Standards.SIC, "8099"), (Standards.NAICS2017, "541922")),
        ((Standards.SIC, "8099"), (Standards.NAICS2017, "621410")),
        ((Standards.SIC, "8099"), (Standards.NAICS2017, "621991")),
        ((Standards.SIC, "8099"), (Standards.NAICS2017, "621999")),
        ((Standards.SIC, "8111"), (Standards.NAICS2017, "541110")),
        ((Standards.SIC, "8211"), (Standards.NAICS2017, "611110")),
        ((Standards.SIC, "8221"), (Standards.NAICS2017, "611310")),
        ((Standards.SIC, "8222"), (Standards.NAICS2017, "611210")),
        ((Standards.SIC, "8231"), (Standards.NAICS2017, "519120")),
        ((Standards.SIC, "8243"), (Standards.NAICS2017, "611420")),
        ((Standards.SIC, "8243"), (Standards.NAICS2017, "611519")),
        ((Standards.SIC, "8244"), (Standards.NAICS2017, "611410")),
        ((Standards.SIC, "8249"), (Standards.NAICS2017, "611512")),
        ((Standards.SIC, "8249"), (Standards.NAICS2017, "611513")),
        ((Standards.SIC, "8249"), (Standards.NAICS2017, "611519")),
        ((Standards.SIC, "8299"), (Standards.NAICS2017, "611430")),
        ((Standards.SIC, "8299"), (Standards.NAICS2017, "611512")),
        ((Standards.SIC, "8299"), (Standards.NAICS2017, "611519")),
        ((Standards.SIC, "8299"), (Standards.NAICS2017, "611610")),
        ((Standards.SIC, "8299"), (Standards.NAICS2017, "611620")),
        ((Standards.SIC, "8299"), (Standards.NAICS2017, "611630")),
        ((Standards.SIC, "8299"), (Standards.NAICS2017, "611691")),
        ((Standards.SIC, "8299"), (Standards.NAICS2017, "611692")),
        ((Standards.SIC, "8299"), (Standards.NAICS2017, "611699")),
        ((Standards.SIC, "8299"), (Standards.NAICS2017, "611710")),
        ((Standards.SIC, "8322"), (Standards.NAICS2017, "624110")),
        ((Standards.SIC, "8322"), (Standards.NAICS2017, "624120")),
        ((Standards.SIC, "8322"), (Standards.NAICS2017, "624190")),
        ((Standards.SIC, "8322"), (Standards.NAICS2017, "624210")),
        ((Standards.SIC, "8322"), (Standards.NAICS2017, "624221")),
        ((Standards.SIC, "8322"), (Standards.NAICS2017, "624229")),
        ((Standards.SIC, "8322"), (Standards.NAICS2017, "624230")),
        ((Standards.SIC, "8322"), (Standards.NAICS2017, "922150")),
        ((Standards.SIC, "8331"), (Standards.NAICS2017, "624310")),
        ((Standards.SIC, "8351"), (Standards.NAICS2017, "624410")),
        ((Standards.SIC, "8361"), (Standards.NAICS2017, "623210")),
        ((Standards.SIC, "8361"), (Standards.NAICS2017, "623220")),
        ((Standards.SIC, "8361"), (Standards.NAICS2017, "623312")),
        ((Standards.SIC, "8361"), (Standards.NAICS2017, "623990")),
        ((Standards.SIC, "8399"), (Standards.NAICS2017, "813212")),
        ((Standards.SIC, "8399"), (Standards.NAICS2017, "813219")),
        ((Standards.SIC, "8399"), (Standards.NAICS2017, "813311")),
        ((Standards.SIC, "8399"), (Standards.NAICS2017, "813312")),
        ((Standards.SIC, "8399"), (Standards.NAICS2017, "813319")),
        ((Standards.SIC, "8412"), (Standards.NAICS2017, "712110")),
        ((Standards.SIC, "8412"), (Standards.NAICS2017, "712120")),
        ((Standards.SIC, "8422"), (Standards.NAICS2017, "712130")),
        ((Standards.SIC, "8422"), (Standards.NAICS2017, "712190")),
        ((Standards.SIC, "8611"), (Standards.NAICS2017, "813910")),
        ((Standards.SIC, "8621"), (Standards.NAICS2017, "813920")),
        ((Standards.SIC, "8631"), (Standards.NAICS2017, "813930")),
        ((Standards.SIC, "8641"), (Standards.NAICS2017, "813319")),
        ((Standards.SIC, "8641"), (Standards.NAICS2017, "813410")),
        ((Standards.SIC, "8641"), (Standards.NAICS2017, "813990")),
        ((Standards.SIC, "8641"), (Standards.NAICS2017, "921150")),
        ((Standards.SIC, "8651"), (Standards.NAICS2017, "813940")),
        ((Standards.SIC, "8661"), (Standards.NAICS2017, "813110")),
        ((Standards.SIC, "8699"), (Standards.NAICS2017, "561599")),
        ((Standards.SIC, "8699"), (Standards.NAICS2017, "813312")),
        ((Standards.SIC, "8699"), (Standards.NAICS2017, "813410")),
        ((Standards.SIC, "8699"), (Standards.NAICS2017, "813910")),
        ((Standards.SIC, "8699"), (Standards.NAICS2017, "813990")),
        ((Standards.SIC, "8711"), (Standards.NAICS2017, "541330")),
        ((Standards.SIC, "8712"), (Standards.NAICS2017, "541310")),
        ((Standards.SIC, "8713"), (Standards.NAICS2017, "541360")),
        ((Standards.SIC, "8713"), (Standards.NAICS2017, "541370")),
        ((Standards.SIC, "8721"), (Standards.NAICS2017, "541211")),
        ((Standards.SIC, "8721"), (Standards.NAICS2017, "541214")),
        ((Standards.SIC, "8721"), (Standards.NAICS2017, "541219")),
        ((Standards.SIC, "8731"), (Standards.NAICS2017, "541713")),
        ((Standards.SIC, "8731"), (Standards.NAICS2017, "541714")),
        ((Standards.SIC, "8731"), (Standards.NAICS2017, "541715")),
        ((Standards.SIC, "8732"), (Standards.NAICS2017, "541720")),
        ((Standards.SIC, "8732"), (Standards.NAICS2017, "541910")),
        ((Standards.SIC, "8733"), (Standards.NAICS2017, "541713")),
        ((Standards.SIC, "8733"), (Standards.NAICS2017, "541714")),
        ((Standards.SIC, "8733"), (Standards.NAICS2017, "541715")),
        ((Standards.SIC, "8733"), (Standards.NAICS2017, "541720")),
        ((Standards.SIC, "8734"), (Standards.NAICS2017, "541380")),
        ((Standards.SIC, "8734"), (Standards.NAICS2017, "541940")),
        ((Standards.SIC, "8741"), (Standards.NAICS2017, "236115")),
        ((Standards.SIC, "8741"), (Standards.NAICS2017, "236116")),
        ((Standards.SIC, "8741"), (Standards.NAICS2017, "236118")),
        ((Standards.SIC, "8741"), (Standards.NAICS2017, "236210")),
        ((Standards.SIC, "8741"), (Standards.NAICS2017, "236220")),
        ((Standards.SIC, "8741"), (Standards.NAICS2017, "237110")),
        ((Standards.SIC, "8741"), (Standards.NAICS2017, "237120")),
        ((Standards.SIC, "8741"), (Standards.NAICS2017, "237130")),
        ((Standards.SIC, "8741"), (Standards.NAICS2017, "237310")),
        ((Standards.SIC, "8741"), (Standards.NAICS2017, "237990")),
        ((Standards.SIC, "8741"), (Standards.NAICS2017, "561110")),
        ((Standards.SIC, "8742"), (Standards.NAICS2017, "541611")),
        ((Standards.SIC, "8742"), (Standards.NAICS2017, "541612")),
        ((Standards.SIC, "8742"), (Standards.NAICS2017, "541613")),
        ((Standards.SIC, "8742"), (Standards.NAICS2017, "541614")),
        ((Standards.SIC, "8742"), (Standards.NAICS2017, "561312")),
        ((Standards.SIC, "8743"), (Standards.NAICS2017, "541820")),
        ((Standards.SIC, "8744"), (Standards.NAICS2017, "561210")),
        ((Standards.SIC, "8748"), (Standards.NAICS2017, "541320")),
        ((Standards.SIC, "8748"), (Standards.NAICS2017, "541330")),
        ((Standards.SIC, "8748"), (Standards.NAICS2017, "541618")),
        ((Standards.SIC, "8748"), (Standards.NAICS2017, "541690")),
        ((Standards.SIC, "8748"), (Standards.NAICS2017, "611710")),
        ((Standards.SIC, "8811"), (Standards.NAICS2017, "814110")),
        ((Standards.SIC, "8999"), (Standards.NAICS2017, "512230")),
        ((Standards.SIC, "8999"), (Standards.NAICS2017, "512250")),
        ((Standards.SIC, "8999"), (Standards.NAICS2017, "519130")),
        ((Standards.SIC, "8999"), (Standards.NAICS2017, "541612")),
        ((Standards.SIC, "8999"), (Standards.NAICS2017, "541620")),
        ((Standards.SIC, "8999"), (Standards.NAICS2017, "541690")),
        ((Standards.SIC, "8999"), (Standards.NAICS2017, "541990")),
        ((Standards.SIC, "8999"), (Standards.NAICS2017, "561312")),
        ((Standards.SIC, "8999"), (Standards.NAICS2017, "711510")),
        ((Standards.SIC, "9111"), (Standards.NAICS2017, "921110")),
        ((Standards.SIC, "9121"), (Standards.NAICS2017, "921120")),
        ((Standards.SIC, "9131"), (Standards.NAICS2017, "921140")),
        ((Standards.SIC, "9199"), (Standards.NAICS2017, "921190")),
        ((Standards.SIC, "9211"), (Standards.NAICS2017, "922110")),
        ((Standards.SIC, "9221"), (Standards.NAICS2017, "922120")),
        ((Standards.SIC, "9222"), (Standards.NAICS2017, "922130")),
        ((Standards.SIC, "9223"), (Standards.NAICS2017, "922140")),
        ((Standards.SIC, "9224"), (Standards.NAICS2017, "922160")),
        ((Standards.SIC, "9229"), (Standards.NAICS2017, "922190")),
        ((Standards.SIC, "9311"), (Standards.NAICS2017, "921130")),
        ((Standards.SIC, "9411"), (Standards.NAICS2017, "923110")),
        ((Standards.SIC, "9431"), (Standards.NAICS2017, "923120")),
        ((Standards.SIC, "9441"), (Standards.NAICS2017, "923130")),
        ((Standards.SIC, "9451"), (Standards.NAICS2017, "923140")),
        ((Standards.SIC, "9511"), (Standards.NAICS2017, "924110")),
        ((Standards.SIC, "9512"), (Standards.NAICS2017, "924120")),
        ((Standards.SIC, "9531"), (Standards.NAICS2017, "925110")),
        ((Standards.SIC, "9532"), (Standards.NAICS2017, "925120")),
        ((Standards.SIC, "9611"), (Standards.NAICS2017, "926110")),
        ((Standards.SIC, "9621"), (Standards.NAICS2017, "488111")),
        ((Standards.SIC, "9621"), (Standards.NAICS2017, "926120")),
        ((Standards.SIC, "9631"), (Standards.NAICS2017, "926130")),
        ((Standards.SIC, "9641"), (Standards.NAICS2017, "926140")),
        ((Standards.SIC, "9651"), (Standards.NAICS2017, "926150")),
        ((Standards.SIC, "9661"), (Standards.NAICS2017, "927110")),
        ((Standards.SIC, "9711"), (Standards.NAICS2017, "928110")),
        ((Standards.SIC, "9721"), (Standards.NAICS2017, "928120")),
    ],
)
