# -*- coding: utf-8 -*-
"""`SCIAN2018 Standard <https://www.inegi.org.mx/app/scian/>`_.
"""
from ...types import Category, Classification, Standard, Standards

SCIAN2018 = Standard(
    standard=Standards.SCIAN2018,
    classes=[
        Classification(
            "11",
            "Agricultura, cría y explotación de animales, aprovechamiento forestal, pesca y caza",
            Category.SECTION,
        ),
        Classification("111", "Agricultura", Category.DIVISION),
        Classification("1111", "Cultivo de semillas oleaginosas, leguminosas y cereales", Category.GROUP),
        Classification("11111", "Cultivo de soya", Category.CLASS),
        Classification("111110", "Cultivo de soya", Category.SUBCLASS),
        Classification("11112", "Cultivo de semillas oleaginosas, excepto soya", Category.CLASS),
        Classification("111121", "Cultivo de cártamo", Category.SUBCLASS),
        Classification("111122", "Cultivo de girasol", Category.SUBCLASS),
        Classification("111129", "Cultivo anual de otras semillas oleaginosas", Category.SUBCLASS),
        Classification("11113", "Cultivo de leguminosas", Category.CLASS),
        Classification("111131", "Cultivo de frijol grano", Category.SUBCLASS),
        Classification("111132", "Cultivo de garbanzo grano", Category.SUBCLASS),
        Classification("111139", "Cultivo de otras leguminosas", Category.SUBCLASS),
        Classification("11114", "Cultivo de trigo", Category.CLASS),
        Classification("111140", "Cultivo de trigo", Category.SUBCLASS),
        Classification("11115", "Cultivo de maíz", Category.CLASS),
        Classification("111151", "Cultivo de maíz grano", Category.SUBCLASS),
        Classification("111152", "Cultivo de maíz forrajero", Category.SUBCLASS),
        Classification("11116", "Cultivo de arroz", Category.CLASS),
        Classification("111160", "Cultivo de arroz", Category.SUBCLASS),
        Classification("11119", "Cultivo de otros cereales", Category.CLASS),
        Classification("111191", "Cultivo de sorgo grano", Category.SUBCLASS),
        Classification("111192", "Cultivo de avena grano", Category.SUBCLASS),
        Classification("111193", "Cultivo de cebada grano", Category.SUBCLASS),
        Classification("111194", "Cultivo de sorgo forrajero", Category.SUBCLASS),
        Classification("111195", "Cultivo de avena forrajera", Category.SUBCLASS),
        Classification("111199", "Cultivo de otros cereales", Category.SUBCLASS),
        Classification("1112", "Cultivo de hortalizas", Category.GROUP),
        Classification("11121", "Cultivo de hortalizas", Category.CLASS),
        Classification("111211", "Cultivo de jitomate o tomate rojo", Category.SUBCLASS),
        Classification("111212", "Cultivo de chile", Category.SUBCLASS),
        Classification("111213", "Cultivo de cebolla", Category.SUBCLASS),
        Classification("111214", "Cultivo de melón", Category.SUBCLASS),
        Classification("111215", "Cultivo de tomate verde", Category.SUBCLASS),
        Classification("111216", "Cultivo de papa", Category.SUBCLASS),
        Classification("111217", "Cultivo de calabaza", Category.SUBCLASS),
        Classification("111218", "Cultivo de sandía", Category.SUBCLASS),
        Classification("111219", "Cultivo de otras hortalizas", Category.SUBCLASS),
        Classification("1113", "Cultivo de frutales y nueces", Category.GROUP),
        Classification("11131", "Cultivo de naranja", Category.CLASS),
        Classification("111310", "Cultivo de naranja", Category.SUBCLASS),
        Classification("11132", "Cultivo de otros cítricos", Category.CLASS),
        Classification("111321", "Cultivo de limón", Category.SUBCLASS),
        Classification("111329", "Cultivo de otros cítricos", Category.SUBCLASS),
        Classification("11133", "Cultivo de frutales no cítricos y de nueces", Category.CLASS),
        Classification("111331", "Cultivo de café", Category.SUBCLASS),
        Classification("111332", "Cultivo de plátano", Category.SUBCLASS),
        Classification("111333", "Cultivo de mango", Category.SUBCLASS),
        Classification("111334", "Cultivo de aguacate", Category.SUBCLASS),
        Classification("111335", "Cultivo de uva", Category.SUBCLASS),
        Classification("111336", "Cultivo de manzana", Category.SUBCLASS),
        Classification("111337", "Cultivo de cacao", Category.SUBCLASS),
        Classification("111338", "Cultivo de coco", Category.SUBCLASS),
        Classification("111339", "Cultivo de otros frutales no cítricos y de nueces", Category.SUBCLASS),
        Classification(
            "1114", "Cultivo en invernaderos y otras estructuras agrícolas protegidas, y floricultura", Category.GROUP
        ),
        Classification(
            "11141",
            "Cultivo de productos alimenticios en invernaderos y otras estructuras agrícolas protegidas",
            Category.CLASS,
        ),
        Classification(
            "111411", "Cultivo de jitomate en invernaderos y otras estructuras agrícolas protegidas", Category.SUBCLASS
        ),
        Classification(
            "111412", "Cultivo de fresa en invernaderos y otras estructuras agrícolas protegidas", Category.SUBCLASS
        ),
        Classification(
            "111413",
            "Cultivo de bayas (berries) en invernaderos y otras estructuras agrícolas protegidas, excepto fresas ",
            Category.SUBCLASS,
        ),
        Classification(
            "111414", "Cultivo de chile en invernaderos y otras estructuras agrícolas protegidas", Category.SUBCLASS
        ),
        Classification(
            "111415", "Cultivo de manzana en invernaderos y otras estructuras agrícolas protegidas", Category.SUBCLASS
        ),
        Classification(
            "111416", "Cultivo de pepino en invernaderos y otras estructuras agrícolas protegidas", Category.SUBCLASS
        ),
        Classification(
            "111419",
            "Cultivo de otros productos alimenticios en invernaderos y otras estructuras agrícolas protegidas ",
            Category.SUBCLASS,
        ),
        Classification(
            "11142",
            "Floricultura, y otros cultivos de productos no alimenticios en invernaderos y otras estructuras agrícolas protegidas",
            Category.CLASS,
        ),
        Classification("111421", "Floricultura a cielo abierto", Category.SUBCLASS),
        Classification(
            "111422", "Floricultura en invernaderos y otras estructuras agrícolas protegidas", Category.SUBCLASS
        ),
        Classification("111423", "Cultivo de árboles de ciclo productivo de 10 años o menos", Category.SUBCLASS),
        Classification(
            "111429",
            "Otros cultivos no alimenticios en invernaderos y otras estructuras agrícolas protegidas ",
            Category.SUBCLASS,
        ),
        Classification("1119", "Otros cultivos", Category.GROUP),
        Classification("11191", "Cultivo de tabaco", Category.CLASS),
        Classification("111910", "Cultivo de tabaco", Category.SUBCLASS),
        Classification("11192", "Cultivo de algodón", Category.CLASS),
        Classification("111920", "Cultivo de algodón", Category.SUBCLASS),
        Classification("11193", "Cultivo de caña de azúcar", Category.CLASS),
        Classification("111930", "Cultivo de caña de azúcar", Category.SUBCLASS),
        Classification("11194", "Cultivo de alfalfa y pastos", Category.CLASS),
        Classification("111941", "Cultivo de alfalfa", Category.SUBCLASS),
        Classification("111942", "Cultivo de pastos", Category.SUBCLASS),
        Classification("11199", "Otros cultivos", Category.CLASS),
        Classification("111991", "Cultivo de agaves alcoholeros", Category.SUBCLASS),
        Classification("111992", "Cultivo de cacahuate", Category.SUBCLASS),
        Classification("111993", "Actividades agrícolas combinadas con explotación de animales", Category.SUBCLASS),
        Classification("111994", "Actividades agrícolas combinadas con aprovechamiento forestal", Category.SUBCLASS),
        Classification(
            "111995",
            "Actividades agrícolas combinadas con explotación de animales y aprovechamiento forestal ",
            Category.SUBCLASS,
        ),
        Classification("111999", "Otros cultivos", Category.SUBCLASS),
        Classification("112", "Cría y explotación de animales", Category.DIVISION),
        Classification("1121", "Explotación de bovinos", Category.GROUP),
        Classification("11211", "Explotación de bovinos para la producción de carne", Category.CLASS),
        Classification("112110", "Explotación de bovinos para la producción de carne", Category.SUBCLASS),
        Classification("11212", "Explotación de bovinos para la producción de leche", Category.CLASS),
        Classification("112120", "Explotación de bovinos para la producción de leche", Category.SUBCLASS),
        Classification("11213", "Explotación de bovinos sin especialización y para otros propósitos", Category.CLASS),
        Classification(
            "112131", "Explotación de bovinos para la producción conjunta de leche y carne", Category.SUBCLASS
        ),
        Classification("112139", "Explotación de bovinos para otros propósitos", Category.SUBCLASS),
        Classification("1122", "Explotación de porcinos", Category.GROUP),
        Classification("11221", "Explotación de porcinos", Category.CLASS),
        Classification("112211", "Explotación de porcinos en granja", Category.SUBCLASS),
        Classification("112212", "Explotación de porcinos en traspatio", Category.SUBCLASS),
        Classification("1123", "Explotación avícola", Category.GROUP),
        Classification("11231", "Explotación de gallinas para la producción de huevo", Category.CLASS),
        Classification("112311", "Explotación de gallinas para la producción de huevo fértil", Category.SUBCLASS),
        Classification("112312", "Explotación de gallinas para la producción de huevo para plato", Category.SUBCLASS),
        Classification("11232", "Explotación de pollos para la producción de carne", Category.CLASS),
        Classification("112320", "Explotación de pollos para la producción de carne", Category.SUBCLASS),
        Classification("11233", "Explotación de guajolotes o pavos", Category.CLASS),
        Classification("112330", "Explotación de guajolotes o pavos", Category.SUBCLASS),
        Classification("11234", "Producción de aves en incubadora", Category.CLASS),
        Classification("112340", "Producción de aves en incubadora", Category.SUBCLASS),
        Classification("11239", "Explotación de otras aves para producción de carne y huevo", Category.CLASS),
        Classification("112390", "Explotación de otras aves para producción de carne y huevo", Category.SUBCLASS),
        Classification("1124", "Explotación de ovinos y caprinos", Category.GROUP),
        Classification("11241", "Explotación de ovinos", Category.CLASS),
        Classification("112410", "Explotación de ovinos", Category.SUBCLASS),
        Classification("11242", "Explotación de caprinos", Category.CLASS),
        Classification("112420", "Explotación de caprinos", Category.SUBCLASS),
        Classification("1125", "Acuicultura", Category.GROUP),
        Classification("11251", "Acuicultura", Category.CLASS),
        Classification("112511", "Camaronicultura", Category.SUBCLASS),
        Classification("112512", "Piscicultura y otra acuicultura, excepto camaronicultura", Category.SUBCLASS),
        Classification("1129", "Explotación de otros animales", Category.GROUP),
        Classification("11291", "Apicultura", Category.CLASS),
        Classification("112910", "Apicultura", Category.SUBCLASS),
        Classification("11292", "Explotación de équidos", Category.CLASS),
        Classification("112920", "Explotación de équidos", Category.SUBCLASS),
        Classification("11293", "Cunicultura y explotación de animales con pelaje fino", Category.CLASS),
        Classification("112930", "Cunicultura y explotación de animales con pelaje fino", Category.SUBCLASS),
        Classification("11299", "Explotación de otros animales", Category.CLASS),
        Classification("112991", "Explotación de animales combinada con aprovechamiento forestal", Category.SUBCLASS),
        Classification("112999", "Explotación de otros animales", Category.SUBCLASS),
        Classification("113", "Aprovechamiento forestal", Category.DIVISION),
        Classification("1131", "Silvicultura", Category.GROUP),
        Classification("11311", "Silvicultura", Category.CLASS),
        Classification("113110", "Silvicultura", Category.SUBCLASS),
        Classification("1132", "Viveros forestales y recolección de productos forestales", Category.GROUP),
        Classification("11321", "Viveros forestales y recolección de productos forestales", Category.CLASS),
        Classification("113211", "Viveros forestales", Category.SUBCLASS),
        Classification("113212", "Recolección de productos forestales", Category.SUBCLASS),
        Classification("1133", "Tala de árboles", Category.GROUP),
        Classification("11331", "Tala de árboles", Category.CLASS),
        Classification("113310", "Tala de árboles", Category.SUBCLASS),
        Classification("114", "Pesca, caza y captura", Category.DIVISION),
        Classification("1141", "Pesca", Category.GROUP),
        Classification("11411", "Pesca", Category.CLASS),
        Classification("114111", "Pesca de camarón", Category.SUBCLASS),
        Classification("114112", "Pesca de túnidos", Category.SUBCLASS),
        Classification("114113", "Pesca de sardina y anchoveta", Category.SUBCLASS),
        Classification(
            "114119", "Pesca y captura de otros peces, crustáceos, moluscos y otras especies", Category.SUBCLASS
        ),
        Classification("1142", "Caza y captura", Category.GROUP),
        Classification("11421", "Caza y captura", Category.CLASS),
        Classification("114210", "Caza y captura", Category.SUBCLASS),
        Classification(
            "115", "Servicios relacionados con las actividades agropecuarias y forestales", Category.DIVISION
        ),
        Classification("1151", "Servicios relacionados con la agricultura", Category.GROUP),
        Classification("11511", "Servicios relacionados con la agricultura", Category.CLASS),
        Classification("115111", "Servicios de fumigación agrícola", Category.SUBCLASS),
        Classification("115112", "Despepite de algodón", Category.SUBCLASS),
        Classification("115113", "Beneficio de productos agrícolas", Category.SUBCLASS),
        Classification("115119", "Otros servicios relacionados con la agricultura", Category.SUBCLASS),
        Classification("1152", "Servicios relacionados con la cría y explotación de animales", Category.GROUP),
        Classification("11521", "Servicios relacionados con la cría y explotación de animales", Category.CLASS),
        Classification("115210", "Servicios relacionados con la cría y explotación de animales", Category.SUBCLASS),
        Classification("1153", "Servicios relacionados con el aprovechamiento forestal", Category.GROUP),
        Classification("11531", "Servicios relacionados con el aprovechamiento forestal", Category.CLASS),
        Classification("115310", "Servicios relacionados con el aprovechamiento forestal", Category.SUBCLASS),
        Classification("21", "Minería", Category.SECTION),
        Classification("211", "Extracción de petróleo y gas", Category.DIVISION),
        Classification("2111", "Extracción de petróleo y gas", Category.GROUP),
        Classification("21111", "Extracción de petróleo y gas", Category.CLASS),
        Classification("211111", "Extracción de petróleo y gas natural asociado", Category.SUBCLASS),
        Classification("211112", "Extracción de gas natural no asociado", Category.SUBCLASS),
        Classification(
            "212", "Minería de minerales metálicos y no metálicos, excepto petróleo y gas", Category.DIVISION
        ),
        Classification("2121", "Minería de carbón mineral", Category.GROUP),
        Classification("21211", "Minería de carbón mineral", Category.CLASS),
        Classification("212110", "Minería de carbón mineral", Category.SUBCLASS),
        Classification("2122", "Minería de minerales metálicos", Category.GROUP),
        Classification("21221", "Minería de hierro", Category.CLASS),
        Classification("212210", "Minería de hierro", Category.SUBCLASS),
        Classification("21222", "Minería de oro y plata", Category.CLASS),
        Classification("212221", "Minería de oro", Category.SUBCLASS),
        Classification("212222", "Minería de plata", Category.SUBCLASS),
        Classification("21223", "Minería de cobre, plomo y zinc", Category.CLASS),
        Classification("212231", "Minería de cobre", Category.SUBCLASS),
        Classification("212232", "Minería de plomo y zinc", Category.SUBCLASS),
        Classification("21229", "Minería de otros minerales metálicos", Category.CLASS),
        Classification("212291", "Minería de manganeso", Category.SUBCLASS),
        Classification("212292", "Minería de mercurio y antimonio", Category.SUBCLASS),
        Classification("212293", "Minería de uranio y minerales radiactivos", Category.SUBCLASS),
        Classification("212299", "Minería de otros minerales metálicos", Category.SUBCLASS),
        Classification("2123", "Minería de minerales no metálicos", Category.GROUP),
        Classification("21231", "Minería de piedra caliza, mármol y otras piedras dimensionadas", Category.CLASS),
        Classification("212311", "Minería de piedra caliza", Category.SUBCLASS),
        Classification("212312", "Minería de mármol", Category.SUBCLASS),
        Classification("212319", "Minería de otras piedras dimensionadas", Category.SUBCLASS),
        Classification(
            "21232",
            "Minería de arena, grava, tezontle, tepetate, arcillas y de otros minerales refractarios",
            Category.CLASS,
        ),
        Classification("212321", "Minería de arena y grava para la construcción", Category.SUBCLASS),
        Classification("212322", "Minería de tezontle y tepetate", Category.SUBCLASS),
        Classification("212323", "Minería de feldespato", Category.SUBCLASS),
        Classification("212324", "Minería de sílice", Category.SUBCLASS),
        Classification("212325", "Minería de caolín", Category.SUBCLASS),
        Classification("212329", "Minería de otras arcillas y de otros minerales refractarios", Category.SUBCLASS),
        Classification("21239", "Minería de otros minerales no metálicos", Category.CLASS),
        Classification("212391", "Minería de sal", Category.SUBCLASS),
        Classification("212392", "Minería de piedra de yeso", Category.SUBCLASS),
        Classification("212393", "Minería de barita", Category.SUBCLASS),
        Classification("212394", "Minería de roca fosfórica", Category.SUBCLASS),
        Classification("212395", "Minería de fluorita", Category.SUBCLASS),
        Classification("212396", "Minería de grafito", Category.SUBCLASS),
        Classification("212397", "Minería de azufre", Category.SUBCLASS),
        Classification("212398", "Minería de minerales no metálicos para productos químicos", Category.SUBCLASS),
        Classification("212399", "Minería de otros minerales no metálicos", Category.SUBCLASS),
        Classification("213", "Servicios relacionados con la minería", Category.DIVISION),
        Classification("2131", "Servicios relacionados con la minería", Category.GROUP),
        Classification("21311", "Servicios relacionados con la minería", Category.CLASS),
        Classification("213111", "Perforación de pozos petroleros y de gas", Category.SUBCLASS),
        Classification("213119", "Otros servicios relacionados con la minería", Category.SUBCLASS),
        Classification(
            "22",
            "Generación, transmisión, distribución y comercialización de energía eléctrica, suministro de agua y de gas natural por ductos al consumidor final",
            Category.SECTION,
        ),
        Classification(
            "221",
            "Generación, transmisión, distribución y comercialización de energía eléctrica, suministro de agua y de gas natural por ductos al consumidor final",
            Category.DIVISION,
        ),
        Classification(
            "2211", "Generación, transmisión, distribución y comercialización de energía eléctrica", Category.GROUP
        ),
        Classification("22111", "Generación de energía eléctrica", Category.CLASS),
        Classification("221111", "Generación de electricidad a partir de combustibles fósiles", Category.SUBCLASS),
        Classification("221112", "Generación de electricidad a partir de energía hidráulica", Category.SUBCLASS),
        Classification("221113", "Generación de electricidad a partir de energía solar", Category.SUBCLASS),
        Classification("221114", "Generación de electricidad a partir de energía eólica", Category.SUBCLASS),
        Classification("221119", "Generación de electricidad a partir de otro tipo de energía", Category.SUBCLASS),
        Classification("22112", "Transmisión, distribución y comercialización de energía eléctrica", Category.CLASS),
        Classification("221121", "Transmisión de energía eléctrica", Category.SUBCLASS),
        Classification("221122", "Distribución de energía eléctrica", Category.SUBCLASS),
        Classification("221123", "Comercialización de energía eléctrica", Category.SUBCLASS),
        Classification("2212", "Suministro de gas natural por ductos al consumidor final", Category.GROUP),
        Classification("22121", "Suministro de gas natural por ductos al consumidor final", Category.CLASS),
        Classification("221210", "Suministro de gas natural por ductos al consumidor final", Category.SUBCLASS),
        Classification("2213", "Captación, tratamiento y suministro de agua", Category.GROUP),
        Classification("22131", "Captación, tratamiento y suministro de agua", Category.CLASS),
        Classification(
            "221311", "Captación, tratamiento y suministro de agua realizados por el sector privado", Category.SUBCLASS
        ),
        Classification(
            "221312", "Captación, tratamiento y suministro de agua realizados por el sector público", Category.SUBCLASS
        ),
        Classification("23", "Construcción", Category.SECTION),
        Classification("236", "Edificación", Category.DIVISION),
        Classification("2361", "Edificación residencial", Category.GROUP),
        Classification("23611", "Edificación residencial", Category.CLASS),
        Classification("236111", "Edificación de vivienda unifamiliar", Category.SUBCLASS),
        Classification("236112", "Edificación de vivienda multifamiliar", Category.SUBCLASS),
        Classification("236113", "Supervisión de edificación residencial", Category.SUBCLASS),
        Classification("2362", "Edificación no residencial", Category.GROUP),
        Classification("23621", "Edificación de naves y plantas industriales", Category.CLASS),
        Classification(
            "236211", "Edificación de naves y plantas industriales, excepto la supervisión", Category.SUBCLASS
        ),
        Classification("236212", "Supervisión de edificación de naves y plantas industriales", Category.SUBCLASS),
        Classification("23622", "Edificación de inmuebles comerciales y de servicios", Category.CLASS),
        Classification(
            "236221", "Edificación de inmuebles comerciales y de servicios, excepto la supervisión", Category.SUBCLASS
        ),
        Classification(
            "236222", "Supervisión de edificación de inmuebles comerciales y de servicios", Category.SUBCLASS
        ),
        Classification("237", "Construcción de obras de ingeniería civil", Category.DIVISION),
        Classification(
            "2371",
            "Construcción de obras para el suministro de agua, petróleo, gas, energía eléctrica y telecomunicaciones",
            Category.GROUP,
        ),
        Classification(
            "23711",
            "Construcción de obras para el tratamiento, distribución y suministro de agua, drenaje y riego",
            Category.CLASS,
        ),
        Classification(
            "237111",
            "Construcción de obras para el tratamiento, distribución y suministro de agua y drenaje ",
            Category.SUBCLASS,
        ),
        Classification("237112", "Construcción de sistemas de riego agrícola", Category.SUBCLASS),
        Classification(
            "237113",
            "Supervisión de construcción de obras para el tratamiento, distribución y suministro de agua, drenaje y riego ",
            Category.SUBCLASS,
        ),
        Classification("23712", "Construcción de obras para petróleo y gas", Category.CLASS),
        Classification("237121", "Construcción de sistemas de distribución de petróleo y gas", Category.SUBCLASS),
        Classification("237122", "Construcción de plantas de refinería y petroquímica", Category.SUBCLASS),
        Classification("237123", "Supervisión de construcción de obras para petróleo y gas", Category.SUBCLASS),
        Classification(
            "23713",
            "Construcción de obras de generación y conducción de energía eléctrica y de obras para telecomunicaciones",
            Category.CLASS,
        ),
        Classification(
            "237131", "Construcción de obras de generación y conducción de energía eléctrica", Category.SUBCLASS
        ),
        Classification("237132", "Construcción de obras para telecomunicaciones", Category.SUBCLASS),
        Classification(
            "237133",
            "Supervisión de construcción de obras de generación y conducción de energía eléctrica y de obras para telecomunicaciones ",
            Category.SUBCLASS,
        ),
        Classification("2372", "División de terrenos y construcción de obras de urbanización", Category.GROUP),
        Classification("23721", "División de terrenos y construcción de obras de urbanización", Category.CLASS),
        Classification("237211", "División de terrenos", Category.SUBCLASS),
        Classification("237212", "Construcción de obras de urbanización", Category.SUBCLASS),
        Classification(
            "237213",
            "Supervisión de división de terrenos y de construcción de obras de urbanización ",
            Category.SUBCLASS,
        ),
        Classification("2373", "Construcción de vías de comunicación", Category.GROUP),
        Classification("23731", "Construcción de vías de comunicación", Category.CLASS),
        Classification("237311", "Instalación de señalamientos y protecciones en obras viales", Category.SUBCLASS),
        Classification("237312", "Construcción de carreteras, puentes y similares", Category.SUBCLASS),
        Classification("237313", "Supervisión de construcción de vías de comunicación", Category.SUBCLASS),
        Classification("2379", "Otras construcciones de ingeniería civil", Category.GROUP),
        Classification("23799", "Otras construcciones de ingeniería civil", Category.CLASS),
        Classification("237991", "Construcción de presas y represas", Category.SUBCLASS),
        Classification("237992", "Construcción de obras marítimas, fluviales y subacuáticas", Category.SUBCLASS),
        Classification("237993", "Construcción de obras para transporte eléctrico y ferroviario", Category.SUBCLASS),
        Classification("237994", "Supervisión de construcción de otras obras de ingeniería civil", Category.SUBCLASS),
        Classification("237999", "Otras construcciones de ingeniería civil", Category.SUBCLASS),
        Classification("238", "Trabajos especializados para la construcción", Category.DIVISION),
        Classification(
            "2381", "Cimentaciones, montaje de estructuras prefabricadas y trabajos en exteriores", Category.GROUP
        ),
        Classification("23811", "Trabajos de cimentaciones", Category.CLASS),
        Classification("238110", "Trabajos de cimentaciones", Category.SUBCLASS),
        Classification("23812", "Montaje de estructuras prefabricadas", Category.CLASS),
        Classification("238121", "Montaje de estructuras de concreto prefabricadas", Category.SUBCLASS),
        Classification("238122", "Montaje de estructuras de acero prefabricadas", Category.SUBCLASS),
        Classification("23813", "Trabajos de albañilería", Category.CLASS),
        Classification("238130", "Trabajos de albañilería", Category.SUBCLASS),
        Classification("23819", "Otros trabajos en exteriores", Category.CLASS),
        Classification("238190", "Otros trabajos en exteriores", Category.SUBCLASS),
        Classification("2382", "Instalaciones y equipamiento en construcciones", Category.GROUP),
        Classification("23821", "Instalaciones eléctricas en construcciones", Category.CLASS),
        Classification("238210", "Instalaciones eléctricas en construcciones", Category.SUBCLASS),
        Classification(
            "23822",
            "Instalaciones hidrosanitarias, de gas, sistemas centrales de aire acondicionado y calefacción",
            Category.CLASS,
        ),
        Classification("238221", "Instalaciones hidrosanitarias y de gas", Category.SUBCLASS),
        Classification(
            "238222", "Instalaciones de sistemas centrales de aire acondicionado y calefacción", Category.SUBCLASS
        ),
        Classification("23829", "Otras instalaciones y equipamiento en construcciones", Category.CLASS),
        Classification("238290", "Otras instalaciones y equipamiento en construcciones", Category.SUBCLASS),
        Classification("2383", "Trabajos de acabados en edificaciones", Category.GROUP),
        Classification("23831", "Colocación de muros falsos, aislamiento y enyesado", Category.CLASS),
        Classification("238311", "Colocación de muros falsos y aislamiento", Category.SUBCLASS),
        Classification("238312", "Trabajos de enyesado, empastado y tiroleado", Category.SUBCLASS),
        Classification("23832", "Trabajos de pintura y otros cubrimientos de paredes", Category.CLASS),
        Classification("238320", "Trabajos de pintura y otros cubrimientos de paredes", Category.SUBCLASS),
        Classification("23833", "Colocación de pisos flexibles y de madera", Category.CLASS),
        Classification("238330", "Colocación de pisos flexibles y de madera", Category.SUBCLASS),
        Classification("23834", "Colocación de pisos cerámicos y azulejos", Category.CLASS),
        Classification("238340", "Colocación de pisos cerámicos y azulejos", Category.SUBCLASS),
        Classification(
            "23835", "Realización de trabajos de carpintería en el lugar de la construcción", Category.CLASS
        ),
        Classification(
            "238350", "Realización de trabajos de carpintería en el lugar de la construcción", Category.SUBCLASS
        ),
        Classification("23839", "Otros trabajos de acabados en edificaciones", Category.CLASS),
        Classification("238390", "Otros trabajos de acabados en edificaciones", Category.SUBCLASS),
        Classification("2389", "Otros trabajos especializados para la construcción", Category.GROUP),
        Classification("23891", "Preparación de terrenos para la construcción", Category.CLASS),
        Classification("238910", "Preparación de terrenos para la construcción", Category.SUBCLASS),
        Classification("23899", "Otros trabajos especializados para la construcción", Category.CLASS),
        Classification("238990", "Otros trabajos especializados para la construcción", Category.SUBCLASS),
        Classification("31-33", "Industrias manufactureras", Category.CLASS),
        Classification("311", "Industria alimentaria", Category.DIVISION),
        Classification("3111", "Elaboración de alimentos para animales", Category.GROUP),
        Classification("31111", "Elaboración de alimentos para animales", Category.CLASS),
        Classification("311110", "Elaboración de alimentos para animales", Category.SUBCLASS),
        Classification("3112", "Molienda de granos y de semillas y obtención de aceites y grasas", Category.GROUP),
        Classification(
            "31121", "Beneficio del arroz, elaboración de productos de molinería, y de malta", Category.CLASS
        ),
        Classification("311211", "Beneficio del arroz", Category.SUBCLASS),
        Classification("311212", "Elaboración de harina de trigo", Category.SUBCLASS),
        Classification("311213", "Elaboración de harina de maíz", Category.SUBCLASS),
        Classification("311214", "Elaboración de harina de otros productos agrícolas", Category.SUBCLASS),
        Classification("311215", "Elaboración de malta", Category.SUBCLASS),
        Classification("31122", "Elaboración de almidones, aceites y grasas vegetales comestibles", Category.CLASS),
        Classification("311221", "Elaboración de féculas y otros almidones y sus derivados", Category.SUBCLASS),
        Classification("311222", "Elaboración de aceites y grasas vegetales comestibles", Category.SUBCLASS),
        Classification("31123", "Elaboración de cereales para el desayuno", Category.CLASS),
        Classification("311230", "Elaboración de cereales para el desayuno", Category.SUBCLASS),
        Classification("3113", "Elaboración de azúcares, chocolates, dulces y similares", Category.GROUP),
        Classification("31131", "Elaboración de azúcares", Category.CLASS),
        Classification("311311", "Elaboración de azúcar de caña", Category.SUBCLASS),
        Classification("311319", "Elaboración de otros azúcares", Category.SUBCLASS),
        Classification(
            "31134", "Elaboración de dulces, chicles y productos de confitería que no sean de chocolate", Category.CLASS
        ),
        Classification(
            "311340",
            "Elaboración de dulces, chicles y productos de confitería que no sean de chocolate ",
            Category.SUBCLASS,
        ),
        Classification("31135", "Elaboración de chocolate y productos de chocolate", Category.CLASS),
        Classification("311350", "Elaboración de chocolate y productos de chocolate", Category.SUBCLASS),
        Classification("3114", "Conservación de frutas, verduras, guisos y otros alimentos preparados", Category.GROUP),
        Classification("31141", "Congelación de frutas, verduras, guisos y otros alimentos preparados", Category.CLASS),
        Classification("311411", "Congelación de frutas y verduras", Category.SUBCLASS),
        Classification("311412", "Congelación de guisos y otros alimentos preparados", Category.SUBCLASS),
        Classification(
            "31142",
            "Conservación de frutas, verduras, guisos y otros alimentos preparados por procesos distintos a la congelación",
            Category.CLASS,
        ),
        Classification("311421", "Deshidratación de frutas y verduras", Category.SUBCLASS),
        Classification(
            "311422",
            "Conservación de frutas y verduras por procesos distintos a la congelación y la deshidratación ",
            Category.SUBCLASS,
        ),
        Classification(
            "311423",
            "Conservación de guisos y otros alimentos preparados por procesos distintos a la congelación ",
            Category.SUBCLASS,
        ),
        Classification("3115", "Elaboración de productos lácteos", Category.GROUP),
        Classification("31151", "Elaboración de leche y derivados lácteos", Category.CLASS),
        Classification("311511", "Elaboración de leche líquida", Category.SUBCLASS),
        Classification("311512", "Elaboración de leche en polvo, condensada y evaporada", Category.SUBCLASS),
        Classification("311513", "Elaboración de derivados y fermentos lácteos", Category.SUBCLASS),
        Classification("31152", "Elaboración de helados y paletas", Category.CLASS),
        Classification("311520", "Elaboración de helados y paletas", Category.SUBCLASS),
        Classification(
            "3116",
            "Matanza, empacado y procesamiento de carne de ganado, aves y otros animales comestibles",
            Category.GROUP,
        ),
        Classification(
            "31161",
            "Matanza, empacado y procesamiento de carne de ganado, aves y otros animales comestibles",
            Category.CLASS,
        ),
        Classification("311611", "Matanza de ganado, aves y otros animales comestibles", Category.SUBCLASS),
        Classification(
            "311612", "Corte y empacado de carne de ganado, aves y otros animales comestibles", Category.SUBCLASS
        ),
        Classification(
            "311613",
            "Preparación de embutidos y otras conservas de carne de ganado, aves y otros animales comestibles ",
            Category.SUBCLASS,
        ),
        Classification("311614", "Elaboración de manteca y otras grasas animales comestibles", Category.SUBCLASS),
        Classification("3117", "Preparación y envasado de pescados y mariscos", Category.GROUP),
        Classification("31171", "Preparación y envasado de pescados y mariscos", Category.CLASS),
        Classification("311710", "Preparación y envasado de pescados y mariscos", Category.SUBCLASS),
        Classification("3118", "Elaboración de productos de panadería y tortillas", Category.GROUP),
        Classification("31181", "Elaboración de pan y otros productos de panadería", Category.CLASS),
        Classification("311811", "Panificación industrial", Category.SUBCLASS),
        Classification("311812", "Panificación tradicional", Category.SUBCLASS),
        Classification("311813", "Elaboración de tortillas de harina de trigo de forma tradicional", Category.SUBCLASS),
        Classification("31182", "Elaboración de galletas y pastas para sopa", Category.CLASS),
        Classification("311820", "Elaboración de galletas y pastas para sopa", Category.SUBCLASS),
        Classification("31183", "Elaboración de tortillas de maíz y molienda de nixtamal", Category.CLASS),
        Classification("311830", "Elaboración de tortillas de maíz y molienda de nixtamal", Category.SUBCLASS),
        Classification("3119", "Otras industrias alimentarias", Category.GROUP),
        Classification("31191", "Elaboración de botanas", Category.CLASS),
        Classification("311910", "Elaboración de botanas", Category.SUBCLASS),
        Classification("31192", "Industrias del café y del té", Category.CLASS),
        Classification("311921", "Beneficio del café", Category.SUBCLASS),
        Classification("311922", "Elaboración de café tostado y molido", Category.SUBCLASS),
        Classification("311923", "Elaboración de café instantáneo", Category.SUBCLASS),
        Classification("311924", "Preparación y envasado de té", Category.SUBCLASS),
        Classification(
            "31193", "Elaboración de concentrados, polvos, jarabes y esencias de sabor para bebidas", Category.CLASS
        ),
        Classification(
            "311930",
            "Elaboración de concentrados, polvos, jarabes y esencias de sabor para bebidas ",
            Category.SUBCLASS,
        ),
        Classification("31194", "Elaboración de condimentos y aderezos", Category.CLASS),
        Classification("311940", "Elaboración de condimentos y aderezos", Category.SUBCLASS),
        Classification("31199", "Elaboración de otros alimentos", Category.CLASS),
        Classification("311991", "Elaboración de gelatinas y otros postres en polvo", Category.SUBCLASS),
        Classification("311992", "Elaboración de levadura", Category.SUBCLASS),
        Classification("311993", "Elaboración de alimentos frescos para consumo inmediato", Category.SUBCLASS),
        Classification("311999", "Elaboración de otros alimentos", Category.SUBCLASS),
        Classification("312", "Industria de las bebidas y del tabaco", Category.DIVISION),
        Classification("3121", "Industria de las bebidas", Category.GROUP),
        Classification(
            "31211",
            "Elaboración de refrescos, hielo y otras bebidas no alcohólicas, y purificación y embotellado de agua",
            Category.CLASS,
        ),
        Classification("312111", "Elaboración de refrescos y otras bebidas no alcohólicas", Category.SUBCLASS),
        Classification("312112", "Purificación y embotellado de agua", Category.SUBCLASS),
        Classification("312113", "Elaboración de hielo", Category.SUBCLASS),
        Classification("31212", "Elaboración de cerveza", Category.CLASS),
        Classification("312120", "Elaboración de cerveza", Category.SUBCLASS),
        Classification(
            "31213",
            "Elaboración de bebidas alcohólicas a base de uva y bebidas fermentadas, excepto cerveza",
            Category.CLASS,
        ),
        Classification("312131", "Elaboración de bebidas alcohólicas a base de uva", Category.SUBCLASS),
        Classification("312132", "Elaboración de pulque", Category.SUBCLASS),
        Classification("312139", "Elaboración de sidra y otras bebidas fermentadas", Category.SUBCLASS),
        Classification("31214", "Elaboración de bebidas destiladas, excepto de uva", Category.CLASS),
        Classification("312141", "Elaboración de ron y otras bebidas destiladas de caña", Category.SUBCLASS),
        Classification("312142", "Elaboración de bebidas destiladas de agave", Category.SUBCLASS),
        Classification("312143", "Obtención de alcohol etílico potable", Category.SUBCLASS),
        Classification("312149", "Elaboración de otras bebidas destiladas", Category.SUBCLASS),
        Classification("3122", "Industria del tabaco", Category.GROUP),
        Classification("31221", "Beneficio del tabaco", Category.CLASS),
        Classification("312210", "Beneficio del tabaco", Category.SUBCLASS),
        Classification("31222", "Elaboración de productos de tabaco", Category.CLASS),
        Classification("312221", "Elaboración de cigarros", Category.SUBCLASS),
        Classification("312222", "Elaboración de puros y otros productos de tabaco", Category.SUBCLASS),
        Classification("313", "Fabricación de insumos textiles y acabado de textiles", Category.DIVISION),
        Classification("3131", "Preparación e hilado de fibras textiles, y fabricación de hilos", Category.GROUP),
        Classification("31311", "Preparación e hilado de fibras textiles, y fabricación de hilos", Category.CLASS),
        Classification("313111", "Preparación e hilado de fibras duras naturales", Category.SUBCLASS),
        Classification("313112", "Preparación e hilado de fibras blandas naturales", Category.SUBCLASS),
        Classification("313113", "Fabricación de hilos para coser y bordar", Category.SUBCLASS),
        Classification("3132", "Fabricación de telas", Category.GROUP),
        Classification("31321", "Fabricación de telas anchas de tejido de trama", Category.CLASS),
        Classification("313210", "Fabricación de telas anchas de tejido de trama", Category.SUBCLASS),
        Classification("31322", "Fabricación de telas angostas de tejido de trama y pasamanería", Category.CLASS),
        Classification("313220", "Fabricación de telas angostas de tejido de trama y pasamanería", Category.SUBCLASS),
        Classification("31323", "Fabricación de telas no tejidas (comprimidas)", Category.CLASS),
        Classification("313230", "Fabricación de telas no tejidas (comprimidas)", Category.SUBCLASS),
        Classification("31324", "Fabricación de telas de tejido de punto", Category.CLASS),
        Classification("313240", "Fabricación de telas de tejido de punto", Category.SUBCLASS),
        Classification("3133", "Acabado de productos textiles y fabricación de telas recubiertas", Category.GROUP),
        Classification("31331", "Acabado de productos textiles", Category.CLASS),
        Classification("313310", "Acabado de productos textiles", Category.SUBCLASS),
        Classification("31332", "Fabricación de telas recubiertas", Category.CLASS),
        Classification("313320", "Fabricación de telas recubiertas", Category.SUBCLASS),
        Classification("314", "Fabricación de productos textiles, excepto prendas de vestir", Category.DIVISION),
        Classification("3141", "Confección de alfombras, blancos y similares", Category.GROUP),
        Classification("31411", "Fabricación de alfombras y tapetes", Category.CLASS),
        Classification("314110", "Fabricación de alfombras y tapetes", Category.SUBCLASS),
        Classification("31412", "Confección de cortinas, blancos y similares", Category.CLASS),
        Classification("314120", "Confección de cortinas, blancos y similares", Category.SUBCLASS),
        Classification("3149", "Fabricación de otros productos textiles, excepto prendas de vestir", Category.GROUP),
        Classification(
            "31491",
            "Confección de costales y productos de textiles recubiertos y de materiales sucedáneos",
            Category.CLASS,
        ),
        Classification("314911", "Confección de costales", Category.SUBCLASS),
        Classification(
            "314912", "Confección de productos de textiles recubiertos y de materiales sucedáneos", Category.SUBCLASS
        ),
        Classification(
            "31499", "Fabricación de otros productos textiles no clasificados en otra parte", Category.CLASS
        ),
        Classification("314991", "Confección, bordado y deshilado de productos textiles", Category.SUBCLASS),
        Classification("314992", "Fabricación de redes y otros productos de cordelería", Category.SUBCLASS),
        Classification("314993", "Fabricación de productos textiles reciclados", Category.SUBCLASS),
        Classification(
            "314999",
            "Fabricación de banderas y otros productos textiles no clasificados en otra parte ",
            Category.SUBCLASS,
        ),
        Classification("315", "Fabricación de prendas de vestir", Category.DIVISION),
        Classification("3151", "Fabricación de prendas de vestir de tejido de punto", Category.GROUP),
        Classification("31511", "Fabricación de calcetines y medias de tejido de punto", Category.CLASS),
        Classification("315110", "Fabricación de calcetines y medias de tejido de punto", Category.SUBCLASS),
        Classification("31519", "Fabricación de otras prendas de vestir de tejido de punto", Category.CLASS),
        Classification("315191", "Fabricación de ropa interior de tejido de punto", Category.SUBCLASS),
        Classification("315192", "Fabricación de ropa exterior de tejido de punto", Category.SUBCLASS),
        Classification("3152", "Confección de prendas de vestir", Category.GROUP),
        Classification(
            "31521", "Confección de prendas de vestir de cuero, piel y materiales sucedáneos", Category.CLASS
        ),
        Classification(
            "315210", "Confección de prendas de vestir de cuero, piel y materiales sucedáneos", Category.SUBCLASS
        ),
        Classification("31522", "Confección de prendas de vestir de materiales textiles", Category.CLASS),
        Classification("315221", "Confección en serie de ropa interior y de dormir", Category.SUBCLASS),
        Classification("315222", "Confección en serie de camisas", Category.SUBCLASS),
        Classification("315223", "Confección en serie de uniformes", Category.SUBCLASS),
        Classification("315224", "Confección en serie de disfraces y trajes típicos", Category.SUBCLASS),
        Classification("315225", "Confección de prendas de vestir sobre medida", Category.SUBCLASS),
        Classification("315229", "Confección en serie de otra ropa exterior de materiales textiles", Category.SUBCLASS),
        Classification(
            "3159",
            "Confección de accesorios de vestir y otras prendas de vestir no clasificados en otra parte",
            Category.GROUP,
        ),
        Classification(
            "31599",
            "Confección de accesorios de vestir y otras prendas de vestir no clasificados en otra parte",
            Category.CLASS,
        ),
        Classification("315991", "Confección de sombreros y gorras", Category.SUBCLASS),
        Classification(
            "315999",
            "Confección de otros accesorios y prendas de vestir no clasificados en otra parte ",
            Category.SUBCLASS,
        ),
        Classification(
            "316",
            "Curtido y acabado de cuero y piel, y fabricación de productos de cuero, piel y materiales sucedáneos",
            Category.DIVISION,
        ),
        Classification("3161", "Curtido y acabado de cuero y piel", Category.GROUP),
        Classification("31611", "Curtido y acabado de cuero y piel", Category.CLASS),
        Classification("316110", "Curtido y acabado de cuero y piel", Category.SUBCLASS),
        Classification("3162", "Fabricación de calzado", Category.GROUP),
        Classification("31621", "Fabricación de calzado", Category.CLASS),
        Classification("316211", "Fabricación de calzado con corte de piel y cuero", Category.SUBCLASS),
        Classification("316212", "Fabricación de calzado con corte de tela", Category.SUBCLASS),
        Classification("316213", "Fabricación de calzado de plástico", Category.SUBCLASS),
        Classification("316214", "Fabricación de calzado de hule", Category.SUBCLASS),
        Classification("316219", "Fabricación de huaraches y calzado de otro tipo de materiales", Category.SUBCLASS),
        Classification("3169", "Fabricación de otros productos de cuero, piel y materiales sucedáneos", Category.GROUP),
        Classification(
            "31699", "Fabricación de otros productos de cuero, piel y materiales sucedáneos", Category.CLASS
        ),
        Classification("316991", "Fabricación de bolsos de mano, maletas y similares", Category.SUBCLASS),
        Classification(
            "316999", "Fabricación de otros productos de cuero, piel y materiales sucedáneos", Category.SUBCLASS
        ),
        Classification("321", "Industria de la madera", Category.DIVISION),
        Classification("3211", "Aserrado y conservación de la madera", Category.GROUP),
        Classification("32111", "Aserrado y conservación de la madera", Category.CLASS),
        Classification("321111", "Aserraderos integrados", Category.SUBCLASS),
        Classification("321112", "Aserrado de tablas y tablones", Category.SUBCLASS),
        Classification("321113", "Tratamiento de la madera y fabricación de postes y durmientes", Category.SUBCLASS),
        Classification("3212", "Fabricación de laminados y aglutinados de madera", Category.GROUP),
        Classification("32121", "Fabricación de laminados y aglutinados de madera", Category.CLASS),
        Classification("321210", "Fabricación de laminados y aglutinados de madera", Category.SUBCLASS),
        Classification("3219", "Fabricación de otros productos de madera", Category.GROUP),
        Classification("32191", "Fabricación de productos de madera para la construcción", Category.CLASS),
        Classification("321910", "Fabricación de productos de madera para la construcción", Category.SUBCLASS),
        Classification("32192", "Fabricación de productos para embalaje y envases de madera", Category.CLASS),
        Classification("321920", "Fabricación de productos para embalaje y envases de madera", Category.SUBCLASS),
        Classification(
            "32199",
            "Fabricación de otros productos de madera y de materiales trenzables, excepto palma",
            Category.CLASS,
        ),
        Classification("321991", "Fabricación de productos de materiales trenzables, excepto palma", Category.SUBCLASS),
        Classification("321992", "Fabricación de artículos y utensilios de madera para el hogar", Category.SUBCLASS),
        Classification("321993", "Fabricación de productos de madera de uso industrial", Category.SUBCLASS),
        Classification("321999", "Fabricación de otros productos de madera", Category.SUBCLASS),
        Classification("322", "Industria del papel", Category.DIVISION),
        Classification("3221", "Fabricación de pulpa, papel y cartón", Category.GROUP),
        Classification("32211", "Fabricación de pulpa", Category.CLASS),
        Classification("322110", "Fabricación de pulpa", Category.SUBCLASS),
        Classification("32212", "Fabricación de papel", Category.CLASS),
        Classification("322121", "Fabricación de papel en plantas integradas", Category.SUBCLASS),
        Classification("322122", "Fabricación de papel a partir de pulpa", Category.SUBCLASS),
        Classification("32213", "Fabricación de cartón", Category.CLASS),
        Classification("322131", "Fabricación de cartón en plantas integradas", Category.SUBCLASS),
        Classification("322132", "Fabricación de cartón y cartoncillo a partir de pulpa", Category.SUBCLASS),
        Classification("3222", "Fabricación de productos de cartón y papel", Category.GROUP),
        Classification("32221", "Fabricación de envases de cartón", Category.CLASS),
        Classification("322210", "Fabricación de envases de cartón", Category.SUBCLASS),
        Classification(
            "32222", "Fabricación de bolsas de papel y productos celulósicos recubiertos y tratados", Category.CLASS
        ),
        Classification(
            "322220",
            "Fabricación de bolsas de papel y productos celulósicos recubiertos y tratados ",
            Category.SUBCLASS,
        ),
        Classification("32223", "Fabricación de productos de papelería", Category.CLASS),
        Classification("322230", "Fabricación de productos de papelería", Category.SUBCLASS),
        Classification("32229", "Fabricación de otros productos de cartón y papel", Category.CLASS),
        Classification("322291", "Fabricación de pañales desechables y productos sanitarios", Category.SUBCLASS),
        Classification("322299", "Fabricación de otros productos de cartón y papel", Category.SUBCLASS),
        Classification("323", "Impresión e industrias conexas", Category.DIVISION),
        Classification("3231", "Impresión e industrias conexas", Category.GROUP),
        Classification("32311", "Impresión", Category.CLASS),
        Classification("323111", "Impresión de libros, periódicos y revistas", Category.SUBCLASS),
        Classification("323119", "Impresión de formas continuas y otros impresos", Category.SUBCLASS),
        Classification("32312", "Industrias conexas a la impresión", Category.CLASS),
        Classification("323120", "Industrias conexas a la impresión", Category.SUBCLASS),
        Classification("324", "Fabricación de productos derivados del petróleo y del carbón", Category.DIVISION),
        Classification("3241", "Fabricación de productos derivados del petróleo y del carbón", Category.GROUP),
        Classification("32411", "Refinación de petróleo", Category.CLASS),
        Classification("324110", "Refinación de petróleo", Category.SUBCLASS),
        Classification("32412", "Fabricación de productos de asfalto", Category.CLASS),
        Classification("324120", "Fabricación de productos de asfalto", Category.SUBCLASS),
        Classification(
            "32419",
            "Fabricación de otros productos derivados del petróleo refinado y del carbón mineral",
            Category.CLASS,
        ),
        Classification("324191", "Fabricación de aceites y grasas lubricantes", Category.SUBCLASS),
        Classification(
            "324199",
            "Fabricación de coque y otros productos derivados del petróleo refinado y del carbón mineral ",
            Category.SUBCLASS,
        ),
        Classification("325", "Industria química", Category.DIVISION),
        Classification("3251", "Fabricación de productos químicos básicos", Category.GROUP),
        Classification(
            "32511", "Fabricación de petroquímicos básicos del gas natural y del petróleo refinado", Category.CLASS
        ),
        Classification(
            "325110", "Fabricación de petroquímicos básicos del gas natural y del petróleo refinado", Category.SUBCLASS
        ),
        Classification("32512", "Fabricación de gases industriales", Category.CLASS),
        Classification("325120", "Fabricación de gases industriales", Category.SUBCLASS),
        Classification("32513", "Fabricación de pigmentos y colorantes sintéticos", Category.CLASS),
        Classification("325130", "Fabricación de pigmentos y colorantes sintéticos", Category.SUBCLASS),
        Classification("32518", "Fabricación de otros productos químicos básicos inorgánicos", Category.CLASS),
        Classification("325180", "Fabricación de otros productos químicos básicos inorgánicos", Category.SUBCLASS),
        Classification("32519", "Fabricación de otros productos químicos básicos orgánicos", Category.CLASS),
        Classification("325190", "Fabricación de otros productos químicos básicos orgánicos", Category.SUBCLASS),
        Classification("3252", "Fabricación de resinas y hules sintéticos, y fibras químicas", Category.GROUP),
        Classification("32521", "Fabricación de resinas y hules sintéticos", Category.CLASS),
        Classification("325211", "Fabricación de resinas sintéticas", Category.SUBCLASS),
        Classification("325212", "Fabricación de hules sintéticos", Category.SUBCLASS),
        Classification("32522", "Fabricación de fibras químicas", Category.CLASS),
        Classification("325220", "Fabricación de fibras químicas", Category.SUBCLASS),
        Classification("3253", "Fabricación de fertilizantes, pesticidas y otros agroquímicos", Category.GROUP),
        Classification("32531", "Fabricación de fertilizantes", Category.CLASS),
        Classification("325310", "Fabricación de fertilizantes", Category.SUBCLASS),
        Classification(
            "32532", "Fabricación de pesticidas y otros agroquímicos, excepto fertilizantes", Category.CLASS
        ),
        Classification(
            "325320", "Fabricación de pesticidas y otros agroquímicos, excepto fertilizantes", Category.SUBCLASS
        ),
        Classification("3254", "Fabricación de productos farmacéuticos", Category.GROUP),
        Classification("32541", "Fabricación de productos farmacéuticos", Category.CLASS),
        Classification("325411", "Fabricación de materias primas para la industria farmacéutica", Category.SUBCLASS),
        Classification("325412", "Fabricación de preparaciones farmacéuticas", Category.SUBCLASS),
        Classification("3255", "Fabricación de pinturas, recubrimientos y adhesivos", Category.GROUP),
        Classification("32551", "Fabricación de pinturas y recubrimientos", Category.CLASS),
        Classification("325510", "Fabricación de pinturas y recubrimientos", Category.SUBCLASS),
        Classification("32552", "Fabricación de adhesivos", Category.CLASS),
        Classification("325520", "Fabricación de adhesivos", Category.SUBCLASS),
        Classification("3256", "Fabricación de jabones, limpiadores y preparaciones de tocador", Category.GROUP),
        Classification("32561", "Fabricación de jabones, limpiadores y dentífricos", Category.CLASS),
        Classification("325610", "Fabricación de jabones, limpiadores y dentífricos", Category.SUBCLASS),
        Classification("32562", "Fabricación de cosméticos, perfumes y otras preparaciones de tocador", Category.CLASS),
        Classification(
            "325620", "Fabricación de cosméticos, perfumes y otras preparaciones de tocador", Category.SUBCLASS
        ),
        Classification("3259", "Fabricación de otros productos químicos", Category.GROUP),
        Classification("32591", "Fabricación de tintas para impresión", Category.CLASS),
        Classification("325910", "Fabricación de tintas para impresión", Category.SUBCLASS),
        Classification("32592", "Fabricación de explosivos", Category.CLASS),
        Classification("325920", "Fabricación de explosivos", Category.SUBCLASS),
        Classification("32599", "Fabricación de otros productos químicos", Category.CLASS),
        Classification("325991", "Fabricación de cerillos", Category.SUBCLASS),
        Classification(
            "325992", "Fabricación de películas, placas y papel fotosensible para fotografía", Category.SUBCLASS
        ),
        Classification("325993", "Fabricación de resinas de plásticos reciclados", Category.SUBCLASS),
        Classification("325999", "Fabricación de otros productos químicos", Category.SUBCLASS),
        Classification("326", "Industria del plástico y del hule", Category.DIVISION),
        Classification("3261", "Fabricación de productos de plástico", Category.GROUP),
        Classification("32611", "Fabricación de bolsas y películas de plástico flexible", Category.CLASS),
        Classification("326110", "Fabricación de bolsas y películas de plástico flexible", Category.SUBCLASS),
        Classification("32612", "Fabricación de tubería y conexiones, y tubos para embalaje", Category.CLASS),
        Classification("326120", "Fabricación de tubería y conexiones, y tubos para embalaje", Category.SUBCLASS),
        Classification("32613", "Fabricación de laminados de plástico rígido", Category.CLASS),
        Classification("326130", "Fabricación de laminados de plástico rígido", Category.SUBCLASS),
        Classification("32614", "Fabricación de espumas y productos de poliestireno", Category.CLASS),
        Classification("326140", "Fabricación de espumas y productos de poliestireno", Category.SUBCLASS),
        Classification("32615", "Fabricación de espumas y productos de uretano", Category.CLASS),
        Classification("326150", "Fabricación de espumas y productos de uretano", Category.SUBCLASS),
        Classification("32616", "Fabricación de botellas de plástico", Category.CLASS),
        Classification("326160", "Fabricación de botellas de plástico", Category.SUBCLASS),
        Classification("32619", "Fabricación de otros productos de plástico", Category.CLASS),
        Classification(
            "326191", "Fabricación de productos de plástico para el hogar con y sin reforzamiento", Category.SUBCLASS
        ),
        Classification("326192", "Fabricación de autopartes de plástico con y sin reforzamiento", Category.SUBCLASS),
        Classification(
            "326193",
            "Fabricación de envases y contenedores de plástico para embalaje con y sin reforzamiento ",
            Category.SUBCLASS,
        ),
        Classification(
            "326194",
            "Fabricación de otros productos de plástico de uso industrial sin reforzamiento ",
            Category.SUBCLASS,
        ),
        Classification("326198", "Fabricación de otros productos de plástico con reforzamiento", Category.SUBCLASS),
        Classification("326199", "Fabricación de otros productos de plástico sin reforzamiento", Category.SUBCLASS),
        Classification("3262", "Fabricación de productos de hule", Category.GROUP),
        Classification("32621", "Fabricación y revitalización de llantas", Category.CLASS),
        Classification("326211", "Fabricación de llantas y cámaras", Category.SUBCLASS),
        Classification("326212", "Revitalización de llantas", Category.SUBCLASS),
        Classification("32622", "Fabricación de bandas y mangueras de hule y de plástico", Category.CLASS),
        Classification("326220", "Fabricación de bandas y mangueras de hule y de plástico", Category.SUBCLASS),
        Classification("32629", "Fabricación de otros productos de hule", Category.CLASS),
        Classification("326290", "Fabricación de otros productos de hule", Category.SUBCLASS),
        Classification("327", "Fabricación de productos a base de minerales no metálicos", Category.DIVISION),
        Classification("3271", "Fabricación de productos a base de arcillas y minerales refractarios", Category.GROUP),
        Classification(
            "32711", "Fabricación de artículos de alfarería, porcelana, loza y muebles de baño", Category.CLASS
        ),
        Classification("327111", "Fabricación de artículos de alfarería, porcelana y loza", Category.SUBCLASS),
        Classification("327112", "Fabricación de muebles de baño", Category.SUBCLASS),
        Classification("32712", "Fabricación de productos a base de arcilla para la construcción", Category.CLASS),
        Classification("327121", "Fabricación de ladrillos no refractarios", Category.SUBCLASS),
        Classification("327122", "Fabricación de azulejos y losetas no refractarias", Category.SUBCLASS),
        Classification("327123", "Fabricación de productos refractarios", Category.SUBCLASS),
        Classification("3272", "Fabricación de vidrio y productos de vidrio", Category.GROUP),
        Classification("32721", "Fabricación de vidrio y productos de vidrio", Category.CLASS),
        Classification("327211", "Fabricación de vidrio", Category.SUBCLASS),
        Classification("327212", "Fabricación de espejos", Category.SUBCLASS),
        Classification("327213", "Fabricación de envases y ampolletas de vidrio", Category.SUBCLASS),
        Classification("327214", "Fabricación de fibra de vidrio", Category.SUBCLASS),
        Classification("327215", "Fabricación de artículos de vidrio de uso doméstico", Category.SUBCLASS),
        Classification("327216", "Fabricación de artículos de vidrio de uso industrial y comercial", Category.SUBCLASS),
        Classification("327219", "Fabricación de otros productos de vidrio", Category.SUBCLASS),
        Classification("3273", "Fabricación de cemento y productos de concreto", Category.GROUP),
        Classification(
            "32731", "Fabricación de cemento y productos a base de cemento en plantas integradas", Category.CLASS
        ),
        Classification(
            "327310", "Fabricación de cemento y productos a base de cemento en plantas integradas", Category.SUBCLASS
        ),
        Classification("32732", "Fabricación de concreto", Category.CLASS),
        Classification("327320", "Fabricación de concreto", Category.SUBCLASS),
        Classification("32733", "Fabricación de tubos y bloques de cemento y concreto", Category.CLASS),
        Classification("327330", "Fabricación de tubos y bloques de cemento y concreto", Category.SUBCLASS),
        Classification("32739", "Fabricación de otros productos de cemento y concreto", Category.CLASS),
        Classification("327391", "Fabricación de productos preesforzados de concreto", Category.SUBCLASS),
        Classification("327399", "Fabricación de otros productos de cemento y concreto", Category.SUBCLASS),
        Classification("3274", "Fabricación de cal, yeso y productos de yeso", Category.GROUP),
        Classification("32741", "Fabricación de cal", Category.CLASS),
        Classification("327410", "Fabricación de cal", Category.SUBCLASS),
        Classification("32742", "Fabricación de yeso y productos de yeso", Category.CLASS),
        Classification("327420", "Fabricación de yeso y productos de yeso", Category.SUBCLASS),
        Classification("3279", "Fabricación de otros productos a base de minerales no metálicos", Category.GROUP),
        Classification("32791", "Fabricación de productos abrasivos", Category.CLASS),
        Classification("327910", "Fabricación de productos abrasivos", Category.SUBCLASS),
        Classification("32799", "Fabricación de otros productos a base de minerales no metálicos", Category.CLASS),
        Classification("327991", "Fabricación de productos a base de piedras de cantera", Category.SUBCLASS),
        Classification("327999", "Fabricación de otros productos a base de minerales no metálicos", Category.SUBCLASS),
        Classification("331", "Industrias metálicas básicas", Category.DIVISION),
        Classification("3311", "Industria básica del hierro y del acero", Category.GROUP),
        Classification("33111", "Industria básica del hierro y del acero", Category.CLASS),
        Classification("331111", "Complejos siderúrgicos", Category.SUBCLASS),
        Classification("331112", "Fabricación de desbastes primarios y ferroaleaciones", Category.SUBCLASS),
        Classification("3312", "Fabricación de productos de hierro y acero", Category.GROUP),
        Classification("33121", "Fabricación de tubos y postes de hierro y acero", Category.CLASS),
        Classification("331210", "Fabricación de tubos y postes de hierro y acero", Category.SUBCLASS),
        Classification("33122", "Fabricación de otros productos de hierro y acero", Category.CLASS),
        Classification("331220", "Fabricación de otros productos de hierro y acero", Category.SUBCLASS),
        Classification("3313", "Industria básica del aluminio", Category.GROUP),
        Classification("33131", "Industria básica del aluminio", Category.CLASS),
        Classification("331310", "Industria básica del aluminio", Category.SUBCLASS),
        Classification("3314", "Industrias de metales no ferrosos, excepto aluminio", Category.GROUP),
        Classification(
            "33141", "Fundición y refinación de cobre, metales preciosos y de otros metales no ferrosos", Category.CLASS
        ),
        Classification("331411", "Fundición y refinación de cobre", Category.SUBCLASS),
        Classification("331412", "Fundición y refinación de metales preciosos", Category.SUBCLASS),
        Classification("331419", "Fundición y refinación de otros metales no ferrosos", Category.SUBCLASS),
        Classification("33142", "Laminación secundaria de cobre", Category.CLASS),
        Classification("331420", "Laminación secundaria de cobre", Category.SUBCLASS),
        Classification("33149", "Laminación secundaria de otros metales no ferrosos", Category.CLASS),
        Classification("331490", "Laminación secundaria de otros metales no ferrosos", Category.SUBCLASS),
        Classification("3315", "Moldeo por fundición de piezas metálicas", Category.GROUP),
        Classification("33151", "Moldeo por fundición de piezas de hierro y acero", Category.CLASS),
        Classification("331510", "Moldeo por fundición de piezas de hierro y acero", Category.SUBCLASS),
        Classification("33152", "Moldeo por fundición de piezas metálicas no ferrosas", Category.CLASS),
        Classification("331520", "Moldeo por fundición de piezas metálicas no ferrosas", Category.SUBCLASS),
        Classification("332", "Fabricación de productos metálicos", Category.DIVISION),
        Classification("3321", "Fabricación de productos metálicos forjados y troquelados", Category.GROUP),
        Classification("33211", "Fabricación de productos metálicos forjados y troquelados", Category.CLASS),
        Classification("332110", "Fabricación de productos metálicos forjados y troquelados", Category.SUBCLASS),
        Classification(
            "3322", "Fabricación de herramientas de mano sin motor y utensilios de cocina metálicos", Category.GROUP
        ),
        Classification(
            "33221", "Fabricación de herramientas de mano sin motor y utensilios de cocina metálicos", Category.CLASS
        ),
        Classification("332211", "Fabricación de herramientas de mano metálicas sin motor", Category.SUBCLASS),
        Classification("332212", "Fabricación de utensilios de cocina metálicos", Category.SUBCLASS),
        Classification("3323", "Fabricación de estructuras metálicas y productos de herrería", Category.GROUP),
        Classification("33231", "Fabricación de estructuras metálicas", Category.CLASS),
        Classification("332310", "Fabricación de estructuras metálicas", Category.SUBCLASS),
        Classification("33232", "Fabricación de productos de herrería", Category.CLASS),
        Classification("332320", "Fabricación de productos de herrería", Category.SUBCLASS),
        Classification("3324", "Fabricación de calderas, tanques y envases metálicos", Category.GROUP),
        Classification("33241", "Fabricación de calderas industriales", Category.CLASS),
        Classification("332410", "Fabricación de calderas industriales", Category.SUBCLASS),
        Classification("33242", "Fabricación de tanques metálicos de calibre grueso", Category.CLASS),
        Classification("332420", "Fabricación de tanques metálicos de calibre grueso", Category.SUBCLASS),
        Classification("33243", "Fabricación de envases metálicos de calibre ligero", Category.CLASS),
        Classification("332430", "Fabricación de envases metálicos de calibre ligero", Category.SUBCLASS),
        Classification("3325", "Fabricación de herrajes y cerraduras", Category.GROUP),
        Classification("33251", "Fabricación de herrajes y cerraduras", Category.CLASS),
        Classification("332510", "Fabricación de herrajes y cerraduras", Category.SUBCLASS),
        Classification("3326", "Fabricación de alambre, productos de alambre y resortes", Category.GROUP),
        Classification("33261", "Fabricación de alambre, productos de alambre y resortes", Category.CLASS),
        Classification("332610", "Fabricación de alambre, productos de alambre y resortes", Category.SUBCLASS),
        Classification("3327", "Maquinado de piezas y fabricación de tornillos", Category.GROUP),
        Classification("33271", "Maquinado de piezas para maquinaria y equipo en general", Category.CLASS),
        Classification("332710", "Maquinado de piezas para maquinaria y equipo en general", Category.SUBCLASS),
        Classification("33272", "Fabricación de tornillos, tuercas, remaches y similares", Category.CLASS),
        Classification("332720", "Fabricación de tornillos, tuercas, remaches y similares", Category.SUBCLASS),
        Classification("3328", "Recubrimientos y terminados metálicos", Category.GROUP),
        Classification("33281", "Recubrimientos y terminados metálicos", Category.CLASS),
        Classification("332810", "Recubrimientos y terminados metálicos", Category.SUBCLASS),
        Classification("3329", "Fabricación de otros productos metálicos", Category.GROUP),
        Classification("33291", "Fabricación de válvulas metálicas", Category.CLASS),
        Classification("332910", "Fabricación de válvulas metálicas", Category.SUBCLASS),
        Classification("33299", "Fabricación de otros productos metálicos", Category.CLASS),
        Classification("332991", "Fabricación de baleros y rodamientos", Category.SUBCLASS),
        Classification("332999", "Fabricación de otros productos metálicos", Category.SUBCLASS),
        Classification("333", "Fabricación de maquinaria y equipo", Category.DIVISION),
        Classification(
            "3331",
            "Fabricación de maquinaria y equipo agropecuario, para la construcción y para la industria extractiva",
            Category.GROUP,
        ),
        Classification("33311", "Fabricación de maquinaria y equipo agropecuario", Category.CLASS),
        Classification("333111", "Fabricación de maquinaria y equipo agrícola", Category.SUBCLASS),
        Classification("333112", "Fabricación de maquinaria y equipo pecuario", Category.SUBCLASS),
        Classification("33312", "Fabricación de maquinaria y equipo para la construcción", Category.CLASS),
        Classification("333120", "Fabricación de maquinaria y equipo para la construcción", Category.SUBCLASS),
        Classification("33313", "Fabricación de maquinaria y equipo para la industria extractiva", Category.CLASS),
        Classification("333130", "Fabricación de maquinaria y equipo para la industria extractiva", Category.SUBCLASS),
        Classification(
            "3332",
            "Fabricación de maquinaria y equipo para las industrias manufactureras, excepto la metalmecánica",
            Category.GROUP,
        ),
        Classification(
            "33324",
            "Fabricación de maquinaria y equipo para las industrias manufactureras, excepto la metalmecánica",
            Category.CLASS,
        ),
        Classification(
            "333241", "Fabricación de maquinaria y equipo para la industria de la madera", Category.SUBCLASS
        ),
        Classification(
            "333242", "Fabricación de maquinaria y equipo para la industria del hule y del plástico", Category.SUBCLASS
        ),
        Classification(
            "333243",
            "Fabricación de maquinaria y equipo para la industria alimentaria y de las bebidas ",
            Category.SUBCLASS,
        ),
        Classification("333244", "Fabricación de maquinaria y equipo para la industria textil", Category.SUBCLASS),
        Classification(
            "333245", "Fabricación de maquinaria y equipo para la industria de la impresión", Category.SUBCLASS
        ),
        Classification(
            "333246",
            "Fabricación de maquinaria y equipo para la industria del vidrio y otros minerales no metálicos ",
            Category.SUBCLASS,
        ),
        Classification(
            "333249", "Fabricación de maquinaria y equipo para otras industrias manufactureras", Category.SUBCLASS
        ),
        Classification("3333", "Fabricación de maquinaria y equipo para el comercio y los servicios", Category.GROUP),
        Classification("33331", "Fabricación de maquinaria y equipo para el comercio y los servicios", Category.CLASS),
        Classification("333311", "Fabricación de aparatos fotográficos", Category.SUBCLASS),
        Classification("333312", "Fabricación de máquinas fotocopiadoras", Category.SUBCLASS),
        Classification(
            "333319", "Fabricación de otra maquinaria y equipo para el comercio y los servicios", Category.SUBCLASS
        ),
        Classification(
            "3334",
            "Fabricación de equipo de aire acondicionado, calefacción, y de refrigeración industrial y comercial",
            Category.GROUP,
        ),
        Classification(
            "33341",
            "Fabricación de equipo de aire acondicionado, calefacción, y de refrigeración industrial y comercial",
            Category.CLASS,
        ),
        Classification("333411", "Fabricación de equipo de aire acondicionado y calefacción", Category.SUBCLASS),
        Classification("333412", "Fabricación de equipo de refrigeración industrial y comercial", Category.SUBCLASS),
        Classification("3335", "Fabricación de maquinaria y equipo para la industria metalmecánica", Category.GROUP),
        Classification("33351", "Fabricación de maquinaria y equipo para la industria metalmecánica", Category.CLASS),
        Classification(
            "333510", "Fabricación de maquinaria y equipo para la industria metalmecánica", Category.SUBCLASS
        ),
        Classification(
            "3336", "Fabricación de motores de combustión interna, turbinas y transmisiones", Category.GROUP
        ),
        Classification(
            "33361", "Fabricación de motores de combustión interna, turbinas y transmisiones", Category.CLASS
        ),
        Classification(
            "333610", "Fabricación de motores de combustión interna, turbinas y transmisiones", Category.SUBCLASS
        ),
        Classification("3339", "Fabricación de otra maquinaria y equipo para la industria en general", Category.GROUP),
        Classification("33391", "Fabricación de bombas y sistemas de bombeo", Category.CLASS),
        Classification("333910", "Fabricación de bombas y sistemas de bombeo", Category.SUBCLASS),
        Classification("33392", "Fabricación de maquinaria y equipo para levantar y trasladar", Category.CLASS),
        Classification("333920", "Fabricación de maquinaria y equipo para levantar y trasladar", Category.SUBCLASS),
        Classification("33399", "Fabricación de otra maquinaria y equipo para la industria en general", Category.CLASS),
        Classification("333991", "Fabricación de equipo para soldar y soldaduras", Category.SUBCLASS),
        Classification("333992", "Fabricación de maquinaria y equipo para envasar y empacar", Category.SUBCLASS),
        Classification("333993", "Fabricación de aparatos e instrumentos para pesar", Category.SUBCLASS),
        Classification(
            "333999", "Fabricación de otra maquinaria y equipo para la industria en general", Category.SUBCLASS
        ),
        Classification(
            "334",
            "Fabricación de equipo de computación, comunicación, medición y de otros equipos, componentes y accesorios electrónicos",
            Category.DIVISION,
        ),
        Classification("3341", "Fabricación de computadoras y equipo periférico", Category.GROUP),
        Classification("33411", "Fabricación de computadoras y equipo periférico", Category.CLASS),
        Classification("334110", "Fabricación de computadoras y equipo periférico", Category.SUBCLASS),
        Classification("3342", "Fabricación de equipo de comunicación", Category.GROUP),
        Classification("33421", "Fabricación de equipo telefónico", Category.CLASS),
        Classification("334210", "Fabricación de equipo telefónico", Category.SUBCLASS),
        Classification(
            "33422",
            "Fabricación de equipo de transmisión y recepción de señales de radio y televisión, y equipo de comunicación inalámbrico",
            Category.CLASS,
        ),
        Classification(
            "334220",
            "Fabricación de equipo de transmisión y recepción de señales de radio y televisión, y equipo de comunicación inalámbrico ",
            Category.SUBCLASS,
        ),
        Classification("33429", "Fabricación de otros equipos de comunicación", Category.CLASS),
        Classification("334290", "Fabricación de otros equipos de comunicación", Category.SUBCLASS),
        Classification("3343", "Fabricación de equipo de audio y de video", Category.GROUP),
        Classification("33431", "Fabricación de equipo de audio y de video", Category.CLASS),
        Classification("334310", "Fabricación de equipo de audio y de video", Category.SUBCLASS),
        Classification("3344", "Fabricación de componentes electrónicos", Category.GROUP),
        Classification("33441", "Fabricación de componentes electrónicos", Category.CLASS),
        Classification("334410", "Fabricación de componentes electrónicos", Category.SUBCLASS),
        Classification(
            "3345",
            "Fabricación de instrumentos de medición, control, navegación, y equipo médico electrónico",
            Category.GROUP,
        ),
        Classification(
            "33451",
            "Fabricación de instrumentos de medición, control, navegación, y equipo médico electrónico",
            Category.CLASS,
        ),
        Classification("334511", "Fabricación de relojes", Category.SUBCLASS),
        Classification(
            "334519",
            "Fabricación de otros instrumentos de medición, control, navegación, y equipo médico electrónico ",
            Category.SUBCLASS,
        ),
        Classification("3346", "Fabricación y reproducción de medios magnéticos y ópticos", Category.GROUP),
        Classification("33461", "Fabricación y reproducción de medios magnéticos y ópticos", Category.CLASS),
        Classification("334610", "Fabricación y reproducción de medios magnéticos y ópticos", Category.SUBCLASS),
        Classification(
            "335",
            "Fabricación de accesorios, aparatos eléctricos y equipo de generación de energía eléctrica",
            Category.DIVISION,
        ),
        Classification("3351", "Fabricación de accesorios de iluminación", Category.GROUP),
        Classification("33511", "Fabricación de focos", Category.CLASS),
        Classification("335110", "Fabricación de focos", Category.SUBCLASS),
        Classification("33512", "Fabricación de lámparas ornamentales", Category.CLASS),
        Classification("335120", "Fabricación de lámparas ornamentales", Category.SUBCLASS),
        Classification("3352", "Fabricación de aparatos eléctricos de uso doméstico", Category.GROUP),
        Classification("33521", "Fabricación de enseres electrodomésticos menores", Category.CLASS),
        Classification("335210", "Fabricación de enseres electrodomésticos menores", Category.SUBCLASS),
        Classification("33522", "Fabricación de aparatos de línea blanca", Category.CLASS),
        Classification("335220", "Fabricación de aparatos de línea blanca", Category.SUBCLASS),
        Classification(
            "3353", "Fabricación de equipo de generación y distribución de energía eléctrica", Category.GROUP
        ),
        Classification(
            "33531", "Fabricación de equipo de generación y distribución de energía eléctrica", Category.CLASS
        ),
        Classification("335311", "Fabricación de motores y generadores eléctricos", Category.SUBCLASS),
        Classification(
            "335312", "Fabricación de equipo y aparatos de distribución de energía eléctrica", Category.SUBCLASS
        ),
        Classification("3359", "Fabricación de otros equipos y accesorios eléctricos", Category.GROUP),
        Classification("33591", "Fabricación de acumuladores y pilas", Category.CLASS),
        Classification("335910", "Fabricación de acumuladores y pilas", Category.SUBCLASS),
        Classification("33592", "Fabricación de cables de conducción eléctrica", Category.CLASS),
        Classification("335920", "Fabricación de cables de conducción eléctrica", Category.SUBCLASS),
        Classification(
            "33593",
            "Fabricación de enchufes, contactos, fusibles y otros accesorios para instalaciones eléctricas",
            Category.CLASS,
        ),
        Classification(
            "335930",
            "Fabricación de enchufes, contactos, fusibles y otros accesorios para instalaciones eléctricas ",
            Category.SUBCLASS,
        ),
        Classification("33599", "Fabricación de otros productos eléctricos", Category.CLASS),
        Classification("335991", "Fabricación de productos eléctricos de carbón y grafito", Category.SUBCLASS),
        Classification("335999", "Fabricación de otros productos eléctricos", Category.SUBCLASS),
        Classification("336", "Fabricación de equipo de transporte", Category.DIVISION),
        Classification("3361", "Fabricación de automóviles y camiones", Category.GROUP),
        Classification("33611", "Fabricación de automóviles y camionetas", Category.CLASS),
        Classification("336110", "Fabricación de automóviles y camionetas", Category.SUBCLASS),
        Classification("33612", "Fabricación de camiones y tractocamiones", Category.CLASS),
        Classification("336120", "Fabricación de camiones y tractocamiones", Category.SUBCLASS),
        Classification("3362", "Fabricación de carrocerías y remolques", Category.GROUP),
        Classification("33621", "Fabricación de carrocerías y remolques", Category.CLASS),
        Classification("336210", "Fabricación de carrocerías y remolques", Category.SUBCLASS),
        Classification("3363", "Fabricación de partes para vehículos automotores", Category.GROUP),
        Classification("33631", "Fabricación de motores y sus partes para vehículos automotrices", Category.CLASS),
        Classification("336310", "Fabricación de motores y sus partes para vehículos automotrices", Category.SUBCLASS),
        Classification(
            "33632",
            "Fabricación de equipo eléctrico y electrónico y sus partes para vehículos automotores",
            Category.CLASS,
        ),
        Classification(
            "336320",
            "Fabricación de equipo eléctrico y electrónico y sus partes para vehículos automotores ",
            Category.SUBCLASS,
        ),
        Classification(
            "33633",
            "Fabricación de partes de sistemas de dirección y de suspensión para vehículos automotrices",
            Category.CLASS,
        ),
        Classification(
            "336330",
            "Fabricación de partes de sistemas de dirección y de suspensión para vehículos automotrices ",
            Category.SUBCLASS,
        ),
        Classification(
            "33634", "Fabricación de partes de sistemas de frenos para vehículos automotrices", Category.CLASS
        ),
        Classification(
            "336340", "Fabricación de partes de sistemas de frenos para vehículos automotrices", Category.SUBCLASS
        ),
        Classification(
            "33635", "Fabricación de partes de sistemas de transmisión para vehículos automotores", Category.CLASS
        ),
        Classification(
            "336350", "Fabricación de partes de sistemas de transmisión para vehículos automotores", Category.SUBCLASS
        ),
        Classification(
            "33636", "Fabricación de asientos y accesorios interiores para vehículos automotores", Category.CLASS
        ),
        Classification(
            "336360", "Fabricación de asientos y accesorios interiores para vehículos automotores", Category.SUBCLASS
        ),
        Classification(
            "33637", "Fabricación de piezas metálicas troqueladas para vehículos automotrices", Category.CLASS
        ),
        Classification(
            "336370", "Fabricación de piezas metálicas troqueladas para vehículos automotrices", Category.SUBCLASS
        ),
        Classification("33639", "Fabricación de otras partes para vehículos automotrices", Category.CLASS),
        Classification("336390", "Fabricación de otras partes para vehículos automotrices", Category.SUBCLASS),
        Classification("3364", "Fabricación de equipo aeroespacial", Category.GROUP),
        Classification("33641", "Fabricación de equipo aeroespacial", Category.CLASS),
        Classification("336410", "Fabricación de equipo aeroespacial", Category.SUBCLASS),
        Classification("3365", "Fabricación de equipo ferroviario", Category.GROUP),
        Classification("33651", "Fabricación de equipo ferroviario", Category.CLASS),
        Classification("336510", "Fabricación de equipo ferroviario", Category.SUBCLASS),
        Classification("3366", "Fabricación de embarcaciones", Category.GROUP),
        Classification("33661", "Fabricación de embarcaciones", Category.CLASS),
        Classification("336610", "Fabricación de embarcaciones", Category.SUBCLASS),
        Classification("3369", "Fabricación de otro equipo de transporte", Category.GROUP),
        Classification("33699", "Fabricación de otro equipo de transporte", Category.CLASS),
        Classification("336991", "Fabricación de motocicletas", Category.SUBCLASS),
        Classification("336992", "Fabricación de bicicletas y triciclos", Category.SUBCLASS),
        Classification("336999", "Fabricación de otro equipo de transporte", Category.SUBCLASS),
        Classification("337", "Fabricación de muebles, colchones y persianas", Category.DIVISION),
        Classification("3371", "Fabricación de muebles, excepto de oficina y estantería", Category.GROUP),
        Classification("33711", "Fabricación de cocinas integrales y muebles modulares de baño", Category.CLASS),
        Classification("337110", "Fabricación de cocinas integrales y muebles modulares de baño", Category.SUBCLASS),
        Classification(
            "33712",
            "Fabricación de muebles, excepto cocinas integrales, muebles modulares de baño y muebles de oficina y estantería",
            Category.CLASS,
        ),
        Classification(
            "337120",
            "Fabricación de muebles, excepto cocinas integrales, muebles modulares de baño y muebles de oficina y estantería ",
            Category.SUBCLASS,
        ),
        Classification("3372", "Fabricación de muebles de oficina y estantería", Category.GROUP),
        Classification("33721", "Fabricación de muebles de oficina y estantería", Category.CLASS),
        Classification("337210", "Fabricación de muebles de oficina y estantería", Category.SUBCLASS),
        Classification("3379", "Fabricación de colchones, persianas y cortineros", Category.GROUP),
        Classification("33791", "Fabricación de colchones", Category.CLASS),
        Classification("337910", "Fabricación de colchones", Category.SUBCLASS),
        Classification("33792", "Fabricación de persianas y cortineros", Category.CLASS),
        Classification("337920", "Fabricación de persianas y cortineros", Category.SUBCLASS),
        Classification("339", "Otras industrias manufactureras", Category.DIVISION),
        Classification(
            "3391",
            "Fabricación de equipo no electrónico y material desechable de uso médico, dental y para laboratorio, y artículos oftálmicos",
            Category.GROUP,
        ),
        Classification(
            "33911",
            "Fabricación de equipo no electrónico y material desechable de uso médico, dental y para laboratorio, y artículos oftálmicos",
            Category.CLASS,
        ),
        Classification(
            "339111",
            "Fabricación de equipo no electrónico para uso médico, dental y para laboratorio ",
            Category.SUBCLASS,
        ),
        Classification("339112", "Fabricación de material desechable de uso médico", Category.SUBCLASS),
        Classification("339113", "Fabricación de artículos oftálmicos", Category.SUBCLASS),
        Classification("3399", "Otras industrias manufactureras", Category.GROUP),
        Classification("33991", "Metalistería y joyería", Category.CLASS),
        Classification("339911", "Acuñación e impresión de monedas", Category.SUBCLASS),
        Classification("339912", "Orfebrería y joyería de metales y piedras preciosos", Category.SUBCLASS),
        Classification("339913", "Joyería de metales y piedras no preciosos y de otros materiales", Category.SUBCLASS),
        Classification("339914", "Metalistería de metales no preciosos", Category.SUBCLASS),
        Classification("33992", "Fabricación de artículos deportivos", Category.CLASS),
        Classification("339920", "Fabricación de artículos deportivos", Category.SUBCLASS),
        Classification("33993", "Fabricación de juguetes", Category.CLASS),
        Classification("339930", "Fabricación de juguetes", Category.SUBCLASS),
        Classification(
            "33994",
            "Fabricación de artículos y accesorios para escritura, pintura, dibujo y actividades de oficina",
            Category.CLASS,
        ),
        Classification(
            "339940",
            "Fabricación de artículos y accesorios para escritura, pintura, dibujo y actividades de oficina ",
            Category.SUBCLASS,
        ),
        Classification("33995", "Fabricación de anuncios y señalamientos", Category.CLASS),
        Classification("339950", "Fabricación de anuncios y señalamientos", Category.SUBCLASS),
        Classification("33999", "Otras industrias manufactureras", Category.CLASS),
        Classification("339991", "Fabricación de instrumentos musicales", Category.SUBCLASS),
        Classification("339992", "Fabricación de cierres, botones y agujas", Category.SUBCLASS),
        Classification("339993", "Fabricación de escobas, cepillos y similares", Category.SUBCLASS),
        Classification("339994", "Fabricación de velas y veladoras", Category.SUBCLASS),
        Classification("339995", "Fabricación de ataúdes", Category.SUBCLASS),
        Classification("339999", "Otras industrias manufactureras", Category.SUBCLASS),
        Classification("43", "Comercio al por mayor", Category.SECTION),
        Classification(
            "431", "Comercio al por mayor de abarrotes, alimentos, bebidas, hielo y tabaco", Category.DIVISION
        ),
        Classification("4311", "Comercio al por mayor de abarrotes y alimentos", Category.GROUP),
        Classification("43111", "Comercio al por mayor de abarrotes", Category.CLASS),
        Classification("431110", "Comercio al por mayor de abarrotes", Category.SUBCLASS),
        Classification("43112", "Comercio al por mayor de carnes", Category.CLASS),
        Classification("431121", "Comercio al por mayor de carnes rojas", Category.SUBCLASS),
        Classification("431122", "Comercio al por mayor de carne de aves", Category.SUBCLASS),
        Classification("431123", "Comercio al por mayor de pescados y mariscos", Category.SUBCLASS),
        Classification("43113", "Comercio al por mayor de frutas y verduras frescas", Category.CLASS),
        Classification("431130", "Comercio al por mayor de frutas y verduras frescas", Category.SUBCLASS),
        Classification("43114", "Comercio al por mayor de huevo", Category.CLASS),
        Classification("431140", "Comercio al por mayor de huevo", Category.SUBCLASS),
        Classification(
            "43115", "Comercio al por mayor de semillas y granos alimenticios, especias y chiles secos", Category.CLASS
        ),
        Classification(
            "431150",
            "Comercio al por mayor de semillas y granos alimenticios, especias y chiles secos ",
            Category.SUBCLASS,
        ),
        Classification("43116", "Comercio al por mayor de leche y otros productos lácteos", Category.CLASS),
        Classification("431160", "Comercio al por mayor de leche y otros productos lácteos", Category.SUBCLASS),
        Classification("43117", "Comercio al por mayor de embutidos", Category.CLASS),
        Classification("431170", "Comercio al por mayor de embutidos", Category.SUBCLASS),
        Classification("43118", "Comercio al por mayor de dulces y materias primas para repostería", Category.CLASS),
        Classification(
            "431180", "Comercio al por mayor de dulces y materias primas para repostería", Category.SUBCLASS
        ),
        Classification("43119", "Comercio al por mayor de otros alimentos", Category.CLASS),
        Classification("431191", "Comercio al por mayor de pan y pasteles", Category.SUBCLASS),
        Classification("431192", "Comercio al por mayor de botanas y frituras", Category.SUBCLASS),
        Classification("431193", "Comercio al por mayor de conservas alimenticias", Category.SUBCLASS),
        Classification("431194", "Comercio al por mayor de miel", Category.SUBCLASS),
        Classification("431199", "Comercio al por mayor de otros alimentos", Category.SUBCLASS),
        Classification("4312", "Comercio al por mayor de bebidas, hielo y tabaco", Category.GROUP),
        Classification("43121", "Comercio al por mayor de bebidas y hielo", Category.CLASS),
        Classification("431211", "Comercio al por mayor de bebidas no alcohólicas y hielo", Category.SUBCLASS),
        Classification("431212", "Comercio al por mayor de vinos y licores", Category.SUBCLASS),
        Classification("431213", "Comercio al por mayor de cerveza", Category.SUBCLASS),
        Classification("43122", "Comercio al por mayor de cigarros, puros y tabaco", Category.CLASS),
        Classification("431220", "Comercio al por mayor de cigarros, puros y tabaco", Category.SUBCLASS),
        Classification("432", "Comercio al por mayor de productos textiles y calzado", Category.DIVISION),
        Classification("4321", "Comercio al por mayor de productos textiles y calzado", Category.GROUP),
        Classification("43211", "Comercio al por mayor de productos textiles, excepto ropa", Category.CLASS),
        Classification("432111", "Comercio al por mayor de fibras, hilos y telas", Category.SUBCLASS),
        Classification("432112", "Comercio al por mayor de blancos", Category.SUBCLASS),
        Classification("432113", "Comercio al por mayor de cueros y pieles", Category.SUBCLASS),
        Classification("432119", "Comercio al por mayor de otros productos textiles", Category.SUBCLASS),
        Classification("43212", "Comercio al por mayor de ropa, bisutería y accesorios de vestir", Category.CLASS),
        Classification("432120", "Comercio al por mayor de ropa, bisutería y accesorios de vestir", Category.SUBCLASS),
        Classification("43213", "Comercio al por mayor de calzado", Category.CLASS),
        Classification("432130", "Comercio al por mayor de calzado", Category.SUBCLASS),
        Classification(
            "433",
            "Comercio al por mayor de productos farmacéuticos, de perfumería, artículos para el esparcimiento, electrodomésticos menores y aparatos de línea blanca ",
            Category.DIVISION,
        ),
        Classification("4331", "Comercio al por mayor de productos farmacéuticos", Category.GROUP),
        Classification("43311", "Comercio al por mayor de productos farmacéuticos", Category.CLASS),
        Classification("433110", "Comercio al por mayor de productos farmacéuticos", Category.SUBCLASS),
        Classification(
            "4332", "Comercio al por mayor de artículos de perfumería, cosméticos y joyería", Category.GROUP
        ),
        Classification("43321", "Comercio al por mayor de artículos de perfumería y cosméticos", Category.CLASS),
        Classification("433210", "Comercio al por mayor de artículos de perfumería y cosméticos", Category.SUBCLASS),
        Classification("43322", "Comercio al por mayor de artículos de joyería y relojes", Category.CLASS),
        Classification("433220", "Comercio al por mayor de artículos de joyería y relojes", Category.SUBCLASS),
        Classification("4333", "Comercio al por mayor de discos, juguetes y artículos deportivos", Category.GROUP),
        Classification("43331", "Comercio al por mayor de discos, juguetes y artículos deportivos", Category.CLASS),
        Classification("433311", "Comercio al por mayor de discos y casetes", Category.SUBCLASS),
        Classification("433312", "Comercio al por mayor de juguetes y bicicletas", Category.SUBCLASS),
        Classification("433313", "Comercio al por mayor de artículos y aparatos deportivos", Category.SUBCLASS),
        Classification(
            "4334", "Comercio al por mayor de artículos de papelería, libros, revistas y periódicos", Category.GROUP
        ),
        Classification("43341", "Comercio al por mayor de artículos de papelería", Category.CLASS),
        Classification("433410", "Comercio al por mayor de artículos de papelería", Category.SUBCLASS),
        Classification("43342", "Comercio al por mayor de libros", Category.CLASS),
        Classification("433420", "Comercio al por mayor de libros", Category.SUBCLASS),
        Classification("43343", "Comercio al por mayor de revistas y periódicos", Category.CLASS),
        Classification("433430", "Comercio al por mayor de revistas y periódicos", Category.SUBCLASS),
        Classification(
            "4335", "Comercio al por mayor de electrodomésticos menores y aparatos de línea blanca", Category.GROUP
        ),
        Classification(
            "43351", "Comercio al por mayor de electrodomésticos menores y aparatos de línea blanca", Category.CLASS
        ),
        Classification(
            "433510",
            "Comercio al por mayor de electrodomésticos menores y aparatos de línea blanca ",
            Category.SUBCLASS,
        ),
        Classification(
            "434",
            "Comercio al por mayor de materias primas agropecuarias y forestales, para la industria, y materiales de desecho ",
            Category.DIVISION,
        ),
        Classification("4341", "Comercio al por mayor de materias primas agropecuarias y forestales", Category.GROUP),
        Classification("43411", "Comercio al por mayor de materias primas agropecuarias y forestales", Category.CLASS),
        Classification(
            "434111", "Comercio al por mayor de fertilizantes, plaguicidas y semillas para siembra", Category.SUBCLASS
        ),
        Classification(
            "434112",
            "Comercio al por mayor de medicamentos veterinarios y alimentos para animales, excepto mascotas ",
            Category.SUBCLASS,
        ),
        Classification("4342", "Comercio al por mayor de materias primas para la industria", Category.GROUP),
        Classification(
            "43421",
            "Comercio al por mayor de materiales para la construcción, excepto de madera y metálicos ",
            Category.CLASS,
        ),
        Classification("434211", "Comercio al por mayor de cemento, tabique y grava", Category.SUBCLASS),
        Classification(
            "434219",
            "Comercio al por mayor de otros materiales para la construcción, excepto de madera y metálicos ",
            Category.SUBCLASS,
        ),
        Classification(
            "43422",
            "Comercio al por mayor de otros materiales para la construcción y materias primas para otras industrias ",
            Category.CLASS,
        ),
        Classification(
            "434221",
            "Comercio al por mayor de materiales metálicos para la construcción y la manufactura ",
            Category.SUBCLASS,
        ),
        Classification(
            "434222",
            "Comercio al por mayor de productos químicos para la industria farmacéutica y para otro uso industrial ",
            Category.SUBCLASS,
        ),
        Classification(
            "434223",
            "Comercio al por mayor de envases en general, papel y cartón para la industria ",
            Category.SUBCLASS,
        ),
        Classification(
            "434224", "Comercio al por mayor de madera para la construcción y la industria", Category.SUBCLASS
        ),
        Classification("434225", "Comercio al por mayor de equipo y material eléctrico", Category.SUBCLASS),
        Classification("434226", "Comercio al por mayor de pintura", Category.SUBCLASS),
        Classification("434227", "Comercio al por mayor de vidrios y espejos", Category.SUBCLASS),
        Classification("434228", "Comercio al por mayor de ganado y aves en pie", Category.SUBCLASS),
        Classification(
            "434229", "Comercio al por mayor de otras materias primas para otras industrias", Category.SUBCLASS
        ),
        Classification("43423", "Comercio al por mayor de combustibles de uso industrial", Category.CLASS),
        Classification("434230", "Comercio al por mayor de combustibles de uso industrial", Category.SUBCLASS),
        Classification("43424", "Comercio al por mayor de artículos desechables", Category.CLASS),
        Classification("434240", "Comercio al por mayor de artículos desechables", Category.SUBCLASS),
        Classification("4343", "Comercio al por mayor de materiales de desecho", Category.GROUP),
        Classification("43431", "Comercio al por mayor de materiales de desecho", Category.CLASS),
        Classification("434311", "Comercio al por mayor de desechos metálicos", Category.SUBCLASS),
        Classification("434312", "Comercio al por mayor de desechos de papel y de cartón", Category.SUBCLASS),
        Classification("434313", "Comercio al por mayor de desechos de vidrio", Category.SUBCLASS),
        Classification("434314", "Comercio al por mayor de desechos de plástico", Category.SUBCLASS),
        Classification("434319", "Comercio al por mayor de otros materiales de desecho", Category.SUBCLASS),
        Classification(
            "435",
            "Comercio al por mayor de maquinaria, equipo y mobiliario para actividades agropecuarias, industriales, de servicios y comerciales, y de otra maquinaria y equipo de uso general ",
            Category.DIVISION,
        ),
        Classification(
            "4351",
            "Comercio al por mayor de maquinaria y equipo agropecuario, forestal y para la pesca ",
            Category.GROUP,
        ),
        Classification(
            "43511",
            "Comercio al por mayor de maquinaria y equipo agropecuario, forestal y para la pesca ",
            Category.CLASS,
        ),
        Classification(
            "435110",
            "Comercio al por mayor de maquinaria y equipo agropecuario, forestal y para la pesca ",
            Category.SUBCLASS,
        ),
        Classification("4352", "Comercio al por mayor de maquinaria y equipo para la industria", Category.GROUP),
        Classification(
            "43521", "Comercio al por mayor de maquinaria y equipo para la construcción y la minería", Category.CLASS
        ),
        Classification(
            "435210",
            "Comercio al por mayor de maquinaria y equipo para la construcción y la minería ",
            Category.SUBCLASS,
        ),
        Classification(
            "43522", "Comercio al por mayor de maquinaria y equipo para la industria manufacturera", Category.CLASS
        ),
        Classification(
            "435220", "Comercio al por mayor de maquinaria y equipo para la industria manufacturera", Category.SUBCLASS
        ),
        Classification(
            "4353",
            "Comercio al por mayor de maquinaria y equipo para los servicios y para actividades comerciales ",
            Category.GROUP,
        ),
        Classification(
            "43531",
            "Comercio al por mayor de maquinaria y equipo para los servicios y para actividades comerciales ",
            Category.CLASS,
        ),
        Classification(
            "435311",
            "Comercio al por mayor de equipo de telecomunicaciones, fotografía y cinematografía ",
            Category.SUBCLASS,
        ),
        Classification(
            "435312",
            "Comercio al por mayor de artículos y accesorios para diseño y pintura artística ",
            Category.SUBCLASS,
        ),
        Classification(
            "435313",
            "Comercio al por mayor de mobiliario, equipo e instrumental médico y de laboratorio ",
            Category.SUBCLASS,
        ),
        Classification(
            "435319",
            "Comercio al por mayor de maquinaria y equipo para otros servicios y para actividades comerciales ",
            Category.SUBCLASS,
        ),
        Classification(
            "4354",
            "Comercio al por mayor de mobiliario y equipo de cómputo y de oficina, y de otra maquinaria y equipo de uso general ",
            Category.GROUP,
        ),
        Classification(
            "43541",
            "Comercio al por mayor de mobiliario y equipo de cómputo y de oficina, y de otra maquinaria y equipo de uso general ",
            Category.CLASS,
        ),
        Classification(
            "435411", "Comercio al por mayor de mobiliario, equipo, y accesorios de cómputo", Category.SUBCLASS
        ),
        Classification("435412", "Comercio al por mayor de mobiliario y equipo de oficina", Category.SUBCLASS),
        Classification("435419", "Comercio al por mayor de otra maquinaria y equipo de uso general", Category.SUBCLASS),
        Classification(
            "436",
            "Comercio al por mayor de camiones y de partes y refacciones nuevas para automóviles, camionetas y camiones ",
            Category.DIVISION,
        ),
        Classification(
            "4361",
            "Comercio al por mayor de camiones y de partes y refacciones nuevas para automóviles, camionetas y camiones ",
            Category.GROUP,
        ),
        Classification(
            "43611",
            "Comercio al por mayor de camiones y de partes y refacciones nuevas para automóviles, camionetas y camiones ",
            Category.CLASS,
        ),
        Classification("436111", "Comercio al por mayor de camiones", Category.SUBCLASS),
        Classification(
            "436112",
            "Comercio al por mayor de partes y refacciones nuevas para automóviles, camionetas y camiones ",
            Category.SUBCLASS,
        ),
        Classification("437", "Intermediación de comercio al por mayor", Category.DIVISION),
        Classification(
            "4371",
            "Intermediación de comercio al por mayor, excepto a través de interney de otros medios electrónicos ",
            Category.GROUP,
        ),
        Classification(
            "43711",
            "Intermediación de comercio al por mayor, excepto a través de interney de otros medios electrónicos ",
            Category.CLASS,
        ),
        Classification(
            "437111",
            "Intermediación de comercio al por mayor de productos agropecuarios, excepto a través de interney de otros medios electrónicos ",
            Category.SUBCLASS,
        ),
        Classification(
            "437112",
            "Intermediación de comercio al por mayor de productos para la industria, el comercio y los servicios, excepto a través de interney de otros medios electrónicos ",
            Category.SUBCLASS,
        ),
        Classification(
            "437113",
            "Intermediación de comercio al por mayor para productos de uso doméstico y personal, excepto a través de interney de otros medios electrónicos ",
            Category.SUBCLASS,
        ),
        Classification(
            "4372",
            "Intermediación de comercio al por mayor exclusivamente a través de interney otros medios electrónicos ",
            Category.GROUP,
        ),
        Classification(
            "43721",
            "Intermediación de comercio al por mayor exclusivamente a través de interney otros medios electrónicos ",
            Category.CLASS,
        ),
        Classification(
            "437210",
            "Intermediación de comercio al por mayor exclusivamente a través de interney otros medios electrónicos ",
            Category.SUBCLASS,
        ),
        Classification("46", "Comercio al por menor", Category.SECTION),
        Classification(
            "461", "Comercio al por menor de abarrotes, alimentos, bebidas, hielo y tabaco", Category.DIVISION
        ),
        Classification("4611", "Comercio al por menor de abarrotes y alimentos", Category.GROUP),
        Classification(
            "46111", "Comercio al por menor en tiendas de abarrotes, ultramarinos y misceláneas", Category.CLASS
        ),
        Classification(
            "461110", "Comercio al por menor en tiendas de abarrotes, ultramarinos y misceláneas", Category.SUBCLASS
        ),
        Classification("46112", "Comercio al por menor de carnes", Category.CLASS),
        Classification("461121", "Comercio al por menor de carnes rojas", Category.SUBCLASS),
        Classification("461122", "Comercio al por menor de carne de aves", Category.SUBCLASS),
        Classification("461123", "Comercio al por menor de pescados y mariscos", Category.SUBCLASS),
        Classification("46113", "Comercio al por menor de frutas y verduras frescas", Category.CLASS),
        Classification("461130", "Comercio al por menor de frutas y verduras frescas", Category.SUBCLASS),
        Classification(
            "46114", "Comercio al por menor de semillas y granos alimenticios, especias y chiles secos", Category.CLASS
        ),
        Classification(
            "461140",
            "Comercio al por menor de semillas y granos alimenticios, especias y chiles secos ",
            Category.SUBCLASS,
        ),
        Classification("46115", "Comercio al por menor de leche, otros productos lácteos y embutidos", Category.CLASS),
        Classification(
            "461150", "Comercio al por menor de leche, otros productos lácteos y embutidos", Category.SUBCLASS
        ),
        Classification("46116", "Comercio al por menor de dulces y materias primas para repostería", Category.CLASS),
        Classification(
            "461160", "Comercio al por menor de dulces y materias primas para repostería", Category.SUBCLASS
        ),
        Classification("46117", "Comercio al por menor de paletas de hielo y helados", Category.CLASS),
        Classification("461170", "Comercio al por menor de paletas de hielo y helados", Category.SUBCLASS),
        Classification("46119", "Comercio al por menor de otros alimentos", Category.CLASS),
        Classification("461190", "Comercio al por menor de otros alimentos", Category.SUBCLASS),
        Classification("4612", "Comercio al por menor de bebidas, hielo y tabaco", Category.GROUP),
        Classification("46121", "Comercio al por menor de bebidas y hielo", Category.CLASS),
        Classification("461211", "Comercio al por menor de vinos y licores", Category.SUBCLASS),
        Classification("461212", "Comercio al por menor de cerveza", Category.SUBCLASS),
        Classification("461213", "Comercio al por menor de bebidas no alcohólicas y hielo", Category.SUBCLASS),
        Classification("46122", "Comercio al por menor de cigarros, puros y tabaco", Category.CLASS),
        Classification("461220", "Comercio al por menor de cigarros, puros y tabaco", Category.SUBCLASS),
        Classification("462", "Comercio al por menor en tiendas de autoservicio y departamentales", Category.DIVISION),
        Classification("4621", "Comercio al por menor en tiendas de autoservicio", Category.GROUP),
        Classification("46211", "Comercio al por menor en tiendas de autoservicio", Category.CLASS),
        Classification("462111", "Comercio al por menor en supermercados", Category.SUBCLASS),
        Classification("462112", "Comercio al por menor en minisupers", Category.SUBCLASS),
        Classification("4622", "Comercio al por menor en tiendas departamentales", Category.GROUP),
        Classification("46221", "Comercio al por menor en tiendas departamentales", Category.CLASS),
        Classification("462210", "Comercio al por menor en tiendas departamentales", Category.SUBCLASS),
        Classification(
            "463",
            "Comercio al por menor de productos textiles, bisutería, accesorios de vestir y calzado ",
            Category.DIVISION,
        ),
        Classification("4631", "Comercio al por menor de productos textiles, excepto ropa", Category.GROUP),
        Classification("46311", "Comercio al por menor de productos textiles, excepto ropa", Category.CLASS),
        Classification("463111", "Comercio al por menor de telas", Category.SUBCLASS),
        Classification("463112", "Comercio al por menor de blancos", Category.SUBCLASS),
        Classification("463113", "Comercio al por menor de artículos de mercería y bonetería", Category.SUBCLASS),
        Classification("4632", "Comercio al por menor de ropa, bisutería y accesorios de vestir", Category.GROUP),
        Classification("46321", "Comercio al por menor de ropa, bisutería y accesorios de vestir", Category.CLASS),
        Classification("463211", "Comercio al por menor de ropa, excepto de bebé y lencería", Category.SUBCLASS),
        Classification("463212", "Comercio al por menor de ropa de bebé", Category.SUBCLASS),
        Classification("463213", "Comercio al por menor de lencería", Category.SUBCLASS),
        Classification(
            "463214", "Comercio al por menor de disfraces, vestimenta regional y vestidos de novia", Category.SUBCLASS
        ),
        Classification("463215", "Comercio al por menor de bisutería y accesorios de vestir", Category.SUBCLASS),
        Classification(
            "463216",
            "Comercio al por menor de ropa de cuero y piel y de otros artículos de estos materiales ",
            Category.SUBCLASS,
        ),
        Classification("463217", "Comercio al por menor de pañales desechables", Category.SUBCLASS),
        Classification("463218", "Comercio al por menor de sombreros", Category.SUBCLASS),
        Classification("4633", "Comercio al por menor de calzado", Category.GROUP),
        Classification("46331", "Comercio al por menor de calzado", Category.CLASS),
        Classification("463310", "Comercio al por menor de calzado", Category.SUBCLASS),
        Classification("464", "Comercio al por menor de artículos para el cuidado de la salud", Category.DIVISION),
        Classification("4641", "Comercio al por menor de artículos para el cuidado de la salud", Category.GROUP),
        Classification("46411", "Comercio al por menor de productos farmacéuticos y naturistas", Category.CLASS),
        Classification("464111", "Farmacias sin minisúper", Category.SUBCLASS),
        Classification("464112", "Farmacias con minisúper", Category.SUBCLASS),
        Classification(
            "464113",
            "Comercio al por menor de productos naturistas, medicamentos homeopáticos y de complementos alimenticios ",
            Category.SUBCLASS,
        ),
        Classification("46412", "Comercio al por menor de lentes y artículos ortopédicos", Category.CLASS),
        Classification("464121", "Comercio al por menor de lentes", Category.SUBCLASS),
        Classification("464122", "Comercio al por menor de artículos ortopédicos", Category.SUBCLASS),
        Classification(
            "465",
            "Comercio al por menor de artículos de papelería, para el esparcimiento y otros artículos de uso personal ",
            Category.DIVISION,
        ),
        Classification("4651", "Comercio al por menor de artículos de perfumería y joyería", Category.GROUP),
        Classification("46511", "Comercio al por menor de artículos de perfumería y joyería", Category.CLASS),
        Classification("465111", "Comercio al por menor de artículos de perfumería y cosméticos", Category.SUBCLASS),
        Classification("465112", "Comercio al por menor de artículos de joyería y relojes", Category.SUBCLASS),
        Classification("4652", "Comercio al por menor de artículos para el esparcimiento", Category.GROUP),
        Classification("46521", "Comercio al por menor de artículos para el esparcimiento", Category.CLASS),
        Classification("465211", "Comercio al por menor de discos y casetes", Category.SUBCLASS),
        Classification("465212", "Comercio al por menor de juguetes", Category.SUBCLASS),
        Classification("465213", "Comercio al por menor de bicicletas y triciclos", Category.SUBCLASS),
        Classification("465214", "Comercio al por menor de equipo y material fotográfico", Category.SUBCLASS),
        Classification("465215", "Comercio al por menor de artículos y aparatos deportivos", Category.SUBCLASS),
        Classification("465216", "Comercio al por menor de instrumentos musicales", Category.SUBCLASS),
        Classification(
            "4653", "Comercio al por menor de artículos de papelería, libros, revistas y periódicos", Category.GROUP
        ),
        Classification(
            "46531", "Comercio al por menor de artículos de papelería, libros, revistas y periódicos", Category.CLASS
        ),
        Classification("465311", "Comercio al por menor de artículos de papelería", Category.SUBCLASS),
        Classification("465312", "Comercio al por menor de libros", Category.SUBCLASS),
        Classification("465313", "Comercio al por menor de revistas y periódicos", Category.SUBCLASS),
        Classification(
            "4659",
            "Comercio al por menor de mascotas, regalos, artículos religiosos, desechables, artesanías y otros artículos de uso personal ",
            Category.GROUP,
        ),
        Classification(
            "46591",
            "Comercio al por menor de mascotas, regalos, artículos religiosos, desechables, artesanías y otros artículos de uso personal ",
            Category.CLASS,
        ),
        Classification("465911", "Comercio al por menor de mascotas", Category.SUBCLASS),
        Classification("465912", "Comercio al por menor de regalos", Category.SUBCLASS),
        Classification("465913", "Comercio al por menor de artículos religiosos", Category.SUBCLASS),
        Classification("465914", "Comercio al por menor de artículos desechables", Category.SUBCLASS),
        Classification("465915", "Comercio al por menor en tiendas de artesanías", Category.SUBCLASS),
        Classification("465919", "Comercio al por menor de otros artículos de uso personal", Category.SUBCLASS),
        Classification(
            "466",
            "Comercio al por menor de enseres domésticos, computadoras, artículos para la decoración de interiores y artículos usados ",
            Category.DIVISION,
        ),
        Classification(
            "4661", "Comercio al por menor de muebles para el hogar y otros enseres domésticos", Category.GROUP
        ),
        Classification(
            "46611", "Comercio al por menor de muebles para el hogar y otros enseres domésticos", Category.CLASS
        ),
        Classification("466111", "Comercio al por menor de muebles para el hogar", Category.SUBCLASS),
        Classification(
            "466112",
            "Comercio al por menor de electrodomésticos menores y aparatos de línea blanca ",
            Category.SUBCLASS,
        ),
        Classification("466113", "Comercio al por menor de muebles para jardín", Category.SUBCLASS),
        Classification(
            "466114", "Comercio al por menor de cristalería, loza y utensilios de cocina", Category.SUBCLASS
        ),
        Classification(
            "4662",
            "Comercio al por menor de mobiliario, equipo y accesorios de cómputo, teléfonos y otros aparatos de comunicación ",
            Category.GROUP,
        ),
        Classification(
            "46621",
            "Comercio al por menor de mobiliario, equipo y accesorios de cómputo, teléfonos y otros aparatos de comunicación ",
            Category.CLASS,
        ),
        Classification(
            "466211", "Comercio al por menor de mobiliario, equipo y accesorios de cómputo", Category.SUBCLASS
        ),
        Classification(
            "466212", "Comercio al por menor de teléfonos y otros aparatos de comunicación", Category.SUBCLASS
        ),
        Classification("4663", "Comercio al por menor de artículos para la decoración de interiores", Category.GROUP),
        Classification("46631", "Comercio al por menor de artículos para la decoración de interiores", Category.CLASS),
        Classification(
            "466311", "Comercio al por menor de alfombras, cortinas, tapices y similares", Category.SUBCLASS
        ),
        Classification("466312", "Comercio al por menor de plantas y flores naturales", Category.SUBCLASS),
        Classification("466313", "Comercio al por menor de antigüedades y obras de arte", Category.SUBCLASS),
        Classification("466314", "Comercio al por menor de lámparas ornamentales y candiles", Category.SUBCLASS),
        Classification(
            "466319", "Comercio al por menor de otros artículos para la decoración de interiores", Category.SUBCLASS
        ),
        Classification("4664", "Comercio al por menor de artículos usados", Category.GROUP),
        Classification("46641", "Comercio al por menor de artículos usados", Category.CLASS),
        Classification("466410", "Comercio al por menor de artículos usados", Category.SUBCLASS),
        Classification(
            "467", "Comercio al por menor de artículos de ferretería, tlapalería y vidrios", Category.DIVISION
        ),
        Classification(
            "4671", "Comercio al por menor de artículos de ferretería, tlapalería y vidrios", Category.GROUP
        ),
        Classification(
            "46711", "Comercio al por menor de artículos de ferretería, tlapalería y vidrios", Category.CLASS
        ),
        Classification("467111", "Comercio al por menor en ferreterías y tlapalerías", Category.SUBCLASS),
        Classification("467112", "Comercio al por menor de pisos y recubrimientos cerámicos", Category.SUBCLASS),
        Classification("467113", "Comercio al por menor de pintura", Category.SUBCLASS),
        Classification("467114", "Comercio al por menor de vidrios y espejos", Category.SUBCLASS),
        Classification("467115", "Comercio al por menor de artículos para la limpieza", Category.SUBCLASS),
        Classification(
            "467116",
            "Comercio al por menor de materiales para la construcción en tiendas de autoservicio especializadas ",
            Category.SUBCLASS,
        ),
        Classification(
            "467117", "Comercio al por menor de artículos para albercas y otros artículos", Category.SUBCLASS
        ),
        Classification(
            "468",
            "Comercio al por menor de vehículos de motor, refacciones, combustibles y lubricantes ",
            Category.DIVISION,
        ),
        Classification("4681", "Comercio al por menor de automóviles y camionetas", Category.GROUP),
        Classification("46811", "Comercio al por menor de automóviles y camionetas", Category.CLASS),
        Classification("468111", "Comercio al por menor de automóviles y camionetas nuevos", Category.SUBCLASS),
        Classification("468112", "Comercio al por menor de automóviles y camionetas usados", Category.SUBCLASS),
        Classification(
            "4682",
            "Comercio al por menor de partes y refacciones para automóviles, camionetas y camiones ",
            Category.GROUP,
        ),
        Classification(
            "46821",
            "Comercio al por menor de partes y refacciones para automóviles, camionetas y camiones ",
            Category.CLASS,
        ),
        Classification(
            "468211",
            "Comercio al por menor de partes y refacciones nuevas para automóviles, camionetas y camiones ",
            Category.SUBCLASS,
        ),
        Classification(
            "468212",
            "Comercio al por menor de partes y refacciones usadas para automóviles, camionetas y camiones ",
            Category.SUBCLASS,
        ),
        Classification(
            "468213",
            "Comercio al por menor de llantas y cámaras para automóviles, camionetas y camiones ",
            Category.SUBCLASS,
        ),
        Classification("4683", "Comercio al por menor de motocicletas y otros vehículos de motor", Category.GROUP),
        Classification("46831", "Comercio al por menor de motocicletas y otros vehículos de motor", Category.CLASS),
        Classification("468311", "Comercio al por menor de motocicletas", Category.SUBCLASS),
        Classification("468319", "Comercio al por menor de otros vehículos de motor", Category.SUBCLASS),
        Classification("4684", "Comercio al por menor de combustibles, aceites y grasas lubricantes", Category.GROUP),
        Classification("46841", "Comercio al por menor de combustibles", Category.CLASS),
        Classification("468411", "Comercio al por menor de gasolina y diésel", Category.SUBCLASS),
        Classification(
            "468412", "Comercio al por menor de gas L.P. en cilindros y para tanques estacionarios", Category.SUBCLASS
        ),
        Classification("468413", "Comercio al por menor de gas L.P. en estaciones de carburación", Category.SUBCLASS),
        Classification("468414", "Comercio al por menor en estaciones de gas natural vehicular", Category.SUBCLASS),
        Classification("468419", "Comercio al por menor de otros combustibles", Category.SUBCLASS),
        Classification(
            "46842",
            "Comercio al por menor de aceites y grasas lubricantes, aditivos y similares para vehículos de motor ",
            Category.CLASS,
        ),
        Classification(
            "468420",
            "Comercio al por menor de aceites y grasas lubricantes, aditivos y similares para vehículos de motor ",
            Category.SUBCLASS,
        ),
        Classification(
            "469",
            "Comercio al por menor exclusivamente a través de internet, y catálogos impresos, televisión y similares ",
            Category.DIVISION,
        ),
        Classification(
            "4691",
            "Comercio al por menor exclusivamente a través de internet, y catálogos impresos, televisión y similares ",
            Category.GROUP,
        ),
        Classification(
            "46911",
            "Comercio al por menor exclusivamente a través de internet, y catálogos impresos, televisión y similares ",
            Category.CLASS,
        ),
        Classification(
            "469110",
            "Comercio al por menor exclusivamente a través de internet, y catálogos impresos, televisión y similares ",
            Category.SUBCLASS,
        ),
        Classification("48-49", "Transportes, correos y almacenamiento", Category.CLASS),
        Classification("481", "Transporte aéreo", Category.DIVISION),
        Classification("4811", "Transporte aéreo regular", Category.GROUP),
        Classification("48111", "Transporte aéreo regular", Category.CLASS),
        Classification("481111", "Transporte aéreo regular en líneas aéreas nacionales", Category.SUBCLASS),
        Classification("481112", "Transporte aéreo regular en líneas aéreas extranjeras", Category.SUBCLASS),
        Classification("4812", "Transporte aéreo no regular", Category.GROUP),
        Classification("48121", "Transporte aéreo no regular", Category.CLASS),
        Classification("481210", "Transporte aéreo no regular", Category.SUBCLASS),
        Classification("482", "Transporte por ferrocarril", Category.DIVISION),
        Classification("4821", "Transporte por ferrocarril", Category.GROUP),
        Classification("48211", "Transporte por ferrocarril", Category.CLASS),
        Classification("482110", "Transporte por ferrocarril", Category.SUBCLASS),
        Classification("483", "Transporte por agua", Category.DIVISION),
        Classification("4831", "Transporte marítimo", Category.GROUP),
        Classification("48311", "Transporte marítimo", Category.CLASS),
        Classification("483111", "Transporte marítimo de altura, excepto de petróleo y gas natural", Category.SUBCLASS),
        Classification(
            "483112", "Transporte marítimo de cabotaje, excepto de petróleo y gas natural", Category.SUBCLASS
        ),
        Classification("483113", "Transporte marítimo de petróleo y gas natural", Category.SUBCLASS),
        Classification("4832", "Transporte por aguas interiores", Category.GROUP),
        Classification("48321", "Transporte por aguas interiores", Category.CLASS),
        Classification("483210", "Transporte por aguas interiores", Category.SUBCLASS),
        Classification("484", "Autotransporte de carga", Category.DIVISION),
        Classification("4841", "Autotransporte de carga general", Category.GROUP),
        Classification("48411", "Autotransporte local de carga general", Category.CLASS),
        Classification("484111", "Autotransporte local de productos agrícolas sin refrigeración", Category.SUBCLASS),
        Classification("484119", "Otro autotransporte local de carga general", Category.SUBCLASS),
        Classification("48412", "Autotransporte foráneo de carga general", Category.CLASS),
        Classification("484121", "Autotransporte foráneo de productos agrícolas sin refrigeración", Category.SUBCLASS),
        Classification("484129", "Otro autotransporte foráneo de carga general", Category.SUBCLASS),
        Classification("4842", "Autotransporte de carga especializado", Category.GROUP),
        Classification("48421", "Servicios de mudanzas", Category.CLASS),
        Classification("484210", "Servicios de mudanzas", Category.SUBCLASS),
        Classification("48422", "Autotransporte local de carga especializado, excepto mudanzas", Category.CLASS),
        Classification("484221", "Autotransporte local de materiales para la construcción", Category.SUBCLASS),
        Classification("484222", "Autotransporte local de materiales y residuos peligrosos", Category.SUBCLASS),
        Classification("484223", "Autotransporte local con refrigeración", Category.SUBCLASS),
        Classification("484224", "Autotransporte local de madera", Category.SUBCLASS),
        Classification("484229", "Otro autotransporte local de carga especializado", Category.SUBCLASS),
        Classification("48423", "Autotransporte foráneo de carga especializado, excepto mudanzas", Category.CLASS),
        Classification("484231", "Autotransporte foráneo de materiales para la construcción", Category.SUBCLASS),
        Classification("484232", "Autotransporte foráneo de materiales y residuos peligrosos", Category.SUBCLASS),
        Classification("484233", "Autotransporte foráneo con refrigeración", Category.SUBCLASS),
        Classification("484234", "Autotransporte foráneo de madera", Category.SUBCLASS),
        Classification("484239", "Otro autotransporte foráneo de carga especializado", Category.SUBCLASS),
        Classification("485", "Transporte terrestre de pasajeros, excepto por ferrocarril", Category.DIVISION),
        Classification("4851", "Transporte colectivo urbano y suburbano de pasajeros de ruta fija", Category.GROUP),
        Classification("48511", "Transporte colectivo urbano y suburbano de pasajeros de ruta fija", Category.CLASS),
        Classification(
            "485111",
            "Transporte colectivo urbano y suburbano de pasajeros en autobuses de ruta fija ",
            Category.SUBCLASS,
        ),
        Classification(
            "485112",
            "Transporte colectivo urbano y suburbano de pasajeros en automóviles de ruta fija ",
            Category.SUBCLASS,
        ),
        Classification(
            "485113",
            "Transporte colectivo urbano y suburbano de pasajeros en trolebuses y trenes ligeros ",
            Category.SUBCLASS,
        ),
        Classification("485114", "Transporte colectivo urbano y suburbano de pasajeros en metro", Category.SUBCLASS),
        Classification(
            "485115",
            "Transporte colectivo urbano y suburbano de pasajeros en autobuses que transitan en carril exclusivo ",
            Category.SUBCLASS,
        ),
        Classification("4852", "Transporte colectivo foráneo de pasajeros de ruta fija", Category.GROUP),
        Classification("48521", "Transporte colectivo foráneo de pasajeros de ruta fija", Category.CLASS),
        Classification("485210", "Transporte colectivo foráneo de pasajeros de ruta fija", Category.SUBCLASS),
        Classification("4853", "Servicio de taxis y limusinas", Category.GROUP),
        Classification("48531", "Servicio de taxis", Category.CLASS),
        Classification("485311", "Transporte de pasajeros en taxis de sitio", Category.SUBCLASS),
        Classification("485312", "Transporte de pasajeros en taxis de ruleteo", Category.SUBCLASS),
        Classification("48532", "Alquiler de automóviles con chofer", Category.CLASS),
        Classification("485320", "Alquiler de automóviles con chofer", Category.SUBCLASS),
        Classification("4854", "Transporte escolar y de personal", Category.GROUP),
        Classification("48541", "Transporte escolar y de personal", Category.CLASS),
        Classification("485410", "Transporte escolar y de personal", Category.SUBCLASS),
        Classification("4855", "Alquiler de autobuses con chofer", Category.GROUP),
        Classification("48551", "Alquiler de autobuses con chofer", Category.CLASS),
        Classification("485510", "Alquiler de autobuses con chofer", Category.SUBCLASS),
        Classification("4859", "Otro transporte terrestre de pasajeros", Category.GROUP),
        Classification("48599", "Otro transporte terrestre de pasajeros", Category.CLASS),
        Classification("485990", "Otro transporte terrestre de pasajeros", Category.SUBCLASS),
        Classification("486", "Transporte por ductos", Category.DIVISION),
        Classification("4861", "Transporte de petróleo crudo por ductos", Category.GROUP),
        Classification("48611", "Transporte de petróleo crudo por ductos", Category.CLASS),
        Classification("486110", "Transporte de petróleo crudo por ductos", Category.SUBCLASS),
        Classification("4862", "Transporte de gas natural por ductos", Category.GROUP),
        Classification("48621", "Transporte de gas natural por ductos", Category.CLASS),
        Classification("486210", "Transporte de gas natural por ductos", Category.SUBCLASS),
        Classification("4869", "Transporte por ductos de otros productos", Category.GROUP),
        Classification("48691", "Transporte por ductos de productos refinados del petróleo", Category.CLASS),
        Classification("486910", "Transporte por ductos de productos refinados del petróleo", Category.SUBCLASS),
        Classification(
            "48699",
            "Transporte por ductos de otros productos, excepto de productos refinados del petróleo",
            Category.CLASS,
        ),
        Classification(
            "486990",
            "Transporte por ductos de otros productos, excepto de productos refinados del petróleo ",
            Category.SUBCLASS,
        ),
        Classification("487", "Transporte turístico", Category.DIVISION),
        Classification("4871", "Transporte turístico por tierra", Category.GROUP),
        Classification("48711", "Transporte turístico por tierra", Category.CLASS),
        Classification("487110", "Transporte turístico por tierra", Category.SUBCLASS),
        Classification("4872", "Transporte turístico por agua", Category.GROUP),
        Classification("48721", "Transporte turístico por agua", Category.CLASS),
        Classification("487210", "Transporte turístico por agua", Category.SUBCLASS),
        Classification("4879", "Otro transporte turístico", Category.GROUP),
        Classification("48799", "Otro transporte turístico", Category.CLASS),
        Classification("487990", "Otro transporte turístico", Category.SUBCLASS),
        Classification("488", "Servicios relacionados con el transporte", Category.DIVISION),
        Classification("4881", "Servicios relacionados con el transporte aéreo", Category.GROUP),
        Classification("48811", "Operaciones aeroportuarias", Category.CLASS),
        Classification("488111", "Servicios a la navegación aérea", Category.SUBCLASS),
        Classification("488112", "Administración de aeropuertos y helipuertos", Category.SUBCLASS),
        Classification("48819", "Otros servicios relacionados con el transporte aéreo", Category.CLASS),
        Classification("488190", "Otros servicios relacionados con el transporte aéreo", Category.SUBCLASS),
        Classification("4882", "Servicios relacionados con el transporte por ferrocarril", Category.GROUP),
        Classification("48821", "Servicios relacionados con el transporte por ferrocarril", Category.CLASS),
        Classification("488210", "Servicios relacionados con el transporte por ferrocarril", Category.SUBCLASS),
        Classification("4883", "Servicios relacionados con el transporte por agua", Category.GROUP),
        Classification("48831", "Administración de puertos y muelles", Category.CLASS),
        Classification("488310", "Administración de puertos y muelles", Category.SUBCLASS),
        Classification("48832", "Servicios de carga y descarga para el transporte por agua", Category.CLASS),
        Classification("488320", "Servicios de carga y descarga para el transporte por agua", Category.SUBCLASS),
        Classification("48833", "Servicios para la navegación por agua", Category.CLASS),
        Classification("488330", "Servicios para la navegación por agua", Category.SUBCLASS),
        Classification("48839", "Otros servicios relacionados con el transporte por agua", Category.CLASS),
        Classification("488390", "Otros servicios relacionados con el transporte por agua", Category.SUBCLASS),
        Classification("4884", "Servicios relacionados con el transporte por carretera", Category.GROUP),
        Classification("48841", "Servicios de grúa", Category.CLASS),
        Classification("488410", "Servicios de grúa", Category.SUBCLASS),
        Classification("48849", "Otros servicios relacionados con el transporte por carretera", Category.CLASS),
        Classification("488491", "Servicios de administración de centrales camioneras", Category.SUBCLASS),
        Classification(
            "488492", "Servicios de administración de carreteras, puentes y servicios auxiliares", Category.SUBCLASS
        ),
        Classification(
            "488493",
            "Servicios de báscula para el transporte y otros servicios relacionados con el transporte por carretera ",
            Category.SUBCLASS,
        ),
        Classification("4885", "Servicios de intermediación para el transporte de carga", Category.GROUP),
        Classification("48851", "Servicios de intermediación para el transporte de carga", Category.CLASS),
        Classification("488511", "Servicios de agencias aduanales", Category.SUBCLASS),
        Classification("488519", "Otros servicios de intermediación para el transporte de carga", Category.SUBCLASS),
        Classification("4889", "Otros servicios relacionados con el transporte", Category.GROUP),
        Classification("48899", "Otros servicios relacionados con el transporte", Category.CLASS),
        Classification("488990", "Otros servicios relacionados con el transporte", Category.SUBCLASS),
        Classification("491", "Servicios postales", Category.DIVISION),
        Classification("4911", "Servicios postales", Category.GROUP),
        Classification("49111", "Servicios postales", Category.CLASS),
        Classification("491110", "Servicios postales", Category.SUBCLASS),
        Classification("492", "Servicios de mensajería y paquetería", Category.DIVISION),
        Classification("4921", "Servicios de mensajería y paquetería foránea", Category.GROUP),
        Classification("49211", "Servicios de mensajería y paquetería foránea", Category.CLASS),
        Classification("492110", "Servicios de mensajería y paquetería foránea", Category.SUBCLASS),
        Classification("4922", "Servicios de mensajería y paquetería local", Category.GROUP),
        Classification("49221", "Servicios de mensajería y paquetería local", Category.CLASS),
        Classification("492210", "Servicios de mensajería y paquetería local", Category.SUBCLASS),
        Classification("493", "Servicios de almacenamiento", Category.DIVISION),
        Classification("4931", "Servicios de almacenamiento", Category.GROUP),
        Classification(
            "49311",
            "Almacenes generales de depósito y otros servicios de almacenamiento general sin instalaciones especializadas",
            Category.CLASS,
        ),
        Classification("493111", "Almacenes generales de depósito", Category.SUBCLASS),
        Classification(
            "493119", "Otros servicios de almacenamiento general sin instalaciones especializadas", Category.SUBCLASS
        ),
        Classification("49312", "Almacenamiento con refrigeración", Category.CLASS),
        Classification("493120", "Almacenamiento con refrigeración", Category.SUBCLASS),
        Classification("49313", "Almacenamiento de productos agrícolas que no requieren refrigeración", Category.CLASS),
        Classification(
            "493130", "Almacenamiento de productos agrícolas que no requieren refrigeración", Category.SUBCLASS
        ),
        Classification("49319", "Otros servicios de almacenamiento con instalaciones especializadas", Category.CLASS),
        Classification(
            "493190", "Otros servicios de almacenamiento con instalaciones especializadas", Category.SUBCLASS
        ),
        Classification("51", "Información en medios masivos", Category.SECTION),
        Classification(
            "511",
            "Edición de periódicos, revistas, libros, software y otros materiales, y edición de estas publicaciones integrada con la impresión",
            Category.DIVISION,
        ),
        Classification(
            "5111",
            "Edición de periódicos, revistas, libros y similares, y edición de estas publicaciones integrada con la impresión",
            Category.GROUP,
        ),
        Classification(
            "51111", "Edición de periódicos y edición de estas publicaciones integrada con la impresión", Category.CLASS
        ),
        Classification("511111", "Edición de periódicos", Category.SUBCLASS),
        Classification("511112", "Edición de periódicos integrada con la impresión", Category.SUBCLASS),
        Classification(
            "51112",
            "Edición de revistas y otras publicaciones periódicas y edición de estas publicaciones integrada con la impresión",
            Category.CLASS,
        ),
        Classification("511121", "Edición de revistas y otras publicaciones periódicas", Category.SUBCLASS),
        Classification(
            "511122",
            "Edición de revistas y otras publicaciones periódicas integrada con la impresión ",
            Category.SUBCLASS,
        ),
        Classification(
            "51113", "Edición de libros y edición de estas publicaciones integrada con la impresión", Category.CLASS
        ),
        Classification("511131", "Edición de libros", Category.SUBCLASS),
        Classification("511132", "Edición de libros integrada con la impresión", Category.SUBCLASS),
        Classification(
            "51114",
            "Edición de directorios y de listas de correo, y edición de estas publicaciones integrada con la impresión",
            Category.CLASS,
        ),
        Classification("511141", "Edición de directorios y de listas de correo", Category.SUBCLASS),
        Classification(
            "511142", "Edición de directorios y de listas de correo integrada con la impresión", Category.SUBCLASS
        ),
        Classification(
            "51119",
            "Edición de otros materiales y edición de estas publicaciones integrada con la impresión",
            Category.CLASS,
        ),
        Classification("511191", "Edición de otros materiales", Category.SUBCLASS),
        Classification("511192", "Edición de otros materiales integrada con la impresión", Category.SUBCLASS),
        Classification(
            "5112", "Edición de software y edición de software integrada con la reproducción", Category.GROUP
        ),
        Classification(
            "51121", "Edición de software y edición de software integrada con la reproducción", Category.CLASS
        ),
        Classification(
            "511210", "Edición de software y edición de software integrada con la reproducción", Category.SUBCLASS
        ),
        Classification("512", "Industria fílmica y del video, e industria del sonido", Category.DIVISION),
        Classification("5121", "Industria fílmica y del video", Category.GROUP),
        Classification(
            "51211",
            "Producción de películas, programas para la televisión y otros materiales audiovisuales",
            Category.CLASS,
        ),
        Classification("512111", "Producción de películas", Category.SUBCLASS),
        Classification("512112", "Producción de programas para la televisión", Category.SUBCLASS),
        Classification(
            "512113", "Producción de videoclips, comerciales y otros materiales audiovisuales", Category.SUBCLASS
        ),
        Classification("51212", "Distribución de películas y de otros materiales audiovisuales", Category.CLASS),
        Classification("512120", "Distribución de películas y de otros materiales audiovisuales", Category.SUBCLASS),
        Classification("51213", "Exhibición de películas y otros materiales audiovisuales", Category.CLASS),
        Classification("512130", "Exhibición de películas y otros materiales audiovisuales", Category.SUBCLASS),
        Classification(
            "51219",
            "Servicios de postproducción y otros servicios para la industria fílmica y del video",
            Category.CLASS,
        ),
        Classification(
            "512190",
            "Servicios de postproducción y otros servicios para la industria fílmica y del video ",
            Category.SUBCLASS,
        ),
        Classification("5122", "Industria del sonido", Category.GROUP),
        Classification("51223", "Editoras de música", Category.CLASS),
        Classification("512230", "Editoras de música", Category.SUBCLASS),
        Classification(
            "51224", "Grabación de discos compactos (CD) y de video digital (DVD) o casetes musicales", Category.CLASS
        ),
        Classification(
            "512240",
            "Grabación de discos compactos (CD) y de video digital (DVD) o casetes musicales ",
            Category.SUBCLASS,
        ),
        Classification("51225", "Productoras y distribuidoras discográficas", Category.CLASS),
        Classification("512250", "Productoras y distribuidoras discográficas", Category.SUBCLASS),
        Classification("51229", "Otros servicios de grabación del sonido", Category.CLASS),
        Classification("512290", "Otros servicios de grabación del sonido", Category.SUBCLASS),
        Classification("515", "Radio y televisión", Category.DIVISION),
        Classification("5151", "Transmisión de programas de radio y televisión", Category.GROUP),
        Classification("51511", "Transmisión de programas de radio", Category.CLASS),
        Classification("515110", "Transmisión de programas de radio", Category.SUBCLASS),
        Classification("51512", "Transmisión de programas de televisión", Category.CLASS),
        Classification("515120", "Transmisión de programas de televisión", Category.SUBCLASS),
        Classification(
            "5152",
            "Producción de programación de canales para sistemas de televisión por cable o satelitales",
            Category.GROUP,
        ),
        Classification(
            "51521",
            "Producción de programación de canales para sistemas de televisión por cable o satelitales",
            Category.CLASS,
        ),
        Classification(
            "515210",
            "Producción de programación de canales para sistemas de televisión por cable o satelitales ",
            Category.SUBCLASS,
        ),
        Classification("517", "Telecomunicaciones", Category.DIVISION),
        Classification(
            "5173", "Operadores de servicios de telecomunicaciones alámbricas e inalámbricas", Category.GROUP
        ),
        Classification(
            "51731", "Operadores de servicios de telecomunicaciones alámbricas e inalámbricas", Category.CLASS
        ),
        Classification("517311", "Operadores de servicios de telecomunicaciones alámbricas", Category.SUBCLASS),
        Classification("517312", "Operadores de servicios de telecomunicaciones inalámbricas", Category.SUBCLASS),
        Classification("5174", "Operadores de servicios de telecomunicaciones vía satélite", Category.GROUP),
        Classification("51741", "Operadores de servicios de telecomunicaciones vía satélite", Category.CLASS),
        Classification("517410", "Operadores de servicios de telecomunicaciones vía satélite", Category.SUBCLASS),
        Classification("5179", "Otros servicios de telecomunicaciones", Category.GROUP),
        Classification("51791", "Otros servicios de telecomunicaciones", Category.CLASS),
        Classification("517910", "Otros servicios de telecomunicaciones", Category.SUBCLASS),
        Classification(
            "518",
            "Procesamiento electrónico de información, hospedaje y otros servicios relacionados",
            Category.DIVISION,
        ),
        Classification(
            "5182", "Procesamiento electrónico de información, hospedaje y otros servicios relacionados", Category.GROUP
        ),
        Classification(
            "51821",
            "Procesamiento electrónico de información, hospedaje y otros servicios relacionados",
            Category.CLASS,
        ),
        Classification(
            "518210",
            "Procesamiento electrónico de información, hospedaje y otros servicios relacionados ",
            Category.SUBCLASS,
        ),
        Classification("519", "Otros servicios de información", Category.DIVISION),
        Classification("5191", "Otros servicios de información", Category.GROUP),
        Classification("51911", "Agencias noticiosas", Category.CLASS),
        Classification("519110", "Agencias noticiosas", Category.SUBCLASS),
        Classification("51912", "Bibliotecas y archivos", Category.CLASS),
        Classification("519121", "Bibliotecas y archivos del sector privado", Category.SUBCLASS),
        Classification("519122", "Bibliotecas y archivos del sector público", Category.SUBCLASS),
        Classification(
            "51913",
            "Edición y difusión de contenido exclusivamente a través de interney servicios de búsqueda en la red",
            Category.CLASS,
        ),
        Classification(
            "519130",
            "Edición y difusión de contenido exclusivamente a través de interney servicios de búsqueda en la red ",
            Category.SUBCLASS,
        ),
        Classification("51919", "Otros servicios de suministro de información", Category.CLASS),
        Classification("519190", "Otros servicios de suministro de información", Category.SUBCLASS),
        Classification("52", "Servicios financieros y de seguros", Category.SECTION),
        Classification("521", "Banca central", Category.DIVISION),
        Classification("5211", "Banca central", Category.GROUP),
        Classification("52111", "Banca central", Category.CLASS),
        Classification("521110", "Banca central", Category.SUBCLASS),
        Classification("522", "Instituciones de intermediación crediticia y financiera no bursátil", Category.DIVISION),
        Classification("5221", "Banca múltiple", Category.GROUP),
        Classification("52211", "Banca múltiple", Category.CLASS),
        Classification("522110", "Banca múltiple", Category.SUBCLASS),
        Classification("5222", "Instituciones financieras de fomento económico", Category.GROUP),
        Classification("52221", "Banca de desarrollo", Category.CLASS),
        Classification("522210", "Banca de desarrollo", Category.SUBCLASS),
        Classification("52222", "Fondos y fideicomisos financieros", Category.CLASS),
        Classification("522220", "Fondos y fideicomisos financieros", Category.SUBCLASS),
        Classification("5223", "Uniones de crédito e instituciones de ahorro", Category.GROUP),
        Classification("52231", "Uniones de crédito", Category.CLASS),
        Classification("522310", "Uniones de crédito", Category.SUBCLASS),
        Classification("52232", "Cajas de ahorro popular", Category.CLASS),
        Classification("522320", "Cajas de ahorro popular", Category.SUBCLASS),
        Classification("52239", "Otras instituciones de ahorro y préstamo", Category.CLASS),
        Classification("522390", "Otras instituciones de ahorro y préstamo", Category.SUBCLASS),
        Classification(
            "5224", "Otras instituciones de intermediación crediticia y financiera no bursátil", Category.GROUP
        ),
        Classification("52244", "Compañías de autofinanciamiento", Category.CLASS),
        Classification("522440", "Compañías de autofinanciamiento", Category.SUBCLASS),
        Classification("52245", "Montepíos y casas de empeño", Category.CLASS),
        Classification("522451", "Montepíos", Category.SUBCLASS),
        Classification("522452", "Casas de empeño", Category.SUBCLASS),
        Classification("52246", "Sociedades financieras de objeto múltiple", Category.CLASS),
        Classification("522460", "Sociedades financieras de objeto múltiple", Category.SUBCLASS),
        Classification(
            "52249", "Otras instituciones de intermediación crediticia y financiera no bursátil", Category.CLASS
        ),
        Classification(
            "522490", "Otras instituciones de intermediación crediticia y financiera no bursátil", Category.SUBCLASS
        ),
        Classification("5225", "Servicios relacionados con la intermediación crediticia no bursátil", Category.GROUP),
        Classification("52251", "Servicios relacionados con la intermediación crediticia no bursátil", Category.CLASS),
        Classification(
            "522510", "Servicios relacionados con la intermediación crediticia no bursátil", Category.SUBCLASS
        ),
        Classification("523", "Actividades bursátiles, cambiarias y de inversión financiera", Category.DIVISION),
        Classification("5231", "Casas de bolsa, casas de cambio y centros cambiarios", Category.GROUP),
        Classification("52311", "Casas de bolsa", Category.CLASS),
        Classification("523110", "Casas de bolsa", Category.SUBCLASS),
        Classification("52312", "Casas de cambio y centros cambiarios", Category.CLASS),
        Classification("523121", "Casas de cambio", Category.SUBCLASS),
        Classification("523122", "Centros cambiarios", Category.SUBCLASS),
        Classification("5232", "Bolsa de valores", Category.GROUP),
        Classification("52321", "Bolsa de valores", Category.CLASS),
        Classification("523210", "Bolsa de valores", Category.SUBCLASS),
        Classification(
            "5239",
            "Asesoría en inversiones y otros servicios relacionados con la intermediación bursátil",
            Category.GROUP,
        ),
        Classification("52391", "Asesoría en inversiones", Category.CLASS),
        Classification("523910", "Asesoría en inversiones", Category.SUBCLASS),
        Classification("52399", "Otros servicios relacionados con la intermediación bursátil", Category.CLASS),
        Classification("523990", "Otros servicios relacionados con la intermediación bursátil", Category.SUBCLASS),
        Classification(
            "524", "Compañías de seguros, fianzas, y administración de fondos para el retiro", Category.DIVISION
        ),
        Classification("5241", "Compañías de seguros y fianzas", Category.GROUP),
        Classification("52411", "Compañías de seguros", Category.CLASS),
        Classification("524110", "Compañías de seguros", Category.SUBCLASS),
        Classification("52412", "Fondos de aseguramiento campesino", Category.CLASS),
        Classification("524120", "Fondos de aseguramiento campesino", Category.SUBCLASS),
        Classification("52413", "Compañías afianzadoras", Category.CLASS),
        Classification("524130", "Compañías afianzadoras", Category.SUBCLASS),
        Classification(
            "5242",
            "Servicios relacionados con los seguros y las fianzas, y administración de fondos para el retiro",
            Category.GROUP,
        ),
        Classification("52421", "Agentes, ajustadores y gestores de seguros y fianzas", Category.CLASS),
        Classification("524210", "Agentes, ajustadores y gestores de seguros y fianzas", Category.SUBCLASS),
        Classification("52422", "Administración de fondos para el retiro", Category.CLASS),
        Classification("524220", "Administración de fondos para el retiro", Category.SUBCLASS),
        Classification(
            "525",
            "Sociedades de inversión especializadas en fondos para el retiro y fondos de inversión ",
            Category.DIVISION,
        ),
        Classification("5251", "Sociedades de inversión especializadas en fondos para el retiro", Category.GROUP),
        Classification("52511", "Sociedades de inversión especializadas en fondos para el retiro", Category.CLASS),
        Classification("525110", "Sociedades de inversión especializadas en fondos para el retiro", Category.SUBCLASS),
        Classification("5252", "Fondos de inversión", Category.GROUP),
        Classification("52521", "Fondos de inversión", Category.CLASS),
        Classification("525210", "Fondos de inversión", Category.SUBCLASS),
        Classification("53", "Servicios inmobiliarios y de alquiler de bienes muebles e intangibles", Category.SECTION),
        Classification("531", "Servicios inmobiliarios", Category.DIVISION),
        Classification("5311", "Alquiler sin intermediación de bienes raíces", Category.GROUP),
        Classification("53111", "Alquiler sin intermediación de bienes raíces", Category.CLASS),
        Classification("531111", "Alquiler sin intermediación de viviendas amuebladas", Category.SUBCLASS),
        Classification("531112", "Alquiler sin intermediación de viviendas no amuebladas", Category.SUBCLASS),
        Classification(
            "531113", "Alquiler sin intermediación de salones para fiestas y convenciones", Category.SUBCLASS
        ),
        Classification("531114", "Alquiler sin intermediación de oficinas y locales comerciales", Category.SUBCLASS),
        Classification(
            "531115", "Alquiler sin intermediación de teatros, estadios, auditorios y similares", Category.SUBCLASS
        ),
        Classification(
            "531116",
            "Alquiler sin intermediación de edificios industriales dentro de un parque industrial ",
            Category.SUBCLASS,
        ),
        Classification("531119", "Alquiler sin intermediación de otros bienes raíces", Category.SUBCLASS),
        Classification("5312", "Inmobiliarias y corredores de bienes raíces", Category.GROUP),
        Classification("53121", "Inmobiliarias y corredores de bienes raíces", Category.CLASS),
        Classification("531210", "Inmobiliarias y corredores de bienes raíces", Category.SUBCLASS),
        Classification("5313", "Servicios relacionados con los servicios inmobiliarios", Category.GROUP),
        Classification("53131", "Servicios relacionados con los servicios inmobiliarios", Category.CLASS),
        Classification("531311", "Servicios de administración de bienes raíces", Category.SUBCLASS),
        Classification("531319", "Otros servicios relacionados con los servicios inmobiliarios", Category.SUBCLASS),
        Classification("532", "Servicios de alquiler de bienes muebles", Category.DIVISION),
        Classification("5321", "Alquiler de automóviles, camiones y otros transportes terrestres", Category.GROUP),
        Classification("53211", "Alquiler de automóviles sin chofer", Category.CLASS),
        Classification("532110", "Alquiler de automóviles sin chofer", Category.SUBCLASS),
        Classification(
            "53212", "Alquiler de camiones de carga, autobuses, minibuses y remolques sin chofer", Category.CLASS
        ),
        Classification("532121", "Alquiler de camiones de carga sin chofer", Category.SUBCLASS),
        Classification("532122", "Alquiler de autobuses, minibuses y remolques sin chofer", Category.SUBCLASS),
        Classification("5322", "Alquiler de artículos para el hogar y personales", Category.GROUP),
        Classification(
            "53221", "Alquiler de aparatos eléctricos y electrónicos para el hogar y personales", Category.CLASS
        ),
        Classification(
            "532210", "Alquiler de aparatos eléctricos y electrónicos para el hogar y personales", Category.SUBCLASS
        ),
        Classification("53228", "Alquiler de otros artículos para el hogar y personales", Category.CLASS),
        Classification("532281", "Alquiler de prendas de vestir", Category.SUBCLASS),
        Classification("532282", "Alquiler de mesas, sillas, vajillas y similares", Category.SUBCLASS),
        Classification("532289", "Alquiler de otros artículos para el hogar y personales", Category.SUBCLASS),
        Classification("5323", "Centros generales de alquiler", Category.GROUP),
        Classification("53231", "Centros generales de alquiler", Category.CLASS),
        Classification("532310", "Centros generales de alquiler", Category.SUBCLASS),
        Classification(
            "5324",
            "Alquiler de maquinaria y equipo agropecuario, pesquero, industrial, comercial y de servicios",
            Category.GROUP,
        ),
        Classification(
            "53241",
            "Alquiler de maquinaria y equipo para construcción, minería, actividades forestales y transporte, excepto terrestre",
            Category.CLASS,
        ),
        Classification(
            "532411",
            "Alquiler de maquinaria y equipo para construcción, minería y actividades forestales ",
            Category.SUBCLASS,
        ),
        Classification("532412", "Alquiler de equipo de transporte, excepto terrestre", Category.SUBCLASS),
        Classification(
            "53242", "Alquiler de equipo de cómputo y de otras máquinas y mobiliario de oficina", Category.CLASS
        ),
        Classification(
            "532420", "Alquiler de equipo de cómputo y de otras máquinas y mobiliario de oficina", Category.SUBCLASS
        ),
        Classification(
            "53249",
            "Alquiler de otra maquinaria y equipo agropecuario, pesquero, para la industria manufacturera, comercial y de servicios",
            Category.CLASS,
        ),
        Classification(
            "532491",
            "Alquiler de maquinaria y equipo agropecuario, pesquero y para la industria manufacturera ",
            Category.SUBCLASS,
        ),
        Classification(
            "532492", "Alquiler de maquinaria y equipo para mover, levantar y acomodar materiales", Category.SUBCLASS
        ),
        Classification("532493", "Alquiler de maquinaria y equipo comercial y de servicios", Category.SUBCLASS),
        Classification("533", "Servicios de alquiler de marcas registradas, patentes y franquicias", Category.DIVISION),
        Classification("5331", "Servicios de alquiler de marcas registradas, patentes y franquicias", Category.GROUP),
        Classification("53311", "Servicios de alquiler de marcas registradas, patentes y franquicias", Category.CLASS),
        Classification(
            "533110", "Servicios de alquiler de marcas registradas, patentes y franquicias", Category.SUBCLASS
        ),
        Classification("54", "Servicios profesionales, científicos y técnicos", Category.SECTION),
        Classification("541", "Servicios profesionales, científicos y técnicos", Category.DIVISION),
        Classification("5411", "Servicios legales", Category.GROUP),
        Classification("54111", "Bufetes jurídicos", Category.CLASS),
        Classification("541110", "Bufetes jurídicos", Category.SUBCLASS),
        Classification("54112", "Notarías públicas", Category.CLASS),
        Classification("541120", "Notarías públicas", Category.SUBCLASS),
        Classification("54119", "Servicios de apoyo para efectuar trámites legales", Category.CLASS),
        Classification("541190", "Servicios de apoyo para efectuar trámites legales", Category.SUBCLASS),
        Classification("5412", "Servicios de contabilidad, auditoría y servicios relacionados", Category.GROUP),
        Classification("54121", "Servicios de contabilidad, auditoría y servicios relacionados", Category.CLASS),
        Classification("541211", "Servicios de contabilidad y auditoría", Category.SUBCLASS),
        Classification("541219", "Otros servicios relacionados con la contabilidad", Category.SUBCLASS),
        Classification("5413", "Servicios de arquitectura, ingeniería y actividades relacionadas", Category.GROUP),
        Classification("54131", "Servicios de arquitectura", Category.CLASS),
        Classification("541310", "Servicios de arquitectura", Category.SUBCLASS),
        Classification("54132", "Servicios de arquitectura de paisaje y urbanismo", Category.CLASS),
        Classification("541320", "Servicios de arquitectura de paisaje y urbanismo", Category.SUBCLASS),
        Classification("54133", "Servicios de ingeniería", Category.CLASS),
        Classification("541330", "Servicios de ingeniería", Category.SUBCLASS),
        Classification("54134", "Servicios de dibujo", Category.CLASS),
        Classification("541340", "Servicios de dibujo", Category.SUBCLASS),
        Classification("54135", "Servicios de inspección de edificios", Category.CLASS),
        Classification("541350", "Servicios de inspección de edificios", Category.SUBCLASS),
        Classification("54136", "Servicios de levantamiento geofísico", Category.CLASS),
        Classification("541360", "Servicios de levantamiento geofísico", Category.SUBCLASS),
        Classification("54137", "Servicios de elaboración de mapas", Category.CLASS),
        Classification("541370", "Servicios de elaboración de mapas", Category.SUBCLASS),
        Classification("54138", "Laboratorios de pruebas", Category.CLASS),
        Classification("541380", "Laboratorios de pruebas", Category.SUBCLASS),
        Classification("5414", "Diseño especializado", Category.GROUP),
        Classification("54141", "Diseño y decoración de interiores", Category.CLASS),
        Classification("541410", "Diseño y decoración de interiores", Category.SUBCLASS),
        Classification("54142", "Diseño industrial", Category.CLASS),
        Classification("541420", "Diseño industrial", Category.SUBCLASS),
        Classification("54143", "Diseño gráfico", Category.CLASS),
        Classification("541430", "Diseño gráfico", Category.SUBCLASS),
        Classification("54149", "Diseño de modas y otros diseños especializados", Category.CLASS),
        Classification("541490", "Diseño de modas y otros diseños especializados", Category.SUBCLASS),
        Classification("5415", "Servicios de diseño de sistemas de cómputo y servicios relacionados", Category.GROUP),
        Classification("54151", "Servicios de diseño de sistemas de cómputo y servicios relacionados", Category.CLASS),
        Classification(
            "541510", "Servicios de diseño de sistemas de cómputo y servicios relacionados", Category.SUBCLASS
        ),
        Classification("5416", "Servicios de consultoría administrativa, científica y técnica", Category.GROUP),
        Classification("54161", "Servicios de consultoría en administración", Category.CLASS),
        Classification("541610", "Servicios de consultoría en administración", Category.SUBCLASS),
        Classification("54162", "Servicios de consultoría en medio ambiente", Category.CLASS),
        Classification("541620", "Servicios de consultoría en medio ambiente", Category.SUBCLASS),
        Classification("54169", "Otros servicios de consultoría científica y técnica", Category.CLASS),
        Classification("541690", "Otros servicios de consultoría científica y técnica", Category.SUBCLASS),
        Classification("5417", "Servicios de investigación científica y desarrollo", Category.GROUP),
        Classification(
            "54171",
            "Servicios de investigación científica y desarrollo en ciencias naturales y exactas, ingeniería, y ciencias de la vida",
            Category.CLASS,
        ),
        Classification(
            "541711",
            "Servicios de investigación científica y desarrollo en ciencias naturales y exactas, ingeniería, y ciencias de la vida, prestados por el sector privado ",
            Category.SUBCLASS,
        ),
        Classification(
            "541712",
            "Servicios de investigación científica y desarrollo en ciencias naturales y exactas, ingeniería, y ciencias de la vida, prestados por el sector público ",
            Category.SUBCLASS,
        ),
        Classification(
            "54172",
            "Servicios de investigación científica y desarrollo en ciencias sociales y humanidades",
            Category.CLASS,
        ),
        Classification(
            "541721",
            "Servicios de investigación científica y desarrollo en ciencias sociales y humanidades, prestados por el sector privado ",
            Category.SUBCLASS,
        ),
        Classification(
            "541722",
            "Servicios de investigación científica y desarrollo en ciencias sociales y humanidades, prestados por el sector público ",
            Category.SUBCLASS,
        ),
        Classification("5418", "Servicios de publicidad y actividades relacionadas", Category.GROUP),
        Classification("54181", "Agencias de publicidad", Category.CLASS),
        Classification("541810", "Agencias de publicidad", Category.SUBCLASS),
        Classification("54182", "Agencias de relaciones públicas", Category.CLASS),
        Classification("541820", "Agencias de relaciones públicas", Category.SUBCLASS),
        Classification("54183", "Agencias de compra de medios a petición del cliente", Category.CLASS),
        Classification("541830", "Agencias de compra de medios a petición del cliente", Category.SUBCLASS),
        Classification("54184", "Agencias de representación de medios", Category.CLASS),
        Classification("541840", "Agencias de representación de medios", Category.SUBCLASS),
        Classification("54185", "Agencias de anuncios publicitarios", Category.CLASS),
        Classification("541850", "Agencias de anuncios publicitarios", Category.SUBCLASS),
        Classification("54186", "Agencias de correo directo", Category.CLASS),
        Classification("541860", "Agencias de correo directo", Category.SUBCLASS),
        Classification("54187", "Distribución de material publicitario", Category.CLASS),
        Classification("541870", "Distribución de material publicitario", Category.SUBCLASS),
        Classification("54189", "Servicios de rotulación y otros servicios de publicidad", Category.CLASS),
        Classification("541890", "Servicios de rotulación y otros servicios de publicidad", Category.SUBCLASS),
        Classification("5419", "Otros servicios profesionales, científicos y técnicos", Category.GROUP),
        Classification(
            "54191", "Servicios de investigación de mercados y encuestas de opinión pública", Category.CLASS
        ),
        Classification(
            "541910", "Servicios de investigación de mercados y encuestas de opinión pública", Category.SUBCLASS
        ),
        Classification("54192", "Servicios de fotografía y videograbación", Category.CLASS),
        Classification("541920", "Servicios de fotografía y videograbación", Category.SUBCLASS),
        Classification("54193", "Servicios de traducción e interpretación", Category.CLASS),
        Classification("541930", "Servicios de traducción e interpretación", Category.SUBCLASS),
        Classification("54194", "Servicios veterinarios", Category.CLASS),
        Classification(
            "541941", "Servicios veterinarios para mascotas prestados por el sector privado", Category.SUBCLASS
        ),
        Classification(
            "541942", "Servicios veterinarios para mascotas prestados por el sector público", Category.SUBCLASS
        ),
        Classification(
            "541943", "Servicios veterinarios para la ganadería prestados por el sector privado", Category.SUBCLASS
        ),
        Classification(
            "541944", "Servicios veterinarios para la ganadería prestados por el sector público", Category.SUBCLASS
        ),
        Classification("54199", "Otros servicios profesionales, científicos y técnicos", Category.CLASS),
        Classification("541990", "Otros servicios profesionales, científicos y técnicos", Category.SUBCLASS),
        Classification("55", "Corporativos", Category.SECTION),
        Classification("551", "Corporativos", Category.DIVISION),
        Classification("5511", "Corporativos", Category.GROUP),
        Classification("55111", "Corporativos", Category.CLASS),
        Classification("551111", "Corporativos", Category.SUBCLASS),
        Classification("551112", "Tenedoras de acciones", Category.SUBCLASS),
        Classification(
            "56", "Servicios de apoyo a los negocios y manejo de residuos, y servicios de remediación", Category.SECTION
        ),
        Classification("561", "Servicios de apoyo a los negocios", Category.DIVISION),
        Classification("5611", "Servicios de administración de negocios", Category.GROUP),
        Classification("56111", "Servicios de administración de negocios", Category.CLASS),
        Classification("561110", "Servicios de administración de negocios", Category.SUBCLASS),
        Classification("5612", "Servicios combinados de apoyo en instalaciones", Category.GROUP),
        Classification("56121", "Servicios combinados de apoyo en instalaciones", Category.CLASS),
        Classification("561210", "Servicios combinados de apoyo en instalaciones", Category.SUBCLASS),
        Classification("5613", "Servicios de empleo", Category.GROUP),
        Classification("56131", "Agencias de colocación", Category.CLASS),
        Classification("561310", "Agencias de colocación", Category.SUBCLASS),
        Classification("56132", "Agencias de empleo temporal", Category.CLASS),
        Classification("561320", "Agencias de empleo temporal", Category.SUBCLASS),
        Classification("56133", "Suministro de personal permanente", Category.CLASS),
        Classification("561330", "Suministro de personal permanente", Category.SUBCLASS),
        Classification(
            "5614",
            "Servicios de apoyo secretarial, fotocopiado, cobranza, investigación crediticia y similares",
            Category.GROUP,
        ),
        Classification("56141", "Servicios de preparación de documentos", Category.CLASS),
        Classification("561410", "Servicios de preparación de documentos", Category.SUBCLASS),
        Classification(
            "56142", "Servicios de casetas telefónicas, recepción de llamadas y promoción por teléfono", Category.CLASS
        ),
        Classification("561421", "Servicios de casetas telefónicas", Category.SUBCLASS),
        Classification(
            "561422", "Servicios de recepción de llamadas telefónicas y promoción por teléfono", Category.SUBCLASS
        ),
        Classification("56143", "Servicios de fotocopiado, fax, acceso a computadoras y afines", Category.CLASS),
        Classification("561431", "Servicios de fotocopiado, fax y afines", Category.SUBCLASS),
        Classification("561432", "Servicios de acceso a computadoras", Category.SUBCLASS),
        Classification("56144", "Agencias de cobranza", Category.CLASS),
        Classification("561440", "Agencias de cobranza", Category.SUBCLASS),
        Classification("56145", "Despachos de investigación de solvencia financiera", Category.CLASS),
        Classification("561450", "Despachos de investigación de solvencia financiera", Category.SUBCLASS),
        Classification("56149", "Otros servicios de apoyo secretarial y similares", Category.CLASS),
        Classification("561490", "Otros servicios de apoyo secretarial y similares", Category.SUBCLASS),
        Classification("5615", "Agencias de viajes y servicios de reservaciones", Category.GROUP),
        Classification("56151", "Agencias de viajes", Category.CLASS),
        Classification("561510", "Agencias de viajes", Category.SUBCLASS),
        Classification(
            "56152",
            "Organización de excursiones y paquetes turísticos para agencias de viajes (Operadores de tours)",
            Category.CLASS,
        ),
        Classification(
            "561520",
            "Organización de excursiones y paquetes turísticos para agencias de viajes (Operadores de tours) ",
            Category.SUBCLASS,
        ),
        Classification("56159", "Otros servicios de reservaciones", Category.CLASS),
        Classification("561590", "Otros servicios de reservaciones", Category.SUBCLASS),
        Classification("5616", "Servicios de investigación, protección y seguridad", Category.GROUP),
        Classification(
            "56161", "Servicios de investigación y de protección y custodia, excepto mediante monitoreo", Category.CLASS
        ),
        Classification(
            "561610",
            "Servicios de investigación y de protección y custodia, excepto mediante monitoreo ",
            Category.SUBCLASS,
        ),
        Classification(
            "56162", "Servicios de protección y custodia mediante el monitoreo de sistemas de seguridad", Category.CLASS
        ),
        Classification(
            "561620",
            "Servicios de protección y custodia mediante el monitoreo de sistemas de seguridad ",
            Category.SUBCLASS,
        ),
        Classification("5617", "Servicios de limpieza", Category.GROUP),
        Classification("56171", "Servicios de control y exterminación de plagas", Category.CLASS),
        Classification("561710", "Servicios de control y exterminación de plagas", Category.SUBCLASS),
        Classification("56172", "Servicios de limpieza de inmuebles", Category.CLASS),
        Classification("561720", "Servicios de limpieza de inmuebles", Category.SUBCLASS),
        Classification("56173", "Servicios de instalación y mantenimiento de áreas verdes", Category.CLASS),
        Classification("561730", "Servicios de instalación y mantenimiento de áreas verdes", Category.SUBCLASS),
        Classification("56174", "Servicios de limpieza de tapicería, alfombras y muebles", Category.CLASS),
        Classification("561740", "Servicios de limpieza de tapicería, alfombras y muebles", Category.SUBCLASS),
        Classification("56179", "Otros servicios de limpieza", Category.CLASS),
        Classification("561790", "Otros servicios de limpieza", Category.SUBCLASS),
        Classification("5619", "Otros servicios de apoyo a los negocios", Category.GROUP),
        Classification("56191", "Servicios de empacado y etiquetado", Category.CLASS),
        Classification("561910", "Servicios de empacado y etiquetado", Category.SUBCLASS),
        Classification("56192", "Organizadores de convenciones y ferias comerciales e industriales", Category.CLASS),
        Classification(
            "561920", "Organizadores de convenciones y ferias comerciales e industriales", Category.SUBCLASS
        ),
        Classification("56199", "Otros servicios de apoyo a los negocios", Category.CLASS),
        Classification("561990", "Otros servicios de apoyo a los negocios", Category.SUBCLASS),
        Classification("562", "Manejo de residuos y servicios de remediación", Category.DIVISION),
        Classification("5621", "Recolección de residuos", Category.GROUP),
        Classification("56211", "Recolección de residuos peligrosos", Category.CLASS),
        Classification("562111", "Recolección de residuos peligrosos por el sector privado", Category.SUBCLASS),
        Classification("562112", "Recolección de residuos peligrosos por el sector público", Category.SUBCLASS),
        Classification("56212", "Recolección de residuos no peligrosos", Category.CLASS),
        Classification("562121", "Recolección de residuos no peligrosos por el sector privado", Category.SUBCLASS),
        Classification("562122", "Recolección de residuos no peligrosos por el sector público", Category.SUBCLASS),
        Classification("5622", "Tratamiento y disposición final de residuos", Category.GROUP),
        Classification("56221", "Tratamiento y disposición final de residuos peligrosos", Category.CLASS),
        Classification(
            "562211", "Tratamiento y disposición final de residuos peligrosos por el sector privado", Category.SUBCLASS
        ),
        Classification(
            "562212", "Tratamiento y disposición final de residuos peligrosos por el sector público", Category.SUBCLASS
        ),
        Classification("56222", "Tratamiento y disposición final de residuos no peligrosos", Category.CLASS),
        Classification(
            "562221",
            "Tratamiento y disposición final de residuos no peligrosos por el sector privado ",
            Category.SUBCLASS,
        ),
        Classification(
            "562222",
            "Tratamiento y disposición final de residuos no peligrosos por el sector público ",
            Category.SUBCLASS,
        ),
        Classification(
            "5629", "Servicios de remediación, recuperación, y otros servicios de manejo de residuos", Category.GROUP
        ),
        Classification("56291", "Servicios de remediación", Category.CLASS),
        Classification("562911", "Servicios de remediación de residuos por el sector privado", Category.SUBCLASS),
        Classification("562912", "Servicios de remediación de residuos por el sector público", Category.SUBCLASS),
        Classification("56292", "Recuperación de residuos", Category.CLASS),
        Classification("562921", "Recuperación de residuos por el sector privado", Category.SUBCLASS),
        Classification("562922", "Recuperación de residuos por el sector público", Category.SUBCLASS),
        Classification("56299", "Otros servicios de manejo de residuos", Category.CLASS),
        Classification("562998", "Otros servicios de manejo de residuos por el sector privado", Category.SUBCLASS),
        Classification("562999", "Otros servicios de manejo de residuos por el sector público", Category.SUBCLASS),
        Classification("61", "Servicios educativos", Category.SECTION),
        Classification("611", "Servicios educativos", Category.DIVISION),
        Classification("6111", "Escuelas de educación básica, media y para necesidades especiales", Category.GROUP),
        Classification("61111", "Escuelas de educación preescolar", Category.CLASS),
        Classification("611111", "Escuelas de educación preescolar del sector privado", Category.SUBCLASS),
        Classification("611112", "Escuelas de educación preescolar del sector público", Category.SUBCLASS),
        Classification("61112", "Escuelas de educación primaria", Category.CLASS),
        Classification("611121", "Escuelas de educación primaria del sector privado", Category.SUBCLASS),
        Classification("611122", "Escuelas de educación primaria del sector público", Category.SUBCLASS),
        Classification("61113", "Escuelas de educación secundaria general", Category.CLASS),
        Classification("611131", "Escuelas de educación secundaria general del sector privado", Category.SUBCLASS),
        Classification("611132", "Escuelas de educación secundaria general del sector público", Category.SUBCLASS),
        Classification("61114", "Escuelas de educación secundaria técnica", Category.CLASS),
        Classification("611141", "Escuelas de educación secundaria técnica del sector privado", Category.SUBCLASS),
        Classification("611142", "Escuelas de educación secundaria técnica del sector público", Category.SUBCLASS),
        Classification("61115", "Escuelas de educación media técnica terminal", Category.CLASS),
        Classification("611151", "Escuelas de educación media técnica terminal del sector privado", Category.SUBCLASS),
        Classification("611152", "Escuelas de educación media técnica terminal del sector público", Category.SUBCLASS),
        Classification("61116", "Escuelas de educación media superior", Category.CLASS),
        Classification("611161", "Escuelas de educación media superior del sector privado", Category.SUBCLASS),
        Classification("611162", "Escuelas de educación media superior del sector público", Category.SUBCLASS),
        Classification("61117", "Escuelas que combinan diversos niveles de educación", Category.CLASS),
        Classification(
            "611171", "Escuelas del sector privado que combinan diversos niveles de educación", Category.SUBCLASS
        ),
        Classification(
            "611172", "Escuelas del sector público que combinan diversos niveles de educación", Category.SUBCLASS
        ),
        Classification("61118", "Escuelas de educación para necesidades especiales", Category.CLASS),
        Classification(
            "611181", "Escuelas del sector privado de educación para necesidades especiales", Category.SUBCLASS
        ),
        Classification(
            "611182", "Escuelas del sector público de educación para necesidades especiales", Category.SUBCLASS
        ),
        Classification("6112", "Escuelas de educación técnica superior", Category.GROUP),
        Classification("61121", "Escuelas de educación técnica superior", Category.CLASS),
        Classification("611211", "Escuelas de educación técnica superior del sector privado", Category.SUBCLASS),
        Classification("611212", "Escuelas de educación técnica superior del sector público", Category.SUBCLASS),
        Classification("6113", "Escuelas de educación superior", Category.GROUP),
        Classification("61131", "Escuelas de educación superior", Category.CLASS),
        Classification("611311", "Escuelas de educación superior del sector privado", Category.SUBCLASS),
        Classification("611312", "Escuelas de educación superior del sector público", Category.SUBCLASS),
        Classification(
            "6114", "Escuelas comerciales, de computación y de capacitación para ejecutivos", Category.GROUP
        ),
        Classification("61141", "Escuelas comerciales y secretariales", Category.CLASS),
        Classification("611411", "Escuelas comerciales y secretariales del sector privado", Category.SUBCLASS),
        Classification("611412", "Escuelas comerciales y secretariales del sector público", Category.SUBCLASS),
        Classification("61142", "Escuelas de computación", Category.CLASS),
        Classification("611421", "Escuelas de computación del sector privado", Category.SUBCLASS),
        Classification("611422", "Escuelas de computación del sector público", Category.SUBCLASS),
        Classification("61143", "Escuelas para la capacitación de ejecutivos", Category.CLASS),
        Classification("611431", "Escuelas para la capacitación de ejecutivos del sector privado", Category.SUBCLASS),
        Classification("611432", "Escuelas para la capacitación de ejecutivos del sector público", Category.SUBCLASS),
        Classification("6115", "Escuelas de oficios", Category.GROUP),
        Classification("61151", "Escuelas de oficios", Category.CLASS),
        Classification("611511", "Escuelas del sector privado dedicadas a la enseñanza de oficios", Category.SUBCLASS),
        Classification("611512", "Escuelas del sector público dedicadas a la enseñanza de oficios", Category.SUBCLASS),
        Classification("6116", "Otros servicios educativos", Category.GROUP),
        Classification("61161", "Escuelas de arte", Category.CLASS),
        Classification("611611", "Escuelas de arte del sector privado", Category.SUBCLASS),
        Classification("611612", "Escuelas de arte del sector público", Category.SUBCLASS),
        Classification("61162", "Escuelas de deporte", Category.CLASS),
        Classification("611621", "Escuelas de deporte del sector privado", Category.SUBCLASS),
        Classification("611622", "Escuelas de deporte del sector público", Category.SUBCLASS),
        Classification("61163", "Escuelas de idiomas", Category.CLASS),
        Classification("611631", "Escuelas de idiomas del sector privado", Category.SUBCLASS),
        Classification("611632", "Escuelas de idiomas del sector público", Category.SUBCLASS),
        Classification("61169", "Otros servicios educativos", Category.CLASS),
        Classification("611691", "Servicios de profesores particulares", Category.SUBCLASS),
        Classification("611698", "Otros servicios educativos proporcionados por el sector privado", Category.SUBCLASS),
        Classification("611699", "Otros servicios educativos proporcionados por el sector público", Category.SUBCLASS),
        Classification("6117", "Servicios de apoyo a la educación", Category.GROUP),
        Classification("61171", "Servicios de apoyo a la educación", Category.CLASS),
        Classification("611710", "Servicios de apoyo a la educación", Category.SUBCLASS),
        Classification("62", "Servicios de salud y de asistencia social", Category.SECTION),
        Classification("621", "Servicios médicos de consulta externa y servicios relacionados", Category.DIVISION),
        Classification("6211", "Consultorios médicos", Category.GROUP),
        Classification("62111", "Consultorios médicos", Category.CLASS),
        Classification("621111", "Consultorios de medicina general del sector privado", Category.SUBCLASS),
        Classification("621112", "Consultorios de medicina general del sector público", Category.SUBCLASS),
        Classification("621113", "Consultorios de medicina especializada del sector privado", Category.SUBCLASS),
        Classification("621114", "Consultorios de medicina especializada del sector público", Category.SUBCLASS),
        Classification("621115", "Clínicas de consultorios médicos del sector privado", Category.SUBCLASS),
        Classification("621116", "Clínicas de consultorios médicos del sector público", Category.SUBCLASS),
        Classification("6212", "Consultorios dentales", Category.GROUP),
        Classification("62121", "Consultorios dentales", Category.CLASS),
        Classification("621211", "Consultorios dentales del sector privado", Category.SUBCLASS),
        Classification("621212", "Consultorios dentales del sector público", Category.SUBCLASS),
        Classification("6213", "Otros consultorios para el cuidado de la salud", Category.GROUP),
        Classification("62131", "Consultorios de quiropráctica", Category.CLASS),
        Classification("621311", "Consultorios de quiropráctica del sector privado", Category.SUBCLASS),
        Classification("621312", "Consultorios de quiropráctica del sector público", Category.SUBCLASS),
        Classification("62132", "Consultorios de optometría", Category.CLASS),
        Classification("621320", "Consultorios de optometría", Category.SUBCLASS),
        Classification("62133", "Consultorios de psicología", Category.CLASS),
        Classification("621331", "Consultorios de psicología del sector privado", Category.SUBCLASS),
        Classification("621332", "Consultorios de psicología del sector público", Category.SUBCLASS),
        Classification(
            "62134", "Consultorios de audiología y de terapia ocupacional, física y del lenguaje", Category.CLASS
        ),
        Classification(
            "621341",
            "Consultorios del sector privado de audiología y de terapia ocupacional, física y del lenguaje ",
            Category.SUBCLASS,
        ),
        Classification(
            "621342",
            "Consultorios del sector público de audiología y de terapia ocupacional, física y del lenguaje ",
            Category.SUBCLASS,
        ),
        Classification("62139", "Otros consultorios para el cuidado de la salud", Category.CLASS),
        Classification("621391", "Consultorios de nutriólogos y dietistas del sector privado", Category.SUBCLASS),
        Classification("621392", "Consultorios de nutriólogos y dietistas del sector público", Category.SUBCLASS),
        Classification(
            "621398", "Otros consultorios del sector privado para el cuidado de la salud", Category.SUBCLASS
        ),
        Classification(
            "621399", "Otros consultorios del sector público para el cuidado de la salud", Category.SUBCLASS
        ),
        Classification(
            "6214", "Centros para la atención de pacientes que no requieren hospitalización", Category.GROUP
        ),
        Classification("62141", "Centros de planificación familiar", Category.CLASS),
        Classification("621411", "Centros de planificación familiar del sector privado", Category.SUBCLASS),
        Classification("621412", "Centros de planificación familiar del sector público", Category.SUBCLASS),
        Classification("62142", "Centros de atención médica externa para enfermos mentales y adictos", Category.CLASS),
        Classification(
            "621421",
            "Centros del sector privado de atención médica externa para enfermos mentales y adictos ",
            Category.SUBCLASS,
        ),
        Classification(
            "621422",
            "Centros del sector público de atención médica externa para enfermos mentales y adictos ",
            Category.SUBCLASS,
        ),
        Classification(
            "62149", "Otros centros para la atención de pacientes que no requieren hospitalización", Category.CLASS
        ),
        Classification(
            "621491",
            "Otros centros del sector privado para la atención de pacientes que no requieren hospitalización ",
            Category.SUBCLASS,
        ),
        Classification(
            "621492",
            "Otros centros del sector público para la atención de pacientes que no requieren hospitalización ",
            Category.SUBCLASS,
        ),
        Classification("6215", "Laboratorios médicos y de diagnóstico", Category.GROUP),
        Classification("62151", "Laboratorios médicos y de diagnóstico", Category.CLASS),
        Classification("621511", "Laboratorios médicos y de diagnóstico del sector privado", Category.SUBCLASS),
        Classification("621512", "Laboratorios médicos y de diagnóstico del sector público", Category.SUBCLASS),
        Classification("6216", "Servicios de enfermería a domicilio", Category.GROUP),
        Classification("62161", "Servicios de enfermería a domicilio", Category.CLASS),
        Classification("621610", "Servicios de enfermería a domicilio", Category.SUBCLASS),
        Classification(
            "6219",
            "Servicios de ambulancias, de bancos de órganos y otros servicios auxiliares al tratamiento médico",
            Category.GROUP,
        ),
        Classification("62191", "Servicios de ambulancias", Category.CLASS),
        Classification("621910", "Servicios de ambulancias", Category.SUBCLASS),
        Classification(
            "62199",
            "Servicios de bancos de órganos, bancos de sangre y otros servicios auxiliares al tratamiento médico",
            Category.CLASS,
        ),
        Classification(
            "621991",
            "Servicios de bancos de órganos, bancos de sangre y otros servicios auxiliares al tratamiento médico prestados por el sector privado ",
            Category.SUBCLASS,
        ),
        Classification(
            "621992",
            "Servicios de bancos de órganos, bancos de sangre y otros servicios auxiliares al tratamiento médico prestados por el sector público ",
            Category.SUBCLASS,
        ),
        Classification("622", "Hospitales", Category.DIVISION),
        Classification("6221", "Hospitales generales", Category.GROUP),
        Classification("62211", "Hospitales generales", Category.CLASS),
        Classification("622111", "Hospitales generales del sector privado", Category.SUBCLASS),
        Classification("622112", "Hospitales generales del sector público", Category.SUBCLASS),
        Classification("6222", "Hospitales psiquiátricos y para el tratamiento por adicción", Category.GROUP),
        Classification("62221", "Hospitales psiquiátricos y para el tratamiento por adicción", Category.CLASS),
        Classification(
            "622211",
            "Hospitales psiquiátricos y para el tratamiento por adicción del sector privado ",
            Category.SUBCLASS,
        ),
        Classification(
            "622212",
            "Hospitales psiquiátricos y para el tratamiento por adicción del sector público ",
            Category.SUBCLASS,
        ),
        Classification("6223", "Hospitales de otras especialidades médicas", Category.GROUP),
        Classification("62231", "Hospitales de otras especialidades médicas", Category.CLASS),
        Classification("622311", "Hospitales del sector privado de otras especialidades médicas", Category.SUBCLASS),
        Classification("622312", "Hospitales del sector público de otras especialidades médicas", Category.SUBCLASS),
        Classification("623", "Residencias de asistencia social y para el cuidado de la salud", Category.DIVISION),
        Classification(
            "6231",
            "Residencias con cuidados de enfermeras para enfermos convalecientes, en rehabilitación, incurables y terminales",
            Category.GROUP,
        ),
        Classification(
            "62311",
            "Residencias con cuidados de enfermeras para enfermos convalecientes, en rehabilitación, incurables y terminales",
            Category.CLASS,
        ),
        Classification(
            "623111",
            "Residencias del sector privado con cuidados de enfermeras para enfermos convalecientes, en rehabilitación, incurables y terminales ",
            Category.SUBCLASS,
        ),
        Classification(
            "623112",
            "Residencias del sector público con cuidados de enfermeras para enfermos convalecientes, en rehabilitación, incurables y terminales ",
            Category.SUBCLASS,
        ),
        Classification(
            "6232",
            "Residencias para el cuidado de personas con problemas de retardo mental, trastorno mental y adicciones",
            Category.GROUP,
        ),
        Classification(
            "62321", "Residencias para el cuidado de personas con problemas de retardo mental", Category.CLASS
        ),
        Classification(
            "623211",
            "Residencias del sector privado para el cuidado de personas con problemas de retardo mental ",
            Category.SUBCLASS,
        ),
        Classification(
            "623212",
            "Residencias del sector público para el cuidado de personas con problemas de retardo mental ",
            Category.SUBCLASS,
        ),
        Classification(
            "62322",
            "Residencias para el cuidado de personas con problemas de trastorno mental y adicción",
            Category.CLASS,
        ),
        Classification(
            "623221",
            "Residencias del sector privado para el cuidado de personas con problemas de trastorno mental y adicción ",
            Category.SUBCLASS,
        ),
        Classification(
            "623222",
            "Residencias del sector público para el cuidado de personas con problemas de trastorno mental y adicción ",
            Category.SUBCLASS,
        ),
        Classification("6233", "Asilos y otras residencias para el cuidado de ancianos", Category.GROUP),
        Classification("62331", "Asilos y otras residencias para el cuidado de ancianos", Category.CLASS),
        Classification(
            "623311", "Asilos y otras residencias del sector privado para el cuidado de ancianos", Category.SUBCLASS
        ),
        Classification(
            "623312", "Asilos y otras residencias del sector público para el cuidado de ancianos", Category.SUBCLASS
        ),
        Classification("6239", "Orfanatos y otras residencias de asistencia social", Category.GROUP),
        Classification("62399", "Orfanatos y otras residencias de asistencia social", Category.CLASS),
        Classification(
            "623991", "Orfanatos y otras residencias de asistencia social del sector privado", Category.SUBCLASS
        ),
        Classification(
            "623992", "Orfanatos y otras residencias de asistencia social del sector público", Category.SUBCLASS
        ),
        Classification("624", "Otros servicios de asistencia social", Category.DIVISION),
        Classification("6241", "Servicios de orientación y trabajo social", Category.GROUP),
        Classification(
            "62411", "Servicios de orientación y trabajo social para la niñez y la juventud", Category.CLASS
        ),
        Classification(
            "624111",
            "Servicios de orientación y trabajo social para la niñez y la juventud prestados por el sector privado ",
            Category.SUBCLASS,
        ),
        Classification(
            "624112",
            "Servicios de orientación y trabajo social para la niñez y la juventud prestados por el sector público ",
            Category.SUBCLASS,
        ),
        Classification(
            "62412", "Centros de atención y cuidado diurno de ancianos y personas con discapacidad", Category.CLASS
        ),
        Classification(
            "624121",
            "Centros del sector privado dedicados a la atención y cuidado diurno de ancianos y personas con discapacidad ",
            Category.SUBCLASS,
        ),
        Classification(
            "624122",
            "Centros del sector público dedicados a la atención y cuidado diurno de ancianos y personas con discapacidad ",
            Category.SUBCLASS,
        ),
        Classification("62419", "Otros servicios de orientación y trabajo social", Category.CLASS),
        Classification(
            "624191", "Agrupaciones de autoayuda para alcohólicos y personas con otras adicciones", Category.SUBCLASS
        ),
        Classification(
            "624198",
            "Otros servicios de orientación y trabajo social prestados por el sector privado ",
            Category.SUBCLASS,
        ),
        Classification(
            "624199",
            "Otros servicios de orientación y trabajo social prestados por el sector público ",
            Category.SUBCLASS,
        ),
        Classification("6242", "Servicios comunitarios de alimentación, refugio y emergencia", Category.GROUP),
        Classification("62421", "Servicios de alimentación comunitarios", Category.CLASS),
        Classification(
            "624211", "Servicios de alimentación comunitarios prestados por el sector privado", Category.SUBCLASS
        ),
        Classification(
            "624212", "Servicios de alimentación comunitarios prestados por el sector público", Category.SUBCLASS
        ),
        Classification("62422", "Refugios temporales comunitarios", Category.CLASS),
        Classification("624221", "Refugios temporales comunitarios del sector privado", Category.SUBCLASS),
        Classification("624222", "Refugios temporales comunitarios del sector público", Category.SUBCLASS),
        Classification("62423", "Servicios de emergencia comunitarios", Category.CLASS),
        Classification(
            "624231", "Servicios de emergencia comunitarios prestados por el sector privado", Category.SUBCLASS
        ),
        Classification(
            "624232", "Servicios de emergencia comunitarios prestados por el sector público", Category.SUBCLASS
        ),
        Classification(
            "6243",
            "Servicios de capacitación para el trabajo para personas desempleadas, subempleadas o con discapacidad",
            Category.GROUP,
        ),
        Classification(
            "62431",
            "Servicios de capacitación para el trabajo para personas desempleadas, subempleadas o con discapacidad",
            Category.CLASS,
        ),
        Classification(
            "624311",
            "Servicios de capacitación para el trabajo prestados por el sector privado para personas desempleadas, subempleadas o con discapacidad ",
            Category.SUBCLASS,
        ),
        Classification(
            "624312",
            "Servicios de capacitación para el trabajo prestados por el sector público para personas desempleadas, subempleadas o con discapacidad ",
            Category.SUBCLASS,
        ),
        Classification("6244", "Guarderías", Category.GROUP),
        Classification("62441", "Guarderías", Category.CLASS),
        Classification("624411", "Guarderías del sector privado", Category.SUBCLASS),
        Classification("624412", "Guarderías del sector público", Category.SUBCLASS),
        Classification(
            "71", "Servicios de esparcimiento culturales y deportivos, y otros servicios recreativos", Category.SECTION
        ),
        Classification(
            "711", "Servicios artísticos, culturales y deportivos, y otros servicios relacionados", Category.DIVISION
        ),
        Classification("7111", "Compañías y grupos de espectáculos artísticos y culturales", Category.GROUP),
        Classification("71111", "Compañías de teatro", Category.CLASS),
        Classification("711111", "Compañías de teatro del sector privado", Category.SUBCLASS),
        Classification("711112", "Compañías de teatro del sector público", Category.SUBCLASS),
        Classification("71112", "Compañías de danza", Category.CLASS),
        Classification("711121", "Compañías de danza del sector privado", Category.SUBCLASS),
        Classification("711122", "Compañías de danza del sector público", Category.SUBCLASS),
        Classification("71113", "Cantantes y grupos musicales", Category.CLASS),
        Classification("711131", "Cantantes y grupos musicales del sector privado", Category.SUBCLASS),
        Classification("711132", "Grupos musicales del sector público", Category.SUBCLASS),
        Classification("71119", "Otras compañías y grupos de espectáculos artísticos", Category.CLASS),
        Classification(
            "711191", "Otras compañías y grupos de espectáculos artísticos del sector privado", Category.SUBCLASS
        ),
        Classification(
            "711192", "Otras compañías y grupos de espectáculos artísticos del sector público", Category.SUBCLASS
        ),
        Classification("7112", "Deportistas y equipos deportivos profesionales", Category.GROUP),
        Classification("71121", "Deportistas y equipos deportivos profesionales", Category.CLASS),
        Classification("711211", "Deportistas profesionales", Category.SUBCLASS),
        Classification("711212", "Equipos deportivos profesionales", Category.SUBCLASS),
        Classification(
            "7113", "Promotores de espectáculos artísticos, culturales, deportivos y similares", Category.GROUP
        ),
        Classification(
            "71131",
            "Promotores de espectáculos artísticos, culturales, deportivos y similares que cuentan con instalaciones para presentarlos",
            Category.CLASS,
        ),
        Classification(
            "711311",
            "Promotores del sector privado de espectáculos artísticos, culturales, deportivos y similares que cuentan con instalaciones para presentarlos ",
            Category.SUBCLASS,
        ),
        Classification(
            "711312",
            "Promotores del sector público de espectáculos artísticos, culturales, deportivos y similares que cuentan con instalaciones para presentarlos ",
            Category.SUBCLASS,
        ),
        Classification(
            "71132",
            "Promotores de espectáculos artísticos, culturales, deportivos y similares que no cuentan con instalaciones para presentarlos",
            Category.CLASS,
        ),
        Classification(
            "711320",
            "Promotores de espectáculos artísticos, culturales, deportivos y similares que no cuentan con instalaciones para presentarlos ",
            Category.SUBCLASS,
        ),
        Classification("7114", "Agentes y representantes de artistas, deportistas y similares", Category.GROUP),
        Classification("71141", "Agentes y representantes de artistas, deportistas y similares", Category.CLASS),
        Classification("711410", "Agentes y representantes de artistas, deportistas y similares", Category.SUBCLASS),
        Classification("7115", "Artistas, escritores y técnicos independientes", Category.GROUP),
        Classification("71151", "Artistas, escritores y técnicos independientes", Category.CLASS),
        Classification("711510", "Artistas, escritores y técnicos independientes", Category.SUBCLASS),
        Classification("712", "Museos, sitios históricos, zoológicos y similares", Category.DIVISION),
        Classification("7121", "Museos, sitios históricos, zoológicos y similares", Category.GROUP),
        Classification("71211", "Museos", Category.CLASS),
        Classification("712111", "Museos del sector privado", Category.SUBCLASS),
        Classification("712112", "Museos del sector público", Category.SUBCLASS),
        Classification("71212", "Sitios históricos", Category.CLASS),
        Classification("712120", "Sitios históricos", Category.SUBCLASS),
        Classification("71213", "Jardines botánicos y zoológicos", Category.CLASS),
        Classification("712131", "Jardines botánicos y zoológicos del sector privado", Category.SUBCLASS),
        Classification("712132", "Jardines botánicos y zoológicos del sector público", Category.SUBCLASS),
        Classification(
            "71219", "Grutas, parques naturales y otros sitios del patrimonio cultural de la nación", Category.CLASS
        ),
        Classification(
            "712190",
            "Grutas, parques naturales y otros sitios del patrimonio cultural de la nación ",
            Category.SUBCLASS,
        ),
        Classification(
            "713",
            "Servicios de entretenimiento en instalaciones recreativas y otros servicios recreativos",
            Category.DIVISION,
        ),
        Classification("7131", "Parques con instalaciones recreativas y casas de juegos electrónicos", Category.GROUP),
        Classification("71311", "Parques con instalaciones recreativas", Category.CLASS),
        Classification("713111", "Parques de diversiones y temáticos del sector privado", Category.SUBCLASS),
        Classification("713112", "Parques de diversiones y temáticos del sector público", Category.SUBCLASS),
        Classification("713113", "Parques acuáticos y balnearios del sector privado", Category.SUBCLASS),
        Classification("713114", "Parques acuáticos y balnearios del sector público", Category.SUBCLASS),
        Classification("71312", "Casas de juegos electrónicos", Category.CLASS),
        Classification("713120", "Casas de juegos electrónicos", Category.SUBCLASS),
        Classification("7132", "Casinos, loterías y otros juegos de azar", Category.GROUP),
        Classification("71321", "Casinos", Category.CLASS),
        Classification("713210", "Casinos", Category.SUBCLASS),
        Classification("71329", "Loterías y otros juegos de azar", Category.CLASS),
        Classification(
            "713291",
            "Venta de billetes de lotería, pronósticos deportivos y otros boletos de sorteo ",
            Category.SUBCLASS,
        ),
        Classification("713299", "Otros juegos de azar", Category.SUBCLASS),
        Classification("7139", "Otros servicios recreativos", Category.GROUP),
        Classification("71391", "Campos de golf", Category.CLASS),
        Classification("713910", "Campos de golf", Category.SUBCLASS),
        Classification("71392", "Pistas para esquiar", Category.CLASS),
        Classification("713920", "Pistas para esquiar", Category.SUBCLASS),
        Classification("71393", "Marinas turísticas", Category.CLASS),
        Classification("713930", "Marinas turísticas", Category.SUBCLASS),
        Classification("71394", "Clubes deportivos y centros de acondicionamiento físico", Category.CLASS),
        Classification("713941", "Clubes deportivos del sector privado", Category.SUBCLASS),
        Classification("713942", "Clubes deportivos del sector público", Category.SUBCLASS),
        Classification("713943", "Centros de acondicionamiento físico del sector privado", Category.SUBCLASS),
        Classification("713944", "Centros de acondicionamiento físico del sector público", Category.SUBCLASS),
        Classification("71395", "Boliches", Category.CLASS),
        Classification("713950", "Boliches", Category.SUBCLASS),
        Classification("71399", "Otros servicios recreativos", Category.CLASS),
        Classification("713991", "Billares", Category.SUBCLASS),
        Classification("713992", "Clubes o ligas de aficionados", Category.SUBCLASS),
        Classification("713998", "Otros servicios recreativos prestados por el sector privado", Category.SUBCLASS),
        Classification("713999", "Otros servicios recreativos prestados por el sector público", Category.SUBCLASS),
        Classification(
            "72", "Servicios de alojamiento temporal y de preparación de alimentos y bebidas", Category.SECTION
        ),
        Classification("721", "Servicios de alojamiento temporal", Category.DIVISION),
        Classification("7211", "Hoteles, moteles y similares", Category.GROUP),
        Classification("72111", "Hoteles y moteles, excepto hoteles con casino", Category.CLASS),
        Classification("721111", "Hoteles con otros servicios integrados", Category.SUBCLASS),
        Classification("721112", "Hoteles sin otros servicios integrados", Category.SUBCLASS),
        Classification("721113", "Moteles", Category.SUBCLASS),
        Classification("72112", "Hoteles con casino", Category.CLASS),
        Classification("721120", "Hoteles con casino", Category.SUBCLASS),
        Classification("72119", "Cabañas, villas y similares", Category.CLASS),
        Classification("721190", "Cabañas, villas y similares", Category.SUBCLASS),
        Classification("7212", "Campamentos y albergues recreativos", Category.GROUP),
        Classification("72121", "Campamentos y albergues recreativos", Category.CLASS),
        Classification("721210", "Campamentos y albergues recreativos", Category.SUBCLASS),
        Classification(
            "7213",
            "Pensiones y casas de huéspedes, y departamentos y casas amueblados con servicios de hotelería",
            Category.GROUP,
        ),
        Classification(
            "72131",
            "Pensiones y casas de huéspedes, y departamentos y casas amueblados con servicios de hotelería",
            Category.CLASS,
        ),
        Classification("721311", "Pensiones y casas de huéspedes", Category.SUBCLASS),
        Classification("721312", "Departamentos y casas amueblados con servicios de hotelería", Category.SUBCLASS),
        Classification("722", "Servicios de preparación de alimentos y bebidas", Category.DIVISION),
        Classification("7223", "Servicios de preparación de alimentos por encargo", Category.GROUP),
        Classification("72231", "Servicios de comedor para empresas e instituciones", Category.CLASS),
        Classification("722310", "Servicios de comedor para empresas e instituciones", Category.SUBCLASS),
        Classification("72232", "Servicios de preparación de alimentos para ocasiones especiales", Category.CLASS),
        Classification("722320", "Servicios de preparación de alimentos para ocasiones especiales", Category.SUBCLASS),
        Classification("72233", "Servicios de preparación de alimentos en unidades móviles", Category.CLASS),
        Classification("722330", "Servicios de preparación de alimentos en unidades móviles", Category.SUBCLASS),
        Classification("7224", "Centros nocturnos, bares, cantinas y similares", Category.GROUP),
        Classification("72241", "Centros nocturnos, bares, cantinas y similares", Category.CLASS),
        Classification("722411", "Centros nocturnos, discotecas y similares", Category.SUBCLASS),
        Classification("722412", "Bares, cantinas y similares", Category.SUBCLASS),
        Classification(
            "7225", "Servicios de preparación de alimentos y bebidas alcohólicas y no alcohólicas", Category.GROUP
        ),
        Classification(
            "72251", "Servicios de preparación de alimentos y bebidas alcohólicas y no alcohólicas", Category.CLASS
        ),
        Classification(
            "722511",
            "Restaurantes con servicio de preparación de alimentos a la carta o de comida corrida ",
            Category.SUBCLASS,
        ),
        Classification("722512", "Restaurantes con servicio de preparación de pescados y mariscos", Category.SUBCLASS),
        Classification("722513", "Restaurantes con servicio de preparación de antojitos", Category.SUBCLASS),
        Classification("722514", "Restaurantes con servicio de preparación de tacos y tortas", Category.SUBCLASS),
        Classification(
            "722515", "Cafeterías, fuentes de sodas, neverías, refresquerías y similares", Category.SUBCLASS
        ),
        Classification("722516", "Restaurantes de autoservicio", Category.SUBCLASS),
        Classification(
            "722517",
            "Restaurantes con servicio de preparación de pizzas, hamburguesas, hodogs y pollos rostizados para llevar ",
            Category.SUBCLASS,
        ),
        Classification("722518", "Restaurantes que preparan otro tipo de alimentos para llevar", Category.SUBCLASS),
        Classification(
            "722519", "Servicios de preparación de otros alimentos para consumo inmediato", Category.SUBCLASS
        ),
        Classification("81", "Otros servicios excepto actividades gubernamentales", Category.SECTION),
        Classification("811", "Servicios de reparación y mantenimiento", Category.DIVISION),
        Classification("8111", "Reparación y mantenimiento de automóviles y camiones", Category.GROUP),
        Classification("81111", "Reparación mecánica y eléctrica de automóviles y camiones", Category.CLASS),
        Classification("811111", "Reparación mecánica en general de automóviles y camiones", Category.SUBCLASS),
        Classification("811112", "Reparación del sistema eléctrico de automóviles y camiones", Category.SUBCLASS),
        Classification("811113", "Rectificación de partes de motor de automóviles y camiones", Category.SUBCLASS),
        Classification("811114", "Reparación de transmisiones de automóviles y camiones", Category.SUBCLASS),
        Classification("811115", "Reparación de suspensiones de automóviles y camiones", Category.SUBCLASS),
        Classification("811116", "Alineación y balanceo de automóviles y camiones", Category.SUBCLASS),
        Classification("811119", "Otras reparaciones mecánicas de automóviles y camiones", Category.SUBCLASS),
        Classification(
            "81112",
            "Hojalatería, tapicería y otras reparaciones a la carrocería de automóviles y camiones",
            Category.CLASS,
        ),
        Classification("811121", "Hojalatería y pintura de automóviles y camiones", Category.SUBCLASS),
        Classification("811122", "Tapicería de automóviles y camiones", Category.SUBCLASS),
        Classification("811123", "Servicios de blindaje y de adaptación de automóviles y camiones", Category.SUBCLASS),
        Classification(
            "811129",
            "Instalación de cristales y otras reparaciones a la carrocería de automóviles y camiones ",
            Category.SUBCLASS,
        ),
        Classification(
            "81119", "Otros servicios de reparación y mantenimiento de automóviles y camiones", Category.CLASS
        ),
        Classification("811191", "Reparación menor de llantas", Category.SUBCLASS),
        Classification("811192", "Lavado y lubricado de automóviles y camiones", Category.SUBCLASS),
        Classification(
            "811199", "Otros servicios de reparación y mantenimiento de automóviles y camiones", Category.SUBCLASS
        ),
        Classification(
            "8112", "Reparación y mantenimiento de equipo electrónico y de equipo de precisión", Category.GROUP
        ),
        Classification(
            "81121", "Reparación y mantenimiento de equipo electrónico y de equipo de precisión", Category.CLASS
        ),
        Classification(
            "811211", "Reparación y mantenimiento de equipo electrónico de uso doméstico", Category.SUBCLASS
        ),
        Classification(
            "811219",
            "Reparación y mantenimiento de otro equipo electrónico y de equipo de precisión ",
            Category.SUBCLASS,
        ),
        Classification(
            "8113",
            "Reparación y mantenimiento de maquinaria y equipo agropecuario, industrial, comercial y de servicios",
            Category.GROUP,
        ),
        Classification(
            "81131",
            "Reparación y mantenimiento de maquinaria y equipo agropecuario, industrial, comercial y de servicios",
            Category.CLASS,
        ),
        Classification(
            "811311", "Reparación y mantenimiento de maquinaria y equipo agropecuario y forestal", Category.SUBCLASS
        ),
        Classification("811312", "Reparación y mantenimiento de maquinaria y equipo industrial", Category.SUBCLASS),
        Classification(
            "811313",
            "Reparación y mantenimiento de maquinaria y equipo para mover, levantar y acomodar materiales ",
            Category.SUBCLASS,
        ),
        Classification(
            "811314", "Reparación y mantenimiento de maquinaria y equipo comercial y de servicios", Category.SUBCLASS
        ),
        Classification("8114", "Reparación y mantenimiento de artículos para el hogar y personales", Category.GROUP),
        Classification(
            "81141", "Reparación y mantenimiento de aparatos eléctricos para el hogar y personales", Category.CLASS
        ),
        Classification(
            "811410", "Reparación y mantenimiento de aparatos eléctricos para el hogar y personales", Category.SUBCLASS
        ),
        Classification("81142", "Reparación de tapicería de muebles para el hogar", Category.CLASS),
        Classification("811420", "Reparación de tapicería de muebles para el hogar", Category.SUBCLASS),
        Classification("81143", "Reparación de calzado y otros artículos de piel y cuero", Category.CLASS),
        Classification("811430", "Reparación de calzado y otros artículos de piel y cuero", Category.SUBCLASS),
        Classification(
            "81149", "Reparación y mantenimiento de otros artículos para el hogar y personales", Category.CLASS
        ),
        Classification("811491", "Cerrajerías", Category.SUBCLASS),
        Classification("811492", "Reparación y mantenimiento de motocicletas", Category.SUBCLASS),
        Classification("811493", "Reparación y mantenimiento de bicicletas", Category.SUBCLASS),
        Classification(
            "811499", "Reparación y mantenimiento de otros artículos para el hogar y personales", Category.SUBCLASS
        ),
        Classification("812", "Servicios personales", Category.DIVISION),
        Classification("8121", "Salones y clínicas de belleza, baños públicos y bolerías", Category.GROUP),
        Classification("81211", "Salones y clínicas de belleza y peluquerías", Category.CLASS),
        Classification("812110", "Salones y clínicas de belleza y peluquerías", Category.SUBCLASS),
        Classification("81212", "Baños públicos", Category.CLASS),
        Classification("812120", "Baños públicos", Category.SUBCLASS),
        Classification("81213", "Sanitarios públicos y bolerías", Category.CLASS),
        Classification("812130", "Sanitarios públicos y bolerías", Category.SUBCLASS),
        Classification("8122", "Lavanderías y tintorerías", Category.GROUP),
        Classification("81221", "Lavanderías y tintorerías", Category.CLASS),
        Classification("812210", "Lavanderías y tintorerías", Category.SUBCLASS),
        Classification("8123", "Servicios funerarios y administración de cementerios", Category.GROUP),
        Classification("81231", "Servicios funerarios", Category.CLASS),
        Classification("812310", "Servicios funerarios", Category.SUBCLASS),
        Classification("81232", "Administración de cementerios", Category.CLASS),
        Classification("812321", "Administración de cementerios pertenecientes al sector privado", Category.SUBCLASS),
        Classification("812322", "Administración de cementerios pertenecientes al sector público", Category.SUBCLASS),
        Classification("8124", "Estacionamientos y pensiones para vehículos automotores", Category.GROUP),
        Classification("81241", "Estacionamientos y pensiones para vehículos automotores", Category.CLASS),
        Classification("812410", "Estacionamientos y pensiones para vehículos automotores", Category.SUBCLASS),
        Classification(
            "8129", "Servicios de revelado e impresión de fotografías y otros servicios personales", Category.GROUP
        ),
        Classification("81291", "Servicios de revelado e impresión de fotografías", Category.CLASS),
        Classification("812910", "Servicios de revelado e impresión de fotografías", Category.SUBCLASS),
        Classification("81299", "Otros servicios personales", Category.CLASS),
        Classification("812990", "Otros servicios personales", Category.SUBCLASS),
        Classification("813", "Asociaciones y organizaciones", Category.DIVISION),
        Classification(
            "8131", "Asociaciones y organizaciones comerciales, laborales, profesionales y recreativas", Category.GROUP
        ),
        Classification(
            "81311",
            "Asociaciones, organizaciones y cámaras de productores, comerciantes y prestadores de servicios ",
            Category.CLASS,
        ),
        Classification(
            "813110",
            "Asociaciones, organizaciones y cámaras de productores, comerciantes y prestadores de servicios ",
            Category.SUBCLASS,
        ),
        Classification("81312", "Asociaciones y organizaciones laborales y sindicales", Category.CLASS),
        Classification("813120", "Asociaciones y organizaciones laborales y sindicales", Category.SUBCLASS),
        Classification("81313", "Asociaciones y organizaciones de profesionistas", Category.CLASS),
        Classification("813130", "Asociaciones y organizaciones de profesionistas", Category.SUBCLASS),
        Classification("81314", "Asociaciones regulatorias de actividades recreativas", Category.CLASS),
        Classification("813140", "Asociaciones regulatorias de actividades recreativas", Category.SUBCLASS),
        Classification("8132", "Asociaciones y organizaciones religiosas, políticas y civiles", Category.GROUP),
        Classification("81321", "Asociaciones y organizaciones religiosas", Category.CLASS),
        Classification("813210", "Asociaciones y organizaciones religiosas", Category.SUBCLASS),
        Classification("81322", "Asociaciones y organizaciones políticas", Category.CLASS),
        Classification("813220", "Asociaciones y organizaciones políticas", Category.SUBCLASS),
        Classification("81323", "Asociaciones y organizaciones civiles", Category.CLASS),
        Classification("813230", "Asociaciones y organizaciones civiles", Category.SUBCLASS),
        Classification("814", "Hogares con empleados domésticos", Category.DIVISION),
        Classification("8141", "Hogares con empleados domésticos", Category.GROUP),
        Classification("81411", "Hogares con empleados domésticos", Category.CLASS),
        Classification("814110", "Hogares con empleados domésticos", Category.SUBCLASS),
        Classification(
            "93",
            "Actividades legislativas, gubernamentales, de impartición de justicia y de organismos internacionales y extraterritoriales",
            Category.SECTION,
        ),
        Classification(
            "931", "Actividades legislativas, gubernamentales y de impartición de justicia", Category.DIVISION
        ),
        Classification("9311", "Órganos legislativos", Category.GROUP),
        Classification("93111", "Órganos legislativos", Category.CLASS),
        Classification("931110", "Órganos legislativos", Category.SUBCLASS),
        Classification("9312", "Administración pública en general", Category.GROUP),
        Classification("93121", "Administración pública en general", Category.CLASS),
        Classification("931210", "Administración pública en general", Category.SUBCLASS),
        Classification("9313", "Regulación y fomento del desarrollo económico", Category.GROUP),
        Classification("93131", "Regulación y fomento del desarrollo económico", Category.CLASS),
        Classification("931310", "Regulación y fomento del desarrollo económico", Category.SUBCLASS),
        Classification(
            "9314", "Impartición de justicia y mantenimiento de la seguridad y el orden público", Category.GROUP
        ),
        Classification(
            "93141", "Impartición de justicia y mantenimiento de la seguridad y el orden público", Category.CLASS
        ),
        Classification(
            "931410", "Impartición de justicia y mantenimiento de la seguridad y el orden público", Category.SUBCLASS
        ),
        Classification(
            "9315", "Regulación y fomento de actividades para mejorar y preservar el medio ambiente", Category.GROUP
        ),
        Classification(
            "93151", "Regulación y fomento de actividades para mejorar y preservar el medio ambiente", Category.CLASS
        ),
        Classification(
            "931510",
            "Regulación y fomento de actividades para mejorar y preservar el medio ambiente ",
            Category.SUBCLASS,
        ),
        Classification("9316", "Actividades administrativas de instituciones de bienestar social", Category.GROUP),
        Classification("93161", "Actividades administrativas de instituciones de bienestar social", Category.CLASS),
        Classification("931610", "Actividades administrativas de instituciones de bienestar social", Category.SUBCLASS),
        Classification("9317", "Relaciones exteriores", Category.GROUP),
        Classification("93171", "Relaciones exteriores", Category.CLASS),
        Classification("931710", "Relaciones exteriores", Category.SUBCLASS),
        Classification("9318", "Actividades de seguridad nacional", Category.GROUP),
        Classification("93181", "Actividades de seguridad nacional", Category.CLASS),
        Classification("931810", "Actividades de seguridad nacional", Category.SUBCLASS),
        Classification("932", "Organismos internacionales y extraterritoriales", Category.DIVISION),
        Classification("9321", "Organismos internacionales y extraterritoriales", Category.GROUP),
        Classification("93211", "Organismos internacionales", Category.CLASS),
        Classification("932110", "Organismos internacionales", Category.SUBCLASS),
        Classification("93212", "Sedes diplomáticas y otras unidades extraterritoriales", Category.CLASS),
        Classification("932120", "Sedes diplomáticas y otras unidades extraterritoriales", Category.SUBCLASS),
    ],
)
