# -*- coding: utf-8 -*-
"""`Concordance between SBI2008 and NACE2, "The first four digits of the SBI are the four digits of NACE..." <https://www.cbs.nl/en-gb/onze-diensten/methods/classifications/activiteiten/standard-industrial-classifications--dutch-sbi-2008-nace-and-isic-->`_.
"""
from ...types import Concordance, Standards
from ..nace2 import NACE2
from . import SBI2008

SBI2008_to_NACE2 = Concordance(
    src=SBI2008,
    dst=NACE2,
    concordances=[
        ((Standards.SBI2008, "1411"), (Standards.NACE2, "14.11")),
        ((Standards.SBI2008, "1412"), (Standards.NACE2, "14.12")),
        ((Standards.SBI2008, "1011"), (Standards.NACE2, "10.11")),
        ((Standards.SBI2008, "1012"), (Standards.NACE2, "10.12")),
        ((Standards.SBI2008, "1013"), (Standards.NACE2, "10.13")),
        ((Standards.SBI2008, "1020"), (Standards.NACE2, "10.20")),
        ((Standards.SBI2008, "1031"), (Standards.NACE2, "10.31")),
        ((Standards.SBI2008, "1032"), (Standards.NACE2, "10.32")),
        ((Standards.SBI2008, "1039"), (Standards.NACE2, "10.39")),
        ((Standards.SBI2008, "1041"), (Standards.NACE2, "10.41")),
        ((Standards.SBI2008, "1042"), (Standards.NACE2, "10.42")),
        ((Standards.SBI2008, "1051"), (Standards.NACE2, "10.51")),
        ((Standards.SBI2008, "1052"), (Standards.NACE2, "10.52")),
        ((Standards.SBI2008, "1061"), (Standards.NACE2, "10.61")),
        ((Standards.SBI2008, "1062"), (Standards.NACE2, "10.62")),
        ((Standards.SBI2008, "1071"), (Standards.NACE2, "10.71")),
        ((Standards.SBI2008, "1072"), (Standards.NACE2, "10.72")),
        ((Standards.SBI2008, "1073"), (Standards.NACE2, "10.73")),
        ((Standards.SBI2008, "1081"), (Standards.NACE2, "10.81")),
        ((Standards.SBI2008, "10821"), (Standards.NACE2, "10.82")),
        ((Standards.SBI2008, "10822"), (Standards.NACE2, "10.82")),
        ((Standards.SBI2008, "1083"), (Standards.NACE2, "10.83")),
        ((Standards.SBI2008, "1084"), (Standards.NACE2, "10.84")),
        ((Standards.SBI2008, "1085"), (Standards.NACE2, "10.85")),
        ((Standards.SBI2008, "1086"), (Standards.NACE2, "10.86")),
        ((Standards.SBI2008, "1089"), (Standards.NACE2, "10.89")),
        ((Standards.SBI2008, "1091"), (Standards.NACE2, "10.91")),
        ((Standards.SBI2008, "1092"), (Standards.NACE2, "10.92")),
        ((Standards.SBI2008, "1101"), (Standards.NACE2, "11.01")),
        ((Standards.SBI2008, "1102"), (Standards.NACE2, "11.02")),
        ((Standards.SBI2008, "1103"), (Standards.NACE2, "11.03")),
        ((Standards.SBI2008, "1104"), (Standards.NACE2, "11.04")),
        ((Standards.SBI2008, "1105"), (Standards.NACE2, "11.05")),
        ((Standards.SBI2008, "1106"), (Standards.NACE2, "11.06")),
        ((Standards.SBI2008, "1107"), (Standards.NACE2, "11.07")),
        ((Standards.SBI2008, "1200"), (Standards.NACE2, "12.00")),
        ((Standards.SBI2008, "1310"), (Standards.NACE2, "13.10")),
        ((Standards.SBI2008, "1320"), (Standards.NACE2, "13.20")),
        ((Standards.SBI2008, "1330"), (Standards.NACE2, "13.30")),
        ((Standards.SBI2008, "1391"), (Standards.NACE2, "13.91")),
        ((Standards.SBI2008, "1392"), (Standards.NACE2, "13.92")),
        ((Standards.SBI2008, "1393"), (Standards.NACE2, "13.93")),
        ((Standards.SBI2008, "1394"), (Standards.NACE2, "13.94")),
        ((Standards.SBI2008, "1395"), (Standards.NACE2, "13.95")),
        ((Standards.SBI2008, "1396"), (Standards.NACE2, "13.96")),
        ((Standards.SBI2008, "1399"), (Standards.NACE2, "13.99")),
        ((Standards.SBI2008, "1411"), (Standards.NACE2, "14.11")),
        ((Standards.SBI2008, "1412"), (Standards.NACE2, "14.12")),
        ((Standards.SBI2008, "1413"), (Standards.NACE2, "14.13")),
        ((Standards.SBI2008, "1414"), (Standards.NACE2, "14.14")),
        ((Standards.SBI2008, "1419"), (Standards.NACE2, "14.19")),
        ((Standards.SBI2008, "1420"), (Standards.NACE2, "14.20")),
        ((Standards.SBI2008, "1431"), (Standards.NACE2, "14.31")),
        ((Standards.SBI2008, "1439"), (Standards.NACE2, "14.39")),
        ((Standards.SBI2008, "1511"), (Standards.NACE2, "15.11")),
        ((Standards.SBI2008, "1512"), (Standards.NACE2, "15.12")),
        ((Standards.SBI2008, "1520"), (Standards.NACE2, "15.20")),
        ((Standards.SBI2008, "16101"), (Standards.NACE2, "16.10")),
        ((Standards.SBI2008, "16102"), (Standards.NACE2, "16.10")),
        ((Standards.SBI2008, "1621"), (Standards.NACE2, "16.21")),
        ((Standards.SBI2008, "1622"), (Standards.NACE2, "16.22")),
        ((Standards.SBI2008, "16231"), (Standards.NACE2, "16.23")),
        ((Standards.SBI2008, "16239"), (Standards.NACE2, "16.23")),
        ((Standards.SBI2008, "1624"), (Standards.NACE2, "16.24")),
        ((Standards.SBI2008, "1629"), (Standards.NACE2, "16.29")),
        ((Standards.SBI2008, "1711"), (Standards.NACE2, "17.11")),
        ((Standards.SBI2008, "17121"), (Standards.NACE2, "17.12")),
        ((Standards.SBI2008, "17122"), (Standards.NACE2, "17.12")),
        ((Standards.SBI2008, "17129"), (Standards.NACE2, "17.12")),
        ((Standards.SBI2008, "17211"), (Standards.NACE2, "17.21")),
        ((Standards.SBI2008, "17212"), (Standards.NACE2, "17.21")),
        ((Standards.SBI2008, "1722"), (Standards.NACE2, "17.22")),
        ((Standards.SBI2008, "1723"), (Standards.NACE2, "17.23")),
        ((Standards.SBI2008, "1724"), (Standards.NACE2, "17.24")),
        ((Standards.SBI2008, "1729"), (Standards.NACE2, "17.29")),
        ((Standards.SBI2008, "1811"), (Standards.NACE2, "18.11")),
        ((Standards.SBI2008, "18121"), (Standards.NACE2, "18.12")),
        ((Standards.SBI2008, "18122"), (Standards.NACE2, "18.12")),
        ((Standards.SBI2008, "18123"), (Standards.NACE2, "18.12")),
        ((Standards.SBI2008, "18124"), (Standards.NACE2, "18.12")),
        ((Standards.SBI2008, "18125"), (Standards.NACE2, "18.12")),
        ((Standards.SBI2008, "18129"), (Standards.NACE2, "18.12")),
        ((Standards.SBI2008, "1813"), (Standards.NACE2, "18.13")),
        ((Standards.SBI2008, "1814"), (Standards.NACE2, "18.14")),
        ((Standards.SBI2008, "1820"), (Standards.NACE2, "18.20")),
        ((Standards.SBI2008, "1910"), (Standards.NACE2, "19.10")),
        ((Standards.SBI2008, "19201"), (Standards.NACE2, "19.20")),
        ((Standards.SBI2008, "19202"), (Standards.NACE2, "19.20")),
        ((Standards.SBI2008, "2011"), (Standards.NACE2, "20.11")),
        ((Standards.SBI2008, "2012"), (Standards.NACE2, "20.12")),
        ((Standards.SBI2008, "2013"), (Standards.NACE2, "20.13")),
        ((Standards.SBI2008, "20141"), (Standards.NACE2, "20.14")),
        ((Standards.SBI2008, "20149"), (Standards.NACE2, "20.14")),
        ((Standards.SBI2008, "2015"), (Standards.NACE2, "20.15")),
        ((Standards.SBI2008, "2016"), (Standards.NACE2, "20.16")),
        ((Standards.SBI2008, "2017"), (Standards.NACE2, "20.17")),
        ((Standards.SBI2008, "2020"), (Standards.NACE2, "20.20")),
        ((Standards.SBI2008, "2030"), (Standards.NACE2, "20.30")),
        ((Standards.SBI2008, "2041"), (Standards.NACE2, "20.41")),
        ((Standards.SBI2008, "2042"), (Standards.NACE2, "20.42")),
        ((Standards.SBI2008, "2051"), (Standards.NACE2, "20.51")),
        ((Standards.SBI2008, "2052"), (Standards.NACE2, "20.52")),
        ((Standards.SBI2008, "2053"), (Standards.NACE2, "20.53")),
        ((Standards.SBI2008, "2059"), (Standards.NACE2, "20.59")),
        ((Standards.SBI2008, "2060"), (Standards.NACE2, "20.60")),
        ((Standards.SBI2008, "2110"), (Standards.NACE2, "21.10")),
        ((Standards.SBI2008, "2120"), (Standards.NACE2, "21.20")),
        ((Standards.SBI2008, "2211"), (Standards.NACE2, "22.11")),
        ((Standards.SBI2008, "2219"), (Standards.NACE2, "22.19")),
        ((Standards.SBI2008, "2221"), (Standards.NACE2, "22.21")),
        ((Standards.SBI2008, "2222"), (Standards.NACE2, "22.22")),
        ((Standards.SBI2008, "2223"), (Standards.NACE2, "22.23")),
        ((Standards.SBI2008, "2229"), (Standards.NACE2, "22.29")),
        ((Standards.SBI2008, "2311"), (Standards.NACE2, "23.11")),
        ((Standards.SBI2008, "2312"), (Standards.NACE2, "23.12")),
        ((Standards.SBI2008, "2313"), (Standards.NACE2, "23.13")),
        ((Standards.SBI2008, "2314"), (Standards.NACE2, "23.14")),
        ((Standards.SBI2008, "2319"), (Standards.NACE2, "23.19")),
        ((Standards.SBI2008, "2320"), (Standards.NACE2, "23.20")),
        ((Standards.SBI2008, "2331"), (Standards.NACE2, "23.31")),
        ((Standards.SBI2008, "2332"), (Standards.NACE2, "23.32")),
        ((Standards.SBI2008, "2341"), (Standards.NACE2, "23.41")),
        ((Standards.SBI2008, "2342"), (Standards.NACE2, "23.42")),
        ((Standards.SBI2008, "2343"), (Standards.NACE2, "23.43")),
        ((Standards.SBI2008, "2344"), (Standards.NACE2, "23.44")),
        ((Standards.SBI2008, "2349"), (Standards.NACE2, "23.49")),
        ((Standards.SBI2008, "2351"), (Standards.NACE2, "23.51")),
        ((Standards.SBI2008, "2352"), (Standards.NACE2, "23.52")),
        ((Standards.SBI2008, "23611"), (Standards.NACE2, "23.61")),
        ((Standards.SBI2008, "23612"), (Standards.NACE2, "23.61")),
        ((Standards.SBI2008, "2362"), (Standards.NACE2, "23.62")),
        ((Standards.SBI2008, "2363"), (Standards.NACE2, "23.63")),
        ((Standards.SBI2008, "2364"), (Standards.NACE2, "23.64")),
        ((Standards.SBI2008, "2365"), (Standards.NACE2, "23.65")),
        ((Standards.SBI2008, "2369"), (Standards.NACE2, "23.69")),
        ((Standards.SBI2008, "2370"), (Standards.NACE2, "23.70")),
        ((Standards.SBI2008, "2391"), (Standards.NACE2, "23.91")),
        ((Standards.SBI2008, "2399"), (Standards.NACE2, "23.99")),
        ((Standards.SBI2008, "2410"), (Standards.NACE2, "24.10")),
        ((Standards.SBI2008, "2420"), (Standards.NACE2, "24.20")),
        ((Standards.SBI2008, "2431"), (Standards.NACE2, "24.31")),
        ((Standards.SBI2008, "2432"), (Standards.NACE2, "24.32")),
        ((Standards.SBI2008, "2433"), (Standards.NACE2, "24.33")),
        ((Standards.SBI2008, "2434"), (Standards.NACE2, "24.34")),
        ((Standards.SBI2008, "2441"), (Standards.NACE2, "24.41")),
        ((Standards.SBI2008, "2442"), (Standards.NACE2, "24.42")),
        ((Standards.SBI2008, "2443"), (Standards.NACE2, "24.43")),
        ((Standards.SBI2008, "2444"), (Standards.NACE2, "24.44")),
        ((Standards.SBI2008, "2445"), (Standards.NACE2, "24.45")),
        ((Standards.SBI2008, "2446"), (Standards.NACE2, "24.46")),
        ((Standards.SBI2008, "2451"), (Standards.NACE2, "24.51")),
        ((Standards.SBI2008, "2452"), (Standards.NACE2, "24.52")),
        ((Standards.SBI2008, "2453"), (Standards.NACE2, "24.53")),
        ((Standards.SBI2008, "2454"), (Standards.NACE2, "24.54")),
        ((Standards.SBI2008, "2511"), (Standards.NACE2, "25.11")),
        ((Standards.SBI2008, "2512"), (Standards.NACE2, "25.12")),
        ((Standards.SBI2008, "2521"), (Standards.NACE2, "25.21")),
        ((Standards.SBI2008, "2529"), (Standards.NACE2, "25.29")),
        ((Standards.SBI2008, "2530"), (Standards.NACE2, "25.30")),
        ((Standards.SBI2008, "2540"), (Standards.NACE2, "25.40")),
        ((Standards.SBI2008, "2550"), (Standards.NACE2, "25.50")),
        ((Standards.SBI2008, "2561"), (Standards.NACE2, "25.61")),
        ((Standards.SBI2008, "2562"), (Standards.NACE2, "25.62")),
        ((Standards.SBI2008, "2571"), (Standards.NACE2, "25.71")),
        ((Standards.SBI2008, "2572"), (Standards.NACE2, "25.72")),
        ((Standards.SBI2008, "2573"), (Standards.NACE2, "25.73")),
        ((Standards.SBI2008, "2591"), (Standards.NACE2, "25.91")),
        ((Standards.SBI2008, "2592"), (Standards.NACE2, "25.92")),
        ((Standards.SBI2008, "2593"), (Standards.NACE2, "25.93")),
        ((Standards.SBI2008, "2594"), (Standards.NACE2, "25.94")),
        ((Standards.SBI2008, "2599"), (Standards.NACE2, "25.99")),
        ((Standards.SBI2008, "2611"), (Standards.NACE2, "26.11")),
        ((Standards.SBI2008, "2612"), (Standards.NACE2, "26.12")),
        ((Standards.SBI2008, "2620"), (Standards.NACE2, "26.20")),
        ((Standards.SBI2008, "2630"), (Standards.NACE2, "26.30")),
        ((Standards.SBI2008, "2640"), (Standards.NACE2, "26.40")),
        ((Standards.SBI2008, "2651"), (Standards.NACE2, "26.51")),
        ((Standards.SBI2008, "2652"), (Standards.NACE2, "26.52")),
        ((Standards.SBI2008, "2660"), (Standards.NACE2, "26.60")),
        ((Standards.SBI2008, "2670"), (Standards.NACE2, "26.70")),
        ((Standards.SBI2008, "2680"), (Standards.NACE2, "26.80")),
        ((Standards.SBI2008, "2711"), (Standards.NACE2, "27.11")),
        ((Standards.SBI2008, "2712"), (Standards.NACE2, "27.12")),
        ((Standards.SBI2008, "2720"), (Standards.NACE2, "27.20")),
        ((Standards.SBI2008, "2731"), (Standards.NACE2, "27.31")),
        ((Standards.SBI2008, "2732"), (Standards.NACE2, "27.32")),
        ((Standards.SBI2008, "2733"), (Standards.NACE2, "27.33")),
        ((Standards.SBI2008, "2740"), (Standards.NACE2, "27.40")),
        ((Standards.SBI2008, "2751"), (Standards.NACE2, "27.51")),
        ((Standards.SBI2008, "2752"), (Standards.NACE2, "27.52")),
        ((Standards.SBI2008, "2790"), (Standards.NACE2, "27.90")),
        ((Standards.SBI2008, "2811"), (Standards.NACE2, "28.11")),
        ((Standards.SBI2008, "2812"), (Standards.NACE2, "28.12")),
        ((Standards.SBI2008, "2813"), (Standards.NACE2, "28.13")),
        ((Standards.SBI2008, "2814"), (Standards.NACE2, "28.14")),
        ((Standards.SBI2008, "2815"), (Standards.NACE2, "28.15")),
        ((Standards.SBI2008, "2821"), (Standards.NACE2, "28.21")),
        ((Standards.SBI2008, "2822"), (Standards.NACE2, "28.22")),
        ((Standards.SBI2008, "2823"), (Standards.NACE2, "28.23")),
        ((Standards.SBI2008, "2824"), (Standards.NACE2, "28.24")),
        ((Standards.SBI2008, "2825"), (Standards.NACE2, "28.25")),
        ((Standards.SBI2008, "2829"), (Standards.NACE2, "28.29")),
        ((Standards.SBI2008, "2830"), (Standards.NACE2, "28.30")),
        ((Standards.SBI2008, "2841"), (Standards.NACE2, "28.41")),
        ((Standards.SBI2008, "2849"), (Standards.NACE2, "28.49")),
        ((Standards.SBI2008, "2891"), (Standards.NACE2, "28.91")),
        ((Standards.SBI2008, "2892"), (Standards.NACE2, "28.92")),
        ((Standards.SBI2008, "2893"), (Standards.NACE2, "28.93")),
        ((Standards.SBI2008, "2894"), (Standards.NACE2, "28.94")),
        ((Standards.SBI2008, "2895"), (Standards.NACE2, "28.95")),
        ((Standards.SBI2008, "2896"), (Standards.NACE2, "28.96")),
        ((Standards.SBI2008, "2899"), (Standards.NACE2, "28.99")),
        ((Standards.SBI2008, "2910"), (Standards.NACE2, "29.10")),
        ((Standards.SBI2008, "29201"), (Standards.NACE2, "29.20")),
        ((Standards.SBI2008, "29202"), (Standards.NACE2, "29.20")),
        ((Standards.SBI2008, "2931"), (Standards.NACE2, "29.31")),
        ((Standards.SBI2008, "2932"), (Standards.NACE2, "29.32")),
        ((Standards.SBI2008, "3011"), (Standards.NACE2, "30.11")),
        ((Standards.SBI2008, "3012"), (Standards.NACE2, "30.12")),
        ((Standards.SBI2008, "3020"), (Standards.NACE2, "30.20")),
        ((Standards.SBI2008, "3030"), (Standards.NACE2, "30.30")),
        ((Standards.SBI2008, "3040"), (Standards.NACE2, "30.40")),
        ((Standards.SBI2008, "3091"), (Standards.NACE2, "30.91")),
        ((Standards.SBI2008, "3092"), (Standards.NACE2, "30.92")),
        ((Standards.SBI2008, "3099"), (Standards.NACE2, "30.99")),
        ((Standards.SBI2008, "31011"), (Standards.NACE2, "31.01")),
        ((Standards.SBI2008, "31012"), (Standards.NACE2, "31.01")),
        ((Standards.SBI2008, "3102"), (Standards.NACE2, "31.02")),
        ((Standards.SBI2008, "3103"), (Standards.NACE2, "31.03")),
        ((Standards.SBI2008, "3109"), (Standards.NACE2, "31.09")),
        ((Standards.SBI2008, "3211"), (Standards.NACE2, "32.11")),
        ((Standards.SBI2008, "3212"), (Standards.NACE2, "32.12")),
        ((Standards.SBI2008, "3213"), (Standards.NACE2, "32.13")),
        ((Standards.SBI2008, "3220"), (Standards.NACE2, "32.20")),
        ((Standards.SBI2008, "3230"), (Standards.NACE2, "32.30")),
        ((Standards.SBI2008, "3240"), (Standards.NACE2, "32.40")),
        ((Standards.SBI2008, "32501"), (Standards.NACE2, "32.50")),
        ((Standards.SBI2008, "32502"), (Standards.NACE2, "32.50")),
        ((Standards.SBI2008, "3291"), (Standards.NACE2, "32.91")),
        ((Standards.SBI2008, "32991"), (Standards.NACE2, "32.99")),
        ((Standards.SBI2008, "32999"), (Standards.NACE2, "32.99")),
        ((Standards.SBI2008, "3311"), (Standards.NACE2, "33.11")),
        ((Standards.SBI2008, "33121"), (Standards.NACE2, "33.12")),
        ((Standards.SBI2008, "33122"), (Standards.NACE2, "33.12")),
        ((Standards.SBI2008, "33123"), (Standards.NACE2, "33.12")),
        ((Standards.SBI2008, "3313"), (Standards.NACE2, "33.13")),
        ((Standards.SBI2008, "3314"), (Standards.NACE2, "33.14")),
        ((Standards.SBI2008, "3315"), (Standards.NACE2, "33.15")),
        ((Standards.SBI2008, "3316"), (Standards.NACE2, "33.16")),
        ((Standards.SBI2008, "3317"), (Standards.NACE2, "33.17")),
        ((Standards.SBI2008, "3319"), (Standards.NACE2, "33.19")),
        ((Standards.SBI2008, "35111"), (Standards.NACE2, "35.11")),
        ((Standards.SBI2008, "35112"), (Standards.NACE2, "35.11")),
        ((Standards.SBI2008, "35113"), (Standards.NACE2, "35.11")),
        ((Standards.SBI2008, "3512"), (Standards.NACE2, "35.12")),
        ((Standards.SBI2008, "3513"), (Standards.NACE2, "35.13")),
        ((Standards.SBI2008, "3514"), (Standards.NACE2, "35.14")),
        ((Standards.SBI2008, "3530"), (Standards.NACE2, "35.30")),
        ((Standards.SBI2008, "3600"), (Standards.NACE2, "36.00")),
        ((Standards.SBI2008, "3700"), (Standards.NACE2, "37.00")),
        ((Standards.SBI2008, "3811"), (Standards.NACE2, "38.11")),
        ((Standards.SBI2008, "3812"), (Standards.NACE2, "38.12")),
        ((Standards.SBI2008, "3821"), (Standards.NACE2, "38.21")),
        ((Standards.SBI2008, "3822"), (Standards.NACE2, "38.22")),
        ((Standards.SBI2008, "3831"), (Standards.NACE2, "38.31")),
        ((Standards.SBI2008, "3832"), (Standards.NACE2, "38.32")),
        ((Standards.SBI2008, "3900"), (Standards.NACE2, "39.00")),
        ((Standards.SBI2008, "4110"), (Standards.NACE2, "41.10")),
        ((Standards.SBI2008, "4120"), (Standards.NACE2, "41.20")),
        ((Standards.SBI2008, "42111"), (Standards.NACE2, "42.11")),
        ((Standards.SBI2008, "42112"), (Standards.NACE2, "42.11")),
        ((Standards.SBI2008, "4212"), (Standards.NACE2, "42.12")),
        ((Standards.SBI2008, "4213"), (Standards.NACE2, "42.13")),
        ((Standards.SBI2008, "4221"), (Standards.NACE2, "42.21")),
        ((Standards.SBI2008, "4222"), (Standards.NACE2, "42.22")),
        ((Standards.SBI2008, "4291"), (Standards.NACE2, "42.91")),
        ((Standards.SBI2008, "4299"), (Standards.NACE2, "42.99")),
        ((Standards.SBI2008, "4311"), (Standards.NACE2, "43.11")),
        ((Standards.SBI2008, "4312"), (Standards.NACE2, "43.12")),
        ((Standards.SBI2008, "4313"), (Standards.NACE2, "43.13")),
        ((Standards.SBI2008, "4321"), (Standards.NACE2, "43.21")),
        ((Standards.SBI2008, "43221"), (Standards.NACE2, "43.22")),
        ((Standards.SBI2008, "43222"), (Standards.NACE2, "43.22")),
        ((Standards.SBI2008, "4329"), (Standards.NACE2, "43.29")),
        ((Standards.SBI2008, "4331"), (Standards.NACE2, "43.31")),
        ((Standards.SBI2008, "4332"), (Standards.NACE2, "43.32")),
        ((Standards.SBI2008, "4333"), (Standards.NACE2, "43.33")),
        ((Standards.SBI2008, "4334"), (Standards.NACE2, "43.34")),
        ((Standards.SBI2008, "4339"), (Standards.NACE2, "43.39")),
        ((Standards.SBI2008, "4391"), (Standards.NACE2, "43.91")),
        ((Standards.SBI2008, "43991"), (Standards.NACE2, "43.99")),
        ((Standards.SBI2008, "43992"), (Standards.NACE2, "43.99")),
        ((Standards.SBI2008, "43993"), (Standards.NACE2, "43.99")),
        ((Standards.SBI2008, "43999"), (Standards.NACE2, "43.99")),
        ((Standards.SBI2008, "45111"), (Standards.NACE2, "45.11")),
        ((Standards.SBI2008, "45112"), (Standards.NACE2, "45.11")),
        ((Standards.SBI2008, "45191"), (Standards.NACE2, "45.19")),
        ((Standards.SBI2008, "45192"), (Standards.NACE2, "45.19")),
        ((Standards.SBI2008, "45193"), (Standards.NACE2, "45.19")),
        ((Standards.SBI2008, "45194"), (Standards.NACE2, "45.19")),
        ((Standards.SBI2008, "45201"), (Standards.NACE2, "45.20")),
        ((Standards.SBI2008, "45202"), (Standards.NACE2, "45.20")),
        ((Standards.SBI2008, "45203"), (Standards.NACE2, "45.20")),
        ((Standards.SBI2008, "45204"), (Standards.NACE2, "45.20")),
        ((Standards.SBI2008, "45205"), (Standards.NACE2, "45.20")),
        ((Standards.SBI2008, "45311"), (Standards.NACE2, "45.31")),
        ((Standards.SBI2008, "45312"), (Standards.NACE2, "45.31")),
        ((Standards.SBI2008, "4532"), (Standards.NACE2, "45.32")),
        ((Standards.SBI2008, "45401"), (Standards.NACE2, "45.40")),
        ((Standards.SBI2008, "45402"), (Standards.NACE2, "45.40")),
        ((Standards.SBI2008, "4611"), (Standards.NACE2, "46.11")),
        ((Standards.SBI2008, "4612"), (Standards.NACE2, "46.12")),
        ((Standards.SBI2008, "4613"), (Standards.NACE2, "46.13")),
        ((Standards.SBI2008, "4614"), (Standards.NACE2, "46.14")),
        ((Standards.SBI2008, "4615"), (Standards.NACE2, "46.15")),
        ((Standards.SBI2008, "4616"), (Standards.NACE2, "46.16")),
        ((Standards.SBI2008, "4617"), (Standards.NACE2, "46.17")),
        ((Standards.SBI2008, "4618"), (Standards.NACE2, "46.18")),
        ((Standards.SBI2008, "4619"), (Standards.NACE2, "46.19")),
        ((Standards.SBI2008, "46211"), (Standards.NACE2, "46.21")),
        ((Standards.SBI2008, "46212"), (Standards.NACE2, "46.21")),
        ((Standards.SBI2008, "46213"), (Standards.NACE2, "46.21")),
        ((Standards.SBI2008, "46214"), (Standards.NACE2, "46.21")),
        ((Standards.SBI2008, "46215"), (Standards.NACE2, "46.21")),
        ((Standards.SBI2008, "46216"), (Standards.NACE2, "46.21")),
        ((Standards.SBI2008, "46217"), (Standards.NACE2, "46.21")),
        ((Standards.SBI2008, "46218"), (Standards.NACE2, "46.21")),
        ((Standards.SBI2008, "46219"), (Standards.NACE2, "46.21")),
        ((Standards.SBI2008, "4622"), (Standards.NACE2, "46.22")),
        ((Standards.SBI2008, "46231"), (Standards.NACE2, "46.23")),
        ((Standards.SBI2008, "46232"), (Standards.NACE2, "46.23")),
        ((Standards.SBI2008, "46241"), (Standards.NACE2, "46.24")),
        ((Standards.SBI2008, "46242"), (Standards.NACE2, "46.24")),
        ((Standards.SBI2008, "46311"), (Standards.NACE2, "46.31")),
        ((Standards.SBI2008, "46312"), (Standards.NACE2, "46.31")),
        ((Standards.SBI2008, "4632"), (Standards.NACE2, "46.32")),
        ((Standards.SBI2008, "46331"), (Standards.NACE2, "46.33")),
        ((Standards.SBI2008, "46332"), (Standards.NACE2, "46.33")),
        ((Standards.SBI2008, "4634"), (Standards.NACE2, "46.34")),
        ((Standards.SBI2008, "4635"), (Standards.NACE2, "46.35")),
        ((Standards.SBI2008, "4636"), (Standards.NACE2, "46.36")),
        ((Standards.SBI2008, "4637"), (Standards.NACE2, "46.37")),
        ((Standards.SBI2008, "46381"), (Standards.NACE2, "46.38")),
        ((Standards.SBI2008, "46382"), (Standards.NACE2, "46.38")),
        ((Standards.SBI2008, "46383"), (Standards.NACE2, "46.38")),
        ((Standards.SBI2008, "46384"), (Standards.NACE2, "46.38")),
        ((Standards.SBI2008, "46389"), (Standards.NACE2, "46.38")),
        ((Standards.SBI2008, "4639"), (Standards.NACE2, "46.39")),
        ((Standards.SBI2008, "46411"), (Standards.NACE2, "46.41")),
        ((Standards.SBI2008, "46412"), (Standards.NACE2, "46.41")),
        ((Standards.SBI2008, "46421"), (Standards.NACE2, "46.42")),
        ((Standards.SBI2008, "46422"), (Standards.NACE2, "46.42")),
        ((Standards.SBI2008, "46423"), (Standards.NACE2, "46.42")),
        ((Standards.SBI2008, "46424"), (Standards.NACE2, "46.42")),
        ((Standards.SBI2008, "46425"), (Standards.NACE2, "46.42")),
        ((Standards.SBI2008, "46429"), (Standards.NACE2, "46.42")),
        ((Standards.SBI2008, "46431"), (Standards.NACE2, "46.43")),
        ((Standards.SBI2008, "46432"), (Standards.NACE2, "46.43")),
        ((Standards.SBI2008, "46433"), (Standards.NACE2, "46.43")),
        ((Standards.SBI2008, "46434"), (Standards.NACE2, "46.43")),
        ((Standards.SBI2008, "46435"), (Standards.NACE2, "46.43")),
        ((Standards.SBI2008, "46436"), (Standards.NACE2, "46.43")),
        ((Standards.SBI2008, "46441"), (Standards.NACE2, "46.44")),
        ((Standards.SBI2008, "46442"), (Standards.NACE2, "46.44")),
        ((Standards.SBI2008, "4645"), (Standards.NACE2, "46.45")),
        ((Standards.SBI2008, "46461"), (Standards.NACE2, "46.46")),
        ((Standards.SBI2008, "46462"), (Standards.NACE2, "46.46")),
        ((Standards.SBI2008, "46471"), (Standards.NACE2, "46.47")),
        ((Standards.SBI2008, "46472"), (Standards.NACE2, "46.47")),
        ((Standards.SBI2008, "46473"), (Standards.NACE2, "46.47")),
        ((Standards.SBI2008, "4648"), (Standards.NACE2, "46.48")),
        ((Standards.SBI2008, "46491"), (Standards.NACE2, "46.49")),
        ((Standards.SBI2008, "46492"), (Standards.NACE2, "46.49")),
        ((Standards.SBI2008, "46493"), (Standards.NACE2, "46.49")),
        ((Standards.SBI2008, "46494"), (Standards.NACE2, "46.49")),
        ((Standards.SBI2008, "46495"), (Standards.NACE2, "46.49")),
        ((Standards.SBI2008, "46496"), (Standards.NACE2, "46.49")),
        ((Standards.SBI2008, "46497"), (Standards.NACE2, "46.49")),
        ((Standards.SBI2008, "46498"), (Standards.NACE2, "46.49")),
        ((Standards.SBI2008, "46499"), (Standards.NACE2, "46.49")),
        ((Standards.SBI2008, "4651"), (Standards.NACE2, "46.51")),
        ((Standards.SBI2008, "4652"), (Standards.NACE2, "46.52")),
        ((Standards.SBI2008, "4661"), (Standards.NACE2, "46.61")),
        ((Standards.SBI2008, "4662"), (Standards.NACE2, "46.62")),
        ((Standards.SBI2008, "4663"), (Standards.NACE2, "46.63")),
        ((Standards.SBI2008, "4664"), (Standards.NACE2, "46.64")),
        ((Standards.SBI2008, "4665"), (Standards.NACE2, "46.65")),
        ((Standards.SBI2008, "4666"), (Standards.NACE2, "46.66")),
        ((Standards.SBI2008, "46691"), (Standards.NACE2, "46.69")),
        ((Standards.SBI2008, "46692"), (Standards.NACE2, "46.69")),
        ((Standards.SBI2008, "46693"), (Standards.NACE2, "46.69")),
        ((Standards.SBI2008, "46694"), (Standards.NACE2, "46.69")),
        ((Standards.SBI2008, "46695"), (Standards.NACE2, "46.69")),
        ((Standards.SBI2008, "46696"), (Standards.NACE2, "46.69")),
        ((Standards.SBI2008, "46697"), (Standards.NACE2, "46.69")),
        ((Standards.SBI2008, "46699"), (Standards.NACE2, "46.69")),
        ((Standards.SBI2008, "46711"), (Standards.NACE2, "46.71")),
        ((Standards.SBI2008, "46712"), (Standards.NACE2, "46.71")),
        ((Standards.SBI2008, "46713"), (Standards.NACE2, "46.71")),
        ((Standards.SBI2008, "46721"), (Standards.NACE2, "46.72")),
        ((Standards.SBI2008, "46722"), (Standards.NACE2, "46.72")),
        ((Standards.SBI2008, "46723"), (Standards.NACE2, "46.72")),
        ((Standards.SBI2008, "46731"), (Standards.NACE2, "46.73")),
        ((Standards.SBI2008, "46732"), (Standards.NACE2, "46.73")),
        ((Standards.SBI2008, "46733"), (Standards.NACE2, "46.73")),
        ((Standards.SBI2008, "46734"), (Standards.NACE2, "46.73")),
        ((Standards.SBI2008, "46735"), (Standards.NACE2, "46.73")),
        ((Standards.SBI2008, "46736"), (Standards.NACE2, "46.73")),
        ((Standards.SBI2008, "46737"), (Standards.NACE2, "46.73")),
        ((Standards.SBI2008, "46738"), (Standards.NACE2, "46.73")),
        ((Standards.SBI2008, "46739"), (Standards.NACE2, "46.73")),
        ((Standards.SBI2008, "46741"), (Standards.NACE2, "46.74")),
        ((Standards.SBI2008, "46742"), (Standards.NACE2, "46.74")),
        ((Standards.SBI2008, "46751"), (Standards.NACE2, "46.75")),
        ((Standards.SBI2008, "46752"), (Standards.NACE2, "46.75")),
        ((Standards.SBI2008, "46761"), (Standards.NACE2, "46.76")),
        ((Standards.SBI2008, "46762"), (Standards.NACE2, "46.76")),
        ((Standards.SBI2008, "46769"), (Standards.NACE2, "46.76")),
        ((Standards.SBI2008, "46771"), (Standards.NACE2, "46.77")),
        ((Standards.SBI2008, "46772"), (Standards.NACE2, "46.77")),
        ((Standards.SBI2008, "46779"), (Standards.NACE2, "46.77")),
        ((Standards.SBI2008, "46901"), (Standards.NACE2, "46.90")),
        ((Standards.SBI2008, "46902"), (Standards.NACE2, "46.90")),
        ((Standards.SBI2008, "4711"), (Standards.NACE2, "47.11")),
        ((Standards.SBI2008, "47191"), (Standards.NACE2, "47.19")),
        ((Standards.SBI2008, "47192"), (Standards.NACE2, "47.19")),
        ((Standards.SBI2008, "4721"), (Standards.NACE2, "47.21")),
        ((Standards.SBI2008, "47221"), (Standards.NACE2, "47.22")),
        ((Standards.SBI2008, "47222"), (Standards.NACE2, "47.22")),
        ((Standards.SBI2008, "4723"), (Standards.NACE2, "47.23")),
        ((Standards.SBI2008, "47241"), (Standards.NACE2, "47.24")),
        ((Standards.SBI2008, "47242"), (Standards.NACE2, "47.24")),
        ((Standards.SBI2008, "4725"), (Standards.NACE2, "47.25")),
        ((Standards.SBI2008, "4726"), (Standards.NACE2, "47.26")),
        ((Standards.SBI2008, "47291"), (Standards.NACE2, "47.29")),
        ((Standards.SBI2008, "47292"), (Standards.NACE2, "47.29")),
        ((Standards.SBI2008, "47293"), (Standards.NACE2, "47.29")),
        ((Standards.SBI2008, "47299"), (Standards.NACE2, "47.29")),
        ((Standards.SBI2008, "4730"), (Standards.NACE2, "47.30")),
        ((Standards.SBI2008, "4741"), (Standards.NACE2, "47.41")),
        ((Standards.SBI2008, "4742"), (Standards.NACE2, "47.42")),
        ((Standards.SBI2008, "47431"), (Standards.NACE2, "47.43")),
        ((Standards.SBI2008, "47432"), (Standards.NACE2, "47.43")),
        ((Standards.SBI2008, "47511"), (Standards.NACE2, "47.51")),
        ((Standards.SBI2008, "47512"), (Standards.NACE2, "47.51")),
        ((Standards.SBI2008, "47513"), (Standards.NACE2, "47.51")),
        ((Standards.SBI2008, "47521"), (Standards.NACE2, "47.52")),
        ((Standards.SBI2008, "47522"), (Standards.NACE2, "47.52")),
        ((Standards.SBI2008, "47523"), (Standards.NACE2, "47.52")),
        ((Standards.SBI2008, "47524"), (Standards.NACE2, "47.52")),
        ((Standards.SBI2008, "47525"), (Standards.NACE2, "47.52")),
        ((Standards.SBI2008, "47526"), (Standards.NACE2, "47.52")),
        ((Standards.SBI2008, "47527"), (Standards.NACE2, "47.52")),
        ((Standards.SBI2008, "47528"), (Standards.NACE2, "47.52")),
        ((Standards.SBI2008, "4753"), (Standards.NACE2, "47.53")),
        ((Standards.SBI2008, "47541"), (Standards.NACE2, "47.54")),
        ((Standards.SBI2008, "47542"), (Standards.NACE2, "47.54")),
        ((Standards.SBI2008, "47543"), (Standards.NACE2, "47.54")),
        ((Standards.SBI2008, "47544"), (Standards.NACE2, "47.54")),
        ((Standards.SBI2008, "47591"), (Standards.NACE2, "47.59")),
        ((Standards.SBI2008, "47592"), (Standards.NACE2, "47.59")),
        ((Standards.SBI2008, "47593"), (Standards.NACE2, "47.59")),
        ((Standards.SBI2008, "47594"), (Standards.NACE2, "47.59")),
        ((Standards.SBI2008, "47595"), (Standards.NACE2, "47.59")),
        ((Standards.SBI2008, "47596"), (Standards.NACE2, "47.59")),
        ((Standards.SBI2008, "47597"), (Standards.NACE2, "47.59")),
        ((Standards.SBI2008, "4761"), (Standards.NACE2, "47.61")),
        ((Standards.SBI2008, "4762"), (Standards.NACE2, "47.62")),
        ((Standards.SBI2008, "4763"), (Standards.NACE2, "47.63")),
        ((Standards.SBI2008, "47641"), (Standards.NACE2, "47.64")),
        ((Standards.SBI2008, "47642"), (Standards.NACE2, "47.64")),
        ((Standards.SBI2008, "47643"), (Standards.NACE2, "47.64")),
        ((Standards.SBI2008, "47644"), (Standards.NACE2, "47.64")),
        ((Standards.SBI2008, "4765"), (Standards.NACE2, "47.65")),
        ((Standards.SBI2008, "47711"), (Standards.NACE2, "47.71")),
        ((Standards.SBI2008, "47712"), (Standards.NACE2, "47.71")),
        ((Standards.SBI2008, "47713"), (Standards.NACE2, "47.71")),
        ((Standards.SBI2008, "47714"), (Standards.NACE2, "47.71")),
        ((Standards.SBI2008, "47715"), (Standards.NACE2, "47.71")),
        ((Standards.SBI2008, "47716"), (Standards.NACE2, "47.71")),
        ((Standards.SBI2008, "47717"), (Standards.NACE2, "47.71")),
        ((Standards.SBI2008, "47718"), (Standards.NACE2, "47.71")),
        ((Standards.SBI2008, "47721"), (Standards.NACE2, "47.72")),
        ((Standards.SBI2008, "47722"), (Standards.NACE2, "47.72")),
        ((Standards.SBI2008, "4773"), (Standards.NACE2, "47.73")),
        ((Standards.SBI2008, "47741"), (Standards.NACE2, "47.74")),
        ((Standards.SBI2008, "47742"), (Standards.NACE2, "47.74")),
        ((Standards.SBI2008, "4775"), (Standards.NACE2, "47.75")),
        ((Standards.SBI2008, "47761"), (Standards.NACE2, "47.76")),
        ((Standards.SBI2008, "47762"), (Standards.NACE2, "47.76")),
        ((Standards.SBI2008, "47763"), (Standards.NACE2, "47.76")),
        ((Standards.SBI2008, "4777"), (Standards.NACE2, "47.77")),
        ((Standards.SBI2008, "47781"), (Standards.NACE2, "47.78")),
        ((Standards.SBI2008, "47782"), (Standards.NACE2, "47.78")),
        ((Standards.SBI2008, "47783"), (Standards.NACE2, "47.78")),
        ((Standards.SBI2008, "47789"), (Standards.NACE2, "47.78")),
        ((Standards.SBI2008, "47791"), (Standards.NACE2, "47.79")),
        ((Standards.SBI2008, "47792"), (Standards.NACE2, "47.79")),
        ((Standards.SBI2008, "47793"), (Standards.NACE2, "47.79")),
        ((Standards.SBI2008, "47811"), (Standards.NACE2, "47.81")),
        ((Standards.SBI2008, "47819"), (Standards.NACE2, "47.81")),
        ((Standards.SBI2008, "4782"), (Standards.NACE2, "47.82")),
        ((Standards.SBI2008, "47891"), (Standards.NACE2, "47.89")),
        ((Standards.SBI2008, "47892"), (Standards.NACE2, "47.89")),
        ((Standards.SBI2008, "47899"), (Standards.NACE2, "47.89")),
        ((Standards.SBI2008, "4791"), (Standards.NACE2, "47.91")),
        ((Standards.SBI2008, "47911"), (Standards.NACE2, "47.91")),
        ((Standards.SBI2008, "47912"), (Standards.NACE2, "47.91")),
        ((Standards.SBI2008, "47913"), (Standards.NACE2, "47.91")),
        ((Standards.SBI2008, "47914"), (Standards.NACE2, "47.91")),
        ((Standards.SBI2008, "47915"), (Standards.NACE2, "47.91")),
        ((Standards.SBI2008, "47916"), (Standards.NACE2, "47.91")),
        ((Standards.SBI2008, "47918"), (Standards.NACE2, "47.91")),
        ((Standards.SBI2008, "47919"), (Standards.NACE2, "47.91")),
        ((Standards.SBI2008, "47991"), (Standards.NACE2, "47.99")),
        ((Standards.SBI2008, "47992"), (Standards.NACE2, "47.99")),
        ((Standards.SBI2008, "47999"), (Standards.NACE2, "47.99")),
        ((Standards.SBI2008, "4910"), (Standards.NACE2, "49.10")),
        ((Standards.SBI2008, "4920"), (Standards.NACE2, "49.20")),
        ((Standards.SBI2008, "4931"), (Standards.NACE2, "49.31")),
        ((Standards.SBI2008, "4932"), (Standards.NACE2, "49.32")),
        ((Standards.SBI2008, "49391"), (Standards.NACE2, "49.39")),
        ((Standards.SBI2008, "49392"), (Standards.NACE2, "49.39")),
        ((Standards.SBI2008, "49393"), (Standards.NACE2, "49.39")),
        ((Standards.SBI2008, "4941"), (Standards.NACE2, "49.41")),
        ((Standards.SBI2008, "4942"), (Standards.NACE2, "49.42")),
        ((Standards.SBI2008, "4950"), (Standards.NACE2, "49.50")),
        ((Standards.SBI2008, "5010"), (Standards.NACE2, "50.10")),
        ((Standards.SBI2008, "50201"), (Standards.NACE2, "50.20")),
        ((Standards.SBI2008, "50202"), (Standards.NACE2, "50.20")),
        ((Standards.SBI2008, "5030"), (Standards.NACE2, "50.30")),
        ((Standards.SBI2008, "50401"), (Standards.NACE2, "50.40")),
        ((Standards.SBI2008, "50402"), (Standards.NACE2, "50.40")),
        ((Standards.SBI2008, "50403"), (Standards.NACE2, "50.40")),
        ((Standards.SBI2008, "5110"), (Standards.NACE2, "51.10")),
        ((Standards.SBI2008, "5121"), (Standards.NACE2, "51.21")),
        ((Standards.SBI2008, "52101"), (Standards.NACE2, "52.10")),
        ((Standards.SBI2008, "52102"), (Standards.NACE2, "52.10")),
        ((Standards.SBI2008, "52109"), (Standards.NACE2, "52.10")),
        ((Standards.SBI2008, "5221"), (Standards.NACE2, "52.21")),
        ((Standards.SBI2008, "5222"), (Standards.NACE2, "52.22")),
        ((Standards.SBI2008, "5223"), (Standards.NACE2, "52.23")),
        ((Standards.SBI2008, "52241"), (Standards.NACE2, "52.24")),
        ((Standards.SBI2008, "52242"), (Standards.NACE2, "52.24")),
        ((Standards.SBI2008, "52291"), (Standards.NACE2, "52.29")),
        ((Standards.SBI2008, "52292"), (Standards.NACE2, "52.29")),
        ((Standards.SBI2008, "5310"), (Standards.NACE2, "53.10")),
        ((Standards.SBI2008, "53201"), (Standards.NACE2, "53.20")),
        ((Standards.SBI2008, "53202"), (Standards.NACE2, "53.20")),
        ((Standards.SBI2008, "55101"), (Standards.NACE2, "55.10")),
        ((Standards.SBI2008, "55102"), (Standards.NACE2, "55.10")),
        ((Standards.SBI2008, "55201"), (Standards.NACE2, "55.20")),
        ((Standards.SBI2008, "55202"), (Standards.NACE2, "55.20")),
        ((Standards.SBI2008, "5530"), (Standards.NACE2, "55.30")),
        ((Standards.SBI2008, "5590"), (Standards.NACE2, "55.90")),
        ((Standards.SBI2008, "56101"), (Standards.NACE2, "56.10")),
        ((Standards.SBI2008, "56102"), (Standards.NACE2, "56.10")),
        ((Standards.SBI2008, "5621"), (Standards.NACE2, "56.21")),
        ((Standards.SBI2008, "5629"), (Standards.NACE2, "56.29")),
        ((Standards.SBI2008, "5630"), (Standards.NACE2, "56.30")),
        ((Standards.SBI2008, "5811"), (Standards.NACE2, "58.11")),
        ((Standards.SBI2008, "5812"), (Standards.NACE2, "58.12")),
        ((Standards.SBI2008, "5813"), (Standards.NACE2, "58.13")),
        ((Standards.SBI2008, "5814"), (Standards.NACE2, "58.14")),
        ((Standards.SBI2008, "5819"), (Standards.NACE2, "58.19")),
        ((Standards.SBI2008, "5821"), (Standards.NACE2, "58.21")),
        ((Standards.SBI2008, "5829"), (Standards.NACE2, "58.29")),
        ((Standards.SBI2008, "59111"), (Standards.NACE2, "59.11")),
        ((Standards.SBI2008, "59112"), (Standards.NACE2, "59.11")),
        ((Standards.SBI2008, "5912"), (Standards.NACE2, "59.12")),
        ((Standards.SBI2008, "5913"), (Standards.NACE2, "59.13")),
        ((Standards.SBI2008, "5914"), (Standards.NACE2, "59.14")),
        ((Standards.SBI2008, "5920"), (Standards.NACE2, "59.20")),
        ((Standards.SBI2008, "6010"), (Standards.NACE2, "60.10")),
        ((Standards.SBI2008, "6020"), (Standards.NACE2, "60.20")),
        ((Standards.SBI2008, "6110"), (Standards.NACE2, "61.10")),
        ((Standards.SBI2008, "6120"), (Standards.NACE2, "61.20")),
        ((Standards.SBI2008, "6130"), (Standards.NACE2, "61.30")),
        ((Standards.SBI2008, "6190"), (Standards.NACE2, "61.90")),
        ((Standards.SBI2008, "6201"), (Standards.NACE2, "62.01")),
        ((Standards.SBI2008, "6202"), (Standards.NACE2, "62.02")),
        ((Standards.SBI2008, "6203"), (Standards.NACE2, "62.03")),
        ((Standards.SBI2008, "6209"), (Standards.NACE2, "62.09")),
        ((Standards.SBI2008, "6311"), (Standards.NACE2, "63.11")),
        ((Standards.SBI2008, "6312"), (Standards.NACE2, "63.12")),
        ((Standards.SBI2008, "6391"), (Standards.NACE2, "63.91")),
        ((Standards.SBI2008, "6399"), (Standards.NACE2, "63.99")),
        ((Standards.SBI2008, "6411"), (Standards.NACE2, "64.11")),
        ((Standards.SBI2008, "64191"), (Standards.NACE2, "64.19")),
        ((Standards.SBI2008, "64192"), (Standards.NACE2, "64.19")),
        ((Standards.SBI2008, "64193"), (Standards.NACE2, "64.19")),
        ((Standards.SBI2008, "64194"), (Standards.NACE2, "64.19")),
        ((Standards.SBI2008, "6420"), (Standards.NACE2, "64.20")),
        ((Standards.SBI2008, "64301"), (Standards.NACE2, "64.30")),
        ((Standards.SBI2008, "64302"), (Standards.NACE2, "64.30")),
        ((Standards.SBI2008, "64303"), (Standards.NACE2, "64.30")),
        ((Standards.SBI2008, "6491"), (Standards.NACE2, "64.91")),
        ((Standards.SBI2008, "64921"), (Standards.NACE2, "64.92")),
        ((Standards.SBI2008, "64922"), (Standards.NACE2, "64.92")),
        ((Standards.SBI2008, "64923"), (Standards.NACE2, "64.92")),
        ((Standards.SBI2008, "64924"), (Standards.NACE2, "64.92")),
        ((Standards.SBI2008, "6499"), (Standards.NACE2, "64.99")),
        ((Standards.SBI2008, "65111"), (Standards.NACE2, "65.11")),
        ((Standards.SBI2008, "65112"), (Standards.NACE2, "65.11")),
        ((Standards.SBI2008, "65113"), (Standards.NACE2, "65.11")),
        ((Standards.SBI2008, "6512"), (Standards.NACE2, "65.12")),
        ((Standards.SBI2008, "65121"), (Standards.NACE2, "65.12")),
        ((Standards.SBI2008, "65122"), (Standards.NACE2, "65.12")),
        ((Standards.SBI2008, "6520"), (Standards.NACE2, "65.20")),
        ((Standards.SBI2008, "65301"), (Standards.NACE2, "65.30")),
        ((Standards.SBI2008, "65302"), (Standards.NACE2, "65.30")),
        ((Standards.SBI2008, "65303"), (Standards.NACE2, "65.30")),
        ((Standards.SBI2008, "65309"), (Standards.NACE2, "65.30")),
        ((Standards.SBI2008, "6611"), (Standards.NACE2, "66.11")),
        ((Standards.SBI2008, "6612"), (Standards.NACE2, "66.12")),
        ((Standards.SBI2008, "66191"), (Standards.NACE2, "66.19")),
        ((Standards.SBI2008, "66192"), (Standards.NACE2, "66.19")),
        ((Standards.SBI2008, "66193"), (Standards.NACE2, "66.19")),
        ((Standards.SBI2008, "6621"), (Standards.NACE2, "66.21")),
        ((Standards.SBI2008, "6622"), (Standards.NACE2, "66.22")),
        ((Standards.SBI2008, "66291"), (Standards.NACE2, "66.29")),
        ((Standards.SBI2008, "66292"), (Standards.NACE2, "66.29")),
        ((Standards.SBI2008, "66293"), (Standards.NACE2, "66.29")),
        ((Standards.SBI2008, "66299"), (Standards.NACE2, "66.29")),
        ((Standards.SBI2008, "6630"), (Standards.NACE2, "66.30")),
        ((Standards.SBI2008, "6810"), (Standards.NACE2, "68.10")),
        ((Standards.SBI2008, "68201"), (Standards.NACE2, "68.20")),
        ((Standards.SBI2008, "68202"), (Standards.NACE2, "68.20")),
        ((Standards.SBI2008, "68203"), (Standards.NACE2, "68.20")),
        ((Standards.SBI2008, "68204"), (Standards.NACE2, "68.20")),
        ((Standards.SBI2008, "6831"), (Standards.NACE2, "68.31")),
        ((Standards.SBI2008, "6832"), (Standards.NACE2, "68.32")),
        ((Standards.SBI2008, "69101"), (Standards.NACE2, "69.10")),
        ((Standards.SBI2008, "69102"), (Standards.NACE2, "69.10")),
        ((Standards.SBI2008, "69103"), (Standards.NACE2, "69.10")),
        ((Standards.SBI2008, "69104"), (Standards.NACE2, "69.10")),
        ((Standards.SBI2008, "69105"), (Standards.NACE2, "69.10")),
        ((Standards.SBI2008, "69201"), (Standards.NACE2, "69.20")),
        ((Standards.SBI2008, "69202"), (Standards.NACE2, "69.20")),
        ((Standards.SBI2008, "69203"), (Standards.NACE2, "69.20")),
        ((Standards.SBI2008, "69204"), (Standards.NACE2, "69.20")),
        ((Standards.SBI2008, "69209"), (Standards.NACE2, "69.20")),
        ((Standards.SBI2008, "70101"), (Standards.NACE2, "70.10")),
        ((Standards.SBI2008, "70102"), (Standards.NACE2, "70.10")),
        ((Standards.SBI2008, "7021"), (Standards.NACE2, "70.21")),
        ((Standards.SBI2008, "70221"), (Standards.NACE2, "70.22")),
        ((Standards.SBI2008, "70222"), (Standards.NACE2, "70.22")),
        ((Standards.SBI2008, "7111"), (Standards.NACE2, "71.11")),
        ((Standards.SBI2008, "71111"), (Standards.NACE2, "71.11")),
        ((Standards.SBI2008, "71112"), (Standards.NACE2, "71.11")),
        ((Standards.SBI2008, "7112"), (Standards.NACE2, "71.12")),
        ((Standards.SBI2008, "71201"), (Standards.NACE2, "71.20")),
        ((Standards.SBI2008, "71202"), (Standards.NACE2, "71.20")),
        ((Standards.SBI2008, "71203"), (Standards.NACE2, "71.20")),
        ((Standards.SBI2008, "72111"), (Standards.NACE2, "72.11")),
        ((Standards.SBI2008, "72112"), (Standards.NACE2, "72.11")),
        ((Standards.SBI2008, "72113"), (Standards.NACE2, "72.11")),
        ((Standards.SBI2008, "72191"), (Standards.NACE2, "72.19")),
        ((Standards.SBI2008, "72192"), (Standards.NACE2, "72.19")),
        ((Standards.SBI2008, "72193"), (Standards.NACE2, "72.19")),
        ((Standards.SBI2008, "72199"), (Standards.NACE2, "72.19")),
        ((Standards.SBI2008, "7220"), (Standards.NACE2, "72.20")),
        ((Standards.SBI2008, "7311"), (Standards.NACE2, "73.11")),
        ((Standards.SBI2008, "7312"), (Standards.NACE2, "73.12")),
        ((Standards.SBI2008, "7320"), (Standards.NACE2, "73.20")),
        ((Standards.SBI2008, "7410"), (Standards.NACE2, "74.10")),
        ((Standards.SBI2008, "74101"), (Standards.NACE2, "74.10")),
        ((Standards.SBI2008, "74102"), (Standards.NACE2, "74.10")),
        ((Standards.SBI2008, "74103"), (Standards.NACE2, "74.10")),
        ((Standards.SBI2008, "74201"), (Standards.NACE2, "74.20")),
        ((Standards.SBI2008, "74202"), (Standards.NACE2, "74.20")),
        ((Standards.SBI2008, "74203"), (Standards.NACE2, "74.20")),
        ((Standards.SBI2008, "7430"), (Standards.NACE2, "74.30")),
        ((Standards.SBI2008, "7490"), (Standards.NACE2, "74.90")),
        ((Standards.SBI2008, "7500"), (Standards.NACE2, "75.00")),
        ((Standards.SBI2008, "77111"), (Standards.NACE2, "77.11")),
        ((Standards.SBI2008, "77112"), (Standards.NACE2, "77.11")),
        ((Standards.SBI2008, "7712"), (Standards.NACE2, "77.12")),
        ((Standards.SBI2008, "7721"), (Standards.NACE2, "77.21")),
        ((Standards.SBI2008, "7722"), (Standards.NACE2, "77.22")),
        ((Standards.SBI2008, "77291"), (Standards.NACE2, "77.29")),
        ((Standards.SBI2008, "77292"), (Standards.NACE2, "77.29")),
        ((Standards.SBI2008, "77299"), (Standards.NACE2, "77.29")),
        ((Standards.SBI2008, "7731"), (Standards.NACE2, "77.31")),
        ((Standards.SBI2008, "7732"), (Standards.NACE2, "77.32")),
        ((Standards.SBI2008, "7733"), (Standards.NACE2, "77.33")),
        ((Standards.SBI2008, "7734"), (Standards.NACE2, "77.34")),
        ((Standards.SBI2008, "7735"), (Standards.NACE2, "77.35")),
        ((Standards.SBI2008, "77391"), (Standards.NACE2, "77.39")),
        ((Standards.SBI2008, "77399"), (Standards.NACE2, "77.39")),
        ((Standards.SBI2008, "7740"), (Standards.NACE2, "77.40")),
        ((Standards.SBI2008, "7810"), (Standards.NACE2, "78.10")),
        ((Standards.SBI2008, "78201"), (Standards.NACE2, "78.20")),
        ((Standards.SBI2008, "78202"), (Standards.NACE2, "78.20")),
        ((Standards.SBI2008, "78203"), (Standards.NACE2, "78.20")),
        ((Standards.SBI2008, "7830"), (Standards.NACE2, "78.30")),
        ((Standards.SBI2008, "7911"), (Standards.NACE2, "79.11")),
        ((Standards.SBI2008, "7912"), (Standards.NACE2, "79.12")),
        ((Standards.SBI2008, "7990"), (Standards.NACE2, "79.90")),
        ((Standards.SBI2008, "8010"), (Standards.NACE2, "80.10")),
        ((Standards.SBI2008, "8020"), (Standards.NACE2, "80.20")),
        ((Standards.SBI2008, "8030"), (Standards.NACE2, "80.30")),
        ((Standards.SBI2008, "8110"), (Standards.NACE2, "81.10")),
        ((Standards.SBI2008, "8121"), (Standards.NACE2, "81.21")),
        ((Standards.SBI2008, "8122"), (Standards.NACE2, "81.22")),
        ((Standards.SBI2008, "81221"), (Standards.NACE2, "81.22")),
        ((Standards.SBI2008, "81222"), (Standards.NACE2, "81.22")),
        ((Standards.SBI2008, "81229"), (Standards.NACE2, "81.22")),
        ((Standards.SBI2008, "8129"), (Standards.NACE2, "81.29")),
        ((Standards.SBI2008, "8130"), (Standards.NACE2, "81.30")),
        ((Standards.SBI2008, "8211"), (Standards.NACE2, "82.11")),
        ((Standards.SBI2008, "8219"), (Standards.NACE2, "82.19")),
        ((Standards.SBI2008, "8220"), (Standards.NACE2, "82.20")),
        ((Standards.SBI2008, "8230"), (Standards.NACE2, "82.30")),
        ((Standards.SBI2008, "8291"), (Standards.NACE2, "82.91")),
        ((Standards.SBI2008, "8292"), (Standards.NACE2, "82.92")),
        ((Standards.SBI2008, "82991"), (Standards.NACE2, "82.99")),
        ((Standards.SBI2008, "82992"), (Standards.NACE2, "82.99")),
        ((Standards.SBI2008, "82999"), (Standards.NACE2, "82.99")),
        ((Standards.SBI2008, "8411"), (Standards.NACE2, "84.11")),
        ((Standards.SBI2008, "8412"), (Standards.NACE2, "84.12")),
        ((Standards.SBI2008, "8413"), (Standards.NACE2, "84.13")),
        ((Standards.SBI2008, "8421"), (Standards.NACE2, "84.21")),
        ((Standards.SBI2008, "8422"), (Standards.NACE2, "84.22")),
        ((Standards.SBI2008, "84231"), (Standards.NACE2, "84.23")),
        ((Standards.SBI2008, "84232"), (Standards.NACE2, "84.23")),
        ((Standards.SBI2008, "8424"), (Standards.NACE2, "84.24")),
        ((Standards.SBI2008, "8425"), (Standards.NACE2, "84.25")),
        ((Standards.SBI2008, "8430"), (Standards.NACE2, "84.30")),
        ((Standards.SBI2008, "85201"), (Standards.NACE2, "85.20")),
        ((Standards.SBI2008, "85202"), (Standards.NACE2, "85.20")),
        ((Standards.SBI2008, "85203"), (Standards.NACE2, "85.20")),
        ((Standards.SBI2008, "85311"), (Standards.NACE2, "85.31")),
        ((Standards.SBI2008, "85312"), (Standards.NACE2, "85.31")),
        ((Standards.SBI2008, "85313"), (Standards.NACE2, "85.31")),
        ((Standards.SBI2008, "85314"), (Standards.NACE2, "85.31")),
        ((Standards.SBI2008, "85321"), (Standards.NACE2, "85.32")),
        ((Standards.SBI2008, "85322"), (Standards.NACE2, "85.32")),
        ((Standards.SBI2008, "85323"), (Standards.NACE2, "85.32")),
        ((Standards.SBI2008, "8541"), (Standards.NACE2, "85.41")),
        ((Standards.SBI2008, "8542"), (Standards.NACE2, "85.42")),
        ((Standards.SBI2008, "85511"), (Standards.NACE2, "85.51")),
        ((Standards.SBI2008, "85519"), (Standards.NACE2, "85.51")),
        ((Standards.SBI2008, "85521"), (Standards.NACE2, "85.52")),
        ((Standards.SBI2008, "85522"), (Standards.NACE2, "85.52")),
        ((Standards.SBI2008, "8553"), (Standards.NACE2, "85.53")),
        ((Standards.SBI2008, "85591"), (Standards.NACE2, "85.59")),
        ((Standards.SBI2008, "85592"), (Standards.NACE2, "85.59")),
        ((Standards.SBI2008, "85599"), (Standards.NACE2, "85.59")),
        ((Standards.SBI2008, "8560"), (Standards.NACE2, "85.60")),
        ((Standards.SBI2008, "86101"), (Standards.NACE2, "86.10")),
        ((Standards.SBI2008, "86102"), (Standards.NACE2, "86.10")),
        ((Standards.SBI2008, "86103"), (Standards.NACE2, "86.10")),
        ((Standards.SBI2008, "86104"), (Standards.NACE2, "86.10")),
        ((Standards.SBI2008, "8621"), (Standards.NACE2, "86.21")),
        ((Standards.SBI2008, "86221"), (Standards.NACE2, "86.22")),
        ((Standards.SBI2008, "86222"), (Standards.NACE2, "86.22")),
        ((Standards.SBI2008, "86231"), (Standards.NACE2, "86.23")),
        ((Standards.SBI2008, "86232"), (Standards.NACE2, "86.23")),
        ((Standards.SBI2008, "8710"), (Standards.NACE2, "87.10")),
        ((Standards.SBI2008, "8720"), (Standards.NACE2, "87.20")),
        ((Standards.SBI2008, "87301"), (Standards.NACE2, "87.30")),
        ((Standards.SBI2008, "87302"), (Standards.NACE2, "87.30")),
        ((Standards.SBI2008, "87901"), (Standards.NACE2, "87.90")),
        ((Standards.SBI2008, "87902"), (Standards.NACE2, "87.90")),
        ((Standards.SBI2008, "88101"), (Standards.NACE2, "88.10")),
        ((Standards.SBI2008, "88102"), (Standards.NACE2, "88.10")),
        ((Standards.SBI2008, "88103"), (Standards.NACE2, "88.10")),
        ((Standards.SBI2008, "8891"), (Standards.NACE2, "88.91")),
        ((Standards.SBI2008, "88991"), (Standards.NACE2, "88.99")),
        ((Standards.SBI2008, "88992"), (Standards.NACE2, "88.99")),
        ((Standards.SBI2008, "88993"), (Standards.NACE2, "88.99")),
        ((Standards.SBI2008, "88999"), (Standards.NACE2, "88.99")),
        ((Standards.SBI2008, "90011"), (Standards.NACE2, "90.01")),
        ((Standards.SBI2008, "90012"), (Standards.NACE2, "90.01")),
        ((Standards.SBI2008, "90013"), (Standards.NACE2, "90.01")),
        ((Standards.SBI2008, "9002"), (Standards.NACE2, "90.02")),
        ((Standards.SBI2008, "9003"), (Standards.NACE2, "90.03")),
        ((Standards.SBI2008, "90041"), (Standards.NACE2, "90.04")),
        ((Standards.SBI2008, "90042"), (Standards.NACE2, "90.04")),
        ((Standards.SBI2008, "91011"), (Standards.NACE2, "91.01")),
        ((Standards.SBI2008, "91012"), (Standards.NACE2, "91.01")),
        ((Standards.SBI2008, "91019"), (Standards.NACE2, "91.01")),
        ((Standards.SBI2008, "91021"), (Standards.NACE2, "91.02")),
        ((Standards.SBI2008, "91022"), (Standards.NACE2, "91.02")),
        ((Standards.SBI2008, "9103"), (Standards.NACE2, "91.03")),
        ((Standards.SBI2008, "91041"), (Standards.NACE2, "91.04")),
        ((Standards.SBI2008, "91042"), (Standards.NACE2, "91.04")),
        ((Standards.SBI2008, "92001"), (Standards.NACE2, "92.00")),
        ((Standards.SBI2008, "92009"), (Standards.NACE2, "92.00")),
        ((Standards.SBI2008, "93111"), (Standards.NACE2, "93.11")),
        ((Standards.SBI2008, "93112"), (Standards.NACE2, "93.11")),
        ((Standards.SBI2008, "93113"), (Standards.NACE2, "93.11")),
        ((Standards.SBI2008, "93119"), (Standards.NACE2, "93.11")),
        ((Standards.SBI2008, "93121"), (Standards.NACE2, "93.12")),
        ((Standards.SBI2008, "93122"), (Standards.NACE2, "93.12")),
        ((Standards.SBI2008, "93123"), (Standards.NACE2, "93.12")),
        ((Standards.SBI2008, "93124"), (Standards.NACE2, "93.12")),
        ((Standards.SBI2008, "93125"), (Standards.NACE2, "93.12")),
        ((Standards.SBI2008, "93126"), (Standards.NACE2, "93.12")),
        ((Standards.SBI2008, "93127"), (Standards.NACE2, "93.12")),
        ((Standards.SBI2008, "93128"), (Standards.NACE2, "93.12")),
        ((Standards.SBI2008, "93129"), (Standards.NACE2, "93.12")),
        ((Standards.SBI2008, "9313"), (Standards.NACE2, "93.13")),
        ((Standards.SBI2008, "93191"), (Standards.NACE2, "93.19")),
        ((Standards.SBI2008, "93192"), (Standards.NACE2, "93.19")),
        ((Standards.SBI2008, "93193"), (Standards.NACE2, "93.19")),
        ((Standards.SBI2008, "93194"), (Standards.NACE2, "93.19")),
        ((Standards.SBI2008, "93195"), (Standards.NACE2, "93.19")),
        ((Standards.SBI2008, "93196"), (Standards.NACE2, "93.19")),
        ((Standards.SBI2008, "93199"), (Standards.NACE2, "93.19")),
        ((Standards.SBI2008, "93211"), (Standards.NACE2, "93.21")),
        ((Standards.SBI2008, "93212"), (Standards.NACE2, "93.21")),
        ((Standards.SBI2008, "93291"), (Standards.NACE2, "93.29")),
        ((Standards.SBI2008, "93299"), (Standards.NACE2, "93.29")),
        ((Standards.SBI2008, "9411"), (Standards.NACE2, "94.11")),
        ((Standards.SBI2008, "9412"), (Standards.NACE2, "94.12")),
        ((Standards.SBI2008, "9420"), (Standards.NACE2, "94.20")),
        ((Standards.SBI2008, "94911"), (Standards.NACE2, "94.91")),
        ((Standards.SBI2008, "94919"), (Standards.NACE2, "94.91")),
        ((Standards.SBI2008, "9492"), (Standards.NACE2, "94.92")),
        ((Standards.SBI2008, "94991"), (Standards.NACE2, "94.99")),
        ((Standards.SBI2008, "94992"), (Standards.NACE2, "94.99")),
        ((Standards.SBI2008, "94993"), (Standards.NACE2, "94.99")),
        ((Standards.SBI2008, "94994"), (Standards.NACE2, "94.99")),
        ((Standards.SBI2008, "94995"), (Standards.NACE2, "94.99")),
        ((Standards.SBI2008, "94996"), (Standards.NACE2, "94.99")),
        ((Standards.SBI2008, "94997"), (Standards.NACE2, "94.99")),
        ((Standards.SBI2008, "9511"), (Standards.NACE2, "95.11")),
        ((Standards.SBI2008, "9512"), (Standards.NACE2, "95.12")),
        ((Standards.SBI2008, "9521"), (Standards.NACE2, "95.21")),
        ((Standards.SBI2008, "9522"), (Standards.NACE2, "95.22")),
        ((Standards.SBI2008, "9523"), (Standards.NACE2, "95.23")),
        ((Standards.SBI2008, "9524"), (Standards.NACE2, "95.24")),
        ((Standards.SBI2008, "9525"), (Standards.NACE2, "95.25")),
        ((Standards.SBI2008, "9529"), (Standards.NACE2, "95.29")),
        ((Standards.SBI2008, "96011"), (Standards.NACE2, "96.01")),
        ((Standards.SBI2008, "96012"), (Standards.NACE2, "96.01")),
        ((Standards.SBI2008, "96013"), (Standards.NACE2, "96.01")),
        ((Standards.SBI2008, "96021"), (Standards.NACE2, "96.02")),
        ((Standards.SBI2008, "96022"), (Standards.NACE2, "96.02")),
        ((Standards.SBI2008, "96031"), (Standards.NACE2, "96.03")),
        ((Standards.SBI2008, "96032"), (Standards.NACE2, "96.03")),
        ((Standards.SBI2008, "9604"), (Standards.NACE2, "96.04")),
        ((Standards.SBI2008, "9609"), (Standards.NACE2, "96.09")),
        ((Standards.SBI2008, "9700"), (Standards.NACE2, "97.00")),
        ((Standards.SBI2008, "9810"), (Standards.NACE2, "98.10")),
        ((Standards.SBI2008, "9820"), (Standards.NACE2, "98.20")),
        ((Standards.SBI2008, "9900"), (Standards.NACE2, "99.00")),
    ],
)
