# -*- coding: utf-8 -*-
"""`SBI2008 Standard, Update 2019 <https://www.kvk.nl/overzicht-standaard-bedrijfsindeling/>`_.
"""
from ...types import Category, Classification, Standard, Standards

SBI2008 = Standard(
    standard=Standards.SBI2008,
    classes=[
        Classification("1", "(Code nog niet vastgesteld)", Category.CLASS),
        Classification("2", "Geen bedrijfsactiviteit(en)", Category.CLASS),
        Classification("111", "Teelt van granen", Category.CLASS),
        Classification("1131", "Teelt van groenten in de volle grond", Category.CLASS),
        Classification("1132", "Teelt van groenten onder glas", Category.CLASS),
        Classification("1133", "Teelt van paddenstoelen", Category.CLASS),
        Classification("1134", "Teelt van aardappels en overige wortel- en knolgewassen", Category.CLASS),
        Classification("116", "Teelt van vezelgewassen", Category.CLASS),
        Classification("1191", "Teelt van snijbloemen en snijheesters in de volle grond", Category.CLASS),
        Classification("1192", "Teelt van snijbloemen en snijheesters onder glas", Category.CLASS),
        Classification("1193", "Teelt van voedergewassen", Category.CLASS),
        Classification("1199", "Teelt van overige eenjarige gewassen (rest)", Category.CLASS),
        Classification("121", "Druiventeelt", Category.CLASS),
        Classification("1241", "Teelt van appels en peren", Category.CLASS),
        Classification("1242", "Teelt van steenvruchten", Category.CLASS),
        Classification("1251", "Teelt van aardbeien in de volle grond", Category.CLASS),
        Classification("1252", "Teelt van aardbeien onder glas", Category.CLASS),
        Classification(
            "1253",
            "Teelt van houtig klein fruit in de volle grond (incl. overige boomvruchten en noten)",
            Category.CLASS,
        ),
        Classification("1254", "Teelt van houtig klein fruit onder glas", Category.CLASS),
        Classification("127", "Teelt van gewassen bestemd voor de vervaardiging van dranken", Category.CLASS),
        Classification("128", "Teelt van specerijgewassen", Category.CLASS),
        Classification("129", "Teelt van overige meerjarige gewassen", Category.CLASS),
        Classification("1301", "Teelt van bloembollen", Category.CLASS),
        Classification("1302", "Teelt van perkplanten in de volle grond", Category.CLASS),
        Classification("1303", "Teelt van perkplanten onder glas", Category.CLASS),
        Classification("1304", "Teelt van potplanten onder glas", Category.CLASS),
        Classification("1305", "Teelt van boomkwekerijgewassen in de volle grond", Category.CLASS),
        Classification("1309", "Teelt van overige sierplanten in de volle grond", Category.CLASS),
        Classification("1411", "Houden van melkvee", Category.CLASS),
        Classification("1412", "Opfokken van jongvee voor de melkveehouderij", Category.CLASS),
        Classification("1421", "Houden van vleeskalveren", Category.CLASS),
        Classification("1422", "Overige vleesveehouderij en zoogkoeienbedrijven", Category.CLASS),
        Classification("143", "Fokken en houden van paarden en ezels", Category.CLASS),
        Classification("1451", "Fokken en houden van schapen", Category.CLASS),
        Classification("1452", "Fokken en houden van geiten", Category.CLASS),
        Classification("1461", "Fokvarkens- vermeerderingsbedrijven", Category.CLASS),
        Classification("1462", "Vleesvarkensbedrijven", Category.CLASS),
        Classification("1463", "Gesloten en deels gesloten varkensbedrijven", Category.CLASS),
        Classification("1471", "Opfokken en/of houden van leghennen", Category.CLASS),
        Classification("1472", "Opfokken en/of houden van vleeskuikens", Category.CLASS),
        Classification("1473", "Opfokken en/of houden van ouderdieren van leghennen en vleeskuikens", Category.CLASS),
        Classification("1479", "Opfokken en/of houden van overig pluimvee", Category.CLASS),
        Classification("1491", "Fokken en houden van edelpelsdieren", Category.CLASS),
        Classification("1499", "Fokken en houden van overige dieren", Category.CLASS),
        Classification(
            "150", "Akker- en/of tuinbouw in combinatie met het fokken en houden van dieren", Category.CLASS
        ),
        Classification("161", "Dienstverlening voor de akker- en/of tuinbouw", Category.CLASS),
        Classification("162", "Dienstverlening voor het fokken en houden van dieren", Category.CLASS),
        Classification("163", "Behandeling van gewassen na de oogst", Category.CLASS),
        Classification("164", "Behandeling van zaden voor vermeerdering", Category.CLASS),
        Classification("170", "Jacht", Category.CLASS),
        Classification("210", "Bosbouw", Category.CLASS),
        Classification("220", "Exploitatie van bossen", Category.CLASS),
        Classification("240", "Dienstverlening voor de bosbouw", Category.CLASS),
        Classification("311", "Zee- en kustvisserij", Category.CLASS),
        Classification("312", "Binnenvisserij", Category.CLASS),
        Classification("321", "Kweken van zeevis en -schaaldieren", Category.CLASS),
        Classification("322", "Kweken van zoetwatervis en -schaaldieren", Category.CLASS),
        Classification("610", "Winning van aardolie", Category.CLASS),
        Classification("620", "Winning van aardgas", Category.CLASS),
        Classification("812", "Winning van zand", Category.CLASS),
        Classification("892", "Winning van turf", Category.CLASS),
        Classification("893", "Winning van zout", Category.CLASS),
        Classification("899", "Winning van overige delfstoffen (rest)", Category.CLASS),
        Classification("910", "Dienstverlening voor de winning van aardolie en aardgas", Category.CLASS),
        Classification("990", "Dienstverlening voor de winning van delfstoffen (geen olie en gas)", Category.CLASS),
        Classification("1011", "Slachterijen (geen pluimvee-)", Category.CLASS),
        Classification("1012", "Pluimveeslachterijen", Category.CLASS),
        Classification("1013", "Vleesverwerking (niet tot maaltijden)", Category.CLASS),
        Classification("1020", "Visverwerking", Category.CLASS),
        Classification("1031", "Vervaardiging van aardappelproducten", Category.CLASS),
        Classification("1032", "Vervaardiging van fruit- en groentesap", Category.CLASS),
        Classification("1039", "Verwerking van groente en fruit (niet tot sap en maaltijden)", Category.CLASS),
        Classification(
            "1041",
            "Vervaardiging van plantaardige en dierlijke oliën en vetten (geen margarine en andere spijsvetten)",
            Category.CLASS,
        ),
        Classification("1042", "Vervaardiging van margarine en overige spijsvetten", Category.CLASS),
        Classification("1051", "Vervaardiging van zuivelproducten (geen consumptie-ijs)", Category.CLASS),
        Classification("1052", "Vervaardiging van consumptie-ijs", Category.CLASS),
        Classification("1061", "Vervaardiging van meel (geen zetmeel)", Category.CLASS),
        Classification("1062", "Vervaardiging van zetmeel en zetmeelproducten", Category.CLASS),
        Classification("1071", "Vervaardiging van brood en vers banketbakkerswerk", Category.CLASS),
        Classification(
            "1072", "Vervaardiging van beschuit en koekjes en ander houdbaar banketbakkerswerk", Category.CLASS
        ),
        Classification("1073", "Vervaardiging van deegwaren", Category.CLASS),
        Classification("1081", "Vervaardiging van suiker", Category.CLASS),
        Classification("10821", "Verwerking van cacao", Category.CLASS),
        Classification("10822", "Vervaardiging van chocolade en suikerwerk", Category.CLASS),
        Classification("1083", "Verwerking van koffie en thee", Category.CLASS),
        Classification("1084", "Vervaardiging van specerijen", Category.CLASS),
        Classification("1085", "Vervaardiging van kant-en-klaarmaaltijden en snacks", Category.CLASS),
        Classification("1086", "Vervaardiging van gehomogeniseerde voedingspreparaten en dieetvoeding", Category.CLASS),
        Classification("1089", "Vervaardiging van overige voedingsmiddelen (rest)", Category.CLASS),
        Classification("1091", "Vervaardiging van veevoeders", Category.CLASS),
        Classification("1092", "Vervaardiging van voeders voor huisdieren", Category.CLASS),
        Classification("1101", "Vervaardiging van sterk alcoholische dranken door distilleren", Category.CLASS),
        Classification("1102", "Vervaardiging van wijn uit druiven", Category.CLASS),
        Classification("1103", "Vervaardiging van cider en van overige vruchtenwijnen", Category.CLASS),
        Classification("1104", "Vervaardiging van overige niet-gedistilleerde gegiste dranken", Category.CLASS),
        Classification("1105", "Vervaardiging van bier", Category.CLASS),
        Classification("1106", "Mouterijen", Category.CLASS),
        Classification("1107", "Vervaardiging van frisdranken", Category.CLASS),
        Classification("1200", "Vervaardiging van tabaksproducten", Category.CLASS),
        Classification("1310", "Bewerken en spinnen van textielvezels", Category.CLASS),
        Classification("1320", "Weven van textiel", Category.CLASS),
        Classification("1330", "Textielveredeling", Category.CLASS),
        Classification("1391", "Vervaardiging van gebreide en gehaakte stoffen", Category.CLASS),
        Classification(
            "1392", "Vervaardiging van geconfectioneerde artikelen van textiel (geen kleding)", Category.CLASS
        ),
        Classification("1393", "Vervaardiging van vloerkleden en tapijt", Category.CLASS),
        Classification("1394", "Vervaardiging van koord", Category.CLASS),
        Classification(
            "1395", "Vervaardiging van gebonden textielvlies en artikelen daarvan (geen kleding)", Category.CLASS
        ),
        Classification("1396", "Vervaardiging van technisch en industrieel textiel", Category.CLASS),
        Classification("1399", "Vervaardiging van overige textielproducten (rest)", Category.CLASS),
        Classification("1411", "Vervaardiging van kleding van leer", Category.CLASS),
        Classification("1412", "Vervaardiging van werkkleding", Category.CLASS),
        Classification("1413", "Vervaardiging van overige bovenkleding", Category.CLASS),
        Classification("1414", "Vervaardiging van onderkleding", Category.CLASS),
        Classification("1419", "Vervaardiging van baby- en sportkleding en kledingaccessoires", Category.CLASS),
        Classification("1420", "Vervaardiging van artikelen van bont", Category.CLASS),
        Classification("1431", "Vervaardiging van gebreide en gehaakte kousen en sokken", Category.CLASS),
        Classification(
            "1439", "Vervaardiging van gebreide en gehaakte kleding (geen kousen en sokken)", Category.CLASS
        ),
        Classification("1511", "Looien en bewerken van leer", Category.CLASS),
        Classification("1512", "Vervaardiging van koffers", Category.CLASS),
        Classification("1520", "Vervaardiging van schoenen", Category.CLASS),
        Classification("16101", "Zagen en schaven en overige primaire houtbewerking", Category.CLASS),
        Classification("16102", "Verduurzamen van hout", Category.CLASS),
        Classification("1621", "Vervaardiging van fineer en plaatmateriaal op basis van hout", Category.CLASS),
        Classification("1622", "Vervaardiging van panelen voor parketvloeren", Category.CLASS),
        Classification("16231", "Vervaardiging van deuren", Category.CLASS),
        Classification("16239", "Vervaardiging van overig timmerwerk voor de bouw (geen deuren", Category.CLASS),
        Classification("1624", "Vervaardiging van houten emballage", Category.CLASS),
        Classification(
            "1629", "Vervaardiging van overige artikelen van hout en van artikelen van kurk", Category.CLASS
        ),
        Classification("1711", "Vervaardiging van papierpulp", Category.CLASS),
        Classification("17121", "Vervaardiging van grafisch papier en karton", Category.CLASS),
        Classification("17122", "Vervaardiging van papier en karton voor verpakking", Category.CLASS),
        Classification(
            "17129", "Vervaardiging van papier en karton (geen grafisch en niet voor verpakking)", Category.CLASS
        ),
        Classification("17211", "Vervaardiging van verpakkingsmiddelen van papier en karton", Category.CLASS),
        Classification("17212", "Vervaardiging van golfpapier en -karton", Category.CLASS),
        Classification("1722", "Vervaardiging van huishoudelijke en sanitaire papierwaren", Category.CLASS),
        Classification("1723", "Vervaardiging van kantoorbenodigdheden van papier", Category.CLASS),
        Classification("1724", "Vervaardiging van behangselpapier", Category.CLASS),
        Classification("1729", "Vervaardiging van overige papier- en kartonwaren", Category.CLASS),
        Classification("1811", "Drukkerijen van dagbladen", Category.CLASS),
        Classification("18121", "Drukkerijen van boeken e.d.", Category.CLASS),
        Classification("18122", "Drukkerijen van tijdschriften", Category.CLASS),
        Classification("18123", "Drukkerijen van reclame", Category.CLASS),
        Classification("18124", "Drukkerijen van verpakkingen", Category.CLASS),
        Classification("18125", "Drukkerijen van formulieren", Category.CLASS),
        Classification("18129", "Overige drukkerijen (rest)", Category.CLASS),
        Classification("1813", "Prepress- en premedia-activiteiten", Category.CLASS),
        Classification("1814", "Grafische afwerking en overige activiteiten verwant aan de drukkerij", Category.CLASS),
        Classification("1820", "Reproductie van opgenomen media", Category.CLASS),
        Classification("1910", "Vervaardiging van cokesovenproducten", Category.CLASS),
        Classification("19201", "Aardolieraffinage", Category.CLASS),
        Classification("19202", "Aardolieverwerking (geen -raffinage)", Category.CLASS),
        Classification("2011", "Vervaardiging van industriële gassen", Category.CLASS),
        Classification("2012", "Vervaardiging van kleur- en verfstoffen", Category.CLASS),
        Classification("2013", "Vervaardiging van overige anorganische basischemicaliën", Category.CLASS),
        Classification("20141", "Vervaardiging van petrochemische producten", Category.CLASS),
        Classification(
            "20149",
            "Vervaardiging van overige organische basischemicaliën (geen petrochemische producten)",
            Category.CLASS,
        ),
        Classification("2015", "Vervaardiging van kunstmeststoffen en stikstofverbindingen", Category.CLASS),
        Classification("2016", "Vervaardiging van kunststof in primaire vorm", Category.CLASS),
        Classification("2017", "Vervaardiging van synthetische rubber in primaire vorm", Category.CLASS),
        Classification("2020", "Vervaardiging van verdelgingsmiddelen en overige landbouwchemicaliën", Category.CLASS),
        Classification("2030", "Vervaardiging van verf", Category.CLASS),
        Classification("2041", "Vervaardiging van zeep", Category.CLASS),
        Classification("2042", "Vervaardiging van parfums en cosmetica", Category.CLASS),
        Classification("2051", "Vervaardiging van kruit en springstoffen en van lucifers", Category.CLASS),
        Classification("2052", "Vervaardiging van lijm en bereide kleefmiddelen", Category.CLASS),
        Classification("2053", "Vervaardiging van etherische oliën", Category.CLASS),
        Classification("2059", "Vervaardiging van overige chemische producten (rest)", Category.CLASS),
        Classification("2060", "Vervaardiging van synthetische en kunstmatige vezels", Category.CLASS),
        Classification("2110", "Vervaardiging van farmaceutische grondstoffen", Category.CLASS),
        Classification("2120", "Vervaardiging van farmaceutische producten (geen grondstoffen)", Category.CLASS),
        Classification("2211", "Vervaardiging van rubberbanden en loopvlakvernieuwing", Category.CLASS),
        Classification("2219", "Vervaardiging van producten van rubber (geen banden)", Category.CLASS),
        Classification("2221", "Vervaardiging van platen", Category.CLASS),
        Classification("2222", "Vervaardiging van verpakkingsmiddelen van kunststof", Category.CLASS),
        Classification("2223", "Vervaardiging van kunststofproducten voor de bouw", Category.CLASS),
        Classification("2229", "Vervaardiging van overige producten van kunststof", Category.CLASS),
        Classification("2311", "Vervaardiging van vlakglas", Category.CLASS),
        Classification("2312", "Vormen en bewerken van vlakglas", Category.CLASS),
        Classification("2313", "Vervaardiging van holglas", Category.CLASS),
        Classification("2314", "Vervaardiging van glasvezels", Category.CLASS),
        Classification("2319", "Vervaardiging en bewerking van overig glas", Category.CLASS),
        Classification("2320", "Vervaardiging van vuurvaste keramische producten", Category.CLASS),
        Classification("2331", "Vervaardiging van keramische tegels en plavuizen", Category.CLASS),
        Classification(
            "2332", "Vervaardiging van keramische producten voor de bouw (geen tegels en plavuizen)", Category.CLASS
        ),
        Classification("2341", "Vervaardiging van huishoudelijk en sieraardewerk", Category.CLASS),
        Classification("2342", "Vervaardiging van sanitair aardewerk", Category.CLASS),
        Classification(
            "2343", "Vervaardiging van isolatoren en isolatiemateriaal van keramische stoffen", Category.CLASS
        ),
        Classification("2344", "Vervaardiging van overig technisch aardewerk", Category.CLASS),
        Classification("2349", "Vervaardiging van overige keramische producten (rest)", Category.CLASS),
        Classification("2351", "Vervaardiging van cement", Category.CLASS),
        Classification("2352", "Vervaardiging van kalk en gips", Category.CLASS),
        Classification("23611", "Vervaardiging van producten van beton voor de bouw", Category.CLASS),
        Classification("23612", "Vervaardiging van kalkzandsteen", Category.CLASS),
        Classification("2362", "Vervaardiging van producten van gips voor de bouw", Category.CLASS),
        Classification("2363", "Vervaardiging van stortklare beton", Category.CLASS),
        Classification("2364", "Vervaardiging van mortel in droge vorm", Category.CLASS),
        Classification("2365", "Vervaardiging van producten van vezelcement", Category.CLASS),
        Classification("2369", "Vervaardiging van overige producten van beton", Category.CLASS),
        Classification("2370", "Natuursteenbewerking", Category.CLASS),
        Classification("2391", "Vervaardiging van schuur-", Category.CLASS),
        Classification(
            "2399", "Vervaardiging van overige niet-metaalhoudende minerale producten (geen schuur-", Category.CLASS
        ),
        Classification("2410", "Vervaardiging van ijzer en staal en van ferrolegeringen", Category.CLASS),
        Classification("2420", "Vervaardiging van stalen buizen", Category.CLASS),
        Classification("2431", "Koudtrekken van staven", Category.CLASS),
        Classification("2432", "Koudwalsen van bandstaal", Category.CLASS),
        Classification("2433", "Koudvervormen en koudfelsen", Category.CLASS),
        Classification("2434", "Koudtrekken van draad", Category.CLASS),
        Classification("2441", "Vervaardiging van edelmetalen", Category.CLASS),
        Classification("2442", "Vervaardiging van aluminium", Category.CLASS),
        Classification("2443", "Vervaardiging van lood", Category.CLASS),
        Classification("2444", "Vervaardiging van koper", Category.CLASS),
        Classification("2445", "Vervaardiging van overige non-ferrometalen", Category.CLASS),
        Classification("2446", "Smelten en raffineren van uranium", Category.CLASS),
        Classification("2451", "Gieten van ijzer", Category.CLASS),
        Classification("2452", "Gieten van staal", Category.CLASS),
        Classification("2453", "Gieten van lichte metalen", Category.CLASS),
        Classification("2454", "Gieten van overige non-ferrometalen", Category.CLASS),
        Classification("2511", "Vervaardiging van metalen constructiewerken en delen daarvan", Category.CLASS),
        Classification("2512", "Vervaardiging van metalen deuren", Category.CLASS),
        Classification("2521", "Vervaardiging van ketels en radiatoren voor centrale verwarming", Category.CLASS),
        Classification("2529", "Vervaardiging van metalen tanks en reservoirs", Category.CLASS),
        Classification("2530", "Vervaardiging van stoomketels (geen ketels voor centrale verwarming)", Category.CLASS),
        Classification("2540", "Vervaardiging van wapens en munitie", Category.CLASS),
        Classification("2550", "Smeden", Category.CLASS),
        Classification("2561", "Oppervlaktebehandeling en bekleding van metaal", Category.CLASS),
        Classification("2562", "Algemene metaalbewerking", Category.CLASS),
        Classification("2571", "Vervaardiging van scharen", Category.CLASS),
        Classification("2572", "Vervaardiging van hang- en sluitwerk", Category.CLASS),
        Classification("2573", "Vervaardiging van gereedschap", Category.CLASS),
        Classification("2591", "Vervaardiging van stalen vaten e.d.", Category.CLASS),
        Classification("2592", "Vervaardiging van verpakkingsmiddelen van licht metaal", Category.CLASS),
        Classification("2593", "Vervaardiging van artikelen van draad en van kettingen en veren", Category.CLASS),
        Classification("2594", "Vervaardiging van bouten", Category.CLASS),
        Classification("2599", "Vervaardiging van overige producten van metaal (rest)", Category.CLASS),
        Classification("2611", "Vervaardiging van elektronische componenten", Category.CLASS),
        Classification("2612", "Vervaardiging van elektronische printplaten", Category.CLASS),
        Classification("2620", "Vervaardiging van computers en randapparatuur", Category.CLASS),
        Classification("2630", "Vervaardiging van communicatieapparatuur", Category.CLASS),
        Classification("2640", "Vervaardiging van consumentenelektronica", Category.CLASS),
        Classification("2651", "Vervaardiging van meet-", Category.CLASS),
        Classification("2652", "Vervaardiging van uurwerken", Category.CLASS),
        Classification(
            "2660",
            "Vervaardiging van bestralingsapparatuur en van elektromedische en elektrotherapeutische apparatuur",
            Category.CLASS,
        ),
        Classification("2670", "Vervaardiging van optische instrumenten en apparatuur", Category.CLASS),
        Classification("2680", "Vervaardiging van informatiedragers", Category.CLASS),
        Classification("2711", "Vervaardiging van elektromotoren", Category.CLASS),
        Classification("2712", "Vervaardiging van schakel- en verdeelinrichtingen", Category.CLASS),
        Classification("2720", "Vervaardiging van batterijen en accumulatoren", Category.CLASS),
        Classification("2731", "Vervaardiging van kabels van optische vezels", Category.CLASS),
        Classification("2732", "Vervaardiging van overige elektrische en elektronische kabel", Category.CLASS),
        Classification("2733", "Vervaardiging van schakelaars", Category.CLASS),
        Classification("2740", "Vervaardiging van elektrische lampen en verlichtingsapparaten", Category.CLASS),
        Classification("2751", "Vervaardiging van elektrische huishoudapparaten", Category.CLASS),
        Classification("2752", "Vervaardiging van niet-elektrische huishoudapparaten", Category.CLASS),
        Classification("2790", "Vervaardiging van overige elektrische apparatuur", Category.CLASS),
        Classification("2811", "Vervaardiging van motoren en turbines (niet voor vliegtuigen", Category.CLASS),
        Classification("2812", "Vervaardiging van hydraulische apparatuur", Category.CLASS),
        Classification("2813", "Vervaardiging van niet-hydraulische pompen en compressoren", Category.CLASS),
        Classification("2814", "Vervaardiging van appendages", Category.CLASS),
        Classification("2815", "Vervaardiging van tandwielen", Category.CLASS),
        Classification("2821", "Vervaardiging van industriële ovens en branders", Category.CLASS),
        Classification("2822", "Vervaardiging van hijs-", Category.CLASS),
        Classification(
            "2823",
            "Vervaardiging van kantoormachines en -apparatuur (geen computers en randapparatuur)",
            Category.CLASS,
        ),
        Classification("2824", "Vervaardiging van pneumatisch en elektrisch handgereedschap", Category.CLASS),
        Classification(
            "2825",
            "Vervaardiging van machines en apparaten voor industriële koeltechniek en klimaatregeling",
            Category.CLASS,
        ),
        Classification(
            "2829", "Vervaardiging van overige machines en apparaten voor algemeen gebruik (rest)", Category.CLASS
        ),
        Classification("2830", "Vervaardiging van machines en werktuigen voor de land- en bosbouw", Category.CLASS),
        Classification("2841", "Vervaardiging van gereedschapswerktuigen voor metaalbewerking", Category.CLASS),
        Classification("2849", "Vervaardiging van gereedschapswerktuigen niet voor metaalbewerking", Category.CLASS),
        Classification("2891", "Vervaardiging van machines voor de metallurgie", Category.CLASS),
        Classification("2892", "Vervaardiging van machines voor de bouw en winning van delfstoffen", Category.CLASS),
        Classification(
            "2893", "Vervaardiging van machines voor de productie van voedings- en genotmiddelen", Category.CLASS
        ),
        Classification("2894", "Vervaardiging van machines voor de productie van textiel", Category.CLASS),
        Classification("2895", "Vervaardiging van machines voor de productie van papier en karton", Category.CLASS),
        Classification("2896", "Vervaardiging van machines voor de kunststof- en rubberindustrie", Category.CLASS),
        Classification("2899", "Vervaardiging van overige machines", Category.CLASS),
        Classification("2910", "Vervaardiging van auto's", Category.CLASS),
        Classification("29201", "Carrosseriebouw", Category.CLASS),
        Classification("29202", "Vervaardiging van aanhangwagens en opleggers", Category.CLASS),
        Classification(
            "2931",
            "Vervaardiging van elektrische en elektronische onderdelen en toebehoren voor auto's",
            Category.CLASS,
        ),
        Classification(
            "2932",
            "Vervaardiging van niet-elektrische en -elektronische onderdelen en toebehoren voor auto's",
            Category.CLASS,
        ),
        Classification(
            "3011", "Bouw van schepen en drijvend materieel (geen sport- en recreatievaartuigen)", Category.CLASS
        ),
        Classification("3012", "Bouw van sport- en recreatievaartuigen", Category.CLASS),
        Classification("3020", "Vervaardiging van rollend spoor- en tramwegmaterieel", Category.CLASS),
        Classification("3030", "Vervaardiging van vliegtuigen en onderdelen daarvoor", Category.CLASS),
        Classification("3040", "Vervaardiging van militaire gevechtsvoertuigen", Category.CLASS),
        Classification("3091", "Vervaardiging van motor- en bromfietsen", Category.CLASS),
        Classification("3092", "Vervaardiging van fietsen en invalidenwagens", Category.CLASS),
        Classification("3099", "Vervaardiging van overige transportmiddelen (rest)", Category.CLASS),
        Classification("31011", "Interieurbouw", Category.CLASS),
        Classification("31012", "Vervaardiging van bedrijfsmeubels", Category.CLASS),
        Classification("3102", "Vervaardiging van keukenmeubels", Category.CLASS),
        Classification("3103", "Vervaardiging van matrassen", Category.CLASS),
        Classification("3109", "Vervaardiging van overige meubels", Category.CLASS),
        Classification("3211", "Slaan van munten en medailles", Category.CLASS),
        Classification(
            "3212", "Bewerken van edelstenen en vervaardiging van sieraden e.d. (geen imitatie)", Category.CLASS
        ),
        Classification("3213", "Vervaardiging van imitatiesieraden", Category.CLASS),
        Classification("3220", "Vervaardiging van muziekinstrumenten", Category.CLASS),
        Classification("3230", "Vervaardiging van sportartikelen", Category.CLASS),
        Classification("3240", "Vervaardiging van speelgoed en spellen", Category.CLASS),
        Classification("32501", "Tandtechnische bedrijven", Category.CLASS),
        Classification(
            "32502", "Vervaardiging van medische instrumenten en hulpmiddelen (geen tandtechniek)", Category.CLASS
        ),
        Classification("3291", "Vervaardiging van borstelwaren", Category.CLASS),
        Classification("32991", "Sociale werkvoorziening", Category.CLASS),
        Classification("32999", "Vervaardiging van overige goederen (rest)", Category.CLASS),
        Classification("3311", "Reparatie van producten van metaal", Category.CLASS),
        Classification(
            "33121",
            "Reparatie en onderhoud van machines voor algemeen gebruik en machine-onderdelen (geen gereedschap)",
            Category.CLASS,
        ),
        Classification(
            "33122",
            "Reparatie en onderhoud van pneumatisch en elektrisch gereedschap en gereedschapswerktuigen",
            Category.CLASS,
        ),
        Classification("33123", "Reparatie en onderhoud van machines voor een specifieke bedrijfstak", Category.CLASS),
        Classification("3313", "Reparatie van elektronische en optische apparatuur", Category.CLASS),
        Classification("3314", "Reparatie van elektrische apparatuur", Category.CLASS),
        Classification("3315", "Reparatie en onderhoud van schepen", Category.CLASS),
        Classification("3316", "Reparatie en onderhoud van vliegtuigen", Category.CLASS),
        Classification("3317", "Reparatie en onderhoud van overige transportmiddelen", Category.CLASS),
        Classification("3319", "Reparatie van overige apparatuur", Category.CLASS),
        Classification("3321", "Installatie van ketels en tanks", Category.CLASS),
        Classification("33221", "Installatie van machines voor algemeen gebruik (geen gereedschap)", Category.CLASS),
        Classification(
            "33222", "Installatie van pneumatisch en elektrisch gereedschap en gereedschapswerktuigen", Category.CLASS
        ),
        Classification("33223", "Installatie van machines voor een specifieke bedrijfstak", Category.CLASS),
        Classification("3323", "Installatie van elektronische en optische apparatuur", Category.CLASS),
        Classification("3324", "Installatie van elektrische apparatuur", Category.CLASS),
        Classification("3329", "Installatie van overige toebehoren", Category.CLASS),
        Classification("35111", "Productie van elektriciteit door thermische", Category.CLASS),
        Classification("35112", "Productie van elektriciteit door windenergie", Category.CLASS),
        Classification("35113", "Productie van elektriciteit door zonnecellen", Category.CLASS),
        Classification("3512", "Beheer en exploitatie van transportnetten voor elektriciteit", Category.CLASS),
        Classification(
            "3513", "Distributie van elektriciteit en gasvormige brandstoffen via leidingen", Category.CLASS
        ),
        Classification("3514", "Handel in elektriciteit en in gas via leidingen", Category.CLASS),
        Classification("3520", "Productie van biogas", Category.CLASS),
        Classification("3530", "Productie en distributie van stoom en gekoelde lucht", Category.CLASS),
        Classification("3600", "Winning en distributie van water", Category.CLASS),
        Classification("3700", "Afvalwaterinzameling en -behandeling", Category.CLASS),
        Classification("3811", "Inzameling van onschadelijk afval", Category.CLASS),
        Classification("3812", "Inzameling van schadelijk afval", Category.CLASS),
        Classification("3821", "Behandeling van onschadelijk afval", Category.CLASS),
        Classification("3822", "Behandeling van schadelijk afval", Category.CLASS),
        Classification("3831", "Sloop van schepen", Category.CLASS),
        Classification("3832", "Gesorteerd materiaal voorbereiden tot recycling", Category.CLASS),
        Classification("3900", "Sanering en overig afvalbeheer", Category.CLASS),
        Classification("4110", "Projectontwikkeling", Category.CLASS),
        Classification("4120", "Algemene burgerlijke en utiliteitsbouw", Category.CLASS),
        Classification("42111", "Wegenbouw", Category.CLASS),
        Classification("42112", "Stratenmaken", Category.CLASS),
        Classification("4212", "Bouw van boven- en ondergrondse spoorwegen", Category.CLASS),
        Classification("4213", "Bouw van kunstwerken", Category.CLASS),
        Classification("4221", "Leggen van rioleringen", Category.CLASS),
        Classification("4222", "Leggen van elektriciteits- en telecommunicatiekabels", Category.CLASS),
        Classification("4291", "Natte waterbouw", Category.CLASS),
        Classification("4299", "Bouw van overige civieltechnische werken (rest)", Category.CLASS),
        Classification("4311", "Slopen van bouwwerken", Category.CLASS),
        Classification("4312", "Grondverzet", Category.CLASS),
        Classification("4313", "Proefboren", Category.CLASS),
        Classification("4321", "Elektrotechnische bouwinstallatie", Category.CLASS),
        Classification("43221", "Loodgieters- en fitterswerk", Category.CLASS),
        Classification("43222", "Installatie van verwarmings- en luchtbehandelingsapparatuur", Category.CLASS),
        Classification("4329", "Overige bouwinstallatie", Category.CLASS),
        Classification("4331", "Stukadoren", Category.CLASS),
        Classification("4332", "Bouwtimmeren", Category.CLASS),
        Classification("4333", "Afwerking van vloeren en wanden", Category.CLASS),
        Classification("4334", "Schilderen en glaszetten", Category.CLASS),
        Classification("4339", "Overige afwerking van gebouwen", Category.CLASS),
        Classification("4391", "Dakdekken en bouwen van dakconstructies", Category.CLASS),
        Classification("43991", "Heien en andere funderingswerkzaamheden", Category.CLASS),
        Classification("43992", "Vlechten van betonstaal", Category.CLASS),
        Classification("43993", "Metselen en voegen", Category.CLASS),
        Classification("43999", "Overige gespecialiseerde werkzaamheden in de bouw (rest)", Category.CLASS),
        Classification("45111", "Import van nieuwe personenauto's en lichte bedrijfsauto's", Category.CLASS),
        Classification(
            "45112",
            "Handel in en reparatie van personenauto's en lichte bedrijfsauto's (geen import van nieuwe)",
            Category.CLASS,
        ),
        Classification("45191", "Import van nieuwe bedrijfsauto's", Category.CLASS),
        Classification(
            "45192", "Handel in en reparatie van zwaardere bedrijfsauto's (geen import van nieuwe)", Category.CLASS
        ),
        Classification(
            "45193", "Handel in en reparatie van aanhangwagens en opleggers (geen caravans)", Category.CLASS
        ),
        Classification("45194", "Handel in en reparatie van caravans", Category.CLASS),
        Classification("45201", "Auto-onderdelenservicebedrijven", Category.CLASS),
        Classification("45202", "Bandenservicebedrijven", Category.CLASS),
        Classification("45203", "Reparatie van specifieke auto-onderdelen", Category.CLASS),
        Classification("45204", "Carrosserieherstel", Category.CLASS),
        Classification("45205", "Overige gespecialiseerde reparatie en slepen van auto's", Category.CLASS),
        Classification(
            "45311",
            "Groothandel en handelsbemiddeling in auto-onderdelen en -accessoires (geen banden)",
            Category.CLASS,
        ),
        Classification("45312", "Groothandel en handelsbemiddeling in banden", Category.CLASS),
        Classification("4532", "Detailhandel in auto-onderdelen en -accessoires", Category.CLASS),
        Classification(
            "45401", "Groothandel en handelsbemiddeling in motorfietsen en onderdelen daarvan", Category.CLASS
        ),
        Classification("45402", "Detailhandel in en reparatie van motorfietsen en onderdelen daarvan", Category.CLASS),
        Classification("4611", "Handelsbemiddeling in landbouwproducten", Category.CLASS),
        Classification("4612", "Handelsbemiddeling in brandstoffen", Category.CLASS),
        Classification("4613", "Handelsbemiddeling in hout", Category.CLASS),
        Classification("4614", "Handelsbemiddeling in machines", Category.CLASS),
        Classification("4615", "Handelsbemiddeling in meubels", Category.CLASS),
        Classification("4616", "Handelsbemiddeling in textiel", Category.CLASS),
        Classification("4617", "Handelsbemiddeling in voedings- en genotmiddelen", Category.CLASS),
        Classification("4618", "Handelsbemiddeling gespecialiseerd in overige goederen", Category.CLASS),
        Classification("4619", "Niet-gespecialiseerde handelsbemiddeling", Category.CLASS),
        Classification("46211", "Groothandel in granen", Category.CLASS),
        Classification("46212", "Groothandel in zaden", Category.CLASS),
        Classification("46213", "Groothandel in hooi", Category.CLASS),
        Classification("46214", "Groothandel in meng- en krachtvoeder", Category.CLASS),
        Classification("46215", "Groothandel in veevoeder (geen ruw-", Category.CLASS),
        Classification(
            "46216",
            "Groothandel in ruwe plantaardige en dierlijke oliën en vetten en oliehoudende grondstoffen",
            Category.CLASS,
        ),
        Classification("46217", "Groothandel in ruwe tabak", Category.CLASS),
        Classification("46218", "Groothandel in akkerbouwproducten en veevoeder algemeen assortiment", Category.CLASS),
        Classification("46219", "Groothandel in overige akkerbouwproducten", Category.CLASS),
        Classification("4622", "Groothandel in bloemen en planten", Category.CLASS),
        Classification("46231", "Groothandel in levend vee", Category.CLASS),
        Classification("46232", "Groothandel in huisdieren", Category.CLASS),
        Classification("46241", "Groothandel in huiden en vellen", Category.CLASS),
        Classification("46242", "Groothandel in leer en halffabrikaten van leer", Category.CLASS),
        Classification("46311", "Groothandel in groenten en fruit", Category.CLASS),
        Classification("46312", "Groothandel in consumptie-aardappelen", Category.CLASS),
        Classification(
            "4632", "Groothandel in vlees en vleeswaren en in wild en gevogelte (niet levend)", Category.CLASS
        ),
        Classification("46331", "Groothandel in zuivelproducten en spijsoliën en -vetten", Category.CLASS),
        Classification("46332", "Groothandel in eieren", Category.CLASS),
        Classification("4634", "Groothandel in dranken (geen zuivel)", Category.CLASS),
        Classification("4635", "Groothandel in tabaksproducten en rokersbenodigdheden", Category.CLASS),
        Classification("4636", "Groothandel in suiker", Category.CLASS),
        Classification("4637", "Groothandel in koffie", Category.CLASS),
        Classification("46381", "Groothandel in snacks", Category.CLASS),
        Classification("46382", "Groothandel in vis", Category.CLASS),
        Classification(
            "46383", "Gespecialiseerde groothandel in overige voedings- en genotmiddelen (rest)", Category.CLASS
        ),
        Classification("46384", "Groothandel in bakkerijgrondstoffen", Category.CLASS),
        Classification(
            "46389",
            "Gespecialiseerde groothandel in overige grondstoffen en halffabrikaten voor de voedingsmiddelenindustrie (rest)",
            Category.CLASS,
        ),
        Classification("4639", "Groothandel in voedings- en genotmiddelen algemeen assortiment", Category.CLASS),
        Classification("46411", "Groothandel in kledingstoffen en fournituren", Category.CLASS),
        Classification("46412", "Groothandel in huishoudtextiel en beddengoed", Category.CLASS),
        Classification("46421", "Groothandel in bovenkleding", Category.CLASS),
        Classification("46422", "Groothandel in werkkleding", Category.CLASS),
        Classification("46423", "Groothandel in onderkleding", Category.CLASS),
        Classification("46424", "Groothandel in schoenen", Category.CLASS),
        Classification("46425", "Groothandel in mode-artikelen", Category.CLASS),
        Classification("46429", "Groothandel in textielwaren algemeen assortiment", Category.CLASS),
        Classification("46431", "Groothandel in witgoed", Category.CLASS),
        Classification("46432", "Groothandel in elektrische huishoudelijke apparatuur (geen witgoed", Category.CLASS),
        Classification("46433", "Groothandel in audio- en video-apparatuur", Category.CLASS),
        Classification("46434", "Groothandel in fotografische artikelen", Category.CLASS),
        Classification("46435", "Groothandel in beeld- en geluidsdragers", Category.CLASS),
        Classification("46436", "Groothandel in optische artikelen", Category.CLASS),
        Classification("46441", "Groothandel in glas", Category.CLASS),
        Classification("46442", "Groothandel in was-", Category.CLASS),
        Classification("4645", "Groothandel in parfums en cosmetica", Category.CLASS),
        Classification("46461", "Groothandel in farmaceutische producten", Category.CLASS),
        Classification("46462", "Groothandel in medische en tandheelkundige instrumenten", Category.CLASS),
        Classification("46471", "Groothandel in huismeubilair", Category.CLASS),
        Classification("46472", "Groothandel in woningtextiel en vloerbedekking", Category.CLASS),
        Classification("46473", "Groothandel in verlichtingsartikelen", Category.CLASS),
        Classification("4648", "Groothandel in juweliersartikelen en uurwerken", Category.CLASS),
        Classification("46491", "Groothandel in fietsen en bromfietsen", Category.CLASS),
        Classification("46492", "Groothandel in watersportartikelen", Category.CLASS),
        Classification("46493", "Groothandel in kampeerartikelen (geen caravans)", Category.CLASS),
        Classification("46494", "Groothandel in speelgoed", Category.CLASS),
        Classification("46495", "Groothandel in muziekinstrumenten", Category.CLASS),
        Classification("46496", "Groothandel in sportartikelen (geen watersport)", Category.CLASS),
        Classification("46497", "Groothandel in papier- en kartonwaren (geen verpakkingsmateriaal)", Category.CLASS),
        Classification("46498", "Groothandel in boeken", Category.CLASS),
        Classification("46499", "Groothandel in overige consumentenartikelen (non-food) (rest)", Category.CLASS),
        Classification("4651", "Groothandel in computers", Category.CLASS),
        Classification(
            "4652",
            "Groothandel in elektronische en telecommunicatieapparatuur en bijbehorende onderdelen",
            Category.CLASS,
        ),
        Classification("4661", "Groothandel in landbouwmachines", Category.CLASS),
        Classification("4662", "Groothandel in gereedschapswerktuigen", Category.CLASS),
        Classification("4663", "Groothandel in machines voor de bouw", Category.CLASS),
        Classification(
            "4664", "Groothandel in machines voor de textielindustrie en in naai- en breimachines", Category.CLASS
        ),
        Classification("4665", "Groothandel in bedrijfsmeubels", Category.CLASS),
        Classification("4666", "Groothandel in kantoormachines (geen computers)", Category.CLASS),
        Classification("46681", "Groothandel in machines voor de grafische industrie", Category.CLASS),
        Classification("46682", "Groothandel in machines voor de voedings- en genotmiddelenindustrie", Category.CLASS),
        Classification("46691", "Groothandel in intern transportmaterieel", Category.CLASS),
        Classification("46692", "Groothandel in machines en apparaten voor de warmte-", Category.CLASS),
        Classification("46693", "Groothandel in verbrandingsmotoren", Category.CLASS),
        Classification("46694", "Groothandel in appendages", Category.CLASS),
        Classification("46695", "Groothandel in meet- en regelapparaten", Category.CLASS),
        Classification("46696", "Groothandel in emballage", Category.CLASS),
        Classification("46697", "Groothandel in scheepsbenodigdheden en visserij-artikelen", Category.CLASS),
        Classification("46699", "Groothandel in overige machines", Category.CLASS),
        Classification("46711", "Groothandel in vaste brandstoffen", Category.CLASS),
        Classification("46712", "Groothandel in vloeibare en gasvormige brandstoffen", Category.CLASS),
        Classification("46713", "Groothandel in minerale olieproducten (geen brandstoffen)", Category.CLASS),
        Classification("46721", "Groothandel in metaalertsen", Category.CLASS),
        Classification("46722", "Groothandel in ferrometalen en -halffabrikaten", Category.CLASS),
        Classification("46723", "Groothandel in non-ferrometalen en -halffabrikaten", Category.CLASS),
        Classification("46731", "Groothandel in hout en plaatmateriaal", Category.CLASS),
        Classification("46732", "Groothandel in verf en verfwaren", Category.CLASS),
        Classification("46733", "Groothandel in behang", Category.CLASS),
        Classification("46734", "Groothandel in vlakglas", Category.CLASS),
        Classification("46735", "Groothandel in zand en grind", Category.CLASS),
        Classification("46736", "Groothandel in tegels en plavuizen", Category.CLASS),
        Classification("46737", "Groothandel in sanitaire artikelen en sanitair installatiemateriaal", Category.CLASS),
        Classification("46738", "Groothandel gespecialiseerd in overige bouwmaterialen", Category.CLASS),
        Classification("46739", "Groothandel in bouwmaterialen algemeen assortiment", Category.CLASS),
        Classification("46741", "Groothandel in ijzer- en metaalwaren", Category.CLASS),
        Classification("46742", "Groothandel in verwarmingsapparaten", Category.CLASS),
        Classification(
            "46751", "Groothandel in chemische grondstoffen en chemicaliën voor industriële toepassing", Category.CLASS
        ),
        Classification("46752", "Groothandel in bestrijdingsmiddelen en kunstmeststoffen", Category.CLASS),
        Classification("46761", "Groothandel in textielgrondstoffen en -halffabrikaten", Category.CLASS),
        Classification("46762", "Groothandel in papier en karton", Category.CLASS),
        Classification("46769", "Groothandel in overige intermediaire producten (rest)", Category.CLASS),
        Classification("46771", "Groothandel in autosloopmateriaal", Category.CLASS),
        Classification("46772", "Groothandel in ijzer- en staalschroot en oude non-ferrometalen", Category.CLASS),
        Classification("46779", "Groothandel in overige oude materialen en afvalstoffen", Category.CLASS),
        Classification("46901", "Niet-gespecialiseerde groothandel in consumentenartikelen", Category.CLASS),
        Classification("46902", "Niet-gespecialiseerde groothandel in niet-consumentenartikelen", Category.CLASS),
        Classification(
            "4711",
            "Supermarkten en dergelijke winkels met een algemeen assortiment voedings- en genotmiddelen",
            Category.CLASS,
        ),
        Classification("47191", "Warenhuizen", Category.CLASS),
        Classification("47192", "Winkels met een algemeen assortiment non-food (geen warenhuizen)", Category.CLASS),
        Classification("4721", "Winkels in aardappelen", Category.CLASS),
        Classification("47221", "Winkels in vlees en vleeswaren", Category.CLASS),
        Classification("47222", "Winkels in wild en gevogelte", Category.CLASS),
        Classification("4723", "Winkels in vis", Category.CLASS),
        Classification("47241", "Winkels in brood en banket", Category.CLASS),
        Classification("47242", "Winkels in chocolade en suikerwerk", Category.CLASS),
        Classification("4725", "Winkels in dranken", Category.CLASS),
        Classification("4726", "Winkels in tabaksproducten", Category.CLASS),
        Classification("47291", "Winkels in kaas", Category.CLASS),
        Classification("47292", "Winkels in natuurvoeding en reformartikelen", Category.CLASS),
        Classification("47293", "Winkels in buitenlandse voedingsmiddelen", Category.CLASS),
        Classification(
            "47299", "Gespecialiseerde winkels in overige voedings- en genotmiddelen (rest)", Category.CLASS
        ),
        Classification("4730", "Benzinestations", Category.CLASS),
        Classification("4741", "Winkels in computers", Category.CLASS),
        Classification("4742", "Winkels in telecommunicatieapparatuur", Category.CLASS),
        Classification("47431", "Winkels in audio- en videoapparatuur", Category.CLASS),
        Classification("47432", "Winkels in een algemeen assortiment van wit- en bruingoed", Category.CLASS),
        Classification("47511", "Winkels in kledingsstoffen", Category.CLASS),
        Classification("47512", "Winkels in huishoudtextiel", Category.CLASS),
        Classification("47513", "Winkels in breiwol", Category.CLASS),
        Classification("47521", "Winkels in ijzerwaren en gereedschappen", Category.CLASS),
        Classification("47522", "Winkels in verf", Category.CLASS),
        Classification("47523", "Winkels in houten bouw- en tuinmaterialen", Category.CLASS),
        Classification("47524", "Winkels in tegels", Category.CLASS),
        Classification("47525", "Winkels in keukens", Category.CLASS),
        Classification("47526", "Winkels in parket-", Category.CLASS),
        Classification("47527", "Winkels gespecialiseerd in overige doe-het-zelfartikelen", Category.CLASS),
        Classification("47528", "Bouwmarkten en andere winkels in bouwmaterialen algemeen assortiment", Category.CLASS),
        Classification("4753", "Winkels in vloerbedekking en gordijnen", Category.CLASS),
        Classification("47541", "Winkels in witgoed", Category.CLASS),
        Classification("47542", "Winkels in naai- en breimachines", Category.CLASS),
        Classification("47543", "Winkels in overige elektrische huishoudelijke apparatuur", Category.CLASS),
        Classification("47544", "Winkels in onderdelen voor elektrische huishoudelijke apparatuur", Category.CLASS),
        Classification("47591", "Winkels in meubels", Category.CLASS),
        Classification("47592", "Winkels in verlichtingsartikelen", Category.CLASS),
        Classification("47593", "Winkels in artikelen voor woninginrichting algemeen assortiment", Category.CLASS),
        Classification("47594", "Winkels in muziekinstrumenten", Category.CLASS),
        Classification("47595", "Winkels in glas-", Category.CLASS),
        Classification("47596", "Winkels gespecialiseerd in overige huishoudelijke artikelen (rest)", Category.CLASS),
        Classification("47597", "Winkels in huishoudelijke artikelen algemeen assortiment", Category.CLASS),
        Classification("4761", "Winkels in boeken", Category.CLASS),
        Classification("4762", "Winkels in kranten", Category.CLASS),
        Classification("4763", "Winkels in audio- en video-opnamen", Category.CLASS),
        Classification("47641", "Winkels in fietsen en bromfietsen", Category.CLASS),
        Classification("47642", "Winkels in watersportartikelen", Category.CLASS),
        Classification("47643", "Winkels in sportartikelen (geen watersport)", Category.CLASS),
        Classification("47644", "Winkels in kampeerartikelen (geen caravans)", Category.CLASS),
        Classification("4765", "Winkels in speelgoed", Category.CLASS),
        Classification("47711", "Winkels in herenkleding", Category.CLASS),
        Classification("47712", "Winkels in dameskleding", Category.CLASS),
        Classification("47713", "Winkels in bovenkleding en mode-artikelen (algemeen assortiment)", Category.CLASS),
        Classification("47714", "Winkels in baby- en kinderkleding", Category.CLASS),
        Classification("47715", "Winkels in babyartikelen algemeen assortiment", Category.CLASS),
        Classification("47716", "Winkels in onderkleding", Category.CLASS),
        Classification("47717", "Winkels in mode-artikelen", Category.CLASS),
        Classification("47718", "Textielsupermarkten", Category.CLASS),
        Classification("47721", "Winkels in schoenen", Category.CLASS),
        Classification("47722", "Winkels in lederwaren en reisartikelen", Category.CLASS),
        Classification("4773", "Apotheken", Category.CLASS),
        Classification("47741", "Winkels in drogisterij-artikelen", Category.CLASS),
        Classification("47742", "Winkels in medische en orthopedische artikelen", Category.CLASS),
        Classification("4775", "Winkels in parfums en cosmetica", Category.CLASS),
        Classification("47761", "Winkels in bloemen en planten", Category.CLASS),
        Classification("47762", "Tuincentra", Category.CLASS),
        Classification("47763", "Winkels in dieren", Category.CLASS),
        Classification("4777", "Winkels in juweliersartikelen en uurwerken", Category.CLASS),
        Classification("47781", "Winkels in fotografische artikelen", Category.CLASS),
        Classification("47782", "Winkels in optische artikelen", Category.CLASS),
        Classification("47783", "Winkels in schilderijen", Category.CLASS),
        Classification("47789", "Winkels gespecialiseerd in overige artikelen (rest)", Category.CLASS),
        Classification("47791", "Winkels in antiek", Category.CLASS),
        Classification("47792", "Winkels in tweedehands kleding", Category.CLASS),
        Classification("47793", "Winkels in tweedehands goederen (geen kleding)", Category.CLASS),
        Classification("47811", "Markthandel in aardappelen", Category.CLASS),
        Classification("47819", "Markthandel in overige voedings- en genotmiddelen", Category.CLASS),
        Classification("4782", "Markthandel in textiel", Category.CLASS),
        Classification("47891", "Markthandel in bloemen", Category.CLASS),
        Classification("47892", "Markthandel in tweedehands goederen", Category.CLASS),
        Classification("47899", "Markthandel in overige goederen", Category.CLASS),
        Classification("4791", "Detailhandel via postorder en internet", Category.CLASS),
        Classification(
            "47911", "Detailhandel via postorder en internet voedingsmiddelen en drogisterijwaren", Category.CLASS
        ),
        Classification("47912", "Detailhandel via postorder en internet in consumentenelektronica", Category.CLASS),
        Classification("47913", "Detailhandel via postorder en internet in boeken", Category.CLASS),
        Classification("47914", "Detailhandel via postorder en internet in kleding en mode-artikelen", Category.CLASS),
        Classification("47915", "Detailhandel via postorder en internet in huis- en tuinartikelen", Category.CLASS),
        Classification("47916", "Detailhandel via postorder en internet in vrijetijdsartikelen", Category.CLASS),
        Classification(
            "47918", "Gespecialiseerde detailhandel via postorder en internet in overige non-food", Category.CLASS
        ),
        Classification(
            "47919", "Detailhandel via postorder en internet in een algemeenassortiment non-food", Category.CLASS
        ),
        Classification("47991", "Colportage", Category.CLASS),
        Classification("47992", "Straathandel", Category.CLASS),
        Classification("47999", "Detailhandel via overige distributievormen", Category.CLASS),
        Classification("4910", "Personenvervoer per spoor (geen tram of metro)", Category.CLASS),
        Classification("4920", "Goederenvervoer per spoor", Category.CLASS),
        Classification("4931", "Openbaar vervoer binnen steden", Category.CLASS),
        Classification("4932", "Vervoer per taxi", Category.CLASS),
        Classification("49391", "Ongeregeld personenvervoer over de weg", Category.CLASS),
        Classification("49392", "Openbaar interlokaal personenvervoer over de weg", Category.CLASS),
        Classification("49393", "Geregeld besloten personenvervoer over de weg", Category.CLASS),
        Classification("4941", "Goederenvervoer over de weg (geen verhuizingen)", Category.CLASS),
        Classification("4942", "Verhuisvervoer", Category.CLASS),
        Classification("4950", "Transport via pijpleidingen", Category.CLASS),
        Classification("5010", "Zee- en kustvaart (passagiersvaart en veerdiensten)", Category.CLASS),
        Classification("50201", "Zee- en kustvaart (vracht- en tankvaart", Category.CLASS),
        Classification("50202", "Zee- en kustsleepvaart", Category.CLASS),
        Classification("5030", "Binnenvaart (passagiersvaart en veerdiensten)", Category.CLASS),
        Classification("50401", "Binnenvaart (vrachtvaart)", Category.CLASS),
        Classification("50402", "Binnenvaart (tankvaart)", Category.CLASS),
        Classification("50403", "Binnenvaart (sleep- en duwvaart)", Category.CLASS),
        Classification("5110", "Personenvervoer door de lucht", Category.CLASS),
        Classification("5121", "Goederenvervoer door de lucht", Category.CLASS),
        Classification("52101", "Opslag in tanks", Category.CLASS),
        Classification("52102", "Opslag in koelhuizen e.d.", Category.CLASS),
        Classification("52109", "Opslag in distributiecentra en overige opslag (niet in tanks", Category.CLASS),
        Classification("5221", "Dienstverlening voor vervoer over land", Category.CLASS),
        Classification("5222", "Dienstverlening voor vervoer over water", Category.CLASS),
        Classification("5223", "Dienstverlening voor de luchtvaart", Category.CLASS),
        Classification("52241", "Laad-", Category.CLASS),
        Classification("52242", "Laad-", Category.CLASS),
        Classification("52291", "Expediteurs", Category.CLASS),
        Classification("52292", "Weging en meting", Category.CLASS),
        Classification("5310", "Nationale post met universele dienstverplichting", Category.CLASS),
        Classification("53201", "Post zonder universele dienstverplichting", Category.CLASS),
        Classification("53202", "Koeriers", Category.CLASS),
        Classification("55101", "Hotel-restaurants", Category.CLASS),
        Classification("55102", "Hotels (geen hotel-restaurants)", Category.CLASS),
        Classification("55201", "Verhuur van vakantiehuisjes en appartementen", Category.CLASS),
        Classification("55202", "Jeugdherbergen en vakantiekampen", Category.CLASS),
        Classification("5530", "Kampeerterreinen", Category.CLASS),
        Classification("5590", "Overige logiesverstrekking", Category.CLASS),
        Classification("56101", "Restaurants", Category.CLASS),
        Classification("56102", "Fastfoodrestaurants", Category.CLASS),
        Classification("5621", "Eventcatering", Category.CLASS),
        Classification("5629", "Kantines en contractcatering", Category.CLASS),
        Classification("5630", "Cafés", Category.CLASS),
        Classification("5811", "Uitgeverijen van boeken", Category.CLASS),
        Classification("5812", "Databanken", Category.CLASS),
        Classification("5813", "Uitgeverijen van kranten", Category.CLASS),
        Classification("5814", "Uitgeverijen van tijdschriften", Category.CLASS),
        Classification("5819", "Overige uitgeverijen (niet van software)", Category.CLASS),
        Classification("5821", "Uitgeverijen van computerspellen", Category.CLASS),
        Classification("5829", "Overige uitgeverijen van software", Category.CLASS),
        Classification("59111", "Productie van films (geen televisiefilms)", Category.CLASS),
        Classification("59112", "Productie van televisieprogramma's", Category.CLASS),
        Classification("5912", "Facilitaire activiteiten voor film- en televisieproductie", Category.CLASS),
        Classification("5913", "Distributie van films en televisieproducties", Category.CLASS),
        Classification("5914", "Bioscopen", Category.CLASS),
        Classification("5920", "Maken en uitgeven van geluidsopnamen", Category.CLASS),
        Classification("6010", "Radio-omroepen", Category.CLASS),
        Classification("6020", "Televisie-omroepen", Category.CLASS),
        Classification("6110", "Draadgebonden telecommunicatie", Category.CLASS),
        Classification("6120", "Draadloze telecommunicatie", Category.CLASS),
        Classification("6130", "Telecommunicatie via satelliet", Category.CLASS),
        Classification("6190", "Overige telecommunicatie", Category.CLASS),
        Classification("6201", "Ontwikkelen", Category.CLASS),
        Classification("6202", "Advisering en ondersteuning op het gebied van informatietechnologie", Category.CLASS),
        Classification("6203", "Beheer van computerfaciliteiten", Category.CLASS),
        Classification(
            "6209", "Overige dienstverlenende activiteiten op het gebied van informatietechnologie", Category.CLASS
        ),
        Classification("6311", "Gegevensverwerking", Category.CLASS),
        Classification("6312", "Webportals", Category.CLASS),
        Classification("6321", "Persagentschappen", Category.CLASS),
        Classification(
            "6329", "Overige dienstverlenende activiteiten op het gebied van informatie (rest)", Category.CLASS
        ),
        Classification("6391", "Persagentschappen", Category.CLASS),
        Classification(
            "6399", "Overige dienstverlenende activiteiten op het gebied van informatie (rest)", Category.CLASS
        ),
        Classification("6411", "Centrale banken", Category.CLASS),
        Classification("64191", "Coöperatief georganiseerde banken", Category.CLASS),
        Classification("64192", "Effectenkredietinstellingen", Category.CLASS),
        Classification("64193", "Spaarbanken", Category.CLASS),
        Classification("64194", "Algemene banken", Category.CLASS),
        Classification("6420", "Financiële holdings", Category.CLASS),
        Classification("64301", "Beleggingsinstellingen in financiële activa", Category.CLASS),
        Classification("64302", "Beleggingsinstellingen in vaste activa", Category.CLASS),
        Classification("64303", "Beleggingsinstellingen met beperkte toetreding", Category.CLASS),
        Classification("6491", "Financiële lease", Category.CLASS),
        Classification("64921", "Hypotheekbanken en bouwfondsen", Category.CLASS),
        Classification("64922", "Volkskredietbanken en commerciële financieringsmaatschappijen", Category.CLASS),
        Classification("64923", "Participatiemaatschappijen", Category.CLASS),
        Classification("64924", "Wisselmakelaars en overige kredietverstrekking", Category.CLASS),
        Classification("6499", "Overige financiële intermediatie", Category.CLASS),
        Classification("65111", "Levensverzekeringen (geen herverzekering)", Category.CLASS),
        Classification("65112", "Naturaverzekeringen", Category.CLASS),
        Classification("65113", "Spaarkassen", Category.CLASS),
        Classification("6512", "Schadeverzekeringen (geen herverzekering)", Category.CLASS),
        Classification("65121", "Schadeverzekeringen - exclusief  zorgverzekeringen", Category.CLASS),
        Classification("65122", "Zorgverzekeringen", Category.CLASS),
        Classification("6520", "Herverzekering", Category.CLASS),
        Classification("65301", "Bedrijfspensioenfondsen", Category.CLASS),
        Classification("65302", "Ondernemingspensioenfondsen en -spaarfondsen", Category.CLASS),
        Classification("65303", "Beroepspensioenfondsen", Category.CLASS),
        Classification("65309", "Overige pensioenfondsen", Category.CLASS),
        Classification("6611", "Beheer van financiële markten", Category.CLASS),
        Classification("6612", "Commissionairs en makelaars in effecten", Category.CLASS),
        Classification("66191", "Administratiekantoren voor aandelen en obligaties", Category.CLASS),
        Classification("66192", "Marketmakers", Category.CLASS),
        Classification("66193", "Hypotheek- en kredietbemiddeling", Category.CLASS),
        Classification("6621", "Risicoanalisten en schadetaxateurs", Category.CLASS),
        Classification("6622", "Assurantietussenpersonen", Category.CLASS),
        Classification("66291", "Verzekeringsbeurzen", Category.CLASS),
        Classification("66292", "Actuariële en pensioenadviesbureaus", Category.CLASS),
        Classification("66293", "Waarborgfondsen", Category.CLASS),
        Classification(
            "66299", "Overige dienstverlening op het gebied van verzekeringen en pensioenfondsen (rest)", Category.CLASS
        ),
        Classification("6630", "Vermogensbeheer", Category.CLASS),
        Classification("6810", "Handel in eigen onroerend goed", Category.CLASS),
        Classification("68201", "Woningbouwverenigingen en -stichtingen", Category.CLASS),
        Classification("68202", "Gemeentelijke woningbedrijven", Category.CLASS),
        Classification("68203", "Verhuur van overige woonruimte", Category.CLASS),
        Classification("68204", "Verhuur van onroerend goed (niet van woonruimte)", Category.CLASS),
        Classification("6831", "Bemiddeling bij handel", Category.CLASS),
        Classification("6832", "Beheer van onroerend goed", Category.CLASS),
        Classification("69101", "Advocatenkantoren", Category.CLASS),
        Classification("69102", "Rechtskundige adviesbureaus", Category.CLASS),
        Classification("69103", "Notariskantoren", Category.CLASS),
        Classification("69104", "Deurwaarderskantoren", Category.CLASS),
        Classification("69105", "Octrooibureaus", Category.CLASS),
        Classification("69201", "Registeraccountants", Category.CLASS),
        Classification("69202", "Accountants-administratieconsulenten", Category.CLASS),
        Classification("69203", "Boekhoudkantoren", Category.CLASS),
        Classification("69204", "Belastingconsulenten", Category.CLASS),
        Classification("69209", "Overige administratiekantoren", Category.CLASS),
        Classification("70101", "Concerndiensten binnen eigen concern", Category.CLASS),
        Classification("70102", "Holdings (geen financiële)", Category.CLASS),
        Classification("7021", "Public relationsbureaus", Category.CLASS),
        Classification("70221", "Organisatie-adviesbureaus", Category.CLASS),
        Classification(
            "70222",
            "Advisering op het gebied van management en bedrijfsvoering (geen public relations en organisatie- adviesbureaus)",
            Category.CLASS,
        ),
        Classification("7111", "Architecten", Category.CLASS),
        Classification("71111", "Architecten (geen interieurarchitecten)", Category.CLASS),
        Classification("71112", "Interieurarchitecten", Category.CLASS),
        Classification("7112", "Ingenieurs en overig technisch ontwerp en advies", Category.CLASS),
        Classification("71201", "Keuring en controle van agrarische producten en voedingsmiddelen", Category.CLASS),
        Classification("71202", "Keuring en controle van machines", Category.CLASS),
        Classification("71203", "Overige keuring en controle", Category.CLASS),
        Classification(
            "72111",
            "Biotechnologisch speur- en ontwikkelingswerk op het gebied van agrarische producten en processen",
            Category.CLASS,
        ),
        Classification(
            "72112",
            "Biotechnologisch speur- en ontwikkelingswerk op het gebied van medische producten en farmaceutische processen en van voeding",
            Category.CLASS,
        ),
        Classification(
            "72113", "Biotechnologisch speur- en ontwikkelingswerk voor overige toepassingen", Category.CLASS
        ),
        Classification(
            "72191",
            "Speur- en ontwikkelingswerk op het gebied van landbouw en visserij (niet biotechnologisch)",
            Category.CLASS,
        ),
        Classification("72192", "Technisch speur- en ontwikkelingswerk", Category.CLASS),
        Classification(
            "72193",
            "Speur- en ontwikkelingswerk op het gebied van gezondheid en voeding (niet biotechnologisch)",
            Category.CLASS,
        ),
        Classification(
            "72199", "Overig natuurwetenschappelijk speur- en ontwikkelingswerk (niet biotechnologisch)", Category.CLASS
        ),
        Classification(
            "7220",
            "Speur- en ontwikkelingswerk op het gebied van de maatschappij- en geesteswetenschappen",
            Category.CLASS,
        ),
        Classification("7311", "Reclamebureaus", Category.CLASS),
        Classification("7312", "Handel in advertentieruimte en -tijd", Category.CLASS),
        Classification("7320", "Markt- en opinieonderzoekbureaus", Category.CLASS),
        Classification("7410", "Industrieel ontwerp en vormgeving", Category.CLASS),
        Classification("74101", "Communicatie- en grafisch ontwerp", Category.CLASS),
        Classification("74102", "Industrieel en productontwerp", Category.CLASS),
        Classification("74103", "Interieur- en ruimtelijk ontwerp", Category.CLASS),
        Classification("74201", "Fotografie", Category.CLASS),
        Classification("74202", "Ontwikkelwinkels", Category.CLASS),
        Classification("74203", "Ontwikkelcentrales", Category.CLASS),
        Classification("7430", "Vertalers en tolken", Category.CLASS),
        Classification("7490", "Overige specialistische zakelijke dienstverlening", Category.CLASS),
        Classification("7500", "Veterinaire dienstverlening", Category.CLASS),
        Classification(
            "77111", "Verhuur van personenauto's en lichte bedrijfsauto's (geen operational lease)", Category.CLASS
        ),
        Classification("77112", "Operational lease van personenauto's en lichte bedrijfsauto's", Category.CLASS),
        Classification("7712", "Verhuur en lease van vrachtwagens", Category.CLASS),
        Classification("7721", "Verhuur van sport- en recreatieartikelen", Category.CLASS),
        Classification("7722", "Videotheken", Category.CLASS),
        Classification("77291", "Verhuur van leesportefeuilles", Category.CLASS),
        Classification("77292", "Verhuur van kleding en huishoudelijke artikelen", Category.CLASS),
        Classification("77299", "Verhuur van overige consumentenartikelen (rest)", Category.CLASS),
        Classification("7731", "Verhuur en lease van landbouwmachines en -werktuigen", Category.CLASS),
        Classification("7732", "Verhuur en lease van machines en installaties voor de bouw", Category.CLASS),
        Classification("7733", "Verhuur en lease van computers en kantoorapparatuur", Category.CLASS),
        Classification("7734", "Verhuur en lease van schepen", Category.CLASS),
        Classification("7735", "Verhuur en lease van vliegtuigen", Category.CLASS),
        Classification("77391", "Verhuur van automaten", Category.CLASS),
        Classification(
            "77399",
            "Verhuur en lease van overige machines en werktuigen en van overige goederen (geen automaten)",
            Category.CLASS,
        ),
        Classification("7740", "Lease van niet-financiële immateriële activa", Category.CLASS),
        Classification("7810", "Arbeidsbemiddeling", Category.CLASS),
        Classification("78201", "Uitzendbureaus", Category.CLASS),
        Classification("78202", "Uitleenbureaus", Category.CLASS),
        Classification("78203", "Banenpools (werkgelegenheidsprojecten)", Category.CLASS),
        Classification("7830", "Payrolling (personeelsbeheer)", Category.CLASS),
        Classification("7911", "Reisbemiddeling", Category.CLASS),
        Classification("7912", "Reisorganisatie", Category.CLASS),
        Classification(
            "7990", "Informatieverstrekking op het gebied van toerisme en reserveringsbureaus", Category.CLASS
        ),
        Classification("8010", "Particuliere beveiliging", Category.CLASS),
        Classification("8020", "Beveiliging via beveiligingssystemen", Category.CLASS),
        Classification("8030", "Opsporing", Category.CLASS),
        Classification("8110", "Facility management", Category.CLASS),
        Classification("8121", "Interieurreiniging van gebouwen", Category.CLASS),
        Classification("8122", "Gespecialiseerde reiniging van gebouwen en industriële reiniging", Category.CLASS),
        Classification("81221", "Glazenwassen", Category.CLASS),
        Classification("81222", "Schoorsteenvegen", Category.CLASS),
        Classification(
            "81229", "Overige gespecialiseerde reiniging van gebouwen en industriële reiniging", Category.CLASS
        ),
        Classification("8129", "Overige reiniging", Category.CLASS),
        Classification("8130", "Landschapsverzorging", Category.CLASS),
        Classification("8211", "Brede administratieve dienstverlening", Category.CLASS),
        Classification("8219", "Secretariële dienstverlening", Category.CLASS),
        Classification("8220", "Callcenters", Category.CLASS),
        Classification("8230", "Organiseren van congressen en beurzen", Category.CLASS),
        Classification("8291", "Kredietinformatie- en incassobureaus", Category.CLASS),
        Classification("8292", "Pakken", Category.CLASS),
        Classification("82991", "Veilingen van landbouw-", Category.CLASS),
        Classification("82992", "Veilingen van huisraad", Category.CLASS),
        Classification("82999", "Overige zakelijke dienstverlening (rest)", Category.CLASS),
        Classification("8411", "Algemeen overheidsbestuur", Category.CLASS),
        Classification("8412", "Openbaar bestuur op het gebied van gezondheidszorg", Category.CLASS),
        Classification("8413", "Openbaar bestuur op het gebied van het bedrijfsleven", Category.CLASS),
        Classification("8421", "Buitenlandse zaken", Category.CLASS),
        Classification("8422", "Defensie", Category.CLASS),
        Classification("84231", "Rechtspraak", Category.CLASS),
        Classification("84232", "Ministerie van Justitie en gevangeniswezen", Category.CLASS),
        Classification("8424", "Politie", Category.CLASS),
        Classification("8425", "Brandweer", Category.CLASS),
        Classification("8430", "Verplichte sociale verzekeringen", Category.CLASS),
        Classification("85201", "Basisonderwijs voor leerplichtigen", Category.CLASS),
        Classification("85202", "Speciaal basisonderwijs", Category.CLASS),
        Classification("85203", "Speciaal onderwijs in expertisecentra", Category.CLASS),
        Classification("85311", "Havo en vwo", Category.CLASS),
        Classification("85312", "Voorbereidend middelbaar beroepsonderwijs", Category.CLASS),
        Classification("85313", "Praktijkonderwijs", Category.CLASS),
        Classification("85314", "Brede scholengemeenschappen voor voortgezet onderwijs", Category.CLASS),
        Classification("85321", "Middelbaar beroepsonderwijs", Category.CLASS),
        Classification("85322", "Educatie", Category.CLASS),
        Classification("85323", "Middelbaar beroepsonderwijs en educatie (gecombineerd)", Category.CLASS),
        Classification("8541", "Niet-universitair hoger onderwijs", Category.CLASS),
        Classification("8542", "Universitair hoger onderwijs", Category.CLASS),
        Classification("85511", "Zeil- en surfscholen", Category.CLASS),
        Classification("85519", "Overig sport- en recreatieonderwijs", Category.CLASS),
        Classification("85521", "Dansscholen", Category.CLASS),
        Classification("85522", "Kunstzinnige vorming van amateurs (geen dansscholen)", Category.CLASS),
        Classification("8553", "Auto- en motorrijscholen", Category.CLASS),
        Classification("85591", "Afstandsonderwijs", Category.CLASS),
        Classification("85592", "Bedrijfsopleiding en -training", Category.CLASS),
        Classification("85599", "Studiebegeleiding", Category.CLASS),
        Classification("8560", "Dienstverlening voor het onderwijs", Category.CLASS),
        Classification("86101", "Universitair medische centra", Category.CLASS),
        Classification("86102", "Algemene ziekenhuizen", Category.CLASS),
        Classification("86103", "Categorale ziekenhuizen", Category.CLASS),
        Classification("86104", "Geestelijke gezondheids- en verslavingszorg met overnachting", Category.CLASS),
        Classification("8621", "Praktijken van huisartsen", Category.CLASS),
        Classification(
            "86221",
            "Praktijken van medisch specialisten en medische dagbehandelcentra (geen tandheelkunde of psychiatrie)",
            Category.CLASS,
        ),
        Classification(
            "86222",
            "Praktijken van psychiaters en dagbehandelcentra voor geestelijke gezondheids- en verslavingszorg",
            Category.CLASS,
        ),
        Classification("86231", "Praktijken van tandartsen", Category.CLASS),
        Classification("86232", "Praktijken van tandheelkundig specialisten", Category.CLASS),
        Classification("86911", "Praktijken van verloskundigen", Category.CLASS),
        Classification("86912", "Praktijken van fysiotherapeuten", Category.CLASS),
        Classification("86913", "Praktijken van psychotherapeuten", Category.CLASS),
        Classification(
            "86919",
            "Overige paramedische praktijken (geen fysiotherapie en psychologie) en alternatieve genezers",
            Category.CLASS,
        ),
        Classification("86921", "Gezondheidscentra", Category.CLASS),
        Classification("86922", "Arbobegeleiding en reïntegratie", Category.CLASS),
        Classification("86923", "Preventieve gezondheidszorg (geen arbobegeleiding)", Category.CLASS),
        Classification("86924", "Medische laboratoria", Category.CLASS),
        Classification("86925", "Ambulancediensten en centrale posten", Category.CLASS),
        Classification(
            "86929",
            "Samenwerkingsorganen op het gebied van gezondheidszorg en overige gezondheidszorgondersteunende diensten",
            Category.CLASS,
        ),
        Classification("8710", "Verpleeghuizen", Category.CLASS),
        Classification(
            "8720",
            "Huizen en dagverblijven voor verstandelijk gehandicapten en psychiatrische cliënten",
            Category.CLASS,
        ),
        Classification("87301", "Huizen en dagverblijven voor niet-verstandelijk gehandicapten", Category.CLASS),
        Classification("87302", "Verzorgingshuizen", Category.CLASS),
        Classification("87901", "Jeugdzorg met overnachting en dagverblijven voor jeugdzorg", Category.CLASS),
        Classification("87902", "Maatschappelijk opvang met overnachting", Category.CLASS),
        Classification("88101", "Thuiszorg", Category.CLASS),
        Classification("88102", "Welzijnswerk voor ouderen", Category.CLASS),
        Classification("88103", "Ondersteuning en begeleiding van gehandicapten", Category.CLASS),
        Classification("8891", "Kinderopvang en peuterspeelzaalwerk", Category.CLASS),
        Classification("88991", "Ambulante jeugdzorg", Category.CLASS),
        Classification("88992", "Maatschappelijk werk", Category.CLASS),
        Classification("88993", "Lokaal welzijnswerk", Category.CLASS),
        Classification("88999", "Overig maatschappelijk advies", Category.CLASS),
        Classification("90011", "Beoefening van podiumkunst", Category.CLASS),
        Classification("90012", "Producenten van podiumkunst", Category.CLASS),
        Classification("90013", "Circus en variété", Category.CLASS),
        Classification("9002", "Dienstverlening voor uitvoerende kunst", Category.CLASS),
        Classification("9003", "Schrijven en overige scheppende kunst", Category.CLASS),
        Classification("90041", "Theaters en schouwburgen", Category.CLASS),
        Classification("90042", "Evenementenhallen", Category.CLASS),
        Classification("91011", "Openbare bibliotheken", Category.CLASS),
        Classification("91012", "Kunstuitleencentra", Category.CLASS),
        Classification("91019", "Overige culturele uitleencentra en openbare archieven", Category.CLASS),
        Classification("91021", "Musea", Category.CLASS),
        Classification("91022", "Kunstgalerieën en -expositieruimten", Category.CLASS),
        Classification("9103", "Monumentenzorg", Category.CLASS),
        Classification("91041", "Dieren- en plantentuinen", Category.CLASS),
        Classification("91042", "Natuurbehoud", Category.CLASS),
        Classification("92001", "Loterijen en kansspelen (geen amusementsautomaten)", Category.CLASS),
        Classification("92009", "Exploitatie van amusements- en speelautomaten", Category.CLASS),
        Classification("93111", "Zwembaden", Category.CLASS),
        Classification("93112", "Sporthallen", Category.CLASS),
        Classification("93113", "Sportvelden", Category.CLASS),
        Classification("93119", "Overige sportaccommodaties", Category.CLASS),
        Classification("93121", "Veldvoetbal", Category.CLASS),
        Classification("93122", "Veldsport in teamverband (geen voetbal)", Category.CLASS),
        Classification("93123", "Atletiek", Category.CLASS),
        Classification("93124", "Tennis", Category.CLASS),
        Classification("93125", "Paardensport en maneges", Category.CLASS),
        Classification("93126", "Wielersport", Category.CLASS),
        Classification("93127", "Auto- en motorsport", Category.CLASS),
        Classification("93128", "Wintersport", Category.CLASS),
        Classification("93129", "Overige buitensport", Category.CLASS),
        Classification("9313", "Fitnesscentra", Category.CLASS),
        Classification("93141", "Individuele zaalsport", Category.CLASS),
        Classification("93142", "Zaalsport in teamverband", Category.CLASS),
        Classification("93143", "Kracht- en vechtsport", Category.CLASS),
        Classification("93144", "Bowlen", Category.CLASS),
        Classification("93145", "Denksport", Category.CLASS),
        Classification("93146", "Sportscholen", Category.CLASS),
        Classification("93149", "Overige binnensport en omnisport", Category.CLASS),
        Classification("93151", "Zwem- en onderwatersport", Category.CLASS),
        Classification("93152", "Roei-", Category.CLASS),
        Classification("93191", "Beroepssportlieden", Category.CLASS),
        Classification("93192", "Hengelsport", Category.CLASS),
        Classification("93193", "Verzorgen van vistochten", Category.CLASS),
        Classification("93194", "Supportersverenigingen (sport)", Category.CLASS),
        Classification("93195", "Organiseren van sportevenementen", Category.CLASS),
        Classification(
            "93196", "Overkoepelende organen en samenwerkings- en adviesorganen op het gebied van sport", Category.CLASS
        ),
        Classification("93199", "Overige sportactiviteiten (rest)", Category.CLASS),
        Classification("93211", "Pret- en themaparken", Category.CLASS),
        Classification("93212", "Kermisattracties", Category.CLASS),
        Classification("93291", "Jachthavens", Category.CLASS),
        Classification("93299", "Overige recreatie (rest) (geen jachthavens)", Category.CLASS),
        Classification("9411", "Bedrijfs- en werkgeversorganisaties", Category.CLASS),
        Classification("9412", "Beroepsorganisaties", Category.CLASS),
        Classification("9420", "Werknemersorganisaties", Category.CLASS),
        Classification("94911", "Religieuze organisaties", Category.CLASS),
        Classification("94919", "Overige levensbeschouwelijke organisaties", Category.CLASS),
        Classification("9492", "Politieke organisaties", Category.CLASS),
        Classification("94991", "Gezelligheidsverenigingen", Category.CLASS),
        Classification("94992", "Hobbyclubs", Category.CLASS),
        Classification("94993", "Steunfondsen (niet op het gebied van welzijnszorg)", Category.CLASS),
        Classification("94994", "Vriendenkringen op het gebied van cultuur", Category.CLASS),
        Classification(
            "94995",
            "Overkoepelende organen en samenwerkings- en adviesorganen (niet op het gebied van gezondheids- en welzijnszorg",
            Category.CLASS,
        ),
        Classification("94996", "Overige ideële organisaties (rest)", Category.CLASS),
        Classification("94997", "Overige belangenbehartiging (rest)", Category.CLASS),
        Classification("9511", "Reparatie van computers en randapparatuur", Category.CLASS),
        Classification("9512", "Reparatie van communicatieapparatuur", Category.CLASS),
        Classification("9521", "Reparatie van consumentenelektronica (geen computers)", Category.CLASS),
        Classification("9522", "Reparatie van elektrische huishoudelijke apparaten", Category.CLASS),
        Classification("9523", "Reparatie van schoenen en lederwaren", Category.CLASS),
        Classification("9524", "Reparatie en stoffering van meubels", Category.CLASS),
        Classification("9525", "Reparatie van uurwerken en juweliersartikelen", Category.CLASS),
        Classification("9529", "Reparatie van overige consumentenartikelen", Category.CLASS),
        Classification("96011", "Wasserijen en linnenverhuur", Category.CLASS),
        Classification("96012", "Chemische wasserijen en ververijen", Category.CLASS),
        Classification("96013", "Wassalons en -verzendinrichtingen", Category.CLASS),
        Classification("96021", "Haarverzorging", Category.CLASS),
        Classification("96022", "Schoonheidsverzorging", Category.CLASS),
        Classification("96031", "Uitvaartverzorging", Category.CLASS),
        Classification("96032", "Crematoria", Category.CLASS),
        Classification("9604", "Sauna's", Category.CLASS),
        Classification("9609", "Overige dienstverlening (rest)", Category.CLASS),
        Classification("9700", "Huishoudens als werkgever van huishoudelijk personeel", Category.CLASS),
        Classification(
            "9810",
            "Niet-gespecificeerde productie van goederen door particuliere huishoudens voor eigen gebruik",
            Category.CLASS,
        ),
        Classification(
            "9820",
            "Niet-gespecificeerde productie van diensten door particuliere huishoudens voor eigen gebruik",
            Category.CLASS,
        ),
        Classification("9900", "Extraterritoriale organisaties en lichamen", Category.CLASS),
    ],
)
