"""`Concordance between NACEBEL2003 and NACEBEL2008 <https://economie.fgov.be/sites/default/files/Files/Entreprises/KBO/conversiontable-Nacebel-2003-2008.xls>`_.
"""
from ...types import Concordance, Standards
from ..nacebel2008 import NACEBEL2008
from . import NACEBEL2003

NACEBEL2003_to_NACEBEL2008 = Concordance(
    src=NACEBEL2003,
    dst=NACEBEL2008,
    concordances=[
        ((Standards.NACEBEL2003, "01110"), (Standards.NACEBEL2008, "01110")),
        ((Standards.NACEBEL2003, "01110"), (Standards.NACEBEL2008, "01120")),
        ((Standards.NACEBEL2003, "01110"), (Standards.NACEBEL2008, "01130")),
        ((Standards.NACEBEL2003, "01110"), (Standards.NACEBEL2008, "01140")),
        ((Standards.NACEBEL2003, "01110"), (Standards.NACEBEL2008, "01150")),
        ((Standards.NACEBEL2003, "01110"), (Standards.NACEBEL2008, "01160")),
        ((Standards.NACEBEL2003, "01110"), (Standards.NACEBEL2008, "01199")),
        ((Standards.NACEBEL2003, "01110"), (Standards.NACEBEL2008, "01260")),
        ((Standards.NACEBEL2003, "01110"), (Standards.NACEBEL2008, "01280")),
        ((Standards.NACEBEL2003, "01110"), (Standards.NACEBEL2008, "01290")),
        ((Standards.NACEBEL2003, "01110"), (Standards.NACEBEL2008, "01630")),
        ((Standards.NACEBEL2003, "01110"), (Standards.NACEBEL2008, "01640")),
        ((Standards.NACEBEL2003, "0111001"), (Standards.NACEBEL2008, "0111001")),
        ((Standards.NACEBEL2003, "0111002"), (Standards.NACEBEL2008, "0113011")),
        ((Standards.NACEBEL2003, "0111003"), (Standards.NACEBEL2008, "01130")),
        ((Standards.NACEBEL2003, "0111004"), (Standards.NACEBEL2008, "01150")),
        ((Standards.NACEBEL2003, "0111005"), (Standards.NACEBEL2008, "0111002")),
        ((Standards.NACEBEL2003, "0111006"), (Standards.NACEBEL2008, "0113012")),
        ((Standards.NACEBEL2003, "0111007"), (Standards.NACEBEL2008, "01160")),
        ((Standards.NACEBEL2003, "0111008"), (Standards.NACEBEL2008, "0111003")),
        ((Standards.NACEBEL2003, "0111009"), (Standards.NACEBEL2008, "0128021")),
        ((Standards.NACEBEL2003, "0111010"), (Standards.NACEBEL2008, "0111004")),
        ((Standards.NACEBEL2003, "0111011"), (Standards.NACEBEL2008, "0111005")),
        ((Standards.NACEBEL2003, "01121"), (Standards.NACEBEL2008, "01130")),
        ((Standards.NACEBEL2003, "01121"), (Standards.NACEBEL2008, "01110")),
        ((Standards.NACEBEL2003, "01121"), (Standards.NACEBEL2008, "01280")),
        ((Standards.NACEBEL2003, "01121"), (Standards.NACEBEL2008, "01640")),
        ((Standards.NACEBEL2003, "01121"), (Standards.NACEBEL2008, "02300")),
        ((Standards.NACEBEL2003, "0112101"), (Standards.NACEBEL2008, "01130")),
        ((Standards.NACEBEL2003, "0112102"), (Standards.NACEBEL2008, "0128001")),
        ((Standards.NACEBEL2003, "0112103"), (Standards.NACEBEL2008, "0113001")),
        ((Standards.NACEBEL2003, "0112104"), (Standards.NACEBEL2008, "0113002")),
        ((Standards.NACEBEL2003, "01122"), (Standards.NACEBEL2008, "01191")),
        ((Standards.NACEBEL2003, "01122"), (Standards.NACEBEL2008, "01640")),
        ((Standards.NACEBEL2003, "0112201"), (Standards.NACEBEL2008, "0119101")),
        ((Standards.NACEBEL2003, "0112202"), (Standards.NACEBEL2008, "0119102")),
        ((Standards.NACEBEL2003, "0112203"), (Standards.NACEBEL2008, "0119103")),
        ((Standards.NACEBEL2003, "01123"), (Standards.NACEBEL2008, "01301")),
        ((Standards.NACEBEL2003, "01123"), (Standards.NACEBEL2008, "01250")),
        ((Standards.NACEBEL2003, "01123"), (Standards.NACEBEL2008, "01309")),
        ((Standards.NACEBEL2003, "01123"), (Standards.NACEBEL2008, "01640")),
        ((Standards.NACEBEL2003, "01123"), (Standards.NACEBEL2008, "02100")),
        ((Standards.NACEBEL2003, "0112301"), (Standards.NACEBEL2008, "0130901")),
        ((Standards.NACEBEL2003, "0112302"), (Standards.NACEBEL2008, "0130902")),
        ((Standards.NACEBEL2003, "01130"), (Standards.NACEBEL2008, "01240")),
        ((Standards.NACEBEL2003, "01130"), (Standards.NACEBEL2008, "01210")),
        ((Standards.NACEBEL2003, "01130"), (Standards.NACEBEL2008, "01220")),
        ((Standards.NACEBEL2003, "01130"), (Standards.NACEBEL2008, "01230")),
        ((Standards.NACEBEL2003, "01130"), (Standards.NACEBEL2008, "01250")),
        ((Standards.NACEBEL2003, "01130"), (Standards.NACEBEL2008, "01260")),
        ((Standards.NACEBEL2003, "01130"), (Standards.NACEBEL2008, "01270")),
        ((Standards.NACEBEL2003, "01130"), (Standards.NACEBEL2008, "01280")),
        ((Standards.NACEBEL2003, "01130"), (Standards.NACEBEL2008, "01630")),
        ((Standards.NACEBEL2003, "01130"), (Standards.NACEBEL2008, "01640")),
        ((Standards.NACEBEL2003, "01130"), (Standards.NACEBEL2008, "02300")),
        ((Standards.NACEBEL2003, "01130"), (Standards.NACEBEL2008, "10410")),
        ((Standards.NACEBEL2003, "01130"), (Standards.NACEBEL2008, "11020")),
        ((Standards.NACEBEL2003, "0113001"), (Standards.NACEBEL2008, "0124001")),
        ((Standards.NACEBEL2003, "0113002"), (Standards.NACEBEL2008, "0121001")),
        ((Standards.NACEBEL2003, "0113003"), (Standards.NACEBEL2008, "01260")),
        ((Standards.NACEBEL2003, "0113004"), (Standards.NACEBEL2008, "01270")),
        ((Standards.NACEBEL2003, "0113005"), (Standards.NACEBEL2008, "0128011")),
        ((Standards.NACEBEL2003, "0113006"), (Standards.NACEBEL2008, "01260")),
        ((Standards.NACEBEL2003, "01210"), (Standards.NACEBEL2008, "01410")),
        ((Standards.NACEBEL2003, "01210"), (Standards.NACEBEL2008, "01420")),
        ((Standards.NACEBEL2003, "0121001"), (Standards.NACEBEL2008, "0141001")),
        ((Standards.NACEBEL2003, "0121002"), (Standards.NACEBEL2008, "0141002")),
        ((Standards.NACEBEL2003, "01220"), (Standards.NACEBEL2008, "01450")),
        ((Standards.NACEBEL2003, "01220"), (Standards.NACEBEL2008, "01430")),
        ((Standards.NACEBEL2003, "01220"), (Standards.NACEBEL2008, "01490")),
        ((Standards.NACEBEL2003, "0122001"), (Standards.NACEBEL2008, "0145001")),
        ((Standards.NACEBEL2003, "0122002"), (Standards.NACEBEL2008, "01430")),
        ((Standards.NACEBEL2003, "0122003"), (Standards.NACEBEL2008, "0145002")),
        ((Standards.NACEBEL2003, "0122004"), (Standards.NACEBEL2008, "0145003")),
        ((Standards.NACEBEL2003, "01231"), (Standards.NACEBEL2008, "01461")),
        ((Standards.NACEBEL2003, "0123101"), (Standards.NACEBEL2008, "0146101")),
        ((Standards.NACEBEL2003, "01232"), (Standards.NACEBEL2008, "01462")),
        ((Standards.NACEBEL2003, "0123201"), (Standards.NACEBEL2008, "0146201")),
        ((Standards.NACEBEL2003, "01241"), (Standards.NACEBEL2008, "01471")),
        ((Standards.NACEBEL2003, "0124101"), (Standards.NACEBEL2008, "01471")),
        ((Standards.NACEBEL2003, "01242"), (Standards.NACEBEL2008, "01472")),
        ((Standards.NACEBEL2003, "0124201"), (Standards.NACEBEL2008, "01472")),
        ((Standards.NACEBEL2003, "01243"), (Standards.NACEBEL2008, "01479")),
        ((Standards.NACEBEL2003, "0124301"), (Standards.NACEBEL2008, "01479")),
        ((Standards.NACEBEL2003, "01250"), (Standards.NACEBEL2008, "01490")),
        ((Standards.NACEBEL2003, "01250"), (Standards.NACEBEL2008, "01440")),
        ((Standards.NACEBEL2003, "01250"), (Standards.NACEBEL2008, "03220")),
        ((Standards.NACEBEL2003, "0125001"), (Standards.NACEBEL2008, "0149001")),
        ((Standards.NACEBEL2003, "0125002"), (Standards.NACEBEL2008, "0149002")),
        ((Standards.NACEBEL2003, "0125003"), (Standards.NACEBEL2008, "0149003")),
        ((Standards.NACEBEL2003, "0125004"), (Standards.NACEBEL2008, "0149004")),
        ((Standards.NACEBEL2003, "0125005"), (Standards.NACEBEL2008, "0149005")),
        ((Standards.NACEBEL2003, "0125006"), (Standards.NACEBEL2008, "01490")),
        ((Standards.NACEBEL2003, "0125007"), (Standards.NACEBEL2008, "03220")),
        ((Standards.NACEBEL2003, "0125008"), (Standards.NACEBEL2008, "0149006")),
        ((Standards.NACEBEL2003, "0125009"), (Standards.NACEBEL2008, "0149007")),
        ((Standards.NACEBEL2003, "01300"), (Standards.NACEBEL2008, "01500")),
        ((Standards.NACEBEL2003, "0130001"), (Standards.NACEBEL2008, "0150001")),
        ((Standards.NACEBEL2003, "01410"), (Standards.NACEBEL2008, "81300")),
        ((Standards.NACEBEL2003, "01410"), (Standards.NACEBEL2008, "01610")),
        ((Standards.NACEBEL2003, "01410"), (Standards.NACEBEL2008, "01630")),
        ((Standards.NACEBEL2003, "01410"), (Standards.NACEBEL2008, "01640")),
        ((Standards.NACEBEL2003, "01410"), (Standards.NACEBEL2008, "10392")),
        ((Standards.NACEBEL2003, "0141001"), (Standards.NACEBEL2008, "0161001")),
        ((Standards.NACEBEL2003, "0141002"), (Standards.NACEBEL2008, "0161002")),
        ((Standards.NACEBEL2003, "0141003"), (Standards.NACEBEL2008, "01610")),
        ((Standards.NACEBEL2003, "0141004"), (Standards.NACEBEL2008, "0161003")),
        ((Standards.NACEBEL2003, "0141005"), (Standards.NACEBEL2008, "0161007")),
        ((Standards.NACEBEL2003, "0141006"), (Standards.NACEBEL2008, "0161004")),
        ((Standards.NACEBEL2003, "0141007"), (Standards.NACEBEL2008, "0161005")),
        ((Standards.NACEBEL2003, "0141008"), (Standards.NACEBEL2008, "0163001")),
        ((Standards.NACEBEL2003, "0141009"), (Standards.NACEBEL2008, "8130001")),
        ((Standards.NACEBEL2003, "0141010"), (Standards.NACEBEL2008, "0161008")),
        ((Standards.NACEBEL2003, "0141011"), (Standards.NACEBEL2008, "8130002")),
        ((Standards.NACEBEL2003, "0141012"), (Standards.NACEBEL2008, "0161006")),
        ((Standards.NACEBEL2003, "01411"), (Standards.NACEBEL2008, "01610")),
        ((Standards.NACEBEL2003, "01412"), (Standards.NACEBEL2008, "01610")),
        ((Standards.NACEBEL2003, "01420"), (Standards.NACEBEL2008, "01620")),
        ((Standards.NACEBEL2003, "0142001"), (Standards.NACEBEL2008, "0162001")),
        ((Standards.NACEBEL2003, "0142002"), (Standards.NACEBEL2008, "0162002")),
        ((Standards.NACEBEL2003, "0142003"), (Standards.NACEBEL2008, "0162003")),
        ((Standards.NACEBEL2003, "0142004"), (Standards.NACEBEL2008, "9609501")),
        ((Standards.NACEBEL2003, "0142005"), (Standards.NACEBEL2008, "9609301")),
        ((Standards.NACEBEL2003, "01500"), (Standards.NACEBEL2008, "01700")),
        ((Standards.NACEBEL2003, "01500"), (Standards.NACEBEL2008, "94999")),
        ((Standards.NACEBEL2003, "0150001"), (Standards.NACEBEL2008, "0170001")),
        ((Standards.NACEBEL2003, "0150002"), (Standards.NACEBEL2008, "01700")),
        ((Standards.NACEBEL2003, "0150003"), (Standards.NACEBEL2008, "01700")),
        ((Standards.NACEBEL2003, "0150004"), (Standards.NACEBEL2008, "01700")),
        ((Standards.NACEBEL2003, "02011"), (Standards.NACEBEL2008, "02100")),
        ((Standards.NACEBEL2003, "02011"), (Standards.NACEBEL2008, "01290")),
        ((Standards.NACEBEL2003, "0201101"), (Standards.NACEBEL2008, "0210001")),
        ((Standards.NACEBEL2003, "0201102"), (Standards.NACEBEL2008, "0210002")),
        ((Standards.NACEBEL2003, "0201103"), (Standards.NACEBEL2008, "0210003")),
        ((Standards.NACEBEL2003, "0201104"), (Standards.NACEBEL2008, "0129001")),
        ((Standards.NACEBEL2003, "02012"), (Standards.NACEBEL2008, "02200")),
        ((Standards.NACEBEL2003, "02012"), (Standards.NACEBEL2008, "02300")),
        ((Standards.NACEBEL2003, "02012"), (Standards.NACEBEL2008, "16100")),
        ((Standards.NACEBEL2003, "0201201"), (Standards.NACEBEL2008, "0220001")),
        ((Standards.NACEBEL2003, "0201202"), (Standards.NACEBEL2008, "02300")),
        ((Standards.NACEBEL2003, "02020"), (Standards.NACEBEL2008, "02400")),
        ((Standards.NACEBEL2003, "0202001"), (Standards.NACEBEL2008, "0240001")),
        ((Standards.NACEBEL2003, "0202002"), (Standards.NACEBEL2008, "0240002")),
        ((Standards.NACEBEL2003, "05010"), (Standards.NACEBEL2008, "03110")),
        ((Standards.NACEBEL2003, "05010"), (Standards.NACEBEL2008, "03120")),
        ((Standards.NACEBEL2003, "0501001"), (Standards.NACEBEL2008, "0311001")),
        ((Standards.NACEBEL2003, "0501002"), (Standards.NACEBEL2008, "0311002")),
        ((Standards.NACEBEL2003, "0501003"), (Standards.NACEBEL2008, "03110")),
        ((Standards.NACEBEL2003, "0501004"), (Standards.NACEBEL2008, "03110")),
        ((Standards.NACEBEL2003, "0501005"), (Standards.NACEBEL2008, "03110")),
        ((Standards.NACEBEL2003, "0501006"), (Standards.NACEBEL2008, "0311003")),
        ((Standards.NACEBEL2003, "05020"), (Standards.NACEBEL2008, "03220")),
        ((Standards.NACEBEL2003, "05020"), (Standards.NACEBEL2008, "03210")),
        ((Standards.NACEBEL2003, "0502001"), (Standards.NACEBEL2008, "0321001")),
        ((Standards.NACEBEL2003, "0502002"), (Standards.NACEBEL2008, "0321002")),
        ((Standards.NACEBEL2003, "0502003"), (Standards.NACEBEL2008, "0322001")),
        ((Standards.NACEBEL2003, "0502004"), (Standards.NACEBEL2008, "03210")),
        ((Standards.NACEBEL2003, "10100"), (Standards.NACEBEL2008, "09900")),
        ((Standards.NACEBEL2003, "10100"), (Standards.NACEBEL2008, "05100")),
        ((Standards.NACEBEL2003, "10100"), (Standards.NACEBEL2008, "19200")),
        ((Standards.NACEBEL2003, "1010001"), (Standards.NACEBEL2008, "05100")),
        ((Standards.NACEBEL2003, "1010002"), (Standards.NACEBEL2008, "0510001")),
        ((Standards.NACEBEL2003, "1010003"), (Standards.NACEBEL2008, "0510002")),
        ((Standards.NACEBEL2003, "1010004"), (Standards.NACEBEL2008, "05100")),
        ((Standards.NACEBEL2003, "10200"), (Standards.NACEBEL2008, "09900")),
        ((Standards.NACEBEL2003, "10200"), (Standards.NACEBEL2008, "05200")),
        ((Standards.NACEBEL2003, "10200"), (Standards.NACEBEL2008, "19200")),
        ((Standards.NACEBEL2003, "1020001"), (Standards.NACEBEL2008, "05200")),
        ((Standards.NACEBEL2003, "1020002"), (Standards.NACEBEL2008, "05200")),
        ((Standards.NACEBEL2003, "1020003"), (Standards.NACEBEL2008, "05200")),
        ((Standards.NACEBEL2003, "10300"), (Standards.NACEBEL2008, "08920")),
        ((Standards.NACEBEL2003, "10300"), (Standards.NACEBEL2008, "19200")),
        ((Standards.NACEBEL2003, "1030001"), (Standards.NACEBEL2008, "08920")),
        ((Standards.NACEBEL2003, "1030002"), (Standards.NACEBEL2008, "0892001")),
        ((Standards.NACEBEL2003, "1030003"), (Standards.NACEBEL2008, "08920")),
        ((Standards.NACEBEL2003, "11100"), (Standards.NACEBEL2008, "09100")),
        ((Standards.NACEBEL2003, "11100"), (Standards.NACEBEL2008, "06100")),
        ((Standards.NACEBEL2003, "11100"), (Standards.NACEBEL2008, "06200")),
        ((Standards.NACEBEL2003, "11100"), (Standards.NACEBEL2008, "52210")),
        ((Standards.NACEBEL2003, "11100"), (Standards.NACEBEL2008, "52220")),
        ((Standards.NACEBEL2003, "1110001"), (Standards.NACEBEL2008, "06100")),
        ((Standards.NACEBEL2003, "1110002"), (Standards.NACEBEL2008, "06200")),
        ((Standards.NACEBEL2003, "1110003"), (Standards.NACEBEL2008, "0620001")),
        ((Standards.NACEBEL2003, "1110004"), (Standards.NACEBEL2008, "0620002")),
        ((Standards.NACEBEL2003, "1110005"), (Standards.NACEBEL2008, "09100")),
        ((Standards.NACEBEL2003, "1110006"), (Standards.NACEBEL2008, "06200")),
        ((Standards.NACEBEL2003, "1110007"), (Standards.NACEBEL2008, "06100")),
        ((Standards.NACEBEL2003, "1110008"), (Standards.NACEBEL2008, "06100")),
        ((Standards.NACEBEL2003, "11200"), (Standards.NACEBEL2008, "09100")),
        ((Standards.NACEBEL2003, "1120001"), (Standards.NACEBEL2008, "0910001")),
        ((Standards.NACEBEL2003, "1120002"), (Standards.NACEBEL2008, "0910002")),
        ((Standards.NACEBEL2003, "1120003"), (Standards.NACEBEL2008, "09100")),
        ((Standards.NACEBEL2003, "1120004"), (Standards.NACEBEL2008, "09100")),
        ((Standards.NACEBEL2003, "1120005"), (Standards.NACEBEL2008, "09100")),
        ((Standards.NACEBEL2003, "1120006"), (Standards.NACEBEL2008, "09100")),
        ((Standards.NACEBEL2003, "12000"), (Standards.NACEBEL2008, "09900")),
        ((Standards.NACEBEL2003, "12000"), (Standards.NACEBEL2008, "07210")),
        ((Standards.NACEBEL2003, "1200001"), (Standards.NACEBEL2008, "07210")),
        ((Standards.NACEBEL2003, "1200002"), (Standards.NACEBEL2008, "07210")),
        ((Standards.NACEBEL2003, "1200003"), (Standards.NACEBEL2008, "07210")),
        ((Standards.NACEBEL2003, "13000"), (Standards.NACEBEL2008, "09900")),
        ((Standards.NACEBEL2003, "1300001"), (Standards.NACEBEL2008, "07100")),
        ((Standards.NACEBEL2003, "1300002"), (Standards.NACEBEL2008, "07100")),
        ((Standards.NACEBEL2003, "13100"), (Standards.NACEBEL2008, "09900")),
        ((Standards.NACEBEL2003, "13100"), (Standards.NACEBEL2008, "07100")),
        ((Standards.NACEBEL2003, "1310001"), (Standards.NACEBEL2008, "07100")),
        ((Standards.NACEBEL2003, "1310002"), (Standards.NACEBEL2008, "07100")),
        ((Standards.NACEBEL2003, "13200"), (Standards.NACEBEL2008, "09900")),
        ((Standards.NACEBEL2003, "13200"), (Standards.NACEBEL2008, "07290")),
        ((Standards.NACEBEL2003, "1320001"), (Standards.NACEBEL2008, "07290")),
        ((Standards.NACEBEL2003, "14110"), (Standards.NACEBEL2008, "08111")),
        ((Standards.NACEBEL2003, "14110"), (Standards.NACEBEL2008, "09900")),
        ((Standards.NACEBEL2003, "1411001"), (Standards.NACEBEL2008, "0811101")),
        ((Standards.NACEBEL2003, "14121"), (Standards.NACEBEL2008, "08112")),
        ((Standards.NACEBEL2003, "14121"), (Standards.NACEBEL2008, "08111")),
        ((Standards.NACEBEL2003, "14121"), (Standards.NACEBEL2008, "09900")),
        ((Standards.NACEBEL2003, "1412101"), (Standards.NACEBEL2008, "0811201")),
        ((Standards.NACEBEL2003, "14122"), (Standards.NACEBEL2008, "08112")),
        ((Standards.NACEBEL2003, "14122"), (Standards.NACEBEL2008, "09900")),
        ((Standards.NACEBEL2003, "1412201"), (Standards.NACEBEL2008, "0811211")),
        ((Standards.NACEBEL2003, "1412202"), (Standards.NACEBEL2008, "08112")),
        ((Standards.NACEBEL2003, "1412203"), (Standards.NACEBEL2008, "08112")),
        ((Standards.NACEBEL2003, "1412204"), (Standards.NACEBEL2008, "08112")),
        ((Standards.NACEBEL2003, "1412205"), (Standards.NACEBEL2008, "0811212")),
        ((Standards.NACEBEL2003, "14130"), (Standards.NACEBEL2008, "08112")),
        ((Standards.NACEBEL2003, "14130"), (Standards.NACEBEL2008, "09900")),
        ((Standards.NACEBEL2003, "1413001"), (Standards.NACEBEL2008, "0811221")),
        ((Standards.NACEBEL2003, "14211"), (Standards.NACEBEL2008, "08122")),
        ((Standards.NACEBEL2003, "14211"), (Standards.NACEBEL2008, "09900")),
        ((Standards.NACEBEL2003, "1421101"), (Standards.NACEBEL2008, "0812201")),
        ((Standards.NACEBEL2003, "14212"), (Standards.NACEBEL2008, "08121")),
        ((Standards.NACEBEL2003, "14212"), (Standards.NACEBEL2008, "09900")),
        ((Standards.NACEBEL2003, "1421201"), (Standards.NACEBEL2008, "0812101")),
        ((Standards.NACEBEL2003, "1421202"), (Standards.NACEBEL2008, "0812102")),
        ((Standards.NACEBEL2003, "14220"), (Standards.NACEBEL2008, "08123")),
        ((Standards.NACEBEL2003, "14220"), (Standards.NACEBEL2008, "09900")),
        ((Standards.NACEBEL2003, "1422001"), (Standards.NACEBEL2008, "08123")),
        ((Standards.NACEBEL2003, "14300"), (Standards.NACEBEL2008, "08910")),
        ((Standards.NACEBEL2003, "14300"), (Standards.NACEBEL2008, "09900")),
        ((Standards.NACEBEL2003, "1430001"), (Standards.NACEBEL2008, "08910")),
        ((Standards.NACEBEL2003, "1430002"), (Standards.NACEBEL2008, "08910")),
        ((Standards.NACEBEL2003, "1430003"), (Standards.NACEBEL2008, "08910")),
        ((Standards.NACEBEL2003, "1430004"), (Standards.NACEBEL2008, "08910")),
        ((Standards.NACEBEL2003, "1430005"), (Standards.NACEBEL2008, "08910")),
        ((Standards.NACEBEL2003, "1430006"), (Standards.NACEBEL2008, "08910")),
        ((Standards.NACEBEL2003, "14400"), (Standards.NACEBEL2008, "10840")),
        ((Standards.NACEBEL2003, "14400"), (Standards.NACEBEL2008, "08930")),
        ((Standards.NACEBEL2003, "14400"), (Standards.NACEBEL2008, "09900")),
        ((Standards.NACEBEL2003, "1440001"), (Standards.NACEBEL2008, "08930")),
        ((Standards.NACEBEL2003, "1440002"), (Standards.NACEBEL2008, "08930")),
        ((Standards.NACEBEL2003, "1440003"), (Standards.NACEBEL2008, "08930")),
        ((Standards.NACEBEL2003, "1440004"), (Standards.NACEBEL2008, "08930")),
        ((Standards.NACEBEL2003, "14500"), (Standards.NACEBEL2008, "08990")),
        ((Standards.NACEBEL2003, "14500"), (Standards.NACEBEL2008, "09900")),
        ((Standards.NACEBEL2003, "1450001"), (Standards.NACEBEL2008, "0899001")),
        ((Standards.NACEBEL2003, "15111"), (Standards.NACEBEL2008, "10110")),
        ((Standards.NACEBEL2003, "1511101"), (Standards.NACEBEL2008, "1011001")),
        ((Standards.NACEBEL2003, "1511102"), (Standards.NACEBEL2008, "1011002")),
        ((Standards.NACEBEL2003, "1511103"), (Standards.NACEBEL2008, "1011003")),
        ((Standards.NACEBEL2003, "1511104"), (Standards.NACEBEL2008, "1011004")),
        ((Standards.NACEBEL2003, "1511105"), (Standards.NACEBEL2008, "1011005")),
        ((Standards.NACEBEL2003, "1511106"), (Standards.NACEBEL2008, "1011006")),
        ((Standards.NACEBEL2003, "1511107"), (Standards.NACEBEL2008, "1011007")),
        ((Standards.NACEBEL2003, "15112"), (Standards.NACEBEL2008, "10110")),
        ((Standards.NACEBEL2003, "1511201"), (Standards.NACEBEL2008, "1011011")),
        ((Standards.NACEBEL2003, "15121"), (Standards.NACEBEL2008, "10120")),
        ((Standards.NACEBEL2003, "15121"), (Standards.NACEBEL2008, "10110")),
        ((Standards.NACEBEL2003, "1512101"), (Standards.NACEBEL2008, "1012001")),
        ((Standards.NACEBEL2003, "1512102"), (Standards.NACEBEL2008, "1012002")),
        ((Standards.NACEBEL2003, "1512103"), (Standards.NACEBEL2008, "1012003")),
        ((Standards.NACEBEL2003, "1512104"), (Standards.NACEBEL2008, "1012004")),
        ((Standards.NACEBEL2003, "15122"), (Standards.NACEBEL2008, "10120")),
        ((Standards.NACEBEL2003, "15122"), (Standards.NACEBEL2008, "10110")),
        ((Standards.NACEBEL2003, "1512201"), (Standards.NACEBEL2008, "10120")),
        ((Standards.NACEBEL2003, "15131"), (Standards.NACEBEL2008, "10130")),
        ((Standards.NACEBEL2003, "15131"), (Standards.NACEBEL2008, "10850")),
        ((Standards.NACEBEL2003, "15131"), (Standards.NACEBEL2008, "10890")),
        ((Standards.NACEBEL2003, "1513101"), (Standards.NACEBEL2008, "1013001")),
        ((Standards.NACEBEL2003, "1513102"), (Standards.NACEBEL2008, "1013002")),
        ((Standards.NACEBEL2003, "1513103"), (Standards.NACEBEL2008, "1085001")),
        ((Standards.NACEBEL2003, "15132"), (Standards.NACEBEL2008, "10130")),
        ((Standards.NACEBEL2003, "15132"), (Standards.NACEBEL2008, "10850")),
        ((Standards.NACEBEL2003, "15132"), (Standards.NACEBEL2008, "10890")),
        ((Standards.NACEBEL2003, "1513201"), (Standards.NACEBEL2008, "1013011")),
        ((Standards.NACEBEL2003, "1513202"), (Standards.NACEBEL2008, "1085011")),
        ((Standards.NACEBEL2003, "15201"), (Standards.NACEBEL2008, "10200")),
        ((Standards.NACEBEL2003, "15201"), (Standards.NACEBEL2008, "10850")),
        ((Standards.NACEBEL2003, "1520101"), (Standards.NACEBEL2008, "1020001")),
        ((Standards.NACEBEL2003, "1520102"), (Standards.NACEBEL2008, "1020002")),
        ((Standards.NACEBEL2003, "1520103"), (Standards.NACEBEL2008, "1085021")),
        ((Standards.NACEBEL2003, "1520104"), (Standards.NACEBEL2008, "10200")),
        ((Standards.NACEBEL2003, "1520105"), (Standards.NACEBEL2008, "10200")),
        ((Standards.NACEBEL2003, "15202"), (Standards.NACEBEL2008, "10200")),
        ((Standards.NACEBEL2003, "15202"), (Standards.NACEBEL2008, "10850")),
        ((Standards.NACEBEL2003, "1520201"), (Standards.NACEBEL2008, "1020011")),
        ((Standards.NACEBEL2003, "1520202"), (Standards.NACEBEL2008, "10200")),
        ((Standards.NACEBEL2003, "1520203"), (Standards.NACEBEL2008, "1085031")),
        ((Standards.NACEBEL2003, "15311"), (Standards.NACEBEL2008, "10311")),
        ((Standards.NACEBEL2003, "1531101"), (Standards.NACEBEL2008, "1031101")),
        ((Standards.NACEBEL2003, "1531102"), (Standards.NACEBEL2008, "1031102")),
        ((Standards.NACEBEL2003, "1531103"), (Standards.NACEBEL2008, "1031103")),
        ((Standards.NACEBEL2003, "1531104"), (Standards.NACEBEL2008, "10311")),
        ((Standards.NACEBEL2003, "1531105"), (Standards.NACEBEL2008, "1031104")),
        ((Standards.NACEBEL2003, "15312"), (Standards.NACEBEL2008, "10312")),
        ((Standards.NACEBEL2003, "1531201"), (Standards.NACEBEL2008, "10312")),
        ((Standards.NACEBEL2003, "1531202"), (Standards.NACEBEL2008, "1031201")),
        ((Standards.NACEBEL2003, "15320"), (Standards.NACEBEL2008, "10320")),
        ((Standards.NACEBEL2003, "1532001"), (Standards.NACEBEL2008, "10320")),
        ((Standards.NACEBEL2003, "1532002"), (Standards.NACEBEL2008, "1032001")),
        ((Standards.NACEBEL2003, "15331"), (Standards.NACEBEL2008, "10391")),
        ((Standards.NACEBEL2003, "15331"), (Standards.NACEBEL2008, "10850")),
        ((Standards.NACEBEL2003, "1533101"), (Standards.NACEBEL2008, "1039102")),
        ((Standards.NACEBEL2003, "1533102"), (Standards.NACEBEL2008, "1039101")),
        ((Standards.NACEBEL2003, "15332"), (Standards.NACEBEL2008, "10393")),
        ((Standards.NACEBEL2003, "15332"), (Standards.NACEBEL2008, "10850")),
        ((Standards.NACEBEL2003, "1533201"), (Standards.NACEBEL2008, "10393")),
        ((Standards.NACEBEL2003, "1533202"), (Standards.NACEBEL2008, "10393")),
        ((Standards.NACEBEL2003, "15333"), (Standards.NACEBEL2008, "10392")),
        ((Standards.NACEBEL2003, "15333"), (Standards.NACEBEL2008, "10393")),
        ((Standards.NACEBEL2003, "1533301"), (Standards.NACEBEL2008, "1039203")),
        ((Standards.NACEBEL2003, "1533302"), (Standards.NACEBEL2008, "1039201")),
        ((Standards.NACEBEL2003, "1533303"), (Standards.NACEBEL2008, "10392")),
        ((Standards.NACEBEL2003, "1533304"), (Standards.NACEBEL2008, "1039202")),
        ((Standards.NACEBEL2003, "15411"), (Standards.NACEBEL2008, "10410")),
        ((Standards.NACEBEL2003, "1541101"), (Standards.NACEBEL2008, "10410")),
        ((Standards.NACEBEL2003, "1541102"), (Standards.NACEBEL2008, "10410")),
        ((Standards.NACEBEL2003, "15412"), (Standards.NACEBEL2008, "10410")),
        ((Standards.NACEBEL2003, "1541201"), (Standards.NACEBEL2008, "10410")),
        ((Standards.NACEBEL2003, "1541202"), (Standards.NACEBEL2008, "10410")),
        ((Standards.NACEBEL2003, "15420"), (Standards.NACEBEL2008, "10410")),
        ((Standards.NACEBEL2003, "1542001"), (Standards.NACEBEL2008, "1041001")),
        ((Standards.NACEBEL2003, "1542002"), (Standards.NACEBEL2008, "10410")),
        ((Standards.NACEBEL2003, "15430"), (Standards.NACEBEL2008, "10420")),
        ((Standards.NACEBEL2003, "1543001"), (Standards.NACEBEL2008, "10420")),
        ((Standards.NACEBEL2003, "1543002"), (Standards.NACEBEL2008, "10420")),
        ((Standards.NACEBEL2003, "1543003"), (Standards.NACEBEL2008, "10420")),
        ((Standards.NACEBEL2003, "15510"), (Standards.NACEBEL2008, "10510")),
        ((Standards.NACEBEL2003, "1551001"), (Standards.NACEBEL2008, "1051001")),
        ((Standards.NACEBEL2003, "1551002"), (Standards.NACEBEL2008, "1051002")),
        ((Standards.NACEBEL2003, "1551003"), (Standards.NACEBEL2008, "1051003")),
        ((Standards.NACEBEL2003, "1551004"), (Standards.NACEBEL2008, "10510")),
        ((Standards.NACEBEL2003, "1551005"), (Standards.NACEBEL2008, "1051004")),
        ((Standards.NACEBEL2003, "1551006"), (Standards.NACEBEL2008, "1051005")),
        ((Standards.NACEBEL2003, "1551007"), (Standards.NACEBEL2008, "1051006")),
        ((Standards.NACEBEL2003, "1551008"), (Standards.NACEBEL2008, "1051007")),
        ((Standards.NACEBEL2003, "1551009"), (Standards.NACEBEL2008, "1051008")),
        ((Standards.NACEBEL2003, "1551010"), (Standards.NACEBEL2008, "1051009")),
        ((Standards.NACEBEL2003, "15520"), (Standards.NACEBEL2008, "10520")),
        ((Standards.NACEBEL2003, "1552001"), (Standards.NACEBEL2008, "1052001")),
        ((Standards.NACEBEL2003, "15610"), (Standards.NACEBEL2008, "10610")),
        ((Standards.NACEBEL2003, "1561001"), (Standards.NACEBEL2008, "1061001")),
        ((Standards.NACEBEL2003, "1561002"), (Standards.NACEBEL2008, "10610")),
        ((Standards.NACEBEL2003, "1561003"), (Standards.NACEBEL2008, "10610")),
        ((Standards.NACEBEL2003, "1561004"), (Standards.NACEBEL2008, "10610")),
        ((Standards.NACEBEL2003, "1561005"), (Standards.NACEBEL2008, "1061002")),
        ((Standards.NACEBEL2003, "1561006"), (Standards.NACEBEL2008, "1061003")),
        ((Standards.NACEBEL2003, "15620"), (Standards.NACEBEL2008, "10620")),
        ((Standards.NACEBEL2003, "15620"), (Standards.NACEBEL2008, "10890")),
        ((Standards.NACEBEL2003, "1562001"), (Standards.NACEBEL2008, "10620")),
        ((Standards.NACEBEL2003, "1562002"), (Standards.NACEBEL2008, "10620")),
        ((Standards.NACEBEL2003, "1562003"), (Standards.NACEBEL2008, "10620")),
        ((Standards.NACEBEL2003, "1562004"), (Standards.NACEBEL2008, "10620")),
        ((Standards.NACEBEL2003, "1562005"), (Standards.NACEBEL2008, "10620")),
        ((Standards.NACEBEL2003, "1562006"), (Standards.NACEBEL2008, "10620")),
        ((Standards.NACEBEL2003, "1562007"), (Standards.NACEBEL2008, "10620")),
        ((Standards.NACEBEL2003, "1562008"), (Standards.NACEBEL2008, "1089011")),
        ((Standards.NACEBEL2003, "15710"), (Standards.NACEBEL2008, "10910")),
        ((Standards.NACEBEL2003, "1571001"), (Standards.NACEBEL2008, "1091001")),
        ((Standards.NACEBEL2003, "1571002"), (Standards.NACEBEL2008, "10910")),
        ((Standards.NACEBEL2003, "1571003"), (Standards.NACEBEL2008, "10910")),
        ((Standards.NACEBEL2003, "15720"), (Standards.NACEBEL2008, "10920")),
        ((Standards.NACEBEL2003, "1572001"), (Standards.NACEBEL2008, "10920")),
        ((Standards.NACEBEL2003, "15811"), (Standards.NACEBEL2008, "10711")),
        ((Standards.NACEBEL2003, "15811"), (Standards.NACEBEL2008, "10850")),
        ((Standards.NACEBEL2003, "15811"), (Standards.NACEBEL2008, "10890")),
        ((Standards.NACEBEL2003, "1581101"), (Standards.NACEBEL2008, "1071101")),
        ((Standards.NACEBEL2003, "1581102"), (Standards.NACEBEL2008, "1071102")),
        ((Standards.NACEBEL2003, "15812"), (Standards.NACEBEL2008, "10712")),
        ((Standards.NACEBEL2003, "15812"), (Standards.NACEBEL2008, "10850")),
        ((Standards.NACEBEL2003, "15812"), (Standards.NACEBEL2008, "10890")),
        ((Standards.NACEBEL2003, "1581201"), (Standards.NACEBEL2008, "1071201")),
        ((Standards.NACEBEL2003, "15820"), (Standards.NACEBEL2008, "10720")),
        ((Standards.NACEBEL2003, "1582001"), (Standards.NACEBEL2008, "1072001")),
        ((Standards.NACEBEL2003, "1582002"), (Standards.NACEBEL2008, "1072002")),
        ((Standards.NACEBEL2003, "1582003"), (Standards.NACEBEL2008, "1072003")),
        ((Standards.NACEBEL2003, "15830"), (Standards.NACEBEL2008, "10810")),
        ((Standards.NACEBEL2003, "1583001"), (Standards.NACEBEL2008, "1081001")),
        ((Standards.NACEBEL2003, "1583002"), (Standards.NACEBEL2008, "1081002")),
        ((Standards.NACEBEL2003, "1583003"), (Standards.NACEBEL2008, "10810")),
        ((Standards.NACEBEL2003, "1583004"), (Standards.NACEBEL2008, "10810")),
        ((Standards.NACEBEL2003, "1583005"), (Standards.NACEBEL2008, "10810")),
        ((Standards.NACEBEL2003, "15840"), (Standards.NACEBEL2008, "10820")),
        ((Standards.NACEBEL2003, "1584001"), (Standards.NACEBEL2008, "1082001")),
        ((Standards.NACEBEL2003, "1584002"), (Standards.NACEBEL2008, "1082002")),
        ((Standards.NACEBEL2003, "1584003"), (Standards.NACEBEL2008, "1082003")),
        ((Standards.NACEBEL2003, "1584004"), (Standards.NACEBEL2008, "10820")),
        ((Standards.NACEBEL2003, "1584005"), (Standards.NACEBEL2008, "10820")),
        ((Standards.NACEBEL2003, "1584006"), (Standards.NACEBEL2008, "1082004")),
        ((Standards.NACEBEL2003, "15850"), (Standards.NACEBEL2008, "10730")),
        ((Standards.NACEBEL2003, "15850"), (Standards.NACEBEL2008, "10850")),
        ((Standards.NACEBEL2003, "1585001"), (Standards.NACEBEL2008, "1073001")),
        ((Standards.NACEBEL2003, "1585002"), (Standards.NACEBEL2008, "10730")),
        ((Standards.NACEBEL2003, "15860"), (Standards.NACEBEL2008, "10830")),
        ((Standards.NACEBEL2003, "1586001"), (Standards.NACEBEL2008, "1083001")),
        ((Standards.NACEBEL2003, "1586002"), (Standards.NACEBEL2008, "1083002")),
        ((Standards.NACEBEL2003, "1586003"), (Standards.NACEBEL2008, "10830")),
        ((Standards.NACEBEL2003, "1586004"), (Standards.NACEBEL2008, "1083003")),
        ((Standards.NACEBEL2003, "1586005"), (Standards.NACEBEL2008, "82920")),
        ((Standards.NACEBEL2003, "1586006"), (Standards.NACEBEL2008, "1083004")),
        ((Standards.NACEBEL2003, "15870"), (Standards.NACEBEL2008, "10840")),
        ((Standards.NACEBEL2003, "1587001"), (Standards.NACEBEL2008, "1084001")),
        ((Standards.NACEBEL2003, "1587002"), (Standards.NACEBEL2008, "1084002")),
        ((Standards.NACEBEL2003, "1587003"), (Standards.NACEBEL2008, "1084003")),
        ((Standards.NACEBEL2003, "1587004"), (Standards.NACEBEL2008, "10840")),
        ((Standards.NACEBEL2003, "15880"), (Standards.NACEBEL2008, "10860")),
        ((Standards.NACEBEL2003, "1588001"), (Standards.NACEBEL2008, "1086001")),
        ((Standards.NACEBEL2003, "1588002"), (Standards.NACEBEL2008, "10860")),
        ((Standards.NACEBEL2003, "1588003"), (Standards.NACEBEL2008, "10860")),
        ((Standards.NACEBEL2003, "1588004"), (Standards.NACEBEL2008, "10860")),
        ((Standards.NACEBEL2003, "1588005"), (Standards.NACEBEL2008, "10860")),
        ((Standards.NACEBEL2003, "1588006"), (Standards.NACEBEL2008, "10860")),
        ((Standards.NACEBEL2003, "1588007"), (Standards.NACEBEL2008, "10860")),
        ((Standards.NACEBEL2003, "1588008"), (Standards.NACEBEL2008, "10860")),
        ((Standards.NACEBEL2003, "1588009"), (Standards.NACEBEL2008, "10860")),
        ((Standards.NACEBEL2003, "15890"), (Standards.NACEBEL2008, "10890")),
        ((Standards.NACEBEL2003, "1589001"), (Standards.NACEBEL2008, "1089001")),
        ((Standards.NACEBEL2003, "1589002"), (Standards.NACEBEL2008, "10890")),
        ((Standards.NACEBEL2003, "1589003"), (Standards.NACEBEL2008, "10890")),
        ((Standards.NACEBEL2003, "1589004"), (Standards.NACEBEL2008, "10890")),
        ((Standards.NACEBEL2003, "1589005"), (Standards.NACEBEL2008, "1089002")),
        ((Standards.NACEBEL2003, "1589006"), (Standards.NACEBEL2008, "10890")),
        ((Standards.NACEBEL2003, "1589007"), (Standards.NACEBEL2008, "10820")),
        ((Standards.NACEBEL2003, "15910"), (Standards.NACEBEL2008, "11010")),
        ((Standards.NACEBEL2003, "1591001"), (Standards.NACEBEL2008, "1101001")),
        ((Standards.NACEBEL2003, "1591002"), (Standards.NACEBEL2008, "1101002")),
        ((Standards.NACEBEL2003, "15920"), (Standards.NACEBEL2008, "20140")),
        ((Standards.NACEBEL2003, "1592001"), (Standards.NACEBEL2008, "20140")),
        ((Standards.NACEBEL2003, "1592002"), (Standards.NACEBEL2008, "11010")),
        ((Standards.NACEBEL2003, "15930"), (Standards.NACEBEL2008, "11020")),
        ((Standards.NACEBEL2003, "1593001"), (Standards.NACEBEL2008, "1102001")),
        ((Standards.NACEBEL2003, "1593002"), (Standards.NACEBEL2008, "11020")),
        ((Standards.NACEBEL2003, "15940"), (Standards.NACEBEL2008, "11030")),
        ((Standards.NACEBEL2003, "1594001"), (Standards.NACEBEL2008, "1103001")),
        ((Standards.NACEBEL2003, "1594002"), (Standards.NACEBEL2008, "11030")),
        ((Standards.NACEBEL2003, "15950"), (Standards.NACEBEL2008, "11040")),
        ((Standards.NACEBEL2003, "1595001"), (Standards.NACEBEL2008, "1104001")),
        ((Standards.NACEBEL2003, "1595002"), (Standards.NACEBEL2008, "11040")),
        ((Standards.NACEBEL2003, "15960"), (Standards.NACEBEL2008, "11050")),
        ((Standards.NACEBEL2003, "1596001"), (Standards.NACEBEL2008, "11050")),
        ((Standards.NACEBEL2003, "15970"), (Standards.NACEBEL2008, "11060")),
        ((Standards.NACEBEL2003, "1597001"), (Standards.NACEBEL2008, "11060")),
        ((Standards.NACEBEL2003, "15980"), (Standards.NACEBEL2008, "11070")),
        ((Standards.NACEBEL2003, "1598001"), (Standards.NACEBEL2008, "1107001")),
        ((Standards.NACEBEL2003, "1598002"), (Standards.NACEBEL2008, "1107002")),
        ((Standards.NACEBEL2003, "1598003"), (Standards.NACEBEL2008, "1107003")),
        ((Standards.NACEBEL2003, "1598004"), (Standards.NACEBEL2008, "11070")),
        ((Standards.NACEBEL2003, "1598005"), (Standards.NACEBEL2008, "10510")),
        ((Standards.NACEBEL2003, "1598006"), (Standards.NACEBEL2008, "11050")),
        ((Standards.NACEBEL2003, "1598007"), (Standards.NACEBEL2008, "11020")),
        ((Standards.NACEBEL2003, "1598008"), (Standards.NACEBEL2008, "11070")),
        ((Standards.NACEBEL2003, "16000"), (Standards.NACEBEL2008, "12000")),
        ((Standards.NACEBEL2003, "1600001"), (Standards.NACEBEL2008, "1200001")),
        ((Standards.NACEBEL2003, "1600002"), (Standards.NACEBEL2008, "1200002")),
        ((Standards.NACEBEL2003, "17110"), (Standards.NACEBEL2008, "13100")),
        ((Standards.NACEBEL2003, "1711001"), (Standards.NACEBEL2008, "1310001")),
        ((Standards.NACEBEL2003, "1711002"), (Standards.NACEBEL2008, "1310002")),
        ((Standards.NACEBEL2003, "17120"), (Standards.NACEBEL2008, "13100")),
        ((Standards.NACEBEL2003, "1712001"), (Standards.NACEBEL2008, "13100")),
        ((Standards.NACEBEL2003, "1712002"), (Standards.NACEBEL2008, "13100")),
        ((Standards.NACEBEL2003, "17130"), (Standards.NACEBEL2008, "13100")),
        ((Standards.NACEBEL2003, "1713001"), (Standards.NACEBEL2008, "13100")),
        ((Standards.NACEBEL2003, "1713002"), (Standards.NACEBEL2008, "13100")),
        ((Standards.NACEBEL2003, "1713003"), (Standards.NACEBEL2008, "13100")),
        ((Standards.NACEBEL2003, "17140"), (Standards.NACEBEL2008, "13100")),
        ((Standards.NACEBEL2003, "1714001"), (Standards.NACEBEL2008, "13100")),
        ((Standards.NACEBEL2003, "1714002"), (Standards.NACEBEL2008, "1310011")),
        ((Standards.NACEBEL2003, "17150"), (Standards.NACEBEL2008, "13100")),
        ((Standards.NACEBEL2003, "1715001"), (Standards.NACEBEL2008, "13100")),
        ((Standards.NACEBEL2003, "1715002"), (Standards.NACEBEL2008, "13100")),
        ((Standards.NACEBEL2003, "1715003"), (Standards.NACEBEL2008, "13100")),
        ((Standards.NACEBEL2003, "1715004"), (Standards.NACEBEL2008, "1310021")),
        ((Standards.NACEBEL2003, "17160"), (Standards.NACEBEL2008, "13100")),
        ((Standards.NACEBEL2003, "1716001"), (Standards.NACEBEL2008, "13100")),
        ((Standards.NACEBEL2003, "1716002"), (Standards.NACEBEL2008, "1310031")),
        ((Standards.NACEBEL2003, "17170"), (Standards.NACEBEL2008, "13100")),
        ((Standards.NACEBEL2003, "1717001"), (Standards.NACEBEL2008, "1310041")),
        ((Standards.NACEBEL2003, "1717002"), (Standards.NACEBEL2008, "1310042")),
        ((Standards.NACEBEL2003, "17210"), (Standards.NACEBEL2008, "13200")),
        ((Standards.NACEBEL2003, "1721001"), (Standards.NACEBEL2008, "1320001")),
        ((Standards.NACEBEL2003, "1721002"), (Standards.NACEBEL2008, "1320002")),
        ((Standards.NACEBEL2003, "17220"), (Standards.NACEBEL2008, "13200")),
        ((Standards.NACEBEL2003, "1722001"), (Standards.NACEBEL2008, "13200")),
        ((Standards.NACEBEL2003, "17230"), (Standards.NACEBEL2008, "13200")),
        ((Standards.NACEBEL2003, "1723001"), (Standards.NACEBEL2008, "1320011")),
        ((Standards.NACEBEL2003, "17240"), (Standards.NACEBEL2008, "13200")),
        ((Standards.NACEBEL2003, "1724001"), (Standards.NACEBEL2008, "13200")),
        ((Standards.NACEBEL2003, "17250"), (Standards.NACEBEL2008, "13200")),
        ((Standards.NACEBEL2003, "1725001"), (Standards.NACEBEL2008, "13200")),
        ((Standards.NACEBEL2003, "1725002"), (Standards.NACEBEL2008, "1320021")),
        ((Standards.NACEBEL2003, "1725003"), (Standards.NACEBEL2008, "13200")),
        ((Standards.NACEBEL2003, "17300"), (Standards.NACEBEL2008, "13300")),
        ((Standards.NACEBEL2003, "17300"), (Standards.NACEBEL2008, "18120")),
        ((Standards.NACEBEL2003, "1730001"), (Standards.NACEBEL2008, "1330001")),
        ((Standards.NACEBEL2003, "1730002"), (Standards.NACEBEL2008, "1330002")),
        ((Standards.NACEBEL2003, "17401"), (Standards.NACEBEL2008, "13921")),
        ((Standards.NACEBEL2003, "1740101"), (Standards.NACEBEL2008, "1392101")),
        ((Standards.NACEBEL2003, "1740102"), (Standards.NACEBEL2008, "1392102")),
        ((Standards.NACEBEL2003, "1740103"), (Standards.NACEBEL2008, "10120")),
        ((Standards.NACEBEL2003, "1740104"), (Standards.NACEBEL2008, "13921")),
        ((Standards.NACEBEL2003, "1740105"), (Standards.NACEBEL2008, "1392103")),
        ((Standards.NACEBEL2003, "17402"), (Standards.NACEBEL2008, "13929")),
        ((Standards.NACEBEL2003, "17402"), (Standards.NACEBEL2008, "32500")),
        ((Standards.NACEBEL2003, "17402"), (Standards.NACEBEL2008, "33190")),
        ((Standards.NACEBEL2003, "17402"), (Standards.NACEBEL2008, "95290")),
        ((Standards.NACEBEL2003, "1740201"), (Standards.NACEBEL2008, "1392901")),
        ((Standards.NACEBEL2003, "1740202"), (Standards.NACEBEL2008, "1392902")),
        ((Standards.NACEBEL2003, "1740203"), (Standards.NACEBEL2008, "1392903")),
        ((Standards.NACEBEL2003, "1740204"), (Standards.NACEBEL2008, "13929")),
        ((Standards.NACEBEL2003, "1740205"), (Standards.NACEBEL2008, "13929")),
        ((Standards.NACEBEL2003, "17510"), (Standards.NACEBEL2008, "13930")),
        ((Standards.NACEBEL2003, "1751001"), (Standards.NACEBEL2008, "1393001")),
        ((Standards.NACEBEL2003, "17520"), (Standards.NACEBEL2008, "13940")),
        ((Standards.NACEBEL2003, "17520"), (Standards.NACEBEL2008, "33190")),
        ((Standards.NACEBEL2003, "1752001"), (Standards.NACEBEL2008, "13940")),
        ((Standards.NACEBEL2003, "1752002"), (Standards.NACEBEL2008, "13940")),
        ((Standards.NACEBEL2003, "1752003"), (Standards.NACEBEL2008, "13940")),
        ((Standards.NACEBEL2003, "17530"), (Standards.NACEBEL2008, "13950")),
        ((Standards.NACEBEL2003, "1753001"), (Standards.NACEBEL2008, "13950")),
        ((Standards.NACEBEL2003, "17540"), (Standards.NACEBEL2008, "13960")),
        ((Standards.NACEBEL2003, "17540"), (Standards.NACEBEL2008, "13990")),
        ((Standards.NACEBEL2003, "17540"), (Standards.NACEBEL2008, "17220")),
        ((Standards.NACEBEL2003, "1754001"), (Standards.NACEBEL2008, "1396001")),
        ((Standards.NACEBEL2003, "1754002"), (Standards.NACEBEL2008, "1399001")),
        ((Standards.NACEBEL2003, "1754003"), (Standards.NACEBEL2008, "1396002")),
        ((Standards.NACEBEL2003, "1754004"), (Standards.NACEBEL2008, "1396003")),
        ((Standards.NACEBEL2003, "1754005"), (Standards.NACEBEL2008, "1399002")),
        ((Standards.NACEBEL2003, "1754006"), (Standards.NACEBEL2008, "1396004")),
        ((Standards.NACEBEL2003, "1754007"), (Standards.NACEBEL2008, "17220")),
        ((Standards.NACEBEL2003, "1754008"), (Standards.NACEBEL2008, "13960")),
        ((Standards.NACEBEL2003, "1754009"), (Standards.NACEBEL2008, "13990")),
        ((Standards.NACEBEL2003, "1754010"), (Standards.NACEBEL2008, "13960")),
        ((Standards.NACEBEL2003, "1754011"), (Standards.NACEBEL2008, "13960")),
        ((Standards.NACEBEL2003, "1754012"), (Standards.NACEBEL2008, "13960")),
        ((Standards.NACEBEL2003, "1754013"), (Standards.NACEBEL2008, "13990")),
        ((Standards.NACEBEL2003, "17600"), (Standards.NACEBEL2008, "13910")),
        ((Standards.NACEBEL2003, "1760001"), (Standards.NACEBEL2008, "13910")),
        ((Standards.NACEBEL2003, "17710"), (Standards.NACEBEL2008, "14310")),
        ((Standards.NACEBEL2003, "17710"), (Standards.NACEBEL2008, "14199")),
        ((Standards.NACEBEL2003, "1771001"), (Standards.NACEBEL2008, "14310")),
        ((Standards.NACEBEL2003, "17720"), (Standards.NACEBEL2008, "14390")),
        ((Standards.NACEBEL2003, "1772001"), (Standards.NACEBEL2008, "14390")),
        ((Standards.NACEBEL2003, "18100"), (Standards.NACEBEL2008, "14110")),
        ((Standards.NACEBEL2003, "18100"), (Standards.NACEBEL2008, "32990")),
        ((Standards.NACEBEL2003, "1810001"), (Standards.NACEBEL2008, "14110")),
        ((Standards.NACEBEL2003, "18210"), (Standards.NACEBEL2008, "14120")),
        ((Standards.NACEBEL2003, "1821001"), (Standards.NACEBEL2008, "14120")),
        ((Standards.NACEBEL2003, "1821002"), (Standards.NACEBEL2008, "3299011")),
        ((Standards.NACEBEL2003, "18221"), (Standards.NACEBEL2008, "14130")),
        ((Standards.NACEBEL2003, "1822101"), (Standards.NACEBEL2008, "1413001")),
        ((Standards.NACEBEL2003, "18222"), (Standards.NACEBEL2008, "14130")),
        ((Standards.NACEBEL2003, "1822201"), (Standards.NACEBEL2008, "1413011")),
        ((Standards.NACEBEL2003, "18230"), (Standards.NACEBEL2008, "14140")),
        ((Standards.NACEBEL2003, "1823001"), (Standards.NACEBEL2008, "1414001")),
        ((Standards.NACEBEL2003, "18241"), (Standards.NACEBEL2008, "14199")),
        ((Standards.NACEBEL2003, "1824101"), (Standards.NACEBEL2008, "14199")),
        ((Standards.NACEBEL2003, "18242"), (Standards.NACEBEL2008, "14199")),
        ((Standards.NACEBEL2003, "1824201"), (Standards.NACEBEL2008, "14199")),
        ((Standards.NACEBEL2003, "18243"), (Standards.NACEBEL2008, "14191")),
        ((Standards.NACEBEL2003, "1824301"), (Standards.NACEBEL2008, "1419101")),
        ((Standards.NACEBEL2003, "1824302"), (Standards.NACEBEL2008, "1419102")),
        ((Standards.NACEBEL2003, "18244"), (Standards.NACEBEL2008, "14199")),
        ((Standards.NACEBEL2003, "18244"), (Standards.NACEBEL2008, "32990")),
        ((Standards.NACEBEL2003, "1824401"), (Standards.NACEBEL2008, "1419901")),
        ((Standards.NACEBEL2003, "1824402"), (Standards.NACEBEL2008, "1419902")),
        ((Standards.NACEBEL2003, "18300"), (Standards.NACEBEL2008, "14200")),
        ((Standards.NACEBEL2003, "18300"), (Standards.NACEBEL2008, "13200")),
        ((Standards.NACEBEL2003, "18300"), (Standards.NACEBEL2008, "13910")),
        ((Standards.NACEBEL2003, "18300"), (Standards.NACEBEL2008, "15110")),
        ((Standards.NACEBEL2003, "1830001"), (Standards.NACEBEL2008, "1511011")),
        ((Standards.NACEBEL2003, "1830002"), (Standards.NACEBEL2008, "1420001")),
        ((Standards.NACEBEL2003, "1830003"), (Standards.NACEBEL2008, "14200")),
        ((Standards.NACEBEL2003, "1830004"), (Standards.NACEBEL2008, "1420002")),
        ((Standards.NACEBEL2003, "1830005"), (Standards.NACEBEL2008, "14200")),
        ((Standards.NACEBEL2003, "19100"), (Standards.NACEBEL2008, "15110")),
        ((Standards.NACEBEL2003, "1910001"), (Standards.NACEBEL2008, "15110")),
        ((Standards.NACEBEL2003, "1910002"), (Standards.NACEBEL2008, "1511001")),
        ((Standards.NACEBEL2003, "1910003"), (Standards.NACEBEL2008, "1511002")),
        ((Standards.NACEBEL2003, "1910004"), (Standards.NACEBEL2008, "1511003")),
        ((Standards.NACEBEL2003, "19200"), (Standards.NACEBEL2008, "15120")),
        ((Standards.NACEBEL2003, "19200"), (Standards.NACEBEL2008, "32990")),
        ((Standards.NACEBEL2003, "1920001"), (Standards.NACEBEL2008, "1512001")),
        ((Standards.NACEBEL2003, "1920002"), (Standards.NACEBEL2008, "1512002")),
        ((Standards.NACEBEL2003, "1920003"), (Standards.NACEBEL2008, "15120")),
        ((Standards.NACEBEL2003, "1920004"), (Standards.NACEBEL2008, "1512003")),
        ((Standards.NACEBEL2003, "19301"), (Standards.NACEBEL2008, "15200")),
        ((Standards.NACEBEL2003, "19301"), (Standards.NACEBEL2008, "16291")),
        ((Standards.NACEBEL2003, "19301"), (Standards.NACEBEL2008, "22190")),
        ((Standards.NACEBEL2003, "19301"), (Standards.NACEBEL2008, "22290")),
        ((Standards.NACEBEL2003, "1930101"), (Standards.NACEBEL2008, "1520001")),
        ((Standards.NACEBEL2003, "1930102"), (Standards.NACEBEL2008, "15200")),
        ((Standards.NACEBEL2003, "1930103"), (Standards.NACEBEL2008, "1520002")),
        ((Standards.NACEBEL2003, "19302"), (Standards.NACEBEL2008, "15200")),
        ((Standards.NACEBEL2003, "19302"), (Standards.NACEBEL2008, "16291")),
        ((Standards.NACEBEL2003, "19302"), (Standards.NACEBEL2008, "22190")),
        ((Standards.NACEBEL2003, "19302"), (Standards.NACEBEL2008, "22290")),
        ((Standards.NACEBEL2003, "1930201"), (Standards.NACEBEL2008, "15200")),
        ((Standards.NACEBEL2003, "1930202"), (Standards.NACEBEL2008, "22190")),
        ((Standards.NACEBEL2003, "20101"), (Standards.NACEBEL2008, "16100")),
        ((Standards.NACEBEL2003, "2010101"), (Standards.NACEBEL2008, "1610001")),
        ((Standards.NACEBEL2003, "2010102"), (Standards.NACEBEL2008, "1610002")),
        ((Standards.NACEBEL2003, "2010103"), (Standards.NACEBEL2008, "1610003")),
        ((Standards.NACEBEL2003, "2010104"), (Standards.NACEBEL2008, "1610004")),
        ((Standards.NACEBEL2003, "2010105"), (Standards.NACEBEL2008, "1610005")),
        ((Standards.NACEBEL2003, "20102"), (Standards.NACEBEL2008, "16100")),
        ((Standards.NACEBEL2003, "2010201"), (Standards.NACEBEL2008, "1610011")),
        ((Standards.NACEBEL2003, "20200"), (Standards.NACEBEL2008, "16210")),
        ((Standards.NACEBEL2003, "2020001"), (Standards.NACEBEL2008, "1621001")),
        ((Standards.NACEBEL2003, "2020002"), (Standards.NACEBEL2008, "1621002")),
        ((Standards.NACEBEL2003, "20300"), (Standards.NACEBEL2008, "16230")),
        ((Standards.NACEBEL2003, "20300"), (Standards.NACEBEL2008, "16220")),
        ((Standards.NACEBEL2003, "20300"), (Standards.NACEBEL2008, "43320")),
        ((Standards.NACEBEL2003, "20301"), (Standards.NACEBEL2008, "16230")),
        ((Standards.NACEBEL2003, "2030101"), (Standards.NACEBEL2008, "16230")),
        ((Standards.NACEBEL2003, "2030102"), (Standards.NACEBEL2008, "16230")),
        ((Standards.NACEBEL2003, "2030103"), (Standards.NACEBEL2008, "16230")),
        ((Standards.NACEBEL2003, "2030104"), (Standards.NACEBEL2008, "16230")),
        ((Standards.NACEBEL2003, "2030105"), (Standards.NACEBEL2008, "16220")),
        ((Standards.NACEBEL2003, "2030106"), (Standards.NACEBEL2008, "16230")),
        ((Standards.NACEBEL2003, "2030107"), (Standards.NACEBEL2008, "16230")),
        ((Standards.NACEBEL2003, "20400"), (Standards.NACEBEL2008, "16240")),
        ((Standards.NACEBEL2003, "20400"), (Standards.NACEBEL2008, "33190")),
        ((Standards.NACEBEL2003, "2040001"), (Standards.NACEBEL2008, "1624001")),
        ((Standards.NACEBEL2003, "2040002"), (Standards.NACEBEL2008, "1624002")),
        ((Standards.NACEBEL2003, "2040003"), (Standards.NACEBEL2008, "1624003")),
        ((Standards.NACEBEL2003, "2040004"), (Standards.NACEBEL2008, "16240")),
        ((Standards.NACEBEL2003, "20510"), (Standards.NACEBEL2008, "16291")),
        ((Standards.NACEBEL2003, "20510"), (Standards.NACEBEL2008, "32990")),
        ((Standards.NACEBEL2003, "20510"), (Standards.NACEBEL2008, "33190")),
        ((Standards.NACEBEL2003, "2051001"), (Standards.NACEBEL2008, "1629101")),
        ((Standards.NACEBEL2003, "2051002"), (Standards.NACEBEL2008, "1629102")),
        ((Standards.NACEBEL2003, "2051003"), (Standards.NACEBEL2008, "1629103")),
        ((Standards.NACEBEL2003, "2051004"), (Standards.NACEBEL2008, "1629104")),
        ((Standards.NACEBEL2003, "2051005"), (Standards.NACEBEL2008, "1629105")),
        ((Standards.NACEBEL2003, "2051006"), (Standards.NACEBEL2008, "1629106")),
        ((Standards.NACEBEL2003, "2051007"), (Standards.NACEBEL2008, "3299021")),
        ((Standards.NACEBEL2003, "2051008"), (Standards.NACEBEL2008, "1629107")),
        ((Standards.NACEBEL2003, "2051009"), (Standards.NACEBEL2008, "1629108")),
        ((Standards.NACEBEL2003, "20520"), (Standards.NACEBEL2008, "16292")),
        ((Standards.NACEBEL2003, "20520"), (Standards.NACEBEL2008, "32990")),
        ((Standards.NACEBEL2003, "2052001"), (Standards.NACEBEL2008, "1629201")),
        ((Standards.NACEBEL2003, "2052002"), (Standards.NACEBEL2008, "16292")),
        ((Standards.NACEBEL2003, "2052003"), (Standards.NACEBEL2008, "1629202")),
        ((Standards.NACEBEL2003, "2052004"), (Standards.NACEBEL2008, "16292")),
        ((Standards.NACEBEL2003, "21110"), (Standards.NACEBEL2008, "17110")),
        ((Standards.NACEBEL2003, "2111001"), (Standards.NACEBEL2008, "17110")),
        ((Standards.NACEBEL2003, "21121"), (Standards.NACEBEL2008, "17120")),
        ((Standards.NACEBEL2003, "2112101"), (Standards.NACEBEL2008, "17120")),
        ((Standards.NACEBEL2003, "2112102"), (Standards.NACEBEL2008, "1712001")),
        ((Standards.NACEBEL2003, "2112103"), (Standards.NACEBEL2008, "2399011")),
        ((Standards.NACEBEL2003, "2112104"), (Standards.NACEBEL2008, "17120")),
        ((Standards.NACEBEL2003, "2112105"), (Standards.NACEBEL2008, "1712002")),
        ((Standards.NACEBEL2003, "2112106"), (Standards.NACEBEL2008, "1712003")),
        ((Standards.NACEBEL2003, "2112107"), (Standards.NACEBEL2008, "17120")),
        ((Standards.NACEBEL2003, "21122"), (Standards.NACEBEL2008, "17120")),
        ((Standards.NACEBEL2003, "2112201"), (Standards.NACEBEL2008, "17120")),
        ((Standards.NACEBEL2003, "2112202"), (Standards.NACEBEL2008, "1712011")),
        ((Standards.NACEBEL2003, "21210"), (Standards.NACEBEL2008, "17210")),
        ((Standards.NACEBEL2003, "2121001"), (Standards.NACEBEL2008, "1721001")),
        ((Standards.NACEBEL2003, "2121002"), (Standards.NACEBEL2008, "1721002")),
        ((Standards.NACEBEL2003, "2121003"), (Standards.NACEBEL2008, "1721003")),
        ((Standards.NACEBEL2003, "2121004"), (Standards.NACEBEL2008, "17210")),
        ((Standards.NACEBEL2003, "2121005"), (Standards.NACEBEL2008, "1721004")),
        ((Standards.NACEBEL2003, "2121006"), (Standards.NACEBEL2008, "17210")),
        ((Standards.NACEBEL2003, "2121007"), (Standards.NACEBEL2008, "17210")),
        ((Standards.NACEBEL2003, "21220"), (Standards.NACEBEL2008, "17220")),
        ((Standards.NACEBEL2003, "21220"), (Standards.NACEBEL2008, "18120")),
        ((Standards.NACEBEL2003, "2122001"), (Standards.NACEBEL2008, "17220")),
        ((Standards.NACEBEL2003, "21230"), (Standards.NACEBEL2008, "17230")),
        ((Standards.NACEBEL2003, "2123001"), (Standards.NACEBEL2008, "17230")),
        ((Standards.NACEBEL2003, "2123002"), (Standards.NACEBEL2008, "17230")),
        ((Standards.NACEBEL2003, "2123003"), (Standards.NACEBEL2008, "17230")),
        ((Standards.NACEBEL2003, "2123004"), (Standards.NACEBEL2008, "17230")),
        ((Standards.NACEBEL2003, "2123005"), (Standards.NACEBEL2008, "17230")),
        ((Standards.NACEBEL2003, "2123006"), (Standards.NACEBEL2008, "1723001")),
        ((Standards.NACEBEL2003, "2123007"), (Standards.NACEBEL2008, "17230")),
        ((Standards.NACEBEL2003, "21240"), (Standards.NACEBEL2008, "17240")),
        ((Standards.NACEBEL2003, "2124001"), (Standards.NACEBEL2008, "17240")),
        ((Standards.NACEBEL2003, "2124002"), (Standards.NACEBEL2008, "17240")),
        ((Standards.NACEBEL2003, "21250"), (Standards.NACEBEL2008, "17290")),
        ((Standards.NACEBEL2003, "2125001"), (Standards.NACEBEL2008, "1729001")),
        ((Standards.NACEBEL2003, "2125002"), (Standards.NACEBEL2008, "17290")),
        ((Standards.NACEBEL2003, "2125003"), (Standards.NACEBEL2008, "17290")),
        ((Standards.NACEBEL2003, "2125004"), (Standards.NACEBEL2008, "17290")),
        ((Standards.NACEBEL2003, "2125005"), (Standards.NACEBEL2008, "17290")),
        ((Standards.NACEBEL2003, "22110"), (Standards.NACEBEL2008, "58110")),
        ((Standards.NACEBEL2003, "22110"), (Standards.NACEBEL2008, "32990")),
        ((Standards.NACEBEL2003, "22110"), (Standards.NACEBEL2008, "58120")),
        ((Standards.NACEBEL2003, "2211001"), (Standards.NACEBEL2008, "5811001")),
        ((Standards.NACEBEL2003, "2211002"), (Standards.NACEBEL2008, "5811002")),
        ((Standards.NACEBEL2003, "2211003"), (Standards.NACEBEL2008, "5811003")),
        ((Standards.NACEBEL2003, "2211004"), (Standards.NACEBEL2008, "5920311")),
        ((Standards.NACEBEL2003, "22120"), (Standards.NACEBEL2008, "58130")),
        ((Standards.NACEBEL2003, "2212001"), (Standards.NACEBEL2008, "5813001")),
        ((Standards.NACEBEL2003, "22130"), (Standards.NACEBEL2008, "58140")),
        ((Standards.NACEBEL2003, "2213001"), (Standards.NACEBEL2008, "5814001")),
        ((Standards.NACEBEL2003, "22140"), (Standards.NACEBEL2008, "59203")),
        ((Standards.NACEBEL2003, "2214001"), (Standards.NACEBEL2008, "5920301")),
        ((Standards.NACEBEL2003, "2214002"), (Standards.NACEBEL2008, "5920302")),
        ((Standards.NACEBEL2003, "22150"), (Standards.NACEBEL2008, "58190")),
        ((Standards.NACEBEL2003, "2215001"), (Standards.NACEBEL2008, "5819001")),
        ((Standards.NACEBEL2003, "22210"), (Standards.NACEBEL2008, "18110")),
        ((Standards.NACEBEL2003, "2221001"), (Standards.NACEBEL2008, "1811001")),
        ((Standards.NACEBEL2003, "22220"), (Standards.NACEBEL2008, "18120")),
        ((Standards.NACEBEL2003, "2222001"), (Standards.NACEBEL2008, "1812001")),
        ((Standards.NACEBEL2003, "22230"), (Standards.NACEBEL2008, "18140")),
        ((Standards.NACEBEL2003, "2223001"), (Standards.NACEBEL2008, "1814001")),
        ((Standards.NACEBEL2003, "2223002"), (Standards.NACEBEL2008, "1814002")),
        ((Standards.NACEBEL2003, "22240"), (Standards.NACEBEL2008, "18130")),
        ((Standards.NACEBEL2003, "2224001"), (Standards.NACEBEL2008, "1813001")),
        ((Standards.NACEBEL2003, "2224002"), (Standards.NACEBEL2008, "1813002")),
        ((Standards.NACEBEL2003, "22250"), (Standards.NACEBEL2008, "18130")),
        ((Standards.NACEBEL2003, "2225001"), (Standards.NACEBEL2008, "1813011")),
        ((Standards.NACEBEL2003, "2225002"), (Standards.NACEBEL2008, "1813012")),
        ((Standards.NACEBEL2003, "2225003"), (Standards.NACEBEL2008, "1813013")),
        ((Standards.NACEBEL2003, "22310"), (Standards.NACEBEL2008, "18200")),
        ((Standards.NACEBEL2003, "2231001"), (Standards.NACEBEL2008, "1820001")),
        ((Standards.NACEBEL2003, "22320"), (Standards.NACEBEL2008, "18200")),
        ((Standards.NACEBEL2003, "2232001"), (Standards.NACEBEL2008, "1820011")),
        ((Standards.NACEBEL2003, "22330"), (Standards.NACEBEL2008, "18200")),
        ((Standards.NACEBEL2003, "2233001"), (Standards.NACEBEL2008, "1820021")),
        ((Standards.NACEBEL2003, "23100"), (Standards.NACEBEL2008, "19100")),
        ((Standards.NACEBEL2003, "2310001"), (Standards.NACEBEL2008, "19100")),
        ((Standards.NACEBEL2003, "2310002"), (Standards.NACEBEL2008, "19100")),
        ((Standards.NACEBEL2003, "2310003"), (Standards.NACEBEL2008, "19100")),
        ((Standards.NACEBEL2003, "23200"), (Standards.NACEBEL2008, "19200")),
        ((Standards.NACEBEL2003, "2320001"), (Standards.NACEBEL2008, "1920001")),
        ((Standards.NACEBEL2003, "2320002"), (Standards.NACEBEL2008, "19200")),
        ((Standards.NACEBEL2003, "2320003"), (Standards.NACEBEL2008, "19200")),
        ((Standards.NACEBEL2003, "2320004"), (Standards.NACEBEL2008, "19200")),
        ((Standards.NACEBEL2003, "2320005"), (Standards.NACEBEL2008, "19200")),
        ((Standards.NACEBEL2003, "2320006"), (Standards.NACEBEL2008, "19200")),
        ((Standards.NACEBEL2003, "23300"), (Standards.NACEBEL2008, "38222")),
        ((Standards.NACEBEL2003, "23300"), (Standards.NACEBEL2008, "20130")),
        ((Standards.NACEBEL2003, "23300"), (Standards.NACEBEL2008, "21209")),
        ((Standards.NACEBEL2003, "23300"), (Standards.NACEBEL2008, "24460")),
        ((Standards.NACEBEL2003, "2330001"), (Standards.NACEBEL2008, "20130")),
        ((Standards.NACEBEL2003, "2330002"), (Standards.NACEBEL2008, "24460")),
        ((Standards.NACEBEL2003, "2330003"), (Standards.NACEBEL2008, "21209")),
        ((Standards.NACEBEL2003, "2330004"), (Standards.NACEBEL2008, "3822201")),
        ((Standards.NACEBEL2003, "24110"), (Standards.NACEBEL2008, "20110")),
        ((Standards.NACEBEL2003, "2411001"), (Standards.NACEBEL2008, "2011001")),
        ((Standards.NACEBEL2003, "2411002"), (Standards.NACEBEL2008, "20110")),
        ((Standards.NACEBEL2003, "2411003"), (Standards.NACEBEL2008, "20110")),
        ((Standards.NACEBEL2003, "2411004"), (Standards.NACEBEL2008, "2011002")),
        ((Standards.NACEBEL2003, "2411005"), (Standards.NACEBEL2008, "20110")),
        ((Standards.NACEBEL2003, "2411006"), (Standards.NACEBEL2008, "20110")),
        ((Standards.NACEBEL2003, "24120"), (Standards.NACEBEL2008, "20120")),
        ((Standards.NACEBEL2003, "2412001"), (Standards.NACEBEL2008, "2012001")),
        ((Standards.NACEBEL2003, "2412002"), (Standards.NACEBEL2008, "20120")),
        ((Standards.NACEBEL2003, "24130"), (Standards.NACEBEL2008, "20130")),
        ((Standards.NACEBEL2003, "2413001"), (Standards.NACEBEL2008, "2013001")),
        ((Standards.NACEBEL2003, "2413002"), (Standards.NACEBEL2008, "20130")),
        ((Standards.NACEBEL2003, "2413003"), (Standards.NACEBEL2008, "2013002")),
        ((Standards.NACEBEL2003, "2413004"), (Standards.NACEBEL2008, "20130")),
        ((Standards.NACEBEL2003, "2413005"), (Standards.NACEBEL2008, "2013003")),
        ((Standards.NACEBEL2003, "2413006"), (Standards.NACEBEL2008, "2013004")),
        ((Standards.NACEBEL2003, "2413007"), (Standards.NACEBEL2008, "20130")),
        ((Standards.NACEBEL2003, "24140"), (Standards.NACEBEL2008, "20140")),
        ((Standards.NACEBEL2003, "24140"), (Standards.NACEBEL2008, "19100")),
        ((Standards.NACEBEL2003, "2414001"), (Standards.NACEBEL2008, "2014001")),
        ((Standards.NACEBEL2003, "2414002"), (Standards.NACEBEL2008, "20140")),
        ((Standards.NACEBEL2003, "2414003"), (Standards.NACEBEL2008, "20140")),
        ((Standards.NACEBEL2003, "2414004"), (Standards.NACEBEL2008, "20140")),
        ((Standards.NACEBEL2003, "2414005"), (Standards.NACEBEL2008, "20140")),
        ((Standards.NACEBEL2003, "2414006"), (Standards.NACEBEL2008, "20140")),
        ((Standards.NACEBEL2003, "2414007"), (Standards.NACEBEL2008, "20140")),
        ((Standards.NACEBEL2003, "2414008"), (Standards.NACEBEL2008, "20140")),
        ((Standards.NACEBEL2003, "2414009"), (Standards.NACEBEL2008, "20140")),
        ((Standards.NACEBEL2003, "2414010"), (Standards.NACEBEL2008, "20140")),
        ((Standards.NACEBEL2003, "2414011"), (Standards.NACEBEL2008, "19100")),
        ((Standards.NACEBEL2003, "2414012"), (Standards.NACEBEL2008, "2014002")),
        ((Standards.NACEBEL2003, "24151"), (Standards.NACEBEL2008, "20150")),
        ((Standards.NACEBEL2003, "2415101"), (Standards.NACEBEL2008, "2015001")),
        ((Standards.NACEBEL2003, "24152"), (Standards.NACEBEL2008, "20150")),
        ((Standards.NACEBEL2003, "2415201"), (Standards.NACEBEL2008, "20150")),
        ((Standards.NACEBEL2003, "24160"), (Standards.NACEBEL2008, "20160")),
        ((Standards.NACEBEL2003, "2416001"), (Standards.NACEBEL2008, "2016001")),
        ((Standards.NACEBEL2003, "2416002"), (Standards.NACEBEL2008, "20160")),
        ((Standards.NACEBEL2003, "2416003"), (Standards.NACEBEL2008, "20160")),
        ((Standards.NACEBEL2003, "2416004"), (Standards.NACEBEL2008, "20160")),
        ((Standards.NACEBEL2003, "2416005"), (Standards.NACEBEL2008, "20160")),
        ((Standards.NACEBEL2003, "2416006"), (Standards.NACEBEL2008, "20160")),
        ((Standards.NACEBEL2003, "2416007"), (Standards.NACEBEL2008, "20160")),
        ((Standards.NACEBEL2003, "2416008"), (Standards.NACEBEL2008, "20160")),
        ((Standards.NACEBEL2003, "24170"), (Standards.NACEBEL2008, "20170")),
        ((Standards.NACEBEL2003, "2417001"), (Standards.NACEBEL2008, "2017001")),
        ((Standards.NACEBEL2003, "2417002"), (Standards.NACEBEL2008, "20170")),
        ((Standards.NACEBEL2003, "24200"), (Standards.NACEBEL2008, "20200")),
        ((Standards.NACEBEL2003, "2420001"), (Standards.NACEBEL2008, "20200")),
        ((Standards.NACEBEL2003, "24300"), (Standards.NACEBEL2008, "20300")),
        ((Standards.NACEBEL2003, "2430001"), (Standards.NACEBEL2008, "2030001")),
        ((Standards.NACEBEL2003, "2430002"), (Standards.NACEBEL2008, "2030002")),
        ((Standards.NACEBEL2003, "2430003"), (Standards.NACEBEL2008, "2030003")),
        ((Standards.NACEBEL2003, "2430004"), (Standards.NACEBEL2008, "20300")),
        ((Standards.NACEBEL2003, "2430005"), (Standards.NACEBEL2008, "20300")),
        ((Standards.NACEBEL2003, "2430006"), (Standards.NACEBEL2008, "20300")),
        ((Standards.NACEBEL2003, "2430007"), (Standards.NACEBEL2008, "20300")),
        ((Standards.NACEBEL2003, "2430008"), (Standards.NACEBEL2008, "20300")),
        ((Standards.NACEBEL2003, "24410"), (Standards.NACEBEL2008, "21100")),
        ((Standards.NACEBEL2003, "2441001"), (Standards.NACEBEL2008, "2110001")),
        ((Standards.NACEBEL2003, "2441002"), (Standards.NACEBEL2008, "2110002")),
        ((Standards.NACEBEL2003, "2441003"), (Standards.NACEBEL2008, "2110003")),
        ((Standards.NACEBEL2003, "2441004"), (Standards.NACEBEL2008, "21100")),
        ((Standards.NACEBEL2003, "2441005"), (Standards.NACEBEL2008, "20140")),
        ((Standards.NACEBEL2003, "2441006"), (Standards.NACEBEL2008, "2110004")),
        ((Standards.NACEBEL2003, "24421"), (Standards.NACEBEL2008, "21201")),
        ((Standards.NACEBEL2003, "2442101"), (Standards.NACEBEL2008, "21201")),
        ((Standards.NACEBEL2003, "2442102"), (Standards.NACEBEL2008, "21201")),
        ((Standards.NACEBEL2003, "2442103"), (Standards.NACEBEL2008, "2120101")),
        ((Standards.NACEBEL2003, "2442104"), (Standards.NACEBEL2008, "2120102")),
        ((Standards.NACEBEL2003, "2442105"), (Standards.NACEBEL2008, "2120103")),
        ((Standards.NACEBEL2003, "2442106"), (Standards.NACEBEL2008, "2120104")),
        ((Standards.NACEBEL2003, "24422"), (Standards.NACEBEL2008, "21209")),
        ((Standards.NACEBEL2003, "24422"), (Standards.NACEBEL2008, "32500")),
        ((Standards.NACEBEL2003, "2442201"), (Standards.NACEBEL2008, "32500")),
        ((Standards.NACEBEL2003, "2442202"), (Standards.NACEBEL2008, "21209")),
        ((Standards.NACEBEL2003, "24511"), (Standards.NACEBEL2008, "20411")),
        ((Standards.NACEBEL2003, "24511"), (Standards.NACEBEL2008, "20420")),
        ((Standards.NACEBEL2003, "2451101"), (Standards.NACEBEL2008, "20411")),
        ((Standards.NACEBEL2003, "2451102"), (Standards.NACEBEL2008, "2041101")),
        ((Standards.NACEBEL2003, "2451103"), (Standards.NACEBEL2008, "20411")),
        ((Standards.NACEBEL2003, "2451104"), (Standards.NACEBEL2008, "20411")),
        ((Standards.NACEBEL2003, "24512"), (Standards.NACEBEL2008, "20412")),
        ((Standards.NACEBEL2003, "2451201"), (Standards.NACEBEL2008, "2041201")),
        ((Standards.NACEBEL2003, "2451202"), (Standards.NACEBEL2008, "2041202")),
        ((Standards.NACEBEL2003, "2451203"), (Standards.NACEBEL2008, "20412")),
        ((Standards.NACEBEL2003, "2451204"), (Standards.NACEBEL2008, "20412")),
        ((Standards.NACEBEL2003, "2451205"), (Standards.NACEBEL2008, "20412")),
        ((Standards.NACEBEL2003, "24520"), (Standards.NACEBEL2008, "20420")),
        ((Standards.NACEBEL2003, "2452001"), (Standards.NACEBEL2008, "2042001")),
        ((Standards.NACEBEL2003, "2452002"), (Standards.NACEBEL2008, "2042002")),
        ((Standards.NACEBEL2003, "2452003"), (Standards.NACEBEL2008, "20420")),
        ((Standards.NACEBEL2003, "2452004"), (Standards.NACEBEL2008, "2042003")),
        ((Standards.NACEBEL2003, "2452005"), (Standards.NACEBEL2008, "2042004")),
        ((Standards.NACEBEL2003, "2452006"), (Standards.NACEBEL2008, "20420")),
        ((Standards.NACEBEL2003, "2452007"), (Standards.NACEBEL2008, "20420")),
        ((Standards.NACEBEL2003, "2452008"), (Standards.NACEBEL2008, "20420")),
        ((Standards.NACEBEL2003, "2452009"), (Standards.NACEBEL2008, "2042005")),
        ((Standards.NACEBEL2003, "24610"), (Standards.NACEBEL2008, "20510")),
        ((Standards.NACEBEL2003, "2461001"), (Standards.NACEBEL2008, "2051001")),
        ((Standards.NACEBEL2003, "2461002"), (Standards.NACEBEL2008, "20510")),
        ((Standards.NACEBEL2003, "2461003"), (Standards.NACEBEL2008, "2051002")),
        ((Standards.NACEBEL2003, "2461004"), (Standards.NACEBEL2008, "20510")),
        ((Standards.NACEBEL2003, "24620"), (Standards.NACEBEL2008, "20520")),
        ((Standards.NACEBEL2003, "24620"), (Standards.NACEBEL2008, "20590")),
        ((Standards.NACEBEL2003, "2462001"), (Standards.NACEBEL2008, "2059021")),
        ((Standards.NACEBEL2003, "2462002"), (Standards.NACEBEL2008, "20520")),
        ((Standards.NACEBEL2003, "2462003"), (Standards.NACEBEL2008, "2052001")),
        ((Standards.NACEBEL2003, "24630"), (Standards.NACEBEL2008, "20530")),
        ((Standards.NACEBEL2003, "2463001"), (Standards.NACEBEL2008, "2053001")),
        ((Standards.NACEBEL2003, "2463002"), (Standards.NACEBEL2008, "20530")),
        ((Standards.NACEBEL2003, "2463003"), (Standards.NACEBEL2008, "20530")),
        ((Standards.NACEBEL2003, "2463004"), (Standards.NACEBEL2008, "20530")),
        ((Standards.NACEBEL2003, "24640"), (Standards.NACEBEL2008, "20590")),
        ((Standards.NACEBEL2003, "2464001"), (Standards.NACEBEL2008, "2059001")),
        ((Standards.NACEBEL2003, "2464002"), (Standards.NACEBEL2008, "20590")),
        ((Standards.NACEBEL2003, "24650"), (Standards.NACEBEL2008, "26800")),
        ((Standards.NACEBEL2003, "2465001"), (Standards.NACEBEL2008, "2680001")),
        ((Standards.NACEBEL2003, "2465002"), (Standards.NACEBEL2008, "2680002")),
        ((Standards.NACEBEL2003, "24660"), (Standards.NACEBEL2008, "20590")),
        ((Standards.NACEBEL2003, "24660"), (Standards.NACEBEL2008, "26110")),
        ((Standards.NACEBEL2003, "2466001"), (Standards.NACEBEL2008, "20590")),
        ((Standards.NACEBEL2003, "2466002"), (Standards.NACEBEL2008, "2059011")),
        ((Standards.NACEBEL2003, "2466003"), (Standards.NACEBEL2008, "2059012")),
        ((Standards.NACEBEL2003, "2466004"), (Standards.NACEBEL2008, "20590")),
        ((Standards.NACEBEL2003, "2466005"), (Standards.NACEBEL2008, "20590")),
        ((Standards.NACEBEL2003, "2466006"), (Standards.NACEBEL2008, "20590")),
        ((Standards.NACEBEL2003, "2466007"), (Standards.NACEBEL2008, "20590")),
        ((Standards.NACEBEL2003, "2466008"), (Standards.NACEBEL2008, "20590")),
        ((Standards.NACEBEL2003, "2466009"), (Standards.NACEBEL2008, "20590")),
        ((Standards.NACEBEL2003, "2466010"), (Standards.NACEBEL2008, "2059013")),
        ((Standards.NACEBEL2003, "2466011"), (Standards.NACEBEL2008, "20590")),
        ((Standards.NACEBEL2003, "24700"), (Standards.NACEBEL2008, "20600")),
        ((Standards.NACEBEL2003, "2470001"), (Standards.NACEBEL2008, "2060001")),
        ((Standards.NACEBEL2003, "2470002"), (Standards.NACEBEL2008, "20600")),
        ((Standards.NACEBEL2003, "2470003"), (Standards.NACEBEL2008, "20600")),
        ((Standards.NACEBEL2003, "2470004"), (Standards.NACEBEL2008, "20600")),
        ((Standards.NACEBEL2003, "25110"), (Standards.NACEBEL2008, "22110")),
        ((Standards.NACEBEL2003, "2511001"), (Standards.NACEBEL2008, "22110")),
        ((Standards.NACEBEL2003, "2511002"), (Standards.NACEBEL2008, "22110")),
        ((Standards.NACEBEL2003, "2511003"), (Standards.NACEBEL2008, "22110")),
        ((Standards.NACEBEL2003, "25120"), (Standards.NACEBEL2008, "22110")),
        ((Standards.NACEBEL2003, "2512001"), (Standards.NACEBEL2008, "22110")),
        ((Standards.NACEBEL2003, "25130"), (Standards.NACEBEL2008, "22190")),
        ((Standards.NACEBEL2003, "25130"), (Standards.NACEBEL2008, "33190")),
        ((Standards.NACEBEL2003, "2513001"), (Standards.NACEBEL2008, "22190")),
        ((Standards.NACEBEL2003, "2513002"), (Standards.NACEBEL2008, "22190")),
        ((Standards.NACEBEL2003, "2513003"), (Standards.NACEBEL2008, "2219001")),
        ((Standards.NACEBEL2003, "2513004"), (Standards.NACEBEL2008, "22190")),
        ((Standards.NACEBEL2003, "2513005"), (Standards.NACEBEL2008, "2219002")),
        ((Standards.NACEBEL2003, "2513006"), (Standards.NACEBEL2008, "22190")),
        ((Standards.NACEBEL2003, "2513007"), (Standards.NACEBEL2008, "22190")),
        ((Standards.NACEBEL2003, "2513008"), (Standards.NACEBEL2008, "22190")),
        ((Standards.NACEBEL2003, "2513009"), (Standards.NACEBEL2008, "22190")),
        ((Standards.NACEBEL2003, "2513010"), (Standards.NACEBEL2008, "22190")),
        ((Standards.NACEBEL2003, "2513011"), (Standards.NACEBEL2008, "22190")),
        ((Standards.NACEBEL2003, "2513012"), (Standards.NACEBEL2008, "22190")),
        ((Standards.NACEBEL2003, "2513013"), (Standards.NACEBEL2008, "2219003")),
        ((Standards.NACEBEL2003, "25210"), (Standards.NACEBEL2008, "22210")),
        ((Standards.NACEBEL2003, "25210"), (Standards.NACEBEL2008, "33190")),
        ((Standards.NACEBEL2003, "25210"), (Standards.NACEBEL2008, "33200")),
        ((Standards.NACEBEL2003, "2521001"), (Standards.NACEBEL2008, "2221001")),
        ((Standards.NACEBEL2003, "2521002"), (Standards.NACEBEL2008, "2221002")),
        ((Standards.NACEBEL2003, "25220"), (Standards.NACEBEL2008, "22220")),
        ((Standards.NACEBEL2003, "2522001"), (Standards.NACEBEL2008, "22220")),
        ((Standards.NACEBEL2003, "25230"), (Standards.NACEBEL2008, "22230")),
        ((Standards.NACEBEL2003, "25230"), (Standards.NACEBEL2008, "43320")),
        ((Standards.NACEBEL2003, "2523001"), (Standards.NACEBEL2008, "2223001")),
        ((Standards.NACEBEL2003, "2523002"), (Standards.NACEBEL2008, "2223002")),
        ((Standards.NACEBEL2003, "2523003"), (Standards.NACEBEL2008, "2223003")),
        ((Standards.NACEBEL2003, "2523004"), (Standards.NACEBEL2008, "2223004")),
        ((Standards.NACEBEL2003, "25240"), (Standards.NACEBEL2008, "22290")),
        ((Standards.NACEBEL2003, "25240"), (Standards.NACEBEL2008, "27330")),
        ((Standards.NACEBEL2003, "25240"), (Standards.NACEBEL2008, "32990")),
        ((Standards.NACEBEL2003, "25240"), (Standards.NACEBEL2008, "33190")),
        ((Standards.NACEBEL2003, "2524001"), (Standards.NACEBEL2008, "22290")),
        ((Standards.NACEBEL2003, "2524002"), (Standards.NACEBEL2008, "2229001")),
        ((Standards.NACEBEL2003, "2524003"), (Standards.NACEBEL2008, "2229002")),
        ((Standards.NACEBEL2003, "2524004"), (Standards.NACEBEL2008, "2229003")),
        ((Standards.NACEBEL2003, "26110"), (Standards.NACEBEL2008, "23110")),
        ((Standards.NACEBEL2003, "2611001"), (Standards.NACEBEL2008, "2311001")),
        ((Standards.NACEBEL2003, "26120"), (Standards.NACEBEL2008, "23120")),
        ((Standards.NACEBEL2003, "2612001"), (Standards.NACEBEL2008, "2312001")),
        ((Standards.NACEBEL2003, "2612002"), (Standards.NACEBEL2008, "2312002")),
        ((Standards.NACEBEL2003, "2612003"), (Standards.NACEBEL2008, "2312003")),
        ((Standards.NACEBEL2003, "26130"), (Standards.NACEBEL2008, "23130")),
        ((Standards.NACEBEL2003, "2613001"), (Standards.NACEBEL2008, "2313001")),
        ((Standards.NACEBEL2003, "2613002"), (Standards.NACEBEL2008, "2313002")),
        ((Standards.NACEBEL2003, "2613003"), (Standards.NACEBEL2008, "2313003")),
        ((Standards.NACEBEL2003, "2613004"), (Standards.NACEBEL2008, "2313004")),
        ((Standards.NACEBEL2003, "26140"), (Standards.NACEBEL2008, "23140")),
        ((Standards.NACEBEL2003, "2614001"), (Standards.NACEBEL2008, "2314001")),
        ((Standards.NACEBEL2003, "2614002"), (Standards.NACEBEL2008, "23140")),
        ((Standards.NACEBEL2003, "2614003"), (Standards.NACEBEL2008, "23140")),
        ((Standards.NACEBEL2003, "26150"), (Standards.NACEBEL2008, "23190")),
        ((Standards.NACEBEL2003, "26150"), (Standards.NACEBEL2008, "33190")),
        ((Standards.NACEBEL2003, "26150"), (Standards.NACEBEL2008, "33200")),
        ((Standards.NACEBEL2003, "2615001"), (Standards.NACEBEL2008, "2319001")),
        ((Standards.NACEBEL2003, "2615002"), (Standards.NACEBEL2008, "23190")),
        ((Standards.NACEBEL2003, "2615003"), (Standards.NACEBEL2008, "23190")),
        ((Standards.NACEBEL2003, "2615004"), (Standards.NACEBEL2008, "2319002")),
        ((Standards.NACEBEL2003, "2615005"), (Standards.NACEBEL2008, "2319003")),
        ((Standards.NACEBEL2003, "2615006"), (Standards.NACEBEL2008, "23190")),
        ((Standards.NACEBEL2003, "2615007"), (Standards.NACEBEL2008, "23190")),
        ((Standards.NACEBEL2003, "2615008"), (Standards.NACEBEL2008, "23190")),
        ((Standards.NACEBEL2003, "26211"), (Standards.NACEBEL2008, "23410")),
        ((Standards.NACEBEL2003, "2621101"), (Standards.NACEBEL2008, "2341001")),
        ((Standards.NACEBEL2003, "2621102"), (Standards.NACEBEL2008, "2341002")),
        ((Standards.NACEBEL2003, "26212"), (Standards.NACEBEL2008, "23410")),
        ((Standards.NACEBEL2003, "2621201"), (Standards.NACEBEL2008, "2341011")),
        ((Standards.NACEBEL2003, "2621202"), (Standards.NACEBEL2008, "2341012")),
        ((Standards.NACEBEL2003, "26220"), (Standards.NACEBEL2008, "23420")),
        ((Standards.NACEBEL2003, "2622001"), (Standards.NACEBEL2008, "2342001")),
        ((Standards.NACEBEL2003, "26230"), (Standards.NACEBEL2008, "23430")),
        ((Standards.NACEBEL2003, "2623001"), (Standards.NACEBEL2008, "23430")),
        ((Standards.NACEBEL2003, "26240"), (Standards.NACEBEL2008, "23440")),
        ((Standards.NACEBEL2003, "2624001"), (Standards.NACEBEL2008, "2344001")),
        ((Standards.NACEBEL2003, "26250"), (Standards.NACEBEL2008, "23490")),
        ((Standards.NACEBEL2003, "2625001"), (Standards.NACEBEL2008, "23490")),
        ((Standards.NACEBEL2003, "2625002"), (Standards.NACEBEL2008, "2349001")),
        ((Standards.NACEBEL2003, "26260"), (Standards.NACEBEL2008, "23200")),
        ((Standards.NACEBEL2003, "2626001"), (Standards.NACEBEL2008, "2320001")),
        ((Standards.NACEBEL2003, "2626002"), (Standards.NACEBEL2008, "23200")),
        ((Standards.NACEBEL2003, "2626003"), (Standards.NACEBEL2008, "23200")),
        ((Standards.NACEBEL2003, "2626004"), (Standards.NACEBEL2008, "23200")),
        ((Standards.NACEBEL2003, "2626005"), (Standards.NACEBEL2008, "23200")),
        ((Standards.NACEBEL2003, "26300"), (Standards.NACEBEL2008, "23310")),
        ((Standards.NACEBEL2003, "2630001"), (Standards.NACEBEL2008, "2331001")),
        ((Standards.NACEBEL2003, "2630002"), (Standards.NACEBEL2008, "23310")),
        ((Standards.NACEBEL2003, "26401"), (Standards.NACEBEL2008, "23322")),
        ((Standards.NACEBEL2003, "2640101"), (Standards.NACEBEL2008, "2332201")),
        ((Standards.NACEBEL2003, "26402"), (Standards.NACEBEL2008, "23321")),
        ((Standards.NACEBEL2003, "2640201"), (Standards.NACEBEL2008, "2332101")),
        ((Standards.NACEBEL2003, "26403"), (Standards.NACEBEL2008, "23322")),
        ((Standards.NACEBEL2003, "26403"), (Standards.NACEBEL2008, "33190")),
        ((Standards.NACEBEL2003, "26403"), (Standards.NACEBEL2008, "33200")),
        ((Standards.NACEBEL2003, "2640301"), (Standards.NACEBEL2008, "2332211")),
        ((Standards.NACEBEL2003, "2640302"), (Standards.NACEBEL2008, "23322")),
        ((Standards.NACEBEL2003, "2640303"), (Standards.NACEBEL2008, "23322")),
        ((Standards.NACEBEL2003, "2640304"), (Standards.NACEBEL2008, "2332212")),
        ((Standards.NACEBEL2003, "26510"), (Standards.NACEBEL2008, "23510")),
        ((Standards.NACEBEL2003, "2651001"), (Standards.NACEBEL2008, "23510")),
        ((Standards.NACEBEL2003, "26520"), (Standards.NACEBEL2008, "23520")),
        ((Standards.NACEBEL2003, "2652001"), (Standards.NACEBEL2008, "2352001")),
        ((Standards.NACEBEL2003, "26530"), (Standards.NACEBEL2008, "23520")),
        ((Standards.NACEBEL2003, "2653001"), (Standards.NACEBEL2008, "2352011")),
        ((Standards.NACEBEL2003, "26610"), (Standards.NACEBEL2008, "23610")),
        ((Standards.NACEBEL2003, "2661001"), (Standards.NACEBEL2008, "2361001")),
        ((Standards.NACEBEL2003, "2661002"), (Standards.NACEBEL2008, "2361002")),
        ((Standards.NACEBEL2003, "26620"), (Standards.NACEBEL2008, "23620")),
        ((Standards.NACEBEL2003, "2662001"), (Standards.NACEBEL2008, "23620")),
        ((Standards.NACEBEL2003, "26630"), (Standards.NACEBEL2008, "23630")),
        ((Standards.NACEBEL2003, "2663001"), (Standards.NACEBEL2008, "2363001")),
        ((Standards.NACEBEL2003, "26640"), (Standards.NACEBEL2008, "23640")),
        ((Standards.NACEBEL2003, "2664001"), (Standards.NACEBEL2008, "23640")),
        ((Standards.NACEBEL2003, "26650"), (Standards.NACEBEL2008, "23650")),
        ((Standards.NACEBEL2003, "2665001"), (Standards.NACEBEL2008, "2365001")),
        ((Standards.NACEBEL2003, "2665002"), (Standards.NACEBEL2008, "2365002")),
        ((Standards.NACEBEL2003, "26660"), (Standards.NACEBEL2008, "23690")),
        ((Standards.NACEBEL2003, "2666001"), (Standards.NACEBEL2008, "2369001")),
        ((Standards.NACEBEL2003, "26700"), (Standards.NACEBEL2008, "23700")),
        ((Standards.NACEBEL2003, "2670001"), (Standards.NACEBEL2008, "2370001")),
        ((Standards.NACEBEL2003, "2670002"), (Standards.NACEBEL2008, "2370002")),
        ((Standards.NACEBEL2003, "2670003"), (Standards.NACEBEL2008, "2370003")),
        ((Standards.NACEBEL2003, "26810"), (Standards.NACEBEL2008, "23910")),
        ((Standards.NACEBEL2003, "26810"), (Standards.NACEBEL2008, "33190")),
        ((Standards.NACEBEL2003, "26810"), (Standards.NACEBEL2008, "33200")),
        ((Standards.NACEBEL2003, "2681001"), (Standards.NACEBEL2008, "23910")),
        ((Standards.NACEBEL2003, "2681002"), (Standards.NACEBEL2008, "23910")),
        ((Standards.NACEBEL2003, "26820"), (Standards.NACEBEL2008, "23990")),
        ((Standards.NACEBEL2003, "2682001"), (Standards.NACEBEL2008, "23990")),
        ((Standards.NACEBEL2003, "2682002"), (Standards.NACEBEL2008, "2399001")),
        ((Standards.NACEBEL2003, "2682003"), (Standards.NACEBEL2008, "23990")),
        ((Standards.NACEBEL2003, "2682004"), (Standards.NACEBEL2008, "2399002")),
        ((Standards.NACEBEL2003, "2682005"), (Standards.NACEBEL2008, "23990")),
        ((Standards.NACEBEL2003, "2682006"), (Standards.NACEBEL2008, "23990")),
        ((Standards.NACEBEL2003, "2682007"), (Standards.NACEBEL2008, "2399003")),
        ((Standards.NACEBEL2003, "27100"), (Standards.NACEBEL2008, "24100")),
        ((Standards.NACEBEL2003, "27101"), (Standards.NACEBEL2008, "24100")),
        ((Standards.NACEBEL2003, "2710101"), (Standards.NACEBEL2008, "24510")),
        ((Standards.NACEBEL2003, "2710102"), (Standards.NACEBEL2008, "24100")),
        ((Standards.NACEBEL2003, "2710103"), (Standards.NACEBEL2008, "24520")),
        ((Standards.NACEBEL2003, "2710104"), (Standards.NACEBEL2008, "19100")),
        ((Standards.NACEBEL2003, "27102"), (Standards.NACEBEL2008, "24100")),
        ((Standards.NACEBEL2003, "2710201"), (Standards.NACEBEL2008, "24100")),
        ((Standards.NACEBEL2003, "27103"), (Standards.NACEBEL2008, "24100")),
        ((Standards.NACEBEL2003, "2710301"), (Standards.NACEBEL2008, "24100")),
        ((Standards.NACEBEL2003, "2710302"), (Standards.NACEBEL2008, "24100")),
        ((Standards.NACEBEL2003, "2710303"), (Standards.NACEBEL2008, "24100")),
        ((Standards.NACEBEL2003, "2710304"), (Standards.NACEBEL2008, "24410")),
        ((Standards.NACEBEL2003, "2710305"), (Standards.NACEBEL2008, "24100")),
        ((Standards.NACEBEL2003, "2710306"), (Standards.NACEBEL2008, "24100")),
        ((Standards.NACEBEL2003, "2710307"), (Standards.NACEBEL2008, "24100")),
        ((Standards.NACEBEL2003, "27104"), (Standards.NACEBEL2008, "24100")),
        ((Standards.NACEBEL2003, "2710401"), (Standards.NACEBEL2008, "24100")),
        ((Standards.NACEBEL2003, "27210"), (Standards.NACEBEL2008, "24510")),
        ((Standards.NACEBEL2003, "2721001"), (Standards.NACEBEL2008, "24520")),
        ((Standards.NACEBEL2003, "2721002"), (Standards.NACEBEL2008, "24520")),
        ((Standards.NACEBEL2003, "27220"), (Standards.NACEBEL2008, "24200")),
        ((Standards.NACEBEL2003, "2722001"), (Standards.NACEBEL2008, "24200")),
        ((Standards.NACEBEL2003, "2722002"), (Standards.NACEBEL2008, "2420001")),
        ((Standards.NACEBEL2003, "2722003"), (Standards.NACEBEL2008, "2420002")),
        ((Standards.NACEBEL2003, "2725003"), (Standards.NACEBEL2008, "24100")),
        ((Standards.NACEBEL2003, "27310"), (Standards.NACEBEL2008, "24310")),
        ((Standards.NACEBEL2003, "2731001"), (Standards.NACEBEL2008, "24310")),
        ((Standards.NACEBEL2003, "27320"), (Standards.NACEBEL2008, "24320")),
        ((Standards.NACEBEL2003, "2732001"), (Standards.NACEBEL2008, "2432001")),
        ((Standards.NACEBEL2003, "27330"), (Standards.NACEBEL2008, "24330")),
        ((Standards.NACEBEL2003, "2733001"), (Standards.NACEBEL2008, "24330")),
        ((Standards.NACEBEL2003, "27340"), (Standards.NACEBEL2008, "24340")),
        ((Standards.NACEBEL2003, "2734001"), (Standards.NACEBEL2008, "2434001")),
        ((Standards.NACEBEL2003, "27350"), (Standards.NACEBEL2008, "24100")),
        ((Standards.NACEBEL2003, "2735001"), (Standards.NACEBEL2008, "24100")),
        ((Standards.NACEBEL2003, "2735002"), (Standards.NACEBEL2008, "24100")),
        ((Standards.NACEBEL2003, "2735003"), (Standards.NACEBEL2008, "24100")),
        ((Standards.NACEBEL2003, "2735004"), (Standards.NACEBEL2008, "24100")),
        ((Standards.NACEBEL2003, "27410"), (Standards.NACEBEL2008, "24410")),
        ((Standards.NACEBEL2003, "2741001"), (Standards.NACEBEL2008, "24410")),
        ((Standards.NACEBEL2003, "2741002"), (Standards.NACEBEL2008, "24410")),
        ((Standards.NACEBEL2003, "2741003"), (Standards.NACEBEL2008, "2441001")),
        ((Standards.NACEBEL2003, "2741004"), (Standards.NACEBEL2008, "24410")),
        ((Standards.NACEBEL2003, "2741005"), (Standards.NACEBEL2008, "24410")),
        ((Standards.NACEBEL2003, "2741006"), (Standards.NACEBEL2008, "24410")),
        ((Standards.NACEBEL2003, "2741007"), (Standards.NACEBEL2008, "24410")),
        ((Standards.NACEBEL2003, "27421"), (Standards.NACEBEL2008, "24420")),
        ((Standards.NACEBEL2003, "2742101"), (Standards.NACEBEL2008, "24420")),
        ((Standards.NACEBEL2003, "2742102"), (Standards.NACEBEL2008, "24420")),
        ((Standards.NACEBEL2003, "2742103"), (Standards.NACEBEL2008, "24420")),
        ((Standards.NACEBEL2003, "2742104"), (Standards.NACEBEL2008, "24420")),
        ((Standards.NACEBEL2003, "27422"), (Standards.NACEBEL2008, "24420")),
        ((Standards.NACEBEL2003, "2742201"), (Standards.NACEBEL2008, "24420")),
        ((Standards.NACEBEL2003, "2742202"), (Standards.NACEBEL2008, "24420")),
        ((Standards.NACEBEL2003, "2742203"), (Standards.NACEBEL2008, "24420")),
        ((Standards.NACEBEL2003, "27431"), (Standards.NACEBEL2008, "24430")),
        ((Standards.NACEBEL2003, "2743101"), (Standards.NACEBEL2008, "24430")),
        ((Standards.NACEBEL2003, "2743102"), (Standards.NACEBEL2008, "24430")),
        ((Standards.NACEBEL2003, "27432"), (Standards.NACEBEL2008, "24430")),
        ((Standards.NACEBEL2003, "2743201"), (Standards.NACEBEL2008, "24430")),
        ((Standards.NACEBEL2003, "2743202"), (Standards.NACEBEL2008, "24430")),
        ((Standards.NACEBEL2003, "27441"), (Standards.NACEBEL2008, "24440")),
        ((Standards.NACEBEL2003, "2744101"), (Standards.NACEBEL2008, "24440")),
        ((Standards.NACEBEL2003, "2744102"), (Standards.NACEBEL2008, "24440")),
        ((Standards.NACEBEL2003, "2744103"), (Standards.NACEBEL2008, "24440")),
        ((Standards.NACEBEL2003, "27442"), (Standards.NACEBEL2008, "24440")),
        ((Standards.NACEBEL2003, "2744201"), (Standards.NACEBEL2008, "24440")),
        ((Standards.NACEBEL2003, "2744202"), (Standards.NACEBEL2008, "24440")),
        ((Standards.NACEBEL2003, "2744203"), (Standards.NACEBEL2008, "24440")),
        ((Standards.NACEBEL2003, "2744204"), (Standards.NACEBEL2008, "24440")),
        ((Standards.NACEBEL2003, "27451"), (Standards.NACEBEL2008, "24450")),
        ((Standards.NACEBEL2003, "2745101"), (Standards.NACEBEL2008, "24450")),
        ((Standards.NACEBEL2003, "2745102"), (Standards.NACEBEL2008, "24450")),
        ((Standards.NACEBEL2003, "2745103"), (Standards.NACEBEL2008, "24450")),
        ((Standards.NACEBEL2003, "2745104"), (Standards.NACEBEL2008, "24450")),
        ((Standards.NACEBEL2003, "27452"), (Standards.NACEBEL2008, "24450")),
        ((Standards.NACEBEL2003, "2745201"), (Standards.NACEBEL2008, "24450")),
        ((Standards.NACEBEL2003, "2745202"), (Standards.NACEBEL2008, "24450")),
        ((Standards.NACEBEL2003, "27500"), (Standards.NACEBEL2008, "24510")),
        ((Standards.NACEBEL2003, "2750001"), (Standards.NACEBEL2008, "24510")),
        ((Standards.NACEBEL2003, "27510"), (Standards.NACEBEL2008, "24510")),
        ((Standards.NACEBEL2003, "2751001"), (Standards.NACEBEL2008, "2451001")),
        ((Standards.NACEBEL2003, "2751002"), (Standards.NACEBEL2008, "24510")),
        ((Standards.NACEBEL2003, "2751003"), (Standards.NACEBEL2008, "24510")),
        ((Standards.NACEBEL2003, "2751004"), (Standards.NACEBEL2008, "24510")),
        ((Standards.NACEBEL2003, "27520"), (Standards.NACEBEL2008, "24520")),
        ((Standards.NACEBEL2003, "2752001"), (Standards.NACEBEL2008, "2452001")),
        ((Standards.NACEBEL2003, "2752002"), (Standards.NACEBEL2008, "24520")),
        ((Standards.NACEBEL2003, "27530"), (Standards.NACEBEL2008, "24530")),
        ((Standards.NACEBEL2003, "2753001"), (Standards.NACEBEL2008, "24530")),
        ((Standards.NACEBEL2003, "2753002"), (Standards.NACEBEL2008, "24530")),
        ((Standards.NACEBEL2003, "27540"), (Standards.NACEBEL2008, "24540")),
        ((Standards.NACEBEL2003, "2754001"), (Standards.NACEBEL2008, "24540")),
        ((Standards.NACEBEL2003, "2754002"), (Standards.NACEBEL2008, "24540")),
        ((Standards.NACEBEL2003, "28110"), (Standards.NACEBEL2008, "25110")),
        ((Standards.NACEBEL2003, "28110"), (Standards.NACEBEL2008, "33110")),
        ((Standards.NACEBEL2003, "2811001"), (Standards.NACEBEL2008, "2511001")),
        ((Standards.NACEBEL2003, "2811002"), (Standards.NACEBEL2008, "2511002")),
        ((Standards.NACEBEL2003, "2811003"), (Standards.NACEBEL2008, "2511003")),
        ((Standards.NACEBEL2003, "28120"), (Standards.NACEBEL2008, "25120")),
        ((Standards.NACEBEL2003, "28120"), (Standards.NACEBEL2008, "43320")),
        ((Standards.NACEBEL2003, "2812001"), (Standards.NACEBEL2008, "2512001")),
        ((Standards.NACEBEL2003, "28210"), (Standards.NACEBEL2008, "25290")),
        ((Standards.NACEBEL2003, "28210"), (Standards.NACEBEL2008, "33110")),
        ((Standards.NACEBEL2003, "2821001"), (Standards.NACEBEL2008, "2529001")),
        ((Standards.NACEBEL2003, "2821002"), (Standards.NACEBEL2008, "2529002")),
        ((Standards.NACEBEL2003, "28220"), (Standards.NACEBEL2008, "25210")),
        ((Standards.NACEBEL2003, "28220"), (Standards.NACEBEL2008, "33110")),
        ((Standards.NACEBEL2003, "2822001"), (Standards.NACEBEL2008, "2521001")),
        ((Standards.NACEBEL2003, "28300"), (Standards.NACEBEL2008, "25300")),
        ((Standards.NACEBEL2003, "28300"), (Standards.NACEBEL2008, "33110")),
        ((Standards.NACEBEL2003, "2830001"), (Standards.NACEBEL2008, "2530001")),
        ((Standards.NACEBEL2003, "2830002"), (Standards.NACEBEL2008, "2530002")),
        ((Standards.NACEBEL2003, "2830003"), (Standards.NACEBEL2008, "25300")),
        ((Standards.NACEBEL2003, "2830004"), (Standards.NACEBEL2008, "2530003")),
        ((Standards.NACEBEL2003, "28401"), (Standards.NACEBEL2008, "25501")),
        ((Standards.NACEBEL2003, "2840101"), (Standards.NACEBEL2008, "2550101")),
        ((Standards.NACEBEL2003, "2840102"), (Standards.NACEBEL2008, "2550102")),
        ((Standards.NACEBEL2003, "28402"), (Standards.NACEBEL2008, "25502")),
        ((Standards.NACEBEL2003, "2840201"), (Standards.NACEBEL2008, "2550201")),
        ((Standards.NACEBEL2003, "28403"), (Standards.NACEBEL2008, "25502")),
        ((Standards.NACEBEL2003, "2840301"), (Standards.NACEBEL2008, "2550211")),
        ((Standards.NACEBEL2003, "28510"), (Standards.NACEBEL2008, "25610")),
        ((Standards.NACEBEL2003, "2851001"), (Standards.NACEBEL2008, "2561001")),
        ((Standards.NACEBEL2003, "2851002"), (Standards.NACEBEL2008, "2561002")),
        ((Standards.NACEBEL2003, "2851003"), (Standards.NACEBEL2008, "2561003")),
        ((Standards.NACEBEL2003, "2851004"), (Standards.NACEBEL2008, "2561004")),
        ((Standards.NACEBEL2003, "2851005"), (Standards.NACEBEL2008, "2561005")),
        ((Standards.NACEBEL2003, "2851006"), (Standards.NACEBEL2008, "2561006")),
        ((Standards.NACEBEL2003, "2851007"), (Standards.NACEBEL2008, "2561007")),
        ((Standards.NACEBEL2003, "28520"), (Standards.NACEBEL2008, "25620")),
        ((Standards.NACEBEL2003, "28520"), (Standards.NACEBEL2008, "01620")),
        ((Standards.NACEBEL2003, "2852001"), (Standards.NACEBEL2008, "2562001")),
        ((Standards.NACEBEL2003, "2852002"), (Standards.NACEBEL2008, "3312011")),
        ((Standards.NACEBEL2003, "2852003"), (Standards.NACEBEL2008, "0162011")),
        ((Standards.NACEBEL2003, "28610"), (Standards.NACEBEL2008, "25710")),
        ((Standards.NACEBEL2003, "28610"), (Standards.NACEBEL2008, "33110")),
        ((Standards.NACEBEL2003, "2861001"), (Standards.NACEBEL2008, "2571001")),
        ((Standards.NACEBEL2003, "2861002"), (Standards.NACEBEL2008, "25710")),
        ((Standards.NACEBEL2003, "28620"), (Standards.NACEBEL2008, "25739")),
        ((Standards.NACEBEL2003, "28620"), (Standards.NACEBEL2008, "28410")),
        ((Standards.NACEBEL2003, "28620"), (Standards.NACEBEL2008, "28490")),
        ((Standards.NACEBEL2003, "28620"), (Standards.NACEBEL2008, "28920")),
        ((Standards.NACEBEL2003, "28620"), (Standards.NACEBEL2008, "33110")),
        ((Standards.NACEBEL2003, "2862001"), (Standards.NACEBEL2008, "2573901")),
        ((Standards.NACEBEL2003, "2862002"), (Standards.NACEBEL2008, "2573902")),
        ((Standards.NACEBEL2003, "2862003"), (Standards.NACEBEL2008, "25739")),
        ((Standards.NACEBEL2003, "2862004"), (Standards.NACEBEL2008, "2573903")),
        ((Standards.NACEBEL2003, "2862005"), (Standards.NACEBEL2008, "2573904")),
        ((Standards.NACEBEL2003, "2862006"), (Standards.NACEBEL2008, "25739")),
        ((Standards.NACEBEL2003, "28630"), (Standards.NACEBEL2008, "25720")),
        ((Standards.NACEBEL2003, "28630"), (Standards.NACEBEL2008, "33110")),
        ((Standards.NACEBEL2003, "2863001"), (Standards.NACEBEL2008, "2572001")),
        ((Standards.NACEBEL2003, "2863002"), (Standards.NACEBEL2008, "2572002")),
        ((Standards.NACEBEL2003, "28710"), (Standards.NACEBEL2008, "25910")),
        ((Standards.NACEBEL2003, "28710"), (Standards.NACEBEL2008, "33110")),
        ((Standards.NACEBEL2003, "2871001"), (Standards.NACEBEL2008, "2591001")),
        ((Standards.NACEBEL2003, "2871002"), (Standards.NACEBEL2008, "2591002")),
        ((Standards.NACEBEL2003, "28720"), (Standards.NACEBEL2008, "25920")),
        ((Standards.NACEBEL2003, "2872001"), (Standards.NACEBEL2008, "2592001")),
        ((Standards.NACEBEL2003, "2872002"), (Standards.NACEBEL2008, "25920")),
        ((Standards.NACEBEL2003, "2872003"), (Standards.NACEBEL2008, "2592002")),
        ((Standards.NACEBEL2003, "28730"), (Standards.NACEBEL2008, "25930")),
        ((Standards.NACEBEL2003, "2873001"), (Standards.NACEBEL2008, "25930")),
        ((Standards.NACEBEL2003, "2873002"), (Standards.NACEBEL2008, "25930")),
        ((Standards.NACEBEL2003, "2873003"), (Standards.NACEBEL2008, "2593001")),
        ((Standards.NACEBEL2003, "2873004"), (Standards.NACEBEL2008, "2593002")),
        ((Standards.NACEBEL2003, "28741"), (Standards.NACEBEL2008, "25940")),
        ((Standards.NACEBEL2003, "2874101"), (Standards.NACEBEL2008, "25940")),
        ((Standards.NACEBEL2003, "2874102"), (Standards.NACEBEL2008, "25940")),
        ((Standards.NACEBEL2003, "28742"), (Standards.NACEBEL2008, "25930")),
        ((Standards.NACEBEL2003, "2874201"), (Standards.NACEBEL2008, "25930")),
        ((Standards.NACEBEL2003, "28743"), (Standards.NACEBEL2008, "25930")),
        ((Standards.NACEBEL2003, "2874301"), (Standards.NACEBEL2008, "2593011")),
        ((Standards.NACEBEL2003, "2874302"), (Standards.NACEBEL2008, "25930")),
        ((Standards.NACEBEL2003, "28751"), (Standards.NACEBEL2008, "25991")),
        ((Standards.NACEBEL2003, "28751"), (Standards.NACEBEL2008, "33110")),
        ((Standards.NACEBEL2003, "2875101"), (Standards.NACEBEL2008, "2599101")),
        ((Standards.NACEBEL2003, "2875102"), (Standards.NACEBEL2008, "25991")),
        ((Standards.NACEBEL2003, "2875103"), (Standards.NACEBEL2008, "25991")),
        ((Standards.NACEBEL2003, "2875104"), (Standards.NACEBEL2008, "25991")),
        ((Standards.NACEBEL2003, "28752"), (Standards.NACEBEL2008, "25991")),
        ((Standards.NACEBEL2003, "28752"), (Standards.NACEBEL2008, "33110")),
        ((Standards.NACEBEL2003, "2875201"), (Standards.NACEBEL2008, "2599111")),
        ((Standards.NACEBEL2003, "28753"), (Standards.NACEBEL2008, "25999")),
        ((Standards.NACEBEL2003, "28753"), (Standards.NACEBEL2008, "33110")),
        ((Standards.NACEBEL2003, "2875301"), (Standards.NACEBEL2008, "2599901")),
        ((Standards.NACEBEL2003, "28754"), (Standards.NACEBEL2008, "25999")),
        ((Standards.NACEBEL2003, "28754"), (Standards.NACEBEL2008, "33110")),
        ((Standards.NACEBEL2003, "2875401"), (Standards.NACEBEL2008, "25999")),
        ((Standards.NACEBEL2003, "2875402"), (Standards.NACEBEL2008, "25999")),
        ((Standards.NACEBEL2003, "28755"), (Standards.NACEBEL2008, "25999")),
        ((Standards.NACEBEL2003, "28755"), (Standards.NACEBEL2008, "25710")),
        ((Standards.NACEBEL2003, "28755"), (Standards.NACEBEL2008, "32990")),
        ((Standards.NACEBEL2003, "28755"), (Standards.NACEBEL2008, "33110")),
        ((Standards.NACEBEL2003, "2875501"), (Standards.NACEBEL2008, "25710")),
        ((Standards.NACEBEL2003, "2875502"), (Standards.NACEBEL2008, "32990")),
        ((Standards.NACEBEL2003, "2875503"), (Standards.NACEBEL2008, "2599911")),
        ((Standards.NACEBEL2003, "2875504"), (Standards.NACEBEL2008, "2599914")),
        ((Standards.NACEBEL2003, "2875505"), (Standards.NACEBEL2008, "2599912")),
        ((Standards.NACEBEL2003, "2875506"), (Standards.NACEBEL2008, "2599913")),
        ((Standards.NACEBEL2003, "2875507"), (Standards.NACEBEL2008, "25999")),
        ((Standards.NACEBEL2003, "2875508"), (Standards.NACEBEL2008, "25999")),
        ((Standards.NACEBEL2003, "29110"), (Standards.NACEBEL2008, "28110")),
        ((Standards.NACEBEL2003, "29110"), (Standards.NACEBEL2008, "27110")),
        ((Standards.NACEBEL2003, "29110"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "2911001"), (Standards.NACEBEL2008, "2811001")),
        ((Standards.NACEBEL2003, "2911002"), (Standards.NACEBEL2008, "28110")),
        ((Standards.NACEBEL2003, "2911003"), (Standards.NACEBEL2008, "2811002")),
        ((Standards.NACEBEL2003, "29120"), (Standards.NACEBEL2008, "28120")),
        ((Standards.NACEBEL2003, "29120"), (Standards.NACEBEL2008, "28130")),
        ((Standards.NACEBEL2003, "29120"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "2912001"), (Standards.NACEBEL2008, "2813001")),
        ((Standards.NACEBEL2003, "2912002"), (Standards.NACEBEL2008, "2813002")),
        ((Standards.NACEBEL2003, "2912003"), (Standards.NACEBEL2008, "2813003")),
        ((Standards.NACEBEL2003, "2912004"), (Standards.NACEBEL2008, "2812001")),
        ((Standards.NACEBEL2003, "29130"), (Standards.NACEBEL2008, "28140")),
        ((Standards.NACEBEL2003, "29130"), (Standards.NACEBEL2008, "28120")),
        ((Standards.NACEBEL2003, "29130"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "2913001"), (Standards.NACEBEL2008, "2814001")),
        ((Standards.NACEBEL2003, "2913002"), (Standards.NACEBEL2008, "28140")),
        ((Standards.NACEBEL2003, "2913003"), (Standards.NACEBEL2008, "28140")),
        ((Standards.NACEBEL2003, "29141"), (Standards.NACEBEL2008, "28150")),
        ((Standards.NACEBEL2003, "29141"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "2914101"), (Standards.NACEBEL2008, "28150")),
        ((Standards.NACEBEL2003, "29142"), (Standards.NACEBEL2008, "28150")),
        ((Standards.NACEBEL2003, "29142"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "2914201"), (Standards.NACEBEL2008, "2815001")),
        ((Standards.NACEBEL2003, "2914202"), (Standards.NACEBEL2008, "2815002")),
        ((Standards.NACEBEL2003, "2914203"), (Standards.NACEBEL2008, "2815003")),
        ((Standards.NACEBEL2003, "2914204"), (Standards.NACEBEL2008, "28150")),
        ((Standards.NACEBEL2003, "2914205"), (Standards.NACEBEL2008, "28150")),
        ((Standards.NACEBEL2003, "2914206"), (Standards.NACEBEL2008, "2812011")),
        ((Standards.NACEBEL2003, "29210"), (Standards.NACEBEL2008, "28210")),
        ((Standards.NACEBEL2003, "29210"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "2921001"), (Standards.NACEBEL2008, "2821001")),
        ((Standards.NACEBEL2003, "2921002"), (Standards.NACEBEL2008, "2821002")),
        ((Standards.NACEBEL2003, "2921003"), (Standards.NACEBEL2008, "28210")),
        ((Standards.NACEBEL2003, "29220"), (Standards.NACEBEL2008, "28220")),
        ((Standards.NACEBEL2003, "29220"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "29220"), (Standards.NACEBEL2008, "43299")),
        ((Standards.NACEBEL2003, "2922001"), (Standards.NACEBEL2008, "2822001")),
        ((Standards.NACEBEL2003, "2922002"), (Standards.NACEBEL2008, "2822002")),
        ((Standards.NACEBEL2003, "2922003"), (Standards.NACEBEL2008, "2822003")),
        ((Standards.NACEBEL2003, "2922004"), (Standards.NACEBEL2008, "2822004")),
        ((Standards.NACEBEL2003, "2922005"), (Standards.NACEBEL2008, "2822005")),
        ((Standards.NACEBEL2003, "2922006"), (Standards.NACEBEL2008, "2822006")),
        ((Standards.NACEBEL2003, "29230"), (Standards.NACEBEL2008, "28250")),
        ((Standards.NACEBEL2003, "29230"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "2923001"), (Standards.NACEBEL2008, "2825001")),
        ((Standards.NACEBEL2003, "2923002"), (Standards.NACEBEL2008, "2825002")),
        ((Standards.NACEBEL2003, "2923003"), (Standards.NACEBEL2008, "2825003")),
        ((Standards.NACEBEL2003, "2923004"), (Standards.NACEBEL2008, "2825004")),
        ((Standards.NACEBEL2003, "2923005"), (Standards.NACEBEL2008, "2825005")),
        ((Standards.NACEBEL2003, "29241"), (Standards.NACEBEL2008, "28291")),
        ((Standards.NACEBEL2003, "29241"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "2924101"), (Standards.NACEBEL2008, "2829101")),
        ((Standards.NACEBEL2003, "2924102"), (Standards.NACEBEL2008, "28291")),
        ((Standards.NACEBEL2003, "2924103"), (Standards.NACEBEL2008, "2829102")),
        ((Standards.NACEBEL2003, "29242"), (Standards.NACEBEL2008, "28292")),
        ((Standards.NACEBEL2003, "29242"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "2924201"), (Standards.NACEBEL2008, "28292")),
        ((Standards.NACEBEL2003, "29243"), (Standards.NACEBEL2008, "28293")),
        ((Standards.NACEBEL2003, "29243"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "2924301"), (Standards.NACEBEL2008, "2829301")),
        ((Standards.NACEBEL2003, "2924302"), (Standards.NACEBEL2008, "28293")),
        ((Standards.NACEBEL2003, "29244"), (Standards.NACEBEL2008, "28294")),
        ((Standards.NACEBEL2003, "29244"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "2924401"), (Standards.NACEBEL2008, "28294")),
        ((Standards.NACEBEL2003, "29245"), (Standards.NACEBEL2008, "28295")),
        ((Standards.NACEBEL2003, "29245"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "2924501"), (Standards.NACEBEL2008, "2829501")),
        ((Standards.NACEBEL2003, "2924502"), (Standards.NACEBEL2008, "28295")),
        ((Standards.NACEBEL2003, "29246"), (Standards.NACEBEL2008, "28296")),
        ((Standards.NACEBEL2003, "29246"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "2924601"), (Standards.NACEBEL2008, "28296")),
        ((Standards.NACEBEL2003, "29247"), (Standards.NACEBEL2008, "28299")),
        ((Standards.NACEBEL2003, "29247"), (Standards.NACEBEL2008, "32500")),
        ((Standards.NACEBEL2003, "29247"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "29247"), (Standards.NACEBEL2008, "33130")),
        ((Standards.NACEBEL2003, "2924701"), (Standards.NACEBEL2008, "2829901")),
        ((Standards.NACEBEL2003, "2924702"), (Standards.NACEBEL2008, "28299")),
        ((Standards.NACEBEL2003, "2924703"), (Standards.NACEBEL2008, "28299")),
        ((Standards.NACEBEL2003, "2924704"), (Standards.NACEBEL2008, "28299")),
        ((Standards.NACEBEL2003, "2924705"), (Standards.NACEBEL2008, "28299")),
        ((Standards.NACEBEL2003, "2924706"), (Standards.NACEBEL2008, "28299")),
        ((Standards.NACEBEL2003, "29310"), (Standards.NACEBEL2008, "28300")),
        ((Standards.NACEBEL2003, "2931001"), (Standards.NACEBEL2008, "2830001")),
        ((Standards.NACEBEL2003, "2931002"), (Standards.NACEBEL2008, "2830002")),
        ((Standards.NACEBEL2003, "29321"), (Standards.NACEBEL2008, "28300")),
        ((Standards.NACEBEL2003, "2932101"), (Standards.NACEBEL2008, "2830011")),
        ((Standards.NACEBEL2003, "2932102"), (Standards.NACEBEL2008, "2830012")),
        ((Standards.NACEBEL2003, "2932103"), (Standards.NACEBEL2008, "2830013")),
        ((Standards.NACEBEL2003, "2932104"), (Standards.NACEBEL2008, "2830014")),
        ((Standards.NACEBEL2003, "2932105"), (Standards.NACEBEL2008, "2830015")),
        ((Standards.NACEBEL2003, "2932106"), (Standards.NACEBEL2008, "28300")),
        ((Standards.NACEBEL2003, "2932107"), (Standards.NACEBEL2008, "2830016")),
        ((Standards.NACEBEL2003, "29322"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "29322"), (Standards.NACEBEL2008, "95220")),
        ((Standards.NACEBEL2003, "2932201"), (Standards.NACEBEL2008, "3312001")),
        ((Standards.NACEBEL2003, "2932202"), (Standards.NACEBEL2008, "3312002")),
        ((Standards.NACEBEL2003, "29401"), (Standards.NACEBEL2008, "28410")),
        ((Standards.NACEBEL2003, "2940101"), (Standards.NACEBEL2008, "28410")),
        ((Standards.NACEBEL2003, "2940102"), (Standards.NACEBEL2008, "28410")),
        ((Standards.NACEBEL2003, "2940103"), (Standards.NACEBEL2008, "28410")),
        ((Standards.NACEBEL2003, "2940104"), (Standards.NACEBEL2008, "28490")),
        ((Standards.NACEBEL2003, "29402"), (Standards.NACEBEL2008, "28299")),
        ((Standards.NACEBEL2003, "2940201"), (Standards.NACEBEL2008, "28299")),
        ((Standards.NACEBEL2003, "2940202"), (Standards.NACEBEL2008, "28299")),
        ((Standards.NACEBEL2003, "29403"), (Standards.NACEBEL2008, "28299")),
        ((Standards.NACEBEL2003, "2940301"), (Standards.NACEBEL2008, "28490")),
        ((Standards.NACEBEL2003, "2940302"), (Standards.NACEBEL2008, "28490")),
        ((Standards.NACEBEL2003, "2940303"), (Standards.NACEBEL2008, "28490")),
        ((Standards.NACEBEL2003, "29404"), (Standards.NACEBEL2008, "28240")),
        ((Standards.NACEBEL2003, "2940401"), (Standards.NACEBEL2008, "28240")),
        ((Standards.NACEBEL2003, "2940402"), (Standards.NACEBEL2008, "28240")),
        ((Standards.NACEBEL2003, "29405"), (Standards.NACEBEL2008, "28299")),
        ((Standards.NACEBEL2003, "2940501"), (Standards.NACEBEL2008, "28490")),
        ((Standards.NACEBEL2003, "29410"), (Standards.NACEBEL2008, "28240")),
        ((Standards.NACEBEL2003, "29410"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "29420"), (Standards.NACEBEL2008, "28410")),
        ((Standards.NACEBEL2003, "29420"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "29430"), (Standards.NACEBEL2008, "28299")),
        ((Standards.NACEBEL2003, "29430"), (Standards.NACEBEL2008, "27900")),
        ((Standards.NACEBEL2003, "29430"), (Standards.NACEBEL2008, "28490")),
        ((Standards.NACEBEL2003, "29430"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "29430"), (Standards.NACEBEL2008, "33140")),
        ((Standards.NACEBEL2003, "29431"), (Standards.NACEBEL2008, "27900")),
        ((Standards.NACEBEL2003, "29432"), (Standards.NACEBEL2008, "28490")),
        ((Standards.NACEBEL2003, "29433"), (Standards.NACEBEL2008, "28490")),
        ((Standards.NACEBEL2003, "29510"), (Standards.NACEBEL2008, "28910")),
        ((Standards.NACEBEL2003, "29510"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "2951001"), (Standards.NACEBEL2008, "2891001")),
        ((Standards.NACEBEL2003, "2951002"), (Standards.NACEBEL2008, "28910")),
        ((Standards.NACEBEL2003, "29520"), (Standards.NACEBEL2008, "28920")),
        ((Standards.NACEBEL2003, "29520"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "2952001"), (Standards.NACEBEL2008, "2892001")),
        ((Standards.NACEBEL2003, "2952002"), (Standards.NACEBEL2008, "28920")),
        ((Standards.NACEBEL2003, "2952003"), (Standards.NACEBEL2008, "28920")),
        ((Standards.NACEBEL2003, "2952004"), (Standards.NACEBEL2008, "28920")),
        ((Standards.NACEBEL2003, "2952005"), (Standards.NACEBEL2008, "28920")),
        ((Standards.NACEBEL2003, "2952006"), (Standards.NACEBEL2008, "2892002")),
        ((Standards.NACEBEL2003, "2952007"), (Standards.NACEBEL2008, "2892003")),
        ((Standards.NACEBEL2003, "2952008"), (Standards.NACEBEL2008, "28920")),
        ((Standards.NACEBEL2003, "2952009"), (Standards.NACEBEL2008, "28920")),
        ((Standards.NACEBEL2003, "2952010"), (Standards.NACEBEL2008, "28920")),
        ((Standards.NACEBEL2003, "2952011"), (Standards.NACEBEL2008, "28920")),
        ((Standards.NACEBEL2003, "2952012"), (Standards.NACEBEL2008, "28920")),
        ((Standards.NACEBEL2003, "29530"), (Standards.NACEBEL2008, "28930")),
        ((Standards.NACEBEL2003, "29530"), (Standards.NACEBEL2008, "28300")),
        ((Standards.NACEBEL2003, "29530"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "2953001"), (Standards.NACEBEL2008, "2893001")),
        ((Standards.NACEBEL2003, "2953002"), (Standards.NACEBEL2008, "2893002")),
        ((Standards.NACEBEL2003, "2953003"), (Standards.NACEBEL2008, "28930")),
        ((Standards.NACEBEL2003, "2953004"), (Standards.NACEBEL2008, "28930")),
        ((Standards.NACEBEL2003, "2953005"), (Standards.NACEBEL2008, "2893003")),
        ((Standards.NACEBEL2003, "2953006"), (Standards.NACEBEL2008, "2893004")),
        ((Standards.NACEBEL2003, "2953007"), (Standards.NACEBEL2008, "28930")),
        ((Standards.NACEBEL2003, "2953008"), (Standards.NACEBEL2008, "28930")),
        ((Standards.NACEBEL2003, "2953009"), (Standards.NACEBEL2008, "2893005")),
        ((Standards.NACEBEL2003, "29540"), (Standards.NACEBEL2008, "28940")),
        ((Standards.NACEBEL2003, "29540"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "2954001"), (Standards.NACEBEL2008, "2894001")),
        ((Standards.NACEBEL2003, "2954002"), (Standards.NACEBEL2008, "28940")),
        ((Standards.NACEBEL2003, "2954003"), (Standards.NACEBEL2008, "28940")),
        ((Standards.NACEBEL2003, "2954004"), (Standards.NACEBEL2008, "28940")),
        ((Standards.NACEBEL2003, "2954005"), (Standards.NACEBEL2008, "28940")),
        ((Standards.NACEBEL2003, "2954006"), (Standards.NACEBEL2008, "28940")),
        ((Standards.NACEBEL2003, "2954007"), (Standards.NACEBEL2008, "28940")),
        ((Standards.NACEBEL2003, "2954008"), (Standards.NACEBEL2008, "2894002")),
        ((Standards.NACEBEL2003, "2954009"), (Standards.NACEBEL2008, "2894003")),
        ((Standards.NACEBEL2003, "2954010"), (Standards.NACEBEL2008, "28940")),
        ((Standards.NACEBEL2003, "2954011"), (Standards.NACEBEL2008, "28940")),
        ((Standards.NACEBEL2003, "2954012"), (Standards.NACEBEL2008, "2894004")),
        ((Standards.NACEBEL2003, "2954013"), (Standards.NACEBEL2008, "2894005")),
        ((Standards.NACEBEL2003, "2954014"), (Standards.NACEBEL2008, "28940")),
        ((Standards.NACEBEL2003, "29550"), (Standards.NACEBEL2008, "28950")),
        ((Standards.NACEBEL2003, "29550"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "2955001"), (Standards.NACEBEL2008, "2895001")),
        ((Standards.NACEBEL2003, "2955002"), (Standards.NACEBEL2008, "28950")),
        ((Standards.NACEBEL2003, "2955003"), (Standards.NACEBEL2008, "28950")),
        ((Standards.NACEBEL2003, "29561"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "29561"), (Standards.NACEBEL2008, "28940")),
        ((Standards.NACEBEL2003, "29561"), (Standards.NACEBEL2008, "28990")),
        ((Standards.NACEBEL2003, "2956101"), (Standards.NACEBEL2008, "28990")),
        ((Standards.NACEBEL2003, "2956102"), (Standards.NACEBEL2008, "28990")),
        ((Standards.NACEBEL2003, "29562"), (Standards.NACEBEL2008, "28960")),
        ((Standards.NACEBEL2003, "29562"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "2956201"), (Standards.NACEBEL2008, "28960")),
        ((Standards.NACEBEL2003, "29563"), (Standards.NACEBEL2008, "25731")),
        ((Standards.NACEBEL2003, "29563"), (Standards.NACEBEL2008, "33110")),
        ((Standards.NACEBEL2003, "2956301"), (Standards.NACEBEL2008, "25731")),
        ((Standards.NACEBEL2003, "29564"), (Standards.NACEBEL2008, "28990")),
        ((Standards.NACEBEL2003, "29564"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "2956401"), (Standards.NACEBEL2008, "28990")),
        ((Standards.NACEBEL2003, "2956402"), (Standards.NACEBEL2008, "28990")),
        ((Standards.NACEBEL2003, "2956403"), (Standards.NACEBEL2008, "28990")),
        ((Standards.NACEBEL2003, "2956404"), (Standards.NACEBEL2008, "28990")),
        ((Standards.NACEBEL2003, "2956405"), (Standards.NACEBEL2008, "28990")),
        ((Standards.NACEBEL2003, "2956406"), (Standards.NACEBEL2008, "2899001")),
        ((Standards.NACEBEL2003, "2956407"), (Standards.NACEBEL2008, "28990")),
        ((Standards.NACEBEL2003, "2956408"), (Standards.NACEBEL2008, "2899002")),
        ((Standards.NACEBEL2003, "29601"), (Standards.NACEBEL2008, "25400")),
        ((Standards.NACEBEL2003, "29601"), (Standards.NACEBEL2008, "30300")),
        ((Standards.NACEBEL2003, "29601"), (Standards.NACEBEL2008, "30400")),
        ((Standards.NACEBEL2003, "29601"), (Standards.NACEBEL2008, "33110")),
        ((Standards.NACEBEL2003, "29601"), (Standards.NACEBEL2008, "33160")),
        ((Standards.NACEBEL2003, "2960101"), (Standards.NACEBEL2008, "30400")),
        ((Standards.NACEBEL2003, "2960102"), (Standards.NACEBEL2008, "2540001")),
        ((Standards.NACEBEL2003, "2960103"), (Standards.NACEBEL2008, "2540002")),
        ((Standards.NACEBEL2003, "2960104"), (Standards.NACEBEL2008, "25400")),
        ((Standards.NACEBEL2003, "2960105"), (Standards.NACEBEL2008, "25400")),
        ((Standards.NACEBEL2003, "29602"), (Standards.NACEBEL2008, "25400")),
        ((Standards.NACEBEL2003, "29602"), (Standards.NACEBEL2008, "33110")),
        ((Standards.NACEBEL2003, "2960201"), (Standards.NACEBEL2008, "25400")),
        ((Standards.NACEBEL2003, "29710"), (Standards.NACEBEL2008, "27510")),
        ((Standards.NACEBEL2003, "29710"), (Standards.NACEBEL2008, "28210")),
        ((Standards.NACEBEL2003, "29710"), (Standards.NACEBEL2008, "33140")),
        ((Standards.NACEBEL2003, "2971001"), (Standards.NACEBEL2008, "2751001")),
        ((Standards.NACEBEL2003, "2971002"), (Standards.NACEBEL2008, "27510")),
        ((Standards.NACEBEL2003, "2971003"), (Standards.NACEBEL2008, "27510")),
        ((Standards.NACEBEL2003, "2971004"), (Standards.NACEBEL2008, "27510")),
        ((Standards.NACEBEL2003, "2971005"), (Standards.NACEBEL2008, "27510")),
        ((Standards.NACEBEL2003, "2971006"), (Standards.NACEBEL2008, "2751002")),
        ((Standards.NACEBEL2003, "2971007"), (Standards.NACEBEL2008, "27510")),
        ((Standards.NACEBEL2003, "2971008"), (Standards.NACEBEL2008, "27510")),
        ((Standards.NACEBEL2003, "29720"), (Standards.NACEBEL2008, "28210")),
        ((Standards.NACEBEL2003, "29720"), (Standards.NACEBEL2008, "27520")),
        ((Standards.NACEBEL2003, "2972001"), (Standards.NACEBEL2008, "2752001")),
        ((Standards.NACEBEL2003, "2972002"), (Standards.NACEBEL2008, "2821011")),
        ((Standards.NACEBEL2003, "30010"), (Standards.NACEBEL2008, "28230")),
        ((Standards.NACEBEL2003, "3001001"), (Standards.NACEBEL2008, "2823001")),
        ((Standards.NACEBEL2003, "3001002"), (Standards.NACEBEL2008, "28230")),
        ((Standards.NACEBEL2003, "3001003"), (Standards.NACEBEL2008, "28230")),
        ((Standards.NACEBEL2003, "3001004"), (Standards.NACEBEL2008, "28230")),
        ((Standards.NACEBEL2003, "30020"), (Standards.NACEBEL2008, "26200")),
        ((Standards.NACEBEL2003, "30020"), (Standards.NACEBEL2008, "62090")),
        ((Standards.NACEBEL2003, "3002001"), (Standards.NACEBEL2008, "2620001")),
        ((Standards.NACEBEL2003, "3002002"), (Standards.NACEBEL2008, "2620002")),
        ((Standards.NACEBEL2003, "3002003"), (Standards.NACEBEL2008, "2561011")),
        ((Standards.NACEBEL2003, "31100"), (Standards.NACEBEL2008, "27110")),
        ((Standards.NACEBEL2003, "31100"), (Standards.NACEBEL2008, "26110")),
        ((Standards.NACEBEL2003, "31100"), (Standards.NACEBEL2008, "33130")),
        ((Standards.NACEBEL2003, "31100"), (Standards.NACEBEL2008, "33140")),
        ((Standards.NACEBEL2003, "3110001"), (Standards.NACEBEL2008, "2711001")),
        ((Standards.NACEBEL2003, "3110002"), (Standards.NACEBEL2008, "2711002")),
        ((Standards.NACEBEL2003, "3110003"), (Standards.NACEBEL2008, "27110")),
        ((Standards.NACEBEL2003, "3110004"), (Standards.NACEBEL2008, "27110")),
        ((Standards.NACEBEL2003, "3110005"), (Standards.NACEBEL2008, "27110")),
        ((Standards.NACEBEL2003, "3110006"), (Standards.NACEBEL2008, "27110")),
        ((Standards.NACEBEL2003, "3110007"), (Standards.NACEBEL2008, "2711003")),
        ((Standards.NACEBEL2003, "3110008"), (Standards.NACEBEL2008, "2711004")),
        ((Standards.NACEBEL2003, "3110009"), (Standards.NACEBEL2008, "2711005")),
        ((Standards.NACEBEL2003, "31200"), (Standards.NACEBEL2008, "27120")),
        ((Standards.NACEBEL2003, "31200"), (Standards.NACEBEL2008, "26110")),
        ((Standards.NACEBEL2003, "31200"), (Standards.NACEBEL2008, "27330")),
        ((Standards.NACEBEL2003, "31200"), (Standards.NACEBEL2008, "33140")),
        ((Standards.NACEBEL2003, "3120001"), (Standards.NACEBEL2008, "2733001")),
        ((Standards.NACEBEL2003, "3120002"), (Standards.NACEBEL2008, "2712002")),
        ((Standards.NACEBEL2003, "31300"), (Standards.NACEBEL2008, "27320")),
        ((Standards.NACEBEL2003, "31300"), (Standards.NACEBEL2008, "26110")),
        ((Standards.NACEBEL2003, "31300"), (Standards.NACEBEL2008, "27310")),
        ((Standards.NACEBEL2003, "31300"), (Standards.NACEBEL2008, "27900")),
        ((Standards.NACEBEL2003, "3130001"), (Standards.NACEBEL2008, "2732001")),
        ((Standards.NACEBEL2003, "3130002"), (Standards.NACEBEL2008, "27310")),
        ((Standards.NACEBEL2003, "31400"), (Standards.NACEBEL2008, "27200")),
        ((Standards.NACEBEL2003, "3140001"), (Standards.NACEBEL2008, "2720001")),
        ((Standards.NACEBEL2003, "3140002"), (Standards.NACEBEL2008, "27200")),
        ((Standards.NACEBEL2003, "31501"), (Standards.NACEBEL2008, "27401")),
        ((Standards.NACEBEL2003, "3150101"), (Standards.NACEBEL2008, "2740101")),
        ((Standards.NACEBEL2003, "3150102"), (Standards.NACEBEL2008, "27401")),
        ((Standards.NACEBEL2003, "3150103"), (Standards.NACEBEL2008, "27401")),
        ((Standards.NACEBEL2003, "3150104"), (Standards.NACEBEL2008, "27401")),
        ((Standards.NACEBEL2003, "31502"), (Standards.NACEBEL2008, "27402")),
        ((Standards.NACEBEL2003, "3150201"), (Standards.NACEBEL2008, "2740201")),
        ((Standards.NACEBEL2003, "3150202"), (Standards.NACEBEL2008, "2740202")),
        ((Standards.NACEBEL2003, "3150203"), (Standards.NACEBEL2008, "2740203")),
        ((Standards.NACEBEL2003, "3150204"), (Standards.NACEBEL2008, "2740204")),
        ((Standards.NACEBEL2003, "3150205"), (Standards.NACEBEL2008, "2740205")),
        ((Standards.NACEBEL2003, "3150206"), (Standards.NACEBEL2008, "2740206")),
        ((Standards.NACEBEL2003, "3150207"), (Standards.NACEBEL2008, "2740207")),
        ((Standards.NACEBEL2003, "31610"), (Standards.NACEBEL2008, "29310")),
        ((Standards.NACEBEL2003, "31610"), (Standards.NACEBEL2008, "27402")),
        ((Standards.NACEBEL2003, "3161001"), (Standards.NACEBEL2008, "29310")),
        ((Standards.NACEBEL2003, "3161002"), (Standards.NACEBEL2008, "2740211")),
        ((Standards.NACEBEL2003, "3161003"), (Standards.NACEBEL2008, "29310")),
        ((Standards.NACEBEL2003, "3161004"), (Standards.NACEBEL2008, "2931001")),
        ((Standards.NACEBEL2003, "3161005"), (Standards.NACEBEL2008, "3092011")),
        ((Standards.NACEBEL2003, "31621"), (Standards.NACEBEL2008, "26300")),
        ((Standards.NACEBEL2003, "31621"), (Standards.NACEBEL2008, "30200")),
        ((Standards.NACEBEL2003, "31621"), (Standards.NACEBEL2008, "33140")),
        ((Standards.NACEBEL2003, "3162101"), (Standards.NACEBEL2008, "2790011")),
        ((Standards.NACEBEL2003, "3162102"), (Standards.NACEBEL2008, "2790012")),
        ((Standards.NACEBEL2003, "31622"), (Standards.NACEBEL2008, "27900")),
        ((Standards.NACEBEL2003, "31622"), (Standards.NACEBEL2008, "23440")),
        ((Standards.NACEBEL2003, "31622"), (Standards.NACEBEL2008, "25999")),
        ((Standards.NACEBEL2003, "31622"), (Standards.NACEBEL2008, "33140")),
        ((Standards.NACEBEL2003, "3162201"), (Standards.NACEBEL2008, "27900")),
        ((Standards.NACEBEL2003, "31623"), (Standards.NACEBEL2008, "27900")),
        ((Standards.NACEBEL2003, "31623"), (Standards.NACEBEL2008, "26510")),
        ((Standards.NACEBEL2003, "31623"), (Standards.NACEBEL2008, "28990")),
        ((Standards.NACEBEL2003, "31623"), (Standards.NACEBEL2008, "33130")),
        ((Standards.NACEBEL2003, "31623"), (Standards.NACEBEL2008, "33140")),
        ((Standards.NACEBEL2003, "3162301"), (Standards.NACEBEL2008, "27900")),
        ((Standards.NACEBEL2003, "3162302"), (Standards.NACEBEL2008, "27900")),
        ((Standards.NACEBEL2003, "3162303"), (Standards.NACEBEL2008, "2790001")),
        ((Standards.NACEBEL2003, "3162304"), (Standards.NACEBEL2008, "27900")),
        ((Standards.NACEBEL2003, "3162305"), (Standards.NACEBEL2008, "2899011")),
        ((Standards.NACEBEL2003, "3162306"), (Standards.NACEBEL2008, "2790002")),
        ((Standards.NACEBEL2003, "32100"), (Standards.NACEBEL2008, "26110")),
        ((Standards.NACEBEL2003, "32100"), (Standards.NACEBEL2008, "26120")),
        ((Standards.NACEBEL2003, "32100"), (Standards.NACEBEL2008, "27900")),
        ((Standards.NACEBEL2003, "32100"), (Standards.NACEBEL2008, "33130")),
        ((Standards.NACEBEL2003, "3210001"), (Standards.NACEBEL2008, "26110")),
        ((Standards.NACEBEL2003, "3210002"), (Standards.NACEBEL2008, "26110")),
        ((Standards.NACEBEL2003, "3210003"), (Standards.NACEBEL2008, "2611001")),
        ((Standards.NACEBEL2003, "3210004"), (Standards.NACEBEL2008, "26110")),
        ((Standards.NACEBEL2003, "3210005"), (Standards.NACEBEL2008, "26110")),
        ((Standards.NACEBEL2003, "3210006"), (Standards.NACEBEL2008, "26110")),
        ((Standards.NACEBEL2003, "3210007"), (Standards.NACEBEL2008, "2611002")),
        ((Standards.NACEBEL2003, "3210008"), (Standards.NACEBEL2008, "2611003")),
        ((Standards.NACEBEL2003, "32201"), (Standards.NACEBEL2008, "26300")),
        ((Standards.NACEBEL2003, "32201"), (Standards.NACEBEL2008, "95120")),
        ((Standards.NACEBEL2003, "3220101"), (Standards.NACEBEL2008, "26300")),
        ((Standards.NACEBEL2003, "3220102"), (Standards.NACEBEL2008, "2630001")),
        ((Standards.NACEBEL2003, "3220103"), (Standards.NACEBEL2008, "26300")),
        ((Standards.NACEBEL2003, "3220104"), (Standards.NACEBEL2008, "2630002")),
        ((Standards.NACEBEL2003, "3220105"), (Standards.NACEBEL2008, "26300")),
        ((Standards.NACEBEL2003, "3220106"), (Standards.NACEBEL2008, "26300")),
        ((Standards.NACEBEL2003, "3220107"), (Standards.NACEBEL2008, "2630003")),
        ((Standards.NACEBEL2003, "32202"), (Standards.NACEBEL2008, "26300")),
        ((Standards.NACEBEL2003, "32202"), (Standards.NACEBEL2008, "95120")),
        ((Standards.NACEBEL2003, "3220201"), (Standards.NACEBEL2008, "26300")),
        ((Standards.NACEBEL2003, "3220202"), (Standards.NACEBEL2008, "26300")),
        ((Standards.NACEBEL2003, "3220203"), (Standards.NACEBEL2008, "26300")),
        ((Standards.NACEBEL2003, "32300"), (Standards.NACEBEL2008, "26400")),
        ((Standards.NACEBEL2003, "32300"), (Standards.NACEBEL2008, "26110")),
        ((Standards.NACEBEL2003, "32300"), (Standards.NACEBEL2008, "26200")),
        ((Standards.NACEBEL2003, "32300"), (Standards.NACEBEL2008, "26300")),
        ((Standards.NACEBEL2003, "32300"), (Standards.NACEBEL2008, "28230")),
        ((Standards.NACEBEL2003, "32300"), (Standards.NACEBEL2008, "33130")),
        ((Standards.NACEBEL2003, "3230001"), (Standards.NACEBEL2008, "2640001")),
        ((Standards.NACEBEL2003, "3230002"), (Standards.NACEBEL2008, "2640002")),
        ((Standards.NACEBEL2003, "3230003"), (Standards.NACEBEL2008, "26400")),
        ((Standards.NACEBEL2003, "3230004"), (Standards.NACEBEL2008, "26400")),
        ((Standards.NACEBEL2003, "3230005"), (Standards.NACEBEL2008, "26400")),
        ((Standards.NACEBEL2003, "3230006"), (Standards.NACEBEL2008, "2630011")),
        ((Standards.NACEBEL2003, "3230007"), (Standards.NACEBEL2008, "26400")),
        ((Standards.NACEBEL2003, "3230008"), (Standards.NACEBEL2008, "2640003")),
        ((Standards.NACEBEL2003, "3230009"), (Standards.NACEBEL2008, "26110")),
        ((Standards.NACEBEL2003, "33101"), (Standards.NACEBEL2008, "32500")),
        ((Standards.NACEBEL2003, "33101"), (Standards.NACEBEL2008, "26600")),
        ((Standards.NACEBEL2003, "33101"), (Standards.NACEBEL2008, "33140")),
        ((Standards.NACEBEL2003, "3310101"), (Standards.NACEBEL2008, "2660001")),
        ((Standards.NACEBEL2003, "33102"), (Standards.NACEBEL2008, "32500")),
        ((Standards.NACEBEL2003, "33102"), (Standards.NACEBEL2008, "26600")),
        ((Standards.NACEBEL2003, "33102"), (Standards.NACEBEL2008, "32990")),
        ((Standards.NACEBEL2003, "3310201"), (Standards.NACEBEL2008, "2660011")),
        ((Standards.NACEBEL2003, "3310202"), (Standards.NACEBEL2008, "3250001")),
        ((Standards.NACEBEL2003, "3310203"), (Standards.NACEBEL2008, "3250002")),
        ((Standards.NACEBEL2003, "3310204"), (Standards.NACEBEL2008, "32500")),
        ((Standards.NACEBEL2003, "3310205"), (Standards.NACEBEL2008, "32500")),
        ((Standards.NACEBEL2003, "3310206"), (Standards.NACEBEL2008, "3250003")),
        ((Standards.NACEBEL2003, "3310207"), (Standards.NACEBEL2008, "32500")),
        ((Standards.NACEBEL2003, "33103"), (Standards.NACEBEL2008, "32500")),
        ((Standards.NACEBEL2003, "33103"), (Standards.NACEBEL2008, "26600")),
        ((Standards.NACEBEL2003, "3310301"), (Standards.NACEBEL2008, "3250011")),
        ((Standards.NACEBEL2003, "33201"), (Standards.NACEBEL2008, "26510")),
        ((Standards.NACEBEL2003, "33201"), (Standards.NACEBEL2008, "26300")),
        ((Standards.NACEBEL2003, "33201"), (Standards.NACEBEL2008, "26700")),
        ((Standards.NACEBEL2003, "33201"), (Standards.NACEBEL2008, "28299")),
        ((Standards.NACEBEL2003, "33201"), (Standards.NACEBEL2008, "28990")),
        ((Standards.NACEBEL2003, "33201"), (Standards.NACEBEL2008, "32500")),
        ((Standards.NACEBEL2003, "33201"), (Standards.NACEBEL2008, "33140")),
        ((Standards.NACEBEL2003, "33202"), (Standards.NACEBEL2008, "26510")),
        ((Standards.NACEBEL2003, "33202"), (Standards.NACEBEL2008, "26300")),
        ((Standards.NACEBEL2003, "33202"), (Standards.NACEBEL2008, "26700")),
        ((Standards.NACEBEL2003, "33202"), (Standards.NACEBEL2008, "28299")),
        ((Standards.NACEBEL2003, "33202"), (Standards.NACEBEL2008, "28990")),
        ((Standards.NACEBEL2003, "33202"), (Standards.NACEBEL2008, "32500")),
        ((Standards.NACEBEL2003, "33202"), (Standards.NACEBEL2008, "33140")),
        ((Standards.NACEBEL2003, "3320201"), (Standards.NACEBEL2008, "2651001")),
        ((Standards.NACEBEL2003, "3320202"), (Standards.NACEBEL2008, "26510")),
        ((Standards.NACEBEL2003, "3320203"), (Standards.NACEBEL2008, "2651002")),
        ((Standards.NACEBEL2003, "3320204"), (Standards.NACEBEL2008, "26510")),
        ((Standards.NACEBEL2003, "3320205"), (Standards.NACEBEL2008, "26510")),
        ((Standards.NACEBEL2003, "3320206"), (Standards.NACEBEL2008, "2651003")),
        ((Standards.NACEBEL2003, "3320207"), (Standards.NACEBEL2008, "2651004")),
        ((Standards.NACEBEL2003, "3320208"), (Standards.NACEBEL2008, "26510")),
        ((Standards.NACEBEL2003, "3320209"), (Standards.NACEBEL2008, "26510")),
        ((Standards.NACEBEL2003, "3320210"), (Standards.NACEBEL2008, "26510")),
        ((Standards.NACEBEL2003, "3320211"), (Standards.NACEBEL2008, "2651005")),
        ((Standards.NACEBEL2003, "3320212"), (Standards.NACEBEL2008, "2651006")),
        ((Standards.NACEBEL2003, "33300"), (Standards.NACEBEL2008, "33200")),
        ((Standards.NACEBEL2003, "3330001"), (Standards.NACEBEL2008, "3320001")),
        ((Standards.NACEBEL2003, "3330002"), (Standards.NACEBEL2008, "3320002")),
        ((Standards.NACEBEL2003, "33401"), (Standards.NACEBEL2008, "32500")),
        ((Standards.NACEBEL2003, "3340101"), (Standards.NACEBEL2008, "3250021")),
        ((Standards.NACEBEL2003, "3340102"), (Standards.NACEBEL2008, "3250022")),
        ((Standards.NACEBEL2003, "3340103"), (Standards.NACEBEL2008, "3250023")),
        ((Standards.NACEBEL2003, "33402"), (Standards.NACEBEL2008, "26700")),
        ((Standards.NACEBEL2003, "33402"), (Standards.NACEBEL2008, "27310")),
        ((Standards.NACEBEL2003, "3340201"), (Standards.NACEBEL2008, "23190")),
        ((Standards.NACEBEL2003, "3340202"), (Standards.NACEBEL2008, "2670001")),
        ((Standards.NACEBEL2003, "3340203"), (Standards.NACEBEL2008, "27310")),
        ((Standards.NACEBEL2003, "3340204"), (Standards.NACEBEL2008, "26700")),
        ((Standards.NACEBEL2003, "3340205"), (Standards.NACEBEL2008, "26700")),
        ((Standards.NACEBEL2003, "3340206"), (Standards.NACEBEL2008, "26700")),
        ((Standards.NACEBEL2003, "3340207"), (Standards.NACEBEL2008, "26700")),
        ((Standards.NACEBEL2003, "3340208"), (Standards.NACEBEL2008, "26700")),
        ((Standards.NACEBEL2003, "3340209"), (Standards.NACEBEL2008, "26700")),
        ((Standards.NACEBEL2003, "3340210"), (Standards.NACEBEL2008, "26700")),
        ((Standards.NACEBEL2003, "33500"), (Standards.NACEBEL2008, "26520")),
        ((Standards.NACEBEL2003, "33500"), (Standards.NACEBEL2008, "32123")),
        ((Standards.NACEBEL2003, "33500"), (Standards.NACEBEL2008, "32130")),
        ((Standards.NACEBEL2003, "33500"), (Standards.NACEBEL2008, "33130")),
        ((Standards.NACEBEL2003, "3350001"), (Standards.NACEBEL2008, "2652001")),
        ((Standards.NACEBEL2003, "3350002"), (Standards.NACEBEL2008, "26520")),
        ((Standards.NACEBEL2003, "3350003"), (Standards.NACEBEL2008, "26520")),
        ((Standards.NACEBEL2003, "34100"), (Standards.NACEBEL2008, "29100")),
        ((Standards.NACEBEL2003, "34100"), (Standards.NACEBEL2008, "28920")),
        ((Standards.NACEBEL2003, "34100"), (Standards.NACEBEL2008, "30910")),
        ((Standards.NACEBEL2003, "3410001"), (Standards.NACEBEL2008, "2910001")),
        ((Standards.NACEBEL2003, "3410002"), (Standards.NACEBEL2008, "2910002")),
        ((Standards.NACEBEL2003, "3410003"), (Standards.NACEBEL2008, "29100")),
        ((Standards.NACEBEL2003, "3410004"), (Standards.NACEBEL2008, "29100")),
        ((Standards.NACEBEL2003, "3410005"), (Standards.NACEBEL2008, "2910003")),
        ((Standards.NACEBEL2003, "3410006"), (Standards.NACEBEL2008, "2910004")),
        ((Standards.NACEBEL2003, "34201"), (Standards.NACEBEL2008, "33110")),
        ((Standards.NACEBEL2003, "34201"), (Standards.NACEBEL2008, "29201")),
        ((Standards.NACEBEL2003, "34201"), (Standards.NACEBEL2008, "29202")),
        ((Standards.NACEBEL2003, "3420101"), (Standards.NACEBEL2008, "2920101")),
        ((Standards.NACEBEL2003, "3420102"), (Standards.NACEBEL2008, "2920211")),
        ((Standards.NACEBEL2003, "3420103"), (Standards.NACEBEL2008, "2920103")),
        ((Standards.NACEBEL2003, "3420104"), (Standards.NACEBEL2008, "2920102")),
        ((Standards.NACEBEL2003, "34202"), (Standards.NACEBEL2008, "29202")),
        ((Standards.NACEBEL2003, "3420201"), (Standards.NACEBEL2008, "2920201")),
        ((Standards.NACEBEL2003, "3420202"), (Standards.NACEBEL2008, "2920111")),
        ((Standards.NACEBEL2003, "3420203"), (Standards.NACEBEL2008, "2920202")),
        ((Standards.NACEBEL2003, "3420204"), (Standards.NACEBEL2008, "29202")),
        ((Standards.NACEBEL2003, "34300"), (Standards.NACEBEL2008, "29320")),
        ((Standards.NACEBEL2003, "34300"), (Standards.NACEBEL2008, "28110")),
        ((Standards.NACEBEL2003, "3430001"), (Standards.NACEBEL2008, "2932001")),
        ((Standards.NACEBEL2003, "3430002"), (Standards.NACEBEL2008, "2811011")),
        ((Standards.NACEBEL2003, "3430003"), (Standards.NACEBEL2008, "2932002")),
        ((Standards.NACEBEL2003, "35110"), (Standards.NACEBEL2008, "33150")),
        ((Standards.NACEBEL2003, "35110"), (Standards.NACEBEL2008, "30110")),
        ((Standards.NACEBEL2003, "3511001"), (Standards.NACEBEL2008, "3315001")),
        ((Standards.NACEBEL2003, "3511002"), (Standards.NACEBEL2008, "3315002")),
        ((Standards.NACEBEL2003, "3511003"), (Standards.NACEBEL2008, "3315003")),
        ((Standards.NACEBEL2003, "3511004"), (Standards.NACEBEL2008, "3315004")),
        ((Standards.NACEBEL2003, "3511005"), (Standards.NACEBEL2008, "3011001")),
        ((Standards.NACEBEL2003, "3511006"), (Standards.NACEBEL2008, "30110")),
        ((Standards.NACEBEL2003, "3511007"), (Standards.NACEBEL2008, "3011002")),
        ((Standards.NACEBEL2003, "3511008"), (Standards.NACEBEL2008, "3011003")),
        ((Standards.NACEBEL2003, "3511009"), (Standards.NACEBEL2008, "3831001")),
        ((Standards.NACEBEL2003, "35120"), (Standards.NACEBEL2008, "33150")),
        ((Standards.NACEBEL2003, "35120"), (Standards.NACEBEL2008, "30120")),
        ((Standards.NACEBEL2003, "3512001"), (Standards.NACEBEL2008, "3012001")),
        ((Standards.NACEBEL2003, "3512002"), (Standards.NACEBEL2008, "3012002")),
        ((Standards.NACEBEL2003, "3512003"), (Standards.NACEBEL2008, "3012003")),
        ((Standards.NACEBEL2003, "3512004"), (Standards.NACEBEL2008, "3012004")),
        ((Standards.NACEBEL2003, "3512005"), (Standards.NACEBEL2008, "3315011")),
        ((Standards.NACEBEL2003, "35200"), (Standards.NACEBEL2008, "30200")),
        ((Standards.NACEBEL2003, "35200"), (Standards.NACEBEL2008, "33170")),
        ((Standards.NACEBEL2003, "3520001"), (Standards.NACEBEL2008, "30200")),
        ((Standards.NACEBEL2003, "3520002"), (Standards.NACEBEL2008, "30200")),
        ((Standards.NACEBEL2003, "3520003"), (Standards.NACEBEL2008, "30200")),
        ((Standards.NACEBEL2003, "3520004"), (Standards.NACEBEL2008, "30200")),
        ((Standards.NACEBEL2003, "3520005"), (Standards.NACEBEL2008, "3020001")),
        ((Standards.NACEBEL2003, "3520006"), (Standards.NACEBEL2008, "3317001")),
        ((Standards.NACEBEL2003, "35300"), (Standards.NACEBEL2008, "30300")),
        ((Standards.NACEBEL2003, "35300"), (Standards.NACEBEL2008, "28990")),
        ((Standards.NACEBEL2003, "35300"), (Standards.NACEBEL2008, "33160")),
        ((Standards.NACEBEL2003, "3530001"), (Standards.NACEBEL2008, "3030001")),
        ((Standards.NACEBEL2003, "3530002"), (Standards.NACEBEL2008, "3030002")),
        ((Standards.NACEBEL2003, "3530003"), (Standards.NACEBEL2008, "3030003")),
        ((Standards.NACEBEL2003, "3530004"), (Standards.NACEBEL2008, "30300")),
        ((Standards.NACEBEL2003, "3530005"), (Standards.NACEBEL2008, "30300")),
        ((Standards.NACEBEL2003, "3530006"), (Standards.NACEBEL2008, "30300")),
        ((Standards.NACEBEL2003, "3530007"), (Standards.NACEBEL2008, "3030004")),
        ((Standards.NACEBEL2003, "3530008"), (Standards.NACEBEL2008, "30300")),
        ((Standards.NACEBEL2003, "3530009"), (Standards.NACEBEL2008, "3030005")),
        ((Standards.NACEBEL2003, "3530010"), (Standards.NACEBEL2008, "28990")),
        ((Standards.NACEBEL2003, "3530011"), (Standards.NACEBEL2008, "30300")),
        ((Standards.NACEBEL2003, "35410"), (Standards.NACEBEL2008, "30910")),
        ((Standards.NACEBEL2003, "3541001"), (Standards.NACEBEL2008, "3091001")),
        ((Standards.NACEBEL2003, "3541002"), (Standards.NACEBEL2008, "30910")),
        ((Standards.NACEBEL2003, "3541003"), (Standards.NACEBEL2008, "30910")),
        ((Standards.NACEBEL2003, "3541004"), (Standards.NACEBEL2008, "30910")),
        ((Standards.NACEBEL2003, "35420"), (Standards.NACEBEL2008, "30920")),
        ((Standards.NACEBEL2003, "3542001"), (Standards.NACEBEL2008, "3092001")),
        ((Standards.NACEBEL2003, "3542002"), (Standards.NACEBEL2008, "3092002")),
        ((Standards.NACEBEL2003, "35430"), (Standards.NACEBEL2008, "30920")),
        ((Standards.NACEBEL2003, "35430"), (Standards.NACEBEL2008, "33170")),
        ((Standards.NACEBEL2003, "3543001"), (Standards.NACEBEL2008, "30920")),
        ((Standards.NACEBEL2003, "3543002"), (Standards.NACEBEL2008, "30920")),
        ((Standards.NACEBEL2003, "35500"), (Standards.NACEBEL2008, "30990")),
        ((Standards.NACEBEL2003, "35500"), (Standards.NACEBEL2008, "28220")),
        ((Standards.NACEBEL2003, "35500"), (Standards.NACEBEL2008, "31010")),
        ((Standards.NACEBEL2003, "35500"), (Standards.NACEBEL2008, "33110")),
        ((Standards.NACEBEL2003, "35500"), (Standards.NACEBEL2008, "33170")),
        ((Standards.NACEBEL2003, "3550001"), (Standards.NACEBEL2008, "3099001")),
        ((Standards.NACEBEL2003, "3550002"), (Standards.NACEBEL2008, "3099002")),
        ((Standards.NACEBEL2003, "36100"), (Standards.NACEBEL2008, "31091")),
        ((Standards.NACEBEL2003, "3610001"), (Standards.NACEBEL2008, "31091")),
        ((Standards.NACEBEL2003, "36111"), (Standards.NACEBEL2008, "31091")),
        ((Standards.NACEBEL2003, "36111"), (Standards.NACEBEL2008, "31010")),
        ((Standards.NACEBEL2003, "36111"), (Standards.NACEBEL2008, "31020")),
        ((Standards.NACEBEL2003, "36111"), (Standards.NACEBEL2008, "31092")),
        ((Standards.NACEBEL2003, "36111"), (Standards.NACEBEL2008, "95240")),
        ((Standards.NACEBEL2003, "3611101"), (Standards.NACEBEL2008, "3109101")),
        ((Standards.NACEBEL2003, "3611102"), (Standards.NACEBEL2008, "3101021")),
        ((Standards.NACEBEL2003, "3611103"), (Standards.NACEBEL2008, "3109102")),
        ((Standards.NACEBEL2003, "36112"), (Standards.NACEBEL2008, "29320")),
        ((Standards.NACEBEL2003, "36112"), (Standards.NACEBEL2008, "30110")),
        ((Standards.NACEBEL2003, "36112"), (Standards.NACEBEL2008, "30200")),
        ((Standards.NACEBEL2003, "36112"), (Standards.NACEBEL2008, "30300")),
        ((Standards.NACEBEL2003, "36112"), (Standards.NACEBEL2008, "31010")),
        ((Standards.NACEBEL2003, "36112"), (Standards.NACEBEL2008, "95240")),
        ((Standards.NACEBEL2003, "3611201"), (Standards.NACEBEL2008, "31010")),
        ((Standards.NACEBEL2003, "36121"), (Standards.NACEBEL2008, "31010")),
        ((Standards.NACEBEL2003, "36121"), (Standards.NACEBEL2008, "28230")),
        ((Standards.NACEBEL2003, "36121"), (Standards.NACEBEL2008, "95240")),
        ((Standards.NACEBEL2003, "3612101"), (Standards.NACEBEL2008, "3101001")),
        ((Standards.NACEBEL2003, "3612102"), (Standards.NACEBEL2008, "3101002")),
        ((Standards.NACEBEL2003, "36122"), (Standards.NACEBEL2008, "31010")),
        ((Standards.NACEBEL2003, "36122"), (Standards.NACEBEL2008, "28230")),
        ((Standards.NACEBEL2003, "36122"), (Standards.NACEBEL2008, "95240")),
        ((Standards.NACEBEL2003, "3612201"), (Standards.NACEBEL2008, "3101011")),
        ((Standards.NACEBEL2003, "3612202"), (Standards.NACEBEL2008, "3101012")),
        ((Standards.NACEBEL2003, "36130"), (Standards.NACEBEL2008, "31020")),
        ((Standards.NACEBEL2003, "36130"), (Standards.NACEBEL2008, "31091")),
        ((Standards.NACEBEL2003, "3613001"), (Standards.NACEBEL2008, "3102001")),
        ((Standards.NACEBEL2003, "3613002"), (Standards.NACEBEL2008, "3109121")),
        ((Standards.NACEBEL2003, "36141"), (Standards.NACEBEL2008, "31091")),
        ((Standards.NACEBEL2003, "36141"), (Standards.NACEBEL2008, "31099")),
        ((Standards.NACEBEL2003, "36141"), (Standards.NACEBEL2008, "95240")),
        ((Standards.NACEBEL2003, "3614101"), (Standards.NACEBEL2008, "3109111")),
        ((Standards.NACEBEL2003, "3614102"), (Standards.NACEBEL2008, "3109901")),
        ((Standards.NACEBEL2003, "3614103"), (Standards.NACEBEL2008, "9524001")),
        ((Standards.NACEBEL2003, "36142"), (Standards.NACEBEL2008, "31092")),
        ((Standards.NACEBEL2003, "36142"), (Standards.NACEBEL2008, "95240")),
        ((Standards.NACEBEL2003, "3614201"), (Standards.NACEBEL2008, "31092")),
        ((Standards.NACEBEL2003, "36150"), (Standards.NACEBEL2008, "31030")),
        ((Standards.NACEBEL2003, "3615001"), (Standards.NACEBEL2008, "3103001")),
        ((Standards.NACEBEL2003, "3615002"), (Standards.NACEBEL2008, "3103002")),
        ((Standards.NACEBEL2003, "36210"), (Standards.NACEBEL2008, "32110")),
        ((Standards.NACEBEL2003, "3621001"), (Standards.NACEBEL2008, "32110")),
        ((Standards.NACEBEL2003, "3621002"), (Standards.NACEBEL2008, "3211001")),
        ((Standards.NACEBEL2003, "36221"), (Standards.NACEBEL2008, "32121")),
        ((Standards.NACEBEL2003, "3622101"), (Standards.NACEBEL2008, "3212101")),
        ((Standards.NACEBEL2003, "36222"), (Standards.NACEBEL2008, "32122")),
        ((Standards.NACEBEL2003, "3622201"), (Standards.NACEBEL2008, "3212201")),
        ((Standards.NACEBEL2003, "3622202"), (Standards.NACEBEL2008, "3212202")),
        ((Standards.NACEBEL2003, "3622203"), (Standards.NACEBEL2008, "3212203")),
        ((Standards.NACEBEL2003, "36223"), (Standards.NACEBEL2008, "32123")),
        ((Standards.NACEBEL2003, "3622301"), (Standards.NACEBEL2008, "3212301")),
        ((Standards.NACEBEL2003, "3622302"), (Standards.NACEBEL2008, "3212302")),
        ((Standards.NACEBEL2003, "36224"), (Standards.NACEBEL2008, "32124")),
        ((Standards.NACEBEL2003, "36224"), (Standards.NACEBEL2008, "32129")),
        ((Standards.NACEBEL2003, "3622401"), (Standards.NACEBEL2008, "3212401")),
        ((Standards.NACEBEL2003, "3622402"), (Standards.NACEBEL2008, "32129")),
        ((Standards.NACEBEL2003, "3622403"), (Standards.NACEBEL2008, "3212901")),
        ((Standards.NACEBEL2003, "36300"), (Standards.NACEBEL2008, "32200")),
        ((Standards.NACEBEL2003, "36300"), (Standards.NACEBEL2008, "33190")),
        ((Standards.NACEBEL2003, "36300"), (Standards.NACEBEL2008, "95290")),
        ((Standards.NACEBEL2003, "3630001"), (Standards.NACEBEL2008, "3220001")),
        ((Standards.NACEBEL2003, "3630002"), (Standards.NACEBEL2008, "3220002")),
        ((Standards.NACEBEL2003, "3630003"), (Standards.NACEBEL2008, "32200")),
        ((Standards.NACEBEL2003, "3630004"), (Standards.NACEBEL2008, "32200")),
        ((Standards.NACEBEL2003, "3630005"), (Standards.NACEBEL2008, "3220003")),
        ((Standards.NACEBEL2003, "3630006"), (Standards.NACEBEL2008, "3220004")),
        ((Standards.NACEBEL2003, "3630007"), (Standards.NACEBEL2008, "3220005")),
        ((Standards.NACEBEL2003, "3630008"), (Standards.NACEBEL2008, "32200")),
        ((Standards.NACEBEL2003, "3630009"), (Standards.NACEBEL2008, "32200")),
        ((Standards.NACEBEL2003, "3630010"), (Standards.NACEBEL2008, "32200")),
        ((Standards.NACEBEL2003, "3630011"), (Standards.NACEBEL2008, "9529021")),
        ((Standards.NACEBEL2003, "36400"), (Standards.NACEBEL2008, "32300")),
        ((Standards.NACEBEL2003, "3640001"), (Standards.NACEBEL2008, "3230001")),
        ((Standards.NACEBEL2003, "3640002"), (Standards.NACEBEL2008, "3230002")),
        ((Standards.NACEBEL2003, "3640003"), (Standards.NACEBEL2008, "32300")),
        ((Standards.NACEBEL2003, "3640004"), (Standards.NACEBEL2008, "32300")),
        ((Standards.NACEBEL2003, "3640005"), (Standards.NACEBEL2008, "32300")),
        ((Standards.NACEBEL2003, "3640006"), (Standards.NACEBEL2008, "32300")),
        ((Standards.NACEBEL2003, "3640007"), (Standards.NACEBEL2008, "32300")),
        ((Standards.NACEBEL2003, "3640008"), (Standards.NACEBEL2008, "32300")),
        ((Standards.NACEBEL2003, "3640009"), (Standards.NACEBEL2008, "3230003")),
        ((Standards.NACEBEL2003, "3640010"), (Standards.NACEBEL2008, "32300")),
        ((Standards.NACEBEL2003, "3640011"), (Standards.NACEBEL2008, "32300")),
        ((Standards.NACEBEL2003, "3640012"), (Standards.NACEBEL2008, "3230004")),
        ((Standards.NACEBEL2003, "36500"), (Standards.NACEBEL2008, "32400")),
        ((Standards.NACEBEL2003, "36500"), (Standards.NACEBEL2008, "26400")),
        ((Standards.NACEBEL2003, "36500"), (Standards.NACEBEL2008, "28990")),
        ((Standards.NACEBEL2003, "36500"), (Standards.NACEBEL2008, "33190")),
        ((Standards.NACEBEL2003, "3650001"), (Standards.NACEBEL2008, "3240001")),
        ((Standards.NACEBEL2003, "3650002"), (Standards.NACEBEL2008, "3240002")),
        ((Standards.NACEBEL2003, "3650003"), (Standards.NACEBEL2008, "32400")),
        ((Standards.NACEBEL2003, "3650004"), (Standards.NACEBEL2008, "32400")),
        ((Standards.NACEBEL2003, "3650005"), (Standards.NACEBEL2008, "3240003")),
        ((Standards.NACEBEL2003, "3650006"), (Standards.NACEBEL2008, "3240004")),
        ((Standards.NACEBEL2003, "3650007"), (Standards.NACEBEL2008, "3240005")),
        ((Standards.NACEBEL2003, "3650008"), (Standards.NACEBEL2008, "3240006")),
        ((Standards.NACEBEL2003, "3650009"), (Standards.NACEBEL2008, "32400")),
        ((Standards.NACEBEL2003, "36610"), (Standards.NACEBEL2008, "32130")),
        ((Standards.NACEBEL2003, "3661001"), (Standards.NACEBEL2008, "3213001")),
        ((Standards.NACEBEL2003, "36620"), (Standards.NACEBEL2008, "32910")),
        ((Standards.NACEBEL2003, "3662001"), (Standards.NACEBEL2008, "32910")),
        ((Standards.NACEBEL2003, "3662002"), (Standards.NACEBEL2008, "32910")),
        ((Standards.NACEBEL2003, "36630"), (Standards.NACEBEL2008, "32990")),
        ((Standards.NACEBEL2003, "36630"), (Standards.NACEBEL2008, "13990")),
        ((Standards.NACEBEL2003, "36630"), (Standards.NACEBEL2008, "15120")),
        ((Standards.NACEBEL2003, "36630"), (Standards.NACEBEL2008, "16291")),
        ((Standards.NACEBEL2003, "36630"), (Standards.NACEBEL2008, "16292")),
        ((Standards.NACEBEL2003, "36630"), (Standards.NACEBEL2008, "20510")),
        ((Standards.NACEBEL2003, "36630"), (Standards.NACEBEL2008, "22190")),
        ((Standards.NACEBEL2003, "36630"), (Standards.NACEBEL2008, "22230")),
        ((Standards.NACEBEL2003, "36630"), (Standards.NACEBEL2008, "22290")),
        ((Standards.NACEBEL2003, "36630"), (Standards.NACEBEL2008, "25991")),
        ((Standards.NACEBEL2003, "36630"), (Standards.NACEBEL2008, "25999")),
        ((Standards.NACEBEL2003, "36630"), (Standards.NACEBEL2008, "28990")),
        ((Standards.NACEBEL2003, "36630"), (Standards.NACEBEL2008, "30920")),
        ((Standards.NACEBEL2003, "3663001"), (Standards.NACEBEL2008, "32990")),
        ((Standards.NACEBEL2003, "3663002"), (Standards.NACEBEL2008, "32990")),
        ((Standards.NACEBEL2003, "3663003"), (Standards.NACEBEL2008, "3299001")),
        ((Standards.NACEBEL2003, "3663004"), (Standards.NACEBEL2008, "30920")),
        ((Standards.NACEBEL2003, "3663005"), (Standards.NACEBEL2008, "32990")),
        ((Standards.NACEBEL2003, "3663006"), (Standards.NACEBEL2008, "32990")),
        ((Standards.NACEBEL2003, "3663007"), (Standards.NACEBEL2008, "3299002")),
        ((Standards.NACEBEL2003, "3663008"), (Standards.NACEBEL2008, "3299003")),
        ((Standards.NACEBEL2003, "3663009"), (Standards.NACEBEL2008, "2899021")),
        ((Standards.NACEBEL2003, "3663010"), (Standards.NACEBEL2008, "2223011")),
        ((Standards.NACEBEL2003, "3663011"), (Standards.NACEBEL2008, "3299004")),
        ((Standards.NACEBEL2003, "3663012"), (Standards.NACEBEL2008, "3299005")),
        ((Standards.NACEBEL2003, "3663013"), (Standards.NACEBEL2008, "3299006")),
        ((Standards.NACEBEL2003, "3663014"), (Standards.NACEBEL2008, "32990")),
        ((Standards.NACEBEL2003, "3663015"), (Standards.NACEBEL2008, "3299007")),
        ((Standards.NACEBEL2003, "37100"), (Standards.NACEBEL2008, "38322")),
        ((Standards.NACEBEL2003, "37100"), (Standards.NACEBEL2008, "38310")),
        ((Standards.NACEBEL2003, "37100"), (Standards.NACEBEL2008, "38321")),
        ((Standards.NACEBEL2003, "3710001"), (Standards.NACEBEL2008, "3832201")),
        ((Standards.NACEBEL2003, "3710002"), (Standards.NACEBEL2008, "3832202")),
        ((Standards.NACEBEL2003, "3710003"), (Standards.NACEBEL2008, "3831011")),
        ((Standards.NACEBEL2003, "3710004"), (Standards.NACEBEL2008, "3831012")),
        ((Standards.NACEBEL2003, "3710005"), (Standards.NACEBEL2008, "3831013")),
        ((Standards.NACEBEL2003, "37200"), (Standards.NACEBEL2008, "38323")),
        ((Standards.NACEBEL2003, "3720001"), (Standards.NACEBEL2008, "3832901")),
        ((Standards.NACEBEL2003, "3720002"), (Standards.NACEBEL2008, "3832902")),
        ((Standards.NACEBEL2003, "3720003"), (Standards.NACEBEL2008, "38329")),
        ((Standards.NACEBEL2003, "3720004"), (Standards.NACEBEL2008, "38323")),
        ((Standards.NACEBEL2003, "3720005"), (Standards.NACEBEL2008, "3832903")),
        ((Standards.NACEBEL2003, "37210"), (Standards.NACEBEL2008, "38329")),
        ((Standards.NACEBEL2003, "37220"), (Standards.NACEBEL2008, "38329")),
        ((Standards.NACEBEL2003, "37230"), (Standards.NACEBEL2008, "38329")),
        ((Standards.NACEBEL2003, "40100"), (Standards.NACEBEL2008, "35140")),
        ((Standards.NACEBEL2003, "4010001"), (Standards.NACEBEL2008, "35110")),
        ((Standards.NACEBEL2003, "4010002"), (Standards.NACEBEL2008, "35120")),
        ((Standards.NACEBEL2003, "40110"), (Standards.NACEBEL2008, "35110")),
        ((Standards.NACEBEL2003, "40110"), (Standards.NACEBEL2008, "38120")),
        ((Standards.NACEBEL2003, "40120"), (Standards.NACEBEL2008, "35120")),
        ((Standards.NACEBEL2003, "40130"), (Standards.NACEBEL2008, "35140")),
        ((Standards.NACEBEL2003, "40130"), (Standards.NACEBEL2008, "35130")),
        ((Standards.NACEBEL2003, "40200"), (Standards.NACEBEL2008, "35220")),
        ((Standards.NACEBEL2003, "4020001"), (Standards.NACEBEL2008, "35210")),
        ((Standards.NACEBEL2003, "4020002"), (Standards.NACEBEL2008, "35220")),
        ((Standards.NACEBEL2003, "4020003"), (Standards.NACEBEL2008, "35220")),
        ((Standards.NACEBEL2003, "4020004"), (Standards.NACEBEL2008, "82920")),
        ((Standards.NACEBEL2003, "40210"), (Standards.NACEBEL2008, "35210")),
        ((Standards.NACEBEL2003, "40220"), (Standards.NACEBEL2008, "35220")),
        ((Standards.NACEBEL2003, "40220"), (Standards.NACEBEL2008, "35230")),
        ((Standards.NACEBEL2003, "40300"), (Standards.NACEBEL2008, "35300")),
        ((Standards.NACEBEL2003, "4030001"), (Standards.NACEBEL2008, "3530001")),
        ((Standards.NACEBEL2003, "4030002"), (Standards.NACEBEL2008, "3530002")),
        ((Standards.NACEBEL2003, "40400"), (Standards.NACEBEL2008, "35140")),
        ((Standards.NACEBEL2003, "41000"), (Standards.NACEBEL2008, "36000")),
        ((Standards.NACEBEL2003, "4100001"), (Standards.NACEBEL2008, "3600001")),
        ((Standards.NACEBEL2003, "4100002"), (Standards.NACEBEL2008, "36000")),
        ((Standards.NACEBEL2003, "45111"), (Standards.NACEBEL2008, "43110")),
        ((Standards.NACEBEL2003, "4511101"), (Standards.NACEBEL2008, "4311001")),
        ((Standards.NACEBEL2003, "4511102"), (Standards.NACEBEL2008, "4312011")),
        ((Standards.NACEBEL2003, "45112"), (Standards.NACEBEL2008, "43120")),
        ((Standards.NACEBEL2003, "4511201"), (Standards.NACEBEL2008, "4312001")),
        ((Standards.NACEBEL2003, "4511202"), (Standards.NACEBEL2008, "4312002")),
        ((Standards.NACEBEL2003, "4511203"), (Standards.NACEBEL2008, "4312003")),
        ((Standards.NACEBEL2003, "4511204"), (Standards.NACEBEL2008, "4312004")),
        ((Standards.NACEBEL2003, "45120"), (Standards.NACEBEL2008, "43130")),
        ((Standards.NACEBEL2003, "4512001"), (Standards.NACEBEL2008, "4313001")),
        ((Standards.NACEBEL2003, "4512002"), (Standards.NACEBEL2008, "4313002")),
        ((Standards.NACEBEL2003, "45200"), (Standards.NACEBEL2008, "41203")),
        ((Standards.NACEBEL2003, "4520001"), (Standards.NACEBEL2008, "4120121")),
        ((Standards.NACEBEL2003, "4520002"), (Standards.NACEBEL2008, "4120122")),
        ((Standards.NACEBEL2003, "45211"), (Standards.NACEBEL2008, "41201")),
        ((Standards.NACEBEL2003, "4521101"), (Standards.NACEBEL2008, "4120101")),
        ((Standards.NACEBEL2003, "4521102"), (Standards.NACEBEL2008, "4120102")),
        ((Standards.NACEBEL2003, "45212"), (Standards.NACEBEL2008, "41201")),
        ((Standards.NACEBEL2003, "45212"), (Standards.NACEBEL2008, "41202")),
        ((Standards.NACEBEL2003, "4521201"), (Standards.NACEBEL2008, "4120111")),
        ((Standards.NACEBEL2003, "4521202"), (Standards.NACEBEL2008, "4120112")),
        ((Standards.NACEBEL2003, "45213"), (Standards.NACEBEL2008, "41203")),
        ((Standards.NACEBEL2003, "45213"), (Standards.NACEBEL2008, "42990")),
        ((Standards.NACEBEL2003, "45213"), (Standards.NACEBEL2008, "43999")),
        ((Standards.NACEBEL2003, "4521301"), (Standards.NACEBEL2008, "4120301")),
        ((Standards.NACEBEL2003, "4521302"), (Standards.NACEBEL2008, "4120302")),
        ((Standards.NACEBEL2003, "45214"), (Standards.NACEBEL2008, "42130")),
        ((Standards.NACEBEL2003, "4521401"), (Standards.NACEBEL2008, "4213001")),
        ((Standards.NACEBEL2003, "4521402"), (Standards.NACEBEL2008, "4213002")),
        ((Standards.NACEBEL2003, "45215"), (Standards.NACEBEL2008, "42220")),
        ((Standards.NACEBEL2003, "45215"), (Standards.NACEBEL2008, "42211")),
        ((Standards.NACEBEL2003, "45215"), (Standards.NACEBEL2008, "42212")),
        ((Standards.NACEBEL2003, "45215"), (Standards.NACEBEL2008, "42219")),
        ((Standards.NACEBEL2003, "4521501"), (Standards.NACEBEL2008, "4221911")),
        ((Standards.NACEBEL2003, "4521502"), (Standards.NACEBEL2008, "4221912")),
        ((Standards.NACEBEL2003, "4521503"), (Standards.NACEBEL2008, "4222001")),
        ((Standards.NACEBEL2003, "4521504"), (Standards.NACEBEL2008, "4222002")),
        ((Standards.NACEBEL2003, "45220"), (Standards.NACEBEL2008, "43910")),
        ((Standards.NACEBEL2003, "45220"), (Standards.NACEBEL2008, "43991")),
        ((Standards.NACEBEL2003, "4522001"), (Standards.NACEBEL2008, "4391001")),
        ((Standards.NACEBEL2003, "4522002"), (Standards.NACEBEL2008, "4391002")),
        ((Standards.NACEBEL2003, "4522003"), (Standards.NACEBEL2008, "4391003")),
        ((Standards.NACEBEL2003, "4522004"), (Standards.NACEBEL2008, "4399101")),
        ((Standards.NACEBEL2003, "45230"), (Standards.NACEBEL2008, "42110")),
        ((Standards.NACEBEL2003, "45230"), (Standards.NACEBEL2008, "41203")),
        ((Standards.NACEBEL2003, "45230"), (Standards.NACEBEL2008, "42120")),
        ((Standards.NACEBEL2003, "45230"), (Standards.NACEBEL2008, "42990")),
        ((Standards.NACEBEL2003, "4523001"), (Standards.NACEBEL2008, "4212001")),
        ((Standards.NACEBEL2003, "4523002"), (Standards.NACEBEL2008, "4211001")),
        ((Standards.NACEBEL2003, "4523003"), (Standards.NACEBEL2008, "4211002")),
        ((Standards.NACEBEL2003, "4523004"), (Standards.NACEBEL2008, "4299001")),
        ((Standards.NACEBEL2003, "4523005"), (Standards.NACEBEL2008, "4211003")),
        ((Standards.NACEBEL2003, "45241"), (Standards.NACEBEL2008, "42911")),
        ((Standards.NACEBEL2003, "4524101"), (Standards.NACEBEL2008, "4291101")),
        ((Standards.NACEBEL2003, "4524102"), (Standards.NACEBEL2008, "4291102")),
        ((Standards.NACEBEL2003, "45242"), (Standards.NACEBEL2008, "42919")),
        ((Standards.NACEBEL2003, "45242"), (Standards.NACEBEL2008, "42219")),
        ((Standards.NACEBEL2003, "45242"), (Standards.NACEBEL2008, "43999")),
        ((Standards.NACEBEL2003, "4524201"), (Standards.NACEBEL2008, "4291901")),
        ((Standards.NACEBEL2003, "4524202"), (Standards.NACEBEL2008, "4291902")),
        ((Standards.NACEBEL2003, "4524203"), (Standards.NACEBEL2008, "4291903")),
        ((Standards.NACEBEL2003, "4524204"), (Standards.NACEBEL2008, "4291904")),
        ((Standards.NACEBEL2003, "4524205"), (Standards.NACEBEL2008, "4291905")),
        ((Standards.NACEBEL2003, "4524206"), (Standards.NACEBEL2008, "4399921")),
        ((Standards.NACEBEL2003, "45250"), (Standards.NACEBEL2008, "43999")),
        ((Standards.NACEBEL2003, "45250"), (Standards.NACEBEL2008, "42219")),
        ((Standards.NACEBEL2003, "45250"), (Standards.NACEBEL2008, "43991")),
        ((Standards.NACEBEL2003, "45250"), (Standards.NACEBEL2008, "43993")),
        ((Standards.NACEBEL2003, "45250"), (Standards.NACEBEL2008, "43994")),
        ((Standards.NACEBEL2003, "45250"), (Standards.NACEBEL2008, "43995")),
        ((Standards.NACEBEL2003, "45250"), (Standards.NACEBEL2008, "43996")),
        ((Standards.NACEBEL2003, "4525001"), (Standards.NACEBEL2008, "4399901")),
        ((Standards.NACEBEL2003, "4525002"), (Standards.NACEBEL2008, "4221901")),
        ((Standards.NACEBEL2003, "4525003"), (Standards.NACEBEL2008, "4399902")),
        ((Standards.NACEBEL2003, "4525004"), (Standards.NACEBEL2008, "4399401")),
        ((Standards.NACEBEL2003, "4525005"), (Standards.NACEBEL2008, "4399601")),
        ((Standards.NACEBEL2003, "4525006"), (Standards.NACEBEL2008, "4399903")),
        ((Standards.NACEBEL2003, "4525007"), (Standards.NACEBEL2008, "4399301")),
        ((Standards.NACEBEL2003, "4525008"), (Standards.NACEBEL2008, "4399904")),
        ((Standards.NACEBEL2003, "4525009"), (Standards.NACEBEL2008, "4399905")),
        ((Standards.NACEBEL2003, "4525010"), (Standards.NACEBEL2008, "4399906")),
        ((Standards.NACEBEL2003, "4525011"), (Standards.NACEBEL2008, "4399402")),
        ((Standards.NACEBEL2003, "4525012"), (Standards.NACEBEL2008, "4399907")),
        ((Standards.NACEBEL2003, "45310"), (Standards.NACEBEL2008, "43211")),
        ((Standards.NACEBEL2003, "45310"), (Standards.NACEBEL2008, "43222")),
        ((Standards.NACEBEL2003, "45310"), (Standards.NACEBEL2008, "43299")),
        ((Standards.NACEBEL2003, "45310"), (Standards.NACEBEL2008, "80200")),
        ((Standards.NACEBEL2003, "4531001"), (Standards.NACEBEL2008, "4321101")),
        ((Standards.NACEBEL2003, "4531002"), (Standards.NACEBEL2008, "3320011")),
        ((Standards.NACEBEL2003, "4531003"), (Standards.NACEBEL2008, "4321102")),
        ((Standards.NACEBEL2003, "4531004"), (Standards.NACEBEL2008, "4322211")),
        ((Standards.NACEBEL2003, "4531005"), (Standards.NACEBEL2008, "4329911")),
        ((Standards.NACEBEL2003, "4531006"), (Standards.NACEBEL2008, "4321103")),
        ((Standards.NACEBEL2003, "4531007"), (Standards.NACEBEL2008, "4329912")),
        ((Standards.NACEBEL2003, "45320"), (Standards.NACEBEL2008, "43291")),
        ((Standards.NACEBEL2003, "4532001"), (Standards.NACEBEL2008, "4329101")),
        ((Standards.NACEBEL2003, "4532002"), (Standards.NACEBEL2008, "4329102")),
        ((Standards.NACEBEL2003, "4532003"), (Standards.NACEBEL2008, "4329103")),
        ((Standards.NACEBEL2003, "45331"), (Standards.NACEBEL2008, "43222")),
        ((Standards.NACEBEL2003, "4533101"), (Standards.NACEBEL2008, "4322201")),
        ((Standards.NACEBEL2003, "4533102"), (Standards.NACEBEL2008, "4322202")),
        ((Standards.NACEBEL2003, "45332"), (Standards.NACEBEL2008, "43221")),
        ((Standards.NACEBEL2003, "4533201"), (Standards.NACEBEL2008, "4322101")),
        ((Standards.NACEBEL2003, "45340"), (Standards.NACEBEL2008, "43299")),
        ((Standards.NACEBEL2003, "45340"), (Standards.NACEBEL2008, "43212")),
        ((Standards.NACEBEL2003, "4534001"), (Standards.NACEBEL2008, "4321201")),
        ((Standards.NACEBEL2003, "4534002"), (Standards.NACEBEL2008, "4329901")),
        ((Standards.NACEBEL2003, "4534003"), (Standards.NACEBEL2008, "4329902")),
        ((Standards.NACEBEL2003, "4534004"), (Standards.NACEBEL2008, "4329903")),
        ((Standards.NACEBEL2003, "4534005"), (Standards.NACEBEL2008, "4329904")),
        ((Standards.NACEBEL2003, "45410"), (Standards.NACEBEL2008, "43310")),
        ((Standards.NACEBEL2003, "4541001"), (Standards.NACEBEL2008, "4331001")),
        ((Standards.NACEBEL2003, "4541002"), (Standards.NACEBEL2008, "4332031")),
        ((Standards.NACEBEL2003, "45421"), (Standards.NACEBEL2008, "43320")),
        ((Standards.NACEBEL2003, "45421"), (Standards.NACEBEL2008, "43332")),
        ((Standards.NACEBEL2003, "4542101"), (Standards.NACEBEL2008, "4332001")),
        ((Standards.NACEBEL2003, "4542102"), (Standards.NACEBEL2008, "4332002")),
        ((Standards.NACEBEL2003, "4542103"), (Standards.NACEBEL2008, "4332003")),
        ((Standards.NACEBEL2003, "4542104"), (Standards.NACEBEL2008, "4332004")),
        ((Standards.NACEBEL2003, "4542105"), (Standards.NACEBEL2008, "4332005")),
        ((Standards.NACEBEL2003, "45422"), (Standards.NACEBEL2008, "43320")),
        ((Standards.NACEBEL2003, "4542201"), (Standards.NACEBEL2008, "4332011")),
        ((Standards.NACEBEL2003, "4542202"), (Standards.NACEBEL2008, "4332012")),
        ((Standards.NACEBEL2003, "4542203"), (Standards.NACEBEL2008, "4332013")),
        ((Standards.NACEBEL2003, "4542204"), (Standards.NACEBEL2008, "4332014")),
        ((Standards.NACEBEL2003, "4542205"), (Standards.NACEBEL2008, "4332015")),
        ((Standards.NACEBEL2003, "4542206"), (Standards.NACEBEL2008, "4332016")),
        ((Standards.NACEBEL2003, "4542207"), (Standards.NACEBEL2008, "43320")),
        ((Standards.NACEBEL2003, "45431"), (Standards.NACEBEL2008, "43331")),
        ((Standards.NACEBEL2003, "4543101"), (Standards.NACEBEL2008, "4333101")),
        ((Standards.NACEBEL2003, "45432"), (Standards.NACEBEL2008, "43332")),
        ((Standards.NACEBEL2003, "45432"), (Standards.NACEBEL2008, "43333")),
        ((Standards.NACEBEL2003, "4543201"), (Standards.NACEBEL2008, "4333201")),
        ((Standards.NACEBEL2003, "45433"), (Standards.NACEBEL2008, "43333")),
        ((Standards.NACEBEL2003, "4543301"), (Standards.NACEBEL2008, "4333301")),
        ((Standards.NACEBEL2003, "45441"), (Standards.NACEBEL2008, "43341")),
        ((Standards.NACEBEL2003, "45441"), (Standards.NACEBEL2008, "43342")),
        ((Standards.NACEBEL2003, "4544101"), (Standards.NACEBEL2008, "4334101")),
        ((Standards.NACEBEL2003, "4544102"), (Standards.NACEBEL2008, "4399111")),
        ((Standards.NACEBEL2003, "4544103"), (Standards.NACEBEL2008, "4334201")),
        ((Standards.NACEBEL2003, "4544104"), (Standards.NACEBEL2008, "4334202")),
        ((Standards.NACEBEL2003, "45442"), (Standards.NACEBEL2008, "43343")),
        ((Standards.NACEBEL2003, "4544201"), (Standards.NACEBEL2008, "4334301")),
        ((Standards.NACEBEL2003, "4544202"), (Standards.NACEBEL2008, "4332021")),
        ((Standards.NACEBEL2003, "45450"), (Standards.NACEBEL2008, "43390")),
        ((Standards.NACEBEL2003, "45450"), (Standards.NACEBEL2008, "43992")),
        ((Standards.NACEBEL2003, "45450"), (Standards.NACEBEL2008, "43999")),
        ((Standards.NACEBEL2003, "4545001"), (Standards.NACEBEL2008, "4399931")),
        ((Standards.NACEBEL2003, "4545002"), (Standards.NACEBEL2008, "4399201")),
        ((Standards.NACEBEL2003, "4545003"), (Standards.NACEBEL2008, "4339001")),
        ((Standards.NACEBEL2003, "4545004"), (Standards.NACEBEL2008, "4339002")),
        ((Standards.NACEBEL2003, "45500"), (Standards.NACEBEL2008, "43999")),
        ((Standards.NACEBEL2003, "4550001"), (Standards.NACEBEL2008, "4399911")),
        ((Standards.NACEBEL2003, "50101"), (Standards.NACEBEL2008, "45111")),
        ((Standards.NACEBEL2003, "50101"), (Standards.NACEBEL2008, "45191")),
        ((Standards.NACEBEL2003, "5010101"), (Standards.NACEBEL2008, "4511101")),
        ((Standards.NACEBEL2003, "5010102"), (Standards.NACEBEL2008, "4519101")),
        ((Standards.NACEBEL2003, "5010103"), (Standards.NACEBEL2008, "4519102")),
        ((Standards.NACEBEL2003, "50102"), (Standards.NACEBEL2008, "45112")),
        ((Standards.NACEBEL2003, "50102"), (Standards.NACEBEL2008, "45192")),
        ((Standards.NACEBEL2003, "5010201"), (Standards.NACEBEL2008, "4511201")),
        ((Standards.NACEBEL2003, "5010202"), (Standards.NACEBEL2008, "4519201")),
        ((Standards.NACEBEL2003, "5010203"), (Standards.NACEBEL2008, "4519202")),
        ((Standards.NACEBEL2003, "50103"), (Standards.NACEBEL2008, "45113")),
        ((Standards.NACEBEL2003, "50103"), (Standards.NACEBEL2008, "45193")),
        ((Standards.NACEBEL2003, "5010301"), (Standards.NACEBEL2008, "4511301")),
        ((Standards.NACEBEL2003, "5010302"), (Standards.NACEBEL2008, "4519301")),
        ((Standards.NACEBEL2003, "5010303"), (Standards.NACEBEL2008, "4519302")),
        ((Standards.NACEBEL2003, "50104"), (Standards.NACEBEL2008, "45194")),
        ((Standards.NACEBEL2003, "5010401"), (Standards.NACEBEL2008, "4519401")),
        ((Standards.NACEBEL2003, "5010402"), (Standards.NACEBEL2008, "4519402")),
        ((Standards.NACEBEL2003, "50200"), (Standards.NACEBEL2008, "45201")),
        ((Standards.NACEBEL2003, "50200"), (Standards.NACEBEL2008, "45202")),
        ((Standards.NACEBEL2003, "50200"), (Standards.NACEBEL2008, "45203")),
        ((Standards.NACEBEL2003, "50200"), (Standards.NACEBEL2008, "45204")),
        ((Standards.NACEBEL2003, "50200"), (Standards.NACEBEL2008, "45205")),
        ((Standards.NACEBEL2003, "50200"), (Standards.NACEBEL2008, "45206")),
        ((Standards.NACEBEL2003, "50200"), (Standards.NACEBEL2008, "45209")),
        ((Standards.NACEBEL2003, "50200"), (Standards.NACEBEL2008, "52210")),
        ((Standards.NACEBEL2003, "5020001"), (Standards.NACEBEL2008, "4520301")),
        ((Standards.NACEBEL2003, "5020002"), (Standards.NACEBEL2008, "45204")),
        ((Standards.NACEBEL2003, "5020003"), (Standards.NACEBEL2008, "4520302")),
        ((Standards.NACEBEL2003, "5020004"), (Standards.NACEBEL2008, "4520101")),
        ((Standards.NACEBEL2003, "5020005"), (Standards.NACEBEL2008, "4520901")),
        ((Standards.NACEBEL2003, "5020006"), (Standards.NACEBEL2008, "5221011")),
        ((Standards.NACEBEL2003, "50301"), (Standards.NACEBEL2008, "45310")),
        ((Standards.NACEBEL2003, "5030101"), (Standards.NACEBEL2008, "4531001")),
        ((Standards.NACEBEL2003, "5030102"), (Standards.NACEBEL2008, "4531002")),
        ((Standards.NACEBEL2003, "50302"), (Standards.NACEBEL2008, "45320")),
        ((Standards.NACEBEL2003, "5030201"), (Standards.NACEBEL2008, "4532001")),
        ((Standards.NACEBEL2003, "5030202"), (Standards.NACEBEL2008, "4532002")),
        ((Standards.NACEBEL2003, "5030203"), (Standards.NACEBEL2008, "4532003")),
        ((Standards.NACEBEL2003, "50400"), (Standards.NACEBEL2008, "45402")),
        ((Standards.NACEBEL2003, "50400"), (Standards.NACEBEL2008, "45401")),
        ((Standards.NACEBEL2003, "5040001"), (Standards.NACEBEL2008, "4540101")),
        ((Standards.NACEBEL2003, "5040002"), (Standards.NACEBEL2008, "4540102")),
        ((Standards.NACEBEL2003, "5040003"), (Standards.NACEBEL2008, "4540103")),
        ((Standards.NACEBEL2003, "5040004"), (Standards.NACEBEL2008, "4540104")),
        ((Standards.NACEBEL2003, "5040005"), (Standards.NACEBEL2008, "4540201")),
        ((Standards.NACEBEL2003, "5040006"), (Standards.NACEBEL2008, "4540202")),
        ((Standards.NACEBEL2003, "5040007"), (Standards.NACEBEL2008, "4540203")),
        ((Standards.NACEBEL2003, "5040008"), (Standards.NACEBEL2008, "4540204")),
        ((Standards.NACEBEL2003, "5040009"), (Standards.NACEBEL2008, "4540205")),
        ((Standards.NACEBEL2003, "50500"), (Standards.NACEBEL2008, "47300")),
        ((Standards.NACEBEL2003, "5050001"), (Standards.NACEBEL2008, "4730001")),
        ((Standards.NACEBEL2003, "5050002"), (Standards.NACEBEL2008, "4730002")),
        ((Standards.NACEBEL2003, "51110"), (Standards.NACEBEL2008, "46110")),
        ((Standards.NACEBEL2003, "5111001"), (Standards.NACEBEL2008, "4611001")),
        ((Standards.NACEBEL2003, "51120"), (Standards.NACEBEL2008, "46120")),
        ((Standards.NACEBEL2003, "5112001"), (Standards.NACEBEL2008, "4612001")),
        ((Standards.NACEBEL2003, "5112002"), (Standards.NACEBEL2008, "4612002")),
        ((Standards.NACEBEL2003, "51130"), (Standards.NACEBEL2008, "46130")),
        ((Standards.NACEBEL2003, "5113001"), (Standards.NACEBEL2008, "4613001")),
        ((Standards.NACEBEL2003, "5113002"), (Standards.NACEBEL2008, "4613002")),
        ((Standards.NACEBEL2003, "5113003"), (Standards.NACEBEL2008, "4613003")),
        ((Standards.NACEBEL2003, "51140"), (Standards.NACEBEL2008, "46140")),
        ((Standards.NACEBEL2003, "5114001"), (Standards.NACEBEL2008, "4614001")),
        ((Standards.NACEBEL2003, "5114002"), (Standards.NACEBEL2008, "4614002")),
        ((Standards.NACEBEL2003, "5114003"), (Standards.NACEBEL2008, "4614003")),
        ((Standards.NACEBEL2003, "5114004"), (Standards.NACEBEL2008, "4614004")),
        ((Standards.NACEBEL2003, "5114005"), (Standards.NACEBEL2008, "4614005")),
        ((Standards.NACEBEL2003, "5114006"), (Standards.NACEBEL2008, "4614006")),
        ((Standards.NACEBEL2003, "51150"), (Standards.NACEBEL2008, "46150")),
        ((Standards.NACEBEL2003, "5115001"), (Standards.NACEBEL2008, "4615001")),
        ((Standards.NACEBEL2003, "5115002"), (Standards.NACEBEL2008, "4615002")),
        ((Standards.NACEBEL2003, "5115003"), (Standards.NACEBEL2008, "4615003")),
        ((Standards.NACEBEL2003, "5115004"), (Standards.NACEBEL2008, "4615004")),
        ((Standards.NACEBEL2003, "5115005"), (Standards.NACEBEL2008, "4615005")),
        ((Standards.NACEBEL2003, "5115006"), (Standards.NACEBEL2008, "4615006")),
        ((Standards.NACEBEL2003, "5115007"), (Standards.NACEBEL2008, "4615007")),
        ((Standards.NACEBEL2003, "5115008"), (Standards.NACEBEL2008, "4615008")),
        ((Standards.NACEBEL2003, "5115009"), (Standards.NACEBEL2008, "4615009")),
        ((Standards.NACEBEL2003, "51160"), (Standards.NACEBEL2008, "46160")),
        ((Standards.NACEBEL2003, "5116001"), (Standards.NACEBEL2008, "4616001")),
        ((Standards.NACEBEL2003, "5116002"), (Standards.NACEBEL2008, "4616002")),
        ((Standards.NACEBEL2003, "51170"), (Standards.NACEBEL2008, "46170")),
        ((Standards.NACEBEL2003, "5117001"), (Standards.NACEBEL2008, "4617001")),
        ((Standards.NACEBEL2003, "51180"), (Standards.NACEBEL2008, "46180")),
        ((Standards.NACEBEL2003, "5118001"), (Standards.NACEBEL2008, "4618001")),
        ((Standards.NACEBEL2003, "51190"), (Standards.NACEBEL2008, "46190")),
        ((Standards.NACEBEL2003, "5119001"), (Standards.NACEBEL2008, "4619001")),
        ((Standards.NACEBEL2003, "51210"), (Standards.NACEBEL2008, "46216")),
        ((Standards.NACEBEL2003, "51210"), (Standards.NACEBEL2008, "46211")),
        ((Standards.NACEBEL2003, "51210"), (Standards.NACEBEL2008, "46212")),
        ((Standards.NACEBEL2003, "51210"), (Standards.NACEBEL2008, "46213")),
        ((Standards.NACEBEL2003, "51210"), (Standards.NACEBEL2008, "46214")),
        ((Standards.NACEBEL2003, "5121001"), (Standards.NACEBEL2008, "4621101")),
        ((Standards.NACEBEL2003, "5121002"), (Standards.NACEBEL2008, "4621301")),
        ((Standards.NACEBEL2003, "5121003"), (Standards.NACEBEL2008, "4621102")),
        ((Standards.NACEBEL2003, "5121004"), (Standards.NACEBEL2008, "4622001")),
        ((Standards.NACEBEL2003, "5121005"), (Standards.NACEBEL2008, "46212")),
        ((Standards.NACEBEL2003, "51220"), (Standards.NACEBEL2008, "46220")),
        ((Standards.NACEBEL2003, "5122001"), (Standards.NACEBEL2008, "46220")),
        ((Standards.NACEBEL2003, "51230"), (Standards.NACEBEL2008, "46231")),
        ((Standards.NACEBEL2003, "51230"), (Standards.NACEBEL2008, "46232")),
        ((Standards.NACEBEL2003, "5123001"), (Standards.NACEBEL2008, "46232")),
        ((Standards.NACEBEL2003, "51240"), (Standards.NACEBEL2008, "46240")),
        ((Standards.NACEBEL2003, "5124001"), (Standards.NACEBEL2008, "46240")),
        ((Standards.NACEBEL2003, "51250"), (Standards.NACEBEL2008, "46215")),
        ((Standards.NACEBEL2003, "5125001"), (Standards.NACEBEL2008, "46215")),
        ((Standards.NACEBEL2003, "51310"), (Standards.NACEBEL2008, "46319")),
        ((Standards.NACEBEL2003, "51310"), (Standards.NACEBEL2008, "10392")),
        ((Standards.NACEBEL2003, "51310"), (Standards.NACEBEL2008, "46311")),
        ((Standards.NACEBEL2003, "5131001"), (Standards.NACEBEL2008, "4631901")),
        ((Standards.NACEBEL2003, "51321"), (Standards.NACEBEL2008, "46321")),
        ((Standards.NACEBEL2003, "5132101"), (Standards.NACEBEL2008, "4632101")),
        ((Standards.NACEBEL2003, "51322"), (Standards.NACEBEL2008, "46322")),
        ((Standards.NACEBEL2003, "5132201"), (Standards.NACEBEL2008, "46322")),
        ((Standards.NACEBEL2003, "5132202"), (Standards.NACEBEL2008, "4632102")),
        ((Standards.NACEBEL2003, "51331"), (Standards.NACEBEL2008, "46331")),
        ((Standards.NACEBEL2003, "5133101"), (Standards.NACEBEL2008, "4633101")),
        ((Standards.NACEBEL2003, "5133102"), (Standards.NACEBEL2008, "4633102")),
        ((Standards.NACEBEL2003, "51332"), (Standards.NACEBEL2008, "46332")),
        ((Standards.NACEBEL2003, "5133201"), (Standards.NACEBEL2008, "4633201")),
        ((Standards.NACEBEL2003, "51340"), (Standards.NACEBEL2008, "46349")),
        ((Standards.NACEBEL2003, "5134001"), (Standards.NACEBEL2008, "4634901")),
        ((Standards.NACEBEL2003, "5134002"), (Standards.NACEBEL2008, "4634101")),
        ((Standards.NACEBEL2003, "51350"), (Standards.NACEBEL2008, "46350")),
        ((Standards.NACEBEL2003, "5135001"), (Standards.NACEBEL2008, "46350")),
        ((Standards.NACEBEL2003, "51360"), (Standards.NACEBEL2008, "46360")),
        ((Standards.NACEBEL2003, "5136001"), (Standards.NACEBEL2008, "46360")),
        ((Standards.NACEBEL2003, "51370"), (Standards.NACEBEL2008, "46370")),
        ((Standards.NACEBEL2003, "5137001"), (Standards.NACEBEL2008, "46370")),
        ((Standards.NACEBEL2003, "51381"), (Standards.NACEBEL2008, "46381")),
        ((Standards.NACEBEL2003, "5138101"), (Standards.NACEBEL2008, "46381")),
        ((Standards.NACEBEL2003, "51382"), (Standards.NACEBEL2008, "46382")),
        ((Standards.NACEBEL2003, "5138201"), (Standards.NACEBEL2008, "46382")),
        ((Standards.NACEBEL2003, "51383"), (Standards.NACEBEL2008, "46383")),
        ((Standards.NACEBEL2003, "5138301"), (Standards.NACEBEL2008, "4638301")),
        ((Standards.NACEBEL2003, "51384"), (Standards.NACEBEL2008, "46389")),
        ((Standards.NACEBEL2003, "51384"), (Standards.NACEBEL2008, "46319")),
        ((Standards.NACEBEL2003, "5138401"), (Standards.NACEBEL2008, "4638901")),
        ((Standards.NACEBEL2003, "5138402"), (Standards.NACEBEL2008, "4638902")),
        ((Standards.NACEBEL2003, "5138403"), (Standards.NACEBEL2008, "4638903")),
        ((Standards.NACEBEL2003, "5138404"), (Standards.NACEBEL2008, "4638904")),
        ((Standards.NACEBEL2003, "5138405"), (Standards.NACEBEL2008, "4638905")),
        ((Standards.NACEBEL2003, "5138406"), (Standards.NACEBEL2008, "4638906")),
        ((Standards.NACEBEL2003, "5138407"), (Standards.NACEBEL2008, "4638907")),
        ((Standards.NACEBEL2003, "51391"), (Standards.NACEBEL2008, "46391")),
        ((Standards.NACEBEL2003, "5139101"), (Standards.NACEBEL2008, "4639101")),
        ((Standards.NACEBEL2003, "51392"), (Standards.NACEBEL2008, "46392")),
        ((Standards.NACEBEL2003, "5139201"), (Standards.NACEBEL2008, "4639201")),
        ((Standards.NACEBEL2003, "51410"), (Standards.NACEBEL2008, "46412")),
        ((Standards.NACEBEL2003, "51410"), (Standards.NACEBEL2008, "46411")),
        ((Standards.NACEBEL2003, "51410"), (Standards.NACEBEL2008, "46419")),
        ((Standards.NACEBEL2003, "5141001"), (Standards.NACEBEL2008, "4641101")),
        ((Standards.NACEBEL2003, "5141002"), (Standards.NACEBEL2008, "4641102")),
        ((Standards.NACEBEL2003, "5141003"), (Standards.NACEBEL2008, "4641201")),
        ((Standards.NACEBEL2003, "5141004"), (Standards.NACEBEL2008, "4641901")),
        ((Standards.NACEBEL2003, "5141005"), (Standards.NACEBEL2008, "4641103")),
        ((Standards.NACEBEL2003, "51421"), (Standards.NACEBEL2008, "46423")),
        ((Standards.NACEBEL2003, "51421"), (Standards.NACEBEL2008, "46421")),
        ((Standards.NACEBEL2003, "51421"), (Standards.NACEBEL2008, "46422")),
        ((Standards.NACEBEL2003, "51421"), (Standards.NACEBEL2008, "46424")),
        ((Standards.NACEBEL2003, "5142101"), (Standards.NACEBEL2008, "4642301")),
        ((Standards.NACEBEL2003, "5142102"), (Standards.NACEBEL2008, "4642302")),
        ((Standards.NACEBEL2003, "5142103"), (Standards.NACEBEL2008, "46424")),
        ((Standards.NACEBEL2003, "51422"), (Standards.NACEBEL2008, "46425")),
        ((Standards.NACEBEL2003, "5142201"), (Standards.NACEBEL2008, "4642501")),
        ((Standards.NACEBEL2003, "51430"), (Standards.NACEBEL2008, "46431")),
        ((Standards.NACEBEL2003, "51430"), (Standards.NACEBEL2008, "46432")),
        ((Standards.NACEBEL2003, "51430"), (Standards.NACEBEL2008, "46473")),
        ((Standards.NACEBEL2003, "51430"), (Standards.NACEBEL2008, "46520")),
        ((Standards.NACEBEL2003, "5143001"), (Standards.NACEBEL2008, "4643101")),
        ((Standards.NACEBEL2003, "5143002"), (Standards.NACEBEL2008, "4643102")),
        ((Standards.NACEBEL2003, "5143003"), (Standards.NACEBEL2008, "4643201")),
        ((Standards.NACEBEL2003, "5143004"), (Standards.NACEBEL2008, "46473")),
        ((Standards.NACEBEL2003, "5143005"), (Standards.NACEBEL2008, "4643103")),
        ((Standards.NACEBEL2003, "51441"), (Standards.NACEBEL2008, "46494")),
        ((Standards.NACEBEL2003, "51441"), (Standards.NACEBEL2008, "46441")),
        ((Standards.NACEBEL2003, "5144101"), (Standards.NACEBEL2008, "4644101")),
        ((Standards.NACEBEL2003, "5144102"), (Standards.NACEBEL2008, "4649401")),
        ((Standards.NACEBEL2003, "51442"), (Standards.NACEBEL2008, "46442")),
        ((Standards.NACEBEL2003, "51442"), (Standards.NACEBEL2008, "46733")),
        ((Standards.NACEBEL2003, "5144201"), (Standards.NACEBEL2008, "4673301")),
        ((Standards.NACEBEL2003, "5144202"), (Standards.NACEBEL2008, "4644201")),
        ((Standards.NACEBEL2003, "51450"), (Standards.NACEBEL2008, "46450")),
        ((Standards.NACEBEL2003, "5145001"), (Standards.NACEBEL2008, "46450")),
        ((Standards.NACEBEL2003, "5145002"), (Standards.NACEBEL2008, "4645001")),
        ((Standards.NACEBEL2003, "51460"), (Standards.NACEBEL2008, "46460")),
        ((Standards.NACEBEL2003, "5146001"), (Standards.NACEBEL2008, "46460")),
        ((Standards.NACEBEL2003, "5146002"), (Standards.NACEBEL2008, "4646001")),
        ((Standards.NACEBEL2003, "5146003"), (Standards.NACEBEL2008, "4646002")),
        ((Standards.NACEBEL2003, "51471"), (Standards.NACEBEL2008, "46494")),
        ((Standards.NACEBEL2003, "51471"), (Standards.NACEBEL2008, "46471")),
        ((Standards.NACEBEL2003, "51471"), (Standards.NACEBEL2008, "46472")),
        ((Standards.NACEBEL2003, "51471"), (Standards.NACEBEL2008, "46733")),
        ((Standards.NACEBEL2003, "5147101"), (Standards.NACEBEL2008, "4649411")),
        ((Standards.NACEBEL2003, "51472"), (Standards.NACEBEL2008, "46491")),
        ((Standards.NACEBEL2003, "5147201"), (Standards.NACEBEL2008, "46491")),
        ((Standards.NACEBEL2003, "51473"), (Standards.NACEBEL2008, "46433")),
        ((Standards.NACEBEL2003, "5147301"), (Standards.NACEBEL2008, "46433")),
        ((Standards.NACEBEL2003, "51474"), (Standards.NACEBEL2008, "46480")),
        ((Standards.NACEBEL2003, "5147401"), (Standards.NACEBEL2008, "46480")),
        ((Standards.NACEBEL2003, "51475"), (Standards.NACEBEL2008, "46492")),
        ((Standards.NACEBEL2003, "51475"), (Standards.NACEBEL2008, "46493")),
        ((Standards.NACEBEL2003, "5147501"), (Standards.NACEBEL2008, "4649201")),
        ((Standards.NACEBEL2003, "51476"), (Standards.NACEBEL2008, "46496")),
        ((Standards.NACEBEL2003, "51476"), (Standards.NACEBEL2008, "46495")),
        ((Standards.NACEBEL2003, "51476"), (Standards.NACEBEL2008, "46497")),
        ((Standards.NACEBEL2003, "5147601"), (Standards.NACEBEL2008, "4649601")),
        ((Standards.NACEBEL2003, "51477"), (Standards.NACEBEL2008, "46498")),
        ((Standards.NACEBEL2003, "5147701"), (Standards.NACEBEL2008, "4649801")),
        ((Standards.NACEBEL2003, "51478"), (Standards.NACEBEL2008, "46499")),
        ((Standards.NACEBEL2003, "5147801"), (Standards.NACEBEL2008, "4649901")),
        ((Standards.NACEBEL2003, "5147802"), (Standards.NACEBEL2008, "4649902")),
        ((Standards.NACEBEL2003, "5147803"), (Standards.NACEBEL2008, "4649903")),
        ((Standards.NACEBEL2003, "51510"), (Standards.NACEBEL2008, "46710")),
        ((Standards.NACEBEL2003, "5151001"), (Standards.NACEBEL2008, "4671001")),
        ((Standards.NACEBEL2003, "5151002"), (Standards.NACEBEL2008, "46710")),
        ((Standards.NACEBEL2003, "5151003"), (Standards.NACEBEL2008, "4671002")),
        ((Standards.NACEBEL2003, "51520"), (Standards.NACEBEL2008, "46720")),
        ((Standards.NACEBEL2003, "5152001"), (Standards.NACEBEL2008, "4672001")),
        ((Standards.NACEBEL2003, "5152002"), (Standards.NACEBEL2008, "4672002")),
        ((Standards.NACEBEL2003, "5152003"), (Standards.NACEBEL2008, "4672003")),
        ((Standards.NACEBEL2003, "51531"), (Standards.NACEBEL2008, "46732")),
        ((Standards.NACEBEL2003, "51531"), (Standards.NACEBEL2008, "46731")),
        ((Standards.NACEBEL2003, "5153101"), (Standards.NACEBEL2008, "4673201")),
        ((Standards.NACEBEL2003, "5153102"), (Standards.NACEBEL2008, "4673202")),
        ((Standards.NACEBEL2003, "5153103"), (Standards.NACEBEL2008, "4673203")),
        ((Standards.NACEBEL2003, "5153104"), (Standards.NACEBEL2008, "4673204")),
        ((Standards.NACEBEL2003, "51532"), (Standards.NACEBEL2008, "46731")),
        ((Standards.NACEBEL2003, "51532"), (Standards.NACEBEL2008, "46733")),
        ((Standards.NACEBEL2003, "51532"), (Standards.NACEBEL2008, "46734")),
        ((Standards.NACEBEL2003, "51532"), (Standards.NACEBEL2008, "46735")),
        ((Standards.NACEBEL2003, "51532"), (Standards.NACEBEL2008, "46736")),
        ((Standards.NACEBEL2003, "51532"), (Standards.NACEBEL2008, "46739")),
        ((Standards.NACEBEL2003, "5153201"), (Standards.NACEBEL2008, "4673311")),
        ((Standards.NACEBEL2003, "5153202"), (Standards.NACEBEL2008, "4673101")),
        ((Standards.NACEBEL2003, "5153203"), (Standards.NACEBEL2008, "4673401")),
        ((Standards.NACEBEL2003, "5153204"), (Standards.NACEBEL2008, "4673601")),
        ((Standards.NACEBEL2003, "5153205"), (Standards.NACEBEL2008, "4673102")),
        ((Standards.NACEBEL2003, "51541"), (Standards.NACEBEL2008, "46741")),
        ((Standards.NACEBEL2003, "5154101"), (Standards.NACEBEL2008, "4674101")),
        ((Standards.NACEBEL2003, "5154102"), (Standards.NACEBEL2008, "4674102")),
        ((Standards.NACEBEL2003, "5154103"), (Standards.NACEBEL2008, "4674103")),
        ((Standards.NACEBEL2003, "51542"), (Standards.NACEBEL2008, "46742")),
        ((Standards.NACEBEL2003, "5154201"), (Standards.NACEBEL2008, "4674201")),
        ((Standards.NACEBEL2003, "5154202"), (Standards.NACEBEL2008, "4674202")),
        ((Standards.NACEBEL2003, "51550"), (Standards.NACEBEL2008, "46751")),
        ((Standards.NACEBEL2003, "51550"), (Standards.NACEBEL2008, "46752")),
        ((Standards.NACEBEL2003, "51550"), (Standards.NACEBEL2008, "46769")),
        ((Standards.NACEBEL2003, "5155001"), (Standards.NACEBEL2008, "4675101")),
        ((Standards.NACEBEL2003, "5155002"), (Standards.NACEBEL2008, "4675201")),
        ((Standards.NACEBEL2003, "5155003"), (Standards.NACEBEL2008, "4676911")),
        ((Standards.NACEBEL2003, "5155004"), (Standards.NACEBEL2008, "4676912")),
        ((Standards.NACEBEL2003, "5155005"), (Standards.NACEBEL2008, "4675102")),
        ((Standards.NACEBEL2003, "51561"), (Standards.NACEBEL2008, "46761")),
        ((Standards.NACEBEL2003, "5156101"), (Standards.NACEBEL2008, "4676101")),
        ((Standards.NACEBEL2003, "5156102"), (Standards.NACEBEL2008, "4676102")),
        ((Standards.NACEBEL2003, "51562"), (Standards.NACEBEL2008, "46769")),
        ((Standards.NACEBEL2003, "5156201"), (Standards.NACEBEL2008, "4676901")),
        ((Standards.NACEBEL2003, "5156202"), (Standards.NACEBEL2008, "4676902")),
        ((Standards.NACEBEL2003, "5156203"), (Standards.NACEBEL2008, "4676903")),
        ((Standards.NACEBEL2003, "51570"), (Standards.NACEBEL2008, "46772")),
        ((Standards.NACEBEL2003, "51570"), (Standards.NACEBEL2008, "46771")),
        ((Standards.NACEBEL2003, "51570"), (Standards.NACEBEL2008, "46779")),
        ((Standards.NACEBEL2003, "5157001"), (Standards.NACEBEL2008, "4677201")),
        ((Standards.NACEBEL2003, "51610"), (Standards.NACEBEL2008, "46620")),
        ((Standards.NACEBEL2003, "5161001"), (Standards.NACEBEL2008, "46620")),
        ((Standards.NACEBEL2003, "5161002"), (Standards.NACEBEL2008, "46620")),
        ((Standards.NACEBEL2003, "51620"), (Standards.NACEBEL2008, "46630")),
        ((Standards.NACEBEL2003, "5162001"), (Standards.NACEBEL2008, "46630")),
        ((Standards.NACEBEL2003, "5162002"), (Standards.NACEBEL2008, "46630")),
        ((Standards.NACEBEL2003, "51630"), (Standards.NACEBEL2008, "46640")),
        ((Standards.NACEBEL2003, "5163001"), (Standards.NACEBEL2008, "46640")),
        ((Standards.NACEBEL2003, "5163002"), (Standards.NACEBEL2008, "46640")),
        ((Standards.NACEBEL2003, "51640"), (Standards.NACEBEL2008, "46510")),
        ((Standards.NACEBEL2003, "5164001"), (Standards.NACEBEL2008, "46510")),
        ((Standards.NACEBEL2003, "5164002"), (Standards.NACEBEL2008, "46660")),
        ((Standards.NACEBEL2003, "5164003"), (Standards.NACEBEL2008, "46650")),
        ((Standards.NACEBEL2003, "51651"), (Standards.NACEBEL2008, "46693")),
        ((Standards.NACEBEL2003, "5165101"), (Standards.NACEBEL2008, "46693")),
        ((Standards.NACEBEL2003, "5165102"), (Standards.NACEBEL2008, "46693")),
        ((Standards.NACEBEL2003, "51652"), (Standards.NACEBEL2008, "46699")),
        ((Standards.NACEBEL2003, "5165201"), (Standards.NACEBEL2008, "46694")),
        ((Standards.NACEBEL2003, "5165202"), (Standards.NACEBEL2008, "46699")),
        ((Standards.NACEBEL2003, "5165203"), (Standards.NACEBEL2008, "46696")),
        ((Standards.NACEBEL2003, "5165204"), (Standards.NACEBEL2008, "46699")),
        ((Standards.NACEBEL2003, "5165205"), (Standards.NACEBEL2008, "46699")),
        ((Standards.NACEBEL2003, "5165206"), (Standards.NACEBEL2008, "46699")),
        ((Standards.NACEBEL2003, "5165207"), (Standards.NACEBEL2008, "46699")),
        ((Standards.NACEBEL2003, "51653"), (Standards.NACEBEL2008, "46699")),
        ((Standards.NACEBEL2003, "5165301"), (Standards.NACEBEL2008, "46699")),
        ((Standards.NACEBEL2003, "5165302"), (Standards.NACEBEL2008, "46699")),
        ((Standards.NACEBEL2003, "5165303"), (Standards.NACEBEL2008, "46699")),
        ((Standards.NACEBEL2003, "5165304"), (Standards.NACEBEL2008, "46699")),
        ((Standards.NACEBEL2003, "5165305"), (Standards.NACEBEL2008, "46699")),
        ((Standards.NACEBEL2003, "51660"), (Standards.NACEBEL2008, "46610")),
        ((Standards.NACEBEL2003, "5166001"), (Standards.NACEBEL2008, "46610")),
        ((Standards.NACEBEL2003, "5166002"), (Standards.NACEBEL2008, "46610")),
        ((Standards.NACEBEL2003, "5166003"), (Standards.NACEBEL2008, "46610")),
        ((Standards.NACEBEL2003, "51700"), (Standards.NACEBEL2008, "46900")),
        ((Standards.NACEBEL2003, "5170001"), (Standards.NACEBEL2008, "46900")),
        ((Standards.NACEBEL2003, "5170002"), (Standards.NACEBEL2008, "46900")),
        ((Standards.NACEBEL2003, "51810"), (Standards.NACEBEL2008, "46620")),
        ((Standards.NACEBEL2003, "51820"), (Standards.NACEBEL2008, "46630")),
        ((Standards.NACEBEL2003, "51830"), (Standards.NACEBEL2008, "46640")),
        ((Standards.NACEBEL2003, "51840"), (Standards.NACEBEL2008, "46510")),
        ((Standards.NACEBEL2003, "51850"), (Standards.NACEBEL2008, "46660")),
        ((Standards.NACEBEL2003, "51850"), (Standards.NACEBEL2008, "46650")),
        ((Standards.NACEBEL2003, "51860"), (Standards.NACEBEL2008, "46520")),
        ((Standards.NACEBEL2003, "51871"), (Standards.NACEBEL2008, "46693")),
        ((Standards.NACEBEL2003, "51872"), (Standards.NACEBEL2008, "46699")),
        ((Standards.NACEBEL2003, "51872"), (Standards.NACEBEL2008, "46691")),
        ((Standards.NACEBEL2003, "51872"), (Standards.NACEBEL2008, "46692")),
        ((Standards.NACEBEL2003, "51872"), (Standards.NACEBEL2008, "46694")),
        ((Standards.NACEBEL2003, "51872"), (Standards.NACEBEL2008, "46695")),
        ((Standards.NACEBEL2003, "51872"), (Standards.NACEBEL2008, "46696")),
        ((Standards.NACEBEL2003, "51872"), (Standards.NACEBEL2008, "46697")),
        ((Standards.NACEBEL2003, "51873"), (Standards.NACEBEL2008, "46699")),
        ((Standards.NACEBEL2003, "51880"), (Standards.NACEBEL2008, "46610")),
        ((Standards.NACEBEL2003, "51900"), (Standards.NACEBEL2008, "46900")),
        ((Standards.NACEBEL2003, "52111"), (Standards.NACEBEL2008, "47111")),
        ((Standards.NACEBEL2003, "5211101"), (Standards.NACEBEL2008, "4711101")),
        ((Standards.NACEBEL2003, "52112"), (Standards.NACEBEL2008, "47112")),
        ((Standards.NACEBEL2003, "5211201"), (Standards.NACEBEL2008, "4711201")),
        ((Standards.NACEBEL2003, "52113"), (Standards.NACEBEL2008, "47113")),
        ((Standards.NACEBEL2003, "5211301"), (Standards.NACEBEL2008, "4711301")),
        ((Standards.NACEBEL2003, "52114"), (Standards.NACEBEL2008, "47114")),
        ((Standards.NACEBEL2003, "5211401"), (Standards.NACEBEL2008, "4711401")),
        ((Standards.NACEBEL2003, "52115"), (Standards.NACEBEL2008, "47115")),
        ((Standards.NACEBEL2003, "5211501"), (Standards.NACEBEL2008, "47115")),
        ((Standards.NACEBEL2003, "52116"), (Standards.NACEBEL2008, "47112")),
        ((Standards.NACEBEL2003, "5211601"), (Standards.NACEBEL2008, "4711211")),
        ((Standards.NACEBEL2003, "52121"), (Standards.NACEBEL2008, "47192")),
        ((Standards.NACEBEL2003, "5212101"), (Standards.NACEBEL2008, "4719201")),
        ((Standards.NACEBEL2003, "52122"), (Standards.NACEBEL2008, "47191")),
        ((Standards.NACEBEL2003, "5212201"), (Standards.NACEBEL2008, "4719101")),
        ((Standards.NACEBEL2003, "52210"), (Standards.NACEBEL2008, "47210")),
        ((Standards.NACEBEL2003, "5221001"), (Standards.NACEBEL2008, "4721001")),
        ((Standards.NACEBEL2003, "52220"), (Standards.NACEBEL2008, "47221")),
        ((Standards.NACEBEL2003, "52220"), (Standards.NACEBEL2008, "47222")),
        ((Standards.NACEBEL2003, "5222001"), (Standards.NACEBEL2008, "4722101")),
        ((Standards.NACEBEL2003, "5222002"), (Standards.NACEBEL2008, "47222")),
        ((Standards.NACEBEL2003, "52230"), (Standards.NACEBEL2008, "47230")),
        ((Standards.NACEBEL2003, "5223001"), (Standards.NACEBEL2008, "4723001")),
        ((Standards.NACEBEL2003, "52240"), (Standards.NACEBEL2008, "47241")),
        ((Standards.NACEBEL2003, "52240"), (Standards.NACEBEL2008, "47242")),
        ((Standards.NACEBEL2003, "5224001"), (Standards.NACEBEL2008, "4724101")),
        ((Standards.NACEBEL2003, "52250"), (Standards.NACEBEL2008, "47252")),
        ((Standards.NACEBEL2003, "52250"), (Standards.NACEBEL2008, "47251")),
        ((Standards.NACEBEL2003, "5225001"), (Standards.NACEBEL2008, "4725201")),
        ((Standards.NACEBEL2003, "5225002"), (Standards.NACEBEL2008, "4725202")),
        ((Standards.NACEBEL2003, "52260"), (Standards.NACEBEL2008, "47260")),
        ((Standards.NACEBEL2003, "5226001"), (Standards.NACEBEL2008, "4726001")),
        ((Standards.NACEBEL2003, "52271"), (Standards.NACEBEL2008, "47291")),
        ((Standards.NACEBEL2003, "5227101"), (Standards.NACEBEL2008, "4729101")),
        ((Standards.NACEBEL2003, "52272"), (Standards.NACEBEL2008, "47299")),
        ((Standards.NACEBEL2003, "52272"), (Standards.NACEBEL2008, "47210")),
        ((Standards.NACEBEL2003, "5227201"), (Standards.NACEBEL2008, "4729901")),
        ((Standards.NACEBEL2003, "5227202"), (Standards.NACEBEL2008, "4729902")),
        ((Standards.NACEBEL2003, "5227203"), (Standards.NACEBEL2008, "4721011")),
        ((Standards.NACEBEL2003, "5227204"), (Standards.NACEBEL2008, "4729903")),
        ((Standards.NACEBEL2003, "52310"), (Standards.NACEBEL2008, "47730")),
        ((Standards.NACEBEL2003, "5231001"), (Standards.NACEBEL2008, "4773001")),
        ((Standards.NACEBEL2003, "52320"), (Standards.NACEBEL2008, "47740")),
        ((Standards.NACEBEL2003, "5232001"), (Standards.NACEBEL2008, "4774001")),
        ((Standards.NACEBEL2003, "5232002"), (Standards.NACEBEL2008, "4774002")),
        ((Standards.NACEBEL2003, "5232003"), (Standards.NACEBEL2008, "4774003")),
        ((Standards.NACEBEL2003, "52330"), (Standards.NACEBEL2008, "47750")),
        ((Standards.NACEBEL2003, "5233001"), (Standards.NACEBEL2008, "4775001")),
        ((Standards.NACEBEL2003, "5233002"), (Standards.NACEBEL2008, "4775002")),
        ((Standards.NACEBEL2003, "52410"), (Standards.NACEBEL2008, "47512")),
        ((Standards.NACEBEL2003, "52410"), (Standards.NACEBEL2008, "47511")),
        ((Standards.NACEBEL2003, "52410"), (Standards.NACEBEL2008, "47513")),
        ((Standards.NACEBEL2003, "52410"), (Standards.NACEBEL2008, "47519")),
        ((Standards.NACEBEL2003, "5241001"), (Standards.NACEBEL2008, "4751201")),
        ((Standards.NACEBEL2003, "5241002"), (Standards.NACEBEL2008, "4751301")),
        ((Standards.NACEBEL2003, "5241003"), (Standards.NACEBEL2008, "4751302")),
        ((Standards.NACEBEL2003, "5241004"), (Standards.NACEBEL2008, "4751303")),
        ((Standards.NACEBEL2003, "5241005"), (Standards.NACEBEL2008, "4751901")),
        ((Standards.NACEBEL2003, "5241006"), (Standards.NACEBEL2008, "4751202")),
        ((Standards.NACEBEL2003, "52421"), (Standards.NACEBEL2008, "47716")),
        ((Standards.NACEBEL2003, "5242101"), (Standards.NACEBEL2008, "4771601")),
        ((Standards.NACEBEL2003, "52422"), (Standards.NACEBEL2008, "47712")),
        ((Standards.NACEBEL2003, "5242201"), (Standards.NACEBEL2008, "4771201")),
        ((Standards.NACEBEL2003, "52423"), (Standards.NACEBEL2008, "47711")),
        ((Standards.NACEBEL2003, "5242301"), (Standards.NACEBEL2008, "4771101")),
        ((Standards.NACEBEL2003, "52424"), (Standards.NACEBEL2008, "47713")),
        ((Standards.NACEBEL2003, "5242401"), (Standards.NACEBEL2008, "4771301")),
        ((Standards.NACEBEL2003, "52425"), (Standards.NACEBEL2008, "47714")),
        ((Standards.NACEBEL2003, "5242501"), (Standards.NACEBEL2008, "4771401")),
        ((Standards.NACEBEL2003, "52426"), (Standards.NACEBEL2008, "47715")),
        ((Standards.NACEBEL2003, "5242601"), (Standards.NACEBEL2008, "4771501")),
        ((Standards.NACEBEL2003, "52431"), (Standards.NACEBEL2008, "47721")),
        ((Standards.NACEBEL2003, "5243101"), (Standards.NACEBEL2008, "4772101")),
        ((Standards.NACEBEL2003, "52432"), (Standards.NACEBEL2008, "47722")),
        ((Standards.NACEBEL2003, "5243201"), (Standards.NACEBEL2008, "4772201")),
        ((Standards.NACEBEL2003, "52441"), (Standards.NACEBEL2008, "47591")),
        ((Standards.NACEBEL2003, "5244101"), (Standards.NACEBEL2008, "4759101")),
        ((Standards.NACEBEL2003, "5244102"), (Standards.NACEBEL2008, "4759102")),
        ((Standards.NACEBEL2003, "5244103"), (Standards.NACEBEL2008, "4759103")),
        ((Standards.NACEBEL2003, "52442"), (Standards.NACEBEL2008, "47592")),
        ((Standards.NACEBEL2003, "52442"), (Standards.NACEBEL2008, "47530")),
        ((Standards.NACEBEL2003, "52442"), (Standards.NACEBEL2008, "47593")),
        ((Standards.NACEBEL2003, "52442"), (Standards.NACEBEL2008, "47599")),
        ((Standards.NACEBEL2003, "5244201"), (Standards.NACEBEL2008, "4759201")),
        ((Standards.NACEBEL2003, "5244202"), (Standards.NACEBEL2008, "4759301")),
        ((Standards.NACEBEL2003, "5244203"), (Standards.NACEBEL2008, "4753011")),
        ((Standards.NACEBEL2003, "5244204"), (Standards.NACEBEL2008, "4759901")),
        ((Standards.NACEBEL2003, "5244205"), (Standards.NACEBEL2008, "4759902")),
        ((Standards.NACEBEL2003, "5244206"), (Standards.NACEBEL2008, "4759903")),
        ((Standards.NACEBEL2003, "52450"), (Standards.NACEBEL2008, "47540")),
        ((Standards.NACEBEL2003, "52450"), (Standards.NACEBEL2008, "47430")),
        ((Standards.NACEBEL2003, "52450"), (Standards.NACEBEL2008, "47594")),
        ((Standards.NACEBEL2003, "52450"), (Standards.NACEBEL2008, "47630")),
        ((Standards.NACEBEL2003, "5245001"), (Standards.NACEBEL2008, "4754001")),
        ((Standards.NACEBEL2003, "5245002"), (Standards.NACEBEL2008, "4743001")),
        ((Standards.NACEBEL2003, "5245003"), (Standards.NACEBEL2008, "4763001")),
        ((Standards.NACEBEL2003, "5245004"), (Standards.NACEBEL2008, "4759401")),
        ((Standards.NACEBEL2003, "52461"), (Standards.NACEBEL2008, "47521")),
        ((Standards.NACEBEL2003, "52461"), (Standards.NACEBEL2008, "47522")),
        ((Standards.NACEBEL2003, "52461"), (Standards.NACEBEL2008, "47523")),
        ((Standards.NACEBEL2003, "52461"), (Standards.NACEBEL2008, "47525")),
        ((Standards.NACEBEL2003, "52461"), (Standards.NACEBEL2008, "47526")),
        ((Standards.NACEBEL2003, "52461"), (Standards.NACEBEL2008, "47527")),
        ((Standards.NACEBEL2003, "52461"), (Standards.NACEBEL2008, "47529")),
        ((Standards.NACEBEL2003, "5246101"), (Standards.NACEBEL2008, "4752101")),
        ((Standards.NACEBEL2003, "52462"), (Standards.NACEBEL2008, "47521")),
        ((Standards.NACEBEL2003, "52462"), (Standards.NACEBEL2008, "47522")),
        ((Standards.NACEBEL2003, "52462"), (Standards.NACEBEL2008, "47523")),
        ((Standards.NACEBEL2003, "52462"), (Standards.NACEBEL2008, "47525")),
        ((Standards.NACEBEL2003, "52462"), (Standards.NACEBEL2008, "47526")),
        ((Standards.NACEBEL2003, "52462"), (Standards.NACEBEL2008, "47527")),
        ((Standards.NACEBEL2003, "52462"), (Standards.NACEBEL2008, "47529")),
        ((Standards.NACEBEL2003, "5246201"), (Standards.NACEBEL2008, "4752111")),
        ((Standards.NACEBEL2003, "52470"), (Standards.NACEBEL2008, "47620")),
        ((Standards.NACEBEL2003, "52470"), (Standards.NACEBEL2008, "47610")),
        ((Standards.NACEBEL2003, "5247001"), (Standards.NACEBEL2008, "4762001")),
        ((Standards.NACEBEL2003, "5247002"), (Standards.NACEBEL2008, "4762002")),
        ((Standards.NACEBEL2003, "52481"), (Standards.NACEBEL2008, "47781")),
        ((Standards.NACEBEL2003, "5248101"), (Standards.NACEBEL2008, "4778101")),
        ((Standards.NACEBEL2003, "5248102"), (Standards.NACEBEL2008, "4778102")),
        ((Standards.NACEBEL2003, "52482"), (Standards.NACEBEL2008, "47640")),
        ((Standards.NACEBEL2003, "5248201"), (Standards.NACEBEL2008, "4764001")),
        ((Standards.NACEBEL2003, "5248202"), (Standards.NACEBEL2008, "4764002")),
        ((Standards.NACEBEL2003, "52483"), (Standards.NACEBEL2008, "47761")),
        ((Standards.NACEBEL2003, "5248301"), (Standards.NACEBEL2008, "4776101")),
        ((Standards.NACEBEL2003, "5248302"), (Standards.NACEBEL2008, "4776102")),
        ((Standards.NACEBEL2003, "5248303"), (Standards.NACEBEL2008, "4776103")),
        ((Standards.NACEBEL2003, "5248304"), (Standards.NACEBEL2008, "4776104")),
        ((Standards.NACEBEL2003, "52484"), (Standards.NACEBEL2008, "47770")),
        ((Standards.NACEBEL2003, "5248401"), (Standards.NACEBEL2008, "4777001")),
        ((Standards.NACEBEL2003, "5248402"), (Standards.NACEBEL2008, "4777002")),
        ((Standards.NACEBEL2003, "52485"), (Standards.NACEBEL2008, "47782")),
        ((Standards.NACEBEL2003, "5248501"), (Standards.NACEBEL2008, "4778201")),
        ((Standards.NACEBEL2003, "52486"), (Standards.NACEBEL2008, "47530")),
        ((Standards.NACEBEL2003, "52486"), (Standards.NACEBEL2008, "47524")),
        ((Standards.NACEBEL2003, "5248601"), (Standards.NACEBEL2008, "4753001")),
        ((Standards.NACEBEL2003, "5248602"), (Standards.NACEBEL2008, "4753002")),
        ((Standards.NACEBEL2003, "5248603"), (Standards.NACEBEL2008, "4753003")),
        ((Standards.NACEBEL2003, "52487"), (Standards.NACEBEL2008, "47410")),
        ((Standards.NACEBEL2003, "52487"), (Standards.NACEBEL2008, "47420")),
        ((Standards.NACEBEL2003, "52487"), (Standards.NACEBEL2008, "47591")),
        ((Standards.NACEBEL2003, "5248701"), (Standards.NACEBEL2008, "4741001")),
        ((Standards.NACEBEL2003, "5248702"), (Standards.NACEBEL2008, "4741002")),
        ((Standards.NACEBEL2003, "52488"), (Standards.NACEBEL2008, "47784")),
        ((Standards.NACEBEL2003, "5248801"), (Standards.NACEBEL2008, "4778401")),
        ((Standards.NACEBEL2003, "5248802"), (Standards.NACEBEL2008, "4778402")),
        ((Standards.NACEBEL2003, "52489"), (Standards.NACEBEL2008, "47650")),
        ((Standards.NACEBEL2003, "5248901"), (Standards.NACEBEL2008, "4765001")),
        ((Standards.NACEBEL2003, "52491"), (Standards.NACEBEL2008, "47783")),
        ((Standards.NACEBEL2003, "5249101"), (Standards.NACEBEL2008, "4778301")),
        ((Standards.NACEBEL2003, "5249102"), (Standards.NACEBEL2008, "4778302")),
        ((Standards.NACEBEL2003, "52492"), (Standards.NACEBEL2008, "47785")),
        ((Standards.NACEBEL2003, "5249201"), (Standards.NACEBEL2008, "4778501")),
        ((Standards.NACEBEL2003, "52493"), (Standards.NACEBEL2008, "47788")),
        ((Standards.NACEBEL2003, "5249301"), (Standards.NACEBEL2008, "4778801")),
        ((Standards.NACEBEL2003, "5249302"), (Standards.NACEBEL2008, "4778802")),
        ((Standards.NACEBEL2003, "52494"), (Standards.NACEBEL2008, "47789")),
        ((Standards.NACEBEL2003, "5249401"), (Standards.NACEBEL2008, "47789")),
        ((Standards.NACEBEL2003, "52495"), (Standards.NACEBEL2008, "47789")),
        ((Standards.NACEBEL2003, "5249501"), (Standards.NACEBEL2008, "47789")),
        ((Standards.NACEBEL2003, "52496"), (Standards.NACEBEL2008, "47762")),
        ((Standards.NACEBEL2003, "5249601"), (Standards.NACEBEL2008, "4776201")),
        ((Standards.NACEBEL2003, "52497"), (Standards.NACEBEL2008, "47786")),
        ((Standards.NACEBEL2003, "5249701"), (Standards.NACEBEL2008, "4778601")),
        ((Standards.NACEBEL2003, "5249702"), (Standards.NACEBEL2008, "4778602")),
        ((Standards.NACEBEL2003, "52498"), (Standards.NACEBEL2008, "47789")),
        ((Standards.NACEBEL2003, "52498"), (Standards.NACEBEL2008, "47787")),
        ((Standards.NACEBEL2003, "5249801"), (Standards.NACEBEL2008, "4778701")),
        ((Standards.NACEBEL2003, "5249802"), (Standards.NACEBEL2008, "4778901")),
        ((Standards.NACEBEL2003, "5249803"), (Standards.NACEBEL2008, "4778902")),
        ((Standards.NACEBEL2003, "52501"), (Standards.NACEBEL2008, "47791")),
        ((Standards.NACEBEL2003, "5250101"), (Standards.NACEBEL2008, "4779101")),
        ((Standards.NACEBEL2003, "52502"), (Standards.NACEBEL2008, "47792")),
        ((Standards.NACEBEL2003, "52502"), (Standards.NACEBEL2008, "47793")),
        ((Standards.NACEBEL2003, "5250201"), (Standards.NACEBEL2008, "4779301")),
        ((Standards.NACEBEL2003, "5250202"), (Standards.NACEBEL2008, "4779302")),
        ((Standards.NACEBEL2003, "5250203"), (Standards.NACEBEL2008, "4779303")),
        ((Standards.NACEBEL2003, "52610"), (Standards.NACEBEL2008, "47910")),
        ((Standards.NACEBEL2003, "5261001"), (Standards.NACEBEL2008, "4791001")),
        ((Standards.NACEBEL2003, "5261002"), (Standards.NACEBEL2008, "4791002")),
        ((Standards.NACEBEL2003, "52621"), (Standards.NACEBEL2008, "47810")),
        ((Standards.NACEBEL2003, "5262101"), (Standards.NACEBEL2008, "4781001")),
        ((Standards.NACEBEL2003, "52622"), (Standards.NACEBEL2008, "47820")),
        ((Standards.NACEBEL2003, "5262201"), (Standards.NACEBEL2008, "4782001")),
        ((Standards.NACEBEL2003, "52623"), (Standards.NACEBEL2008, "47890")),
        ((Standards.NACEBEL2003, "5262301"), (Standards.NACEBEL2008, "4789001")),
        ((Standards.NACEBEL2003, "52630"), (Standards.NACEBEL2008, "47990")),
        ((Standards.NACEBEL2003, "52630"), (Standards.NACEBEL2008, "47791")),
        ((Standards.NACEBEL2003, "52630"), (Standards.NACEBEL2008, "47792")),
        ((Standards.NACEBEL2003, "52630"), (Standards.NACEBEL2008, "47793")),
        ((Standards.NACEBEL2003, "52630"), (Standards.NACEBEL2008, "47910")),
        ((Standards.NACEBEL2003, "5263001"), (Standards.NACEBEL2008, "4799001")),
        ((Standards.NACEBEL2003, "52710"), (Standards.NACEBEL2008, "95230")),
        ((Standards.NACEBEL2003, "5271001"), (Standards.NACEBEL2008, "9523001")),
        ((Standards.NACEBEL2003, "52720"), (Standards.NACEBEL2008, "95210")),
        ((Standards.NACEBEL2003, "52720"), (Standards.NACEBEL2008, "95220")),
        ((Standards.NACEBEL2003, "5272001"), (Standards.NACEBEL2008, "9522001")),
        ((Standards.NACEBEL2003, "5272002"), (Standards.NACEBEL2008, "9521001")),
        ((Standards.NACEBEL2003, "52730"), (Standards.NACEBEL2008, "95250")),
        ((Standards.NACEBEL2003, "5273001"), (Standards.NACEBEL2008, "9525001")),
        ((Standards.NACEBEL2003, "52740"), (Standards.NACEBEL2008, "95290")),
        ((Standards.NACEBEL2003, "52740"), (Standards.NACEBEL2008, "13300")),
        ((Standards.NACEBEL2003, "52740"), (Standards.NACEBEL2008, "95120")),
        ((Standards.NACEBEL2003, "52740"), (Standards.NACEBEL2008, "95230")),
        ((Standards.NACEBEL2003, "52740"), (Standards.NACEBEL2008, "96099")),
        ((Standards.NACEBEL2003, "5274001"), (Standards.NACEBEL2008, "9529001")),
        ((Standards.NACEBEL2003, "5274002"), (Standards.NACEBEL2008, "9529002")),
        ((Standards.NACEBEL2003, "5274003"), (Standards.NACEBEL2008, "9529003")),
        ((Standards.NACEBEL2003, "5274004"), (Standards.NACEBEL2008, "3311001")),
        ((Standards.NACEBEL2003, "5274005"), (Standards.NACEBEL2008, "9529004")),
        ((Standards.NACEBEL2003, "5274006"), (Standards.NACEBEL2008, "9529005")),
        ((Standards.NACEBEL2003, "5274007"), (Standards.NACEBEL2008, "9529006")),
        ((Standards.NACEBEL2003, "5274008"), (Standards.NACEBEL2008, "9529007")),
        ((Standards.NACEBEL2003, "5274009"), (Standards.NACEBEL2008, "9529008")),
        ((Standards.NACEBEL2003, "55100"), (Standards.NACEBEL2008, "55100")),
        ((Standards.NACEBEL2003, "5510001"), (Standards.NACEBEL2008, "5510001")),
        ((Standards.NACEBEL2003, "55101"), (Standards.NACEBEL2008, "55100")),
        ((Standards.NACEBEL2003, "55102"), (Standards.NACEBEL2008, "55100")),
        ((Standards.NACEBEL2003, "55110"), (Standards.NACEBEL2008, "55100")),
        ((Standards.NACEBEL2003, "5511001"), (Standards.NACEBEL2008, "5510011")),
        ((Standards.NACEBEL2003, "55120"), (Standards.NACEBEL2008, "55100")),
        ((Standards.NACEBEL2003, "5512001"), (Standards.NACEBEL2008, "55100")),
        ((Standards.NACEBEL2003, "5512002"), (Standards.NACEBEL2008, "55100")),
        ((Standards.NACEBEL2003, "55210"), (Standards.NACEBEL2008, "55201")),
        ((Standards.NACEBEL2003, "55210"), (Standards.NACEBEL2008, "55209")),
        ((Standards.NACEBEL2003, "5521001"), (Standards.NACEBEL2008, "5520101")),
        ((Standards.NACEBEL2003, "55220"), (Standards.NACEBEL2008, "55300")),
        ((Standards.NACEBEL2003, "5522001"), (Standards.NACEBEL2008, "5530001")),
        ((Standards.NACEBEL2003, "55231"), (Standards.NACEBEL2008, "55202")),
        ((Standards.NACEBEL2003, "5523101"), (Standards.NACEBEL2008, "5520201")),
        ((Standards.NACEBEL2003, "5523102"), (Standards.NACEBEL2008, "5520901")),
        ((Standards.NACEBEL2003, "55232"), (Standards.NACEBEL2008, "55203")),
        ((Standards.NACEBEL2003, "55232"), (Standards.NACEBEL2008, "55204")),
        ((Standards.NACEBEL2003, "55232"), (Standards.NACEBEL2008, "55209")),
        ((Standards.NACEBEL2003, "55232"), (Standards.NACEBEL2008, "55900")),
        ((Standards.NACEBEL2003, "5523201"), (Standards.NACEBEL2008, "5520301")),
        ((Standards.NACEBEL2003, "5523202"), (Standards.NACEBEL2008, "5520302")),
        ((Standards.NACEBEL2003, "5523203"), (Standards.NACEBEL2008, "55900")),
        ((Standards.NACEBEL2003, "5523204"), (Standards.NACEBEL2008, "5520902")),
        ((Standards.NACEBEL2003, "55233"), (Standards.NACEBEL2008, "55900")),
        ((Standards.NACEBEL2003, "5523301"), (Standards.NACEBEL2008, "5590001")),
        ((Standards.NACEBEL2003, "5523302"), (Standards.NACEBEL2008, "55900")),
        ((Standards.NACEBEL2003, "55301"), (Standards.NACEBEL2008, "56101")),
        ((Standards.NACEBEL2003, "55301"), (Standards.NACEBEL2008, "56102")),
        ((Standards.NACEBEL2003, "5530101"), (Standards.NACEBEL2008, "5610101")),
        ((Standards.NACEBEL2003, "5530102"), (Standards.NACEBEL2008, "5610102")),
        ((Standards.NACEBEL2003, "5530103"), (Standards.NACEBEL2008, "5610103")),
        ((Standards.NACEBEL2003, "5530104"), (Standards.NACEBEL2008, "5610104")),
        ((Standards.NACEBEL2003, "5530105"), (Standards.NACEBEL2008, "5610105")),
        ((Standards.NACEBEL2003, "55302"), (Standards.NACEBEL2008, "56102")),
        ((Standards.NACEBEL2003, "55302"), (Standards.NACEBEL2008, "56101")),
        ((Standards.NACEBEL2003, "5530201"), (Standards.NACEBEL2008, "5610201")),
        ((Standards.NACEBEL2003, "5530202"), (Standards.NACEBEL2008, "5610202")),
        ((Standards.NACEBEL2003, "5530203"), (Standards.NACEBEL2008, "5610203")),
        ((Standards.NACEBEL2003, "5530204"), (Standards.NACEBEL2008, "5610204")),
        ((Standards.NACEBEL2003, "5530205"), (Standards.NACEBEL2008, "5610205")),
        ((Standards.NACEBEL2003, "5530206"), (Standards.NACEBEL2008, "5610206")),
        ((Standards.NACEBEL2003, "5530207"), (Standards.NACEBEL2008, "5610207")),
        ((Standards.NACEBEL2003, "55401"), (Standards.NACEBEL2008, "56301")),
        ((Standards.NACEBEL2003, "5540101"), (Standards.NACEBEL2008, "5630101")),
        ((Standards.NACEBEL2003, "55402"), (Standards.NACEBEL2008, "56302")),
        ((Standards.NACEBEL2003, "55402"), (Standards.NACEBEL2008, "56309")),
        ((Standards.NACEBEL2003, "5540201"), (Standards.NACEBEL2008, "5630201")),
        ((Standards.NACEBEL2003, "55510"), (Standards.NACEBEL2008, "56290")),
        ((Standards.NACEBEL2003, "55521"), (Standards.NACEBEL2008, "56290")),
        ((Standards.NACEBEL2003, "5552101"), (Standards.NACEBEL2008, "5629001")),
        ((Standards.NACEBEL2003, "55522"), (Standards.NACEBEL2008, "56210")),
        ((Standards.NACEBEL2003, "5552201"), (Standards.NACEBEL2008, "5621001")),
        ((Standards.NACEBEL2003, "5552202"), (Standards.NACEBEL2008, "5621002")),
        ((Standards.NACEBEL2003, "60100"), (Standards.NACEBEL2008, "49200")),
        ((Standards.NACEBEL2003, "60100"), (Standards.NACEBEL2008, "49100")),
        ((Standards.NACEBEL2003, "6010001"), (Standards.NACEBEL2008, "49100")),
        ((Standards.NACEBEL2003, "60211"), (Standards.NACEBEL2008, "49310")),
        ((Standards.NACEBEL2003, "6021101"), (Standards.NACEBEL2008, "4931001")),
        ((Standards.NACEBEL2003, "60212"), (Standards.NACEBEL2008, "49310")),
        ((Standards.NACEBEL2003, "60212"), (Standards.NACEBEL2008, "49390")),
        ((Standards.NACEBEL2003, "6021201"), (Standards.NACEBEL2008, "4931011")),
        ((Standards.NACEBEL2003, "6021202"), (Standards.NACEBEL2008, "4931012")),
        ((Standards.NACEBEL2003, "6021203"), (Standards.NACEBEL2008, "49310")),
        ((Standards.NACEBEL2003, "60220"), (Standards.NACEBEL2008, "49320")),
        ((Standards.NACEBEL2003, "6022001"), (Standards.NACEBEL2008, "4932001")),
        ((Standards.NACEBEL2003, "6022002"), (Standards.NACEBEL2008, "4932002")),
        ((Standards.NACEBEL2003, "60230"), (Standards.NACEBEL2008, "49390")),
        ((Standards.NACEBEL2003, "6023001"), (Standards.NACEBEL2008, "4939001")),
        ((Standards.NACEBEL2003, "6023002"), (Standards.NACEBEL2008, "4939002")),
        ((Standards.NACEBEL2003, "60241"), (Standards.NACEBEL2008, "49420")),
        ((Standards.NACEBEL2003, "6024101"), (Standards.NACEBEL2008, "4942001")),
        ((Standards.NACEBEL2003, "6024102"), (Standards.NACEBEL2008, "4942002")),
        ((Standards.NACEBEL2003, "6024103"), (Standards.NACEBEL2008, "4942003")),
        ((Standards.NACEBEL2003, "60242"), (Standards.NACEBEL2008, "49410")),
        ((Standards.NACEBEL2003, "6024201"), (Standards.NACEBEL2008, "4941001")),
        ((Standards.NACEBEL2003, "6024202"), (Standards.NACEBEL2008, "4941002")),
        ((Standards.NACEBEL2003, "6024203"), (Standards.NACEBEL2008, "4941003")),
        ((Standards.NACEBEL2003, "6024204"), (Standards.NACEBEL2008, "4941004")),
        ((Standards.NACEBEL2003, "60243"), (Standards.NACEBEL2008, "49410")),
        ((Standards.NACEBEL2003, "6024301"), (Standards.NACEBEL2008, "4941011")),
        ((Standards.NACEBEL2003, "60300"), (Standards.NACEBEL2008, "49500")),
        ((Standards.NACEBEL2003, "6030001"), (Standards.NACEBEL2008, "4950001")),
        ((Standards.NACEBEL2003, "6030002"), (Standards.NACEBEL2008, "4950002")),
        ((Standards.NACEBEL2003, "61100"), (Standards.NACEBEL2008, "50200")),
        ((Standards.NACEBEL2003, "61100"), (Standards.NACEBEL2008, "50100")),
        ((Standards.NACEBEL2003, "61100"), (Standards.NACEBEL2008, "52220")),
        ((Standards.NACEBEL2003, "6110001"), (Standards.NACEBEL2008, "5020001")),
        ((Standards.NACEBEL2003, "6110002"), (Standards.NACEBEL2008, "5010001")),
        ((Standards.NACEBEL2003, "6110003"), (Standards.NACEBEL2008, "5020002")),
        ((Standards.NACEBEL2003, "6110004"), (Standards.NACEBEL2008, "5020003")),
        ((Standards.NACEBEL2003, "6110005"), (Standards.NACEBEL2008, "5020004")),
        ((Standards.NACEBEL2003, "61200"), (Standards.NACEBEL2008, "50400")),
        ((Standards.NACEBEL2003, "61200"), (Standards.NACEBEL2008, "50300")),
        ((Standards.NACEBEL2003, "61200"), (Standards.NACEBEL2008, "52220")),
        ((Standards.NACEBEL2003, "6120001"), (Standards.NACEBEL2008, "5040001")),
        ((Standards.NACEBEL2003, "62100"), (Standards.NACEBEL2008, "51100")),
        ((Standards.NACEBEL2003, "62100"), (Standards.NACEBEL2008, "51210")),
        ((Standards.NACEBEL2003, "6210001"), (Standards.NACEBEL2008, "5110001")),
        ((Standards.NACEBEL2003, "62200"), (Standards.NACEBEL2008, "51100")),
        ((Standards.NACEBEL2003, "62200"), (Standards.NACEBEL2008, "51210")),
        ((Standards.NACEBEL2003, "6220001"), (Standards.NACEBEL2008, "5110011")),
        ((Standards.NACEBEL2003, "6220002"), (Standards.NACEBEL2008, "5110012")),
        ((Standards.NACEBEL2003, "6220003"), (Standards.NACEBEL2008, "5110013")),
        ((Standards.NACEBEL2003, "6220004"), (Standards.NACEBEL2008, "5110014")),
        ((Standards.NACEBEL2003, "6220005"), (Standards.NACEBEL2008, "5110015")),
        ((Standards.NACEBEL2003, "62300"), (Standards.NACEBEL2008, "51220")),
        ((Standards.NACEBEL2003, "6230001"), (Standards.NACEBEL2008, "51220")),
        ((Standards.NACEBEL2003, "6230002"), (Standards.NACEBEL2008, "51220")),
        ((Standards.NACEBEL2003, "63111"), (Standards.NACEBEL2008, "52241")),
        ((Standards.NACEBEL2003, "6311101"), (Standards.NACEBEL2008, "5224101")),
        ((Standards.NACEBEL2003, "6311102"), (Standards.NACEBEL2008, "5224102")),
        ((Standards.NACEBEL2003, "63112"), (Standards.NACEBEL2008, "52249")),
        ((Standards.NACEBEL2003, "6311201"), (Standards.NACEBEL2008, "5224901")),
        ((Standards.NACEBEL2003, "63121"), (Standards.NACEBEL2008, "52100")),
        ((Standards.NACEBEL2003, "6312101"), (Standards.NACEBEL2008, "5210001")),
        ((Standards.NACEBEL2003, "63122"), (Standards.NACEBEL2008, "52100")),
        ((Standards.NACEBEL2003, "6312201"), (Standards.NACEBEL2008, "5210011")),
        ((Standards.NACEBEL2003, "63210"), (Standards.NACEBEL2008, "52210")),
        ((Standards.NACEBEL2003, "6321001"), (Standards.NACEBEL2008, "5221001")),
        ((Standards.NACEBEL2003, "6321002"), (Standards.NACEBEL2008, "5221002")),
        ((Standards.NACEBEL2003, "6321003"), (Standards.NACEBEL2008, "5221003")),
        ((Standards.NACEBEL2003, "6321004"), (Standards.NACEBEL2008, "4939011")),
        ((Standards.NACEBEL2003, "6321005"), (Standards.NACEBEL2008, "5221004")),
        ((Standards.NACEBEL2003, "63220"), (Standards.NACEBEL2008, "52220")),
        ((Standards.NACEBEL2003, "63220"), (Standards.NACEBEL2008, "85329")),
        ((Standards.NACEBEL2003, "6322001"), (Standards.NACEBEL2008, "5222001")),
        ((Standards.NACEBEL2003, "6322002"), (Standards.NACEBEL2008, "5222002")),
        ((Standards.NACEBEL2003, "6322003"), (Standards.NACEBEL2008, "5222003")),
        ((Standards.NACEBEL2003, "6322004"), (Standards.NACEBEL2008, "5222004")),
        ((Standards.NACEBEL2003, "6322005"), (Standards.NACEBEL2008, "52220")),
        ((Standards.NACEBEL2003, "63230"), (Standards.NACEBEL2008, "52230")),
        ((Standards.NACEBEL2003, "63230"), (Standards.NACEBEL2008, "85329")),
        ((Standards.NACEBEL2003, "6323001"), (Standards.NACEBEL2008, "52230")),
        ((Standards.NACEBEL2003, "6323002"), (Standards.NACEBEL2008, "52230")),
        ((Standards.NACEBEL2003, "6323003"), (Standards.NACEBEL2008, "8532901")),
        ((Standards.NACEBEL2003, "6323004"), (Standards.NACEBEL2008, "5223001")),
        ((Standards.NACEBEL2003, "6323005"), (Standards.NACEBEL2008, "5223002")),
        ((Standards.NACEBEL2003, "63301"), (Standards.NACEBEL2008, "79110")),
        ((Standards.NACEBEL2003, "6330101"), (Standards.NACEBEL2008, "7911001")),
        ((Standards.NACEBEL2003, "6330102"), (Standards.NACEBEL2008, "7911002")),
        ((Standards.NACEBEL2003, "6330103"), (Standards.NACEBEL2008, "7911003")),
        ((Standards.NACEBEL2003, "6330104"), (Standards.NACEBEL2008, "7911004")),
        ((Standards.NACEBEL2003, "63302"), (Standards.NACEBEL2008, "79120")),
        ((Standards.NACEBEL2003, "6330201"), (Standards.NACEBEL2008, "7912001")),
        ((Standards.NACEBEL2003, "6330202"), (Standards.NACEBEL2008, "7912002")),
        ((Standards.NACEBEL2003, "63303"), (Standards.NACEBEL2008, "79901")),
        ((Standards.NACEBEL2003, "63303"), (Standards.NACEBEL2008, "79909")),
        ((Standards.NACEBEL2003, "6330301"), (Standards.NACEBEL2008, "7990101")),
        ((Standards.NACEBEL2003, "63401"), (Standards.NACEBEL2008, "52290")),
        ((Standards.NACEBEL2003, "6340101"), (Standards.NACEBEL2008, "5229001")),
        ((Standards.NACEBEL2003, "63402"), (Standards.NACEBEL2008, "52290")),
        ((Standards.NACEBEL2003, "6340201"), (Standards.NACEBEL2008, "5229011")),
        ((Standards.NACEBEL2003, "6340202"), (Standards.NACEBEL2008, "5229012")),
        ((Standards.NACEBEL2003, "63403"), (Standards.NACEBEL2008, "52290")),
        ((Standards.NACEBEL2003, "6340301"), (Standards.NACEBEL2008, "5229021")),
        ((Standards.NACEBEL2003, "63404"), (Standards.NACEBEL2008, "52290")),
        ((Standards.NACEBEL2003, "6340401"), (Standards.NACEBEL2008, "52290")),
        ((Standards.NACEBEL2003, "63405"), (Standards.NACEBEL2008, "52290")),
        ((Standards.NACEBEL2003, "6340501"), (Standards.NACEBEL2008, "5229031")),
        ((Standards.NACEBEL2003, "6340502"), (Standards.NACEBEL2008, "5229032")),
        ((Standards.NACEBEL2003, "6340503"), (Standards.NACEBEL2008, "5229033")),
        ((Standards.NACEBEL2003, "63406"), (Standards.NACEBEL2008, "52290")),
        ((Standards.NACEBEL2003, "6340601"), (Standards.NACEBEL2008, "5229041")),
        ((Standards.NACEBEL2003, "6340602"), (Standards.NACEBEL2008, "5229042")),
        ((Standards.NACEBEL2003, "6340603"), (Standards.NACEBEL2008, "5229043")),
        ((Standards.NACEBEL2003, "64110"), (Standards.NACEBEL2008, "53100")),
        ((Standards.NACEBEL2003, "64110"), (Standards.NACEBEL2008, "82190")),
        ((Standards.NACEBEL2003, "6411001"), (Standards.NACEBEL2008, "5310001")),
        ((Standards.NACEBEL2003, "6411002"), (Standards.NACEBEL2008, "5310002")),
        ((Standards.NACEBEL2003, "6411003"), (Standards.NACEBEL2008, "5310003")),
        ((Standards.NACEBEL2003, "6411004"), (Standards.NACEBEL2008, "53100")),
        ((Standards.NACEBEL2003, "6411005"), (Standards.NACEBEL2008, "8219001")),
        ((Standards.NACEBEL2003, "64120"), (Standards.NACEBEL2008, "53200")),
        ((Standards.NACEBEL2003, "6412001"), (Standards.NACEBEL2008, "5320001")),
        ((Standards.NACEBEL2003, "64200"), (Standards.NACEBEL2008, "61200")),
        ((Standards.NACEBEL2003, "64200"), (Standards.NACEBEL2008, "60200")),
        ((Standards.NACEBEL2003, "64200"), (Standards.NACEBEL2008, "61100")),
        ((Standards.NACEBEL2003, "64200"), (Standards.NACEBEL2008, "61300")),
        ((Standards.NACEBEL2003, "64200"), (Standards.NACEBEL2008, "61900")),
        ((Standards.NACEBEL2003, "6420001"), (Standards.NACEBEL2008, "6120001")),
        ((Standards.NACEBEL2003, "6420002"), (Standards.NACEBEL2008, "6120002")),
        ((Standards.NACEBEL2003, "6420003"), (Standards.NACEBEL2008, "6120003")),
        ((Standards.NACEBEL2003, "6420004"), (Standards.NACEBEL2008, "6120004")),
        ((Standards.NACEBEL2003, "6420005"), (Standards.NACEBEL2008, "6120005")),
        ((Standards.NACEBEL2003, "64201"), (Standards.NACEBEL2008, "61100")),
        ((Standards.NACEBEL2003, "64202"), (Standards.NACEBEL2008, "61200")),
        ((Standards.NACEBEL2003, "65110"), (Standards.NACEBEL2008, "64110")),
        ((Standards.NACEBEL2003, "6511001"), (Standards.NACEBEL2008, "64110")),
        ((Standards.NACEBEL2003, "65120"), (Standards.NACEBEL2008, "64190")),
        ((Standards.NACEBEL2003, "65120"), (Standards.NACEBEL2008, "66191")),
        ((Standards.NACEBEL2003, "65121"), (Standards.NACEBEL2008, "64190")),
        ((Standards.NACEBEL2003, "6512101"), (Standards.NACEBEL2008, "64190")),
        ((Standards.NACEBEL2003, "65122"), (Standards.NACEBEL2008, "64190")),
        ((Standards.NACEBEL2003, "6512201"), (Standards.NACEBEL2008, "64190")),
        ((Standards.NACEBEL2003, "65123"), (Standards.NACEBEL2008, "64190")),
        ((Standards.NACEBEL2003, "6512301"), (Standards.NACEBEL2008, "64190")),
        ((Standards.NACEBEL2003, "6512302"), (Standards.NACEBEL2008, "64190")),
        ((Standards.NACEBEL2003, "6512303"), (Standards.NACEBEL2008, "64190")),
        ((Standards.NACEBEL2003, "6512304"), (Standards.NACEBEL2008, "64190")),
        ((Standards.NACEBEL2003, "6512305"), (Standards.NACEBEL2008, "64190")),
        ((Standards.NACEBEL2003, "6512306"), (Standards.NACEBEL2008, "64190")),
        ((Standards.NACEBEL2003, "6512307"), (Standards.NACEBEL2008, "64190")),
        ((Standards.NACEBEL2003, "6512308"), (Standards.NACEBEL2008, "64190")),
        ((Standards.NACEBEL2003, "65124"), (Standards.NACEBEL2008, "64190")),
        ((Standards.NACEBEL2003, "65210"), (Standards.NACEBEL2008, "64910")),
        ((Standards.NACEBEL2003, "6521001"), (Standards.NACEBEL2008, "6491001")),
        ((Standards.NACEBEL2003, "65221"), (Standards.NACEBEL2008, "64921")),
        ((Standards.NACEBEL2003, "6522101"), (Standards.NACEBEL2008, "6492101")),
        ((Standards.NACEBEL2003, "65222"), (Standards.NACEBEL2008, "64922")),
        ((Standards.NACEBEL2003, "65222"), (Standards.NACEBEL2008, "64929")),
        ((Standards.NACEBEL2003, "6522201"), (Standards.NACEBEL2008, "6492201")),
        ((Standards.NACEBEL2003, "6522202"), (Standards.NACEBEL2008, "6492202")),
        ((Standards.NACEBEL2003, "6522203"), (Standards.NACEBEL2008, "64922")),
        ((Standards.NACEBEL2003, "6522204"), (Standards.NACEBEL2008, "6492203")),
        ((Standards.NACEBEL2003, "65223"), (Standards.NACEBEL2008, "64991")),
        ((Standards.NACEBEL2003, "65231"), (Standards.NACEBEL2008, "64200")),
        ((Standards.NACEBEL2003, "6523101"), (Standards.NACEBEL2008, "6420001")),
        ((Standards.NACEBEL2003, "65232"), (Standards.NACEBEL2008, "64991")),
        ((Standards.NACEBEL2003, "6523201"), (Standards.NACEBEL2008, "64991")),
        ((Standards.NACEBEL2003, "65233"), (Standards.NACEBEL2008, "64992")),
        ((Standards.NACEBEL2003, "6523301"), (Standards.NACEBEL2008, "64992")),
        ((Standards.NACEBEL2003, "65234"), (Standards.NACEBEL2008, "64200")),
        ((Standards.NACEBEL2003, "6523401"), (Standards.NACEBEL2008, "64200")),
        ((Standards.NACEBEL2003, "65235"), (Standards.NACEBEL2008, "64300")),
        ((Standards.NACEBEL2003, "6523501"), (Standards.NACEBEL2008, "64300")),
        ((Standards.NACEBEL2003, "65236"), (Standards.NACEBEL2008, "64999")),
        ((Standards.NACEBEL2003, "6523601"), (Standards.NACEBEL2008, "6499901")),
        ((Standards.NACEBEL2003, "6523602"), (Standards.NACEBEL2008, "6499902")),
        ((Standards.NACEBEL2003, "6523603"), (Standards.NACEBEL2008, "6499903")),
        ((Standards.NACEBEL2003, "6523604"), (Standards.NACEBEL2008, "64999")),
        ((Standards.NACEBEL2003, "6523605"), (Standards.NACEBEL2008, "6499904")),
        ((Standards.NACEBEL2003, "6523606"), (Standards.NACEBEL2008, "6499905")),
        ((Standards.NACEBEL2003, "66011"), (Standards.NACEBEL2008, "65111")),
        ((Standards.NACEBEL2003, "6601101"), (Standards.NACEBEL2008, "65111")),
        ((Standards.NACEBEL2003, "66012"), (Standards.NACEBEL2008, "65200")),
        ((Standards.NACEBEL2003, "6601201"), (Standards.NACEBEL2008, "65200")),
        ((Standards.NACEBEL2003, "66013"), (Standards.NACEBEL2008, "65112")),
        ((Standards.NACEBEL2003, "6601301"), (Standards.NACEBEL2008, "6511201")),
        ((Standards.NACEBEL2003, "66020"), (Standards.NACEBEL2008, "65300")),
        ((Standards.NACEBEL2003, "6602001"), (Standards.NACEBEL2008, "6530001")),
        ((Standards.NACEBEL2003, "6602002"), (Standards.NACEBEL2008, "6530002")),
        ((Standards.NACEBEL2003, "66031"), (Standards.NACEBEL2008, "65121")),
        ((Standards.NACEBEL2003, "6603101"), (Standards.NACEBEL2008, "6512101")),
        ((Standards.NACEBEL2003, "6603102"), (Standards.NACEBEL2008, "6512102")),
        ((Standards.NACEBEL2003, "6603103"), (Standards.NACEBEL2008, "6512103")),
        ((Standards.NACEBEL2003, "6603104"), (Standards.NACEBEL2008, "6512104")),
        ((Standards.NACEBEL2003, "6603105"), (Standards.NACEBEL2008, "6512105")),
        ((Standards.NACEBEL2003, "6603106"), (Standards.NACEBEL2008, "6512106")),
        ((Standards.NACEBEL2003, "6603107"), (Standards.NACEBEL2008, "6512107")),
        ((Standards.NACEBEL2003, "6603108"), (Standards.NACEBEL2008, "6512108")),
        ((Standards.NACEBEL2003, "6603109"), (Standards.NACEBEL2008, "6512109")),
        ((Standards.NACEBEL2003, "66032"), (Standards.NACEBEL2008, "65200")),
        ((Standards.NACEBEL2003, "6603201"), (Standards.NACEBEL2008, "65200")),
        ((Standards.NACEBEL2003, "66033"), (Standards.NACEBEL2008, "65122")),
        ((Standards.NACEBEL2003, "6603301"), (Standards.NACEBEL2008, "65122")),
        ((Standards.NACEBEL2003, "67110"), (Standards.NACEBEL2008, "66110")),
        ((Standards.NACEBEL2003, "6711001"), (Standards.NACEBEL2008, "6611001")),
        ((Standards.NACEBEL2003, "67120"), (Standards.NACEBEL2008, "66199")),
        ((Standards.NACEBEL2003, "67120"), (Standards.NACEBEL2008, "66120")),
        ((Standards.NACEBEL2003, "67120"), (Standards.NACEBEL2008, "66300")),
        ((Standards.NACEBEL2003, "6712001"), (Standards.NACEBEL2008, "6619901")),
        ((Standards.NACEBEL2003, "6712002"), (Standards.NACEBEL2008, "6619902")),
        ((Standards.NACEBEL2003, "6712003"), (Standards.NACEBEL2008, "6619903")),
        ((Standards.NACEBEL2003, "67130"), (Standards.NACEBEL2008, "66199")),
        ((Standards.NACEBEL2003, "67130"), (Standards.NACEBEL2008, "66120")),
        ((Standards.NACEBEL2003, "67130"), (Standards.NACEBEL2008, "66191")),
        ((Standards.NACEBEL2003, "6713001"), (Standards.NACEBEL2008, "6619911")),
        ((Standards.NACEBEL2003, "6713002"), (Standards.NACEBEL2008, "6619912")),
        ((Standards.NACEBEL2003, "6713003"), (Standards.NACEBEL2008, "6619913")),
        ((Standards.NACEBEL2003, "6713004"), (Standards.NACEBEL2008, "6619914")),
        ((Standards.NACEBEL2003, "6713005"), (Standards.NACEBEL2008, "6619915")),
        ((Standards.NACEBEL2003, "6713006"), (Standards.NACEBEL2008, "6619916")),
        ((Standards.NACEBEL2003, "6713007"), (Standards.NACEBEL2008, "6619917")),
        ((Standards.NACEBEL2003, "6713008"), (Standards.NACEBEL2008, "6619918")),
        ((Standards.NACEBEL2003, "67201"), (Standards.NACEBEL2008, "66220")),
        ((Standards.NACEBEL2003, "6720101"), (Standards.NACEBEL2008, "6622001")),
        ((Standards.NACEBEL2003, "67202"), (Standards.NACEBEL2008, "66210")),
        ((Standards.NACEBEL2003, "6720201"), (Standards.NACEBEL2008, "6621001")),
        ((Standards.NACEBEL2003, "67203"), (Standards.NACEBEL2008, "66290")),
        ((Standards.NACEBEL2003, "6720301"), (Standards.NACEBEL2008, "6629001")),
        ((Standards.NACEBEL2003, "70111"), (Standards.NACEBEL2008, "41101")),
        ((Standards.NACEBEL2003, "7011101"), (Standards.NACEBEL2008, "4110101")),
        ((Standards.NACEBEL2003, "7011102"), (Standards.NACEBEL2008, "4110102")),
        ((Standards.NACEBEL2003, "70112"), (Standards.NACEBEL2008, "41102")),
        ((Standards.NACEBEL2003, "7011201"), (Standards.NACEBEL2008, "4110201")),
        ((Standards.NACEBEL2003, "70113"), (Standards.NACEBEL2008, "41102")),
        ((Standards.NACEBEL2003, "70113"), (Standards.NACEBEL2008, "42110")),
        ((Standards.NACEBEL2003, "70113"), (Standards.NACEBEL2008, "42120")),
        ((Standards.NACEBEL2003, "70113"), (Standards.NACEBEL2008, "42130")),
        ((Standards.NACEBEL2003, "70113"), (Standards.NACEBEL2008, "42211")),
        ((Standards.NACEBEL2003, "70113"), (Standards.NACEBEL2008, "42212")),
        ((Standards.NACEBEL2003, "70113"), (Standards.NACEBEL2008, "42219")),
        ((Standards.NACEBEL2003, "70113"), (Standards.NACEBEL2008, "42220")),
        ((Standards.NACEBEL2003, "70113"), (Standards.NACEBEL2008, "42911")),
        ((Standards.NACEBEL2003, "70113"), (Standards.NACEBEL2008, "42919")),
        ((Standards.NACEBEL2003, "70113"), (Standards.NACEBEL2008, "42990")),
        ((Standards.NACEBEL2003, "7011301"), (Standards.NACEBEL2008, "4110211")),
        ((Standards.NACEBEL2003, "7011302"), (Standards.NACEBEL2008, "4110212")),
        ((Standards.NACEBEL2003, "7011303"), (Standards.NACEBEL2008, "4299011")),
        ((Standards.NACEBEL2003, "7011304"), (Standards.NACEBEL2008, "4299012")),
        ((Standards.NACEBEL2003, "7011305"), (Standards.NACEBEL2008, "4299013")),
        ((Standards.NACEBEL2003, "70120"), (Standards.NACEBEL2008, "68100")),
        ((Standards.NACEBEL2003, "7012001"), (Standards.NACEBEL2008, "6810001")),
        ((Standards.NACEBEL2003, "7012002"), (Standards.NACEBEL2008, "6810002")),
        ((Standards.NACEBEL2003, "70201"), (Standards.NACEBEL2008, "68201")),
        ((Standards.NACEBEL2003, "7020101"), (Standards.NACEBEL2008, "6820101")),
        ((Standards.NACEBEL2003, "7020102"), (Standards.NACEBEL2008, "6820102")),
        ((Standards.NACEBEL2003, "7020103"), (Standards.NACEBEL2008, "6820103")),
        ((Standards.NACEBEL2003, "70202"), (Standards.NACEBEL2008, "68202")),
        ((Standards.NACEBEL2003, "7020201"), (Standards.NACEBEL2008, "6820201")),
        ((Standards.NACEBEL2003, "70203"), (Standards.NACEBEL2008, "68203")),
        ((Standards.NACEBEL2003, "7020301"), (Standards.NACEBEL2008, "6820301")),
        ((Standards.NACEBEL2003, "7020302"), (Standards.NACEBEL2008, "6820302")),
        ((Standards.NACEBEL2003, "7020303"), (Standards.NACEBEL2008, "6820303")),
        ((Standards.NACEBEL2003, "70204"), (Standards.NACEBEL2008, "68204")),
        ((Standards.NACEBEL2003, "7020401"), (Standards.NACEBEL2008, "6820401")),
        ((Standards.NACEBEL2003, "7020402"), (Standards.NACEBEL2008, "6820402")),
        ((Standards.NACEBEL2003, "70311"), (Standards.NACEBEL2008, "68311")),
        ((Standards.NACEBEL2003, "7031101"), (Standards.NACEBEL2008, "6831101")),
        ((Standards.NACEBEL2003, "70312"), (Standards.NACEBEL2008, "68312")),
        ((Standards.NACEBEL2003, "7031201"), (Standards.NACEBEL2008, "6831201")),
        ((Standards.NACEBEL2003, "70321"), (Standards.NACEBEL2008, "81100")),
        ((Standards.NACEBEL2003, "70321"), (Standards.NACEBEL2008, "68321")),
        ((Standards.NACEBEL2003, "7032101"), (Standards.NACEBEL2008, "6832101")),
        ((Standards.NACEBEL2003, "7032102"), (Standards.NACEBEL2008, "6832102")),
        ((Standards.NACEBEL2003, "70322"), (Standards.NACEBEL2008, "81100")),
        ((Standards.NACEBEL2003, "70322"), (Standards.NACEBEL2008, "68322")),
        ((Standards.NACEBEL2003, "7032201"), (Standards.NACEBEL2008, "6832201")),
        ((Standards.NACEBEL2003, "7032202"), (Standards.NACEBEL2008, "6832202")),
        ((Standards.NACEBEL2003, "71100"), (Standards.NACEBEL2008, "77110")),
        ((Standards.NACEBEL2003, "7110001"), (Standards.NACEBEL2008, "7711001")),
        ((Standards.NACEBEL2003, "7110002"), (Standards.NACEBEL2008, "7711002")),
        ((Standards.NACEBEL2003, "7110003"), (Standards.NACEBEL2008, "7711003")),
        ((Standards.NACEBEL2003, "71210"), (Standards.NACEBEL2008, "77120")),
        ((Standards.NACEBEL2003, "71210"), (Standards.NACEBEL2008, "77393")),
        ((Standards.NACEBEL2003, "71210"), (Standards.NACEBEL2008, "77399")),
        ((Standards.NACEBEL2003, "7121001"), (Standards.NACEBEL2008, "7712001")),
        ((Standards.NACEBEL2003, "71220"), (Standards.NACEBEL2008, "77340")),
        ((Standards.NACEBEL2003, "7122001"), (Standards.NACEBEL2008, "7734001")),
        ((Standards.NACEBEL2003, "71230"), (Standards.NACEBEL2008, "77350")),
        ((Standards.NACEBEL2003, "7123001"), (Standards.NACEBEL2008, "7735001")),
        ((Standards.NACEBEL2003, "71310"), (Standards.NACEBEL2008, "77310")),
        ((Standards.NACEBEL2003, "7131001"), (Standards.NACEBEL2008, "7731001")),
        ((Standards.NACEBEL2003, "7131002"), (Standards.NACEBEL2008, "7731002")),
        ((Standards.NACEBEL2003, "71320"), (Standards.NACEBEL2008, "77320")),
        ((Standards.NACEBEL2003, "71320"), (Standards.NACEBEL2008, "77394")),
        ((Standards.NACEBEL2003, "7132001"), (Standards.NACEBEL2008, "7732001")),
        ((Standards.NACEBEL2003, "7132002"), (Standards.NACEBEL2008, "7732002")),
        ((Standards.NACEBEL2003, "71330"), (Standards.NACEBEL2008, "77330")),
        ((Standards.NACEBEL2003, "7133001"), (Standards.NACEBEL2008, "7733001")),
        ((Standards.NACEBEL2003, "7133002"), (Standards.NACEBEL2008, "7733002")),
        ((Standards.NACEBEL2003, "71340"), (Standards.NACEBEL2008, "77399")),
        ((Standards.NACEBEL2003, "71340"), (Standards.NACEBEL2008, "77391")),
        ((Standards.NACEBEL2003, "71340"), (Standards.NACEBEL2008, "77392")),
        ((Standards.NACEBEL2003, "7134001"), (Standards.NACEBEL2008, "7739901")),
        ((Standards.NACEBEL2003, "7134002"), (Standards.NACEBEL2008, "7739902")),
        ((Standards.NACEBEL2003, "7134003"), (Standards.NACEBEL2008, "7739903")),
        ((Standards.NACEBEL2003, "7134004"), (Standards.NACEBEL2008, "7739904")),
        ((Standards.NACEBEL2003, "7134005"), (Standards.NACEBEL2008, "7739201")),
        ((Standards.NACEBEL2003, "7134006"), (Standards.NACEBEL2008, "7739101")),
        ((Standards.NACEBEL2003, "71401"), (Standards.NACEBEL2008, "77291")),
        ((Standards.NACEBEL2003, "7140101"), (Standards.NACEBEL2008, "7729101")),
        ((Standards.NACEBEL2003, "7140102"), (Standards.NACEBEL2008, "7729102")),
        ((Standards.NACEBEL2003, "71402"), (Standards.NACEBEL2008, "77220")),
        ((Standards.NACEBEL2003, "7140201"), (Standards.NACEBEL2008, "7722001")),
        ((Standards.NACEBEL2003, "7140202"), (Standards.NACEBEL2008, "7722002")),
        ((Standards.NACEBEL2003, "71403"), (Standards.NACEBEL2008, "77292")),
        ((Standards.NACEBEL2003, "7140301"), (Standards.NACEBEL2008, "7729201")),
        ((Standards.NACEBEL2003, "71404"), (Standards.NACEBEL2008, "77293")),
        ((Standards.NACEBEL2003, "7140401"), (Standards.NACEBEL2008, "7729301")),
        ((Standards.NACEBEL2003, "71405"), (Standards.NACEBEL2008, "77294")),
        ((Standards.NACEBEL2003, "7140501"), (Standards.NACEBEL2008, "7729401")),
        ((Standards.NACEBEL2003, "7140502"), (Standards.NACEBEL2008, "7729402")),
        ((Standards.NACEBEL2003, "71406"), (Standards.NACEBEL2008, "77210")),
        ((Standards.NACEBEL2003, "7140601"), (Standards.NACEBEL2008, "7721001")),
        ((Standards.NACEBEL2003, "7140602"), (Standards.NACEBEL2008, "7721002")),
        ((Standards.NACEBEL2003, "7140603"), (Standards.NACEBEL2008, "7721003")),
        ((Standards.NACEBEL2003, "71407"), (Standards.NACEBEL2008, "77295")),
        ((Standards.NACEBEL2003, "7140701"), (Standards.NACEBEL2008, "7729501")),
        ((Standards.NACEBEL2003, "71408"), (Standards.NACEBEL2008, "77299")),
        ((Standards.NACEBEL2003, "71408"), (Standards.NACEBEL2008, "77296")),
        ((Standards.NACEBEL2003, "7140801"), (Standards.NACEBEL2008, "7729901")),
        ((Standards.NACEBEL2003, "7140802"), (Standards.NACEBEL2008, "7729902")),
        ((Standards.NACEBEL2003, "7140803"), (Standards.NACEBEL2008, "7729601")),
        ((Standards.NACEBEL2003, "7140804"), (Standards.NACEBEL2008, "7729903")),
        ((Standards.NACEBEL2003, "7140805"), (Standards.NACEBEL2008, "7729904")),
        ((Standards.NACEBEL2003, "72100"), (Standards.NACEBEL2008, "62020")),
        ((Standards.NACEBEL2003, "7210001"), (Standards.NACEBEL2008, "6202001")),
        ((Standards.NACEBEL2003, "7210002"), (Standards.NACEBEL2008, "6202002")),
        ((Standards.NACEBEL2003, "72200"), (Standards.NACEBEL2008, "62010")),
        ((Standards.NACEBEL2003, "7220001"), (Standards.NACEBEL2008, "62010")),
        ((Standards.NACEBEL2003, "7220002"), (Standards.NACEBEL2008, "62010")),
        ((Standards.NACEBEL2003, "7220003"), (Standards.NACEBEL2008, "62010")),
        ((Standards.NACEBEL2003, "72210"), (Standards.NACEBEL2008, "58290")),
        ((Standards.NACEBEL2003, "72210"), (Standards.NACEBEL2008, "58210")),
        ((Standards.NACEBEL2003, "72220"), (Standards.NACEBEL2008, "62010")),
        ((Standards.NACEBEL2003, "72220"), (Standards.NACEBEL2008, "62020")),
        ((Standards.NACEBEL2003, "72220"), (Standards.NACEBEL2008, "62090")),
        ((Standards.NACEBEL2003, "72300"), (Standards.NACEBEL2008, "63110")),
        ((Standards.NACEBEL2003, "72300"), (Standards.NACEBEL2008, "62030")),
        ((Standards.NACEBEL2003, "7230001"), (Standards.NACEBEL2008, "6311001")),
        ((Standards.NACEBEL2003, "7230002"), (Standards.NACEBEL2008, "6311002")),
        ((Standards.NACEBEL2003, "72400"), (Standards.NACEBEL2008, "63110")),
        ((Standards.NACEBEL2003, "72400"), (Standards.NACEBEL2008, "58110")),
        ((Standards.NACEBEL2003, "72400"), (Standards.NACEBEL2008, "58120")),
        ((Standards.NACEBEL2003, "72400"), (Standards.NACEBEL2008, "58130")),
        ((Standards.NACEBEL2003, "72400"), (Standards.NACEBEL2008, "58140")),
        ((Standards.NACEBEL2003, "72400"), (Standards.NACEBEL2008, "58190")),
        ((Standards.NACEBEL2003, "72400"), (Standards.NACEBEL2008, "58210")),
        ((Standards.NACEBEL2003, "72400"), (Standards.NACEBEL2008, "58290")),
        ((Standards.NACEBEL2003, "72400"), (Standards.NACEBEL2008, "59203")),
        ((Standards.NACEBEL2003, "72400"), (Standards.NACEBEL2008, "60100")),
        ((Standards.NACEBEL2003, "72400"), (Standards.NACEBEL2008, "60200")),
        ((Standards.NACEBEL2003, "72400"), (Standards.NACEBEL2008, "62010")),
        ((Standards.NACEBEL2003, "72400"), (Standards.NACEBEL2008, "63120")),
        ((Standards.NACEBEL2003, "7240001"), (Standards.NACEBEL2008, "6311011")),
        ((Standards.NACEBEL2003, "7240002"), (Standards.NACEBEL2008, "6311012")),
        ((Standards.NACEBEL2003, "7240003"), (Standards.NACEBEL2008, "6311013")),
        ((Standards.NACEBEL2003, "72500"), (Standards.NACEBEL2008, "95110")),
        ((Standards.NACEBEL2003, "72500"), (Standards.NACEBEL2008, "33120")),
        ((Standards.NACEBEL2003, "7250001"), (Standards.NACEBEL2008, "9511001")),
        ((Standards.NACEBEL2003, "7250002"), (Standards.NACEBEL2008, "9511002")),
        ((Standards.NACEBEL2003, "72600"), (Standards.NACEBEL2008, "62090")),
        ((Standards.NACEBEL2003, "7260001"), (Standards.NACEBEL2008, "62090")),
        ((Standards.NACEBEL2003, "73100"), (Standards.NACEBEL2008, "72190")),
        ((Standards.NACEBEL2003, "73100"), (Standards.NACEBEL2008, "72110")),
        ((Standards.NACEBEL2003, "73100"), (Standards.NACEBEL2008, "72200")),
        ((Standards.NACEBEL2003, "7310001"), (Standards.NACEBEL2008, "7219001")),
        ((Standards.NACEBEL2003, "73200"), (Standards.NACEBEL2008, "72200")),
        ((Standards.NACEBEL2003, "7320001"), (Standards.NACEBEL2008, "7220001")),
        ((Standards.NACEBEL2003, "74111"), (Standards.NACEBEL2008, "69101")),
        ((Standards.NACEBEL2003, "74111"), (Standards.NACEBEL2008, "69109")),
        ((Standards.NACEBEL2003, "7411101"), (Standards.NACEBEL2008, "69101")),
        ((Standards.NACEBEL2003, "74112"), (Standards.NACEBEL2008, "69102")),
        ((Standards.NACEBEL2003, "7411201"), (Standards.NACEBEL2008, "69102")),
        ((Standards.NACEBEL2003, "74113"), (Standards.NACEBEL2008, "69103")),
        ((Standards.NACEBEL2003, "7411301"), (Standards.NACEBEL2008, "69103")),
        ((Standards.NACEBEL2003, "74114"), (Standards.NACEBEL2008, "69109")),
        ((Standards.NACEBEL2003, "7411401"), (Standards.NACEBEL2008, "6910901")),
        ((Standards.NACEBEL2003, "74121"), (Standards.NACEBEL2008, "69202")),
        ((Standards.NACEBEL2003, "7412101"), (Standards.NACEBEL2008, "6920201")),
        ((Standards.NACEBEL2003, "7412102"), (Standards.NACEBEL2008, "6920202")),
        ((Standards.NACEBEL2003, "7412103"), (Standards.NACEBEL2008, "6920203")),
        ((Standards.NACEBEL2003, "74122"), (Standards.NACEBEL2008, "69201")),
        ((Standards.NACEBEL2003, "7412201"), (Standards.NACEBEL2008, "69201")),
        ((Standards.NACEBEL2003, "74123"), (Standards.NACEBEL2008, "69203")),
        ((Standards.NACEBEL2003, "7412301"), (Standards.NACEBEL2008, "69203")),
        ((Standards.NACEBEL2003, "74124"), (Standards.NACEBEL2008, "69201")),
        ((Standards.NACEBEL2003, "7412401"), (Standards.NACEBEL2008, "6920101")),
        ((Standards.NACEBEL2003, "7412402"), (Standards.NACEBEL2008, "6920102")),
        ((Standards.NACEBEL2003, "74131"), (Standards.NACEBEL2008, "73200")),
        ((Standards.NACEBEL2003, "7413101"), (Standards.NACEBEL2008, "7320001")),
        ((Standards.NACEBEL2003, "7413102"), (Standards.NACEBEL2008, "7320002")),
        ((Standards.NACEBEL2003, "74132"), (Standards.NACEBEL2008, "73200")),
        ((Standards.NACEBEL2003, "7413201"), (Standards.NACEBEL2008, "7320011")),
        ((Standards.NACEBEL2003, "74141"), (Standards.NACEBEL2008, "70210")),
        ((Standards.NACEBEL2003, "7414101"), (Standards.NACEBEL2008, "7021001")),
        ((Standards.NACEBEL2003, "7414102"), (Standards.NACEBEL2008, "7021002")),
        ((Standards.NACEBEL2003, "74142"), (Standards.NACEBEL2008, "70220")),
        ((Standards.NACEBEL2003, "74142"), (Standards.NACEBEL2008, "02400")),
        ((Standards.NACEBEL2003, "74142"), (Standards.NACEBEL2008, "74901")),
        ((Standards.NACEBEL2003, "7414201"), (Standards.NACEBEL2008, "7022001")),
        ((Standards.NACEBEL2003, "7414202"), (Standards.NACEBEL2008, "7022002")),
        ((Standards.NACEBEL2003, "7414203"), (Standards.NACEBEL2008, "7022003")),
        ((Standards.NACEBEL2003, "7414204"), (Standards.NACEBEL2008, "7022004")),
        ((Standards.NACEBEL2003, "74151"), (Standards.NACEBEL2008, "64200")),
        ((Standards.NACEBEL2003, "74151"), (Standards.NACEBEL2008, "70100")),
        ((Standards.NACEBEL2003, "7415101"), (Standards.NACEBEL2008, "6420011")),
        ((Standards.NACEBEL2003, "7415102"), (Standards.NACEBEL2008, "6420012")),
        ((Standards.NACEBEL2003, "74152"), (Standards.NACEBEL2008, "70100")),
        ((Standards.NACEBEL2003, "7415201"), (Standards.NACEBEL2008, "70100")),
        ((Standards.NACEBEL2003, "74201"), (Standards.NACEBEL2008, "71111")),
        ((Standards.NACEBEL2003, "74201"), (Standards.NACEBEL2008, "71113")),
        ((Standards.NACEBEL2003, "7420101"), (Standards.NACEBEL2008, "7111101")),
        ((Standards.NACEBEL2003, "7420102"), (Standards.NACEBEL2008, "7111102")),
        ((Standards.NACEBEL2003, "7420103"), (Standards.NACEBEL2008, "7111103")),
        ((Standards.NACEBEL2003, "7420104"), (Standards.NACEBEL2008, "7111301")),
        ((Standards.NACEBEL2003, "7420105"), (Standards.NACEBEL2008, "7111302")),
        ((Standards.NACEBEL2003, "7420106"), (Standards.NACEBEL2008, "7111104")),
        ((Standards.NACEBEL2003, "74202"), (Standards.NACEBEL2008, "71122")),
        ((Standards.NACEBEL2003, "7420201"), (Standards.NACEBEL2008, "7112201")),
        ((Standards.NACEBEL2003, "7420202"), (Standards.NACEBEL2008, "7112202")),
        ((Standards.NACEBEL2003, "7420203"), (Standards.NACEBEL2008, "7112203")),
        ((Standards.NACEBEL2003, "7420204"), (Standards.NACEBEL2008, "7112204")),
        ((Standards.NACEBEL2003, "74203"), (Standards.NACEBEL2008, "71121")),
        ((Standards.NACEBEL2003, "74203"), (Standards.NACEBEL2008, "74102")),
        ((Standards.NACEBEL2003, "74203"), (Standards.NACEBEL2008, "74909")),
        ((Standards.NACEBEL2003, "7420301"), (Standards.NACEBEL2008, "7112101")),
        ((Standards.NACEBEL2003, "7420302"), (Standards.NACEBEL2008, "7112102")),
        ((Standards.NACEBEL2003, "7420303"), (Standards.NACEBEL2008, "7112103")),
        ((Standards.NACEBEL2003, "7420304"), (Standards.NACEBEL2008, "7112104")),
        ((Standards.NACEBEL2003, "7420305"), (Standards.NACEBEL2008, "7112105")),
        ((Standards.NACEBEL2003, "7420306"), (Standards.NACEBEL2008, "7112106")),
        ((Standards.NACEBEL2003, "7420307"), (Standards.NACEBEL2008, "7112107")),
        ((Standards.NACEBEL2003, "74301"), (Standards.NACEBEL2008, "71201")),
        ((Standards.NACEBEL2003, "7430101"), (Standards.NACEBEL2008, "71201")),
        ((Standards.NACEBEL2003, "74302"), (Standards.NACEBEL2008, "71209")),
        ((Standards.NACEBEL2003, "7430201"), (Standards.NACEBEL2008, "7120901")),
        ((Standards.NACEBEL2003, "7430202"), (Standards.NACEBEL2008, "7120902")),
        ((Standards.NACEBEL2003, "7430203"), (Standards.NACEBEL2008, "7120903")),
        ((Standards.NACEBEL2003, "7430204"), (Standards.NACEBEL2008, "7120904")),
        ((Standards.NACEBEL2003, "7430205"), (Standards.NACEBEL2008, "7120905")),
        ((Standards.NACEBEL2003, "7430206"), (Standards.NACEBEL2008, "7120906")),
        ((Standards.NACEBEL2003, "74401"), (Standards.NACEBEL2008, "73110")),
        ((Standards.NACEBEL2003, "7440101"), (Standards.NACEBEL2008, "7311001")),
        ((Standards.NACEBEL2003, "7440102"), (Standards.NACEBEL2008, "7311002")),
        ((Standards.NACEBEL2003, "7440103"), (Standards.NACEBEL2008, "7311003")),
        ((Standards.NACEBEL2003, "7440104"), (Standards.NACEBEL2008, "7311004")),
        ((Standards.NACEBEL2003, "7440105"), (Standards.NACEBEL2008, "7311005")),
        ((Standards.NACEBEL2003, "7440106"), (Standards.NACEBEL2008, "7311006")),
        ((Standards.NACEBEL2003, "7440107"), (Standards.NACEBEL2008, "7311007")),
        ((Standards.NACEBEL2003, "74402"), (Standards.NACEBEL2008, "73120")),
        ((Standards.NACEBEL2003, "7440201"), (Standards.NACEBEL2008, "7312001")),
        ((Standards.NACEBEL2003, "7440202"), (Standards.NACEBEL2008, "7312002")),
        ((Standards.NACEBEL2003, "7440203"), (Standards.NACEBEL2008, "7311011")),
        ((Standards.NACEBEL2003, "74403"), (Standards.NACEBEL2008, "74105")),
        ((Standards.NACEBEL2003, "74403"), (Standards.NACEBEL2008, "73110")),
        ((Standards.NACEBEL2003, "7440301"), (Standards.NACEBEL2008, "7410501")),
        ((Standards.NACEBEL2003, "7440302"), (Standards.NACEBEL2008, "7410502")),
        ((Standards.NACEBEL2003, "74501"), (Standards.NACEBEL2008, "78100")),
        ((Standards.NACEBEL2003, "7450101"), (Standards.NACEBEL2008, "7810001")),
        ((Standards.NACEBEL2003, "7450102"), (Standards.NACEBEL2008, "7810002")),
        ((Standards.NACEBEL2003, "7450103"), (Standards.NACEBEL2008, "7810003")),
        ((Standards.NACEBEL2003, "7450104"), (Standards.NACEBEL2008, "7810004")),
        ((Standards.NACEBEL2003, "7450105"), (Standards.NACEBEL2008, "78100")),
        ((Standards.NACEBEL2003, "74502"), (Standards.NACEBEL2008, "78200")),
        ((Standards.NACEBEL2003, "74502"), (Standards.NACEBEL2008, "78300")),
        ((Standards.NACEBEL2003, "7450201"), (Standards.NACEBEL2008, "78200")),
        ((Standards.NACEBEL2003, "74503"), (Standards.NACEBEL2008, "78100")),
        ((Standards.NACEBEL2003, "7450301"), (Standards.NACEBEL2008, "7810011")),
        ((Standards.NACEBEL2003, "74601"), (Standards.NACEBEL2008, "74909")),
        ((Standards.NACEBEL2003, "74601"), (Standards.NACEBEL2008, "80100")),
        ((Standards.NACEBEL2003, "74601"), (Standards.NACEBEL2008, "80200")),
        ((Standards.NACEBEL2003, "7460101"), (Standards.NACEBEL2008, "8010001")),
        ((Standards.NACEBEL2003, "7460102"), (Standards.NACEBEL2008, "7490901")),
        ((Standards.NACEBEL2003, "7460103"), (Standards.NACEBEL2008, "8010002")),
        ((Standards.NACEBEL2003, "7460104"), (Standards.NACEBEL2008, "8010003")),
        ((Standards.NACEBEL2003, "74602"), (Standards.NACEBEL2008, "80300")),
        ((Standards.NACEBEL2003, "7460201"), (Standards.NACEBEL2008, "8030001")),
        ((Standards.NACEBEL2003, "7460202"), (Standards.NACEBEL2008, "8030002")),
        ((Standards.NACEBEL2003, "74700"), (Standards.NACEBEL2008, "81220")),
        ((Standards.NACEBEL2003, "74700"), (Standards.NACEBEL2008, "81210")),
        ((Standards.NACEBEL2003, "74700"), (Standards.NACEBEL2008, "81290")),
        ((Standards.NACEBEL2003, "7470001"), (Standards.NACEBEL2008, "8122001")),
        ((Standards.NACEBEL2003, "7470002"), (Standards.NACEBEL2008, "8122002")),
        ((Standards.NACEBEL2003, "7470003"), (Standards.NACEBEL2008, "8122003")),
        ((Standards.NACEBEL2003, "7470004"), (Standards.NACEBEL2008, "8129001")),
        ((Standards.NACEBEL2003, "7470005"), (Standards.NACEBEL2008, "8129002")),
        ((Standards.NACEBEL2003, "74811"), (Standards.NACEBEL2008, "74201")),
        ((Standards.NACEBEL2003, "7481101"), (Standards.NACEBEL2008, "7420101")),
        ((Standards.NACEBEL2003, "7481102"), (Standards.NACEBEL2008, "9609921")),
        ((Standards.NACEBEL2003, "7481103"), (Standards.NACEBEL2008, "7420102")),
        ((Standards.NACEBEL2003, "74812"), (Standards.NACEBEL2008, "74209")),
        ((Standards.NACEBEL2003, "7481201"), (Standards.NACEBEL2008, "7420901")),
        ((Standards.NACEBEL2003, "74820"), (Standards.NACEBEL2008, "82920")),
        ((Standards.NACEBEL2003, "7482001"), (Standards.NACEBEL2008, "8292001")),
        ((Standards.NACEBEL2003, "7482002"), (Standards.NACEBEL2008, "8292002")),
        ((Standards.NACEBEL2003, "7482003"), (Standards.NACEBEL2008, "8292003")),
        ((Standards.NACEBEL2003, "74831"), (Standards.NACEBEL2008, "82190")),
        ((Standards.NACEBEL2003, "7483101"), (Standards.NACEBEL2008, "82190")),
        ((Standards.NACEBEL2003, "7483102"), (Standards.NACEBEL2008, "82190")),
        ((Standards.NACEBEL2003, "7483103"), (Standards.NACEBEL2008, "82190")),
        ((Standards.NACEBEL2003, "7483104"), (Standards.NACEBEL2008, "82200")),
        ((Standards.NACEBEL2003, "7483105"), (Standards.NACEBEL2008, "82190")),
        ((Standards.NACEBEL2003, "74832"), (Standards.NACEBEL2008, "74300")),
        ((Standards.NACEBEL2003, "7483201"), (Standards.NACEBEL2008, "74300")),
        ((Standards.NACEBEL2003, "74833"), (Standards.NACEBEL2008, "82110")),
        ((Standards.NACEBEL2003, "7483301"), (Standards.NACEBEL2008, "82110")),
        ((Standards.NACEBEL2003, "7483302"), (Standards.NACEBEL2008, "82110")),
        ((Standards.NACEBEL2003, "7483303"), (Standards.NACEBEL2008, "82110")),
        ((Standards.NACEBEL2003, "74834"), (Standards.NACEBEL2008, "82110")),
        ((Standards.NACEBEL2003, "7483401"), (Standards.NACEBEL2008, "82110")),
        ((Standards.NACEBEL2003, "7483402"), (Standards.NACEBEL2008, "82110")),
        ((Standards.NACEBEL2003, "7483403"), (Standards.NACEBEL2008, "82110")),
        ((Standards.NACEBEL2003, "74835"), (Standards.NACEBEL2008, "82110")),
        ((Standards.NACEBEL2003, "7483501"), (Standards.NACEBEL2008, "82110")),
        ((Standards.NACEBEL2003, "7483502"), (Standards.NACEBEL2008, "82110")),
        ((Standards.NACEBEL2003, "7483503"), (Standards.NACEBEL2008, "82110")),
        ((Standards.NACEBEL2003, "74841"), (Standards.NACEBEL2008, "82300")),
        ((Standards.NACEBEL2003, "7484101"), (Standards.NACEBEL2008, "46170")),
        ((Standards.NACEBEL2003, "7484102"), (Standards.NACEBEL2008, "82300")),
        ((Standards.NACEBEL2003, "7484103"), (Standards.NACEBEL2008, "82300")),
        ((Standards.NACEBEL2003, "74842"), (Standards.NACEBEL2008, "82300")),
        ((Standards.NACEBEL2003, "7484201"), (Standards.NACEBEL2008, "82300")),
        ((Standards.NACEBEL2003, "7484202"), (Standards.NACEBEL2008, "82300")),
        ((Standards.NACEBEL2003, "7484203"), (Standards.NACEBEL2008, "82300")),
        ((Standards.NACEBEL2003, "7484204"), (Standards.NACEBEL2008, "82300")),
        ((Standards.NACEBEL2003, "7484205"), (Standards.NACEBEL2008, "74109")),
        ((Standards.NACEBEL2003, "74843"), (Standards.NACEBEL2008, "82910")),
        ((Standards.NACEBEL2003, "7484301"), (Standards.NACEBEL2008, "82910")),
        ((Standards.NACEBEL2003, "7484302"), (Standards.NACEBEL2008, "82910")),
        ((Standards.NACEBEL2003, "74844"), (Standards.NACEBEL2008, "71112")),
        ((Standards.NACEBEL2003, "7484401"), (Standards.NACEBEL2008, "71112")),
        ((Standards.NACEBEL2003, "74845"), (Standards.NACEBEL2008, "82990")),
        ((Standards.NACEBEL2003, "7484501"), (Standards.NACEBEL2008, "82990")),
        ((Standards.NACEBEL2003, "74846"), (Standards.NACEBEL2008, "82990")),
        ((Standards.NACEBEL2003, "7484601"), (Standards.NACEBEL2008, "82990")),
        ((Standards.NACEBEL2003, "74847"), (Standards.NACEBEL2008, "74101")),
        ((Standards.NACEBEL2003, "7484701"), (Standards.NACEBEL2008, "74101")),
        ((Standards.NACEBEL2003, "7484702"), (Standards.NACEBEL2008, "74101")),
        ((Standards.NACEBEL2003, "74848"), (Standards.NACEBEL2008, "74901")),
        ((Standards.NACEBEL2003, "7484801"), (Standards.NACEBEL2008, "74901")),
        ((Standards.NACEBEL2003, "74849"), (Standards.NACEBEL2008, "82990")),
        ((Standards.NACEBEL2003, "7484901"), (Standards.NACEBEL2008, "74909")),
        ((Standards.NACEBEL2003, "7484902"), (Standards.NACEBEL2008, "82990")),
        ((Standards.NACEBEL2003, "7484903"), (Standards.NACEBEL2008, "82990")),
        ((Standards.NACEBEL2003, "7484904"), (Standards.NACEBEL2008, "74909")),
        ((Standards.NACEBEL2003, "7484905"), (Standards.NACEBEL2008, "82200")),
        ((Standards.NACEBEL2003, "7484906"), (Standards.NACEBEL2008, "82990")),
        ((Standards.NACEBEL2003, "74851"), (Standards.NACEBEL2008, "82190")),
        ((Standards.NACEBEL2003, "74851"), (Standards.NACEBEL2008, "82990")),
        ((Standards.NACEBEL2003, "74852"), (Standards.NACEBEL2008, "74300")),
        ((Standards.NACEBEL2003, "74853"), (Standards.NACEBEL2008, "82110")),
        ((Standards.NACEBEL2003, "74854"), (Standards.NACEBEL2008, "82110")),
        ((Standards.NACEBEL2003, "74855"), (Standards.NACEBEL2008, "82110")),
        ((Standards.NACEBEL2003, "74855"), (Standards.NACEBEL2008, "82190")),
        ((Standards.NACEBEL2003, "74855"), (Standards.NACEBEL2008, "82990")),
        ((Standards.NACEBEL2003, "74860"), (Standards.NACEBEL2008, "82200")),
        ((Standards.NACEBEL2003, "74871"), (Standards.NACEBEL2008, "82300")),
        ((Standards.NACEBEL2003, "74871"), (Standards.NACEBEL2008, "82990")),
        ((Standards.NACEBEL2003, "74872"), (Standards.NACEBEL2008, "82300")),
        ((Standards.NACEBEL2003, "74872"), (Standards.NACEBEL2008, "74109")),
        ((Standards.NACEBEL2003, "74873"), (Standards.NACEBEL2008, "82910")),
        ((Standards.NACEBEL2003, "74874"), (Standards.NACEBEL2008, "71112")),
        ((Standards.NACEBEL2003, "74875"), (Standards.NACEBEL2008, "82990")),
        ((Standards.NACEBEL2003, "74876"), (Standards.NACEBEL2008, "82990")),
        ((Standards.NACEBEL2003, "74877"), (Standards.NACEBEL2008, "74101")),
        ((Standards.NACEBEL2003, "74877"), (Standards.NACEBEL2008, "74103")),
        ((Standards.NACEBEL2003, "74877"), (Standards.NACEBEL2008, "74104")),
        ((Standards.NACEBEL2003, "74877"), (Standards.NACEBEL2008, "74109")),
        ((Standards.NACEBEL2003, "74878"), (Standards.NACEBEL2008, "74901")),
        ((Standards.NACEBEL2003, "74878"), (Standards.NACEBEL2008, "78100")),
        ((Standards.NACEBEL2003, "74879"), (Standards.NACEBEL2008, "82990")),
        ((Standards.NACEBEL2003, "74879"), (Standards.NACEBEL2008, "59209")),
        ((Standards.NACEBEL2003, "74879"), (Standards.NACEBEL2008, "63990")),
        ((Standards.NACEBEL2003, "74879"), (Standards.NACEBEL2008, "74909")),
        ((Standards.NACEBEL2003, "74879"), (Standards.NACEBEL2008, "77400")),
        ((Standards.NACEBEL2003, "75111"), (Standards.NACEBEL2008, "84111")),
        ((Standards.NACEBEL2003, "75112"), (Standards.NACEBEL2008, "84112")),
        ((Standards.NACEBEL2003, "75113"), (Standards.NACEBEL2008, "84113")),
        ((Standards.NACEBEL2003, "75114"), (Standards.NACEBEL2008, "84114")),
        ((Standards.NACEBEL2003, "75115"), (Standards.NACEBEL2008, "84115")),
        ((Standards.NACEBEL2003, "75116"), (Standards.NACEBEL2008, "84119")),
        ((Standards.NACEBEL2003, "75120"), (Standards.NACEBEL2008, "84120")),
        ((Standards.NACEBEL2003, "75130"), (Standards.NACEBEL2008, "84130")),
        ((Standards.NACEBEL2003, "75140"), (Standards.NACEBEL2008, "84119")),
        ((Standards.NACEBEL2003, "75140"), (Standards.NACEBEL2008, "81100")),
        ((Standards.NACEBEL2003, "75140"), (Standards.NACEBEL2008, "91012")),
        ((Standards.NACEBEL2003, "75210"), (Standards.NACEBEL2008, "84210")),
        ((Standards.NACEBEL2003, "75210"), (Standards.NACEBEL2008, "88999")),
        ((Standards.NACEBEL2003, "75220"), (Standards.NACEBEL2008, "84220")),
        ((Standards.NACEBEL2003, "75231"), (Standards.NACEBEL2008, "84231")),
        ((Standards.NACEBEL2003, "75232"), (Standards.NACEBEL2008, "84232")),
        ((Standards.NACEBEL2003, "75233"), (Standards.NACEBEL2008, "84239")),
        ((Standards.NACEBEL2003, "75241"), (Standards.NACEBEL2008, "84249")),
        ((Standards.NACEBEL2003, "75242"), (Standards.NACEBEL2008, "84241")),
        ((Standards.NACEBEL2003, "75243"), (Standards.NACEBEL2008, "84242")),
        ((Standards.NACEBEL2003, "75244"), (Standards.NACEBEL2008, "84241")),
        ((Standards.NACEBEL2003, "75245"), (Standards.NACEBEL2008, "84242")),
        ((Standards.NACEBEL2003, "75250"), (Standards.NACEBEL2008, "84250")),
        ((Standards.NACEBEL2003, "75250"), (Standards.NACEBEL2008, "84249")),
        ((Standards.NACEBEL2003, "75301"), (Standards.NACEBEL2008, "84301")),
        ((Standards.NACEBEL2003, "75302"), (Standards.NACEBEL2008, "84302")),
        ((Standards.NACEBEL2003, "75303"), (Standards.NACEBEL2008, "84309")),
        ((Standards.NACEBEL2003, "80101"), (Standards.NACEBEL2008, "85201")),
        ((Standards.NACEBEL2003, "80101"), (Standards.NACEBEL2008, "85101")),
        ((Standards.NACEBEL2003, "80101"), (Standards.NACEBEL2008, "85105")),
        ((Standards.NACEBEL2003, "80101"), (Standards.NACEBEL2008, "85205")),
        ((Standards.NACEBEL2003, "80102"), (Standards.NACEBEL2008, "85202")),
        ((Standards.NACEBEL2003, "80102"), (Standards.NACEBEL2008, "85102")),
        ((Standards.NACEBEL2003, "80102"), (Standards.NACEBEL2008, "85105")),
        ((Standards.NACEBEL2003, "80102"), (Standards.NACEBEL2008, "85205")),
        ((Standards.NACEBEL2003, "80103"), (Standards.NACEBEL2008, "85203")),
        ((Standards.NACEBEL2003, "80103"), (Standards.NACEBEL2008, "85103")),
        ((Standards.NACEBEL2003, "80103"), (Standards.NACEBEL2008, "85105")),
        ((Standards.NACEBEL2003, "80103"), (Standards.NACEBEL2008, "85205")),
        ((Standards.NACEBEL2003, "80104"), (Standards.NACEBEL2008, "85204")),
        ((Standards.NACEBEL2003, "80104"), (Standards.NACEBEL2008, "85104")),
        ((Standards.NACEBEL2003, "80104"), (Standards.NACEBEL2008, "85106")),
        ((Standards.NACEBEL2003, "80104"), (Standards.NACEBEL2008, "85206")),
        ((Standards.NACEBEL2003, "80105"), (Standards.NACEBEL2008, "85209")),
        ((Standards.NACEBEL2003, "80105"), (Standards.NACEBEL2008, "85109")),
        ((Standards.NACEBEL2003, "80109"), (Standards.NACEBEL2008, "85209")),
        ((Standards.NACEBEL2003, "80109"), (Standards.NACEBEL2008, "85109")),
        ((Standards.NACEBEL2003, "80211"), (Standards.NACEBEL2008, "85311")),
        ((Standards.NACEBEL2003, "80211"), (Standards.NACEBEL2008, "85325")),
        ((Standards.NACEBEL2003, "80212"), (Standards.NACEBEL2008, "85312")),
        ((Standards.NACEBEL2003, "80212"), (Standards.NACEBEL2008, "85325")),
        ((Standards.NACEBEL2003, "80213"), (Standards.NACEBEL2008, "85313")),
        ((Standards.NACEBEL2003, "80213"), (Standards.NACEBEL2008, "85325")),
        ((Standards.NACEBEL2003, "80214"), (Standards.NACEBEL2008, "85314")),
        ((Standards.NACEBEL2003, "80214"), (Standards.NACEBEL2008, "85326")),
        ((Standards.NACEBEL2003, "80215"), (Standards.NACEBEL2008, "85319")),
        ((Standards.NACEBEL2003, "80216"), (Standards.NACEBEL2008, "85319")),
        ((Standards.NACEBEL2003, "80219"), (Standards.NACEBEL2008, "85319")),
        ((Standards.NACEBEL2003, "80221"), (Standards.NACEBEL2008, "85321")),
        ((Standards.NACEBEL2003, "80221"), (Standards.NACEBEL2008, "85325")),
        ((Standards.NACEBEL2003, "80222"), (Standards.NACEBEL2008, "85322")),
        ((Standards.NACEBEL2003, "80222"), (Standards.NACEBEL2008, "85325")),
        ((Standards.NACEBEL2003, "80223"), (Standards.NACEBEL2008, "85323")),
        ((Standards.NACEBEL2003, "80223"), (Standards.NACEBEL2008, "85325")),
        ((Standards.NACEBEL2003, "80224"), (Standards.NACEBEL2008, "85324")),
        ((Standards.NACEBEL2003, "80224"), (Standards.NACEBEL2008, "85326")),
        ((Standards.NACEBEL2003, "80225"), (Standards.NACEBEL2008, "85329")),
        ((Standards.NACEBEL2003, "80226"), (Standards.NACEBEL2008, "85329")),
        ((Standards.NACEBEL2003, "80301"), (Standards.NACEBEL2008, "85421")),
        ((Standards.NACEBEL2003, "80301"), (Standards.NACEBEL2008, "85410")),
        ((Standards.NACEBEL2003, "80302"), (Standards.NACEBEL2008, "85421")),
        ((Standards.NACEBEL2003, "80302"), (Standards.NACEBEL2008, "85410")),
        ((Standards.NACEBEL2003, "80303"), (Standards.NACEBEL2008, "85421")),
        ((Standards.NACEBEL2003, "80303"), (Standards.NACEBEL2008, "85410")),
        ((Standards.NACEBEL2003, "80304"), (Standards.NACEBEL2008, "85422")),
        ((Standards.NACEBEL2003, "80304"), (Standards.NACEBEL2008, "85410")),
        ((Standards.NACEBEL2003, "80305"), (Standards.NACEBEL2008, "85429")),
        ((Standards.NACEBEL2003, "80305"), (Standards.NACEBEL2008, "85410")),
        ((Standards.NACEBEL2003, "80306"), (Standards.NACEBEL2008, "85429")),
        ((Standards.NACEBEL2003, "80306"), (Standards.NACEBEL2008, "85410")),
        ((Standards.NACEBEL2003, "80309"), (Standards.NACEBEL2008, "85429")),
        ((Standards.NACEBEL2003, "80309"), (Standards.NACEBEL2008, "85410")),
        ((Standards.NACEBEL2003, "80411"), (Standards.NACEBEL2008, "85531")),
        ((Standards.NACEBEL2003, "80411"), (Standards.NACEBEL2008, "85329")),
        ((Standards.NACEBEL2003, "8041101"), (Standards.NACEBEL2008, "8553101")),
        ((Standards.NACEBEL2003, "8041102"), (Standards.NACEBEL2008, "8553102")),
        ((Standards.NACEBEL2003, "80412"), (Standards.NACEBEL2008, "85532")),
        ((Standards.NACEBEL2003, "8041201"), (Standards.NACEBEL2008, "8553201")),
        ((Standards.NACEBEL2003, "8041202"), (Standards.NACEBEL2008, "8553202")),
        ((Standards.NACEBEL2003, "80421"), (Standards.NACEBEL2008, "85592")),
        ((Standards.NACEBEL2003, "80421"), (Standards.NACEBEL2008, "85207")),
        ((Standards.NACEBEL2003, "80421"), (Standards.NACEBEL2008, "85591")),
        ((Standards.NACEBEL2003, "80422"), (Standards.NACEBEL2008, "85520")),
        ((Standards.NACEBEL2003, "80423"), (Standards.NACEBEL2008, "85591")),
        ((Standards.NACEBEL2003, "80423"), (Standards.NACEBEL2008, "85599")),
        ((Standards.NACEBEL2003, "80424"), (Standards.NACEBEL2008, "85599")),
        ((Standards.NACEBEL2003, "80424"), (Standards.NACEBEL2008, "85591")),
        ((Standards.NACEBEL2003, "80424"), (Standards.NACEBEL2008, "85593")),
        ((Standards.NACEBEL2003, "80424"), (Standards.NACEBEL2008, "85609")),
        ((Standards.NACEBEL2003, "85110"), (Standards.NACEBEL2008, "86101")),
        ((Standards.NACEBEL2003, "85110"), (Standards.NACEBEL2008, "86102")),
        ((Standards.NACEBEL2003, "85110"), (Standards.NACEBEL2008, "86103")),
        ((Standards.NACEBEL2003, "85110"), (Standards.NACEBEL2008, "86104")),
        ((Standards.NACEBEL2003, "85110"), (Standards.NACEBEL2008, "86109")),
        ((Standards.NACEBEL2003, "85120"), (Standards.NACEBEL2008, "86220")),
        ((Standards.NACEBEL2003, "85120"), (Standards.NACEBEL2008, "86210")),
        ((Standards.NACEBEL2003, "85120"), (Standards.NACEBEL2008, "86230")),
        ((Standards.NACEBEL2003, "85130"), (Standards.NACEBEL2008, "86230")),
        ((Standards.NACEBEL2003, "85141"), (Standards.NACEBEL2008, "86901")),
        ((Standards.NACEBEL2003, "85142"), (Standards.NACEBEL2008, "86903")),
        ((Standards.NACEBEL2003, "85143"), (Standards.NACEBEL2008, "86909")),
        ((Standards.NACEBEL2003, "85143"), (Standards.NACEBEL2008, "86904")),
        ((Standards.NACEBEL2003, "85143"), (Standards.NACEBEL2008, "86905")),
        ((Standards.NACEBEL2003, "85143"), (Standards.NACEBEL2008, "86906")),
        ((Standards.NACEBEL2003, "85143"), (Standards.NACEBEL2008, "86907")),
        ((Standards.NACEBEL2003, "85144"), (Standards.NACEBEL2008, "86905")),
        ((Standards.NACEBEL2003, "85145"), (Standards.NACEBEL2008, "86902")),
        ((Standards.NACEBEL2003, "85146"), (Standards.NACEBEL2008, "86909")),
        ((Standards.NACEBEL2003, "85200"), (Standards.NACEBEL2008, "75000")),
        ((Standards.NACEBEL2003, "85311"), (Standards.NACEBEL2008, "87201")),
        ((Standards.NACEBEL2003, "85311"), (Standards.NACEBEL2008, "87209")),
        ((Standards.NACEBEL2003, "85311"), (Standards.NACEBEL2008, "87303")),
        ((Standards.NACEBEL2003, "85311"), (Standards.NACEBEL2008, "87309")),
        ((Standards.NACEBEL2003, "85312"), (Standards.NACEBEL2008, "87901")),
        ((Standards.NACEBEL2003, "85313"), (Standards.NACEBEL2008, "87901")),
        ((Standards.NACEBEL2003, "85314"), (Standards.NACEBEL2008, "87202")),
        ((Standards.NACEBEL2003, "85314"), (Standards.NACEBEL2008, "87209")),
        ((Standards.NACEBEL2003, "85314"), (Standards.NACEBEL2008, "87304")),
        ((Standards.NACEBEL2003, "85314"), (Standards.NACEBEL2008, "87309")),
        ((Standards.NACEBEL2003, "85315"), (Standards.NACEBEL2008, "87301")),
        ((Standards.NACEBEL2003, "85315"), (Standards.NACEBEL2008, "87101")),
        ((Standards.NACEBEL2003, "85315"), (Standards.NACEBEL2008, "87302")),
        ((Standards.NACEBEL2003, "8531501"), (Standards.NACEBEL2008, "87301")),
        ((Standards.NACEBEL2003, "85316"), (Standards.NACEBEL2008, "87909")),
        ((Standards.NACEBEL2003, "85316"), (Standards.NACEBEL2008, "87109")),
        ((Standards.NACEBEL2003, "85316"), (Standards.NACEBEL2008, "87203")),
        ((Standards.NACEBEL2003, "85316"), (Standards.NACEBEL2008, "87204")),
        ((Standards.NACEBEL2003, "85316"), (Standards.NACEBEL2008, "87205")),
        ((Standards.NACEBEL2003, "85316"), (Standards.NACEBEL2008, "87209")),
        ((Standards.NACEBEL2003, "85316"), (Standards.NACEBEL2008, "87309")),
        ((Standards.NACEBEL2003, "85316"), (Standards.NACEBEL2008, "87902")),
        ((Standards.NACEBEL2003, "85321"), (Standards.NACEBEL2008, "88911")),
        ((Standards.NACEBEL2003, "85321"), (Standards.NACEBEL2008, "88912")),
        ((Standards.NACEBEL2003, "85321"), (Standards.NACEBEL2008, "88919")),
        ((Standards.NACEBEL2003, "8532101"), (Standards.NACEBEL2008, "8891101")),
        ((Standards.NACEBEL2003, "85322"), (Standards.NACEBEL2008, "88995")),
        ((Standards.NACEBEL2003, "85322"), (Standards.NACEBEL2008, "88104")),
        ((Standards.NACEBEL2003, "85322"), (Standards.NACEBEL2008, "88109")),
        ((Standards.NACEBEL2003, "85322"), (Standards.NACEBEL2008, "88992")),
        ((Standards.NACEBEL2003, "85323"), (Standards.NACEBEL2008, "88999")),
        ((Standards.NACEBEL2003, "85323"), (Standards.NACEBEL2008, "85601")),
        ((Standards.NACEBEL2003, "85323"), (Standards.NACEBEL2008, "88101")),
        ((Standards.NACEBEL2003, "85323"), (Standards.NACEBEL2008, "88102")),
        ((Standards.NACEBEL2003, "85323"), (Standards.NACEBEL2008, "88103")),
        ((Standards.NACEBEL2003, "85323"), (Standards.NACEBEL2008, "88104")),
        ((Standards.NACEBEL2003, "85323"), (Standards.NACEBEL2008, "88109")),
        ((Standards.NACEBEL2003, "85323"), (Standards.NACEBEL2008, "88991")),
        ((Standards.NACEBEL2003, "85323"), (Standards.NACEBEL2008, "88992")),
        ((Standards.NACEBEL2003, "85323"), (Standards.NACEBEL2008, "88993")),
        ((Standards.NACEBEL2003, "85323"), (Standards.NACEBEL2008, "88994")),
        ((Standards.NACEBEL2003, "85323"), (Standards.NACEBEL2008, "88996")),
        ((Standards.NACEBEL2003, "8532301"), (Standards.NACEBEL2008, "88999")),
        ((Standards.NACEBEL2003, "85324"), (Standards.NACEBEL2008, "85601")),
        ((Standards.NACEBEL2003, "90001"), (Standards.NACEBEL2008, "37000")),
        ((Standards.NACEBEL2003, "9000101"), (Standards.NACEBEL2008, "37000")),
        ((Standards.NACEBEL2003, "9000102"), (Standards.NACEBEL2008, "37000")),
        ((Standards.NACEBEL2003, "9000103"), (Standards.NACEBEL2008, "37000")),
        ((Standards.NACEBEL2003, "9000104"), (Standards.NACEBEL2008, "37000")),
        ((Standards.NACEBEL2003, "9000105"), (Standards.NACEBEL2008, "37000")),
        ((Standards.NACEBEL2003, "90002"), (Standards.NACEBEL2008, "38213")),
        ((Standards.NACEBEL2003, "9000201"), (Standards.NACEBEL2008, "38110")),
        ((Standards.NACEBEL2003, "9000202"), (Standards.NACEBEL2008, "38110")),
        ((Standards.NACEBEL2003, "9000203"), (Standards.NACEBEL2008, "38213")),
        ((Standards.NACEBEL2003, "90003"), (Standards.NACEBEL2008, "38213")),
        ((Standards.NACEBEL2003, "9000301"), (Standards.NACEBEL2008, "38213")),
        ((Standards.NACEBEL2003, "9000302"), (Standards.NACEBEL2008, "38213")),
        ((Standards.NACEBEL2003, "9000303"), (Standards.NACEBEL2008, "38213")),
        ((Standards.NACEBEL2003, "9000304"), (Standards.NACEBEL2008, "39000")),
        ((Standards.NACEBEL2003, "9000305"), (Standards.NACEBEL2008, "39000")),
        ((Standards.NACEBEL2003, "9000306"), (Standards.NACEBEL2008, "38110")),
        ((Standards.NACEBEL2003, "90004"), (Standards.NACEBEL2008, "38219")),
        ((Standards.NACEBEL2003, "9000401"), (Standards.NACEBEL2008, "38213")),
        ((Standards.NACEBEL2003, "90005"), (Standards.NACEBEL2008, "81290")),
        ((Standards.NACEBEL2003, "9000501"), (Standards.NACEBEL2008, "81290")),
        ((Standards.NACEBEL2003, "9000502"), (Standards.NACEBEL2008, "81290")),
        ((Standards.NACEBEL2003, "90010"), (Standards.NACEBEL2008, "37000")),
        ((Standards.NACEBEL2003, "90021"), (Standards.NACEBEL2008, "38219")),
        ((Standards.NACEBEL2003, "90021"), (Standards.NACEBEL2008, "38110")),
        ((Standards.NACEBEL2003, "90021"), (Standards.NACEBEL2008, "38120")),
        ((Standards.NACEBEL2003, "90022"), (Standards.NACEBEL2008, "38222")),
        ((Standards.NACEBEL2003, "90023"), (Standards.NACEBEL2008, "38222")),
        ((Standards.NACEBEL2003, "90030"), (Standards.NACEBEL2008, "39000")),
        ((Standards.NACEBEL2003, "90031"), (Standards.NACEBEL2008, "81290")),
        ((Standards.NACEBEL2003, "90032"), (Standards.NACEBEL2008, "39000")),
        ((Standards.NACEBEL2003, "90032"), (Standards.NACEBEL2008, "38110")),
        ((Standards.NACEBEL2003, "90032"), (Standards.NACEBEL2008, "81290")),
        ((Standards.NACEBEL2003, "91110"), (Standards.NACEBEL2008, "94110")),
        ((Standards.NACEBEL2003, "91120"), (Standards.NACEBEL2008, "94120")),
        ((Standards.NACEBEL2003, "91200"), (Standards.NACEBEL2008, "94200")),
        ((Standards.NACEBEL2003, "91310"), (Standards.NACEBEL2008, "94910")),
        ((Standards.NACEBEL2003, "91311"), (Standards.NACEBEL2008, "94910")),
        ((Standards.NACEBEL2003, "91319"), (Standards.NACEBEL2008, "94910")),
        ((Standards.NACEBEL2003, "91320"), (Standards.NACEBEL2008, "94920")),
        ((Standards.NACEBEL2003, "91330"), (Standards.NACEBEL2008, "94999")),
        ((Standards.NACEBEL2003, "91330"), (Standards.NACEBEL2008, "94991")),
        ((Standards.NACEBEL2003, "91330"), (Standards.NACEBEL2008, "94992")),
        ((Standards.NACEBEL2003, "91330"), (Standards.NACEBEL2008, "94993")),
        ((Standards.NACEBEL2003, "91330"), (Standards.NACEBEL2008, "94994")),
        ((Standards.NACEBEL2003, "91330"), (Standards.NACEBEL2008, "94995")),
        ((Standards.NACEBEL2003, "92111"), (Standards.NACEBEL2008, "59111")),
        ((Standards.NACEBEL2003, "9211101"), (Standards.NACEBEL2008, "5911101")),
        ((Standards.NACEBEL2003, "92112"), (Standards.NACEBEL2008, "59112")),
        ((Standards.NACEBEL2003, "9211201"), (Standards.NACEBEL2008, "5911201")),
        ((Standards.NACEBEL2003, "92113"), (Standards.NACEBEL2008, "59113")),
        ((Standards.NACEBEL2003, "9211301"), (Standards.NACEBEL2008, "5911301")),
        ((Standards.NACEBEL2003, "9211302"), (Standards.NACEBEL2008, "5911302")),
        ((Standards.NACEBEL2003, "92114"), (Standards.NACEBEL2008, "59120")),
        ((Standards.NACEBEL2003, "92114"), (Standards.NACEBEL2008, "59202")),
        ((Standards.NACEBEL2003, "9211401"), (Standards.NACEBEL2008, "5912001")),
        ((Standards.NACEBEL2003, "9211402"), (Standards.NACEBEL2008, "5912002")),
        ((Standards.NACEBEL2003, "92120"), (Standards.NACEBEL2008, "59130")),
        ((Standards.NACEBEL2003, "9212001"), (Standards.NACEBEL2008, "5913001")),
        ((Standards.NACEBEL2003, "9212002"), (Standards.NACEBEL2008, "5913002")),
        ((Standards.NACEBEL2003, "9212003"), (Standards.NACEBEL2008, "5913003")),
        ((Standards.NACEBEL2003, "9212004"), (Standards.NACEBEL2008, "5913004")),
        ((Standards.NACEBEL2003, "92130"), (Standards.NACEBEL2008, "59140")),
        ((Standards.NACEBEL2003, "9213001"), (Standards.NACEBEL2008, "5914001")),
        ((Standards.NACEBEL2003, "9213002"), (Standards.NACEBEL2008, "5914002")),
        ((Standards.NACEBEL2003, "92201"), (Standards.NACEBEL2008, "60100")),
        ((Standards.NACEBEL2003, "92201"), (Standards.NACEBEL2008, "59201")),
        ((Standards.NACEBEL2003, "9220101"), (Standards.NACEBEL2008, "6010001")),
        ((Standards.NACEBEL2003, "9220102"), (Standards.NACEBEL2008, "6010002")),
        ((Standards.NACEBEL2003, "92202"), (Standards.NACEBEL2008, "59114")),
        ((Standards.NACEBEL2003, "92202"), (Standards.NACEBEL2008, "59120")),
        ((Standards.NACEBEL2003, "9220201"), (Standards.NACEBEL2008, "5911401")),
        ((Standards.NACEBEL2003, "9220202"), (Standards.NACEBEL2008, "5911402")),
        ((Standards.NACEBEL2003, "92203"), (Standards.NACEBEL2008, "60200")),
        ((Standards.NACEBEL2003, "9220301"), (Standards.NACEBEL2008, "6020001")),
        ((Standards.NACEBEL2003, "9220302"), (Standards.NACEBEL2008, "6020002")),
        ((Standards.NACEBEL2003, "92204"), (Standards.NACEBEL2008, "59114")),
        ((Standards.NACEBEL2003, "92311"), (Standards.NACEBEL2008, "90011")),
        ((Standards.NACEBEL2003, "92311"), (Standards.NACEBEL2008, "90029")),
        ((Standards.NACEBEL2003, "92311"), (Standards.NACEBEL2008, "90031")),
        ((Standards.NACEBEL2003, "92312"), (Standards.NACEBEL2008, "90012")),
        ((Standards.NACEBEL2003, "92313"), (Standards.NACEBEL2008, "90023")),
        ((Standards.NACEBEL2003, "92313"), (Standards.NACEBEL2008, "90021")),
        ((Standards.NACEBEL2003, "92313"), (Standards.NACEBEL2008, "90022")),
        ((Standards.NACEBEL2003, "92313"), (Standards.NACEBEL2008, "90029")),
        ((Standards.NACEBEL2003, "92313"), (Standards.NACEBEL2008, "90032")),
        ((Standards.NACEBEL2003, "92321"), (Standards.NACEBEL2008, "90041")),
        ((Standards.NACEBEL2003, "92321"), (Standards.NACEBEL2008, "79909")),
        ((Standards.NACEBEL2003, "9232101"), (Standards.NACEBEL2008, "9004101")),
        ((Standards.NACEBEL2003, "9232102"), (Standards.NACEBEL2008, "7990901")),
        ((Standards.NACEBEL2003, "9232103"), (Standards.NACEBEL2008, "9004102")),
        ((Standards.NACEBEL2003, "92322"), (Standards.NACEBEL2008, "90042")),
        ((Standards.NACEBEL2003, "92322"), (Standards.NACEBEL2008, "79909")),
        ((Standards.NACEBEL2003, "9232201"), (Standards.NACEBEL2008, "9004201")),
        ((Standards.NACEBEL2003, "9232202"), (Standards.NACEBEL2008, "9004202")),
        ((Standards.NACEBEL2003, "92331"), (Standards.NACEBEL2008, "93211")),
        ((Standards.NACEBEL2003, "9233101"), (Standards.NACEBEL2008, "9321101")),
        ((Standards.NACEBEL2003, "92332"), (Standards.NACEBEL2008, "93212")),
        ((Standards.NACEBEL2003, "9233201"), (Standards.NACEBEL2008, "9321201")),
        ((Standards.NACEBEL2003, "9233202"), (Standards.NACEBEL2008, "93212")),
        ((Standards.NACEBEL2003, "92340"), (Standards.NACEBEL2008, "93299")),
        ((Standards.NACEBEL2003, "92340"), (Standards.NACEBEL2008, "79909")),
        ((Standards.NACEBEL2003, "92340"), (Standards.NACEBEL2008, "85520")),
        ((Standards.NACEBEL2003, "92340"), (Standards.NACEBEL2008, "90012")),
        ((Standards.NACEBEL2003, "9234001"), (Standards.NACEBEL2008, "8552001")),
        ((Standards.NACEBEL2003, "9234002"), (Standards.NACEBEL2008, "9329901")),
        ((Standards.NACEBEL2003, "92400"), (Standards.NACEBEL2008, "63910")),
        ((Standards.NACEBEL2003, "92400"), (Standards.NACEBEL2008, "74202")),
        ((Standards.NACEBEL2003, "92400"), (Standards.NACEBEL2008, "90031")),
        ((Standards.NACEBEL2003, "9240001"), (Standards.NACEBEL2008, "6391001")),
        ((Standards.NACEBEL2003, "9240002"), (Standards.NACEBEL2008, "7420201")),
        ((Standards.NACEBEL2003, "92510"), (Standards.NACEBEL2008, "91011")),
        ((Standards.NACEBEL2003, "92510"), (Standards.NACEBEL2008, "91012")),
        ((Standards.NACEBEL2003, "9251001"), (Standards.NACEBEL2008, "9101101")),
        ((Standards.NACEBEL2003, "9251002"), (Standards.NACEBEL2008, "9101201")),
        ((Standards.NACEBEL2003, "9251003"), (Standards.NACEBEL2008, "9101102")),
        ((Standards.NACEBEL2003, "9251004"), (Standards.NACEBEL2008, "9101103")),
        ((Standards.NACEBEL2003, "9251005"), (Standards.NACEBEL2008, "9101104")),
        ((Standards.NACEBEL2003, "92520"), (Standards.NACEBEL2008, "91030")),
        ((Standards.NACEBEL2003, "92520"), (Standards.NACEBEL2008, "91020")),
        ((Standards.NACEBEL2003, "9252001"), (Standards.NACEBEL2008, "9103001")),
        ((Standards.NACEBEL2003, "9252002"), (Standards.NACEBEL2008, "9103002")),
        ((Standards.NACEBEL2003, "9252003"), (Standards.NACEBEL2008, "9102001")),
        ((Standards.NACEBEL2003, "92530"), (Standards.NACEBEL2008, "91042")),
        ((Standards.NACEBEL2003, "92530"), (Standards.NACEBEL2008, "91041")),
        ((Standards.NACEBEL2003, "9253001"), (Standards.NACEBEL2008, "9104201")),
        ((Standards.NACEBEL2003, "9253002"), (Standards.NACEBEL2008, "9104101")),
        ((Standards.NACEBEL2003, "9253003"), (Standards.NACEBEL2008, "9104202")),
        ((Standards.NACEBEL2003, "92611"), (Standards.NACEBEL2008, "93110")),
        ((Standards.NACEBEL2003, "9261101"), (Standards.NACEBEL2008, "9311001")),
        ((Standards.NACEBEL2003, "9261102"), (Standards.NACEBEL2008, "9311002")),
        ((Standards.NACEBEL2003, "92612"), (Standards.NACEBEL2008, "93130")),
        ((Standards.NACEBEL2003, "92612"), (Standards.NACEBEL2008, "93110")),
        ((Standards.NACEBEL2003, "9261201"), (Standards.NACEBEL2008, "9313001")),
        ((Standards.NACEBEL2003, "92613"), (Standards.NACEBEL2008, "93110")),
        ((Standards.NACEBEL2003, "92613"), (Standards.NACEBEL2008, "93299")),
        ((Standards.NACEBEL2003, "9261301"), (Standards.NACEBEL2008, "9311011")),
        ((Standards.NACEBEL2003, "9261302"), (Standards.NACEBEL2008, "9311012")),
        ((Standards.NACEBEL2003, "9261303"), (Standards.NACEBEL2008, "9311013")),
        ((Standards.NACEBEL2003, "9261304"), (Standards.NACEBEL2008, "9311014")),
        ((Standards.NACEBEL2003, "92621"), (Standards.NACEBEL2008, "93121")),
        ((Standards.NACEBEL2003, "92621"), (Standards.NACEBEL2008, "93122")),
        ((Standards.NACEBEL2003, "92621"), (Standards.NACEBEL2008, "93123")),
        ((Standards.NACEBEL2003, "92621"), (Standards.NACEBEL2008, "93124")),
        ((Standards.NACEBEL2003, "92621"), (Standards.NACEBEL2008, "93125")),
        ((Standards.NACEBEL2003, "92621"), (Standards.NACEBEL2008, "93126")),
        ((Standards.NACEBEL2003, "92621"), (Standards.NACEBEL2008, "93127")),
        ((Standards.NACEBEL2003, "92621"), (Standards.NACEBEL2008, "93128")),
        ((Standards.NACEBEL2003, "92621"), (Standards.NACEBEL2008, "93129")),
        ((Standards.NACEBEL2003, "92621"), (Standards.NACEBEL2008, "93191")),
        ((Standards.NACEBEL2003, "9262101"), (Standards.NACEBEL2008, "9311021")),
        ((Standards.NACEBEL2003, "9262102"), (Standards.NACEBEL2008, "9312901")),
        ((Standards.NACEBEL2003, "9262103"), (Standards.NACEBEL2008, "9312902")),
        ((Standards.NACEBEL2003, "9262104"), (Standards.NACEBEL2008, "9312903")),
        ((Standards.NACEBEL2003, "9262105"), (Standards.NACEBEL2008, "9312904")),
        ((Standards.NACEBEL2003, "92622"), (Standards.NACEBEL2008, "85510")),
        ((Standards.NACEBEL2003, "92622"), (Standards.NACEBEL2008, "93192")),
        ((Standards.NACEBEL2003, "92623"), (Standards.NACEBEL2008, "93199")),
        ((Standards.NACEBEL2003, "92623"), (Standards.NACEBEL2008, "79909")),
        ((Standards.NACEBEL2003, "9262301"), (Standards.NACEBEL2008, "9319901")),
        ((Standards.NACEBEL2003, "9262302"), (Standards.NACEBEL2008, "9319902")),
        ((Standards.NACEBEL2003, "92710"), (Standards.NACEBEL2008, "92000")),
        ((Standards.NACEBEL2003, "9271001"), (Standards.NACEBEL2008, "9200001")),
        ((Standards.NACEBEL2003, "9271002"), (Standards.NACEBEL2008, "9200002")),
        ((Standards.NACEBEL2003, "9271003"), (Standards.NACEBEL2008, "9200003")),
        ((Standards.NACEBEL2003, "9271004"), (Standards.NACEBEL2008, "9200004")),
        ((Standards.NACEBEL2003, "92721"), (Standards.NACEBEL2008, "93291")),
        ((Standards.NACEBEL2003, "92721"), (Standards.NACEBEL2008, "79909")),
        ((Standards.NACEBEL2003, "9272101"), (Standards.NACEBEL2008, "9329101")),
        ((Standards.NACEBEL2003, "92722"), (Standards.NACEBEL2008, "93292")),
        ((Standards.NACEBEL2003, "92722"), (Standards.NACEBEL2008, "79909")),
        ((Standards.NACEBEL2003, "92722"), (Standards.NACEBEL2008, "93299")),
        ((Standards.NACEBEL2003, "9272201"), (Standards.NACEBEL2008, "9329201")),
        ((Standards.NACEBEL2003, "92723"), (Standards.NACEBEL2008, "93299")),
        ((Standards.NACEBEL2003, "92723"), (Standards.NACEBEL2008, "79909")),
        ((Standards.NACEBEL2003, "9272301"), (Standards.NACEBEL2008, "9329911")),
        ((Standards.NACEBEL2003, "9272302"), (Standards.NACEBEL2008, "9329912")),
        ((Standards.NACEBEL2003, "92724"), (Standards.NACEBEL2008, "93299")),
        ((Standards.NACEBEL2003, "92724"), (Standards.NACEBEL2008, "78100")),
        ((Standards.NACEBEL2003, "92724"), (Standards.NACEBEL2008, "79909")),
        ((Standards.NACEBEL2003, "92724"), (Standards.NACEBEL2008, "85510")),
        ((Standards.NACEBEL2003, "92724"), (Standards.NACEBEL2008, "93129")),
        ((Standards.NACEBEL2003, "9272401"), (Standards.NACEBEL2008, "7810021")),
        ((Standards.NACEBEL2003, "9272402"), (Standards.NACEBEL2008, "9329921")),
        ((Standards.NACEBEL2003, "93011"), (Standards.NACEBEL2008, "96011")),
        ((Standards.NACEBEL2003, "9301101"), (Standards.NACEBEL2008, "9601101")),
        ((Standards.NACEBEL2003, "9301102"), (Standards.NACEBEL2008, "9601102")),
        ((Standards.NACEBEL2003, "9301103"), (Standards.NACEBEL2008, "9601103")),
        ((Standards.NACEBEL2003, "9301104"), (Standards.NACEBEL2008, "9601104")),
        ((Standards.NACEBEL2003, "9301105"), (Standards.NACEBEL2008, "9529011")),
        ((Standards.NACEBEL2003, "9301106"), (Standards.NACEBEL2008, "9601105")),
        ((Standards.NACEBEL2003, "93012"), (Standards.NACEBEL2008, "96012")),
        ((Standards.NACEBEL2003, "9301201"), (Standards.NACEBEL2008, "9601201")),
        ((Standards.NACEBEL2003, "9301202"), (Standards.NACEBEL2008, "9601202")),
        ((Standards.NACEBEL2003, "93013"), (Standards.NACEBEL2008, "96012")),
        ((Standards.NACEBEL2003, "9301301"), (Standards.NACEBEL2008, "9601211")),
        ((Standards.NACEBEL2003, "93021"), (Standards.NACEBEL2008, "96021")),
        ((Standards.NACEBEL2003, "9302101"), (Standards.NACEBEL2008, "9602101")),
        ((Standards.NACEBEL2003, "93022"), (Standards.NACEBEL2008, "96022")),
        ((Standards.NACEBEL2003, "9302201"), (Standards.NACEBEL2008, "9602201")),
        ((Standards.NACEBEL2003, "9302202"), (Standards.NACEBEL2008, "9602202")),
        ((Standards.NACEBEL2003, "9302203"), (Standards.NACEBEL2008, "9602203")),
        ((Standards.NACEBEL2003, "93031"), (Standards.NACEBEL2008, "96031")),
        ((Standards.NACEBEL2003, "9303101"), (Standards.NACEBEL2008, "9603101")),
        ((Standards.NACEBEL2003, "9303102"), (Standards.NACEBEL2008, "9603102")),
        ((Standards.NACEBEL2003, "9303103"), (Standards.NACEBEL2008, "9603103")),
        ((Standards.NACEBEL2003, "9303104"), (Standards.NACEBEL2008, "9603104")),
        ((Standards.NACEBEL2003, "93032"), (Standards.NACEBEL2008, "96032")),
        ((Standards.NACEBEL2003, "9303201"), (Standards.NACEBEL2008, "9603201")),
        ((Standards.NACEBEL2003, "9303202"), (Standards.NACEBEL2008, "9603202")),
        ((Standards.NACEBEL2003, "9303203"), (Standards.NACEBEL2008, "9603203")),
        ((Standards.NACEBEL2003, "93040"), (Standards.NACEBEL2008, "96040")),
        ((Standards.NACEBEL2003, "93040"), (Standards.NACEBEL2008, "85510")),
        ((Standards.NACEBEL2003, "93040"), (Standards.NACEBEL2008, "93130")),
        ((Standards.NACEBEL2003, "9304001"), (Standards.NACEBEL2008, "9604001")),
        ((Standards.NACEBEL2003, "93051"), (Standards.NACEBEL2008, "96091")),
        ((Standards.NACEBEL2003, "93051"), (Standards.NACEBEL2008, "96099")),
        ((Standards.NACEBEL2003, "9305101"), (Standards.NACEBEL2008, "9609101")),
        ((Standards.NACEBEL2003, "93052"), (Standards.NACEBEL2008, "96099")),
        ((Standards.NACEBEL2003, "9305201"), (Standards.NACEBEL2008, "9609901")),
        ((Standards.NACEBEL2003, "93053"), (Standards.NACEBEL2008, "96099")),
        ((Standards.NACEBEL2003, "93053"), (Standards.NACEBEL2008, "96092")),
        ((Standards.NACEBEL2003, "93053"), (Standards.NACEBEL2008, "96093")),
        ((Standards.NACEBEL2003, "93053"), (Standards.NACEBEL2008, "96094")),
        ((Standards.NACEBEL2003, "93053"), (Standards.NACEBEL2008, "96095")),
        ((Standards.NACEBEL2003, "9305301"), (Standards.NACEBEL2008, "9609911")),
        ((Standards.NACEBEL2003, "9305302"), (Standards.NACEBEL2008, "9609201")),
        ((Standards.NACEBEL2003, "9305303"), (Standards.NACEBEL2008, "9609912")),
        ((Standards.NACEBEL2003, "9305304"), (Standards.NACEBEL2008, "9609401")),
        ((Standards.NACEBEL2003, "95000"), (Standards.NACEBEL2008, "97000")),
        ((Standards.NACEBEL2003, "95001"), (Standards.NACEBEL2008, "97000")),
        ((Standards.NACEBEL2003, "95002"), (Standards.NACEBEL2008, "97000")),
        ((Standards.NACEBEL2003, "95003"), (Standards.NACEBEL2008, "97000")),
        ((Standards.NACEBEL2003, "96000"), (Standards.NACEBEL2008, "98100")),
        ((Standards.NACEBEL2003, "97000"), (Standards.NACEBEL2008, "98200")),
        ((Standards.NACEBEL2003, "98901"), (Standards.NACEBEL2008, "98200")),
        ((Standards.NACEBEL2003, "98902"), (Standards.NACEBEL2008, "98200")),
        ((Standards.NACEBEL2003, "98903"), (Standards.NACEBEL2008, "98200")),
        ((Standards.NACEBEL2003, "98904"), (Standards.NACEBEL2008, "98200")),
        ((Standards.NACEBEL2003, "98905"), (Standards.NACEBEL2008, "98200")),
        ((Standards.NACEBEL2003, "99000"), (Standards.NACEBEL2008, "99000")),
    ],
)
