# -*- coding: utf-8 -*-
"""`Concordance between NACE2 and ISIC4 <https://unstats.un.org/unsd/classifications/Econ/tables/ISIC/NACE2_ISIC4/NACE2_ISIC4.txt>`_.
"""
from ...types import Concordance, Standards
from ..isic4 import ISIC4
from . import NACE2

NACE2_to_ISIC4 = Concordance(
    src=NACE2,
    dst=ISIC4,
    concordances=[
        ((Standards.NACE2, "A"), (Standards.ISIC4, "A")),
        ((Standards.NACE2, "01"), (Standards.ISIC4, "01")),
        ((Standards.NACE2, "01.1"), (Standards.ISIC4, "011")),
        ((Standards.NACE2, "01.11"), (Standards.ISIC4, "0111")),
        ((Standards.NACE2, "01.12"), (Standards.ISIC4, "0112")),
        ((Standards.NACE2, "01.13"), (Standards.ISIC4, "0113")),
        ((Standards.NACE2, "01.14"), (Standards.ISIC4, "0114")),
        ((Standards.NACE2, "01.15"), (Standards.ISIC4, "0115")),
        ((Standards.NACE2, "01.16"), (Standards.ISIC4, "0116")),
        ((Standards.NACE2, "01.19"), (Standards.ISIC4, "0119")),
        ((Standards.NACE2, "01.2"), (Standards.ISIC4, "012")),
        ((Standards.NACE2, "01.21"), (Standards.ISIC4, "0121")),
        ((Standards.NACE2, "01.22"), (Standards.ISIC4, "0122")),
        ((Standards.NACE2, "01.23"), (Standards.ISIC4, "0123")),
        ((Standards.NACE2, "01.24"), (Standards.ISIC4, "0124")),
        ((Standards.NACE2, "01.25"), (Standards.ISIC4, "0125")),
        ((Standards.NACE2, "01.26"), (Standards.ISIC4, "0126")),
        ((Standards.NACE2, "01.27"), (Standards.ISIC4, "0127")),
        ((Standards.NACE2, "01.28"), (Standards.ISIC4, "0128")),
        ((Standards.NACE2, "01.29"), (Standards.ISIC4, "0129")),
        ((Standards.NACE2, "01.3"), (Standards.ISIC4, "013")),
        ((Standards.NACE2, "01.30"), (Standards.ISIC4, "0130")),
        ((Standards.NACE2, "01.4"), (Standards.ISIC4, "014")),
        ((Standards.NACE2, "01.41"), (Standards.ISIC4, "0141")),
        ((Standards.NACE2, "01.42"), (Standards.ISIC4, "0141")),
        ((Standards.NACE2, "01.43"), (Standards.ISIC4, "0142")),
        ((Standards.NACE2, "01.44"), (Standards.ISIC4, "0143")),
        ((Standards.NACE2, "01.45"), (Standards.ISIC4, "0144")),
        ((Standards.NACE2, "01.46"), (Standards.ISIC4, "0145")),
        ((Standards.NACE2, "01.47"), (Standards.ISIC4, "0146")),
        ((Standards.NACE2, "01.49"), (Standards.ISIC4, "0149")),
        ((Standards.NACE2, "01.5"), (Standards.ISIC4, "015")),
        ((Standards.NACE2, "01.50"), (Standards.ISIC4, "0150")),
        ((Standards.NACE2, "01.6"), (Standards.ISIC4, "016")),
        ((Standards.NACE2, "01.61"), (Standards.ISIC4, "0161")),
        ((Standards.NACE2, "01.62"), (Standards.ISIC4, "0162")),
        ((Standards.NACE2, "01.63"), (Standards.ISIC4, "0163")),
        ((Standards.NACE2, "01.64"), (Standards.ISIC4, "0164")),
        ((Standards.NACE2, "01.7"), (Standards.ISIC4, "017")),
        ((Standards.NACE2, "01.70"), (Standards.ISIC4, "0170")),
        ((Standards.NACE2, "02"), (Standards.ISIC4, "02")),
        ((Standards.NACE2, "02.1"), (Standards.ISIC4, "021")),
        ((Standards.NACE2, "02.10"), (Standards.ISIC4, "0210")),
        ((Standards.NACE2, "02.2"), (Standards.ISIC4, "022")),
        ((Standards.NACE2, "02.20"), (Standards.ISIC4, "0220")),
        ((Standards.NACE2, "02.3"), (Standards.ISIC4, "023")),
        ((Standards.NACE2, "02.30"), (Standards.ISIC4, "0230")),
        ((Standards.NACE2, "02.4"), (Standards.ISIC4, "024")),
        ((Standards.NACE2, "02.40"), (Standards.ISIC4, "0240")),
        ((Standards.NACE2, "03"), (Standards.ISIC4, "03")),
        ((Standards.NACE2, "03.1"), (Standards.ISIC4, "031")),
        ((Standards.NACE2, "03.11"), (Standards.ISIC4, "0311")),
        ((Standards.NACE2, "03.12"), (Standards.ISIC4, "0312")),
        ((Standards.NACE2, "03.2"), (Standards.ISIC4, "032")),
        ((Standards.NACE2, "03.21"), (Standards.ISIC4, "0321")),
        ((Standards.NACE2, "03.22"), (Standards.ISIC4, "0322")),
        ((Standards.NACE2, "B"), (Standards.ISIC4, "B")),
        ((Standards.NACE2, "05"), (Standards.ISIC4, "05")),
        ((Standards.NACE2, "05.1"), (Standards.ISIC4, "051")),
        ((Standards.NACE2, "05.10"), (Standards.ISIC4, "0510")),
        ((Standards.NACE2, "05.2"), (Standards.ISIC4, "052")),
        ((Standards.NACE2, "05.20"), (Standards.ISIC4, "0520")),
        ((Standards.NACE2, "06"), (Standards.ISIC4, "06")),
        ((Standards.NACE2, "06.1"), (Standards.ISIC4, "061")),
        ((Standards.NACE2, "06.10"), (Standards.ISIC4, "0610")),
        ((Standards.NACE2, "06.2"), (Standards.ISIC4, "062")),
        ((Standards.NACE2, "06.20"), (Standards.ISIC4, "0620")),
        ((Standards.NACE2, "07"), (Standards.ISIC4, "07")),
        ((Standards.NACE2, "07.1"), (Standards.ISIC4, "071")),
        ((Standards.NACE2, "07.10"), (Standards.ISIC4, "0710")),
        ((Standards.NACE2, "07.2"), (Standards.ISIC4, "072")),
        ((Standards.NACE2, "07.21"), (Standards.ISIC4, "0721")),
        ((Standards.NACE2, "07.29"), (Standards.ISIC4, "0729")),
        ((Standards.NACE2, "08"), (Standards.ISIC4, "08")),
        ((Standards.NACE2, "08.1"), (Standards.ISIC4, "081")),
        ((Standards.NACE2, "08.11"), (Standards.ISIC4, "0810")),
        ((Standards.NACE2, "08.12"), (Standards.ISIC4, "0810")),
        ((Standards.NACE2, "08.9"), (Standards.ISIC4, "089")),
        ((Standards.NACE2, "08.91"), (Standards.ISIC4, "0891")),
        ((Standards.NACE2, "08.92"), (Standards.ISIC4, "0892")),
        ((Standards.NACE2, "08.93"), (Standards.ISIC4, "0893")),
        ((Standards.NACE2, "08.99"), (Standards.ISIC4, "0899")),
        ((Standards.NACE2, "09"), (Standards.ISIC4, "09")),
        ((Standards.NACE2, "09.1"), (Standards.ISIC4, "091")),
        ((Standards.NACE2, "09.10"), (Standards.ISIC4, "0910")),
        ((Standards.NACE2, "09.9"), (Standards.ISIC4, "099")),
        ((Standards.NACE2, "09.90"), (Standards.ISIC4, "0990")),
        ((Standards.NACE2, "C"), (Standards.ISIC4, "C")),
        ((Standards.NACE2, "10"), (Standards.ISIC4, "10")),
        ((Standards.NACE2, "10.1"), (Standards.ISIC4, "101")),
        ((Standards.NACE2, "10.11"), (Standards.ISIC4, "1010")),
        ((Standards.NACE2, "10.12"), (Standards.ISIC4, "1010")),
        ((Standards.NACE2, "10.13"), (Standards.ISIC4, "1010")),
        ((Standards.NACE2, "10.2"), (Standards.ISIC4, "102")),
        ((Standards.NACE2, "10.20"), (Standards.ISIC4, "1020")),
        ((Standards.NACE2, "10.3"), (Standards.ISIC4, "103")),
        ((Standards.NACE2, "10.31"), (Standards.ISIC4, "1030")),
        ((Standards.NACE2, "10.32"), (Standards.ISIC4, "1030")),
        ((Standards.NACE2, "10.39"), (Standards.ISIC4, "1030")),
        ((Standards.NACE2, "10.4"), (Standards.ISIC4, "104")),
        ((Standards.NACE2, "10.41"), (Standards.ISIC4, "1040")),
        ((Standards.NACE2, "10.42"), (Standards.ISIC4, "1040")),
        ((Standards.NACE2, "10.5"), (Standards.ISIC4, "105")),
        ((Standards.NACE2, "10.51"), (Standards.ISIC4, "1050")),
        ((Standards.NACE2, "10.52"), (Standards.ISIC4, "1050")),
        ((Standards.NACE2, "10.6"), (Standards.ISIC4, "106")),
        ((Standards.NACE2, "10.61"), (Standards.ISIC4, "1061")),
        ((Standards.NACE2, "10.62"), (Standards.ISIC4, "1062")),
        ((Standards.NACE2, "10.7"), (Standards.ISIC4, "107")),
        ((Standards.NACE2, "10.71"), (Standards.ISIC4, "1071")),
        ((Standards.NACE2, "10.72"), (Standards.ISIC4, "1071")),
        ((Standards.NACE2, "10.73"), (Standards.ISIC4, "1074")),
        ((Standards.NACE2, "10.8"), (Standards.ISIC4, "107")),
        ((Standards.NACE2, "10.81"), (Standards.ISIC4, "1072")),
        ((Standards.NACE2, "10.82"), (Standards.ISIC4, "1073")),
        ((Standards.NACE2, "10.83"), (Standards.ISIC4, "1079")),
        ((Standards.NACE2, "10.84"), (Standards.ISIC4, "1079")),
        ((Standards.NACE2, "10.85"), (Standards.ISIC4, "1075")),
        ((Standards.NACE2, "10.86"), (Standards.ISIC4, "1079")),
        ((Standards.NACE2, "10.89"), (Standards.ISIC4, "1079")),
        ((Standards.NACE2, "10.9"), (Standards.ISIC4, "108")),
        ((Standards.NACE2, "10.91"), (Standards.ISIC4, "1080")),
        ((Standards.NACE2, "10.92"), (Standards.ISIC4, "1080")),
        ((Standards.NACE2, "11"), (Standards.ISIC4, "11")),
        ((Standards.NACE2, "11.0"), (Standards.ISIC4, "110")),
        ((Standards.NACE2, "11.01"), (Standards.ISIC4, "1101")),
        ((Standards.NACE2, "11.02"), (Standards.ISIC4, "1102")),
        ((Standards.NACE2, "11.03"), (Standards.ISIC4, "1102")),
        ((Standards.NACE2, "11.04"), (Standards.ISIC4, "1102")),
        ((Standards.NACE2, "11.05"), (Standards.ISIC4, "1103")),
        ((Standards.NACE2, "11.06"), (Standards.ISIC4, "1103")),
        ((Standards.NACE2, "11.07"), (Standards.ISIC4, "1104")),
        ((Standards.NACE2, "12"), (Standards.ISIC4, "12")),
        ((Standards.NACE2, "12.0"), (Standards.ISIC4, "120")),
        ((Standards.NACE2, "12.00"), (Standards.ISIC4, "1200")),
        ((Standards.NACE2, "13"), (Standards.ISIC4, "13")),
        ((Standards.NACE2, "13.1"), (Standards.ISIC4, "131")),
        ((Standards.NACE2, "13.10"), (Standards.ISIC4, "1311")),
        ((Standards.NACE2, "13.2"), (Standards.ISIC4, "131")),
        ((Standards.NACE2, "13.20"), (Standards.ISIC4, "1312")),
        ((Standards.NACE2, "13.3"), (Standards.ISIC4, "131")),
        ((Standards.NACE2, "13.30"), (Standards.ISIC4, "1313")),
        ((Standards.NACE2, "13.9"), (Standards.ISIC4, "139")),
        ((Standards.NACE2, "13.91"), (Standards.ISIC4, "1391")),
        ((Standards.NACE2, "13.92"), (Standards.ISIC4, "1392")),
        ((Standards.NACE2, "13.93"), (Standards.ISIC4, "1393")),
        ((Standards.NACE2, "13.94"), (Standards.ISIC4, "1394")),
        ((Standards.NACE2, "13.95"), (Standards.ISIC4, "1399")),
        ((Standards.NACE2, "13.96"), (Standards.ISIC4, "1399")),
        ((Standards.NACE2, "13.99"), (Standards.ISIC4, "1399")),
        ((Standards.NACE2, "14"), (Standards.ISIC4, "14")),
        ((Standards.NACE2, "14.1"), (Standards.ISIC4, "141")),
        ((Standards.NACE2, "14.11"), (Standards.ISIC4, "1410")),
        ((Standards.NACE2, "14.12"), (Standards.ISIC4, "1410")),
        ((Standards.NACE2, "14.13"), (Standards.ISIC4, "1410")),
        ((Standards.NACE2, "14.14"), (Standards.ISIC4, "1410")),
        ((Standards.NACE2, "14.19"), (Standards.ISIC4, "1410")),
        ((Standards.NACE2, "14.2"), (Standards.ISIC4, "142")),
        ((Standards.NACE2, "14.20"), (Standards.ISIC4, "1420")),
        ((Standards.NACE2, "14.3"), (Standards.ISIC4, "143")),
        ((Standards.NACE2, "14.31"), (Standards.ISIC4, "1430")),
        ((Standards.NACE2, "14.39"), (Standards.ISIC4, "1430")),
        ((Standards.NACE2, "15"), (Standards.ISIC4, "15")),
        ((Standards.NACE2, "15.1"), (Standards.ISIC4, "151")),
        ((Standards.NACE2, "15.11"), (Standards.ISIC4, "1511")),
        ((Standards.NACE2, "15.12"), (Standards.ISIC4, "1512")),
        ((Standards.NACE2, "15.2"), (Standards.ISIC4, "152")),
        ((Standards.NACE2, "15.20"), (Standards.ISIC4, "1520")),
        ((Standards.NACE2, "16"), (Standards.ISIC4, "16")),
        ((Standards.NACE2, "16.1"), (Standards.ISIC4, "161")),
        ((Standards.NACE2, "16.10"), (Standards.ISIC4, "1610")),
        ((Standards.NACE2, "16.2"), (Standards.ISIC4, "162")),
        ((Standards.NACE2, "16.21"), (Standards.ISIC4, "1621")),
        ((Standards.NACE2, "16.22"), (Standards.ISIC4, "1622")),
        ((Standards.NACE2, "16.23"), (Standards.ISIC4, "1622")),
        ((Standards.NACE2, "16.24"), (Standards.ISIC4, "1623")),
        ((Standards.NACE2, "16.29"), (Standards.ISIC4, "1629")),
        ((Standards.NACE2, "17"), (Standards.ISIC4, "17")),
        ((Standards.NACE2, "17.1"), (Standards.ISIC4, "170")),
        ((Standards.NACE2, "17.11"), (Standards.ISIC4, "1701")),
        ((Standards.NACE2, "17.12"), (Standards.ISIC4, "1701")),
        ((Standards.NACE2, "17.2"), (Standards.ISIC4, "170")),
        ((Standards.NACE2, "17.21"), (Standards.ISIC4, "1702")),
        ((Standards.NACE2, "17.22"), (Standards.ISIC4, "1709")),
        ((Standards.NACE2, "17.23"), (Standards.ISIC4, "1709")),
        ((Standards.NACE2, "17.24"), (Standards.ISIC4, "1709")),
        ((Standards.NACE2, "17.29"), (Standards.ISIC4, "1709")),
        ((Standards.NACE2, "18"), (Standards.ISIC4, "18")),
        ((Standards.NACE2, "18.1"), (Standards.ISIC4, "181")),
        ((Standards.NACE2, "18.11"), (Standards.ISIC4, "1811")),
        ((Standards.NACE2, "18.12"), (Standards.ISIC4, "1811")),
        ((Standards.NACE2, "18.13"), (Standards.ISIC4, "1812")),
        ((Standards.NACE2, "18.14"), (Standards.ISIC4, "1812")),
        ((Standards.NACE2, "18.2"), (Standards.ISIC4, "182")),
        ((Standards.NACE2, "18.20"), (Standards.ISIC4, "1820")),
        ((Standards.NACE2, "19"), (Standards.ISIC4, "19")),
        ((Standards.NACE2, "19.1"), (Standards.ISIC4, "191")),
        ((Standards.NACE2, "19.10"), (Standards.ISIC4, "1910")),
        ((Standards.NACE2, "19.2"), (Standards.ISIC4, "192")),
        ((Standards.NACE2, "19.20"), (Standards.ISIC4, "1920")),
        ((Standards.NACE2, "20"), (Standards.ISIC4, "20")),
        ((Standards.NACE2, "20.1"), (Standards.ISIC4, "201")),
        ((Standards.NACE2, "20.11"), (Standards.ISIC4, "2011")),
        ((Standards.NACE2, "20.12"), (Standards.ISIC4, "2011")),
        ((Standards.NACE2, "20.13"), (Standards.ISIC4, "2011")),
        ((Standards.NACE2, "20.14"), (Standards.ISIC4, "2011")),
        ((Standards.NACE2, "20.15"), (Standards.ISIC4, "2012")),
        ((Standards.NACE2, "20.16"), (Standards.ISIC4, "2013")),
        ((Standards.NACE2, "20.17"), (Standards.ISIC4, "2013")),
        ((Standards.NACE2, "20.2"), (Standards.ISIC4, "202")),
        ((Standards.NACE2, "20.20"), (Standards.ISIC4, "2021")),
        ((Standards.NACE2, "20.3"), (Standards.ISIC4, "202")),
        ((Standards.NACE2, "20.30"), (Standards.ISIC4, "2022")),
        ((Standards.NACE2, "20.4"), (Standards.ISIC4, "202")),
        ((Standards.NACE2, "20.41"), (Standards.ISIC4, "2023")),
        ((Standards.NACE2, "20.42"), (Standards.ISIC4, "2023")),
        ((Standards.NACE2, "20.5"), (Standards.ISIC4, "202")),
        ((Standards.NACE2, "20.51"), (Standards.ISIC4, "2029")),
        ((Standards.NACE2, "20.52"), (Standards.ISIC4, "2029")),
        ((Standards.NACE2, "20.53"), (Standards.ISIC4, "2029")),
        ((Standards.NACE2, "20.59"), (Standards.ISIC4, "2029")),
        ((Standards.NACE2, "20.6"), (Standards.ISIC4, "203")),
        ((Standards.NACE2, "20.60"), (Standards.ISIC4, "2030")),
        ((Standards.NACE2, "21"), (Standards.ISIC4, "21")),
        ((Standards.NACE2, "21.1"), (Standards.ISIC4, "210")),
        ((Standards.NACE2, "21.10"), (Standards.ISIC4, "2100")),
        ((Standards.NACE2, "21.2"), (Standards.ISIC4, "210")),
        ((Standards.NACE2, "21.20"), (Standards.ISIC4, "2100")),
        ((Standards.NACE2, "22"), (Standards.ISIC4, "22")),
        ((Standards.NACE2, "22.1"), (Standards.ISIC4, "221")),
        ((Standards.NACE2, "22.11"), (Standards.ISIC4, "2211")),
        ((Standards.NACE2, "22.19"), (Standards.ISIC4, "2219")),
        ((Standards.NACE2, "22.2"), (Standards.ISIC4, "222")),
        ((Standards.NACE2, "22.21"), (Standards.ISIC4, "2220")),
        ((Standards.NACE2, "22.22"), (Standards.ISIC4, "2220")),
        ((Standards.NACE2, "22.23"), (Standards.ISIC4, "2220")),
        ((Standards.NACE2, "22.29"), (Standards.ISIC4, "2220")),
        ((Standards.NACE2, "23"), (Standards.ISIC4, "23")),
        ((Standards.NACE2, "23.1"), (Standards.ISIC4, "231")),
        ((Standards.NACE2, "23.11"), (Standards.ISIC4, "2310")),
        ((Standards.NACE2, "23.12"), (Standards.ISIC4, "2310")),
        ((Standards.NACE2, "23.13"), (Standards.ISIC4, "2310")),
        ((Standards.NACE2, "23.14"), (Standards.ISIC4, "2310")),
        ((Standards.NACE2, "23.19"), (Standards.ISIC4, "2310")),
        ((Standards.NACE2, "23.2"), (Standards.ISIC4, "239")),
        ((Standards.NACE2, "23.20"), (Standards.ISIC4, "2391")),
        ((Standards.NACE2, "23.3"), (Standards.ISIC4, "239")),
        ((Standards.NACE2, "23.31"), (Standards.ISIC4, "2392")),
        ((Standards.NACE2, "23.32"), (Standards.ISIC4, "2392")),
        ((Standards.NACE2, "23.4"), (Standards.ISIC4, "239")),
        ((Standards.NACE2, "23.41"), (Standards.ISIC4, "2393")),
        ((Standards.NACE2, "23.42"), (Standards.ISIC4, "2393")),
        ((Standards.NACE2, "23.43"), (Standards.ISIC4, "2393")),
        ((Standards.NACE2, "23.44"), (Standards.ISIC4, "2393")),
        ((Standards.NACE2, "23.49"), (Standards.ISIC4, "2393")),
        ((Standards.NACE2, "23.5"), (Standards.ISIC4, "239")),
        ((Standards.NACE2, "23.51"), (Standards.ISIC4, "2394")),
        ((Standards.NACE2, "23.52"), (Standards.ISIC4, "2394")),
        ((Standards.NACE2, "23.6"), (Standards.ISIC4, "239")),
        ((Standards.NACE2, "23.61"), (Standards.ISIC4, "2395")),
        ((Standards.NACE2, "23.62"), (Standards.ISIC4, "2395")),
        ((Standards.NACE2, "23.63"), (Standards.ISIC4, "2395")),
        ((Standards.NACE2, "23.64"), (Standards.ISIC4, "2395")),
        ((Standards.NACE2, "23.65"), (Standards.ISIC4, "2395")),
        ((Standards.NACE2, "23.69"), (Standards.ISIC4, "2395")),
        ((Standards.NACE2, "23.7"), (Standards.ISIC4, "239")),
        ((Standards.NACE2, "23.70"), (Standards.ISIC4, "2396")),
        ((Standards.NACE2, "23.9"), (Standards.ISIC4, "239")),
        ((Standards.NACE2, "23.91"), (Standards.ISIC4, "2399")),
        ((Standards.NACE2, "23.99"), (Standards.ISIC4, "2399")),
        ((Standards.NACE2, "24"), (Standards.ISIC4, "24")),
        ((Standards.NACE2, "24.1"), (Standards.ISIC4, "241")),
        ((Standards.NACE2, "24.10"), (Standards.ISIC4, "2410")),
        ((Standards.NACE2, "24.2"), (Standards.ISIC4, "241")),
        ((Standards.NACE2, "24.20"), (Standards.ISIC4, "2410")),
        ((Standards.NACE2, "24.3"), (Standards.ISIC4, "241")),
        ((Standards.NACE2, "24.31"), (Standards.ISIC4, "2410")),
        ((Standards.NACE2, "24.32"), (Standards.ISIC4, "2410")),
        ((Standards.NACE2, "24.33"), (Standards.ISIC4, "2410")),
        ((Standards.NACE2, "24.34"), (Standards.ISIC4, "2410")),
        ((Standards.NACE2, "24.4"), (Standards.ISIC4, "242")),
        ((Standards.NACE2, "24.41"), (Standards.ISIC4, "2420")),
        ((Standards.NACE2, "24.42"), (Standards.ISIC4, "2420")),
        ((Standards.NACE2, "24.43"), (Standards.ISIC4, "2420")),
        ((Standards.NACE2, "24.44"), (Standards.ISIC4, "2420")),
        ((Standards.NACE2, "24.45"), (Standards.ISIC4, "2420")),
        ((Standards.NACE2, "24.46"), (Standards.ISIC4, "2420")),
        ((Standards.NACE2, "24.5"), (Standards.ISIC4, "243")),
        ((Standards.NACE2, "24.51"), (Standards.ISIC4, "2431")),
        ((Standards.NACE2, "24.52"), (Standards.ISIC4, "2431")),
        ((Standards.NACE2, "24.53"), (Standards.ISIC4, "2432")),
        ((Standards.NACE2, "24.54"), (Standards.ISIC4, "2432")),
        ((Standards.NACE2, "25"), (Standards.ISIC4, "25")),
        ((Standards.NACE2, "25.1"), (Standards.ISIC4, "251")),
        ((Standards.NACE2, "25.11"), (Standards.ISIC4, "2511")),
        ((Standards.NACE2, "25.12"), (Standards.ISIC4, "2511")),
        ((Standards.NACE2, "25.2"), (Standards.ISIC4, "251")),
        ((Standards.NACE2, "25.21"), (Standards.ISIC4, "2512")),
        ((Standards.NACE2, "25.29"), (Standards.ISIC4, "2512")),
        ((Standards.NACE2, "25.3"), (Standards.ISIC4, "251")),
        ((Standards.NACE2, "25.30"), (Standards.ISIC4, "2513")),
        ((Standards.NACE2, "25.4"), (Standards.ISIC4, "252")),
        ((Standards.NACE2, "25.40"), (Standards.ISIC4, "2520")),
        ((Standards.NACE2, "25.5"), (Standards.ISIC4, "259")),
        ((Standards.NACE2, "25.50"), (Standards.ISIC4, "2591")),
        ((Standards.NACE2, "25.6"), (Standards.ISIC4, "259")),
        ((Standards.NACE2, "25.61"), (Standards.ISIC4, "2592")),
        ((Standards.NACE2, "25.62"), (Standards.ISIC4, "2592")),
        ((Standards.NACE2, "25.7"), (Standards.ISIC4, "259")),
        ((Standards.NACE2, "25.71"), (Standards.ISIC4, "2593")),
        ((Standards.NACE2, "25.72"), (Standards.ISIC4, "2593")),
        ((Standards.NACE2, "25.73"), (Standards.ISIC4, "2593")),
        ((Standards.NACE2, "25.9"), (Standards.ISIC4, "259")),
        ((Standards.NACE2, "25.91"), (Standards.ISIC4, "2599")),
        ((Standards.NACE2, "25.92"), (Standards.ISIC4, "2599")),
        ((Standards.NACE2, "25.93"), (Standards.ISIC4, "2599")),
        ((Standards.NACE2, "25.94"), (Standards.ISIC4, "2599")),
        ((Standards.NACE2, "25.99"), (Standards.ISIC4, "2599")),
        ((Standards.NACE2, "26"), (Standards.ISIC4, "26")),
        ((Standards.NACE2, "26.1"), (Standards.ISIC4, "261")),
        ((Standards.NACE2, "26.11"), (Standards.ISIC4, "2610")),
        ((Standards.NACE2, "26.12"), (Standards.ISIC4, "2610")),
        ((Standards.NACE2, "26.2"), (Standards.ISIC4, "262")),
        ((Standards.NACE2, "26.20"), (Standards.ISIC4, "2620")),
        ((Standards.NACE2, "26.3"), (Standards.ISIC4, "263")),
        ((Standards.NACE2, "26.30"), (Standards.ISIC4, "2630")),
        ((Standards.NACE2, "26.4"), (Standards.ISIC4, "264")),
        ((Standards.NACE2, "26.40"), (Standards.ISIC4, "2640")),
        ((Standards.NACE2, "26.5"), (Standards.ISIC4, "265")),
        ((Standards.NACE2, "26.51"), (Standards.ISIC4, "2651")),
        ((Standards.NACE2, "26.52"), (Standards.ISIC4, "2652")),
        ((Standards.NACE2, "26.6"), (Standards.ISIC4, "266")),
        ((Standards.NACE2, "26.60"), (Standards.ISIC4, "2660")),
        ((Standards.NACE2, "26.7"), (Standards.ISIC4, "267")),
        ((Standards.NACE2, "26.70"), (Standards.ISIC4, "2670")),
        ((Standards.NACE2, "26.8"), (Standards.ISIC4, "268")),
        ((Standards.NACE2, "26.80"), (Standards.ISIC4, "2680")),
        ((Standards.NACE2, "27"), (Standards.ISIC4, "27")),
        ((Standards.NACE2, "27.1"), (Standards.ISIC4, "271")),
        ((Standards.NACE2, "27.11"), (Standards.ISIC4, "2710")),
        ((Standards.NACE2, "27.12"), (Standards.ISIC4, "2710")),
        ((Standards.NACE2, "27.2"), (Standards.ISIC4, "272")),
        ((Standards.NACE2, "27.20"), (Standards.ISIC4, "2720")),
        ((Standards.NACE2, "27.3"), (Standards.ISIC4, "273")),
        ((Standards.NACE2, "27.31"), (Standards.ISIC4, "2731")),
        ((Standards.NACE2, "27.32"), (Standards.ISIC4, "2732")),
        ((Standards.NACE2, "27.33"), (Standards.ISIC4, "2733")),
        ((Standards.NACE2, "27.4"), (Standards.ISIC4, "274")),
        ((Standards.NACE2, "27.40"), (Standards.ISIC4, "2740")),
        ((Standards.NACE2, "27.5"), (Standards.ISIC4, "275")),
        ((Standards.NACE2, "27.51"), (Standards.ISIC4, "2750")),
        ((Standards.NACE2, "27.52"), (Standards.ISIC4, "2750")),
        ((Standards.NACE2, "27.9"), (Standards.ISIC4, "279")),
        ((Standards.NACE2, "27.90"), (Standards.ISIC4, "2790")),
        ((Standards.NACE2, "28"), (Standards.ISIC4, "28")),
        ((Standards.NACE2, "28.1"), (Standards.ISIC4, "281")),
        ((Standards.NACE2, "28.11"), (Standards.ISIC4, "2811")),
        ((Standards.NACE2, "28.12"), (Standards.ISIC4, "2812")),
        ((Standards.NACE2, "28.13"), (Standards.ISIC4, "2813")),
        ((Standards.NACE2, "28.14"), (Standards.ISIC4, "2813")),
        ((Standards.NACE2, "28.15"), (Standards.ISIC4, "2814")),
        ((Standards.NACE2, "28.2"), (Standards.ISIC4, "281")),
        ((Standards.NACE2, "28.21"), (Standards.ISIC4, "2815")),
        ((Standards.NACE2, "28.22"), (Standards.ISIC4, "2816")),
        ((Standards.NACE2, "28.23"), (Standards.ISIC4, "2817")),
        ((Standards.NACE2, "28.24"), (Standards.ISIC4, "2818")),
        ((Standards.NACE2, "28.25"), (Standards.ISIC4, "2819")),
        ((Standards.NACE2, "28.29"), (Standards.ISIC4, "2819")),
        ((Standards.NACE2, "28.3"), (Standards.ISIC4, "282")),
        ((Standards.NACE2, "28.30"), (Standards.ISIC4, "2821")),
        ((Standards.NACE2, "28.4"), (Standards.ISIC4, "282")),
        ((Standards.NACE2, "28.41"), (Standards.ISIC4, "2822")),
        ((Standards.NACE2, "28.49"), (Standards.ISIC4, "2822")),
        ((Standards.NACE2, "28.9"), (Standards.ISIC4, "282")),
        ((Standards.NACE2, "28.91"), (Standards.ISIC4, "2823")),
        ((Standards.NACE2, "28.92"), (Standards.ISIC4, "2824")),
        ((Standards.NACE2, "28.93"), (Standards.ISIC4, "2825")),
        ((Standards.NACE2, "28.94"), (Standards.ISIC4, "2826")),
        ((Standards.NACE2, "28.95"), (Standards.ISIC4, "2829")),
        ((Standards.NACE2, "28.96"), (Standards.ISIC4, "2829")),
        ((Standards.NACE2, "28.99"), (Standards.ISIC4, "2829")),
        ((Standards.NACE2, "29"), (Standards.ISIC4, "29")),
        ((Standards.NACE2, "29.1"), (Standards.ISIC4, "291")),
        ((Standards.NACE2, "29.10"), (Standards.ISIC4, "2910")),
        ((Standards.NACE2, "29.2"), (Standards.ISIC4, "292")),
        ((Standards.NACE2, "29.20"), (Standards.ISIC4, "2920")),
        ((Standards.NACE2, "29.3"), (Standards.ISIC4, "293")),
        ((Standards.NACE2, "29.31"), (Standards.ISIC4, "2930")),
        ((Standards.NACE2, "29.32"), (Standards.ISIC4, "2930")),
        ((Standards.NACE2, "30"), (Standards.ISIC4, "30")),
        ((Standards.NACE2, "30.1"), (Standards.ISIC4, "301")),
        ((Standards.NACE2, "30.11"), (Standards.ISIC4, "3011")),
        ((Standards.NACE2, "30.12"), (Standards.ISIC4, "3012")),
        ((Standards.NACE2, "30.2"), (Standards.ISIC4, "302")),
        ((Standards.NACE2, "30.20"), (Standards.ISIC4, "3020")),
        ((Standards.NACE2, "30.3"), (Standards.ISIC4, "303")),
        ((Standards.NACE2, "30.30"), (Standards.ISIC4, "3030")),
        ((Standards.NACE2, "30.4"), (Standards.ISIC4, "304")),
        ((Standards.NACE2, "30.40"), (Standards.ISIC4, "3040")),
        ((Standards.NACE2, "30.9"), (Standards.ISIC4, "309")),
        ((Standards.NACE2, "30.91"), (Standards.ISIC4, "3091")),
        ((Standards.NACE2, "30.92"), (Standards.ISIC4, "3092")),
        ((Standards.NACE2, "30.99"), (Standards.ISIC4, "3099")),
        ((Standards.NACE2, "31"), (Standards.ISIC4, "31")),
        ((Standards.NACE2, "31.0"), (Standards.ISIC4, "310")),
        ((Standards.NACE2, "31.01"), (Standards.ISIC4, "3100")),
        ((Standards.NACE2, "31.02"), (Standards.ISIC4, "3100")),
        ((Standards.NACE2, "31.03"), (Standards.ISIC4, "3100")),
        ((Standards.NACE2, "31.09"), (Standards.ISIC4, "3100")),
        ((Standards.NACE2, "32"), (Standards.ISIC4, "32")),
        ((Standards.NACE2, "32.1"), (Standards.ISIC4, "321")),
        ((Standards.NACE2, "32.11"), (Standards.ISIC4, "3211")),
        ((Standards.NACE2, "32.12"), (Standards.ISIC4, "3211")),
        ((Standards.NACE2, "32.13"), (Standards.ISIC4, "3212")),
        ((Standards.NACE2, "32.2"), (Standards.ISIC4, "322")),
        ((Standards.NACE2, "32.20"), (Standards.ISIC4, "3220")),
        ((Standards.NACE2, "32.3"), (Standards.ISIC4, "323")),
        ((Standards.NACE2, "32.30"), (Standards.ISIC4, "3230")),
        ((Standards.NACE2, "32.4"), (Standards.ISIC4, "324")),
        ((Standards.NACE2, "32.40"), (Standards.ISIC4, "3240")),
        ((Standards.NACE2, "32.5"), (Standards.ISIC4, "325")),
        ((Standards.NACE2, "32.50"), (Standards.ISIC4, "3250")),
        ((Standards.NACE2, "32.9"), (Standards.ISIC4, "329")),
        ((Standards.NACE2, "32.91"), (Standards.ISIC4, "3290")),
        ((Standards.NACE2, "32.99"), (Standards.ISIC4, "3290")),
        ((Standards.NACE2, "33"), (Standards.ISIC4, "33")),
        ((Standards.NACE2, "33.1"), (Standards.ISIC4, "331")),
        ((Standards.NACE2, "33.11"), (Standards.ISIC4, "3311")),
        ((Standards.NACE2, "33.12"), (Standards.ISIC4, "3312")),
        ((Standards.NACE2, "33.13"), (Standards.ISIC4, "3313")),
        ((Standards.NACE2, "33.14"), (Standards.ISIC4, "3314")),
        ((Standards.NACE2, "33.15"), (Standards.ISIC4, "3315")),
        ((Standards.NACE2, "33.16"), (Standards.ISIC4, "3315")),
        ((Standards.NACE2, "33.17"), (Standards.ISIC4, "3315")),
        ((Standards.NACE2, "33.19"), (Standards.ISIC4, "3319")),
        ((Standards.NACE2, "33.2"), (Standards.ISIC4, "332")),
        ((Standards.NACE2, "33.20"), (Standards.ISIC4, "3320")),
        ((Standards.NACE2, "D"), (Standards.ISIC4, "D")),
        ((Standards.NACE2, "35"), (Standards.ISIC4, "35")),
        ((Standards.NACE2, "35.1"), (Standards.ISIC4, "351")),
        ((Standards.NACE2, "35.11"), (Standards.ISIC4, "3510")),
        ((Standards.NACE2, "35.12"), (Standards.ISIC4, "3510")),
        ((Standards.NACE2, "35.13"), (Standards.ISIC4, "3510")),
        ((Standards.NACE2, "35.14"), (Standards.ISIC4, "3510")),
        ((Standards.NACE2, "35.2"), (Standards.ISIC4, "352")),
        ((Standards.NACE2, "35.21"), (Standards.ISIC4, "3520")),
        ((Standards.NACE2, "35.22"), (Standards.ISIC4, "3520")),
        ((Standards.NACE2, "35.23"), (Standards.ISIC4, "3520")),
        ((Standards.NACE2, "35.3"), (Standards.ISIC4, "353")),
        ((Standards.NACE2, "35.30"), (Standards.ISIC4, "3530")),
        ((Standards.NACE2, "E"), (Standards.ISIC4, "E")),
        ((Standards.NACE2, "36"), (Standards.ISIC4, "36")),
        ((Standards.NACE2, "36.0"), (Standards.ISIC4, "360")),
        ((Standards.NACE2, "36.00"), (Standards.ISIC4, "3600")),
        ((Standards.NACE2, "37"), (Standards.ISIC4, "37")),
        ((Standards.NACE2, "37.0"), (Standards.ISIC4, "370")),
        ((Standards.NACE2, "37.00"), (Standards.ISIC4, "3700")),
        ((Standards.NACE2, "38"), (Standards.ISIC4, "38")),
        ((Standards.NACE2, "38.1"), (Standards.ISIC4, "381")),
        ((Standards.NACE2, "38.11"), (Standards.ISIC4, "3811")),
        ((Standards.NACE2, "38.12"), (Standards.ISIC4, "3812")),
        ((Standards.NACE2, "38.2"), (Standards.ISIC4, "382")),
        ((Standards.NACE2, "38.21"), (Standards.ISIC4, "3821")),
        ((Standards.NACE2, "38.22"), (Standards.ISIC4, "3822")),
        ((Standards.NACE2, "38.3"), (Standards.ISIC4, "383")),
        ((Standards.NACE2, "38.31"), (Standards.ISIC4, "3830")),
        ((Standards.NACE2, "38.32"), (Standards.ISIC4, "3830")),
        ((Standards.NACE2, "39"), (Standards.ISIC4, "39")),
        ((Standards.NACE2, "39.0"), (Standards.ISIC4, "390")),
        ((Standards.NACE2, "39.00"), (Standards.ISIC4, "3900")),
        ((Standards.NACE2, "F"), (Standards.ISIC4, "F")),
        ((Standards.NACE2, "41"), (Standards.ISIC4, "41")),
        ((Standards.NACE2, "41.1"), (Standards.ISIC4, "410")),
        ((Standards.NACE2, "41.10"), (Standards.ISIC4, "4100")),
        ((Standards.NACE2, "41.2"), (Standards.ISIC4, "410")),
        ((Standards.NACE2, "41.20"), (Standards.ISIC4, "4100")),
        ((Standards.NACE2, "42"), (Standards.ISIC4, "42")),
        ((Standards.NACE2, "42.1"), (Standards.ISIC4, "421")),
        ((Standards.NACE2, "42.11"), (Standards.ISIC4, "4210")),
        ((Standards.NACE2, "42.12"), (Standards.ISIC4, "4210")),
        ((Standards.NACE2, "42.13"), (Standards.ISIC4, "4210")),
        ((Standards.NACE2, "42.2"), (Standards.ISIC4, "422")),
        ((Standards.NACE2, "42.21"), (Standards.ISIC4, "4220")),
        ((Standards.NACE2, "42.22"), (Standards.ISIC4, "4220")),
        ((Standards.NACE2, "42.9"), (Standards.ISIC4, "429")),
        ((Standards.NACE2, "42.91"), (Standards.ISIC4, "4290")),
        ((Standards.NACE2, "42.99"), (Standards.ISIC4, "4290")),
        ((Standards.NACE2, "43"), (Standards.ISIC4, "43")),
        ((Standards.NACE2, "43.1"), (Standards.ISIC4, "431")),
        ((Standards.NACE2, "43.11"), (Standards.ISIC4, "4311")),
        ((Standards.NACE2, "43.12"), (Standards.ISIC4, "4312")),
        ((Standards.NACE2, "43.13"), (Standards.ISIC4, "4312")),
        ((Standards.NACE2, "43.2"), (Standards.ISIC4, "432")),
        ((Standards.NACE2, "43.21"), (Standards.ISIC4, "4321")),
        ((Standards.NACE2, "43.22"), (Standards.ISIC4, "4322")),
        ((Standards.NACE2, "43.29"), (Standards.ISIC4, "4329")),
        ((Standards.NACE2, "43.3"), (Standards.ISIC4, "433")),
        ((Standards.NACE2, "43.31"), (Standards.ISIC4, "4330")),
        ((Standards.NACE2, "43.32"), (Standards.ISIC4, "4330")),
        ((Standards.NACE2, "43.33"), (Standards.ISIC4, "4330")),
        ((Standards.NACE2, "43.34"), (Standards.ISIC4, "4330")),
        ((Standards.NACE2, "43.39"), (Standards.ISIC4, "4330")),
        ((Standards.NACE2, "43.9"), (Standards.ISIC4, "439")),
        ((Standards.NACE2, "43.91"), (Standards.ISIC4, "4390")),
        ((Standards.NACE2, "43.99"), (Standards.ISIC4, "4390")),
        ((Standards.NACE2, "G"), (Standards.ISIC4, "G")),
        ((Standards.NACE2, "45"), (Standards.ISIC4, "45")),
        ((Standards.NACE2, "45.1"), (Standards.ISIC4, "451")),
        ((Standards.NACE2, "45.11"), (Standards.ISIC4, "4510")),
        ((Standards.NACE2, "45.19"), (Standards.ISIC4, "4510")),
        ((Standards.NACE2, "45.2"), (Standards.ISIC4, "452")),
        ((Standards.NACE2, "45.20"), (Standards.ISIC4, "4520")),
        ((Standards.NACE2, "45.3"), (Standards.ISIC4, "453")),
        ((Standards.NACE2, "45.31"), (Standards.ISIC4, "4530")),
        ((Standards.NACE2, "45.32"), (Standards.ISIC4, "4530")),
        ((Standards.NACE2, "45.4"), (Standards.ISIC4, "454")),
        ((Standards.NACE2, "45.40"), (Standards.ISIC4, "4540")),
        ((Standards.NACE2, "46"), (Standards.ISIC4, "46")),
        ((Standards.NACE2, "46.1"), (Standards.ISIC4, "461")),
        ((Standards.NACE2, "46.11"), (Standards.ISIC4, "4610")),
        ((Standards.NACE2, "46.12"), (Standards.ISIC4, "4610")),
        ((Standards.NACE2, "46.13"), (Standards.ISIC4, "4610")),
        ((Standards.NACE2, "46.14"), (Standards.ISIC4, "4610")),
        ((Standards.NACE2, "46.15"), (Standards.ISIC4, "4610")),
        ((Standards.NACE2, "46.16"), (Standards.ISIC4, "4610")),
        ((Standards.NACE2, "46.17"), (Standards.ISIC4, "4610")),
        ((Standards.NACE2, "46.18"), (Standards.ISIC4, "4610")),
        ((Standards.NACE2, "46.19"), (Standards.ISIC4, "4610")),
        ((Standards.NACE2, "46.2"), (Standards.ISIC4, "462")),
        ((Standards.NACE2, "46.21"), (Standards.ISIC4, "4620")),
        ((Standards.NACE2, "46.22"), (Standards.ISIC4, "4620")),
        ((Standards.NACE2, "46.23"), (Standards.ISIC4, "4620")),
        ((Standards.NACE2, "46.24"), (Standards.ISIC4, "4620")),
        ((Standards.NACE2, "46.3"), (Standards.ISIC4, "463")),
        ((Standards.NACE2, "46.31"), (Standards.ISIC4, "4630")),
        ((Standards.NACE2, "46.32"), (Standards.ISIC4, "4630")),
        ((Standards.NACE2, "46.33"), (Standards.ISIC4, "4630")),
        ((Standards.NACE2, "46.34"), (Standards.ISIC4, "4630")),
        ((Standards.NACE2, "46.35"), (Standards.ISIC4, "4630")),
        ((Standards.NACE2, "46.36"), (Standards.ISIC4, "4630")),
        ((Standards.NACE2, "46.37"), (Standards.ISIC4, "4630")),
        ((Standards.NACE2, "46.38"), (Standards.ISIC4, "4630")),
        ((Standards.NACE2, "46.39"), (Standards.ISIC4, "4630")),
        ((Standards.NACE2, "46.4"), (Standards.ISIC4, "464")),
        ((Standards.NACE2, "46.41"), (Standards.ISIC4, "4641")),
        ((Standards.NACE2, "46.42"), (Standards.ISIC4, "4641")),
        ((Standards.NACE2, "46.43"), (Standards.ISIC4, "4649")),
        ((Standards.NACE2, "46.44"), (Standards.ISIC4, "4649")),
        ((Standards.NACE2, "46.45"), (Standards.ISIC4, "4649")),
        ((Standards.NACE2, "46.46"), (Standards.ISIC4, "4649")),
        ((Standards.NACE2, "46.47"), (Standards.ISIC4, "4649")),
        ((Standards.NACE2, "46.48"), (Standards.ISIC4, "4649")),
        ((Standards.NACE2, "46.49"), (Standards.ISIC4, "4649")),
        ((Standards.NACE2, "46.5"), (Standards.ISIC4, "465")),
        ((Standards.NACE2, "46.51"), (Standards.ISIC4, "4651")),
        ((Standards.NACE2, "46.52"), (Standards.ISIC4, "4652")),
        ((Standards.NACE2, "46.6"), (Standards.ISIC4, "466")),
        ((Standards.NACE2, "46.61"), (Standards.ISIC4, "4653")),
        ((Standards.NACE2, "46.62"), (Standards.ISIC4, "4659")),
        ((Standards.NACE2, "46.63"), (Standards.ISIC4, "4659")),
        ((Standards.NACE2, "46.64"), (Standards.ISIC4, "4659")),
        ((Standards.NACE2, "46.65"), (Standards.ISIC4, "4659")),
        ((Standards.NACE2, "46.66"), (Standards.ISIC4, "4659")),
        ((Standards.NACE2, "46.69"), (Standards.ISIC4, "4659")),
        ((Standards.NACE2, "46.7"), (Standards.ISIC4, "466")),
        ((Standards.NACE2, "46.71"), (Standards.ISIC4, "4661")),
        ((Standards.NACE2, "46.72"), (Standards.ISIC4, "4662")),
        ((Standards.NACE2, "46.73"), (Standards.ISIC4, "4663")),
        ((Standards.NACE2, "46.74"), (Standards.ISIC4, "4663")),
        ((Standards.NACE2, "46.75"), (Standards.ISIC4, "4669")),
        ((Standards.NACE2, "46.76"), (Standards.ISIC4, "4669")),
        ((Standards.NACE2, "46.77"), (Standards.ISIC4, "4669")),
        ((Standards.NACE2, "46.9"), (Standards.ISIC4, "469")),
        ((Standards.NACE2, "46.90"), (Standards.ISIC4, "4690")),
        ((Standards.NACE2, "47"), (Standards.ISIC4, "47")),
        ((Standards.NACE2, "47.1"), (Standards.ISIC4, "471")),
        ((Standards.NACE2, "47.11"), (Standards.ISIC4, "4711")),
        ((Standards.NACE2, "47.19"), (Standards.ISIC4, "4719")),
        ((Standards.NACE2, "47.2"), (Standards.ISIC4, "472")),
        ((Standards.NACE2, "47.21"), (Standards.ISIC4, "4721")),
        ((Standards.NACE2, "47.22"), (Standards.ISIC4, "4721")),
        ((Standards.NACE2, "47.23"), (Standards.ISIC4, "4721")),
        ((Standards.NACE2, "47.24"), (Standards.ISIC4, "4721")),
        ((Standards.NACE2, "47.25"), (Standards.ISIC4, "4722")),
        ((Standards.NACE2, "47.26"), (Standards.ISIC4, "4723")),
        ((Standards.NACE2, "47.29"), (Standards.ISIC4, "4721")),
        ((Standards.NACE2, "47.3"), (Standards.ISIC4, "473")),
        ((Standards.NACE2, "47.30"), (Standards.ISIC4, "4730")),
        ((Standards.NACE2, "47.4"), (Standards.ISIC4, "474")),
        ((Standards.NACE2, "47.41"), (Standards.ISIC4, "4741")),
        ((Standards.NACE2, "47.42"), (Standards.ISIC4, "4741")),
        ((Standards.NACE2, "47.43"), (Standards.ISIC4, "4742")),
        ((Standards.NACE2, "47.5"), (Standards.ISIC4, "475")),
        ((Standards.NACE2, "47.51"), (Standards.ISIC4, "4751")),
        ((Standards.NACE2, "47.52"), (Standards.ISIC4, "4752")),
        ((Standards.NACE2, "47.53"), (Standards.ISIC4, "4753")),
        ((Standards.NACE2, "47.54"), (Standards.ISIC4, "4759")),
        ((Standards.NACE2, "47.59"), (Standards.ISIC4, "4759")),
        ((Standards.NACE2, "47.6"), (Standards.ISIC4, "476")),
        ((Standards.NACE2, "47.61"), (Standards.ISIC4, "4761")),
        ((Standards.NACE2, "47.62"), (Standards.ISIC4, "4761")),
        ((Standards.NACE2, "47.63"), (Standards.ISIC4, "4762")),
        ((Standards.NACE2, "47.64"), (Standards.ISIC4, "4763")),
        ((Standards.NACE2, "47.65"), (Standards.ISIC4, "4764")),
        ((Standards.NACE2, "47.7"), (Standards.ISIC4, "477")),
        ((Standards.NACE2, "47.71"), (Standards.ISIC4, "4771")),
        ((Standards.NACE2, "47.72"), (Standards.ISIC4, "4771")),
        ((Standards.NACE2, "47.73"), (Standards.ISIC4, "4772")),
        ((Standards.NACE2, "47.74"), (Standards.ISIC4, "4772")),
        ((Standards.NACE2, "47.75"), (Standards.ISIC4, "4772")),
        ((Standards.NACE2, "47.76"), (Standards.ISIC4, "4773")),
        ((Standards.NACE2, "47.77"), (Standards.ISIC4, "4773")),
        ((Standards.NACE2, "47.78"), (Standards.ISIC4, "4773")),
        ((Standards.NACE2, "47.79"), (Standards.ISIC4, "4774")),
        ((Standards.NACE2, "47.8"), (Standards.ISIC4, "478")),
        ((Standards.NACE2, "47.81"), (Standards.ISIC4, "4781")),
        ((Standards.NACE2, "47.82"), (Standards.ISIC4, "4782")),
        ((Standards.NACE2, "47.89"), (Standards.ISIC4, "4789")),
        ((Standards.NACE2, "47.9"), (Standards.ISIC4, "479")),
        ((Standards.NACE2, "47.91"), (Standards.ISIC4, "4791")),
        ((Standards.NACE2, "47.99"), (Standards.ISIC4, "4799")),
        ((Standards.NACE2, "H"), (Standards.ISIC4, "H")),
        ((Standards.NACE2, "49"), (Standards.ISIC4, "49")),
        ((Standards.NACE2, "49.1"), (Standards.ISIC4, "491")),
        ((Standards.NACE2, "49.10"), (Standards.ISIC4, "4911")),
        ((Standards.NACE2, "49.2"), (Standards.ISIC4, "491")),
        ((Standards.NACE2, "49.20"), (Standards.ISIC4, "4912")),
        ((Standards.NACE2, "49.3"), (Standards.ISIC4, "492")),
        ((Standards.NACE2, "49.31"), (Standards.ISIC4, "4921")),
        ((Standards.NACE2, "49.32"), (Standards.ISIC4, "4922")),
        ((Standards.NACE2, "49.39"), (Standards.ISIC4, "4922")),
        ((Standards.NACE2, "49.4"), (Standards.ISIC4, "492")),
        ((Standards.NACE2, "49.41"), (Standards.ISIC4, "4923")),
        ((Standards.NACE2, "49.42"), (Standards.ISIC4, "4923")),
        ((Standards.NACE2, "49.5"), (Standards.ISIC4, "493")),
        ((Standards.NACE2, "49.50"), (Standards.ISIC4, "4930")),
        ((Standards.NACE2, "50"), (Standards.ISIC4, "50")),
        ((Standards.NACE2, "50.1"), (Standards.ISIC4, "501")),
        ((Standards.NACE2, "50.10"), (Standards.ISIC4, "5011")),
        ((Standards.NACE2, "50.2"), (Standards.ISIC4, "501")),
        ((Standards.NACE2, "50.20"), (Standards.ISIC4, "5012")),
        ((Standards.NACE2, "50.3"), (Standards.ISIC4, "502")),
        ((Standards.NACE2, "50.30"), (Standards.ISIC4, "5021")),
        ((Standards.NACE2, "50.4"), (Standards.ISIC4, "502")),
        ((Standards.NACE2, "50.40"), (Standards.ISIC4, "5022")),
        ((Standards.NACE2, "51"), (Standards.ISIC4, "51")),
        ((Standards.NACE2, "51.1"), (Standards.ISIC4, "511")),
        ((Standards.NACE2, "51.10"), (Standards.ISIC4, "5110")),
        ((Standards.NACE2, "51.2"), (Standards.ISIC4, "512")),
        ((Standards.NACE2, "51.21"), (Standards.ISIC4, "5120")),
        ((Standards.NACE2, "51.22"), (Standards.ISIC4, "5120")),
        ((Standards.NACE2, "52"), (Standards.ISIC4, "52")),
        ((Standards.NACE2, "52.1"), (Standards.ISIC4, "521")),
        ((Standards.NACE2, "52.10"), (Standards.ISIC4, "5210")),
        ((Standards.NACE2, "52.2"), (Standards.ISIC4, "522")),
        ((Standards.NACE2, "52.21"), (Standards.ISIC4, "5221")),
        ((Standards.NACE2, "52.22"), (Standards.ISIC4, "5222")),
        ((Standards.NACE2, "52.23"), (Standards.ISIC4, "5223")),
        ((Standards.NACE2, "52.24"), (Standards.ISIC4, "5224")),
        ((Standards.NACE2, "52.29"), (Standards.ISIC4, "5229")),
        ((Standards.NACE2, "53"), (Standards.ISIC4, "53")),
        ((Standards.NACE2, "53.1"), (Standards.ISIC4, "531")),
        ((Standards.NACE2, "53.10"), (Standards.ISIC4, "5310")),
        ((Standards.NACE2, "53.2"), (Standards.ISIC4, "532")),
        ((Standards.NACE2, "53.20"), (Standards.ISIC4, "5320")),
        ((Standards.NACE2, "I"), (Standards.ISIC4, "I")),
        ((Standards.NACE2, "55"), (Standards.ISIC4, "55")),
        ((Standards.NACE2, "55.1"), (Standards.ISIC4, "551")),
        ((Standards.NACE2, "55.10"), (Standards.ISIC4, "5510")),
        ((Standards.NACE2, "55.2"), (Standards.ISIC4, "551")),
        ((Standards.NACE2, "55.20"), (Standards.ISIC4, "5510")),
        ((Standards.NACE2, "55.3"), (Standards.ISIC4, "552")),
        ((Standards.NACE2, "55.30"), (Standards.ISIC4, "5520")),
        ((Standards.NACE2, "55.9"), (Standards.ISIC4, "559")),
        ((Standards.NACE2, "55.90"), (Standards.ISIC4, "5590")),
        ((Standards.NACE2, "56"), (Standards.ISIC4, "56")),
        ((Standards.NACE2, "56.1"), (Standards.ISIC4, "561")),
        ((Standards.NACE2, "56.10"), (Standards.ISIC4, "5610")),
        ((Standards.NACE2, "56.2"), (Standards.ISIC4, "562")),
        ((Standards.NACE2, "56.21"), (Standards.ISIC4, "5621")),
        ((Standards.NACE2, "56.29"), (Standards.ISIC4, "5629")),
        ((Standards.NACE2, "56.3"), (Standards.ISIC4, "563")),
        ((Standards.NACE2, "56.30"), (Standards.ISIC4, "5630")),
        ((Standards.NACE2, "J"), (Standards.ISIC4, "J")),
        ((Standards.NACE2, "58"), (Standards.ISIC4, "58")),
        ((Standards.NACE2, "58.1"), (Standards.ISIC4, "581")),
        ((Standards.NACE2, "58.11"), (Standards.ISIC4, "5811")),
        ((Standards.NACE2, "58.12"), (Standards.ISIC4, "5812")),
        ((Standards.NACE2, "58.13"), (Standards.ISIC4, "5813")),
        ((Standards.NACE2, "58.14"), (Standards.ISIC4, "5813")),
        ((Standards.NACE2, "58.19"), (Standards.ISIC4, "5819")),
        ((Standards.NACE2, "58.2"), (Standards.ISIC4, "582")),
        ((Standards.NACE2, "58.21"), (Standards.ISIC4, "5820")),
        ((Standards.NACE2, "58.29"), (Standards.ISIC4, "5820")),
        ((Standards.NACE2, "59"), (Standards.ISIC4, "59")),
        ((Standards.NACE2, "59.1"), (Standards.ISIC4, "591")),
        ((Standards.NACE2, "59.11"), (Standards.ISIC4, "5911")),
        ((Standards.NACE2, "59.12"), (Standards.ISIC4, "5912")),
        ((Standards.NACE2, "59.13"), (Standards.ISIC4, "5913")),
        ((Standards.NACE2, "59.14"), (Standards.ISIC4, "5914")),
        ((Standards.NACE2, "59.2"), (Standards.ISIC4, "592")),
        ((Standards.NACE2, "59.20"), (Standards.ISIC4, "5920")),
        ((Standards.NACE2, "60"), (Standards.ISIC4, "60")),
        ((Standards.NACE2, "60.1"), (Standards.ISIC4, "601")),
        ((Standards.NACE2, "60.10"), (Standards.ISIC4, "6010")),
        ((Standards.NACE2, "60.2"), (Standards.ISIC4, "602")),
        ((Standards.NACE2, "60.20"), (Standards.ISIC4, "6020")),
        ((Standards.NACE2, "61"), (Standards.ISIC4, "61")),
        ((Standards.NACE2, "61.1"), (Standards.ISIC4, "611")),
        ((Standards.NACE2, "61.10"), (Standards.ISIC4, "6110")),
        ((Standards.NACE2, "61.2"), (Standards.ISIC4, "612")),
        ((Standards.NACE2, "61.20"), (Standards.ISIC4, "6120")),
        ((Standards.NACE2, "61.3"), (Standards.ISIC4, "613")),
        ((Standards.NACE2, "61.30"), (Standards.ISIC4, "6130")),
        ((Standards.NACE2, "61.9"), (Standards.ISIC4, "619")),
        ((Standards.NACE2, "61.90"), (Standards.ISIC4, "6190")),
        ((Standards.NACE2, "62"), (Standards.ISIC4, "62")),
        ((Standards.NACE2, "62.0"), (Standards.ISIC4, "620")),
        ((Standards.NACE2, "62.01"), (Standards.ISIC4, "6201")),
        ((Standards.NACE2, "62.02"), (Standards.ISIC4, "6202")),
        ((Standards.NACE2, "62.03"), (Standards.ISIC4, "6202")),
        ((Standards.NACE2, "62.09"), (Standards.ISIC4, "6209")),
        ((Standards.NACE2, "63"), (Standards.ISIC4, "63")),
        ((Standards.NACE2, "63.1"), (Standards.ISIC4, "631")),
        ((Standards.NACE2, "63.11"), (Standards.ISIC4, "6311")),
        ((Standards.NACE2, "63.12"), (Standards.ISIC4, "6312")),
        ((Standards.NACE2, "63.9"), (Standards.ISIC4, "639")),
        ((Standards.NACE2, "63.91"), (Standards.ISIC4, "6391")),
        ((Standards.NACE2, "63.99"), (Standards.ISIC4, "6399")),
        ((Standards.NACE2, "K"), (Standards.ISIC4, "K")),
        ((Standards.NACE2, "64"), (Standards.ISIC4, "64")),
        ((Standards.NACE2, "64.1"), (Standards.ISIC4, "641")),
        ((Standards.NACE2, "64.11"), (Standards.ISIC4, "6411")),
        ((Standards.NACE2, "64.19"), (Standards.ISIC4, "6419")),
        ((Standards.NACE2, "64.2"), (Standards.ISIC4, "642")),
        ((Standards.NACE2, "64.20"), (Standards.ISIC4, "6420")),
        ((Standards.NACE2, "64.3"), (Standards.ISIC4, "643")),
        ((Standards.NACE2, "64.30"), (Standards.ISIC4, "6430")),
        ((Standards.NACE2, "64.9"), (Standards.ISIC4, "649")),
        ((Standards.NACE2, "64.91"), (Standards.ISIC4, "6491")),
        ((Standards.NACE2, "64.92"), (Standards.ISIC4, "6492")),
        ((Standards.NACE2, "64.99"), (Standards.ISIC4, "6499")),
        ((Standards.NACE2, "65"), (Standards.ISIC4, "65")),
        ((Standards.NACE2, "65.1"), (Standards.ISIC4, "651")),
        ((Standards.NACE2, "65.11"), (Standards.ISIC4, "6511")),
        ((Standards.NACE2, "65.12"), (Standards.ISIC4, "6512")),
        ((Standards.NACE2, "65.2"), (Standards.ISIC4, "652")),
        ((Standards.NACE2, "65.20"), (Standards.ISIC4, "6520")),
        ((Standards.NACE2, "65.3"), (Standards.ISIC4, "653")),
        ((Standards.NACE2, "65.30"), (Standards.ISIC4, "6530")),
        ((Standards.NACE2, "66"), (Standards.ISIC4, "66")),
        ((Standards.NACE2, "66.1"), (Standards.ISIC4, "661")),
        ((Standards.NACE2, "66.11"), (Standards.ISIC4, "6611")),
        ((Standards.NACE2, "66.12"), (Standards.ISIC4, "6612")),
        ((Standards.NACE2, "66.19"), (Standards.ISIC4, "6619")),
        ((Standards.NACE2, "66.2"), (Standards.ISIC4, "662")),
        ((Standards.NACE2, "66.21"), (Standards.ISIC4, "6621")),
        ((Standards.NACE2, "66.22"), (Standards.ISIC4, "6622")),
        ((Standards.NACE2, "66.29"), (Standards.ISIC4, "6629")),
        ((Standards.NACE2, "66.3"), (Standards.ISIC4, "663")),
        ((Standards.NACE2, "66.30"), (Standards.ISIC4, "6630")),
        ((Standards.NACE2, "L"), (Standards.ISIC4, "L")),
        ((Standards.NACE2, "68"), (Standards.ISIC4, "68")),
        ((Standards.NACE2, "68.1"), (Standards.ISIC4, "681")),
        ((Standards.NACE2, "68.10"), (Standards.ISIC4, "6810")),
        ((Standards.NACE2, "68.2"), (Standards.ISIC4, "681")),
        ((Standards.NACE2, "68.20"), (Standards.ISIC4, "6810")),
        ((Standards.NACE2, "68.3"), (Standards.ISIC4, "682")),
        ((Standards.NACE2, "68.31"), (Standards.ISIC4, "6820")),
        ((Standards.NACE2, "68.32"), (Standards.ISIC4, "6820")),
        ((Standards.NACE2, "M"), (Standards.ISIC4, "M")),
        ((Standards.NACE2, "69"), (Standards.ISIC4, "69")),
        ((Standards.NACE2, "69.1"), (Standards.ISIC4, "691")),
        ((Standards.NACE2, "69.10"), (Standards.ISIC4, "6910")),
        ((Standards.NACE2, "69.2"), (Standards.ISIC4, "692")),
        ((Standards.NACE2, "69.20"), (Standards.ISIC4, "6920")),
        ((Standards.NACE2, "70"), (Standards.ISIC4, "70")),
        ((Standards.NACE2, "70.1"), (Standards.ISIC4, "701")),
        ((Standards.NACE2, "70.10"), (Standards.ISIC4, "7010")),
        ((Standards.NACE2, "70.2"), (Standards.ISIC4, "702")),
        ((Standards.NACE2, "70.21"), (Standards.ISIC4, "7020")),
        ((Standards.NACE2, "70.22"), (Standards.ISIC4, "7020")),
        ((Standards.NACE2, "71"), (Standards.ISIC4, "71")),
        ((Standards.NACE2, "71.1"), (Standards.ISIC4, "711")),
        ((Standards.NACE2, "71.11"), (Standards.ISIC4, "7110")),
        ((Standards.NACE2, "71.12"), (Standards.ISIC4, "7110")),
        ((Standards.NACE2, "71.2"), (Standards.ISIC4, "712")),
        ((Standards.NACE2, "71.20"), (Standards.ISIC4, "7120")),
        ((Standards.NACE2, "72"), (Standards.ISIC4, "72")),
        ((Standards.NACE2, "72.1"), (Standards.ISIC4, "721")),
        ((Standards.NACE2, "72.11"), (Standards.ISIC4, "7210")),
        ((Standards.NACE2, "72.19"), (Standards.ISIC4, "7210")),
        ((Standards.NACE2, "72.2"), (Standards.ISIC4, "722")),
        ((Standards.NACE2, "72.20"), (Standards.ISIC4, "7220")),
        ((Standards.NACE2, "73"), (Standards.ISIC4, "73")),
        ((Standards.NACE2, "73.1"), (Standards.ISIC4, "731")),
        ((Standards.NACE2, "73.11"), (Standards.ISIC4, "7310")),
        ((Standards.NACE2, "73.12"), (Standards.ISIC4, "7310")),
        ((Standards.NACE2, "73.2"), (Standards.ISIC4, "732")),
        ((Standards.NACE2, "73.20"), (Standards.ISIC4, "7320")),
        ((Standards.NACE2, "74"), (Standards.ISIC4, "74")),
        ((Standards.NACE2, "74.1"), (Standards.ISIC4, "741")),
        ((Standards.NACE2, "74.10"), (Standards.ISIC4, "7410")),
        ((Standards.NACE2, "74.2"), (Standards.ISIC4, "742")),
        ((Standards.NACE2, "74.20"), (Standards.ISIC4, "7420")),
        ((Standards.NACE2, "74.3"), (Standards.ISIC4, "749")),
        ((Standards.NACE2, "74.30"), (Standards.ISIC4, "7490")),
        ((Standards.NACE2, "74.9"), (Standards.ISIC4, "749")),
        ((Standards.NACE2, "74.90"), (Standards.ISIC4, "7490")),
        ((Standards.NACE2, "75"), (Standards.ISIC4, "75")),
        ((Standards.NACE2, "75.0"), (Standards.ISIC4, "750")),
        ((Standards.NACE2, "75.00"), (Standards.ISIC4, "7500")),
        ((Standards.NACE2, "N"), (Standards.ISIC4, "N")),
        ((Standards.NACE2, "77"), (Standards.ISIC4, "77")),
        ((Standards.NACE2, "77.1"), (Standards.ISIC4, "771")),
        ((Standards.NACE2, "77.11"), (Standards.ISIC4, "7710")),
        ((Standards.NACE2, "77.12"), (Standards.ISIC4, "7710")),
        ((Standards.NACE2, "77.2"), (Standards.ISIC4, "772")),
        ((Standards.NACE2, "77.21"), (Standards.ISIC4, "7721")),
        ((Standards.NACE2, "77.22"), (Standards.ISIC4, "7722")),
        ((Standards.NACE2, "77.29"), (Standards.ISIC4, "7729")),
        ((Standards.NACE2, "77.3"), (Standards.ISIC4, "773")),
        ((Standards.NACE2, "77.31"), (Standards.ISIC4, "7730")),
        ((Standards.NACE2, "77.32"), (Standards.ISIC4, "7730")),
        ((Standards.NACE2, "77.33"), (Standards.ISIC4, "7730")),
        ((Standards.NACE2, "77.34"), (Standards.ISIC4, "7730")),
        ((Standards.NACE2, "77.35"), (Standards.ISIC4, "7730")),
        ((Standards.NACE2, "77.39"), (Standards.ISIC4, "7730")),
        ((Standards.NACE2, "77.4"), (Standards.ISIC4, "774")),
        ((Standards.NACE2, "77.40"), (Standards.ISIC4, "7740")),
        ((Standards.NACE2, "78"), (Standards.ISIC4, "78")),
        ((Standards.NACE2, "78.1"), (Standards.ISIC4, "781")),
        ((Standards.NACE2, "78.10"), (Standards.ISIC4, "7810")),
        ((Standards.NACE2, "78.2"), (Standards.ISIC4, "782")),
        ((Standards.NACE2, "78.20"), (Standards.ISIC4, "7820")),
        ((Standards.NACE2, "78.3"), (Standards.ISIC4, "783")),
        ((Standards.NACE2, "78.30"), (Standards.ISIC4, "7830")),
        ((Standards.NACE2, "79"), (Standards.ISIC4, "79")),
        ((Standards.NACE2, "79.1"), (Standards.ISIC4, "791")),
        ((Standards.NACE2, "79.11"), (Standards.ISIC4, "7911")),
        ((Standards.NACE2, "79.12"), (Standards.ISIC4, "7912")),
        ((Standards.NACE2, "79.9"), (Standards.ISIC4, "799")),
        ((Standards.NACE2, "79.90"), (Standards.ISIC4, "7990")),
        ((Standards.NACE2, "80"), (Standards.ISIC4, "80")),
        ((Standards.NACE2, "80.1"), (Standards.ISIC4, "801")),
        ((Standards.NACE2, "80.10"), (Standards.ISIC4, "8010")),
        ((Standards.NACE2, "80.2"), (Standards.ISIC4, "802")),
        ((Standards.NACE2, "80.20"), (Standards.ISIC4, "8020")),
        ((Standards.NACE2, "80.3"), (Standards.ISIC4, "803")),
        ((Standards.NACE2, "80.30"), (Standards.ISIC4, "8030")),
        ((Standards.NACE2, "81"), (Standards.ISIC4, "81")),
        ((Standards.NACE2, "81.1"), (Standards.ISIC4, "811")),
        ((Standards.NACE2, "81.10"), (Standards.ISIC4, "8110")),
        ((Standards.NACE2, "81.2"), (Standards.ISIC4, "812")),
        ((Standards.NACE2, "81.21"), (Standards.ISIC4, "8121")),
        ((Standards.NACE2, "81.22"), (Standards.ISIC4, "8129")),
        ((Standards.NACE2, "81.29"), (Standards.ISIC4, "8129")),
        ((Standards.NACE2, "81.3"), (Standards.ISIC4, "813")),
        ((Standards.NACE2, "81.30"), (Standards.ISIC4, "8130")),
        ((Standards.NACE2, "82"), (Standards.ISIC4, "82")),
        ((Standards.NACE2, "82.1"), (Standards.ISIC4, "821")),
        ((Standards.NACE2, "82.11"), (Standards.ISIC4, "8211")),
        ((Standards.NACE2, "82.19"), (Standards.ISIC4, "8219")),
        ((Standards.NACE2, "82.2"), (Standards.ISIC4, "822")),
        ((Standards.NACE2, "82.20"), (Standards.ISIC4, "8220")),
        ((Standards.NACE2, "82.3"), (Standards.ISIC4, "823")),
        ((Standards.NACE2, "82.30"), (Standards.ISIC4, "8230")),
        ((Standards.NACE2, "82.9"), (Standards.ISIC4, "829")),
        ((Standards.NACE2, "82.91"), (Standards.ISIC4, "8291")),
        ((Standards.NACE2, "82.92"), (Standards.ISIC4, "8292")),
        ((Standards.NACE2, "82.99"), (Standards.ISIC4, "8299")),
        ((Standards.NACE2, "O"), (Standards.ISIC4, "O")),
        ((Standards.NACE2, "84"), (Standards.ISIC4, "84")),
        ((Standards.NACE2, "84.1"), (Standards.ISIC4, "841")),
        ((Standards.NACE2, "84.11"), (Standards.ISIC4, "8411")),
        ((Standards.NACE2, "84.12"), (Standards.ISIC4, "8412")),
        ((Standards.NACE2, "84.13"), (Standards.ISIC4, "8413")),
        ((Standards.NACE2, "84.2"), (Standards.ISIC4, "842")),
        ((Standards.NACE2, "84.21"), (Standards.ISIC4, "8421")),
        ((Standards.NACE2, "84.22"), (Standards.ISIC4, "8422")),
        ((Standards.NACE2, "84.23"), (Standards.ISIC4, "8423")),
        ((Standards.NACE2, "84.24"), (Standards.ISIC4, "8423")),
        ((Standards.NACE2, "84.25"), (Standards.ISIC4, "8423")),
        ((Standards.NACE2, "84.3"), (Standards.ISIC4, "843")),
        ((Standards.NACE2, "84.30"), (Standards.ISIC4, "8430")),
        ((Standards.NACE2, "P"), (Standards.ISIC4, "P")),
        ((Standards.NACE2, "85"), (Standards.ISIC4, "85")),
        ((Standards.NACE2, "85.1"), (Standards.ISIC4, "851")),
        ((Standards.NACE2, "85.10"), (Standards.ISIC4, "8510")),
        ((Standards.NACE2, "85.2"), (Standards.ISIC4, "851")),
        ((Standards.NACE2, "85.20"), (Standards.ISIC4, "8510")),
        ((Standards.NACE2, "85.3"), (Standards.ISIC4, "852")),
        ((Standards.NACE2, "85.31"), (Standards.ISIC4, "8521")),
        ((Standards.NACE2, "85.32"), (Standards.ISIC4, "8522")),
        ((Standards.NACE2, "85.4"), (Standards.ISIC4, "853")),
        ((Standards.NACE2, "85.41"), (Standards.ISIC4, "8530")),
        ((Standards.NACE2, "85.42"), (Standards.ISIC4, "8530")),
        ((Standards.NACE2, "85.5"), (Standards.ISIC4, "854")),
        ((Standards.NACE2, "85.51"), (Standards.ISIC4, "8541")),
        ((Standards.NACE2, "85.52"), (Standards.ISIC4, "8542")),
        ((Standards.NACE2, "85.53"), (Standards.ISIC4, "8549")),
        ((Standards.NACE2, "85.59"), (Standards.ISIC4, "8549")),
        ((Standards.NACE2, "85.6"), (Standards.ISIC4, "855")),
        ((Standards.NACE2, "85.60"), (Standards.ISIC4, "8550")),
        ((Standards.NACE2, "Q"), (Standards.ISIC4, "Q")),
        ((Standards.NACE2, "86"), (Standards.ISIC4, "86")),
        ((Standards.NACE2, "86.1"), (Standards.ISIC4, "861")),
        ((Standards.NACE2, "86.10"), (Standards.ISIC4, "8610")),
        ((Standards.NACE2, "86.2"), (Standards.ISIC4, "862")),
        ((Standards.NACE2, "86.21"), (Standards.ISIC4, "8620")),
        ((Standards.NACE2, "86.22"), (Standards.ISIC4, "8620")),
        ((Standards.NACE2, "86.23"), (Standards.ISIC4, "8620")),
        ((Standards.NACE2, "86.9"), (Standards.ISIC4, "869")),
        ((Standards.NACE2, "86.90"), (Standards.ISIC4, "8690")),
        ((Standards.NACE2, "87"), (Standards.ISIC4, "87")),
        ((Standards.NACE2, "87.1"), (Standards.ISIC4, "871")),
        ((Standards.NACE2, "87.10"), (Standards.ISIC4, "8710")),
        ((Standards.NACE2, "87.2"), (Standards.ISIC4, "872")),
        ((Standards.NACE2, "87.20"), (Standards.ISIC4, "8720")),
        ((Standards.NACE2, "87.3"), (Standards.ISIC4, "873")),
        ((Standards.NACE2, "87.30"), (Standards.ISIC4, "8730")),
        ((Standards.NACE2, "87.9"), (Standards.ISIC4, "879")),
        ((Standards.NACE2, "87.90"), (Standards.ISIC4, "8790")),
        ((Standards.NACE2, "88"), (Standards.ISIC4, "88")),
        ((Standards.NACE2, "88.1"), (Standards.ISIC4, "881")),
        ((Standards.NACE2, "88.10"), (Standards.ISIC4, "8810")),
        ((Standards.NACE2, "88.9"), (Standards.ISIC4, "889")),
        ((Standards.NACE2, "88.91"), (Standards.ISIC4, "8890")),
        ((Standards.NACE2, "88.99"), (Standards.ISIC4, "8890")),
        ((Standards.NACE2, "R"), (Standards.ISIC4, "R")),
        ((Standards.NACE2, "90"), (Standards.ISIC4, "90")),
        ((Standards.NACE2, "90.0"), (Standards.ISIC4, "900")),
        ((Standards.NACE2, "90.01"), (Standards.ISIC4, "9000")),
        ((Standards.NACE2, "90.02"), (Standards.ISIC4, "9000")),
        ((Standards.NACE2, "90.03"), (Standards.ISIC4, "9000")),
        ((Standards.NACE2, "90.04"), (Standards.ISIC4, "9000")),
        ((Standards.NACE2, "91"), (Standards.ISIC4, "91")),
        ((Standards.NACE2, "91.0"), (Standards.ISIC4, "910")),
        ((Standards.NACE2, "91.01"), (Standards.ISIC4, "9101")),
        ((Standards.NACE2, "91.02"), (Standards.ISIC4, "9102")),
        ((Standards.NACE2, "91.03"), (Standards.ISIC4, "9102")),
        ((Standards.NACE2, "91.04"), (Standards.ISIC4, "9103")),
        ((Standards.NACE2, "92"), (Standards.ISIC4, "92")),
        ((Standards.NACE2, "92.0"), (Standards.ISIC4, "920")),
        ((Standards.NACE2, "92.00"), (Standards.ISIC4, "9200")),
        ((Standards.NACE2, "93"), (Standards.ISIC4, "93")),
        ((Standards.NACE2, "93.1"), (Standards.ISIC4, "931")),
        ((Standards.NACE2, "93.11"), (Standards.ISIC4, "9311")),
        ((Standards.NACE2, "93.12"), (Standards.ISIC4, "9312")),
        ((Standards.NACE2, "93.13"), (Standards.ISIC4, "9311")),
        ((Standards.NACE2, "93.19"), (Standards.ISIC4, "9319")),
        ((Standards.NACE2, "93.2"), (Standards.ISIC4, "932")),
        ((Standards.NACE2, "93.21"), (Standards.ISIC4, "9321")),
        ((Standards.NACE2, "93.29"), (Standards.ISIC4, "9329")),
        ((Standards.NACE2, "S"), (Standards.ISIC4, "S")),
        ((Standards.NACE2, "94"), (Standards.ISIC4, "94")),
        ((Standards.NACE2, "94.1"), (Standards.ISIC4, "941")),
        ((Standards.NACE2, "94.11"), (Standards.ISIC4, "9411")),
        ((Standards.NACE2, "94.12"), (Standards.ISIC4, "9412")),
        ((Standards.NACE2, "94.2"), (Standards.ISIC4, "942")),
        ((Standards.NACE2, "94.20"), (Standards.ISIC4, "9420")),
        ((Standards.NACE2, "94.9"), (Standards.ISIC4, "949")),
        ((Standards.NACE2, "94.91"), (Standards.ISIC4, "9491")),
        ((Standards.NACE2, "94.92"), (Standards.ISIC4, "9492")),
        ((Standards.NACE2, "94.99"), (Standards.ISIC4, "9499")),
        ((Standards.NACE2, "95"), (Standards.ISIC4, "95")),
        ((Standards.NACE2, "95.1"), (Standards.ISIC4, "951")),
        ((Standards.NACE2, "95.11"), (Standards.ISIC4, "9511")),
        ((Standards.NACE2, "95.12"), (Standards.ISIC4, "9512")),
        ((Standards.NACE2, "95.2"), (Standards.ISIC4, "952")),
        ((Standards.NACE2, "95.21"), (Standards.ISIC4, "9521")),
        ((Standards.NACE2, "95.22"), (Standards.ISIC4, "9522")),
        ((Standards.NACE2, "95.23"), (Standards.ISIC4, "9523")),
        ((Standards.NACE2, "95.24"), (Standards.ISIC4, "9524")),
        ((Standards.NACE2, "95.25"), (Standards.ISIC4, "9529")),
        ((Standards.NACE2, "95.29"), (Standards.ISIC4, "9529")),
        ((Standards.NACE2, "96"), (Standards.ISIC4, "96")),
        ((Standards.NACE2, "96.0"), (Standards.ISIC4, "960")),
        ((Standards.NACE2, "96.01"), (Standards.ISIC4, "9601")),
        ((Standards.NACE2, "96.02"), (Standards.ISIC4, "9602")),
        ((Standards.NACE2, "96.03"), (Standards.ISIC4, "9603")),
        ((Standards.NACE2, "96.04"), (Standards.ISIC4, "9609")),
        ((Standards.NACE2, "96.09"), (Standards.ISIC4, "9609")),
        ((Standards.NACE2, "T"), (Standards.ISIC4, "T")),
        ((Standards.NACE2, "97"), (Standards.ISIC4, "97")),
        ((Standards.NACE2, "97.0"), (Standards.ISIC4, "970")),
        ((Standards.NACE2, "97.00"), (Standards.ISIC4, "9700")),
        ((Standards.NACE2, "98"), (Standards.ISIC4, "98")),
        ((Standards.NACE2, "98.1"), (Standards.ISIC4, "981")),
        ((Standards.NACE2, "98.10"), (Standards.ISIC4, "9810")),
        ((Standards.NACE2, "98.2"), (Standards.ISIC4, "982")),
        ((Standards.NACE2, "98.20"), (Standards.ISIC4, "9820")),
        ((Standards.NACE2, "U"), (Standards.ISIC4, "U")),
        ((Standards.NACE2, "99"), (Standards.ISIC4, "99")),
        ((Standards.NACE2, "99.0"), (Standards.ISIC4, "990")),
        ((Standards.NACE2, "99.00"), (Standards.ISIC4, "9900")),
    ],
)
