"""`NACE1 Standard <https://ec.europa.eu/eurostat/documents/1965800/1978760/Copy+of+5225C5EEBF016050E0440003BA9322F9.xls/6e1aec88-f15b-4d0f-bccc-4ee505c7f810>`_.
"""
from ...types import Category, Classification, Standard, Standards

NACE1 = Standard(
    standard=Standards.NACE1,
    classes=[
        Classification("01.11", "Growing of cereals and other crops n.e.c.", Category.CLASS),
        Classification(
            "01.12", "Growing of vegetables, horticultural specialities and nursery products", Category.CLASS
        ),
        Classification("01.13", "Growing of fruit, nuts, beverage and spice crops", Category.CLASS),
        Classification("01.21", "Farming of cattle, dairy farming", Category.CLASS),
        Classification("01.22", "Farming of sheep, goats, horses, asses, mules and hinnies", Category.CLASS),
        Classification("01.23", "Farming of swine", Category.CLASS),
        Classification("01.24", "Farming of poultry", Category.CLASS),
        Classification("01.25", "Other farming of animals", Category.CLASS),
        Classification("01.3", "Growing of crops combined with farming of animals (mixed farming)", Category.GROUP),
        Classification("01.41", "Agricultural service activities; landscape gardening", Category.CLASS),
        Classification("01.42", "Animal husbandry service activities, except veterinary activities", Category.CLASS),
        Classification(
            "01.5", "Hunting, trapping and game propagation, including related service activities", Category.GROUP
        ),
        Classification("02.01", "Forestry and logging", Category.CLASS),
        Classification("02.02", "Forestry and logging related service activities", Category.CLASS),
        Classification("05.01", "Fishing", Category.CLASS),
        Classification("05.02", " Fish farming", Category.CLASS),
        Classification("10.1", "Mining and agglomeration of hard coal", Category.GROUP),
        Classification("10.2", "Mining and agglomeration of lignite", Category.GROUP),
        Classification("10.3", "Extraction and agglomeration of peat", Category.GROUP),
        Classification("11.1", "Extraction of crude petroleum and natural gas", Category.GROUP),
        Classification(
            "11.2", "Service activities incidental to oil and gas extraction, excluding surveying", Category.GROUP
        ),
        Classification("12", "Mining of uranium and thorium ores", Category.DIVISION),
        Classification("13.1", "Mining of iron ores", Category.GROUP),
        Classification("13.2", "Mining of non-ferrous metal ores, except uranium and thorium ores", Category.GROUP),
        Classification("14.11", "Quarrying of  ornamental and building stone", Category.CLASS),
        Classification("14.12", "Quarrying of limestone, gypsum and chalk", Category.CLASS),
        Classification("14.13", "Quarrying of slate", Category.CLASS),
        Classification("14.21", "Operation of gravel and sand pits", Category.CLASS),
        Classification("14.22", "Mining of clays and kaolin", Category.CLASS),
        Classification("14.3", "Mining of chemical and fertilizer minerals", Category.GROUP),
        Classification("14.4", "Production of salt", Category.GROUP),
        Classification("14.5", "Other mining and quarrying n.e.c.", Category.GROUP),
        Classification("15.11", "Production and preserving of meat", Category.CLASS),
        Classification("15.12", "Production and preserving of poultrymeat", Category.CLASS),
        Classification("15.13", "Production of meat and poultrymeat products", Category.CLASS),
        Classification("15.2", "Processing and preserving of fish and fish products", Category.GROUP),
        Classification("15.31", "Processing and preserving of potatoes", Category.CLASS),
        Classification("15.32", "Manufacture of fruit and vegetable juice", Category.CLASS),
        Classification("15.33", "Processing and preserving of fruit and vegetables n.e.c.", Category.CLASS),
        Classification("15.41", "Manufacture of crude oils and fats", Category.CLASS),
        Classification("15.42", "Manufacture of refined oils and fats", Category.CLASS),
        Classification("15.43", "Manufacture of margarine and similar edible fats", Category.CLASS),
        Classification("15.51", "Operation of dairies and cheese making", Category.CLASS),
        Classification("15.52", "Manufacture of ice cream", Category.CLASS),
        Classification("15.61", "Manufacture of grain mill products", Category.CLASS),
        Classification("15.62", "Manufacture of starches and starch products", Category.CLASS),
        Classification("15.71", "Manufacture of prepared feeds for farm animals", Category.CLASS),
        Classification("15.72", "Manufacture of prepared pet foods", Category.CLASS),
        Classification("15.81", "Manufacture of bread; manufacture of fresh pastry goods and cakes", Category.CLASS),
        Classification(
            "15.82",
            "Manufacture of rusks and biscuits; manufacture of preserved pastry goods and cakes",
            Category.CLASS,
        ),
        Classification("15.83", "Manufacture of sugar", Category.CLASS),
        Classification("15.84", "Manufacture of cocoa; chocolate and sugar confectionery", Category.CLASS),
        Classification(
            "15.85", "Manufacture of macaroni, noodles, couscous and similar farinaceous products", Category.CLASS
        ),
        Classification("15.86", "Processing of tea and coffee", Category.CLASS),
        Classification("15.87", "Manufacture of condiments and seasonings", Category.CLASS),
        Classification("15.88", "Manufacture of homogenised food preparations and dietetic food", Category.CLASS),
        Classification("15.89", "Manufacture of other food products n.e.c.", Category.CLASS),
        Classification("15.91", "Manufacture of distilled potable alcoholic beverages", Category.CLASS),
        Classification("15.92", "Production of ethyl alcohol from fermented materials", Category.CLASS),
        Classification("15.93", "Manufacture of wines", Category.CLASS),
        Classification("15.94", "Manufacture of cider and other fruit wines", Category.CLASS),
        Classification("15.95", "Manufacture of other non-distilled fermented beverages", Category.CLASS),
        Classification("15.96", "Manufacture of beer", Category.CLASS),
        Classification("15.97", "Manufacture of malt", Category.CLASS),
        Classification("15.98", "Production of mineral waters and soft drinks", Category.CLASS),
        Classification("16", "Manufacture of tobacco products", Category.DIVISION),
        Classification("17.11", "Preparation and spinning of cotton-type fibres", Category.CLASS),
        Classification("17.12", "Preparation and spinning of woollen-type fibres", Category.CLASS),
        Classification("17.13", "Preparation and spinning of worsted-type fibres", Category.CLASS),
        Classification("17.14", "Preparation and spinning of flax-type fibres", Category.CLASS),
        Classification(
            "17.15",
            "Throwing and preparation of silk, including from noils, and throwing and texturing of synthetic or artificial filament yarns",
            Category.CLASS,
        ),
        Classification("17.16", "Manufacture of sewing threads", Category.CLASS),
        Classification("17.17", "Preparation and spinning of other textile fibres", Category.CLASS),
        Classification("17.21", "Cotton-type weaving", Category.CLASS),
        Classification("17.22", "Woollen-type weaving", Category.CLASS),
        Classification("17.23", "Worsted-type weaving", Category.CLASS),
        Classification("17.24", "Silk-type weaving", Category.CLASS),
        Classification("17.25", "Other textile weaving", Category.CLASS),
        Classification("17.3", "Finishing of textiles", Category.GROUP),
        Classification("17.4", "Manufacture of made-up textile articles, except apparel", Category.GROUP),
        Classification("17.51", "Manufacture of carpets and rugs", Category.CLASS),
        Classification("17.52", "Manufacture of cordage, rope, twine and netting", Category.CLASS),
        Classification(
            "17.53", "Manufacture of non-wovens and articles made from non-wovens, except apparel", Category.CLASS
        ),
        Classification("17.54", "Manufacture of other textiles n.e.c.", Category.CLASS),
        Classification("17.6", "Manufacture of knitted and crocheted fabrics", Category.GROUP),
        Classification("17.71", "Manufacture of knitted and crocheted hosiery", Category.CLASS),
        Classification(
            "17.72", "Manufacture of knitted and crocheted pullovers, cardigans and similar articles", Category.CLASS
        ),
        Classification("18.1", "Manufacture of leather clothes", Category.GROUP),
        Classification("18.21", "Manufacture of workwear", Category.CLASS),
        Classification("18.22", "Manufacture of other outerwear", Category.CLASS),
        Classification("18.23", "Manufacture of underwear", Category.CLASS),
        Classification("18.24", "Manufacture of other wearing apparel and accessories n.e.c.", Category.CLASS),
        Classification("18.3", "Dressing and dyeing of fur; manufacture of articles of fur", Category.GROUP),
        Classification("19.1", "Tanning and dressing of leather", Category.GROUP),
        Classification("19.2", "Manufacture of luggage, handbags and the like, saddlery and harness", Category.GROUP),
        Classification("19.3", "Manufacture of footwear", Category.GROUP),
        Classification("20.1", "Sawmilling and planing of wood; impregnation of wood", Category.GROUP),
        Classification(
            "20.2",
            "Manufacture of veneer sheets; manufacture of plywood, laminboard, particle board, fibre board and other panels and boards",
            Category.GROUP,
        ),
        Classification("20.3", "Manufacture of builders' carpentry and joinery", Category.GROUP),
        Classification("20.4", "Manufacture of wooden containers", Category.GROUP),
        Classification("20.51", "Manufacture of other products of wood", Category.CLASS),
        Classification("20.52", "Manufacture of articles of cork, straw and plaiting materials", Category.CLASS),
        Classification("21.11", "Manufacture of pulp", Category.CLASS),
        Classification("21.12", "Manufacture of paper and paperboard", Category.CLASS),
        Classification(
            "21.21",
            "Manufacture of corrugated paper and paperboard and of containers of paper and paperboard",
            Category.CLASS,
        ),
        Classification("21.22", "Manufacture of household and sanitary goods and of toilet requisites", Category.CLASS),
        Classification("21.23", "Manufacture of paper stationery", Category.CLASS),
        Classification("21.24", "Manufacture of wallpaper", Category.CLASS),
        Classification("21.25", "Manufacture of other articles of paper and paperboard n.e.c.", Category.CLASS),
        Classification("22.11", "Publishing of books", Category.CLASS),
        Classification("22.12", "Publishing of newspapers", Category.CLASS),
        Classification("22.13", "Publishing of journals and periodicals", Category.CLASS),
        Classification("22.14", "Publishing of sound recordings", Category.CLASS),
        Classification("22.15", "Other publishing", Category.CLASS),
        Classification("22.21", "Printing of newspapers", Category.CLASS),
        Classification("22.22", "Printing n.e.c.", Category.CLASS),
        Classification("22.23", "Bookbinding ", Category.CLASS),
        Classification("22.24", "Pre-press activities", Category.CLASS),
        Classification("22.25", "Ancillary activities related to printing", Category.CLASS),
        Classification("22.31", "Reproduction of sound recording", Category.CLASS),
        Classification("22.32", "Reproduction of video recording", Category.CLASS),
        Classification("22.33", "Reproduction of computer media", Category.CLASS),
        Classification("23.1", "Manufacture of coke oven products", Category.GROUP),
        Classification("23.2", "Manufacture of refined petroleum products", Category.GROUP),
        Classification("23.3", "Processing of nuclear fuel", Category.GROUP),
        Classification("24.11", "Manufacture of industrial gases", Category.CLASS),
        Classification("24.12", "Manufacture of dyes and pigments", Category.CLASS),
        Classification("24.13", "Manufacture of other inorganic basic chemicals", Category.CLASS),
        Classification("24.14", "Manufacture of other organic basic chemicals", Category.CLASS),
        Classification("24.15", "Manufacture of fertilizers and nitrogen compounds", Category.CLASS),
        Classification("24.16", "Manufacture of plastics in primary forms", Category.CLASS),
        Classification("24.17", "Manufacture of synthetic rubber in primary forms", Category.CLASS),
        Classification("24.2", "Manufacture of pesticides and other agro-chemical products", Category.GROUP),
        Classification(
            "24.3", "Manufacture of paints, varnishes and similar coatings, printing ink and mastics", Category.GROUP
        ),
        Classification("24.41", "Manufacture of basic pharmaceutical products", Category.CLASS),
        Classification("24.42", "Manufacture of pharmaceutical preparations", Category.CLASS),
        Classification(
            "24.51", "Manufacture of soap and detergents, cleaning and polishing preparations", Category.CLASS
        ),
        Classification("24.52", "Manufacture of perfumes and toilet preparations", Category.CLASS),
        Classification("24.61", "Manufacture of explosives", Category.CLASS),
        Classification("24.62", "Manufacture of glues and gelatines", Category.CLASS),
        Classification("24.63", "Manufacture of essential oils", Category.CLASS),
        Classification("24.64", "Manufacture of photographic chemical material", Category.CLASS),
        Classification("24.65", "Manufacture of prepared unrecorded media", Category.CLASS),
        Classification("24.66", "Manufacture of other chemical products n.e.c.", Category.CLASS),
        Classification("24.7", "Manufacture of man-made fibres", Category.GROUP),
        Classification("25.11", "Manufacture of rubber tyres and tubes", Category.CLASS),
        Classification("25.12", "Retreading and rebuilding of rubber tyres", Category.CLASS),
        Classification("25.13", "Manufacture of other rubber products", Category.CLASS),
        Classification("25.21", "Manufacture of plastic plates, sheets, tubes and profiles", Category.CLASS),
        Classification("25.22", "Manufacture of plastic packing goods", Category.CLASS),
        Classification("25.23", "Manufacture of builders' ware of plastic", Category.CLASS),
        Classification("25.24", "Manufacture of other plastic products", Category.CLASS),
        Classification("26.11", "Manufacture of flat glass", Category.CLASS),
        Classification("26.12", "Shaping and processing of flat glass", Category.CLASS),
        Classification("26.13", "Manufacture of hollow glass", Category.CLASS),
        Classification("26.14", "Manufacture of glass fibres", Category.CLASS),
        Classification(
            "26.15", "Manufacture and processing of other glass, including technical glassware", Category.CLASS
        ),
        Classification("26.21", "Manufacture of ceramic household and ornamental articles", Category.CLASS),
        Classification("26.22", "Manufacture of ceramic sanitary fixtures", Category.CLASS),
        Classification("26.23", "Manufacture of ceramic insulators and insulating fittings", Category.CLASS),
        Classification("26.24", "Manufacture of other technical ceramic products", Category.CLASS),
        Classification("26.25", "Manufacture of other ceramic products", Category.CLASS),
        Classification("26.26", "Manufacture of refractory ceramic products", Category.CLASS),
        Classification("26.3", "Manufacture of ceramic tiles and flags", Category.GROUP),
        Classification("26.4", "Manufacture of bricks, tiles and construction products, in baked clay", Category.GROUP),
        Classification("26.51", "Manufacture of cement", Category.CLASS),
        Classification("26.52", "Manufacture of lime", Category.CLASS),
        Classification("26.53", "Manufacture of plaster", Category.CLASS),
        Classification("26.61", "Manufacture of concrete products for construction purposes", Category.CLASS),
        Classification("26.62", "Manufacture of plaster products for construction purposes", Category.CLASS),
        Classification("26.63", "Manufacture of ready-mixed concrete", Category.CLASS),
        Classification("26.64", "Manufacture of mortars", Category.CLASS),
        Classification("26.65", "Manufacture of fibre cement", Category.CLASS),
        Classification("26.66", "Manufacture of other articles of concrete, plaster and cement", Category.CLASS),
        Classification("26.7", "Cutting, shaping and finishing of ornamental and building stone", Category.GROUP),
        Classification("26.81", "Production of abrasive products", Category.CLASS),
        Classification("26.82", "Manufacture of other non-metallic mineral products n.e.c.", Category.CLASS),
        Classification("27.1", "Manufacture of basic iron and steel and of ferro-alloys ", Category.GROUP),
        Classification("27.21", "Manufacture of cast iron tubes", Category.CLASS),
        Classification("27.22", "Manufacture of steel tubes", Category.CLASS),
        Classification("27.31", "Cold drawing", Category.CLASS),
        Classification("27.32", "Cold rolling of narrow strip", Category.CLASS),
        Classification("27.33", "Cold forming or folding", Category.CLASS),
        Classification("27.34", "Wire drawing", Category.CLASS),
        Classification("27.41", "Precious metals production", Category.CLASS),
        Classification("27.42", "Aluminium production", Category.CLASS),
        Classification("27.43", "Lead, zinc and tin production", Category.CLASS),
        Classification("27.44", "Copper production", Category.CLASS),
        Classification("27.45", "Other non-ferrous metal production", Category.CLASS),
        Classification("27.51", "Casting of iron", Category.CLASS),
        Classification("27.52", "Casting of steel", Category.CLASS),
        Classification("27.53", "Casting of light metals", Category.CLASS),
        Classification("27.54", "Casting of other non-ferrous metals", Category.CLASS),
        Classification(
            "28", "Manufacture of fabricated metal products, except machinery and equipment", Category.DIVISION
        ),
        Classification("28.11", "Manufacture of metal structures and parts of structures", Category.CLASS),
        Classification("28.12", "Manufacture of builders' carpentry and joinery of metal", Category.CLASS),
        Classification("28.21", "Manufacture of tanks, reservoirs and containers of metal", Category.CLASS),
        Classification("28.22", "Manufacture of central heating radiators and boilers", Category.CLASS),
        Classification(
            "28.3", "Manufacture of steam generators, except central heating hot water boilers", Category.GROUP
        ),
        Classification(
            "28.4", "Forging, pressing, stamping and roll forming of metal; powder metallurgy", Category.GROUP
        ),
        Classification("28.51", "Treatment and coating of metals", Category.CLASS),
        Classification("28.52", "General mechanical engineering", Category.CLASS),
        Classification("28.61", "Manufacture of cutlery", Category.CLASS),
        Classification("28.62", "Manufacture of tools", Category.CLASS),
        Classification("28.63", "Manufacture of locks and hinges", Category.CLASS),
        Classification("28.71", "Manufacture of steel drums and similar containers", Category.CLASS),
        Classification("28.72", "Manufacture of light metal packaging", Category.CLASS),
        Classification("28.73", "Manufacture of wire products", Category.CLASS),
        Classification("28.74", "Manufacture of fasteners, screw machine products, chain and springs", Category.CLASS),
        Classification("28.75", "Manufacture of other fabricated metal products n.e.c.", Category.CLASS),
        Classification("29", "Manufacture of machinery and equipment n.e.c.", Category.DIVISION),
        Classification(
            "29.11", "Manufacture of engines and turbines, except aircraft, vehicle and cycle engines", Category.CLASS
        ),
        Classification("29.12", "Manufacture of pumps and compressors", Category.CLASS),
        Classification("29.13", "Manufacture of taps and valves", Category.CLASS),
        Classification("29.14", "Manufacture of bearings, gears, gearing and driving elements", Category.CLASS),
        Classification("29.21", "Manufacture of furnaces and furnace burners", Category.CLASS),
        Classification("29.22", "Manufacture of lifting and handling equipment", Category.CLASS),
        Classification("29.23", "Manufacture of non-domestic cooling and ventilation equipment", Category.CLASS),
        Classification("29.24", "Manufacture of other general purpose machinery n.e.c.", Category.CLASS),
        Classification("29.31", "Manufacture of agricultural tractors", Category.CLASS),
        Classification("29.32", "Manufacture of other agricultural and forestry machinery", Category.CLASS),
        Classification("29.41", "Manufacture of portable hand held power tools", Category.CLASS),
        Classification("29.42", "Manufacture of other metalworking machine tools", Category.CLASS),
        Classification("29.43", "Manufacture of other machine tools n.e.c.", Category.CLASS),
        Classification("29.51", "Manufacture of machinery for metallurgy", Category.CLASS),
        Classification("29.52", "Manufacture of machinery for mining, quarrying and construction", Category.CLASS),
        Classification("29.53", "Manufacture of machinery for food, beverage and tobacco processing", Category.CLASS),
        Classification("29.54", "Manufacture of machinery for textile, apparel and leather production", Category.CLASS),
        Classification("29.55", "Manufacture of machinery for paper and paperboard production", Category.CLASS),
        Classification("29.56", "Manufacture of other special purpose machinery n.e.c.", Category.CLASS),
        Classification("29.6", "Manufacture of weapons and ammunition", Category.GROUP),
        Classification("29.71", "Manufacture of electric domestic appliances", Category.CLASS),
        Classification("29.72", "Manufacture of non-electric domestic appliances", Category.CLASS),
        Classification("30", "Manufacture of office machinery and computers", Category.DIVISION),
        Classification("30.01", "Manufacture of office machinery", Category.CLASS),
        Classification("30.02", "Manufacture of computers and other information processing equipment", Category.CLASS),
        Classification("31", "Manufacture of electrical machinery and apparatus n.e.c.", Category.DIVISION),
        Classification("31.1", "Manufacture of electric motors, generators and transformers", Category.GROUP),
        Classification("31.2", "Manufacture of electricity distribution and control apparatus", Category.GROUP),
        Classification("31.3", "Manufacture of insulated wire and cable", Category.GROUP),
        Classification("31.4", "Manufacture of accumulators, primary cells and primary batteries", Category.GROUP),
        Classification("31.5", "Manufacture of lighting equipment and electric lamps", Category.GROUP),
        Classification("31.61", "Manufacture of electrical equipment for engines and vehicles n.e.c.", Category.CLASS),
        Classification("31.62", "Manufacture of other electrical equipment n.e.c.", Category.CLASS),
        Classification(
            "32", "Manufacture of radio, television and communication equipment and apparatus", Category.DIVISION
        ),
        Classification(
            "32.1", "Manufacture of electronic valves and tubes and other electronic components", Category.GROUP
        ),
        Classification(
            "32.2",
            "Manufacture of television and radio transmitters and apparatus for line telephony and line telegraphy",
            Category.GROUP,
        ),
        Classification(
            "32.3",
            "Manufacture of television and radio receivers, sound or video recording or reproducing apparatus and associated goods",
            Category.GROUP,
        ),
        Classification(
            "33", "Manufacture of medical, precision and optical instruments, watches and clocks", Category.DIVISION
        ),
        Classification(
            "33.1", "Manufacture of medical and surgical equipment and orthopaedic appliances", Category.GROUP
        ),
        Classification(
            "33.2",
            "Manufacture of instruments and appliances for measuring, checking, testing, navigating and other purposes, except industrial process control equipment",
            Category.GROUP,
        ),
        Classification("33.3", "Manufacture of industrial process control equipment", Category.GROUP),
        Classification("33.4", "Manufacture of optical instruments and photographic equipment", Category.GROUP),
        Classification("33.5", "Manufacture of watches and clocks", Category.GROUP),
        Classification("34", "Manufacture of motor vehicles, trailers and semi-trailers", Category.DIVISION),
        Classification("34.1", "Manufacture of motor vehicles", Category.GROUP),
        Classification(
            "34.2",
            "Manufacture of bodies (coachwork) for motor vehicles; manufacture of trailers and semi-trailers",
            Category.GROUP,
        ),
        Classification(
            "34.3", "Manufacture of parts and accessories for motor vehicles and their engines", Category.GROUP
        ),
        Classification("35", "Manufacture of other transport equipment", Category.DIVISION),
        Classification("35.11", "Building and repairing of ships", Category.CLASS),
        Classification("35.12", "Building and repairing of pleasure and sporting boats", Category.CLASS),
        Classification("35.2", "Manufacture of railway and tramway locomotives and rolling stock", Category.GROUP),
        Classification("35.3", "Manufacture of aircraft and spacecraft", Category.GROUP),
        Classification("35.41", "Manufacture of motorcycles", Category.CLASS),
        Classification("35.42", "Manufacture of bicycles", Category.CLASS),
        Classification("35.43", "Manufacture of invalid carriages", Category.CLASS),
        Classification("35.5", "Manufacture of other transport equipment n.e.c.", Category.GROUP),
        Classification("36", "Manufacture of furniture; manufacturing n.e.c.", Category.DIVISION),
        Classification("36.11", "Manufacture of chairs and seats", Category.CLASS),
        Classification("36.12", "Manufacture of other office and shop furniture", Category.CLASS),
        Classification("36.13", "Manufacture of other kitchen furniture", Category.CLASS),
        Classification("36.14", "Manufacture of other furniture", Category.CLASS),
        Classification("36.15", "Manufacture of mattresses", Category.CLASS),
        Classification("36.21", "Striking of coins ", Category.CLASS),
        Classification("36.22", "Manufacture of jewellery and related articles n.e.c.", Category.CLASS),
        Classification("36.3", "Manufacture of musical instruments", Category.GROUP),
        Classification("36.4", "Manufacture of sports goods", Category.GROUP),
        Classification("36.5", "Manufacture of games and toys", Category.GROUP),
        Classification("36.61", "Manufacture of imitation jewellery", Category.CLASS),
        Classification("36.62", "Manufacture of brooms and brushes", Category.CLASS),
        Classification("36.63", "Other manufacturing n.e.c.", Category.CLASS),
        Classification("37.1", "Recycling of metal waste and scrap", Category.GROUP),
        Classification("37.2", "Recycling of non-metal waste and scrap", Category.GROUP),
        Classification("40.11", "Production of electricity", Category.CLASS),
        Classification("40.12", "Transmission of electricity", Category.CLASS),
        Classification("40.13", "Distribution and trade of electricity", Category.CLASS),
        Classification("40.21", "Manufacture of gas", Category.CLASS),
        Classification("40.22", "Distribution and trade of gaseous fuels through mains", Category.CLASS),
        Classification("40.3", "Steam and hot water supply", Category.GROUP),
        Classification("41", "Collection, purification and distribution of water", Category.DIVISION),
        Classification("45.11", "Demolition and wrecking of buildings; earth moving", Category.CLASS),
        Classification("45.12", "Test drilling and boring", Category.CLASS),
        Classification("45.21", "General construction of buildings and civil engineering works", Category.CLASS),
        Classification("45.22", "Erection of roof covering and frames", Category.CLASS),
        Classification("45.23", "Construction of motorways, roads, airfields and sport facilities", Category.CLASS),
        Classification("45.24", "Construction of water projects", Category.CLASS),
        Classification("45.25", "Other construction work involving special trades", Category.CLASS),
        Classification("45.31", "Installation of electrical wiring and fittings", Category.CLASS),
        Classification("45.32", "Insulation work activities", Category.CLASS),
        Classification("45.33", "Plumbing", Category.CLASS),
        Classification("45.34", "Other building installation", Category.CLASS),
        Classification("45.41", "Plastering", Category.CLASS),
        Classification("45.42", "Joinery installation", Category.CLASS),
        Classification("45.43", "Floor and wall covering", Category.CLASS),
        Classification("45.44", "Painting and glazing", Category.CLASS),
        Classification("45.45", "Other building completion", Category.CLASS),
        Classification("45.5", "Renting of construction or demolition equipment with operator", Category.GROUP),
        Classification("50.1", "Sale of motor vehicles", Category.GROUP),
        Classification("50.2", "Maintenance and repair of motor vehicles", Category.GROUP),
        Classification("50.3", "Sale of motor vehicle parts and accessories", Category.GROUP),
        Classification(
            "50.4", "Sale, maintenance and repair of motorcycles and related parts and accessories", Category.GROUP
        ),
        Classification("50.5", "Retail sale of automotive fuel", Category.GROUP),
        Classification(
            "51.11",
            "Agents involved in the sale of agricultural raw materials, live animals, textile raw materials and semi-finished goods",
            Category.CLASS,
        ),
        Classification(
            "51.12", "Agents involved in the sale of fuels, ores, metals and industrial chemicals", Category.CLASS
        ),
        Classification("51.13", "Agents involved in the sale of timber and building materials", Category.CLASS),
        Classification(
            "51.14",
            "Agents involved in the sale of machinery, industrial equipment, ships and aircraft",
            Category.CLASS,
        ),
        Classification(
            "51.15",
            "Agents involved in the sale of furniture, household goods, hardware and ironmongery",
            Category.CLASS,
        ),
        Classification(
            "51.16", "Agents involved in the sale of textiles, clothing, footwear and leather goods", Category.CLASS
        ),
        Classification("51.17", "Agents involved in the sale of food, beverages and tobacco", Category.CLASS),
        Classification(
            "51.18",
            "Agents specialising in the sale of particular products or ranges of products n.e.c.",
            Category.CLASS,
        ),
        Classification("51.19", "Agents involved in the sale of a variety of goods", Category.CLASS),
        Classification("51.21", "Wholesale of grain, seeds and animal feeds", Category.CLASS),
        Classification("51.22", "Wholesale of flowers and plants", Category.CLASS),
        Classification("51.23", "Wholesale of live animals", Category.CLASS),
        Classification("51.24", "Wholesale of hides, skins and leather", Category.CLASS),
        Classification("51.25", "Wholesale of unmanufactured tobacco", Category.CLASS),
        Classification("51.31", "Wholesale of fruit and vegetables", Category.CLASS),
        Classification("51.32", "Wholesale of meat and meat products", Category.CLASS),
        Classification("51.33", "Wholesale of dairy produce, eggs and edible oils and fats", Category.CLASS),
        Classification("51.34", "Wholesale of alcoholic and other beverages", Category.CLASS),
        Classification("51.35", "Wholesale of tobacco products", Category.CLASS),
        Classification("51.36", "Wholesale of sugar and chocolate and sugar confectionery", Category.CLASS),
        Classification("51.37", "Wholesale of coffee, tea, cocoa and spices", Category.CLASS),
        Classification("51.38", "Wholesale of other food, including fish, crustaceans and molluscs", Category.CLASS),
        Classification("51.39", "Non-specialised wholesale of food, beverages and tobacco", Category.CLASS),
        Classification("51.41", "Wholesale of textiles", Category.CLASS),
        Classification("51.42", "Wholesale of clothing and footwear", Category.CLASS),
        Classification(
            "51.43", "Wholesale of electrical household appliances and radio and television goods", Category.CLASS
        ),
        Classification("51.44", "Wholesale of china and glassware, wallpaper and cleaning materials", Category.CLASS),
        Classification("51.45", "Wholesale of perfume and cosmetics", Category.CLASS),
        Classification("51.46", "Wholesale of pharmaceutical goods", Category.CLASS),
        Classification("51.47", "Wholesale of other household goods", Category.CLASS),
        Classification("51.51", "Wholesale of solid, liquid and gaseous fuels and related products", Category.CLASS),
        Classification("51.52", "Wholesale of metals and metal ores", Category.CLASS),
        Classification("51.53", "Wholesale of wood, construction materials and sanitary equipment", Category.CLASS),
        Classification("51.54", "Wholesale of hardware, plumbing and heating equipment and supplies", Category.CLASS),
        Classification("51.55", "Wholesale of chemical products", Category.CLASS),
        Classification("51.56", "Wholesale of other intermediate products", Category.CLASS),
        Classification("51.57", "Wholesale of waste and scrap", Category.CLASS),
        Classification("51.81", "Wholesale of machine tools", Category.CLASS),
        Classification("51.82", "Wholesale of mining, construction and civil engineering machinery", Category.CLASS),
        Classification(
            "51.83",
            "Wholesale of machinery for the textile industry and of sewing and knitting machines",
            Category.CLASS,
        ),
        Classification("51.84", "Wholesale of computers, computer peripheral equipment and software", Category.CLASS),
        Classification("51.85", "Wholesale of other office machinery and equipment", Category.CLASS),
        Classification("51.86", "Wholesale of other electronic parts and equipment", Category.CLASS),
        Classification(
            "51.87", "Wholesale of other machinery for use in industry, trade and navigation", Category.CLASS
        ),
        Classification(
            "51.88",
            "Wholesale of agricultural machinery and accessories and implements, including tractors",
            Category.CLASS,
        ),
        Classification("51.9", "Other wholesale", Category.GROUP),
        Classification(
            "52.11",
            "Retail sale in non-specialised stores with food, beverages or tobacco predominating",
            Category.CLASS,
        ),
        Classification("52.12", "Other retail sale in non-specialised stores", Category.CLASS),
        Classification("52.21", "Retail sale of fruit and vegetables", Category.CLASS),
        Classification("52.22", "Retail sale of meat and meat products", Category.CLASS),
        Classification("52.23", "Retail sale of fish, crustaceans and molluscs", Category.CLASS),
        Classification(
            "52.24", "Retail sale of bread, cakes, flour confectionery and sugar confectionery", Category.CLASS
        ),
        Classification("52.25", "Retail sale of alcoholic and other beverages", Category.CLASS),
        Classification("52.26", "Retail sale of tobacco products", Category.CLASS),
        Classification(
            "52.27", "Other retail sale of food, beverages and tobacco in specialised stores", Category.CLASS
        ),
        Classification("52.31", "Dispensing chemists", Category.CLASS),
        Classification("52.32", "Retail sale of medical and orthopaedic goods", Category.CLASS),
        Classification("52.33", "Retail sale of cosmetic and toilet articles", Category.CLASS),
        Classification("52.41", "Retail sale of textiles", Category.CLASS),
        Classification("52.42", "Retail sale of clothing", Category.CLASS),
        Classification("52.43", "Retail sale of footwear and leather goods", Category.CLASS),
        Classification(
            "52.44", "Retail sale of furniture, lighting equipment and household articles n.e.c.", Category.CLASS
        ),
        Classification(
            "52.45", "Retail sale of electrical household appliances and radio and television goods", Category.CLASS
        ),
        Classification("52.46", "Retail sale of hardware, paints and glass", Category.CLASS),
        Classification("52.47", "Retail sale of books, newspapers and stationery", Category.CLASS),
        Classification("52.48", "Other retail sale in specialised stores", Category.CLASS),
        Classification("52.5", "Retail sale of second-hand goods in stores", Category.GROUP),
        Classification("52.61", "Retail sale via mail order houses", Category.CLASS),
        Classification("52.62", "Retail sale via stalls and markets", Category.CLASS),
        Classification("52.63", "Other non-store retail sale", Category.CLASS),
        Classification("52.71", "Repair of boots, shoes and other articles of leather", Category.CLASS),
        Classification("52.72", "Repair of electrical household goods", Category.CLASS),
        Classification("52.73", "Repair of watches, clocks and jewellery", Category.CLASS),
        Classification("52.74", "Repair n.e.c.", Category.CLASS),
        Classification("55.1", "Hotels", Category.GROUP),
        Classification("55.21", "Youth hostels and mountain refuges", Category.CLASS),
        Classification("55.22", "Camping sites, including caravan sites", Category.CLASS),
        Classification("55.23", "Other provision of lodgings n.e.c.", Category.CLASS),
        Classification("55.3", "Restaurants", Category.GROUP),
        Classification("55.4", "Bars", Category.GROUP),
        Classification("55.51", "Canteens", Category.CLASS),
        Classification("55.52", "Catering", Category.CLASS),
        Classification("60.1", "Transport via railways", Category.GROUP),
        Classification("60.21", "Other scheduled passenger land transport", Category.CLASS),
        Classification("60.22", "Taxi operation", Category.CLASS),
        Classification("60.23", "Other land passenger transport", Category.CLASS),
        Classification("60.24", "Freight transport by road", Category.CLASS),
        Classification("60.3", "Transport via pipelines", Category.GROUP),
        Classification("61.1", "Sea and coastal water transport", Category.GROUP),
        Classification("61.2", "Inland water transport", Category.GROUP),
        Classification("62.1", "Scheduled air transport", Category.GROUP),
        Classification("62.2", "Non-scheduled air transport", Category.GROUP),
        Classification("62.3", "Space transport", Category.GROUP),
        Classification("63.11", "Cargo handling", Category.CLASS),
        Classification("63.12", "Storage and warehousing", Category.CLASS),
        Classification("63.21", "Other supporting land transport activities", Category.CLASS),
        Classification("63.22", "Other supporting water transport activities", Category.CLASS),
        Classification("63.23", "Other supporting air transport activities", Category.CLASS),
        Classification(
            "63.3",
            "Activities of travel agencies and tour operators; tourist assistance activities n.e.c.",
            Category.GROUP,
        ),
        Classification("63.4", "Activities of other transport agencies", Category.GROUP),
        Classification("64.11", "National post activities", Category.CLASS),
        Classification("64.12", "Courier activities other than national post activities", Category.CLASS),
        Classification("64.2", "Telecommunications", Category.GROUP),
        Classification("65.11", "Central banking", Category.CLASS),
        Classification("65.12", "Other monetary intermediation", Category.CLASS),
        Classification("65.21", "Financial leasing", Category.CLASS),
        Classification("65.22", "Other credit granting", Category.CLASS),
        Classification("65.23", "Other financial intermediation n.e.c.", Category.CLASS),
        Classification("66.01", "Life insurance", Category.CLASS),
        Classification("66.02", "Pension funding", Category.CLASS),
        Classification("66.03", "Non-life insurance", Category.CLASS),
        Classification("67.11", "Administration of financial markets", Category.CLASS),
        Classification("67.12", "Security broking and fund management", Category.CLASS),
        Classification("67.13", "Activities auxiliary to financial intermediation n.e.c.", Category.CLASS),
        Classification("67.2", "Activities auxiliary to insurance and pension funding", Category.GROUP),
        Classification("70.11", "Development and selling of real estate", Category.CLASS),
        Classification("70.12", "Buying and selling of own real estate", Category.CLASS),
        Classification("70.2", "Letting of own property", Category.GROUP),
        Classification("70.31", "Real estate agencies", Category.CLASS),
        Classification("70.32", "Management of real estate on a fee or contract basis", Category.CLASS),
        Classification("71.1", "Renting of automobiles", Category.GROUP),
        Classification("71.21", "Renting of other land transport equipment", Category.CLASS),
        Classification("71.22", "Renting of water transport equipment", Category.CLASS),
        Classification("71.23", "Renting of air transport equipment", Category.CLASS),
        Classification("71.31", "Renting of agricultural machinery and equipment", Category.CLASS),
        Classification(
            "71.32", "Renting of construction and civil engineering machinery and equipment", Category.CLASS
        ),
        Classification("71.33", "Renting of office machinery and equipment, including computers", Category.CLASS),
        Classification("71.34", "Renting of other machinery and equipment n.e.c.", Category.CLASS),
        Classification("71.4", "Renting of personal and household goods n.e.c.", Category.GROUP),
        Classification("72.1", "Hardware consultancy", Category.GROUP),
        Classification("72.21", "Publishing of software", Category.CLASS),
        Classification("72.22", "Other software consultancy and supply", Category.CLASS),
        Classification("72.3", "Data processing", Category.GROUP),
        Classification("72.4", "Database activities", Category.GROUP),
        Classification("72.5", "Maintenance and repair of office, accounting and computing machinery", Category.GROUP),
        Classification("72.6", "Other computer related activities", Category.GROUP),
        Classification(
            "73.1", "Research and experimental development on natural sciences and engineering", Category.GROUP
        ),
        Classification(
            "73.2", "Research and experimental development on social sciences and humanities", Category.GROUP
        ),
        Classification("74.11", "Legal activities", Category.CLASS),
        Classification("74.12", "Accounting, book-keeping and auditing activities; tax consultancy", Category.CLASS),
        Classification("74.13", "Market research and public opinion polling", Category.CLASS),
        Classification("74.14", "Business and management consultancy activities", Category.CLASS),
        Classification("74.15", "Management activities of holding companies", Category.CLASS),
        Classification(
            "74.2", "Architectural and engineering activities and related technical consultancy", Category.GROUP
        ),
        Classification("74.3", "Technical testing and analysis", Category.GROUP),
        Classification("74.4", "Advertising", Category.GROUP),
        Classification("74.5", "Labour recruitment and provision of personnel", Category.GROUP),
        Classification("74.6", "Investigation and security activities", Category.GROUP),
        Classification("74.7", "Industrial cleaning", Category.GROUP),
        Classification("74.81", "Photographic activities", Category.CLASS),
        Classification("74.82", "Packaging activities", Category.CLASS),
        Classification("74.85", "Secretarial and translation activities", Category.CLASS),
        Classification("74.86", "Call centre activities", Category.CLASS),
        Classification("74.87", "Other business activities n.e.c.", Category.CLASS),
        Classification("75.11", "General (overall) public service activities", Category.CLASS),
        Classification(
            "75.12",
            "Regulation of the activities of agencies that provide health care, education, cultural services and other social services, excluding social security",
            Category.CLASS,
        ),
        Classification(
            "75.13", "Regulation of and contribution to more efficient operation of business", Category.CLASS
        ),
        Classification("75.14", "Supporting service activities for the government as a whole", Category.CLASS),
        Classification("75.21", "Foreign affairs", Category.CLASS),
        Classification("75.22", "Defence activities", Category.CLASS),
        Classification("75.23", "Justice and judicial activities", Category.CLASS),
        Classification("75.24", "Public security, law and order activities", Category.CLASS),
        Classification("75.25", "Fire service activities", Category.CLASS),
        Classification("75.3", "Compulsory social security activities", Category.GROUP),
        Classification("80.1", "Primary education", Category.GROUP),
        Classification("80.21", "General secondary education", Category.CLASS),
        Classification("80.22", "Technical and vocational secondary education", Category.CLASS),
        Classification("80.3", "Higher education", Category.GROUP),
        Classification("80.41", "Driving school activities", Category.CLASS),
        Classification("80.42", "Adult and other education n.e.c.", Category.CLASS),
        Classification("85.11", "Hospital activities", Category.CLASS),
        Classification("85.12", "Medical practice activities", Category.CLASS),
        Classification("85.13", "Dental practice activities", Category.CLASS),
        Classification("85.14", "Other human health activities", Category.CLASS),
        Classification("85.2", "Veterinary activities", Category.GROUP),
        Classification("85.31", "Social work activities with accommodation", Category.CLASS),
        Classification("85.32", "Social work activities without accommodation", Category.CLASS),
        Classification("90.01", "Collection and treatment of sewage", Category.CLASS),
        Classification("90.02", "Collection and treatment of other waste", Category.CLASS),
        Classification("90.03", "Sanitation, remediation and similar activities", Category.CLASS),
        Classification("91.11", "Activities of business and employers' organizations", Category.CLASS),
        Classification("91.12", "Activities of professional organizations", Category.CLASS),
        Classification("91.2", "Activities of trade unions", Category.GROUP),
        Classification("91.31", "Activities of religious organizations", Category.CLASS),
        Classification("91.32", "Activities of political organizations", Category.CLASS),
        Classification("91.33", "Activities of other membership organizations n.e.c.", Category.CLASS),
        Classification("92.11", "Motion picture and video production", Category.CLASS),
        Classification("92.12", "Motion picture and video distribution", Category.CLASS),
        Classification("92.13", "Motion picture projection", Category.CLASS),
        Classification("92.2", "Radio and television activities", Category.GROUP),
        Classification("92.31", "Artistic and literary creation and interpretation", Category.CLASS),
        Classification("92.32", "Operation of arts facilities", Category.CLASS),
        Classification("92.33", "Fair and amusement park activities", Category.CLASS),
        Classification("92.34", "Other entertainment activities n.e.c.", Category.CLASS),
        Classification("92.4", "News agency activities", Category.GROUP),
        Classification("92.51", "Library and archives activities", Category.CLASS),
        Classification(
            "92.52", "Museums activities and preservation of historical sites and buildings", Category.CLASS
        ),
        Classification("92.53", "Botanical and zoological gardens and nature reserves activities", Category.CLASS),
        Classification("92.61", "Operation of sports arenas and stadiums", Category.CLASS),
        Classification("92.62", "Other sporting activities", Category.CLASS),
        Classification("92.71", "Gambling and betting activities", Category.CLASS),
        Classification("92.72", "Other recreational activities n.e.c.", Category.CLASS),
        Classification("93.01", "Washing and dry-cleaning of textile and fur products", Category.CLASS),
        Classification("93.02", "Hairdressing and other beauty treatment", Category.CLASS),
        Classification("93.03", "Funeral and related activities", Category.CLASS),
        Classification("93.04", "Physical well-being activities", Category.CLASS),
        Classification("93.05", "Other service activities n.e.c.", Category.CLASS),
        Classification("95", "Activities of households as employers of domestic staff", Category.DIVISION),
        Classification(
            "96", "Undifferentiated goods producing activities of private households for own use", Category.DIVISION
        ),
        Classification(
            "97", "Undifferentiated services producing activities of private households for own use", Category.DIVISION
        ),
        Classification("99", "Extra-territorial organizations and bodies", Category.DIVISION),
    ],
)
