# -*- coding: utf-8 -*-
"""`ISIC3 Standard <https://unstats.un.org/unsd/classifications/Econ/Download/In%20Text/ISIC_Rev_3_1_english_structure.txt>`_.
"""
from ...types import Category, Classification, Standard, Standards

ISIC3 = Standard(
    standard=Standards.ISIC3,
    classes=[
        Classification("A", "Agriculture, hunting and forestry", Category.SECTION),
        Classification("01", "Agriculture, hunting and related service activities", Category.DIVISION),
        Classification("011", "Growing of crops; market gardening; horticulture", Category.GROUP),
        Classification("0111", "Growing of cereals and other crops n.e.c.", Category.CLASS),
        Classification("0112", "Growing of vegetables, horticultural specialties and nursery products", Category.CLASS),
        Classification("0113", "Growing of fruit, nuts, beverage and spice crops", Category.CLASS),
        Classification("012", "Farming of animals", Category.GROUP),
        Classification(
            "0121", "Farming of cattle, sheep, goats, horses, asses, mules and hinnies; dairy farming", Category.CLASS
        ),
        Classification("0122", "Other animal farming; production of animal products n.e.c.", Category.CLASS),
        Classification("013", "Growing of crops combined with farming of animals (mixed farming)", Category.GROUP),
        Classification("0130", "Growing of crops combined with farming of animals (mixed farming)", Category.CLASS),
        Classification(
            "014", "Agricultural and animal husbandry service activities, except veterinary activities", Category.GROUP
        ),
        Classification(
            "0140", "Agricultural and animal husbandry service activities, except veterinary activities", Category.CLASS
        ),
        Classification(
            "015", "Hunting, trapping and game propagation including related service activities", Category.GROUP
        ),
        Classification(
            "0150", "Hunting, trapping and game propagation including related service activities", Category.CLASS
        ),
        Classification("02", "Forestry, logging and related service activities", Category.DIVISION),
        Classification("020", "Forestry, logging and related service activities", Category.GROUP),
        Classification("0200", "Forestry, logging and related service activities", Category.CLASS),
        Classification("B", "Fishing", Category.SECTION),
        Classification(
            "05",
            "Fishing, operation of fish hatcheries and fish farms; service activities incidental to fishing",
            Category.DIVISION,
        ),
        Classification(
            "050",
            "Fishing, operation of fish hatcheries and fish farms; service activities incidental to fishing",
            Category.GROUP,
        ),
        Classification(
            "0500",
            "Fishing, operation of fish hatcheries and fish farms; service activities incidental to fishing",
            Category.CLASS,
        ),
        Classification("C", "Mining and quarrying", Category.SECTION),
        Classification("10", "Mining of coal and lignite; extraction of peat", Category.DIVISION),
        Classification("101", "Mining and agglomeration of hard coal", Category.GROUP),
        Classification("1010", "Mining and agglomeration of hard coal", Category.CLASS),
        Classification("102", "Mining and agglomeration of lignite", Category.GROUP),
        Classification("1020", "Mining and agglomeration of lignite", Category.CLASS),
        Classification("103", "Extraction and agglomeration of peat", Category.GROUP),
        Classification("1030", "Extraction and agglomeration of peat", Category.CLASS),
        Classification(
            "11",
            "Extraction of crude petroleum and natural gas; service activities incidental to oil and gas extraction",
            Category.DIVISION,
        ),
        Classification("111", "Extraction of crude petroleum and natural gas", Category.GROUP),
        Classification("1110", "Extraction of crude petroleum and natural gas", Category.CLASS),
        Classification(
            "112", "Service activities incidental to oil and gas extraction excluding surveying", Category.GROUP
        ),
        Classification(
            "1120", "Service activities incidental to oil and gas extraction excluding surveying", Category.CLASS
        ),
        Classification("12", "Mining of uranium and thorium ores", Category.DIVISION),
        Classification("120", "Mining of uranium and thorium ores", Category.GROUP),
        Classification("1200", "Mining of uranium and thorium ores", Category.CLASS),
        Classification("13", "Mining of metal ores", Category.DIVISION),
        Classification("131", "Mining of iron ores", Category.GROUP),
        Classification("1310", "Mining of iron ores", Category.CLASS),
        Classification("132", "Mining of non-ferrous metal ores, except uranium and thorium ores", Category.GROUP),
        Classification("1320", "Mining of non-ferrous metal ores, except uranium and thorium ores", Category.CLASS),
        Classification("14", "Other mining and quarrying", Category.DIVISION),
        Classification("141", "Quarrying of stone, sand and clay", Category.GROUP),
        Classification("1410", "Quarrying of stone, sand and clay", Category.CLASS),
        Classification("142", "Mining and quarrying n.e.c.", Category.GROUP),
        Classification("1421", "Mining of chemical and fertilizer minerals", Category.CLASS),
        Classification("1422", "Extraction of salt", Category.CLASS),
        Classification("1429", "Other mining and quarrying n.e.c.", Category.CLASS),
        Classification("D", "Manufacturing", Category.SECTION),
        Classification("15", "Manufacture of food products and beverages", Category.DIVISION),
        Classification(
            "151",
            "Production, processing and preservation of meat, fish, fruit, vegetables, oils and fats",
            Category.GROUP,
        ),
        Classification("1511", "Production, processing and preserving of meat and meat products", Category.CLASS),
        Classification("1512", "Processing and preserving of fish and fish products", Category.CLASS),
        Classification("1513", "Processing and preserving of fruit and vegetables", Category.CLASS),
        Classification("1514", "Manufacture of vegetable and animal oils and fats", Category.CLASS),
        Classification("152", "Manufacture of dairy products", Category.GROUP),
        Classification("1520", "Manufacture of dairy products", Category.CLASS),
        Classification(
            "153",
            "Manufacture of grain mill products, starches and starch products, and prepared animal feeds",
            Category.GROUP,
        ),
        Classification("1531", "Manufacture of grain mill products", Category.CLASS),
        Classification("1532", "Manufacture of starches and starch products", Category.CLASS),
        Classification("1533", "Manufacture of prepared animal feeds", Category.CLASS),
        Classification("154", "Manufacture of other food products", Category.GROUP),
        Classification("1541", "Manufacture of bakery products", Category.CLASS),
        Classification("1542", "Manufacture of sugar", Category.CLASS),
        Classification("1543", "Manufacture of cocoa, chocolate and sugar confectionery", Category.CLASS),
        Classification(
            "1544", "Manufacture of macaroni, noodles, couscous and similar farinaceous products", Category.CLASS
        ),
        Classification("1549", "Manufacture of other food products n.e.c.", Category.CLASS),
        Classification("155", "Manufacture of beverages", Category.GROUP),
        Classification(
            "1551",
            "Distilling, rectifying and blending of spirits; ethyl alcohol production from fermented materials",
            Category.CLASS,
        ),
        Classification("1552", "Manufacture of wines", Category.CLASS),
        Classification("1553", "Manufacture of malt liquors and malt", Category.CLASS),
        Classification("1554", "Manufacture of soft drinks; production of mineral waters", Category.CLASS),
        Classification("16", "Manufacture of tobacco products", Category.DIVISION),
        Classification("160", "Manufacture of tobacco products", Category.GROUP),
        Classification("1600", "Manufacture of tobacco products", Category.CLASS),
        Classification("17", "Manufacture of textiles", Category.DIVISION),
        Classification("171", "Spinning, weaving and finishing of textiles", Category.GROUP),
        Classification("1711", "Preparation and spinning of textile fibres; weaving of textiles", Category.CLASS),
        Classification("1712", "Finishing of textiles", Category.CLASS),
        Classification("172", "Manufacture of other textiles", Category.GROUP),
        Classification("1721", "Manufacture of made-up textile articles, except apparel", Category.CLASS),
        Classification("1722", "Manufacture of carpets and rugs", Category.CLASS),
        Classification("1723", "Manufacture of cordage, rope, twine and netting", Category.CLASS),
        Classification("1729", "Manufacture of other textiles n.e.c.", Category.CLASS),
        Classification("173", "Manufacture of knitted and crocheted fabrics and articles", Category.GROUP),
        Classification("1730", "Manufacture of knitted and crocheted fabrics and articles", Category.CLASS),
        Classification("18", "Manufacture of wearing apparel; dressing and dyeing of fur", Category.DIVISION),
        Classification("181", "Manufacture of wearing apparel, except fur apparel", Category.GROUP),
        Classification("1810", "Manufacture of wearing apparel, except fur apparel", Category.CLASS),
        Classification("182", "Dressing and dyeing of fur; manufacture of articles of fur", Category.GROUP),
        Classification("1820", "Dressing and dyeing of fur; manufacture of articles of fur", Category.CLASS),
        Classification(
            "19",
            "Tanning and dressing of leather; manufacture of luggage, handbags, saddlery, harness and footwear",
            Category.DIVISION,
        ),
        Classification(
            "191",
            "Tanning and dressing of leather; manufacture of luggage, handbags, saddlery and harness",
            Category.GROUP,
        ),
        Classification("1911", "Tanning and dressing of leather", Category.CLASS),
        Classification("1912", "Manufacture of luggage, handbags and the like, saddlery and harness", Category.CLASS),
        Classification("192", "Manufacture of footwear", Category.GROUP),
        Classification("1920", "Manufacture of footwear", Category.CLASS),
        Classification(
            "20",
            "Manufacture of wood and of products of wood and cork, except furniture; manufacture of articles of str",
            Category.DIVISION,
        ),
        Classification("201", "Sawmilling and planing of wood", Category.GROUP),
        Classification("2010", "Sawmilling and planing of wood", Category.CLASS),
        Classification("202", "Manufacture of products of wood, cork, straw and plaiting materials", Category.GROUP),
        Classification(
            "2021",
            "Manufacture of veneer sheets; manufacture of plywood, laminboard, particle board and other panels and",
            Category.CLASS,
        ),
        Classification("2022", "Manufacture of builders' carpentry and joinery", Category.CLASS),
        Classification("2023", "Manufacture of wooden containers", Category.CLASS),
        Classification(
            "2029",
            "Manufacture of other products of wood; manufacture of articles of cork, straw and plaiting materials",
            Category.CLASS,
        ),
        Classification("21", "Manufacture of paper and paper products", Category.DIVISION),
        Classification("210", "Manufacture of paper and paper products", Category.GROUP),
        Classification("2101", "Manufacture of pulp, paper and paperboard", Category.CLASS),
        Classification(
            "2102",
            "Manufacture of corrugated paper and paperboard and of containers of paper and paperboard",
            Category.CLASS,
        ),
        Classification("2109", "Manufacture of other articles of paper and paperboard", Category.CLASS),
        Classification("22", "Publishing, printing and reproduction of recorded media", Category.DIVISION),
        Classification("221", "Publishing", Category.GROUP),
        Classification("2211", "Publishing of books, brochures, musical books and other publications", Category.CLASS),
        Classification("2212", "Publishing of newspapers, journals and periodicals", Category.CLASS),
        Classification("2213", "Publishing of recorded media", Category.CLASS),
        Classification("2219", "Other publishing", Category.CLASS),
        Classification("222", "Printing and service activities related to printing", Category.GROUP),
        Classification("2221", "Printing", Category.CLASS),
        Classification("2222", "Service activities related to printing", Category.CLASS),
        Classification("223", "Reproduction of recorded media", Category.GROUP),
        Classification("2230", "Reproduction of recorded media", Category.CLASS),
        Classification("23", "Manufacture of coke, refined petroleum products and nuclear fuel", Category.DIVISION),
        Classification("231", "Manufacture of coke oven products", Category.GROUP),
        Classification("2310", "Manufacture of coke oven products", Category.CLASS),
        Classification("232", "Manufacture of refined petroleum products", Category.GROUP),
        Classification("2320", "Manufacture of refined petroleum products", Category.CLASS),
        Classification("233", "Processing of nuclear fuel", Category.GROUP),
        Classification("2330", "Processing of nuclear fuel", Category.CLASS),
        Classification("24", "Manufacture of chemicals and chemical products", Category.DIVISION),
        Classification("241", "Manufacture of basic chemicals", Category.GROUP),
        Classification(
            "2411", "Manufacture of basic chemicals, except fertilizers and nitrogen compounds", Category.CLASS
        ),
        Classification("2412", "Manufacture of fertilizers and nitrogen compounds", Category.CLASS),
        Classification("2413", "Manufacture of plastics in primary forms and of synthetic rubber", Category.CLASS),
        Classification("242", "Manufacture of other chemical products", Category.GROUP),
        Classification("2421", "Manufacture of pesticides and other agro-chemical products", Category.CLASS),
        Classification(
            "2422", "Manufacture of paints, varnishes and similar coatings, printing ink and mastics", Category.CLASS
        ),
        Classification(
            "2423", "Manufacture of pharmaceuticals, medicinal chemicals and botanical products", Category.CLASS
        ),
        Classification(
            "2424",
            "Manufacture of soap and detergents, cleaning and polishing preparations, perfumes and toilet preparati",
            Category.CLASS,
        ),
        Classification("2429", "Manufacture of other chemical products n.e.c.", Category.CLASS),
        Classification("243", "Manufacture of man-made fibres", Category.GROUP),
        Classification("2430", "Manufacture of man-made fibres", Category.CLASS),
        Classification("25", "Manufacture of rubber and plastics products", Category.DIVISION),
        Classification("251", "Manufacture of rubber products", Category.GROUP),
        Classification(
            "2511", "Manufacture of rubber tyres and tubes; retreading and rebuilding of rubber tyres", Category.CLASS
        ),
        Classification("2519", "Manufacture of other rubber products", Category.CLASS),
        Classification("252", "Manufacture of plastics products", Category.GROUP),
        Classification("2520", "Manufacture of plastics products", Category.CLASS),
        Classification("26", "Manufacture of other non-metallic mineral products", Category.DIVISION),
        Classification("261", "Manufacture of glass and glass products", Category.GROUP),
        Classification("2610", "Manufacture of glass and glass products", Category.CLASS),
        Classification("269", "Manufacture of non-metallic mineral products n.e.c.", Category.GROUP),
        Classification("2691", "Manufacture of non-structural non-refractory ceramic ware", Category.CLASS),
        Classification("2692", "Manufacture of refractory ceramic products", Category.CLASS),
        Classification("2693", "Manufacture of structural non-refractory clay and ceramic products", Category.CLASS),
        Classification("2694", "Manufacture of cement, lime and plaster", Category.CLASS),
        Classification("2695", "Manufacture of articles of concrete, cement and plaster", Category.CLASS),
        Classification("2696", "Cutting, shaping and finishing of stone", Category.CLASS),
        Classification("2699", "Manufacture of other non-metallic mineral products n.e.c.", Category.CLASS),
        Classification("27", "Manufacture of basic metals", Category.DIVISION),
        Classification("271", "Manufacture of basic iron and steel", Category.GROUP),
        Classification("2710", "Manufacture of basic iron and steel", Category.CLASS),
        Classification("272", "Manufacture of basic precious and non-ferrous metals", Category.GROUP),
        Classification("2720", "Manufacture of basic precious and non-ferrous metals", Category.CLASS),
        Classification("273", "Casting of metals", Category.GROUP),
        Classification("2731", "Casting of iron and steel", Category.CLASS),
        Classification("2732", "Casting of non-ferrous metals", Category.CLASS),
        Classification(
            "28", "Manufacture of fabricated metal products, except machinery and equipment", Category.DIVISION
        ),
        Classification(
            "281", "Manufacture of structural metal products, tanks, reservoirs and steam generators", Category.GROUP
        ),
        Classification("2811", "Manufacture of structural metal products", Category.CLASS),
        Classification("2812", "Manufacture of tanks, reservoirs and containers of metal", Category.CLASS),
        Classification(
            "2813", "Manufacture of steam generators, except central heating hot water boilers", Category.CLASS
        ),
        Classification(
            "289", "Manufacture of other fabricated metal products; metal working service activities", Category.GROUP
        ),
        Classification(
            "2891", "Forging, pressing, stamping and roll-forming of metal; powder metallurgy", Category.CLASS
        ),
        Classification(
            "2892",
            "Treatment and coating of metals; general mechanical engineering on a fee or contract basis",
            Category.CLASS,
        ),
        Classification("2893", "Manufacture of cutlery, hand tools and general hardware", Category.CLASS),
        Classification("2899", "Manufacture of other fabricated metal products n.e.c.", Category.CLASS),
        Classification("29", "Manufacture of machinery and equipment n.e.c.", Category.DIVISION),
        Classification("291", "Manufacture of general purpose machinery", Category.GROUP),
        Classification(
            "2911", "Manufacture of engines and turbines, except aircraft, vehicle and cycle engines", Category.CLASS
        ),
        Classification("2912", "Manufacture of pumps, compressors, taps and valves", Category.CLASS),
        Classification("2913", "Manufacture of bearings, gears, gearing and driving elements", Category.CLASS),
        Classification("2914", "Manufacture of ovens, furnaces and furnace burners", Category.CLASS),
        Classification("2915", "Manufacture of lifting and handling equipment", Category.CLASS),
        Classification("2919", "Manufacture of other general purpose machinery", Category.CLASS),
        Classification("292", "Manufacture of special purpose machinery", Category.GROUP),
        Classification("2921", "Manufacture of agricultural and forestry machinery", Category.CLASS),
        Classification("2922", "Manufacture of machine-tools", Category.CLASS),
        Classification("2923", "Manufacture of machinery for metallurgy", Category.CLASS),
        Classification("2924", "Manufacture of machinery for mining, quarrying and construction", Category.CLASS),
        Classification("2925", "Manufacture of machinery for food, beverage and tobacco processing", Category.CLASS),
        Classification("2926", "Manufacture of machinery for textile, apparel and leather production", Category.CLASS),
        Classification("2927", "Manufacture of weapons and ammunition", Category.CLASS),
        Classification("2929", "Manufacture of other special purpose machinery", Category.CLASS),
        Classification("293", "Manufacture of domestic appliances n.e.c.", Category.GROUP),
        Classification("2930", "Manufacture of domestic appliances n.e.c.", Category.CLASS),
        Classification("30", "Manufacture of office, accounting and computing machinery", Category.DIVISION),
        Classification("300", "Manufacture of office, accounting and computing machinery", Category.GROUP),
        Classification("3000", "Manufacture of office, accounting and computing machinery", Category.CLASS),
        Classification("31", "Manufacture of electrical machinery and apparatus n.e.c.", Category.DIVISION),
        Classification("311", "Manufacture of electric motors, generators and transformers", Category.GROUP),
        Classification("3110", "Manufacture of electric motors, generators and transformers", Category.CLASS),
        Classification("312", "Manufacture of electricity distribution and control apparatus", Category.GROUP),
        Classification("3120", "Manufacture of electricity distribution and control apparatus", Category.CLASS),
        Classification("313", "Manufacture of insulated wire and cable", Category.GROUP),
        Classification("3130", "Manufacture of insulated wire and cable", Category.CLASS),
        Classification("314", "Manufacture of accumulators, primary cells and primary batteries", Category.GROUP),
        Classification("3140", "Manufacture of accumulators, primary cells and primary batteries", Category.CLASS),
        Classification("315", "Manufacture of electric lamps and lighting equipment", Category.GROUP),
        Classification("3150", "Manufacture of electric lamps and lighting equipment", Category.CLASS),
        Classification("319", "Manufacture of other electrical equipment n.e.c.", Category.GROUP),
        Classification("3190", "Manufacture of other electrical equipment n.e.c.", Category.CLASS),
        Classification(
            "32", "Manufacture of radio, television and communication equipment and apparatus", Category.DIVISION
        ),
        Classification(
            "321", "Manufacture of electronic valves and tubes and other electronic components", Category.GROUP
        ),
        Classification(
            "3210", "Manufacture of electronic valves and tubes and other electronic components", Category.CLASS
        ),
        Classification(
            "322",
            "Manufacture of television and radio transmitters and apparatus for line telephony and line telegraphy",
            Category.GROUP,
        ),
        Classification(
            "3220",
            "Manufacture of television and radio transmitters and apparatus for line telephony and line telegraphy",
            Category.CLASS,
        ),
        Classification(
            "323",
            "Manufacture of television and radio receivers, sound or video recording or reproducing apparatus, and",
            Category.GROUP,
        ),
        Classification(
            "3230",
            "Manufacture of television and radio receivers, sound or video recording or reproducing apparatus, and",
            Category.CLASS,
        ),
        Classification(
            "33", "Manufacture of medical, precision and optical instruments, watches and clocks", Category.DIVISION
        ),
        Classification(
            "331",
            "Manufacture of medical appliances and instruments and appliances for measuring, checking, testing, nav",
            Category.GROUP,
        ),
        Classification(
            "3311", "Manufacture of medical and surgical equipment and orthopaedic appliances", Category.CLASS
        ),
        Classification(
            "3312",
            "Manufacture of instruments and appliances for measuring, checking, testing, navigating and other purpo",
            Category.CLASS,
        ),
        Classification("3313", "Manufacture of industrial process control equipment", Category.CLASS),
        Classification("332", "Manufacture of optical instruments and photographic equipment", Category.GROUP),
        Classification("3320", "Manufacture of optical instruments and photographic equipment", Category.CLASS),
        Classification("333", "Manufacture of watches and clocks", Category.GROUP),
        Classification("3330", "Manufacture of watches and clocks", Category.CLASS),
        Classification("34", "Manufacture of motor vehicles, trailers and semi-trailers", Category.DIVISION),
        Classification("341", "Manufacture of motor vehicles", Category.GROUP),
        Classification("3410", "Manufacture of motor vehicles", Category.CLASS),
        Classification(
            "342",
            "Manufacture of bodies (coachwork) for motor vehicles; manufacture of trailers and semi-trailers",
            Category.GROUP,
        ),
        Classification(
            "3420",
            "Manufacture of bodies (coachwork) for motor vehicles; manufacture of trailers and semi-trailers",
            Category.CLASS,
        ),
        Classification(
            "343", "Manufacture of parts and accessories for motor vehicles and their engines", Category.GROUP
        ),
        Classification(
            "3430", "Manufacture of parts and accessories for motor vehicles and their engines", Category.CLASS
        ),
        Classification("35", "Manufacture of other transport equipment", Category.DIVISION),
        Classification("351", "Building and repairing of ships and boats", Category.GROUP),
        Classification("3511", "Building and repairing of ships", Category.CLASS),
        Classification("3512", "Building and repairing of pleasure and sporting boats", Category.CLASS),
        Classification("352", "Manufacture of railway and tramway locomotives and rolling stock", Category.GROUP),
        Classification("3520", "Manufacture of railway and tramway locomotives and rolling stock", Category.CLASS),
        Classification("353", "Manufacture of aircraft and spacecraft", Category.GROUP),
        Classification("3530", "Manufacture of aircraft and spacecraft", Category.CLASS),
        Classification("359", "Manufacture of transport equipment n.e.c.", Category.GROUP),
        Classification("3591", "Manufacture of motorcycles", Category.CLASS),
        Classification("3592", "Manufacture of bicycles and invalid carriages", Category.CLASS),
        Classification("3599", "Manufacture of other transport equipment n.e.c.", Category.CLASS),
        Classification("36", "Manufacture of furniture; manufacturing n.e.c.", Category.DIVISION),
        Classification("361", "Manufacture of furniture", Category.GROUP),
        Classification("3610", "Manufacture of furniture", Category.CLASS),
        Classification("369", "Manufacturing n.e.c.", Category.GROUP),
        Classification("3691", "Manufacture of jewellery and related articles", Category.CLASS),
        Classification("3692", "Manufacture of musical instruments", Category.CLASS),
        Classification("3693", "Manufacture of sports goods", Category.CLASS),
        Classification("3694", "Manufacture of games and toys", Category.CLASS),
        Classification("3699", "Other manufacturing n.e.c.", Category.CLASS),
        Classification("37", "Recycling", Category.DIVISION),
        Classification("371", "Recycling of metal waste and scrap", Category.GROUP),
        Classification("3710", "Recycling of metal waste and scrap", Category.CLASS),
        Classification("372", "Recycling of non-metal waste and scrap", Category.GROUP),
        Classification("3720", "Recycling of non-metal waste and scrap", Category.CLASS),
        Classification("E", "Electricity, gas and water supply", Category.SECTION),
        Classification("40", "Electricity, gas, steam and hot water supply", Category.DIVISION),
        Classification("401", "Production, collection and distribution of electricity", Category.GROUP),
        Classification("4010", "Production, collection and distribution of electricity", Category.CLASS),
        Classification("402", "Manufacture of gas; distribution of gaseous fuels through mains", Category.GROUP),
        Classification("4020", "Manufacture of gas; distribution of gaseous fuels through mains", Category.CLASS),
        Classification("403", "Steam and hot water supply", Category.GROUP),
        Classification("4030", "Steam and hot water supply", Category.CLASS),
        Classification("41", "Collection, purification and distribution of water", Category.DIVISION),
        Classification("410", "Collection, purification and distribution of water", Category.GROUP),
        Classification("4100", "Collection, purification and distribution of water", Category.CLASS),
        Classification("F", "Construction", Category.SECTION),
        Classification("45", "Construction", Category.DIVISION),
        Classification("451", "Site preparation", Category.GROUP),
        Classification("4510", "Site preparation", Category.CLASS),
        Classification("452", "Building of complete constructions or parts thereof; civil engineering", Category.GROUP),
        Classification(
            "4520", "Building of complete constructions or parts thereof; civil engineering", Category.CLASS
        ),
        Classification("453", "Building installation", Category.GROUP),
        Classification("4530", "Building installation", Category.CLASS),
        Classification("454", "Building completion", Category.GROUP),
        Classification("4540", "Building completion", Category.CLASS),
        Classification("455", "Renting of construction or demolition equipment with operator", Category.GROUP),
        Classification("4550", "Renting of construction or demolition equipment with operator", Category.CLASS),
        Classification(
            "G",
            "Wholesale and retail trade; repair of motor vehicles, motorcycles and personal and household goods",
            Category.SECTION,
        ),
        Classification(
            "50",
            "Sale, maintenance and repair of motor vehicles and motorcycles; retail sale of automotive fuel",
            Category.DIVISION,
        ),
        Classification("501", "Sale of motor vehicles", Category.GROUP),
        Classification("5010", "Sale of motor vehicles", Category.CLASS),
        Classification("502", "Maintenance and repair of motor vehicles", Category.GROUP),
        Classification("5020", "Maintenance and repair of motor vehicles", Category.CLASS),
        Classification("503", "Sale of motor vehicle parts and accessories", Category.GROUP),
        Classification("5030", "Sale of motor vehicle parts and accessories", Category.CLASS),
        Classification(
            "504", "Sale, maintenance and repair of motorcycles and related parts and accessories", Category.GROUP
        ),
        Classification(
            "5040", "Sale, maintenance and repair of motorcycles and related parts and accessories", Category.CLASS
        ),
        Classification("505", "Retail sale of automotive fuel", Category.GROUP),
        Classification("5050", "Retail sale of automotive fuel", Category.CLASS),
        Classification(
            "51", "Wholesale trade and commission trade, except of motor vehicles and motorcycles", Category.DIVISION
        ),
        Classification("511", "Wholesale on a fee or contract basis", Category.GROUP),
        Classification("5110", "Wholesale on a fee or contract basis", Category.CLASS),
        Classification(
            "512", "Wholesale of agricultural raw materials, live animals, food, beverages and tobacco", Category.GROUP
        ),
        Classification("5121", "Wholesale of agricultural raw materials and live animals", Category.CLASS),
        Classification("5122", "Wholesale of food, beverages and tobacco", Category.CLASS),
        Classification("513", "Wholesale of household goods", Category.GROUP),
        Classification("5131", "Wholesale of textiles, clothing  and footwear", Category.CLASS),
        Classification("5139", "Wholesale of other household goods", Category.CLASS),
        Classification("514", "Wholesale of non-agricultural intermediate products, waste and scrap", Category.GROUP),
        Classification("5141", "Wholesale of solid, liquid and gaseous fuels and related products", Category.CLASS),
        Classification("5142", "Wholesale of metals and metal ores", Category.CLASS),
        Classification(
            "5143",
            "Wholesale of construction materials, hardware, plumbing and heating equipment and supplies",
            Category.CLASS,
        ),
        Classification("5149", "Wholesale of other intermediate products, waste and scrap", Category.CLASS),
        Classification("515", "Wholesale of machinery, equipment and supplies", Category.GROUP),
        Classification("5150", "Wholesale of machinery, equipment and supplies", Category.CLASS),
        Classification("519", "Other wholesale", Category.GROUP),
        Classification("5190", "Other wholesale", Category.CLASS),
        Classification(
            "52",
            "Retail trade, except of motor vehicles and motorcycles; repair of personal and household goods",
            Category.DIVISION,
        ),
        Classification("521", "Non-specialized retail trade in stores", Category.GROUP),
        Classification(
            "5211",
            "Retail sale in non-specialized stores with food, beverages or tobacco predominating",
            Category.CLASS,
        ),
        Classification("5219", "Other retail sale in non-specialized stores", Category.CLASS),
        Classification("522", "Retail sale of food, beverages and tobacco in specialized stores", Category.GROUP),
        Classification("5220", "Retail sale of food, beverages and tobacco in specialized stores", Category.CLASS),
        Classification("523", "Other retail trade of new goods in specialized stores", Category.GROUP),
        Classification(
            "5231", "Retail sale of pharmaceutical and medical goods, cosmetic and toilet articles", Category.CLASS
        ),
        Classification("5232", "Retail sale of textiles, clothing, footwear and leather goods", Category.CLASS),
        Classification("5233", "Retail sale of household appliances, articles and equipment", Category.CLASS),
        Classification("5234", "Retail sale of hardware, paint and glass", Category.CLASS),
        Classification("5239", "Other retail sale in specialized stores", Category.CLASS),
        Classification("524", "Retail sale of second-hand goods in stores", Category.GROUP),
        Classification("5240", "Retail sale of second-hand goods in stores", Category.CLASS),
        Classification("525", "Retail trade not in stores", Category.GROUP),
        Classification("5251", "Retail sale via mail order houses", Category.CLASS),
        Classification("5252", "Retail sale via stalls and markets", Category.CLASS),
        Classification("5259", "Other non-store retail sale", Category.CLASS),
        Classification("526", "Repair of personal and household goods", Category.GROUP),
        Classification("5260", "Repair of personal and household goods", Category.CLASS),
        Classification("H", "Hotels and restaurants", Category.SECTION),
        Classification("55", "Hotels and restaurants", Category.DIVISION),
        Classification("551", "Hotels; camping sites and other provision of short-stay accommodation", Category.GROUP),
        Classification("5510", "Hotels; camping sites and other provision of short-stay accommodation", Category.CLASS),
        Classification("552", "Restaurants, bars and canteens", Category.GROUP),
        Classification("5520", "Restaurants, bars and canteens", Category.CLASS),
        Classification("I", "Transport, storage and communications", Category.SECTION),
        Classification("60", "Land transport; transport via pipelines", Category.DIVISION),
        Classification("601", "Transport via railways", Category.GROUP),
        Classification("6010", "Transport via railways", Category.CLASS),
        Classification("602", "Other land transport", Category.GROUP),
        Classification("6021", "Other scheduled passenger land transport", Category.CLASS),
        Classification("6022", "Other non-scheduled passenger land transport", Category.CLASS),
        Classification("6023", "Freight transport by road", Category.CLASS),
        Classification("603", "Transport via pipelines", Category.GROUP),
        Classification("6030", "Transport via pipelines", Category.CLASS),
        Classification("61", "Water transport", Category.DIVISION),
        Classification("611", "Sea and coastal water transport", Category.GROUP),
        Classification("6110", "Sea and coastal water transport", Category.CLASS),
        Classification("612", "Inland water transport", Category.GROUP),
        Classification("6120", "Inland water transport", Category.CLASS),
        Classification("62", "Air transport", Category.DIVISION),
        Classification("621", "Scheduled air transport", Category.GROUP),
        Classification("6210", "Scheduled air transport", Category.CLASS),
        Classification("622", "Non-scheduled air transport", Category.GROUP),
        Classification("6220", "Non-scheduled air transport", Category.CLASS),
        Classification(
            "63", "Supporting and auxiliary transport activities; activities of travel agencies", Category.DIVISION
        ),
        Classification(
            "630", "Supporting and auxiliary transport activities; activities of travel agencies", Category.GROUP
        ),
        Classification("6301", "Cargo handling", Category.CLASS),
        Classification("6302", "Storage and warehousing", Category.CLASS),
        Classification("6303", "Other supporting transport activities", Category.CLASS),
        Classification(
            "6304",
            "Activities of travel agencies and tour operators; tourist assistance activities n.e.c.",
            Category.CLASS,
        ),
        Classification("6309", "Activities of other transport agencies", Category.CLASS),
        Classification("64", "Post and telecommunications", Category.DIVISION),
        Classification("641", "Post and courier activities", Category.GROUP),
        Classification("6411", "National post activities", Category.CLASS),
        Classification("6412", "Courier activities other than national post activities", Category.CLASS),
        Classification("642", "Telecommunications", Category.GROUP),
        Classification("6420", "Telecommunications", Category.CLASS),
        Classification("J", "Financial intermediation", Category.SECTION),
        Classification("65", "Financial intermediation, except insurance and pension funding", Category.DIVISION),
        Classification("651", "Monetary intermediation", Category.GROUP),
        Classification("6511", "Central banking", Category.CLASS),
        Classification("6519", "Other monetary intermediation", Category.CLASS),
        Classification("659", "Other financial intermediation", Category.GROUP),
        Classification("6591", "Financial leasing", Category.CLASS),
        Classification("6592", "Other credit granting", Category.CLASS),
        Classification("6599", "Other financial intermediation n.e.c.", Category.CLASS),
        Classification("66", "Insurance and pension funding, except compulsory social security", Category.DIVISION),
        Classification("660", "Insurance and pension funding, except compulsory social security", Category.GROUP),
        Classification("6601", "Life insurance", Category.CLASS),
        Classification("6602", "Pension funding", Category.CLASS),
        Classification("6603", "Non-life insurance", Category.CLASS),
        Classification("67", "Activities auxiliary to financial intermediation", Category.DIVISION),
        Classification(
            "671",
            "Activities auxiliary to financial intermediation, except insurance and pension funding",
            Category.GROUP,
        ),
        Classification("6711", "Administration of financial markets", Category.CLASS),
        Classification("6712", "Security dealing activities", Category.CLASS),
        Classification("6719", "Activities auxiliary to financial intermediation n.e.c.", Category.CLASS),
        Classification("672", "Activities auxiliary to insurance and pension funding", Category.GROUP),
        Classification("6720", "Activities auxiliary to insurance and pension funding", Category.CLASS),
        Classification("K", "Real estate, renting and business activities", Category.SECTION),
        Classification("70", "Real estate activities", Category.DIVISION),
        Classification("701", "Real estate activities with own or leased property", Category.GROUP),
        Classification("7010", "Real estate activities with own or leased property", Category.CLASS),
        Classification("702", "Real estate activities on a fee or contract basis", Category.GROUP),
        Classification("7020", "Real estate activities on a fee or contract basis", Category.CLASS),
        Classification(
            "71",
            "Renting of machinery and equipment without operator and of personal and household goods",
            Category.DIVISION,
        ),
        Classification("711", "Renting of transport equipment", Category.GROUP),
        Classification("7111", "Renting of land transport equipment", Category.CLASS),
        Classification("7112", "Renting of water transport equipment", Category.CLASS),
        Classification("7113", "Renting of air transport equipment", Category.CLASS),
        Classification("712", "Renting of other machinery and equipment", Category.GROUP),
        Classification("7121", "Renting of agricultural machinery and equipment", Category.CLASS),
        Classification("7122", "Renting of construction and civil engineering machinery and equipment", Category.CLASS),
        Classification("7123", "Renting of office machinery and equipment (including computers)", Category.CLASS),
        Classification("7129", "Renting of other machinery and equipment n.e.c.", Category.CLASS),
        Classification("713", "Renting of personal and household goods n.e.c.", Category.GROUP),
        Classification("7130", "Renting of personal and household goods n.e.c.", Category.CLASS),
        Classification("72", "Computer and related activities", Category.DIVISION),
        Classification("721", "Hardware consultancy", Category.GROUP),
        Classification("7210", "Hardware consultancy", Category.CLASS),
        Classification("722", "Software consultancy and supply", Category.GROUP),
        Classification("7220", "Software consultancy and supply", Category.CLASS),
        Classification("723", "Data processing", Category.GROUP),
        Classification("7230", "Data processing", Category.CLASS),
        Classification("724", "Data base activities", Category.GROUP),
        Classification("7240", "Data base activities", Category.CLASS),
        Classification("725", "Maintenance and repair of office, accounting and computing machinery", Category.GROUP),
        Classification("7250", "Maintenance and repair of office, accounting and computing machinery", Category.CLASS),
        Classification("729", "Other computer related activities", Category.GROUP),
        Classification("7290", "Other computer related activities", Category.CLASS),
        Classification("73", "Research and development", Category.DIVISION),
        Classification(
            "731", "Research and experimental development on natural sciences and engineering (NSE)", Category.GROUP
        ),
        Classification(
            "7310", "Research and experimental development on natural sciences and engineering (NSE)", Category.CLASS
        ),
        Classification(
            "732", "Research and experimental development on social sciences and humanities (SSH)", Category.GROUP
        ),
        Classification(
            "7320", "Research and experimental development on social sciences and humanities (SSH)", Category.CLASS
        ),
        Classification("74", "Other business activities", Category.DIVISION),
        Classification(
            "741",
            "Legal, accounting, book-keeping and auditing activities; tax consultancy; market research and public o",
            Category.GROUP,
        ),
        Classification("7411", "Legal activities", Category.CLASS),
        Classification("7412", "Accounting, book-keeping and auditing activities; tax consultancy", Category.CLASS),
        Classification("7413", "Market research and public opinion polling", Category.CLASS),
        Classification("7414", "Business and management consultancy activities", Category.CLASS),
        Classification("742", "Architectural, engineering and other technical activities", Category.GROUP),
        Classification(
            "7421", "Architectural and engineering activities and related technical consultancy", Category.CLASS
        ),
        Classification("7422", "Technical testing and analysis", Category.CLASS),
        Classification("743", "Advertising", Category.GROUP),
        Classification("7430", "Advertising", Category.CLASS),
        Classification("749", "Business activities n.e.c.", Category.GROUP),
        Classification("7491", "Labour recruitment and provision of personnel", Category.CLASS),
        Classification("7492", "Investigation and security activities", Category.CLASS),
        Classification("7493", "Building-cleaning activities", Category.CLASS),
        Classification("7494", "Photographic activities", Category.CLASS),
        Classification("7495", "Packaging activities", Category.CLASS),
        Classification("7499", "Other business activities n.e.c.", Category.CLASS),
        Classification("L", "Public administration and defence; compulsory social security", Category.SECTION),
        Classification("75", "Public administration and defence; compulsory social security", Category.DIVISION),
        Classification(
            "751", "Administration of the State and the economic and social policy of the community", Category.GROUP
        ),
        Classification("7511", "General (Over-all) public service activities", Category.CLASS),
        Classification(
            "7512",
            "Regulation of the activities of agencies that provide health care, education, cultural services and ot",
            Category.CLASS,
        ),
        Classification(
            "7513", "Regulation of and contribution to more efficient operation of business", Category.CLASS
        ),
        Classification("7514", "Ancillary service activities for the government as a whole", Category.CLASS),
        Classification("752", "Provision of services to the community as a whole", Category.GROUP),
        Classification("7521", "Foreign affairs", Category.CLASS),
        Classification("7522", "Defence activities", Category.CLASS),
        Classification("7523", "Public order and safety activities", Category.CLASS),
        Classification("753", "Compulsory social security activities", Category.GROUP),
        Classification("7530", "Compulsory social security activities", Category.CLASS),
        Classification("M", "Education", Category.SECTION),
        Classification("80", "Education", Category.DIVISION),
        Classification("801", "Primary education", Category.GROUP),
        Classification("8010", "Primary education", Category.CLASS),
        Classification("802", "Secondary education", Category.GROUP),
        Classification("8021", "General secondary education", Category.CLASS),
        Classification("8022", "Technical and vocational secondary education", Category.CLASS),
        Classification("803", "Higher education", Category.GROUP),
        Classification("8030", "Higher education", Category.CLASS),
        Classification("809", "Adult and other education", Category.GROUP),
        Classification("8090", "Adult and other education", Category.CLASS),
        Classification("N", "Health and social work", Category.SECTION),
        Classification("85", "Health and social work", Category.DIVISION),
        Classification("851", "Human health activities", Category.GROUP),
        Classification("8511", "Hospital activities", Category.CLASS),
        Classification("8512", "Medical and dental practice activities", Category.CLASS),
        Classification("8519", "Other human health activities", Category.CLASS),
        Classification("852", "Veterinary activities", Category.GROUP),
        Classification("8520", "Veterinary activities", Category.CLASS),
        Classification("853", "Social work activities", Category.GROUP),
        Classification("8531", "Social work with accommodation", Category.CLASS),
        Classification("8532", "Social work without accommodation", Category.CLASS),
        Classification("O", "Other community, social and personal service activities", Category.SECTION),
        Classification("90", "Sewage and refuse disposal, sanitation and similar activities", Category.DIVISION),
        Classification("900", "Sewage and refuse disposal, sanitation and similar activities", Category.GROUP),
        Classification("9000", "Sewage and refuse disposal, sanitation and similar activities", Category.CLASS),
        Classification("91", "Activities of membership organizations n.e.c.", Category.DIVISION),
        Classification("911", "Activities of business, employers and professional organizations", Category.GROUP),
        Classification("9111", "Activities of business and employers organizations", Category.CLASS),
        Classification("9112", "Activities of professional organizations", Category.CLASS),
        Classification("912", "Activities of trade unions", Category.GROUP),
        Classification("9120", "Activities of trade unions", Category.CLASS),
        Classification("919", "Activities of other membership organizations", Category.GROUP),
        Classification("9191", "Activities of religious organizations", Category.CLASS),
        Classification("9192", "Activities of political organizations", Category.CLASS),
        Classification("9199", "Activities of other membership organizations n.e.c.", Category.CLASS),
        Classification("92", "Recreational, cultural and sporting activities", Category.DIVISION),
        Classification("921", "Motion picture, radio, television and other entertainment activities", Category.GROUP),
        Classification("9211", "Motion picture and video production and distribution", Category.CLASS),
        Classification("9212", "Motion picture projection", Category.CLASS),
        Classification("9213", "Radio and television activities", Category.CLASS),
        Classification("9214", "Dramatic arts, music and other arts activities", Category.CLASS),
        Classification("9219", "Other entertainment activities n.e.c.", Category.CLASS),
        Classification("922", "News agency activities", Category.GROUP),
        Classification("9220", "News agency activities", Category.CLASS),
        Classification("923", "Library, archives, museums and other cultural activities", Category.GROUP),
        Classification("9231", "Library and archives activities", Category.CLASS),
        Classification("9232", "Museums activities and preservation of historical sites and buildings", Category.CLASS),
        Classification("9233", "Botanical and zoological gardens and nature reserves activities", Category.CLASS),
        Classification("924", "Sporting and other recreational activities", Category.GROUP),
        Classification("9241", "Sporting activities", Category.CLASS),
        Classification("9249", "Other recreational activities", Category.CLASS),
        Classification("93", "Other service activities", Category.DIVISION),
        Classification("930", "Other service activities", Category.GROUP),
        Classification("9301", "Washing, and (dry-) cleaning of textile and fur products", Category.CLASS),
        Classification("9302", "Hairdressing and other beauty treatment", Category.CLASS),
        Classification("9303", "Funeral and related activities", Category.CLASS),
        Classification("9309", "Other service activities n.e.c.", Category.CLASS),
        Classification("P", "Private households with employed persons", Category.SECTION),
        Classification("95", "Private households with employed persons", Category.DIVISION),
        Classification("950", "Private households with employed persons", Category.GROUP),
        Classification("9500", "Private households with employed persons", Category.CLASS),
        Classification("Q", "Extra-territorial organizations and bodies", Category.SECTION),
        Classification("99", "Extra-territorial organizations and bodies", Category.DIVISION),
        Classification("990", "Extra-territorial organizations and bodies", Category.GROUP),
        Classification("9900", "Extra-territorial organizations and bodies", Category.CLASS),
    ],
)
