"""`Concordance between GCED2011 and NACE2 <http://www.stat.kg/stat.files/class.files/%D0%BF%D1%80%D0%BE%D0%B5%D0%BA%D1%82%20%D0%93%D0%9A%D0%AD%D0%94-3.pdf>_`.

All GCED2011 codes that are 4 digits long or less map directly to the same NACE2 code, but not including two letter
codes.
"""
from ...types import Concordance, Standards
from ..nace2 import NACE2
from . import GCED2011

GCED2011_to_NACE2 = Concordance(
    src=GCED2011,
    dst=NACE2,
    concordances=[
        ((Standards.GCED2011, "A"), (Standards.NACE2, "A")),
        ((Standards.GCED2011, "01"), (Standards.NACE2, "01")),
        ((Standards.GCED2011, "01.1"), (Standards.NACE2, "01.1")),
        ((Standards.GCED2011, "01.11"), (Standards.NACE2, "01.11")),
        ((Standards.GCED2011, "01.12"), (Standards.NACE2, "01.12")),
        ((Standards.GCED2011, "01.13"), (Standards.NACE2, "01.13")),
        ((Standards.GCED2011, "01.14"), (Standards.NACE2, "01.14")),
        ((Standards.GCED2011, "01.15"), (Standards.NACE2, "01.15")),
        ((Standards.GCED2011, "01.16"), (Standards.NACE2, "01.16")),
        ((Standards.GCED2011, "01.19"), (Standards.NACE2, "01.19")),
        ((Standards.GCED2011, "01.2"), (Standards.NACE2, "01.2")),
        ((Standards.GCED2011, "01.21"), (Standards.NACE2, "01.21")),
        ((Standards.GCED2011, "01.22"), (Standards.NACE2, "01.22")),
        ((Standards.GCED2011, "01.23"), (Standards.NACE2, "01.23")),
        ((Standards.GCED2011, "01.24"), (Standards.NACE2, "01.24")),
        ((Standards.GCED2011, "01.25"), (Standards.NACE2, "01.25")),
        ((Standards.GCED2011, "01.26"), (Standards.NACE2, "01.26")),
        ((Standards.GCED2011, "01.27"), (Standards.NACE2, "01.27")),
        ((Standards.GCED2011, "01.28"), (Standards.NACE2, "01.28")),
        ((Standards.GCED2011, "01.29"), (Standards.NACE2, "01.29")),
        ((Standards.GCED2011, "01.3"), (Standards.NACE2, "01.3")),
        ((Standards.GCED2011, "01.30"), (Standards.NACE2, "01.30")),
        ((Standards.GCED2011, "01.4"), (Standards.NACE2, "01.4")),
        ((Standards.GCED2011, "01.41"), (Standards.NACE2, "01.41")),
        ((Standards.GCED2011, "01.42"), (Standards.NACE2, "01.42")),
        ((Standards.GCED2011, "01.43"), (Standards.NACE2, "01.43")),
        ((Standards.GCED2011, "01.44"), (Standards.NACE2, "01.44")),
        ((Standards.GCED2011, "01.45"), (Standards.NACE2, "01.45")),
        ((Standards.GCED2011, "01.46"), (Standards.NACE2, "01.46")),
        ((Standards.GCED2011, "01.47"), (Standards.NACE2, "01.47")),
        ((Standards.GCED2011, "01.49"), (Standards.NACE2, "01.49")),
        ((Standards.GCED2011, "01.5"), (Standards.NACE2, "01.5")),
        ((Standards.GCED2011, "01.50"), (Standards.NACE2, "01.50")),
        ((Standards.GCED2011, "01.6"), (Standards.NACE2, "01.6")),
        ((Standards.GCED2011, "01.61"), (Standards.NACE2, "01.61")),
        ((Standards.GCED2011, "01.62"), (Standards.NACE2, "01.62")),
        ((Standards.GCED2011, "01.63"), (Standards.NACE2, "01.63")),
        ((Standards.GCED2011, "01.64"), (Standards.NACE2, "01.64")),
        ((Standards.GCED2011, "01.7"), (Standards.NACE2, "01.7")),
        ((Standards.GCED2011, "01.70"), (Standards.NACE2, "01.70")),
        ((Standards.GCED2011, "02"), (Standards.NACE2, "02")),
        ((Standards.GCED2011, "02.1"), (Standards.NACE2, "02.1")),
        ((Standards.GCED2011, "02.10"), (Standards.NACE2, "02.10")),
        ((Standards.GCED2011, "02.2"), (Standards.NACE2, "02.2")),
        ((Standards.GCED2011, "02.20"), (Standards.NACE2, "02.20")),
        ((Standards.GCED2011, "02.3"), (Standards.NACE2, "02.3")),
        ((Standards.GCED2011, "02.30"), (Standards.NACE2, "02.30")),
        ((Standards.GCED2011, "02.4"), (Standards.NACE2, "02.4")),
        ((Standards.GCED2011, "02.40"), (Standards.NACE2, "02.40")),
        ((Standards.GCED2011, "03"), (Standards.NACE2, "03")),
        ((Standards.GCED2011, "03.1"), (Standards.NACE2, "03.1")),
        ((Standards.GCED2011, "03.12"), (Standards.NACE2, "03.12")),
        ((Standards.GCED2011, "03.2"), (Standards.NACE2, "03.2")),
        ((Standards.GCED2011, "03.22"), (Standards.NACE2, "03.22")),
        ((Standards.GCED2011, "B"), (Standards.NACE2, "B")),
        ((Standards.GCED2011, "05"), (Standards.NACE2, "05")),
        ((Standards.GCED2011, "05.1"), (Standards.NACE2, "05.1")),
        ((Standards.GCED2011, "05.10"), (Standards.NACE2, "05.10")),
        ((Standards.GCED2011, "05.2"), (Standards.NACE2, "05.2")),
        ((Standards.GCED2011, "05.20"), (Standards.NACE2, "05.20")),
        ((Standards.GCED2011, "06"), (Standards.NACE2, "06")),
        ((Standards.GCED2011, "06.1"), (Standards.NACE2, "06.1")),
        ((Standards.GCED2011, "06.10"), (Standards.NACE2, "06.10")),
        ((Standards.GCED2011, "06.2"), (Standards.NACE2, "06.2")),
        ((Standards.GCED2011, "06.20"), (Standards.NACE2, "06.20")),
        ((Standards.GCED2011, "07"), (Standards.NACE2, "07")),
        ((Standards.GCED2011, "07.1"), (Standards.NACE2, "07.1")),
        ((Standards.GCED2011, "07.10"), (Standards.NACE2, "07.10")),
        ((Standards.GCED2011, "07.2"), (Standards.NACE2, "07.2")),
        ((Standards.GCED2011, "07.21"), (Standards.NACE2, "07.21")),
        ((Standards.GCED2011, "07.29"), (Standards.NACE2, "07.29")),
        ((Standards.GCED2011, "08"), (Standards.NACE2, "08")),
        ((Standards.GCED2011, "08.1"), (Standards.NACE2, "08.1")),
        ((Standards.GCED2011, "08.11"), (Standards.NACE2, "08.11")),
        ((Standards.GCED2011, "08.12"), (Standards.NACE2, "08.12")),
        ((Standards.GCED2011, "08.9"), (Standards.NACE2, "08.9")),
        ((Standards.GCED2011, "08.91"), (Standards.NACE2, "08.91")),
        ((Standards.GCED2011, "08.92"), (Standards.NACE2, "08.92")),
        ((Standards.GCED2011, "08.93"), (Standards.NACE2, "08.93")),
        ((Standards.GCED2011, "08.99"), (Standards.NACE2, "08.99")),
        ((Standards.GCED2011, "09"), (Standards.NACE2, "09")),
        ((Standards.GCED2011, "09.1"), (Standards.NACE2, "09.1")),
        ((Standards.GCED2011, "09.10"), (Standards.NACE2, "09.10")),
        ((Standards.GCED2011, "09.9"), (Standards.NACE2, "09.9")),
        ((Standards.GCED2011, "09.90"), (Standards.NACE2, "09.90")),
        ((Standards.GCED2011, "C"), (Standards.NACE2, "C")),
        ((Standards.GCED2011, "10"), (Standards.NACE2, "10")),
        ((Standards.GCED2011, "10.1"), (Standards.NACE2, "10.1")),
        ((Standards.GCED2011, "10.11"), (Standards.NACE2, "10.11")),
        ((Standards.GCED2011, "10.12"), (Standards.NACE2, "10.12")),
        ((Standards.GCED2011, "10.13"), (Standards.NACE2, "10.13")),
        ((Standards.GCED2011, "10.2"), (Standards.NACE2, "10.2")),
        ((Standards.GCED2011, "10.20"), (Standards.NACE2, "10.20")),
        ((Standards.GCED2011, "10.3"), (Standards.NACE2, "10.3")),
        ((Standards.GCED2011, "10.31"), (Standards.NACE2, "10.31")),
        ((Standards.GCED2011, "10.32"), (Standards.NACE2, "10.32")),
        ((Standards.GCED2011, "10.39"), (Standards.NACE2, "10.39")),
        ((Standards.GCED2011, "10.4"), (Standards.NACE2, "10.4")),
        ((Standards.GCED2011, "10.41"), (Standards.NACE2, "10.41")),
        ((Standards.GCED2011, "10.42"), (Standards.NACE2, "10.42")),
        ((Standards.GCED2011, "10.5"), (Standards.NACE2, "10.5")),
        ((Standards.GCED2011, "10.51"), (Standards.NACE2, "10.51")),
        ((Standards.GCED2011, "10.52"), (Standards.NACE2, "10.52")),
        ((Standards.GCED2011, "10.6"), (Standards.NACE2, "10.6")),
        ((Standards.GCED2011, "10.61"), (Standards.NACE2, "10.61")),
        ((Standards.GCED2011, "10.62"), (Standards.NACE2, "10.62")),
        ((Standards.GCED2011, "10.7"), (Standards.NACE2, "10.7")),
        ((Standards.GCED2011, "10.71"), (Standards.NACE2, "10.71")),
        ((Standards.GCED2011, "10.72"), (Standards.NACE2, "10.72")),
        ((Standards.GCED2011, "10.73"), (Standards.NACE2, "10.73")),
        ((Standards.GCED2011, "10.8"), (Standards.NACE2, "10.8")),
        ((Standards.GCED2011, "10.81"), (Standards.NACE2, "10.81")),
        ((Standards.GCED2011, "10.82"), (Standards.NACE2, "10.82")),
        ((Standards.GCED2011, "10.83"), (Standards.NACE2, "10.83")),
        ((Standards.GCED2011, "10.84"), (Standards.NACE2, "10.84")),
        ((Standards.GCED2011, "10.85"), (Standards.NACE2, "10.85")),
        ((Standards.GCED2011, "10.86"), (Standards.NACE2, "10.86")),
        ((Standards.GCED2011, "10.89"), (Standards.NACE2, "10.89")),
        ((Standards.GCED2011, "10.9"), (Standards.NACE2, "10.9")),
        ((Standards.GCED2011, "10.91"), (Standards.NACE2, "10.91")),
        ((Standards.GCED2011, "10.92"), (Standards.NACE2, "10.92")),
        ((Standards.GCED2011, "11"), (Standards.NACE2, "11")),
        ((Standards.GCED2011, "11.0"), (Standards.NACE2, "11.0")),
        ((Standards.GCED2011, "11.01"), (Standards.NACE2, "11.01")),
        ((Standards.GCED2011, "11.02"), (Standards.NACE2, "11.02")),
        ((Standards.GCED2011, "11.03"), (Standards.NACE2, "11.03")),
        ((Standards.GCED2011, "11.04"), (Standards.NACE2, "11.04")),
        ((Standards.GCED2011, "11.05"), (Standards.NACE2, "11.05")),
        ((Standards.GCED2011, "11.06"), (Standards.NACE2, "11.06")),
        ((Standards.GCED2011, "11.07"), (Standards.NACE2, "11.07")),
        ((Standards.GCED2011, "12"), (Standards.NACE2, "12")),
        ((Standards.GCED2011, "12.0"), (Standards.NACE2, "12.0")),
        ((Standards.GCED2011, "12.00"), (Standards.NACE2, "12.00")),
        ((Standards.GCED2011, "13"), (Standards.NACE2, "13")),
        ((Standards.GCED2011, "13.1"), (Standards.NACE2, "13.1")),
        ((Standards.GCED2011, "13.10"), (Standards.NACE2, "13.10")),
        ((Standards.GCED2011, "13.2"), (Standards.NACE2, "13.2")),
        ((Standards.GCED2011, "13.20"), (Standards.NACE2, "13.20")),
        ((Standards.GCED2011, "13.3"), (Standards.NACE2, "13.3")),
        ((Standards.GCED2011, "13.30"), (Standards.NACE2, "13.30")),
        ((Standards.GCED2011, "13.9"), (Standards.NACE2, "13.9")),
        ((Standards.GCED2011, "13.91"), (Standards.NACE2, "13.91")),
        ((Standards.GCED2011, "13.92"), (Standards.NACE2, "13.92")),
        ((Standards.GCED2011, "13.93"), (Standards.NACE2, "13.93")),
        ((Standards.GCED2011, "13.94"), (Standards.NACE2, "13.94")),
        ((Standards.GCED2011, "13.95"), (Standards.NACE2, "13.95")),
        ((Standards.GCED2011, "13.96"), (Standards.NACE2, "13.96")),
        ((Standards.GCED2011, "13.99"), (Standards.NACE2, "13.99")),
        ((Standards.GCED2011, "14"), (Standards.NACE2, "14")),
        ((Standards.GCED2011, "14.1"), (Standards.NACE2, "14.1")),
        ((Standards.GCED2011, "14.11"), (Standards.NACE2, "14.11")),
        ((Standards.GCED2011, "14.12"), (Standards.NACE2, "14.12")),
        ((Standards.GCED2011, "14.13"), (Standards.NACE2, "14.13")),
        ((Standards.GCED2011, "14.14"), (Standards.NACE2, "14.14")),
        ((Standards.GCED2011, "14.19"), (Standards.NACE2, "14.19")),
        ((Standards.GCED2011, "14.2"), (Standards.NACE2, "14.2")),
        ((Standards.GCED2011, "14.20"), (Standards.NACE2, "14.20")),
        ((Standards.GCED2011, "14.3"), (Standards.NACE2, "14.3")),
        ((Standards.GCED2011, "14.31"), (Standards.NACE2, "14.31")),
        ((Standards.GCED2011, "14.39"), (Standards.NACE2, "14.39")),
        ((Standards.GCED2011, "15"), (Standards.NACE2, "15")),
        ((Standards.GCED2011, "15.1"), (Standards.NACE2, "15.1")),
        ((Standards.GCED2011, "15.11"), (Standards.NACE2, "15.11")),
        ((Standards.GCED2011, "15.12"), (Standards.NACE2, "15.12")),
        ((Standards.GCED2011, "15.2"), (Standards.NACE2, "15.2")),
        ((Standards.GCED2011, "15.20"), (Standards.NACE2, "15.20")),
        ((Standards.GCED2011, "16"), (Standards.NACE2, "16")),
        ((Standards.GCED2011, "16.1"), (Standards.NACE2, "16.1")),
        ((Standards.GCED2011, "16.10"), (Standards.NACE2, "16.10")),
        ((Standards.GCED2011, "16.2"), (Standards.NACE2, "16.2")),
        ((Standards.GCED2011, "16.21"), (Standards.NACE2, "16.21")),
        ((Standards.GCED2011, "16.22"), (Standards.NACE2, "16.22")),
        ((Standards.GCED2011, "16.23"), (Standards.NACE2, "16.23")),
        ((Standards.GCED2011, "16.24"), (Standards.NACE2, "16.24")),
        ((Standards.GCED2011, "16.29"), (Standards.NACE2, "16.29")),
        ((Standards.GCED2011, "17"), (Standards.NACE2, "17")),
        ((Standards.GCED2011, "17.1"), (Standards.NACE2, "17.1")),
        ((Standards.GCED2011, "17.11"), (Standards.NACE2, "17.11")),
        ((Standards.GCED2011, "17.12"), (Standards.NACE2, "17.12")),
        ((Standards.GCED2011, "17.2"), (Standards.NACE2, "17.2")),
        ((Standards.GCED2011, "17.21"), (Standards.NACE2, "17.21")),
        ((Standards.GCED2011, "17.22"), (Standards.NACE2, "17.22")),
        ((Standards.GCED2011, "17.23"), (Standards.NACE2, "17.23")),
        ((Standards.GCED2011, "17.24"), (Standards.NACE2, "17.24")),
        ((Standards.GCED2011, "17.29"), (Standards.NACE2, "17.29")),
        ((Standards.GCED2011, "18"), (Standards.NACE2, "18")),
        ((Standards.GCED2011, "18.1"), (Standards.NACE2, "18.1")),
        ((Standards.GCED2011, "18.11"), (Standards.NACE2, "18.11")),
        ((Standards.GCED2011, "18.12"), (Standards.NACE2, "18.12")),
        ((Standards.GCED2011, "18.13"), (Standards.NACE2, "18.13")),
        ((Standards.GCED2011, "18.14"), (Standards.NACE2, "18.14")),
        ((Standards.GCED2011, "18.2"), (Standards.NACE2, "18.2")),
        ((Standards.GCED2011, "18.20"), (Standards.NACE2, "18.20")),
        ((Standards.GCED2011, "19"), (Standards.NACE2, "19")),
        ((Standards.GCED2011, "19.1"), (Standards.NACE2, "19.1")),
        ((Standards.GCED2011, "19.10"), (Standards.NACE2, "19.10")),
        ((Standards.GCED2011, "19.2"), (Standards.NACE2, "19.2")),
        ((Standards.GCED2011, "19.20"), (Standards.NACE2, "19.20")),
        ((Standards.GCED2011, "20"), (Standards.NACE2, "20")),
        ((Standards.GCED2011, "20.1"), (Standards.NACE2, "20.1")),
        ((Standards.GCED2011, "20.11"), (Standards.NACE2, "20.11")),
        ((Standards.GCED2011, "20.12"), (Standards.NACE2, "20.12")),
        ((Standards.GCED2011, "20.13"), (Standards.NACE2, "20.13")),
        ((Standards.GCED2011, "20.14"), (Standards.NACE2, "20.14")),
        ((Standards.GCED2011, "20.15"), (Standards.NACE2, "20.15")),
        ((Standards.GCED2011, "20.16"), (Standards.NACE2, "20.16")),
        ((Standards.GCED2011, "20.17"), (Standards.NACE2, "20.17")),
        ((Standards.GCED2011, "20.2"), (Standards.NACE2, "20.2")),
        ((Standards.GCED2011, "20.20"), (Standards.NACE2, "20.20")),
        ((Standards.GCED2011, "20.3"), (Standards.NACE2, "20.3")),
        ((Standards.GCED2011, "20.30"), (Standards.NACE2, "20.30")),
        ((Standards.GCED2011, "20.4"), (Standards.NACE2, "20.4")),
        ((Standards.GCED2011, "20.41"), (Standards.NACE2, "20.41")),
        ((Standards.GCED2011, "20.42"), (Standards.NACE2, "20.42")),
        ((Standards.GCED2011, "20.5"), (Standards.NACE2, "20.5")),
        ((Standards.GCED2011, "20.51"), (Standards.NACE2, "20.51")),
        ((Standards.GCED2011, "20.52"), (Standards.NACE2, "20.52")),
        ((Standards.GCED2011, "20.53"), (Standards.NACE2, "20.53")),
        ((Standards.GCED2011, "20.59"), (Standards.NACE2, "20.59")),
        ((Standards.GCED2011, "20.6"), (Standards.NACE2, "20.6")),
        ((Standards.GCED2011, "20.60"), (Standards.NACE2, "20.60")),
        ((Standards.GCED2011, "21"), (Standards.NACE2, "21")),
        ((Standards.GCED2011, "21.1"), (Standards.NACE2, "21.1")),
        ((Standards.GCED2011, "21.10"), (Standards.NACE2, "21.10")),
        ((Standards.GCED2011, "21.2"), (Standards.NACE2, "21.2")),
        ((Standards.GCED2011, "21.20"), (Standards.NACE2, "21.20")),
        ((Standards.GCED2011, "22"), (Standards.NACE2, "22")),
        ((Standards.GCED2011, "22.1"), (Standards.NACE2, "22.1")),
        ((Standards.GCED2011, "22.11"), (Standards.NACE2, "22.11")),
        ((Standards.GCED2011, "22.19"), (Standards.NACE2, "22.19")),
        ((Standards.GCED2011, "22.2"), (Standards.NACE2, "22.2")),
        ((Standards.GCED2011, "22.21"), (Standards.NACE2, "22.21")),
        ((Standards.GCED2011, "22.22"), (Standards.NACE2, "22.22")),
        ((Standards.GCED2011, "22.23"), (Standards.NACE2, "22.23")),
        ((Standards.GCED2011, "22.29"), (Standards.NACE2, "22.29")),
        ((Standards.GCED2011, "23"), (Standards.NACE2, "23")),
        ((Standards.GCED2011, "23.1"), (Standards.NACE2, "23.1")),
        ((Standards.GCED2011, "23.11"), (Standards.NACE2, "23.11")),
        ((Standards.GCED2011, "23.12"), (Standards.NACE2, "23.12")),
        ((Standards.GCED2011, "23.13"), (Standards.NACE2, "23.13")),
        ((Standards.GCED2011, "23.14"), (Standards.NACE2, "23.14")),
        ((Standards.GCED2011, "23.19"), (Standards.NACE2, "23.19")),
        ((Standards.GCED2011, "23.2"), (Standards.NACE2, "23.2")),
        ((Standards.GCED2011, "23.20"), (Standards.NACE2, "23.20")),
        ((Standards.GCED2011, "23.3"), (Standards.NACE2, "23.3")),
        ((Standards.GCED2011, "23.31"), (Standards.NACE2, "23.31")),
        ((Standards.GCED2011, "23.32"), (Standards.NACE2, "23.32")),
        ((Standards.GCED2011, "23.4"), (Standards.NACE2, "23.4")),
        ((Standards.GCED2011, "23.41"), (Standards.NACE2, "23.41")),
        ((Standards.GCED2011, "23.42"), (Standards.NACE2, "23.42")),
        ((Standards.GCED2011, "23.43"), (Standards.NACE2, "23.43")),
        ((Standards.GCED2011, "23.44"), (Standards.NACE2, "23.44")),
        ((Standards.GCED2011, "23.49"), (Standards.NACE2, "23.49")),
        ((Standards.GCED2011, "23.5"), (Standards.NACE2, "23.5")),
        ((Standards.GCED2011, "23.51"), (Standards.NACE2, "23.51")),
        ((Standards.GCED2011, "23.52"), (Standards.NACE2, "23.52")),
        ((Standards.GCED2011, "23.6"), (Standards.NACE2, "23.6")),
        ((Standards.GCED2011, "23.61"), (Standards.NACE2, "23.61")),
        ((Standards.GCED2011, "23.62"), (Standards.NACE2, "23.62")),
        ((Standards.GCED2011, "23.63"), (Standards.NACE2, "23.63")),
        ((Standards.GCED2011, "23.64"), (Standards.NACE2, "23.64")),
        ((Standards.GCED2011, "23.65"), (Standards.NACE2, "23.65")),
        ((Standards.GCED2011, "23.69"), (Standards.NACE2, "23.69")),
        ((Standards.GCED2011, "23.7"), (Standards.NACE2, "23.7")),
        ((Standards.GCED2011, "23.70"), (Standards.NACE2, "23.70")),
        ((Standards.GCED2011, "23.9"), (Standards.NACE2, "23.9")),
        ((Standards.GCED2011, "23.91"), (Standards.NACE2, "23.91")),
        ((Standards.GCED2011, "23.99"), (Standards.NACE2, "23.99")),
        ((Standards.GCED2011, "24"), (Standards.NACE2, "24")),
        ((Standards.GCED2011, "24.1"), (Standards.NACE2, "24.1")),
        ((Standards.GCED2011, "24.10"), (Standards.NACE2, "24.10")),
        ((Standards.GCED2011, "24.2"), (Standards.NACE2, "24.2")),
        ((Standards.GCED2011, "24.20"), (Standards.NACE2, "24.20")),
        ((Standards.GCED2011, "24.3"), (Standards.NACE2, "24.3")),
        ((Standards.GCED2011, "24.31"), (Standards.NACE2, "24.31")),
        ((Standards.GCED2011, "24.32"), (Standards.NACE2, "24.32")),
        ((Standards.GCED2011, "24.33"), (Standards.NACE2, "24.33")),
        ((Standards.GCED2011, "24.34"), (Standards.NACE2, "24.34")),
        ((Standards.GCED2011, "24.4"), (Standards.NACE2, "24.4")),
        ((Standards.GCED2011, "24.41"), (Standards.NACE2, "24.41")),
        ((Standards.GCED2011, "24.42"), (Standards.NACE2, "24.42")),
        ((Standards.GCED2011, "24.43"), (Standards.NACE2, "24.43")),
        ((Standards.GCED2011, "24.44"), (Standards.NACE2, "24.44")),
        ((Standards.GCED2011, "24.45"), (Standards.NACE2, "24.45")),
        ((Standards.GCED2011, "24.46"), (Standards.NACE2, "24.46")),
        ((Standards.GCED2011, "24.5"), (Standards.NACE2, "24.5")),
        ((Standards.GCED2011, "24.51"), (Standards.NACE2, "24.51")),
        ((Standards.GCED2011, "24.52"), (Standards.NACE2, "24.52")),
        ((Standards.GCED2011, "24.53"), (Standards.NACE2, "24.53")),
        ((Standards.GCED2011, "24.54"), (Standards.NACE2, "24.54")),
        ((Standards.GCED2011, "25"), (Standards.NACE2, "25")),
        ((Standards.GCED2011, "25.1"), (Standards.NACE2, "25.1")),
        ((Standards.GCED2011, "25.11"), (Standards.NACE2, "25.11")),
        ((Standards.GCED2011, "25.12"), (Standards.NACE2, "25.12")),
        ((Standards.GCED2011, "25.2"), (Standards.NACE2, "25.2")),
        ((Standards.GCED2011, "25.21"), (Standards.NACE2, "25.21")),
        ((Standards.GCED2011, "25.29"), (Standards.NACE2, "25.29")),
        ((Standards.GCED2011, "25.3"), (Standards.NACE2, "25.3")),
        ((Standards.GCED2011, "25.30"), (Standards.NACE2, "25.30")),
        ((Standards.GCED2011, "25.4"), (Standards.NACE2, "25.4")),
        ((Standards.GCED2011, "25.40"), (Standards.NACE2, "25.40")),
        ((Standards.GCED2011, "25.5"), (Standards.NACE2, "25.5")),
        ((Standards.GCED2011, "25.50"), (Standards.NACE2, "25.50")),
        ((Standards.GCED2011, "25.6"), (Standards.NACE2, "25.6")),
        ((Standards.GCED2011, "25.61"), (Standards.NACE2, "25.61")),
        ((Standards.GCED2011, "25.62"), (Standards.NACE2, "25.62")),
        ((Standards.GCED2011, "25.7"), (Standards.NACE2, "25.7")),
        ((Standards.GCED2011, "25.71"), (Standards.NACE2, "25.71")),
        ((Standards.GCED2011, "25.72"), (Standards.NACE2, "25.72")),
        ((Standards.GCED2011, "25.73"), (Standards.NACE2, "25.73")),
        ((Standards.GCED2011, "25.9"), (Standards.NACE2, "25.9")),
        ((Standards.GCED2011, "25.91"), (Standards.NACE2, "25.91")),
        ((Standards.GCED2011, "25.92"), (Standards.NACE2, "25.92")),
        ((Standards.GCED2011, "25.93"), (Standards.NACE2, "25.93")),
        ((Standards.GCED2011, "25.94"), (Standards.NACE2, "25.94")),
        ((Standards.GCED2011, "25.99"), (Standards.NACE2, "25.99")),
        ((Standards.GCED2011, "26"), (Standards.NACE2, "26")),
        ((Standards.GCED2011, "26.1"), (Standards.NACE2, "26.1")),
        ((Standards.GCED2011, "26.11"), (Standards.NACE2, "26.11")),
        ((Standards.GCED2011, "26.12"), (Standards.NACE2, "26.12")),
        ((Standards.GCED2011, "26.2"), (Standards.NACE2, "26.2")),
        ((Standards.GCED2011, "26.20"), (Standards.NACE2, "26.20")),
        ((Standards.GCED2011, "26.3"), (Standards.NACE2, "26.3")),
        ((Standards.GCED2011, "26.30"), (Standards.NACE2, "26.30")),
        ((Standards.GCED2011, "26.4"), (Standards.NACE2, "26.4")),
        ((Standards.GCED2011, "26.40"), (Standards.NACE2, "26.40")),
        ((Standards.GCED2011, "26.5"), (Standards.NACE2, "26.5")),
        ((Standards.GCED2011, "26.51"), (Standards.NACE2, "26.51")),
        ((Standards.GCED2011, "26.52"), (Standards.NACE2, "26.52")),
        ((Standards.GCED2011, "26.6"), (Standards.NACE2, "26.6")),
        ((Standards.GCED2011, "26.60"), (Standards.NACE2, "26.60")),
        ((Standards.GCED2011, "26.7"), (Standards.NACE2, "26.7")),
        ((Standards.GCED2011, "26.70"), (Standards.NACE2, "26.70")),
        ((Standards.GCED2011, "26.8"), (Standards.NACE2, "26.8")),
        ((Standards.GCED2011, "26.80"), (Standards.NACE2, "26.80")),
        ((Standards.GCED2011, "27"), (Standards.NACE2, "27")),
        ((Standards.GCED2011, "27.1"), (Standards.NACE2, "27.1")),
        ((Standards.GCED2011, "27.11"), (Standards.NACE2, "27.11")),
        ((Standards.GCED2011, "27.12"), (Standards.NACE2, "27.12")),
        ((Standards.GCED2011, "27.2"), (Standards.NACE2, "27.2")),
        ((Standards.GCED2011, "27.20"), (Standards.NACE2, "27.20")),
        ((Standards.GCED2011, "27.3"), (Standards.NACE2, "27.3")),
        ((Standards.GCED2011, "27.31"), (Standards.NACE2, "27.31")),
        ((Standards.GCED2011, "27.32"), (Standards.NACE2, "27.32")),
        ((Standards.GCED2011, "27.33"), (Standards.NACE2, "27.33")),
        ((Standards.GCED2011, "27.4"), (Standards.NACE2, "27.4")),
        ((Standards.GCED2011, "27.40"), (Standards.NACE2, "27.40")),
        ((Standards.GCED2011, "27.5"), (Standards.NACE2, "27.5")),
        ((Standards.GCED2011, "27.51"), (Standards.NACE2, "27.51")),
        ((Standards.GCED2011, "27.52"), (Standards.NACE2, "27.52")),
        ((Standards.GCED2011, "27.9"), (Standards.NACE2, "27.9")),
        ((Standards.GCED2011, "27.90"), (Standards.NACE2, "27.90")),
        ((Standards.GCED2011, "28"), (Standards.NACE2, "28")),
        ((Standards.GCED2011, "28.1"), (Standards.NACE2, "28.1")),
        ((Standards.GCED2011, "28.11"), (Standards.NACE2, "28.11")),
        ((Standards.GCED2011, "28.12"), (Standards.NACE2, "28.12")),
        ((Standards.GCED2011, "28.13"), (Standards.NACE2, "28.13")),
        ((Standards.GCED2011, "28.14"), (Standards.NACE2, "28.14")),
        ((Standards.GCED2011, "28.15"), (Standards.NACE2, "28.15")),
        ((Standards.GCED2011, "28.2"), (Standards.NACE2, "28.2")),
        ((Standards.GCED2011, "28.21"), (Standards.NACE2, "28.21")),
        ((Standards.GCED2011, "28.22"), (Standards.NACE2, "28.22")),
        ((Standards.GCED2011, "28.23"), (Standards.NACE2, "28.23")),
        ((Standards.GCED2011, "28.24"), (Standards.NACE2, "28.24")),
        ((Standards.GCED2011, "28.25"), (Standards.NACE2, "28.25")),
        ((Standards.GCED2011, "28.29"), (Standards.NACE2, "28.29")),
        ((Standards.GCED2011, "28.3"), (Standards.NACE2, "28.3")),
        ((Standards.GCED2011, "28.30"), (Standards.NACE2, "28.30")),
        ((Standards.GCED2011, "28.4"), (Standards.NACE2, "28.4")),
        ((Standards.GCED2011, "28.41"), (Standards.NACE2, "28.41")),
        ((Standards.GCED2011, "28.49"), (Standards.NACE2, "28.49")),
        ((Standards.GCED2011, "28.9"), (Standards.NACE2, "28.9")),
        ((Standards.GCED2011, "28.91"), (Standards.NACE2, "28.91")),
        ((Standards.GCED2011, "28.92"), (Standards.NACE2, "28.92")),
        ((Standards.GCED2011, "28.93"), (Standards.NACE2, "28.93")),
        ((Standards.GCED2011, "28.94"), (Standards.NACE2, "28.94")),
        ((Standards.GCED2011, "28.95"), (Standards.NACE2, "28.95")),
        ((Standards.GCED2011, "28.96"), (Standards.NACE2, "28.96")),
        ((Standards.GCED2011, "28.99"), (Standards.NACE2, "28.99")),
        ((Standards.GCED2011, "29"), (Standards.NACE2, "29")),
        ((Standards.GCED2011, "29.1"), (Standards.NACE2, "29.1")),
        ((Standards.GCED2011, "29.10"), (Standards.NACE2, "29.10")),
        ((Standards.GCED2011, "29.2"), (Standards.NACE2, "29.2")),
        ((Standards.GCED2011, "29.20"), (Standards.NACE2, "29.20")),
        ((Standards.GCED2011, "29.3"), (Standards.NACE2, "29.3")),
        ((Standards.GCED2011, "29.31"), (Standards.NACE2, "29.31")),
        ((Standards.GCED2011, "29.32"), (Standards.NACE2, "29.32")),
        ((Standards.GCED2011, "30"), (Standards.NACE2, "30")),
        ((Standards.GCED2011, "30.1"), (Standards.NACE2, "30.1")),
        ((Standards.GCED2011, "30.11"), (Standards.NACE2, "30.11")),
        ((Standards.GCED2011, "30.12"), (Standards.NACE2, "30.12")),
        ((Standards.GCED2011, "30.2"), (Standards.NACE2, "30.2")),
        ((Standards.GCED2011, "30.20"), (Standards.NACE2, "30.20")),
        ((Standards.GCED2011, "30.3"), (Standards.NACE2, "30.3")),
        ((Standards.GCED2011, "30.30"), (Standards.NACE2, "30.30")),
        ((Standards.GCED2011, "30.4"), (Standards.NACE2, "30.4")),
        ((Standards.GCED2011, "30.40"), (Standards.NACE2, "30.40")),
        ((Standards.GCED2011, "30.9"), (Standards.NACE2, "30.9")),
        ((Standards.GCED2011, "30.91"), (Standards.NACE2, "30.91")),
        ((Standards.GCED2011, "30.92"), (Standards.NACE2, "30.92")),
        ((Standards.GCED2011, "30.99"), (Standards.NACE2, "30.99")),
        ((Standards.GCED2011, "31"), (Standards.NACE2, "31")),
        ((Standards.GCED2011, "31.0"), (Standards.NACE2, "31.0")),
        ((Standards.GCED2011, "31.01"), (Standards.NACE2, "31.01")),
        ((Standards.GCED2011, "31.02"), (Standards.NACE2, "31.02")),
        ((Standards.GCED2011, "31.03"), (Standards.NACE2, "31.03")),
        ((Standards.GCED2011, "31.09"), (Standards.NACE2, "31.09")),
        ((Standards.GCED2011, "32"), (Standards.NACE2, "32")),
        ((Standards.GCED2011, "32.1"), (Standards.NACE2, "32.1")),
        ((Standards.GCED2011, "32.11"), (Standards.NACE2, "32.11")),
        ((Standards.GCED2011, "32.12"), (Standards.NACE2, "32.12")),
        ((Standards.GCED2011, "32.13"), (Standards.NACE2, "32.13")),
        ((Standards.GCED2011, "32.2"), (Standards.NACE2, "32.2")),
        ((Standards.GCED2011, "32.20"), (Standards.NACE2, "32.20")),
        ((Standards.GCED2011, "32.3"), (Standards.NACE2, "32.3")),
        ((Standards.GCED2011, "32.30"), (Standards.NACE2, "32.30")),
        ((Standards.GCED2011, "32.4"), (Standards.NACE2, "32.4")),
        ((Standards.GCED2011, "32.40"), (Standards.NACE2, "32.40")),
        ((Standards.GCED2011, "32.5"), (Standards.NACE2, "32.5")),
        ((Standards.GCED2011, "32.50"), (Standards.NACE2, "32.50")),
        ((Standards.GCED2011, "32.9"), (Standards.NACE2, "32.9")),
        ((Standards.GCED2011, "32.91"), (Standards.NACE2, "32.91")),
        ((Standards.GCED2011, "32.99"), (Standards.NACE2, "32.99")),
        ((Standards.GCED2011, "33"), (Standards.NACE2, "33")),
        ((Standards.GCED2011, "33.1"), (Standards.NACE2, "33.1")),
        ((Standards.GCED2011, "33.11"), (Standards.NACE2, "33.11")),
        ((Standards.GCED2011, "33.12"), (Standards.NACE2, "33.12")),
        ((Standards.GCED2011, "33.13"), (Standards.NACE2, "33.13")),
        ((Standards.GCED2011, "33.14"), (Standards.NACE2, "33.14")),
        ((Standards.GCED2011, "33.15"), (Standards.NACE2, "33.15")),
        ((Standards.GCED2011, "33.16"), (Standards.NACE2, "33.16")),
        ((Standards.GCED2011, "33.17"), (Standards.NACE2, "33.17")),
        ((Standards.GCED2011, "33.19"), (Standards.NACE2, "33.19")),
        ((Standards.GCED2011, "33.2"), (Standards.NACE2, "33.2")),
        ((Standards.GCED2011, "33.20"), (Standards.NACE2, "33.20")),
        ((Standards.GCED2011, "D"), (Standards.NACE2, "D")),
        ((Standards.GCED2011, "35"), (Standards.NACE2, "35")),
        ((Standards.GCED2011, "35.1"), (Standards.NACE2, "35.1")),
        ((Standards.GCED2011, "35.11"), (Standards.NACE2, "35.11")),
        ((Standards.GCED2011, "35.12"), (Standards.NACE2, "35.12")),
        ((Standards.GCED2011, "35.13"), (Standards.NACE2, "35.13")),
        ((Standards.GCED2011, "35.14"), (Standards.NACE2, "35.14")),
        ((Standards.GCED2011, "35.2"), (Standards.NACE2, "35.2")),
        ((Standards.GCED2011, "35.21"), (Standards.NACE2, "35.21")),
        ((Standards.GCED2011, "35.22"), (Standards.NACE2, "35.22")),
        ((Standards.GCED2011, "35.23"), (Standards.NACE2, "35.23")),
        ((Standards.GCED2011, "35.3"), (Standards.NACE2, "35.3")),
        ((Standards.GCED2011, "35.30"), (Standards.NACE2, "35.30")),
        ((Standards.GCED2011, "E"), (Standards.NACE2, "E")),
        ((Standards.GCED2011, "36"), (Standards.NACE2, "36")),
        ((Standards.GCED2011, "36.0"), (Standards.NACE2, "36.0")),
        ((Standards.GCED2011, "36.00"), (Standards.NACE2, "36.00")),
        ((Standards.GCED2011, "37"), (Standards.NACE2, "37")),
        ((Standards.GCED2011, "37.0"), (Standards.NACE2, "37.0")),
        ((Standards.GCED2011, "37.00"), (Standards.NACE2, "37.00")),
        ((Standards.GCED2011, "38"), (Standards.NACE2, "38")),
        ((Standards.GCED2011, "38.1"), (Standards.NACE2, "38.1")),
        ((Standards.GCED2011, "38.11"), (Standards.NACE2, "38.11")),
        ((Standards.GCED2011, "38.12"), (Standards.NACE2, "38.12")),
        ((Standards.GCED2011, "38.2"), (Standards.NACE2, "38.2")),
        ((Standards.GCED2011, "38.21"), (Standards.NACE2, "38.21")),
        ((Standards.GCED2011, "38.22"), (Standards.NACE2, "38.22")),
        ((Standards.GCED2011, "38.3"), (Standards.NACE2, "38.3")),
        ((Standards.GCED2011, "38.31"), (Standards.NACE2, "38.31")),
        ((Standards.GCED2011, "38.32"), (Standards.NACE2, "38.32")),
        ((Standards.GCED2011, "39"), (Standards.NACE2, "39")),
        ((Standards.GCED2011, "39.0"), (Standards.NACE2, "39.0")),
        ((Standards.GCED2011, "39.00"), (Standards.NACE2, "39.00")),
        ((Standards.GCED2011, "F"), (Standards.NACE2, "F")),
        ((Standards.GCED2011, "41"), (Standards.NACE2, "41")),
        ((Standards.GCED2011, "41.1"), (Standards.NACE2, "41.1")),
        ((Standards.GCED2011, "41.10"), (Standards.NACE2, "41.10")),
        ((Standards.GCED2011, "41.2"), (Standards.NACE2, "41.2")),
        ((Standards.GCED2011, "41.20"), (Standards.NACE2, "41.20")),
        ((Standards.GCED2011, "42"), (Standards.NACE2, "42")),
        ((Standards.GCED2011, "42.1"), (Standards.NACE2, "42.1")),
        ((Standards.GCED2011, "42.11"), (Standards.NACE2, "42.11")),
        ((Standards.GCED2011, "42.12"), (Standards.NACE2, "42.12")),
        ((Standards.GCED2011, "42.13"), (Standards.NACE2, "42.13")),
        ((Standards.GCED2011, "42.2"), (Standards.NACE2, "42.2")),
        ((Standards.GCED2011, "42.21"), (Standards.NACE2, "42.21")),
        ((Standards.GCED2011, "42.22"), (Standards.NACE2, "42.22")),
        ((Standards.GCED2011, "42.9"), (Standards.NACE2, "42.9")),
        ((Standards.GCED2011, "42.91"), (Standards.NACE2, "42.91")),
        ((Standards.GCED2011, "42.99"), (Standards.NACE2, "42.99")),
        ((Standards.GCED2011, "43"), (Standards.NACE2, "43")),
        ((Standards.GCED2011, "43.1"), (Standards.NACE2, "43.1")),
        ((Standards.GCED2011, "43.11"), (Standards.NACE2, "43.11")),
        ((Standards.GCED2011, "43.12"), (Standards.NACE2, "43.12")),
        ((Standards.GCED2011, "43.13"), (Standards.NACE2, "43.13")),
        ((Standards.GCED2011, "43.2"), (Standards.NACE2, "43.2")),
        ((Standards.GCED2011, "43.21"), (Standards.NACE2, "43.21")),
        ((Standards.GCED2011, "43.22"), (Standards.NACE2, "43.22")),
        ((Standards.GCED2011, "43.29"), (Standards.NACE2, "43.29")),
        ((Standards.GCED2011, "43.3"), (Standards.NACE2, "43.3")),
        ((Standards.GCED2011, "43.31"), (Standards.NACE2, "43.31")),
        ((Standards.GCED2011, "43.32"), (Standards.NACE2, "43.32")),
        ((Standards.GCED2011, "43.33"), (Standards.NACE2, "43.33")),
        ((Standards.GCED2011, "43.34"), (Standards.NACE2, "43.34")),
        ((Standards.GCED2011, "43.39"), (Standards.NACE2, "43.39")),
        ((Standards.GCED2011, "43.9"), (Standards.NACE2, "43.9")),
        ((Standards.GCED2011, "43.91"), (Standards.NACE2, "43.91")),
        ((Standards.GCED2011, "43.99"), (Standards.NACE2, "43.99")),
        ((Standards.GCED2011, "G"), (Standards.NACE2, "G")),
        ((Standards.GCED2011, "45"), (Standards.NACE2, "45")),
        ((Standards.GCED2011, "45.1"), (Standards.NACE2, "45.1")),
        ((Standards.GCED2011, "45.11"), (Standards.NACE2, "45.11")),
        ((Standards.GCED2011, "45.19"), (Standards.NACE2, "45.19")),
        ((Standards.GCED2011, "45.2"), (Standards.NACE2, "45.2")),
        ((Standards.GCED2011, "45.20"), (Standards.NACE2, "45.20")),
        ((Standards.GCED2011, "45.3"), (Standards.NACE2, "45.3")),
        ((Standards.GCED2011, "45.31"), (Standards.NACE2, "45.31")),
        ((Standards.GCED2011, "45.32"), (Standards.NACE2, "45.32")),
        ((Standards.GCED2011, "45.4"), (Standards.NACE2, "45.4")),
        ((Standards.GCED2011, "45.40"), (Standards.NACE2, "45.40")),
        ((Standards.GCED2011, "46"), (Standards.NACE2, "46")),
        ((Standards.GCED2011, "46.1"), (Standards.NACE2, "46.1")),
        ((Standards.GCED2011, "46.11"), (Standards.NACE2, "46.11")),
        ((Standards.GCED2011, "46.12"), (Standards.NACE2, "46.12")),
        ((Standards.GCED2011, "46.13"), (Standards.NACE2, "46.13")),
        ((Standards.GCED2011, "46.14"), (Standards.NACE2, "46.14")),
        ((Standards.GCED2011, "46.15"), (Standards.NACE2, "46.15")),
        ((Standards.GCED2011, "46.16"), (Standards.NACE2, "46.16")),
        ((Standards.GCED2011, "46.17"), (Standards.NACE2, "46.17")),
        ((Standards.GCED2011, "46.18"), (Standards.NACE2, "46.18")),
        ((Standards.GCED2011, "46.19"), (Standards.NACE2, "46.19")),
        ((Standards.GCED2011, "46.2"), (Standards.NACE2, "46.2")),
        ((Standards.GCED2011, "46.21"), (Standards.NACE2, "46.21")),
        ((Standards.GCED2011, "46.22"), (Standards.NACE2, "46.22")),
        ((Standards.GCED2011, "46.23"), (Standards.NACE2, "46.23")),
        ((Standards.GCED2011, "46.24"), (Standards.NACE2, "46.24")),
        ((Standards.GCED2011, "46.3"), (Standards.NACE2, "46.3")),
        ((Standards.GCED2011, "46.31"), (Standards.NACE2, "46.31")),
        ((Standards.GCED2011, "46.32"), (Standards.NACE2, "46.32")),
        ((Standards.GCED2011, "46.33"), (Standards.NACE2, "46.33")),
        ((Standards.GCED2011, "46.34"), (Standards.NACE2, "46.34")),
        ((Standards.GCED2011, "46.35"), (Standards.NACE2, "46.35")),
        ((Standards.GCED2011, "46.36"), (Standards.NACE2, "46.36")),
        ((Standards.GCED2011, "46.37"), (Standards.NACE2, "46.37")),
        ((Standards.GCED2011, "46.38"), (Standards.NACE2, "46.38")),
        ((Standards.GCED2011, "46.39"), (Standards.NACE2, "46.39")),
        ((Standards.GCED2011, "46.4"), (Standards.NACE2, "46.4")),
        ((Standards.GCED2011, "46.41"), (Standards.NACE2, "46.41")),
        ((Standards.GCED2011, "46.42"), (Standards.NACE2, "46.42")),
        ((Standards.GCED2011, "46.43"), (Standards.NACE2, "46.43")),
        ((Standards.GCED2011, "46.44"), (Standards.NACE2, "46.44")),
        ((Standards.GCED2011, "46.45"), (Standards.NACE2, "46.45")),
        ((Standards.GCED2011, "46.46"), (Standards.NACE2, "46.46")),
        ((Standards.GCED2011, "46.47"), (Standards.NACE2, "46.47")),
        ((Standards.GCED2011, "46.48"), (Standards.NACE2, "46.48")),
        ((Standards.GCED2011, "46.49"), (Standards.NACE2, "46.49")),
        ((Standards.GCED2011, "46.5"), (Standards.NACE2, "46.5")),
        ((Standards.GCED2011, "46.51"), (Standards.NACE2, "46.51")),
        ((Standards.GCED2011, "46.52"), (Standards.NACE2, "46.52")),
        ((Standards.GCED2011, "46.6"), (Standards.NACE2, "46.6")),
        ((Standards.GCED2011, "46.61"), (Standards.NACE2, "46.61")),
        ((Standards.GCED2011, "46.62"), (Standards.NACE2, "46.62")),
        ((Standards.GCED2011, "46.63"), (Standards.NACE2, "46.63")),
        ((Standards.GCED2011, "46.64"), (Standards.NACE2, "46.64")),
        ((Standards.GCED2011, "46.65"), (Standards.NACE2, "46.65")),
        ((Standards.GCED2011, "46.66"), (Standards.NACE2, "46.66")),
        ((Standards.GCED2011, "46.69"), (Standards.NACE2, "46.69")),
        ((Standards.GCED2011, "46.7"), (Standards.NACE2, "46.7")),
        ((Standards.GCED2011, "46.71"), (Standards.NACE2, "46.71")),
        ((Standards.GCED2011, "46.72"), (Standards.NACE2, "46.72")),
        ((Standards.GCED2011, "46.73"), (Standards.NACE2, "46.73")),
        ((Standards.GCED2011, "46.74"), (Standards.NACE2, "46.74")),
        ((Standards.GCED2011, "46.75"), (Standards.NACE2, "46.75")),
        ((Standards.GCED2011, "46.76"), (Standards.NACE2, "46.76")),
        ((Standards.GCED2011, "46.77"), (Standards.NACE2, "46.77")),
        ((Standards.GCED2011, "46.9"), (Standards.NACE2, "46.9")),
        ((Standards.GCED2011, "46.90"), (Standards.NACE2, "46.90")),
        ((Standards.GCED2011, "47"), (Standards.NACE2, "47")),
        ((Standards.GCED2011, "47.1"), (Standards.NACE2, "47.1")),
        ((Standards.GCED2011, "47.11"), (Standards.NACE2, "47.11")),
        ((Standards.GCED2011, "47.19"), (Standards.NACE2, "47.19")),
        ((Standards.GCED2011, "47.2"), (Standards.NACE2, "47.2")),
        ((Standards.GCED2011, "47.21"), (Standards.NACE2, "47.21")),
        ((Standards.GCED2011, "47.22"), (Standards.NACE2, "47.22")),
        ((Standards.GCED2011, "47.23"), (Standards.NACE2, "47.23")),
        ((Standards.GCED2011, "47.24"), (Standards.NACE2, "47.24")),
        ((Standards.GCED2011, "47.25"), (Standards.NACE2, "47.25")),
        ((Standards.GCED2011, "47.26"), (Standards.NACE2, "47.26")),
        ((Standards.GCED2011, "47.29"), (Standards.NACE2, "47.29")),
        ((Standards.GCED2011, "47.3"), (Standards.NACE2, "47.3")),
        ((Standards.GCED2011, "47.30"), (Standards.NACE2, "47.30")),
        ((Standards.GCED2011, "47.4"), (Standards.NACE2, "47.4")),
        ((Standards.GCED2011, "47.41"), (Standards.NACE2, "47.41")),
        ((Standards.GCED2011, "47.42"), (Standards.NACE2, "47.42")),
        ((Standards.GCED2011, "47.43"), (Standards.NACE2, "47.43")),
        ((Standards.GCED2011, "47.5"), (Standards.NACE2, "47.5")),
        ((Standards.GCED2011, "47.51"), (Standards.NACE2, "47.51")),
        ((Standards.GCED2011, "47.52"), (Standards.NACE2, "47.52")),
        ((Standards.GCED2011, "47.53"), (Standards.NACE2, "47.53")),
        ((Standards.GCED2011, "47.54"), (Standards.NACE2, "47.54")),
        ((Standards.GCED2011, "47.59"), (Standards.NACE2, "47.59")),
        ((Standards.GCED2011, "47.6"), (Standards.NACE2, "47.6")),
        ((Standards.GCED2011, "47.61"), (Standards.NACE2, "47.61")),
        ((Standards.GCED2011, "47.62"), (Standards.NACE2, "47.62")),
        ((Standards.GCED2011, "47.63"), (Standards.NACE2, "47.63")),
        ((Standards.GCED2011, "47.64"), (Standards.NACE2, "47.64")),
        ((Standards.GCED2011, "47.65"), (Standards.NACE2, "47.65")),
        ((Standards.GCED2011, "47.7"), (Standards.NACE2, "47.7")),
        ((Standards.GCED2011, "47.71"), (Standards.NACE2, "47.71")),
        ((Standards.GCED2011, "47.72"), (Standards.NACE2, "47.72")),
        ((Standards.GCED2011, "47.73"), (Standards.NACE2, "47.73")),
        ((Standards.GCED2011, "47.74"), (Standards.NACE2, "47.74")),
        ((Standards.GCED2011, "47.75"), (Standards.NACE2, "47.75")),
        ((Standards.GCED2011, "47.76"), (Standards.NACE2, "47.76")),
        ((Standards.GCED2011, "47.77"), (Standards.NACE2, "47.77")),
        ((Standards.GCED2011, "47.78"), (Standards.NACE2, "47.78")),
        ((Standards.GCED2011, "47.79"), (Standards.NACE2, "47.79")),
        ((Standards.GCED2011, "47.8"), (Standards.NACE2, "47.8")),
        ((Standards.GCED2011, "47.81"), (Standards.NACE2, "47.81")),
        ((Standards.GCED2011, "47.82"), (Standards.NACE2, "47.82")),
        ((Standards.GCED2011, "47.89"), (Standards.NACE2, "47.89")),
        ((Standards.GCED2011, "47.9"), (Standards.NACE2, "47.9")),
        ((Standards.GCED2011, "47.91"), (Standards.NACE2, "47.91")),
        ((Standards.GCED2011, "47.99"), (Standards.NACE2, "47.99")),
        ((Standards.GCED2011, "H"), (Standards.NACE2, "H")),
        ((Standards.GCED2011, "49"), (Standards.NACE2, "49")),
        ((Standards.GCED2011, "49.1"), (Standards.NACE2, "49.1")),
        ((Standards.GCED2011, "49.10"), (Standards.NACE2, "49.10")),
        ((Standards.GCED2011, "49.2"), (Standards.NACE2, "49.2")),
        ((Standards.GCED2011, "49.20"), (Standards.NACE2, "49.20")),
        ((Standards.GCED2011, "49.3"), (Standards.NACE2, "49.3")),
        ((Standards.GCED2011, "49.31"), (Standards.NACE2, "49.31")),
        ((Standards.GCED2011, "49.32"), (Standards.NACE2, "49.32")),
        ((Standards.GCED2011, "49.39"), (Standards.NACE2, "49.39")),
        ((Standards.GCED2011, "49.4"), (Standards.NACE2, "49.4")),
        ((Standards.GCED2011, "49.41"), (Standards.NACE2, "49.41")),
        ((Standards.GCED2011, "49.42"), (Standards.NACE2, "49.42")),
        ((Standards.GCED2011, "49.5"), (Standards.NACE2, "49.5")),
        ((Standards.GCED2011, "49.50"), (Standards.NACE2, "49.50")),
        ((Standards.GCED2011, "50"), (Standards.NACE2, "50")),
        ((Standards.GCED2011, "50.1"), (Standards.NACE2, "50.1")),
        ((Standards.GCED2011, "50.10"), (Standards.NACE2, "50.10")),
        ((Standards.GCED2011, "50.2"), (Standards.NACE2, "50.2")),
        ((Standards.GCED2011, "50.20"), (Standards.NACE2, "50.20")),
        ((Standards.GCED2011, "50.3"), (Standards.NACE2, "50.3")),
        ((Standards.GCED2011, "50.30"), (Standards.NACE2, "50.30")),
        ((Standards.GCED2011, "50.4"), (Standards.NACE2, "50.4")),
        ((Standards.GCED2011, "50.40"), (Standards.NACE2, "50.40")),
        ((Standards.GCED2011, "51"), (Standards.NACE2, "51")),
        ((Standards.GCED2011, "51.1"), (Standards.NACE2, "51.1")),
        ((Standards.GCED2011, "51.10"), (Standards.NACE2, "51.10")),
        ((Standards.GCED2011, "51.2"), (Standards.NACE2, "51.2")),
        ((Standards.GCED2011, "51.21"), (Standards.NACE2, "51.21")),
        ((Standards.GCED2011, "51.22"), (Standards.NACE2, "51.22")),
        ((Standards.GCED2011, "52"), (Standards.NACE2, "52")),
        ((Standards.GCED2011, "52.1"), (Standards.NACE2, "52.1")),
        ((Standards.GCED2011, "52.10"), (Standards.NACE2, "52.10")),
        ((Standards.GCED2011, "52.2"), (Standards.NACE2, "52.2")),
        ((Standards.GCED2011, "52.21"), (Standards.NACE2, "52.21")),
        ((Standards.GCED2011, "52.22"), (Standards.NACE2, "52.22")),
        ((Standards.GCED2011, "52.23"), (Standards.NACE2, "52.23")),
        ((Standards.GCED2011, "52.24"), (Standards.NACE2, "52.24")),
        ((Standards.GCED2011, "52.29"), (Standards.NACE2, "52.29")),
        ((Standards.GCED2011, "53"), (Standards.NACE2, "53")),
        ((Standards.GCED2011, "53.1"), (Standards.NACE2, "53.1")),
        ((Standards.GCED2011, "53.10"), (Standards.NACE2, "53.10")),
        ((Standards.GCED2011, "53.2"), (Standards.NACE2, "53.2")),
        ((Standards.GCED2011, "53.20"), (Standards.NACE2, "53.20")),
        ((Standards.GCED2011, "I"), (Standards.NACE2, "I")),
        ((Standards.GCED2011, "55"), (Standards.NACE2, "55")),
        ((Standards.GCED2011, "55.1"), (Standards.NACE2, "55.1")),
        ((Standards.GCED2011, "55.10"), (Standards.NACE2, "55.10")),
        ((Standards.GCED2011, "55.2"), (Standards.NACE2, "55.2")),
        ((Standards.GCED2011, "55.20"), (Standards.NACE2, "55.20")),
        ((Standards.GCED2011, "55.3"), (Standards.NACE2, "55.3")),
        ((Standards.GCED2011, "55.30"), (Standards.NACE2, "55.30")),
        ((Standards.GCED2011, "55.9"), (Standards.NACE2, "55.9")),
        ((Standards.GCED2011, "55.90"), (Standards.NACE2, "55.90")),
        ((Standards.GCED2011, "56"), (Standards.NACE2, "56")),
        ((Standards.GCED2011, "56.1"), (Standards.NACE2, "56.1")),
        ((Standards.GCED2011, "56.10"), (Standards.NACE2, "56.10")),
        ((Standards.GCED2011, "56.2"), (Standards.NACE2, "56.2")),
        ((Standards.GCED2011, "56.21"), (Standards.NACE2, "56.21")),
        ((Standards.GCED2011, "56.29"), (Standards.NACE2, "56.29")),
        ((Standards.GCED2011, "56.3"), (Standards.NACE2, "56.3")),
        ((Standards.GCED2011, "56.30"), (Standards.NACE2, "56.30")),
        ((Standards.GCED2011, "J"), (Standards.NACE2, "J")),
        ((Standards.GCED2011, "58"), (Standards.NACE2, "58")),
        ((Standards.GCED2011, "58.1"), (Standards.NACE2, "58.1")),
        ((Standards.GCED2011, "58.11"), (Standards.NACE2, "58.11")),
        ((Standards.GCED2011, "58.12"), (Standards.NACE2, "58.12")),
        ((Standards.GCED2011, "58.13"), (Standards.NACE2, "58.13")),
        ((Standards.GCED2011, "58.14"), (Standards.NACE2, "58.14")),
        ((Standards.GCED2011, "58.19"), (Standards.NACE2, "58.19")),
        ((Standards.GCED2011, "58.2"), (Standards.NACE2, "58.2")),
        ((Standards.GCED2011, "58.21"), (Standards.NACE2, "58.21")),
        ((Standards.GCED2011, "58.29"), (Standards.NACE2, "58.29")),
        ((Standards.GCED2011, "59"), (Standards.NACE2, "59")),
        ((Standards.GCED2011, "59.1"), (Standards.NACE2, "59.1")),
        ((Standards.GCED2011, "59.11"), (Standards.NACE2, "59.11")),
        ((Standards.GCED2011, "59.12"), (Standards.NACE2, "59.12")),
        ((Standards.GCED2011, "59.13"), (Standards.NACE2, "59.13")),
        ((Standards.GCED2011, "59.14"), (Standards.NACE2, "59.14")),
        ((Standards.GCED2011, "59.2"), (Standards.NACE2, "59.2")),
        ((Standards.GCED2011, "59.20"), (Standards.NACE2, "59.20")),
        ((Standards.GCED2011, "60"), (Standards.NACE2, "60")),
        ((Standards.GCED2011, "60.1"), (Standards.NACE2, "60.1")),
        ((Standards.GCED2011, "60.10"), (Standards.NACE2, "60.10")),
        ((Standards.GCED2011, "60.2"), (Standards.NACE2, "60.2")),
        ((Standards.GCED2011, "60.20"), (Standards.NACE2, "60.20")),
        ((Standards.GCED2011, "61"), (Standards.NACE2, "61")),
        ((Standards.GCED2011, "61.1"), (Standards.NACE2, "61.1")),
        ((Standards.GCED2011, "61.10"), (Standards.NACE2, "61.10")),
        ((Standards.GCED2011, "61.2"), (Standards.NACE2, "61.2")),
        ((Standards.GCED2011, "61.20"), (Standards.NACE2, "61.20")),
        ((Standards.GCED2011, "61.3"), (Standards.NACE2, "61.3")),
        ((Standards.GCED2011, "61.30"), (Standards.NACE2, "61.30")),
        ((Standards.GCED2011, "61.9"), (Standards.NACE2, "61.9")),
        ((Standards.GCED2011, "61.90"), (Standards.NACE2, "61.90")),
        ((Standards.GCED2011, "62"), (Standards.NACE2, "62")),
        ((Standards.GCED2011, "62.0"), (Standards.NACE2, "62.0")),
        ((Standards.GCED2011, "62.01"), (Standards.NACE2, "62.01")),
        ((Standards.GCED2011, "62.02"), (Standards.NACE2, "62.02")),
        ((Standards.GCED2011, "62.03"), (Standards.NACE2, "62.03")),
        ((Standards.GCED2011, "62.09"), (Standards.NACE2, "62.09")),
        ((Standards.GCED2011, "63"), (Standards.NACE2, "63")),
        ((Standards.GCED2011, "63.1"), (Standards.NACE2, "63.1")),
        ((Standards.GCED2011, "63.11"), (Standards.NACE2, "63.11")),
        ((Standards.GCED2011, "63.12"), (Standards.NACE2, "63.12")),
        ((Standards.GCED2011, "63.9"), (Standards.NACE2, "63.9")),
        ((Standards.GCED2011, "63.91"), (Standards.NACE2, "63.91")),
        ((Standards.GCED2011, "63.99"), (Standards.NACE2, "63.99")),
        ((Standards.GCED2011, "K"), (Standards.NACE2, "K")),
        ((Standards.GCED2011, "64"), (Standards.NACE2, "64")),
        ((Standards.GCED2011, "64.1"), (Standards.NACE2, "64.1")),
        ((Standards.GCED2011, "64.11"), (Standards.NACE2, "64.11")),
        ((Standards.GCED2011, "64.19"), (Standards.NACE2, "64.19")),
        ((Standards.GCED2011, "64.2"), (Standards.NACE2, "64.2")),
        ((Standards.GCED2011, "64.20"), (Standards.NACE2, "64.20")),
        ((Standards.GCED2011, "64.3"), (Standards.NACE2, "64.3")),
        ((Standards.GCED2011, "64.30"), (Standards.NACE2, "64.30")),
        ((Standards.GCED2011, "64.9"), (Standards.NACE2, "64.9")),
        ((Standards.GCED2011, "64.91"), (Standards.NACE2, "64.91")),
        ((Standards.GCED2011, "64.92"), (Standards.NACE2, "64.92")),
        ((Standards.GCED2011, "64.99"), (Standards.NACE2, "64.99")),
        ((Standards.GCED2011, "65"), (Standards.NACE2, "65")),
        ((Standards.GCED2011, "65.1"), (Standards.NACE2, "65.1")),
        ((Standards.GCED2011, "65.11"), (Standards.NACE2, "65.11")),
        ((Standards.GCED2011, "65.12"), (Standards.NACE2, "65.12")),
        ((Standards.GCED2011, "65.2"), (Standards.NACE2, "65.2")),
        ((Standards.GCED2011, "65.20"), (Standards.NACE2, "65.20")),
        ((Standards.GCED2011, "65.3"), (Standards.NACE2, "65.3")),
        ((Standards.GCED2011, "65.30"), (Standards.NACE2, "65.30")),
        ((Standards.GCED2011, "66"), (Standards.NACE2, "66")),
        ((Standards.GCED2011, "66.1"), (Standards.NACE2, "66.1")),
        ((Standards.GCED2011, "66.11"), (Standards.NACE2, "66.11")),
        ((Standards.GCED2011, "66.12"), (Standards.NACE2, "66.12")),
        ((Standards.GCED2011, "66.19"), (Standards.NACE2, "66.19")),
        ((Standards.GCED2011, "66.2"), (Standards.NACE2, "66.2")),
        ((Standards.GCED2011, "66.21"), (Standards.NACE2, "66.21")),
        ((Standards.GCED2011, "66.22"), (Standards.NACE2, "66.22")),
        ((Standards.GCED2011, "66.29"), (Standards.NACE2, "66.29")),
        ((Standards.GCED2011, "66.3"), (Standards.NACE2, "66.3")),
        ((Standards.GCED2011, "66.30"), (Standards.NACE2, "66.30")),
        ((Standards.GCED2011, "L"), (Standards.NACE2, "L")),
        ((Standards.GCED2011, "68"), (Standards.NACE2, "68")),
        ((Standards.GCED2011, "68.1"), (Standards.NACE2, "68.1")),
        ((Standards.GCED2011, "68.10"), (Standards.NACE2, "68.10")),
        ((Standards.GCED2011, "68.2"), (Standards.NACE2, "68.2")),
        ((Standards.GCED2011, "68.20"), (Standards.NACE2, "68.20")),
        ((Standards.GCED2011, "68.3"), (Standards.NACE2, "68.3")),
        ((Standards.GCED2011, "68.31"), (Standards.NACE2, "68.31")),
        ((Standards.GCED2011, "68.32"), (Standards.NACE2, "68.32")),
        ((Standards.GCED2011, "M"), (Standards.NACE2, "M")),
        ((Standards.GCED2011, "69"), (Standards.NACE2, "69")),
        ((Standards.GCED2011, "69.1"), (Standards.NACE2, "69.1")),
        ((Standards.GCED2011, "69.10"), (Standards.NACE2, "69.10")),
        ((Standards.GCED2011, "69.2"), (Standards.NACE2, "69.2")),
        ((Standards.GCED2011, "69.20"), (Standards.NACE2, "69.20")),
        ((Standards.GCED2011, "70"), (Standards.NACE2, "70")),
        ((Standards.GCED2011, "70.1"), (Standards.NACE2, "70.1")),
        ((Standards.GCED2011, "70.10"), (Standards.NACE2, "70.10")),
        ((Standards.GCED2011, "70.2"), (Standards.NACE2, "70.2")),
        ((Standards.GCED2011, "70.21"), (Standards.NACE2, "70.21")),
        ((Standards.GCED2011, "70.22"), (Standards.NACE2, "70.22")),
        ((Standards.GCED2011, "71"), (Standards.NACE2, "71")),
        ((Standards.GCED2011, "71.1"), (Standards.NACE2, "71.1")),
        ((Standards.GCED2011, "71.11"), (Standards.NACE2, "71.11")),
        ((Standards.GCED2011, "71.12"), (Standards.NACE2, "71.12")),
        ((Standards.GCED2011, "71.2"), (Standards.NACE2, "71.2")),
        ((Standards.GCED2011, "71.20"), (Standards.NACE2, "71.20")),
        ((Standards.GCED2011, "72"), (Standards.NACE2, "72")),
        ((Standards.GCED2011, "72.1"), (Standards.NACE2, "72.1")),
        ((Standards.GCED2011, "72.11"), (Standards.NACE2, "72.11")),
        ((Standards.GCED2011, "72.19"), (Standards.NACE2, "72.19")),
        ((Standards.GCED2011, "72.2"), (Standards.NACE2, "72.2")),
        ((Standards.GCED2011, "72.20"), (Standards.NACE2, "72.20")),
        ((Standards.GCED2011, "73"), (Standards.NACE2, "73")),
        ((Standards.GCED2011, "73.1"), (Standards.NACE2, "73.1")),
        ((Standards.GCED2011, "73.11"), (Standards.NACE2, "73.11")),
        ((Standards.GCED2011, "73.12"), (Standards.NACE2, "73.12")),
        ((Standards.GCED2011, "73.2"), (Standards.NACE2, "73.2")),
        ((Standards.GCED2011, "73.20"), (Standards.NACE2, "73.20")),
        ((Standards.GCED2011, "74"), (Standards.NACE2, "74")),
        ((Standards.GCED2011, "74.1"), (Standards.NACE2, "74.1")),
        ((Standards.GCED2011, "74.10"), (Standards.NACE2, "74.10")),
        ((Standards.GCED2011, "74.2"), (Standards.NACE2, "74.2")),
        ((Standards.GCED2011, "74.20"), (Standards.NACE2, "74.20")),
        ((Standards.GCED2011, "74.3"), (Standards.NACE2, "74.3")),
        ((Standards.GCED2011, "74.30"), (Standards.NACE2, "74.30")),
        ((Standards.GCED2011, "74.9"), (Standards.NACE2, "74.9")),
        ((Standards.GCED2011, "74.90"), (Standards.NACE2, "74.90")),
        ((Standards.GCED2011, "75"), (Standards.NACE2, "75")),
        ((Standards.GCED2011, "75.0"), (Standards.NACE2, "75.0")),
        ((Standards.GCED2011, "75.00"), (Standards.NACE2, "75.00")),
        ((Standards.GCED2011, "N"), (Standards.NACE2, "N")),
        ((Standards.GCED2011, "77"), (Standards.NACE2, "77")),
        ((Standards.GCED2011, "77.1"), (Standards.NACE2, "77.1")),
        ((Standards.GCED2011, "77.11"), (Standards.NACE2, "77.11")),
        ((Standards.GCED2011, "77.12"), (Standards.NACE2, "77.12")),
        ((Standards.GCED2011, "77.2"), (Standards.NACE2, "77.2")),
        ((Standards.GCED2011, "77.21"), (Standards.NACE2, "77.21")),
        ((Standards.GCED2011, "77.22"), (Standards.NACE2, "77.22")),
        ((Standards.GCED2011, "77.29"), (Standards.NACE2, "77.29")),
        ((Standards.GCED2011, "77.3"), (Standards.NACE2, "77.3")),
        ((Standards.GCED2011, "77.31"), (Standards.NACE2, "77.31")),
        ((Standards.GCED2011, "77.32"), (Standards.NACE2, "77.32")),
        ((Standards.GCED2011, "77.33"), (Standards.NACE2, "77.33")),
        ((Standards.GCED2011, "77.34"), (Standards.NACE2, "77.34")),
        ((Standards.GCED2011, "77.35"), (Standards.NACE2, "77.35")),
        ((Standards.GCED2011, "77.39"), (Standards.NACE2, "77.39")),
        ((Standards.GCED2011, "77.4"), (Standards.NACE2, "77.4")),
        ((Standards.GCED2011, "77.40"), (Standards.NACE2, "77.40")),
        ((Standards.GCED2011, "78"), (Standards.NACE2, "78")),
        ((Standards.GCED2011, "78.1"), (Standards.NACE2, "78.1")),
        ((Standards.GCED2011, "78.10"), (Standards.NACE2, "78.10")),
        ((Standards.GCED2011, "78.2"), (Standards.NACE2, "78.2")),
        ((Standards.GCED2011, "78.20"), (Standards.NACE2, "78.20")),
        ((Standards.GCED2011, "78.3"), (Standards.NACE2, "78.3")),
        ((Standards.GCED2011, "78.30"), (Standards.NACE2, "78.30")),
        ((Standards.GCED2011, "79"), (Standards.NACE2, "79")),
        ((Standards.GCED2011, "79.1"), (Standards.NACE2, "79.1")),
        ((Standards.GCED2011, "79.11"), (Standards.NACE2, "79.11")),
        ((Standards.GCED2011, "79.12"), (Standards.NACE2, "79.12")),
        ((Standards.GCED2011, "79.9"), (Standards.NACE2, "79.9")),
        ((Standards.GCED2011, "79.90"), (Standards.NACE2, "79.90")),
        ((Standards.GCED2011, "80"), (Standards.NACE2, "80")),
        ((Standards.GCED2011, "80.1"), (Standards.NACE2, "80.1")),
        ((Standards.GCED2011, "80.10"), (Standards.NACE2, "80.10")),
        ((Standards.GCED2011, "80.2"), (Standards.NACE2, "80.2")),
        ((Standards.GCED2011, "80.20"), (Standards.NACE2, "80.20")),
        ((Standards.GCED2011, "80.3"), (Standards.NACE2, "80.3")),
        ((Standards.GCED2011, "80.30"), (Standards.NACE2, "80.30")),
        ((Standards.GCED2011, "81"), (Standards.NACE2, "81")),
        ((Standards.GCED2011, "81.1"), (Standards.NACE2, "81.1")),
        ((Standards.GCED2011, "81.10"), (Standards.NACE2, "81.10")),
        ((Standards.GCED2011, "81.2"), (Standards.NACE2, "81.2")),
        ((Standards.GCED2011, "81.21"), (Standards.NACE2, "81.21")),
        ((Standards.GCED2011, "81.22"), (Standards.NACE2, "81.22")),
        ((Standards.GCED2011, "81.29"), (Standards.NACE2, "81.29")),
        ((Standards.GCED2011, "81.3"), (Standards.NACE2, "81.3")),
        ((Standards.GCED2011, "81.30"), (Standards.NACE2, "81.30")),
        ((Standards.GCED2011, "82"), (Standards.NACE2, "82")),
        ((Standards.GCED2011, "82.1"), (Standards.NACE2, "82.1")),
        ((Standards.GCED2011, "82.11"), (Standards.NACE2, "82.11")),
        ((Standards.GCED2011, "82.19"), (Standards.NACE2, "82.19")),
        ((Standards.GCED2011, "82.2"), (Standards.NACE2, "82.2")),
        ((Standards.GCED2011, "82.20"), (Standards.NACE2, "82.20")),
        ((Standards.GCED2011, "82.3"), (Standards.NACE2, "82.3")),
        ((Standards.GCED2011, "82.30"), (Standards.NACE2, "82.30")),
        ((Standards.GCED2011, "82.9"), (Standards.NACE2, "82.9")),
        ((Standards.GCED2011, "82.91"), (Standards.NACE2, "82.91")),
        ((Standards.GCED2011, "82.92"), (Standards.NACE2, "82.92")),
        ((Standards.GCED2011, "82.99"), (Standards.NACE2, "82.99")),
        ((Standards.GCED2011, "O"), (Standards.NACE2, "O")),
        ((Standards.GCED2011, "84"), (Standards.NACE2, "84")),
        ((Standards.GCED2011, "84.1"), (Standards.NACE2, "84.1")),
        ((Standards.GCED2011, "84.11"), (Standards.NACE2, "84.11")),
        ((Standards.GCED2011, "84.12"), (Standards.NACE2, "84.12")),
        ((Standards.GCED2011, "84.13"), (Standards.NACE2, "84.13")),
        ((Standards.GCED2011, "84.2"), (Standards.NACE2, "84.2")),
        ((Standards.GCED2011, "84.21"), (Standards.NACE2, "84.21")),
        ((Standards.GCED2011, "84.22"), (Standards.NACE2, "84.22")),
        ((Standards.GCED2011, "84.23"), (Standards.NACE2, "84.23")),
        ((Standards.GCED2011, "84.24"), (Standards.NACE2, "84.24")),
        ((Standards.GCED2011, "84.25"), (Standards.NACE2, "84.25")),
        ((Standards.GCED2011, "84.3"), (Standards.NACE2, "84.3")),
        ((Standards.GCED2011, "84.30"), (Standards.NACE2, "84.30")),
        ((Standards.GCED2011, "P"), (Standards.NACE2, "P")),
        ((Standards.GCED2011, "85"), (Standards.NACE2, "85")),
        ((Standards.GCED2011, "85.1"), (Standards.NACE2, "85.1")),
        ((Standards.GCED2011, "85.10"), (Standards.NACE2, "85.10")),
        ((Standards.GCED2011, "85.2"), (Standards.NACE2, "85.2")),
        ((Standards.GCED2011, "85.20"), (Standards.NACE2, "85.20")),
        ((Standards.GCED2011, "85.3"), (Standards.NACE2, "85.3")),
        ((Standards.GCED2011, "85.31"), (Standards.NACE2, "85.31")),
        ((Standards.GCED2011, "85.32"), (Standards.NACE2, "85.32")),
        ((Standards.GCED2011, "85.4"), (Standards.NACE2, "85.4")),
        ((Standards.GCED2011, "85.41"), (Standards.NACE2, "85.41")),
        ((Standards.GCED2011, "85.42"), (Standards.NACE2, "85.42")),
        ((Standards.GCED2011, "85.5"), (Standards.NACE2, "85.5")),
        ((Standards.GCED2011, "85.51"), (Standards.NACE2, "85.51")),
        ((Standards.GCED2011, "85.52"), (Standards.NACE2, "85.52")),
        ((Standards.GCED2011, "85.53"), (Standards.NACE2, "85.53")),
        ((Standards.GCED2011, "85.59"), (Standards.NACE2, "85.59")),
        ((Standards.GCED2011, "85.6"), (Standards.NACE2, "85.6")),
        ((Standards.GCED2011, "85.60"), (Standards.NACE2, "85.60")),
        ((Standards.GCED2011, "Q"), (Standards.NACE2, "Q")),
        ((Standards.GCED2011, "86"), (Standards.NACE2, "86")),
        ((Standards.GCED2011, "86.1"), (Standards.NACE2, "86.1")),
        ((Standards.GCED2011, "86.10"), (Standards.NACE2, "86.10")),
        ((Standards.GCED2011, "86.2"), (Standards.NACE2, "86.2")),
        ((Standards.GCED2011, "86.21"), (Standards.NACE2, "86.21")),
        ((Standards.GCED2011, "86.22"), (Standards.NACE2, "86.22")),
        ((Standards.GCED2011, "86.23"), (Standards.NACE2, "86.23")),
        ((Standards.GCED2011, "86.9"), (Standards.NACE2, "86.9")),
        ((Standards.GCED2011, "86.90"), (Standards.NACE2, "86.90")),
        ((Standards.GCED2011, "87"), (Standards.NACE2, "87")),
        ((Standards.GCED2011, "87.1"), (Standards.NACE2, "87.1")),
        ((Standards.GCED2011, "87.10"), (Standards.NACE2, "87.10")),
        ((Standards.GCED2011, "87.2"), (Standards.NACE2, "87.2")),
        ((Standards.GCED2011, "87.20"), (Standards.NACE2, "87.20")),
        ((Standards.GCED2011, "87.3"), (Standards.NACE2, "87.3")),
        ((Standards.GCED2011, "87.30"), (Standards.NACE2, "87.30")),
        ((Standards.GCED2011, "87.9"), (Standards.NACE2, "87.9")),
        ((Standards.GCED2011, "87.90"), (Standards.NACE2, "87.90")),
        ((Standards.GCED2011, "88"), (Standards.NACE2, "88")),
        ((Standards.GCED2011, "88.1"), (Standards.NACE2, "88.1")),
        ((Standards.GCED2011, "88.10"), (Standards.NACE2, "88.10")),
        ((Standards.GCED2011, "88.9"), (Standards.NACE2, "88.9")),
        ((Standards.GCED2011, "88.91"), (Standards.NACE2, "88.91")),
        ((Standards.GCED2011, "88.99"), (Standards.NACE2, "88.99")),
        ((Standards.GCED2011, "R"), (Standards.NACE2, "R")),
        ((Standards.GCED2011, "90"), (Standards.NACE2, "90")),
        ((Standards.GCED2011, "90.0"), (Standards.NACE2, "90.0")),
        ((Standards.GCED2011, "90.01"), (Standards.NACE2, "90.01")),
        ((Standards.GCED2011, "90.02"), (Standards.NACE2, "90.02")),
        ((Standards.GCED2011, "90.03"), (Standards.NACE2, "90.03")),
        ((Standards.GCED2011, "90.04"), (Standards.NACE2, "90.04")),
        ((Standards.GCED2011, "91"), (Standards.NACE2, "91")),
        ((Standards.GCED2011, "91.0"), (Standards.NACE2, "91.0")),
        ((Standards.GCED2011, "91.01"), (Standards.NACE2, "91.01")),
        ((Standards.GCED2011, "91.02"), (Standards.NACE2, "91.02")),
        ((Standards.GCED2011, "91.03"), (Standards.NACE2, "91.03")),
        ((Standards.GCED2011, "91.04"), (Standards.NACE2, "91.04")),
        ((Standards.GCED2011, "92"), (Standards.NACE2, "92")),
        ((Standards.GCED2011, "92.0"), (Standards.NACE2, "92.0")),
        ((Standards.GCED2011, "92.00"), (Standards.NACE2, "92.00")),
        ((Standards.GCED2011, "93"), (Standards.NACE2, "93")),
        ((Standards.GCED2011, "93.1"), (Standards.NACE2, "93.1")),
        ((Standards.GCED2011, "93.11"), (Standards.NACE2, "93.11")),
        ((Standards.GCED2011, "93.12"), (Standards.NACE2, "93.12")),
        ((Standards.GCED2011, "93.13"), (Standards.NACE2, "93.13")),
        ((Standards.GCED2011, "93.19"), (Standards.NACE2, "93.19")),
        ((Standards.GCED2011, "93.2"), (Standards.NACE2, "93.2")),
        ((Standards.GCED2011, "93.21"), (Standards.NACE2, "93.21")),
        ((Standards.GCED2011, "93.29"), (Standards.NACE2, "93.29")),
        ((Standards.GCED2011, "S"), (Standards.NACE2, "S")),
        ((Standards.GCED2011, "94"), (Standards.NACE2, "94")),
        ((Standards.GCED2011, "94.1"), (Standards.NACE2, "94.1")),
        ((Standards.GCED2011, "94.11"), (Standards.NACE2, "94.11")),
        ((Standards.GCED2011, "94.12"), (Standards.NACE2, "94.12")),
        ((Standards.GCED2011, "94.2"), (Standards.NACE2, "94.2")),
        ((Standards.GCED2011, "94.20"), (Standards.NACE2, "94.20")),
        ((Standards.GCED2011, "94.9"), (Standards.NACE2, "94.9")),
        ((Standards.GCED2011, "94.91"), (Standards.NACE2, "94.91")),
        ((Standards.GCED2011, "94.92"), (Standards.NACE2, "94.92")),
        ((Standards.GCED2011, "94.99"), (Standards.NACE2, "94.99")),
        ((Standards.GCED2011, "95"), (Standards.NACE2, "95")),
        ((Standards.GCED2011, "95.1"), (Standards.NACE2, "95.1")),
        ((Standards.GCED2011, "95.11"), (Standards.NACE2, "95.11")),
        ((Standards.GCED2011, "95.12"), (Standards.NACE2, "95.12")),
        ((Standards.GCED2011, "95.2"), (Standards.NACE2, "95.2")),
        ((Standards.GCED2011, "95.21"), (Standards.NACE2, "95.21")),
        ((Standards.GCED2011, "95.22"), (Standards.NACE2, "95.22")),
        ((Standards.GCED2011, "95.23"), (Standards.NACE2, "95.23")),
        ((Standards.GCED2011, "95.24"), (Standards.NACE2, "95.24")),
        ((Standards.GCED2011, "95.25"), (Standards.NACE2, "95.25")),
        ((Standards.GCED2011, "95.29"), (Standards.NACE2, "95.29")),
        ((Standards.GCED2011, "96"), (Standards.NACE2, "96")),
        ((Standards.GCED2011, "96.0"), (Standards.NACE2, "96.0")),
        ((Standards.GCED2011, "96.01"), (Standards.NACE2, "96.01")),
        ((Standards.GCED2011, "96.02"), (Standards.NACE2, "96.02")),
        ((Standards.GCED2011, "96.03"), (Standards.NACE2, "96.03")),
        ((Standards.GCED2011, "96.04"), (Standards.NACE2, "96.04")),
        ((Standards.GCED2011, "96.09"), (Standards.NACE2, "96.09")),
        ((Standards.GCED2011, "T"), (Standards.NACE2, "T")),
        ((Standards.GCED2011, "97"), (Standards.NACE2, "97")),
        ((Standards.GCED2011, "97.0"), (Standards.NACE2, "97.0")),
        ((Standards.GCED2011, "97.00"), (Standards.NACE2, "97.00")),
        ((Standards.GCED2011, "98"), (Standards.NACE2, "98")),
        ((Standards.GCED2011, "98.1"), (Standards.NACE2, "98.1")),
        ((Standards.GCED2011, "98.10"), (Standards.NACE2, "98.10")),
        ((Standards.GCED2011, "98.2"), (Standards.NACE2, "98.2")),
        ((Standards.GCED2011, "98.20"), (Standards.NACE2, "98.20")),
        ((Standards.GCED2011, "U"), (Standards.NACE2, "U")),
        ((Standards.GCED2011, "99"), (Standards.NACE2, "99")),
        ((Standards.GCED2011, "99.0"), (Standards.NACE2, "99.0")),
        ((Standards.GCED2011, "99.00"), (Standards.NACE2, "99.00")),
    ],
)
