"""`Concordance between CAEM2005 and ISIC3 <https://date.gov.md/ckan/ro/dataset/5188-clasificatorul-activitatilor-din-economia-moldovei-caem>`_."""

from ...types import Concordance, Standards
from ..isic3 import ISIC3
from . import CAEM2005

CAEM2005_to_ISIC3 = Concordance(
    src=CAEM2005,
    dst=ISIC3,
    concordances=[
        ((Standards.CAEM2005, "A"), (Standards.ISIC3, "A")),
        ((Standards.CAEM2005, "01"), (Standards.ISIC3, "01")),
        ((Standards.CAEM2005, "01.1"), (Standards.ISIC3, "011")),
        ((Standards.CAEM2005, "01.11"), (Standards.ISIC3, "0111")),
        ((Standards.CAEM2005, "01.11.1"), (Standards.ISIC3, "0111")),
        ((Standards.CAEM2005, "01.11.2"), (Standards.ISIC3, "0111")),
        ((Standards.CAEM2005, "01.11.3"), (Standards.ISIC3, "0111")),
        ((Standards.CAEM2005, "01.11.4"), (Standards.ISIC3, "0111")),
        ((Standards.CAEM2005, "01.11.5"), (Standards.ISIC3, "0111")),
        ((Standards.CAEM2005, "01.11.8"), (Standards.ISIC3, "0111")),
        ((Standards.CAEM2005, "01.11.9"), (Standards.ISIC3, "0111")),
        ((Standards.CAEM2005, "01.12"), (Standards.ISIC3, "0112")),
        ((Standards.CAEM2005, "01.12.1"), (Standards.ISIC3, "0112")),
        ((Standards.CAEM2005, "01.12.2"), (Standards.ISIC3, "0112")),
        ((Standards.CAEM2005, "01.12.3"), (Standards.ISIC3, "0112")),
        ((Standards.CAEM2005, "01.12.4"), (Standards.ISIC3, "0112")),
        ((Standards.CAEM2005, "01.13"), (Standards.ISIC3, "0113")),
        ((Standards.CAEM2005, "01.13.1"), (Standards.ISIC3, "0113")),
        ((Standards.CAEM2005, "01.13.2"), (Standards.ISIC3, "0113")),
        ((Standards.CAEM2005, "01.13.3"), (Standards.ISIC3, "0113")),
        ((Standards.CAEM2005, "01.2"), (Standards.ISIC3, "012")),
        ((Standards.CAEM2005, "01.21"), (Standards.ISIC3, "0121")),
        ((Standards.CAEM2005, "01.21.0"), (Standards.ISIC3, "0121")),
        ((Standards.CAEM2005, "01.22"), (Standards.ISIC3, "0121")),
        ((Standards.CAEM2005, "01.22.1"), (Standards.ISIC3, "0121")),
        ((Standards.CAEM2005, "01.22.2"), (Standards.ISIC3, "0121")),
        ((Standards.CAEM2005, "01.22.3"), (Standards.ISIC3, "0121")),
        ((Standards.CAEM2005, "01.23"), (Standards.ISIC3, "0122")),
        ((Standards.CAEM2005, "01.23.0"), (Standards.ISIC3, "0122")),
        ((Standards.CAEM2005, "01.24"), (Standards.ISIC3, "0122")),
        ((Standards.CAEM2005, "01.24.1"), (Standards.ISIC3, "0122")),
        ((Standards.CAEM2005, "01.24.2"), (Standards.ISIC3, "0122")),
        ((Standards.CAEM2005, "01.24.3"), (Standards.ISIC3, "0122")),
        ((Standards.CAEM2005, "01.24.4"), (Standards.ISIC3, "0122")),
        ((Standards.CAEM2005, "01.25"), (Standards.ISIC3, "0122")),
        ((Standards.CAEM2005, "01.25.1"), (Standards.ISIC3, "0122")),
        ((Standards.CAEM2005, "01.25.2"), (Standards.ISIC3, "0122")),
        ((Standards.CAEM2005, "01.3"), (Standards.ISIC3, "013")),
        ((Standards.CAEM2005, "01.30"), (Standards.ISIC3, "0130")),
        ((Standards.CAEM2005, "01.30.0"), (Standards.ISIC3, "0130")),
        ((Standards.CAEM2005, "01.4"), (Standards.ISIC3, "014")),
        ((Standards.CAEM2005, "01.41"), (Standards.ISIC3, "0140")),
        ((Standards.CAEM2005, "01.41.1"), (Standards.ISIC3, "0140")),
        ((Standards.CAEM2005, "01.41.2"), (Standards.ISIC3, "0140")),
        ((Standards.CAEM2005, "01.41.9"), (Standards.ISIC3, "0140")),
        ((Standards.CAEM2005, "01.42"), (Standards.ISIC3, "0140")),
        ((Standards.CAEM2005, "01.42.0"), (Standards.ISIC3, "0140")),
        ((Standards.CAEM2005, "01.5"), (Standards.ISIC3, "015")),
        ((Standards.CAEM2005, "01.50"), (Standards.ISIC3, "0150")),
        ((Standards.CAEM2005, "01.50.0"), (Standards.ISIC3, "0150")),
        ((Standards.CAEM2005, "02"), (Standards.ISIC3, "02")),
        ((Standards.CAEM2005, "02.0"), (Standards.ISIC3, "020")),
        ((Standards.CAEM2005, "02.01"), (Standards.ISIC3, "0200")),
        ((Standards.CAEM2005, "02.01.1"), (Standards.ISIC3, "0200")),
        ((Standards.CAEM2005, "02.01.2"), (Standards.ISIC3, "0200")),
        ((Standards.CAEM2005, "02.01.3"), (Standards.ISIC3, "0200")),
        ((Standards.CAEM2005, "02.02"), (Standards.ISIC3, "0200")),
        ((Standards.CAEM2005, "02.02.0"), (Standards.ISIC3, "0200")),
        ((Standards.CAEM2005, "B"), (Standards.ISIC3, "B")),
        ((Standards.CAEM2005, "05"), (Standards.ISIC3, "05")),
        ((Standards.CAEM2005, "05.0"), (Standards.ISIC3, "050")),
        ((Standards.CAEM2005, "05.01"), (Standards.ISIC3, "0500")),
        ((Standards.CAEM2005, "05.01.0"), (Standards.ISIC3, "0500")),
        ((Standards.CAEM2005, "05.02"), (Standards.ISIC3, "0500")),
        ((Standards.CAEM2005, "05.02.0"), (Standards.ISIC3, "0500")),
        ((Standards.CAEM2005, "C"), (Standards.ISIC3, "C")),
        ((Standards.CAEM2005, "10"), (Standards.ISIC3, "10")),
        ((Standards.CAEM2005, "10.1"), (Standards.ISIC3, "101")),
        ((Standards.CAEM2005, "10.10"), (Standards.ISIC3, "1010")),
        ((Standards.CAEM2005, "10.10.0"), (Standards.ISIC3, "1010")),
        ((Standards.CAEM2005, "10.2"), (Standards.ISIC3, "102")),
        ((Standards.CAEM2005, "10.20"), (Standards.ISIC3, "1020")),
        ((Standards.CAEM2005, "10.20.0"), (Standards.ISIC3, "1020")),
        ((Standards.CAEM2005, "10.3"), (Standards.ISIC3, "103")),
        ((Standards.CAEM2005, "10.30"), (Standards.ISIC3, "1030")),
        ((Standards.CAEM2005, "10.30.0"), (Standards.ISIC3, "1030")),
        ((Standards.CAEM2005, "11"), (Standards.ISIC3, "11")),
        ((Standards.CAEM2005, "11.1"), (Standards.ISIC3, "111")),
        ((Standards.CAEM2005, "11.10"), (Standards.ISIC3, "111")),
        ((Standards.CAEM2005, "11.10.1"), (Standards.ISIC3, "1110")),
        ((Standards.CAEM2005, "11.10.2"), (Standards.ISIC3, "1110")),
        ((Standards.CAEM2005, "11.2"), (Standards.ISIC3, "112")),
        ((Standards.CAEM2005, "11.20"), (Standards.ISIC3, "1120")),
        ((Standards.CAEM2005, "11.20.0"), (Standards.ISIC3, "1120")),
        ((Standards.CAEM2005, "12"), (Standards.ISIC3, "12")),
        ((Standards.CAEM2005, "12.0"), (Standards.ISIC3, "120")),
        ((Standards.CAEM2005, "12.00"), (Standards.ISIC3, "1200")),
        ((Standards.CAEM2005, "12.00.0"), (Standards.ISIC3, "1200")),
        ((Standards.CAEM2005, "13"), (Standards.ISIC3, "13")),
        ((Standards.CAEM2005, "13.1"), (Standards.ISIC3, "131")),
        ((Standards.CAEM2005, "13.10"), (Standards.ISIC3, "1310")),
        ((Standards.CAEM2005, "13.10.0"), (Standards.ISIC3, "1310")),
        ((Standards.CAEM2005, "13.2"), (Standards.ISIC3, "132")),
        ((Standards.CAEM2005, "13.20"), (Standards.ISIC3, "1320")),
        ((Standards.CAEM2005, "13.20.0"), (Standards.ISIC3, "1320")),
        ((Standards.CAEM2005, "14"), (Standards.ISIC3, "14")),
        ((Standards.CAEM2005, "14.1"), (Standards.ISIC3, "141")),
        ((Standards.CAEM2005, "14.11"), (Standards.ISIC3, "1410")),
        ((Standards.CAEM2005, "14.11.0"), (Standards.ISIC3, "1410")),
        ((Standards.CAEM2005, "14.12"), (Standards.ISIC3, "1410")),
        ((Standards.CAEM2005, "14.12.0"), (Standards.ISIC3, "1410")),
        ((Standards.CAEM2005, "14.13"), (Standards.ISIC3, "1410")),
        ((Standards.CAEM2005, "14.13.0"), (Standards.ISIC3, "1410")),
        ((Standards.CAEM2005, "14.2"), (Standards.ISIC3, "141")),
        ((Standards.CAEM2005, "14.21"), (Standards.ISIC3, "1410")),
        ((Standards.CAEM2005, "14.21.0"), (Standards.ISIC3, "1410")),
        ((Standards.CAEM2005, "14.22"), (Standards.ISIC3, "1410")),
        ((Standards.CAEM2005, "14.22.1"), (Standards.ISIC3, "1410")),
        ((Standards.CAEM2005, "14.22.2"), (Standards.ISIC3, "1410")),
        ((Standards.CAEM2005, "14.3"), (Standards.ISIC3, "142")),
        ((Standards.CAEM2005, "14.30"), (Standards.ISIC3, "1421")),
        ((Standards.CAEM2005, "14.30.0"), (Standards.ISIC3, "1421")),
        ((Standards.CAEM2005, "14.4"), (Standards.ISIC3, "142")),
        ((Standards.CAEM2005, "14.40"), (Standards.ISIC3, "1422")),
        ((Standards.CAEM2005, "14.40.0"), (Standards.ISIC3, "1422")),
        ((Standards.CAEM2005, "14.5"), (Standards.ISIC3, "142")),
        ((Standards.CAEM2005, "14.50"), (Standards.ISIC3, "1429")),
        ((Standards.CAEM2005, "14.50.1"), (Standards.ISIC3, "1429")),
        ((Standards.CAEM2005, "14.50.2"), (Standards.ISIC3, "1429")),
        ((Standards.CAEM2005, "14.50.3"), (Standards.ISIC3, "1429")),
        ((Standards.CAEM2005, "14.50.4"), (Standards.ISIC3, "1410")),
        ((Standards.CAEM2005, "14.50.5"), (Standards.ISIC3, "1429")),
        ((Standards.CAEM2005, "D"), (Standards.ISIC3, "D")),
        ((Standards.CAEM2005, "15"), (Standards.ISIC3, "15")),
        ((Standards.CAEM2005, "15.1"), (Standards.ISIC3, "151")),
        ((Standards.CAEM2005, "15.11"), (Standards.ISIC3, "1511")),
        ((Standards.CAEM2005, "15.11.0"), (Standards.ISIC3, "1511")),
        ((Standards.CAEM2005, "15.12"), (Standards.ISIC3, "1511")),
        ((Standards.CAEM2005, "15.12.0"), (Standards.ISIC3, "1511")),
        ((Standards.CAEM2005, "15.13"), (Standards.ISIC3, "1511")),
        ((Standards.CAEM2005, "15.13.0"), (Standards.ISIC3, "1511")),
        ((Standards.CAEM2005, "15.2"), (Standards.ISIC3, "151")),
        ((Standards.CAEM2005, "15.20"), (Standards.ISIC3, "1512")),
        ((Standards.CAEM2005, "15.20.0"), (Standards.ISIC3, "1512")),
        ((Standards.CAEM2005, "15.3"), (Standards.ISIC3, "151")),
        ((Standards.CAEM2005, "15.31"), (Standards.ISIC3, "1513")),
        ((Standards.CAEM2005, "15.31.0"), (Standards.ISIC3, "1513")),
        ((Standards.CAEM2005, "15.32"), (Standards.ISIC3, "1513")),
        ((Standards.CAEM2005, "15.32.0"), (Standards.ISIC3, "1513")),
        ((Standards.CAEM2005, "15.33"), (Standards.ISIC3, "1513")),
        ((Standards.CAEM2005, "15.33.0"), (Standards.ISIC3, "1513")),
        ((Standards.CAEM2005, "15.4"), (Standards.ISIC3, "151")),
        ((Standards.CAEM2005, "15.41"), (Standards.ISIC3, "1514")),
        ((Standards.CAEM2005, "15.41.0"), (Standards.ISIC3, "1514")),
        ((Standards.CAEM2005, "15.42"), (Standards.ISIC3, "1514")),
        ((Standards.CAEM2005, "15.42.0"), (Standards.ISIC3, "1514")),
        ((Standards.CAEM2005, "15.43"), (Standards.ISIC3, "1514")),
        ((Standards.CAEM2005, "15.43.0"), (Standards.ISIC3, "1514")),
        ((Standards.CAEM2005, "15.5"), (Standards.ISIC3, "152")),
        ((Standards.CAEM2005, "15.51"), (Standards.ISIC3, "1520")),
        ((Standards.CAEM2005, "15.51.0"), (Standards.ISIC3, "1520")),
        ((Standards.CAEM2005, "15.52"), (Standards.ISIC3, "1520")),
        ((Standards.CAEM2005, "15.52.0"), (Standards.ISIC3, "1520")),
        ((Standards.CAEM2005, "15.6"), (Standards.ISIC3, "153")),
        ((Standards.CAEM2005, "15.61"), (Standards.ISIC3, "1531")),
        ((Standards.CAEM2005, "15.61.1"), (Standards.ISIC3, "1531")),
        ((Standards.CAEM2005, "15.61.2"), (Standards.ISIC3, "1531")),
        ((Standards.CAEM2005, "15.61.3"), (Standards.ISIC3, "1531")),
        ((Standards.CAEM2005, "15.62"), (Standards.ISIC3, "1532")),
        ((Standards.CAEM2005, "15.62.0"), (Standards.ISIC3, "1532")),
        ((Standards.CAEM2005, "15.7"), (Standards.ISIC3, "153")),
        ((Standards.CAEM2005, "15.71"), (Standards.ISIC3, "1533")),
        ((Standards.CAEM2005, "15.71.0"), (Standards.ISIC3, "1533")),
        ((Standards.CAEM2005, "15.72"), (Standards.ISIC3, "1533")),
        ((Standards.CAEM2005, "15.72.0"), (Standards.ISIC3, "1533")),
        ((Standards.CAEM2005, "15.8"), (Standards.ISIC3, "154")),
        ((Standards.CAEM2005, "15.81"), (Standards.ISIC3, "1541")),
        ((Standards.CAEM2005, "15.81.0"), (Standards.ISIC3, "1541")),
        ((Standards.CAEM2005, "15.82"), (Standards.ISIC3, "1541")),
        ((Standards.CAEM2005, "15.82.0"), (Standards.ISIC3, "1541")),
        ((Standards.CAEM2005, "15.83"), (Standards.ISIC3, "1542")),
        ((Standards.CAEM2005, "15.83.0"), (Standards.ISIC3, "1542")),
        ((Standards.CAEM2005, "15.84"), (Standards.ISIC3, "1543")),
        ((Standards.CAEM2005, "15.84.0"), (Standards.ISIC3, "1543")),
        ((Standards.CAEM2005, "15.85"), (Standards.ISIC3, "1544")),
        ((Standards.CAEM2005, "15.85.0"), (Standards.ISIC3, "1544")),
        ((Standards.CAEM2005, "15.86"), (Standards.ISIC3, "1549")),
        ((Standards.CAEM2005, "15.86.0"), (Standards.ISIC3, "1549")),
        ((Standards.CAEM2005, "15.87"), (Standards.ISIC3, "1549")),
        ((Standards.CAEM2005, "15.87.0"), (Standards.ISIC3, "1549")),
        ((Standards.CAEM2005, "15.88"), (Standards.ISIC3, "1549")),
        ((Standards.CAEM2005, "15.88.0"), (Standards.ISIC3, "1549")),
        ((Standards.CAEM2005, "15.89"), (Standards.ISIC3, "1549")),
        ((Standards.CAEM2005, "15.89.1"), (Standards.ISIC3, "1549")),
        ((Standards.CAEM2005, "15.89.2"), (Standards.ISIC3, "1549")),
        ((Standards.CAEM2005, "15.89.9"), (Standards.ISIC3, "1549")),
        ((Standards.CAEM2005, "15.9"), (Standards.ISIC3, "155")),
        ((Standards.CAEM2005, "15.91"), (Standards.ISIC3, "1551")),
        ((Standards.CAEM2005, "15.91.0"), (Standards.ISIC3, "1551")),
        ((Standards.CAEM2005, "15.92"), (Standards.ISIC3, "1551")),
        ((Standards.CAEM2005, "15.92.0"), (Standards.ISIC3, "1551")),
        ((Standards.CAEM2005, "15.93"), (Standards.ISIC3, "1552")),
        ((Standards.CAEM2005, "15.93.0"), (Standards.ISIC3, "1552")),
        ((Standards.CAEM2005, "15.94"), (Standards.ISIC3, "1552")),
        ((Standards.CAEM2005, "15.94.0"), (Standards.ISIC3, "1552")),
        ((Standards.CAEM2005, "15.95"), (Standards.ISIC3, "1552")),
        ((Standards.CAEM2005, "15.95.0"), (Standards.ISIC3, "1552")),
        ((Standards.CAEM2005, "15.96"), (Standards.ISIC3, "1553")),
        ((Standards.CAEM2005, "15.96.0"), (Standards.ISIC3, "1553")),
        ((Standards.CAEM2005, "15.97"), (Standards.ISIC3, "1553")),
        ((Standards.CAEM2005, "15.97.0"), (Standards.ISIC3, "1553")),
        ((Standards.CAEM2005, "15.98"), (Standards.ISIC3, "1554")),
        ((Standards.CAEM2005, "15.98.0"), (Standards.ISIC3, "1554")),
        ((Standards.CAEM2005, "16"), (Standards.ISIC3, "16")),
        ((Standards.CAEM2005, "16.0"), (Standards.ISIC3, "160")),
        ((Standards.CAEM2005, "16.00"), (Standards.ISIC3, "1600")),
        ((Standards.CAEM2005, "16.00.0"), (Standards.ISIC3, "1600")),
        ((Standards.CAEM2005, "17"), (Standards.ISIC3, "17")),
        ((Standards.CAEM2005, "17.1"), (Standards.ISIC3, "171")),
        ((Standards.CAEM2005, "17.11"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.11.1"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.11.2"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.12"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.12.1"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.12.2"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.13"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.13.1"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.13.2"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.14"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.14.1"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.14.2"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.15"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.15.1"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.15.2"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.16"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.16.1"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.16.2"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.16.3"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.16.4"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.17"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.17.1"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.17.2"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.2"), (Standards.ISIC3, "171")),
        ((Standards.CAEM2005, "17.21"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.21.0"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.22"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.22.0"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.23"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.23.0"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.24"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.24.0"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.25"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.25.1"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.25.9"), (Standards.ISIC3, "1711")),
        ((Standards.CAEM2005, "17.3"), (Standards.ISIC3, "171")),
        ((Standards.CAEM2005, "17.30"), (Standards.ISIC3, "1712")),
        ((Standards.CAEM2005, "17.30.0"), (Standards.ISIC3, "1712")),
        ((Standards.CAEM2005, "17.4"), (Standards.ISIC3, "172")),
        ((Standards.CAEM2005, "17.40"), (Standards.ISIC3, "1721")),
        ((Standards.CAEM2005, "17.40.0"), (Standards.ISIC3, "1721")),
        ((Standards.CAEM2005, "17.5"), (Standards.ISIC3, "172")),
        ((Standards.CAEM2005, "17.51"), (Standards.ISIC3, "1722")),
        ((Standards.CAEM2005, "17.51.0"), (Standards.ISIC3, "1722")),
        ((Standards.CAEM2005, "17.52"), (Standards.ISIC3, "1723")),
        ((Standards.CAEM2005, "17.52.1"), (Standards.ISIC3, "1723")),
        ((Standards.CAEM2005, "17.52.2"), (Standards.ISIC3, "1723")),
        ((Standards.CAEM2005, "17.53"), (Standards.ISIC3, "1729")),
        ((Standards.CAEM2005, "17.53.0"), (Standards.ISIC3, "1729")),
        ((Standards.CAEM2005, "17.54"), (Standards.ISIC3, "1729")),
        ((Standards.CAEM2005, "17.54.1"), (Standards.ISIC3, "1729")),
        ((Standards.CAEM2005, "17.54.2"), (Standards.ISIC3, "1729")),
        ((Standards.CAEM2005, "17.54.9"), (Standards.ISIC3, "1729")),
        ((Standards.CAEM2005, "17.6"), (Standards.ISIC3, "173")),
        ((Standards.CAEM2005, "17.60"), (Standards.ISIC3, "1730")),
        ((Standards.CAEM2005, "17.60.0"), (Standards.ISIC3, "1730")),
        ((Standards.CAEM2005, "17.7"), (Standards.ISIC3, "173")),
        ((Standards.CAEM2005, "17.71"), (Standards.ISIC3, "1730")),
        ((Standards.CAEM2005, "17.71.0"), (Standards.ISIC3, "1730")),
        ((Standards.CAEM2005, "17.72"), (Standards.ISIC3, "1730")),
        ((Standards.CAEM2005, "17.72.0"), (Standards.ISIC3, "1730")),
        ((Standards.CAEM2005, "18"), (Standards.ISIC3, "18")),
        ((Standards.CAEM2005, "18.1"), (Standards.ISIC3, "181")),
        ((Standards.CAEM2005, "18.10"), (Standards.ISIC3, "1810")),
        ((Standards.CAEM2005, "18.10.0"), (Standards.ISIC3, "1810")),
        ((Standards.CAEM2005, "18.2"), (Standards.ISIC3, "181")),
        ((Standards.CAEM2005, "18.21"), (Standards.ISIC3, "1810")),
        ((Standards.CAEM2005, "18.21.0"), (Standards.ISIC3, "1810")),
        ((Standards.CAEM2005, "18.22"), (Standards.ISIC3, "1810")),
        ((Standards.CAEM2005, "18.22.0"), (Standards.ISIC3, "1810")),
        ((Standards.CAEM2005, "18.23"), (Standards.ISIC3, "1810")),
        ((Standards.CAEM2005, "18.23.0"), (Standards.ISIC3, "1810")),
        ((Standards.CAEM2005, "18.24"), (Standards.ISIC3, "1810")),
        ((Standards.CAEM2005, "18.24.1"), (Standards.ISIC3, "1810")),
        ((Standards.CAEM2005, "18.24.9"), (Standards.ISIC3, "1810")),
        ((Standards.CAEM2005, "18.3"), (Standards.ISIC3, "182")),
        ((Standards.CAEM2005, "18.30"), (Standards.ISIC3, "1820")),
        ((Standards.CAEM2005, "18.30.1"), (Standards.ISIC3, "1820")),
        ((Standards.CAEM2005, "18.30.2"), (Standards.ISIC3, "1820")),
        ((Standards.CAEM2005, "18.30.3"), (Standards.ISIC3, "1820")),
        ((Standards.CAEM2005, "19"), (Standards.ISIC3, "19")),
        ((Standards.CAEM2005, "19.1"), (Standards.ISIC3, "191")),
        ((Standards.CAEM2005, "19.10"), (Standards.ISIC3, "1911")),
        ((Standards.CAEM2005, "19.10.1"), (Standards.ISIC3, "1911")),
        ((Standards.CAEM2005, "19.10.2"), (Standards.ISIC3, "1911")),
        ((Standards.CAEM2005, "19.2"), (Standards.ISIC3, "191")),
        ((Standards.CAEM2005, "19.20"), (Standards.ISIC3, "1912")),
        ((Standards.CAEM2005, "19.20.1"), (Standards.ISIC3, "1912")),
        ((Standards.CAEM2005, "19.20.2"), (Standards.ISIC3, "1912")),
        ((Standards.CAEM2005, "19.3"), (Standards.ISIC3, "192")),
        ((Standards.CAEM2005, "19.30"), (Standards.ISIC3, "1920")),
        ((Standards.CAEM2005, "19.30.0"), (Standards.ISIC3, "1920")),
        ((Standards.CAEM2005, "20"), (Standards.ISIC3, "20")),
        ((Standards.CAEM2005, "20.1"), (Standards.ISIC3, "201")),
        ((Standards.CAEM2005, "20.10"), (Standards.ISIC3, "2010")),
        ((Standards.CAEM2005, "20.10.1"), (Standards.ISIC3, "2010")),
        ((Standards.CAEM2005, "20.10.2"), (Standards.ISIC3, "2010")),
        ((Standards.CAEM2005, "20.10.3"), (Standards.ISIC3, "2010")),
        ((Standards.CAEM2005, "20.2"), (Standards.ISIC3, "202")),
        ((Standards.CAEM2005, "20.20"), (Standards.ISIC3, "2021")),
        ((Standards.CAEM2005, "20.20.0"), (Standards.ISIC3, "2021")),
        ((Standards.CAEM2005, "20.3"), (Standards.ISIC3, "202")),
        ((Standards.CAEM2005, "20.30"), (Standards.ISIC3, "2022")),
        ((Standards.CAEM2005, "20.30.1"), (Standards.ISIC3, "2022")),
        ((Standards.CAEM2005, "20.30.2"), (Standards.ISIC3, "2022")),
        ((Standards.CAEM2005, "20.30.3"), (Standards.ISIC3, "2022")),
        ((Standards.CAEM2005, "20.4"), (Standards.ISIC3, "202")),
        ((Standards.CAEM2005, "20.40"), (Standards.ISIC3, "2023")),
        ((Standards.CAEM2005, "20.40.0"), (Standards.ISIC3, "2023")),
        ((Standards.CAEM2005, "20.5"), (Standards.ISIC3, "202")),
        ((Standards.CAEM2005, "20.51"), (Standards.ISIC3, "2029")),
        ((Standards.CAEM2005, "20.51.1"), (Standards.ISIC3, "2029")),
        ((Standards.CAEM2005, "20.51.2"), (Standards.ISIC3, "2029")),
        ((Standards.CAEM2005, "20.52"), (Standards.ISIC3, "2029")),
        ((Standards.CAEM2005, "20.52.0"), (Standards.ISIC3, "2029")),
        ((Standards.CAEM2005, "21"), (Standards.ISIC3, "21")),
        ((Standards.CAEM2005, "21.1"), (Standards.ISIC3, "210")),
        ((Standards.CAEM2005, "21.11"), (Standards.ISIC3, "2101")),
        ((Standards.CAEM2005, "21.11.0"), (Standards.ISIC3, "2101")),
        ((Standards.CAEM2005, "21.12"), (Standards.ISIC3, "2101")),
        ((Standards.CAEM2005, "21.12.0"), (Standards.ISIC3, "2101")),
        ((Standards.CAEM2005, "21.2"), (Standards.ISIC3, "210")),
        ((Standards.CAEM2005, "21.21"), (Standards.ISIC3, "2102")),
        ((Standards.CAEM2005, "21.21.1"), (Standards.ISIC3, "2102")),
        ((Standards.CAEM2005, "21.21.2"), (Standards.ISIC3, "2102")),
        ((Standards.CAEM2005, "21.22"), (Standards.ISIC3, "2109")),
        ((Standards.CAEM2005, "21.22.0"), (Standards.ISIC3, "2109")),
        ((Standards.CAEM2005, "21.23"), (Standards.ISIC3, "2109")),
        ((Standards.CAEM2005, "21.23.0"), (Standards.ISIC3, "2109")),
        ((Standards.CAEM2005, "21.24"), (Standards.ISIC3, "2109")),
        ((Standards.CAEM2005, "21.24.0"), (Standards.ISIC3, "2109")),
        ((Standards.CAEM2005, "21.25"), (Standards.ISIC3, "2109")),
        ((Standards.CAEM2005, "21.25.0"), (Standards.ISIC3, "2109")),
        ((Standards.CAEM2005, "22"), (Standards.ISIC3, "22")),
        ((Standards.CAEM2005, "22.1"), (Standards.ISIC3, "221")),
        ((Standards.CAEM2005, "22.11"), (Standards.ISIC3, "2211")),
        ((Standards.CAEM2005, "22.11.0"), (Standards.ISIC3, "2211")),
        ((Standards.CAEM2005, "22.12"), (Standards.ISIC3, "2212")),
        ((Standards.CAEM2005, "22.12.0"), (Standards.ISIC3, "2212")),
        ((Standards.CAEM2005, "22.13"), (Standards.ISIC3, "2212")),
        ((Standards.CAEM2005, "22.13.0"), (Standards.ISIC3, "2212")),
        ((Standards.CAEM2005, "22.14"), (Standards.ISIC3, "2213")),
        ((Standards.CAEM2005, "22.14.0"), (Standards.ISIC3, "2213")),
        ((Standards.CAEM2005, "22.15"), (Standards.ISIC3, "2219")),
        ((Standards.CAEM2005, "22.15.0"), (Standards.ISIC3, "2219")),
        ((Standards.CAEM2005, "22.2"), (Standards.ISIC3, "222")),
        ((Standards.CAEM2005, "22.21"), (Standards.ISIC3, "2221")),
        ((Standards.CAEM2005, "22.21.0"), (Standards.ISIC3, "2221")),
        ((Standards.CAEM2005, "22.22"), (Standards.ISIC3, "2221")),
        ((Standards.CAEM2005, "22.22.0"), (Standards.ISIC3, "2221")),
        ((Standards.CAEM2005, "22.23"), (Standards.ISIC3, "2222")),
        ((Standards.CAEM2005, "22.23.0"), (Standards.ISIC3, "2222")),
        ((Standards.CAEM2005, "22.24"), (Standards.ISIC3, "2222")),
        ((Standards.CAEM2005, "22.24.0"), (Standards.ISIC3, "2222")),
        ((Standards.CAEM2005, "22.25"), (Standards.ISIC3, "2222")),
        ((Standards.CAEM2005, "22.25.0"), (Standards.ISIC3, "2222")),
        ((Standards.CAEM2005, "22.3"), (Standards.ISIC3, "223")),
        ((Standards.CAEM2005, "22.31"), (Standards.ISIC3, "2230")),
        ((Standards.CAEM2005, "22.31.0"), (Standards.ISIC3, "2230")),
        ((Standards.CAEM2005, "22.32"), (Standards.ISIC3, "2230")),
        ((Standards.CAEM2005, "22.32.0"), (Standards.ISIC3, "2230")),
        ((Standards.CAEM2005, "22.33"), (Standards.ISIC3, "2230")),
        ((Standards.CAEM2005, "22.33.0"), (Standards.ISIC3, "2230")),
        ((Standards.CAEM2005, "23"), (Standards.ISIC3, "23")),
        ((Standards.CAEM2005, "23.1"), (Standards.ISIC3, "231")),
        ((Standards.CAEM2005, "23.10"), (Standards.ISIC3, "2310")),
        ((Standards.CAEM2005, "23.10.0"), (Standards.ISIC3, "2310")),
        ((Standards.CAEM2005, "23.2"), (Standards.ISIC3, "232")),
        ((Standards.CAEM2005, "23.20"), (Standards.ISIC3, "2320")),
        ((Standards.CAEM2005, "23.20.0"), (Standards.ISIC3, "2320")),
        ((Standards.CAEM2005, "23.3"), (Standards.ISIC3, "233")),
        ((Standards.CAEM2005, "23.30"), (Standards.ISIC3, "2330")),
        ((Standards.CAEM2005, "23.30.0"), (Standards.ISIC3, "2330")),
        ((Standards.CAEM2005, "24"), (Standards.ISIC3, "24")),
        ((Standards.CAEM2005, "24.1"), (Standards.ISIC3, "241")),
        ((Standards.CAEM2005, "24.11"), (Standards.ISIC3, "2411")),
        ((Standards.CAEM2005, "24.11.0"), (Standards.ISIC3, "2411")),
        ((Standards.CAEM2005, "24.12"), (Standards.ISIC3, "2411")),
        ((Standards.CAEM2005, "24.12.0"), (Standards.ISIC3, "2411")),
        ((Standards.CAEM2005, "24.13"), (Standards.ISIC3, "2411")),
        ((Standards.CAEM2005, "24.13.0"), (Standards.ISIC3, "2411")),
        ((Standards.CAEM2005, "24.14"), (Standards.ISIC3, "2411")),
        ((Standards.CAEM2005, "24.14.1"), (Standards.ISIC3, "2411")),
        ((Standards.CAEM2005, "24.14.9"), (Standards.ISIC3, "2411")),
        ((Standards.CAEM2005, "24.15"), (Standards.ISIC3, "2412")),
        ((Standards.CAEM2005, "24.15.1"), (Standards.ISIC3, "2412")),
        ((Standards.CAEM2005, "24.15.2"), (Standards.ISIC3, "2412")),
        ((Standards.CAEM2005, "24.16"), (Standards.ISIC3, "2413")),
        ((Standards.CAEM2005, "24.16.0"), (Standards.ISIC3, "2413")),
        ((Standards.CAEM2005, "24.17"), (Standards.ISIC3, "2413")),
        ((Standards.CAEM2005, "24.17.0"), (Standards.ISIC3, "2413")),
        ((Standards.CAEM2005, "24.2"), (Standards.ISIC3, "242")),
        ((Standards.CAEM2005, "24.20"), (Standards.ISIC3, "2421")),
        ((Standards.CAEM2005, "24.20.0"), (Standards.ISIC3, "2421")),
        ((Standards.CAEM2005, "24.3"), (Standards.ISIC3, "242")),
        ((Standards.CAEM2005, "24.30"), (Standards.ISIC3, "2422")),
        ((Standards.CAEM2005, "24.30.1"), (Standards.ISIC3, "2422")),
        ((Standards.CAEM2005, "24.30.2"), (Standards.ISIC3, "2422")),
        ((Standards.CAEM2005, "24.4"), (Standards.ISIC3, "242")),
        ((Standards.CAEM2005, "24.41"), (Standards.ISIC3, "2423")),
        ((Standards.CAEM2005, "24.41.0"), (Standards.ISIC3, "2423")),
        ((Standards.CAEM2005, "24.42"), (Standards.ISIC3, "2423")),
        ((Standards.CAEM2005, "24.42.1"), (Standards.ISIC3, "2423")),
        ((Standards.CAEM2005, "24.42.2"), (Standards.ISIC3, "2423")),
        ((Standards.CAEM2005, "24.42.3"), (Standards.ISIC3, "2423")),
        ((Standards.CAEM2005, "24.5"), (Standards.ISIC3, "242")),
        ((Standards.CAEM2005, "24.51"), (Standards.ISIC3, "2424")),
        ((Standards.CAEM2005, "24.51.0"), (Standards.ISIC3, "2424")),
        ((Standards.CAEM2005, "24.52"), (Standards.ISIC3, "2424")),
        ((Standards.CAEM2005, "24.52.0"), (Standards.ISIC3, "2424")),
        ((Standards.CAEM2005, "24.6"), (Standards.ISIC3, "242")),
        ((Standards.CAEM2005, "24.61"), (Standards.ISIC3, "2429")),
        ((Standards.CAEM2005, "24.61.0"), (Standards.ISIC3, "2429")),
        ((Standards.CAEM2005, "24.62"), (Standards.ISIC3, "2429")),
        ((Standards.CAEM2005, "24.62.0"), (Standards.ISIC3, "2429")),
        ((Standards.CAEM2005, "24.63"), (Standards.ISIC3, "2429")),
        ((Standards.CAEM2005, "24.63.0"), (Standards.ISIC3, "2429")),
        ((Standards.CAEM2005, "24.64"), (Standards.ISIC3, "2429")),
        ((Standards.CAEM2005, "24.64.0"), (Standards.ISIC3, "2429")),
        ((Standards.CAEM2005, "24.65"), (Standards.ISIC3, "2429")),
        ((Standards.CAEM2005, "24.65.0"), (Standards.ISIC3, "2429")),
        ((Standards.CAEM2005, "24.66"), (Standards.ISIC3, "2429")),
        ((Standards.CAEM2005, "24.66.1"), (Standards.ISIC3, "2429")),
        ((Standards.CAEM2005, "24.66.2"), (Standards.ISIC3, "2429")),
        ((Standards.CAEM2005, "24.66.9"), (Standards.ISIC3, "2429")),
        ((Standards.CAEM2005, "24.7"), (Standards.ISIC3, "243")),
        ((Standards.CAEM2005, "24.70"), (Standards.ISIC3, "2430")),
        ((Standards.CAEM2005, "24.70.0"), (Standards.ISIC3, "2430")),
        ((Standards.CAEM2005, "25"), (Standards.ISIC3, "25")),
        ((Standards.CAEM2005, "25.1"), (Standards.ISIC3, "251")),
        ((Standards.CAEM2005, "25.11"), (Standards.ISIC3, "2511")),
        ((Standards.CAEM2005, "25.11.0"), (Standards.ISIC3, "2511")),
        ((Standards.CAEM2005, "25.12"), (Standards.ISIC3, "2511")),
        ((Standards.CAEM2005, "25.12.0"), (Standards.ISIC3, "2511")),
        ((Standards.CAEM2005, "25.13"), (Standards.ISIC3, "2519")),
        ((Standards.CAEM2005, "25.13.1"), (Standards.ISIC3, "2519")),
        ((Standards.CAEM2005, "25.13.2"), (Standards.ISIC3, "2519")),
        ((Standards.CAEM2005, "25.2"), (Standards.ISIC3, "252")),
        ((Standards.CAEM2005, "25.21"), (Standards.ISIC3, "2520")),
        ((Standards.CAEM2005, "25.21.0"), (Standards.ISIC3, "2520")),
        ((Standards.CAEM2005, "25.22"), (Standards.ISIC3, "2520")),
        ((Standards.CAEM2005, "25.22.0"), (Standards.ISIC3, "2520")),
        ((Standards.CAEM2005, "25.23"), (Standards.ISIC3, "2520")),
        ((Standards.CAEM2005, "25.23.0"), (Standards.ISIC3, "2520")),
        ((Standards.CAEM2005, "25.24"), (Standards.ISIC3, "2520")),
        ((Standards.CAEM2005, "25.24.0"), (Standards.ISIC3, "2520")),
        ((Standards.CAEM2005, "26"), (Standards.ISIC3, "26")),
        ((Standards.CAEM2005, "26.1"), (Standards.ISIC3, "261")),
        ((Standards.CAEM2005, "26.11"), (Standards.ISIC3, "2610")),
        ((Standards.CAEM2005, "26.11.0"), (Standards.ISIC3, "2610")),
        ((Standards.CAEM2005, "26.12"), (Standards.ISIC3, "2610")),
        ((Standards.CAEM2005, "26.12.0"), (Standards.ISIC3, "2610")),
        ((Standards.CAEM2005, "26.13"), (Standards.ISIC3, "2610")),
        ((Standards.CAEM2005, "26.13.1"), (Standards.ISIC3, "2610")),
        ((Standards.CAEM2005, "26.13.2"), (Standards.ISIC3, "2610")),
        ((Standards.CAEM2005, "26.14"), (Standards.ISIC3, "2610")),
        ((Standards.CAEM2005, "26.14.0"), (Standards.ISIC3, "2610")),
        ((Standards.CAEM2005, "26.15"), (Standards.ISIC3, "2610")),
        ((Standards.CAEM2005, "26.15.1"), (Standards.ISIC3, "2610")),
        ((Standards.CAEM2005, "26.15.2"), (Standards.ISIC3, "2610")),
        ((Standards.CAEM2005, "26.15.9"), (Standards.ISIC3, "2610")),
        ((Standards.CAEM2005, "26.2"), (Standards.ISIC3, "269")),
        ((Standards.CAEM2005, "26.21"), (Standards.ISIC3, "2691")),
        ((Standards.CAEM2005, "26.21.1"), (Standards.ISIC3, "2691")),
        ((Standards.CAEM2005, "26.21.2"), (Standards.ISIC3, "2691")),
        ((Standards.CAEM2005, "26.22"), (Standards.ISIC3, "2691")),
        ((Standards.CAEM2005, "26.22.0"), (Standards.ISIC3, "2691")),
        ((Standards.CAEM2005, "26.23"), (Standards.ISIC3, "2691")),
        ((Standards.CAEM2005, "26.23.0"), (Standards.ISIC3, "2691")),
        ((Standards.CAEM2005, "26.24"), (Standards.ISIC3, "2691")),
        ((Standards.CAEM2005, "26.24.0"), (Standards.ISIC3, "2691")),
        ((Standards.CAEM2005, "26.25"), (Standards.ISIC3, "2691")),
        ((Standards.CAEM2005, "26.25.0"), (Standards.ISIC3, "2691")),
        ((Standards.CAEM2005, "26.26"), (Standards.ISIC3, "2692")),
        ((Standards.CAEM2005, "26.26.0"), (Standards.ISIC3, "2692")),
        ((Standards.CAEM2005, "26.3"), (Standards.ISIC3, "269")),
        ((Standards.CAEM2005, "26.30"), (Standards.ISIC3, "2693")),
        ((Standards.CAEM2005, "26.30.0"), (Standards.ISIC3, "2693")),
        ((Standards.CAEM2005, "26.4"), (Standards.ISIC3, "269")),
        ((Standards.CAEM2005, "26.40"), (Standards.ISIC3, "2693")),
        ((Standards.CAEM2005, "26.40.0"), (Standards.ISIC3, "2693")),
        ((Standards.CAEM2005, "26.5"), (Standards.ISIC3, "269")),
        ((Standards.CAEM2005, "26.51"), (Standards.ISIC3, "2694")),
        ((Standards.CAEM2005, "26.51.0"), (Standards.ISIC3, "2694")),
        ((Standards.CAEM2005, "26.52"), (Standards.ISIC3, "2694")),
        ((Standards.CAEM2005, "26.52.1"), (Standards.ISIC3, "2694")),
        ((Standards.CAEM2005, "26.52.2"), (Standards.ISIC3, "2694")),
        ((Standards.CAEM2005, "26.53"), (Standards.ISIC3, "2694")),
        ((Standards.CAEM2005, "26.53.0"), (Standards.ISIC3, "2694")),
        ((Standards.CAEM2005, "26.6"), (Standards.ISIC3, "269")),
        ((Standards.CAEM2005, "26.61"), (Standards.ISIC3, "2695")),
        ((Standards.CAEM2005, "26.61.1"), (Standards.ISIC3, "2695")),
        ((Standards.CAEM2005, "26.61.2"), (Standards.ISIC3, "2695")),
        ((Standards.CAEM2005, "26.61.3"), (Standards.ISIC3, "2695")),
        ((Standards.CAEM2005, "26.62"), (Standards.ISIC3, "2695")),
        ((Standards.CAEM2005, "26.62.0"), (Standards.ISIC3, "2695")),
        ((Standards.CAEM2005, "26.63"), (Standards.ISIC3, "2695")),
        ((Standards.CAEM2005, "26.63.1"), (Standards.ISIC3, "2695")),
        ((Standards.CAEM2005, "26.63.2"), (Standards.ISIC3, "2695")),
        ((Standards.CAEM2005, "26.64"), (Standards.ISIC3, "2695")),
        ((Standards.CAEM2005, "26.64.0"), (Standards.ISIC3, "2695")),
        ((Standards.CAEM2005, "26.65"), (Standards.ISIC3, "2695")),
        ((Standards.CAEM2005, "26.65.0"), (Standards.ISIC3, "2695")),
        ((Standards.CAEM2005, "26.66"), (Standards.ISIC3, "2695")),
        ((Standards.CAEM2005, "26.66.0"), (Standards.ISIC3, "2695")),
        ((Standards.CAEM2005, "26.7"), (Standards.ISIC3, "269")),
        ((Standards.CAEM2005, "26.70"), (Standards.ISIC3, "2696")),
        ((Standards.CAEM2005, "26.70.0"), (Standards.ISIC3, "2696")),
        ((Standards.CAEM2005, "26.8"), (Standards.ISIC3, "269")),
        ((Standards.CAEM2005, "26.81"), (Standards.ISIC3, "2699")),
        ((Standards.CAEM2005, "26.81.0"), (Standards.ISIC3, "2699")),
        ((Standards.CAEM2005, "26.82"), (Standards.ISIC3, "2699")),
        ((Standards.CAEM2005, "26.82.1"), (Standards.ISIC3, "2699")),
        ((Standards.CAEM2005, "26.82.2"), (Standards.ISIC3, "2699")),
        ((Standards.CAEM2005, "26.82.3"), (Standards.ISIC3, "2699")),
        ((Standards.CAEM2005, "26.82.4"), (Standards.ISIC3, "2699")),
        ((Standards.CAEM2005, "26.82.5"), (Standards.ISIC3, "2699")),
        ((Standards.CAEM2005, "26.82.6"), (Standards.ISIC3, "2699")),
        ((Standards.CAEM2005, "27"), (Standards.ISIC3, "27")),
        ((Standards.CAEM2005, "27.1"), (Standards.ISIC3, "271")),
        ((Standards.CAEM2005, "27.10"), (Standards.ISIC3, "2710")),
        ((Standards.CAEM2005, "27.10.0"), (Standards.ISIC3, "2710")),
        ((Standards.CAEM2005, "27.2"), (Standards.ISIC3, "271")),
        ((Standards.CAEM2005, "27.21"), (Standards.ISIC3, "2710")),
        ((Standards.CAEM2005, "27.21.0"), (Standards.ISIC3, "2710")),
        ((Standards.CAEM2005, "27.22"), (Standards.ISIC3, "2710")),
        ((Standards.CAEM2005, "27.22.0"), (Standards.ISIC3, "2710")),
        ((Standards.CAEM2005, "27.3"), (Standards.ISIC3, "271")),
        ((Standards.CAEM2005, "27.31"), (Standards.ISIC3, "2710")),
        ((Standards.CAEM2005, "27.31.0"), (Standards.ISIC3, "2710")),
        ((Standards.CAEM2005, "27.32"), (Standards.ISIC3, "2710")),
        ((Standards.CAEM2005, "27.32.0"), (Standards.ISIC3, "2710")),
        ((Standards.CAEM2005, "27.33"), (Standards.ISIC3, "2710")),
        ((Standards.CAEM2005, "27.33.0"), (Standards.ISIC3, "2710")),
        ((Standards.CAEM2005, "27.34"), (Standards.ISIC3, "2710")),
        ((Standards.CAEM2005, "27.34.0"), (Standards.ISIC3, "2710")),
        ((Standards.CAEM2005, "27.4"), (Standards.ISIC3, "272")),
        ((Standards.CAEM2005, "27.41"), (Standards.ISIC3, "2720")),
        ((Standards.CAEM2005, "27.41.0"), (Standards.ISIC3, "2720")),
        ((Standards.CAEM2005, "27.42"), (Standards.ISIC3, "2720")),
        ((Standards.CAEM2005, "27.42.0"), (Standards.ISIC3, "2720")),
        ((Standards.CAEM2005, "27.43"), (Standards.ISIC3, "2720")),
        ((Standards.CAEM2005, "27.43.0"), (Standards.ISIC3, "2720")),
        ((Standards.CAEM2005, "27.44"), (Standards.ISIC3, "2720")),
        ((Standards.CAEM2005, "27.44.0"), (Standards.ISIC3, "2720")),
        ((Standards.CAEM2005, "27.45"), (Standards.ISIC3, "2720")),
        ((Standards.CAEM2005, "27.45.1"), (Standards.ISIC3, "2720")),
        ((Standards.CAEM2005, "27.45.2"), (Standards.ISIC3, "2720")),
        ((Standards.CAEM2005, "27.45.3"), (Standards.ISIC3, "2720")),
        ((Standards.CAEM2005, "27.45.4"), (Standards.ISIC3, "2720")),
        ((Standards.CAEM2005, "27.45.5"), (Standards.ISIC3, "2720")),
        ((Standards.CAEM2005, "27.5"), (Standards.ISIC3, "273")),
        ((Standards.CAEM2005, "27.51"), (Standards.ISIC3, "2731")),
        ((Standards.CAEM2005, "27.51.0"), (Standards.ISIC3, "2731")),
        ((Standards.CAEM2005, "27.52"), (Standards.ISIC3, "2731")),
        ((Standards.CAEM2005, "27.52.0"), (Standards.ISIC3, "2731")),
        ((Standards.CAEM2005, "27.53"), (Standards.ISIC3, "2732")),
        ((Standards.CAEM2005, "27.53.0"), (Standards.ISIC3, "2732")),
        ((Standards.CAEM2005, "27.54"), (Standards.ISIC3, "2732")),
        ((Standards.CAEM2005, "27.54.0"), (Standards.ISIC3, "2732")),
        ((Standards.CAEM2005, "28.1"), (Standards.ISIC3, "281")),
        ((Standards.CAEM2005, "28.11"), (Standards.ISIC3, "2811")),
        ((Standards.CAEM2005, "28.11.1"), (Standards.ISIC3, "2811")),
        ((Standards.CAEM2005, "28.11.2"), (Standards.ISIC3, "2811")),
        ((Standards.CAEM2005, "28.11.3"), (Standards.ISIC3, "2811")),
        ((Standards.CAEM2005, "28.11.4"), (Standards.ISIC3, "2811")),
        ((Standards.CAEM2005, "28.12"), (Standards.ISIC3, "2811")),
        ((Standards.CAEM2005, "28.12.0"), (Standards.ISIC3, "2811")),
        ((Standards.CAEM2005, "28.2"), (Standards.ISIC3, "281")),
        ((Standards.CAEM2005, "28.21"), (Standards.ISIC3, "2812")),
        ((Standards.CAEM2005, "28.21.0"), (Standards.ISIC3, "2812")),
        ((Standards.CAEM2005, "28.22"), (Standards.ISIC3, "2812")),
        ((Standards.CAEM2005, "28.22.0"), (Standards.ISIC3, "2812")),
        ((Standards.CAEM2005, "28.3"), (Standards.ISIC3, "281")),
        ((Standards.CAEM2005, "28.30"), (Standards.ISIC3, "2813")),
        ((Standards.CAEM2005, "28.30.0"), (Standards.ISIC3, "2813")),
        ((Standards.CAEM2005, "28.4"), (Standards.ISIC3, "289")),
        ((Standards.CAEM2005, "28.40"), (Standards.ISIC3, "2891")),
        ((Standards.CAEM2005, "28.40.1"), (Standards.ISIC3, "2891")),
        ((Standards.CAEM2005, "28.40.2"), (Standards.ISIC3, "2891")),
        ((Standards.CAEM2005, "28.5"), (Standards.ISIC3, "289")),
        ((Standards.CAEM2005, "28.51"), (Standards.ISIC3, "2892")),
        ((Standards.CAEM2005, "28.51.0"), (Standards.ISIC3, "2892")),
        ((Standards.CAEM2005, "28.52"), (Standards.ISIC3, "2892")),
        ((Standards.CAEM2005, "28.52.0"), (Standards.ISIC3, "2892")),
        ((Standards.CAEM2005, "28.6"), (Standards.ISIC3, "289")),
        ((Standards.CAEM2005, "28.61"), (Standards.ISIC3, "2893")),
        ((Standards.CAEM2005, "28.61.0"), (Standards.ISIC3, "2893")),
        ((Standards.CAEM2005, "28.62"), (Standards.ISIC3, "2893")),
        ((Standards.CAEM2005, "28.62.1"), (Standards.ISIC3, "2893")),
        ((Standards.CAEM2005, "28.62.2"), (Standards.ISIC3, "2893")),
        ((Standards.CAEM2005, "28.63"), (Standards.ISIC3, "2893")),
        ((Standards.CAEM2005, "28.63.0"), (Standards.ISIC3, "2893")),
        ((Standards.CAEM2005, "28.7"), (Standards.ISIC3, "289")),
        ((Standards.CAEM2005, "28.71"), (Standards.ISIC3, "2899")),
        ((Standards.CAEM2005, "28.71.0"), (Standards.ISIC3, "2899")),
        ((Standards.CAEM2005, "28.72"), (Standards.ISIC3, "2899")),
        ((Standards.CAEM2005, "28.72.0"), (Standards.ISIC3, "2899")),
        ((Standards.CAEM2005, "28.73"), (Standards.ISIC3, "2899")),
        ((Standards.CAEM2005, "28.73.0"), (Standards.ISIC3, "2899")),
        ((Standards.CAEM2005, "28.74"), (Standards.ISIC3, "2899")),
        ((Standards.CAEM2005, "28.74.0"), (Standards.ISIC3, "2899")),
        ((Standards.CAEM2005, "28.75"), (Standards.ISIC3, "2899")),
        ((Standards.CAEM2005, "28.75.1"), (Standards.ISIC3, "2899")),
        ((Standards.CAEM2005, "28.75.2"), (Standards.ISIC3, "2899")),
        ((Standards.CAEM2005, "28.75.9"), (Standards.ISIC3, "2899")),
        ((Standards.CAEM2005, "29"), (Standards.ISIC3, "29")),
        ((Standards.CAEM2005, "29.1"), (Standards.ISIC3, "291")),
        ((Standards.CAEM2005, "29.11"), (Standards.ISIC3, "2911")),
        ((Standards.CAEM2005, "29.11.1"), (Standards.ISIC3, "2911")),
        ((Standards.CAEM2005, "29.11.2"), (Standards.ISIC3, "2911")),
        ((Standards.CAEM2005, "29.11.9"), (Standards.ISIC3, "2911")),
        ((Standards.CAEM2005, "29.12"), (Standards.ISIC3, "2912")),
        ((Standards.CAEM2005, "29.12.1"), (Standards.ISIC3, "2912")),
        ((Standards.CAEM2005, "29.12.2"), (Standards.ISIC3, "2912")),
        ((Standards.CAEM2005, "29.12.3"), (Standards.ISIC3, "2912")),
        ((Standards.CAEM2005, "29.12.9"), (Standards.ISIC3, "2912")),
        ((Standards.CAEM2005, "29.13"), (Standards.ISIC3, "2912")),
        ((Standards.CAEM2005, "29.13.0"), (Standards.ISIC3, "2912")),
        ((Standards.CAEM2005, "29.14"), (Standards.ISIC3, "2913")),
        ((Standards.CAEM2005, "29.14.1"), (Standards.ISIC3, "2913")),
        ((Standards.CAEM2005, "29.14.2"), (Standards.ISIC3, "2913")),
        ((Standards.CAEM2005, "29.14.9"), (Standards.ISIC3, "2913")),
        ((Standards.CAEM2005, "29.2"), (Standards.ISIC3, "291")),
        ((Standards.CAEM2005, "29.21"), (Standards.ISIC3, "2914")),
        ((Standards.CAEM2005, "29.21.1"), (Standards.ISIC3, "2914")),
        ((Standards.CAEM2005, "29.21.2"), (Standards.ISIC3, "2914")),
        ((Standards.CAEM2005, "29.21.9"), (Standards.ISIC3, "2914")),
        ((Standards.CAEM2005, "29.22"), (Standards.ISIC3, "2915")),
        ((Standards.CAEM2005, "29.22.1"), (Standards.ISIC3, "2915")),
        ((Standards.CAEM2005, "29.22.2"), (Standards.ISIC3, "2915")),
        ((Standards.CAEM2005, "29.22.3"), (Standards.ISIC3, "2915")),
        ((Standards.CAEM2005, "29.22.4"), (Standards.ISIC3, "2915")),
        ((Standards.CAEM2005, "29.22.5"), (Standards.ISIC3, "2915")),
        ((Standards.CAEM2005, "29.22.6"), (Standards.ISIC3, "2915")),
        ((Standards.CAEM2005, "29.22.9"), (Standards.ISIC3, "2915")),
        ((Standards.CAEM2005, "29.23"), (Standards.ISIC3, "2919")),
        ((Standards.CAEM2005, "29.23.1"), (Standards.ISIC3, "2919")),
        ((Standards.CAEM2005, "29.23.2"), (Standards.ISIC3, "2919")),
        ((Standards.CAEM2005, "29.23.9"), (Standards.ISIC3, "2919")),
        ((Standards.CAEM2005, "29.24"), (Standards.ISIC3, "2919")),
        ((Standards.CAEM2005, "29.24.1"), (Standards.ISIC3, "2919")),
        ((Standards.CAEM2005, "29.24.2"), (Standards.ISIC3, "2919")),
        ((Standards.CAEM2005, "29.24.3"), (Standards.ISIC3, "2919")),
        ((Standards.CAEM2005, "29.24.4"), (Standards.ISIC3, "2919")),
        ((Standards.CAEM2005, "29.24.5"), (Standards.ISIC3, "2919")),
        ((Standards.CAEM2005, "29.24.8"), (Standards.ISIC3, "2919")),
        ((Standards.CAEM2005, "29.24.9"), (Standards.ISIC3, "2919")),
        ((Standards.CAEM2005, "29.3"), (Standards.ISIC3, "292")),
        ((Standards.CAEM2005, "29.31"), (Standards.ISIC3, "2921")),
        ((Standards.CAEM2005, "29.31.1"), (Standards.ISIC3, "2921")),
        ((Standards.CAEM2005, "29.31.9"), (Standards.ISIC3, "2921")),
        ((Standards.CAEM2005, "29.32"), (Standards.ISIC3, "2921")),
        ((Standards.CAEM2005, "29.32.1"), (Standards.ISIC3, "2921")),
        ((Standards.CAEM2005, "29.32.2"), (Standards.ISIC3, "2921")),
        ((Standards.CAEM2005, "29.32.3"), (Standards.ISIC3, "2921")),
        ((Standards.CAEM2005, "29.32.9"), (Standards.ISIC3, "2921")),
        ((Standards.CAEM2005, "29.4"), (Standards.ISIC3, "292")),
        ((Standards.CAEM2005, "29.41"), (Standards.ISIC3, "2922")),
        ((Standards.CAEM2005, "29.41.0"), (Standards.ISIC3, "2922")),
        ((Standards.CAEM2005, "29.42"), (Standards.ISIC3, "2922")),
        ((Standards.CAEM2005, "29.42.0"), (Standards.ISIC3, "2922")),
        ((Standards.CAEM2005, "29.43"), (Standards.ISIC3, "2922")),
        ((Standards.CAEM2005, "29.43.0"), (Standards.ISIC3, "2922")),
        ((Standards.CAEM2005, "29.5"), (Standards.ISIC3, "292")),
        ((Standards.CAEM2005, "29.51"), (Standards.ISIC3, "2923")),
        ((Standards.CAEM2005, "29.51.1"), (Standards.ISIC3, "2923")),
        ((Standards.CAEM2005, "29.51.9"), (Standards.ISIC3, "2923")),
        ((Standards.CAEM2005, "29.52"), (Standards.ISIC3, "2924")),
        ((Standards.CAEM2005, "29.52.1"), (Standards.ISIC3, "2924")),
        ((Standards.CAEM2005, "29.52.2"), (Standards.ISIC3, "2924")),
        ((Standards.CAEM2005, "29.52.3"), (Standards.ISIC3, "2924")),
        ((Standards.CAEM2005, "29.52.4"), (Standards.ISIC3, "2924")),
        ((Standards.CAEM2005, "29.52.5"), (Standards.ISIC3, "2924")),
        ((Standards.CAEM2005, "29.52.9"), (Standards.ISIC3, "2924")),
        ((Standards.CAEM2005, "29.53"), (Standards.ISIC3, "2925")),
        ((Standards.CAEM2005, "29.53.1"), (Standards.ISIC3, "2925")),
        ((Standards.CAEM2005, "29.53.9"), (Standards.ISIC3, "2925")),
        ((Standards.CAEM2005, "29.54"), (Standards.ISIC3, "2926")),
        ((Standards.CAEM2005, "29.54.1"), (Standards.ISIC3, "2926")),
        ((Standards.CAEM2005, "29.54.2"), (Standards.ISIC3, "2926")),
        ((Standards.CAEM2005, "29.54.3"), (Standards.ISIC3, "2926")),
        ((Standards.CAEM2005, "29.54.4"), (Standards.ISIC3, "2926")),
        ((Standards.CAEM2005, "29.54.5"), (Standards.ISIC3, "2926")),
        ((Standards.CAEM2005, "29.54.9"), (Standards.ISIC3, "2926")),
        ((Standards.CAEM2005, "29.55"), (Standards.ISIC3, "2929")),
        ((Standards.CAEM2005, "29.55.1"), (Standards.ISIC3, "2929")),
        ((Standards.CAEM2005, "29.55.9"), (Standards.ISIC3, "2929")),
        ((Standards.CAEM2005, "29.56"), (Standards.ISIC3, "2929")),
        ((Standards.CAEM2005, "29.56.1"), (Standards.ISIC3, "2929")),
        ((Standards.CAEM2005, "29.56.2"), (Standards.ISIC3, "2929")),
        ((Standards.CAEM2005, "29.56.3"), (Standards.ISIC3, "2929")),
        ((Standards.CAEM2005, "29.56.4"), (Standards.ISIC3, "2929")),
        ((Standards.CAEM2005, "29.56.5"), (Standards.ISIC3, "2929")),
        ((Standards.CAEM2005, "29.56.6"), (Standards.ISIC3, "2929")),
        ((Standards.CAEM2005, "29.56.7"), (Standards.ISIC3, "2929")),
        ((Standards.CAEM2005, "29.56.8"), (Standards.ISIC3, "2929")),
        ((Standards.CAEM2005, "29.56.9"), (Standards.ISIC3, "2929")),
        ((Standards.CAEM2005, "29.6"), (Standards.ISIC3, "292")),
        ((Standards.CAEM2005, "29.60"), (Standards.ISIC3, "2927")),
        ((Standards.CAEM2005, "29.60.0"), (Standards.ISIC3, "2927")),
        ((Standards.CAEM2005, "29.7"), (Standards.ISIC3, "293")),
        ((Standards.CAEM2005, "29.71"), (Standards.ISIC3, "2930")),
        ((Standards.CAEM2005, "29.71.1"), (Standards.ISIC3, "2930")),
        ((Standards.CAEM2005, "29.71.2"), (Standards.ISIC3, "2930")),
        ((Standards.CAEM2005, "29.72"), (Standards.ISIC3, "2930")),
        ((Standards.CAEM2005, "29.72.0"), (Standards.ISIC3, "2930")),
        ((Standards.CAEM2005, "30"), (Standards.ISIC3, "30")),
        ((Standards.CAEM2005, "30.0"), (Standards.ISIC3, "300")),
        ((Standards.CAEM2005, "30.01"), (Standards.ISIC3, "3000")),
        ((Standards.CAEM2005, "30.01.0"), (Standards.ISIC3, "3000")),
        ((Standards.CAEM2005, "30.02"), (Standards.ISIC3, "3000")),
        ((Standards.CAEM2005, "30.02.0"), (Standards.ISIC3, "3000")),
        ((Standards.CAEM2005, "31"), (Standards.ISIC3, "31")),
        ((Standards.CAEM2005, "31.1"), (Standards.ISIC3, "311")),
        ((Standards.CAEM2005, "31.10"), (Standards.ISIC3, "3110")),
        ((Standards.CAEM2005, "31.10.1"), (Standards.ISIC3, "3110")),
        ((Standards.CAEM2005, "31.10.9"), (Standards.ISIC3, "3110")),
        ((Standards.CAEM2005, "31.2"), (Standards.ISIC3, "312")),
        ((Standards.CAEM2005, "31.20"), (Standards.ISIC3, "3120")),
        ((Standards.CAEM2005, "31.20.1"), (Standards.ISIC3, "3120")),
        ((Standards.CAEM2005, "31.20.9"), (Standards.ISIC3, "3120")),
        ((Standards.CAEM2005, "31.3"), (Standards.ISIC3, "313")),
        ((Standards.CAEM2005, "31.30"), (Standards.ISIC3, "3130")),
        ((Standards.CAEM2005, "31.30.0"), (Standards.ISIC3, "3130")),
        ((Standards.CAEM2005, "31.4"), (Standards.ISIC3, "314")),
        ((Standards.CAEM2005, "31.40"), (Standards.ISIC3, "3140")),
        ((Standards.CAEM2005, "31.40.0"), (Standards.ISIC3, "3140")),
        ((Standards.CAEM2005, "31.5"), (Standards.ISIC3, "315")),
        ((Standards.CAEM2005, "31.50"), (Standards.ISIC3, "3150")),
        ((Standards.CAEM2005, "31.50.1"), (Standards.ISIC3, "3150")),
        ((Standards.CAEM2005, "31.50.2"), (Standards.ISIC3, "3150")),
        ((Standards.CAEM2005, "31.6"), (Standards.ISIC3, "319")),
        ((Standards.CAEM2005, "31.61"), (Standards.ISIC3, "3190")),
        ((Standards.CAEM2005, "31.61.1"), (Standards.ISIC3, "3190")),
        ((Standards.CAEM2005, "31.61.9"), (Standards.ISIC3, "3190")),
        ((Standards.CAEM2005, "31.62"), (Standards.ISIC3, "3190")),
        ((Standards.CAEM2005, "31.62.1"), (Standards.ISIC3, "3190")),
        ((Standards.CAEM2005, "31.62.2"), (Standards.ISIC3, "3190")),
        ((Standards.CAEM2005, "31.62.3"), (Standards.ISIC3, "3190")),
        ((Standards.CAEM2005, "31.62.8"), (Standards.ISIC3, "3190")),
        ((Standards.CAEM2005, "31.62.9"), (Standards.ISIC3, "3190")),
        ((Standards.CAEM2005, "32"), (Standards.ISIC3, "32")),
        ((Standards.CAEM2005, "32.1"), (Standards.ISIC3, "321")),
        ((Standards.CAEM2005, "32.10"), (Standards.ISIC3, "3210")),
        ((Standards.CAEM2005, "32.10.0"), (Standards.ISIC3, "3210")),
        ((Standards.CAEM2005, "32.2"), (Standards.ISIC3, "322")),
        ((Standards.CAEM2005, "32.20"), (Standards.ISIC3, "3220")),
        ((Standards.CAEM2005, "32.20.1"), (Standards.ISIC3, "3220")),
        ((Standards.CAEM2005, "32.20.2"), (Standards.ISIC3, "3220")),
        ((Standards.CAEM2005, "32.20.9"), (Standards.ISIC3, "3220")),
        ((Standards.CAEM2005, "32.3"), (Standards.ISIC3, "323")),
        ((Standards.CAEM2005, "32.30"), (Standards.ISIC3, "3230")),
        ((Standards.CAEM2005, "32.30.1"), (Standards.ISIC3, "3230")),
        ((Standards.CAEM2005, "32.30.9"), (Standards.ISIC3, "3230")),
        ((Standards.CAEM2005, "33"), (Standards.ISIC3, "33")),
        ((Standards.CAEM2005, "33.1"), (Standards.ISIC3, "331")),
        ((Standards.CAEM2005, "33.10"), (Standards.ISIC3, "3311")),
        ((Standards.CAEM2005, "33.10.1"), (Standards.ISIC3, "3311")),
        ((Standards.CAEM2005, "33.10.2"), (Standards.ISIC3, "3311")),
        ((Standards.CAEM2005, "33.10.3"), (Standards.ISIC3, "3311")),
        ((Standards.CAEM2005, "33.10.4"), (Standards.ISIC3, "3311")),
        ((Standards.CAEM2005, "33.2"), (Standards.ISIC3, "331")),
        ((Standards.CAEM2005, "33.20"), (Standards.ISIC3, "3312")),
        ((Standards.CAEM2005, "33.20.1"), (Standards.ISIC3, "3312")),
        ((Standards.CAEM2005, "33.20.2"), (Standards.ISIC3, "3312")),
        ((Standards.CAEM2005, "33.20.3"), (Standards.ISIC3, "3312")),
        ((Standards.CAEM2005, "33.20.4"), (Standards.ISIC3, "3312")),
        ((Standards.CAEM2005, "33.20.5"), (Standards.ISIC3, "3312")),
        ((Standards.CAEM2005, "33.20.6"), (Standards.ISIC3, "3312")),
        ((Standards.CAEM2005, "33.20.9"), (Standards.ISIC3, "3312")),
        ((Standards.CAEM2005, "33.3"), (Standards.ISIC3, "331")),
        ((Standards.CAEM2005, "33.30"), (Standards.ISIC3, "3313")),
        ((Standards.CAEM2005, "33.30.1"), (Standards.ISIC3, "3313")),
        ((Standards.CAEM2005, "33.30.9"), (Standards.ISIC3, "3313")),
        ((Standards.CAEM2005, "33.4"), (Standards.ISIC3, "332")),
        ((Standards.CAEM2005, "33.40"), (Standards.ISIC3, "3320")),
        ((Standards.CAEM2005, "33.40.1"), (Standards.ISIC3, "3320")),
        ((Standards.CAEM2005, "33.40.2"), (Standards.ISIC3, "3320")),
        ((Standards.CAEM2005, "33.40.3"), (Standards.ISIC3, "3320")),
        ((Standards.CAEM2005, "33.40.9"), (Standards.ISIC3, "3320")),
        ((Standards.CAEM2005, "33.5"), (Standards.ISIC3, "333")),
        ((Standards.CAEM2005, "33.50"), (Standards.ISIC3, "3330")),
        ((Standards.CAEM2005, "33.50.1"), (Standards.ISIC3, "3330")),
        ((Standards.CAEM2005, "33.50.2"), (Standards.ISIC3, "3330")),
        ((Standards.CAEM2005, "33.50.3"), (Standards.ISIC3, "3330")),
        ((Standards.CAEM2005, "34"), (Standards.ISIC3, "34")),
        ((Standards.CAEM2005, "34.1"), (Standards.ISIC3, "341")),
        ((Standards.CAEM2005, "34.10"), (Standards.ISIC3, "3410")),
        ((Standards.CAEM2005, "34.10.1"), (Standards.ISIC3, "3410")),
        ((Standards.CAEM2005, "34.10.2"), (Standards.ISIC3, "3410")),
        ((Standards.CAEM2005, "34.2"), (Standards.ISIC3, "342")),
        ((Standards.CAEM2005, "34.20"), (Standards.ISIC3, "3420")),
        ((Standards.CAEM2005, "34.20.1"), (Standards.ISIC3, "3420")),
        ((Standards.CAEM2005, "34.20.2"), (Standards.ISIC3, "3420")),
        ((Standards.CAEM2005, "34.3"), (Standards.ISIC3, "343")),
        ((Standards.CAEM2005, "34.30"), (Standards.ISIC3, "3430")),
        ((Standards.CAEM2005, "34.30.1"), (Standards.ISIC3, "3430")),
        ((Standards.CAEM2005, "34.30.2"), (Standards.ISIC3, "3430")),
        ((Standards.CAEM2005, "35"), (Standards.ISIC3, "35")),
        ((Standards.CAEM2005, "35.1"), (Standards.ISIC3, "351")),
        ((Standards.CAEM2005, "35.11"), (Standards.ISIC3, "3511")),
        ((Standards.CAEM2005, "35.11.1"), (Standards.ISIC3, "3511")),
        ((Standards.CAEM2005, "35.11.9"), (Standards.ISIC3, "3511")),
        ((Standards.CAEM2005, "35.12"), (Standards.ISIC3, "3512")),
        ((Standards.CAEM2005, "35.12.1"), (Standards.ISIC3, "3512")),
        ((Standards.CAEM2005, "35.12.9"), (Standards.ISIC3, "3512")),
        ((Standards.CAEM2005, "35.2"), (Standards.ISIC3, "352")),
        ((Standards.CAEM2005, "35.20"), (Standards.ISIC3, "3520")),
        ((Standards.CAEM2005, "35.20.1"), (Standards.ISIC3, "3520")),
        ((Standards.CAEM2005, "35.20.8"), (Standards.ISIC3, "3520")),
        ((Standards.CAEM2005, "35.20.9"), (Standards.ISIC3, "3520")),
        ((Standards.CAEM2005, "35.3"), (Standards.ISIC3, "353")),
        ((Standards.CAEM2005, "35.30"), (Standards.ISIC3, "3530")),
        ((Standards.CAEM2005, "35.30.1"), (Standards.ISIC3, "3530")),
        ((Standards.CAEM2005, "35.30.2"), (Standards.ISIC3, "3530")),
        ((Standards.CAEM2005, "35.30.9"), (Standards.ISIC3, "3530")),
        ((Standards.CAEM2005, "35.4"), (Standards.ISIC3, "359")),
        ((Standards.CAEM2005, "35.41"), (Standards.ISIC3, "3591")),
        ((Standards.CAEM2005, "35.41.0"), (Standards.ISIC3, "3591")),
        ((Standards.CAEM2005, "35.42"), (Standards.ISIC3, "3592")),
        ((Standards.CAEM2005, "35.42.0"), (Standards.ISIC3, "3592")),
        ((Standards.CAEM2005, "35.43"), (Standards.ISIC3, "3592")),
        ((Standards.CAEM2005, "35.43.0"), (Standards.ISIC3, "3592")),
        ((Standards.CAEM2005, "35.5"), (Standards.ISIC3, "359")),
        ((Standards.CAEM2005, "35.50"), (Standards.ISIC3, "3599")),
        ((Standards.CAEM2005, "35.50.0"), (Standards.ISIC3, "3599")),
        ((Standards.CAEM2005, "36.1"), (Standards.ISIC3, "361")),
        ((Standards.CAEM2005, "36.11"), (Standards.ISIC3, "3610")),
        ((Standards.CAEM2005, "36.11.0"), (Standards.ISIC3, "3610")),
        ((Standards.CAEM2005, "36.12"), (Standards.ISIC3, "3610")),
        ((Standards.CAEM2005, "36.12.0"), (Standards.ISIC3, "3610")),
        ((Standards.CAEM2005, "36.13"), (Standards.ISIC3, "3610")),
        ((Standards.CAEM2005, "36.13.0"), (Standards.ISIC3, "3610")),
        ((Standards.CAEM2005, "36.14"), (Standards.ISIC3, "3610")),
        ((Standards.CAEM2005, "36.14.0"), (Standards.ISIC3, "3610")),
        ((Standards.CAEM2005, "36.15"), (Standards.ISIC3, "3610")),
        ((Standards.CAEM2005, "36.15.0"), (Standards.ISIC3, "3610")),
        ((Standards.CAEM2005, "36.2"), (Standards.ISIC3, "369")),
        ((Standards.CAEM2005, "36.21"), (Standards.ISIC3, "3691")),
        ((Standards.CAEM2005, "36.21.0"), (Standards.ISIC3, "3691")),
        ((Standards.CAEM2005, "36.22"), (Standards.ISIC3, "3691")),
        ((Standards.CAEM2005, "36.22.0"), (Standards.ISIC3, "3691")),
        ((Standards.CAEM2005, "36.3"), (Standards.ISIC3, "369")),
        ((Standards.CAEM2005, "36.30"), (Standards.ISIC3, "3692")),
        ((Standards.CAEM2005, "36.30.1"), (Standards.ISIC3, "3692")),
        ((Standards.CAEM2005, "36.30.9"), (Standards.ISIC3, "3692")),
        ((Standards.CAEM2005, "36.4"), (Standards.ISIC3, "369")),
        ((Standards.CAEM2005, "36.40"), (Standards.ISIC3, "3693")),
        ((Standards.CAEM2005, "36.40.0"), (Standards.ISIC3, "3693")),
        ((Standards.CAEM2005, "36.5"), (Standards.ISIC3, "369")),
        ((Standards.CAEM2005, "36.50"), (Standards.ISIC3, "3694")),
        ((Standards.CAEM2005, "36.50.0"), (Standards.ISIC3, "3694")),
        ((Standards.CAEM2005, "36.6"), (Standards.ISIC3, "369")),
        ((Standards.CAEM2005, "36.61"), (Standards.ISIC3, "3699")),
        ((Standards.CAEM2005, "36.61.0"), (Standards.ISIC3, "3699")),
        ((Standards.CAEM2005, "36.62"), (Standards.ISIC3, "3699")),
        ((Standards.CAEM2005, "36.62.0"), (Standards.ISIC3, "3699")),
        ((Standards.CAEM2005, "36.63"), (Standards.ISIC3, "3699")),
        ((Standards.CAEM2005, "36.63.1"), (Standards.ISIC3, "3699")),
        ((Standards.CAEM2005, "36.63.2"), (Standards.ISIC3, "3699")),
        ((Standards.CAEM2005, "36.63.3"), (Standards.ISIC3, "3699")),
        ((Standards.CAEM2005, "36.63.4"), (Standards.ISIC3, "3699")),
        ((Standards.CAEM2005, "36.63.5"), (Standards.ISIC3, "3699")),
        ((Standards.CAEM2005, "36.63.6"), (Standards.ISIC3, "3699")),
        ((Standards.CAEM2005, "36.63.9"), (Standards.ISIC3, "3699")),
        ((Standards.CAEM2005, "37"), (Standards.ISIC3, "37")),
        ((Standards.CAEM2005, "37.1"), (Standards.ISIC3, "371")),
        ((Standards.CAEM2005, "37.10"), (Standards.ISIC3, "3710")),
        ((Standards.CAEM2005, "37.10.1"), (Standards.ISIC3, "3710")),
        ((Standards.CAEM2005, "37.10.2"), (Standards.ISIC3, "3710")),
        ((Standards.CAEM2005, "37.2"), (Standards.ISIC3, "372")),
        ((Standards.CAEM2005, "37.20"), (Standards.ISIC3, "3720")),
        ((Standards.CAEM2005, "37.20.0"), (Standards.ISIC3, "3720")),
        ((Standards.CAEM2005, "E"), (Standards.ISIC3, "E")),
        ((Standards.CAEM2005, "40"), (Standards.ISIC3, "40")),
        ((Standards.CAEM2005, "40.1"), (Standards.ISIC3, "401")),
        ((Standards.CAEM2005, "40.11"), (Standards.ISIC3, "4010")),
        ((Standards.CAEM2005, "40.11.1"), (Standards.ISIC3, "4010")),
        ((Standards.CAEM2005, "40.11.2"), (Standards.ISIC3, "4010")),
        ((Standards.CAEM2005, "40.11.3"), (Standards.ISIC3, "4010")),
        ((Standards.CAEM2005, "40.11.4"), (Standards.ISIC3, "4010")),
        ((Standards.CAEM2005, "40.12"), (Standards.ISIC3, "4010")),
        ((Standards.CAEM2005, "40.12.0"), (Standards.ISIC3, "4010")),
        ((Standards.CAEM2005, "40.13"), (Standards.ISIC3, "4010")),
        ((Standards.CAEM2005, "40.13.0"), (Standards.ISIC3, "4010")),
        ((Standards.CAEM2005, "40.2"), (Standards.ISIC3, "402")),
        ((Standards.CAEM2005, "40.21"), (Standards.ISIC3, "4020")),
        ((Standards.CAEM2005, "40.21.0"), (Standards.ISIC3, "4020")),
        ((Standards.CAEM2005, "40.22"), (Standards.ISIC3, "4020")),
        ((Standards.CAEM2005, "40.22.0"), (Standards.ISIC3, "4020")),
        ((Standards.CAEM2005, "40.3"), (Standards.ISIC3, "403")),
        ((Standards.CAEM2005, "40.30"), (Standards.ISIC3, "4030")),
        ((Standards.CAEM2005, "40.30.1"), (Standards.ISIC3, "4030")),
        ((Standards.CAEM2005, "40.30.2"), (Standards.ISIC3, "4030")),
        ((Standards.CAEM2005, "40.30.3"), (Standards.ISIC3, "4030")),
        ((Standards.CAEM2005, "41"), (Standards.ISIC3, "41")),
        ((Standards.CAEM2005, "41.0"), (Standards.ISIC3, "410")),
        ((Standards.CAEM2005, "41.00"), (Standards.ISIC3, "4100")),
        ((Standards.CAEM2005, "41.00.0"), (Standards.ISIC3, "4100")),
        ((Standards.CAEM2005, "F"), (Standards.ISIC3, "F")),
        ((Standards.CAEM2005, "45"), (Standards.ISIC3, "45")),
        ((Standards.CAEM2005, "45.1"), (Standards.ISIC3, "451")),
        ((Standards.CAEM2005, "45.11"), (Standards.ISIC3, "4510")),
        ((Standards.CAEM2005, "45.11.1"), (Standards.ISIC3, "4510")),
        ((Standards.CAEM2005, "45.11.2"), (Standards.ISIC3, "4510")),
        ((Standards.CAEM2005, "45.11.3"), (Standards.ISIC3, "4510")),
        ((Standards.CAEM2005, "45.11.4"), (Standards.ISIC3, "4510")),
        ((Standards.CAEM2005, "45.11.5"), (Standards.ISIC3, "4510")),
        ((Standards.CAEM2005, "45.12"), (Standards.ISIC3, "4510")),
        ((Standards.CAEM2005, "45.12.0"), (Standards.ISIC3, "4510")),
        ((Standards.CAEM2005, "45.2"), (Standards.ISIC3, "452")),
        ((Standards.CAEM2005, "45.21"), (Standards.ISIC3, "4520")),
        ((Standards.CAEM2005, "45.21.1"), (Standards.ISIC3, "4520")),
        ((Standards.CAEM2005, "45.21.2"), (Standards.ISIC3, "4520")),
        ((Standards.CAEM2005, "45.22"), (Standards.ISIC3, "4520")),
        ((Standards.CAEM2005, "45.22.0"), (Standards.ISIC3, "4520")),
        ((Standards.CAEM2005, "45.23"), (Standards.ISIC3, "4520")),
        ((Standards.CAEM2005, "45.23.0"), (Standards.ISIC3, "4520")),
        ((Standards.CAEM2005, "45.24"), (Standards.ISIC3, "4520")),
        ((Standards.CAEM2005, "45.24.0"), (Standards.ISIC3, "4520")),
        ((Standards.CAEM2005, "45.25"), (Standards.ISIC3, "4520")),
        ((Standards.CAEM2005, "45.25.1"), (Standards.ISIC3, "4520")),
        ((Standards.CAEM2005, "45.25.9"), (Standards.ISIC3, "4520")),
        ((Standards.CAEM2005, "45.3"), (Standards.ISIC3, "453")),
        ((Standards.CAEM2005, "45.31"), (Standards.ISIC3, "4530")),
        ((Standards.CAEM2005, "45.31.0"), (Standards.ISIC3, "4530")),
        ((Standards.CAEM2005, "45.32"), (Standards.ISIC3, "4530")),
        ((Standards.CAEM2005, "45.32.0"), (Standards.ISIC3, "4530")),
        ((Standards.CAEM2005, "45.33"), (Standards.ISIC3, "4530")),
        ((Standards.CAEM2005, "45.33.0"), (Standards.ISIC3, "4530")),
        ((Standards.CAEM2005, "45.34"), (Standards.ISIC3, "4530")),
        ((Standards.CAEM2005, "45.34.0"), (Standards.ISIC3, "4530")),
        ((Standards.CAEM2005, "45.4"), (Standards.ISIC3, "454")),
        ((Standards.CAEM2005, "45.41"), (Standards.ISIC3, "4540")),
        ((Standards.CAEM2005, "45.41.0"), (Standards.ISIC3, "4540")),
        ((Standards.CAEM2005, "45.42"), (Standards.ISIC3, "4540")),
        ((Standards.CAEM2005, "45.42.0"), (Standards.ISIC3, "4540")),
        ((Standards.CAEM2005, "45.43"), (Standards.ISIC3, "4540")),
        ((Standards.CAEM2005, "45.43.0"), (Standards.ISIC3, "4540")),
        ((Standards.CAEM2005, "45.44"), (Standards.ISIC3, "4540")),
        ((Standards.CAEM2005, "45.44.0"), (Standards.ISIC3, "4540")),
        ((Standards.CAEM2005, "45.45"), (Standards.ISIC3, "4540")),
        ((Standards.CAEM2005, "45.45.0"), (Standards.ISIC3, "4540")),
        ((Standards.CAEM2005, "45.5"), (Standards.ISIC3, "455")),
        ((Standards.CAEM2005, "45.50"), (Standards.ISIC3, "4550")),
        ((Standards.CAEM2005, "45.50.0"), (Standards.ISIC3, "4550")),
        ((Standards.CAEM2005, "G"), (Standards.ISIC3, "G")),
        ((Standards.CAEM2005, "50"), (Standards.ISIC3, "50")),
        ((Standards.CAEM2005, "50.1"), (Standards.ISIC3, "501")),
        ((Standards.CAEM2005, "50.10"), (Standards.ISIC3, "5010")),
        ((Standards.CAEM2005, "50.10.1"), (Standards.ISIC3, "5010")),
        ((Standards.CAEM2005, "50.10.2"), (Standards.ISIC3, "5010")),
        ((Standards.CAEM2005, "50.2"), (Standards.ISIC3, "502")),
        ((Standards.CAEM2005, "50.20"), (Standards.ISIC3, "5020")),
        ((Standards.CAEM2005, "50.20.0"), (Standards.ISIC3, "5020")),
        ((Standards.CAEM2005, "50.3"), (Standards.ISIC3, "503")),
        ((Standards.CAEM2005, "50.30"), (Standards.ISIC3, "5030")),
        ((Standards.CAEM2005, "50.30.1"), (Standards.ISIC3, "5030")),
        ((Standards.CAEM2005, "50.30.2"), (Standards.ISIC3, "5030")),
        ((Standards.CAEM2005, "50.4"), (Standards.ISIC3, "504")),
        ((Standards.CAEM2005, "50.40"), (Standards.ISIC3, "5040")),
        ((Standards.CAEM2005, "50.40.1"), (Standards.ISIC3, "5040")),
        ((Standards.CAEM2005, "50.40.2"), (Standards.ISIC3, "5040")),
        ((Standards.CAEM2005, "50.40.3"), (Standards.ISIC3, "5040")),
        ((Standards.CAEM2005, "50.5"), (Standards.ISIC3, "505")),
        ((Standards.CAEM2005, "50.50"), (Standards.ISIC3, "5050")),
        ((Standards.CAEM2005, "50.50.0"), (Standards.ISIC3, "5050")),
        ((Standards.CAEM2005, "51.1"), (Standards.ISIC3, "511")),
        ((Standards.CAEM2005, "51.11"), (Standards.ISIC3, "5110")),
        ((Standards.CAEM2005, "51.11.0"), (Standards.ISIC3, "5110")),
        ((Standards.CAEM2005, "51.12"), (Standards.ISIC3, "5110")),
        ((Standards.CAEM2005, "51.12.0"), (Standards.ISIC3, "5110")),
        ((Standards.CAEM2005, "51.13"), (Standards.ISIC3, "5110")),
        ((Standards.CAEM2005, "51.13.0"), (Standards.ISIC3, "5110")),
        ((Standards.CAEM2005, "51.14"), (Standards.ISIC3, "5110")),
        ((Standards.CAEM2005, "51.14.0"), (Standards.ISIC3, "5110")),
        ((Standards.CAEM2005, "51.15"), (Standards.ISIC3, "5110")),
        ((Standards.CAEM2005, "51.15.0"), (Standards.ISIC3, "5110")),
        ((Standards.CAEM2005, "51.16"), (Standards.ISIC3, "5110")),
        ((Standards.CAEM2005, "51.16.0"), (Standards.ISIC3, "5110")),
        ((Standards.CAEM2005, "51.17"), (Standards.ISIC3, "5110")),
        ((Standards.CAEM2005, "51.17.0"), (Standards.ISIC3, "5110")),
        ((Standards.CAEM2005, "51.18"), (Standards.ISIC3, "5110")),
        ((Standards.CAEM2005, "51.18.0"), (Standards.ISIC3, "5110")),
        ((Standards.CAEM2005, "51.19"), (Standards.ISIC3, "5110")),
        ((Standards.CAEM2005, "51.19.0"), (Standards.ISIC3, "5110")),
        ((Standards.CAEM2005, "51.2"), (Standards.ISIC3, "512")),
        ((Standards.CAEM2005, "51.21"), (Standards.ISIC3, "5121")),
        ((Standards.CAEM2005, "51.21.0"), (Standards.ISIC3, "5121")),
        ((Standards.CAEM2005, "51.22"), (Standards.ISIC3, "5121")),
        ((Standards.CAEM2005, "51.22.0"), (Standards.ISIC3, "5121")),
        ((Standards.CAEM2005, "51.23"), (Standards.ISIC3, "5121")),
        ((Standards.CAEM2005, "51.23.0"), (Standards.ISIC3, "5121")),
        ((Standards.CAEM2005, "51.24"), (Standards.ISIC3, "5121")),
        ((Standards.CAEM2005, "51.24.0"), (Standards.ISIC3, "5121")),
        ((Standards.CAEM2005, "51.25"), (Standards.ISIC3, "5121")),
        ((Standards.CAEM2005, "51.25.0"), (Standards.ISIC3, "5121")),
        ((Standards.CAEM2005, "51.3"), (Standards.ISIC3, "512")),
        ((Standards.CAEM2005, "51.31"), (Standards.ISIC3, "5122")),
        ((Standards.CAEM2005, "51.31.0"), (Standards.ISIC3, "5122")),
        ((Standards.CAEM2005, "51.32"), (Standards.ISIC3, "5122")),
        ((Standards.CAEM2005, "51.32.0"), (Standards.ISIC3, "5122")),
        ((Standards.CAEM2005, "51.33"), (Standards.ISIC3, "5122")),
        ((Standards.CAEM2005, "51.33.0"), (Standards.ISIC3, "5122")),
        ((Standards.CAEM2005, "51.34"), (Standards.ISIC3, "5122")),
        ((Standards.CAEM2005, "51.34.0"), (Standards.ISIC3, "5122")),
        ((Standards.CAEM2005, "51.35"), (Standards.ISIC3, "5122")),
        ((Standards.CAEM2005, "51.35.0"), (Standards.ISIC3, "5122")),
        ((Standards.CAEM2005, "51.36"), (Standards.ISIC3, "5122")),
        ((Standards.CAEM2005, "51.36.0"), (Standards.ISIC3, "5122")),
        ((Standards.CAEM2005, "51.37"), (Standards.ISIC3, "5122")),
        ((Standards.CAEM2005, "51.37.0"), (Standards.ISIC3, "5122")),
        ((Standards.CAEM2005, "51.38"), (Standards.ISIC3, "5122")),
        ((Standards.CAEM2005, "51.38.1"), (Standards.ISIC3, "5122")),
        ((Standards.CAEM2005, "51.38.2"), (Standards.ISIC3, "5122")),
        ((Standards.CAEM2005, "51.38.3"), (Standards.ISIC3, "5122")),
        ((Standards.CAEM2005, "51.38.4"), (Standards.ISIC3, "5122")),
        ((Standards.CAEM2005, "51.38.9"), (Standards.ISIC3, "5122")),
        ((Standards.CAEM2005, "51.39"), (Standards.ISIC3, "5122")),
        ((Standards.CAEM2005, "51.39.0"), (Standards.ISIC3, "5122")),
        ((Standards.CAEM2005, "51.4"), (Standards.ISIC3, "513")),
        ((Standards.CAEM2005, "51.41"), (Standards.ISIC3, "5131")),
        ((Standards.CAEM2005, "51.41.0"), (Standards.ISIC3, "5131")),
        ((Standards.CAEM2005, "51.42"), (Standards.ISIC3, "5131")),
        ((Standards.CAEM2005, "51.42.1"), (Standards.ISIC3, "5131")),
        ((Standards.CAEM2005, "51.42.2"), (Standards.ISIC3, "5131")),
        ((Standards.CAEM2005, "51.42.3"), (Standards.ISIC3, "5131")),
        ((Standards.CAEM2005, "51.43"), (Standards.ISIC3, "5139")),
        ((Standards.CAEM2005, "51.43.1"), (Standards.ISIC3, "5139")),
        ((Standards.CAEM2005, "51.43.2"), (Standards.ISIC3, "5139")),
        ((Standards.CAEM2005, "51.44"), (Standards.ISIC3, "5139")),
        ((Standards.CAEM2005, "51.44.0"), (Standards.ISIC3, "5139")),
        ((Standards.CAEM2005, "51.45"), (Standards.ISIC3, "5139")),
        ((Standards.CAEM2005, "51.45.0"), (Standards.ISIC3, "5139")),
        ((Standards.CAEM2005, "51.46"), (Standards.ISIC3, "5139")),
        ((Standards.CAEM2005, "51.46.0"), (Standards.ISIC3, "5139")),
        ((Standards.CAEM2005, "51.47"), (Standards.ISIC3, "5139")),
        ((Standards.CAEM2005, "51.47.1"), (Standards.ISIC3, "5139")),
        ((Standards.CAEM2005, "51.47.2"), (Standards.ISIC3, "5139")),
        ((Standards.CAEM2005, "51.47.9"), (Standards.ISIC3, "5139")),
        ((Standards.CAEM2005, "51.5"), (Standards.ISIC3, "514")),
        ((Standards.CAEM2005, "51.51"), (Standards.ISIC3, "5141")),
        ((Standards.CAEM2005, "51.51.1"), (Standards.ISIC3, "5141")),
        ((Standards.CAEM2005, "51.51.2"), (Standards.ISIC3, "5141")),
        ((Standards.CAEM2005, "51.51.3"), (Standards.ISIC3, "5141")),
        ((Standards.CAEM2005, "51.51.4"), (Standards.ISIC3, "5141")),
        ((Standards.CAEM2005, "51.51.5"), (Standards.ISIC3, "5141")),
        ((Standards.CAEM2005, "51.51.6"), (Standards.ISIC3, "5141")),
        ((Standards.CAEM2005, "51.51.7"), (Standards.ISIC3, "5141")),
        ((Standards.CAEM2005, "51.51.8"), (Standards.ISIC3, "5141")),
        ((Standards.CAEM2005, "51.51.9"), (Standards.ISIC3, "5141")),
        ((Standards.CAEM2005, "51.52"), (Standards.ISIC3, "5142")),
        ((Standards.CAEM2005, "51.52.0"), (Standards.ISIC3, "5142")),
        ((Standards.CAEM2005, "51.53"), (Standards.ISIC3, "5143")),
        ((Standards.CAEM2005, "51.53.1"), (Standards.ISIC3, "5143")),
        ((Standards.CAEM2005, "51.53.2"), (Standards.ISIC3, "5143")),
        ((Standards.CAEM2005, "51.53.3"), (Standards.ISIC3, "5143")),
        ((Standards.CAEM2005, "51.53.4"), (Standards.ISIC3, "5143")),
        ((Standards.CAEM2005, "51.53.5"), (Standards.ISIC3, "5143")),
        ((Standards.CAEM2005, "51.53.6"), (Standards.ISIC3, "5143")),
        ((Standards.CAEM2005, "51.53.7"), (Standards.ISIC3, "5143")),
        ((Standards.CAEM2005, "51.53.8"), (Standards.ISIC3, "5143")),
        ((Standards.CAEM2005, "51.53.9"), (Standards.ISIC3, "5143")),
        ((Standards.CAEM2005, "51.54"), (Standards.ISIC3, "5143")),
        ((Standards.CAEM2005, "51.54.0"), (Standards.ISIC3, "5143")),
        ((Standards.CAEM2005, "51.55"), (Standards.ISIC3, "5149")),
        ((Standards.CAEM2005, "51.55.1"), (Standards.ISIC3, "5149")),
        ((Standards.CAEM2005, "51.55.2"), (Standards.ISIC3, "5149")),
        ((Standards.CAEM2005, "51.55.3"), (Standards.ISIC3, "5149")),
        ((Standards.CAEM2005, "51.55.4"), (Standards.ISIC3, "5149")),
        ((Standards.CAEM2005, "51.55.5"), (Standards.ISIC3, "5149")),
        ((Standards.CAEM2005, "51.56"), (Standards.ISIC3, "5149")),
        ((Standards.CAEM2005, "51.56.0"), (Standards.ISIC3, "5149")),
        ((Standards.CAEM2005, "51.57"), (Standards.ISIC3, "5149")),
        ((Standards.CAEM2005, "51.57.1"), (Standards.ISIC3, "5149")),
        ((Standards.CAEM2005, "51.57.2"), (Standards.ISIC3, "5149")),
        ((Standards.CAEM2005, "51.57.3"), (Standards.ISIC3, "5149")),
        ((Standards.CAEM2005, "51.57.4"), (Standards.ISIC3, "5149")),
        ((Standards.CAEM2005, "51.8"), (Standards.ISIC3, "515")),
        ((Standards.CAEM2005, "51.81"), (Standards.ISIC3, "5150")),
        ((Standards.CAEM2005, "51.81.0"), (Standards.ISIC3, "5150")),
        ((Standards.CAEM2005, "51.82"), (Standards.ISIC3, "5150")),
        ((Standards.CAEM2005, "51.82.0"), (Standards.ISIC3, "5150")),
        ((Standards.CAEM2005, "51.83"), (Standards.ISIC3, "5150")),
        ((Standards.CAEM2005, "51.83.0"), (Standards.ISIC3, "5150")),
        ((Standards.CAEM2005, "51.84"), (Standards.ISIC3, "5150")),
        ((Standards.CAEM2005, "51.84.0"), (Standards.ISIC3, "5150")),
        ((Standards.CAEM2005, "51.85"), (Standards.ISIC3, "5150")),
        ((Standards.CAEM2005, "51.85.0"), (Standards.ISIC3, "5150")),
        ((Standards.CAEM2005, "51.86"), (Standards.ISIC3, "5150")),
        ((Standards.CAEM2005, "51.86.0"), (Standards.ISIC3, "5150")),
        ((Standards.CAEM2005, "51.87"), (Standards.ISIC3, "5150")),
        ((Standards.CAEM2005, "51.87.0"), (Standards.ISIC3, "5150")),
        ((Standards.CAEM2005, "51.88"), (Standards.ISIC3, "5150")),
        ((Standards.CAEM2005, "51.88.0"), (Standards.ISIC3, "5150")),
        ((Standards.CAEM2005, "51.9"), (Standards.ISIC3, "519")),
        ((Standards.CAEM2005, "51.90"), (Standards.ISIC3, "5190")),
        ((Standards.CAEM2005, "51.90.0"), (Standards.ISIC3, "5190")),
        ((Standards.CAEM2005, "52"), (Standards.ISIC3, "52")),
        ((Standards.CAEM2005, "52.1"), (Standards.ISIC3, "521")),
        ((Standards.CAEM2005, "52.11"), (Standards.ISIC3, "5211")),
        ((Standards.CAEM2005, "52.11.0"), (Standards.ISIC3, "5211")),
        ((Standards.CAEM2005, "52.12"), (Standards.ISIC3, "5219")),
        ((Standards.CAEM2005, "52.12.0"), (Standards.ISIC3, "5219")),
        ((Standards.CAEM2005, "52.2"), (Standards.ISIC3, "522")),
        ((Standards.CAEM2005, "52.21"), (Standards.ISIC3, "5220")),
        ((Standards.CAEM2005, "52.21.0"), (Standards.ISIC3, "5220")),
        ((Standards.CAEM2005, "52.22"), (Standards.ISIC3, "5220")),
        ((Standards.CAEM2005, "52.22.1"), (Standards.ISIC3, "5220")),
        ((Standards.CAEM2005, "52.22.9"), (Standards.ISIC3, "5220")),
        ((Standards.CAEM2005, "52.23"), (Standards.ISIC3, "5220")),
        ((Standards.CAEM2005, "52.23.0"), (Standards.ISIC3, "5220")),
        ((Standards.CAEM2005, "52.24"), (Standards.ISIC3, "5220")),
        ((Standards.CAEM2005, "52.24.0"), (Standards.ISIC3, "5220")),
        ((Standards.CAEM2005, "52.25"), (Standards.ISIC3, "5220")),
        ((Standards.CAEM2005, "52.25.0"), (Standards.ISIC3, "5220")),
        ((Standards.CAEM2005, "52.26"), (Standards.ISIC3, "5220")),
        ((Standards.CAEM2005, "52.26.0"), (Standards.ISIC3, "5220")),
        ((Standards.CAEM2005, "52.27"), (Standards.ISIC3, "5220")),
        ((Standards.CAEM2005, "52.27.1"), (Standards.ISIC3, "5220")),
        ((Standards.CAEM2005, "52.27.2"), (Standards.ISIC3, "5220")),
        ((Standards.CAEM2005, "52.3"), (Standards.ISIC3, "523")),
        ((Standards.CAEM2005, "52.31"), (Standards.ISIC3, "5231")),
        ((Standards.CAEM2005, "52.31.0"), (Standards.ISIC3, "5231")),
        ((Standards.CAEM2005, "52.32"), (Standards.ISIC3, "5231")),
        ((Standards.CAEM2005, "52.32.0"), (Standards.ISIC3, "5231")),
        ((Standards.CAEM2005, "52.33"), (Standards.ISIC3, "5231")),
        ((Standards.CAEM2005, "52.33.0"), (Standards.ISIC3, "5231")),
        ((Standards.CAEM2005, "52.4"), (Standards.ISIC3, "523")),
        ((Standards.CAEM2005, "52.41"), (Standards.ISIC3, "5232")),
        ((Standards.CAEM2005, "52.41.0"), (Standards.ISIC3, "5232")),
        ((Standards.CAEM2005, "52.42"), (Standards.ISIC3, "5232")),
        ((Standards.CAEM2005, "52.42.1"), (Standards.ISIC3, "5232")),
        ((Standards.CAEM2005, "52.42.2"), (Standards.ISIC3, "5232")),
        ((Standards.CAEM2005, "52.43"), (Standards.ISIC3, "5232")),
        ((Standards.CAEM2005, "52.43.1"), (Standards.ISIC3, "5232")),
        ((Standards.CAEM2005, "52.43.2"), (Standards.ISIC3, "5232")),
        ((Standards.CAEM2005, "52.44"), (Standards.ISIC3, "5233")),
        ((Standards.CAEM2005, "52.44.1"), (Standards.ISIC3, "5233")),
        ((Standards.CAEM2005, "52.44.9"), (Standards.ISIC3, "5233")),
        ((Standards.CAEM2005, "52.45"), (Standards.ISIC3, "5233")),
        ((Standards.CAEM2005, "52.45.1"), (Standards.ISIC3, "5233")),
        ((Standards.CAEM2005, "52.45.2"), (Standards.ISIC3, "5233")),
        ((Standards.CAEM2005, "52.45.3"), (Standards.ISIC3, "5233")),
        ((Standards.CAEM2005, "52.45.9"), (Standards.ISIC3, "5233")),
        ((Standards.CAEM2005, "52.46"), (Standards.ISIC3, "5234")),
        ((Standards.CAEM2005, "52.46.0"), (Standards.ISIC3, "5234")),
        ((Standards.CAEM2005, "52.47"), (Standards.ISIC3, "5239")),
        ((Standards.CAEM2005, "52.47.0"), (Standards.ISIC3, "5239")),
        ((Standards.CAEM2005, "52.48"), (Standards.ISIC3, "5239")),
        ((Standards.CAEM2005, "52.48.1"), (Standards.ISIC3, "5239")),
        ((Standards.CAEM2005, "52.48.2"), (Standards.ISIC3, "5239")),
        ((Standards.CAEM2005, "52.48.3"), (Standards.ISIC3, "5239")),
        ((Standards.CAEM2005, "52.48.4"), (Standards.ISIC3, "5239")),
        ((Standards.CAEM2005, "52.48.5"), (Standards.ISIC3, "5239")),
        ((Standards.CAEM2005, "52.48.6"), (Standards.ISIC3, "5239")),
        ((Standards.CAEM2005, "52.48.7"), (Standards.ISIC3, "5239")),
        ((Standards.CAEM2005, "52.48.9"), (Standards.ISIC3, "5239")),
        ((Standards.CAEM2005, "52.5"), (Standards.ISIC3, "524")),
        ((Standards.CAEM2005, "52.50"), (Standards.ISIC3, "5240")),
        ((Standards.CAEM2005, "52.50.0"), (Standards.ISIC3, "5240")),
        ((Standards.CAEM2005, "52.6"), (Standards.ISIC3, "525")),
        ((Standards.CAEM2005, "52.61"), (Standards.ISIC3, "5251")),
        ((Standards.CAEM2005, "52.61.0"), (Standards.ISIC3, "5251")),
        ((Standards.CAEM2005, "52.62"), (Standards.ISIC3, "5252")),
        ((Standards.CAEM2005, "52.62.1"), (Standards.ISIC3, "5252")),
        ((Standards.CAEM2005, "52.62.2"), (Standards.ISIC3, "5252")),
        ((Standards.CAEM2005, "52.63"), (Standards.ISIC3, "5259")),
        ((Standards.CAEM2005, "52.63.1"), (Standards.ISIC3, "5259")),
        ((Standards.CAEM2005, "52.63.9"), (Standards.ISIC3, "5259")),
        ((Standards.CAEM2005, "52.7"), (Standards.ISIC3, "526")),
        ((Standards.CAEM2005, "52.71"), (Standards.ISIC3, "5260")),
        ((Standards.CAEM2005, "52.71.1"), (Standards.ISIC3, "5260")),
        ((Standards.CAEM2005, "52.71.2"), (Standards.ISIC3, "5260")),
        ((Standards.CAEM2005, "52.72"), (Standards.ISIC3, "5260")),
        ((Standards.CAEM2005, "52.72.0"), (Standards.ISIC3, "5260")),
        ((Standards.CAEM2005, "52.73"), (Standards.ISIC3, "5260")),
        ((Standards.CAEM2005, "52.73.1"), (Standards.ISIC3, "5260")),
        ((Standards.CAEM2005, "52.73.2"), (Standards.ISIC3, "5260")),
        ((Standards.CAEM2005, "52.74"), (Standards.ISIC3, "5260")),
        ((Standards.CAEM2005, "52.74.1"), (Standards.ISIC3, "5260")),
        ((Standards.CAEM2005, "52.74.2"), (Standards.ISIC3, "5260")),
        ((Standards.CAEM2005, "52.74.3"), (Standards.ISIC3, "5260")),
        ((Standards.CAEM2005, "52.74.4"), (Standards.ISIC3, "5260")),
        ((Standards.CAEM2005, "52.74.5"), (Standards.ISIC3, "5260")),
        ((Standards.CAEM2005, "52.74.6"), (Standards.ISIC3, "5260")),
        ((Standards.CAEM2005, "52.74.9"), (Standards.ISIC3, "5260")),
        ((Standards.CAEM2005, "H"), (Standards.ISIC3, "H")),
        ((Standards.CAEM2005, "55"), (Standards.ISIC3, "55")),
        ((Standards.CAEM2005, "55.1"), (Standards.ISIC3, "551")),
        ((Standards.CAEM2005, "55.10"), (Standards.ISIC3, "5510")),
        ((Standards.CAEM2005, "55.10.0"), (Standards.ISIC3, "5510")),
        ((Standards.CAEM2005, "55.2"), (Standards.ISIC3, "551")),
        ((Standards.CAEM2005, "55.21"), (Standards.ISIC3, "5510")),
        ((Standards.CAEM2005, "55.21.0"), (Standards.ISIC3, "5510")),
        ((Standards.CAEM2005, "55.22"), (Standards.ISIC3, "5510")),
        ((Standards.CAEM2005, "55.22.0"), (Standards.ISIC3, "5510")),
        ((Standards.CAEM2005, "55.23"), (Standards.ISIC3, "5510")),
        ((Standards.CAEM2005, "55.23.0"), (Standards.ISIC3, "5510")),
        ((Standards.CAEM2005, "55.3"), (Standards.ISIC3, "552")),
        ((Standards.CAEM2005, "55.30"), (Standards.ISIC3, "5520")),
        ((Standards.CAEM2005, "55.30.0"), (Standards.ISIC3, "5520")),
        ((Standards.CAEM2005, "55.4"), (Standards.ISIC3, "552")),
        ((Standards.CAEM2005, "55.40"), (Standards.ISIC3, "5520")),
        ((Standards.CAEM2005, "55.40.0"), (Standards.ISIC3, "5520")),
        ((Standards.CAEM2005, "55.5"), (Standards.ISIC3, "552")),
        ((Standards.CAEM2005, "55.51"), (Standards.ISIC3, "5520")),
        ((Standards.CAEM2005, "55.51.0"), (Standards.ISIC3, "5520")),
        ((Standards.CAEM2005, "55.52"), (Standards.ISIC3, "5520")),
        ((Standards.CAEM2005, "55.52.0"), (Standards.ISIC3, "5520")),
        ((Standards.CAEM2005, "I"), (Standards.ISIC3, "I")),
        ((Standards.CAEM2005, "60"), (Standards.ISIC3, "60")),
        ((Standards.CAEM2005, "60.1"), (Standards.ISIC3, "601")),
        ((Standards.CAEM2005, "60.10"), (Standards.ISIC3, "6010")),
        ((Standards.CAEM2005, "60.10.0"), (Standards.ISIC3, "6010")),
        ((Standards.CAEM2005, "60.2"), (Standards.ISIC3, "602")),
        ((Standards.CAEM2005, "60.21"), (Standards.ISIC3, "6021")),
        ((Standards.CAEM2005, "60.21.1"), (Standards.ISIC3, "6021")),
        ((Standards.CAEM2005, "60.21.2"), (Standards.ISIC3, "6021")),
        ((Standards.CAEM2005, "60.21.3"), (Standards.ISIC3, "6021")),
        ((Standards.CAEM2005, "60.21.4"), (Standards.ISIC3, "6021")),
        ((Standards.CAEM2005, "60.21.9"), (Standards.ISIC3, "6021")),
        ((Standards.CAEM2005, "60.22"), (Standards.ISIC3, "6022")),
        ((Standards.CAEM2005, "60.22.0"), (Standards.ISIC3, "6022")),
        ((Standards.CAEM2005, "60.23"), (Standards.ISIC3, "6022")),
        ((Standards.CAEM2005, "60.23.0"), (Standards.ISIC3, "6022")),
        ((Standards.CAEM2005, "60.24"), (Standards.ISIC3, "6023")),
        ((Standards.CAEM2005, "60.24.0"), (Standards.ISIC3, "6023")),
        ((Standards.CAEM2005, "60.3"), (Standards.ISIC3, "603")),
        ((Standards.CAEM2005, "60.30"), (Standards.ISIC3, "6030")),
        ((Standards.CAEM2005, "60.30.0"), (Standards.ISIC3, "6030")),
        ((Standards.CAEM2005, "61"), (Standards.ISIC3, "61")),
        ((Standards.CAEM2005, "61.1"), (Standards.ISIC3, "611")),
        ((Standards.CAEM2005, "61.10"), (Standards.ISIC3, "6110")),
        ((Standards.CAEM2005, "61.10.0"), (Standards.ISIC3, "6110")),
        ((Standards.CAEM2005, "61.2"), (Standards.ISIC3, "612")),
        ((Standards.CAEM2005, "61.20"), (Standards.ISIC3, "6120")),
        ((Standards.CAEM2005, "61.20.0"), (Standards.ISIC3, "6120")),
        ((Standards.CAEM2005, "62"), (Standards.ISIC3, "62")),
        ((Standards.CAEM2005, "62.1"), (Standards.ISIC3, "621")),
        ((Standards.CAEM2005, "62.10"), (Standards.ISIC3, "6210")),
        ((Standards.CAEM2005, "62.10.0"), (Standards.ISIC3, "6210")),
        ((Standards.CAEM2005, "62.2"), (Standards.ISIC3, "622")),
        ((Standards.CAEM2005, "62.20"), (Standards.ISIC3, "6220")),
        ((Standards.CAEM2005, "62.20.0"), (Standards.ISIC3, "6220")),
        ((Standards.CAEM2005, "62.3"), (Standards.ISIC3, "622")),
        ((Standards.CAEM2005, "62.30"), (Standards.ISIC3, "6220")),
        ((Standards.CAEM2005, "62.30.0"), (Standards.ISIC3, "6220")),
        ((Standards.CAEM2005, "63"), (Standards.ISIC3, "63")),
        ((Standards.CAEM2005, "63.1"), (Standards.ISIC3, "630")),
        ((Standards.CAEM2005, "63.11"), (Standards.ISIC3, "6301")),
        ((Standards.CAEM2005, "63.11.0"), (Standards.ISIC3, "6301")),
        ((Standards.CAEM2005, "63.12"), (Standards.ISIC3, "6302")),
        ((Standards.CAEM2005, "63.12.0"), (Standards.ISIC3, "6302")),
        ((Standards.CAEM2005, "63.2"), (Standards.ISIC3, "630")),
        ((Standards.CAEM2005, "63.21"), (Standards.ISIC3, "6303")),
        ((Standards.CAEM2005, "63.21.1"), (Standards.ISIC3, "6303")),
        ((Standards.CAEM2005, "63.21.2"), (Standards.ISIC3, "6303")),
        ((Standards.CAEM2005, "63.21.3"), (Standards.ISIC3, "6303")),
        ((Standards.CAEM2005, "63.21.4"), (Standards.ISIC3, "6303")),
        ((Standards.CAEM2005, "63.22"), (Standards.ISIC3, "6303")),
        ((Standards.CAEM2005, "63.22.0"), (Standards.ISIC3, "6303")),
        ((Standards.CAEM2005, "63.23"), (Standards.ISIC3, "6303")),
        ((Standards.CAEM2005, "63.23.1"), (Standards.ISIC3, "6303")),
        ((Standards.CAEM2005, "63.23.9"), (Standards.ISIC3, "6303")),
        ((Standards.CAEM2005, "63.3"), (Standards.ISIC3, "630")),
        ((Standards.CAEM2005, "63.30"), (Standards.ISIC3, "6304")),
        ((Standards.CAEM2005, "63.30.0"), (Standards.ISIC3, "6304")),
        ((Standards.CAEM2005, "63.4"), (Standards.ISIC3, "630")),
        ((Standards.CAEM2005, "63.40"), (Standards.ISIC3, "6309")),
        ((Standards.CAEM2005, "63.40.1"), (Standards.ISIC3, "6309")),
        ((Standards.CAEM2005, "63.40.2"), (Standards.ISIC3, "6309")),
        ((Standards.CAEM2005, "63.40.9"), (Standards.ISIC3, "6309")),
        ((Standards.CAEM2005, "64"), (Standards.ISIC3, "64")),
        ((Standards.CAEM2005, "64.1"), (Standards.ISIC3, "641")),
        ((Standards.CAEM2005, "64.11"), (Standards.ISIC3, "6411")),
        ((Standards.CAEM2005, "64.11.0"), (Standards.ISIC3, "6411")),
        ((Standards.CAEM2005, "64.12"), (Standards.ISIC3, "6412")),
        ((Standards.CAEM2005, "64.12.0"), (Standards.ISIC3, "6412")),
        ((Standards.CAEM2005, "64.2"), (Standards.ISIC3, "642")),
        ((Standards.CAEM2005, "64.20"), (Standards.ISIC3, "6420")),
        ((Standards.CAEM2005, "64.20.1"), (Standards.ISIC3, "6420")),
        ((Standards.CAEM2005, "64.20.2"), (Standards.ISIC3, "6420")),
        ((Standards.CAEM2005, "64.20.3"), (Standards.ISIC3, "6420")),
        ((Standards.CAEM2005, "64.20.4"), (Standards.ISIC3, "6420")),
        ((Standards.CAEM2005, "64.20.5"), (Standards.ISIC3, "6420")),
        ((Standards.CAEM2005, "J"), (Standards.ISIC3, "J")),
        ((Standards.CAEM2005, "65"), (Standards.ISIC3, "65")),
        ((Standards.CAEM2005, "65.1"), (Standards.ISIC3, "651")),
        ((Standards.CAEM2005, "65.11"), (Standards.ISIC3, "6511")),
        ((Standards.CAEM2005, "65.11.0"), (Standards.ISIC3, "6511")),
        ((Standards.CAEM2005, "65.12"), (Standards.ISIC3, "6519")),
        ((Standards.CAEM2005, "65.12.1"), (Standards.ISIC3, "6519")),
        ((Standards.CAEM2005, "65.12.2"), (Standards.ISIC3, "6519")),
        ((Standards.CAEM2005, "65.12.9"), (Standards.ISIC3, "6519")),
        ((Standards.CAEM2005, "65.2"), (Standards.ISIC3, "659")),
        ((Standards.CAEM2005, "65.21"), (Standards.ISIC3, "6591")),
        ((Standards.CAEM2005, "65.21.0"), (Standards.ISIC3, "6591")),
        ((Standards.CAEM2005, "65.22"), (Standards.ISIC3, "6592")),
        ((Standards.CAEM2005, "65.22.0"), (Standards.ISIC3, "6592")),
        ((Standards.CAEM2005, "65.23"), (Standards.ISIC3, "6599")),
        ((Standards.CAEM2005, "65.23.0"), (Standards.ISIC3, "6599")),
        ((Standards.CAEM2005, "66"), (Standards.ISIC3, "66")),
        ((Standards.CAEM2005, "66.0"), (Standards.ISIC3, "660")),
        ((Standards.CAEM2005, "66.01"), (Standards.ISIC3, "6601")),
        ((Standards.CAEM2005, "66.01.1"), (Standards.ISIC3, "6601")),
        ((Standards.CAEM2005, "66.01.2"), (Standards.ISIC3, "6601")),
        ((Standards.CAEM2005, "66.02"), (Standards.ISIC3, "6602")),
        ((Standards.CAEM2005, "66.02.1"), (Standards.ISIC3, "6602")),
        ((Standards.CAEM2005, "66.02.2"), (Standards.ISIC3, "6602")),
        ((Standards.CAEM2005, "66.03"), (Standards.ISIC3, "6603")),
        ((Standards.CAEM2005, "66.03.1"), (Standards.ISIC3, "6603")),
        ((Standards.CAEM2005, "66.03.2"), (Standards.ISIC3, "6603")),
        ((Standards.CAEM2005, "67"), (Standards.ISIC3, "67")),
        ((Standards.CAEM2005, "67.1"), (Standards.ISIC3, "671")),
        ((Standards.CAEM2005, "67.11"), (Standards.ISIC3, "6711")),
        ((Standards.CAEM2005, "67.11.0"), (Standards.ISIC3, "6711")),
        ((Standards.CAEM2005, "67.12"), (Standards.ISIC3, "6712")),
        ((Standards.CAEM2005, "67.12.0"), (Standards.ISIC3, "6712")),
        ((Standards.CAEM2005, "67.13"), (Standards.ISIC3, "6719")),
        ((Standards.CAEM2005, "67.13.0"), (Standards.ISIC3, "6719")),
        ((Standards.CAEM2005, "67.2"), (Standards.ISIC3, "672")),
        ((Standards.CAEM2005, "67.20"), (Standards.ISIC3, "6720")),
        ((Standards.CAEM2005, "67.20.0"), (Standards.ISIC3, "6720")),
        ((Standards.CAEM2005, "K"), (Standards.ISIC3, "K")),
        ((Standards.CAEM2005, "70"), (Standards.ISIC3, "70")),
        ((Standards.CAEM2005, "70.1"), (Standards.ISIC3, "701")),
        ((Standards.CAEM2005, "70.11"), (Standards.ISIC3, "7010")),
        ((Standards.CAEM2005, "70.11.0"), (Standards.ISIC3, "7010")),
        ((Standards.CAEM2005, "70.12"), (Standards.ISIC3, "7010")),
        ((Standards.CAEM2005, "70.12.0"), (Standards.ISIC3, "7010")),
        ((Standards.CAEM2005, "70.2"), (Standards.ISIC3, "701")),
        ((Standards.CAEM2005, "70.20"), (Standards.ISIC3, "7010")),
        ((Standards.CAEM2005, "70.20.0"), (Standards.ISIC3, "7010")),
        ((Standards.CAEM2005, "70.3"), (Standards.ISIC3, "702")),
        ((Standards.CAEM2005, "70.31"), (Standards.ISIC3, "7020")),
        ((Standards.CAEM2005, "70.31.1"), (Standards.ISIC3, "7020")),
        ((Standards.CAEM2005, "70.31.2"), (Standards.ISIC3, "7020")),
        ((Standards.CAEM2005, "70.32"), (Standards.ISIC3, "7020")),
        ((Standards.CAEM2005, "70.32.0"), (Standards.ISIC3, "7020")),
        ((Standards.CAEM2005, "71"), (Standards.ISIC3, "71")),
        ((Standards.CAEM2005, "71.1"), (Standards.ISIC3, "711")),
        ((Standards.CAEM2005, "71.10"), (Standards.ISIC3, "7111")),
        ((Standards.CAEM2005, "71.10.0"), (Standards.ISIC3, "7111")),
        ((Standards.CAEM2005, "71.2"), (Standards.ISIC3, "711")),
        ((Standards.CAEM2005, "71.21"), (Standards.ISIC3, "7111")),
        ((Standards.CAEM2005, "71.21.0"), (Standards.ISIC3, "7111")),
        ((Standards.CAEM2005, "71.22"), (Standards.ISIC3, "7112")),
        ((Standards.CAEM2005, "71.22.0"), (Standards.ISIC3, "7112")),
        ((Standards.CAEM2005, "71.23"), (Standards.ISIC3, "7113")),
        ((Standards.CAEM2005, "71.23.0"), (Standards.ISIC3, "7113")),
        ((Standards.CAEM2005, "71.3"), (Standards.ISIC3, "712")),
        ((Standards.CAEM2005, "71.31"), (Standards.ISIC3, "7121")),
        ((Standards.CAEM2005, "71.31.0"), (Standards.ISIC3, "7121")),
        ((Standards.CAEM2005, "71.32"), (Standards.ISIC3, "7122")),
        ((Standards.CAEM2005, "71.32.0"), (Standards.ISIC3, "7122")),
        ((Standards.CAEM2005, "71.33"), (Standards.ISIC3, "7123")),
        ((Standards.CAEM2005, "71.33.0"), (Standards.ISIC3, "7123")),
        ((Standards.CAEM2005, "71.34"), (Standards.ISIC3, "7129")),
        ((Standards.CAEM2005, "71.34.0"), (Standards.ISIC3, "7129")),
        ((Standards.CAEM2005, "71.4"), (Standards.ISIC3, "713")),
        ((Standards.CAEM2005, "71.40"), (Standards.ISIC3, "7130")),
        ((Standards.CAEM2005, "71.40.0"), (Standards.ISIC3, "7130")),
        ((Standards.CAEM2005, "72"), (Standards.ISIC3, "72")),
        ((Standards.CAEM2005, "72.1"), (Standards.ISIC3, "721")),
        ((Standards.CAEM2005, "72.10"), (Standards.ISIC3, "7210")),
        ((Standards.CAEM2005, "72.10.0"), (Standards.ISIC3, "7210")),
        ((Standards.CAEM2005, "72.2"), (Standards.ISIC3, "722")),
        ((Standards.CAEM2005, "72.21"), (Standards.ISIC3, "7220")),
        ((Standards.CAEM2005, "72.21.0"), (Standards.ISIC3, "7220")),
        ((Standards.CAEM2005, "72.22"), (Standards.ISIC3, "7220")),
        ((Standards.CAEM2005, "72.22.0"), (Standards.ISIC3, "7220")),
        ((Standards.CAEM2005, "72.3"), (Standards.ISIC3, "723")),
        ((Standards.CAEM2005, "72.30"), (Standards.ISIC3, "7230")),
        ((Standards.CAEM2005, "72.30.0"), (Standards.ISIC3, "7230")),
        ((Standards.CAEM2005, "72.4"), (Standards.ISIC3, "724")),
        ((Standards.CAEM2005, "72.40"), (Standards.ISIC3, "7240")),
        ((Standards.CAEM2005, "72.40.0"), (Standards.ISIC3, "7240")),
        ((Standards.CAEM2005, "72.5"), (Standards.ISIC3, "725")),
        ((Standards.CAEM2005, "72.50"), (Standards.ISIC3, "7250")),
        ((Standards.CAEM2005, "72.50.0"), (Standards.ISIC3, "7250")),
        ((Standards.CAEM2005, "72.6"), (Standards.ISIC3, "729")),
        ((Standards.CAEM2005, "72.60"), (Standards.ISIC3, "7290")),
        ((Standards.CAEM2005, "72.60.0"), (Standards.ISIC3, "7290")),
        ((Standards.CAEM2005, "73"), (Standards.ISIC3, "73")),
        ((Standards.CAEM2005, "73.1"), (Standards.ISIC3, "731")),
        ((Standards.CAEM2005, "73.10"), (Standards.ISIC3, "7310")),
        ((Standards.CAEM2005, "73.10.0"), (Standards.ISIC3, "7310")),
        ((Standards.CAEM2005, "73.2"), (Standards.ISIC3, "732")),
        ((Standards.CAEM2005, "73.20"), (Standards.ISIC3, "7320")),
        ((Standards.CAEM2005, "73.20.0"), (Standards.ISIC3, "7320")),
        ((Standards.CAEM2005, "74"), (Standards.ISIC3, "74")),
        ((Standards.CAEM2005, "74.1"), (Standards.ISIC3, "741")),
        ((Standards.CAEM2005, "74.11"), (Standards.ISIC3, "7411")),
        ((Standards.CAEM2005, "74.11.1"), (Standards.ISIC3, "7411")),
        ((Standards.CAEM2005, "74.11.2"), (Standards.ISIC3, "7411")),
        ((Standards.CAEM2005, "74.12"), (Standards.ISIC3, "7412")),
        ((Standards.CAEM2005, "74.12.0"), (Standards.ISIC3, "7412")),
        ((Standards.CAEM2005, "74.13"), (Standards.ISIC3, "7413")),
        ((Standards.CAEM2005, "74.13.0"), (Standards.ISIC3, "7413")),
        ((Standards.CAEM2005, "74.14"), (Standards.ISIC3, "7414")),
        ((Standards.CAEM2005, "74.14.0"), (Standards.ISIC3, "7414")),
        ((Standards.CAEM2005, "74.15"), (Standards.ISIC3, "7414")),
        ((Standards.CAEM2005, "74.15.0"), (Standards.ISIC3, "7414")),
        ((Standards.CAEM2005, "74.2"), (Standards.ISIC3, "742")),
        ((Standards.CAEM2005, "74.20"), (Standards.ISIC3, "7421")),
        ((Standards.CAEM2005, "74.20.1"), (Standards.ISIC3, "7421")),
        ((Standards.CAEM2005, "74.20.2"), (Standards.ISIC3, "7421")),
        ((Standards.CAEM2005, "74.20.3"), (Standards.ISIC3, "7421")),
        ((Standards.CAEM2005, "74.20.4"), (Standards.ISIC3, "7421")),
        ((Standards.CAEM2005, "74.20.5"), (Standards.ISIC3, "7421")),
        ((Standards.CAEM2005, "74.3"), (Standards.ISIC3, "742")),
        ((Standards.CAEM2005, "74.30"), (Standards.ISIC3, "7422")),
        ((Standards.CAEM2005, "74.30.1"), (Standards.ISIC3, "7422")),
        ((Standards.CAEM2005, "74.30.2"), (Standards.ISIC3, "7422")),
        ((Standards.CAEM2005, "74.30.9"), (Standards.ISIC3, "7422")),
        ((Standards.CAEM2005, "74.4"), (Standards.ISIC3, "743")),
        ((Standards.CAEM2005, "74.40"), (Standards.ISIC3, "7430")),
        ((Standards.CAEM2005, "74.40.0"), (Standards.ISIC3, "7430")),
        ((Standards.CAEM2005, "74.5"), (Standards.ISIC3, "749")),
        ((Standards.CAEM2005, "74.50"), (Standards.ISIC3, "7491")),
        ((Standards.CAEM2005, "74.50.0"), (Standards.ISIC3, "7491")),
        ((Standards.CAEM2005, "74.6"), (Standards.ISIC3, "749")),
        ((Standards.CAEM2005, "74.60"), (Standards.ISIC3, "7492")),
        ((Standards.CAEM2005, "74.60.0"), (Standards.ISIC3, "7492")),
        ((Standards.CAEM2005, "74.7"), (Standards.ISIC3, "749")),
        ((Standards.CAEM2005, "74.70"), (Standards.ISIC3, "7493")),
        ((Standards.CAEM2005, "74.70.0"), (Standards.ISIC3, "7493")),
        ((Standards.CAEM2005, "74.8"), (Standards.ISIC3, "749")),
        ((Standards.CAEM2005, "74.81"), (Standards.ISIC3, "7494")),
        ((Standards.CAEM2005, "74.81.0"), (Standards.ISIC3, "7494")),
        ((Standards.CAEM2005, "74.82"), (Standards.ISIC3, "7495")),
        ((Standards.CAEM2005, "74.82.0"), (Standards.ISIC3, "7495")),
        ((Standards.CAEM2005, "74.85"), (Standards.ISIC3, "7499")),
        ((Standards.CAEM2005, "74.85.0"), (Standards.ISIC3, "7499")),
        ((Standards.CAEM2005, "74.86"), (Standards.ISIC3, "7499")),
        ((Standards.CAEM2005, "74.86.0"), (Standards.ISIC3, "7499")),
        ((Standards.CAEM2005, "74.87"), (Standards.ISIC3, "7499")),
        ((Standards.CAEM2005, "74.87.0"), (Standards.ISIC3, "7499")),
        ((Standards.CAEM2005, "L"), (Standards.ISIC3, "L")),
        ((Standards.CAEM2005, "75"), (Standards.ISIC3, "75")),
        ((Standards.CAEM2005, "75.1"), (Standards.ISIC3, "751")),
        ((Standards.CAEM2005, "75.11"), (Standards.ISIC3, "7511")),
        ((Standards.CAEM2005, "75.11.1"), (Standards.ISIC3, "7511")),
        ((Standards.CAEM2005, "75.11.2"), (Standards.ISIC3, "7511")),
        ((Standards.CAEM2005, "75.11.3"), (Standards.ISIC3, "7511")),
        ((Standards.CAEM2005, "75.11.4"), (Standards.ISIC3, "7511")),
        ((Standards.CAEM2005, "75.11.5"), (Standards.ISIC3, "7511")),
        ((Standards.CAEM2005, "75.11.6"), (Standards.ISIC3, "7511")),
        ((Standards.CAEM2005, "75.11.7"), (Standards.ISIC3, "7511")),
        ((Standards.CAEM2005, "75.12"), (Standards.ISIC3, "7512")),
        ((Standards.CAEM2005, "75.12.0"), (Standards.ISIC3, "7512")),
        ((Standards.CAEM2005, "75.13"), (Standards.ISIC3, "7513")),
        ((Standards.CAEM2005, "75.13.0"), (Standards.ISIC3, "7513")),
        ((Standards.CAEM2005, "75.14"), (Standards.ISIC3, "7514")),
        ((Standards.CAEM2005, "75.14.0"), (Standards.ISIC3, "7514")),
        ((Standards.CAEM2005, "75.2"), (Standards.ISIC3, "752")),
        ((Standards.CAEM2005, "75.21"), (Standards.ISIC3, "7521")),
        ((Standards.CAEM2005, "75.21.0"), (Standards.ISIC3, "7521")),
        ((Standards.CAEM2005, "75.22"), (Standards.ISIC3, "7522")),
        ((Standards.CAEM2005, "75.22.0"), (Standards.ISIC3, "7522")),
        ((Standards.CAEM2005, "75.23"), (Standards.ISIC3, "7523")),
        ((Standards.CAEM2005, "75.23.0"), (Standards.ISIC3, "7523")),
        ((Standards.CAEM2005, "75.24"), (Standards.ISIC3, "7523")),
        ((Standards.CAEM2005, "75.24.0"), (Standards.ISIC3, "7523")),
        ((Standards.CAEM2005, "75.25"), (Standards.ISIC3, "7523")),
        ((Standards.CAEM2005, "75.25.0"), (Standards.ISIC3, "7523")),
        ((Standards.CAEM2005, "75.3"), (Standards.ISIC3, "753")),
        ((Standards.CAEM2005, "75.30"), (Standards.ISIC3, "7530")),
        ((Standards.CAEM2005, "75.30.0"), (Standards.ISIC3, "7530")),
        ((Standards.CAEM2005, "M"), (Standards.ISIC3, "M")),
        ((Standards.CAEM2005, "80"), (Standards.ISIC3, "80")),
        ((Standards.CAEM2005, "80.1"), (Standards.ISIC3, "801")),
        ((Standards.CAEM2005, "80.10"), (Standards.ISIC3, "8010")),
        ((Standards.CAEM2005, "80.10.1"), (Standards.ISIC3, "8010")),
        ((Standards.CAEM2005, "80.10.2"), (Standards.ISIC3, "8010")),
        ((Standards.CAEM2005, "80.10.3"), (Standards.ISIC3, "8010")),
        ((Standards.CAEM2005, "80.2"), (Standards.ISIC3, "802")),
        ((Standards.CAEM2005, "80.21"), (Standards.ISIC3, "8021")),
        ((Standards.CAEM2005, "80.21.1"), (Standards.ISIC3, "8021")),
        ((Standards.CAEM2005, "80.21.2"), (Standards.ISIC3, "8021")),
        ((Standards.CAEM2005, "80.22"), (Standards.ISIC3, "8022")),
        ((Standards.CAEM2005, "80.22.1"), (Standards.ISIC3, "8022")),
        ((Standards.CAEM2005, "80.22.2"), (Standards.ISIC3, "8030")),
        ((Standards.CAEM2005, "80.3"), (Standards.ISIC3, "803")),
        ((Standards.CAEM2005, "80.30"), (Standards.ISIC3, "8030")),
        ((Standards.CAEM2005, "80.30.1"), (Standards.ISIC3, "8030")),
        ((Standards.CAEM2005, "80.30.2"), (Standards.ISIC3, "8030")),
        ((Standards.CAEM2005, "80.4"), (Standards.ISIC3, "809")),
        ((Standards.CAEM2005, "80.41"), (Standards.ISIC3, "8090")),
        ((Standards.CAEM2005, "80.41.0"), (Standards.ISIC3, "8090")),
        ((Standards.CAEM2005, "80.42"), (Standards.ISIC3, "8090")),
        ((Standards.CAEM2005, "80.42.1"), (Standards.ISIC3, "8090")),
        ((Standards.CAEM2005, "80.42.2"), (Standards.ISIC3, "8090")),
        ((Standards.CAEM2005, "80.42.9"), (Standards.ISIC3, "8090")),
        ((Standards.CAEM2005, "N"), (Standards.ISIC3, "N")),
        ((Standards.CAEM2005, "85"), (Standards.ISIC3, "85")),
        ((Standards.CAEM2005, "85.1"), (Standards.ISIC3, "851")),
        ((Standards.CAEM2005, "85.11"), (Standards.ISIC3, "8511")),
        ((Standards.CAEM2005, "85.11.1"), (Standards.ISIC3, "8511")),
        ((Standards.CAEM2005, "85.11.2"), (Standards.ISIC3, "8511")),
        ((Standards.CAEM2005, "85.11.3"), (Standards.ISIC3, "8511")),
        ((Standards.CAEM2005, "85.11.4"), (Standards.ISIC3, "8511")),
        ((Standards.CAEM2005, "85.11.9"), (Standards.ISIC3, "8511")),
        ((Standards.CAEM2005, "85.12"), (Standards.ISIC3, "8512")),
        ((Standards.CAEM2005, "85.12.0"), (Standards.ISIC3, "8512")),
        ((Standards.CAEM2005, "85.13"), (Standards.ISIC3, "8512")),
        ((Standards.CAEM2005, "85.13.0"), (Standards.ISIC3, "8512")),
        ((Standards.CAEM2005, "85.14"), (Standards.ISIC3, "8519")),
        ((Standards.CAEM2005, "85.14.0"), (Standards.ISIC3, "8519")),
        ((Standards.CAEM2005, "85.2"), (Standards.ISIC3, "852")),
        ((Standards.CAEM2005, "85.20"), (Standards.ISIC3, "8520")),
        ((Standards.CAEM2005, "85.20.0"), (Standards.ISIC3, "8520")),
        ((Standards.CAEM2005, "85.3"), (Standards.ISIC3, "853")),
        ((Standards.CAEM2005, "85.31"), (Standards.ISIC3, "8531")),
        ((Standards.CAEM2005, "85.31.0"), (Standards.ISIC3, "8531")),
        ((Standards.CAEM2005, "85.32"), (Standards.ISIC3, "8532")),
        ((Standards.CAEM2005, "85.32.0"), (Standards.ISIC3, "8532")),
        ((Standards.CAEM2005, "O"), (Standards.ISIC3, "O")),
        ((Standards.CAEM2005, "90"), (Standards.ISIC3, "90")),
        ((Standards.CAEM2005, "90.0"), (Standards.ISIC3, "900")),
        ((Standards.CAEM2005, "90.01"), (Standards.ISIC3, "9000")),
        ((Standards.CAEM2005, "90.01.0"), (Standards.ISIC3, "9000")),
        ((Standards.CAEM2005, "90.02"), (Standards.ISIC3, "9000")),
        ((Standards.CAEM2005, "90.02.0"), (Standards.ISIC3, "9000")),
        ((Standards.CAEM2005, "90.03"), (Standards.ISIC3, "9000")),
        ((Standards.CAEM2005, "90.03.0"), (Standards.ISIC3, "9000")),
        ((Standards.CAEM2005, "91"), (Standards.ISIC3, "91")),
        ((Standards.CAEM2005, "91.1"), (Standards.ISIC3, "911")),
        ((Standards.CAEM2005, "91.11"), (Standards.ISIC3, "9111")),
        ((Standards.CAEM2005, "91.11.0"), (Standards.ISIC3, "9111")),
        ((Standards.CAEM2005, "91.12"), (Standards.ISIC3, "9112")),
        ((Standards.CAEM2005, "91.12.0"), (Standards.ISIC3, "9112")),
        ((Standards.CAEM2005, "91.2"), (Standards.ISIC3, "912")),
        ((Standards.CAEM2005, "91.20"), (Standards.ISIC3, "9120")),
        ((Standards.CAEM2005, "91.20.0"), (Standards.ISIC3, "9120")),
        ((Standards.CAEM2005, "91.3"), (Standards.ISIC3, "919")),
        ((Standards.CAEM2005, "91.31"), (Standards.ISIC3, "9191")),
        ((Standards.CAEM2005, "91.31.0"), (Standards.ISIC3, "9191")),
        ((Standards.CAEM2005, "91.32"), (Standards.ISIC3, "9192")),
        ((Standards.CAEM2005, "91.32.0"), (Standards.ISIC3, "9192")),
        ((Standards.CAEM2005, "91.33"), (Standards.ISIC3, "9199")),
        ((Standards.CAEM2005, "91.33.0"), (Standards.ISIC3, "9199")),
        ((Standards.CAEM2005, "92"), (Standards.ISIC3, "92")),
        ((Standards.CAEM2005, "92.1"), (Standards.ISIC3, "921")),
        ((Standards.CAEM2005, "92.11"), (Standards.ISIC3, "9211")),
        ((Standards.CAEM2005, "92.11.0"), (Standards.ISIC3, "9211")),
        ((Standards.CAEM2005, "92.12"), (Standards.ISIC3, "9211")),
        ((Standards.CAEM2005, "92.12.0"), (Standards.ISIC3, "9211")),
        ((Standards.CAEM2005, "92.13"), (Standards.ISIC3, "9212")),
        ((Standards.CAEM2005, "92.13.0"), (Standards.ISIC3, "9212")),
        ((Standards.CAEM2005, "92.2"), (Standards.ISIC3, "921")),
        ((Standards.CAEM2005, "92.20"), (Standards.ISIC3, "9213")),
        ((Standards.CAEM2005, "92.20.0"), (Standards.ISIC3, "9213")),
        ((Standards.CAEM2005, "92.3"), (Standards.ISIC3, "921")),
        ((Standards.CAEM2005, "92.31"), (Standards.ISIC3, "9214")),
        ((Standards.CAEM2005, "92.31.1"), (Standards.ISIC3, "9214")),
        ((Standards.CAEM2005, "92.31.2"), (Standards.ISIC3, "9214")),
        ((Standards.CAEM2005, "92.31.3"), (Standards.ISIC3, "9214")),
        ((Standards.CAEM2005, "92.32"), (Standards.ISIC3, "9214")),
        ((Standards.CAEM2005, "92.32.0"), (Standards.ISIC3, "9214")),
        ((Standards.CAEM2005, "92.33"), (Standards.ISIC3, "9219")),
        ((Standards.CAEM2005, "92.33.0"), (Standards.ISIC3, "9219")),
        ((Standards.CAEM2005, "92.34"), (Standards.ISIC3, "9219")),
        ((Standards.CAEM2005, "92.34.1"), (Standards.ISIC3, "9219")),
        ((Standards.CAEM2005, "92.34.2"), (Standards.ISIC3, "9219")),
        ((Standards.CAEM2005, "92.34.3"), (Standards.ISIC3, "9219")),
        ((Standards.CAEM2005, "92.4"), (Standards.ISIC3, "922")),
        ((Standards.CAEM2005, "92.40"), (Standards.ISIC3, "9220")),
        ((Standards.CAEM2005, "92.40.0"), (Standards.ISIC3, "9220")),
        ((Standards.CAEM2005, "92.5"), (Standards.ISIC3, "923")),
        ((Standards.CAEM2005, "92.51"), (Standards.ISIC3, "9231")),
        ((Standards.CAEM2005, "92.51.1"), (Standards.ISIC3, "9231")),
        ((Standards.CAEM2005, "92.51.2"), (Standards.ISIC3, "9231")),
        ((Standards.CAEM2005, "92.51.3"), (Standards.ISIC3, "9231")),
        ((Standards.CAEM2005, "92.51.4"), (Standards.ISIC3, "9231")),
        ((Standards.CAEM2005, "92.51.5"), (Standards.ISIC3, "9231")),
        ((Standards.CAEM2005, "92.52"), (Standards.ISIC3, "9232")),
        ((Standards.CAEM2005, "92.52.1"), (Standards.ISIC3, "9232")),
        ((Standards.CAEM2005, "92.52.2"), (Standards.ISIC3, "9232")),
        ((Standards.CAEM2005, "92.52.3"), (Standards.ISIC3, "9232")),
        ((Standards.CAEM2005, "92.53"), (Standards.ISIC3, "9233")),
        ((Standards.CAEM2005, "92.53.1"), (Standards.ISIC3, "9233")),
        ((Standards.CAEM2005, "92.53.2"), (Standards.ISIC3, "9233")),
        ((Standards.CAEM2005, "92.6"), (Standards.ISIC3, "924")),
        ((Standards.CAEM2005, "92.61"), (Standards.ISIC3, "9241")),
        ((Standards.CAEM2005, "92.61.0"), (Standards.ISIC3, "9241")),
        ((Standards.CAEM2005, "92.62"), (Standards.ISIC3, "9241")),
        ((Standards.CAEM2005, "92.62.0"), (Standards.ISIC3, "9241")),
        ((Standards.CAEM2005, "92.7"), (Standards.ISIC3, "924")),
        ((Standards.CAEM2005, "92.71"), (Standards.ISIC3, "9249")),
        ((Standards.CAEM2005, "92.71.0"), (Standards.ISIC3, "9249")),
        ((Standards.CAEM2005, "92.72"), (Standards.ISIC3, "9249")),
        ((Standards.CAEM2005, "92.72.0"), (Standards.ISIC3, "9249")),
        ((Standards.CAEM2005, "93"), (Standards.ISIC3, "93")),
        ((Standards.CAEM2005, "93.0"), (Standards.ISIC3, "930")),
        ((Standards.CAEM2005, "93.01"), (Standards.ISIC3, "9301")),
        ((Standards.CAEM2005, "93.01.1"), (Standards.ISIC3, "9301")),
        ((Standards.CAEM2005, "93.01.2"), (Standards.ISIC3, "9301")),
        ((Standards.CAEM2005, "93.02"), (Standards.ISIC3, "9302")),
        ((Standards.CAEM2005, "93.02.0"), (Standards.ISIC3, "9302")),
        ((Standards.CAEM2005, "93.03"), (Standards.ISIC3, "9303")),
        ((Standards.CAEM2005, "93.03.0"), (Standards.ISIC3, "9303")),
        ((Standards.CAEM2005, "93.04"), (Standards.ISIC3, "9309")),
        ((Standards.CAEM2005, "93.04.0"), (Standards.ISIC3, "9309")),
        ((Standards.CAEM2005, "93.05"), (Standards.ISIC3, "9309")),
        ((Standards.CAEM2005, "93.05.0"), (Standards.ISIC3, "9309")),
        ((Standards.CAEM2005, "P"), (Standards.ISIC3, "P")),
        ((Standards.CAEM2005, "95"), (Standards.ISIC3, "95")),
        ((Standards.CAEM2005, "95.0"), (Standards.ISIC3, "950")),
        ((Standards.CAEM2005, "95.00"), (Standards.ISIC3, "9500")),
        ((Standards.CAEM2005, "95.00.0"), (Standards.ISIC3, "9500")),
        ((Standards.CAEM2005, "Q"), (Standards.ISIC3, "Q")),
        ((Standards.CAEM2005, "99"), (Standards.ISIC3, "99")),
        ((Standards.CAEM2005, "99.0"), (Standards.ISIC3, "990")),
        ((Standards.CAEM2005, "99.00"), (Standards.ISIC3, "9900")),
        ((Standards.CAEM2005, "99.00.0"), (Standards.ISIC3, "9900")),
    ],
)
