"""`Concordance between CAEM2005 and CAEM2009 <https://date.gov.md/ckan/ro/dataset/5188-clasificatorul-activitatilor-din-economia-moldovei-caem>`_."""

from ...types import Concordance, Standards
from ..caem2009 import CAEM2009
from . import CAEM2005

CAEM2005_to_CAEM2009 = Concordance(
    src=CAEM2005,
    dst=CAEM2009,
    concordances=[
        ((Standards.CAEM2005, "A"), (Standards.CAEM2009, "A")),
        ((Standards.CAEM2005, "A"), (Standards.CAEM2009, "C")),
        ((Standards.CAEM2005, "A"), (Standards.CAEM2009, "N")),
        ((Standards.CAEM2005, "A"), (Standards.CAEM2009, "S")),
        ((Standards.CAEM2005, "01"), (Standards.CAEM2009, "01")),
        ((Standards.CAEM2005, "01"), (Standards.CAEM2009, "02")),
        ((Standards.CAEM2005, "01"), (Standards.CAEM2009, "03")),
        ((Standards.CAEM2005, "01"), (Standards.CAEM2009, "10")),
        ((Standards.CAEM2005, "01"), (Standards.CAEM2009, "11")),
        ((Standards.CAEM2005, "01"), (Standards.CAEM2009, "81")),
        ((Standards.CAEM2005, "01"), (Standards.CAEM2009, "94")),
        ((Standards.CAEM2005, "01.1"), (Standards.CAEM2009, "01.1")),
        ((Standards.CAEM2005, "01.1"), (Standards.CAEM2009, "01.2")),
        ((Standards.CAEM2005, "01.1"), (Standards.CAEM2009, "01.3")),
        ((Standards.CAEM2005, "01.1"), (Standards.CAEM2009, "10.4")),
        ((Standards.CAEM2005, "01.1"), (Standards.CAEM2009, "01.6")),
        ((Standards.CAEM2005, "01.1"), (Standards.CAEM2009, "02.1")),
        ((Standards.CAEM2005, "01.1"), (Standards.CAEM2009, "02.3")),
        ((Standards.CAEM2005, "01.1"), (Standards.CAEM2009, "11.0")),
        ((Standards.CAEM2005, "01.11"), (Standards.CAEM2009, "01.11")),
        ((Standards.CAEM2005, "01.11"), (Standards.CAEM2009, "01.12")),
        ((Standards.CAEM2005, "01.11"), (Standards.CAEM2009, "01.13")),
        ((Standards.CAEM2005, "01.11"), (Standards.CAEM2009, "01.14")),
        ((Standards.CAEM2005, "01.11"), (Standards.CAEM2009, "01.15")),
        ((Standards.CAEM2005, "01.11"), (Standards.CAEM2009, "01.16")),
        ((Standards.CAEM2005, "01.11"), (Standards.CAEM2009, "01.19")),
        ((Standards.CAEM2005, "01.11"), (Standards.CAEM2009, "01.26")),
        ((Standards.CAEM2005, "01.11"), (Standards.CAEM2009, "01.28")),
        ((Standards.CAEM2005, "01.11"), (Standards.CAEM2009, "01.29")),
        ((Standards.CAEM2005, "01.11"), (Standards.CAEM2009, "01.63")),
        ((Standards.CAEM2005, "01.11"), (Standards.CAEM2009, "01.64")),
        ((Standards.CAEM2005, "01.11.1"), (Standards.CAEM2009, "01.11")),
        ((Standards.CAEM2005, "01.11.1"), (Standards.CAEM2009, "01.12")),
        ((Standards.CAEM2005, "01.11.1"), (Standards.CAEM2009, "01.19")),
        ((Standards.CAEM2005, "01.11.1"), (Standards.CAEM2009, "01.63")),
        ((Standards.CAEM2005, "01.11.1"), (Standards.CAEM2009, "01.64")),
        ((Standards.CAEM2005, "01.11.2"), (Standards.CAEM2009, "01.13")),
        ((Standards.CAEM2005, "01.11.2"), (Standards.CAEM2009, "01.63")),
        ((Standards.CAEM2005, "01.11.2"), (Standards.CAEM2009, "01.64")),
        ((Standards.CAEM2005, "01.11.3"), (Standards.CAEM2009, "01.13")),
        ((Standards.CAEM2005, "01.11.3"), (Standards.CAEM2009, "01.63")),
        ((Standards.CAEM2005, "01.11.3"), (Standards.CAEM2009, "01.64")),
        ((Standards.CAEM2005, "01.11.4"), (Standards.CAEM2009, "01.11")),
        ((Standards.CAEM2005, "01.11.4"), (Standards.CAEM2009, "01.26")),
        ((Standards.CAEM2005, "01.11.4"), (Standards.CAEM2009, "01.63")),
        ((Standards.CAEM2005, "01.11.4"), (Standards.CAEM2009, "01.64")),
        ((Standards.CAEM2005, "01.11.5"), (Standards.CAEM2009, "01.19")),
        ((Standards.CAEM2005, "01.11.5"), (Standards.CAEM2009, "01.63")),
        ((Standards.CAEM2005, "01.11.5"), (Standards.CAEM2009, "01.64")),
        ((Standards.CAEM2005, "01.11.8"), (Standards.CAEM2009, "01.15")),
        ((Standards.CAEM2005, "01.11.8"), (Standards.CAEM2009, "01.63")),
        ((Standards.CAEM2005, "01.11.8"), (Standards.CAEM2009, "01.64")),
        ((Standards.CAEM2005, "01.11.9"), (Standards.CAEM2009, "01.13")),
        ((Standards.CAEM2005, "01.11.9"), (Standards.CAEM2009, "01.14")),
        ((Standards.CAEM2005, "01.11.9"), (Standards.CAEM2009, "01.16")),
        ((Standards.CAEM2005, "01.11.9"), (Standards.CAEM2009, "01.19")),
        ((Standards.CAEM2005, "01.11.9"), (Standards.CAEM2009, "01.28")),
        ((Standards.CAEM2005, "01.11.9"), (Standards.CAEM2009, "01.29")),
        ((Standards.CAEM2005, "01.11.9"), (Standards.CAEM2009, "01.63")),
        ((Standards.CAEM2005, "01.11.9"), (Standards.CAEM2009, "01.64")),
        ((Standards.CAEM2005, "01.12"), (Standards.CAEM2009, "01.11")),
        ((Standards.CAEM2005, "01.12"), (Standards.CAEM2009, "01.13")),
        ((Standards.CAEM2005, "01.12"), (Standards.CAEM2009, "01.19")),
        ((Standards.CAEM2005, "01.12"), (Standards.CAEM2009, "01.25")),
        ((Standards.CAEM2005, "01.12"), (Standards.CAEM2009, "01.28")),
        ((Standards.CAEM2005, "01.12"), (Standards.CAEM2009, "01.30")),
        ((Standards.CAEM2005, "01.12"), (Standards.CAEM2009, "01.64")),
        ((Standards.CAEM2005, "01.12"), (Standards.CAEM2009, "02.10")),
        ((Standards.CAEM2005, "01.12"), (Standards.CAEM2009, "02.30")),
        ((Standards.CAEM2005, "01.12.1"), (Standards.CAEM2009, "01.11")),
        ((Standards.CAEM2005, "01.12.1"), (Standards.CAEM2009, "01.13")),
        ((Standards.CAEM2005, "01.12.1"), (Standards.CAEM2009, "01.28")),
        ((Standards.CAEM2005, "01.12.1"), (Standards.CAEM2009, "01.64")),
        ((Standards.CAEM2005, "01.12.1"), (Standards.CAEM2009, "02.10")),
        ((Standards.CAEM2005, "01.12.1"), (Standards.CAEM2009, "02.30")),
        ((Standards.CAEM2005, "01.12.2"), (Standards.CAEM2009, "01.11")),
        ((Standards.CAEM2005, "01.12.2"), (Standards.CAEM2009, "01.13")),
        ((Standards.CAEM2005, "01.12.2"), (Standards.CAEM2009, "01.19")),
        ((Standards.CAEM2005, "01.12.2"), (Standards.CAEM2009, "01.64")),
        ((Standards.CAEM2005, "01.12.2"), (Standards.CAEM2009, "02.10")),
        ((Standards.CAEM2005, "01.12.3"), (Standards.CAEM2009, "01.11")),
        ((Standards.CAEM2005, "01.12.3"), (Standards.CAEM2009, "01.19")),
        ((Standards.CAEM2005, "01.12.3"), (Standards.CAEM2009, "01.25")),
        ((Standards.CAEM2005, "01.12.3"), (Standards.CAEM2009, "01.64")),
        ((Standards.CAEM2005, "01.12.3"), (Standards.CAEM2009, "02.10")),
        ((Standards.CAEM2005, "01.12.4"), (Standards.CAEM2009, "01.11")),
        ((Standards.CAEM2005, "01.12.4"), (Standards.CAEM2009, "01.30")),
        ((Standards.CAEM2005, "01.12.4"), (Standards.CAEM2009, "01.64")),
        ((Standards.CAEM2005, "01.12.4"), (Standards.CAEM2009, "02.10")),
        ((Standards.CAEM2005, "01.13"), (Standards.CAEM2009, "01.21")),
        ((Standards.CAEM2005, "01.13"), (Standards.CAEM2009, "01.22")),
        ((Standards.CAEM2005, "01.13"), (Standards.CAEM2009, "01.23")),
        ((Standards.CAEM2005, "01.13"), (Standards.CAEM2009, "01.24")),
        ((Standards.CAEM2005, "01.13"), (Standards.CAEM2009, "01.25")),
        ((Standards.CAEM2005, "01.13"), (Standards.CAEM2009, "01.26")),
        ((Standards.CAEM2005, "01.13"), (Standards.CAEM2009, "01.27")),
        ((Standards.CAEM2005, "01.13"), (Standards.CAEM2009, "01.28")),
        ((Standards.CAEM2005, "01.13"), (Standards.CAEM2009, "01.63")),
        ((Standards.CAEM2005, "01.13"), (Standards.CAEM2009, "01.64")),
        ((Standards.CAEM2005, "01.13"), (Standards.CAEM2009, "02.30")),
        ((Standards.CAEM2005, "01.13"), (Standards.CAEM2009, "10.41")),
        ((Standards.CAEM2005, "01.13"), (Standards.CAEM2009, "11.02")),
        ((Standards.CAEM2005, "01.13.1"), (Standards.CAEM2009, "01.22")),
        ((Standards.CAEM2005, "01.13.1"), (Standards.CAEM2009, "01.23")),
        ((Standards.CAEM2005, "01.13.1"), (Standards.CAEM2009, "01.24")),
        ((Standards.CAEM2005, "01.13.1"), (Standards.CAEM2009, "01.25")),
        ((Standards.CAEM2005, "01.13.1"), (Standards.CAEM2009, "01.26")),
        ((Standards.CAEM2005, "01.13.1"), (Standards.CAEM2009, "01.63")),
        ((Standards.CAEM2005, "01.13.1"), (Standards.CAEM2009, "01.64")),
        ((Standards.CAEM2005, "01.13.1"), (Standards.CAEM2009, "02.30")),
        ((Standards.CAEM2005, "01.13.1"), (Standards.CAEM2009, "10.41")),
        ((Standards.CAEM2005, "01.13.2"), (Standards.CAEM2009, "01.27")),
        ((Standards.CAEM2005, "01.13.2"), (Standards.CAEM2009, "01.28")),
        ((Standards.CAEM2005, "01.13.2"), (Standards.CAEM2009, "01.63")),
        ((Standards.CAEM2005, "01.13.2"), (Standards.CAEM2009, "01.64")),
        ((Standards.CAEM2005, "01.13.2"), (Standards.CAEM2009, "10.41")),
        ((Standards.CAEM2005, "01.13.3"), (Standards.CAEM2009, "01.21")),
        ((Standards.CAEM2005, "01.13.3"), (Standards.CAEM2009, "01.63")),
        ((Standards.CAEM2005, "01.13.3"), (Standards.CAEM2009, "01.64")),
        ((Standards.CAEM2005, "01.13.3"), (Standards.CAEM2009, "10.41")),
        ((Standards.CAEM2005, "01.13.3"), (Standards.CAEM2009, "11.02")),
        ((Standards.CAEM2005, "01.2"), (Standards.CAEM2009, "01.4")),
        ((Standards.CAEM2005, "01.2"), (Standards.CAEM2009, "03.2")),
        ((Standards.CAEM2005, "01.21"), (Standards.CAEM2009, "01.41")),
        ((Standards.CAEM2005, "01.21"), (Standards.CAEM2009, "01.42")),
        ((Standards.CAEM2005, "01.21.0"), (Standards.CAEM2009, "01.41")),
        ((Standards.CAEM2005, "01.21.0"), (Standards.CAEM2009, "01.42")),
        ((Standards.CAEM2005, "01.22"), (Standards.CAEM2009, "01.43")),
        ((Standards.CAEM2005, "01.22"), (Standards.CAEM2009, "01.44")),
        ((Standards.CAEM2005, "01.22"), (Standards.CAEM2009, "01.45")),
        ((Standards.CAEM2005, "01.22"), (Standards.CAEM2009, "01.49")),
        ((Standards.CAEM2005, "01.22.1"), (Standards.CAEM2009, "01.45")),
        ((Standards.CAEM2005, "01.22.2"), (Standards.CAEM2009, "01.43")),
        ((Standards.CAEM2005, "01.22.2"), (Standards.CAEM2009, "01.49")),
        ((Standards.CAEM2005, "01.22.3"), (Standards.CAEM2009, "01.43")),
        ((Standards.CAEM2005, "01.22.3"), (Standards.CAEM2009, "01.44")),
        ((Standards.CAEM2005, "01.22.3"), (Standards.CAEM2009, "01.49")),
        ((Standards.CAEM2005, "01.23"), (Standards.CAEM2009, "01.46")),
        ((Standards.CAEM2005, "01.23.0"), (Standards.CAEM2009, "01.46")),
        ((Standards.CAEM2005, "01.24"), (Standards.CAEM2009, "01.47")),
        ((Standards.CAEM2005, "01.24.1"), (Standards.CAEM2009, "01.47")),
        ((Standards.CAEM2005, "01.24.2"), (Standards.CAEM2009, "01.47")),
        ((Standards.CAEM2005, "01.24.3"), (Standards.CAEM2009, "01.47")),
        ((Standards.CAEM2005, "01.24.4"), (Standards.CAEM2009, "01.47")),
        ((Standards.CAEM2005, "01.25"), (Standards.CAEM2009, "01.49")),
        ((Standards.CAEM2005, "01.25"), (Standards.CAEM2009, "03.22")),
        ((Standards.CAEM2005, "01.25.1"), (Standards.CAEM2009, "01.49")),
        ((Standards.CAEM2005, "01.25.1"), (Standards.CAEM2009, "03.22")),
        ((Standards.CAEM2005, "01.25.2"), (Standards.CAEM2009, "01.49")),
        ((Standards.CAEM2005, "01.25.2"), (Standards.CAEM2009, "03.22")),
        ((Standards.CAEM2005, "01.3"), (Standards.CAEM2009, "01.5")),
        ((Standards.CAEM2005, "01.30"), (Standards.CAEM2009, "01.50")),
        ((Standards.CAEM2005, "01.30.0"), (Standards.CAEM2009, "01.50")),
        ((Standards.CAEM2005, "01.4"), (Standards.CAEM2009, "01.6")),
        ((Standards.CAEM2005, "01.4"), (Standards.CAEM2009, "10.3")),
        ((Standards.CAEM2005, "01.4"), (Standards.CAEM2009, "81.3")),
        ((Standards.CAEM2005, "01.41"), (Standards.CAEM2009, "01.61")),
        ((Standards.CAEM2005, "01.41"), (Standards.CAEM2009, "01.63")),
        ((Standards.CAEM2005, "01.41"), (Standards.CAEM2009, "01.64")),
        ((Standards.CAEM2005, "01.41"), (Standards.CAEM2009, "10.39")),
        ((Standards.CAEM2005, "01.41"), (Standards.CAEM2009, "81.30")),
        ((Standards.CAEM2005, "01.41.1"), (Standards.CAEM2009, "01.61")),
        ((Standards.CAEM2005, "01.41.2"), (Standards.CAEM2009, "01.61")),
        ((Standards.CAEM2005, "01.41.9"), (Standards.CAEM2009, "01.61")),
        ((Standards.CAEM2005, "01.41.9"), (Standards.CAEM2009, "01.63")),
        ((Standards.CAEM2005, "01.41.9"), (Standards.CAEM2009, "01.64")),
        ((Standards.CAEM2005, "01.41.9"), (Standards.CAEM2009, "10.39")),
        ((Standards.CAEM2005, "01.41.9"), (Standards.CAEM2009, "81.30")),
        ((Standards.CAEM2005, "01.42"), (Standards.CAEM2009, "01.62")),
        ((Standards.CAEM2005, "01.42.0"), (Standards.CAEM2009, "01.62")),
        ((Standards.CAEM2005, "01.5"), (Standards.CAEM2009, "01.7")),
        ((Standards.CAEM2005, "01.5"), (Standards.CAEM2009, "94.9")),
        ((Standards.CAEM2005, "01.50"), (Standards.CAEM2009, "01.70")),
        ((Standards.CAEM2005, "01.50"), (Standards.CAEM2009, "94.99")),
        ((Standards.CAEM2005, "01.50.0"), (Standards.CAEM2009, "01.70")),
        ((Standards.CAEM2005, "01.50.0"), (Standards.CAEM2009, "94.99")),
        ((Standards.CAEM2005, "02"), (Standards.CAEM2009, "01")),
        ((Standards.CAEM2005, "02"), (Standards.CAEM2009, "02")),
        ((Standards.CAEM2005, "02"), (Standards.CAEM2009, "16")),
        ((Standards.CAEM2005, "02.0"), (Standards.CAEM2009, "01.2")),
        ((Standards.CAEM2005, "02.0"), (Standards.CAEM2009, "02.1")),
        ((Standards.CAEM2005, "02.0"), (Standards.CAEM2009, "02.2")),
        ((Standards.CAEM2005, "02.0"), (Standards.CAEM2009, "02.3")),
        ((Standards.CAEM2005, "02.0"), (Standards.CAEM2009, "02.4")),
        ((Standards.CAEM2005, "02.0"), (Standards.CAEM2009, "16.1")),
        ((Standards.CAEM2005, "02.01"), (Standards.CAEM2009, "01.29")),
        ((Standards.CAEM2005, "02.01"), (Standards.CAEM2009, "02.10")),
        ((Standards.CAEM2005, "02.01"), (Standards.CAEM2009, "02.20")),
        ((Standards.CAEM2005, "02.01"), (Standards.CAEM2009, "02.30")),
        ((Standards.CAEM2005, "02.01"), (Standards.CAEM2009, "16.10")),
        ((Standards.CAEM2005, "02.01.1"), (Standards.CAEM2009, "01.29")),
        ((Standards.CAEM2005, "02.01.1"), (Standards.CAEM2009, "02.10")),
        ((Standards.CAEM2005, "02.01.2"), (Standards.CAEM2009, "02.20")),
        ((Standards.CAEM2005, "02.01.2"), (Standards.CAEM2009, "16.10")),
        ((Standards.CAEM2005, "02.01.3"), (Standards.CAEM2009, "02.30")),
        ((Standards.CAEM2005, "02.02"), (Standards.CAEM2009, "02.40")),
        ((Standards.CAEM2005, "02.02.0"), (Standards.CAEM2009, "02.40")),
        ((Standards.CAEM2005, "B"), (Standards.CAEM2009, "A")),
        ((Standards.CAEM2005, "B"), (Standards.CAEM2009, "M")),
        ((Standards.CAEM2005, "05"), (Standards.CAEM2009, "03")),
        ((Standards.CAEM2005, "05"), (Standards.CAEM2009, "70")),
        ((Standards.CAEM2005, "05.0"), (Standards.CAEM2009, "03.1")),
        ((Standards.CAEM2005, "05.0"), (Standards.CAEM2009, "03.2")),
        ((Standards.CAEM2005, "05.0"), (Standards.CAEM2009, "70.2")),
        ((Standards.CAEM2005, "05.01"), (Standards.CAEM2009, "03.11")),
        ((Standards.CAEM2005, "05.01"), (Standards.CAEM2009, "03.12")),
        ((Standards.CAEM2005, "05.01"), (Standards.CAEM2009, "70.22")),
        ((Standards.CAEM2005, "05.01.0"), (Standards.CAEM2009, "03.11")),
        ((Standards.CAEM2005, "05.01.0"), (Standards.CAEM2009, "03.12")),
        ((Standards.CAEM2005, "05.01.0"), (Standards.CAEM2009, "70.22")),
        ((Standards.CAEM2005, "05.02"), (Standards.CAEM2009, "03.21")),
        ((Standards.CAEM2005, "05.02"), (Standards.CAEM2009, "03.22")),
        ((Standards.CAEM2005, "05.02.0"), (Standards.CAEM2009, "03.21")),
        ((Standards.CAEM2005, "05.02.0"), (Standards.CAEM2009, "03.22")),
        ((Standards.CAEM2005, "C"), (Standards.CAEM2009, "B")),
        ((Standards.CAEM2005, "C"), (Standards.CAEM2009, "C")),
        ((Standards.CAEM2005, "C"), (Standards.CAEM2009, "E")),
        ((Standards.CAEM2005, "C"), (Standards.CAEM2009, "H")),
        ((Standards.CAEM2005, "10"), (Standards.CAEM2009, "05")),
        ((Standards.CAEM2005, "10"), (Standards.CAEM2009, "08")),
        ((Standards.CAEM2005, "10"), (Standards.CAEM2009, "09")),
        ((Standards.CAEM2005, "10"), (Standards.CAEM2009, "19")),
        ((Standards.CAEM2005, "10.1"), (Standards.CAEM2009, "05.1")),
        ((Standards.CAEM2005, "10.1"), (Standards.CAEM2009, "09.9")),
        ((Standards.CAEM2005, "10.1"), (Standards.CAEM2009, "19.2")),
        ((Standards.CAEM2005, "10.10"), (Standards.CAEM2009, "05.10")),
        ((Standards.CAEM2005, "10.10"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "10.10"), (Standards.CAEM2009, "19.20")),
        ((Standards.CAEM2005, "10.10.0"), (Standards.CAEM2009, "05.10")),
        ((Standards.CAEM2005, "10.10.0"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "10.10.0"), (Standards.CAEM2009, "19.20")),
        ((Standards.CAEM2005, "10.2"), (Standards.CAEM2009, "05.2")),
        ((Standards.CAEM2005, "10.2"), (Standards.CAEM2009, "09.9")),
        ((Standards.CAEM2005, "10.2"), (Standards.CAEM2009, "19.2")),
        ((Standards.CAEM2005, "10.20"), (Standards.CAEM2009, "05.20")),
        ((Standards.CAEM2005, "10.20"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "10.20"), (Standards.CAEM2009, "19.20")),
        ((Standards.CAEM2005, "10.20.0"), (Standards.CAEM2009, "05.20")),
        ((Standards.CAEM2005, "10.20.0"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "10.20.0"), (Standards.CAEM2009, "19.20")),
        ((Standards.CAEM2005, "10.3"), (Standards.CAEM2009, "08.9")),
        ((Standards.CAEM2005, "10.3"), (Standards.CAEM2009, "09.9")),
        ((Standards.CAEM2005, "10.3"), (Standards.CAEM2009, "19.2")),
        ((Standards.CAEM2005, "10.30"), (Standards.CAEM2009, "08.92")),
        ((Standards.CAEM2005, "10.30"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "10.30"), (Standards.CAEM2009, "19.20")),
        ((Standards.CAEM2005, "10.30.0"), (Standards.CAEM2009, "08.92")),
        ((Standards.CAEM2005, "10.30.0"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "10.30.0"), (Standards.CAEM2009, "19.20")),
        ((Standards.CAEM2005, "11"), (Standards.CAEM2009, "06")),
        ((Standards.CAEM2005, "11"), (Standards.CAEM2009, "09")),
        ((Standards.CAEM2005, "11"), (Standards.CAEM2009, "52")),
        ((Standards.CAEM2005, "11.1"), (Standards.CAEM2009, "06.1")),
        ((Standards.CAEM2005, "11.1"), (Standards.CAEM2009, "06.2")),
        ((Standards.CAEM2005, "11.1"), (Standards.CAEM2009, "09.1")),
        ((Standards.CAEM2005, "11.1"), (Standards.CAEM2009, "52.2")),
        ((Standards.CAEM2005, "11.10"), (Standards.CAEM2009, "06.10")),
        ((Standards.CAEM2005, "11.10"), (Standards.CAEM2009, "06.20")),
        ((Standards.CAEM2005, "11.10"), (Standards.CAEM2009, "09.10")),
        ((Standards.CAEM2005, "11.10"), (Standards.CAEM2009, "52.21")),
        ((Standards.CAEM2005, "11.10"), (Standards.CAEM2009, "52.22")),
        ((Standards.CAEM2005, "11.10.1"), (Standards.CAEM2009, "06.10")),
        ((Standards.CAEM2005, "11.10.1"), (Standards.CAEM2009, "09.10")),
        ((Standards.CAEM2005, "11.10.2"), (Standards.CAEM2009, "06.20")),
        ((Standards.CAEM2005, "11.10.2"), (Standards.CAEM2009, "09.10")),
        ((Standards.CAEM2005, "11.10.2"), (Standards.CAEM2009, "52.21")),
        ((Standards.CAEM2005, "11.10.2"), (Standards.CAEM2009, "52.22")),
        ((Standards.CAEM2005, "11.2"), (Standards.CAEM2009, "09.1")),
        ((Standards.CAEM2005, "11.20"), (Standards.CAEM2009, "09.10")),
        ((Standards.CAEM2005, "11.20.0"), (Standards.CAEM2009, "09.10")),
        ((Standards.CAEM2005, "12"), (Standards.CAEM2009, "07")),
        ((Standards.CAEM2005, "12"), (Standards.CAEM2009, "09")),
        ((Standards.CAEM2005, "12.0"), (Standards.CAEM2009, "07.2")),
        ((Standards.CAEM2005, "12.0"), (Standards.CAEM2009, "09.9")),
        ((Standards.CAEM2005, "12.00"), (Standards.CAEM2009, "07.21")),
        ((Standards.CAEM2005, "12.00"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "12.00.0"), (Standards.CAEM2009, "07.21")),
        ((Standards.CAEM2005, "12.00.0"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "13"), (Standards.CAEM2009, "07")),
        ((Standards.CAEM2005, "13"), (Standards.CAEM2009, "09")),
        ((Standards.CAEM2005, "13.1"), (Standards.CAEM2009, "07.1")),
        ((Standards.CAEM2005, "13.1"), (Standards.CAEM2009, "09.9")),
        ((Standards.CAEM2005, "13.10"), (Standards.CAEM2009, "07.10")),
        ((Standards.CAEM2005, "13.10"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "13.10.0"), (Standards.CAEM2009, "07.10")),
        ((Standards.CAEM2005, "13.10.0"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "13.2"), (Standards.CAEM2009, "07.2")),
        ((Standards.CAEM2005, "13.2"), (Standards.CAEM2009, "09.9")),
        ((Standards.CAEM2005, "13.20"), (Standards.CAEM2009, "07.29")),
        ((Standards.CAEM2005, "13.20"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "13.20.0"), (Standards.CAEM2009, "07.29")),
        ((Standards.CAEM2005, "13.20.0"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "14"), (Standards.CAEM2009, "08")),
        ((Standards.CAEM2005, "14"), (Standards.CAEM2009, "09")),
        ((Standards.CAEM2005, "14"), (Standards.CAEM2009, "38")),
        ((Standards.CAEM2005, "14.1"), (Standards.CAEM2009, "08.1")),
        ((Standards.CAEM2005, "14.1"), (Standards.CAEM2009, "09.9")),
        ((Standards.CAEM2005, "14.11"), (Standards.CAEM2009, "08.11")),
        ((Standards.CAEM2005, "14.11"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "14.11.0"), (Standards.CAEM2009, "08.11")),
        ((Standards.CAEM2005, "14.11.0"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "14.12"), (Standards.CAEM2009, "08.11")),
        ((Standards.CAEM2005, "14.12"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "14.12.0"), (Standards.CAEM2009, "08.11")),
        ((Standards.CAEM2005, "14.12.0"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "14.13"), (Standards.CAEM2009, "08.11")),
        ((Standards.CAEM2005, "14.13"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "14.13.0"), (Standards.CAEM2009, "08.11")),
        ((Standards.CAEM2005, "14.13.0"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "14.2"), (Standards.CAEM2009, "08.1")),
        ((Standards.CAEM2005, "14.2"), (Standards.CAEM2009, "09.9")),
        ((Standards.CAEM2005, "14.21"), (Standards.CAEM2009, "08.12")),
        ((Standards.CAEM2005, "14.21"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "14.21.0"), (Standards.CAEM2009, "08.12")),
        ((Standards.CAEM2005, "14.21.0"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "14.22"), (Standards.CAEM2009, "08.12")),
        ((Standards.CAEM2005, "14.22"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "14.22.1"), (Standards.CAEM2009, "08.12")),
        ((Standards.CAEM2005, "14.22.1"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "14.22.2"), (Standards.CAEM2009, "08.12")),
        ((Standards.CAEM2005, "14.22.2"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "14.3"), (Standards.CAEM2009, "08.9")),
        ((Standards.CAEM2005, "14.3"), (Standards.CAEM2009, "09.9")),
        ((Standards.CAEM2005, "14.30"), (Standards.CAEM2009, "08.91")),
        ((Standards.CAEM2005, "14.30"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "14.30.0"), (Standards.CAEM2009, "08.91")),
        ((Standards.CAEM2005, "14.30.0"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "14.4"), (Standards.CAEM2009, "08.9")),
        ((Standards.CAEM2005, "14.4"), (Standards.CAEM2009, "09.9")),
        ((Standards.CAEM2005, "14.4"), (Standards.CAEM2009, "10.8")),
        ((Standards.CAEM2005, "14.40"), (Standards.CAEM2009, "08.93")),
        ((Standards.CAEM2005, "14.40"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "14.40"), (Standards.CAEM2009, "10.84")),
        ((Standards.CAEM2005, "14.40.0"), (Standards.CAEM2009, "08.93")),
        ((Standards.CAEM2005, "14.40.0"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "14.40.0"), (Standards.CAEM2009, "10.84")),
        ((Standards.CAEM2005, "14.5"), (Standards.CAEM2009, "08.9")),
        ((Standards.CAEM2005, "14.5"), (Standards.CAEM2009, "09.9")),
        ((Standards.CAEM2005, "14.5"), (Standards.CAEM2009, "38.2")),
        ((Standards.CAEM2005, "14.50"), (Standards.CAEM2009, "08.99")),
        ((Standards.CAEM2005, "14.50"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "14.50"), (Standards.CAEM2009, "38.21")),
        ((Standards.CAEM2005, "14.50.1"), (Standards.CAEM2009, "08.99")),
        ((Standards.CAEM2005, "14.50.1"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "14.50.1"), (Standards.CAEM2009, "38.21")),
        ((Standards.CAEM2005, "14.50.2"), (Standards.CAEM2009, "08.99")),
        ((Standards.CAEM2005, "14.50.2"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "14.50.2"), (Standards.CAEM2009, "38.21")),
        ((Standards.CAEM2005, "14.50.3"), (Standards.CAEM2009, "08.99")),
        ((Standards.CAEM2005, "14.50.3"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "14.50.4"), (Standards.CAEM2009, "08.99")),
        ((Standards.CAEM2005, "14.50.4"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "14.50.5"), (Standards.CAEM2009, "08.99")),
        ((Standards.CAEM2005, "14.50.5"), (Standards.CAEM2009, "09.90")),
        ((Standards.CAEM2005, "D"), (Standards.CAEM2009, "C")),
        ((Standards.CAEM2005, "D"), (Standards.CAEM2009, "E")),
        ((Standards.CAEM2005, "D"), (Standards.CAEM2009, "F")),
        ((Standards.CAEM2005, "D"), (Standards.CAEM2009, "J")),
        ((Standards.CAEM2005, "D"), (Standards.CAEM2009, "S")),
        ((Standards.CAEM2005, "15"), (Standards.CAEM2009, "10")),
        ((Standards.CAEM2005, "15"), (Standards.CAEM2009, "11")),
        ((Standards.CAEM2005, "15"), (Standards.CAEM2009, "20")),
        ((Standards.CAEM2005, "15.1"), (Standards.CAEM2009, "10.1")),
        ((Standards.CAEM2005, "15.1"), (Standards.CAEM2009, "10.8")),
        ((Standards.CAEM2005, "15.11"), (Standards.CAEM2009, "10.11")),
        ((Standards.CAEM2005, "15.11.0"), (Standards.CAEM2009, "10.11")),
        ((Standards.CAEM2005, "15.12"), (Standards.CAEM2009, "10.11")),
        ((Standards.CAEM2005, "15.12"), (Standards.CAEM2009, "10.12")),
        ((Standards.CAEM2005, "15.12.0"), (Standards.CAEM2009, "10.11")),
        ((Standards.CAEM2005, "15.12.0"), (Standards.CAEM2009, "10.12")),
        ((Standards.CAEM2005, "15.13"), (Standards.CAEM2009, "10.13")),
        ((Standards.CAEM2005, "15.13"), (Standards.CAEM2009, "10.85")),
        ((Standards.CAEM2005, "15.13"), (Standards.CAEM2009, "10.89")),
        ((Standards.CAEM2005, "15.13.0"), (Standards.CAEM2009, "10.13")),
        ((Standards.CAEM2005, "15.13.0"), (Standards.CAEM2009, "10.85")),
        ((Standards.CAEM2005, "15.13.0"), (Standards.CAEM2009, "10.89")),
        ((Standards.CAEM2005, "15.2"), (Standards.CAEM2009, "10.2")),
        ((Standards.CAEM2005, "15.2"), (Standards.CAEM2009, "10.8")),
        ((Standards.CAEM2005, "15.20"), (Standards.CAEM2009, "10.20")),
        ((Standards.CAEM2005, "15.20"), (Standards.CAEM2009, "10.85")),
        ((Standards.CAEM2005, "15.20.0"), (Standards.CAEM2009, "10.20")),
        ((Standards.CAEM2005, "15.20.0"), (Standards.CAEM2009, "10.85")),
        ((Standards.CAEM2005, "15.3"), (Standards.CAEM2009, "10.3")),
        ((Standards.CAEM2005, "15.3"), (Standards.CAEM2009, "10.8")),
        ((Standards.CAEM2005, "15.31"), (Standards.CAEM2009, "10.31")),
        ((Standards.CAEM2005, "15.31.0"), (Standards.CAEM2009, "10.31")),
        ((Standards.CAEM2005, "15.32"), (Standards.CAEM2009, "10.32")),
        ((Standards.CAEM2005, "15.32.0"), (Standards.CAEM2009, "10.32")),
        ((Standards.CAEM2005, "15.33"), (Standards.CAEM2009, "10.39")),
        ((Standards.CAEM2005, "15.33"), (Standards.CAEM2009, "10.85")),
        ((Standards.CAEM2005, "15.33.0"), (Standards.CAEM2009, "10.39")),
        ((Standards.CAEM2005, "15.33.0"), (Standards.CAEM2009, "10.85")),
        ((Standards.CAEM2005, "15.4"), (Standards.CAEM2009, "10.4")),
        ((Standards.CAEM2005, "15.41"), (Standards.CAEM2009, "10.41")),
        ((Standards.CAEM2005, "15.41.0"), (Standards.CAEM2009, "10.41")),
        ((Standards.CAEM2005, "15.42"), (Standards.CAEM2009, "10.41")),
        ((Standards.CAEM2005, "15.42.0"), (Standards.CAEM2009, "10.41")),
        ((Standards.CAEM2005, "15.43"), (Standards.CAEM2009, "10.42")),
        ((Standards.CAEM2005, "15.43.0"), (Standards.CAEM2009, "10.42")),
        ((Standards.CAEM2005, "15.5"), (Standards.CAEM2009, "10.5")),
        ((Standards.CAEM2005, "15.51"), (Standards.CAEM2009, "10.51")),
        ((Standards.CAEM2005, "15.51.0"), (Standards.CAEM2009, "10.51")),
        ((Standards.CAEM2005, "15.52"), (Standards.CAEM2009, "10.52")),
        ((Standards.CAEM2005, "15.52.0"), (Standards.CAEM2009, "10.52")),
        ((Standards.CAEM2005, "15.6"), (Standards.CAEM2009, "10.6")),
        ((Standards.CAEM2005, "15.6"), (Standards.CAEM2009, "10.8")),
        ((Standards.CAEM2005, "15.61"), (Standards.CAEM2009, "10.61")),
        ((Standards.CAEM2005, "15.61.1"), (Standards.CAEM2009, "10.61")),
        ((Standards.CAEM2005, "15.61.2"), (Standards.CAEM2009, "10.61")),
        ((Standards.CAEM2005, "15.61.3"), (Standards.CAEM2009, "10.61")),
        ((Standards.CAEM2005, "15.62"), (Standards.CAEM2009, "10.62")),
        ((Standards.CAEM2005, "15.62"), (Standards.CAEM2009, "10.89")),
        ((Standards.CAEM2005, "15.62.0"), (Standards.CAEM2009, "10.62")),
        ((Standards.CAEM2005, "15.62.0"), (Standards.CAEM2009, "10.89")),
        ((Standards.CAEM2005, "15.7"), (Standards.CAEM2009, "10.9")),
        ((Standards.CAEM2005, "15.71"), (Standards.CAEM2009, "10.91")),
        ((Standards.CAEM2005, "15.71.0"), (Standards.CAEM2009, "10.91")),
        ((Standards.CAEM2005, "15.72"), (Standards.CAEM2009, "10.92")),
        ((Standards.CAEM2005, "15.72.0"), (Standards.CAEM2009, "10.92")),
        ((Standards.CAEM2005, "15.8"), (Standards.CAEM2009, "10.7")),
        ((Standards.CAEM2005, "15.8"), (Standards.CAEM2009, "10.8")),
        ((Standards.CAEM2005, "15.81"), (Standards.CAEM2009, "10.71")),
        ((Standards.CAEM2005, "15.81"), (Standards.CAEM2009, "10.85")),
        ((Standards.CAEM2005, "15.81"), (Standards.CAEM2009, "10.89")),
        ((Standards.CAEM2005, "15.81.0"), (Standards.CAEM2009, "10.71")),
        ((Standards.CAEM2005, "15.81.0"), (Standards.CAEM2009, "10.85")),
        ((Standards.CAEM2005, "15.81.0"), (Standards.CAEM2009, "10.89")),
        ((Standards.CAEM2005, "15.82"), (Standards.CAEM2009, "10.72")),
        ((Standards.CAEM2005, "15.82.0"), (Standards.CAEM2009, "10.72")),
        ((Standards.CAEM2005, "15.83"), (Standards.CAEM2009, "10.81")),
        ((Standards.CAEM2005, "15.83.0"), (Standards.CAEM2009, "10.81")),
        ((Standards.CAEM2005, "15.84"), (Standards.CAEM2009, "10.82")),
        ((Standards.CAEM2005, "15.84.0"), (Standards.CAEM2009, "10.82")),
        ((Standards.CAEM2005, "15.85"), (Standards.CAEM2009, "10.73")),
        ((Standards.CAEM2005, "15.85"), (Standards.CAEM2009, "10.85")),
        ((Standards.CAEM2005, "15.85.0"), (Standards.CAEM2009, "10.73")),
        ((Standards.CAEM2005, "15.85.0"), (Standards.CAEM2009, "10.85")),
        ((Standards.CAEM2005, "15.86"), (Standards.CAEM2009, "10.83")),
        ((Standards.CAEM2005, "15.86.0"), (Standards.CAEM2009, "10.83")),
        ((Standards.CAEM2005, "15.87"), (Standards.CAEM2009, "10.84")),
        ((Standards.CAEM2005, "15.87.0"), (Standards.CAEM2009, "10.84")),
        ((Standards.CAEM2005, "15.88"), (Standards.CAEM2009, "10.86")),
        ((Standards.CAEM2005, "15.88.0"), (Standards.CAEM2009, "10.86")),
        ((Standards.CAEM2005, "15.89"), (Standards.CAEM2009, "10.89")),
        ((Standards.CAEM2005, "15.89.1"), (Standards.CAEM2009, "10.89")),
        ((Standards.CAEM2005, "15.89.2"), (Standards.CAEM2009, "10.89")),
        ((Standards.CAEM2005, "15.89.9"), (Standards.CAEM2009, "10.89")),
        ((Standards.CAEM2005, "15.9"), (Standards.CAEM2009, "11.0")),
        ((Standards.CAEM2005, "15.9"), (Standards.CAEM2009, "20.1")),
        ((Standards.CAEM2005, "15.91"), (Standards.CAEM2009, "11.01")),
        ((Standards.CAEM2005, "15.91.0"), (Standards.CAEM2009, "11.01")),
        ((Standards.CAEM2005, "15.92"), (Standards.CAEM2009, "11.01")),
        ((Standards.CAEM2005, "15.92"), (Standards.CAEM2009, "20.14")),
        ((Standards.CAEM2005, "15.92.0"), (Standards.CAEM2009, "11.01")),
        ((Standards.CAEM2005, "15.92.0"), (Standards.CAEM2009, "20.14")),
        ((Standards.CAEM2005, "15.93"), (Standards.CAEM2009, "11.02")),
        ((Standards.CAEM2005, "15.93.0"), (Standards.CAEM2009, "11.02")),
        ((Standards.CAEM2005, "15.94"), (Standards.CAEM2009, "11.03")),
        ((Standards.CAEM2005, "15.94.0"), (Standards.CAEM2009, "11.03")),
        ((Standards.CAEM2005, "15.95"), (Standards.CAEM2009, "11.04")),
        ((Standards.CAEM2005, "15.95.0"), (Standards.CAEM2009, "11.04")),
        ((Standards.CAEM2005, "15.96"), (Standards.CAEM2009, "11.05")),
        ((Standards.CAEM2005, "15.96.0"), (Standards.CAEM2009, "11.05")),
        ((Standards.CAEM2005, "15.97"), (Standards.CAEM2009, "11.06")),
        ((Standards.CAEM2005, "15.97.0"), (Standards.CAEM2009, "11.06")),
        ((Standards.CAEM2005, "15.98"), (Standards.CAEM2009, "11.07")),
        ((Standards.CAEM2005, "15.98.0"), (Standards.CAEM2009, "11.07")),
        ((Standards.CAEM2005, "16"), (Standards.CAEM2009, "12")),
        ((Standards.CAEM2005, "16.0"), (Standards.CAEM2009, "12.0")),
        ((Standards.CAEM2005, "16.00"), (Standards.CAEM2009, "12.00")),
        ((Standards.CAEM2005, "16.00.0"), (Standards.CAEM2009, "12.00")),
        ((Standards.CAEM2005, "17"), (Standards.CAEM2009, "13")),
        ((Standards.CAEM2005, "17"), (Standards.CAEM2009, "14")),
        ((Standards.CAEM2005, "17"), (Standards.CAEM2009, "17")),
        ((Standards.CAEM2005, "17"), (Standards.CAEM2009, "32")),
        ((Standards.CAEM2005, "17"), (Standards.CAEM2009, "33")),
        ((Standards.CAEM2005, "17"), (Standards.CAEM2009, "95")),
        ((Standards.CAEM2005, "17.1"), (Standards.CAEM2009, "13.1")),
        ((Standards.CAEM2005, "17.11"), (Standards.CAEM2009, "13.10")),
        ((Standards.CAEM2005, "17.11.1"), (Standards.CAEM2009, "13.10")),
        ((Standards.CAEM2005, "17.11.2"), (Standards.CAEM2009, "13.10")),
        ((Standards.CAEM2005, "17.12"), (Standards.CAEM2009, "13.10")),
        ((Standards.CAEM2005, "17.12.1"), (Standards.CAEM2009, "13.10")),
        ((Standards.CAEM2005, "17.12.2"), (Standards.CAEM2009, "13.10")),
        ((Standards.CAEM2005, "17.13"), (Standards.CAEM2009, "13.10")),
        ((Standards.CAEM2005, "17.13.1"), (Standards.CAEM2009, "13.10")),
        ((Standards.CAEM2005, "17.13.2"), (Standards.CAEM2009, "13.10")),
        ((Standards.CAEM2005, "17.14"), (Standards.CAEM2009, "13.10")),
        ((Standards.CAEM2005, "17.14.1"), (Standards.CAEM2009, "13.10")),
        ((Standards.CAEM2005, "17.14.2"), (Standards.CAEM2009, "13.10")),
        ((Standards.CAEM2005, "17.15"), (Standards.CAEM2009, "13.10")),
        ((Standards.CAEM2005, "17.15.1"), (Standards.CAEM2009, "13.10")),
        ((Standards.CAEM2005, "17.15.2"), (Standards.CAEM2009, "13.10")),
        ((Standards.CAEM2005, "17.16"), (Standards.CAEM2009, "13.10")),
        ((Standards.CAEM2005, "17.16.1"), (Standards.CAEM2009, "13.10")),
        ((Standards.CAEM2005, "17.16.2"), (Standards.CAEM2009, "13.10")),
        ((Standards.CAEM2005, "17.16.3"), (Standards.CAEM2009, "13.10")),
        ((Standards.CAEM2005, "17.16.4"), (Standards.CAEM2009, "13.10")),
        ((Standards.CAEM2005, "17.17"), (Standards.CAEM2009, "13.10")),
        ((Standards.CAEM2005, "17.17.1"), (Standards.CAEM2009, "13.10")),
        ((Standards.CAEM2005, "17.17.2"), (Standards.CAEM2009, "13.10")),
        ((Standards.CAEM2005, "17.2"), (Standards.CAEM2009, "13.2")),
        ((Standards.CAEM2005, "17.21"), (Standards.CAEM2009, "13.20")),
        ((Standards.CAEM2005, "17.21.0"), (Standards.CAEM2009, "13.20")),
        ((Standards.CAEM2005, "17.22"), (Standards.CAEM2009, "13.20")),
        ((Standards.CAEM2005, "17.22.0"), (Standards.CAEM2009, "13.20")),
        ((Standards.CAEM2005, "17.23"), (Standards.CAEM2009, "13.20")),
        ((Standards.CAEM2005, "17.23.0"), (Standards.CAEM2009, "13.20")),
        ((Standards.CAEM2005, "17.24"), (Standards.CAEM2009, "13.20")),
        ((Standards.CAEM2005, "17.24.0"), (Standards.CAEM2009, "13.20")),
        ((Standards.CAEM2005, "17.25"), (Standards.CAEM2009, "13.20")),
        ((Standards.CAEM2005, "17.25.1"), (Standards.CAEM2009, "13.20")),
        ((Standards.CAEM2005, "17.25.9"), (Standards.CAEM2009, "13.20")),
        ((Standards.CAEM2005, "17.3"), (Standards.CAEM2009, "13.3")),
        ((Standards.CAEM2005, "17.30"), (Standards.CAEM2009, "13.30")),
        ((Standards.CAEM2005, "17.30.0"), (Standards.CAEM2009, "13.30")),
        ((Standards.CAEM2005, "17.4"), (Standards.CAEM2009, "13.9")),
        ((Standards.CAEM2005, "17.4"), (Standards.CAEM2009, "32.5")),
        ((Standards.CAEM2005, "17.4"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "17.4"), (Standards.CAEM2009, "95.2")),
        ((Standards.CAEM2005, "17.40"), (Standards.CAEM2009, "13.92")),
        ((Standards.CAEM2005, "17.40"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "17.40"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "17.40"), (Standards.CAEM2009, "95.29")),
        ((Standards.CAEM2005, "17.40.0"), (Standards.CAEM2009, "13.92")),
        ((Standards.CAEM2005, "17.40.0"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "17.40.0"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "17.40.0"), (Standards.CAEM2009, "95.29")),
        ((Standards.CAEM2005, "17.5"), (Standards.CAEM2009, "13.9")),
        ((Standards.CAEM2005, "17.5"), (Standards.CAEM2009, "17.2")),
        ((Standards.CAEM2005, "17.5"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "17.51"), (Standards.CAEM2009, "13.93")),
        ((Standards.CAEM2005, "17.51.0"), (Standards.CAEM2009, "13.93")),
        ((Standards.CAEM2005, "17.52"), (Standards.CAEM2009, "13.94")),
        ((Standards.CAEM2005, "17.52"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "17.52.1"), (Standards.CAEM2009, "13.94")),
        ((Standards.CAEM2005, "17.52.1"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "17.52.2"), (Standards.CAEM2009, "13.94")),
        ((Standards.CAEM2005, "17.52.2"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "17.53"), (Standards.CAEM2009, "13.95")),
        ((Standards.CAEM2005, "17.53.0"), (Standards.CAEM2009, "13.95")),
        ((Standards.CAEM2005, "17.54"), (Standards.CAEM2009, "13.96")),
        ((Standards.CAEM2005, "17.54"), (Standards.CAEM2009, "13.99")),
        ((Standards.CAEM2005, "17.54"), (Standards.CAEM2009, "17.22")),
        ((Standards.CAEM2005, "17.54.1"), (Standards.CAEM2009, "13.96")),
        ((Standards.CAEM2005, "17.54.2"), (Standards.CAEM2009, "13.96")),
        ((Standards.CAEM2005, "17.54.9"), (Standards.CAEM2009, "13.99")),
        ((Standards.CAEM2005, "17.54.9"), (Standards.CAEM2009, "17.22")),
        ((Standards.CAEM2005, "17.6"), (Standards.CAEM2009, "13.9")),
        ((Standards.CAEM2005, "17.60"), (Standards.CAEM2009, "13.91")),
        ((Standards.CAEM2005, "17.60.0"), (Standards.CAEM2009, "13.91")),
        ((Standards.CAEM2005, "17.7"), (Standards.CAEM2009, "14.1")),
        ((Standards.CAEM2005, "17.7"), (Standards.CAEM2009, "14.3")),
        ((Standards.CAEM2005, "17.71"), (Standards.CAEM2009, "14.19")),
        ((Standards.CAEM2005, "17.71"), (Standards.CAEM2009, "14.31")),
        ((Standards.CAEM2005, "17.71.0"), (Standards.CAEM2009, "14.19")),
        ((Standards.CAEM2005, "17.71.0"), (Standards.CAEM2009, "14.31")),
        ((Standards.CAEM2005, "17.72"), (Standards.CAEM2009, "14.39")),
        ((Standards.CAEM2005, "17.72.0"), (Standards.CAEM2009, "14.39")),
        ((Standards.CAEM2005, "18"), (Standards.CAEM2009, "13")),
        ((Standards.CAEM2005, "18"), (Standards.CAEM2009, "14")),
        ((Standards.CAEM2005, "18"), (Standards.CAEM2009, "15")),
        ((Standards.CAEM2005, "18"), (Standards.CAEM2009, "32")),
        ((Standards.CAEM2005, "18.1"), (Standards.CAEM2009, "14.1")),
        ((Standards.CAEM2005, "18.1"), (Standards.CAEM2009, "32.9")),
        ((Standards.CAEM2005, "18.10"), (Standards.CAEM2009, "14.11")),
        ((Standards.CAEM2005, "18.10"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "18.10.0"), (Standards.CAEM2009, "14.11")),
        ((Standards.CAEM2005, "18.10.0"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "18.2"), (Standards.CAEM2009, "14.1")),
        ((Standards.CAEM2005, "18.2"), (Standards.CAEM2009, "32.9")),
        ((Standards.CAEM2005, "18.21"), (Standards.CAEM2009, "14.12")),
        ((Standards.CAEM2005, "18.21.0"), (Standards.CAEM2009, "14.12")),
        ((Standards.CAEM2005, "18.22"), (Standards.CAEM2009, "14.13")),
        ((Standards.CAEM2005, "18.22.0"), (Standards.CAEM2009, "14.13")),
        ((Standards.CAEM2005, "18.23"), (Standards.CAEM2009, "14.14")),
        ((Standards.CAEM2005, "18.23.0"), (Standards.CAEM2009, "14.14")),
        ((Standards.CAEM2005, "18.24"), (Standards.CAEM2009, "14.19")),
        ((Standards.CAEM2005, "18.24"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "18.24.1"), (Standards.CAEM2009, "14.19")),
        ((Standards.CAEM2005, "18.24.9"), (Standards.CAEM2009, "14.19")),
        ((Standards.CAEM2005, "18.24.9"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "18.3"), (Standards.CAEM2009, "13.2")),
        ((Standards.CAEM2005, "18.3"), (Standards.CAEM2009, "13.9")),
        ((Standards.CAEM2005, "18.3"), (Standards.CAEM2009, "14.2")),
        ((Standards.CAEM2005, "18.3"), (Standards.CAEM2009, "15.1")),
        ((Standards.CAEM2005, "18.30"), (Standards.CAEM2009, "13.20")),
        ((Standards.CAEM2005, "18.30"), (Standards.CAEM2009, "13.91")),
        ((Standards.CAEM2005, "18.30"), (Standards.CAEM2009, "14.20")),
        ((Standards.CAEM2005, "18.30"), (Standards.CAEM2009, "15.11")),
        ((Standards.CAEM2005, "18.30.1"), (Standards.CAEM2009, "15.11")),
        ((Standards.CAEM2005, "18.30.2"), (Standards.CAEM2009, "13.20")),
        ((Standards.CAEM2005, "18.30.2"), (Standards.CAEM2009, "13.91")),
        ((Standards.CAEM2005, "18.30.3"), (Standards.CAEM2009, "14.20")),
        ((Standards.CAEM2005, "19"), (Standards.CAEM2009, "15")),
        ((Standards.CAEM2005, "19"), (Standards.CAEM2009, "16")),
        ((Standards.CAEM2005, "19"), (Standards.CAEM2009, "22")),
        ((Standards.CAEM2005, "19"), (Standards.CAEM2009, "32")),
        ((Standards.CAEM2005, "19.1"), (Standards.CAEM2009, "15.1")),
        ((Standards.CAEM2005, "19.10"), (Standards.CAEM2009, "15.11")),
        ((Standards.CAEM2005, "19.10.1"), (Standards.CAEM2009, "15.11")),
        ((Standards.CAEM2005, "19.10.2"), (Standards.CAEM2009, "15.11")),
        ((Standards.CAEM2005, "19.2"), (Standards.CAEM2009, "15.1")),
        ((Standards.CAEM2005, "19.2"), (Standards.CAEM2009, "32.9")),
        ((Standards.CAEM2005, "19.20"), (Standards.CAEM2009, "15.12")),
        ((Standards.CAEM2005, "19.20"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "19.20.1"), (Standards.CAEM2009, "15.12")),
        ((Standards.CAEM2005, "19.20.1"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "19.20.2"), (Standards.CAEM2009, "15.12")),
        ((Standards.CAEM2005, "19.3"), (Standards.CAEM2009, "15.2")),
        ((Standards.CAEM2005, "19.3"), (Standards.CAEM2009, "16.2")),
        ((Standards.CAEM2005, "19.3"), (Standards.CAEM2009, "22.1")),
        ((Standards.CAEM2005, "19.3"), (Standards.CAEM2009, "22.2")),
        ((Standards.CAEM2005, "19.30"), (Standards.CAEM2009, "15.20")),
        ((Standards.CAEM2005, "19.30"), (Standards.CAEM2009, "16.29")),
        ((Standards.CAEM2005, "19.30"), (Standards.CAEM2009, "22.19")),
        ((Standards.CAEM2005, "19.30"), (Standards.CAEM2009, "22.29")),
        ((Standards.CAEM2005, "19.30.0"), (Standards.CAEM2009, "15.20")),
        ((Standards.CAEM2005, "19.30.0"), (Standards.CAEM2009, "16.29")),
        ((Standards.CAEM2005, "19.30.0"), (Standards.CAEM2009, "22.19")),
        ((Standards.CAEM2005, "19.30.0"), (Standards.CAEM2009, "22.29")),
        ((Standards.CAEM2005, "20"), (Standards.CAEM2009, "16")),
        ((Standards.CAEM2005, "20"), (Standards.CAEM2009, "32")),
        ((Standards.CAEM2005, "20"), (Standards.CAEM2009, "33")),
        ((Standards.CAEM2005, "20"), (Standards.CAEM2009, "41")),
        ((Standards.CAEM2005, "20"), (Standards.CAEM2009, "43")),
        ((Standards.CAEM2005, "20.1"), (Standards.CAEM2009, "16.1")),
        ((Standards.CAEM2005, "20.10"), (Standards.CAEM2009, "16.10")),
        ((Standards.CAEM2005, "20.10.1"), (Standards.CAEM2009, "16.10")),
        ((Standards.CAEM2005, "20.10.2"), (Standards.CAEM2009, "16.10")),
        ((Standards.CAEM2005, "20.10.3"), (Standards.CAEM2009, "16.10")),
        ((Standards.CAEM2005, "20.2"), (Standards.CAEM2009, "16.2")),
        ((Standards.CAEM2005, "20.20"), (Standards.CAEM2009, "16.21")),
        ((Standards.CAEM2005, "20.20.0"), (Standards.CAEM2009, "16.21")),
        ((Standards.CAEM2005, "20.3"), (Standards.CAEM2009, "16.2")),
        ((Standards.CAEM2005, "20.3"), (Standards.CAEM2009, "41.2")),
        ((Standards.CAEM2005, "20.3"), (Standards.CAEM2009, "43.3")),
        ((Standards.CAEM2005, "20.3"), (Standards.CAEM2009, "43.9")),
        ((Standards.CAEM2005, "20.30"), (Standards.CAEM2009, "16.22")),
        ((Standards.CAEM2005, "20.30"), (Standards.CAEM2009, "16.23")),
        ((Standards.CAEM2005, "20.30"), (Standards.CAEM2009, "41.20")),
        ((Standards.CAEM2005, "20.30"), (Standards.CAEM2009, "43.32")),
        ((Standards.CAEM2005, "20.30"), (Standards.CAEM2009, "43.91")),
        ((Standards.CAEM2005, "20.30.1"), (Standards.CAEM2009, "16.22")),
        ((Standards.CAEM2005, "20.30.1"), (Standards.CAEM2009, "16.23")),
        ((Standards.CAEM2005, "20.30.1"), (Standards.CAEM2009, "41.20")),
        ((Standards.CAEM2005, "20.30.1"), (Standards.CAEM2009, "43.91")),
        ((Standards.CAEM2005, "20.30.2"), (Standards.CAEM2009, "16.23")),
        ((Standards.CAEM2005, "20.30.2"), (Standards.CAEM2009, "41.20")),
        ((Standards.CAEM2005, "20.30.2"), (Standards.CAEM2009, "43.32")),
        ((Standards.CAEM2005, "20.30.3"), (Standards.CAEM2009, "16.23")),
        ((Standards.CAEM2005, "20.30.3"), (Standards.CAEM2009, "41.20")),
        ((Standards.CAEM2005, "20.4"), (Standards.CAEM2009, "16.2")),
        ((Standards.CAEM2005, "20.4"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "20.40"), (Standards.CAEM2009, "16.24")),
        ((Standards.CAEM2005, "20.40"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "20.40.0"), (Standards.CAEM2009, "16.24")),
        ((Standards.CAEM2005, "20.40.0"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "20.5"), (Standards.CAEM2009, "16.2")),
        ((Standards.CAEM2005, "20.5"), (Standards.CAEM2009, "32.9")),
        ((Standards.CAEM2005, "20.5"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "20.51"), (Standards.CAEM2009, "16.29")),
        ((Standards.CAEM2005, "20.51"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "20.51"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "20.51.1"), (Standards.CAEM2009, "16.29")),
        ((Standards.CAEM2005, "20.51.1"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "20.51.1"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "20.51.2"), (Standards.CAEM2009, "16.29")),
        ((Standards.CAEM2005, "20.51.2"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "20.52"), (Standards.CAEM2009, "16.29")),
        ((Standards.CAEM2005, "20.52"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "20.52.0"), (Standards.CAEM2009, "16.29")),
        ((Standards.CAEM2005, "20.52.0"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "21"), (Standards.CAEM2009, "17")),
        ((Standards.CAEM2005, "21"), (Standards.CAEM2009, "18")),
        ((Standards.CAEM2005, "21.1"), (Standards.CAEM2009, "17.1")),
        ((Standards.CAEM2005, "21.11"), (Standards.CAEM2009, "17.11")),
        ((Standards.CAEM2005, "21.11.0"), (Standards.CAEM2009, "17.11")),
        ((Standards.CAEM2005, "21.12"), (Standards.CAEM2009, "17.12")),
        ((Standards.CAEM2005, "21.12.0"), (Standards.CAEM2009, "17.12")),
        ((Standards.CAEM2005, "21.2"), (Standards.CAEM2009, "17.2")),
        ((Standards.CAEM2005, "21.2"), (Standards.CAEM2009, "18.1")),
        ((Standards.CAEM2005, "21.21"), (Standards.CAEM2009, "17.21")),
        ((Standards.CAEM2005, "21.21.1"), (Standards.CAEM2009, "17.21")),
        ((Standards.CAEM2005, "21.21.2"), (Standards.CAEM2009, "17.21")),
        ((Standards.CAEM2005, "21.22"), (Standards.CAEM2009, "17.22")),
        ((Standards.CAEM2005, "21.22"), (Standards.CAEM2009, "18.12")),
        ((Standards.CAEM2005, "21.22.0"), (Standards.CAEM2009, "17.22")),
        ((Standards.CAEM2005, "21.22.0"), (Standards.CAEM2009, "18.12")),
        ((Standards.CAEM2005, "21.23"), (Standards.CAEM2009, "17.23")),
        ((Standards.CAEM2005, "21.23.0"), (Standards.CAEM2009, "17.23")),
        ((Standards.CAEM2005, "21.24"), (Standards.CAEM2009, "17.24")),
        ((Standards.CAEM2005, "21.24.0"), (Standards.CAEM2009, "17.24")),
        ((Standards.CAEM2005, "21.25"), (Standards.CAEM2009, "17.29")),
        ((Standards.CAEM2005, "21.25"), (Standards.CAEM2009, "18.12")),
        ((Standards.CAEM2005, "21.25.0"), (Standards.CAEM2009, "17.29")),
        ((Standards.CAEM2005, "21.25.0"), (Standards.CAEM2009, "18.12")),
        ((Standards.CAEM2005, "22"), (Standards.CAEM2009, "17")),
        ((Standards.CAEM2005, "22"), (Standards.CAEM2009, "18")),
        ((Standards.CAEM2005, "22"), (Standards.CAEM2009, "32")),
        ((Standards.CAEM2005, "22"), (Standards.CAEM2009, "58")),
        ((Standards.CAEM2005, "22"), (Standards.CAEM2009, "59")),
        ((Standards.CAEM2005, "22.1"), (Standards.CAEM2009, "32.9")),
        ((Standards.CAEM2005, "22.1"), (Standards.CAEM2009, "58.1")),
        ((Standards.CAEM2005, "22.1"), (Standards.CAEM2009, "59.2")),
        ((Standards.CAEM2005, "22.11"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "22.11"), (Standards.CAEM2009, "58.11")),
        ((Standards.CAEM2005, "22.11"), (Standards.CAEM2009, "58.12")),
        ((Standards.CAEM2005, "22.11.0"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "22.11.0"), (Standards.CAEM2009, "58.11")),
        ((Standards.CAEM2005, "22.11.0"), (Standards.CAEM2009, "58.12")),
        ((Standards.CAEM2005, "22.12"), (Standards.CAEM2009, "58.13")),
        ((Standards.CAEM2005, "22.12.0"), (Standards.CAEM2009, "58.13")),
        ((Standards.CAEM2005, "22.13"), (Standards.CAEM2009, "58.14")),
        ((Standards.CAEM2005, "22.13.0"), (Standards.CAEM2009, "58.14")),
        ((Standards.CAEM2005, "22.14"), (Standards.CAEM2009, "59.20")),
        ((Standards.CAEM2005, "22.14.0"), (Standards.CAEM2009, "59.20")),
        ((Standards.CAEM2005, "22.15"), (Standards.CAEM2009, "58.19")),
        ((Standards.CAEM2005, "22.15.0"), (Standards.CAEM2009, "58.19")),
        ((Standards.CAEM2005, "22.2"), (Standards.CAEM2009, "17.2")),
        ((Standards.CAEM2005, "22.2"), (Standards.CAEM2009, "18.1")),
        ((Standards.CAEM2005, "22.2"), (Standards.CAEM2009, "58.1")),
        ((Standards.CAEM2005, "22.21"), (Standards.CAEM2009, "18.11")),
        ((Standards.CAEM2005, "22.21.0"), (Standards.CAEM2009, "18.11")),
        ((Standards.CAEM2005, "22.22"), (Standards.CAEM2009, "17.23")),
        ((Standards.CAEM2005, "22.22"), (Standards.CAEM2009, "18.12")),
        ((Standards.CAEM2005, "22.22"), (Standards.CAEM2009, "58.19")),
        ((Standards.CAEM2005, "22.22.0"), (Standards.CAEM2009, "17.23")),
        ((Standards.CAEM2005, "22.22.0"), (Standards.CAEM2009, "18.12")),
        ((Standards.CAEM2005, "22.22.0"), (Standards.CAEM2009, "58.19")),
        ((Standards.CAEM2005, "22.23"), (Standards.CAEM2009, "18.14")),
        ((Standards.CAEM2005, "22.23.0"), (Standards.CAEM2009, "18.14")),
        ((Standards.CAEM2005, "22.24"), (Standards.CAEM2009, "18.13")),
        ((Standards.CAEM2005, "22.24.0"), (Standards.CAEM2009, "18.13")),
        ((Standards.CAEM2005, "22.25"), (Standards.CAEM2009, "18.13")),
        ((Standards.CAEM2005, "22.25.0"), (Standards.CAEM2009, "18.13")),
        ((Standards.CAEM2005, "22.3"), (Standards.CAEM2009, "18.2")),
        ((Standards.CAEM2005, "22.31"), (Standards.CAEM2009, "18.20")),
        ((Standards.CAEM2005, "22.31.0"), (Standards.CAEM2009, "18.20")),
        ((Standards.CAEM2005, "22.32"), (Standards.CAEM2009, "18.20")),
        ((Standards.CAEM2005, "22.32.0"), (Standards.CAEM2009, "18.20")),
        ((Standards.CAEM2005, "22.33"), (Standards.CAEM2009, "18.20")),
        ((Standards.CAEM2005, "22.33.0"), (Standards.CAEM2009, "18.20")),
        ((Standards.CAEM2005, "23"), (Standards.CAEM2009, "19")),
        ((Standards.CAEM2005, "23"), (Standards.CAEM2009, "20")),
        ((Standards.CAEM2005, "23"), (Standards.CAEM2009, "21")),
        ((Standards.CAEM2005, "23"), (Standards.CAEM2009, "24")),
        ((Standards.CAEM2005, "23"), (Standards.CAEM2009, "38")),
        ((Standards.CAEM2005, "23.1"), (Standards.CAEM2009, "19.1")),
        ((Standards.CAEM2005, "23.10"), (Standards.CAEM2009, "19.10")),
        ((Standards.CAEM2005, "23.10.0"), (Standards.CAEM2009, "19.10")),
        ((Standards.CAEM2005, "23.2"), (Standards.CAEM2009, "19.2")),
        ((Standards.CAEM2005, "23.20"), (Standards.CAEM2009, "19.20")),
        ((Standards.CAEM2005, "23.20.0"), (Standards.CAEM2009, "19.20")),
        ((Standards.CAEM2005, "23.3"), (Standards.CAEM2009, "20.1")),
        ((Standards.CAEM2005, "23.3"), (Standards.CAEM2009, "21.2")),
        ((Standards.CAEM2005, "23.3"), (Standards.CAEM2009, "24.4")),
        ((Standards.CAEM2005, "23.3"), (Standards.CAEM2009, "38.1")),
        ((Standards.CAEM2005, "23.3"), (Standards.CAEM2009, "38.2")),
        ((Standards.CAEM2005, "23.30"), (Standards.CAEM2009, "20.13")),
        ((Standards.CAEM2005, "23.30"), (Standards.CAEM2009, "21.20")),
        ((Standards.CAEM2005, "23.30"), (Standards.CAEM2009, "24.46")),
        ((Standards.CAEM2005, "23.30"), (Standards.CAEM2009, "38.12")),
        ((Standards.CAEM2005, "23.30"), (Standards.CAEM2009, "38.22")),
        ((Standards.CAEM2005, "23.30.0"), (Standards.CAEM2009, "20.13")),
        ((Standards.CAEM2005, "23.30.0"), (Standards.CAEM2009, "21.20")),
        ((Standards.CAEM2005, "23.30.0"), (Standards.CAEM2009, "24.46")),
        ((Standards.CAEM2005, "23.30.0"), (Standards.CAEM2009, "38.12")),
        ((Standards.CAEM2005, "23.30.0"), (Standards.CAEM2009, "38.22")),
        ((Standards.CAEM2005, "24"), (Standards.CAEM2009, "19")),
        ((Standards.CAEM2005, "24"), (Standards.CAEM2009, "20")),
        ((Standards.CAEM2005, "24"), (Standards.CAEM2009, "21")),
        ((Standards.CAEM2005, "24"), (Standards.CAEM2009, "26")),
        ((Standards.CAEM2005, "24"), (Standards.CAEM2009, "32")),
        ((Standards.CAEM2005, "24"), (Standards.CAEM2009, "38")),
        ((Standards.CAEM2005, "24.1"), (Standards.CAEM2009, "19.1")),
        ((Standards.CAEM2005, "24.1"), (Standards.CAEM2009, "20.1")),
        ((Standards.CAEM2005, "24.1"), (Standards.CAEM2009, "38.2")),
        ((Standards.CAEM2005, "24.11"), (Standards.CAEM2009, "20.11")),
        ((Standards.CAEM2005, "24.11.0"), (Standards.CAEM2009, "20.11")),
        ((Standards.CAEM2005, "24.12"), (Standards.CAEM2009, "20.12")),
        ((Standards.CAEM2005, "24.12.0"), (Standards.CAEM2009, "20.12")),
        ((Standards.CAEM2005, "24.13"), (Standards.CAEM2009, "20.13")),
        ((Standards.CAEM2005, "24.13.0"), (Standards.CAEM2009, "20.13")),
        ((Standards.CAEM2005, "24.14"), (Standards.CAEM2009, "19.10")),
        ((Standards.CAEM2005, "24.14"), (Standards.CAEM2009, "20.14")),
        ((Standards.CAEM2005, "24.14.1"), (Standards.CAEM2009, "19.10")),
        ((Standards.CAEM2005, "24.14.1"), (Standards.CAEM2009, "20.14")),
        ((Standards.CAEM2005, "24.14.9"), (Standards.CAEM2009, "19.10")),
        ((Standards.CAEM2005, "24.14.9"), (Standards.CAEM2009, "20.14")),
        ((Standards.CAEM2005, "24.15"), (Standards.CAEM2009, "20.15")),
        ((Standards.CAEM2005, "24.15"), (Standards.CAEM2009, "38.21")),
        ((Standards.CAEM2005, "24.15.1"), (Standards.CAEM2009, "20.15")),
        ((Standards.CAEM2005, "24.15.1"), (Standards.CAEM2009, "38.21")),
        ((Standards.CAEM2005, "24.15.2"), (Standards.CAEM2009, "20.15")),
        ((Standards.CAEM2005, "24.15.2"), (Standards.CAEM2009, "38.21")),
        ((Standards.CAEM2005, "24.16"), (Standards.CAEM2009, "20.16")),
        ((Standards.CAEM2005, "24.16.0"), (Standards.CAEM2009, "20.16")),
        ((Standards.CAEM2005, "24.17"), (Standards.CAEM2009, "20.17")),
        ((Standards.CAEM2005, "24.17.0"), (Standards.CAEM2009, "20.17")),
        ((Standards.CAEM2005, "24.2"), (Standards.CAEM2009, "20.2")),
        ((Standards.CAEM2005, "24.20"), (Standards.CAEM2009, "20.20")),
        ((Standards.CAEM2005, "24.20.0"), (Standards.CAEM2009, "20.20")),
        ((Standards.CAEM2005, "24.3"), (Standards.CAEM2009, "20.3")),
        ((Standards.CAEM2005, "24.30"), (Standards.CAEM2009, "20.30")),
        ((Standards.CAEM2005, "24.30.1"), (Standards.CAEM2009, "20.30")),
        ((Standards.CAEM2005, "24.30.2"), (Standards.CAEM2009, "20.30")),
        ((Standards.CAEM2005, "24.4"), (Standards.CAEM2009, "21.1")),
        ((Standards.CAEM2005, "24.4"), (Standards.CAEM2009, "21.2")),
        ((Standards.CAEM2005, "24.4"), (Standards.CAEM2009, "32.5")),
        ((Standards.CAEM2005, "24.41"), (Standards.CAEM2009, "21.10")),
        ((Standards.CAEM2005, "24.41.0"), (Standards.CAEM2009, "21.10")),
        ((Standards.CAEM2005, "24.42"), (Standards.CAEM2009, "21.20")),
        ((Standards.CAEM2005, "24.42"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "24.42.1"), (Standards.CAEM2009, "21.20")),
        ((Standards.CAEM2005, "24.42.2"), (Standards.CAEM2009, "21.20")),
        ((Standards.CAEM2005, "24.42.3"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "24.5"), (Standards.CAEM2009, "20.4")),
        ((Standards.CAEM2005, "24.51"), (Standards.CAEM2009, "20.41")),
        ((Standards.CAEM2005, "24.51"), (Standards.CAEM2009, "20.42")),
        ((Standards.CAEM2005, "24.51.0"), (Standards.CAEM2009, "20.41")),
        ((Standards.CAEM2005, "24.51.0"), (Standards.CAEM2009, "20.42")),
        ((Standards.CAEM2005, "24.52"), (Standards.CAEM2009, "20.42")),
        ((Standards.CAEM2005, "24.52.0"), (Standards.CAEM2009, "20.42")),
        ((Standards.CAEM2005, "24.6"), (Standards.CAEM2009, "20.5")),
        ((Standards.CAEM2005, "24.6"), (Standards.CAEM2009, "26.1")),
        ((Standards.CAEM2005, "24.6"), (Standards.CAEM2009, "26.8")),
        ((Standards.CAEM2005, "24.61"), (Standards.CAEM2009, "20.51")),
        ((Standards.CAEM2005, "24.61.0"), (Standards.CAEM2009, "20.51")),
        ((Standards.CAEM2005, "24.62"), (Standards.CAEM2009, "20.52")),
        ((Standards.CAEM2005, "24.62"), (Standards.CAEM2009, "20.59")),
        ((Standards.CAEM2005, "24.62.0"), (Standards.CAEM2009, "20.52")),
        ((Standards.CAEM2005, "24.62.0"), (Standards.CAEM2009, "20.59")),
        ((Standards.CAEM2005, "24.63"), (Standards.CAEM2009, "20.53")),
        ((Standards.CAEM2005, "24.63.0"), (Standards.CAEM2009, "20.53")),
        ((Standards.CAEM2005, "24.64"), (Standards.CAEM2009, "20.59")),
        ((Standards.CAEM2005, "24.64.0"), (Standards.CAEM2009, "20.59")),
        ((Standards.CAEM2005, "24.65"), (Standards.CAEM2009, "26.80")),
        ((Standards.CAEM2005, "24.65.0"), (Standards.CAEM2009, "26.80")),
        ((Standards.CAEM2005, "24.66"), (Standards.CAEM2009, "20.59")),
        ((Standards.CAEM2005, "24.66"), (Standards.CAEM2009, "26.11")),
        ((Standards.CAEM2005, "24.66.1"), (Standards.CAEM2009, "20.59")),
        ((Standards.CAEM2005, "24.66.1"), (Standards.CAEM2009, "26.11")),
        ((Standards.CAEM2005, "24.66.2"), (Standards.CAEM2009, "20.59")),
        ((Standards.CAEM2005, "24.66.2"), (Standards.CAEM2009, "26.11")),
        ((Standards.CAEM2005, "24.66.9"), (Standards.CAEM2009, "20.59")),
        ((Standards.CAEM2005, "24.66.9"), (Standards.CAEM2009, "26.11")),
        ((Standards.CAEM2005, "24.7"), (Standards.CAEM2009, "20.6")),
        ((Standards.CAEM2005, "24.70"), (Standards.CAEM2009, "20.60")),
        ((Standards.CAEM2005, "24.70.0"), (Standards.CAEM2009, "20.60")),
        ((Standards.CAEM2005, "25"), (Standards.CAEM2009, "22")),
        ((Standards.CAEM2005, "25"), (Standards.CAEM2009, "27")),
        ((Standards.CAEM2005, "25"), (Standards.CAEM2009, "32")),
        ((Standards.CAEM2005, "25"), (Standards.CAEM2009, "33")),
        ((Standards.CAEM2005, "25"), (Standards.CAEM2009, "41")),
        ((Standards.CAEM2005, "25.1"), (Standards.CAEM2009, "22.1")),
        ((Standards.CAEM2005, "25.1"), (Standards.CAEM2009, "32.5")),
        ((Standards.CAEM2005, "25.1"), (Standards.CAEM2009, "32.9")),
        ((Standards.CAEM2005, "25.1"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "25.11"), (Standards.CAEM2009, "22.11")),
        ((Standards.CAEM2005, "25.11.0"), (Standards.CAEM2009, "22.11")),
        ((Standards.CAEM2005, "25.12"), (Standards.CAEM2009, "22.11")),
        ((Standards.CAEM2005, "25.12.0"), (Standards.CAEM2009, "22.11")),
        ((Standards.CAEM2005, "25.13"), (Standards.CAEM2009, "22.19")),
        ((Standards.CAEM2005, "25.13"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "25.13"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "25.13"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "25.13.1"), (Standards.CAEM2009, "22.19")),
        ((Standards.CAEM2005, "25.13.1"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "25.13.1"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "25.13.1"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "25.13.2"), (Standards.CAEM2009, "22.19")),
        ((Standards.CAEM2005, "25.13.2"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "25.2"), (Standards.CAEM2009, "22.2")),
        ((Standards.CAEM2005, "25.2"), (Standards.CAEM2009, "27.3")),
        ((Standards.CAEM2005, "25.2"), (Standards.CAEM2009, "32.9")),
        ((Standards.CAEM2005, "25.2"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "25.2"), (Standards.CAEM2009, "33.2")),
        ((Standards.CAEM2005, "25.2"), (Standards.CAEM2009, "41.2")),
        ((Standards.CAEM2005, "25.2"), (Standards.CAEM2009, "43.3")),
        ((Standards.CAEM2005, "25.21"), (Standards.CAEM2009, "22.21")),
        ((Standards.CAEM2005, "25.21"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "25.21"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "25.21.0"), (Standards.CAEM2009, "22.21")),
        ((Standards.CAEM2005, "25.21.0"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "25.21.0"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "25.22"), (Standards.CAEM2009, "22.22")),
        ((Standards.CAEM2005, "25.22.0"), (Standards.CAEM2009, "22.22")),
        ((Standards.CAEM2005, "25.23"), (Standards.CAEM2009, "22.23")),
        ((Standards.CAEM2005, "25.23"), (Standards.CAEM2009, "27.33")),
        ((Standards.CAEM2005, "25.23"), (Standards.CAEM2009, "41.20")),
        ((Standards.CAEM2005, "25.23"), (Standards.CAEM2009, "43.32")),
        ((Standards.CAEM2005, "25.23.0"), (Standards.CAEM2009, "22.23")),
        ((Standards.CAEM2005, "25.23.0"), (Standards.CAEM2009, "27.33")),
        ((Standards.CAEM2005, "25.23.0"), (Standards.CAEM2009, "41.20")),
        ((Standards.CAEM2005, "25.23.0"), (Standards.CAEM2009, "43.32")),
        ((Standards.CAEM2005, "25.24"), (Standards.CAEM2009, "22.29")),
        ((Standards.CAEM2005, "25.24"), (Standards.CAEM2009, "27.33")),
        ((Standards.CAEM2005, "25.24"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "25.24"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "25.24.0"), (Standards.CAEM2009, "22.29")),
        ((Standards.CAEM2005, "25.24.0"), (Standards.CAEM2009, "27.33")),
        ((Standards.CAEM2005, "25.24.0"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "25.24.0"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "26"), (Standards.CAEM2009, "23")),
        ((Standards.CAEM2005, "26"), (Standards.CAEM2009, "33")),
        ((Standards.CAEM2005, "26.1"), (Standards.CAEM2009, "23.1")),
        ((Standards.CAEM2005, "26.1"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "26.1"), (Standards.CAEM2009, "33.2")),
        ((Standards.CAEM2005, "26.11"), (Standards.CAEM2009, "23.11")),
        ((Standards.CAEM2005, "26.11.0"), (Standards.CAEM2009, "23.11")),
        ((Standards.CAEM2005, "26.12"), (Standards.CAEM2009, "23.12")),
        ((Standards.CAEM2005, "26.12.0"), (Standards.CAEM2009, "23.12")),
        ((Standards.CAEM2005, "26.13"), (Standards.CAEM2009, "23.13")),
        ((Standards.CAEM2005, "26.13.1"), (Standards.CAEM2009, "23.13")),
        ((Standards.CAEM2005, "26.13.2"), (Standards.CAEM2009, "23.13")),
        ((Standards.CAEM2005, "26.14"), (Standards.CAEM2009, "23.14")),
        ((Standards.CAEM2005, "26.14.0"), (Standards.CAEM2009, "23.14")),
        ((Standards.CAEM2005, "26.15"), (Standards.CAEM2009, "23.19")),
        ((Standards.CAEM2005, "26.15"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "26.15"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "26.15.1"), (Standards.CAEM2009, "23.19")),
        ((Standards.CAEM2005, "26.15.1"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "26.15.1"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "26.15.2"), (Standards.CAEM2009, "23.19")),
        ((Standards.CAEM2005, "26.15.2"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "26.15.2"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "26.15.9"), (Standards.CAEM2009, "23.19")),
        ((Standards.CAEM2005, "26.15.9"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "26.15.9"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "26.2"), (Standards.CAEM2009, "23.2")),
        ((Standards.CAEM2005, "26.2"), (Standards.CAEM2009, "23.4")),
        ((Standards.CAEM2005, "26.21"), (Standards.CAEM2009, "23.41")),
        ((Standards.CAEM2005, "26.21.1"), (Standards.CAEM2009, "23.41")),
        ((Standards.CAEM2005, "26.21.2"), (Standards.CAEM2009, "23.41")),
        ((Standards.CAEM2005, "26.22"), (Standards.CAEM2009, "23.42")),
        ((Standards.CAEM2005, "26.22.0"), (Standards.CAEM2009, "23.42")),
        ((Standards.CAEM2005, "26.23"), (Standards.CAEM2009, "23.43")),
        ((Standards.CAEM2005, "26.23.0"), (Standards.CAEM2009, "23.43")),
        ((Standards.CAEM2005, "26.24"), (Standards.CAEM2009, "23.44")),
        ((Standards.CAEM2005, "26.24.0"), (Standards.CAEM2009, "23.44")),
        ((Standards.CAEM2005, "26.25"), (Standards.CAEM2009, "23.49")),
        ((Standards.CAEM2005, "26.25.0"), (Standards.CAEM2009, "23.49")),
        ((Standards.CAEM2005, "26.26"), (Standards.CAEM2009, "23.20")),
        ((Standards.CAEM2005, "26.26.0"), (Standards.CAEM2009, "23.20")),
        ((Standards.CAEM2005, "26.3"), (Standards.CAEM2009, "23.3")),
        ((Standards.CAEM2005, "26.30"), (Standards.CAEM2009, "23.31")),
        ((Standards.CAEM2005, "26.30.0"), (Standards.CAEM2009, "23.31")),
        ((Standards.CAEM2005, "26.4"), (Standards.CAEM2009, "23.3")),
        ((Standards.CAEM2005, "26.4"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "26.4"), (Standards.CAEM2009, "33.2")),
        ((Standards.CAEM2005, "26.40"), (Standards.CAEM2009, "23.32")),
        ((Standards.CAEM2005, "26.40"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "26.40"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "26.40.0"), (Standards.CAEM2009, "23.32")),
        ((Standards.CAEM2005, "26.40.0"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "26.40.0"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "26.5"), (Standards.CAEM2009, "23.5")),
        ((Standards.CAEM2005, "26.51"), (Standards.CAEM2009, "23.51")),
        ((Standards.CAEM2005, "26.51.0"), (Standards.CAEM2009, "23.51")),
        ((Standards.CAEM2005, "26.52"), (Standards.CAEM2009, "23.52")),
        ((Standards.CAEM2005, "26.52.1"), (Standards.CAEM2009, "23.52")),
        ((Standards.CAEM2005, "26.52.2"), (Standards.CAEM2009, "23.52")),
        ((Standards.CAEM2005, "26.53"), (Standards.CAEM2009, "23.52")),
        ((Standards.CAEM2005, "26.53.0"), (Standards.CAEM2009, "23.52")),
        ((Standards.CAEM2005, "26.6"), (Standards.CAEM2009, "23.6")),
        ((Standards.CAEM2005, "26.61"), (Standards.CAEM2009, "23.61")),
        ((Standards.CAEM2005, "26.61.1"), (Standards.CAEM2009, "23.61")),
        ((Standards.CAEM2005, "26.61.2"), (Standards.CAEM2009, "23.61")),
        ((Standards.CAEM2005, "26.61.3"), (Standards.CAEM2009, "23.61")),
        ((Standards.CAEM2005, "26.62"), (Standards.CAEM2009, "23.62")),
        ((Standards.CAEM2005, "26.62.0"), (Standards.CAEM2009, "23.62")),
        ((Standards.CAEM2005, "26.63"), (Standards.CAEM2009, "23.63")),
        ((Standards.CAEM2005, "26.63.1"), (Standards.CAEM2009, "23.63")),
        ((Standards.CAEM2005, "26.63.2"), (Standards.CAEM2009, "23.63")),
        ((Standards.CAEM2005, "26.64"), (Standards.CAEM2009, "23.64")),
        ((Standards.CAEM2005, "26.64.0"), (Standards.CAEM2009, "23.64")),
        ((Standards.CAEM2005, "26.65"), (Standards.CAEM2009, "23.65")),
        ((Standards.CAEM2005, "26.65.0"), (Standards.CAEM2009, "23.65")),
        ((Standards.CAEM2005, "26.66"), (Standards.CAEM2009, "23.69")),
        ((Standards.CAEM2005, "26.66.0"), (Standards.CAEM2009, "23.69")),
        ((Standards.CAEM2005, "26.7"), (Standards.CAEM2009, "23.7")),
        ((Standards.CAEM2005, "26.70"), (Standards.CAEM2009, "23.70")),
        ((Standards.CAEM2005, "26.70.0"), (Standards.CAEM2009, "23.70")),
        ((Standards.CAEM2005, "26.8"), (Standards.CAEM2009, "23.9")),
        ((Standards.CAEM2005, "26.8"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "26.8"), (Standards.CAEM2009, "33.2")),
        ((Standards.CAEM2005, "26.81"), (Standards.CAEM2009, "23.91")),
        ((Standards.CAEM2005, "26.81"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "26.81"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "26.81.0"), (Standards.CAEM2009, "23.91")),
        ((Standards.CAEM2005, "26.81.0"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "26.81.0"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "26.82"), (Standards.CAEM2009, "23.99")),
        ((Standards.CAEM2005, "26.82.1"), (Standards.CAEM2009, "23.99")),
        ((Standards.CAEM2005, "26.82.2"), (Standards.CAEM2009, "23.99")),
        ((Standards.CAEM2005, "26.82.3"), (Standards.CAEM2009, "23.99")),
        ((Standards.CAEM2005, "26.82.4"), (Standards.CAEM2009, "23.99")),
        ((Standards.CAEM2005, "26.82.5"), (Standards.CAEM2009, "23.99")),
        ((Standards.CAEM2005, "26.82.6"), (Standards.CAEM2009, "23.99")),
        ((Standards.CAEM2005, "27"), (Standards.CAEM2009, "24")),
        ((Standards.CAEM2005, "27"), (Standards.CAEM2009, "33")),
        ((Standards.CAEM2005, "27.1"), (Standards.CAEM2009, "24.1")),
        ((Standards.CAEM2005, "27.10"), (Standards.CAEM2009, "24.10")),
        ((Standards.CAEM2005, "27.10.0"), (Standards.CAEM2009, "24.10")),
        ((Standards.CAEM2005, "27.2"), (Standards.CAEM2009, "24.2")),
        ((Standards.CAEM2005, "27.2"), (Standards.CAEM2009, "24.5")),
        ((Standards.CAEM2005, "27.21"), (Standards.CAEM2009, "24.51")),
        ((Standards.CAEM2005, "27.21.0"), (Standards.CAEM2009, "24.51")),
        ((Standards.CAEM2005, "27.22"), (Standards.CAEM2009, "24.20")),
        ((Standards.CAEM2005, "27.22.0"), (Standards.CAEM2009, "24.20")),
        ((Standards.CAEM2005, "27.3"), (Standards.CAEM2009, "24.3")),
        ((Standards.CAEM2005, "27.31"), (Standards.CAEM2009, "24.31")),
        ((Standards.CAEM2005, "27.31.0"), (Standards.CAEM2009, "24.31")),
        ((Standards.CAEM2005, "27.32"), (Standards.CAEM2009, "24.32")),
        ((Standards.CAEM2005, "27.32.0"), (Standards.CAEM2009, "24.32")),
        ((Standards.CAEM2005, "27.33"), (Standards.CAEM2009, "24.33")),
        ((Standards.CAEM2005, "27.33.0"), (Standards.CAEM2009, "24.33")),
        ((Standards.CAEM2005, "27.34"), (Standards.CAEM2009, "24.34")),
        ((Standards.CAEM2005, "27.34.0"), (Standards.CAEM2009, "24.34")),
        ((Standards.CAEM2005, "27.4"), (Standards.CAEM2009, "24.4")),
        ((Standards.CAEM2005, "27.41"), (Standards.CAEM2009, "24.41")),
        ((Standards.CAEM2005, "27.41.0"), (Standards.CAEM2009, "24.41")),
        ((Standards.CAEM2005, "27.42"), (Standards.CAEM2009, "24.42")),
        ((Standards.CAEM2005, "27.42.0"), (Standards.CAEM2009, "24.42")),
        ((Standards.CAEM2005, "27.43"), (Standards.CAEM2009, "24.43")),
        ((Standards.CAEM2005, "27.43.0"), (Standards.CAEM2009, "24.43")),
        ((Standards.CAEM2005, "27.44"), (Standards.CAEM2009, "24.44")),
        ((Standards.CAEM2005, "27.44.0"), (Standards.CAEM2009, "24.44")),
        ((Standards.CAEM2005, "27.45"), (Standards.CAEM2009, "24.45")),
        ((Standards.CAEM2005, "27.45.1"), (Standards.CAEM2009, "24.45")),
        ((Standards.CAEM2005, "27.45.2"), (Standards.CAEM2009, "24.45")),
        ((Standards.CAEM2005, "27.45.3"), (Standards.CAEM2009, "24.45")),
        ((Standards.CAEM2005, "27.45.4"), (Standards.CAEM2009, "24.45")),
        ((Standards.CAEM2005, "27.45.5"), (Standards.CAEM2009, "24.45")),
        ((Standards.CAEM2005, "27.5"), (Standards.CAEM2009, "24.5")),
        ((Standards.CAEM2005, "27.51"), (Standards.CAEM2009, "24.51")),
        ((Standards.CAEM2005, "27.51.0"), (Standards.CAEM2009, "24.51")),
        ((Standards.CAEM2005, "27.52"), (Standards.CAEM2009, "24.52")),
        ((Standards.CAEM2005, "27.52.0"), (Standards.CAEM2009, "24.52")),
        ((Standards.CAEM2005, "27.53"), (Standards.CAEM2009, "24.53")),
        ((Standards.CAEM2005, "27.53.0"), (Standards.CAEM2009, "24.53")),
        ((Standards.CAEM2005, "27.54"), (Standards.CAEM2009, "24.54")),
        ((Standards.CAEM2005, "27.54.0"), (Standards.CAEM2009, "24.54")),
        ((Standards.CAEM2005, "28"), (Standards.CAEM2009, "24")),
        ((Standards.CAEM2005, "28"), (Standards.CAEM2009, "25")),
        ((Standards.CAEM2005, "28"), (Standards.CAEM2009, "28")),
        ((Standards.CAEM2005, "28"), (Standards.CAEM2009, "28.1")),
        ((Standards.CAEM2005, "28"), (Standards.CAEM2009, "32")),
        ((Standards.CAEM2005, "28"), (Standards.CAEM2009, "33")),
        ((Standards.CAEM2005, "28"), (Standards.CAEM2009, "33.2")),
        ((Standards.CAEM2005, "28"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "28"), (Standards.CAEM2009, "41")),
        ((Standards.CAEM2005, "28"), (Standards.CAEM2009, "43")),
        ((Standards.CAEM2005, "28.1"), (Standards.CAEM2009, "24.3")),
        ((Standards.CAEM2005, "28.1"), (Standards.CAEM2009, "25.1")),
        ((Standards.CAEM2005, "28.1"), (Standards.CAEM2009, "28")),
        ((Standards.CAEM2005, "28.1"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "28.1"), (Standards.CAEM2009, "41.2")),
        ((Standards.CAEM2005, "28.1"), (Standards.CAEM2009, "43.3")),
        ((Standards.CAEM2005, "28.11"), (Standards.CAEM2009, "24.33")),
        ((Standards.CAEM2005, "28.11"), (Standards.CAEM2009, "25.11")),
        ((Standards.CAEM2005, "28.11"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "28.11"), (Standards.CAEM2009, "41.20")),
        ((Standards.CAEM2005, "28.11.1"), (Standards.CAEM2009, "24.33")),
        ((Standards.CAEM2005, "28.11.1"), (Standards.CAEM2009, "25.11")),
        ((Standards.CAEM2005, "28.11.1"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "28.11.2"), (Standards.CAEM2009, "24.33")),
        ((Standards.CAEM2005, "28.11.2"), (Standards.CAEM2009, "25.11")),
        ((Standards.CAEM2005, "28.11.2"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "28.11.3"), (Standards.CAEM2009, "24.33")),
        ((Standards.CAEM2005, "28.11.3"), (Standards.CAEM2009, "25.11")),
        ((Standards.CAEM2005, "28.11.3"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "28.11.4"), (Standards.CAEM2009, "24.33")),
        ((Standards.CAEM2005, "28.11.4"), (Standards.CAEM2009, "25.11")),
        ((Standards.CAEM2005, "28.11.4"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "28.11.4"), (Standards.CAEM2009, "41.20")),
        ((Standards.CAEM2005, "28.12"), (Standards.CAEM2009, "25.12")),
        ((Standards.CAEM2005, "28.12"), (Standards.CAEM2009, "43.32")),
        ((Standards.CAEM2005, "28.12.0"), (Standards.CAEM2009, "25.12")),
        ((Standards.CAEM2005, "28.12.0"), (Standards.CAEM2009, "43.32")),
        ((Standards.CAEM2005, "28.2"), (Standards.CAEM2009, "25.2")),
        ((Standards.CAEM2005, "28.2"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "28.21"), (Standards.CAEM2009, "25.29")),
        ((Standards.CAEM2005, "28.21"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "28.21.0"), (Standards.CAEM2009, "25.29")),
        ((Standards.CAEM2005, "28.21.0"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "28.22"), (Standards.CAEM2009, "25.21")),
        ((Standards.CAEM2005, "28.22"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "28.22.0"), (Standards.CAEM2009, "25.21")),
        ((Standards.CAEM2005, "28.22.0"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "28.3"), (Standards.CAEM2009, "25.3")),
        ((Standards.CAEM2005, "28.3"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "28.30"), (Standards.CAEM2009, "25.30")),
        ((Standards.CAEM2005, "28.30"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "28.30.0"), (Standards.CAEM2009, "25.30")),
        ((Standards.CAEM2005, "28.30.0"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "28.4"), (Standards.CAEM2009, "25.5")),
        ((Standards.CAEM2005, "28.40"), (Standards.CAEM2009, "25.50")),
        ((Standards.CAEM2005, "28.40.1"), (Standards.CAEM2009, "25.50")),
        ((Standards.CAEM2005, "28.40.2"), (Standards.CAEM2009, "25.50")),
        ((Standards.CAEM2005, "28.5"), (Standards.CAEM2009, "25.6")),
        ((Standards.CAEM2005, "28.5"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "28.51"), (Standards.CAEM2009, "25.61")),
        ((Standards.CAEM2005, "28.51.0"), (Standards.CAEM2009, "25.61")),
        ((Standards.CAEM2005, "28.52"), (Standards.CAEM2009, "25.62")),
        ((Standards.CAEM2005, "28.52"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "28.52.0"), (Standards.CAEM2009, "25.62")),
        ((Standards.CAEM2005, "28.52.0"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "28.6"), (Standards.CAEM2009, "25.7")),
        ((Standards.CAEM2005, "28.6"), (Standards.CAEM2009, "28.4")),
        ((Standards.CAEM2005, "28.6"), (Standards.CAEM2009, "28.9")),
        ((Standards.CAEM2005, "28.6"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "28.61"), (Standards.CAEM2009, "25.71")),
        ((Standards.CAEM2005, "28.61"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "28.61.0"), (Standards.CAEM2009, "25.71")),
        ((Standards.CAEM2005, "28.61.0"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "28.62"), (Standards.CAEM2009, "25.73")),
        ((Standards.CAEM2005, "28.62"), (Standards.CAEM2009, "28.41")),
        ((Standards.CAEM2005, "28.62"), (Standards.CAEM2009, "28.49")),
        ((Standards.CAEM2005, "28.62"), (Standards.CAEM2009, "28.92")),
        ((Standards.CAEM2005, "28.62"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "28.62.1"), (Standards.CAEM2009, "25.73")),
        ((Standards.CAEM2005, "28.62.1"), (Standards.CAEM2009, "28.41")),
        ((Standards.CAEM2005, "28.62.1"), (Standards.CAEM2009, "28.49")),
        ((Standards.CAEM2005, "28.62.1"), (Standards.CAEM2009, "28.92")),
        ((Standards.CAEM2005, "28.62.1"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "28.62.2"), (Standards.CAEM2009, "25.73")),
        ((Standards.CAEM2005, "28.62.2"), (Standards.CAEM2009, "28.49")),
        ((Standards.CAEM2005, "28.62.2"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "28.63"), (Standards.CAEM2009, "25.72")),
        ((Standards.CAEM2005, "28.63"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "28.63.0"), (Standards.CAEM2009, "25.72")),
        ((Standards.CAEM2005, "28.63.0"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "28.7"), (Standards.CAEM2009, "25.7")),
        ((Standards.CAEM2005, "28.7"), (Standards.CAEM2009, "25.9")),
        ((Standards.CAEM2005, "28.7"), (Standards.CAEM2009, "32.9")),
        ((Standards.CAEM2005, "28.7"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "28.71"), (Standards.CAEM2009, "25.91")),
        ((Standards.CAEM2005, "28.71"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "28.71.0"), (Standards.CAEM2009, "25.91")),
        ((Standards.CAEM2005, "28.71.0"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "28.72"), (Standards.CAEM2009, "25.92")),
        ((Standards.CAEM2005, "28.72.0"), (Standards.CAEM2009, "25.92")),
        ((Standards.CAEM2005, "28.73"), (Standards.CAEM2009, "25.93")),
        ((Standards.CAEM2005, "28.73.0"), (Standards.CAEM2009, "25.93")),
        ((Standards.CAEM2005, "28.74"), (Standards.CAEM2009, "25.93")),
        ((Standards.CAEM2005, "28.74"), (Standards.CAEM2009, "25.94")),
        ((Standards.CAEM2005, "28.74.0"), (Standards.CAEM2009, "25.93")),
        ((Standards.CAEM2005, "28.74.0"), (Standards.CAEM2009, "25.94")),
        ((Standards.CAEM2005, "28.75"), (Standards.CAEM2009, "25.71")),
        ((Standards.CAEM2005, "28.75"), (Standards.CAEM2009, "25.99")),
        ((Standards.CAEM2005, "28.75"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "28.75"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "28.75.1"), (Standards.CAEM2009, "25.99")),
        ((Standards.CAEM2005, "28.75.1"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "28.75.2"), (Standards.CAEM2009, "25.99")),
        ((Standards.CAEM2005, "28.75.2"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "28.75.9"), (Standards.CAEM2009, "25.71")),
        ((Standards.CAEM2005, "28.75.9"), (Standards.CAEM2009, "25.99")),
        ((Standards.CAEM2005, "28.75.9"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "29"), (Standards.CAEM2009, "25")),
        ((Standards.CAEM2005, "29"), (Standards.CAEM2009, "27")),
        ((Standards.CAEM2005, "29"), (Standards.CAEM2009, "28")),
        ((Standards.CAEM2005, "29"), (Standards.CAEM2009, "30")),
        ((Standards.CAEM2005, "29"), (Standards.CAEM2009, "32")),
        ((Standards.CAEM2005, "29"), (Standards.CAEM2009, "33")),
        ((Standards.CAEM2005, "29"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "29"), (Standards.CAEM2009, "43")),
        ((Standards.CAEM2005, "29"), (Standards.CAEM2009, "95")),
        ((Standards.CAEM2005, "29.1"), (Standards.CAEM2009, "28.1")),
        ((Standards.CAEM2005, "29.1"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "29.1"), (Standards.CAEM2009, "33.2")),
        ((Standards.CAEM2005, "29.1"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "29.11"), (Standards.CAEM2009, "28.11")),
        ((Standards.CAEM2005, "29.11"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.11.1"), (Standards.CAEM2009, "28.11")),
        ((Standards.CAEM2005, "29.11.2"), (Standards.CAEM2009, "28.11")),
        ((Standards.CAEM2005, "29.11.9"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.12"), (Standards.CAEM2009, "28.11")),
        ((Standards.CAEM2005, "29.12"), (Standards.CAEM2009, "28.12")),
        ((Standards.CAEM2005, "29.12"), (Standards.CAEM2009, "28.13")),
        ((Standards.CAEM2005, "29.12"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.12.1"), (Standards.CAEM2009, "28.12")),
        ((Standards.CAEM2005, "29.12.2"), (Standards.CAEM2009, "28.11")),
        ((Standards.CAEM2005, "29.12.2"), (Standards.CAEM2009, "28.13")),
        ((Standards.CAEM2005, "29.12.3"), (Standards.CAEM2009, "28.13")),
        ((Standards.CAEM2005, "29.12.9"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.13"), (Standards.CAEM2009, "28.12")),
        ((Standards.CAEM2005, "29.13"), (Standards.CAEM2009, "28.14")),
        ((Standards.CAEM2005, "29.13"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.13.0"), (Standards.CAEM2009, "28.12")),
        ((Standards.CAEM2005, "29.13.0"), (Standards.CAEM2009, "28.14")),
        ((Standards.CAEM2005, "29.13.0"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.14"), (Standards.CAEM2009, "28.15")),
        ((Standards.CAEM2005, "29.14"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.14.1"), (Standards.CAEM2009, "28.15")),
        ((Standards.CAEM2005, "29.14.2"), (Standards.CAEM2009, "28.15")),
        ((Standards.CAEM2005, "29.14.9"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.2"), (Standards.CAEM2009, "28.2")),
        ((Standards.CAEM2005, "29.2"), (Standards.CAEM2009, "32.5")),
        ((Standards.CAEM2005, "29.2"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "29.2"), (Standards.CAEM2009, "33.2")),
        ((Standards.CAEM2005, "29.2"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "29.2"), (Standards.CAEM2009, "43.2")),
        ((Standards.CAEM2005, "29.21"), (Standards.CAEM2009, "28.21")),
        ((Standards.CAEM2005, "29.21"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.21.1"), (Standards.CAEM2009, "28.21")),
        ((Standards.CAEM2005, "29.21.2"), (Standards.CAEM2009, "28.21")),
        ((Standards.CAEM2005, "29.21.9"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.22"), (Standards.CAEM2009, "28.22")),
        ((Standards.CAEM2005, "29.22"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.22"), (Standards.CAEM2009, "43.29")),
        ((Standards.CAEM2005, "29.22.1"), (Standards.CAEM2009, "28.22")),
        ((Standards.CAEM2005, "29.22.2"), (Standards.CAEM2009, "28.22")),
        ((Standards.CAEM2005, "29.22.3"), (Standards.CAEM2009, "28.22")),
        ((Standards.CAEM2005, "29.22.4"), (Standards.CAEM2009, "28.22")),
        ((Standards.CAEM2005, "29.22.5"), (Standards.CAEM2009, "28.22")),
        ((Standards.CAEM2005, "29.22.6"), (Standards.CAEM2009, "28.22")),
        ((Standards.CAEM2005, "29.22.9"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.22.9"), (Standards.CAEM2009, "43.29")),
        ((Standards.CAEM2005, "29.23"), (Standards.CAEM2009, "28.25")),
        ((Standards.CAEM2005, "29.23"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.23.1"), (Standards.CAEM2009, "28.25")),
        ((Standards.CAEM2005, "29.23.2"), (Standards.CAEM2009, "28.25")),
        ((Standards.CAEM2005, "29.23.9"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.24"), (Standards.CAEM2009, "28.29")),
        ((Standards.CAEM2005, "29.24"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "29.24"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.24"), (Standards.CAEM2009, "33.13")),
        ((Standards.CAEM2005, "29.24.1"), (Standards.CAEM2009, "28.29")),
        ((Standards.CAEM2005, "29.24.1"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "29.24.2"), (Standards.CAEM2009, "28.29")),
        ((Standards.CAEM2005, "29.24.2"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "29.24.3"), (Standards.CAEM2009, "28.29")),
        ((Standards.CAEM2005, "29.24.3"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "29.24.4"), (Standards.CAEM2009, "28.29")),
        ((Standards.CAEM2005, "29.24.4"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "29.24.5"), (Standards.CAEM2009, "28.29")),
        ((Standards.CAEM2005, "29.24.5"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "29.24.8"), (Standards.CAEM2009, "28.29")),
        ((Standards.CAEM2005, "29.24.8"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "29.24.9"), (Standards.CAEM2009, "28.29")),
        ((Standards.CAEM2005, "29.24.9"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "29.24.9"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.24.9"), (Standards.CAEM2009, "33.13")),
        ((Standards.CAEM2005, "29.3"), (Standards.CAEM2009, "28.3")),
        ((Standards.CAEM2005, "29.3"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "29.3"), (Standards.CAEM2009, "95.2")),
        ((Standards.CAEM2005, "29.31"), (Standards.CAEM2009, "28.30")),
        ((Standards.CAEM2005, "29.31"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.31.1"), (Standards.CAEM2009, "28.30")),
        ((Standards.CAEM2005, "29.31.9"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.32"), (Standards.CAEM2009, "28.30")),
        ((Standards.CAEM2005, "29.32"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.32"), (Standards.CAEM2009, "95.22")),
        ((Standards.CAEM2005, "29.32.1"), (Standards.CAEM2009, "28.30")),
        ((Standards.CAEM2005, "29.32.2"), (Standards.CAEM2009, "28.30")),
        ((Standards.CAEM2005, "29.32.3"), (Standards.CAEM2009, "28.30")),
        ((Standards.CAEM2005, "29.32.9"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.32.9"), (Standards.CAEM2009, "95.22")),
        ((Standards.CAEM2005, "29.4"), (Standards.CAEM2009, "27.9")),
        ((Standards.CAEM2005, "29.4"), (Standards.CAEM2009, "28.2")),
        ((Standards.CAEM2005, "29.4"), (Standards.CAEM2009, "28.4")),
        ((Standards.CAEM2005, "29.4"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "29.41"), (Standards.CAEM2009, "28.24")),
        ((Standards.CAEM2005, "29.41"), (Standards.CAEM2009, "28.41")),
        ((Standards.CAEM2005, "29.41"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.41.0"), (Standards.CAEM2009, "28.24")),
        ((Standards.CAEM2005, "29.41.0"), (Standards.CAEM2009, "28.41")),
        ((Standards.CAEM2005, "29.41.0"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.42"), (Standards.CAEM2009, "28.41")),
        ((Standards.CAEM2005, "29.42"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.42.0"), (Standards.CAEM2009, "28.41")),
        ((Standards.CAEM2005, "29.42.0"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.43"), (Standards.CAEM2009, "27.90")),
        ((Standards.CAEM2005, "29.43"), (Standards.CAEM2009, "28.29")),
        ((Standards.CAEM2005, "29.43"), (Standards.CAEM2009, "28.41")),
        ((Standards.CAEM2005, "29.43"), (Standards.CAEM2009, "28.49")),
        ((Standards.CAEM2005, "29.43"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.43.0"), (Standards.CAEM2009, "27.90")),
        ((Standards.CAEM2005, "29.43.0"), (Standards.CAEM2009, "28.29")),
        ((Standards.CAEM2005, "29.43.0"), (Standards.CAEM2009, "28.41")),
        ((Standards.CAEM2005, "29.43.0"), (Standards.CAEM2009, "28.49")),
        ((Standards.CAEM2005, "29.43.0"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.5"), (Standards.CAEM2009, "25.7")),
        ((Standards.CAEM2005, "29.5"), (Standards.CAEM2009, "28.3")),
        ((Standards.CAEM2005, "29.5"), (Standards.CAEM2009, "28.9")),
        ((Standards.CAEM2005, "29.5"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "29.51"), (Standards.CAEM2009, "28.91")),
        ((Standards.CAEM2005, "29.51"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.51.1"), (Standards.CAEM2009, "28.91")),
        ((Standards.CAEM2005, "29.51.9"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.52"), (Standards.CAEM2009, "28.92")),
        ((Standards.CAEM2005, "29.52"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.52.1"), (Standards.CAEM2009, "28.92")),
        ((Standards.CAEM2005, "29.52.2"), (Standards.CAEM2009, "28.92")),
        ((Standards.CAEM2005, "29.52.3"), (Standards.CAEM2009, "28.92")),
        ((Standards.CAEM2005, "29.52.4"), (Standards.CAEM2009, "28.92")),
        ((Standards.CAEM2005, "29.52.5"), (Standards.CAEM2009, "28.92")),
        ((Standards.CAEM2005, "29.52.9"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.53"), (Standards.CAEM2009, "28.30")),
        ((Standards.CAEM2005, "29.53"), (Standards.CAEM2009, "28.93")),
        ((Standards.CAEM2005, "29.53"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.53.1"), (Standards.CAEM2009, "28.30")),
        ((Standards.CAEM2005, "29.53.1"), (Standards.CAEM2009, "28.93")),
        ((Standards.CAEM2005, "29.53.9"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.54"), (Standards.CAEM2009, "28.94")),
        ((Standards.CAEM2005, "29.54"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.54.1"), (Standards.CAEM2009, "28.94")),
        ((Standards.CAEM2005, "29.54.2"), (Standards.CAEM2009, "28.94")),
        ((Standards.CAEM2005, "29.54.3"), (Standards.CAEM2009, "28.94")),
        ((Standards.CAEM2005, "29.54.4"), (Standards.CAEM2009, "28.94")),
        ((Standards.CAEM2005, "29.54.5"), (Standards.CAEM2009, "28.94")),
        ((Standards.CAEM2005, "29.54.9"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.55"), (Standards.CAEM2009, "28.95")),
        ((Standards.CAEM2005, "29.55"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.55.1"), (Standards.CAEM2009, "28.95")),
        ((Standards.CAEM2005, "29.55.9"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.56"), (Standards.CAEM2009, "25.73")),
        ((Standards.CAEM2005, "29.56"), (Standards.CAEM2009, "28.94")),
        ((Standards.CAEM2005, "29.56"), (Standards.CAEM2009, "28.96")),
        ((Standards.CAEM2005, "29.56"), (Standards.CAEM2009, "28.99")),
        ((Standards.CAEM2005, "29.56"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.56.1"), (Standards.CAEM2009, "28.99")),
        ((Standards.CAEM2005, "29.56.2"), (Standards.CAEM2009, "28.99")),
        ((Standards.CAEM2005, "29.56.3"), (Standards.CAEM2009, "28.99")),
        ((Standards.CAEM2005, "29.56.4"), (Standards.CAEM2009, "28.94")),
        ((Standards.CAEM2005, "29.56.4"), (Standards.CAEM2009, "28.99")),
        ((Standards.CAEM2005, "29.56.5"), (Standards.CAEM2009, "28.96")),
        ((Standards.CAEM2005, "29.56.6"), (Standards.CAEM2009, "28.99")),
        ((Standards.CAEM2005, "29.56.7"), (Standards.CAEM2009, "28.94")),
        ((Standards.CAEM2005, "29.56.7"), (Standards.CAEM2009, "28.99")),
        ((Standards.CAEM2005, "29.56.8"), (Standards.CAEM2009, "25.73")),
        ((Standards.CAEM2005, "29.56.8"), (Standards.CAEM2009, "28.94")),
        ((Standards.CAEM2005, "29.56.8"), (Standards.CAEM2009, "28.99")),
        ((Standards.CAEM2005, "29.56.9"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "29.6"), (Standards.CAEM2009, "25.4")),
        ((Standards.CAEM2005, "29.6"), (Standards.CAEM2009, "30.3")),
        ((Standards.CAEM2005, "29.6"), (Standards.CAEM2009, "30.4")),
        ((Standards.CAEM2005, "29.6"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "29.60"), (Standards.CAEM2009, "25.40")),
        ((Standards.CAEM2005, "29.60"), (Standards.CAEM2009, "30.30")),
        ((Standards.CAEM2005, "29.60"), (Standards.CAEM2009, "30.40")),
        ((Standards.CAEM2005, "29.60"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "29.60.0"), (Standards.CAEM2009, "25.40")),
        ((Standards.CAEM2005, "29.60.0"), (Standards.CAEM2009, "30.30")),
        ((Standards.CAEM2005, "29.60.0"), (Standards.CAEM2009, "30.40")),
        ((Standards.CAEM2005, "29.60.0"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "29.7"), (Standards.CAEM2009, "27.5")),
        ((Standards.CAEM2005, "29.7"), (Standards.CAEM2009, "28.2")),
        ((Standards.CAEM2005, "29.7"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "29.71"), (Standards.CAEM2009, "27.51")),
        ((Standards.CAEM2005, "29.71"), (Standards.CAEM2009, "28.21")),
        ((Standards.CAEM2005, "29.71"), (Standards.CAEM2009, "28.25")),
        ((Standards.CAEM2005, "29.71"), (Standards.CAEM2009, "33.14")),
        ((Standards.CAEM2005, "29.71.1"), (Standards.CAEM2009, "27.51")),
        ((Standards.CAEM2005, "29.71.1"), (Standards.CAEM2009, "28.21")),
        ((Standards.CAEM2005, "29.71.1"), (Standards.CAEM2009, "28.25")),
        ((Standards.CAEM2005, "29.71.1"), (Standards.CAEM2009, "33.14")),
        ((Standards.CAEM2005, "29.71.2"), (Standards.CAEM2009, "27.51")),
        ((Standards.CAEM2005, "29.71.2"), (Standards.CAEM2009, "33.14")),
        ((Standards.CAEM2005, "29.72"), (Standards.CAEM2009, "27.52")),
        ((Standards.CAEM2005, "29.72"), (Standards.CAEM2009, "28.21")),
        ((Standards.CAEM2005, "29.72.0"), (Standards.CAEM2009, "27.52")),
        ((Standards.CAEM2005, "29.72.0"), (Standards.CAEM2009, "28.21")),
        ((Standards.CAEM2005, "30"), (Standards.CAEM2009, "26")),
        ((Standards.CAEM2005, "30"), (Standards.CAEM2009, "28")),
        ((Standards.CAEM2005, "30"), (Standards.CAEM2009, "33")),
        ((Standards.CAEM2005, "30"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "30"), (Standards.CAEM2009, "62")),
        ((Standards.CAEM2005, "30.0"), (Standards.CAEM2009, "26.2")),
        ((Standards.CAEM2005, "30.0"), (Standards.CAEM2009, "28.2")),
        ((Standards.CAEM2005, "30.0"), (Standards.CAEM2009, "33")),
        ((Standards.CAEM2005, "30.0"), (Standards.CAEM2009, "33.2")),
        ((Standards.CAEM2005, "30.0"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "30.0"), (Standards.CAEM2009, "62.0")),
        ((Standards.CAEM2005, "30.01"), (Standards.CAEM2009, "28.23")),
        ((Standards.CAEM2005, "30.01.0"), (Standards.CAEM2009, "28.23")),
        ((Standards.CAEM2005, "30.02"), (Standards.CAEM2009, "26.20")),
        ((Standards.CAEM2005, "30.02"), (Standards.CAEM2009, "62.09")),
        ((Standards.CAEM2005, "30.02.0"), (Standards.CAEM2009, "26.20")),
        ((Standards.CAEM2005, "30.02.0"), (Standards.CAEM2009, "62.09")),
        ((Standards.CAEM2005, "31"), (Standards.CAEM2009, "23")),
        ((Standards.CAEM2005, "31"), (Standards.CAEM2009, "25")),
        ((Standards.CAEM2005, "31"), (Standards.CAEM2009, "26")),
        ((Standards.CAEM2005, "31"), (Standards.CAEM2009, "27")),
        ((Standards.CAEM2005, "31"), (Standards.CAEM2009, "28")),
        ((Standards.CAEM2005, "31"), (Standards.CAEM2009, "29")),
        ((Standards.CAEM2005, "31"), (Standards.CAEM2009, "30")),
        ((Standards.CAEM2005, "31"), (Standards.CAEM2009, "33")),
        ((Standards.CAEM2005, "31"), (Standards.CAEM2009, "33.2")),
        ((Standards.CAEM2005, "31"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "31.1"), (Standards.CAEM2009, "26.1")),
        ((Standards.CAEM2005, "31.1"), (Standards.CAEM2009, "27.1")),
        ((Standards.CAEM2005, "31.1"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "31.10"), (Standards.CAEM2009, "26.11")),
        ((Standards.CAEM2005, "31.10"), (Standards.CAEM2009, "27.11")),
        ((Standards.CAEM2005, "31.10"), (Standards.CAEM2009, "33.13")),
        ((Standards.CAEM2005, "31.10"), (Standards.CAEM2009, "33.14")),
        ((Standards.CAEM2005, "31.10.1"), (Standards.CAEM2009, "26.11")),
        ((Standards.CAEM2005, "31.10.1"), (Standards.CAEM2009, "27.11")),
        ((Standards.CAEM2005, "31.10.9"), (Standards.CAEM2009, "33.13")),
        ((Standards.CAEM2005, "31.10.9"), (Standards.CAEM2009, "33.14")),
        ((Standards.CAEM2005, "31.2"), (Standards.CAEM2009, "26.1")),
        ((Standards.CAEM2005, "31.2"), (Standards.CAEM2009, "27.1")),
        ((Standards.CAEM2005, "31.2"), (Standards.CAEM2009, "27.3")),
        ((Standards.CAEM2005, "31.2"), (Standards.CAEM2009, "27.9")),
        ((Standards.CAEM2005, "31.2"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "31.20"), (Standards.CAEM2009, "26.11")),
        ((Standards.CAEM2005, "31.20"), (Standards.CAEM2009, "27.12")),
        ((Standards.CAEM2005, "31.20"), (Standards.CAEM2009, "27.33")),
        ((Standards.CAEM2005, "31.20"), (Standards.CAEM2009, "27.90")),
        ((Standards.CAEM2005, "31.20"), (Standards.CAEM2009, "33.14")),
        ((Standards.CAEM2005, "31.20.1"), (Standards.CAEM2009, "26.11")),
        ((Standards.CAEM2005, "31.20.1"), (Standards.CAEM2009, "27.12")),
        ((Standards.CAEM2005, "31.20.1"), (Standards.CAEM2009, "27.33")),
        ((Standards.CAEM2005, "31.20.1"), (Standards.CAEM2009, "27.90")),
        ((Standards.CAEM2005, "31.20.9"), (Standards.CAEM2009, "33.14")),
        ((Standards.CAEM2005, "31.3"), (Standards.CAEM2009, "26.1")),
        ((Standards.CAEM2005, "31.3"), (Standards.CAEM2009, "27.3")),
        ((Standards.CAEM2005, "31.3"), (Standards.CAEM2009, "27.9")),
        ((Standards.CAEM2005, "31.30"), (Standards.CAEM2009, "26.11")),
        ((Standards.CAEM2005, "31.30"), (Standards.CAEM2009, "27.31")),
        ((Standards.CAEM2005, "31.30"), (Standards.CAEM2009, "27.32")),
        ((Standards.CAEM2005, "31.30"), (Standards.CAEM2009, "27.33")),
        ((Standards.CAEM2005, "31.30"), (Standards.CAEM2009, "27.90")),
        ((Standards.CAEM2005, "31.30.0"), (Standards.CAEM2009, "26.11")),
        ((Standards.CAEM2005, "31.30.0"), (Standards.CAEM2009, "27.31")),
        ((Standards.CAEM2005, "31.30.0"), (Standards.CAEM2009, "27.32")),
        ((Standards.CAEM2005, "31.30.0"), (Standards.CAEM2009, "27.33")),
        ((Standards.CAEM2005, "31.30.0"), (Standards.CAEM2009, "27.90")),
        ((Standards.CAEM2005, "31.4"), (Standards.CAEM2009, "27.2")),
        ((Standards.CAEM2005, "31.40"), (Standards.CAEM2009, "27.20")),
        ((Standards.CAEM2005, "31.40.0"), (Standards.CAEM2009, "27.20")),
        ((Standards.CAEM2005, "31.5"), (Standards.CAEM2009, "27.4")),
        ((Standards.CAEM2005, "31.50"), (Standards.CAEM2009, "27.40")),
        ((Standards.CAEM2005, "31.50.1"), (Standards.CAEM2009, "27.40")),
        ((Standards.CAEM2005, "31.50.2"), (Standards.CAEM2009, "27.40")),
        ((Standards.CAEM2005, "31.6"), (Standards.CAEM2009, "23.4")),
        ((Standards.CAEM2005, "31.6"), (Standards.CAEM2009, "25.9")),
        ((Standards.CAEM2005, "31.6"), (Standards.CAEM2009, "26.3")),
        ((Standards.CAEM2005, "31.6"), (Standards.CAEM2009, "26.5")),
        ((Standards.CAEM2005, "31.6"), (Standards.CAEM2009, "27.1")),
        ((Standards.CAEM2005, "31.6"), (Standards.CAEM2009, "27.4")),
        ((Standards.CAEM2005, "31.6"), (Standards.CAEM2009, "27.9")),
        ((Standards.CAEM2005, "31.6"), (Standards.CAEM2009, "28.4")),
        ((Standards.CAEM2005, "31.6"), (Standards.CAEM2009, "28.9")),
        ((Standards.CAEM2005, "31.6"), (Standards.CAEM2009, "29.3")),
        ((Standards.CAEM2005, "31.6"), (Standards.CAEM2009, "30.2")),
        ((Standards.CAEM2005, "31.6"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "31.61"), (Standards.CAEM2009, "27.40")),
        ((Standards.CAEM2005, "31.61"), (Standards.CAEM2009, "29.31")),
        ((Standards.CAEM2005, "31.61"), (Standards.CAEM2009, "33.14")),
        ((Standards.CAEM2005, "31.61.1"), (Standards.CAEM2009, "27.40")),
        ((Standards.CAEM2005, "31.61.1"), (Standards.CAEM2009, "29.31")),
        ((Standards.CAEM2005, "31.61.9"), (Standards.CAEM2009, "33.14")),
        ((Standards.CAEM2005, "31.62"), (Standards.CAEM2009, "23.44")),
        ((Standards.CAEM2005, "31.62"), (Standards.CAEM2009, "25.99")),
        ((Standards.CAEM2005, "31.62"), (Standards.CAEM2009, "26.30")),
        ((Standards.CAEM2005, "31.62"), (Standards.CAEM2009, "26.51")),
        ((Standards.CAEM2005, "31.62"), (Standards.CAEM2009, "27.11")),
        ((Standards.CAEM2005, "31.62"), (Standards.CAEM2009, "27.40")),
        ((Standards.CAEM2005, "31.62"), (Standards.CAEM2009, "27.90")),
        ((Standards.CAEM2005, "31.62"), (Standards.CAEM2009, "28.41")),
        ((Standards.CAEM2005, "31.62"), (Standards.CAEM2009, "28.49")),
        ((Standards.CAEM2005, "31.62"), (Standards.CAEM2009, "28.99")),
        ((Standards.CAEM2005, "31.62"), (Standards.CAEM2009, "30.20")),
        ((Standards.CAEM2005, "31.62"), (Standards.CAEM2009, "33.13")),
        ((Standards.CAEM2005, "31.62"), (Standards.CAEM2009, "33.14")),
        ((Standards.CAEM2005, "31.62.1"), (Standards.CAEM2009, "27.11")),
        ((Standards.CAEM2005, "31.62.1"), (Standards.CAEM2009, "27.40")),
        ((Standards.CAEM2005, "31.62.1"), (Standards.CAEM2009, "27.90")),
        ((Standards.CAEM2005, "31.62.1"), (Standards.CAEM2009, "28.41")),
        ((Standards.CAEM2005, "31.62.2"), (Standards.CAEM2009, "27.11")),
        ((Standards.CAEM2005, "31.62.2"), (Standards.CAEM2009, "27.40")),
        ((Standards.CAEM2005, "31.62.2"), (Standards.CAEM2009, "27.90")),
        ((Standards.CAEM2005, "31.62.2"), (Standards.CAEM2009, "28.49")),
        ((Standards.CAEM2005, "31.62.3"), (Standards.CAEM2009, "26.30")),
        ((Standards.CAEM2005, "31.62.3"), (Standards.CAEM2009, "27.11")),
        ((Standards.CAEM2005, "31.62.3"), (Standards.CAEM2009, "27.40")),
        ((Standards.CAEM2005, "31.62.3"), (Standards.CAEM2009, "28.49")),
        ((Standards.CAEM2005, "31.62.3"), (Standards.CAEM2009, "30.20")),
        ((Standards.CAEM2005, "31.62.8"), (Standards.CAEM2009, "23.44")),
        ((Standards.CAEM2005, "31.62.8"), (Standards.CAEM2009, "25.99")),
        ((Standards.CAEM2005, "31.62.8"), (Standards.CAEM2009, "26.51")),
        ((Standards.CAEM2005, "31.62.8"), (Standards.CAEM2009, "27.11")),
        ((Standards.CAEM2005, "31.62.8"), (Standards.CAEM2009, "27.40")),
        ((Standards.CAEM2005, "31.62.8"), (Standards.CAEM2009, "28.41")),
        ((Standards.CAEM2005, "31.62.8"), (Standards.CAEM2009, "28.49")),
        ((Standards.CAEM2005, "31.62.8"), (Standards.CAEM2009, "28.99")),
        ((Standards.CAEM2005, "31.62.9"), (Standards.CAEM2009, "33.13")),
        ((Standards.CAEM2005, "31.62.9"), (Standards.CAEM2009, "33.14")),
        ((Standards.CAEM2005, "32"), (Standards.CAEM2009, "26")),
        ((Standards.CAEM2005, "32"), (Standards.CAEM2009, "27")),
        ((Standards.CAEM2005, "32"), (Standards.CAEM2009, "28")),
        ((Standards.CAEM2005, "32"), (Standards.CAEM2009, "33")),
        ((Standards.CAEM2005, "32"), (Standards.CAEM2009, "33.2")),
        ((Standards.CAEM2005, "32"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "32"), (Standards.CAEM2009, "95")),
        ((Standards.CAEM2005, "32.1"), (Standards.CAEM2009, "26.1")),
        ((Standards.CAEM2005, "32.1"), (Standards.CAEM2009, "27.9")),
        ((Standards.CAEM2005, "32.1"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "32.10"), (Standards.CAEM2009, "26.11")),
        ((Standards.CAEM2005, "32.10"), (Standards.CAEM2009, "26.12")),
        ((Standards.CAEM2005, "32.10"), (Standards.CAEM2009, "27.90")),
        ((Standards.CAEM2005, "32.10"), (Standards.CAEM2009, "33.13")),
        ((Standards.CAEM2005, "32.10.0"), (Standards.CAEM2009, "26.11")),
        ((Standards.CAEM2005, "32.10.0"), (Standards.CAEM2009, "26.12")),
        ((Standards.CAEM2005, "32.10.0"), (Standards.CAEM2009, "27.90")),
        ((Standards.CAEM2005, "32.10.0"), (Standards.CAEM2009, "33.13")),
        ((Standards.CAEM2005, "32.2"), (Standards.CAEM2009, "26.3")),
        ((Standards.CAEM2005, "32.2"), (Standards.CAEM2009, "95.1")),
        ((Standards.CAEM2005, "32.20"), (Standards.CAEM2009, "26.30")),
        ((Standards.CAEM2005, "32.20"), (Standards.CAEM2009, "95.12")),
        ((Standards.CAEM2005, "32.20.1"), (Standards.CAEM2009, "26.30")),
        ((Standards.CAEM2005, "32.20.2"), (Standards.CAEM2009, "26.30")),
        ((Standards.CAEM2005, "32.20.9"), (Standards.CAEM2009, "95.12")),
        ((Standards.CAEM2005, "32.3"), (Standards.CAEM2009, "26.1")),
        ((Standards.CAEM2005, "32.3"), (Standards.CAEM2009, "26.2")),
        ((Standards.CAEM2005, "32.3"), (Standards.CAEM2009, "26.3")),
        ((Standards.CAEM2005, "32.3"), (Standards.CAEM2009, "26.4")),
        ((Standards.CAEM2005, "32.3"), (Standards.CAEM2009, "26.7")),
        ((Standards.CAEM2005, "32.3"), (Standards.CAEM2009, "28.2")),
        ((Standards.CAEM2005, "32.3"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "32.30"), (Standards.CAEM2009, "26.11")),
        ((Standards.CAEM2005, "32.30"), (Standards.CAEM2009, "26.20")),
        ((Standards.CAEM2005, "32.30"), (Standards.CAEM2009, "26.30")),
        ((Standards.CAEM2005, "32.30"), (Standards.CAEM2009, "26.40")),
        ((Standards.CAEM2005, "32.30"), (Standards.CAEM2009, "26.70")),
        ((Standards.CAEM2005, "32.30"), (Standards.CAEM2009, "28.23")),
        ((Standards.CAEM2005, "32.30"), (Standards.CAEM2009, "33.13")),
        ((Standards.CAEM2005, "32.30.1"), (Standards.CAEM2009, "26.11")),
        ((Standards.CAEM2005, "32.30.1"), (Standards.CAEM2009, "26.20")),
        ((Standards.CAEM2005, "32.30.1"), (Standards.CAEM2009, "26.30")),
        ((Standards.CAEM2005, "32.30.1"), (Standards.CAEM2009, "26.40")),
        ((Standards.CAEM2005, "32.30.1"), (Standards.CAEM2009, "26.70")),
        ((Standards.CAEM2005, "32.30.1"), (Standards.CAEM2009, "28.23")),
        ((Standards.CAEM2005, "32.30.9"), (Standards.CAEM2009, "33.13")),
        ((Standards.CAEM2005, "33"), (Standards.CAEM2009, "26")),
        ((Standards.CAEM2005, "33"), (Standards.CAEM2009, "27")),
        ((Standards.CAEM2005, "33"), (Standards.CAEM2009, "28")),
        ((Standards.CAEM2005, "33"), (Standards.CAEM2009, "28.1")),
        ((Standards.CAEM2005, "33"), (Standards.CAEM2009, "31")),
        ((Standards.CAEM2005, "33"), (Standards.CAEM2009, "32")),
        ((Standards.CAEM2005, "33"), (Standards.CAEM2009, "32.5")),
        ((Standards.CAEM2005, "33"), (Standards.CAEM2009, "33")),
        ((Standards.CAEM2005, "33"), (Standards.CAEM2009, "33.2")),
        ((Standards.CAEM2005, "33"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "33.1"), (Standards.CAEM2009, "26.6")),
        ((Standards.CAEM2005, "33.1"), (Standards.CAEM2009, "31.0")),
        ((Standards.CAEM2005, "33.1"), (Standards.CAEM2009, "32.5")),
        ((Standards.CAEM2005, "33.1"), (Standards.CAEM2009, "32.9")),
        ((Standards.CAEM2005, "33.1"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "33.10"), (Standards.CAEM2009, "26.60")),
        ((Standards.CAEM2005, "33.10"), (Standards.CAEM2009, "31.01")),
        ((Standards.CAEM2005, "33.10"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "33.10"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "33.10"), (Standards.CAEM2009, "33.13")),
        ((Standards.CAEM2005, "33.10"), (Standards.CAEM2009, "33.14")),
        ((Standards.CAEM2005, "33.10.1"), (Standards.CAEM2009, "26.60")),
        ((Standards.CAEM2005, "33.10.1"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "33.10.1"), (Standards.CAEM2009, "33.13")),
        ((Standards.CAEM2005, "33.10.1"), (Standards.CAEM2009, "33.14")),
        ((Standards.CAEM2005, "33.10.2"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "33.10.2"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "33.10.2"), (Standards.CAEM2009, "33.13")),
        ((Standards.CAEM2005, "33.10.2"), (Standards.CAEM2009, "33.14")),
        ((Standards.CAEM2005, "33.10.3"), (Standards.CAEM2009, "26.60")),
        ((Standards.CAEM2005, "33.10.3"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "33.10.3"), (Standards.CAEM2009, "33.13")),
        ((Standards.CAEM2005, "33.10.3"), (Standards.CAEM2009, "33.14")),
        ((Standards.CAEM2005, "33.10.4"), (Standards.CAEM2009, "31.01")),
        ((Standards.CAEM2005, "33.10.4"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "33.10.4"), (Standards.CAEM2009, "33.13")),
        ((Standards.CAEM2005, "33.10.4"), (Standards.CAEM2009, "33.14")),
        ((Standards.CAEM2005, "33.2"), (Standards.CAEM2009, "26.3")),
        ((Standards.CAEM2005, "33.2"), (Standards.CAEM2009, "26.5")),
        ((Standards.CAEM2005, "33.2"), (Standards.CAEM2009, "26.7")),
        ((Standards.CAEM2005, "33.2"), (Standards.CAEM2009, "28.2")),
        ((Standards.CAEM2005, "33.2"), (Standards.CAEM2009, "28.9")),
        ((Standards.CAEM2005, "33.2"), (Standards.CAEM2009, "32.5")),
        ((Standards.CAEM2005, "33.2"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "33.2"), (Standards.CAEM2009, "33.2")),
        ((Standards.CAEM2005, "33.20"), (Standards.CAEM2009, "26.30")),
        ((Standards.CAEM2005, "33.20"), (Standards.CAEM2009, "26.51")),
        ((Standards.CAEM2005, "33.20"), (Standards.CAEM2009, "26.70")),
        ((Standards.CAEM2005, "33.20"), (Standards.CAEM2009, "28.29")),
        ((Standards.CAEM2005, "33.20"), (Standards.CAEM2009, "28.99")),
        ((Standards.CAEM2005, "33.20"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "33.20"), (Standards.CAEM2009, "33.13")),
        ((Standards.CAEM2005, "33.20"), (Standards.CAEM2009, "33.14")),
        ((Standards.CAEM2005, "33.20"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "33.20.1"), (Standards.CAEM2009, "26.51")),
        ((Standards.CAEM2005, "33.20.1"), (Standards.CAEM2009, "28.29")),
        ((Standards.CAEM2005, "33.20.1"), (Standards.CAEM2009, "28.99")),
        ((Standards.CAEM2005, "33.20.1"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "33.20.2"), (Standards.CAEM2009, "26.30")),
        ((Standards.CAEM2005, "33.20.2"), (Standards.CAEM2009, "26.51")),
        ((Standards.CAEM2005, "33.20.2"), (Standards.CAEM2009, "28.29")),
        ((Standards.CAEM2005, "33.20.3"), (Standards.CAEM2009, "26.30")),
        ((Standards.CAEM2005, "33.20.3"), (Standards.CAEM2009, "26.51")),
        ((Standards.CAEM2005, "33.20.3"), (Standards.CAEM2009, "28.29")),
        ((Standards.CAEM2005, "33.20.4"), (Standards.CAEM2009, "26.51")),
        ((Standards.CAEM2005, "33.20.4"), (Standards.CAEM2009, "26.70")),
        ((Standards.CAEM2005, "33.20.4"), (Standards.CAEM2009, "28.29")),
        ((Standards.CAEM2005, "33.20.5"), (Standards.CAEM2009, "26.51")),
        ((Standards.CAEM2005, "33.20.5"), (Standards.CAEM2009, "28.29")),
        ((Standards.CAEM2005, "33.20.6"), (Standards.CAEM2009, "26.51")),
        ((Standards.CAEM2005, "33.20.6"), (Standards.CAEM2009, "28.29")),
        ((Standards.CAEM2005, "33.20.9"), (Standards.CAEM2009, "33.13")),
        ((Standards.CAEM2005, "33.20.9"), (Standards.CAEM2009, "33.14")),
        ((Standards.CAEM2005, "33.20.9"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "33.3"), (Standards.CAEM2009, "33.2")),
        ((Standards.CAEM2005, "33.30"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "33.30.1"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "33.30.9"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "33.4"), (Standards.CAEM2009, "26.7")),
        ((Standards.CAEM2005, "33.4"), (Standards.CAEM2009, "27.3")),
        ((Standards.CAEM2005, "33.4"), (Standards.CAEM2009, "28.9")),
        ((Standards.CAEM2005, "33.4"), (Standards.CAEM2009, "32.5")),
        ((Standards.CAEM2005, "33.4"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "33.40"), (Standards.CAEM2009, "26.70")),
        ((Standards.CAEM2005, "33.40"), (Standards.CAEM2009, "27.31")),
        ((Standards.CAEM2005, "33.40"), (Standards.CAEM2009, "28.99")),
        ((Standards.CAEM2005, "33.40"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "33.40"), (Standards.CAEM2009, "33.13")),
        ((Standards.CAEM2005, "33.40.1"), (Standards.CAEM2009, "26.70")),
        ((Standards.CAEM2005, "33.40.1"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "33.40.2"), (Standards.CAEM2009, "26.70")),
        ((Standards.CAEM2005, "33.40.2"), (Standards.CAEM2009, "28.99")),
        ((Standards.CAEM2005, "33.40.2"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "33.40.3"), (Standards.CAEM2009, "27.31")),
        ((Standards.CAEM2005, "33.40.3"), (Standards.CAEM2009, "32.50")),
        ((Standards.CAEM2005, "33.40.9"), (Standards.CAEM2009, "33.13")),
        ((Standards.CAEM2005, "33.5"), (Standards.CAEM2009, "26.5")),
        ((Standards.CAEM2005, "33.5"), (Standards.CAEM2009, "32.1")),
        ((Standards.CAEM2005, "33.5"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "33.50"), (Standards.CAEM2009, "26.52")),
        ((Standards.CAEM2005, "33.50"), (Standards.CAEM2009, "32.12")),
        ((Standards.CAEM2005, "33.50"), (Standards.CAEM2009, "32.13")),
        ((Standards.CAEM2005, "33.50"), (Standards.CAEM2009, "33.13")),
        ((Standards.CAEM2005, "33.50.1"), (Standards.CAEM2009, "26.52")),
        ((Standards.CAEM2005, "33.50.1"), (Standards.CAEM2009, "32.12")),
        ((Standards.CAEM2005, "33.50.1"), (Standards.CAEM2009, "32.13")),
        ((Standards.CAEM2005, "33.50.2"), (Standards.CAEM2009, "26.52")),
        ((Standards.CAEM2005, "33.50.2"), (Standards.CAEM2009, "33.13")),
        ((Standards.CAEM2005, "33.50.3"), (Standards.CAEM2009, "26.52")),
        ((Standards.CAEM2005, "33.50.3"), (Standards.CAEM2009, "32.12")),
        ((Standards.CAEM2005, "33.50.3"), (Standards.CAEM2009, "32.13")),
        ((Standards.CAEM2005, "34"), (Standards.CAEM2009, "28")),
        ((Standards.CAEM2005, "34"), (Standards.CAEM2009, "29")),
        ((Standards.CAEM2005, "34"), (Standards.CAEM2009, "30")),
        ((Standards.CAEM2005, "34"), (Standards.CAEM2009, "33")),
        ((Standards.CAEM2005, "34"), (Standards.CAEM2009, "33.2")),
        ((Standards.CAEM2005, "34"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "34.1"), (Standards.CAEM2009, "28.9")),
        ((Standards.CAEM2005, "34.1"), (Standards.CAEM2009, "29.1")),
        ((Standards.CAEM2005, "34.1"), (Standards.CAEM2009, "30.9")),
        ((Standards.CAEM2005, "34.10"), (Standards.CAEM2009, "28.92")),
        ((Standards.CAEM2005, "34.10"), (Standards.CAEM2009, "29.10")),
        ((Standards.CAEM2005, "34.10"), (Standards.CAEM2009, "30.91")),
        ((Standards.CAEM2005, "34.10.1"), (Standards.CAEM2009, "28.92")),
        ((Standards.CAEM2005, "34.10.1"), (Standards.CAEM2009, "29.10")),
        ((Standards.CAEM2005, "34.10.2"), (Standards.CAEM2009, "29.10")),
        ((Standards.CAEM2005, "34.10.2"), (Standards.CAEM2009, "30.91")),
        ((Standards.CAEM2005, "34.2"), (Standards.CAEM2009, "29.2")),
        ((Standards.CAEM2005, "34.2"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "34.20"), (Standards.CAEM2009, "29.20")),
        ((Standards.CAEM2005, "34.20"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "34.20.1"), (Standards.CAEM2009, "29.20")),
        ((Standards.CAEM2005, "34.20.1"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "34.20.2"), (Standards.CAEM2009, "29.20")),
        ((Standards.CAEM2005, "34.20.2"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "34.3"), (Standards.CAEM2009, "28.1")),
        ((Standards.CAEM2005, "34.3"), (Standards.CAEM2009, "29.3")),
        ((Standards.CAEM2005, "34.30"), (Standards.CAEM2009, "28.11")),
        ((Standards.CAEM2005, "34.30"), (Standards.CAEM2009, "29.32")),
        ((Standards.CAEM2005, "34.30.1"), (Standards.CAEM2009, "28.11")),
        ((Standards.CAEM2005, "34.30.1"), (Standards.CAEM2009, "29.32")),
        ((Standards.CAEM2005, "34.30.2"), (Standards.CAEM2009, "28.11")),
        ((Standards.CAEM2005, "34.30.2"), (Standards.CAEM2009, "29.32")),
        ((Standards.CAEM2005, "35"), (Standards.CAEM2009, "28")),
        ((Standards.CAEM2005, "35"), (Standards.CAEM2009, "30")),
        ((Standards.CAEM2005, "35"), (Standards.CAEM2009, "31")),
        ((Standards.CAEM2005, "35"), (Standards.CAEM2009, "32")),
        ((Standards.CAEM2005, "35"), (Standards.CAEM2009, "33")),
        ((Standards.CAEM2005, "35"), (Standards.CAEM2009, "33.2")),
        ((Standards.CAEM2005, "35"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "35.1"), (Standards.CAEM2009, "30.1")),
        ((Standards.CAEM2005, "35.1"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "35.11"), (Standards.CAEM2009, "30.11")),
        ((Standards.CAEM2005, "35.11"), (Standards.CAEM2009, "33.15")),
        ((Standards.CAEM2005, "35.11.1"), (Standards.CAEM2009, "30.11")),
        ((Standards.CAEM2005, "35.11.9"), (Standards.CAEM2009, "33.15")),
        ((Standards.CAEM2005, "35.12"), (Standards.CAEM2009, "30.12")),
        ((Standards.CAEM2005, "35.12"), (Standards.CAEM2009, "33.15")),
        ((Standards.CAEM2005, "35.12.1"), (Standards.CAEM2009, "30.12")),
        ((Standards.CAEM2005, "35.12.9"), (Standards.CAEM2009, "33.15")),
        ((Standards.CAEM2005, "35.2"), (Standards.CAEM2009, "30.2")),
        ((Standards.CAEM2005, "35.2"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "35.20"), (Standards.CAEM2009, "30.20")),
        ((Standards.CAEM2005, "35.20"), (Standards.CAEM2009, "33.17")),
        ((Standards.CAEM2005, "35.20.1"), (Standards.CAEM2009, "30.20")),
        ((Standards.CAEM2005, "35.20.8"), (Standards.CAEM2009, "33.17")),
        ((Standards.CAEM2005, "35.20.9"), (Standards.CAEM2009, "33.17")),
        ((Standards.CAEM2005, "35.3"), (Standards.CAEM2009, "28.9")),
        ((Standards.CAEM2005, "35.3"), (Standards.CAEM2009, "30.3")),
        ((Standards.CAEM2005, "35.3"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "35.30"), (Standards.CAEM2009, "28.99")),
        ((Standards.CAEM2005, "35.30"), (Standards.CAEM2009, "30.30")),
        ((Standards.CAEM2005, "35.30"), (Standards.CAEM2009, "33.16")),
        ((Standards.CAEM2005, "35.30.1"), (Standards.CAEM2009, "28.99")),
        ((Standards.CAEM2005, "35.30.1"), (Standards.CAEM2009, "30.30")),
        ((Standards.CAEM2005, "35.30.2"), (Standards.CAEM2009, "28.99")),
        ((Standards.CAEM2005, "35.30.2"), (Standards.CAEM2009, "30.30")),
        ((Standards.CAEM2005, "35.30.9"), (Standards.CAEM2009, "33.16")),
        ((Standards.CAEM2005, "35.4"), (Standards.CAEM2009, "30.9")),
        ((Standards.CAEM2005, "35.4"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "35.41"), (Standards.CAEM2009, "30.91")),
        ((Standards.CAEM2005, "35.41.0"), (Standards.CAEM2009, "30.91")),
        ((Standards.CAEM2005, "35.42"), (Standards.CAEM2009, "30.92")),
        ((Standards.CAEM2005, "35.42.0"), (Standards.CAEM2009, "30.92")),
        ((Standards.CAEM2005, "35.43"), (Standards.CAEM2009, "30.92")),
        ((Standards.CAEM2005, "35.43"), (Standards.CAEM2009, "33.17")),
        ((Standards.CAEM2005, "35.43.0"), (Standards.CAEM2009, "30.92")),
        ((Standards.CAEM2005, "35.43.0"), (Standards.CAEM2009, "33.17")),
        ((Standards.CAEM2005, "35.5"), (Standards.CAEM2009, "28.2")),
        ((Standards.CAEM2005, "35.5"), (Standards.CAEM2009, "30.9")),
        ((Standards.CAEM2005, "35.5"), (Standards.CAEM2009, "31.0")),
        ((Standards.CAEM2005, "35.5"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "35.50"), (Standards.CAEM2009, "28.22")),
        ((Standards.CAEM2005, "35.50"), (Standards.CAEM2009, "30.99")),
        ((Standards.CAEM2005, "35.50"), (Standards.CAEM2009, "31.01")),
        ((Standards.CAEM2005, "35.50"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "35.50"), (Standards.CAEM2009, "33.17")),
        ((Standards.CAEM2005, "35.50.0"), (Standards.CAEM2009, "28.22")),
        ((Standards.CAEM2005, "35.50.0"), (Standards.CAEM2009, "30.99")),
        ((Standards.CAEM2005, "35.50.0"), (Standards.CAEM2009, "31.01")),
        ((Standards.CAEM2005, "35.50.0"), (Standards.CAEM2009, "33.11")),
        ((Standards.CAEM2005, "35.50.0"), (Standards.CAEM2009, "33.17")),
        ((Standards.CAEM2005, "36"), (Standards.CAEM2009, "13")),
        ((Standards.CAEM2005, "36"), (Standards.CAEM2009, "15")),
        ((Standards.CAEM2005, "36"), (Standards.CAEM2009, "16")),
        ((Standards.CAEM2005, "36"), (Standards.CAEM2009, "17")),
        ((Standards.CAEM2005, "36"), (Standards.CAEM2009, "20")),
        ((Standards.CAEM2005, "36"), (Standards.CAEM2009, "22")),
        ((Standards.CAEM2005, "36"), (Standards.CAEM2009, "25")),
        ((Standards.CAEM2005, "36"), (Standards.CAEM2009, "26")),
        ((Standards.CAEM2005, "36"), (Standards.CAEM2009, "28")),
        ((Standards.CAEM2005, "36"), (Standards.CAEM2009, "28.1")),
        ((Standards.CAEM2005, "36"), (Standards.CAEM2009, "29")),
        ((Standards.CAEM2005, "36"), (Standards.CAEM2009, "30")),
        ((Standards.CAEM2005, "36"), (Standards.CAEM2009, "31")),
        ((Standards.CAEM2005, "36"), (Standards.CAEM2009, "32")),
        ((Standards.CAEM2005, "36"), (Standards.CAEM2009, "33")),
        ((Standards.CAEM2005, "36"), (Standards.CAEM2009, "33.2")),
        ((Standards.CAEM2005, "36"), (Standards.CAEM2009, "33.20")),
        ((Standards.CAEM2005, "36"), (Standards.CAEM2009, "95")),
        ((Standards.CAEM2005, "36.1"), (Standards.CAEM2009, "28.2")),
        ((Standards.CAEM2005, "36.1"), (Standards.CAEM2009, "29.3")),
        ((Standards.CAEM2005, "36.1"), (Standards.CAEM2009, "30.1")),
        ((Standards.CAEM2005, "36.1"), (Standards.CAEM2009, "30.2")),
        ((Standards.CAEM2005, "36.1"), (Standards.CAEM2009, "30.3")),
        ((Standards.CAEM2005, "36.1"), (Standards.CAEM2009, "31.0")),
        ((Standards.CAEM2005, "36.1"), (Standards.CAEM2009, "95.2")),
        ((Standards.CAEM2005, "36.11"), (Standards.CAEM2009, "29.32")),
        ((Standards.CAEM2005, "36.11"), (Standards.CAEM2009, "30.11")),
        ((Standards.CAEM2005, "36.11"), (Standards.CAEM2009, "30.20")),
        ((Standards.CAEM2005, "36.11"), (Standards.CAEM2009, "30.30")),
        ((Standards.CAEM2005, "36.11"), (Standards.CAEM2009, "31.01")),
        ((Standards.CAEM2005, "36.11"), (Standards.CAEM2009, "31")),
        ((Standards.CAEM2005, "36.11"), (Standards.CAEM2009, "02")),
        ((Standards.CAEM2005, "36.11"), (Standards.CAEM2009, "31")),
        ((Standards.CAEM2005, "36.11"), (Standards.CAEM2009, "09")),
        ((Standards.CAEM2005, "36.11"), (Standards.CAEM2009, "95.24")),
        ((Standards.CAEM2005, "36.11.0"), (Standards.CAEM2009, "29.32")),
        ((Standards.CAEM2005, "36.11.0"), (Standards.CAEM2009, "30.11")),
        ((Standards.CAEM2005, "36.11.0"), (Standards.CAEM2009, "30.20")),
        ((Standards.CAEM2005, "36.11.0"), (Standards.CAEM2009, "30.30")),
        ((Standards.CAEM2005, "36.11.0"), (Standards.CAEM2009, "31.01")),
        ((Standards.CAEM2005, "36.11.0"), (Standards.CAEM2009, "31")),
        ((Standards.CAEM2005, "36.11.0"), (Standards.CAEM2009, "02")),
        ((Standards.CAEM2005, "36.11.0"), (Standards.CAEM2009, "31")),
        ((Standards.CAEM2005, "36.11.0"), (Standards.CAEM2009, "09")),
        ((Standards.CAEM2005, "36.11.0"), (Standards.CAEM2009, "95.24")),
        ((Standards.CAEM2005, "36.12"), (Standards.CAEM2009, "28.23")),
        ((Standards.CAEM2005, "36.12"), (Standards.CAEM2009, "31.01")),
        ((Standards.CAEM2005, "36.12"), (Standards.CAEM2009, "95.24")),
        ((Standards.CAEM2005, "36.12.0"), (Standards.CAEM2009, "28.23")),
        ((Standards.CAEM2005, "36.12.0"), (Standards.CAEM2009, "31.01")),
        ((Standards.CAEM2005, "36.12.0"), (Standards.CAEM2009, "95.24")),
        ((Standards.CAEM2005, "36.13"), (Standards.CAEM2009, "31")),
        ((Standards.CAEM2005, "36.13"), (Standards.CAEM2009, "02")),
        ((Standards.CAEM2005, "36.13"), (Standards.CAEM2009, "95.24")),
        ((Standards.CAEM2005, "36.13.0"), (Standards.CAEM2009, "31")),
        ((Standards.CAEM2005, "36.13.0"), (Standards.CAEM2009, "02")),
        ((Standards.CAEM2005, "36.13.0"), (Standards.CAEM2009, "95.24")),
        ((Standards.CAEM2005, "36.14"), (Standards.CAEM2009, "31")),
        ((Standards.CAEM2005, "36.14"), (Standards.CAEM2009, "09")),
        ((Standards.CAEM2005, "36.14"), (Standards.CAEM2009, "95.24")),
        ((Standards.CAEM2005, "36.14.0"), (Standards.CAEM2009, "31")),
        ((Standards.CAEM2005, "36.14.0"), (Standards.CAEM2009, "09")),
        ((Standards.CAEM2005, "36.14.0"), (Standards.CAEM2009, "95.24")),
        ((Standards.CAEM2005, "36.15"), (Standards.CAEM2009, "31.03")),
        ((Standards.CAEM2005, "36.15.0"), (Standards.CAEM2009, "31.03")),
        ((Standards.CAEM2005, "36.2"), (Standards.CAEM2009, "32.1")),
        ((Standards.CAEM2005, "36.21"), (Standards.CAEM2009, "32.11")),
        ((Standards.CAEM2005, "36.21.0"), (Standards.CAEM2009, "32.11")),
        ((Standards.CAEM2005, "36.22"), (Standards.CAEM2009, "32.12")),
        ((Standards.CAEM2005, "36.22.0"), (Standards.CAEM2009, "32.12")),
        ((Standards.CAEM2005, "36.3"), (Standards.CAEM2009, "32.2")),
        ((Standards.CAEM2005, "36.3"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "36.3"), (Standards.CAEM2009, "95.2")),
        ((Standards.CAEM2005, "36.30"), (Standards.CAEM2009, "32.20")),
        ((Standards.CAEM2005, "36.30"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "36.30"), (Standards.CAEM2009, "95.29")),
        ((Standards.CAEM2005, "36.30.1"), (Standards.CAEM2009, "32.20")),
        ((Standards.CAEM2005, "36.30.9"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "36.30.9"), (Standards.CAEM2009, "95.29")),
        ((Standards.CAEM2005, "36.4"), (Standards.CAEM2009, "32.3")),
        ((Standards.CAEM2005, "36.4"), (Standards.CAEM2009, "32.9")),
        ((Standards.CAEM2005, "36.4"), (Standards.CAEM2009, "95.2")),
        ((Standards.CAEM2005, "36.40"), (Standards.CAEM2009, "32.30")),
        ((Standards.CAEM2005, "36.40"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "36.40"), (Standards.CAEM2009, "95.29")),
        ((Standards.CAEM2005, "36.40.0"), (Standards.CAEM2009, "32.30")),
        ((Standards.CAEM2005, "36.40.0"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "36.40.0"), (Standards.CAEM2009, "95.29")),
        ((Standards.CAEM2005, "36.5"), (Standards.CAEM2009, "26.4")),
        ((Standards.CAEM2005, "36.5"), (Standards.CAEM2009, "28.9")),
        ((Standards.CAEM2005, "36.5"), (Standards.CAEM2009, "32.4")),
        ((Standards.CAEM2005, "36.5"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "36.50"), (Standards.CAEM2009, "26.40")),
        ((Standards.CAEM2005, "36.50"), (Standards.CAEM2009, "28.99")),
        ((Standards.CAEM2005, "36.50"), (Standards.CAEM2009, "32.40")),
        ((Standards.CAEM2005, "36.50"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "36.50.0"), (Standards.CAEM2009, "26.40")),
        ((Standards.CAEM2005, "36.50.0"), (Standards.CAEM2009, "28.99")),
        ((Standards.CAEM2005, "36.50.0"), (Standards.CAEM2009, "32.40")),
        ((Standards.CAEM2005, "36.50.0"), (Standards.CAEM2009, "33.19")),
        ((Standards.CAEM2005, "36.6"), (Standards.CAEM2009, "13.9")),
        ((Standards.CAEM2005, "36.6"), (Standards.CAEM2009, "15.1")),
        ((Standards.CAEM2005, "36.6"), (Standards.CAEM2009, "16.2")),
        ((Standards.CAEM2005, "36.6"), (Standards.CAEM2009, "17.2")),
        ((Standards.CAEM2005, "36.6"), (Standards.CAEM2009, "20.5")),
        ((Standards.CAEM2005, "36.6"), (Standards.CAEM2009, "22.1")),
        ((Standards.CAEM2005, "36.6"), (Standards.CAEM2009, "22.2")),
        ((Standards.CAEM2005, "36.6"), (Standards.CAEM2009, "25.9")),
        ((Standards.CAEM2005, "36.6"), (Standards.CAEM2009, "28.9")),
        ((Standards.CAEM2005, "36.6"), (Standards.CAEM2009, "30.9")),
        ((Standards.CAEM2005, "36.6"), (Standards.CAEM2009, "32.1")),
        ((Standards.CAEM2005, "36.6"), (Standards.CAEM2009, "32.9")),
        ((Standards.CAEM2005, "36.61"), (Standards.CAEM2009, "32.13")),
        ((Standards.CAEM2005, "36.61.0"), (Standards.CAEM2009, "32.13")),
        ((Standards.CAEM2005, "36.62"), (Standards.CAEM2009, "32.91")),
        ((Standards.CAEM2005, "36.62.0"), (Standards.CAEM2009, "32.91")),
        ((Standards.CAEM2005, "36.63"), (Standards.CAEM2009, "13.99")),
        ((Standards.CAEM2005, "36.63"), (Standards.CAEM2009, "15.12")),
        ((Standards.CAEM2005, "36.63"), (Standards.CAEM2009, "16.29")),
        ((Standards.CAEM2005, "36.63"), (Standards.CAEM2009, "17.29")),
        ((Standards.CAEM2005, "36.63"), (Standards.CAEM2009, "20.51")),
        ((Standards.CAEM2005, "36.63"), (Standards.CAEM2009, "22.19")),
        ((Standards.CAEM2005, "36.63"), (Standards.CAEM2009, "22.23")),
        ((Standards.CAEM2005, "36.63"), (Standards.CAEM2009, "22.29")),
        ((Standards.CAEM2005, "36.63"), (Standards.CAEM2009, "25.99")),
        ((Standards.CAEM2005, "36.63"), (Standards.CAEM2009, "28.99")),
        ((Standards.CAEM2005, "36.63"), (Standards.CAEM2009, "30.92")),
        ((Standards.CAEM2005, "36.63"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "36.63.1"), (Standards.CAEM2009, "22.19")),
        ((Standards.CAEM2005, "36.63.1"), (Standards.CAEM2009, "22.29")),
        ((Standards.CAEM2005, "36.63.1"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "36.63.2"), (Standards.CAEM2009, "22.19")),
        ((Standards.CAEM2005, "36.63.2"), (Standards.CAEM2009, "22.29")),
        ((Standards.CAEM2005, "36.63.2"), (Standards.CAEM2009, "30.92")),
        ((Standards.CAEM2005, "36.63.3"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "36.63.4"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "36.63.5"), (Standards.CAEM2009, "22.19")),
        ((Standards.CAEM2005, "36.63.5"), (Standards.CAEM2009, "22.29")),
        ((Standards.CAEM2005, "36.63.5"), (Standards.CAEM2009, "28.99")),
        ((Standards.CAEM2005, "36.63.6"), (Standards.CAEM2009, "22.19")),
        ((Standards.CAEM2005, "36.63.6"), (Standards.CAEM2009, "22.23")),
        ((Standards.CAEM2005, "36.63.6"), (Standards.CAEM2009, "22.29")),
        ((Standards.CAEM2005, "36.63.6"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "36.63.9"), (Standards.CAEM2009, "13.99")),
        ((Standards.CAEM2005, "36.63.9"), (Standards.CAEM2009, "15.12")),
        ((Standards.CAEM2005, "36.63.9"), (Standards.CAEM2009, "16.29")),
        ((Standards.CAEM2005, "36.63.9"), (Standards.CAEM2009, "17.29")),
        ((Standards.CAEM2005, "36.63.9"), (Standards.CAEM2009, "20.51")),
        ((Standards.CAEM2005, "36.63.9"), (Standards.CAEM2009, "22.19")),
        ((Standards.CAEM2005, "36.63.9"), (Standards.CAEM2009, "22.29")),
        ((Standards.CAEM2005, "36.63.9"), (Standards.CAEM2009, "25.99")),
        ((Standards.CAEM2005, "36.63.9"), (Standards.CAEM2009, "32.99")),
        ((Standards.CAEM2005, "37"), (Standards.CAEM2009, "38")),
        ((Standards.CAEM2005, "37.1"), (Standards.CAEM2009, "38.3")),
        ((Standards.CAEM2005, "37.10"), (Standards.CAEM2009, "38.31")),
        ((Standards.CAEM2005, "37.10"), (Standards.CAEM2009, "38.32")),
        ((Standards.CAEM2005, "37.10.1"), (Standards.CAEM2009, "38.31")),
        ((Standards.CAEM2005, "37.10.1"), (Standards.CAEM2009, "38.32")),
        ((Standards.CAEM2005, "37.10.2"), (Standards.CAEM2009, "38.31")),
        ((Standards.CAEM2005, "37.10.2"), (Standards.CAEM2009, "38.32")),
        ((Standards.CAEM2005, "37.2"), (Standards.CAEM2009, "38.3")),
        ((Standards.CAEM2005, "37.20"), (Standards.CAEM2009, "38.32")),
        ((Standards.CAEM2005, "37.20.0"), (Standards.CAEM2009, "38.32")),
        ((Standards.CAEM2005, "E"), (Standards.CAEM2009, "D")),
        ((Standards.CAEM2005, "E"), (Standards.CAEM2009, "E")),
        ((Standards.CAEM2005, "40"), (Standards.CAEM2009, "35")),
        ((Standards.CAEM2005, "40"), (Standards.CAEM2009, "38")),
        ((Standards.CAEM2005, "40.1"), (Standards.CAEM2009, "35.1")),
        ((Standards.CAEM2005, "40.1"), (Standards.CAEM2009, "38.1")),
        ((Standards.CAEM2005, "40.11"), (Standards.CAEM2009, "35.11")),
        ((Standards.CAEM2005, "40.11"), (Standards.CAEM2009, "38.12")),
        ((Standards.CAEM2005, "40.11.1"), (Standards.CAEM2009, "35.11")),
        ((Standards.CAEM2005, "40.11.2"), (Standards.CAEM2009, "35.11")),
        ((Standards.CAEM2005, "40.11.3"), (Standards.CAEM2009, "35.11")),
        ((Standards.CAEM2005, "40.11.3"), (Standards.CAEM2009, "38.12")),
        ((Standards.CAEM2005, "40.11.4"), (Standards.CAEM2009, "35.11")),
        ((Standards.CAEM2005, "40.12"), (Standards.CAEM2009, "35.12")),
        ((Standards.CAEM2005, "40.12.0"), (Standards.CAEM2009, "35.12")),
        ((Standards.CAEM2005, "40.13"), (Standards.CAEM2009, "35.13")),
        ((Standards.CAEM2005, "40.13"), (Standards.CAEM2009, "35.14")),
        ((Standards.CAEM2005, "40.13.0"), (Standards.CAEM2009, "35.13")),
        ((Standards.CAEM2005, "40.13.0"), (Standards.CAEM2009, "35.14")),
        ((Standards.CAEM2005, "40.2"), (Standards.CAEM2009, "35.2")),
        ((Standards.CAEM2005, "40.21"), (Standards.CAEM2009, "35.21")),
        ((Standards.CAEM2005, "40.21.0"), (Standards.CAEM2009, "35.21")),
        ((Standards.CAEM2005, "40.22"), (Standards.CAEM2009, "35.22")),
        ((Standards.CAEM2005, "40.22"), (Standards.CAEM2009, "35.23")),
        ((Standards.CAEM2005, "40.22.0"), (Standards.CAEM2009, "35.22")),
        ((Standards.CAEM2005, "40.22.0"), (Standards.CAEM2009, "35.23")),
        ((Standards.CAEM2005, "40.3"), (Standards.CAEM2009, "35.3")),
        ((Standards.CAEM2005, "40.30"), (Standards.CAEM2009, "35.30")),
        ((Standards.CAEM2005, "40.30.1"), (Standards.CAEM2009, "35.30")),
        ((Standards.CAEM2005, "40.30.2"), (Standards.CAEM2009, "35.30")),
        ((Standards.CAEM2005, "40.30.3"), (Standards.CAEM2009, "35.30")),
        ((Standards.CAEM2005, "41"), (Standards.CAEM2009, "36")),
        ((Standards.CAEM2005, "41.0"), (Standards.CAEM2009, "36.0")),
        ((Standards.CAEM2005, "41.00"), (Standards.CAEM2009, "36.00")),
        ((Standards.CAEM2005, "41.00.0"), (Standards.CAEM2009, "36.00")),
        ((Standards.CAEM2005, "F"), (Standards.CAEM2009, "F")),
        ((Standards.CAEM2005, "F"), (Standards.CAEM2009, "N")),
        ((Standards.CAEM2005, "45"), (Standards.CAEM2009, "41")),
        ((Standards.CAEM2005, "45"), (Standards.CAEM2009, "42")),
        ((Standards.CAEM2005, "45"), (Standards.CAEM2009, "43")),
        ((Standards.CAEM2005, "45"), (Standards.CAEM2009, "80")),
        ((Standards.CAEM2005, "45.1"), (Standards.CAEM2009, "43.1")),
        ((Standards.CAEM2005, "45.11"), (Standards.CAEM2009, "43.11")),
        ((Standards.CAEM2005, "45.11"), (Standards.CAEM2009, "43.12")),
        ((Standards.CAEM2005, "45.11.1"), (Standards.CAEM2009, "43.11")),
        ((Standards.CAEM2005, "45.11.2"), (Standards.CAEM2009, "43.12")),
        ((Standards.CAEM2005, "45.11.3"), (Standards.CAEM2009, "43.12")),
        ((Standards.CAEM2005, "45.11.4"), (Standards.CAEM2009, "43.12")),
        ((Standards.CAEM2005, "45.11.5"), (Standards.CAEM2009, "43.12")),
        ((Standards.CAEM2005, "45.12"), (Standards.CAEM2009, "43.13")),
        ((Standards.CAEM2005, "45.12.0"), (Standards.CAEM2009, "43.13")),
        ((Standards.CAEM2005, "45.2"), (Standards.CAEM2009, "41.2")),
        ((Standards.CAEM2005, "45.2"), (Standards.CAEM2009, "42.1")),
        ((Standards.CAEM2005, "45.2"), (Standards.CAEM2009, "42.2")),
        ((Standards.CAEM2005, "45.2"), (Standards.CAEM2009, "42.9")),
        ((Standards.CAEM2005, "45.2"), (Standards.CAEM2009, "43.9")),
        ((Standards.CAEM2005, "45.21"), (Standards.CAEM2009, "41.20")),
        ((Standards.CAEM2005, "45.21"), (Standards.CAEM2009, "42.12")),
        ((Standards.CAEM2005, "45.21"), (Standards.CAEM2009, "42.13")),
        ((Standards.CAEM2005, "45.21"), (Standards.CAEM2009, "42.21")),
        ((Standards.CAEM2005, "45.21"), (Standards.CAEM2009, "42.22")),
        ((Standards.CAEM2005, "45.21"), (Standards.CAEM2009, "42.99")),
        ((Standards.CAEM2005, "45.21"), (Standards.CAEM2009, "43.99")),
        ((Standards.CAEM2005, "45.21.1"), (Standards.CAEM2009, "41.20")),
        ((Standards.CAEM2005, "45.21.1"), (Standards.CAEM2009, "43.99")),
        ((Standards.CAEM2005, "45.21.2"), (Standards.CAEM2009, "42.12")),
        ((Standards.CAEM2005, "45.21.2"), (Standards.CAEM2009, "42.13")),
        ((Standards.CAEM2005, "45.21.2"), (Standards.CAEM2009, "42.21")),
        ((Standards.CAEM2005, "45.21.2"), (Standards.CAEM2009, "42.22")),
        ((Standards.CAEM2005, "45.21.2"), (Standards.CAEM2009, "42.99")),
        ((Standards.CAEM2005, "45.22"), (Standards.CAEM2009, "43.91")),
        ((Standards.CAEM2005, "45.22"), (Standards.CAEM2009, "43.99")),
        ((Standards.CAEM2005, "45.22.0"), (Standards.CAEM2009, "43.91")),
        ((Standards.CAEM2005, "45.22.0"), (Standards.CAEM2009, "43.99")),
        ((Standards.CAEM2005, "45.23"), (Standards.CAEM2009, "41.20")),
        ((Standards.CAEM2005, "45.23"), (Standards.CAEM2009, "42.11")),
        ((Standards.CAEM2005, "45.23"), (Standards.CAEM2009, "42.12")),
        ((Standards.CAEM2005, "45.23"), (Standards.CAEM2009, "42.99")),
        ((Standards.CAEM2005, "45.23.0"), (Standards.CAEM2009, "41.20")),
        ((Standards.CAEM2005, "45.23.0"), (Standards.CAEM2009, "42.11")),
        ((Standards.CAEM2005, "45.23.0"), (Standards.CAEM2009, "42.12")),
        ((Standards.CAEM2005, "45.23.0"), (Standards.CAEM2009, "42.99")),
        ((Standards.CAEM2005, "45.24"), (Standards.CAEM2009, "42.21")),
        ((Standards.CAEM2005, "45.24"), (Standards.CAEM2009, "42.91")),
        ((Standards.CAEM2005, "45.24"), (Standards.CAEM2009, "43.99")),
        ((Standards.CAEM2005, "45.24.0"), (Standards.CAEM2009, "42.21")),
        ((Standards.CAEM2005, "45.24.0"), (Standards.CAEM2009, "42.91")),
        ((Standards.CAEM2005, "45.24.0"), (Standards.CAEM2009, "43.99")),
        ((Standards.CAEM2005, "45.25"), (Standards.CAEM2009, "42.21")),
        ((Standards.CAEM2005, "45.25"), (Standards.CAEM2009, "43.99")),
        ((Standards.CAEM2005, "45.25.1"), (Standards.CAEM2009, "42.21")),
        ((Standards.CAEM2005, "45.25.1"), (Standards.CAEM2009, "43.99")),
        ((Standards.CAEM2005, "45.25.9"), (Standards.CAEM2009, "42.21")),
        ((Standards.CAEM2005, "45.25.9"), (Standards.CAEM2009, "43.99")),
        ((Standards.CAEM2005, "45.3"), (Standards.CAEM2009, "43.2")),
        ((Standards.CAEM2005, "45.3"), (Standards.CAEM2009, "80.2")),
        ((Standards.CAEM2005, "45.31"), (Standards.CAEM2009, "43.21")),
        ((Standards.CAEM2005, "45.31"), (Standards.CAEM2009, "43.22")),
        ((Standards.CAEM2005, "45.31"), (Standards.CAEM2009, "43.29")),
        ((Standards.CAEM2005, "45.31"), (Standards.CAEM2009, "80.20")),
        ((Standards.CAEM2005, "45.31.0"), (Standards.CAEM2009, "43.21")),
        ((Standards.CAEM2005, "45.31.0"), (Standards.CAEM2009, "43.22")),
        ((Standards.CAEM2005, "45.31.0"), (Standards.CAEM2009, "43.29")),
        ((Standards.CAEM2005, "45.31.0"), (Standards.CAEM2009, "80.20")),
        ((Standards.CAEM2005, "45.32"), (Standards.CAEM2009, "43.29")),
        ((Standards.CAEM2005, "45.32.0"), (Standards.CAEM2009, "43.29")),
        ((Standards.CAEM2005, "45.33"), (Standards.CAEM2009, "43.22")),
        ((Standards.CAEM2005, "45.33.0"), (Standards.CAEM2009, "43.22")),
        ((Standards.CAEM2005, "45.34"), (Standards.CAEM2009, "43.21")),
        ((Standards.CAEM2005, "45.34"), (Standards.CAEM2009, "43.29")),
        ((Standards.CAEM2005, "45.34.0"), (Standards.CAEM2009, "43.21")),
        ((Standards.CAEM2005, "45.34.0"), (Standards.CAEM2009, "43.29")),
        ((Standards.CAEM2005, "45.4"), (Standards.CAEM2009, "43.3")),
        ((Standards.CAEM2005, "45.4"), (Standards.CAEM2009, "43.9")),
        ((Standards.CAEM2005, "45.41"), (Standards.CAEM2009, "43.31")),
        ((Standards.CAEM2005, "45.41.0"), (Standards.CAEM2009, "43.31")),
        ((Standards.CAEM2005, "45.42"), (Standards.CAEM2009, "43.32")),
        ((Standards.CAEM2005, "45.42.0"), (Standards.CAEM2009, "43.32")),
        ((Standards.CAEM2005, "45.43"), (Standards.CAEM2009, "43.33")),
        ((Standards.CAEM2005, "45.43.0"), (Standards.CAEM2009, "43.33")),
        ((Standards.CAEM2005, "45.44"), (Standards.CAEM2009, "43.34")),
        ((Standards.CAEM2005, "45.44.0"), (Standards.CAEM2009, "43.34")),
        ((Standards.CAEM2005, "45.45"), (Standards.CAEM2009, "43.39")),
        ((Standards.CAEM2005, "45.45"), (Standards.CAEM2009, "43.99")),
        ((Standards.CAEM2005, "45.45.0"), (Standards.CAEM2009, "43.39")),
        ((Standards.CAEM2005, "45.45.0"), (Standards.CAEM2009, "43.99")),
        ((Standards.CAEM2005, "45.5"), (Standards.CAEM2009, "43.9")),
        ((Standards.CAEM2005, "45.50"), (Standards.CAEM2009, "43.99")),
        ((Standards.CAEM2005, "45.50.0"), (Standards.CAEM2009, "43.99")),
        ((Standards.CAEM2005, "G"), (Standards.CAEM2009, "C")),
        ((Standards.CAEM2005, "G"), (Standards.CAEM2009, "G")),
        ((Standards.CAEM2005, "G"), (Standards.CAEM2009, "H")),
        ((Standards.CAEM2005, "G"), (Standards.CAEM2009, "S")),
        ((Standards.CAEM2005, "50"), (Standards.CAEM2009, "45")),
        ((Standards.CAEM2005, "50"), (Standards.CAEM2009, "47")),
        ((Standards.CAEM2005, "50"), (Standards.CAEM2009, "52")),
        ((Standards.CAEM2005, "50.1"), (Standards.CAEM2009, "45.1")),
        ((Standards.CAEM2005, "50.10"), (Standards.CAEM2009, "45.11")),
        ((Standards.CAEM2005, "50.10"), (Standards.CAEM2009, "45.19")),
        ((Standards.CAEM2005, "50.10.1"), (Standards.CAEM2009, "45.11")),
        ((Standards.CAEM2005, "50.10.1"), (Standards.CAEM2009, "45.19")),
        ((Standards.CAEM2005, "50.10.2"), (Standards.CAEM2009, "45.11")),
        ((Standards.CAEM2005, "50.10.2"), (Standards.CAEM2009, "45.19")),
        ((Standards.CAEM2005, "50.2"), (Standards.CAEM2009, "45.2")),
        ((Standards.CAEM2005, "50.2"), (Standards.CAEM2009, "52.2")),
        ((Standards.CAEM2005, "50.20"), (Standards.CAEM2009, "45.20")),
        ((Standards.CAEM2005, "50.20"), (Standards.CAEM2009, "52.21")),
        ((Standards.CAEM2005, "50.20.0"), (Standards.CAEM2009, "45.20")),
        ((Standards.CAEM2005, "50.20.0"), (Standards.CAEM2009, "52.21")),
        ((Standards.CAEM2005, "50.3"), (Standards.CAEM2009, "45.3")),
        ((Standards.CAEM2005, "50.30"), (Standards.CAEM2009, "45.31")),
        ((Standards.CAEM2005, "50.30"), (Standards.CAEM2009, "45.32")),
        ((Standards.CAEM2005, "50.30.1"), (Standards.CAEM2009, "45.31")),
        ((Standards.CAEM2005, "50.30.2"), (Standards.CAEM2009, "45.32")),
        ((Standards.CAEM2005, "50.4"), (Standards.CAEM2009, "45.4")),
        ((Standards.CAEM2005, "50.40"), (Standards.CAEM2009, "45.40")),
        ((Standards.CAEM2005, "50.40.1"), (Standards.CAEM2009, "45.40")),
        ((Standards.CAEM2005, "50.40.2"), (Standards.CAEM2009, "45.40")),
        ((Standards.CAEM2005, "50.40.3"), (Standards.CAEM2009, "45.40")),
        ((Standards.CAEM2005, "50.5"), (Standards.CAEM2009, "47.3")),
        ((Standards.CAEM2005, "50.50"), (Standards.CAEM2009, "47.30")),
        ((Standards.CAEM2005, "50.50.0"), (Standards.CAEM2009, "47.30")),
        ((Standards.CAEM2005, "51"), (Standards.CAEM2009, "10")),
        ((Standards.CAEM2005, "51"), (Standards.CAEM2009, "11")),
        ((Standards.CAEM2005, "51"), (Standards.CAEM2009, "46")),
        ((Standards.CAEM2005, "51.1"), (Standards.CAEM2009, "46.1")),
        ((Standards.CAEM2005, "51.11"), (Standards.CAEM2009, "46.11")),
        ((Standards.CAEM2005, "51.11.0"), (Standards.CAEM2009, "46.11")),
        ((Standards.CAEM2005, "51.12"), (Standards.CAEM2009, "46.12")),
        ((Standards.CAEM2005, "51.12.0"), (Standards.CAEM2009, "46.12")),
        ((Standards.CAEM2005, "51.13"), (Standards.CAEM2009, "46.13")),
        ((Standards.CAEM2005, "51.13.0"), (Standards.CAEM2009, "46.13")),
        ((Standards.CAEM2005, "51.14"), (Standards.CAEM2009, "46.14")),
        ((Standards.CAEM2005, "51.14.0"), (Standards.CAEM2009, "46.14")),
        ((Standards.CAEM2005, "51.15"), (Standards.CAEM2009, "46.15")),
        ((Standards.CAEM2005, "51.15.0"), (Standards.CAEM2009, "46.15")),
        ((Standards.CAEM2005, "51.16"), (Standards.CAEM2009, "46.16")),
        ((Standards.CAEM2005, "51.16.0"), (Standards.CAEM2009, "46.16")),
        ((Standards.CAEM2005, "51.17"), (Standards.CAEM2009, "46.17")),
        ((Standards.CAEM2005, "51.17.0"), (Standards.CAEM2009, "46.17")),
        ((Standards.CAEM2005, "51.18"), (Standards.CAEM2009, "46.18")),
        ((Standards.CAEM2005, "51.18.0"), (Standards.CAEM2009, "46.18")),
        ((Standards.CAEM2005, "51.19"), (Standards.CAEM2009, "46.19")),
        ((Standards.CAEM2005, "51.19.0"), (Standards.CAEM2009, "46.19")),
        ((Standards.CAEM2005, "51.2"), (Standards.CAEM2009, "46.2")),
        ((Standards.CAEM2005, "51.21"), (Standards.CAEM2009, "46.21")),
        ((Standards.CAEM2005, "51.21.0"), (Standards.CAEM2009, "46.21")),
        ((Standards.CAEM2005, "51.22"), (Standards.CAEM2009, "46.22")),
        ((Standards.CAEM2005, "51.22.0"), (Standards.CAEM2009, "46.22")),
        ((Standards.CAEM2005, "51.23"), (Standards.CAEM2009, "46.23")),
        ((Standards.CAEM2005, "51.23.0"), (Standards.CAEM2009, "46.23")),
        ((Standards.CAEM2005, "51.24"), (Standards.CAEM2009, "46.24")),
        ((Standards.CAEM2005, "51.24.0"), (Standards.CAEM2009, "46.24")),
        ((Standards.CAEM2005, "51.25"), (Standards.CAEM2009, "46.21")),
        ((Standards.CAEM2005, "51.25.0"), (Standards.CAEM2009, "46.21")),
        ((Standards.CAEM2005, "51.3"), (Standards.CAEM2009, "10.3")),
        ((Standards.CAEM2005, "51.3"), (Standards.CAEM2009, "11.0")),
        ((Standards.CAEM2005, "51.3"), (Standards.CAEM2009, "46.3")),
        ((Standards.CAEM2005, "51.31"), (Standards.CAEM2009, "10.39")),
        ((Standards.CAEM2005, "51.31"), (Standards.CAEM2009, "46.31")),
        ((Standards.CAEM2005, "51.31.0"), (Standards.CAEM2009, "10.39")),
        ((Standards.CAEM2005, "51.31.0"), (Standards.CAEM2009, "46.31")),
        ((Standards.CAEM2005, "51.32"), (Standards.CAEM2009, "46.32")),
        ((Standards.CAEM2005, "51.32.0"), (Standards.CAEM2009, "46.32")),
        ((Standards.CAEM2005, "51.33"), (Standards.CAEM2009, "46.33")),
        ((Standards.CAEM2005, "51.33.0"), (Standards.CAEM2009, "46.33")),
        ((Standards.CAEM2005, "51.34"), (Standards.CAEM2009, "11.01")),
        ((Standards.CAEM2005, "51.34"), (Standards.CAEM2009, "11.02")),
        ((Standards.CAEM2005, "51.34"), (Standards.CAEM2009, "46.34")),
        ((Standards.CAEM2005, "51.34.0"), (Standards.CAEM2009, "11.01")),
        ((Standards.CAEM2005, "51.34.0"), (Standards.CAEM2009, "11.02")),
        ((Standards.CAEM2005, "51.34.0"), (Standards.CAEM2009, "46.34")),
        ((Standards.CAEM2005, "51.35"), (Standards.CAEM2009, "46.35")),
        ((Standards.CAEM2005, "51.35.0"), (Standards.CAEM2009, "46.35")),
        ((Standards.CAEM2005, "51.36"), (Standards.CAEM2009, "46.36")),
        ((Standards.CAEM2005, "51.36.0"), (Standards.CAEM2009, "46.36")),
        ((Standards.CAEM2005, "51.37"), (Standards.CAEM2009, "46.37")),
        ((Standards.CAEM2005, "51.37.0"), (Standards.CAEM2009, "46.37")),
        ((Standards.CAEM2005, "51.38"), (Standards.CAEM2009, "46.31")),
        ((Standards.CAEM2005, "51.38"), (Standards.CAEM2009, "46.38")),
        ((Standards.CAEM2005, "51.38.1"), (Standards.CAEM2009, "46.38")),
        ((Standards.CAEM2005, "51.38.2"), (Standards.CAEM2009, "46.38")),
        ((Standards.CAEM2005, "51.38.3"), (Standards.CAEM2009, "46.38")),
        ((Standards.CAEM2005, "51.38.4"), (Standards.CAEM2009, "46.38")),
        ((Standards.CAEM2005, "51.38.9"), (Standards.CAEM2009, "46.31")),
        ((Standards.CAEM2005, "51.38.9"), (Standards.CAEM2009, "46.38")),
        ((Standards.CAEM2005, "51.39"), (Standards.CAEM2009, "46.39")),
        ((Standards.CAEM2005, "51.39.0"), (Standards.CAEM2009, "46.39")),
        ((Standards.CAEM2005, "51.4"), (Standards.CAEM2009, "46.4")),
        ((Standards.CAEM2005, "51.4"), (Standards.CAEM2009, "46.5")),
        ((Standards.CAEM2005, "51.4"), (Standards.CAEM2009, "46.7")),
        ((Standards.CAEM2005, "51.41"), (Standards.CAEM2009, "46.41")),
        ((Standards.CAEM2005, "51.41.0"), (Standards.CAEM2009, "46.41")),
        ((Standards.CAEM2005, "51.42"), (Standards.CAEM2009, "46.42")),
        ((Standards.CAEM2005, "51.42.1"), (Standards.CAEM2009, "46.42")),
        ((Standards.CAEM2005, "51.42.2"), (Standards.CAEM2009, "46.42")),
        ((Standards.CAEM2005, "51.42.3"), (Standards.CAEM2009, "46.42")),
        ((Standards.CAEM2005, "51.43"), (Standards.CAEM2009, "46.43")),
        ((Standards.CAEM2005, "51.43"), (Standards.CAEM2009, "46.47")),
        ((Standards.CAEM2005, "51.43"), (Standards.CAEM2009, "46.52")),
        ((Standards.CAEM2005, "51.43.1"), (Standards.CAEM2009, "46.43")),
        ((Standards.CAEM2005, "51.43.1"), (Standards.CAEM2009, "46.47")),
        ((Standards.CAEM2005, "51.43.2"), (Standards.CAEM2009, "46.43")),
        ((Standards.CAEM2005, "51.43.2"), (Standards.CAEM2009, "46.52")),
        ((Standards.CAEM2005, "51.44"), (Standards.CAEM2009, "46.44")),
        ((Standards.CAEM2005, "51.44"), (Standards.CAEM2009, "46.49")),
        ((Standards.CAEM2005, "51.44"), (Standards.CAEM2009, "46.73")),
        ((Standards.CAEM2005, "51.44.0"), (Standards.CAEM2009, "46.44")),
        ((Standards.CAEM2005, "51.44.0"), (Standards.CAEM2009, "46.49")),
        ((Standards.CAEM2005, "51.44.0"), (Standards.CAEM2009, "46.73")),
        ((Standards.CAEM2005, "51.45"), (Standards.CAEM2009, "46.45")),
        ((Standards.CAEM2005, "51.45.0"), (Standards.CAEM2009, "46.45")),
        ((Standards.CAEM2005, "51.46"), (Standards.CAEM2009, "46.46")),
        ((Standards.CAEM2005, "51.46.0"), (Standards.CAEM2009, "46.46")),
        ((Standards.CAEM2005, "51.47"), (Standards.CAEM2009, "46.43")),
        ((Standards.CAEM2005, "51.47"), (Standards.CAEM2009, "46.47")),
        ((Standards.CAEM2005, "51.47"), (Standards.CAEM2009, "46.48")),
        ((Standards.CAEM2005, "51.47"), (Standards.CAEM2009, "46.49")),
        ((Standards.CAEM2005, "51.47"), (Standards.CAEM2009, "46.73")),
        ((Standards.CAEM2005, "51.47.1"), (Standards.CAEM2009, "46.47")),
        ((Standards.CAEM2005, "51.47.2"), (Standards.CAEM2009, "46.49")),
        ((Standards.CAEM2005, "51.47.9"), (Standards.CAEM2009, "46.43")),
        ((Standards.CAEM2005, "51.47.9"), (Standards.CAEM2009, "46.48")),
        ((Standards.CAEM2005, "51.47.9"), (Standards.CAEM2009, "46.49")),
        ((Standards.CAEM2005, "51.47.9"), (Standards.CAEM2009, "46.73")),
        ((Standards.CAEM2005, "51.5"), (Standards.CAEM2009, "46.7")),
        ((Standards.CAEM2005, "51.51"), (Standards.CAEM2009, "46.71")),
        ((Standards.CAEM2005, "51.51.1"), (Standards.CAEM2009, "46.71")),
        ((Standards.CAEM2005, "51.51.2"), (Standards.CAEM2009, "46.71")),
        ((Standards.CAEM2005, "51.51.3"), (Standards.CAEM2009, "46.71")),
        ((Standards.CAEM2005, "51.51.4"), (Standards.CAEM2009, "46.71")),
        ((Standards.CAEM2005, "51.51.5"), (Standards.CAEM2009, "46.71")),
        ((Standards.CAEM2005, "51.51.6"), (Standards.CAEM2009, "46.71")),
        ((Standards.CAEM2005, "51.51.7"), (Standards.CAEM2009, "46.71")),
        ((Standards.CAEM2005, "51.51.8"), (Standards.CAEM2009, "46.71")),
        ((Standards.CAEM2005, "51.51.9"), (Standards.CAEM2009, "46.71")),
        ((Standards.CAEM2005, "51.52"), (Standards.CAEM2009, "46.72")),
        ((Standards.CAEM2005, "51.52.0"), (Standards.CAEM2009, "46.72")),
        ((Standards.CAEM2005, "51.53"), (Standards.CAEM2009, "46.73")),
        ((Standards.CAEM2005, "51.53.1"), (Standards.CAEM2009, "46.73")),
        ((Standards.CAEM2005, "51.53.2"), (Standards.CAEM2009, "46.73")),
        ((Standards.CAEM2005, "51.53.3"), (Standards.CAEM2009, "46.73")),
        ((Standards.CAEM2005, "51.53.4"), (Standards.CAEM2009, "46.73")),
        ((Standards.CAEM2005, "51.53.5"), (Standards.CAEM2009, "46.73")),
        ((Standards.CAEM2005, "51.53.6"), (Standards.CAEM2009, "46.73")),
        ((Standards.CAEM2005, "51.53.7"), (Standards.CAEM2009, "46.73")),
        ((Standards.CAEM2005, "51.53.8"), (Standards.CAEM2009, "46.73")),
        ((Standards.CAEM2005, "51.53.9"), (Standards.CAEM2009, "46.73")),
        ((Standards.CAEM2005, "51.54"), (Standards.CAEM2009, "46.74")),
        ((Standards.CAEM2005, "51.54.0"), (Standards.CAEM2009, "46.74")),
        ((Standards.CAEM2005, "51.55"), (Standards.CAEM2009, "46.75")),
        ((Standards.CAEM2005, "51.55"), (Standards.CAEM2009, "46.76")),
        ((Standards.CAEM2005, "51.55.1"), (Standards.CAEM2009, "46.75")),
        ((Standards.CAEM2005, "51.55.2"), (Standards.CAEM2009, "46.75")),
        ((Standards.CAEM2005, "51.55.3"), (Standards.CAEM2009, "46.75")),
        ((Standards.CAEM2005, "51.55.4"), (Standards.CAEM2009, "46.75")),
        ((Standards.CAEM2005, "51.55.5"), (Standards.CAEM2009, "46.76")),
        ((Standards.CAEM2005, "51.56"), (Standards.CAEM2009, "46.76")),
        ((Standards.CAEM2005, "51.56.0"), (Standards.CAEM2009, "46.76")),
        ((Standards.CAEM2005, "51.57"), (Standards.CAEM2009, "46.77")),
        ((Standards.CAEM2005, "51.57.1"), (Standards.CAEM2009, "46.77")),
        ((Standards.CAEM2005, "51.57.2"), (Standards.CAEM2009, "46.77")),
        ((Standards.CAEM2005, "51.57.3"), (Standards.CAEM2009, "46.77")),
        ((Standards.CAEM2005, "51.57.4"), (Standards.CAEM2009, "46.77")),
        ((Standards.CAEM2005, "51.8"), (Standards.CAEM2009, "46.5")),
        ((Standards.CAEM2005, "51.8"), (Standards.CAEM2009, "46.6")),
        ((Standards.CAEM2005, "51.81"), (Standards.CAEM2009, "46.62")),
        ((Standards.CAEM2005, "51.81.0"), (Standards.CAEM2009, "46.62")),
        ((Standards.CAEM2005, "51.82"), (Standards.CAEM2009, "46.63")),
        ((Standards.CAEM2005, "51.82.0"), (Standards.CAEM2009, "46.63")),
        ((Standards.CAEM2005, "51.83"), (Standards.CAEM2009, "46.64")),
        ((Standards.CAEM2005, "51.83.0"), (Standards.CAEM2009, "46.64")),
        ((Standards.CAEM2005, "51.84"), (Standards.CAEM2009, "46.51")),
        ((Standards.CAEM2005, "51.84.0"), (Standards.CAEM2009, "46.51")),
        ((Standards.CAEM2005, "51.85"), (Standards.CAEM2009, "46.65")),
        ((Standards.CAEM2005, "51.85"), (Standards.CAEM2009, "46.66")),
        ((Standards.CAEM2005, "51.85.0"), (Standards.CAEM2009, "46.65")),
        ((Standards.CAEM2005, "51.85.0"), (Standards.CAEM2009, "46.66")),
        ((Standards.CAEM2005, "51.86"), (Standards.CAEM2009, "46.52")),
        ((Standards.CAEM2005, "51.86.0"), (Standards.CAEM2009, "46.52")),
        ((Standards.CAEM2005, "51.87"), (Standards.CAEM2009, "46.69")),
        ((Standards.CAEM2005, "51.87.0"), (Standards.CAEM2009, "46.69")),
        ((Standards.CAEM2005, "51.87"), (Standards.CAEM2009, "46.69")),
        ((Standards.CAEM2005, "51.87.0"), (Standards.CAEM2009, "46.69")),
        ((Standards.CAEM2005, "51.88"), (Standards.CAEM2009, "46.61")),
        ((Standards.CAEM2005, "51.88.0"), (Standards.CAEM2009, "46.61")),
        ((Standards.CAEM2005, "51.9"), (Standards.CAEM2009, "46.9")),
        ((Standards.CAEM2005, "51.90"), (Standards.CAEM2009, "46.90")),
        ((Standards.CAEM2005, "51.90.0"), (Standards.CAEM2009, "46.90")),
        ((Standards.CAEM2005, "52"), (Standards.CAEM2009, "13")),
        ((Standards.CAEM2005, "52"), (Standards.CAEM2009, "47")),
        ((Standards.CAEM2005, "52"), (Standards.CAEM2009, "95")),
        ((Standards.CAEM2005, "52.1"), (Standards.CAEM2009, "47.1")),
        ((Standards.CAEM2005, "52.11"), (Standards.CAEM2009, "47.11")),
        ((Standards.CAEM2005, "52.11.0"), (Standards.CAEM2009, "47.11")),
        ((Standards.CAEM2005, "52.12"), (Standards.CAEM2009, "47.19")),
        ((Standards.CAEM2005, "52.12.0"), (Standards.CAEM2009, "47.19")),
        ((Standards.CAEM2005, "52.2"), (Standards.CAEM2009, "47.2")),
        ((Standards.CAEM2005, "52.21"), (Standards.CAEM2009, "47.21")),
        ((Standards.CAEM2005, "52.21.0"), (Standards.CAEM2009, "47.21")),
        ((Standards.CAEM2005, "52.22"), (Standards.CAEM2009, "47.22")),
        ((Standards.CAEM2005, "52.22.1"), (Standards.CAEM2009, "47.22")),
        ((Standards.CAEM2005, "52.22.9"), (Standards.CAEM2009, "47.22")),
        ((Standards.CAEM2005, "52.23"), (Standards.CAEM2009, "47.23")),
        ((Standards.CAEM2005, "52.23.0"), (Standards.CAEM2009, "47.23")),
        ((Standards.CAEM2005, "52.24"), (Standards.CAEM2009, "47.24")),
        ((Standards.CAEM2005, "52.24.0"), (Standards.CAEM2009, "47.24")),
        ((Standards.CAEM2005, "52.25"), (Standards.CAEM2009, "47.25")),
        ((Standards.CAEM2005, "52.25.0"), (Standards.CAEM2009, "47.25")),
        ((Standards.CAEM2005, "52.26"), (Standards.CAEM2009, "47.26")),
        ((Standards.CAEM2005, "52.26.0"), (Standards.CAEM2009, "47.26")),
        ((Standards.CAEM2005, "52.27"), (Standards.CAEM2009, "47.21")),
        ((Standards.CAEM2005, "52.27"), (Standards.CAEM2009, "47.29")),
        ((Standards.CAEM2005, "52.27.1"), (Standards.CAEM2009, "47.29")),
        ((Standards.CAEM2005, "52.27.2"), (Standards.CAEM2009, "47.21")),
        ((Standards.CAEM2005, "52.27.2"), (Standards.CAEM2009, "47.29")),
        ((Standards.CAEM2005, "52.3"), (Standards.CAEM2009, "47.7")),
        ((Standards.CAEM2005, "52.31"), (Standards.CAEM2009, "47.73")),
        ((Standards.CAEM2005, "52.31.0"), (Standards.CAEM2009, "47.73")),
        ((Standards.CAEM2005, "52.32"), (Standards.CAEM2009, "47.74")),
        ((Standards.CAEM2005, "52.32.0"), (Standards.CAEM2009, "47.74")),
        ((Standards.CAEM2005, "52.33"), (Standards.CAEM2009, "47.75")),
        ((Standards.CAEM2005, "52.33.0"), (Standards.CAEM2009, "47.75")),
        ((Standards.CAEM2005, "52.4"), (Standards.CAEM2009, "47.4")),
        ((Standards.CAEM2005, "52.4"), (Standards.CAEM2009, "47.5")),
        ((Standards.CAEM2005, "52.4"), (Standards.CAEM2009, "47.6")),
        ((Standards.CAEM2005, "52.4"), (Standards.CAEM2009, "47.7")),
        ((Standards.CAEM2005, "52.41"), (Standards.CAEM2009, "47.51")),
        ((Standards.CAEM2005, "52.41.0"), (Standards.CAEM2009, "47.51")),
        ((Standards.CAEM2005, "52.42"), (Standards.CAEM2009, "47.71")),
        ((Standards.CAEM2005, "52.42.1"), (Standards.CAEM2009, "47.71")),
        ((Standards.CAEM2005, "52.42.2"), (Standards.CAEM2009, "47.71")),
        ((Standards.CAEM2005, "52.43"), (Standards.CAEM2009, "47.72")),
        ((Standards.CAEM2005, "52.43.1"), (Standards.CAEM2009, "47.72")),
        ((Standards.CAEM2005, "52.43.2"), (Standards.CAEM2009, "47.72")),
        ((Standards.CAEM2005, "52.44"), (Standards.CAEM2009, "47.53")),
        ((Standards.CAEM2005, "52.44"), (Standards.CAEM2009, "47.59")),
        ((Standards.CAEM2005, "52.44.1"), (Standards.CAEM2009, "47.59")),
        ((Standards.CAEM2005, "52.44.9"), (Standards.CAEM2009, "47.53")),
        ((Standards.CAEM2005, "52.44.9"), (Standards.CAEM2009, "47.59")),
        ((Standards.CAEM2005, "52.45"), (Standards.CAEM2009, "47.43")),
        ((Standards.CAEM2005, "52.45"), (Standards.CAEM2009, "47.54")),
        ((Standards.CAEM2005, "52.45"), (Standards.CAEM2009, "47.59")),
        ((Standards.CAEM2005, "52.45"), (Standards.CAEM2009, "47.63")),
        ((Standards.CAEM2005, "52.45.1"), (Standards.CAEM2009, "47.54")),
        ((Standards.CAEM2005, "52.45.1"), (Standards.CAEM2009, "47.59")),
        ((Standards.CAEM2005, "52.45.2"), (Standards.CAEM2009, "47.43")),
        ((Standards.CAEM2005, "52.45.2"), (Standards.CAEM2009, "47.59")),
        ((Standards.CAEM2005, "52.45.2"), (Standards.CAEM2009, "47.63")),
        ((Standards.CAEM2005, "52.45.3"), (Standards.CAEM2009, "47.59")),
        ((Standards.CAEM2005, "52.45.9"), (Standards.CAEM2009, "47.59")),
        ((Standards.CAEM2005, "52.46"), (Standards.CAEM2009, "47.52")),
        ((Standards.CAEM2005, "52.46.0"), (Standards.CAEM2009, "47.52")),
        ((Standards.CAEM2005, "52.47"), (Standards.CAEM2009, "47.61")),
        ((Standards.CAEM2005, "52.47"), (Standards.CAEM2009, "47.62")),
        ((Standards.CAEM2005, "52.47.0"), (Standards.CAEM2009, "47.61")),
        ((Standards.CAEM2005, "52.47.0"), (Standards.CAEM2009, "47.62")),
        ((Standards.CAEM2005, "52.48"), (Standards.CAEM2009, "47.41")),
        ((Standards.CAEM2005, "52.48"), (Standards.CAEM2009, "47.42")),
        ((Standards.CAEM2005, "52.48"), (Standards.CAEM2009, "47.53")),
        ((Standards.CAEM2005, "52.48"), (Standards.CAEM2009, "47.59")),
        ((Standards.CAEM2005, "52.48"), (Standards.CAEM2009, "47.64")),
        ((Standards.CAEM2005, "52.48"), (Standards.CAEM2009, "47.65")),
        ((Standards.CAEM2005, "52.48"), (Standards.CAEM2009, "47.76")),
        ((Standards.CAEM2005, "52.48"), (Standards.CAEM2009, "47.77")),
        ((Standards.CAEM2005, "52.48"), (Standards.CAEM2009, "47.78")),
        ((Standards.CAEM2005, "52.48.1"), (Standards.CAEM2009, "47.78")),
        ((Standards.CAEM2005, "52.48.2"), (Standards.CAEM2009, "47.53")),
        ((Standards.CAEM2005, "52.48.3"), (Standards.CAEM2009, "47.53")),
        ((Standards.CAEM2005, "52.48.4"), (Standards.CAEM2009, "47.64")),
        ((Standards.CAEM2005, "52.48.4"), (Standards.CAEM2009, "47.77")),
        ((Standards.CAEM2005, "52.48.5"), (Standards.CAEM2009, "47.64")),
        ((Standards.CAEM2005, "52.48.6"), (Standards.CAEM2009, "47.78")),
        ((Standards.CAEM2005, "52.48.7"), (Standards.CAEM2009, "47.76")),
        ((Standards.CAEM2005, "52.48.9"), (Standards.CAEM2009, "47.41")),
        ((Standards.CAEM2005, "52.48.9"), (Standards.CAEM2009, "47.42")),
        ((Standards.CAEM2005, "52.48.9"), (Standards.CAEM2009, "47.53")),
        ((Standards.CAEM2005, "52.48.9"), (Standards.CAEM2009, "47.59")),
        ((Standards.CAEM2005, "52.48.9"), (Standards.CAEM2009, "47.65")),
        ((Standards.CAEM2005, "52.48.9"), (Standards.CAEM2009, "47.76")),
        ((Standards.CAEM2005, "52.48.9"), (Standards.CAEM2009, "47.78")),
        ((Standards.CAEM2005, "52.5"), (Standards.CAEM2009, "47.7")),
        ((Standards.CAEM2005, "52.50"), (Standards.CAEM2009, "47.79")),
        ((Standards.CAEM2005, "52.50.0"), (Standards.CAEM2009, "47.79")),
        ((Standards.CAEM2005, "52.6"), (Standards.CAEM2009, "47.7")),
        ((Standards.CAEM2005, "52.6"), (Standards.CAEM2009, "47.8")),
        ((Standards.CAEM2005, "52.6"), (Standards.CAEM2009, "47.9")),
        ((Standards.CAEM2005, "52.61"), (Standards.CAEM2009, "47.91")),
        ((Standards.CAEM2005, "52.61.0"), (Standards.CAEM2009, "47.91")),
        ((Standards.CAEM2005, "52.62"), (Standards.CAEM2009, "47.81")),
        ((Standards.CAEM2005, "52.62"), (Standards.CAEM2009, "47.82")),
        ((Standards.CAEM2005, "52.62"), (Standards.CAEM2009, "47.89")),
        ((Standards.CAEM2005, "52.62.1"), (Standards.CAEM2009, "47.81")),
        ((Standards.CAEM2005, "52.62.1"), (Standards.CAEM2009, "47.89")),
        ((Standards.CAEM2005, "52.62.2"), (Standards.CAEM2009, "47.82")),
        ((Standards.CAEM2005, "52.62.2"), (Standards.CAEM2009, "47.89")),
        ((Standards.CAEM2005, "52.63"), (Standards.CAEM2009, "47.79")),
        ((Standards.CAEM2005, "52.63"), (Standards.CAEM2009, "47.91")),
        ((Standards.CAEM2005, "52.63"), (Standards.CAEM2009, "47.99")),
        ((Standards.CAEM2005, "52.63.1"), (Standards.CAEM2009, "47.79")),
        ((Standards.CAEM2005, "52.63.1"), (Standards.CAEM2009, "47.91")),
        ((Standards.CAEM2005, "52.63.1"), (Standards.CAEM2009, "47.99")),
        ((Standards.CAEM2005, "52.63.9"), (Standards.CAEM2009, "47.79")),
        ((Standards.CAEM2005, "52.63.9"), (Standards.CAEM2009, "47.91")),
        ((Standards.CAEM2005, "52.63.9"), (Standards.CAEM2009, "47.99")),
        ((Standards.CAEM2005, "52.7"), (Standards.CAEM2009, "13.3")),
        ((Standards.CAEM2005, "52.7"), (Standards.CAEM2009, "95.1")),
        ((Standards.CAEM2005, "52.7"), (Standards.CAEM2009, "95.2")),
        ((Standards.CAEM2005, "52.71"), (Standards.CAEM2009, "95.23")),
        ((Standards.CAEM2005, "52.71.1"), (Standards.CAEM2009, "95.23")),
        ((Standards.CAEM2005, "52.71.2"), (Standards.CAEM2009, "95.23")),
        ((Standards.CAEM2005, "52.72"), (Standards.CAEM2009, "95.21")),
        ((Standards.CAEM2005, "52.72"), (Standards.CAEM2009, "95.22")),
        ((Standards.CAEM2005, "52.72.0"), (Standards.CAEM2009, "95.21")),
        ((Standards.CAEM2005, "52.72.0"), (Standards.CAEM2009, "95.22")),
        ((Standards.CAEM2005, "52.73"), (Standards.CAEM2009, "95.25")),
        ((Standards.CAEM2005, "52.73.1"), (Standards.CAEM2009, "95.25")),
        ((Standards.CAEM2005, "52.73.2"), (Standards.CAEM2009, "95.25")),
        ((Standards.CAEM2005, "52.74"), (Standards.CAEM2009, "13.30")),
        ((Standards.CAEM2005, "52.74"), (Standards.CAEM2009, "95.12")),
        ((Standards.CAEM2005, "52.74"), (Standards.CAEM2009, "95.23")),
        ((Standards.CAEM2005, "52.74"), (Standards.CAEM2009, "95.24")),
        ((Standards.CAEM2005, "52.74"), (Standards.CAEM2009, "95.29")),
        ((Standards.CAEM2005, "52.74.1"), (Standards.CAEM2009, "13.30")),
        ((Standards.CAEM2005, "52.74.1"), (Standards.CAEM2009, "95.29")),
        ((Standards.CAEM2005, "52.74.2"), (Standards.CAEM2009, "13.30")),
        ((Standards.CAEM2005, "52.74.2"), (Standards.CAEM2009, "95.29")),
        ((Standards.CAEM2005, "52.74.3"), (Standards.CAEM2009, "95.23")),
        ((Standards.CAEM2005, "52.74.3"), (Standards.CAEM2009, "95.29")),
        ((Standards.CAEM2005, "52.74.4"), (Standards.CAEM2009, "95.24")),
        ((Standards.CAEM2005, "52.74.5"), (Standards.CAEM2009, "95.29")),
        ((Standards.CAEM2005, "52.74.6"), (Standards.CAEM2009, "95.29")),
        ((Standards.CAEM2005, "52.74.9"), (Standards.CAEM2009, "95.12")),
        ((Standards.CAEM2005, "52.74.9"), (Standards.CAEM2009, "95.29")),
        ((Standards.CAEM2005, "H"), (Standards.CAEM2009, "I")),
        ((Standards.CAEM2005, "55"), (Standards.CAEM2009, "55")),
        ((Standards.CAEM2005, "55"), (Standards.CAEM2009, "56")),
        ((Standards.CAEM2005, "55.1"), (Standards.CAEM2009, "55.1")),
        ((Standards.CAEM2005, "55.10"), (Standards.CAEM2009, "55.10")),
        ((Standards.CAEM2005, "55.10.0"), (Standards.CAEM2009, "55.10")),
        ((Standards.CAEM2005, "55.2"), (Standards.CAEM2009, "55.2")),
        ((Standards.CAEM2005, "55.2"), (Standards.CAEM2009, "55.3")),
        ((Standards.CAEM2005, "55.2"), (Standards.CAEM2009, "55.9")),
        ((Standards.CAEM2005, "55.21"), (Standards.CAEM2009, "55.20")),
        ((Standards.CAEM2005, "55.21"), (Standards.CAEM2009, "55.30")),
        ((Standards.CAEM2005, "55.21.0"), (Standards.CAEM2009, "55.20")),
        ((Standards.CAEM2005, "55.21.0"), (Standards.CAEM2009, "55.30")),
        ((Standards.CAEM2005, "55.22"), (Standards.CAEM2009, "55.30")),
        ((Standards.CAEM2005, "55.22.0"), (Standards.CAEM2009, "55.30")),
        ((Standards.CAEM2005, "55.23"), (Standards.CAEM2009, "55.20")),
        ((Standards.CAEM2005, "55.23"), (Standards.CAEM2009, "55.90")),
        ((Standards.CAEM2005, "55.23.0"), (Standards.CAEM2009, "55.20")),
        ((Standards.CAEM2005, "55.23.0"), (Standards.CAEM2009, "55.90")),
        ((Standards.CAEM2005, "55.3"), (Standards.CAEM2009, "56.1")),
        ((Standards.CAEM2005, "55.30"), (Standards.CAEM2009, "56.10")),
        ((Standards.CAEM2005, "55.30.0"), (Standards.CAEM2009, "56.10")),
        ((Standards.CAEM2005, "55.4"), (Standards.CAEM2009, "56.3")),
        ((Standards.CAEM2005, "55.40"), (Standards.CAEM2009, "56.30")),
        ((Standards.CAEM2005, "55.40.0"), (Standards.CAEM2009, "56.30")),
        ((Standards.CAEM2005, "55.5"), (Standards.CAEM2009, "56.2")),
        ((Standards.CAEM2005, "55.51"), (Standards.CAEM2009, "56.29")),
        ((Standards.CAEM2005, "55.51.0"), (Standards.CAEM2009, "56.29")),
        ((Standards.CAEM2005, "55.52"), (Standards.CAEM2009, "56.21")),
        ((Standards.CAEM2005, "55.52"), (Standards.CAEM2009, "56.29")),
        ((Standards.CAEM2005, "55.52.0"), (Standards.CAEM2009, "56.21")),
        ((Standards.CAEM2005, "55.52.0"), (Standards.CAEM2009, "56.29")),
        ((Standards.CAEM2005, "I"), (Standards.CAEM2009, "H")),
        ((Standards.CAEM2005, "I"), (Standards.CAEM2009, "J")),
        ((Standards.CAEM2005, "I"), (Standards.CAEM2009, "M")),
        ((Standards.CAEM2005, "I"), (Standards.CAEM2009, "N")),
        ((Standards.CAEM2005, "I"), (Standards.CAEM2009, "P")),
        ((Standards.CAEM2005, "60"), (Standards.CAEM2009, "49")),
        ((Standards.CAEM2005, "60"), (Standards.CAEM2009, "52")),
        ((Standards.CAEM2005, "60.1"), (Standards.CAEM2009, "49.1")),
        ((Standards.CAEM2005, "60.1"), (Standards.CAEM2009, "49.2")),
        ((Standards.CAEM2005, "60.1"), (Standards.CAEM2009, "52.2")),
        ((Standards.CAEM2005, "60.10"), (Standards.CAEM2009, "49.10")),
        ((Standards.CAEM2005, "60.10"), (Standards.CAEM2009, "49.20")),
        ((Standards.CAEM2005, "60.10"), (Standards.CAEM2009, "52.21")),
        ((Standards.CAEM2005, "60.10.0"), (Standards.CAEM2009, "49.10")),
        ((Standards.CAEM2005, "60.10.0"), (Standards.CAEM2009, "49.20")),
        ((Standards.CAEM2005, "60.10.0"), (Standards.CAEM2009, "52.21")),
        ((Standards.CAEM2005, "60.2"), (Standards.CAEM2009, "49.3")),
        ((Standards.CAEM2005, "60.2"), (Standards.CAEM2009, "49.4")),
        ((Standards.CAEM2005, "60.21"), (Standards.CAEM2009, "49.31")),
        ((Standards.CAEM2005, "60.21"), (Standards.CAEM2009, "49.39")),
        ((Standards.CAEM2005, "60.21.1"), (Standards.CAEM2009, "49.31")),
        ((Standards.CAEM2005, "60.21.2"), (Standards.CAEM2009, "49.31")),
        ((Standards.CAEM2005, "60.21.3"), (Standards.CAEM2009, "49.31")),
        ((Standards.CAEM2005, "60.21.4"), (Standards.CAEM2009, "49.31")),
        ((Standards.CAEM2005, "60.21.9"), (Standards.CAEM2009, "49.39")),
        ((Standards.CAEM2005, "60.22"), (Standards.CAEM2009, "49.32")),
        ((Standards.CAEM2005, "60.22.0"), (Standards.CAEM2009, "49.32")),
        ((Standards.CAEM2005, "60.23"), (Standards.CAEM2009, "49.39")),
        ((Standards.CAEM2005, "60.23.0"), (Standards.CAEM2009, "49.39")),
        ((Standards.CAEM2005, "60.24"), (Standards.CAEM2009, "49.41")),
        ((Standards.CAEM2005, "60.24"), (Standards.CAEM2009, "49.42")),
        ((Standards.CAEM2005, "60.24.0"), (Standards.CAEM2009, "49.41")),
        ((Standards.CAEM2005, "60.24.0"), (Standards.CAEM2009, "49.42")),
        ((Standards.CAEM2005, "60.3"), (Standards.CAEM2009, "49.5")),
        ((Standards.CAEM2005, "60.30"), (Standards.CAEM2009, "49.50")),
        ((Standards.CAEM2005, "60.30.0"), (Standards.CAEM2009, "49.50")),
        ((Standards.CAEM2005, "61"), (Standards.CAEM2009, "50")),
        ((Standards.CAEM2005, "61"), (Standards.CAEM2009, "52")),
        ((Standards.CAEM2005, "61.1"), (Standards.CAEM2009, "50.1")),
        ((Standards.CAEM2005, "61.1"), (Standards.CAEM2009, "50.2")),
        ((Standards.CAEM2005, "61.1"), (Standards.CAEM2009, "52.2")),
        ((Standards.CAEM2005, "61.10"), (Standards.CAEM2009, "50.10")),
        ((Standards.CAEM2005, "61.10"), (Standards.CAEM2009, "50.20")),
        ((Standards.CAEM2005, "61.10"), (Standards.CAEM2009, "52.22")),
        ((Standards.CAEM2005, "61.10.0"), (Standards.CAEM2009, "50.10")),
        ((Standards.CAEM2005, "61.10.0"), (Standards.CAEM2009, "50.20")),
        ((Standards.CAEM2005, "61.10.0"), (Standards.CAEM2009, "52.22")),
        ((Standards.CAEM2005, "61.2"), (Standards.CAEM2009, "50.3")),
        ((Standards.CAEM2005, "61.2"), (Standards.CAEM2009, "50.4")),
        ((Standards.CAEM2005, "61.2"), (Standards.CAEM2009, "52.2")),
        ((Standards.CAEM2005, "61.20"), (Standards.CAEM2009, "50.30")),
        ((Standards.CAEM2005, "61.20"), (Standards.CAEM2009, "50.40")),
        ((Standards.CAEM2005, "61.20"), (Standards.CAEM2009, "52.22")),
        ((Standards.CAEM2005, "61.20.0"), (Standards.CAEM2009, "50.30")),
        ((Standards.CAEM2005, "61.20.0"), (Standards.CAEM2009, "50.40")),
        ((Standards.CAEM2005, "61.20.0"), (Standards.CAEM2009, "52.22")),
        ((Standards.CAEM2005, "62"), (Standards.CAEM2009, "51")),
        ((Standards.CAEM2005, "62.1"), (Standards.CAEM2009, "51.1")),
        ((Standards.CAEM2005, "62.1"), (Standards.CAEM2009, "51.2")),
        ((Standards.CAEM2005, "62.10"), (Standards.CAEM2009, "51.10")),
        ((Standards.CAEM2005, "62.10"), (Standards.CAEM2009, "51.21")),
        ((Standards.CAEM2005, "62.10.0"), (Standards.CAEM2009, "51.10")),
        ((Standards.CAEM2005, "62.10.0"), (Standards.CAEM2009, "51.21")),
        ((Standards.CAEM2005, "62.2"), (Standards.CAEM2009, "51.1")),
        ((Standards.CAEM2005, "62.2"), (Standards.CAEM2009, "51.2")),
        ((Standards.CAEM2005, "62.20"), (Standards.CAEM2009, "51.10")),
        ((Standards.CAEM2005, "62.20"), (Standards.CAEM2009, "51.21")),
        ((Standards.CAEM2005, "62.20.0"), (Standards.CAEM2009, "51.10")),
        ((Standards.CAEM2005, "62.20.0"), (Standards.CAEM2009, "51.21")),
        ((Standards.CAEM2005, "62.3"), (Standards.CAEM2009, "51.2")),
        ((Standards.CAEM2005, "62.3"), (Standards.CAEM2009, "52.2")),
        ((Standards.CAEM2005, "62.30"), (Standards.CAEM2009, "51.22")),
        ((Standards.CAEM2005, "62.30"), (Standards.CAEM2009, "52.23")),
        ((Standards.CAEM2005, "62.30.0"), (Standards.CAEM2009, "51.22")),
        ((Standards.CAEM2005, "62.30.0"), (Standards.CAEM2009, "52.23")),
        ((Standards.CAEM2005, "63"), (Standards.CAEM2009, "52")),
        ((Standards.CAEM2005, "63"), (Standards.CAEM2009, "74")),
        ((Standards.CAEM2005, "63"), (Standards.CAEM2009, "79")),
        ((Standards.CAEM2005, "63"), (Standards.CAEM2009, "85")),
        ((Standards.CAEM2005, "63.1"), (Standards.CAEM2009, "52.1")),
        ((Standards.CAEM2005, "63.1"), (Standards.CAEM2009, "52.2")),
        ((Standards.CAEM2005, "63.11"), (Standards.CAEM2009, "52.24")),
        ((Standards.CAEM2005, "63.11.0"), (Standards.CAEM2009, "52.24")),
        ((Standards.CAEM2005, "63.12"), (Standards.CAEM2009, "52.10")),
        ((Standards.CAEM2005, "63.12.0"), (Standards.CAEM2009, "52.10")),
        ((Standards.CAEM2005, "63.2"), (Standards.CAEM2009, "52.2")),
        ((Standards.CAEM2005, "63.2"), (Standards.CAEM2009, "85.3")),
        ((Standards.CAEM2005, "63.21"), (Standards.CAEM2009, "52.21")),
        ((Standards.CAEM2005, "63.21.1"), (Standards.CAEM2009, "52.21")),
        ((Standards.CAEM2005, "63.21.2"), (Standards.CAEM2009, "52.21")),
        ((Standards.CAEM2005, "63.21.3"), (Standards.CAEM2009, "52.21")),
        ((Standards.CAEM2005, "63.21.4"), (Standards.CAEM2009, "52.21")),
        ((Standards.CAEM2005, "63.22"), (Standards.CAEM2009, "52.22")),
        ((Standards.CAEM2005, "63.22"), (Standards.CAEM2009, "85.32")),
        ((Standards.CAEM2005, "63.22.0"), (Standards.CAEM2009, "52.22")),
        ((Standards.CAEM2005, "63.22.0"), (Standards.CAEM2009, "85.32")),
        ((Standards.CAEM2005, "63.23"), (Standards.CAEM2009, "52.23")),
        ((Standards.CAEM2005, "63.23"), (Standards.CAEM2009, "85.32")),
        ((Standards.CAEM2005, "63.23.1"), (Standards.CAEM2009, "52.23")),
        ((Standards.CAEM2005, "63.23.9"), (Standards.CAEM2009, "52.23")),
        ((Standards.CAEM2005, "63.23.9"), (Standards.CAEM2009, "85.32")),
        ((Standards.CAEM2005, "63.3"), (Standards.CAEM2009, "79.1")),
        ((Standards.CAEM2005, "63.3"), (Standards.CAEM2009, "79.9")),
        ((Standards.CAEM2005, "63.30"), (Standards.CAEM2009, "79.11")),
        ((Standards.CAEM2005, "63.30"), (Standards.CAEM2009, "79.12")),
        ((Standards.CAEM2005, "63.30"), (Standards.CAEM2009, "79.90")),
        ((Standards.CAEM2005, "63.30.0"), (Standards.CAEM2009, "79.11")),
        ((Standards.CAEM2005, "63.30.0"), (Standards.CAEM2009, "79.12")),
        ((Standards.CAEM2005, "63.30.0"), (Standards.CAEM2009, "79.90")),
        ((Standards.CAEM2005, "63.4"), (Standards.CAEM2009, "52.2")),
        ((Standards.CAEM2005, "63.4"), (Standards.CAEM2009, "74.9")),
        ((Standards.CAEM2005, "63.40"), (Standards.CAEM2009, "52.29")),
        ((Standards.CAEM2005, "63.40"), (Standards.CAEM2009, "74.90")),
        ((Standards.CAEM2005, "63.40.1"), (Standards.CAEM2009, "52.29")),
        ((Standards.CAEM2005, "63.40.2"), (Standards.CAEM2009, "52.29")),
        ((Standards.CAEM2005, "63.40.2"), (Standards.CAEM2009, "74.90")),
        ((Standards.CAEM2005, "63.40.9"), (Standards.CAEM2009, "52.29")),
        ((Standards.CAEM2005, "64"), (Standards.CAEM2009, "53")),
        ((Standards.CAEM2005, "64"), (Standards.CAEM2009, "60")),
        ((Standards.CAEM2005, "64"), (Standards.CAEM2009, "61")),
        ((Standards.CAEM2005, "64"), (Standards.CAEM2009, "82")),
        ((Standards.CAEM2005, "64.1"), (Standards.CAEM2009, "53.1")),
        ((Standards.CAEM2005, "64.1"), (Standards.CAEM2009, "53.2")),
        ((Standards.CAEM2005, "64.1"), (Standards.CAEM2009, "82.1")),
        ((Standards.CAEM2005, "64.11"), (Standards.CAEM2009, "53.10")),
        ((Standards.CAEM2005, "64.11"), (Standards.CAEM2009, "82.19")),
        ((Standards.CAEM2005, "64.11.0"), (Standards.CAEM2009, "53.10")),
        ((Standards.CAEM2005, "64.11.0"), (Standards.CAEM2009, "82.19")),
        ((Standards.CAEM2005, "64.12"), (Standards.CAEM2009, "53.20")),
        ((Standards.CAEM2005, "64.12.0"), (Standards.CAEM2009, "53.20")),
        ((Standards.CAEM2005, "64.2"), (Standards.CAEM2009, "60.1")),
        ((Standards.CAEM2005, "64.2"), (Standards.CAEM2009, "60.2")),
        ((Standards.CAEM2005, "64.2"), (Standards.CAEM2009, "61.1")),
        ((Standards.CAEM2005, "64.2"), (Standards.CAEM2009, "61.2")),
        ((Standards.CAEM2005, "64.2"), (Standards.CAEM2009, "61.3")),
        ((Standards.CAEM2005, "64.2"), (Standards.CAEM2009, "61.9")),
        ((Standards.CAEM2005, "64.20"), (Standards.CAEM2009, "60.10")),
        ((Standards.CAEM2005, "64.20"), (Standards.CAEM2009, "60.20")),
        ((Standards.CAEM2005, "64.20"), (Standards.CAEM2009, "61.10")),
        ((Standards.CAEM2005, "64.20"), (Standards.CAEM2009, "61.20")),
        ((Standards.CAEM2005, "64.20"), (Standards.CAEM2009, "61.30")),
        ((Standards.CAEM2005, "64.20"), (Standards.CAEM2009, "61.90")),
        ((Standards.CAEM2005, "64.20.1"), (Standards.CAEM2009, "60.10")),
        ((Standards.CAEM2005, "64.20.1"), (Standards.CAEM2009, "60.20")),
        ((Standards.CAEM2005, "64.20.1"), (Standards.CAEM2009, "61.10")),
        ((Standards.CAEM2005, "64.20.1"), (Standards.CAEM2009, "61.20")),
        ((Standards.CAEM2005, "64.20.1"), (Standards.CAEM2009, "61.30")),
        ((Standards.CAEM2005, "64.20.1"), (Standards.CAEM2009, "61.90")),
        ((Standards.CAEM2005, "64.20.2"), (Standards.CAEM2009, "60.10")),
        ((Standards.CAEM2005, "64.20.2"), (Standards.CAEM2009, "60.20")),
        ((Standards.CAEM2005, "64.20.2"), (Standards.CAEM2009, "61.10")),
        ((Standards.CAEM2005, "64.20.2"), (Standards.CAEM2009, "61.20")),
        ((Standards.CAEM2005, "64.20.2"), (Standards.CAEM2009, "61.30")),
        ((Standards.CAEM2005, "64.20.2"), (Standards.CAEM2009, "61.90")),
        ((Standards.CAEM2005, "64.20.3"), (Standards.CAEM2009, "60.10")),
        ((Standards.CAEM2005, "64.20.3"), (Standards.CAEM2009, "60.20")),
        ((Standards.CAEM2005, "64.20.3"), (Standards.CAEM2009, "61.10")),
        ((Standards.CAEM2005, "64.20.3"), (Standards.CAEM2009, "61.20")),
        ((Standards.CAEM2005, "64.20.3"), (Standards.CAEM2009, "61.30")),
        ((Standards.CAEM2005, "64.20.3"), (Standards.CAEM2009, "61.90")),
        ((Standards.CAEM2005, "64.20.4"), (Standards.CAEM2009, "60.10")),
        ((Standards.CAEM2005, "64.20.4"), (Standards.CAEM2009, "60.20")),
        ((Standards.CAEM2005, "64.20.4"), (Standards.CAEM2009, "61.10")),
        ((Standards.CAEM2005, "64.20.4"), (Standards.CAEM2009, "61.20")),
        ((Standards.CAEM2005, "64.20.4"), (Standards.CAEM2009, "61.30")),
        ((Standards.CAEM2005, "64.20.4"), (Standards.CAEM2009, "61.90")),
        ((Standards.CAEM2005, "64.20.5"), (Standards.CAEM2009, "60.10")),
        ((Standards.CAEM2005, "64.20.5"), (Standards.CAEM2009, "60.20")),
        ((Standards.CAEM2005, "64.20.5"), (Standards.CAEM2009, "61.10")),
        ((Standards.CAEM2005, "64.20.5"), (Standards.CAEM2009, "61.20")),
        ((Standards.CAEM2005, "64.20.5"), (Standards.CAEM2009, "61.30")),
        ((Standards.CAEM2005, "64.20.5"), (Standards.CAEM2009, "61.90")),
        ((Standards.CAEM2005, "J"), (Standards.CAEM2009, "K")),
        ((Standards.CAEM2005, "65"), (Standards.CAEM2009, "64")),
        ((Standards.CAEM2005, "65.1"), (Standards.CAEM2009, "64.1")),
        ((Standards.CAEM2005, "65.11"), (Standards.CAEM2009, "64.11")),
        ((Standards.CAEM2005, "65.11.0"), (Standards.CAEM2009, "64.11")),
        ((Standards.CAEM2005, "65.12"), (Standards.CAEM2009, "64.19")),
        ((Standards.CAEM2005, "65.12.1"), (Standards.CAEM2009, "64.19")),
        ((Standards.CAEM2005, "65.12.2"), (Standards.CAEM2009, "64.19")),
        ((Standards.CAEM2005, "65.12.9"), (Standards.CAEM2009, "64.19")),
        ((Standards.CAEM2005, "65.2"), (Standards.CAEM2009, "64.2")),
        ((Standards.CAEM2005, "65.2"), (Standards.CAEM2009, "64.3")),
        ((Standards.CAEM2005, "65.2"), (Standards.CAEM2009, "64.9")),
        ((Standards.CAEM2005, "65.21"), (Standards.CAEM2009, "64.91")),
        ((Standards.CAEM2005, "65.21.0"), (Standards.CAEM2009, "64.91")),
        ((Standards.CAEM2005, "65.22"), (Standards.CAEM2009, "64.92")),
        ((Standards.CAEM2005, "65.22"), (Standards.CAEM2009, "64.99")),
        ((Standards.CAEM2005, "65.22.0"), (Standards.CAEM2009, "64.92")),
        ((Standards.CAEM2005, "65.22.0"), (Standards.CAEM2009, "64.99")),
        ((Standards.CAEM2005, "65.23"), (Standards.CAEM2009, "64.20")),
        ((Standards.CAEM2005, "65.23"), (Standards.CAEM2009, "64.30")),
        ((Standards.CAEM2005, "65.23"), (Standards.CAEM2009, "64.99")),
        ((Standards.CAEM2005, "65.23"), (Standards.CAEM2009, "64.92")),
        ((Standards.CAEM2005, "65.23.0"), (Standards.CAEM2009, "64.20")),
        ((Standards.CAEM2005, "65.23.0"), (Standards.CAEM2009, "64.30")),
        ((Standards.CAEM2005, "65.23.0"), (Standards.CAEM2009, "64.99")),
        ((Standards.CAEM2005, "65.23.0"), (Standards.CAEM2009, "64.92")),
        ((Standards.CAEM2005, "66"), (Standards.CAEM2009, "65")),
        ((Standards.CAEM2005, "66.0"), (Standards.CAEM2009, "65.1")),
        ((Standards.CAEM2005, "66.0"), (Standards.CAEM2009, "65.2")),
        ((Standards.CAEM2005, "66.0"), (Standards.CAEM2009, "65.3")),
        ((Standards.CAEM2005, "66.01"), (Standards.CAEM2009, "65.11")),
        ((Standards.CAEM2005, "66.01"), (Standards.CAEM2009, "65.20")),
        ((Standards.CAEM2005, "66.01.1"), (Standards.CAEM2009, "65.11")),
        ((Standards.CAEM2005, "66.01.1"), (Standards.CAEM2009, "65.20")),
        ((Standards.CAEM2005, "66.01.2"), (Standards.CAEM2009, "65.11")),
        ((Standards.CAEM2005, "66.01.2"), (Standards.CAEM2009, "65.20")),
        ((Standards.CAEM2005, "66.02"), (Standards.CAEM2009, "65.20")),
        ((Standards.CAEM2005, "66.02"), (Standards.CAEM2009, "65.30")),
        ((Standards.CAEM2005, "66.02.1"), (Standards.CAEM2009, "65.20")),
        ((Standards.CAEM2005, "66.02.1"), (Standards.CAEM2009, "65.30")),
        ((Standards.CAEM2005, "66.02.2"), (Standards.CAEM2009, "65.20")),
        ((Standards.CAEM2005, "66.02.2"), (Standards.CAEM2009, "65.30")),
        ((Standards.CAEM2005, "66.03"), (Standards.CAEM2009, "65.12")),
        ((Standards.CAEM2005, "66.03"), (Standards.CAEM2009, "65.20")),
        ((Standards.CAEM2005, "66.03.1"), (Standards.CAEM2009, "65.12")),
        ((Standards.CAEM2005, "66.03.1"), (Standards.CAEM2009, "65.20")),
        ((Standards.CAEM2005, "66.03.2"), (Standards.CAEM2009, "65.12")),
        ((Standards.CAEM2005, "66.03.2"), (Standards.CAEM2009, "65.20")),
        ((Standards.CAEM2005, "67"), (Standards.CAEM2009, "66")),
        ((Standards.CAEM2005, "67.1"), (Standards.CAEM2009, "66.1")),
        ((Standards.CAEM2005, "67.1"), (Standards.CAEM2009, "66.3")),
        ((Standards.CAEM2005, "67.11"), (Standards.CAEM2009, "66.11")),
        ((Standards.CAEM2005, "67.11.0"), (Standards.CAEM2009, "66.11")),
        ((Standards.CAEM2005, "67.12"), (Standards.CAEM2009, "66.12")),
        ((Standards.CAEM2005, "67.12"), (Standards.CAEM2009, "66.30")),
        ((Standards.CAEM2005, "67.12.0"), (Standards.CAEM2009, "66.12")),
        ((Standards.CAEM2005, "67.12.0"), (Standards.CAEM2009, "66.30")),
        ((Standards.CAEM2005, "67.13"), (Standards.CAEM2009, "66.12")),
        ((Standards.CAEM2005, "67.13"), (Standards.CAEM2009, "66.19")),
        ((Standards.CAEM2005, "67.13.0"), (Standards.CAEM2009, "66.12")),
        ((Standards.CAEM2005, "67.13.0"), (Standards.CAEM2009, "66.19")),
        ((Standards.CAEM2005, "67.2"), (Standards.CAEM2009, "66.2")),
        ((Standards.CAEM2005, "67.20"), (Standards.CAEM2009, "66.21")),
        ((Standards.CAEM2005, "67.20"), (Standards.CAEM2009, "66.22")),
        ((Standards.CAEM2005, "67.20"), (Standards.CAEM2009, "66.29")),
        ((Standards.CAEM2005, "67.20.0"), (Standards.CAEM2009, "66.21")),
        ((Standards.CAEM2005, "67.20.0"), (Standards.CAEM2009, "66.22")),
        ((Standards.CAEM2005, "67.20.0"), (Standards.CAEM2009, "66.29")),
        ((Standards.CAEM2005, "K"), (Standards.CAEM2009, "A")),
        ((Standards.CAEM2005, "K"), (Standards.CAEM2009, "F")),
        ((Standards.CAEM2005, "K"), (Standards.CAEM2009, "J")),
        ((Standards.CAEM2005, "K"), (Standards.CAEM2009, "K")),
        ((Standards.CAEM2005, "K"), (Standards.CAEM2009, "L")),
        ((Standards.CAEM2005, "K"), (Standards.CAEM2009, "M")),
        ((Standards.CAEM2005, "K"), (Standards.CAEM2009, "N")),
        ((Standards.CAEM2005, "K"), (Standards.CAEM2009, "P")),
        ((Standards.CAEM2005, "K"), (Standards.CAEM2009, "S")),
        ((Standards.CAEM2005, "70"), (Standards.CAEM2009, "41")),
        ((Standards.CAEM2005, "70"), (Standards.CAEM2009, "68")),
        ((Standards.CAEM2005, "70"), (Standards.CAEM2009, "81")),
        ((Standards.CAEM2005, "70.1"), (Standards.CAEM2009, "41.1")),
        ((Standards.CAEM2005, "70.1"), (Standards.CAEM2009, "68.1")),
        ((Standards.CAEM2005, "70.11"), (Standards.CAEM2009, "41.10")),
        ((Standards.CAEM2005, "70.11.0"), (Standards.CAEM2009, "41.10")),
        ((Standards.CAEM2005, "70.12"), (Standards.CAEM2009, "68.10")),
        ((Standards.CAEM2005, "70.12.0"), (Standards.CAEM2009, "68.10")),
        ((Standards.CAEM2005, "70.2"), (Standards.CAEM2009, "68.2")),
        ((Standards.CAEM2005, "70.20"), (Standards.CAEM2009, "68.20")),
        ((Standards.CAEM2005, "70.20.0"), (Standards.CAEM2009, "68.20")),
        ((Standards.CAEM2005, "70.3"), (Standards.CAEM2009, "68.3")),
        ((Standards.CAEM2005, "70.3"), (Standards.CAEM2009, "81.1")),
        ((Standards.CAEM2005, "70.31"), (Standards.CAEM2009, "68.31")),
        ((Standards.CAEM2005, "70.31.1"), (Standards.CAEM2009, "68.31")),
        ((Standards.CAEM2005, "70.31.2"), (Standards.CAEM2009, "68.31")),
        ((Standards.CAEM2005, "70.32"), (Standards.CAEM2009, "68.32")),
        ((Standards.CAEM2005, "70.32"), (Standards.CAEM2009, "81.10")),
        ((Standards.CAEM2005, "70.32.0"), (Standards.CAEM2009, "68.32")),
        ((Standards.CAEM2005, "70.32.0"), (Standards.CAEM2009, "81.10")),
        ((Standards.CAEM2005, "71"), (Standards.CAEM2009, "77")),
        ((Standards.CAEM2005, "71.1"), (Standards.CAEM2009, "77.1")),
        ((Standards.CAEM2005, "71.10"), (Standards.CAEM2009, "77.11")),
        ((Standards.CAEM2005, "71.10.0"), (Standards.CAEM2009, "77.11")),
        ((Standards.CAEM2005, "71.2"), (Standards.CAEM2009, "77.1")),
        ((Standards.CAEM2005, "71.2"), (Standards.CAEM2009, "77.3")),
        ((Standards.CAEM2005, "71.21"), (Standards.CAEM2009, "77.12")),
        ((Standards.CAEM2005, "71.21"), (Standards.CAEM2009, "77.39")),
        ((Standards.CAEM2005, "71.21.0"), (Standards.CAEM2009, "77.12")),
        ((Standards.CAEM2005, "71.21.0"), (Standards.CAEM2009, "77.39")),
        ((Standards.CAEM2005, "71.22"), (Standards.CAEM2009, "77.34")),
        ((Standards.CAEM2005, "71.22.0"), (Standards.CAEM2009, "77.34")),
        ((Standards.CAEM2005, "71.23"), (Standards.CAEM2009, "77.35")),
        ((Standards.CAEM2005, "71.23.0"), (Standards.CAEM2009, "77.35")),
        ((Standards.CAEM2005, "71.3"), (Standards.CAEM2009, "77.3")),
        ((Standards.CAEM2005, "71.31"), (Standards.CAEM2009, "77.31")),
        ((Standards.CAEM2005, "71.31.0"), (Standards.CAEM2009, "77.31")),
        ((Standards.CAEM2005, "71.32"), (Standards.CAEM2009, "77.32")),
        ((Standards.CAEM2005, "71.32"), (Standards.CAEM2009, "77.39")),
        ((Standards.CAEM2005, "71.32.0"), (Standards.CAEM2009, "77.32")),
        ((Standards.CAEM2005, "71.32.0"), (Standards.CAEM2009, "77.39")),
        ((Standards.CAEM2005, "71.33"), (Standards.CAEM2009, "77.33")),
        ((Standards.CAEM2005, "71.33.0"), (Standards.CAEM2009, "77.33")),
        ((Standards.CAEM2005, "71.34"), (Standards.CAEM2009, "77.39")),
        ((Standards.CAEM2005, "71.34.0"), (Standards.CAEM2009, "77.39")),
        ((Standards.CAEM2005, "71.4"), (Standards.CAEM2009, "77.2")),
        ((Standards.CAEM2005, "71.40"), (Standards.CAEM2009, "77.21")),
        ((Standards.CAEM2005, "71.40"), (Standards.CAEM2009, "77.22")),
        ((Standards.CAEM2005, "71.40"), (Standards.CAEM2009, "77.29")),
        ((Standards.CAEM2005, "71.40.0"), (Standards.CAEM2009, "77.21")),
        ((Standards.CAEM2005, "71.40.0"), (Standards.CAEM2009, "77.22")),
        ((Standards.CAEM2005, "71.40.0"), (Standards.CAEM2009, "77.29")),
        ((Standards.CAEM2005, "72"), (Standards.CAEM2009, "33")),
        ((Standards.CAEM2005, "72"), (Standards.CAEM2009, "58")),
        ((Standards.CAEM2005, "72"), (Standards.CAEM2009, "59")),
        ((Standards.CAEM2005, "72"), (Standards.CAEM2009, "60")),
        ((Standards.CAEM2005, "72"), (Standards.CAEM2009, "62")),
        ((Standards.CAEM2005, "72"), (Standards.CAEM2009, "63")),
        ((Standards.CAEM2005, "72"), (Standards.CAEM2009, "95")),
        ((Standards.CAEM2005, "72.1"), (Standards.CAEM2009, "62.0")),
        ((Standards.CAEM2005, "72.10"), (Standards.CAEM2009, "62.02")),
        ((Standards.CAEM2005, "72.10.0"), (Standards.CAEM2009, "62.02")),
        ((Standards.CAEM2005, "72.2"), (Standards.CAEM2009, "58.2")),
        ((Standards.CAEM2005, "72.2"), (Standards.CAEM2009, "62.0")),
        ((Standards.CAEM2005, "72.21"), (Standards.CAEM2009, "58.21")),
        ((Standards.CAEM2005, "72.21"), (Standards.CAEM2009, "58.29")),
        ((Standards.CAEM2005, "72.21.0"), (Standards.CAEM2009, "58.21")),
        ((Standards.CAEM2005, "72.21.0"), (Standards.CAEM2009, "58.29")),
        ((Standards.CAEM2005, "72.22"), (Standards.CAEM2009, "62.01")),
        ((Standards.CAEM2005, "72.22"), (Standards.CAEM2009, "62.02")),
        ((Standards.CAEM2005, "72.22"), (Standards.CAEM2009, "62.09")),
        ((Standards.CAEM2005, "72.22.0"), (Standards.CAEM2009, "62.01")),
        ((Standards.CAEM2005, "72.22.0"), (Standards.CAEM2009, "62.02")),
        ((Standards.CAEM2005, "72.22.0"), (Standards.CAEM2009, "62.09")),
        ((Standards.CAEM2005, "72.3"), (Standards.CAEM2009, "62.0")),
        ((Standards.CAEM2005, "72.3"), (Standards.CAEM2009, "63.1")),
        ((Standards.CAEM2005, "72.30"), (Standards.CAEM2009, "62.03")),
        ((Standards.CAEM2005, "72.30"), (Standards.CAEM2009, "63.11")),
        ((Standards.CAEM2005, "72.30.0"), (Standards.CAEM2009, "62.03")),
        ((Standards.CAEM2005, "72.30.0"), (Standards.CAEM2009, "63.11")),
        ((Standards.CAEM2005, "72.4"), (Standards.CAEM2009, "58.1")),
        ((Standards.CAEM2005, "72.4"), (Standards.CAEM2009, "58.2")),
        ((Standards.CAEM2005, "72.4"), (Standards.CAEM2009, "59.2")),
        ((Standards.CAEM2005, "72.4"), (Standards.CAEM2009, "60.1")),
        ((Standards.CAEM2005, "72.4"), (Standards.CAEM2009, "60.2")),
        ((Standards.CAEM2005, "72.4"), (Standards.CAEM2009, "62.0")),
        ((Standards.CAEM2005, "72.4"), (Standards.CAEM2009, "63.1")),
        ((Standards.CAEM2005, "72.40"), (Standards.CAEM2009, "58.11")),
        ((Standards.CAEM2005, "72.40"), (Standards.CAEM2009, "58.12")),
        ((Standards.CAEM2005, "72.40"), (Standards.CAEM2009, "58.13")),
        ((Standards.CAEM2005, "72.40"), (Standards.CAEM2009, "58.14")),
        ((Standards.CAEM2005, "72.40"), (Standards.CAEM2009, "58.19")),
        ((Standards.CAEM2005, "72.40"), (Standards.CAEM2009, "58.21")),
        ((Standards.CAEM2005, "72.40"), (Standards.CAEM2009, "58.29")),
        ((Standards.CAEM2005, "72.40"), (Standards.CAEM2009, "59.20")),
        ((Standards.CAEM2005, "72.40"), (Standards.CAEM2009, "60.10")),
        ((Standards.CAEM2005, "72.40"), (Standards.CAEM2009, "60.20")),
        ((Standards.CAEM2005, "72.40"), (Standards.CAEM2009, "62.01")),
        ((Standards.CAEM2005, "72.40"), (Standards.CAEM2009, "63.11")),
        ((Standards.CAEM2005, "72.40"), (Standards.CAEM2009, "63.12")),
        ((Standards.CAEM2005, "72.40.0"), (Standards.CAEM2009, "58.11")),
        ((Standards.CAEM2005, "72.40.0"), (Standards.CAEM2009, "58.12")),
        ((Standards.CAEM2005, "72.40.0"), (Standards.CAEM2009, "58.13")),
        ((Standards.CAEM2005, "72.40.0"), (Standards.CAEM2009, "58.14")),
        ((Standards.CAEM2005, "72.40.0"), (Standards.CAEM2009, "58.19")),
        ((Standards.CAEM2005, "72.40.0"), (Standards.CAEM2009, "58.21")),
        ((Standards.CAEM2005, "72.40.0"), (Standards.CAEM2009, "58.29")),
        ((Standards.CAEM2005, "72.40.0"), (Standards.CAEM2009, "59.20")),
        ((Standards.CAEM2005, "72.40.0"), (Standards.CAEM2009, "60.10")),
        ((Standards.CAEM2005, "72.40.0"), (Standards.CAEM2009, "60.20")),
        ((Standards.CAEM2005, "72.40.0"), (Standards.CAEM2009, "62.01")),
        ((Standards.CAEM2005, "72.40.0"), (Standards.CAEM2009, "63.11")),
        ((Standards.CAEM2005, "72.40.0"), (Standards.CAEM2009, "63.12")),
        ((Standards.CAEM2005, "72.5"), (Standards.CAEM2009, "33.1")),
        ((Standards.CAEM2005, "72.5"), (Standards.CAEM2009, "95.1")),
        ((Standards.CAEM2005, "72.50"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "72.50"), (Standards.CAEM2009, "95.11")),
        ((Standards.CAEM2005, "72.50.0"), (Standards.CAEM2009, "33.12")),
        ((Standards.CAEM2005, "72.50.0"), (Standards.CAEM2009, "95.11")),
        ((Standards.CAEM2005, "72.6"), (Standards.CAEM2009, "62.0")),
        ((Standards.CAEM2005, "72.60"), (Standards.CAEM2009, "62.09")),
        ((Standards.CAEM2005, "72.60.0"), (Standards.CAEM2009, "62.09")),
        ((Standards.CAEM2005, "73"), (Standards.CAEM2009, "72")),
        ((Standards.CAEM2005, "73.1"), (Standards.CAEM2009, "72.1")),
        ((Standards.CAEM2005, "73.1"), (Standards.CAEM2009, "72.2")),
        ((Standards.CAEM2005, "73.10"), (Standards.CAEM2009, "72.11")),
        ((Standards.CAEM2005, "73.10"), (Standards.CAEM2009, "72.19")),
        ((Standards.CAEM2005, "73.10"), (Standards.CAEM2009, "72.20")),
        ((Standards.CAEM2005, "73.10.0"), (Standards.CAEM2009, "72.11")),
        ((Standards.CAEM2005, "73.10.0"), (Standards.CAEM2009, "72.19")),
        ((Standards.CAEM2005, "73.10.0"), (Standards.CAEM2009, "72.20")),
        ((Standards.CAEM2005, "73.2"), (Standards.CAEM2009, "72.2")),
        ((Standards.CAEM2005, "73.20"), (Standards.CAEM2009, "72.20")),
        ((Standards.CAEM2005, "73.20.0"), (Standards.CAEM2009, "72.20")),
        ((Standards.CAEM2005, "74"), (Standards.CAEM2009, "02")),
        ((Standards.CAEM2005, "74"), (Standards.CAEM2009, "59")),
        ((Standards.CAEM2005, "74"), (Standards.CAEM2009, "63")),
        ((Standards.CAEM2005, "74"), (Standards.CAEM2009, "64")),
        ((Standards.CAEM2005, "74"), (Standards.CAEM2009, "69")),
        ((Standards.CAEM2005, "74"), (Standards.CAEM2009, "70")),
        ((Standards.CAEM2005, "74"), (Standards.CAEM2009, "71")),
        ((Standards.CAEM2005, "74"), (Standards.CAEM2009, "73")),
        ((Standards.CAEM2005, "74"), (Standards.CAEM2009, "74")),
        ((Standards.CAEM2005, "74"), (Standards.CAEM2009, "77")),
        ((Standards.CAEM2005, "74"), (Standards.CAEM2009, "78")),
        ((Standards.CAEM2005, "74"), (Standards.CAEM2009, "80")),
        ((Standards.CAEM2005, "74"), (Standards.CAEM2009, "81")),
        ((Standards.CAEM2005, "74"), (Standards.CAEM2009, "82")),
        ((Standards.CAEM2005, "74"), (Standards.CAEM2009, "85")),
        ((Standards.CAEM2005, "74.1"), (Standards.CAEM2009, "02.4")),
        ((Standards.CAEM2005, "74.1"), (Standards.CAEM2009, "64.2")),
        ((Standards.CAEM2005, "74.1"), (Standards.CAEM2009, "69.1")),
        ((Standards.CAEM2005, "74.1"), (Standards.CAEM2009, "69.2")),
        ((Standards.CAEM2005, "74.1"), (Standards.CAEM2009, "70.1")),
        ((Standards.CAEM2005, "74.1"), (Standards.CAEM2009, "70.2")),
        ((Standards.CAEM2005, "74.1"), (Standards.CAEM2009, "73.2")),
        ((Standards.CAEM2005, "74.1"), (Standards.CAEM2009, "74.9")),
        ((Standards.CAEM2005, "74.1"), (Standards.CAEM2009, "85.6")),
        ((Standards.CAEM2005, "74.11"), (Standards.CAEM2009, "69.10")),
        ((Standards.CAEM2005, "74.11.1"), (Standards.CAEM2009, "69.10")),
        ((Standards.CAEM2005, "74.11.2"), (Standards.CAEM2009, "69.10")),
        ((Standards.CAEM2005, "74.12"), (Standards.CAEM2009, "69.20")),
        ((Standards.CAEM2005, "74.12.0"), (Standards.CAEM2009, "69.20")),
        ((Standards.CAEM2005, "74.13"), (Standards.CAEM2009, "73.20")),
        ((Standards.CAEM2005, "74.13.0"), (Standards.CAEM2009, "73.20")),
        ((Standards.CAEM2005, "74.14"), (Standards.CAEM2009, "02.40")),
        ((Standards.CAEM2005, "74.14"), (Standards.CAEM2009, "70.21")),
        ((Standards.CAEM2005, "74.14"), (Standards.CAEM2009, "70.22")),
        ((Standards.CAEM2005, "74.14"), (Standards.CAEM2009, "74.90")),
        ((Standards.CAEM2005, "74.14"), (Standards.CAEM2009, "85.60")),
        ((Standards.CAEM2005, "74.14.0"), (Standards.CAEM2009, "02.40")),
        ((Standards.CAEM2005, "74.14.0"), (Standards.CAEM2009, "70.21")),
        ((Standards.CAEM2005, "74.14.0"), (Standards.CAEM2009, "70.22")),
        ((Standards.CAEM2005, "74.14.0"), (Standards.CAEM2009, "74.90")),
        ((Standards.CAEM2005, "74.14.0"), (Standards.CAEM2009, "85.60")),
        ((Standards.CAEM2005, "74.15"), (Standards.CAEM2009, "64.20")),
        ((Standards.CAEM2005, "74.15"), (Standards.CAEM2009, "70.10")),
        ((Standards.CAEM2005, "74.15.0"), (Standards.CAEM2009, "64.20")),
        ((Standards.CAEM2005, "74.15.0"), (Standards.CAEM2009, "70.10")),
        ((Standards.CAEM2005, "74.2"), (Standards.CAEM2009, "71.1")),
        ((Standards.CAEM2005, "74.2"), (Standards.CAEM2009, "74.2")),
        ((Standards.CAEM2005, "74.2"), (Standards.CAEM2009, "74.9")),
        ((Standards.CAEM2005, "74.20"), (Standards.CAEM2009, "71.11")),
        ((Standards.CAEM2005, "74.20"), (Standards.CAEM2009, "71.12")),
        ((Standards.CAEM2005, "74.20"), (Standards.CAEM2009, "74.20")),
        ((Standards.CAEM2005, "74.20"), (Standards.CAEM2009, "74.90")),
        ((Standards.CAEM2005, "74.20.1"), (Standards.CAEM2009, "71.11")),
        ((Standards.CAEM2005, "74.20.1"), (Standards.CAEM2009, "71.12")),
        ((Standards.CAEM2005, "74.20.2"), (Standards.CAEM2009, "71.12")),
        ((Standards.CAEM2005, "74.20.3"), (Standards.CAEM2009, "71.12")),
        ((Standards.CAEM2005, "74.20.3"), (Standards.CAEM2009, "74.20")),
        ((Standards.CAEM2005, "74.20.4"), (Standards.CAEM2009, "71.12")),
        ((Standards.CAEM2005, "74.20.4"), (Standards.CAEM2009, "74.90")),
        ((Standards.CAEM2005, "74.20.5"), (Standards.CAEM2009, "71.12")),
        ((Standards.CAEM2005, "74.3"), (Standards.CAEM2009, "71.2")),
        ((Standards.CAEM2005, "74.30"), (Standards.CAEM2009, "71.20")),
        ((Standards.CAEM2005, "74.30.1"), (Standards.CAEM2009, "71.20")),
        ((Standards.CAEM2005, "74.30.2"), (Standards.CAEM2009, "71.20")),
        ((Standards.CAEM2005, "74.30.9"), (Standards.CAEM2009, "71.20")),
        ((Standards.CAEM2005, "74.4"), (Standards.CAEM2009, "73.1")),
        ((Standards.CAEM2005, "74.40"), (Standards.CAEM2009, "73.11")),
        ((Standards.CAEM2005, "74.40"), (Standards.CAEM2009, "73.12")),
        ((Standards.CAEM2005, "74.40.0"), (Standards.CAEM2009, "73.11")),
        ((Standards.CAEM2005, "74.40.0"), (Standards.CAEM2009, "73.12")),
        ((Standards.CAEM2005, "74.5"), (Standards.CAEM2009, "78.1")),
        ((Standards.CAEM2005, "74.5"), (Standards.CAEM2009, "78.2")),
        ((Standards.CAEM2005, "74.5"), (Standards.CAEM2009, "78.3")),
        ((Standards.CAEM2005, "74.50"), (Standards.CAEM2009, "78.10")),
        ((Standards.CAEM2005, "74.50"), (Standards.CAEM2009, "78.20")),
        ((Standards.CAEM2005, "74.50"), (Standards.CAEM2009, "78.30")),
        ((Standards.CAEM2005, "74.50.0"), (Standards.CAEM2009, "78.10")),
        ((Standards.CAEM2005, "74.50.0"), (Standards.CAEM2009, "78.20")),
        ((Standards.CAEM2005, "74.50.0"), (Standards.CAEM2009, "78.30")),
        ((Standards.CAEM2005, "74.6"), (Standards.CAEM2009, "74.9")),
        ((Standards.CAEM2005, "74.6"), (Standards.CAEM2009, "80.1")),
        ((Standards.CAEM2005, "74.6"), (Standards.CAEM2009, "80.2")),
        ((Standards.CAEM2005, "74.6"), (Standards.CAEM2009, "80.3")),
        ((Standards.CAEM2005, "74.60"), (Standards.CAEM2009, "74.90")),
        ((Standards.CAEM2005, "74.60"), (Standards.CAEM2009, "80.10")),
        ((Standards.CAEM2005, "74.60"), (Standards.CAEM2009, "80.20")),
        ((Standards.CAEM2005, "74.60"), (Standards.CAEM2009, "80.30")),
        ((Standards.CAEM2005, "74.60.0"), (Standards.CAEM2009, "74.90")),
        ((Standards.CAEM2005, "74.60.0"), (Standards.CAEM2009, "80.10")),
        ((Standards.CAEM2005, "74.60.0"), (Standards.CAEM2009, "80.20")),
        ((Standards.CAEM2005, "74.60.0"), (Standards.CAEM2009, "80.30")),
        ((Standards.CAEM2005, "74.7"), (Standards.CAEM2009, "81.2")),
        ((Standards.CAEM2005, "74.70"), (Standards.CAEM2009, "81.21")),
        ((Standards.CAEM2005, "74.70"), (Standards.CAEM2009, "81.22")),
        ((Standards.CAEM2005, "74.70"), (Standards.CAEM2009, "81.29")),
        ((Standards.CAEM2005, "74.70.0"), (Standards.CAEM2009, "81.21")),
        ((Standards.CAEM2005, "74.70.0"), (Standards.CAEM2009, "81.22")),
        ((Standards.CAEM2005, "74.70.0"), (Standards.CAEM2009, "81.29")),
        ((Standards.CAEM2005, "74.8"), (Standards.CAEM2009, "59.2")),
        ((Standards.CAEM2005, "74.8"), (Standards.CAEM2009, "63.9")),
        ((Standards.CAEM2005, "74.8"), (Standards.CAEM2009, "74.1")),
        ((Standards.CAEM2005, "74.8"), (Standards.CAEM2009, "74.2")),
        ((Standards.CAEM2005, "74.8"), (Standards.CAEM2009, "74.3")),
        ((Standards.CAEM2005, "74.8"), (Standards.CAEM2009, "74.9")),
        ((Standards.CAEM2005, "74.8"), (Standards.CAEM2009, "77.4")),
        ((Standards.CAEM2005, "74.8"), (Standards.CAEM2009, "82.1")),
        ((Standards.CAEM2005, "74.8"), (Standards.CAEM2009, "82.2")),
        ((Standards.CAEM2005, "74.8"), (Standards.CAEM2009, "82.3")),
        ((Standards.CAEM2005, "74.8"), (Standards.CAEM2009, "82.9")),
        ((Standards.CAEM2005, "74.81"), (Standards.CAEM2009, "74.20")),
        ((Standards.CAEM2005, "74.81.0"), (Standards.CAEM2009, "74.20")),
        ((Standards.CAEM2005, "74.82"), (Standards.CAEM2009, "82.92")),
        ((Standards.CAEM2005, "74.82.0"), (Standards.CAEM2009, "82.92")),
        ((Standards.CAEM2005, "74.85"), (Standards.CAEM2009, "74.30")),
        ((Standards.CAEM2005, "74.85"), (Standards.CAEM2009, "82.11")),
        ((Standards.CAEM2005, "74.85"), (Standards.CAEM2009, "82.19")),
        ((Standards.CAEM2005, "74.85"), (Standards.CAEM2009, "82.99")),
        ((Standards.CAEM2005, "74.85.0"), (Standards.CAEM2009, "74.30")),
        ((Standards.CAEM2005, "74.85.0"), (Standards.CAEM2009, "82.11")),
        ((Standards.CAEM2005, "74.85.0"), (Standards.CAEM2009, "82.19")),
        ((Standards.CAEM2005, "74.85.0"), (Standards.CAEM2009, "82.99")),
        ((Standards.CAEM2005, "74.86"), (Standards.CAEM2009, "82.20")),
        ((Standards.CAEM2005, "74.86.0"), (Standards.CAEM2009, "82.20")),
        ((Standards.CAEM2005, "74.87"), (Standards.CAEM2009, "59.20")),
        ((Standards.CAEM2005, "74.87"), (Standards.CAEM2009, "63.99")),
        ((Standards.CAEM2005, "74.87"), (Standards.CAEM2009, "74.10")),
        ((Standards.CAEM2005, "74.87"), (Standards.CAEM2009, "74.90")),
        ((Standards.CAEM2005, "74.87"), (Standards.CAEM2009, "77.40")),
        ((Standards.CAEM2005, "74.87"), (Standards.CAEM2009, "82.30")),
        ((Standards.CAEM2005, "74.87"), (Standards.CAEM2009, "82.91")),
        ((Standards.CAEM2005, "74.87"), (Standards.CAEM2009, "82.99")),
        ((Standards.CAEM2005, "74.87.0"), (Standards.CAEM2009, "59.20")),
        ((Standards.CAEM2005, "74.87.0"), (Standards.CAEM2009, "63.99")),
        ((Standards.CAEM2005, "74.87.0"), (Standards.CAEM2009, "74.10")),
        ((Standards.CAEM2005, "74.87.0"), (Standards.CAEM2009, "74.90")),
        ((Standards.CAEM2005, "74.87.0"), (Standards.CAEM2009, "77.40")),
        ((Standards.CAEM2005, "74.87.0"), (Standards.CAEM2009, "82.30")),
        ((Standards.CAEM2005, "74.87.0"), (Standards.CAEM2009, "82.91")),
        ((Standards.CAEM2005, "74.87.0"), (Standards.CAEM2009, "82.99")),
        ((Standards.CAEM2005, "L"), (Standards.CAEM2009, "N")),
        ((Standards.CAEM2005, "L"), (Standards.CAEM2009, "O")),
        ((Standards.CAEM2005, "L"), (Standards.CAEM2009, "Q")),
        ((Standards.CAEM2005, "L"), (Standards.CAEM2009, "R")),
        ((Standards.CAEM2005, "75"), (Standards.CAEM2009, "81")),
        ((Standards.CAEM2005, "75"), (Standards.CAEM2009, "82")),
        ((Standards.CAEM2005, "75"), (Standards.CAEM2009, "84")),
        ((Standards.CAEM2005, "75"), (Standards.CAEM2009, "88")),
        ((Standards.CAEM2005, "75"), (Standards.CAEM2009, "91")),
        ((Standards.CAEM2005, "75.1"), (Standards.CAEM2009, "81.1")),
        ((Standards.CAEM2005, "75.1"), (Standards.CAEM2009, "82.9")),
        ((Standards.CAEM2005, "75.1"), (Standards.CAEM2009, "84.1")),
        ((Standards.CAEM2005, "75.1"), (Standards.CAEM2009, "91.0")),
        ((Standards.CAEM2005, "75.11"), (Standards.CAEM2009, "84.11")),
        ((Standards.CAEM2005, "75.11.1"), (Standards.CAEM2009, "84.11")),
        ((Standards.CAEM2005, "75.11.2"), (Standards.CAEM2009, "84.11")),
        ((Standards.CAEM2005, "75.11.3"), (Standards.CAEM2009, "84.11")),
        ((Standards.CAEM2005, "75.11.4"), (Standards.CAEM2009, "84.11")),
        ((Standards.CAEM2005, "75.11.5"), (Standards.CAEM2009, "84.11")),
        ((Standards.CAEM2005, "75.11.6"), (Standards.CAEM2009, "84.11")),
        ((Standards.CAEM2005, "75.11.7"), (Standards.CAEM2009, "84.11")),
        ((Standards.CAEM2005, "75.12"), (Standards.CAEM2009, "84.12")),
        ((Standards.CAEM2005, "75.12.0"), (Standards.CAEM2009, "84.12")),
        ((Standards.CAEM2005, "75.13"), (Standards.CAEM2009, "82.99")),
        ((Standards.CAEM2005, "75.13"), (Standards.CAEM2009, "84.13")),
        ((Standards.CAEM2005, "75.13.0"), (Standards.CAEM2009, "82.99")),
        ((Standards.CAEM2005, "75.13.0"), (Standards.CAEM2009, "84.13")),
        ((Standards.CAEM2005, "75.14"), (Standards.CAEM2009, "81.10")),
        ((Standards.CAEM2005, "75.14"), (Standards.CAEM2009, "84.11")),
        ((Standards.CAEM2005, "75.14"), (Standards.CAEM2009, "91.01")),
        ((Standards.CAEM2005, "75.14.0"), (Standards.CAEM2009, "81.10")),
        ((Standards.CAEM2005, "75.14.0"), (Standards.CAEM2009, "84.11")),
        ((Standards.CAEM2005, "75.14.0"), (Standards.CAEM2009, "91.01")),
        ((Standards.CAEM2005, "75.2"), (Standards.CAEM2009, "84.2")),
        ((Standards.CAEM2005, "75.2"), (Standards.CAEM2009, "88.9")),
        ((Standards.CAEM2005, "75.21"), (Standards.CAEM2009, "84.21")),
        ((Standards.CAEM2005, "75.21"), (Standards.CAEM2009, "88.99")),
        ((Standards.CAEM2005, "75.21.0"), (Standards.CAEM2009, "84.21")),
        ((Standards.CAEM2005, "75.21.0"), (Standards.CAEM2009, "88.99")),
        ((Standards.CAEM2005, "75.22"), (Standards.CAEM2009, "84.22")),
        ((Standards.CAEM2005, "75.22.0"), (Standards.CAEM2009, "84.22")),
        ((Standards.CAEM2005, "75.23"), (Standards.CAEM2009, "84.23")),
        ((Standards.CAEM2005, "75.23.0"), (Standards.CAEM2009, "84.23")),
        ((Standards.CAEM2005, "75.24"), (Standards.CAEM2009, "84.24")),
        ((Standards.CAEM2005, "75.24.0"), (Standards.CAEM2009, "84.24")),
        ((Standards.CAEM2005, "75.25"), (Standards.CAEM2009, "84.25")),
        ((Standards.CAEM2005, "75.25.0"), (Standards.CAEM2009, "84.25")),
        ((Standards.CAEM2005, "75.3"), (Standards.CAEM2009, "84.3")),
        ((Standards.CAEM2005, "75.30"), (Standards.CAEM2009, "84.30")),
        ((Standards.CAEM2005, "75.30.0"), (Standards.CAEM2009, "84.30")),
        ((Standards.CAEM2005, "M"), (Standards.CAEM2009, "P")),
        ((Standards.CAEM2005, "80"), (Standards.CAEM2009, "85")),
        ((Standards.CAEM2005, "80.1"), (Standards.CAEM2009, "85.1")),
        ((Standards.CAEM2005, "80.1"), (Standards.CAEM2009, "85.2")),
        ((Standards.CAEM2005, "80.1"), (Standards.CAEM2009, "85.5")),
        ((Standards.CAEM2005, "80.10"), (Standards.CAEM2009, "85.10")),
        ((Standards.CAEM2005, "80.10"), (Standards.CAEM2009, "85.20")),
        ((Standards.CAEM2005, "80.10"), (Standards.CAEM2009, "85.51")),
        ((Standards.CAEM2005, "80.10"), (Standards.CAEM2009, "85.52")),
        ((Standards.CAEM2005, "80.10.1"), (Standards.CAEM2009, "85.10")),
        ((Standards.CAEM2005, "80.10.2"), (Standards.CAEM2009, "85.20")),
        ((Standards.CAEM2005, "80.10.3"), (Standards.CAEM2009, "85.51")),
        ((Standards.CAEM2005, "80.10.3"), (Standards.CAEM2009, "85.52")),
        ((Standards.CAEM2005, "80.2"), (Standards.CAEM2009, "85.3")),
        ((Standards.CAEM2005, "80.2"), (Standards.CAEM2009, "85.4")),
        ((Standards.CAEM2005, "80.21"), (Standards.CAEM2009, "85.31")),
        ((Standards.CAEM2005, "80.21.1"), (Standards.CAEM2009, "85.31")),
        ((Standards.CAEM2005, "80.21.2"), (Standards.CAEM2009, "85.31")),
        ((Standards.CAEM2005, "80.22"), (Standards.CAEM2009, "85.32")),
        ((Standards.CAEM2005, "80.22"), (Standards.CAEM2009, "85.41")),
        ((Standards.CAEM2005, "80.22.1"), (Standards.CAEM2009, "85.32")),
        ((Standards.CAEM2005, "80.22.2"), (Standards.CAEM2009, "85.41")),
        ((Standards.CAEM2005, "80.3"), (Standards.CAEM2009, "85.4")),
        ((Standards.CAEM2005, "80.30"), (Standards.CAEM2009, "85.41")),
        ((Standards.CAEM2005, "80.30"), (Standards.CAEM2009, "85.42")),
        ((Standards.CAEM2005, "80.30.1"), (Standards.CAEM2009, "85.41")),
        ((Standards.CAEM2005, "80.30.1"), (Standards.CAEM2009, "85.42")),
        ((Standards.CAEM2005, "80.30.2"), (Standards.CAEM2009, "85.41")),
        ((Standards.CAEM2005, "80.30.2"), (Standards.CAEM2009, "85.42")),
        ((Standards.CAEM2005, "80.4"), (Standards.CAEM2009, "85.3")),
        ((Standards.CAEM2005, "80.4"), (Standards.CAEM2009, "85.5")),
        ((Standards.CAEM2005, "80.41"), (Standards.CAEM2009, "85.53")),
        ((Standards.CAEM2005, "80.41.0"), (Standards.CAEM2009, "85.53")),
        ((Standards.CAEM2005, "80.42"), (Standards.CAEM2009, "85.32")),
        ((Standards.CAEM2005, "80.42"), (Standards.CAEM2009, "85.51")),
        ((Standards.CAEM2005, "80.42"), (Standards.CAEM2009, "85.52")),
        ((Standards.CAEM2005, "80.42"), (Standards.CAEM2009, "85.59")),
        ((Standards.CAEM2005, "80.42.1"), (Standards.CAEM2009, "85.32")),
        ((Standards.CAEM2005, "80.42.1"), (Standards.CAEM2009, "85.51")),
        ((Standards.CAEM2005, "80.42.1"), (Standards.CAEM2009, "85.52")),
        ((Standards.CAEM2005, "80.42.1"), (Standards.CAEM2009, "85.59")),
        ((Standards.CAEM2005, "80.42.2"), (Standards.CAEM2009, "85.32")),
        ((Standards.CAEM2005, "80.42.2"), (Standards.CAEM2009, "85.51")),
        ((Standards.CAEM2005, "80.42.2"), (Standards.CAEM2009, "85.52")),
        ((Standards.CAEM2005, "80.42.2"), (Standards.CAEM2009, "85.59")),
        ((Standards.CAEM2005, "80.42.9"), (Standards.CAEM2009, "85.32")),
        ((Standards.CAEM2005, "80.42.9"), (Standards.CAEM2009, "85.51")),
        ((Standards.CAEM2005, "80.42.9"), (Standards.CAEM2009, "85.52")),
        ((Standards.CAEM2005, "80.42.9"), (Standards.CAEM2009, "85.59")),
        ((Standards.CAEM2005, "N"), (Standards.CAEM2009, "M")),
        ((Standards.CAEM2005, "N"), (Standards.CAEM2009, "Q")),
        ((Standards.CAEM2005, "85"), (Standards.CAEM2009, "75")),
        ((Standards.CAEM2005, "85"), (Standards.CAEM2009, "86")),
        ((Standards.CAEM2005, "85"), (Standards.CAEM2009, "87")),
        ((Standards.CAEM2005, "85"), (Standards.CAEM2009, "88")),
        ((Standards.CAEM2005, "85.1"), (Standards.CAEM2009, "86.1")),
        ((Standards.CAEM2005, "85.1"), (Standards.CAEM2009, "86.2")),
        ((Standards.CAEM2005, "85.1"), (Standards.CAEM2009, "86.9")),
        ((Standards.CAEM2005, "85.1"), (Standards.CAEM2009, "87.1")),
        ((Standards.CAEM2005, "85.1"), (Standards.CAEM2009, "87.2")),
        ((Standards.CAEM2005, "85.1"), (Standards.CAEM2009, "87.3")),
        ((Standards.CAEM2005, "85.11"), (Standards.CAEM2009, "86.10")),
        ((Standards.CAEM2005, "85.11"), (Standards.CAEM2009, "87.20")),
        ((Standards.CAEM2005, "85.11.1"), (Standards.CAEM2009, "86.10")),
        ((Standards.CAEM2005, "85.11.2"), (Standards.CAEM2009, "86.10")),
        ((Standards.CAEM2005, "85.11.3"), (Standards.CAEM2009, "86.10")),
        ((Standards.CAEM2005, "85.11.4"), (Standards.CAEM2009, "86.10")),
        ((Standards.CAEM2005, "85.11.9"), (Standards.CAEM2009, "86.10")),
        ((Standards.CAEM2005, "85.12"), (Standards.CAEM2009, "86.21")),
        ((Standards.CAEM2005, "85.12"), (Standards.CAEM2009, "86.22")),
        ((Standards.CAEM2005, "85.12.0"), (Standards.CAEM2009, "86.21")),
        ((Standards.CAEM2005, "85.12.0"), (Standards.CAEM2009, "86.22")),
        ((Standards.CAEM2005, "85.13"), (Standards.CAEM2009, "86.23")),
        ((Standards.CAEM2005, "85.13.0"), (Standards.CAEM2009, "86.23")),
        ((Standards.CAEM2005, "85.14"), (Standards.CAEM2009, "86.90")),
        ((Standards.CAEM2005, "85.14"), (Standards.CAEM2009, "87.10")),
        ((Standards.CAEM2005, "85.14"), (Standards.CAEM2009, "87.20")),
        ((Standards.CAEM2005, "85.14"), (Standards.CAEM2009, "87.30")),
        ((Standards.CAEM2005, "85.14.0"), (Standards.CAEM2009, "86.90")),
        ((Standards.CAEM2005, "85.14.0"), (Standards.CAEM2009, "87.10")),
        ((Standards.CAEM2005, "85.14.0"), (Standards.CAEM2009, "87.20")),
        ((Standards.CAEM2005, "85.14.0"), (Standards.CAEM2009, "87.30")),
        ((Standards.CAEM2005, "85.2"), (Standards.CAEM2009, "75.0")),
        ((Standards.CAEM2005, "85.20"), (Standards.CAEM2009, "75.00")),
        ((Standards.CAEM2005, "85.20.0"), (Standards.CAEM2009, "75.00")),
        ((Standards.CAEM2005, "85.3"), (Standards.CAEM2009, "87.2")),
        ((Standards.CAEM2005, "85.3"), (Standards.CAEM2009, "87.3")),
        ((Standards.CAEM2005, "85.3"), (Standards.CAEM2009, "87.9")),
        ((Standards.CAEM2005, "85.3"), (Standards.CAEM2009, "88.1")),
        ((Standards.CAEM2005, "85.3"), (Standards.CAEM2009, "88.9")),
        ((Standards.CAEM2005, "85.31"), (Standards.CAEM2009, "87.20")),
        ((Standards.CAEM2005, "85.31"), (Standards.CAEM2009, "87.30")),
        ((Standards.CAEM2005, "85.31"), (Standards.CAEM2009, "87.90")),
        ((Standards.CAEM2005, "85.31.0"), (Standards.CAEM2009, "87.20")),
        ((Standards.CAEM2005, "85.31.0"), (Standards.CAEM2009, "87.30")),
        ((Standards.CAEM2005, "85.31.0"), (Standards.CAEM2009, "87.90")),
        ((Standards.CAEM2005, "85.32"), (Standards.CAEM2009, "88.10")),
        ((Standards.CAEM2005, "85.32"), (Standards.CAEM2009, "88.91")),
        ((Standards.CAEM2005, "85.32"), (Standards.CAEM2009, "88.99")),
        ((Standards.CAEM2005, "85.32.0"), (Standards.CAEM2009, "88.10")),
        ((Standards.CAEM2005, "85.32.0"), (Standards.CAEM2009, "88.91")),
        ((Standards.CAEM2005, "85.32.0"), (Standards.CAEM2009, "88.99")),
        ((Standards.CAEM2005, "O"), (Standards.CAEM2009, "A")),
        ((Standards.CAEM2005, "O"), (Standards.CAEM2009, "E")),
        ((Standards.CAEM2005, "O"), (Standards.CAEM2009, "J")),
        ((Standards.CAEM2005, "O"), (Standards.CAEM2009, "M")),
        ((Standards.CAEM2005, "O"), (Standards.CAEM2009, "N")),
        ((Standards.CAEM2005, "O"), (Standards.CAEM2009, "P")),
        ((Standards.CAEM2005, "O"), (Standards.CAEM2009, "R")),
        ((Standards.CAEM2005, "O"), (Standards.CAEM2009, "S")),
        ((Standards.CAEM2005, "90"), (Standards.CAEM2009, "37")),
        ((Standards.CAEM2005, "90"), (Standards.CAEM2009, "38")),
        ((Standards.CAEM2005, "90"), (Standards.CAEM2009, "39")),
        ((Standards.CAEM2005, "90"), (Standards.CAEM2009, "81")),
        ((Standards.CAEM2005, "90.0"), (Standards.CAEM2009, "37.0")),
        ((Standards.CAEM2005, "90.0"), (Standards.CAEM2009, "38.1")),
        ((Standards.CAEM2005, "90.0"), (Standards.CAEM2009, "38.2")),
        ((Standards.CAEM2005, "90.0"), (Standards.CAEM2009, "39.0")),
        ((Standards.CAEM2005, "90.0"), (Standards.CAEM2009, "81.2")),
        ((Standards.CAEM2005, "90.01"), (Standards.CAEM2009, "37.00")),
        ((Standards.CAEM2005, "90.01.0"), (Standards.CAEM2009, "37.00")),
        ((Standards.CAEM2005, "90.02"), (Standards.CAEM2009, "38.11")),
        ((Standards.CAEM2005, "90.02"), (Standards.CAEM2009, "38.12")),
        ((Standards.CAEM2005, "90.02"), (Standards.CAEM2009, "38.21")),
        ((Standards.CAEM2005, "90.02"), (Standards.CAEM2009, "38.22")),
        ((Standards.CAEM2005, "90.02.0"), (Standards.CAEM2009, "38.11")),
        ((Standards.CAEM2005, "90.02.0"), (Standards.CAEM2009, "38.12")),
        ((Standards.CAEM2005, "90.02.0"), (Standards.CAEM2009, "38.21")),
        ((Standards.CAEM2005, "90.02.0"), (Standards.CAEM2009, "38.22")),
        ((Standards.CAEM2005, "90.03"), (Standards.CAEM2009, "38.11")),
        ((Standards.CAEM2005, "90.03"), (Standards.CAEM2009, "39.00")),
        ((Standards.CAEM2005, "90.03"), (Standards.CAEM2009, "81.29")),
        ((Standards.CAEM2005, "90.03.0"), (Standards.CAEM2009, "38.11")),
        ((Standards.CAEM2005, "90.03.0"), (Standards.CAEM2009, "39.00")),
        ((Standards.CAEM2005, "90.03.0"), (Standards.CAEM2009, "81.29")),
        ((Standards.CAEM2005, "91"), (Standards.CAEM2009, "94")),
        ((Standards.CAEM2005, "91.1"), (Standards.CAEM2009, "94.1")),
        ((Standards.CAEM2005, "91.11"), (Standards.CAEM2009, "94.11")),
        ((Standards.CAEM2005, "91.11.0"), (Standards.CAEM2009, "94.11")),
        ((Standards.CAEM2005, "91.12"), (Standards.CAEM2009, "94.12")),
        ((Standards.CAEM2005, "91.12.0"), (Standards.CAEM2009, "94.12")),
        ((Standards.CAEM2005, "91.2"), (Standards.CAEM2009, "94.2")),
        ((Standards.CAEM2005, "91.20"), (Standards.CAEM2009, "94.20")),
        ((Standards.CAEM2005, "91.20.0"), (Standards.CAEM2009, "94.20")),
        ((Standards.CAEM2005, "91.3"), (Standards.CAEM2009, "94.9")),
        ((Standards.CAEM2005, "91.31"), (Standards.CAEM2009, "94.91")),
        ((Standards.CAEM2005, "91.31.0"), (Standards.CAEM2009, "94.91")),
        ((Standards.CAEM2005, "91.32"), (Standards.CAEM2009, "94.92")),
        ((Standards.CAEM2005, "91.32.0"), (Standards.CAEM2009, "94.92")),
        ((Standards.CAEM2005, "91.33"), (Standards.CAEM2009, "94.99")),
        ((Standards.CAEM2005, "91.33.0"), (Standards.CAEM2009, "94.99")),
        ((Standards.CAEM2005, "92"), (Standards.CAEM2009, "01")),
        ((Standards.CAEM2005, "92"), (Standards.CAEM2009, "59")),
        ((Standards.CAEM2005, "92"), (Standards.CAEM2009, "60")),
        ((Standards.CAEM2005, "92"), (Standards.CAEM2009, "63")),
        ((Standards.CAEM2005, "92"), (Standards.CAEM2009, "74")),
        ((Standards.CAEM2005, "92"), (Standards.CAEM2009, "78")),
        ((Standards.CAEM2005, "92"), (Standards.CAEM2009, "79")),
        ((Standards.CAEM2005, "92"), (Standards.CAEM2009, "85")),
        ((Standards.CAEM2005, "92"), (Standards.CAEM2009, "90")),
        ((Standards.CAEM2005, "92"), (Standards.CAEM2009, "91")),
        ((Standards.CAEM2005, "92"), (Standards.CAEM2009, "92")),
        ((Standards.CAEM2005, "92"), (Standards.CAEM2009, "93")),
        ((Standards.CAEM2005, "92.1"), (Standards.CAEM2009, "59.1")),
        ((Standards.CAEM2005, "92.1"), (Standards.CAEM2009, "59.2")),
        ((Standards.CAEM2005, "92.11"), (Standards.CAEM2009, "59.11")),
        ((Standards.CAEM2005, "92.11"), (Standards.CAEM2009, "59.12")),
        ((Standards.CAEM2005, "92.11"), (Standards.CAEM2009, "59.20")),
        ((Standards.CAEM2005, "92.11.0"), (Standards.CAEM2009, "59.11")),
        ((Standards.CAEM2005, "92.11.0"), (Standards.CAEM2009, "59.12")),
        ((Standards.CAEM2005, "92.11.0"), (Standards.CAEM2009, "59.20")),
        ((Standards.CAEM2005, "92.12"), (Standards.CAEM2009, "59.13")),
        ((Standards.CAEM2005, "92.12.0"), (Standards.CAEM2009, "59.13")),
        ((Standards.CAEM2005, "92.13"), (Standards.CAEM2009, "59.14")),
        ((Standards.CAEM2005, "92.13.0"), (Standards.CAEM2009, "59.14")),
        ((Standards.CAEM2005, "92.2"), (Standards.CAEM2009, "59.1")),
        ((Standards.CAEM2005, "92.2"), (Standards.CAEM2009, "59.2")),
        ((Standards.CAEM2005, "92.2"), (Standards.CAEM2009, "60.1")),
        ((Standards.CAEM2005, "92.2"), (Standards.CAEM2009, "60.2")),
        ((Standards.CAEM2005, "92.20"), (Standards.CAEM2009, "59.11")),
        ((Standards.CAEM2005, "92.20"), (Standards.CAEM2009, "59.20")),
        ((Standards.CAEM2005, "92.20"), (Standards.CAEM2009, "60.10")),
        ((Standards.CAEM2005, "92.20"), (Standards.CAEM2009, "60.20")),
        ((Standards.CAEM2005, "92.20.0"), (Standards.CAEM2009, "59.11")),
        ((Standards.CAEM2005, "92.20.0"), (Standards.CAEM2009, "59.20")),
        ((Standards.CAEM2005, "92.20.0"), (Standards.CAEM2009, "60.10")),
        ((Standards.CAEM2005, "92.20.0"), (Standards.CAEM2009, "60.20")),
        ((Standards.CAEM2005, "92.3"), (Standards.CAEM2009, "79.9")),
        ((Standards.CAEM2005, "92.3"), (Standards.CAEM2009, "85.5")),
        ((Standards.CAEM2005, "92.3"), (Standards.CAEM2009, "90.0")),
        ((Standards.CAEM2005, "92.3"), (Standards.CAEM2009, "93.2")),
        ((Standards.CAEM2005, "92.31"), (Standards.CAEM2009, "90.01")),
        ((Standards.CAEM2005, "92.31"), (Standards.CAEM2009, "90.02")),
        ((Standards.CAEM2005, "92.31"), (Standards.CAEM2009, "90.03")),
        ((Standards.CAEM2005, "92.31.1"), (Standards.CAEM2009, "90.01")),
        ((Standards.CAEM2005, "92.31.1"), (Standards.CAEM2009, "90.02")),
        ((Standards.CAEM2005, "92.31.2"), (Standards.CAEM2009, "90.01")),
        ((Standards.CAEM2005, "92.31.2"), (Standards.CAEM2009, "90.02")),
        ((Standards.CAEM2005, "92.31.3"), (Standards.CAEM2009, "90.03")),
        ((Standards.CAEM2005, "92.32"), (Standards.CAEM2009, "79.90")),
        ((Standards.CAEM2005, "92.32"), (Standards.CAEM2009, "90.02")),
        ((Standards.CAEM2005, "92.32"), (Standards.CAEM2009, "90.04")),
        ((Standards.CAEM2005, "92.32.0"), (Standards.CAEM2009, "79.90")),
        ((Standards.CAEM2005, "92.32.0"), (Standards.CAEM2009, "90.02")),
        ((Standards.CAEM2005, "92.32.0"), (Standards.CAEM2009, "90.04")),
        ((Standards.CAEM2005, "92.33"), (Standards.CAEM2009, "93.21")),
        ((Standards.CAEM2005, "92.33.0"), (Standards.CAEM2009, "93.21")),
        ((Standards.CAEM2005, "92.34"), (Standards.CAEM2009, "79.90")),
        ((Standards.CAEM2005, "92.34"), (Standards.CAEM2009, "85.52")),
        ((Standards.CAEM2005, "92.34"), (Standards.CAEM2009, "90.01")),
        ((Standards.CAEM2005, "92.34"), (Standards.CAEM2009, "90.02")),
        ((Standards.CAEM2005, "92.34"), (Standards.CAEM2009, "93.29")),
        ((Standards.CAEM2005, "92.34.1"), (Standards.CAEM2009, "79.90")),
        ((Standards.CAEM2005, "92.34.1"), (Standards.CAEM2009, "90.01")),
        ((Standards.CAEM2005, "92.34.1"), (Standards.CAEM2009, "90.02")),
        ((Standards.CAEM2005, "92.34.1"), (Standards.CAEM2009, "93.29")),
        ((Standards.CAEM2005, "92.34.2"), (Standards.CAEM2009, "79.90")),
        ((Standards.CAEM2005, "92.34.2"), (Standards.CAEM2009, "90.01")),
        ((Standards.CAEM2005, "92.34.2"), (Standards.CAEM2009, "90.02")),
        ((Standards.CAEM2005, "92.34.2"), (Standards.CAEM2009, "93.29")),
        ((Standards.CAEM2005, "92.34.3"), (Standards.CAEM2009, "79.90")),
        ((Standards.CAEM2005, "92.34.3"), (Standards.CAEM2009, "85.52")),
        ((Standards.CAEM2005, "92.34.3"), (Standards.CAEM2009, "90.02")),
        ((Standards.CAEM2005, "92.34.3"), (Standards.CAEM2009, "93.29")),
        ((Standards.CAEM2005, "92.4"), (Standards.CAEM2009, "63.9")),
        ((Standards.CAEM2005, "92.4"), (Standards.CAEM2009, "74.2")),
        ((Standards.CAEM2005, "92.4"), (Standards.CAEM2009, "90.0")),
        ((Standards.CAEM2005, "92.40"), (Standards.CAEM2009, "63.91")),
        ((Standards.CAEM2005, "92.40"), (Standards.CAEM2009, "74.20")),
        ((Standards.CAEM2005, "92.40"), (Standards.CAEM2009, "90.03")),
        ((Standards.CAEM2005, "92.40.0"), (Standards.CAEM2009, "63.91")),
        ((Standards.CAEM2005, "92.40.0"), (Standards.CAEM2009, "74.20")),
        ((Standards.CAEM2005, "92.40.0"), (Standards.CAEM2009, "90.03")),
        ((Standards.CAEM2005, "92.5"), (Standards.CAEM2009, "91.0")),
        ((Standards.CAEM2005, "92.51"), (Standards.CAEM2009, "91.01")),
        ((Standards.CAEM2005, "92.51.1"), (Standards.CAEM2009, "91.01")),
        ((Standards.CAEM2005, "92.51.2"), (Standards.CAEM2009, "91.01")),
        ((Standards.CAEM2005, "92.51.3"), (Standards.CAEM2009, "91.01")),
        ((Standards.CAEM2005, "92.51.4"), (Standards.CAEM2009, "91.01")),
        ((Standards.CAEM2005, "92.51.5"), (Standards.CAEM2009, "91.01")),
        ((Standards.CAEM2005, "92.52"), (Standards.CAEM2009, "91.02")),
        ((Standards.CAEM2005, "92.52"), (Standards.CAEM2009, "91.03")),
        ((Standards.CAEM2005, "92.52.1"), (Standards.CAEM2009, "91.02")),
        ((Standards.CAEM2005, "92.52.2"), (Standards.CAEM2009, "91.03")),
        ((Standards.CAEM2005, "92.52.3"), (Standards.CAEM2009, "91.02")),
        ((Standards.CAEM2005, "92.53"), (Standards.CAEM2009, "91.04")),
        ((Standards.CAEM2005, "92.53.1"), (Standards.CAEM2009, "91.04")),
        ((Standards.CAEM2005, "92.53.2"), (Standards.CAEM2009, "91.04")),
        ((Standards.CAEM2005, "92.6"), (Standards.CAEM2009, "79.9")),
        ((Standards.CAEM2005, "92.6"), (Standards.CAEM2009, "85.5")),
        ((Standards.CAEM2005, "92.6"), (Standards.CAEM2009, "93.1")),
        ((Standards.CAEM2005, "92.6"), (Standards.CAEM2009, "93.2")),
        ((Standards.CAEM2005, "92.61"), (Standards.CAEM2009, "93.11")),
        ((Standards.CAEM2005, "92.61.0"), (Standards.CAEM2009, "93.11")),
        ((Standards.CAEM2005, "92.62"), (Standards.CAEM2009, "79.90")),
        ((Standards.CAEM2005, "92.62"), (Standards.CAEM2009, "85.51")),
        ((Standards.CAEM2005, "92.62"), (Standards.CAEM2009, "93.11")),
        ((Standards.CAEM2005, "92.62"), (Standards.CAEM2009, "93.12")),
        ((Standards.CAEM2005, "92.62"), (Standards.CAEM2009, "93.19")),
        ((Standards.CAEM2005, "92.62"), (Standards.CAEM2009, "93.29")),
        ((Standards.CAEM2005, "92.62.0"), (Standards.CAEM2009, "79.90")),
        ((Standards.CAEM2005, "92.62.0"), (Standards.CAEM2009, "85.51")),
        ((Standards.CAEM2005, "92.62.0"), (Standards.CAEM2009, "93.11")),
        ((Standards.CAEM2005, "92.62.0"), (Standards.CAEM2009, "93.12")),
        ((Standards.CAEM2005, "92.62.0"), (Standards.CAEM2009, "93.19")),
        ((Standards.CAEM2005, "92.62.0"), (Standards.CAEM2009, "93.29")),
        ((Standards.CAEM2005, "92.7"), (Standards.CAEM2009, "01.6")),
        ((Standards.CAEM2005, "92.7"), (Standards.CAEM2009, "78.1")),
        ((Standards.CAEM2005, "92.7"), (Standards.CAEM2009, "79.9")),
        ((Standards.CAEM2005, "92.7"), (Standards.CAEM2009, "92.0")),
        ((Standards.CAEM2005, "92.7"), (Standards.CAEM2009, "93.2")),
        ((Standards.CAEM2005, "92.71"), (Standards.CAEM2009, "92.00")),
        ((Standards.CAEM2005, "92.71.0"), (Standards.CAEM2009, "92.00")),
        ((Standards.CAEM2005, "92.72"), (Standards.CAEM2009, "01.62")),
        ((Standards.CAEM2005, "92.72"), (Standards.CAEM2009, "78.10")),
        ((Standards.CAEM2005, "92.72"), (Standards.CAEM2009, "79.90")),
        ((Standards.CAEM2005, "92.72"), (Standards.CAEM2009, "93.29")),
        ((Standards.CAEM2005, "92.72.0"), (Standards.CAEM2009, "01.62")),
        ((Standards.CAEM2005, "92.72.0"), (Standards.CAEM2009, "78.10")),
        ((Standards.CAEM2005, "92.72.0"), (Standards.CAEM2009, "79.90")),
        ((Standards.CAEM2005, "92.72.0"), (Standards.CAEM2009, "93.29")),
        ((Standards.CAEM2005, "93"), (Standards.CAEM2009, "85")),
        ((Standards.CAEM2005, "93"), (Standards.CAEM2009, "93")),
        ((Standards.CAEM2005, "93"), (Standards.CAEM2009, "96")),
        ((Standards.CAEM2005, "93.0"), (Standards.CAEM2009, "85.5")),
        ((Standards.CAEM2005, "93.0"), (Standards.CAEM2009, "93.1")),
        ((Standards.CAEM2005, "93.0"), (Standards.CAEM2009, "96.0")),
        ((Standards.CAEM2005, "93.01"), (Standards.CAEM2009, "96.01")),
        ((Standards.CAEM2005, "93.01.1"), (Standards.CAEM2009, "96.01")),
        ((Standards.CAEM2005, "93.01.2"), (Standards.CAEM2009, "96.01")),
        ((Standards.CAEM2005, "93.02"), (Standards.CAEM2009, "96.02")),
        ((Standards.CAEM2005, "93.02.0"), (Standards.CAEM2009, "96.02")),
        ((Standards.CAEM2005, "93.03"), (Standards.CAEM2009, "96.03")),
        ((Standards.CAEM2005, "93.03.0"), (Standards.CAEM2009, "96.03")),
        ((Standards.CAEM2005, "93.04"), (Standards.CAEM2009, "93.13")),
        ((Standards.CAEM2005, "93.04"), (Standards.CAEM2009, "96.04")),
        ((Standards.CAEM2005, "93.04.0"), (Standards.CAEM2009, "93.13")),
        ((Standards.CAEM2005, "93.04.0"), (Standards.CAEM2009, "96.04")),
        ((Standards.CAEM2005, "93.05"), (Standards.CAEM2009, "85.51")),
        ((Standards.CAEM2005, "93.05"), (Standards.CAEM2009, "96.09")),
        ((Standards.CAEM2005, "93.05.0"), (Standards.CAEM2009, "85.51")),
        ((Standards.CAEM2005, "93.05.0"), (Standards.CAEM2009, "96.09")),
        ((Standards.CAEM2005, "P"), (Standards.CAEM2009, "T")),
        ((Standards.CAEM2005, "95"), (Standards.CAEM2009, "97")),
        ((Standards.CAEM2005, "95.0"), (Standards.CAEM2009, "97.0")),
        ((Standards.CAEM2005, "95.00"), (Standards.CAEM2009, "97.00")),
        ((Standards.CAEM2005, "95.00.0"), (Standards.CAEM2009, "97.00")),
        ((Standards.CAEM2005, "96"), (Standards.CAEM2009, "98")),
        ((Standards.CAEM2005, "96.0"), (Standards.CAEM2009, "98.1")),
        ((Standards.CAEM2005, "96.00"), (Standards.CAEM2009, "98.10")),
        ((Standards.CAEM2005, "96.00.0"), (Standards.CAEM2009, "98.10")),
        ((Standards.CAEM2005, "97"), (Standards.CAEM2009, "98")),
        ((Standards.CAEM2005, "97.0"), (Standards.CAEM2009, "98.2")),
        ((Standards.CAEM2005, "97.00"), (Standards.CAEM2009, "98.20")),
        ((Standards.CAEM2005, "97.00.0"), (Standards.CAEM2009, "98.20")),
        ((Standards.CAEM2005, "Q"), (Standards.CAEM2009, "U")),
        ((Standards.CAEM2005, "99"), (Standards.CAEM2009, "99")),
        ((Standards.CAEM2005, "99.0"), (Standards.CAEM2009, "99.0")),
        ((Standards.CAEM2005, "99.00"), (Standards.CAEM2009, "99.00")),
        ((Standards.CAEM2005, "99.00.0"), (Standards.CAEM2009, "99.00")),
    ],
)
