from gazeclassify.classifier.instance import InstanceSegmentation
from gazeclassify.eyetracker.pupilinvisible import PupilInvisibleLoader
from gazeclassify.service.analysis import Analysis


def test_run_instance_segmentation_on_two_frame_trial() -> None:
    analysis = Analysis()
    PupilInvisibleLoader(analysis).from_trial_folder("gazeclassify/example_data/trial")
    InstanceSegmentation(analysis).classify("Human_Joints")

    import json
    results = json.dumps(analysis.results, default=lambda x: x.__dict__)
    expected_string = '[{"frame_id": 0, "name": "Human_Joints", "classifications": [{"distance": 677.1754131941278, "joint": "Neck", "person_id": 0}, {"distance": 659.6980986688193, "joint": "Right Shoulder", "person_id": 0}, {"distance": 596.2589937634616, "joint": "Right Elbow", "person_id": 1}, {"distance": 610.6028813518858, "joint": "Right Wrist", "person_id": 1}, {"distance": 692.274247254679, "joint": "Right Hip", "person_id": 0}, {"distance": 584.5745019249472, "joint": "Right Hip", "person_id": 2}, {"distance": 739.5749259572267, "joint": "Right Knee", "person_id": 0}, {"distance": 604.968815401321, "joint": "Right Knee", "person_id": 2}, {"distance": 773.7359080160629, "joint": "Right Ankle", "person_id": 0}, {"distance": 637.1596426413015, "joint": "Right Ankle", "person_id": 2}, {"distance": 708.9813765250925, "joint": "Left Hip", "person_id": 0}, {"distance": 617.4385464801228, "joint": "Left Knee", "person_id": 3}, {"distance": 637.9877185531046, "joint": "Left Ankle", "person_id": 3}, {"distance": 592.1046430911656, "joint": "Right Eye", "person_id": 4}, {"distance": 675.125791857381, "joint": "Right Eye", "person_id": 5}, {"distance": 607.3442182498537, "joint": "Left Eye", "person_id": 4}, {"distance": 659.1370203042912, "joint": "Right Ear", "person_id": 5}, {"distance": 608.0467640054497, "joint": "Left Ear", "person_id": 4}]}, {"frame_id": 1, "name": "Human_Joints", "classifications": [{"distance": 607.3521677987899, "joint": "Neck", "person_id": 0}, {"distance": 677.1720156326253, "joint": "Neck", "person_id": 3}, {"distance": 592.8317441036684, "joint": "Right Shoulder", "person_id": 0}, {"distance": 677.1720156326253, "joint": "Right Shoulder", "person_id": 1}, {"distance": 609.187621663941, "joint": "Right Elbow", "person_id": 0}, {"distance": 692.153079881931, "joint": "Right Elbow", "person_id": 1}, {"distance": 610.599160497618, "joint": "Right Wrist", "person_id": 0}, {"distance": 677.1720156326253, "joint": "Left Shoulder", "person_id": 2}, {"distance": 675.0636827382386, "joint": "Left Elbow", "person_id": 2}, {"distance": 628.0153517506446, "joint": "Right Hip", "person_id": 0}, {"distance": 708.2991591740397, "joint": "Right Hip", "person_id": 3}, {"distance": 645.9359676898057, "joint": "Right Knee", "person_id": 0}, {"distance": 740.016713178116, "joint": "Right Knee", "person_id": 3}, {"distance": 773.7322100764591, "joint": "Right Ankle", "person_id": 3}, {"distance": 722.6837964898028, "joint": "Left Hip", "person_id": 3}, {"distance": 659.7819896329293, "joint": "Left Knee", "person_id": 4}, {"distance": 682.4655074240353, "joint": "Left Ankle", "person_id": 4}, {"distance": 592.1009762428104, "joint": "Right Eye", "person_id": 0}, {"distance": 546.6836102275083, "joint": "Right Eye", "person_id": 5}, {"distance": 607.3406051328199, "joint": "Left Eye", "person_id": 0}, {"distance": 546.6836102275083, "joint": "Left Eye", "person_id": 5}, {"distance": 675.1223974916085, "joint": "Left Eye", "person_id": 6}, {"distance": 676.530877349027, "joint": "Right Ear", "person_id": 2}, {"distance": 608.0431533251718, "joint": "Left Ear", "person_id": 0}, {"distance": 676.530877349027, "joint": "Left Ear", "person_id": 6}]}]'
    assert results == expected_string
