Provides Go-like `defer`
-----------
Powered by [Yamato Nagata](https://twitter.com/514YJ)

[GitHub](https://github.com/nagataaaas/defern)

installation:
`$ pip install defern`

```python
from defern import defern, deferner, defern_this, here

def defer_multiple_function(frame):
    defern(lambda: print("it's middle 7th"), frame=frame)
    defern(lambda: print("it's middle 8th"), frame=frame)

print("Hi")

defern(lambda: print("it's middle 1st"))  # you can pass function to run after return.
defern(lambda: print("it's middle 2nd"))
defern(print, "it's middle 3rd")  # passed args and kwargs after function will given to function.

@deferner
def defer_this(number: str):
    print("it's middle", number)  # you can create function which runs after return with `@deferner`

defer_this("4th")
defer_this("5th", frame=here())

@defern_this  # wrap function to create procedure which automatically runs after return
def defer_this_now():
    print("it's middle 6th")

defer_multiple_function(here())  # here() to get currentFrame and pass it to `defern` or function created with `deferner`
                                 # with name `frame` will create `defern` to that frame

print('ended')

# Hi
# ended
# it's middle 1st
# it's middle 2nd
# it's middle 3rd
# it's middle 4th
# it's middle 5th
# it's middle 6th
# it's middle 7th
# it's middle 8th
```