import requests
from typing import Dict

from pyoti import __version__
from pyoti.classes import FileHash


class MalwareBazaar(FileHash):
    """MalwareBazaar by abuse.ch

    MalwareBazaar is a project from abuse.ch with the goal of sharing malware samples with the infosec community, AV
    vendors and threat intelligence providers.
    """
    def __init__(self, api_key: str, api_url: str = "https://mb-api.abuse.ch/api/v1"):
        FileHash.__init__(self, api_key=api_key, api_url=api_url)

    def _api_post(self, data) -> requests.models.Response:
        """POST request to MalwareBazaar API"""
        headers = {
            "API-KEY": self.api_key,
            "User-Agent": f"PyOTI {__version__}"
        }

        response = requests.request("POST", url=self.api_url, data=data, headers=headers)

        return response

    def check_hash(self) -> Dict:
        """Checks File Hash reputation"""
        data = {"query": "get_info", "hash": self.file_hash}

        response = self._api_post(data=data)

        return response.json()
