## Graphical programming

Within Nodedge, you can create your program by simply combining built-in blocks, the *nodes*, with *edges* in a 
diagram-like structure. This paradigm is called *model-based design*.
Instead of writing complex lines of text code, it allows you to focus on the logical flow of your program.
Nodes allow you to perform mathematical operations, simulate plants, process signals,
design and reuse patterns, and more. You can easily drag-and-drop
the nodes from the provided node libraries, and configure them to your needs. You can also create your own custom nodes
and share them with other users.

## Source code access

Nodedge gives you source code access. 
Its code is freely available and auditable on Github.
This allows the community to contribute, engage, audit, report, and fix issues.

<center>
  <a href="https://github.com/nodedge/nodedge/">
  <img src="media/github_logo.png" alt="qt" height="100" />
  </a>
</center>

## New generation interface

Nodedge graphics is based on Qt, the industry-leading framework for interfaces that users love.
Compared to other graphic scientific editors, Nodedge has improved ergonomy and more intuitive user interaction.

<center>
  <a href="https://www.qt.io/">
  <img src="media/qt_logo.png" alt="qt" height="100" />
  </a>
</center>


## Python-based software

Nodedge is written in Python3, the most popular scripting language.
The graphical scripting functionality also provides Python3 code generation from the graphic blocks in the scene.
Moreover, the custom block allows you to code your own graphic block - with a custom functionality - in Python.

<center>
  <a href="https://www.python.org/">
  <img src="media/python_logo.png" alt="qt" height="100" />
  </a>
</center>

## Portability and collaboration

Nodedge is cross-platform. You can install it on Windows, macOS, and Linux.
Nodedge project files are saved in a JSON format, which makes portability and versioning 
easy. For next-level collaboration experience, we aim at making simultaneous editing possible.
You and your colleagues will be able to access the same project, from anywhere, with no conflicts
or latencies.
    
