from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="mtabe",
    version="1.4.0",
    packages=find_packages(),
    include_package_data=True,
    install_requires=[
        "annotated-types>=0.7.0",
        "anyio>=4.9.0",
        "beautifulsoup4>=4.13.4",
        "bs4>=0.0.2",
        "certifi>=2025.4.26",
        "charset-normalizer>=3.4.1",
        "click>=8.1.8",
        "colorama>=0.4.6",
        "comtypes>=1.4.10",
        "distro>=1.9.0",
        "et_xmlfile>=2.0.0",
        "groq>=0.23.1",
        "h11>=0.16.0",
        "httpcore>=1.0.9",
        "httpx>=0.28.1",
        "idna>=3.10",
        "lxml>=5.4.0",
        "markdown-it-py>=3.0.0",
        "mdurl>=0.1.2",
        "numpy>=2.2.5",
        "openpyxl>=3.1.5",
        "pandas>=2.2.3",
        "pillow>=11.2.1",
        "pydantic>=2.11.4",
        "pydantic_core>=2.33.2",
        "pyfiglet>=1.0.2",
        "Pygments>=2.19.1",
        "PyPDF2>=3.0.1",
        "pypiwin32>=223",
        "python-dateutil>=2.9.0.post0",
        "python-docx>=1.1.2",
        "python-dotenv>=1.1.0",
        "python-pptx>=1.0.2",
        "pyttsx3>=2.98",
        "pytz>=2025.2",
        "pywin32>=310",
        "requests>=2.32.3",
        "rich>=14.0.0",
        "six>=1.17.0",
        "sniffio>=1.3.1",
        "soupsieve>=2.7",
        "typing-inspection>=0.4.0",
        "typing_extensions>=4.13.2",
        "tzdata>=2025.2",
        "urllib3>=2.4.0",
        "xlrd>=2.0.1",
        "XlsxWriter>=3.2.3",
        "yt-dlp>=2025.5.22"
    ],
    entry_points={
        'console_scripts': [
            'mtabe=mtabe.main:mycommands',
        ],
    },
    author="Henrylee",
    author_email="henrydionizi@gmail.com",
    description="An AI-powered CLI for adding notes and generating flashcards, tests, and chat summaries.",
    keywords='cli ai notes flashcards',
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/Henryle-hd/mtabe",
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires=">=3.8",
)