"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
require("@aws-cdk/assert/jest");
const cdk = require("@aws-cdk/core");
const appsync = require("../lib");
test('should not throw an Error', () => {
    // GIVEN
    const stack = new cdk.Stack();
    // WHEN
    const when = () => {
        new appsync.GraphQLApi(stack, 'api', {
            authorizationConfig: {},
            schemaDefinition: appsync.SchemaDefinition.FILE,
            name: 'api',
            schemaDefinitionFile: path.join(__dirname, 'appsync.test.graphql'),
        });
    };
    // THEN
    expect(when).not.toThrow();
});
test('appsync should configure pipeline when pipelineConfig has contents', () => {
    // GIVEN
    const stack = new cdk.Stack();
    // WHEN
    const api = new appsync.GraphQLApi(stack, 'api', {
        authorizationConfig: {},
        name: 'api',
        schemaDefinition: appsync.SchemaDefinition.FILE,
        schemaDefinitionFile: path.join(__dirname, 'appsync.test.graphql'),
    });
    new appsync.Resolver(stack, 'resolver', {
        api: api,
        typeName: 'test',
        fieldName: 'test2',
        pipelineConfig: ['test', 'test'],
    });
    // THEN
    expect(stack).toHaveResourceLike('AWS::AppSync::Resolver', {
        Kind: 'PIPELINE',
        PipelineConfig: { Functions: ['test', 'test'] },
    });
});
test('appsync should configure resolver as unit when pipelineConfig is empty', () => {
    // GIVEN
    const stack = new cdk.Stack();
    // WHEN
    const api = new appsync.GraphQLApi(stack, 'api', {
        authorizationConfig: {},
        name: 'api',
        schemaDefinition: appsync.SchemaDefinition.FILE,
        schemaDefinitionFile: path.join(__dirname, 'appsync.test.graphql'),
    });
    new appsync.Resolver(stack, 'resolver', {
        api: api,
        typeName: 'test',
        fieldName: 'test2',
    });
    // THEN
    expect(stack).toHaveResourceLike('AWS::AppSync::Resolver', {
        Kind: 'UNIT',
    });
});
test('appsync should configure resolver as unit when pipelineConfig is empty array', () => {
    // GIVEN
    const stack = new cdk.Stack();
    // WHEN
    const api = new appsync.GraphQLApi(stack, 'api', {
        authorizationConfig: {},
        name: 'api',
        schemaDefinition: appsync.SchemaDefinition.FILE,
        schemaDefinitionFile: path.join(__dirname, 'appsync.test.graphql'),
    });
    new appsync.Resolver(stack, 'resolver', {
        api: api,
        typeName: 'test',
        fieldName: 'test2',
        pipelineConfig: [],
    });
    // THEN
    expect(stack).toHaveResourceLike('AWS::AppSync::Resolver', {
        Kind: 'UNIT',
    });
});
//# sourceMappingURL=data:application/json;base64,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