"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const cdk = require("@aws-cdk/core");
const path = require("path");
const appsync = require("../lib");
describe('AppSync Authorization Config', () => {
    test('AppSync creates default api key', () => {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        new appsync.GraphQLApi(stack, 'api', {
            name: 'api',
            schemaDefinition: appsync.SchemaDefinition.FILE,
            schemaDefinitionFile: path.join(__dirname, 'appsync.test.graphql'),
        });
        // THEN
        expect(stack).toHaveResource('AWS::AppSync::ApiKey');
    });
    test('AppSync creates api key from additionalAuthorizationModes', () => {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        new appsync.GraphQLApi(stack, 'api', {
            name: 'api',
            schemaDefinition: appsync.SchemaDefinition.FILE,
            schemaDefinitionFile: path.join(__dirname, 'appsync.test.graphql'),
            authorizationConfig: {
                defaultAuthorization: {
                    authorizationType: appsync.AuthorizationType.IAM,
                },
                additionalAuthorizationModes: [
                    { authorizationType: appsync.AuthorizationType.API_KEY },
                ],
            },
        });
        // THEN
        expect(stack).toHaveResource('AWS::AppSync::ApiKey');
    });
    test('AppSync does not create unspecified api key from additionalAuthorizationModes', () => {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        new appsync.GraphQLApi(stack, 'api', {
            name: 'api',
            schemaDefinition: appsync.SchemaDefinition.FILE,
            schemaDefinitionFile: path.join(__dirname, 'appsync.test.graphql'),
            authorizationConfig: {
                defaultAuthorization: {
                    authorizationType: appsync.AuthorizationType.IAM,
                },
            },
        });
        // THEN
        expect(stack).not.toHaveResource('AWS::AppSync::ApiKey');
    });
    test('appsync does not create unspecified api key with empty additionalAuthorizationModes', () => {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        new appsync.GraphQLApi(stack, 'api', {
            name: 'api',
            schemaDefinition: appsync.SchemaDefinition.FILE,
            schemaDefinitionFile: path.join(__dirname, 'appsync.test.graphql'),
            authorizationConfig: {
                defaultAuthorization: {
                    authorizationType: appsync.AuthorizationType.IAM,
                },
                additionalAuthorizationModes: [],
            },
        });
        // THEN
        expect(stack).not.toHaveResource('AWS::AppSync::ApiKey');
    });
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBwc3luYy1hcGlrZXkudGVzdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFwcHN5bmMtYXBpa2V5LnRlc3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxnQ0FBOEI7QUFDOUIscUNBQXFDO0FBQ3JDLDZCQUE2QjtBQUM3QixrQ0FBa0M7QUFFbEMsUUFBUSxDQUFDLDhCQUE4QixFQUFFLEdBQUcsRUFBRTtJQUM1QyxJQUFJLENBQUMsaUNBQWlDLEVBQUUsR0FBRyxFQUFFO1FBQzNDLFFBQVE7UUFDUixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUU5QixPQUFPO1FBQ1AsSUFBSSxPQUFPLENBQUMsVUFBVSxDQUFDLEtBQUssRUFBRSxLQUFLLEVBQUU7WUFDbkMsSUFBSSxFQUFFLEtBQUs7WUFDWCxnQkFBZ0IsRUFBRSxPQUFPLENBQUMsZ0JBQWdCLENBQUMsSUFBSTtZQUMvQyxvQkFBb0IsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxzQkFBc0IsQ0FBQztTQUNuRSxDQUFDLENBQUM7UUFFSCxPQUFPO1FBQ1AsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLGNBQWMsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3ZELENBQUMsQ0FBQyxDQUFDO0lBRUgsSUFBSSxDQUFDLDJEQUEyRCxFQUFFLEdBQUcsRUFBRTtRQUNyRSxRQUFRO1FBQ1IsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUM7UUFFOUIsT0FBTztRQUNQLElBQUksT0FBTyxDQUFDLFVBQVUsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFO1lBQ25DLElBQUksRUFBRSxLQUFLO1lBQ1gsZ0JBQWdCLEVBQUUsT0FBTyxDQUFDLGdCQUFnQixDQUFDLElBQUk7WUFDL0Msb0JBQW9CLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsc0JBQXNCLENBQUM7WUFDbEUsbUJBQW1CLEVBQUU7Z0JBQ25CLG9CQUFvQixFQUFFO29CQUNwQixpQkFBaUIsRUFBRSxPQUFPLENBQUMsaUJBQWlCLENBQUMsR0FBRztpQkFDakQ7Z0JBQ0QsNEJBQTRCLEVBQUU7b0JBQzVCLEVBQUUsaUJBQWlCLEVBQUUsT0FBTyxDQUFDLGlCQUFpQixDQUFDLE9BQU8sRUFBRTtpQkFDekQ7YUFDRjtTQUNGLENBQUMsQ0FBQztRQUVILE9BQU87UUFDUCxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsY0FBYyxDQUFDLHNCQUFzQixDQUFDLENBQUM7SUFDdkQsQ0FBQyxDQUFDLENBQUM7SUFFSCxJQUFJLENBQUMsK0VBQStFLEVBQUUsR0FBRyxFQUFFO1FBQ3pGLFFBQVE7UUFDUixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUU5QixPQUFPO1FBQ1AsSUFBSSxPQUFPLENBQUMsVUFBVSxDQUFDLEtBQUssRUFBRSxLQUFLLEVBQUU7WUFDbkMsSUFBSSxFQUFFLEtBQUs7WUFDWCxnQkFBZ0IsRUFBRSxPQUFPLENBQUMsZ0JBQWdCLENBQUMsSUFBSTtZQUMvQyxvQkFBb0IsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxzQkFBc0IsQ0FBQztZQUNsRSxtQkFBbUIsRUFBRTtnQkFDbkIsb0JBQW9CLEVBQUU7b0JBQ3BCLGlCQUFpQixFQUFFLE9BQU8sQ0FBQyxpQkFBaUIsQ0FBQyxHQUFHO2lCQUNqRDthQUNGO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsT0FBTztRQUNQLE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLHNCQUFzQixDQUFDLENBQUM7SUFDM0QsQ0FBQyxDQUFDLENBQUM7SUFFSCxJQUFJLENBQUMscUZBQXFGLEVBQUUsR0FBRyxFQUFFO1FBQy9GLFFBQVE7UUFDUixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUU5QixPQUFPO1FBQ1AsSUFBSSxPQUFPLENBQUMsVUFBVSxDQUFDLEtBQUssRUFBRSxLQUFLLEVBQUU7WUFDbkMsSUFBSSxFQUFFLEtBQUs7WUFDWCxnQkFBZ0IsRUFBRSxPQUFPLENBQUMsZ0JBQWdCLENBQUMsSUFBSTtZQUMvQyxvQkFBb0IsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxzQkFBc0IsQ0FBQztZQUNsRSxtQkFBbUIsRUFBRTtnQkFDbkIsb0JBQW9CLEVBQUU7b0JBQ3BCLGlCQUFpQixFQUFFLE9BQU8sQ0FBQyxpQkFBaUIsQ0FBQyxHQUFHO2lCQUNqRDtnQkFDRCw0QkFBNEIsRUFBRSxFQUFFO2FBQ2pDO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsT0FBTztRQUNQLE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLHNCQUFzQixDQUFDLENBQUM7SUFDM0QsQ0FBQyxDQUFDLENBQUM7QUFDTCxDQUFDLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAnQGF3cy1jZGsvYXNzZXJ0L2plc3QnO1xuaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0ICogYXMgcGF0aCBmcm9tICdwYXRoJztcbmltcG9ydCAqIGFzIGFwcHN5bmMgZnJvbSAnLi4vbGliJztcblxuZGVzY3JpYmUoJ0FwcFN5bmMgQXV0aG9yaXphdGlvbiBDb25maWcnLCAoKSA9PiB7XG4gIHRlc3QoJ0FwcFN5bmMgY3JlYXRlcyBkZWZhdWx0IGFwaSBrZXknLCAoKSA9PiB7XG4gICAgLy8gR0lWRU5cbiAgICBjb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soKTtcblxuICAgIC8vIFdIRU5cbiAgICBuZXcgYXBwc3luYy5HcmFwaFFMQXBpKHN0YWNrLCAnYXBpJywge1xuICAgICAgbmFtZTogJ2FwaScsXG4gICAgICBzY2hlbWFEZWZpbml0aW9uOiBhcHBzeW5jLlNjaGVtYURlZmluaXRpb24uRklMRSxcbiAgICAgIHNjaGVtYURlZmluaXRpb25GaWxlOiBwYXRoLmpvaW4oX19kaXJuYW1lLCAnYXBwc3luYy50ZXN0LmdyYXBocWwnKSxcbiAgICB9KTtcblxuICAgIC8vIFRIRU5cbiAgICBleHBlY3Qoc3RhY2spLnRvSGF2ZVJlc291cmNlKCdBV1M6OkFwcFN5bmM6OkFwaUtleScpO1xuICB9KTtcblxuICB0ZXN0KCdBcHBTeW5jIGNyZWF0ZXMgYXBpIGtleSBmcm9tIGFkZGl0aW9uYWxBdXRob3JpemF0aW9uTW9kZXMnLCAoKSA9PiB7XG4gICAgLy8gR0lWRU5cbiAgICBjb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soKTtcblxuICAgIC8vIFdIRU5cbiAgICBuZXcgYXBwc3luYy5HcmFwaFFMQXBpKHN0YWNrLCAnYXBpJywge1xuICAgICAgbmFtZTogJ2FwaScsXG4gICAgICBzY2hlbWFEZWZpbml0aW9uOiBhcHBzeW5jLlNjaGVtYURlZmluaXRpb24uRklMRSxcbiAgICAgIHNjaGVtYURlZmluaXRpb25GaWxlOiBwYXRoLmpvaW4oX19kaXJuYW1lLCAnYXBwc3luYy50ZXN0LmdyYXBocWwnKSxcbiAgICAgIGF1dGhvcml6YXRpb25Db25maWc6IHtcbiAgICAgICAgZGVmYXVsdEF1dGhvcml6YXRpb246IHtcbiAgICAgICAgICBhdXRob3JpemF0aW9uVHlwZTogYXBwc3luYy5BdXRob3JpemF0aW9uVHlwZS5JQU0sXG4gICAgICAgIH0sXG4gICAgICAgIGFkZGl0aW9uYWxBdXRob3JpemF0aW9uTW9kZXM6IFtcbiAgICAgICAgICB7IGF1dGhvcml6YXRpb25UeXBlOiBhcHBzeW5jLkF1dGhvcml6YXRpb25UeXBlLkFQSV9LRVkgfSxcbiAgICAgICAgXSxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICAvLyBUSEVOXG4gICAgZXhwZWN0KHN0YWNrKS50b0hhdmVSZXNvdXJjZSgnQVdTOjpBcHBTeW5jOjpBcGlLZXknKTtcbiAgfSk7XG5cbiAgdGVzdCgnQXBwU3luYyBkb2VzIG5vdCBjcmVhdGUgdW5zcGVjaWZpZWQgYXBpIGtleSBmcm9tIGFkZGl0aW9uYWxBdXRob3JpemF0aW9uTW9kZXMnLCAoKSA9PiB7XG4gICAgLy8gR0lWRU5cbiAgICBjb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soKTtcblxuICAgIC8vIFdIRU5cbiAgICBuZXcgYXBwc3luYy5HcmFwaFFMQXBpKHN0YWNrLCAnYXBpJywge1xuICAgICAgbmFtZTogJ2FwaScsXG4gICAgICBzY2hlbWFEZWZpbml0aW9uOiBhcHBzeW5jLlNjaGVtYURlZmluaXRpb24uRklMRSxcbiAgICAgIHNjaGVtYURlZmluaXRpb25GaWxlOiBwYXRoLmpvaW4oX19kaXJuYW1lLCAnYXBwc3luYy50ZXN0LmdyYXBocWwnKSxcbiAgICAgIGF1dGhvcml6YXRpb25Db25maWc6IHtcbiAgICAgICAgZGVmYXVsdEF1dGhvcml6YXRpb246IHtcbiAgICAgICAgICBhdXRob3JpemF0aW9uVHlwZTogYXBwc3luYy5BdXRob3JpemF0aW9uVHlwZS5JQU0sXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH0pO1xuXG4gICAgLy8gVEhFTlxuICAgIGV4cGVjdChzdGFjaykubm90LnRvSGF2ZVJlc291cmNlKCdBV1M6OkFwcFN5bmM6OkFwaUtleScpO1xuICB9KTtcblxuICB0ZXN0KCdhcHBzeW5jIGRvZXMgbm90IGNyZWF0ZSB1bnNwZWNpZmllZCBhcGkga2V5IHdpdGggZW1wdHkgYWRkaXRpb25hbEF1dGhvcml6YXRpb25Nb2RlcycsICgpID0+IHtcbiAgICAvLyBHSVZFTlxuICAgIGNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjaygpO1xuXG4gICAgLy8gV0hFTlxuICAgIG5ldyBhcHBzeW5jLkdyYXBoUUxBcGkoc3RhY2ssICdhcGknLCB7XG4gICAgICBuYW1lOiAnYXBpJyxcbiAgICAgIHNjaGVtYURlZmluaXRpb246IGFwcHN5bmMuU2NoZW1hRGVmaW5pdGlvbi5GSUxFLFxuICAgICAgc2NoZW1hRGVmaW5pdGlvbkZpbGU6IHBhdGguam9pbihfX2Rpcm5hbWUsICdhcHBzeW5jLnRlc3QuZ3JhcGhxbCcpLFxuICAgICAgYXV0aG9yaXphdGlvbkNvbmZpZzoge1xuICAgICAgICBkZWZhdWx0QXV0aG9yaXphdGlvbjoge1xuICAgICAgICAgIGF1dGhvcml6YXRpb25UeXBlOiBhcHBzeW5jLkF1dGhvcml6YXRpb25UeXBlLklBTSxcbiAgICAgICAgfSxcbiAgICAgICAgYWRkaXRpb25hbEF1dGhvcml6YXRpb25Nb2RlczogW10sXG4gICAgICB9LFxuICAgIH0pO1xuXG4gICAgLy8gVEhFTlxuICAgIGV4cGVjdChzdGFjaykubm90LnRvSGF2ZVJlc291cmNlKCdBV1M6OkFwcFN5bmM6OkFwaUtleScpO1xuICB9KTtcbn0pO1xuIl19