// Copyright (c) Mito
import React from 'react';
import DefaultTaskpane from '../DefaultTaskpane/DefaultTaskpane';
import '../../../../css/taskpanes/Steps/StepTaskpane.css';
import StepDataElement from './StepDataElement';
import DefaultTaskpaneHeader from '../DefaultTaskpane/DefaultTaskpaneHeader';
import DefaultTaskpaneBody from '../DefaultTaskpane/DefaultTaskpaneBody';
/*
    Taskpane containing a list of all the steps and allowing
    a user to interact with them
*/
function StepTaskpane(props) {
    return (React.createElement(DefaultTaskpane, null,
        React.createElement(DefaultTaskpaneHeader, { header: 'Step History', setUIState: props.setUIState }),
        React.createElement(DefaultTaskpaneBody, null,
            React.createElement("div", { className: 'step-takspane-container' }, props.stepSummaryList.map((stepSummary) => {
                return (React.createElement(StepDataElement, { key: stepSummary.step_id, beforeCurrIdx: stepSummary.step_idx <= props.currStepIdx, isCurrIdx: stepSummary.step_idx === props.currStepIdx, lastIndex: props.stepSummaryList[props.stepSummaryList.length - 1].step_idx, stepData: stepSummary, mitoAPI: props.mitoAPI }));
            })))));
}
export default StepTaskpane;
//# sourceMappingURL=StepsTaskpane.js.map