// Copyright (c) Mito
import React, { useEffect, useState } from 'react';
import FileBrowserElement from './FileBrowserElement';
import FileBrowserPathSelector from './FileBrowserPathSelector';
import '../../../../css/taskpanes/Import/FileBrowser.css';
import Input from '../../elements/Input';
import { fuzzyMatch } from '../../../utils/strings';
import Row from '../../spacing/Row';
import Col from '../../spacing/Col';
import SortArrowIcon from '../../icons/SortArrowIcon';
/*
    This file browser component displays a list of files and folders
    and allows a user to navigate through the file and folder.
*/
function FileBrowser(props) {
    var _a;
    const [search, setSearch] = useState('');
    const [sort, setSort] = useState('last_modified_descending');
    // Filter to the searched for elements, and then sort properly
    const elementsToDisplay = (_a = props.elements) === null || _a === void 0 ? void 0 : _a.filter(element => {
        return fuzzyMatch(element.name, search) > .8;
    }).sort((elementOne, elementTwo) => {
        if (sort === 'name_ascending') {
            return elementOne.name < elementTwo.name ? -1 : 1;
        }
        else if (sort === 'name_descending') {
            return elementOne.name >= elementTwo.name ? -1 : 1;
        }
        else if (sort === 'last_modified_ascending') {
            return elementOne.lastModified < elementTwo.lastModified ? -1 : 1;
        }
        else {
            return elementOne.lastModified >= elementTwo.lastModified ? -1 : 1;
        }
    });
    useEffect(() => {
        // When the user switches folders, reset the search
        setSearch('');
    }, [props.pathParts]);
    return (React.createElement("div", { className: 'file-browser flexbox-column' },
        React.createElement("div", null,
            React.createElement(FileBrowserPathSelector, { setCurrPathParts: props.setCurrPathParts, pathParts: props.pathParts })),
        React.createElement(Row, { className: 'border-t-light-gray border-b-light-gray', justify: 'space-between' },
            React.createElement(Col, { span: 18, className: 'flexbox-row flexbox-space-between border-r-light-gray', onClick: () => {
                    setSort(sort === 'name_descending' ? 'name_ascending' : 'name_descending');
                } },
                React.createElement("p", { className: 'text-body-2 pt-5px pb-5px' }, "Name"),
                sort.startsWith('name') &&
                    React.createElement("div", { className: 'mr-5px ml-5px' },
                        React.createElement(SortArrowIcon, { direction: sort.endsWith('descending') ? 'descending' : 'ascending' }))),
            React.createElement(Col, { span: 6, className: 'flexbox-row flexbox-justify-end text-align-right', onClick: () => {
                    setSort(sort === 'last_modified_descending' ? 'last_modified_ascending' : 'last_modified_descending');
                } },
                sort.startsWith('last_modified') &&
                    React.createElement("div", { className: 'mr-5px ml-5px' },
                        React.createElement(SortArrowIcon, { direction: sort.endsWith('descending') ? 'descending' : 'ascending' })),
                React.createElement("p", { className: 'text-body-2 pt-5px pb-5px' }, "Last Modified"))),
        React.createElement("div", { className: 'mt-5px mb-5px' },
            React.createElement(Input, { value: search, placeholder: 'Search the current folder', onChange: (e) => { setSearch(e.target.value); }, width: 'block', autoFocus: true })),
        React.createElement("div", { className: 'file-browser-element-list' }, elementsToDisplay === null || elementsToDisplay === void 0 ? void 0 : elementsToDisplay.map((element, i) => {
            return (React.createElement(FileBrowserElement, { mitoAPI: props.mitoAPI, key: i, element: element, selectedElement: props.selectedElement, setSelectedElement: props.setSelectedElement, importElement: props.importElement, pathParts: props.pathParts, setCurrPathParts: props.setCurrPathParts, excelImportEnabled: props.userProfile.excelImportEnabled }));
        }))));
}
export default FileBrowser;
//# sourceMappingURL=FileBrowser.js.map