// Copyright (c) Saga Inc.
import React from 'react';
import XIcon from '../icons/XIcon';
import Select from './Select';
import Row from '../spacing/Row';
import Col from '../spacing/Col';
import DropdownItem from './DropdownItem';
/*
    This component is a row with a select followed by an X Icon.
*/
const SelectAndXIconCard = (props) => {
    return (React.createElement(Row, { key: props.value, justify: 'space-between', align: 'center' },
        React.createElement(Col, { flex: '1' },
            React.createElement(Select, { value: props.value + '', onChange: (newID) => {
                    props.onChange(newID);
                }, searchable: true }, props.selectableValues.map(id => {
                const title = props.titleMap[id];
                return (React.createElement(DropdownItem, { key: id, id: id, title: title }));
            }))),
        React.createElement(Col, { offset: 1, offsetRight: 1 },
            React.createElement(XIcon, { onClick: () => { props.onDelete(); } }))));
};
export default SelectAndXIconCard;
//# sourceMappingURL=SelectAndXIconCard.js.map