import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DirConfig extends cdktf.TerraformMetaArguments {
    /**
    * Path to the directory where the templated files will be written
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/template/r/dir#destination_dir Dir#destination_dir}
    */
    readonly destinationDir: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/template/r/dir#id Dir#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Path to the directory where the files to template reside
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/template/r/dir#source_dir Dir#source_dir}
    */
    readonly sourceDir: string;
    /**
    * Variables to substitute
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/template/r/dir#vars Dir#vars}
    */
    readonly vars?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/template/r/dir template_dir}
*/
export declare class Dir extends cdktf.TerraformResource {
    static readonly tfResourceType = "template_dir";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/template/r/dir template_dir} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DirConfig
    */
    constructor(scope: Construct, id: string, config: DirConfig);
    private _destinationDir?;
    get destinationDir(): string;
    set destinationDir(value: string);
    get destinationDirInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _sourceDir?;
    get sourceDir(): string;
    set sourceDir(value: string);
    get sourceDirInput(): string | undefined;
    private _vars?;
    get vars(): {
        [key: string]: string;
    };
    set vars(value: {
        [key: string]: string;
    });
    resetVars(): void;
    get varsInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
