# openshift-release
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v0
- Package version: 0.0.1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import openshift_release
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import openshift_release
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import openshift_release
from openshift_release.rest import ApiException
from pprint import pprint


# Defining host is optional and default to http://localhost
configuration.host = "http://localhost"
# Enter a context with an instance of the API client
with openshift_release.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openshift_release.ApisApi(api_client)
    
    try:
        api_response = api_instance.get_api_versions()
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ApisApi->get_api_versions: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApisApi* | [**get_api_versions**](docs/ApisApi.md#get_api_versions) | **GET** /apis/ | 
*ArtOpenshiftIoApi* | [**get_art_openshift_io_api_group**](docs/ArtOpenshiftIoApi.md#get_art_openshift_io_api_group) | **GET** /apis/art.openshift.io/ | 
*ArtOpenshiftIoV1alpha1Api* | [**create_art_openshift_io_v1alpha1_namespaced_advisory**](docs/ArtOpenshiftIoV1alpha1Api.md#create_art_openshift_io_v1alpha1_namespaced_advisory) | **POST** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/advisories | 
*ArtOpenshiftIoV1alpha1Api* | [**create_art_openshift_io_v1alpha1_namespaced_advisory_status**](docs/ArtOpenshiftIoV1alpha1Api.md#create_art_openshift_io_v1alpha1_namespaced_advisory_status) | **POST** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/advisories/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**create_art_openshift_io_v1alpha1_namespaced_build**](docs/ArtOpenshiftIoV1alpha1Api.md#create_art_openshift_io_v1alpha1_namespaced_build) | **POST** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/builds | 
*ArtOpenshiftIoV1alpha1Api* | [**create_art_openshift_io_v1alpha1_namespaced_build_status**](docs/ArtOpenshiftIoV1alpha1Api.md#create_art_openshift_io_v1alpha1_namespaced_build_status) | **POST** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/builds/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**create_art_openshift_io_v1alpha1_namespaced_component**](docs/ArtOpenshiftIoV1alpha1Api.md#create_art_openshift_io_v1alpha1_namespaced_component) | **POST** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/components | 
*ArtOpenshiftIoV1alpha1Api* | [**create_art_openshift_io_v1alpha1_namespaced_component_status**](docs/ArtOpenshiftIoV1alpha1Api.md#create_art_openshift_io_v1alpha1_namespaced_component_status) | **POST** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/components/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**create_art_openshift_io_v1alpha1_namespaced_release**](docs/ArtOpenshiftIoV1alpha1Api.md#create_art_openshift_io_v1alpha1_namespaced_release) | **POST** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/releases | 
*ArtOpenshiftIoV1alpha1Api* | [**create_art_openshift_io_v1alpha1_namespaced_release_status**](docs/ArtOpenshiftIoV1alpha1Api.md#create_art_openshift_io_v1alpha1_namespaced_release_status) | **POST** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/releases/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**create_art_openshift_io_v1alpha1_namespaced_release_stream**](docs/ArtOpenshiftIoV1alpha1Api.md#create_art_openshift_io_v1alpha1_namespaced_release_stream) | **POST** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/releasestreams | 
*ArtOpenshiftIoV1alpha1Api* | [**create_art_openshift_io_v1alpha1_namespaced_release_stream_status**](docs/ArtOpenshiftIoV1alpha1Api.md#create_art_openshift_io_v1alpha1_namespaced_release_stream_status) | **POST** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/releasestreams/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**create_art_openshift_io_v1alpha1_namespaced_rpm_compose**](docs/ArtOpenshiftIoV1alpha1Api.md#create_art_openshift_io_v1alpha1_namespaced_rpm_compose) | **POST** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/rpmcomposes | 
*ArtOpenshiftIoV1alpha1Api* | [**create_art_openshift_io_v1alpha1_namespaced_rpm_compose_status**](docs/ArtOpenshiftIoV1alpha1Api.md#create_art_openshift_io_v1alpha1_namespaced_rpm_compose_status) | **POST** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/rpmcomposes/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**create_art_openshift_io_v1alpha1_namespaced_source_revision**](docs/ArtOpenshiftIoV1alpha1Api.md#create_art_openshift_io_v1alpha1_namespaced_source_revision) | **POST** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/sourcerevisions | 
*ArtOpenshiftIoV1alpha1Api* | [**create_art_openshift_io_v1alpha1_namespaced_source_revision_status**](docs/ArtOpenshiftIoV1alpha1Api.md#create_art_openshift_io_v1alpha1_namespaced_source_revision_status) | **POST** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/sourcerevisions/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**delete_art_openshift_io_v1alpha1_collection_namespaced_advisory**](docs/ArtOpenshiftIoV1alpha1Api.md#delete_art_openshift_io_v1alpha1_collection_namespaced_advisory) | **DELETE** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/advisories | 
*ArtOpenshiftIoV1alpha1Api* | [**delete_art_openshift_io_v1alpha1_collection_namespaced_build**](docs/ArtOpenshiftIoV1alpha1Api.md#delete_art_openshift_io_v1alpha1_collection_namespaced_build) | **DELETE** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/builds | 
*ArtOpenshiftIoV1alpha1Api* | [**delete_art_openshift_io_v1alpha1_collection_namespaced_component**](docs/ArtOpenshiftIoV1alpha1Api.md#delete_art_openshift_io_v1alpha1_collection_namespaced_component) | **DELETE** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/components | 
*ArtOpenshiftIoV1alpha1Api* | [**delete_art_openshift_io_v1alpha1_collection_namespaced_release**](docs/ArtOpenshiftIoV1alpha1Api.md#delete_art_openshift_io_v1alpha1_collection_namespaced_release) | **DELETE** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/releases | 
*ArtOpenshiftIoV1alpha1Api* | [**delete_art_openshift_io_v1alpha1_collection_namespaced_release_stream**](docs/ArtOpenshiftIoV1alpha1Api.md#delete_art_openshift_io_v1alpha1_collection_namespaced_release_stream) | **DELETE** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/releasestreams | 
*ArtOpenshiftIoV1alpha1Api* | [**delete_art_openshift_io_v1alpha1_collection_namespaced_rpm_compose**](docs/ArtOpenshiftIoV1alpha1Api.md#delete_art_openshift_io_v1alpha1_collection_namespaced_rpm_compose) | **DELETE** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/rpmcomposes | 
*ArtOpenshiftIoV1alpha1Api* | [**delete_art_openshift_io_v1alpha1_collection_namespaced_source_revision**](docs/ArtOpenshiftIoV1alpha1Api.md#delete_art_openshift_io_v1alpha1_collection_namespaced_source_revision) | **DELETE** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/sourcerevisions | 
*ArtOpenshiftIoV1alpha1Api* | [**delete_art_openshift_io_v1alpha1_namespaced_advisory**](docs/ArtOpenshiftIoV1alpha1Api.md#delete_art_openshift_io_v1alpha1_namespaced_advisory) | **DELETE** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/advisories/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**delete_art_openshift_io_v1alpha1_namespaced_advisory_status**](docs/ArtOpenshiftIoV1alpha1Api.md#delete_art_openshift_io_v1alpha1_namespaced_advisory_status) | **DELETE** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/advisories/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**delete_art_openshift_io_v1alpha1_namespaced_build**](docs/ArtOpenshiftIoV1alpha1Api.md#delete_art_openshift_io_v1alpha1_namespaced_build) | **DELETE** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/builds/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**delete_art_openshift_io_v1alpha1_namespaced_build_status**](docs/ArtOpenshiftIoV1alpha1Api.md#delete_art_openshift_io_v1alpha1_namespaced_build_status) | **DELETE** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/builds/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**delete_art_openshift_io_v1alpha1_namespaced_component**](docs/ArtOpenshiftIoV1alpha1Api.md#delete_art_openshift_io_v1alpha1_namespaced_component) | **DELETE** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/components/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**delete_art_openshift_io_v1alpha1_namespaced_component_status**](docs/ArtOpenshiftIoV1alpha1Api.md#delete_art_openshift_io_v1alpha1_namespaced_component_status) | **DELETE** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/components/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**delete_art_openshift_io_v1alpha1_namespaced_release**](docs/ArtOpenshiftIoV1alpha1Api.md#delete_art_openshift_io_v1alpha1_namespaced_release) | **DELETE** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/releases/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**delete_art_openshift_io_v1alpha1_namespaced_release_status**](docs/ArtOpenshiftIoV1alpha1Api.md#delete_art_openshift_io_v1alpha1_namespaced_release_status) | **DELETE** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/releases/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**delete_art_openshift_io_v1alpha1_namespaced_release_stream**](docs/ArtOpenshiftIoV1alpha1Api.md#delete_art_openshift_io_v1alpha1_namespaced_release_stream) | **DELETE** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/releasestreams/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**delete_art_openshift_io_v1alpha1_namespaced_release_stream_status**](docs/ArtOpenshiftIoV1alpha1Api.md#delete_art_openshift_io_v1alpha1_namespaced_release_stream_status) | **DELETE** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/releasestreams/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**delete_art_openshift_io_v1alpha1_namespaced_rpm_compose**](docs/ArtOpenshiftIoV1alpha1Api.md#delete_art_openshift_io_v1alpha1_namespaced_rpm_compose) | **DELETE** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/rpmcomposes/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**delete_art_openshift_io_v1alpha1_namespaced_rpm_compose_status**](docs/ArtOpenshiftIoV1alpha1Api.md#delete_art_openshift_io_v1alpha1_namespaced_rpm_compose_status) | **DELETE** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/rpmcomposes/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**delete_art_openshift_io_v1alpha1_namespaced_source_revision**](docs/ArtOpenshiftIoV1alpha1Api.md#delete_art_openshift_io_v1alpha1_namespaced_source_revision) | **DELETE** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/sourcerevisions/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**delete_art_openshift_io_v1alpha1_namespaced_source_revision_status**](docs/ArtOpenshiftIoV1alpha1Api.md#delete_art_openshift_io_v1alpha1_namespaced_source_revision_status) | **DELETE** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/sourcerevisions/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**get_art_openshift_io_v1alpha1_api_resources**](docs/ArtOpenshiftIoV1alpha1Api.md#get_art_openshift_io_v1alpha1_api_resources) | **GET** /apis/art.openshift.io/v1alpha1/ | 
*ArtOpenshiftIoV1alpha1Api* | [**list_art_openshift_io_v1alpha1_advisory_for_all_namespaces**](docs/ArtOpenshiftIoV1alpha1Api.md#list_art_openshift_io_v1alpha1_advisory_for_all_namespaces) | **GET** /apis/art.openshift.io/v1alpha1/advisories | 
*ArtOpenshiftIoV1alpha1Api* | [**list_art_openshift_io_v1alpha1_build_for_all_namespaces**](docs/ArtOpenshiftIoV1alpha1Api.md#list_art_openshift_io_v1alpha1_build_for_all_namespaces) | **GET** /apis/art.openshift.io/v1alpha1/builds | 
*ArtOpenshiftIoV1alpha1Api* | [**list_art_openshift_io_v1alpha1_component_for_all_namespaces**](docs/ArtOpenshiftIoV1alpha1Api.md#list_art_openshift_io_v1alpha1_component_for_all_namespaces) | **GET** /apis/art.openshift.io/v1alpha1/components | 
*ArtOpenshiftIoV1alpha1Api* | [**list_art_openshift_io_v1alpha1_namespaced_advisory**](docs/ArtOpenshiftIoV1alpha1Api.md#list_art_openshift_io_v1alpha1_namespaced_advisory) | **GET** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/advisories | 
*ArtOpenshiftIoV1alpha1Api* | [**list_art_openshift_io_v1alpha1_namespaced_build**](docs/ArtOpenshiftIoV1alpha1Api.md#list_art_openshift_io_v1alpha1_namespaced_build) | **GET** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/builds | 
*ArtOpenshiftIoV1alpha1Api* | [**list_art_openshift_io_v1alpha1_namespaced_component**](docs/ArtOpenshiftIoV1alpha1Api.md#list_art_openshift_io_v1alpha1_namespaced_component) | **GET** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/components | 
*ArtOpenshiftIoV1alpha1Api* | [**list_art_openshift_io_v1alpha1_namespaced_release**](docs/ArtOpenshiftIoV1alpha1Api.md#list_art_openshift_io_v1alpha1_namespaced_release) | **GET** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/releases | 
*ArtOpenshiftIoV1alpha1Api* | [**list_art_openshift_io_v1alpha1_namespaced_release_stream**](docs/ArtOpenshiftIoV1alpha1Api.md#list_art_openshift_io_v1alpha1_namespaced_release_stream) | **GET** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/releasestreams | 
*ArtOpenshiftIoV1alpha1Api* | [**list_art_openshift_io_v1alpha1_namespaced_rpm_compose**](docs/ArtOpenshiftIoV1alpha1Api.md#list_art_openshift_io_v1alpha1_namespaced_rpm_compose) | **GET** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/rpmcomposes | 
*ArtOpenshiftIoV1alpha1Api* | [**list_art_openshift_io_v1alpha1_namespaced_source_revision**](docs/ArtOpenshiftIoV1alpha1Api.md#list_art_openshift_io_v1alpha1_namespaced_source_revision) | **GET** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/sourcerevisions | 
*ArtOpenshiftIoV1alpha1Api* | [**list_art_openshift_io_v1alpha1_release_for_all_namespaces**](docs/ArtOpenshiftIoV1alpha1Api.md#list_art_openshift_io_v1alpha1_release_for_all_namespaces) | **GET** /apis/art.openshift.io/v1alpha1/releases | 
*ArtOpenshiftIoV1alpha1Api* | [**list_art_openshift_io_v1alpha1_release_stream_for_all_namespaces**](docs/ArtOpenshiftIoV1alpha1Api.md#list_art_openshift_io_v1alpha1_release_stream_for_all_namespaces) | **GET** /apis/art.openshift.io/v1alpha1/releasestreams | 
*ArtOpenshiftIoV1alpha1Api* | [**list_art_openshift_io_v1alpha1_rpm_compose_for_all_namespaces**](docs/ArtOpenshiftIoV1alpha1Api.md#list_art_openshift_io_v1alpha1_rpm_compose_for_all_namespaces) | **GET** /apis/art.openshift.io/v1alpha1/rpmcomposes | 
*ArtOpenshiftIoV1alpha1Api* | [**list_art_openshift_io_v1alpha1_source_revision_for_all_namespaces**](docs/ArtOpenshiftIoV1alpha1Api.md#list_art_openshift_io_v1alpha1_source_revision_for_all_namespaces) | **GET** /apis/art.openshift.io/v1alpha1/sourcerevisions | 
*ArtOpenshiftIoV1alpha1Api* | [**patch_art_openshift_io_v1alpha1_namespaced_advisory**](docs/ArtOpenshiftIoV1alpha1Api.md#patch_art_openshift_io_v1alpha1_namespaced_advisory) | **PATCH** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/advisories/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**patch_art_openshift_io_v1alpha1_namespaced_advisory_status**](docs/ArtOpenshiftIoV1alpha1Api.md#patch_art_openshift_io_v1alpha1_namespaced_advisory_status) | **PATCH** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/advisories/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**patch_art_openshift_io_v1alpha1_namespaced_build**](docs/ArtOpenshiftIoV1alpha1Api.md#patch_art_openshift_io_v1alpha1_namespaced_build) | **PATCH** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/builds/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**patch_art_openshift_io_v1alpha1_namespaced_build_status**](docs/ArtOpenshiftIoV1alpha1Api.md#patch_art_openshift_io_v1alpha1_namespaced_build_status) | **PATCH** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/builds/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**patch_art_openshift_io_v1alpha1_namespaced_component**](docs/ArtOpenshiftIoV1alpha1Api.md#patch_art_openshift_io_v1alpha1_namespaced_component) | **PATCH** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/components/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**patch_art_openshift_io_v1alpha1_namespaced_component_status**](docs/ArtOpenshiftIoV1alpha1Api.md#patch_art_openshift_io_v1alpha1_namespaced_component_status) | **PATCH** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/components/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**patch_art_openshift_io_v1alpha1_namespaced_release**](docs/ArtOpenshiftIoV1alpha1Api.md#patch_art_openshift_io_v1alpha1_namespaced_release) | **PATCH** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/releases/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**patch_art_openshift_io_v1alpha1_namespaced_release_status**](docs/ArtOpenshiftIoV1alpha1Api.md#patch_art_openshift_io_v1alpha1_namespaced_release_status) | **PATCH** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/releases/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**patch_art_openshift_io_v1alpha1_namespaced_release_stream**](docs/ArtOpenshiftIoV1alpha1Api.md#patch_art_openshift_io_v1alpha1_namespaced_release_stream) | **PATCH** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/releasestreams/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**patch_art_openshift_io_v1alpha1_namespaced_release_stream_status**](docs/ArtOpenshiftIoV1alpha1Api.md#patch_art_openshift_io_v1alpha1_namespaced_release_stream_status) | **PATCH** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/releasestreams/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**patch_art_openshift_io_v1alpha1_namespaced_rpm_compose**](docs/ArtOpenshiftIoV1alpha1Api.md#patch_art_openshift_io_v1alpha1_namespaced_rpm_compose) | **PATCH** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/rpmcomposes/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**patch_art_openshift_io_v1alpha1_namespaced_rpm_compose_status**](docs/ArtOpenshiftIoV1alpha1Api.md#patch_art_openshift_io_v1alpha1_namespaced_rpm_compose_status) | **PATCH** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/rpmcomposes/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**patch_art_openshift_io_v1alpha1_namespaced_source_revision**](docs/ArtOpenshiftIoV1alpha1Api.md#patch_art_openshift_io_v1alpha1_namespaced_source_revision) | **PATCH** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/sourcerevisions/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**patch_art_openshift_io_v1alpha1_namespaced_source_revision_status**](docs/ArtOpenshiftIoV1alpha1Api.md#patch_art_openshift_io_v1alpha1_namespaced_source_revision_status) | **PATCH** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/sourcerevisions/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**read_art_openshift_io_v1alpha1_namespaced_advisory**](docs/ArtOpenshiftIoV1alpha1Api.md#read_art_openshift_io_v1alpha1_namespaced_advisory) | **GET** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/advisories/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**read_art_openshift_io_v1alpha1_namespaced_advisory_status**](docs/ArtOpenshiftIoV1alpha1Api.md#read_art_openshift_io_v1alpha1_namespaced_advisory_status) | **GET** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/advisories/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**read_art_openshift_io_v1alpha1_namespaced_build**](docs/ArtOpenshiftIoV1alpha1Api.md#read_art_openshift_io_v1alpha1_namespaced_build) | **GET** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/builds/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**read_art_openshift_io_v1alpha1_namespaced_build_status**](docs/ArtOpenshiftIoV1alpha1Api.md#read_art_openshift_io_v1alpha1_namespaced_build_status) | **GET** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/builds/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**read_art_openshift_io_v1alpha1_namespaced_component**](docs/ArtOpenshiftIoV1alpha1Api.md#read_art_openshift_io_v1alpha1_namespaced_component) | **GET** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/components/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**read_art_openshift_io_v1alpha1_namespaced_component_status**](docs/ArtOpenshiftIoV1alpha1Api.md#read_art_openshift_io_v1alpha1_namespaced_component_status) | **GET** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/components/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**read_art_openshift_io_v1alpha1_namespaced_release**](docs/ArtOpenshiftIoV1alpha1Api.md#read_art_openshift_io_v1alpha1_namespaced_release) | **GET** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/releases/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**read_art_openshift_io_v1alpha1_namespaced_release_status**](docs/ArtOpenshiftIoV1alpha1Api.md#read_art_openshift_io_v1alpha1_namespaced_release_status) | **GET** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/releases/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**read_art_openshift_io_v1alpha1_namespaced_release_stream**](docs/ArtOpenshiftIoV1alpha1Api.md#read_art_openshift_io_v1alpha1_namespaced_release_stream) | **GET** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/releasestreams/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**read_art_openshift_io_v1alpha1_namespaced_release_stream_status**](docs/ArtOpenshiftIoV1alpha1Api.md#read_art_openshift_io_v1alpha1_namespaced_release_stream_status) | **GET** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/releasestreams/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**read_art_openshift_io_v1alpha1_namespaced_rpm_compose**](docs/ArtOpenshiftIoV1alpha1Api.md#read_art_openshift_io_v1alpha1_namespaced_rpm_compose) | **GET** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/rpmcomposes/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**read_art_openshift_io_v1alpha1_namespaced_rpm_compose_status**](docs/ArtOpenshiftIoV1alpha1Api.md#read_art_openshift_io_v1alpha1_namespaced_rpm_compose_status) | **GET** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/rpmcomposes/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**read_art_openshift_io_v1alpha1_namespaced_source_revision**](docs/ArtOpenshiftIoV1alpha1Api.md#read_art_openshift_io_v1alpha1_namespaced_source_revision) | **GET** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/sourcerevisions/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**read_art_openshift_io_v1alpha1_namespaced_source_revision_status**](docs/ArtOpenshiftIoV1alpha1Api.md#read_art_openshift_io_v1alpha1_namespaced_source_revision_status) | **GET** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/sourcerevisions/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**replace_art_openshift_io_v1alpha1_namespaced_advisory**](docs/ArtOpenshiftIoV1alpha1Api.md#replace_art_openshift_io_v1alpha1_namespaced_advisory) | **PUT** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/advisories/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**replace_art_openshift_io_v1alpha1_namespaced_advisory_status**](docs/ArtOpenshiftIoV1alpha1Api.md#replace_art_openshift_io_v1alpha1_namespaced_advisory_status) | **PUT** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/advisories/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**replace_art_openshift_io_v1alpha1_namespaced_build**](docs/ArtOpenshiftIoV1alpha1Api.md#replace_art_openshift_io_v1alpha1_namespaced_build) | **PUT** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/builds/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**replace_art_openshift_io_v1alpha1_namespaced_build_status**](docs/ArtOpenshiftIoV1alpha1Api.md#replace_art_openshift_io_v1alpha1_namespaced_build_status) | **PUT** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/builds/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**replace_art_openshift_io_v1alpha1_namespaced_component**](docs/ArtOpenshiftIoV1alpha1Api.md#replace_art_openshift_io_v1alpha1_namespaced_component) | **PUT** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/components/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**replace_art_openshift_io_v1alpha1_namespaced_component_status**](docs/ArtOpenshiftIoV1alpha1Api.md#replace_art_openshift_io_v1alpha1_namespaced_component_status) | **PUT** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/components/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**replace_art_openshift_io_v1alpha1_namespaced_release**](docs/ArtOpenshiftIoV1alpha1Api.md#replace_art_openshift_io_v1alpha1_namespaced_release) | **PUT** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/releases/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**replace_art_openshift_io_v1alpha1_namespaced_release_status**](docs/ArtOpenshiftIoV1alpha1Api.md#replace_art_openshift_io_v1alpha1_namespaced_release_status) | **PUT** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/releases/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**replace_art_openshift_io_v1alpha1_namespaced_release_stream**](docs/ArtOpenshiftIoV1alpha1Api.md#replace_art_openshift_io_v1alpha1_namespaced_release_stream) | **PUT** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/releasestreams/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**replace_art_openshift_io_v1alpha1_namespaced_release_stream_status**](docs/ArtOpenshiftIoV1alpha1Api.md#replace_art_openshift_io_v1alpha1_namespaced_release_stream_status) | **PUT** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/releasestreams/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**replace_art_openshift_io_v1alpha1_namespaced_rpm_compose**](docs/ArtOpenshiftIoV1alpha1Api.md#replace_art_openshift_io_v1alpha1_namespaced_rpm_compose) | **PUT** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/rpmcomposes/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**replace_art_openshift_io_v1alpha1_namespaced_rpm_compose_status**](docs/ArtOpenshiftIoV1alpha1Api.md#replace_art_openshift_io_v1alpha1_namespaced_rpm_compose_status) | **PUT** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/rpmcomposes/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**replace_art_openshift_io_v1alpha1_namespaced_source_revision**](docs/ArtOpenshiftIoV1alpha1Api.md#replace_art_openshift_io_v1alpha1_namespaced_source_revision) | **PUT** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/sourcerevisions/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**replace_art_openshift_io_v1alpha1_namespaced_source_revision_status**](docs/ArtOpenshiftIoV1alpha1Api.md#replace_art_openshift_io_v1alpha1_namespaced_source_revision_status) | **PUT** /apis/art.openshift.io/v1alpha1/namespaces/{namespace}/sourcerevisions/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_advisory_list_for_all_namespaces**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_advisory_list_for_all_namespaces) | **GET** /apis/art.openshift.io/v1alpha1/watch/advisories | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_build_list_for_all_namespaces**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_build_list_for_all_namespaces) | **GET** /apis/art.openshift.io/v1alpha1/watch/builds | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_component_list_for_all_namespaces**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_component_list_for_all_namespaces) | **GET** /apis/art.openshift.io/v1alpha1/watch/components | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_namespaced_advisory**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_namespaced_advisory) | **GET** /apis/art.openshift.io/v1alpha1/watch/namespaces/{namespace}/advisories/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_namespaced_advisory_list**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_namespaced_advisory_list) | **GET** /apis/art.openshift.io/v1alpha1/watch/namespaces/{namespace}/advisories | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_namespaced_advisory_status**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_namespaced_advisory_status) | **GET** /apis/art.openshift.io/v1alpha1/watch/namespaces/{namespace}/advisories/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_namespaced_build**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_namespaced_build) | **GET** /apis/art.openshift.io/v1alpha1/watch/namespaces/{namespace}/builds/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_namespaced_build_list**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_namespaced_build_list) | **GET** /apis/art.openshift.io/v1alpha1/watch/namespaces/{namespace}/builds | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_namespaced_build_status**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_namespaced_build_status) | **GET** /apis/art.openshift.io/v1alpha1/watch/namespaces/{namespace}/builds/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_namespaced_component**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_namespaced_component) | **GET** /apis/art.openshift.io/v1alpha1/watch/namespaces/{namespace}/components/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_namespaced_component_list**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_namespaced_component_list) | **GET** /apis/art.openshift.io/v1alpha1/watch/namespaces/{namespace}/components | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_namespaced_component_status**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_namespaced_component_status) | **GET** /apis/art.openshift.io/v1alpha1/watch/namespaces/{namespace}/components/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_namespaced_release**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_namespaced_release) | **GET** /apis/art.openshift.io/v1alpha1/watch/namespaces/{namespace}/releases/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_namespaced_release_list**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_namespaced_release_list) | **GET** /apis/art.openshift.io/v1alpha1/watch/namespaces/{namespace}/releases | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_namespaced_release_status**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_namespaced_release_status) | **GET** /apis/art.openshift.io/v1alpha1/watch/namespaces/{namespace}/releases/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_namespaced_release_stream**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_namespaced_release_stream) | **GET** /apis/art.openshift.io/v1alpha1/watch/namespaces/{namespace}/releasestreams/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_namespaced_release_stream_list**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_namespaced_release_stream_list) | **GET** /apis/art.openshift.io/v1alpha1/watch/namespaces/{namespace}/releasestreams | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_namespaced_release_stream_status**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_namespaced_release_stream_status) | **GET** /apis/art.openshift.io/v1alpha1/watch/namespaces/{namespace}/releasestreams/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_namespaced_rpm_compose**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_namespaced_rpm_compose) | **GET** /apis/art.openshift.io/v1alpha1/watch/namespaces/{namespace}/rpmcomposes/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_namespaced_rpm_compose_list**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_namespaced_rpm_compose_list) | **GET** /apis/art.openshift.io/v1alpha1/watch/namespaces/{namespace}/rpmcomposes | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_namespaced_rpm_compose_status**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_namespaced_rpm_compose_status) | **GET** /apis/art.openshift.io/v1alpha1/watch/namespaces/{namespace}/rpmcomposes/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_namespaced_source_revision**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_namespaced_source_revision) | **GET** /apis/art.openshift.io/v1alpha1/watch/namespaces/{namespace}/sourcerevisions/{name} | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_namespaced_source_revision_list**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_namespaced_source_revision_list) | **GET** /apis/art.openshift.io/v1alpha1/watch/namespaces/{namespace}/sourcerevisions | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_namespaced_source_revision_status**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_namespaced_source_revision_status) | **GET** /apis/art.openshift.io/v1alpha1/watch/namespaces/{namespace}/sourcerevisions/{name}/status | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_release_list_for_all_namespaces**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_release_list_for_all_namespaces) | **GET** /apis/art.openshift.io/v1alpha1/watch/releases | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_release_stream_list_for_all_namespaces**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_release_stream_list_for_all_namespaces) | **GET** /apis/art.openshift.io/v1alpha1/watch/releasestreams | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_rpm_compose_list_for_all_namespaces**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_rpm_compose_list_for_all_namespaces) | **GET** /apis/art.openshift.io/v1alpha1/watch/rpmcomposes | 
*ArtOpenshiftIoV1alpha1Api* | [**watch_art_openshift_io_v1alpha1_source_revision_list_for_all_namespaces**](docs/ArtOpenshiftIoV1alpha1Api.md#watch_art_openshift_io_v1alpha1_source_revision_list_for_all_namespaces) | **GET** /apis/art.openshift.io/v1alpha1/watch/sourcerevisions | 
*VersionApi* | [**get_code_version**](docs/VersionApi.md#get_code_version) | **GET** /version/ | 


## Documentation For Models

 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1Advisory](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1Advisory.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1AdvisoryList](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1AdvisoryList.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1AdvisorySpec](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1AdvisorySpec.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1AdvisoryStatus](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1AdvisoryStatus.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1BrewBuild](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1BrewBuild.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1Build](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1Build.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1BuildJenkinsInfo](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1BuildJenkinsInfo.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1BuildList](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1BuildList.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1BuildSpec](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1BuildSpec.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1Component](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1Component.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ComponentDistGit](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ComponentDistGit.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ComponentGitSource](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ComponentGitSource.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ComponentImage](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ComponentImage.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ComponentList](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ComponentList.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ComponentSource](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ComponentSource.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ComponentSpec](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ComponentSpec.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1OcpBuildDataGitSource](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1OcpBuildDataGitSource.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1RPMCompose](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1RPMCompose.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1RPMComposeList](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1RPMComposeList.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1Release](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1Release.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ReleaseList](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ReleaseList.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ReleaseSpec](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ReleaseSpec.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ReleaseStream](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ReleaseStream.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ReleaseStreamList](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ReleaseStreamList.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ReleaseStreamOcpBuildData](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ReleaseStreamOcpBuildData.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ReleaseStreamSpec](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ReleaseStreamSpec.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ReleaseVersion](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1ReleaseVersion.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1SourceRevision](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1SourceRevision.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1SourceRevisionList](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1SourceRevisionList.md)
 - [ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1SourceRevisionSpec](docs/ComGithubVfreexReleaseApiserverPkgApisArtV1alpha1SourceRevisionSpec.md)
 - [IoK8sApimachineryPkgApisMetaV1APIGroup](docs/IoK8sApimachineryPkgApisMetaV1APIGroup.md)
 - [IoK8sApimachineryPkgApisMetaV1APIGroupList](docs/IoK8sApimachineryPkgApisMetaV1APIGroupList.md)
 - [IoK8sApimachineryPkgApisMetaV1APIResource](docs/IoK8sApimachineryPkgApisMetaV1APIResource.md)
 - [IoK8sApimachineryPkgApisMetaV1APIResourceList](docs/IoK8sApimachineryPkgApisMetaV1APIResourceList.md)
 - [IoK8sApimachineryPkgApisMetaV1DeleteOptions](docs/IoK8sApimachineryPkgApisMetaV1DeleteOptions.md)
 - [IoK8sApimachineryPkgApisMetaV1GroupVersionForDiscovery](docs/IoK8sApimachineryPkgApisMetaV1GroupVersionForDiscovery.md)
 - [IoK8sApimachineryPkgApisMetaV1ListMeta](docs/IoK8sApimachineryPkgApisMetaV1ListMeta.md)
 - [IoK8sApimachineryPkgApisMetaV1ManagedFieldsEntry](docs/IoK8sApimachineryPkgApisMetaV1ManagedFieldsEntry.md)
 - [IoK8sApimachineryPkgApisMetaV1ObjectMeta](docs/IoK8sApimachineryPkgApisMetaV1ObjectMeta.md)
 - [IoK8sApimachineryPkgApisMetaV1OwnerReference](docs/IoK8sApimachineryPkgApisMetaV1OwnerReference.md)
 - [IoK8sApimachineryPkgApisMetaV1Preconditions](docs/IoK8sApimachineryPkgApisMetaV1Preconditions.md)
 - [IoK8sApimachineryPkgApisMetaV1ServerAddressByClientCIDR](docs/IoK8sApimachineryPkgApisMetaV1ServerAddressByClientCIDR.md)
 - [IoK8sApimachineryPkgApisMetaV1Status](docs/IoK8sApimachineryPkgApisMetaV1Status.md)
 - [IoK8sApimachineryPkgApisMetaV1StatusCause](docs/IoK8sApimachineryPkgApisMetaV1StatusCause.md)
 - [IoK8sApimachineryPkgApisMetaV1StatusDetails](docs/IoK8sApimachineryPkgApisMetaV1StatusDetails.md)
 - [IoK8sApimachineryPkgApisMetaV1WatchEvent](docs/IoK8sApimachineryPkgApisMetaV1WatchEvent.md)
 - [IoK8sApimachineryPkgVersionInfo](docs/IoK8sApimachineryPkgVersionInfo.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author




