# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pydelling',
 'pydelling.config',
 'pydelling.interpolation',
 'pydelling.managers',
 'pydelling.managers.callbacks',
 'pydelling.paraview_processor',
 'pydelling.paraview_processor.filters',
 'pydelling.preprocessing',
 'pydelling.preprocessing.dfn_preprocessor',
 'pydelling.preprocessing.gid_preprocessor',
 'pydelling.preprocessing.mesh_preprocessor',
 'pydelling.preprocessing.mesh_preprocessor.geometry',
 'pydelling.readers',
 'pydelling.readers.iGPReader',
 'pydelling.readers.iGPReader.engines',
 'pydelling.readers.iGPReader.geometry',
 'pydelling.readers.iGPReader.io',
 'pydelling.readers.iGPReader.utils',
 'pydelling.tests',
 'pydelling.tests.interpolation',
 'pydelling.tests.managers',
 'pydelling.tests.preprocessing',
 'pydelling.tests.preprocessing.DfnPreprocessor',
 'pydelling.tests.preprocessing.MeshPreprocessor',
 'pydelling.tests.readers',
 'pydelling.tests.utils',
 'pydelling.tests.utils.geometry',
 'pydelling.tests.writers',
 'pydelling.utils',
 'pydelling.utils.geometry',
 'pydelling.webapps',
 'pydelling.webapps.components',
 'pydelling.webapps.webapps',
 'pydelling.writers']

package_data = \
{'': ['*'],
 'pydelling.tests': ['_trial_temp/custom_edge_intersections.txt',
                     '_trial_temp/custom_edge_intersections.txt',
                     '_trial_temp/custom_edge_intersections.txt',
                     '_trial_temp/custom_edge_intersections.txt',
                     '_trial_temp/custom_edge_intersections.txt',
                     '_trial_temp/custom_edge_intersections.txt',
                     '_trial_temp/custom_edge_intersections.txt',
                     '_trial_temp/custom_edge_intersections.txt',
                     '_trial_temp/element.obj',
                     '_trial_temp/element.obj',
                     '_trial_temp/element.obj',
                     '_trial_temp/element.obj',
                     '_trial_temp/element.obj',
                     '_trial_temp/element.obj',
                     '_trial_temp/element.obj',
                     '_trial_temp/element.obj',
                     '_trial_temp/fracture.obj',
                     '_trial_temp/fracture.obj',
                     '_trial_temp/fracture.obj',
                     '_trial_temp/fracture.obj',
                     '_trial_temp/fracture.obj',
                     '_trial_temp/fracture.obj',
                     '_trial_temp/fracture.obj',
                     '_trial_temp/fracture.obj',
                     '_trial_temp/gid_batch.bch',
                     '_trial_temp/gid_batch.bch',
                     '_trial_temp/gid_batch.bch',
                     '_trial_temp/gid_batch.bch',
                     '_trial_temp/gid_batch.bch',
                     '_trial_temp/gid_batch.bch',
                     '_trial_temp/gid_batch.bch',
                     '_trial_temp/gid_batch.bch',
                     '_trial_temp/studies/BaseStudy-2/*',
                     '_trial_temp/test.json',
                     '_trial_temp/test.json',
                     '_trial_temp/test.json',
                     '_trial_temp/test.json',
                     '_trial_temp/test.json',
                     '_trial_temp/test.json',
                     '_trial_temp/test.json',
                     '_trial_temp/test.json',
                     '_trial_temp/test_dfn.vtk',
                     '_trial_temp/test_dfn.vtk',
                     '_trial_temp/test_dfn.vtk',
                     '_trial_temp/test_dfn.vtk',
                     '_trial_temp/test_dfn.vtk',
                     '_trial_temp/test_dfn.vtk',
                     '_trial_temp/test_dfn.vtk',
                     '_trial_temp/test_dfn.vtk',
                     '_trial_temp/test_element.obj',
                     '_trial_temp/test_element.obj',
                     '_trial_temp/test_element.obj',
                     '_trial_temp/test_element.obj',
                     '_trial_temp/test_element.obj',
                     '_trial_temp/test_element.obj',
                     '_trial_temp/test_element.obj',
                     '_trial_temp/test_element.obj',
                     '_trial_temp/test_mesh.vtk',
                     '_trial_temp/test_mesh.vtk',
                     '_trial_temp/test_mesh.vtk',
                     '_trial_temp/test_mesh.vtk',
                     '_trial_temp/test_mesh.vtk',
                     '_trial_temp/test_mesh.vtk',
                     '_trial_temp/test_mesh.vtk',
                     '_trial_temp/test_mesh.vtk',
                     'case-6/*',
                     'results/Pwall.ex',
                     'results/Pwall.ex',
                     'results/test-implicit_to_explicit.mesh',
                     'results/test-implicit_to_explicit.mesh',
                     'studies/BaseStudy-2/*',
                     'test_data/*',
                     'test_data/problematic_fractures/*',
                     'test_data/test_implicit_to_explicit.gid/*',
                     'test_data/test_implicit_to_explicit.gid/PFLOTRAN/*',
                     'test_data/test_implicit_to_explicit.gid/PFLOTRAN/PFLOTRANrun/*',
                     'test_folder/*'],
 'pydelling.tests.managers': ['_trial_temp/studies/BaseStudy-2/*'],
 'pydelling.tests.readers': ['_trial_temp/*'],
 'pydelling.tests.utils.geometry': ['_trial_temp/*'],
 'pydelling.webapps': ['.streamlit/*']}

install_requires = \
['alive-progress',
 'dill',
 'docker',
 'h5py',
 'matplotlib',
 'meshio',
 'mkdocs',
 'mkdocs-material',
 'mkdocstrings',
 'mpmath',
 'natsort',
 'numpy',
 'numpy-stl',
 'ofpp',
 'openpyxl',
 'pandas',
 'paramiko',
 'plotly',
 'python-box',
 'pyyaml',
 'rich',
 'rtree',
 'scikit-learn',
 'scipy',
 'seaborn',
 'setuptools',
 'shapely',
 'sklearn',
 'streamlit',
 'tabulate',
 'tqdm',
 'trimesh',
 'vtk',
 'xlrd']

setup_kwargs = {
    'name': 'pydelling',
    'version': '1.10.4',
    'description': 'Package providing a variety of utility methods for mathematical modelling',
    'long_description': ' # Pydelling\nSet of pre- and post-processing scripts for modelling\n\n\n## Recommendations\n\nUsing and IDE like PyCharm is recommended to keep things easy. It may be useful if you need to debug your scripts,\nor edit them.\n\nUsing PyCharm, you can follow the installation step and then run your scripts in pydelling env automatically.\nOtherwise, you can follow the steps below to run pydelling manually. \n\n\n## Installation\nConfigure the conda environment running\n\n`conda env create --file environment.yaml`\n\nRegular pip dependencies can be found at `requirements.txt`\n\n\n## Templates and Examples\n\nSome examples of usage of pydelling may be found inside `templates` folder. Use `config.yaml` to setup data sources and \nother variables.\n\n\n## Running template scripts\n\nIn order to execute pydelling, `pydelling` conda env needs to be loaded.\n\n\n### Loading conda environment\n\n`conda activate pydelling`\n\n### Running script\n\nRun the script and set the config file as argument. If the config file is not specified, `./config.yaml` will be taken as default.\n\nExample: \n\n`python templates\\interpolate_top_BC\\interpolate_BC.py templates\\interpolate_top_BC\\config.yaml`\n\n',
    'author': 'Aitor',
    'author_email': 'aitirga@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<3.11',
}


setup(**setup_kwargs)
