# Generated by Django 3.1 on 2022-08-03 13:31

from django.db import migrations, models
import django.db.models.deletion
import pgcrypto.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Database',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('handle', models.SlugField(help_text='Set a unique name for this database', max_length=200)),
                ('source', models.IntegerField(choices=[(0, 'PostgreSQL'), (1, 'Microsoft SQL'), (2, 'MySQL/MariaDB'), (3, 'SQLite'), (4, 'FireBird')], help_text='Select what kind of SQL database this is')),
                ('config', pgcrypto.fields.EncryptedTextField(charset='utf-8', check_armor=True, cipher='aes', help_text='Set connection information and credentials', max_length=1000, versioned=False)),
                ('description', models.CharField(help_text='Describe what this database is all about', max_length=200)),
            ],
        ),
        migrations.CreateModel(
            name='StateWatcher',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Describe this state watcher or give it a name', max_length=200)),
                ('query', models.CharField(help_text='SQL statment that will be used to get some state data that needs to be watched', max_length=10000)),
                ('interval', models.IntegerField(help_text='Time interval in minutes on which the state will be evaluated')),
                ('identity', models.CharField(help_text='(This is required in case the query can possibly return more than one record) identity column is used to identify which record has been removed in case the number of record dropped to less than it used to be in the previous interval', max_length=100)),
                ('target', models.CharField(help_text='Webhook link to which notifications will be sent or path to python function to execute', max_length=1000)),
                ('last_state', models.CharField(editable=False, max_length=1073741824)),
                ('database', models.ForeignKey(help_text='The database containing the state data to watch', on_delete=django.db.models.deletion.CASCADE, to='alert360.database')),
            ],
        ),
    ]
