/*
 Highcharts JS v10.3.2 (2022-11-28)

 3D features for Highcharts JS

 License: www.highcharts.com/license
*/
(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/highcharts-3d",["highcharts"],function(F){a(F);a.Highcharts=F;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function F(a,z,y,D){a.hasOwnProperty(z)||(a[z]=D.apply(null,y),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:z,module:a[z]}})))}a=a?a._modules:{};F(a,"Core/Math3D.js",
[a["Core/Globals.js"],a["Core/Utilities.js"]],function(a,z){function y(m,f,k,c){var b=f.options.chart.options3d,a=r(c,k?f.inverted:!1),g={x:f.plotWidth/2,y:f.plotHeight/2,z:b.depth/2,vd:r(b.depth,1)*r(b.viewDistance,0)},B=f.scale3d||1;c=H*b.beta*(a?-1:1);b=H*b.alpha*(a?-1:1);var p=Math.cos(b),t=Math.cos(-c),C=Math.sin(b),n=Math.sin(-c);k||(g.x+=f.plotLeft,g.y+=f.plotTop);return m.map(function(b){var f=(a?b.y:b.x)-g.x;var c=(a?b.x:b.y)-g.y;b=(b.z||0)-g.z;f={x:t*f-n*b,y:-C*n*f+p*c-t*C*b,z:p*n*f+C*c+
p*t*b};c=x(f,g,g.vd);c.x=c.x*B+g.x;c.y=c.y*B+g.y;c.z=f.z*B+g.z;return{x:a?c.y:c.x,y:a?c.x:c.y,z:c.z}})}function x(a,f,k){f=0<k&&k<Number.POSITIVE_INFINITY?k/(a.z+f.z+k):1;return{x:a.x*f,y:a.y*f}}function m(a){var f=0,k;for(k=0;k<a.length;k++){var c=(k+1)%a.length;f+=a[k].x*a[c].y-a[c].x*a[k].y}return f/2}var H=a.deg2rad,r=z.pick;return{perspective:y,perspective3D:x,pointCameraDistance:function(a,f){var k=f.options.chart.options3d,c=f.plotWidth/2;f=f.plotHeight/2;k=r(k.depth,1)*r(k.viewDistance,0)+
k.depth;return Math.sqrt(Math.pow(c-r(a.plotX,a.x),2)+Math.pow(f-r(a.plotY,a.y),2)+Math.pow(k-r(a.plotZ,a.z),2))},shapeArea:m,shapeArea3D:function(a,f,k){return m(y(a,f,k))}}});F(a,"Core/Renderer/SVG/SVGElement3D.js",[a["Core/Color/Color.js"],a["Core/Renderer/SVG/SVGElement.js"],a["Core/Utilities.js"]],function(a,z,y){var x=a.parse,m=y.defined;a=y.merge;var H=y.objectEach,r=y.pick,C={base:{initArgs:function(f){var a=this,c=a.renderer,b=c[a.pathType+"Path"](f),m=b.zIndexes;a.parts.forEach(function(g){var f=
{"class":"highcharts-3d-"+g,zIndex:m[g]||0};c.styledMode&&("top"===g?f.filter="url(#highcharts-brighter)":"side"===g&&(f.filter="url(#highcharts-darker)"));a[g]=c.path(b[g]).attr(f).add(a)});a.attr({"stroke-linejoin":"round",zIndex:m.group});a.originalDestroy=a.destroy;a.destroy=a.destroyParts;a.forcedSides=b.forcedSides},singleSetterForParts:function(a,m,c,b,l,g){var f={};b=[null,null,b||"attr",l,g];var p=c&&c.zIndexes;c?(p&&p.group&&this.attr({zIndex:p.group}),H(c,function(b,g){f[g]={};f[g][a]=
b;p&&(f[g].zIndex=c.zIndexes[g]||0)}),b[1]=f):(f[a]=m,b[0]=f);return this.processParts.apply(this,b)},processParts:function(a,m,c,b,l){var g=this;g.parts.forEach(function(f){m&&(a=r(m[f],!1));if(!1!==a)g[f][c](a,b,l)});return g},destroyParts:function(){this.processParts(null,null,"destroy");return this.originalDestroy()}}};C.cuboid=a(C.base,{parts:["front","top","side"],pathType:"cuboid",attr:function(a,k,c,b){if("string"===typeof a&&"undefined"!==typeof k){var f=a;a={};a[f]=k}return a.shapeArgs||
m(a.x)?this.singleSetterForParts("d",null,this.renderer[this.pathType+"Path"](a.shapeArgs||a)):z.prototype.attr.call(this,a,void 0,c,b)},animate:function(a,k,c){if(m(a.x)&&m(a.y)){a=this.renderer[this.pathType+"Path"](a);var b=a.forcedSides;this.singleSetterForParts("d",null,a,"animate",k,c);this.attr({zIndex:a.zIndexes.group});b!==this.forcedSides&&(this.forcedSides=b,this.renderer.styledMode||C.cuboid.fillSetter.call(this,this.fill))}else z.prototype.animate.call(this,a,k,c);return this},fillSetter:function(a){this.forcedSides=
this.forcedSides||[];this.singleSetterForParts("fill",null,{front:a,top:x(a).brighten(0<=this.forcedSides.indexOf("top")?0:.1).get(),side:x(a).brighten(0<=this.forcedSides.indexOf("side")?0:-.1).get()});this.color=this.fill=a;return this}});return C});F(a,"Core/Renderer/SVG/SVGRenderer3D.js",[a["Core/Animation/AnimationUtilities.js"],a["Core/Color/Color.js"],a["Core/Globals.js"],a["Core/Math3D.js"],a["Core/Renderer/SVG/SVGElement.js"],a["Core/Renderer/SVG/SVGElement3D.js"],a["Core/Renderer/SVG/SVGRenderer.js"],
a["Core/Utilities.js"]],function(a,z,y,D,m,H,r,C){var f=this&&this.__extends||function(){var a=function(h,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,e){a.__proto__=e}||function(a,e){for(var u in e)e.hasOwnProperty(u)&&(a[u]=e[u])};return a(h,b)};return function(h,b){function g(){this.constructor=h}a(h,b);h.prototype=null===b?Object.create(b):(g.prototype=b.prototype,new g)}}(),k=a.animObject,c=z.parse,b=y.charts,l=y.deg2rad,g=D.perspective,B=D.shapeArea,p=C.defined,t=C.extend,
v=C.merge,n=C.pick,x=Math.cos,E=Math.sin,J=Math.PI,K=4*(Math.sqrt(2)-1)/3/(J/2);return function(a){function h(){return null!==a&&a.apply(this,arguments)||this}f(h,a);h.compose=function(a){a=a.prototype;var b=h.prototype;a.elements3d=H;a.arc3d=b.arc3d;a.arc3dPath=b.arc3dPath;a.cuboid=b.cuboid;a.cuboidPath=b.cuboidPath;a.element3d=b.element3d;a.face3d=b.face3d;a.polyhedron=b.polyhedron;a.toLinePath=b.toLinePath;a.toLineSegments=b.toLineSegments};h.curveTo=function(a,b,e,u,d,q,w,A){var h=[],g=q-d;return q>
d&&q-d>Math.PI/2+.0001?(h=h.concat(this.curveTo(a,b,e,u,d,d+Math.PI/2,w,A)),h=h.concat(this.curveTo(a,b,e,u,d+Math.PI/2,q,w,A))):q<d&&d-q>Math.PI/2+.0001?(h=h.concat(this.curveTo(a,b,e,u,d,d-Math.PI/2,w,A)),h=h.concat(this.curveTo(a,b,e,u,d-Math.PI/2,q,w,A))):[["C",a+e*Math.cos(d)-e*K*g*Math.sin(d)+w,b+u*Math.sin(d)+u*K*g*Math.cos(d)+A,a+e*Math.cos(q)+e*K*g*Math.sin(q)+w,b+u*Math.sin(q)-u*K*g*Math.cos(q)+A,a+e*Math.cos(q)+w,b+u*Math.sin(q)+A]]};h.prototype.toLinePath=function(a,b){var e=[];a.forEach(function(a){e.push(["L",
a.x,a.y])});a.length&&(e[0][0]="M",b&&e.push(["Z"]));return e};h.prototype.toLineSegments=function(a){var b=[],e=!0;a.forEach(function(a){b.push(e?["M",a.x,a.y]:["L",a.x,a.y]);e=!e});return b};h.prototype.face3d=function(a){var h=this,e=this.createElement("path");e.vertexes=[];e.insidePlotArea=!1;e.enabled=!0;e.attr=function(e){if("object"===typeof e&&(p(e.enabled)||p(e.vertexes)||p(e.insidePlotArea))){this.enabled=n(e.enabled,this.enabled);this.vertexes=n(e.vertexes,this.vertexes);this.insidePlotArea=
n(e.insidePlotArea,this.insidePlotArea);delete e.enabled;delete e.vertexes;delete e.insidePlotArea;var d=g(this.vertexes,b[h.chartIndex],this.insidePlotArea),q=h.toLinePath(d,!0);d=B(d);e.d=q;e.visibility=this.enabled&&0<d?"inherit":"hidden"}return m.prototype.attr.apply(this,arguments)};e.animate=function(e){if("object"===typeof e&&(p(e.enabled)||p(e.vertexes)||p(e.insidePlotArea))){this.enabled=n(e.enabled,this.enabled);this.vertexes=n(e.vertexes,this.vertexes);this.insidePlotArea=n(e.insidePlotArea,
this.insidePlotArea);delete e.enabled;delete e.vertexes;delete e.insidePlotArea;var d=g(this.vertexes,b[h.chartIndex],this.insidePlotArea),q=h.toLinePath(d,!0);d=B(d);d=this.enabled&&0<d?"visible":"hidden";e.d=q;this.attr("visibility",d)}return m.prototype.animate.apply(this,arguments)};return e.attr(a)};h.prototype.polyhedron=function(a){var b=this,e=this.g(),h=e.destroy;this.styledMode||e.attr({"stroke-linejoin":"round"});e.faces=[];e.destroy=function(){for(var d=0;d<e.faces.length;d++)e.faces[d].destroy();
return h.call(this)};e.attr=function(d,q,a,h){if("object"===typeof d&&p(d.faces)){for(;e.faces.length>d.faces.length;)e.faces.pop().destroy();for(;e.faces.length<d.faces.length;)e.faces.push(b.face3d().add(e));for(var w=0;w<d.faces.length;w++)b.styledMode&&delete d.faces[w].fill,e.faces[w].attr(d.faces[w],null,a,h);delete d.faces}return m.prototype.attr.apply(this,arguments)};e.animate=function(d,q,a){if(d&&d.faces){for(;e.faces.length>d.faces.length;)e.faces.pop().destroy();for(;e.faces.length<d.faces.length;)e.faces.push(b.face3d().add(e));
for(var w=0;w<d.faces.length;w++)e.faces[w].animate(d.faces[w],q,a);delete d.faces}return m.prototype.animate.apply(this,arguments)};return e.attr(a)};h.prototype.element3d=function(a,b){var e=this.g();t(e,this.elements3d[a]);e.initArgs(b);return e};h.prototype.cuboid=function(a){return this.element3d("cuboid",a)};h.prototype.cuboidPath=function(a){function h(e){return 0===w&&1<e&&6>e?{x:I[e].x,y:I[e].y+10,z:I[e].z}:I[0].x===I[7].x&&4<=e?{x:I[e].x+10,y:I[e].y,z:I[e].z}:0===c&&2>e||5<e?{x:I[e].x,y:I[e].y,
z:I[e].z+10}:I[e]}function e(e){return I[e]}var u=a.x||0,d=a.y||0,q=a.z||0,w=a.height||0,A=a.width||0,c=a.depth||0,f=b[this.chartIndex],m=f.options.chart.options3d.alpha,p=0,I=[{x:u,y:d,z:q},{x:u+A,y:d,z:q},{x:u+A,y:d+w,z:q},{x:u,y:d+w,z:q},{x:u,y:d+w,z:q+c},{x:u+A,y:d+w,z:q+c},{x:u+A,y:d,z:q+c},{x:u,y:d,z:q+c}],k=[];I=g(I,f,a.insidePlotArea);var G=function(d,a,q){var w=[[],-1],b=d.map(e),u=a.map(e);d=d.map(h);a=a.map(h);0>B(b)?w=[b,0]:0>B(u)?w=[u,1]:q&&(k.push(q),w=0>B(d)?[b,0]:0>B(a)?[u,1]:[b,0]);
return w};var l=G([3,2,1,0],[7,6,5,4],"front");a=l[0];var t=l[1];l=G([1,6,7,0],[4,5,2,3],"top");A=l[0];var r=l[1];l=G([1,2,5,6],[0,7,4,3],"side");G=l[0];l=l[1];1===l?p+=1E6*(f.plotWidth-u):l||(p+=1E6*u);p+=10*(!r||0<=m&&180>=m||360>m&&357.5<m?f.plotHeight-d:10+d);1===t?p+=100*q:t||(p+=100*(1E3-q));return{front:this.toLinePath(a,!0),top:this.toLinePath(A,!0),side:this.toLinePath(G,!0),zIndexes:{group:Math.round(p)},forcedSides:k,isFront:t,isTop:r}};h.prototype.arc3d=function(a){function b(e){var a=
!1,q={},b;e=v(e);for(b in e)-1!==d.indexOf(b)&&(q[b]=e[b],delete e[b],a=!0);return a?[q,e]:!1}var e=this.g(),h=e.renderer,d="x y r innerR start end depth".split(" ");a=v(a);a.alpha=(a.alpha||0)*l;a.beta=(a.beta||0)*l;e.top=h.path();e.side1=h.path();e.side2=h.path();e.inn=h.path();e.out=h.path();e.onAdd=function(){var d=e.parentGroup,a=e.attr("class");e.top.add(e);["out","inn","side1","side2"].forEach(function(q){e[q].attr({"class":a+" highcharts-3d-side"}).add(d)})};["addClass","removeClass"].forEach(function(d){e[d]=
function(){var a=arguments;["top","out","inn","side1","side2"].forEach(function(q){e[q][d].apply(e[q],a)})}});e.setPaths=function(d){var a=e.renderer.arc3dPath(d),q=100*a.zTop;e.attribs=d;e.top.attr({d:a.top,zIndex:a.zTop});e.inn.attr({d:a.inn,zIndex:a.zInn});e.out.attr({d:a.out,zIndex:a.zOut});e.side1.attr({d:a.side1,zIndex:a.zSide1});e.side2.attr({d:a.side2,zIndex:a.zSide2});e.zIndex=q;e.attr({zIndex:q});d.center&&(e.top.setRadialReference(d.center),delete d.center)};e.setPaths(a);e.fillSetter=
function(e){var d=c(e).brighten(-.1).get();this.fill=e;this.side1.attr({fill:d});this.side2.attr({fill:d});this.inn.attr({fill:d});this.out.attr({fill:d});this.top.attr({fill:e});return this};["opacity","translateX","translateY","visibility"].forEach(function(d){e[d+"Setter"]=function(d,a){e[a]=d;["out","inn","side1","side2","top"].forEach(function(q){e[q].attr(a,d)})}});e.attr=function(d){var a;if("object"===typeof d&&(a=b(d))){var q=a[0];arguments[0]=a[1];t(e.attribs,q);e.setPaths(e.attribs)}return m.prototype.attr.apply(e,
arguments)};e.animate=function(d,a,h){var q=this.attribs,u="data-"+Math.random().toString(26).substring(2,9);delete d.center;delete d.z;delete d.alpha;delete d.beta;var w=k(n(a,this.renderer.globalAnimation));if(w.duration){a=b(d);e[u]=0;d[u]=1;e[u+"Setter"]=y.noop;if(a){var A=a[0];w.step=function(d,e){function a(d){return q[d]+(n(A[d],q[d])-q[d])*e.pos}e.prop===u&&e.elem.setPaths(v(q,{x:a("x"),y:a("y"),r:a("r"),innerR:a("innerR"),start:a("start"),end:a("end"),depth:a("depth")}))}}a=w}return m.prototype.animate.call(this,
d,a,h)};e.destroy=function(){this.top.destroy();this.out.destroy();this.inn.destroy();this.side1.destroy();this.side2.destroy();return m.prototype.destroy.call(this)};e.hide=function(){this.top.hide();this.out.hide();this.inn.hide();this.side1.hide();this.side2.hide()};e.show=function(d){this.top.show(d);this.out.show(d);this.inn.show(d);this.side1.show(d);this.side2.show(d)};return e};h.prototype.arc3dPath=function(a){function b(d){d%=2*Math.PI;d>Math.PI&&(d=2*Math.PI-d);return d}var e=a.x||0,u=
a.y||0,d=a.start||0,q=(a.end||0)-.00001,w=a.r||0,A=a.innerR||0,g=a.depth||0,c=a.alpha||0,f=a.beta||0,m=Math.cos(d),p=Math.sin(d);a=Math.cos(q);var k=Math.sin(q),l=w*Math.cos(f);w*=Math.cos(c);var t=A*Math.cos(f),r=A*Math.cos(c);A=g*Math.sin(f);var n=g*Math.sin(c);g=[["M",e+l*m,u+w*p]];g=g.concat(h.curveTo(e,u,l,w,d,q,0,0));g.push(["L",e+t*a,u+r*k]);g=g.concat(h.curveTo(e,u,t,r,q,d,0,0));g.push(["Z"]);var B=0<f?Math.PI/2:0;f=0<c?0:Math.PI/2;B=d>-B?d:q>-B?-B:d;var G=q<J-f?q:d<J-f?J-f:q,v=2*J-f;c=[["M",
e+l*x(B),u+w*E(B)]];c=c.concat(h.curveTo(e,u,l,w,B,G,0,0));q>v&&d<v?(c.push(["L",e+l*x(G)+A,u+w*E(G)+n]),c=c.concat(h.curveTo(e,u,l,w,G,v,A,n)),c.push(["L",e+l*x(v),u+w*E(v)]),c=c.concat(h.curveTo(e,u,l,w,v,q,0,0)),c.push(["L",e+l*x(q)+A,u+w*E(q)+n]),c=c.concat(h.curveTo(e,u,l,w,q,v,A,n)),c.push(["L",e+l*x(v),u+w*E(v)]),c=c.concat(h.curveTo(e,u,l,w,v,G,0,0))):q>J-f&&d<J-f&&(c.push(["L",e+l*Math.cos(G)+A,u+w*Math.sin(G)+n]),c=c.concat(h.curveTo(e,u,l,w,G,q,A,n)),c.push(["L",e+l*Math.cos(q),u+w*Math.sin(q)]),
c=c.concat(h.curveTo(e,u,l,w,q,G,0,0)));c.push(["L",e+l*Math.cos(G)+A,u+w*Math.sin(G)+n]);c=c.concat(h.curveTo(e,u,l,w,G,B,A,n));c.push(["Z"]);f=[["M",e+t*m,u+r*p]];f=f.concat(h.curveTo(e,u,t,r,d,q,0,0));f.push(["L",e+t*Math.cos(q)+A,u+r*Math.sin(q)+n]);f=f.concat(h.curveTo(e,u,t,r,q,d,A,n));f.push(["Z"]);m=[["M",e+l*m,u+w*p],["L",e+l*m+A,u+w*p+n],["L",e+t*m+A,u+r*p+n],["L",e+t*m,u+r*p],["Z"]];e=[["M",e+l*a,u+w*k],["L",e+l*a+A,u+w*k+n],["L",e+t*a+A,u+r*k+n],["L",e+t*a,u+r*k],["Z"]];k=Math.atan2(n,
-A);u=Math.abs(q+k);a=Math.abs(d+k);d=Math.abs((d+q)/2+k);u=b(u);a=b(a);d=b(d);d*=1E5;q=1E5*a;u*=1E5;return{top:g,zTop:1E5*Math.PI+1,out:c,zOut:Math.max(d,q,u),inn:f,zInn:Math.max(d,q,u),side1:m,zSide1:.99*u,side2:e,zSide2:.99*q}};return h}(r)});F(a,"Core/Chart/Chart3D.js",[a["Core/Color/Color.js"],a["Core/Defaults.js"],a["Core/Math3D.js"],a["Core/Utilities.js"]],function(a,z,y,D){var m=a.parse,x=z.defaultOptions,r=y.perspective,C=y.shapeArea3D,f=D.addEvent,k=D.isArray,c=D.merge,b=D.pick,l=D.wrap,
g;(function(a){function g(a){this.is3d()&&"scatter"===a.options.type&&(a.options.type="scatter3d")}function t(){if(this.chart3d&&this.is3d()){var a=this.renderer,b=this.options.chart.options3d,d=this.chart3d.get3dFrame(),q=this.plotLeft,h=this.plotLeft+this.plotWidth,g=this.plotTop,c=this.plotTop+this.plotHeight;b=b.depth;var f=q-(d.left.visible?d.left.size:0),l=h+(d.right.visible?d.right.size:0),p=g-(d.top.visible?d.top.size:0),k=c+(d.bottom.visible?d.bottom.size:0),t=0-(d.front.visible?d.front.size:
0),n=b+(d.back.visible?d.back.size:0),r=this.hasRendered?"animate":"attr";this.chart3d.frame3d=d;this.frameShapes||(this.frameShapes={bottom:a.polyhedron().add(),top:a.polyhedron().add(),left:a.polyhedron().add(),right:a.polyhedron().add(),back:a.polyhedron().add(),front:a.polyhedron().add()});this.frameShapes.bottom[r]({"class":"highcharts-3d-frame highcharts-3d-frame-bottom",zIndex:d.bottom.frontFacing?-1E3:1E3,faces:[{fill:m(d.bottom.color).brighten(.1).get(),vertexes:[{x:f,y:k,z:t},{x:l,y:k,z:t},
{x:l,y:k,z:n},{x:f,y:k,z:n}],enabled:d.bottom.visible},{fill:m(d.bottom.color).brighten(.1).get(),vertexes:[{x:q,y:c,z:b},{x:h,y:c,z:b},{x:h,y:c,z:0},{x:q,y:c,z:0}],enabled:d.bottom.visible},{fill:m(d.bottom.color).brighten(-.1).get(),vertexes:[{x:f,y:k,z:t},{x:f,y:k,z:n},{x:q,y:c,z:b},{x:q,y:c,z:0}],enabled:d.bottom.visible&&!d.left.visible},{fill:m(d.bottom.color).brighten(-.1).get(),vertexes:[{x:l,y:k,z:n},{x:l,y:k,z:t},{x:h,y:c,z:0},{x:h,y:c,z:b}],enabled:d.bottom.visible&&!d.right.visible},{fill:m(d.bottom.color).get(),
vertexes:[{x:l,y:k,z:t},{x:f,y:k,z:t},{x:q,y:c,z:0},{x:h,y:c,z:0}],enabled:d.bottom.visible&&!d.front.visible},{fill:m(d.bottom.color).get(),vertexes:[{x:f,y:k,z:n},{x:l,y:k,z:n},{x:h,y:c,z:b},{x:q,y:c,z:b}],enabled:d.bottom.visible&&!d.back.visible}]});this.frameShapes.top[r]({"class":"highcharts-3d-frame highcharts-3d-frame-top",zIndex:d.top.frontFacing?-1E3:1E3,faces:[{fill:m(d.top.color).brighten(.1).get(),vertexes:[{x:f,y:p,z:n},{x:l,y:p,z:n},{x:l,y:p,z:t},{x:f,y:p,z:t}],enabled:d.top.visible},
{fill:m(d.top.color).brighten(.1).get(),vertexes:[{x:q,y:g,z:0},{x:h,y:g,z:0},{x:h,y:g,z:b},{x:q,y:g,z:b}],enabled:d.top.visible},{fill:m(d.top.color).brighten(-.1).get(),vertexes:[{x:f,y:p,z:n},{x:f,y:p,z:t},{x:q,y:g,z:0},{x:q,y:g,z:b}],enabled:d.top.visible&&!d.left.visible},{fill:m(d.top.color).brighten(-.1).get(),vertexes:[{x:l,y:p,z:t},{x:l,y:p,z:n},{x:h,y:g,z:b},{x:h,y:g,z:0}],enabled:d.top.visible&&!d.right.visible},{fill:m(d.top.color).get(),vertexes:[{x:f,y:p,z:t},{x:l,y:p,z:t},{x:h,y:g,
z:0},{x:q,y:g,z:0}],enabled:d.top.visible&&!d.front.visible},{fill:m(d.top.color).get(),vertexes:[{x:l,y:p,z:n},{x:f,y:p,z:n},{x:q,y:g,z:b},{x:h,y:g,z:b}],enabled:d.top.visible&&!d.back.visible}]});this.frameShapes.left[r]({"class":"highcharts-3d-frame highcharts-3d-frame-left",zIndex:d.left.frontFacing?-1E3:1E3,faces:[{fill:m(d.left.color).brighten(.1).get(),vertexes:[{x:f,y:k,z:t},{x:q,y:c,z:0},{x:q,y:c,z:b},{x:f,y:k,z:n}],enabled:d.left.visible&&!d.bottom.visible},{fill:m(d.left.color).brighten(.1).get(),
vertexes:[{x:f,y:p,z:n},{x:q,y:g,z:b},{x:q,y:g,z:0},{x:f,y:p,z:t}],enabled:d.left.visible&&!d.top.visible},{fill:m(d.left.color).brighten(-.1).get(),vertexes:[{x:f,y:k,z:n},{x:f,y:p,z:n},{x:f,y:p,z:t},{x:f,y:k,z:t}],enabled:d.left.visible},{fill:m(d.left.color).brighten(-.1).get(),vertexes:[{x:q,y:g,z:b},{x:q,y:c,z:b},{x:q,y:c,z:0},{x:q,y:g,z:0}],enabled:d.left.visible},{fill:m(d.left.color).get(),vertexes:[{x:f,y:k,z:t},{x:f,y:p,z:t},{x:q,y:g,z:0},{x:q,y:c,z:0}],enabled:d.left.visible&&!d.front.visible},
{fill:m(d.left.color).get(),vertexes:[{x:f,y:p,z:n},{x:f,y:k,z:n},{x:q,y:c,z:b},{x:q,y:g,z:b}],enabled:d.left.visible&&!d.back.visible}]});this.frameShapes.right[r]({"class":"highcharts-3d-frame highcharts-3d-frame-right",zIndex:d.right.frontFacing?-1E3:1E3,faces:[{fill:m(d.right.color).brighten(.1).get(),vertexes:[{x:l,y:k,z:n},{x:h,y:c,z:b},{x:h,y:c,z:0},{x:l,y:k,z:t}],enabled:d.right.visible&&!d.bottom.visible},{fill:m(d.right.color).brighten(.1).get(),vertexes:[{x:l,y:p,z:t},{x:h,y:g,z:0},{x:h,
y:g,z:b},{x:l,y:p,z:n}],enabled:d.right.visible&&!d.top.visible},{fill:m(d.right.color).brighten(-.1).get(),vertexes:[{x:h,y:g,z:0},{x:h,y:c,z:0},{x:h,y:c,z:b},{x:h,y:g,z:b}],enabled:d.right.visible},{fill:m(d.right.color).brighten(-.1).get(),vertexes:[{x:l,y:k,z:t},{x:l,y:p,z:t},{x:l,y:p,z:n},{x:l,y:k,z:n}],enabled:d.right.visible},{fill:m(d.right.color).get(),vertexes:[{x:l,y:p,z:t},{x:l,y:k,z:t},{x:h,y:c,z:0},{x:h,y:g,z:0}],enabled:d.right.visible&&!d.front.visible},{fill:m(d.right.color).get(),
vertexes:[{x:l,y:k,z:n},{x:l,y:p,z:n},{x:h,y:g,z:b},{x:h,y:c,z:b}],enabled:d.right.visible&&!d.back.visible}]});this.frameShapes.back[r]({"class":"highcharts-3d-frame highcharts-3d-frame-back",zIndex:d.back.frontFacing?-1E3:1E3,faces:[{fill:m(d.back.color).brighten(.1).get(),vertexes:[{x:l,y:k,z:n},{x:f,y:k,z:n},{x:q,y:c,z:b},{x:h,y:c,z:b}],enabled:d.back.visible&&!d.bottom.visible},{fill:m(d.back.color).brighten(.1).get(),vertexes:[{x:f,y:p,z:n},{x:l,y:p,z:n},{x:h,y:g,z:b},{x:q,y:g,z:b}],enabled:d.back.visible&&
!d.top.visible},{fill:m(d.back.color).brighten(-.1).get(),vertexes:[{x:f,y:k,z:n},{x:f,y:p,z:n},{x:q,y:g,z:b},{x:q,y:c,z:b}],enabled:d.back.visible&&!d.left.visible},{fill:m(d.back.color).brighten(-.1).get(),vertexes:[{x:l,y:p,z:n},{x:l,y:k,z:n},{x:h,y:c,z:b},{x:h,y:g,z:b}],enabled:d.back.visible&&!d.right.visible},{fill:m(d.back.color).get(),vertexes:[{x:q,y:g,z:b},{x:h,y:g,z:b},{x:h,y:c,z:b},{x:q,y:c,z:b}],enabled:d.back.visible},{fill:m(d.back.color).get(),vertexes:[{x:f,y:k,z:n},{x:l,y:k,z:n},
{x:l,y:p,z:n},{x:f,y:p,z:n}],enabled:d.back.visible}]});this.frameShapes.front[r]({"class":"highcharts-3d-frame highcharts-3d-frame-front",zIndex:d.front.frontFacing?-1E3:1E3,faces:[{fill:m(d.front.color).brighten(.1).get(),vertexes:[{x:f,y:k,z:t},{x:l,y:k,z:t},{x:h,y:c,z:0},{x:q,y:c,z:0}],enabled:d.front.visible&&!d.bottom.visible},{fill:m(d.front.color).brighten(.1).get(),vertexes:[{x:l,y:p,z:t},{x:f,y:p,z:t},{x:q,y:g,z:0},{x:h,y:g,z:0}],enabled:d.front.visible&&!d.top.visible},{fill:m(d.front.color).brighten(-.1).get(),
vertexes:[{x:f,y:p,z:t},{x:f,y:k,z:t},{x:q,y:c,z:0},{x:q,y:g,z:0}],enabled:d.front.visible&&!d.left.visible},{fill:m(d.front.color).brighten(-.1).get(),vertexes:[{x:l,y:k,z:t},{x:l,y:p,z:t},{x:h,y:g,z:0},{x:h,y:c,z:0}],enabled:d.front.visible&&!d.right.visible},{fill:m(d.front.color).get(),vertexes:[{x:h,y:g,z:0},{x:q,y:g,z:0},{x:q,y:c,z:0},{x:h,y:c,z:0}],enabled:d.front.visible},{fill:m(d.front.color).get(),vertexes:[{x:l,y:k,z:t},{x:f,y:k,z:t},{x:f,y:p,z:t},{x:l,y:p,z:t}],enabled:d.front.visible}]})}}
function v(){this.styledMode&&[{name:"darker",slope:.6},{name:"brighter",slope:1.4}].forEach(function(a){this.renderer.definition({tagName:"filter",attributes:{id:"highcharts-"+a.name},children:[{tagName:"feComponentTransfer",children:[{tagName:"feFuncR",attributes:{type:"linear",slope:a.slope}},{tagName:"feFuncG",attributes:{type:"linear",slope:a.slope}},{tagName:"feFuncB",attributes:{type:"linear",slope:a.slope}}]}]})},this)}function n(){var a=this.options;this.is3d()&&(a.series||[]).forEach(function(e){"scatter"===
(e.type||a.chart.type||a.chart.defaultSeriesType)&&(e.type="scatter3d")})}function B(){var a=this.options.chart.options3d;if(this.chart3d&&this.is3d()){a&&(a.alpha=a.alpha%360+(0<=a.alpha?0:360),a.beta=a.beta%360+(0<=a.beta?0:360));var b=this.inverted,d=this.clipBox,h=this.margin;d[b?"y":"x"]=-(h[3]||0);d[b?"x":"y"]=-(h[0]||0);d[b?"height":"width"]=this.chartWidth+(h[3]||0)+(h[1]||0);d[b?"width":"height"]=this.chartHeight+(h[0]||0)+(h[2]||0);this.scale3d=1;!0===a.fitToPlot&&(this.scale3d=this.chart3d.getScale(a.depth));
this.chart3d.frame3d=this.chart3d.get3dFrame()}}function E(){this.is3d()&&(this.isDirtyBox=!0)}function y(){this.chart3d&&this.is3d()&&(this.chart3d.frame3d=this.chart3d.get3dFrame())}function z(){this.chart3d||(this.chart3d=new M(this))}function N(a){return this.is3d()||a.apply(this,[].slice.call(arguments,1))}function h(a){var e=this.series.length;if(this.is3d())for(;e--;)a=this.series[e],a.translate(),a.render();else a.call(this)}function G(a){a.apply(this,[].slice.call(arguments,1));this.is3d()&&
(this.container.className+=" highcharts-3d-chart")}var M=function(){function a(a){this.frame3d=void 0;this.chart=a}a.prototype.get3dFrame=function(){var a=this.chart,d=a.options.chart.options3d,e=d.frame,h=a.plotLeft,g=a.plotLeft+a.plotWidth,c=a.plotTop,f=a.plotTop+a.plotHeight,l=d.depth,p=function(d){d=C(d,a);return.5<d?1:-.5>d?-1:0},k=p([{x:h,y:f,z:l},{x:g,y:f,z:l},{x:g,y:f,z:0},{x:h,y:f,z:0}]),t=p([{x:h,y:c,z:0},{x:g,y:c,z:0},{x:g,y:c,z:l},{x:h,y:c,z:l}]),m=p([{x:h,y:c,z:0},{x:h,y:c,z:l},{x:h,
y:f,z:l},{x:h,y:f,z:0}]),n=p([{x:g,y:c,z:l},{x:g,y:c,z:0},{x:g,y:f,z:0},{x:g,y:f,z:l}]),G=p([{x:h,y:f,z:0},{x:g,y:f,z:0},{x:g,y:c,z:0},{x:h,y:c,z:0}]);p=p([{x:h,y:c,z:l},{x:g,y:c,z:l},{x:g,y:f,z:l},{x:h,y:f,z:l}]);var M=!1,B=!1,v=!1,E=!1;[].concat(a.xAxis,a.yAxis,a.zAxis).forEach(function(a){a&&(a.horiz?a.opposite?B=!0:M=!0:a.opposite?E=!0:v=!0)});var x=function(a,d,e){for(var h=["size","color","visible"],g={},c=0;c<h.length;c++)for(var f=h[c],l=0;l<a.length;l++)if("object"===typeof a[l]){var p=a[l][f];
if("undefined"!==typeof p&&null!==p){g[f]=p;break}}a=e;!0===g.visible||!1===g.visible?a=g.visible:"auto"===g.visible&&(a=0<d);return{size:b(g.size,1),color:b(g.color,"none"),frontFacing:0<d,visible:a}};e={axes:{},bottom:x([e.bottom,e.top,e],k,M),top:x([e.top,e.bottom,e],t,B),left:x([e.left,e.right,e.side,e],m,v),right:x([e.right,e.left,e.side,e],n,E),back:x([e.back,e.front,e],p,!0),front:x([e.front,e.back,e],G,!1)};"auto"===d.axisLabelPosition?(n=function(a,d){return a.visible!==d.visible||a.visible&&
d.visible&&a.frontFacing!==d.frontFacing},d=[],n(e.left,e.front)&&d.push({y:(c+f)/2,x:h,z:0,xDir:{x:1,y:0,z:0}}),n(e.left,e.back)&&d.push({y:(c+f)/2,x:h,z:l,xDir:{x:0,y:0,z:-1}}),n(e.right,e.front)&&d.push({y:(c+f)/2,x:g,z:0,xDir:{x:0,y:0,z:1}}),n(e.right,e.back)&&d.push({y:(c+f)/2,x:g,z:l,xDir:{x:-1,y:0,z:0}}),k=[],n(e.bottom,e.front)&&k.push({x:(h+g)/2,y:f,z:0,xDir:{x:1,y:0,z:0}}),n(e.bottom,e.back)&&k.push({x:(h+g)/2,y:f,z:l,xDir:{x:-1,y:0,z:0}}),t=[],n(e.top,e.front)&&t.push({x:(h+g)/2,y:c,z:0,
xDir:{x:1,y:0,z:0}}),n(e.top,e.back)&&t.push({x:(h+g)/2,y:c,z:l,xDir:{x:-1,y:0,z:0}}),m=[],n(e.bottom,e.left)&&m.push({z:(0+l)/2,y:f,x:h,xDir:{x:0,y:0,z:-1}}),n(e.bottom,e.right)&&m.push({z:(0+l)/2,y:f,x:g,xDir:{x:0,y:0,z:1}}),f=[],n(e.top,e.left)&&f.push({z:(0+l)/2,y:c,x:h,xDir:{x:0,y:0,z:-1}}),n(e.top,e.right)&&f.push({z:(0+l)/2,y:c,x:g,xDir:{x:0,y:0,z:1}}),h=function(d,e,h){if(0===d.length)return null;if(1===d.length)return d[0];for(var b=r(d,a,!1),g=0,c=1;c<b.length;c++)h*b[c][e]>h*b[g][e]?g=
c:h*b[c][e]===h*b[g][e]&&b[c].z<b[g].z&&(g=c);return d[g]},e.axes={y:{left:h(d,"x",-1),right:h(d,"x",1)},x:{top:h(t,"y",-1),bottom:h(k,"y",1)},z:{top:h(f,"y",-1),bottom:h(m,"y",1)}}):e.axes={y:{left:{x:h,z:0,xDir:{x:1,y:0,z:0}},right:{x:g,z:0,xDir:{x:0,y:0,z:1}}},x:{top:{y:c,z:0,xDir:{x:1,y:0,z:0}},bottom:{y:f,z:0,xDir:{x:1,y:0,z:0}}},z:{top:{x:v?g:h,y:c,xDir:v?{x:0,y:0,z:1}:{x:0,y:0,z:-1}},bottom:{x:v?g:h,y:f,xDir:v?{x:0,y:0,z:1}:{x:0,y:0,z:-1}}}};return e};a.prototype.getScale=function(a){var d=
this.chart,e=d.plotLeft,h=d.plotWidth+e,b=d.plotTop,g=d.plotHeight+b,c=e+d.plotWidth/2,f=b+d.plotHeight/2,l=Number.MAX_VALUE,p=-Number.MAX_VALUE,k=Number.MAX_VALUE,t=-Number.MAX_VALUE,n=1;var m=[{x:e,y:b,z:0},{x:e,y:b,z:a}];[0,1].forEach(function(a){m.push({x:h,y:m[a].y,z:m[a].z})});[0,1,2,3].forEach(function(a){m.push({x:m[a].x,y:g,z:m[a].z})});m=r(m,d,!1);m.forEach(function(a){l=Math.min(l,a.x);p=Math.max(p,a.x);k=Math.min(k,a.y);t=Math.max(t,a.y)});e>l&&(n=Math.min(n,1-Math.abs((e+c)/(l+c))%1));
h<p&&(n=Math.min(n,(h-c)/(p-c)));b>k&&(n=0>k?Math.min(n,(b+f)/(-k+b+f)):Math.min(n,1-(b+f)/(k+f)%1));g<t&&(n=Math.min(n,Math.abs((g-f)/(t-f))));return n};return a}();a.Composition=M;a.defaultOptions={chart:{options3d:{enabled:!1,alpha:0,beta:0,depth:100,fitToPlot:!0,viewDistance:25,axisLabelPosition:null,frame:{visible:"default",size:1,bottom:{},top:{},left:{},right:{},back:{},front:{}}}}};a.compose=function(e,b){var d=e.prototype;b=b.prototype;d.is3d=function(){return!(!this.options.chart.options3d||
!this.options.chart.options3d.enabled)};d.propsRequireDirtyBox.push("chart.options3d");d.propsRequireUpdateSeries.push("chart.options3d");b.matrixSetter=function(){if(1>this.pos&&(k(this.start)||k(this.end))){var a=this.start||[1,0,0,1,0,0],d=this.end||[1,0,0,1,0,0];var e=[];for(var h=0;6>h;h++)e.push(this.pos*d[h]+(1-this.pos)*a[h])}else e=this.end;this.elem.attr(this.prop,e,null,!0)};c(!0,x,a.defaultOptions);f(e,"init",z);f(e,"addSeries",g);f(e,"afterDrawChartBox",t);f(e,"afterGetContainer",v);
f(e,"afterInit",n);f(e,"afterSetChartSize",B);f(e,"beforeRedraw",E);f(e,"beforeRender",y);l(d,"isInsidePlot",N);l(d,"renderSeries",h);l(d,"setClassName",G)}})(g||(g={}));"";return g});F(a,"Core/Axis/ZAxis.js",[a["Core/Axis/Axis.js"],a["Core/Utilities.js"]],function(a,z){function x(a){return new c(this,a)}function D(){var a=this,c=this.options.zAxis=f(this.options.zAxis||{});this.is3d()&&(this.zAxis=[],c.forEach(function(b,c){b.index=c;b.isX=!0;a.addZAxis(b).setScale()}))}var m=this&&this.__extends||
function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function g(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(g.prototype=c.prototype,new g)}}(),H=z.addEvent,r=z.merge,C=z.pick,f=z.splat,k=[],c=function(a){function b(b,c){b=a.call(this,b,c)||this;b.isZAxis=!0;return b}m(b,a);b.compose=function(a){-1===k.indexOf(a)&&
(k.push(a),H(a,"afterGetAxes",D),a=a.prototype,a.addZAxis=x,a.collectionsWithInit.zAxis=[a.addZAxis],a.collectionsWithUpdate.push("zAxis"))};b.prototype.getSeriesExtremes=function(){var a=this,b=this.chart;this.hasVisibleSeries=!1;this.dataMin=this.dataMax=this.ignoreMinPadding=this.ignoreMaxPadding=void 0;this.stacking&&this.stacking.buildStacks();this.series.forEach(function(c){if(c.visible||!b.options.chart.ignoreHiddenSeries)a.hasVisibleSeries=!0,c=c.zData,c.length&&(a.dataMin=Math.min(C(a.dataMin,
c[0]),Math.min.apply(null,c)),a.dataMax=Math.max(C(a.dataMax,c[0]),Math.max.apply(null,c)))})};b.prototype.setAxisSize=function(){var b=this.chart;a.prototype.setAxisSize.call(this);this.width=this.len=b.options.chart.options3d&&b.options.chart.options3d.depth||0;this.right=b.chartWidth-this.width-this.left};b.prototype.setOptions=function(b){b=r({offset:0,lineWidth:0},b);this.isZAxis=!0;a.prototype.setOptions.call(this,b);this.coll="zAxis"};return b}(a);return c});F(a,"Core/Axis/Axis3DDefaults.js",
[],function(){return{labels:{position3d:"offset",skew3d:!1},title:{position3d:null,skew3d:null}}});F(a,"Core/Axis/Tick3DComposition.js",[a["Core/Utilities.js"]],function(a){function x(a){var f=this.axis.axis3D;f&&m(a.pos,f.fix3dPosition(a.pos))}function y(a){var f=this.axis.axis3D,k=a.apply(this,[].slice.call(arguments,1));if(f){var c=k[0],b=k[1];if("M"===c[0]&&"L"===b[0])return f=[f.fix3dPosition({x:c[1],y:c[2],z:0}),f.fix3dPosition({x:b[1],y:b[2],z:0})],this.axis.chart.renderer.toLineSegments(f)}return k}
var D=a.addEvent,m=a.extend,H=a.wrap,r=[];return{compose:function(a){-1===r.indexOf(a)&&(r.push(a),D(a,"afterGetLabelPosition",x),H(a.prototype,"getMarkPath",y))}}});F(a,"Core/Axis/Axis3DComposition.js",[a["Core/Axis/Axis3DDefaults.js"],a["Core/Globals.js"],a["Core/Math3D.js"],a["Core/Axis/Tick3DComposition.js"],a["Core/Utilities.js"]],function(a,z,y,D,m){function x(){var a=this.chart,b=this.options;a.is3d&&a.is3d()&&"colorAxis"!==this.coll&&(b.tickWidth=L(b.tickWidth,0),b.gridLineWidth=L(b.gridLineWidth,
1))}function r(a){this.chart.is3d()&&"colorAxis"!==this.coll&&a.point&&(a.point.crosshairPos=this.isXAxis?a.point.axisXpos:this.len-a.point.axisYpos)}function C(){this.axis3D||(this.axis3D=new K(this))}function f(a){return this.chart.is3d()&&"colorAxis"!==this.coll?[]:a.apply(this,[].slice.call(arguments,1))}function k(a){if(!this.chart.is3d()||"colorAxis"===this.coll)return a.apply(this,[].slice.call(arguments,1));var b=arguments,c=b[2],f=[];b=this.getPlotLinePath({value:b[1]});c=this.getPlotLinePath({value:c});
if(b&&c)for(var e=0;e<b.length;e+=2){var g=b[e],d=b[e+1],l=c[e],k=c[e+1];"M"===g[0]&&"L"===d[0]&&"M"===l[0]&&"L"===k[0]&&f.push(g,d,k,["L",l[1],l[2]],["Z"])}return f}function c(a){var b=this.axis3D,c=this.chart,f=a.apply(this,[].slice.call(arguments,1));if("colorAxis"===this.coll||!c.chart3d||!c.is3d()||null===f)return f;var e=c.options.chart.options3d,g=this.isZAxis?c.plotWidth:e.depth;e=c.chart3d.frame3d;var d=f[0],l=f[1];f=[];"M"===d[0]&&"L"===l[0]&&(b=[b.swapZ({x:d[1],y:d[2],z:0}),b.swapZ({x:d[1],
y:d[2],z:g}),b.swapZ({x:l[1],y:l[2],z:0}),b.swapZ({x:l[1],y:l[2],z:g})],this.horiz?(this.isZAxis?(e.left.visible&&f.push(b[0],b[2]),e.right.visible&&f.push(b[1],b[3])):(e.front.visible&&f.push(b[0],b[2]),e.back.visible&&f.push(b[1],b[3])),e.top.visible&&f.push(b[0],b[1]),e.bottom.visible&&f.push(b[2],b[3])):(e.front.visible&&f.push(b[0],b[2]),e.back.visible&&f.push(b[1],b[3]),e.left.visible&&f.push(b[0],b[1]),e.right.visible&&f.push(b[2],b[3])),f=B(f,this.chart,!1));return c.renderer.toLineSegments(f)}
function b(a,b){var c=this.chart,h=this.ticks,e=this.gridGroup;if(this.categories&&c.frameShapes&&c.is3d()&&e&&b&&b.label){e=e.element.childNodes[0].getBBox();var f=c.frameShapes.left.getBBox(),d=c.options.chart.options3d;c={x:c.plotWidth/2,y:c.plotHeight/2,z:d.depth/2,vd:L(d.depth,1)*L(d.viewDistance,0)};d=b.pos;var g=h[d-1],l=h[d+1],k=h=void 0;0!==d&&g&&g.label&&g.label.xy&&(h=p({x:g.label.xy.x,y:g.label.xy.y,z:null},c,c.vd));l&&l.label&&l.label.xy&&(k=p({x:l.label.xy.x,y:l.label.xy.y,z:null},c,
c.vd));d={x:b.label.xy.x,y:b.label.xy.y,z:null};d=p(d,c,c.vd);return Math.abs(h?d.x-h.x:k?k.x-d.x:e.x-f.x)}return a.apply(this,[].slice.call(arguments,1))}function l(a){var b=a.apply(this,[].slice.call(arguments,1));return this.axis3D?this.axis3D.fix3dPosition(b,!0):b}var g=z.deg2rad,B=y.perspective,p=y.perspective3D,t=y.shapeArea,v=m.addEvent,n=m.merge,L=m.pick,E=m.wrap,J=[],K=function(){function p(a){this.axis=a}p.compose=function(h,g){D.compose(g);-1===J.indexOf(h)&&(J.push(h),n(!0,h.defaultOptions,
a),h.keepProps.push("axis3D"),v(h,"init",C),v(h,"afterSetOptions",x),v(h,"drawCrosshair",r),h=h.prototype,E(h,"getLinePath",f),E(h,"getPlotBandPath",k),E(h,"getPlotLinePath",c),E(h,"getSlotWidth",b),E(h,"getTitlePosition",l))};p.prototype.fix3dPosition=function(a,b){var c=this.axis,e=c.chart;if("colorAxis"===c.coll||!e.chart3d||!e.is3d())return a;var f=g*e.options.chart.options3d.alpha,d=g*e.options.chart.options3d.beta,h=L(b&&c.options.title.position3d,c.options.labels.position3d);b=L(b&&c.options.title.skew3d,
c.options.labels.skew3d);var l=e.chart3d.frame3d,k=e.plotLeft,p=e.plotWidth+k,n=e.plotTop,m=e.plotHeight+n,r=e=0,v={x:0,y:1,z:0},E=!1;a=c.axis3D.swapZ({x:a.x,y:a.y,z:0});if(c.isZAxis)if(c.opposite){if(null===l.axes.z.top)return{};r=a.y-n;a.x=l.axes.z.top.x;a.y=l.axes.z.top.y;k=l.axes.z.top.xDir;E=!l.top.frontFacing}else{if(null===l.axes.z.bottom)return{};r=a.y-m;a.x=l.axes.z.bottom.x;a.y=l.axes.z.bottom.y;k=l.axes.z.bottom.xDir;E=!l.bottom.frontFacing}else if(c.horiz)if(c.opposite){if(null===l.axes.x.top)return{};
r=a.y-n;a.y=l.axes.x.top.y;a.z=l.axes.x.top.z;k=l.axes.x.top.xDir;E=!l.top.frontFacing}else{if(null===l.axes.x.bottom)return{};r=a.y-m;a.y=l.axes.x.bottom.y;a.z=l.axes.x.bottom.z;k=l.axes.x.bottom.xDir;E=!l.bottom.frontFacing}else if(c.opposite){if(null===l.axes.y.right)return{};e=a.x-p;a.x=l.axes.y.right.x;a.z=l.axes.y.right.z;k=l.axes.y.right.xDir;k={x:k.z,y:k.y,z:-k.x}}else{if(null===l.axes.y.left)return{};e=a.x-k;a.x=l.axes.y.left.x;a.z=l.axes.y.left.z;k=l.axes.y.left.xDir}"chart"!==h&&("flap"===
h?c.horiz?(d=Math.sin(f),f=Math.cos(f),c.opposite&&(d=-d),E&&(d=-d),v={x:k.z*d,y:f,z:-k.x*d}):k={x:Math.cos(d),y:0,z:Math.sin(d)}:"ortho"===h?c.horiz?(v=Math.cos(f),h=Math.sin(d)*v,f=-Math.sin(f),d=-v*Math.cos(d),v={x:k.y*d-k.z*f,y:k.z*h-k.x*d,z:k.x*f-k.y*h},f=1/Math.sqrt(v.x*v.x+v.y*v.y+v.z*v.z),E&&(f=-f),v={x:f*v.x,y:f*v.y,z:f*v.z}):k={x:Math.cos(d),y:0,z:Math.sin(d)}:c.horiz?v={x:Math.sin(d)*Math.sin(f),y:Math.cos(f),z:-Math.cos(d)*Math.sin(f)}:k={x:Math.cos(d),y:0,z:Math.sin(d)});a.x+=e*k.x+r*
v.x;a.y+=e*k.y+r*v.y;a.z+=e*k.z+r*v.z;e=B([a],c.chart)[0];b&&(0>t(B([a,{x:a.x+k.x,y:a.y+k.y,z:a.z+k.z},{x:a.x+v.x,y:a.y+v.y,z:a.z+v.z}],c.chart))&&(k={x:-k.x,y:-k.y,z:-k.z}),a=B([{x:a.x,y:a.y,z:a.z},{x:a.x+k.x,y:a.y+k.y,z:a.z+k.z},{x:a.x+v.x,y:a.y+v.y,z:a.z+v.z}],c.chart),e.matrix=[a[1].x-a[0].x,a[1].y-a[0].y,a[2].x-a[0].x,a[2].y-a[0].y,e.x,e.y],e.matrix[4]-=e.x*e.matrix[0]+e.y*e.matrix[2],e.matrix[5]-=e.x*e.matrix[1]+e.y*e.matrix[3]);return e};p.prototype.swapZ=function(a,b){var c=this.axis;return c.isZAxis?
(b=b?0:c.chart.plotLeft,{x:b+a.z,y:a.y,z:a.x-b}):a};return p}();return K});F(a,"Core/Series/Series3D.js",[a["Core/Math3D.js"],a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,z,y){var x=this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(c,b)};return function(c,b){function f(){this.constructor=c}a(c,b);c.prototype=null===b?Object.create(b):
(f.prototype=b.prototype,new f)}}(),m=a.perspective;a=y.addEvent;var H=y.extend,r=y.merge,C=y.pick,f=y.isNumber;y=function(a){function c(){return null!==a&&a.apply(this,arguments)||this}x(c,a);c.prototype.translate=function(){a.prototype.translate.apply(this,arguments);this.chart.is3d()&&this.translate3dPoints()};c.prototype.translate3dPoints=function(){var a=this.options,c=this.chart,g=C(this.zAxis,c.options.zAxis[0]),k=[],p,t=[];this.zPadding=(a.stacking?f(a.stack)?a.stack:0:this.index||0)*(a.depth||
0+(a.groupZPadding||1));for(p=0;p<this.data.length;p++){a=this.data[p];if(g&&g.translate){var v=g.logarithmic&&g.val2lin?g.val2lin(a.z):a.z;a.plotZ=g.translate(v);a.isInside=a.isInside?v>=g.min&&v<=g.max:!1}else a.plotZ=this.zPadding;a.axisXpos=a.plotX;a.axisYpos=a.plotY;a.axisZpos=a.plotZ;k.push({x:a.plotX,y:a.plotY,z:a.plotZ});t.push(a.plotX||0)}this.rawPointsX=t;c=m(k,c,!0);for(p=0;p<this.data.length;p++)a=this.data[p],g=c[p],a.plotX=g.x,a.plotY=g.y,a.plotZ=g.z};c.defaultOptions=r(z.defaultOptions);
return c}(z);a(z,"afterTranslate",function(){this.chart.is3d()&&this.translate3dPoints()});H(z.prototype,{translate3dPoints:y.prototype.translate3dPoints});return y});F(a,"Series/Area3D/Area3DSeries.js",[a["Core/Math3D.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,z,y){function x(a){var f=a.apply(this,[].slice.call(arguments,1));if(!this.chart.is3d())return f;var c=H.getGraphPath,b=this.options,l=Math.round(this.yAxis.getThreshold(b.threshold)),g=[];if(this.rawPointsX)for(var r=
0;r<this.points.length;r++)g.push({x:this.rawPointsX[r],y:b.stacking?this.points[r].yBottom:l,z:this.zPadding});b=this.chart.options.chart.options3d;g=m(g,this.chart,!0).map(function(a){return{plotX:a.x,plotY:a.y,plotZ:a.z}});this.group&&b&&b.depth&&b.beta&&(this.markerGroup&&(this.markerGroup.add(this.group),this.markerGroup.attr({translateX:0,translateY:0})),this.group.attr({zIndex:Math.max(1,270<b.beta||90>b.beta?b.depth-Math.round(this.zPadding||0):Math.round(this.zPadding||0))}));g.reversed=
!0;c=c.call(this,g,!0,!0);c[0]&&"M"===c[0][0]&&(c[0]=["L",c[0][1],c[0][2]]);this.areaPath&&(c=this.areaPath.splice(0,this.areaPath.length/2).concat(c),c.xMap=this.areaPath.xMap,this.areaPath=c);return f}var m=a.perspective,H=z.seriesTypes.line.prototype,r=y.wrap,C=[];return{compose:function(a){-1===C.indexOf(a)&&(C.push(a),r(a.prototype,"getGraphPath",x))}}});F(a,"Series/Column3D/Column3DComposition.js",[a["Series/Column/ColumnSeries.js"],a["Core/Globals.js"],a["Core/Series/Series.js"],a["Core/Math3D.js"],
a["Core/Series/SeriesRegistry.js"],a["Core/Axis/Stacking/StackItem.js"],a["Core/Utilities.js"]],function(a,z,y,D,m,H,r){function x(a,b){var c=a.series,f={totalStacks:0},g,l=1;c.forEach(function(a){g=B(a.options.stack,b?0:c.length-1-a.index);f[g]?f[g].series.push(a):(f[g]={series:[a],position:l},l++)});f.totalStacks=l+1;return f}function f(a){var b=a.apply(this,[].slice.call(arguments,1));this.chart.is3d&&this.chart.is3d()&&(b.stroke=this.options.edgeColor||b.fill,b["stroke-width"]=B(this.options.edgeWidth,
1));return b}function k(a,b,c){var f=this.chart.is3d&&this.chart.is3d();f&&(this.options.inactiveOtherPoints=!0);a.call(this,b,c);f&&(this.options.inactiveOtherPoints=!1)}function c(a){for(var b=[],c=1;c<arguments.length;c++)b[c-1]=arguments[c];return this.series.chart.is3d()?this.graphic&&"g"!==this.graphic.element.nodeName:a.apply(this,b)}var b=a.prototype,l=z.svg,g=D.perspective;z=r.addEvent;var B=r.pick;r=r.wrap;r(b,"translate",function(a){a.apply(this,[].slice.call(arguments,1));this.chart.is3d()&&
this.translate3dShapes()});r(y.prototype,"justifyDataLabel",function(a){return arguments[2].outside3dPlot?!1:a.apply(this,[].slice.call(arguments,1))});b.translate3dPoints=function(){};b.translate3dShapes=function(){var a=this,b=a.chart,c=a.options,f=c.depth,l=(c.stacking?c.stack||0:a.index)*(f+(c.groupZPadding||1)),k=a.borderWidth%2?.5:0,m;b.inverted&&!a.yAxis.reversed&&(k*=-1);!1!==c.grouping&&(l=0);l+=c.groupZPadding||1;a.data.forEach(function(c){c.outside3dPlot=null;if(null!==c.y){var n=c.shapeArgs,
h=c.tooltipPos,p;[["x","width"],["y","height"]].forEach(function(b){p=n[b[0]]-k;0>p&&(n[b[1]]+=n[b[0]]+k,n[b[0]]=-k,p=0);p+n[b[1]]>a[b[0]+"Axis"].len&&0!==n[b[1]]&&(n[b[1]]=a[b[0]+"Axis"].len-n[b[0]]);if(0!==n[b[1]]&&(n[b[0]]>=a[b[0]+"Axis"].len||n[b[0]]+n[b[1]]<=k)){for(var e in n)n[e]="y"===e?-9999:0;c.outside3dPlot=!0}});"rect"===c.shapeType&&(c.shapeType="cuboid");n.z=l;n.depth=f;n.insidePlotArea=!0;m={x:n.x+n.width/2,y:n.y,z:l+f/2};b.inverted&&(m.x=n.height,m.y=c.clientX);c.plot3d=g([m],b,!0,
!1)[0];h=g([{x:h[0],y:h[1],z:l+f/2}],b,!0,!1)[0];c.tooltipPos=[h.x,h.y]}});a.z=l};r(b,"animate",function(a){if(this.chart.is3d()){var b=arguments[1],c=this.yAxis,f=this,g=this.yAxis.reversed;l&&(b?f.data.forEach(function(a){null!==a.y&&(a.height=a.shapeArgs.height,a.shapey=a.shapeArgs.y,a.shapeArgs.height=1,g||(a.shapeArgs.y=a.stackY?a.plotY+c.translate(a.stackY):a.plotY+(a.negative?-a.height:a.height)))}):(f.data.forEach(function(a){if(null!==a.y&&(a.shapeArgs.height=a.height,a.shapeArgs.y=a.shapey,
a.graphic))a.graphic[a.outside3dPlot?"attr":"animate"](a.shapeArgs,f.options.animation)}),this.drawDataLabels()))}else a.apply(this,[].slice.call(arguments,1))});r(b,"plotGroup",function(a,b,c,f,g,l){"dataLabelsGroup"!==b&&this.chart.is3d()&&(this[b]&&delete this[b],l&&(this.chart.columnGroup||(this.chart.columnGroup=this.chart.renderer.g("columnGroup").add(l)),this[b]=this.chart.columnGroup,this.chart.columnGroup.attr(this.getPlotBox()),this[b].survive=!0,"group"===b||"markerGroup"===b))&&(arguments[3]=
"visible");return a.apply(this,Array.prototype.slice.call(arguments,1))});r(b,"setVisible",function(a,b){var c=this;c.chart.is3d()&&c.data.forEach(function(a){a.visible=a.options.visible=b="undefined"===typeof b?!B(c.visible,a.visible):b;c.options.data[c.data.indexOf(a)]=a.options;a.graphic&&a.graphic.attr({visibility:b?"visible":"hidden"})});a.apply(this,Array.prototype.slice.call(arguments,1))});z(a,"afterInit",function(){if(this.chart.is3d()){var a=this.options,b=a.grouping,c=a.stacking,f=this.yAxis.options.reversedStacks,
g=0;if("undefined"===typeof b||b){b=x(this.chart,c);g=a.stack||0;for(c=0;c<b[g].series.length&&b[g].series[c]!==this;c++);g=10*(b.totalStacks-b[g].position)+(f?c:-c);this.xAxis.reversed||(g=10*b.totalStacks-g)}a.depth=a.depth||25;this.z=this.z||0;a.zIndex=g}});r(b,"pointAttribs",f);r(b,"setState",k);r(b.pointClass.prototype,"hasNewShapeType",c);m.seriesTypes.columnRange&&(z=m.seriesTypes.columnrange.prototype,r(z,"pointAttribs",f),r(z,"setState",k),r(z.pointClass.prototype,"hasNewShapeType",c),z.plotGroup=
b.plotGroup,z.setVisible=b.setVisible);r(y.prototype,"alignDataLabel",function(a,b,c,f,l){var k=this.chart;f.outside3dPlot=b.outside3dPlot;if(k.is3d()&&this.is("column")){var m=this.options,n=B(f.inside,!!this.options.stacking),p=k.options.chart.options3d,h=b.pointWidth/2||0;m={x:l.x+h,y:l.y,z:this.z+m.depth/2};k.inverted&&(n&&(l.width=0,m.x+=b.shapeArgs.height/2),90<=p.alpha&&270>=p.alpha&&(m.y+=b.shapeArgs.width));m=g([m],k,!0,!1)[0];l.x=m.x-h;l.y=b.outside3dPlot?-9E9:m.y}a.apply(this,[].slice.call(arguments,
1))});r(H.prototype,"getStackBox",function(a,b,c,f,l,k,r,x){var n=a.apply(this,[].slice.call(arguments,1));if(b.is3d()&&c.base){var h=+c.base.split(",")[0],p=b.series[h];h=b.options.chart.options3d;p&&p instanceof m.seriesTypes.column&&(p={x:n.x+(b.inverted?r:k/2),y:n.y,z:p.options.depth/2},b.inverted&&(n.width=0,90<=h.alpha&&270>=h.alpha&&(p.y+=k)),p=g([p],b,!0,!1)[0],n.x=p.x-k/2,n.y=p.y)}return n});"";return a});F(a,"Series/Pie3D/Pie3DPoint.js",[a["Core/Series/SeriesRegistry.js"]],function(a){var x=
this&&this.__extends||function(){var a=function(m,x){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,m){a.__proto__=m}||function(a,m){for(var f in m)m.hasOwnProperty(f)&&(a[f]=m[f])};return a(m,x)};return function(m,x){function r(){this.constructor=m}a(m,x);m.prototype=null===x?Object.create(x):(r.prototype=x.prototype,new r)}}();a=a.seriesTypes.pie.prototype.pointClass;var y=a.prototype.haloPath;return function(a){function m(){var m=null!==a&&a.apply(this,arguments)||this;m.series=
void 0;return m}x(m,a);m.prototype.haloPath=function(){return this.series.chart.is3d()?[]:y.apply(this,arguments)};return m}(a)});F(a,"Series/Pie3D/Pie3DSeries.js",[a["Core/Globals.js"],a["Series/Pie3D/Pie3DPoint.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,z,y,D){var m=this&&this.__extends||function(){var a=function(f,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};
return a(f,c)};return function(f,c){function b(){this.constructor=f}a(f,c);f.prototype=null===c?Object.create(c):(b.prototype=c.prototype,new b)}}(),x=a.deg2rad,r=a.svg;a=D.extend;var C=D.pick;y=function(a){function f(){return null!==a&&a.apply(this,arguments)||this}m(f,a);f.prototype.addPoint=function(){a.prototype.addPoint.apply(this,arguments);this.chart.is3d()&&this.update(this.userOptions,!0)};f.prototype.animate=function(c){if(this.chart.is3d()){var b=this.options.animation;var f=this.center;
var g=this.group,k=this.markerGroup;r&&(!0===b&&(b={}),c?(g.oldtranslateX=C(g.oldtranslateX,g.translateX),g.oldtranslateY=C(g.oldtranslateY,g.translateY),f={translateX:f[0],translateY:f[1],scaleX:.001,scaleY:.001},g.attr(f),k&&(k.attrSetters=g.attrSetters,k.attr(f))):(f={translateX:g.oldtranslateX,translateY:g.oldtranslateY,scaleX:1,scaleY:1},g.animate(f,b),k&&k.animate(f,b)))}else a.prototype.animate.apply(this,arguments)};f.prototype.drawDataLabels=function(){if(this.chart.is3d()){var c=this.chart.options.chart.options3d;
this.data.forEach(function(a){var b=a.shapeArgs,f=b.r,k=(b.start+b.end)/2;a=a.labelPosition;var m=a.connectorPosition,r=-f*(1-Math.cos((b.alpha||c.alpha)*x))*Math.sin(k),v=f*(Math.cos((b.beta||c.beta)*x)-1)*Math.cos(k);[a.natural,m.breakAt,m.touchingSliceAt].forEach(function(a){a.x+=v;a.y+=r})})}a.prototype.drawDataLabels.apply(this,arguments)};f.prototype.pointAttribs=function(c){var b=a.prototype.pointAttribs.apply(this,arguments),f=this.options;this.chart.is3d()&&!this.chart.styledMode&&(b.stroke=
f.edgeColor||c.color||this.color,b["stroke-width"]=C(f.edgeWidth,1));return b};f.prototype.translate=function(){a.prototype.translate.apply(this,arguments);if(this.chart.is3d()){var c=this,b=c.options,f=b.depth||0,g=c.chart.options.chart.options3d,k=g.alpha,m=g.beta,r=b.stacking?(b.stack||0)*f:c._i*f;r+=f/2;!1!==b.grouping&&(r=0);c.data.forEach(function(a){var g=a.shapeArgs;a.shapeType="arc3d";g.z=r;g.depth=.75*f;g.alpha=k;g.beta=m;g.center=c.center;g=(g.end+g.start)/2;a.slicedTranslation={translateX:Math.round(Math.cos(g)*
b.slicedOffset*Math.cos(k*x)),translateY:Math.round(Math.sin(g)*b.slicedOffset*Math.cos(k*x))}})}};f.prototype.drawTracker=function(){a.prototype.drawTracker.apply(this,arguments);this.chart.is3d()&&this.points.forEach(function(a){a.graphic&&["out","inn","side1","side2"].forEach(function(b){a.graphic&&(a.graphic[b].element.point=a)})})};return f}(y.seriesTypes.pie);a(y.prototype,{pointClass:z});"";return y});F(a,"Series/Pie3D/Pie3DComposition.js",[a["Series/Pie3D/Pie3DPoint.js"],a["Series/Pie3D/Pie3DSeries.js"],
a["Core/Series/SeriesRegistry.js"]],function(a,z,y){y.seriesTypes.pie.prototype.pointClass.prototype.haloPath=a.prototype.haloPath;y.seriesTypes.pie=z});F(a,"Series/Scatter3D/Scatter3DPoint.js",[a["Series/Scatter/ScatterSeries.js"],a["Core/Utilities.js"]],function(a,z){var x=this&&this.__extends||function(){var a=function(m,r){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,f){a.__proto__=f}||function(a,f){for(var k in f)f.hasOwnProperty(k)&&(a[k]=f[k])};return a(m,r)};return function(m,
r){function x(){this.constructor=m}a(m,r);m.prototype=null===r?Object.create(r):(x.prototype=r.prototype,new x)}}(),D=z.defined;return function(a){function m(){var m=null!==a&&a.apply(this,arguments)||this;m.options=void 0;m.series=void 0;return m}x(m,a);m.prototype.applyOptions=function(){a.prototype.applyOptions.apply(this,arguments);D(this.z)||(this.z=0);return this};return m}(a.prototype.pointClass)});F(a,"Series/Scatter3D/Scatter3DSeries.js",[a["Core/Math3D.js"],a["Series/Scatter3D/Scatter3DPoint.js"],
a["Series/Scatter/ScatterSeries.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,z,y,D,m){var x=this&&this.__extends||function(){var a=function(f,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(f,c)};return function(f,c){function b(){this.constructor=f}a(f,c);f.prototype=null===c?Object.create(c):(b.prototype=c.prototype,new b)}}(),r=a.pointCameraDistance;a=m.extend;
var C=m.merge;m=function(a){function f(){var c=null!==a&&a.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}x(f,a);f.prototype.pointAttribs=function(c){var b=a.prototype.pointAttribs.apply(this,arguments);this.chart.is3d()&&c&&(b.zIndex=r(c,this.chart));return b};f.defaultOptions=C(y.defaultOptions,{tooltip:{pointFormat:"x: <b>{point.x}</b><br/>y: <b>{point.y}</b><br/>z: <b>{point.z}</b><br/>"}});return f}(y);a(m.prototype,{axisTypes:["xAxis","yAxis","zAxis"],directTouch:!0,
parallelArrays:["x","y","z"],pointArrayMap:["x","y","z"],pointClass:z});D.registerSeriesType("scatter3d",m);"";return m});F(a,"masters/highcharts-3d.src.js",[a["Core/Globals.js"],a["Core/Renderer/SVG/SVGRenderer3D.js"],a["Core/Chart/Chart3D.js"],a["Core/Axis/ZAxis.js"],a["Core/Axis/Axis3DComposition.js"],a["Series/Area3D/Area3DSeries.js"]],function(a,z,y,D,m,F){z.compose(a.SVGRenderer);y.compose(a.Chart,a.Fx);D.compose(a.Chart);m.compose(a.Axis,a.Tick);F.compose(a.seriesTypes.area)})});
//# sourceMappingURL=highcharts-3d.js.map