# -*- coding: utf-8 -*-

countries=(
("DE", "DEU", "276", "Deutschland", "Federal Republic of Germany"),
("AT", "AUT", "040", "Österreich", "Republic of Austria"),
("CH", "CHE", "756", "Schweiz", "Swiss Confederation"),
("AF", "AFG", "004", "Afghanistan", "Islamic Republic of Afghanistan"),
("AX", "ALA", "248", "Åland Islands"),
("AL", "ALB", "008", "Albania", "Republic of Albania"),
("DZ", "DZA", "012", "Algeria", "People's Democratic Republic of Algeria"),
("AS", "ASM", "016", "American Samoa"),
("AD", "AND", "020", "Andorra", "Principality of Andorra"),
("AO", "AGO", "024", "Angola", "Republic of Angola"),
("AI", "AIA", "660", "Anguilla"),
("AQ", "ATA", "010", "Antarctica"),
("AG", "ATG", "028", "Antigua and Barbuda"),
("AR", "ARG", "032", "Argentina", "Argentine Republic"),
("AM", "ARM", "051", "Armenia", "Republic of Armenia"),
("AW", "ABW", "533", "Aruba"),
("AU", "AUS", "036", "Australia"),
("AZ", "AZE", "031", "Azerbaijan", "Republic of Azerbaijan"),
("BS", "BHS", "044", "Bahamas", "Commonwealth of the Bahamas"),
("BH", "BHR", "048", "Bahrain", "Kingdom of Bahrain"),
("BD", "BGD", "050", "Bangladesh", "People's Republic of Bangladesh"),
("BB", "BRB", "052", "Barbados"),
("BY", "BLR", "112", "Belarus", "Republic of Belarus"),
("BE", "BEL", "056", "Belgium", "Kingdom of Belgium"),
("BZ", "BLZ", "084", "Belize"),
("BJ", "BEN", "204", "Benin", "Republic of Benin"),
("BM", "BMU", "060", "Bermuda"),
("BT", "BTN", "064", "Bhutan", "Kingdom of Bhutan"),
("BO", "BOL", "068", "Bolivia", "Republic of Bolivia"),
("BA", "BIH", "070", "Bosnia and Herzegovina", "Republic of Bosnia and Herzegovina"),
("BW", "BWA", "072", "Botswana", "Republic of Botswana"),
("BV", "BVT", "074", "Bouvet Island"),
("BR", "BRA", "076", "Brazil", "Federative Republic of Brazil"),
("IO", "IOT", "086", "British Indian Ocean Territory"),
("BN", "BRN", "096", "Brunei Darussalam"),
("BG", "BGR", "100", "Bulgaria", "Republic of Bulgaria"),
("BF", "BFA", "854", "Burkina Faso"),
("BI", "BDI", "108", "Burundi", "Republic of Burundi"),
("KH", "KHM", "116", "Cambodia", "Kingdom of Cambodia"),
("CM", "CMR", "120", "Cameroon", "Republic of Cameroon"),
("CA", "CAN", "124", "Canada"),
("CV", "CPV", "132", "Cape Verde", "Republic of Cape Verde"),
("KY", "CYM", "136", "Cayman Islands"),
("CF", "CAF", "140", "Central African Republic"),
("TD", "TCD", "148", "Chad", "Republic of Chad"),
("CL", "CHL", "152", "Chile", "Republic of Chile"),
("CN", "CHN", "156", "China", "People's Republic of China"),
("CX", "CXR", "162", "Christmas Island"),
("CC", "CCK", "166", "Cocos (Keeling) Islands"),
("CO", "COL", "170", "Colombia", "Republic of Colombia"),
("KM", "COM", "174", "Comoros", "Union of the Comoros"),
("CG", "COG", "178", "Congo", "Republic of the Congo"),
("CD", "COD", "180", "Congo, The Democratic Republic of the"),
("CK", "COK", "184", "Cook Islands"),
("CR", "CRI", "188", "Costa Rica", "Republic of Costa Rica"),
("CI", "CIV", "384", "Côte d'Ivoire", "Republic of Côte d'Ivoire"),
("HR", "HRV", "191", "Croatia", "Republic of Croatia"),
("CU", "CUB", "192", "Cuba", "Republic of Cuba"),
("CY", "CYP", "196", "Cyprus", "Republic of Cyprus"),
("CZ", "CZE", "203", "Czech Republic"),
("DK", "DNK", "208", "Denmark", "Kingdom of Denmark"),
("DJ", "DJI", "262", "Djibouti", "Republic of Djibouti"),
("DM", "DMA", "212", "Dominica", "Commonwealth of Dominica"),
("DO", "DOM", "214", "Dominican Republic"),
("EC", "ECU", "218", "Ecuador", "Republic of Ecuador"),
("EG", "EGY", "818", "Egypt", "Arab Republic of Egypt"),
("SV", "SLV", "222", "El Salvador", "Republic of El Salvador"),
("GQ", "GNQ", "226", "Equatorial Guinea", "Republic of Equatorial Guinea"),
("ER", "ERI", "232", "Eritrea"),
("EE", "EST", "233", "Estonia", "Republic of Estonia"),
("ET", "ETH", "231", "Ethiopia", "Federal Democratic Republic of Ethiopia"),
("FK", "FLK", "238", "Falkland Islands (Malvinas)"),
("FO", "FRO", "234", "Faroe Islands"),
("FJ", "FJI", "242", "Fiji", "Republic of the Fiji Islands"),
("FI", "FIN", "246", "Finland", "Republic of Finland"),
("FR", "FRA", "250", "France", "French Republic"),
("GF", "GUF", "254", "French Guiana"),
("PF", "PYF", "258", "French Polynesia"),
("TF", "ATF", "260", "French Southern Territories"),
("GA", "GAB", "266", "Gabon", "Gabonese Republic"),
("GM", "GMB", "270", "Gambia", "Republic of the Gambia"),
("GE", "GEO", "268", "Georgia"),
("GH", "GHA", "288", "Ghana", "Republic of Ghana"),
("GI", "GIB", "292", "Gibraltar"),
("GR", "GRC", "300", "Greece", "Hellenic Republic"),
("GL", "GRL", "304", "Greenland"),
("GD", "GRD", "308", "Grenada"),
("GP", "GLP", "312", "Guadeloupe"),
("GU", "GUM", "316", "Guam"),
("GT", "GTM", "320", "Guatemala", "Republic of Guatemala"),
("GG", "GGY", "831", "Guernsey"),
("GN", "GIN", "324", "Guinea", "Republic of Guinea"),
("GW", "GNB", "624", "Guinea-Bissau", "Republic of Guinea-Bissau"),
("GY", "GUY", "328", "Guyana", "Republic of Guyana"),
("HT", "HTI", "332", "Haiti", "Republic of Haiti"),
("HM", "HMD", "334", "Heard Island and McDonald Islands"),
("VA", "VAT", "336", "Holy See (Vatican City State)"),
("HN", "HND", "340", "Honduras", "Republic of Honduras"),
("HK", "HKG", "344", "Hong Kong", "Hong Kong Special Administrative Region of China"),
("HU", "HUN", "348", "Hungary", "Republic of Hungary"),
("IS", "ISL", "352", "Iceland", "Republic of Iceland"),
("IN", "IND", "356", "India", "Republic of India"),
("ID", "IDN", "360", "Indonesia", "Republic of Indonesia"),
("IR", "IRN", "364", "Iran, Islamic Republic of", "Islamic Republic of Iran"),
("IQ", "IRQ", "368", "Iraq", "Republic of Iraq"),
("IE", "IRL", "372", "Ireland"),
("IM", "IMN", "833", "Isle of Man"),
("IL", "ISR", "376", "Israel", "State of Israel"),
("IT", "ITA", "380", "Italy", "Italian Republic"),
("JM", "JAM", "388", "Jamaica"),
("JP", "JPN", "392", "Japan"),
("JE", "JEY", "832", "Jersey"),
("JO", "JOR", "400", "Jordan", "Hashemite Kingdom of Jordan"),
("KZ", "KAZ", "398", "Kazakhstan", "Republic of Kazakhstan"),
("KE", "KEN", "404", "Kenya", "Republic of Kenya"),
("KI", "KIR", "296", "Kiribati", "Republic of Kiribati"),
("KP", "PRK", "408", "Korea, Democratic People's Republic of", "Democratic People's Republic of Korea"),
("KR", "KOR", "410", "Korea, Republic of"),
("KW", "KWT", "414", "Kuwait", "State of Kuwait"),
("KG", "KGZ", "417", "Kyrgyzstan", "Kyrgyz Republic"),
("LA", "LAO", "418", "Lao People's Democratic Republic"),
("LV", "LVA", "428", "Latvia", "Republic of Latvia"),
("LB", "LBN", "422", "Lebanon", "Lebanese Republic"),
("LS", "LSO", "426", "Lesotho", "Kingdom of Lesotho"),
("LR", "LBR", "430", "Liberia", "Republic of Liberia"),
("LY", "LBY", "434", "Libyan Arab Jamahiriya", "Socialist People's Libyan Arab Jamahiriya"),
("LI", "LIE", "438", "Liechtenstein", "Principality of Liechtenstein"),
("LT", "LTU", "440", "Lithuania", "Republic of Lithuania"),
("LU", "LUX", "442", "Luxembourg", "Grand Duchy of Luxembourg"),
("MO", "MAC", "446", "Macao", "Macao Special Administrative Region of China"),
("MK", "MKD", "807", "Macedonia, Republic of", "The Former Yugoslav Republic of Macedonia"),
("MG", "MDG", "450", "Madagascar", "Republic of Madagascar"),
("MW", "MWI", "454", "Malawi", "Republic of Malawi"),
("MY", "MYS", "458", "Malaysia"),
("MV", "MDV", "462", "Maldives", "Republic of Maldives"),
("ML", "MLI", "466", "Mali", "Republic of Mali"),
("MT", "MLT", "470", "Malta", "Republic of Malta"),
("MH", "MHL", "584", "Marshall Islands", "Republic of the Marshall Islands"),
("MQ", "MTQ", "474", "Martinique"),
("MR", "MRT", "478", "Mauritania", "Islamic Republic of Mauritania"),
("MU", "MUS", "480", "Mauritius", "Republic of Mauritius"),
("YT", "MYT", "175", "Mayotte"),
("MX", "MEX", "484", "Mexico", "United Mexican States"),
("FM", "FSM", "583", "Micronesia, Federated States of", "Federated States of Micronesia"),
("MD", "MDA", "498", "Moldova", "Republic of Moldova"),
("MC", "MCO", "492", "Monaco", "Principality of Monaco"),
("MN", "MNG", "496", "Mongolia"),
("ME", "MNE", "499", "Montenegro", "Montenegro"),
("MS", "MSR", "500", "Montserrat"),
("MA", "MAR", "504", "Morocco", "Kingdom of Morocco"),
("MZ", "MOZ", "508", "Mozambique", "Republic of Mozambique"),
("MM", "MMR", "104", "Myanmar", "Union of Myanmar"),
("NA", "NAM", "516", "Namibia", "Republic of Namibia"),
("NR", "NRU", "520", "Nauru", "Republic of Nauru"),
("NP", "NPL", "524", "Nepal", "Federal Democratic Republic of Nepal"),
("NL", "NLD", "528", "Netherlands", "Kingdom of the Netherlands"),
("AN", "ANT", "530", "Netherlands Antilles"),
("NC", "NCL", "540", "New Caledonia"),
("NZ", "NZL", "554", "New Zealand"),
("NI", "NIC", "558", "Nicaragua", "Republic of Nicaragua"),
("NE", "NER", "562", "Niger", "Republic of the Niger"),
("NG", "NGA", "566", "Nigeria", "Federal Republic of Nigeria"),
("NU", "NIU", "570", "Niue", "Republic of Niue"),
("NF", "NFK", "574", "Norfolk Island"),
("MP", "MNP", "580", "Northern Mariana Islands", "Commonwealth of the Northern Mariana Islands"),
("NO", "NOR", "578", "Norway", "Kingdom of Norway"),
("OM", "OMN", "512", "Oman", "Sultanate of Oman"),
("PK", "PAK", "586", "Pakistan", "Islamic Republic of Pakistan"),
("PW", "PLW", "585", "Palau", "Republic of Palau"),
("PS", "PSE", "275", "Palestinian Territory, Occupied", "Occupied Palestinian Territory"),
("PA", "PAN", "591", "Panama", "Republic of Panama"),
("PG", "PNG", "598", "Papua New Guinea"),
("PY", "PRY", "600", "Paraguay", "Republic of Paraguay"),
("PE", "PER", "604", "Peru", "Republic of Peru"),
("PH", "PHL", "608", "Philippines", "Republic of the Philippines"),
("PN", "PCN", "612", "Pitcairn"),
("PL", "POL", "616", "Poland", "Republic of Poland"),
("PT", "PRT", "620", "Portugal", "Portuguese Republic"),
("PR", "PRI", "630", "Puerto Rico"),
("QA", "QAT", "634", "Qatar", "State of Qatar"),
("RE", "REU", "638", "Reunion"),
("RO", "ROU", "642", "Romania"),
("RU", "RUS", "643", "Russian Federation"),
("RW", "RWA", "646", "Rwanda", "Rwandese Republic"),
("BL", "BLM", "652", "Saint Barthélemy"),
("SH", "SHN", "654", "Saint Helena"),
("KN", "KNA", "659", "Saint Kitts and Nevis"),
("LC", "LCA", "662", "Saint Lucia"),
("MF", "MAF", "663", "Saint Martin (French part)"),
("PM", "SPM", "666", "Saint Pierre and Miquelon"),
("VC", "VCT", "670", "Saint Vincent and the Grenadines"),
("WS", "WSM", "882", "Samoa", "Independent State of Samoa"),
("SM", "SMR", "674", "San Marino", "Republic of San Marino"),
("ST", "STP", "678", "Sao Tome and Principe", "Democratic Republic of Sao Tome and Principe"),
("SA", "SAU", "682", "Saudi Arabia", "Kingdom of Saudi Arabia"),
("SN", "SEN", "686", "Senegal", "Republic of Senegal"),
("RS", "SRB", "688", "Serbia", "Republic of Serbia"),
("SC", "SYC", "690", "Seychelles", "Republic of Seychelles"),
("SL", "SLE", "694", "Sierra Leone", "Republic of Sierra Leone"),
("SG", "SGP", "702", "Singapore", "Republic of Singapore"),
("SK", "SVK", "703", "Slovakia", "Slovak Republic"),
("SI", "SVN", "705", "Slovenia", "Republic of Slovenia"),
("SB", "SLB", "090", "Solomon Islands"),
("SO", "SOM", "706", "Somalia", "Somali Republic"),
("ZA", "ZAF", "710", "South Africa", "Republic of South Africa"),
("GS", "SGS", "239", "South Georgia and the South Sandwich Islands"),
("ES", "ESP", "724", "Spain", "Kingdom of Spain"),
("LK", "LKA", "144", "Sri Lanka", "Democratic Socialist Republic of Sri Lanka"),
("SD", "SDN", "736", "Sudan", "Republic of the Sudan"),
("SR", "SUR", "740", "Suriname", "Republic of Suriname"),
("SJ", "SJM", "744", "Svalbard and Jan Mayen"),
("SZ", "SWZ", "748", "Swaziland", "Kingdom of Swaziland"),
("SE", "SWE", "752", "Sweden", "Kingdom of Sweden"),
("SY", "SYR", "760", "Syrian Arab Republic"),
("TW", "TWN", "158", "Taiwan", "Taiwan, Province of China", "Taiwan, Province of China"),
("TJ", "TJK", "762", "Tajikistan", "Republic of Tajikistan"),
("TZ", "TZA", "834", "Tanzania, United Republic of", "United Republic of Tanzania"),
("TH", "THA", "764", "Thailand", "Kingdom of Thailand"),
("TL", "TLS", "626", "Timor-Leste", "Democratic Republic of Timor-Leste"),
("TG", "TGO", "768", "Togo", "Togolese Republic"),
("TK", "TKL", "772", "Tokelau"),
("TO", "TON", "776", "Tonga", "Kingdom of Tonga"),
("TT", "TTO", "780", "Trinidad and Tobago", "Republic of Trinidad and Tobago"),
("TN", "TUN", "788", "Tunisia", "Republic of Tunisia"),
("TR", "TUR", "792", "Turkey", "Republic of Turkey"),
("TM", "TKM", "795", "Turkmenistan"),
("TC", "TCA", "796", "Turks and Caicos Islands"),
("TV", "TUV", "798", "Tuvalu"),
("UG", "UGA", "800", "Uganda", "Republic of Uganda"),
("UA", "UKR", "804", "Ukraine"),
("AE", "ARE", "784", "United Arab Emirates"),
("GB", "GBR", "826", "United Kingdom", "United Kingdom of Great Britain and Northern Ireland"),
("US", "USA", "840", "United States", "United States of America"),
("UM", "UMI", "581", "United States Minor Outlying Islands"),
("UY", "URY", "858", "Uruguay", "Eastern Republic of Uruguay"),
("UZ", "UZB", "860", "Uzbekistan", "Republic of Uzbekistan"),
("VU", "VUT", "548", "Vanuatu", "Republic of Vanuatu"),
("VE", "VEN", "862", "Venezuela", "Bolivarian Republic of Venezuela"),
("VN", "VNM", "704", "Viet Nam", "Socialist Republic of Viet Nam"),
("VG", "VGB", "092", "Virgin Islands, British", "British Virgin Islands"),
("VI", "VIR", "850", "Virgin Islands, U.S.", "Virgin Islands of the United States"),
("WF", "WLF", "876", "Wallis and Futuna"),
("EH", "ESH", "732", "Western Sahara"),
("YE", "YEM", "887", "Yemen", "Republic of Yemen"),
("ZM", "ZMB", "894", "Zambia", "Republic of Zambia"),
("ZW", "ZWE", "716", "Zimbabwe", "Republic of Zimbabwe"),
)
_cl = []

def GetConf(code):
    """
    Load country by code
    """
    code = code.upper()
    if len(code)==2:
        for c in countries:
            if c[0] == code:
                return _GetDict(c)
    if len(code)==3:
        for c in countries:
            if c[1] == code:
                return _GetDict(c)
    return {}


def GetCountries():
    """
    load codelist of countries and cache
    """
    if len(_cl) == 0:
        for c in countries:
            _cl.append({"id": c[1], "name": c[3]})
    return _cl


def _GetDict(c):
    d = {"code": c[1], "code2": c[0], "numeric": c[2], "name": c[3]}
    if len(c) > 4:
        d["name2"] = c[4]
    return d