eval("//# sourceURL=assets/ember-cli/loader.js");

;eval("define(\"arena/adapters/application\", \n  [\"ember-data\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var DS = __dependency1__[\"default\"];\n\n    // export default DS.FixtureAdapter.extend({});\n\n    __exports__[\"default\"] = DS.RESTAdapter.extend({\n        host: ArenaENV.api_endpoint,\n        namespace: \'api/1\',\n        ajax: function(url, type, hash) {\n            if (Ember.isEmpty(hash)) hash = {};\n            if (Ember.isEmpty(hash.data)) hash.data = {};\n            hash.data.ts = new Date().getTime();\n            return this._super(url, type, hash);\n        }\n    });\n  });//# sourceURL=arena/adapters/application.js");

;eval("define(\"arena/app\", \n  [\"ember\",\"ember/resolver\",\"ember/load-initializers\",\"exports\"],\n  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    var Resolver = __dependency2__[\"default\"];\n    var loadInitializers = __dependency3__[\"default\"];\n\n    Ember.MODEL_FACTORY_INJECTIONS = true;\n\n    var App = Ember.Application.extend({\n      modulePrefix: \'arena\', // TODO: loaded via config\n      Resolver: Resolver\n    });\n\n    loadInitializers(App, \'arena\');\n\n    __exports__[\"default\"] = App;\n  });//# sourceURL=arena/app.js");

;eval("define(\"arena/helpers/quake-name\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n\n    var helper = function(value) {\n        var escaped = Ember.Handlebars.Utils.escapeExpression(value);\n\n        escaped = escaped.replace(/\\^([0-9])/g,\'</span><span class=\"quake-color-$1\">\');\n        escaped = \'<span class=\"quake-color-0\">\' + escaped + \'</span>\';\n\n        return new Ember.Handlebars.SafeString(escaped);\n    };\n\n    var quakeName = Ember.Handlebars.makeBoundHelper(helper);\n    quakeName.helper = helper;\n\n    __exports__[\"default\"] = quakeName;\n  });//# sourceURL=arena/helpers/quake-name.js");

;eval("define(\"arena/models/game\", \n  [\"ember-data\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var DS = __dependency1__[\"default\"];\n\n    var Game = DS.Model.extend({\n        mapname: DS.attr(\'string\'),\n        current: DS.attr(\'boolean\'),\n        start: DS.attr(\'epoch\'),\n        stop: DS.attr(\'epoch\'),\n        players: DS.hasMany(\'player\', {async: true})\n    });\n\n    Game.reopenClass({\n        FIXTURES: [\n            {\n                id: 1,\n                map: \'awesomemap\',\n                current: true,\n                players: [\n                    \'2394808AFSDFAFS\',\n                    \'23948ASDF08AFSDFAFS\'\n                ],\n                start: moment().toDate(),\n                stop: null\n            },\n            {\n                id: 2,\n                map: \'lastmap\',\n                current: false,\n                start: moment().subtract(\'hour\').toDate(),\n                stop: moment().toDate()\n            }\n        ]\n    });\n\n    __exports__[\"default\"] = Game;\n  });//# sourceURL=arena/models/game.js");

;eval("define(\"arena/models/player\", \n  [\"ember-data\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var DS = __dependency1__[\"default\"];\n\n    var Player = DS.Model.extend({\n        name: DS.attr(\'string\'),\n        team: DS.attr(\'string\'),\n        online: DS.attr(\'boolean\'),\n        score: DS.attr(\'number\'),\n        names: DS.attr(\'raw\'),\n    });\n\n    Player.reopenClass({\n        FIXTURES: [\n            {\n                id: \'2394808AFSDFAFS\',\n                name: \'-[aequitas]-\',\n                team: \'red\',\n                online: true,\n                score: 42,\n                names: [\'old_nickname\']\n            },\n            {\n                id: \'23948ASDF08AFSDFAFS\',\n                name: \'n^100^0b\',\n                team: \'red\',\n                online: true,\n                score: 0\n            },\n            {\n                id: \'23948SFADFJKLASDF08AFSDFAFS\',\n                name: \'colors^11^22^33^44^55^66^77^0w00t\',\n                team: \'\',\n                online: false,\n                score: 0\n            }\n        ]\n    });\n\n    __exports__[\"default\"] = Player;\n  });//# sourceURL=arena/models/player.js");

;eval("define(\"arena/models/vote\", \n  [\"ember-data\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var DS = __dependency1__[\"default\"];\n\n    __exports__[\"default\"] = DS.Model.extend({\n        vote: DS.attr(\'number\'),\n        player: DS.belongsTo(\'player\', {async: true}),\n        game: DS.belongsTo(\'game\', {async: true})\n    });\n  });//# sourceURL=arena/models/vote.js");

;eval("define(\"arena/router\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n\n    var Router = Ember.Router.extend({\n      location: ArenaENV.locationType\n    });\n\n    Router.map(function() {\n      this.resource(\'games\');\n      this.resource(\'players\');\n      this.resource(\'player\', { path: \'/players/:player_id\' });\n      this.resource(\'votes\');\n    });\n\n    __exports__[\"default\"] = Router;\n  });//# sourceURL=arena/router.js");

;eval("define(\"arena/routes/games\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n\n    __exports__[\"default\"] = Ember.Route.extend({\n        model: function() {\n            return this.store.find(\'game\');\n        },\n        activate: function(){\n            this.poll();\n        },\n        deactivate: function(){\n            Ember.run.cancel(this.get(\'poll_inst\'));\n        },\n        poll: function() {\n            var _this = this;\n            var poll_inst = Ember.run.later( function() {\n                _this.store.find(\'game\');\n                _this.poll();\n            }, 10000 );\n            this.set(\'poll_inst\', poll_inst);\n        }\n    });\n  });//# sourceURL=arena/routes/games.js");

;eval("define(\"arena/routes/player\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n\n    __exports__[\"default\"] = Ember.Route.extend({\n        setupController: function(controller, model){\n            this._super(controller, model);\n            this.poll(model);\n        },\n        deactivate: function(){\n            Ember.run.cancel(this.get(\'poll_inst\'));\n        },\n        poll: function(model) {\n            var _this = this;\n            var poll_inst = Ember.run.later( function() {\n                model.reload();\n                _this.poll(model);\n            }, 5000 );\n            this.set(\'poll_inst\', poll_inst);\n        }\n    });\n  });//# sourceURL=arena/routes/player.js");

;eval("define(\"arena/routes/players\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n\n    __exports__[\"default\"] = Ember.Route.extend({\n        model: function() {\n            return this.store.find(\'player\');\n        },\n        activate: function(){\n            this.poll();\n        },\n        deactivate: function(){\n            Ember.run.cancel(this.get(\'poll_inst\'));\n        },\n        poll: function() {\n            var _this = this;\n            var poll_inst = Ember.run.later( function() {\n                _this.store.find(\'player\');\n                _this.poll();\n            }, 5000 );\n            this.set(\'poll_inst\', poll_inst);\n        }\n    });\n  });//# sourceURL=arena/routes/players.js");

;eval("define(\"arena/routes/votes\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n\n    __exports__[\"default\"] = Ember.Route.extend({\n        model: function() {\n            return this.store.find(\'vote\');\n        },\n    });\n  });//# sourceURL=arena/routes/votes.js");

;eval("define(\"arena/serializers/application\", \n  [\"ember-data\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var DS = __dependency1__[\"default\"];\n\n    __exports__[\"default\"] = DS.RESTSerializer.extend({\n        extractArray: function(store, type, payload) {\n            payload[type.typeKey] = payload._items;\n            delete payload._items;\n            delete payload._links;\n\n            return this._super(store, type, payload);\n        },\n        extractSingle: function(store, type, payload, id) {\n            var _payload = {};\n            _payload[type.typeKey] = payload;\n\n            return this._super(store, type, _payload, id);\n        },\n        primaryKey: \'_id\'\n    });\n  });//# sourceURL=arena/serializers/application.js");

;eval("define(\"arena/templates/_navbar\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    __exports__[\"default\"] = Ember.Handlebars.template(function anonymous(Handlebars,depth0,helpers,partials,data) {\n    this.compilerInfo = [4,\'>= 1.0.0\'];\n    helpers = this.merge(helpers, Ember.Handlebars.helpers); data = data || {};\n      var buffer = \'\', stack1, helper, options, self=this, helperMissing=helpers.helperMissing;\n\n    function program1(depth0,data) {\n      \n      var buffer = \'\', stack1, helper, options;\n      data.buffer.push(\"\\n            \");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{\n        \'bubbles\': (false)\n      },hashTypes:{\'bubbles\': \"BOOLEAN\"},hashContexts:{\'bubbles\': depth0},inverse:self.noop,fn:self.program(2, program2, data),contexts:[depth0],types:[\"STRING\"],data:data},helper ? helper.call(depth0, \"players\", options) : helperMissing.call(depth0, \"link-to\", \"players\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n        \");\n      return buffer;\n      }\n    function program2(depth0,data) {\n      \n      \n      data.buffer.push(\"\\n                Players\\n            \");\n      }\n\n    function program4(depth0,data) {\n      \n      var buffer = \'\', stack1, helper, options;\n      data.buffer.push(\"\\n            \");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{\n        \'bubbles\': (false)\n      },hashTypes:{\'bubbles\': \"BOOLEAN\"},hashContexts:{\'bubbles\': depth0},inverse:self.noop,fn:self.program(5, program5, data),contexts:[depth0],types:[\"STRING\"],data:data},helper ? helper.call(depth0, \"games\", options) : helperMissing.call(depth0, \"link-to\", \"games\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n        \");\n      return buffer;\n      }\n    function program5(depth0,data) {\n      \n      \n      data.buffer.push(\"\\n                Games\\n            \");\n      }\n\n    function program7(depth0,data) {\n      \n      var buffer = \'\', stack1, helper, options;\n      data.buffer.push(\"\\n            \");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{\n        \'bubbles\': (false)\n      },hashTypes:{\'bubbles\': \"BOOLEAN\"},hashContexts:{\'bubbles\': depth0},inverse:self.noop,fn:self.program(8, program8, data),contexts:[depth0],types:[\"STRING\"],data:data},helper ? helper.call(depth0, \"votes\", options) : helperMissing.call(depth0, \"link-to\", \"votes\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n        \");\n      return buffer;\n      }\n    function program8(depth0,data) {\n      \n      \n      data.buffer.push(\"\\n                Votes\\n            \");\n      }\n\n      data.buffer.push(\"<nav class=\\\"navbar navbar-default\\\" role=\\\"navigation\\\">\\n  <div class=\\\"container-fluid\\\">\\n    <!-- Brand and toggle get grouped for better mobile display -->\\n    <div class=\\\"navbar-header\\\">\\n      <button type=\\\"button\\\" class=\\\"navbar-toggle\\\" data-toggle=\\\"collapse\\\" data-target=\\\"#bs-example-navbar-collapse-1\\\">\\n        <span class=\\\"sr-only\\\">Toggle navigation</span>\\n        <span class=\\\"icon-bar\\\"></span>\\n        <span class=\\\"icon-bar\\\"></span>\\n        <span class=\\\"icon-bar\\\"></span>\\n      </button>\\n      <a class=\\\"navbar-brand\\\" href=\\\"#\\\">Munerator</a>\\n    </div>\\n\\n    <!-- Collect the nav links, forms, and other content for toggling -->\\n    <div class=\\\"collapse navbar-collapse in\\\" id=\\\"bs-example-navbar-collapse-1\\\">\\n      <ul class=\\\"nav navbar-nav\\\">\\n        \");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{\n        \'tagName\': (\"li\"),\n        \'href\': (false)\n      },hashTypes:{\'tagName\': \"STRING\",\'href\': \"BOOLEAN\"},hashContexts:{\'tagName\': depth0,\'href\': depth0},inverse:self.noop,fn:self.program(1, program1, data),contexts:[depth0],types:[\"STRING\"],data:data},helper ? helper.call(depth0, \"players\", options) : helperMissing.call(depth0, \"link-to\", \"players\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n        \");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{\n        \'tagName\': (\"li\"),\n        \'href\': (false)\n      },hashTypes:{\'tagName\': \"STRING\",\'href\': \"BOOLEAN\"},hashContexts:{\'tagName\': depth0,\'href\': depth0},inverse:self.noop,fn:self.program(4, program4, data),contexts:[depth0],types:[\"STRING\"],data:data},helper ? helper.call(depth0, \"games\", options) : helperMissing.call(depth0, \"link-to\", \"games\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n        \");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{\n        \'tagName\': (\"li\"),\n        \'href\': (false)\n      },hashTypes:{\'tagName\': \"STRING\",\'href\': \"BOOLEAN\"},hashContexts:{\'tagName\': depth0,\'href\': depth0},inverse:self.noop,fn:self.program(7, program7, data),contexts:[depth0],types:[\"STRING\"],data:data},helper ? helper.call(depth0, \"votes\", options) : helperMissing.call(depth0, \"link-to\", \"votes\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n  </div><!-- /.container-fluid -->\\n</nav>\");\n      return buffer;\n      \n    });\n  });//# sourceURL=arena/templates/_navbar.js");

;eval("define(\"arena/templates/application\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    __exports__[\"default\"] = Ember.Handlebars.template(function anonymous(Handlebars,depth0,helpers,partials,data) {\n    this.compilerInfo = [4,\'>= 1.0.0\'];\n    helpers = this.merge(helpers, Ember.Handlebars.helpers); data = data || {};\n      var buffer = \'\', stack1, helper, options, helperMissing=helpers.helperMissing, escapeExpression=this.escapeExpression;\n\n\n      data.buffer.push(escapeExpression((helper = helpers.partial || (depth0 && depth0.partial),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"STRING\"],data:data},helper ? helper.call(depth0, \"navbar\", options) : helperMissing.call(depth0, \"partial\", \"navbar\", options))));\n      data.buffer.push(\"\\n\");\n      stack1 = helpers._triageMustache.call(depth0, \"outlet\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      return buffer;\n      \n    });\n  });//# sourceURL=arena/templates/application.js");

;eval("define(\"arena/templates/games\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    __exports__[\"default\"] = Ember.Handlebars.template(function anonymous(Handlebars,depth0,helpers,partials,data) {\n    this.compilerInfo = [4,\'>= 1.0.0\'];\n    helpers = this.merge(helpers, Ember.Handlebars.helpers); data = data || {};\n      var buffer = \'\', stack1, helperMissing=helpers.helperMissing, escapeExpression=this.escapeExpression, self=this;\n\n    function program1(depth0,data) {\n      \n      var buffer = \'\', stack1;\n      data.buffer.push(\"\\n<tr>\\n    <td>\");\n      stack1 = helpers[\'if\'].call(depth0, \"current\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(2, program2, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</td>\\n    <td>\");\n      stack1 = helpers._triageMustache.call(depth0, \"mapname\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</td>\\n    <td>\\n    <ul>\\n    \");\n      stack1 = helpers.each.call(depth0, \"players\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(4, program4, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n    </ul\\n    </td>\\n    <td>\");\n      stack1 = helpers._triageMustache.call(depth0, \"start\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</td>\\n    <td>\");\n      stack1 = helpers._triageMustache.call(depth0, \"stop\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</td>\\n</tr>\\n\");\n      return buffer;\n      }\n    function program2(depth0,data) {\n      \n      \n      data.buffer.push(\"<span class=\\\"glyphicon glyphicon-ok\\\"></span>\");\n      }\n\n    function program4(depth0,data) {\n      \n      var buffer = \'\', stack1, helper, options;\n      data.buffer.push(\"\\n    <li>\");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(5, program5, data),contexts:[depth0,depth0],types:[\"STRING\",\"ID\"],data:data},helper ? helper.call(depth0, \"player\", \"\", options) : helperMissing.call(depth0, \"link-to\", \"player\", \"\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</li>\\n    \");\n      return buffer;\n      }\n    function program5(depth0,data) {\n      \n      var helper, options;\n      data.buffer.push(escapeExpression((helper = helpers[\'quake-name\'] || (depth0 && depth0[\'quake-name\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data},helper ? helper.call(depth0, \"name\", options) : helperMissing.call(depth0, \"quake-name\", \"name\", options))));\n      }\n\n      data.buffer.push(\"<table class=\\\"table\\\">\\n<tr>\\n    <th>Current</th>\\n    <th>Map name</th>\\n    <th>Players</th>\\n    <th>Start</th>\\n    <th>Stop</th>\\n</tr>\\n\");\n      stack1 = helpers.each.call(depth0, {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(1, program1, data),contexts:[],types:[],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n</table>\");\n      return buffer;\n      \n    });\n  });//# sourceURL=arena/templates/games.js");

;eval("define(\"arena/templates/index\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    __exports__[\"default\"] = Ember.Handlebars.template(function anonymous(Handlebars,depth0,helpers,partials,data) {\n    this.compilerInfo = [4,\'>= 1.0.0\'];\n    helpers = this.merge(helpers, Ember.Handlebars.helpers); data = data || {};\n      \n\n\n      data.buffer.push(\"<p><a href=\\\"https://quake.ijohan.nl\\\">Game Manager</a></p>\\n<p><a href=\\\"http://quake.brensen.com/api/1\\\">API</a></p>\\n<p><a href=\\\"/stats\\\">Stats</a></p>\\n\\n<p>Join us every day around 12:30 at: quake.brensen.com, port 1200.</p>\\n<p>OpenArena version: 0.8.8 (<a href=\\\"http://www.openarena.ws/download.php?list.61\\\">download</a>)</p>\\n<p>Be sure to enable downloading in your settings or some maps will not load <a target=\\\"_blank\\\" href=\\\"http://openarena.wikia.com/wiki/Manual/Automatic_downloading#How_to_setup\\\">instructions</a></p>\");\n      \n    });\n  });//# sourceURL=arena/templates/index.js");

;eval("define(\"arena/templates/maps\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    __exports__[\"default\"] = Ember.Handlebars.template(function anonymous(Handlebars,depth0,helpers,partials,data) {\n    this.compilerInfo = [4,\'>= 1.0.0\'];\n    helpers = this.merge(helpers, Ember.Handlebars.helpers); data = data || {};\n      var buffer = \'\', stack1, self=this;\n\n    function program1(depth0,data) {\n      \n      var buffer = \'\', stack1;\n      data.buffer.push(\"\\n        <li>\\n          <label>\");\n      stack1 = helpers._triageMustache.call(depth0, \"name\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</label>(\");\n      stack1 = helpers._triageMustache.call(depth0, \"current\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\")\\n        </li>\\n        \");\n      return buffer;\n      }\n\n      data.buffer.push(\"<section id=\\\"maps\\\">\\n<h3>Maps</h3>\\n    <ul id=\\\"map-list\\\">\\n        \");\n      stack1 = helpers.each.call(depth0, {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(1, program1, data),contexts:[],types:[],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n    </ul>\\n</section>\");\n      return buffer;\n      \n    });\n  });//# sourceURL=arena/templates/maps.js");

;eval("define(\"arena/templates/player\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    __exports__[\"default\"] = Ember.Handlebars.template(function anonymous(Handlebars,depth0,helpers,partials,data) {\n    this.compilerInfo = [4,\'>= 1.0.0\'];\n    helpers = this.merge(helpers, Ember.Handlebars.helpers); data = data || {};\n      var buffer = \'\', stack1, helper, options, helperMissing=helpers.helperMissing, escapeExpression=this.escapeExpression, self=this;\n\n    function program1(depth0,data) {\n      \n      var buffer = \'\', stack1;\n      data.buffer.push(\"\\n<p>Previous nicknames:</p>\\n<ul>\\n\");\n      stack1 = helpers.each.call(depth0, \"names\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(2, program2, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n</ul>\\n\");\n      return buffer;\n      }\n    function program2(depth0,data) {\n      \n      var buffer = \'\', helper, options;\n      data.buffer.push(\"\\n<li>\");\n      data.buffer.push(escapeExpression((helper = helpers[\'quake-name\'] || (depth0 && depth0[\'quake-name\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data},helper ? helper.call(depth0, \"\", options) : helperMissing.call(depth0, \"quake-name\", \"\", options))));\n      data.buffer.push(\"</li>\\n\");\n      return buffer;\n      }\n\n      data.buffer.push(\"<p>Nickname: \");\n      data.buffer.push(escapeExpression((helper = helpers[\'quake-name\'] || (depth0 && depth0[\'quake-name\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data},helper ? helper.call(depth0, \"name\", options) : helperMissing.call(depth0, \"quake-name\", \"name\", options))));\n      data.buffer.push(\"</p>\\n\");\n      stack1 = helpers[\'if\'].call(depth0, \"names\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(1, program1, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      return buffer;\n      \n    });\n  });//# sourceURL=arena/templates/player.js");

;eval("define(\"arena/templates/players\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    __exports__[\"default\"] = Ember.Handlebars.template(function anonymous(Handlebars,depth0,helpers,partials,data) {\n    this.compilerInfo = [4,\'>= 1.0.0\'];\n    helpers = this.merge(helpers, Ember.Handlebars.helpers); data = data || {};\n      var buffer = \'\', stack1, helperMissing=helpers.helperMissing, escapeExpression=this.escapeExpression, self=this;\n\n    function program1(depth0,data) {\n      \n      var buffer = \'\', stack1, helper, options;\n      data.buffer.push(\"\\n<tr>\\n    <td>\");\n      stack1 = helpers[\'if\'].call(depth0, \"online\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(2, program2, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</td>\\n    <td>\");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(4, program4, data),contexts:[depth0,depth0],types:[\"STRING\",\"ID\"],data:data},helper ? helper.call(depth0, \"player\", \"\", options) : helperMissing.call(depth0, \"link-to\", \"player\", \"\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</td>\\n    <td>\");\n      stack1 = helpers._triageMustache.call(depth0, \"team\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</td>\\n    <td>\");\n      stack1 = helpers._triageMustache.call(depth0, \"score\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</td>\\n</tr>\\n\");\n      return buffer;\n      }\n    function program2(depth0,data) {\n      \n      \n      data.buffer.push(\"<span class=\\\"glyphicon glyphicon-ok\\\"></span>\");\n      }\n\n    function program4(depth0,data) {\n      \n      var helper, options;\n      data.buffer.push(escapeExpression((helper = helpers[\'quake-name\'] || (depth0 && depth0[\'quake-name\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data},helper ? helper.call(depth0, \"name\", options) : helperMissing.call(depth0, \"quake-name\", \"name\", options))));\n      }\n\n      data.buffer.push(\"<table class=\\\"table\\\">\\n<tr>\\n    <th>Online</th>\\n    <th>Name</th>\\n    <th>Team</th>\\n    <th>Score</th>\\n</tr>\\n\");\n      stack1 = helpers.each.call(depth0, {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(1, program1, data),contexts:[],types:[],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n</table>\");\n      return buffer;\n      \n    });\n  });//# sourceURL=arena/templates/players.js");

;eval("define(\"arena/templates/votes\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    __exports__[\"default\"] = Ember.Handlebars.template(function anonymous(Handlebars,depth0,helpers,partials,data) {\n    this.compilerInfo = [4,\'>= 1.0.0\'];\n    helpers = this.merge(helpers, Ember.Handlebars.helpers); data = data || {};\n      var buffer = \'\', stack1, self=this;\n\n    function program1(depth0,data) {\n      \n      var buffer = \'\', stack1;\n      data.buffer.push(\"\\n<tr>\\n    <td>\");\n      stack1 = helpers._triageMustache.call(depth0, \"player.name\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</td>\\n    <td>\");\n      stack1 = helpers._triageMustache.call(depth0, \"game.mapname\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</td>\\n    <td>\");\n      stack1 = helpers._triageMustache.call(depth0, \"vote\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</td>\\n</tr>\\n\");\n      return buffer;\n      }\n\n      data.buffer.push(\"<table class=\\\"table\\\">\\n<tr>\\n    <th>Player</th>\\n    <th>Game</th>\\n    <th>Vote</th>\\n</tr>\\n\");\n      stack1 = helpers.each.call(depth0, {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(1, program1, data),contexts:[],types:[],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n</table>\");\n      return buffer;\n      \n    });\n  });//# sourceURL=arena/templates/votes.js");

;eval("define(\"arena/tests/arena/adapters/application.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/adapters\');\n    test(\'arena/adapters/application.js should pass jshint\', function() { \n      ok(false, \'arena/adapters/application.js should pass jshint.\\narena/adapters/application.js: line 9, col 34, Expected \\\'{\\\' and instead saw \\\'hash\\\'.\\narena/adapters/application.js: line 10, col 39, Expected \\\'{\\\' and instead saw \\\'hash\\\'.\\narena/adapters/application.js: line 9, col 13, \\\'Ember\\\' is not defined.\\narena/adapters/application.js: line 10, col 13, \\\'Ember\\\' is not defined.\\n\\n4 errors\'); \n    });\n  });//# sourceURL=arena/tests/arena/adapters/application.jshint.js");

;eval("define(\"arena/tests/arena/app.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena\');\n    test(\'arena/app.js should pass jshint\', function() { \n      ok(true, \'arena/app.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/app.jshint.js");

;eval("define(\"arena/tests/arena/helpers/quake-name.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/helpers\');\n    test(\'arena/helpers/quake-name.js should pass jshint\', function() { \n      ok(true, \'arena/helpers/quake-name.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/helpers/quake-name.jshint.js");

;eval("define(\"arena/tests/arena/models/game.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/models\');\n    test(\'arena/models/game.js should pass jshint\', function() { \n      ok(true, \'arena/models/game.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/models/game.jshint.js");

;eval("define(\"arena/tests/arena/models/player.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/models\');\n    test(\'arena/models/player.js should pass jshint\', function() { \n      ok(true, \'arena/models/player.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/models/player.jshint.js");

;eval("define(\"arena/tests/arena/models/vote.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/models\');\n    test(\'arena/models/vote.js should pass jshint\', function() { \n      ok(true, \'arena/models/vote.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/models/vote.jshint.js");

;eval("define(\"arena/tests/arena/router.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena\');\n    test(\'arena/router.js should pass jshint\', function() { \n      ok(true, \'arena/router.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/router.jshint.js");

;eval("define(\"arena/tests/arena/routes/games.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/routes\');\n    test(\'arena/routes/games.js should pass jshint\', function() { \n      ok(true, \'arena/routes/games.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/routes/games.jshint.js");

;eval("define(\"arena/tests/arena/routes/player.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/routes\');\n    test(\'arena/routes/player.js should pass jshint\', function() { \n      ok(true, \'arena/routes/player.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/routes/player.jshint.js");

;eval("define(\"arena/tests/arena/routes/players.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/routes\');\n    test(\'arena/routes/players.js should pass jshint\', function() { \n      ok(true, \'arena/routes/players.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/routes/players.jshint.js");

;eval("define(\"arena/tests/arena/routes/votes.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/routes\');\n    test(\'arena/routes/votes.js should pass jshint\', function() { \n      ok(true, \'arena/routes/votes.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/routes/votes.jshint.js");

;eval("define(\"arena/tests/arena/serializers/application.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/serializers\');\n    test(\'arena/serializers/application.js should pass jshint\', function() { \n      ok(true, \'arena/serializers/application.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/serializers/application.jshint.js");

;eval("define(\"arena/tests/arena/tests/helpers/resolver.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/helpers\');\n    test(\'arena/tests/helpers/resolver.js should pass jshint\', function() { \n      ok(true, \'arena/tests/helpers/resolver.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/helpers/resolver.jshint.js");

;eval("define(\"arena/tests/arena/tests/helpers/start-app.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/helpers\');\n    test(\'arena/tests/helpers/start-app.js should pass jshint\', function() { \n      ok(true, \'arena/tests/helpers/start-app.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/helpers/start-app.jshint.js");

;eval("define(\"arena/tests/arena/tests/test-helper.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests\');\n    test(\'arena/tests/test-helper.js should pass jshint\', function() { \n      ok(true, \'arena/tests/test-helper.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/test-helper.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/helpers/quake-name-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/helpers\');\n    test(\'arena/tests/unit/helpers/quake-name-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/helpers/quake-name-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/helpers/quake-name-test.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/models/vote-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/models\');\n    test(\'arena/tests/unit/models/vote-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/models/vote-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/models/vote-test.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/routes/player-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/routes\');\n    test(\'arena/tests/unit/routes/player-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/routes/player-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/routes/player-test.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/routes/votes-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/routes\');\n    test(\'arena/tests/unit/routes/votes-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/routes/votes-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/routes/votes-test.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/serializers/applications-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/serializers\');\n    test(\'arena/tests/unit/serializers/applications-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/serializers/applications-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/serializers/applications-test.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/transforms/epoch-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/transforms\');\n    test(\'arena/tests/unit/transforms/epoch-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/transforms/epoch-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/transforms/epoch-test.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/transforms/raw-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/transforms\');\n    test(\'arena/tests/unit/transforms/raw-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/transforms/raw-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/transforms/raw-test.jshint.js");

;eval("define(\"arena/tests/arena/transforms/epoch.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/transforms\');\n    test(\'arena/transforms/epoch.js should pass jshint\', function() { \n      ok(true, \'arena/transforms/epoch.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/transforms/epoch.jshint.js");

;eval("define(\"arena/tests/arena/transforms/raw.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/transforms\');\n    test(\'arena/transforms/raw.js should pass jshint\', function() { \n      ok(true, \'arena/transforms/raw.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/transforms/raw.jshint.js");

;eval("define(\"arena/tests/helpers/resolver\", \n  [\"ember/resolver\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Resolver = __dependency1__[\"default\"];\n\n    var resolver = Resolver.create();\n\n    resolver.namespace = {\n      modulePrefix: \'arena\'\n    };\n\n    __exports__[\"default\"] = resolver;\n  });//# sourceURL=arena/tests/helpers/resolver.js");

;eval("define(\"arena/tests/helpers/start-app\", \n  [\"exports\"],\n  function(__exports__) {\n    \"use strict\";\n    /* global require */\n\n    var Application = require(\'arena/app\')[\'default\'];\n    var Router = require(\'arena/router\')[\'default\'];\n\n    __exports__[\"default\"] = function startApp(attrs) {\n      var App;\n\n      var attributes = Ember.merge({\n        // useful Test defaults\n        rootElement: \'#ember-testing\',\n        LOG_ACTIVE_GENERATION:false,\n        LOG_VIEW_LOOKUPS: false\n      }, attrs); // but you can override;\n\n      Router.reopen({\n        location: \'none\'\n      });\n\n      Ember.run(function(){\n        App = Application.create(attributes);\n        App.setupForTesting();\n        App.injectTestHelpers();\n      });\n\n      App.reset(); // this shouldn\'t be needed, i want to be able to \"start an app at a specific URL\"\n\n      return App;\n    }\n  });//# sourceURL=arena/tests/helpers/start-app.js");

;eval("define(\"arena/tests/test-helper\", \n  [\"arena/tests/helpers/resolver\",\"ember-qunit\"],\n  function(__dependency1__, __dependency2__) {\n    \"use strict\";\n    var resolver = __dependency1__[\"default\"];\n    var setResolver = __dependency2__.setResolver;\n\n    setResolver(resolver);\n\n    document.write(\'<div id=\"ember-testing-container\"><div id=\"ember-testing\"></div></div>\');\n  });//# sourceURL=arena/tests/test-helper.js");

;eval("define(\"arena/tests/unit/helpers/quake-name-test\", \n  [\"ember-qunit\",\"arena/helpers/quake-name\"],\n  function(__dependency1__, __dependency2__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleFor = __dependency1__.moduleFor;\n\n    var quakeName = __dependency2__[\"default\"];\n\n    test(\'quake name should be converted to colored html\', function() {\n        equal(quakeName.helper(\'colors^11^22^33^44^55^66^77^0w00t\'), \'<span class=\"quake-color-0\">colors</span><span class=\"quake-color-1\">1</span><span class=\"quake-color-2\">2</span><span class=\"quake-color-3\">3</span><span class=\"quake-color-4\">4</span><span class=\"quake-color-5\">5</span><span class=\"quake-color-6\">6</span><span class=\"quake-color-7\">7</span><span class=\"quake-color-0\">w00t</span>\');\n    });\n  });//# sourceURL=arena/tests/unit/helpers/quake-name-test.js");

;eval("define(\"arena/tests/unit/models/vote-test\", \n  [\"ember-qunit\"],\n  function(__dependency1__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleForModel = __dependency1__.moduleForModel;\n\n    moduleForModel(\'vote\', \'Vote\', {\n      // Specify the other units that are required for this test.\n      needs: []\n    });\n\n    test(\'it exists\', function() {\n      var model = this.subject();\n      // var store = this.store();\n      ok(model);\n    });\n  });//# sourceURL=arena/tests/unit/models/vote-test.js");

;eval("define(\"arena/tests/unit/routes/player-test\", \n  [\"ember-qunit\"],\n  function(__dependency1__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleFor = __dependency1__.moduleFor;\n\n    moduleFor(\'route:player\', \'PlayerRoute\', {\n      // Specify the other units that are required for this test.\n      // needs: [\'controller:foo\']\n    });\n\n    test(\'it exists\', function() {\n      var route = this.subject();\n      ok(route);\n    });\n  });//# sourceURL=arena/tests/unit/routes/player-test.js");

;eval("define(\"arena/tests/unit/routes/votes-test\", \n  [\"ember-qunit\"],\n  function(__dependency1__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleFor = __dependency1__.moduleFor;\n\n    moduleFor(\'route:votes\', \'VotesRoute\', {\n      // Specify the other units that are required for this test.\n      // needs: [\'controller:foo\']\n    });\n\n    test(\'it exists\', function() {\n      var route = this.subject();\n      ok(route);\n    });\n  });//# sourceURL=arena/tests/unit/routes/votes-test.js");

;eval("define(\"arena/tests/unit/serializers/applications-test\", \n  [\"ember-qunit\"],\n  function(__dependency1__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleFor = __dependency1__.moduleFor;\n\n    moduleFor(\'serializer:application\', \'ApplicationSerializer\', {\n      // Specify the other units that are required for this test.\n      // needs: [\'adapter:foo\']\n    });\n\n    // Replace this with your real tests.\n    test(\'it exists\', function() {\n      var adapter = this.subject();\n      ok(adapter);\n    });\n  });//# sourceURL=arena/tests/unit/serializers/applications-test.js");

;eval("define(\"arena/tests/unit/transforms/epoch-test\", \n  [\"ember-qunit\"],\n  function(__dependency1__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleFor = __dependency1__.moduleFor;\n\n    moduleFor(\'transform:epoch\', \'EpochTransform\', {\n      // Specify the other units that are required for this test.\n      // needs: [\'serializer:foo\']\n    });\n\n    test(\'converts python epoch to date\', function() {\n      var transform = this.subject();\n\n      var epoch = \'1403268702.480765\';\n\n      var date = moment.unix(epoch).toDate();\n\n      deepEqual(transform.deserialize(epoch), date, \'Epoch should deserialize to Date\');\n    });\n  });//# sourceURL=arena/tests/unit/transforms/epoch-test.js");

;eval("define(\"arena/tests/unit/transforms/raw-test\", \n  [\"ember-qunit\"],\n  function(__dependency1__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleFor = __dependency1__.moduleFor;\n\n    moduleFor(\'transform:raw\', \'RawTransform\', {\n      // Specify the other units that are required for this test.\n      // needs: [\'serializer:foo\']\n    });\n\n    // Replace this with your real tests.\n    test(\'it exists\', function() {\n      var transform = this.subject();\n      ok(transform);\n    });\n  });//# sourceURL=arena/tests/unit/transforms/raw-test.js");

;eval("define(\"arena/transforms/epoch\", \n  [\"ember-data\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var DS = __dependency1__[\"default\"];\n\n    __exports__[\"default\"] = DS.Transform.extend({\n      deserialize: function(serialized) {\n        if (serialized){\n            return moment.unix(serialized).toDate();\n        } else {\n            return null;\n        }\n      },\n\n      serialize: function(deserialized) {\n        return moment(deserialized).format(\'X.SS\');\n      }\n    });\n  });//# sourceURL=arena/transforms/epoch.js");

;eval("define(\"arena/transforms/raw\", \n  [\"ember-data\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var DS = __dependency1__[\"default\"];\n\n    __exports__[\"default\"] = DS.Transform.extend({\n      deserialize: function(serialized) {\n        return serialized;\n      },\n\n      serialize: function(deserialized) {\n        return deserialized;\n      }\n    });\n  });//# sourceURL=arena/transforms/raw.js");
