'''
exceptions.py: exceptions defined by commonpy

Authors
-------

Michael Hucka <mhucka@caltech.edu> -- Caltech Library

Copyright
---------

Copyright (c) 2020 by the California Institute of Technology.  This code is
open-source software released under a 3-clause BSD license.  Please see the
file "LICENSE" for more information.
'''


# Base class.
# .............................................................................
# The base class makes it possible to use a single test to distinguish
# between exceptions generated by Commonpy code and exceptions generated by
# something else.

class CommonpyException(Exception):
    '''Base class for Commonpy exceptions.'''
    pass


# Exception classes.
# .............................................................................

class Interrupted(CommonpyException):
    '''The user elected to cancel/quit the program.'''
    pass

class NetworkFailure(CommonpyException):
    '''Unrecoverable problem involving network operations.'''
    pass

class ServiceFailure(CommonpyException):
    '''Unrecoverable problem involving a remote service.'''
    pass

class AuthenticationFailure(CommonpyException):
    '''Problem obtaining or using authentication credentials.'''
    pass

class NoContent(CommonpyException):
    '''No content found at the given location.'''
    pass

class RateLimitExceeded(CommonpyException):
    '''The service flagged reports that its rate limits have been exceeded.'''
    pass

class InternalError(CommonpyException):
    '''Unrecoverable problem involving commonpy itself.'''
    pass
