# -*- coding: utf-8 -*-
"""Cisco Identity Services Engine SelfRegisteredPortal API wrapper.

Copyright (c) 2021 Cisco and/or its affiliates.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
"""


from __future__ import absolute_import, division, print_function, unicode_literals

from builtins import *

from past.builtins import basestring

from ...pagination import get_next_page
from ...restsession import RestSession
from ...utils import (
    apply_path_params,
    check_type,
    dict_from_items_with_values,
    dict_of_str,
)


class SelfRegisteredPortal(object):
    """Identity Services Engine SelfRegisteredPortal API (version: 3.1.0).

    Wraps the Identity Services Engine SelfRegisteredPortal
    API and exposes the API as native Python
    methods that return native Python objects.

    | Self Registered Guest Portal API provides the ability to create, read, update, delete and search self registered portals.

    **Revision History**

    +----------------+----------------------+-----------------------+---------------------------+
    | **Revision #** | **Resource Version** | **Cisco ISE Version** | **Description**           |
    +----------------+----------------------+-----------------------+---------------------------+
    | 0              | 1.0                  | 2.2                   | Initial Cisco ISE Version |
    +----------------+----------------------+-----------------------+---------------------------+

    |

    **Resource Definition**

    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    | **Attribute**                             | **Type**  | **Required** | **Description**                                                                                                                                                                                                                                                                                                                                                                                                           | **Default Values**      | **Example Values**                                                                                                            |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    | name                                      | String    | Yes          | Resource Name                                                                                                                                                                                                                                                                                                                                                                                                             |                         | Self-Registered Guest Portal (default)                                                                                        |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    | id                                        | String    | No           | Resource UUID, mandatory for update                                                                                                                                                                                                                                                                                                                                                                                       |                         | 4e8ade36-4048-472a-b345-632cc155acfc                                                                                          |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    | description                               | String    | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         | Guests may create their own accounts and be assigned a username and password, or use their social login to access the network |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    | portalTestUrl                             | String    | No           | URL to bring up a test page for this portal                                                                                                                                                                                                                                                                                                                                                                               |                         | https://{ise-ip}:8443/portal/PortalSetup.action?portal=4e8ade36-4048-472a-b345-632cc155acfc                                   |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    | portalType                                | Enum      | Yes          | Allowed values: BYOD, HOTSPOTGUEST, MYDEVICE, SELFREGGUEST, SPONSOR, SPONSOREDGUEST                                                                                                                                                                                                                                                                                                                                       | SELFREGGUEST            |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    | settings                                  | List      | No           | Defines all of the settings groups available for a portal                                                                                                                                                                                                                                                                                                                                                                 |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    | - portalSettings                          | List      | No           | The port, interface, certificate, and other basic settings of a portal                                                                                                                                                                                                                                                                                                                                                    |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - httpsPort                             | Integer   | Yes          | The port number that the allowed interfaces will listen on. Range from 8000 to 8999                                                                                                                                                                                                                                                                                                                                       |                         | 8443                                                                                                                          |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - allowedInterfaces                     | Enum      | Yes          | Interfaces that the portal will be reachable on.                                                                                                                                                                                                                                                                                                                                                                          |                         | [ "eth0", "bond0" ]                                                                                                           |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - certificateGroupTag                   | String    | Yes          | Logical name of the x.509 server certificate that will be used for the portal                                                                                                                                                                                                                                                                                                                                             |                         | Default Portal Certificate Group                                                                                              |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - authenticationMethod                  | String    | Yes          | Unique Id of the identity source sequence                                                                                                                                                                                                                                                                                                                                                                                 |                         | 92e50f80-8c01-11e6-996c-525400b48521                                                                                          |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - assignedGuestTypeForEmployee          | String    | Yes          | Unique Id of a guest type. Employees using this portal as a guest inherit login options from the guest type                                                                                                                                                                                                                                                                                                               |                         | Contractor (default)                                                                                                          |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - displayLang                           | Enum      | No           | Allowed values: USEBROWSERLOCALE, ALWAYSUSE                                                                                                                                                                                                                                                                                                                                                                               |                         | USEBROWSERLOCALE                                                                                                              |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - fallbackLanguage                      | String    | No           | Used when displayLang = USEBROWSERLOCALE                                                                                                                                                                                                                                                                                                                                                                                  |                         | English                                                                                                                       |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - alwaysUsedLanguage                    | String    | No           | Used when displayLang = ALWAYSUSE                                                                                                                                                                                                                                                                                                                                                                                         |                         | English                                                                                                                       |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    | - loginPageSettings                       | List      | No           | Portal Login Page settings groups follow                                                                                                                                                                                                                                                                                                                                                                                  |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - maxFailedAttemptsBeforeRateLimit      | Integer   | No           | Maximum failed login attempts before rate limiting                                                                                                                                                                                                                                                                                                                                                                        | 5                       |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - timeBetweenLoginsDuringRateLimit      | Integer   | No           | Time between login attempts when rate limiting                                                                                                                                                                                                                                                                                                                                                                            | 2                       |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - includeAup                            | Boolean   | No           | Include an Acceptable Use Policy (AUP) that should be displayed during login                                                                                                                                                                                                                                                                                                                                              | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - aupDisplay                            | Enum      | No           | How the AUP should be displayed, either on page or as a link. Only valid if includeAup = true.                                                                                                                                                                                                                                                                                                                            | ASLINK                  |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - requireAupAcceptance                  | Boolean   | No           | Require the portal user to accept the AUP. Only valid if includeAup = true                                                                                                                                                                                                                                                                                                                                                | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - requireAccessCode                     | Boolean   | No           | Require the portal user to enter an access code                                                                                                                                                                                                                                                                                                                                                                           | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - accessCode                            | String    | No           | Access code that must be entered by the portal user (only valid if requireAccessCode = true)                                                                                                                                                                                                                                                                                                                              |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - allowGuestToCreateAccounts            | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - allowGuestToChangePassword            | Boolean   | No           | Require the portal user to enter an access code                                                                                                                                                                                                                                                                                                                                                                           | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - allowAlternateGuestPortal             | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         | false                                                                                                                         |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - alternateGuestPortal                  | String    | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    | - selfRegPageSettings                     | List      | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - assignGuestsToGuestType               | String    | No           | Guests are assigned to this guest type                                                                                                                                                                                                                                                                                                                                                                                    |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - accountValidityDuration               | Integer   | No           | Self-registered guest account is valid for this many account_validity_time_units                                                                                                                                                                                                                                                                                                                                          | 1                       |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - accountValidityTimeUnits              | Enum      | No           | Time units for account_validity_duration.                                                                                                                                                                                                                                                                                                                                                                                 | DAYS                    |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - requireRegistrationCode               | Boolean   | No           | Self-registered guests are required to enter a registration code                                                                                                                                                                                                                                                                                                                                                          | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - registrationCode                      | String    | No           | The registration code that the guest user must enter                                                                                                                                                                                                                                                                                                                                                                      |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - fieldUserName                         | List      | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - include                             | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         | true                                                                                                                          |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - require                             | Boolean   | No           | Only applicable if include = true                                                                                                                                                                                                                                                                                                                                                                                         |                         | false                                                                                                                         |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - fieldFirstName                        | List      | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - include                             | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         | true                                                                                                                          |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - require                             | Boolean   | No           | Only applicable if include = true                                                                                                                                                                                                                                                                                                                                                                                         |                         | false                                                                                                                         |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - fieldLastName                         | List      | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - include                             | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         | true                                                                                                                          |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - require                             | Boolean   | No           | Only applicable if include = true                                                                                                                                                                                                                                                                                                                                                                                         |                         | false                                                                                                                         |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - fieldEmailAddr                        | List      | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - include                             | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         | true                                                                                                                          |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - require                             | Boolean   | No           | Only applicable if include = true                                                                                                                                                                                                                                                                                                                                                                                         |                         | false                                                                                                                         |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - fieldPhoneNo                          | List      | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - include                             | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         | true                                                                                                                          |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - require                             | Boolean   | No           | Only applicable if include = true                                                                                                                                                                                                                                                                                                                                                                                         |                         | false                                                                                                                         |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - fieldCompany                          | List      | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - include                             | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         | true                                                                                                                          |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - require                             | Boolean   | No           | Only applicable if include = true                                                                                                                                                                                                                                                                                                                                                                                         |                         | false                                                                                                                         |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - fieldLocation                         | List      | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - include                             | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         | true                                                                                                                          |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - require                             | Boolean   | No           | Only applicable if include = true                                                                                                                                                                                                                                                                                                                                                                                         |                         | false                                                                                                                         |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - selectableLocations                   | List      | No           | Guests can choose from these locations to set their time zone                                                                                                                                                                                                                                                                                                                                                             |                         | ["San Jose"]                                                                                                                  |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - fieldSmsProvider                      | List      | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - include                             | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         | true                                                                                                                          |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - require                             | Boolean   | No           | Only applicable if include = true                                                                                                                                                                                                                                                                                                                                                                                         |                         | false                                                                                                                         |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - selectableSmsProviders                | List      | No           | This attribute is an array of SMS provider names                                                                                                                                                                                                                                                                                                                                                                          |                         | ["Global Default"]                                                                                                            |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - fieldPersonBeingVisited               | List      | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - include                             | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         | true                                                                                                                          |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - require                             | Boolean   | No           | Only applicable if include = true                                                                                                                                                                                                                                                                                                                                                                                         |                         | false                                                                                                                         |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - fieldReasonForVisit                   | List      | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - include                             | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         | true                                                                                                                          |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - require                             | Boolean   | No           | Only applicable if include = true                                                                                                                                                                                                                                                                                                                                                                                         |                         | false                                                                                                                         |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - includeAup                            | Boolean   | No           | Include an Acceptable Use Policy (AUP) that should be displayed during login                                                                                                                                                                                                                                                                                                                                              | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - aupDisplay                            | Enum      | No           | How the AUP should be displayed, either on page or as a link. Only valid if includeAup = true.                                                                                                                                                                                                                                                                                                                            | ASLINK                  |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - requireAupAcceptance                  | Boolean   | No           | Require the portal user to accept the AUP. Only valid if includeAup = true                                                                                                                                                                                                                                                                                                                                                | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - enableGuestEmailWhitelist             | Boolean   | No           | Allow guests with an e-mail address from selected domains                                                                                                                                                                                                                                                                                                                                                                 | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - guestEmailWhitelistDomains            | List      | No           | Self-registered guests whose e-mail address is in one of these domains will be allowed. Only valid if enableGuestEmailWhitelist = true                                                                                                                                                                                                                                                                                    |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - enableGuestEmailBlacklist             | Boolean   | No           | Disallow guests with an e-mail address from selected domains                                                                                                                                                                                                                                                                                                                                                              | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - guestEmailBlacklistDomains            | List      | No           | Self-registered guests whose e-mail address is in one of these domains will be disallowed. Only valid if enableGuestEmailBlacklist = true                                                                                                                                                                                                                                                                                 |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - requireGuestApproval                  | Boolean   | No           | Require self-registered guests to be approved if true                                                                                                                                                                                                                                                                                                                                                                     | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - autoLoginSelfWait                     | Boolean   | No           | Allow guests to login automatically from self-registration after sponsor's approval. No need to provide the credentials by guest to login                                                                                                                                                                                                                                                                                 | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - autoLoginTimePeriod                   | Integer   | No           | Waiting period for auto login until sponsor's approval. If time exceeds, guest has to login manually by providing the credentials. Default value is 5 minutes                                                                                                                                                                                                                                                             | 5                       |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - sendApprovalRequestTo                 | Enum      | No           | Specifies where approval requests are sent. Only valid if requireGuestApproval = true.                                                                                                                                                                                                                                                                                                                                    | SELECTEDEMAILADDRESSES  |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - approvalEmailAddresses                | String    | No           | Only valid if requireGuestApproval = true and sendApprovalRequestTo = SELECTEDEMAILADDRESSES                                                                                                                                                                                                                                                                                                                              |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - postRegistrationRedirect              | Enum      | No           | After the registration submission direct the guest user to one of the following pages. Only valid if requireGuestApproval = true.                                                                                                                                                                                                                                                                                         | SELFREGISTRATIONSUCCESS |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - postRegistrationRedirectUrl           | String    | No           | URL where guest user is redirected after registration. Only valid if requireGuestApproval = true and postRegistrationRedirect = URL                                                                                                                                                                                                                                                                                       |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - credentialNotificationUsingEmail      | Boolean   | No           | If true, send credential notification upon approval using email. Only valid if requireGuestApproval = true                                                                                                                                                                                                                                                                                                                | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - credentialNotificationUsingSms        | Boolean   | No           | If true, send credential notification upon approval using SMS. Only valid if requireGuestApproval = true                                                                                                                                                                                                                                                                                                                  | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - approveDenyLinksValidFor              | Integer   | No           | This attribute, along with approveDenyLinksTimeUnits, specifies how long the link can be used. Only valid if requireGuestApproval = true                                                                                                                                                                                                                                                                                  | 1440                    |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - approveDenyLinksTimeUnits             | Enum      | No           | This attribute, along with approveDenyLinksValidFor, specifies how long the link can be used. Only valid if requireGuestApproval = true.                                                                                                                                                                                                                                                                                  | DAYS                    |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - requireApproverToAuthenticate         | Boolean   | No           | When self-registered guests require approval, an approval request is e-mailed to one or more sponsor users. If the Cisco ISE Administrator chooses to include an approval link in the e-mail, a sponsor user who clicks the link will be required to enter their username and password if this attribute is true. Only valid if requireGuestApproval = true                                                               | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - sponsorPortalList                     | List      | No           | When self-registered guests require approval, an approval request is e-mailed to one or more sponsor users. If the Cisco ISE Administrator chooses to include an approval link in the e-mail, a sponsor user who clicks the link will be authenticated against the selected sponsor portals in the order specified. Only valid if requireGuestApproval = true. The array should contain the names of the selected portals |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    | - selfRegSuccessSettings                  | List      | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - includeUserName                       | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | true                    |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - includePassword                       | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | true                    |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - includeFirstName                      | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | true                    |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - includeLastName                       | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | true                    |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - includeEmailAddr                      | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | true                    |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - includePhoneNo                        | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | true                    |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - includeCompany                        | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | true                    |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - includeLocation                       | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | true                    |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - includeSmsProvider                    | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | true                    |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - includePersonBeingVisited             | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | true                    |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - includeReasonForVisit                 | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | true                    |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - allowGuestSendSelfUsingPrint          | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - allowGuestSendSelfUsingEmail          | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - allowGuestSendSelfUsingSms            | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - includeAup                            | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - aupOnPage                             | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - requireAupAcceptance                  | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - requireAupScrolling                   | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - allowGuestLoginFromSelfregSuccessPage | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    | - aupSettings                             | List      | No           | Configuration of the Acceptable Use Policy (AUP) for a portal                                                                                                                                                                                                                                                                                                                                                             |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - displayFrequency                      | Enum      | No           | How the AUP should be displayed, either on page or as a link. Only valid if includeAup = true.                                                                                                                                                                                                                                                                                                                            | FIRSTLOGIN              |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - includeAup                            | Boolean   | No           | Require the portal user to read and accept an AUP                                                                                                                                                                                                                                                                                                                                                                         | true                    |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - requireAupScrolling                   | Boolean   | No           | Require the portal user to scroll to the end of the AUP. Only valid if requireAupAcceptance = true                                                                                                                                                                                                                                                                                                                        | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - useDiffAupForEmployees                | Boolean   | No           | Only valid if requireAupAcceptance = trueG                                                                                                                                                                                                                                                                                                                                                                                | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - skipAupForEmployees                   | Boolean   | No           | Only valid if requireAupAcceptance = true                                                                                                                                                                                                                                                                                                                                                                                 | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - displayFrequencyIntervalDays          | Integer   | No           | Number of days between AUP confirmations (when displayFrequency = recurring)                                                                                                                                                                                                                                                                                                                                              | 7                       |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    | - GuestChangePasswordSettings             | List      | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - allowChangePasswdAtFirstLogin         | Boolean   | No           | Allow guest to change their own passwords                                                                                                                                                                                                                                                                                                                                                                                 | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    | - guestDeviceRegistrationSettings         | List      | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - autoRegisterGuestDevices              | Boolean   | No           | Automatically register guest devices                                                                                                                                                                                                                                                                                                                                                                                      | true                    |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - allowGuestsToRegisterDevices          | Boolean   | No           | Allow guests to register devices                                                                                                                                                                                                                                                                                                                                                                                          | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    | - byodSettings                            | List      | No           | Configuration of BYOD Device Welcome, Registration and Success steps                                                                                                                                                                                                                                                                                                                                                      |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - byodWelcomeSettings                   | List      | No           | Configuration of BYOD endpoint welcome step configuration                                                                                                                                                                                                                                                                                                                                                                 |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - enableBYOD                          | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | true                    |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - enableGuestAccess                   | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - requireMDM                          | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - includeAup                          | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | true                    |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - aupDisplay                          | Enum      | No           | How the AUP should be displayed, either on page or as a link. Only valid if includeAup = true.                                                                                                                                                                                                                                                                                                                            | ONPAGE                  |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - requireAupAcceptance                | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - requireScrolling                    | Boolean   | No           | Require BYOD devices to scroll down to the bottom of the AUP, Only valid if includeAup = true                                                                                                                                                                                                                                                                                                                             | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - byodRegistrationSettings              | List      | No           | Configuration of BYOD endpoint Registration step configuration                                                                                                                                                                                                                                                                                                                                                            |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - showDeviceID                        | Boolean   | No           | Display Device ID field during registration                                                                                                                                                                                                                                                                                                                                                                               | true                    |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - endPointIdentityGroupId             | String    | No           | Identity group id for which endpoint belongs                                                                                                                                                                                                                                                                                                                                                                              |                         | aa13bb40-8bff-11e6-996c-525400b48521                                                                                          |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - byodRegistrationSuccessSettings       | List      | No           | Configuration of BYOD endpoint Registration Success step configuration                                                                                                                                                                                                                                                                                                                                                    |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - successRedirect                     | Enum      | No           | After an Authentication Success where should device be redirected.                                                                                                                                                                                                                                                                                                                                                        | AUTHSUCCESSPAGE         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - redirectUrl                         | String    | No           | Target URL for redirection, used when successRedirect = URL                                                                                                                                                                                                                                                                                                                                                               |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    | - authSuccessSettings                     | List      | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - successRedirect                       | Enum      | No           | After an Authentication Success where should device be redirected.                                                                                                                                                                                                                                                                                                                                                        | AUTHSUCCESSPAGE         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - redirectUrl                           | String    | No           | Target URL for redirection, used when successRedirect = URL                                                                                                                                                                                                                                                                                                                                                               |                         | www.cisco.com                                                                                                                 |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    | - postLoginBannerSettings                 | List      | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - includePostAccessBanner               | Boolean   | No           | Include a Post-Login Banner page                                                                                                                                                                                                                                                                                                                                                                                          | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    | - supportInfoSettings                     | List      | No           | Portal Support Information Settings                                                                                                                                                                                                                                                                                                                                                                                       |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - includeSupportInfoPage                | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - includeMacAddr                        | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - includeIpAddress                      | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - includeBrowserUserAgent               | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - includePolicyServer                   | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - includeFailureCode                    | Boolean   | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           | false                   |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - emptyFieldDisplay                     | Enum      | No           | Specifies how empty fields are handled on the Support Information Page.                                                                                                                                                                                                                                                                                                                                                   |                         | HIDE                                                                                                                          |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - defaultEmptyFieldValue                | String    | No           | The default value displayed for an empty field Only valid when emptyFieldDisplay = DISPLAYWITHDEFAULTVALUE                                                                                                                                                                                                                                                                                                                |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    | customizations                            | List      | No           | Defines all of the Portal Customizations available                                                                                                                                                                                                                                                                                                                                                                        |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    | - portalTheme                             | List      | No           | Defines the configuration for portal theme                                                                                                                                                                                                                                                                                                                                                                                |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - id                                    | String    | No           | The unique internal identifier of the portal theme                                                                                                                                                                                                                                                                                                                                                                        |                         | 9eb421c0-8c01-11e6-996c-525400b48521                                                                                          |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - name                                  | String    | Yes          | The system- or user-assigned name of the portal theme                                                                                                                                                                                                                                                                                                                                                                     |                         | Default Blue theme                                                                                                            |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - themeData                             | String    | No           | A CSS file, represented as a Base64-encoded byte array                                                                                                                                                                                                                                                                                                                                                                    |                         | Base 64 encoded string of Theme CSS file                                                                                      |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    | - portalTweakSettings                     | List      | No           | The Tweak Settings are a customization of the Portal Theme that has been selected for the portal. When the Portal Theme selection is changed, the Tweak Settings are overwritten to match the values in the theme. The Tweak Settings can subsequently be changed by the user                                                                                                                                             |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - bannerColor                           | String    | No           | Hex value of color                                                                                                                                                                                                                                                                                                                                                                                                        |                         | #0000FF                                                                                                                       |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - bannerTextColor                       | String    | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         | Banner Text color code from GUI                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - pageBackgroundColor                   | String    | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         | Color code from GUI                                                                                                           |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - pageLabelAndTextColor                 | String    | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         | Label and Text color from GUI                                                                                                 |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    | - language                                | List      | No           | This property is supported only for Read operation and it allows to show the customizations in English. Other languages are not supported                                                                                                                                                                                                                                                                                 |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - viewLanguage                          | String    | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         | English                                                                                                                       |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    | - globalCustomizations                    | List      | No           | Represent the portal Global customizations                                                                                                                                                                                                                                                                                                                                                                                |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - bannerTitle                           | String    | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         | Guest Portal                                                                                                                  |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - contactText                           | String    | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         | Contact Support                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - footerElement                         | String    | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         | Footer Element                                                                                                                |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - mobileLogoImage                       | Image     | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - data                                | String    | No           | Represented as base 64 encoded string of the image byte array                                                                                                                                                                                                                                                                                                                                                             |                         | base 64 encoded value of image                                                                                                |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - desktopLogoImage                      | Image     | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - data                                | String    | No           | Represented as base 64 encoded string of the image byte array                                                                                                                                                                                                                                                                                                                                                             |                         | base 64 encoded value of image                                                                                                |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - bannerImage                           | Image     | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - data                                | String    | No           | Represented as base 64 encoded string of the image byte array                                                                                                                                                                                                                                                                                                                                                             |                         | base 64 encoded value of image                                                                                                |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - backgroundImage                       | Image     | No           |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - data                                | String    | No           | Represented as base 64 encoded string of the image byte array                                                                                                                                                                                                                                                                                                                                                             |                         | base 64 encoded value of image                                                                                                |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    | - pageCustomizations                      | List      | No           | Represent the entire page customization as a giant dictionary                                                                                                                                                                                                                                                                                                                                                             |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |   - data                                  | List      | No           | The Dictionary will be exposed here as key value pair                                                                                                                                                                                                                                                                                                                                                                     |                         |                                                                                                                               |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - key                                 | String    | Yes          |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         | ui_contact_ip_address_label                                                                                                   |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+
    |     - value                               | String    | Yes          |                                                                                                                                                                                                                                                                                                                                                                                                                           |                         | SVAgYWRkcmVzczo=                                                                                                              |
    +-------------------------------------------+-----------+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+-------------------------+-------------------------------------------------------------------------------------------------------------------------------+

    """

    def __init__(self, session, object_factory, request_validator):
        """Initialize a new SelfRegisteredPortal
        object with the provided RestSession.

        Args:
            session(RestSession): The RESTful session object to be used for
                API calls to the Identity Services Engine service.

        Raises:
            TypeError: If the parameter types are incorrect.

        """
        check_type(session, RestSession)

        super(SelfRegisteredPortal, self).__init__()

        self._session = session
        self._object_factory = object_factory
        self._request_validator = request_validator

    def get_self_registered_portal_by_id(self,
                                         id,
                                         headers=None,
                                         **query_parameters):
        """This API allows the client to get a self registered portal by
        ID.

        Args:
            id(basestring): id path parameter.
            headers(dict): Dictionary of HTTP Headers to send with the Request
                .
            **query_parameters: Additional query parameters (provides
                support for parameters that may be added in the future).

        Returns:

            RestResponse: REST response with following properties:

              - headers(MyDict): response headers.
              - response(MyDict): response body as a MyDict object. Access the object's properties by using the dot notation
                or the bracket notation.
              - content(bytes): representation of the request's response
              - text(str): representation of the request's response

        Raises:
            TypeError: If the parameter types are incorrect.
            MalformedRequest: If the request body created is invalid.
            ApiError: If the Identity Services Engine cloud returns an error.
        """
        check_type(headers, dict)

        if headers is not None:
            if 'Content-Type' in headers:
                check_type(headers.get('Content-Type'),
                           basestring, may_be_none=False)
            if 'Accept' in headers:
                check_type(headers.get('Accept'),
                           basestring, may_be_none=False)
            if 'ERS-Media-Type' in headers:
                check_type(headers.get('ERS-Media-Type'),
                           basestring)
            if 'X-CSRF-Token' in headers:
                check_type(headers.get('X-CSRF-Token'),
                           basestring)

        with_custom_headers = False
        _headers = self._session.headers or {}
        if headers:
            _headers.update(dict_of_str(headers))
            with_custom_headers = True
        check_type(id, basestring,
                   may_be_none=False)

        _params = {
        }
        _params.update(query_parameters)
        _params = dict_from_items_with_values(_params)

        path_params = {
            'id': id,
        }

        e_url = ('/ers/config/selfregportal/{id}')
        endpoint_full_url = apply_path_params(e_url, path_params)
        if with_custom_headers:
            _api_response = self._session.get(endpoint_full_url, params=_params,
                                              headers=_headers)
        else:
            _api_response = self._session.get(endpoint_full_url, params=_params)

        return self._object_factory('bpm_f9c9a5e917af53dbbb91733e82e72ebe_v3_1_0', _api_response)

    def get_by_id(self,
                  id,
                  headers=None,
                  **query_parameters):
        """Alias for `get_self_registered_portal_by_id <#ciscoisesdk.
        api.v3_1_0.self_registered_portal.
        SelfRegisteredPortal.get_self_registered_portal_by_id>`_
        """
        return self.get_self_registered_portal_by_id(
            id=id,
            headers=headers,
            **query_parameters
        )

    def update_self_registered_portal_by_id(self,
                                            id,
                                            customizations=None,
                                            description=None,
                                            name=None,
                                            portal_test_url=None,
                                            portal_type=None,
                                            settings=None,
                                            headers=None,
                                            payload=None,
                                            active_validation=True,
                                            **query_parameters):
        """This API allows the client to update a self registered portal by
        ID.

        Args:
            customizations(object): Defines all of the Portal
                Customizations available, property of
                the request body.
            description(string): description, property of the
                request body.
            id(string): id, property of the request body.
            name(string): name, property of the request body.
            portal_test_url(string): URL to bring up a test page for
                this portal, property of the request
                body.
            portal_type(string): Allowed values: BYOD, HOTSPOTGUEST,
                MYDEVICE, SELFREGGUEST, SPONSOR,
                SPONSOREDGUEST, property of the request
                body.
            settings(object): Defines all of the settings groups
                available for a portal, property of the
                request body.
            id(basestring): id path parameter.
            headers(dict): Dictionary of HTTP Headers to send with the Request
                .
            payload(dict): A JSON serializable Python object to send in the
                body of the Request.
            active_validation(bool): Enable/Disable payload validation.
                Defaults to True.
            **query_parameters: Additional query parameters (provides
                support for parameters that may be added in the future).

        Returns:

            RestResponse: REST response with following properties:

              - headers(MyDict): response headers.
              - response(MyDict): response body as a MyDict object. Access the object's properties by using the dot notation
                or the bracket notation.
              - content(bytes): representation of the request's response
              - text(str): representation of the request's response

        Raises:
            TypeError: If the parameter types are incorrect.
            MalformedRequest: If the request body created is invalid.
            ApiError: If the Identity Services Engine cloud returns an error.
        """
        check_type(headers, dict)

        if headers is not None:
            if 'Content-Type' in headers:
                check_type(headers.get('Content-Type'),
                           basestring, may_be_none=False)
            if 'Accept' in headers:
                check_type(headers.get('Accept'),
                           basestring, may_be_none=False)
            if 'ERS-Media-Type' in headers:
                check_type(headers.get('ERS-Media-Type'),
                           basestring)
            if 'X-CSRF-Token' in headers:
                check_type(headers.get('X-CSRF-Token'),
                           basestring)

        with_custom_headers = False
        _headers = self._session.headers or {}
        if headers:
            _headers.update(dict_of_str(headers))
            with_custom_headers = True
        is_xml_payload = 'application/xml' in _headers.get('Content-Type', [])
        if active_validation and is_xml_payload:
            check_type(payload, basestring)
        if active_validation and not is_xml_payload:
            check_type(payload, dict)
        check_type(id, basestring,
                   may_be_none=False)

        _params = {
        }
        _params.update(query_parameters)
        _params = dict_from_items_with_values(_params)

        path_params = {
            'id': id,
        }
        if is_xml_payload:
            _payload = payload
        else:
            _tmp_payload = {
                'id':
                    id,
                'name':
                    name,
                'description':
                    description,
                'portalType':
                    portal_type,
                'portalTestUrl':
                    portal_test_url,
                'settings':
                    settings,
                'customizations':
                    customizations,
            }
            _payload = {
                'SelfRegPortal': dict_from_items_with_values(_tmp_payload)
            }
            _payload.update(payload or {})
            _payload = dict_from_items_with_values(_payload)
        if active_validation and not is_xml_payload:
            self._request_validator('jsd_c4fada6c558d9aba09cc373d5b266_v3_1_0')\
                .validate(_payload)

        e_url = ('/ers/config/selfregportal/{id}')
        endpoint_full_url = apply_path_params(e_url, path_params)

        request_params = {'data': _payload} if is_xml_payload else {'json': _payload}
        if with_custom_headers:
            _api_response = self._session.put(endpoint_full_url, params=_params,
                                              headers=_headers,
                                              **request_params)

        else:
            _api_response = self._session.put(endpoint_full_url, params=_params,
                                              **request_params)

        return self._object_factory('bpm_c4fada6c558d9aba09cc373d5b266_v3_1_0', _api_response)

    def update_by_id(self,
                     id,
                     customizations=None,
                     description=None,
                     name=None,
                     portal_test_url=None,
                     portal_type=None,
                     settings=None,
                     headers=None,
                     payload=None,
                     active_validation=True,
                     **query_parameters):
        """Alias for `update_self_registered_portal_by_id <#ciscoisesdk.
        api.v3_1_0.self_registered_portal.
        SelfRegisteredPortal.update_self_registered_portal_by_id>`_
        """
        return self.update_self_registered_portal_by_id(
            id=id,
            customizations=customizations,
            description=description,
            name=name,
            portal_test_url=portal_test_url,
            portal_type=portal_type,
            settings=settings,
            payload=payload,
            active_validation=active_validation,
            headers=headers,
            **query_parameters
        )

    def delete_self_registered_portal_by_id(self,
                                            id,
                                            headers=None,
                                            **query_parameters):
        """This API deletes a self registered portal by ID.

        Args:
            id(basestring): id path parameter.
            headers(dict): Dictionary of HTTP Headers to send with the Request
                .
            **query_parameters: Additional query parameters (provides
                support for parameters that may be added in the future).

        Returns:

            RestResponse: REST response with following properties:

              - headers(MyDict): response headers.
              - response(MyDict): response body as a MyDict object. Access the object's properties by using the dot notation
                or the bracket notation.
              - content(bytes): representation of the request's response
              - text(str): representation of the request's response

        Raises:
            TypeError: If the parameter types are incorrect.
            MalformedRequest: If the request body created is invalid.
            ApiError: If the Identity Services Engine cloud returns an error.
        """
        check_type(headers, dict)

        if headers is not None:
            if 'Content-Type' in headers:
                check_type(headers.get('Content-Type'),
                           basestring, may_be_none=False)
            if 'Accept' in headers:
                check_type(headers.get('Accept'),
                           basestring, may_be_none=False)
            if 'ERS-Media-Type' in headers:
                check_type(headers.get('ERS-Media-Type'),
                           basestring)
            if 'X-CSRF-Token' in headers:
                check_type(headers.get('X-CSRF-Token'),
                           basestring)

        with_custom_headers = False
        _headers = self._session.headers or {}
        if headers:
            _headers.update(dict_of_str(headers))
            with_custom_headers = True
        check_type(id, basestring,
                   may_be_none=False)

        _params = {
        }
        _params.update(query_parameters)
        _params = dict_from_items_with_values(_params)

        path_params = {
            'id': id,
        }

        e_url = ('/ers/config/selfregportal/{id}')
        endpoint_full_url = apply_path_params(e_url, path_params)
        if with_custom_headers:
            _api_response = self._session.delete(endpoint_full_url, params=_params,
                                                 headers=_headers)
        else:
            _api_response = self._session.delete(endpoint_full_url, params=_params)

        return self._object_factory('bpm_f9ada2e275fa2934fdb4825266a2c_v3_1_0', _api_response)

    def delete_by_id(self,
                     id,
                     headers=None,
                     **query_parameters):
        """Alias for `delete_self_registered_portal_by_id <#ciscoisesdk.
        api.v3_1_0.self_registered_portal.
        SelfRegisteredPortal.delete_self_registered_portal_by_id>`_
        """
        return self.delete_self_registered_portal_by_id(
            id=id,
            headers=headers,
            **query_parameters
        )

    def get_self_registered_portals(self,
                                    filter=None,
                                    filter_type=None,
                                    page=None,
                                    size=None,
                                    sortasc=None,
                                    sortdsc=None,
                                    headers=None,
                                    **query_parameters):
        """This API allows the client to get all the self registered
        portals.   Filter:   [name]   To search resources by
        using  toDate  column,follow the format:   DD-MON-YY
        (Example:13-SEP-18)     Day or Year:GET
        /ers/config/guestuser/?filter=toDate.CONTAINS.13
        Month:GET
        /ers/config/guestuser/?filter=toDate.CONTAINS.SEP
        Date:GET
        /ers/config/guestuser/?filter=toDate.CONTAINS.13-SEP-18
        Sorting:   [name, description].

        Args:
            page(int): page query parameter. Page number.
            size(int): size query parameter. Number of objects
                returned per page.
            sortasc(basestring): sortasc query parameter. sort asc.
            sortdsc(basestring): sortdsc query parameter. sort desc.
            filter(basestring, list, set, tuple): filter query
                parameter.               **Simple
                filtering** should be available through
                the filter query string parameter. The
                structure of a filter is a triplet of
                field operator and value separated with
                dots. More than one filter can be sent.
                The logical operator common to ALL
                filter criteria will be by default AND,
                and can be changed by using the
                "filterType=or" query string parameter.
                Each resource Data model description
                should specify if an attribute is a
                filtered field.              (Operator:
                Description),
                (EQ: Equals),               (NEQ: Not
                Equals),               (GT: Greater
                Than),               (LT: Less Then),
                (STARTSW: Starts With),
                (NSTARTSW: Not Starts With),
                (ENDSW: Ends With),
                (NENDSW: Not Ends With),
                (CONTAINS: Contains),
                (NCONTAINS: Not Contains),
                .
            filter_type(basestring): filterType query parameter. The
                logical operator common to ALL filter
                criteria will be by default AND, and can
                be changed by using the parameter.
            headers(dict): Dictionary of HTTP Headers to send with the Request
                .
            **query_parameters: Additional query parameters (provides
                support for parameters that may be added in the future).

        Returns:

            RestResponse: REST response with following properties:

              - headers(MyDict): response headers.
              - response(MyDict): response body as a MyDict object. Access the object's properties by using the dot notation
                or the bracket notation.
              - content(bytes): representation of the request's response
              - text(str): representation of the request's response

        Raises:
            TypeError: If the parameter types are incorrect.
            MalformedRequest: If the request body created is invalid.
            ApiError: If the Identity Services Engine cloud returns an error.
        """
        check_type(headers, dict)

        if headers is not None:
            if 'Content-Type' in headers:
                check_type(headers.get('Content-Type'),
                           basestring, may_be_none=False)
            if 'Accept' in headers:
                check_type(headers.get('Accept'),
                           basestring, may_be_none=False)
            if 'ERS-Media-Type' in headers:
                check_type(headers.get('ERS-Media-Type'),
                           basestring)
            if 'X-CSRF-Token' in headers:
                check_type(headers.get('X-CSRF-Token'),
                           basestring)

        with_custom_headers = False
        _headers = self._session.headers or {}
        if headers:
            _headers.update(dict_of_str(headers))
            with_custom_headers = True
        check_type(page, (int, basestring, list))
        check_type(size, (int, basestring, list))
        check_type(sortasc, basestring)
        check_type(sortdsc, basestring)
        check_type(filter, (basestring, list, set, tuple))
        check_type(filter_type, basestring)

        _params = {
            'page':
                page,
            'size':
                size,
            'sortasc':
                sortasc,
            'sortdsc':
                sortdsc,
            'filter':
                filter,
            'filterType':
                filter_type,
        }
        _params.update(query_parameters)
        _params = dict_from_items_with_values(_params)

        path_params = {
        }

        e_url = ('/ers/config/selfregportal')
        endpoint_full_url = apply_path_params(e_url, path_params)
        if with_custom_headers:
            _api_response = self._session.get(endpoint_full_url, params=_params,
                                              headers=_headers)
        else:
            _api_response = self._session.get(endpoint_full_url, params=_params)

        return self._object_factory('bpm_bb165bd00a6653ac9da440f23ee62ecc_v3_1_0', _api_response)

    def get_all(self,
                filter=None,
                filter_type=None,
                page=None,
                size=None,
                sortasc=None,
                sortdsc=None,
                headers=None,
                **query_parameters):
        """Alias for `get_self_registered_portals <#ciscoisesdk.
        api.v3_1_0.self_registered_portal.
        SelfRegisteredPortal.get_self_registered_portals>`_
        """
        return self.get_self_registered_portals(
            filter=filter,
            filter_type=filter_type,
            page=page,
            size=size,
            sortasc=sortasc,
            sortdsc=sortdsc,
            headers=headers,
            **query_parameters
        )

    def get_self_registered_portals_generator(self,
                                              filter=None,
                                              filter_type=None,
                                              page=None,
                                              size=None,
                                              sortasc=None,
                                              sortdsc=None,
                                              headers=None,
                                              **query_parameters):
        """This API allows the client to get all the self registered
        portals.   Filter:   [name]   To search resources by
        using  toDate  column,follow the format:   DD-MON-YY
        (Example:13-SEP-18)     Day or Year:GET
        /ers/config/guestuser/?filter=toDate.CONTAINS.13
        Month:GET
        /ers/config/guestuser/?filter=toDate.CONTAINS.SEP
        Date:GET
        /ers/config/guestuser/?filter=toDate.CONTAINS.13-SEP-18
        Sorting:   [name, description].

        Args:
            page(int): page query parameter. Page number.
            size(int): size query parameter. Number of objects
                returned per page.
            sortasc(basestring): sortasc query parameter. sort asc.
            sortdsc(basestring): sortdsc query parameter. sort desc.
            filter(basestring, list, set, tuple): filter query
                parameter.               **Simple
                filtering** should be available through
                the filter query string parameter. The
                structure of a filter is a triplet of
                field operator and value separated with
                dots. More than one filter can be sent.
                The logical operator common to ALL
                filter criteria will be by default AND,
                and can be changed by using the
                "filterType=or" query string parameter.
                Each resource Data model description
                should specify if an attribute is a
                filtered field.              (Operator:
                Description),
                (EQ: Equals),               (NEQ: Not
                Equals),               (GT: Greater
                Than),               (LT: Less Then),
                (STARTSW: Starts With),
                (NSTARTSW: Not Starts With),
                (ENDSW: Ends With),
                (NENDSW: Not Ends With),
                (CONTAINS: Contains),
                (NCONTAINS: Not Contains),
                .
            filter_type(basestring): filterType query parameter. The
                logical operator common to ALL filter
                criteria will be by default AND, and can
                be changed by using the parameter.
            headers(dict): Dictionary of HTTP Headers to send with the Request
                .
            **query_parameters: Additional query parameters (provides
                support for parameters that may be added in the future).

        Returns:
            Generator: A generator object containing the following object.

              + RestResponse: REST response with following properties:

                  - headers(MyDict): response headers.
                  - response(MyDict): response body as a MyDict object. Access the object's properties by using the dot notation
                    or the bracket notation.
                  - content(bytes): representation of the request's response
                  - text(str): representation of the request's response

        Raises:
            TypeError: If the parameter types are incorrect.
            MalformedRequest: If the request body created is invalid.
            ApiError: If the Identity Services Engine cloud returns an error.
        """

        yield from get_next_page(
            self.get_self_registered_portals, dict(
                filter=filter,
                filter_type=filter_type,
                page=page,
                size=size,
                sortasc=sortasc,
                sortdsc=sortdsc,
                headers=headers,
                **query_parameters
            ),
            access_next_list=["SearchResult", "nextPage", "href"],
            access_resource_list=["SearchResult", "resources"])

    def get_all_generator(self,
                          filter=None,
                          filter_type=None,
                          page=None,
                          size=None,
                          sortasc=None,
                          sortdsc=None,
                          headers=None,
                          **query_parameters):
        """Alias for `get_self_registered_portals_generator <#ciscoisesdk.
        api.v3_1_0.self_registered_portal.
        SelfRegisteredPortal.get_self_registered_portals_generator>`_
        """
        yield from get_next_page(
            self.get_self_registered_portals, dict(
                filter=filter,
                filter_type=filter_type,
                page=page,
                size=size,
                sortasc=sortasc,
                sortdsc=sortdsc,
                headers=headers,
                **query_parameters
            ),
            access_next_list=["SearchResult", "nextPage", "href"],
            access_resource_list=["SearchResult", "resources"])

    def create_self_registered_portal(self,
                                      customizations=None,
                                      description=None,
                                      name=None,
                                      portal_test_url=None,
                                      portal_type=None,
                                      settings=None,
                                      headers=None,
                                      payload=None,
                                      active_validation=True,
                                      **query_parameters):
        """This API creates a self registered portal.

        Args:
            customizations(object): Defines all of the Portal
                Customizations available, property of
                the request body.
            description(string): description, property of the
                request body.
            name(string): name, property of the request body.
            portal_test_url(string): URL to bring up a test page for
                this portal, property of the request
                body.
            portal_type(string): Allowed values: BYOD, HOTSPOTGUEST,
                MYDEVICE, SELFREGGUEST, SPONSOR,
                SPONSOREDGUEST, property of the request
                body.
            settings(object): Defines all of the settings groups
                available for a portal, property of the
                request body.
            headers(dict): Dictionary of HTTP Headers to send with the Request
                .
            payload(dict): A JSON serializable Python object to send in the
                body of the Request.
            active_validation(bool): Enable/Disable payload validation.
                Defaults to True.
            **query_parameters: Additional query parameters (provides
                support for parameters that may be added in the future).

        Returns:

            RestResponse: REST response with following properties:

              - headers(MyDict): response headers.
              - response(MyDict): response body as a MyDict object. Access the object's properties by using the dot notation
                or the bracket notation.
              - content(bytes): representation of the request's response
              - text(str): representation of the request's response

        Raises:
            TypeError: If the parameter types are incorrect.
            MalformedRequest: If the request body created is invalid.
            ApiError: If the Identity Services Engine cloud returns an error.
        """
        check_type(headers, dict)

        if headers is not None:
            if 'Content-Type' in headers:
                check_type(headers.get('Content-Type'),
                           basestring, may_be_none=False)
            if 'Accept' in headers:
                check_type(headers.get('Accept'),
                           basestring, may_be_none=False)
            if 'ERS-Media-Type' in headers:
                check_type(headers.get('ERS-Media-Type'),
                           basestring)
            if 'X-CSRF-Token' in headers:
                check_type(headers.get('X-CSRF-Token'),
                           basestring)

        with_custom_headers = False
        _headers = self._session.headers or {}
        if headers:
            _headers.update(dict_of_str(headers))
            with_custom_headers = True
        is_xml_payload = 'application/xml' in _headers.get('Content-Type', [])
        if active_validation and is_xml_payload:
            check_type(payload, basestring)
        if active_validation and not is_xml_payload:
            check_type(payload, dict)

        _params = {
        }
        _params.update(query_parameters)
        _params = dict_from_items_with_values(_params)

        path_params = {
        }
        if is_xml_payload:
            _payload = payload
        else:
            _tmp_payload = {
                'name':
                    name,
                'description':
                    description,
                'portalType':
                    portal_type,
                'portalTestUrl':
                    portal_test_url,
                'settings':
                    settings,
                'customizations':
                    customizations,
            }
            _payload = {
                'SelfRegPortal': dict_from_items_with_values(_tmp_payload)
            }
            _payload.update(payload or {})
            _payload = dict_from_items_with_values(_payload)
        if active_validation and not is_xml_payload:
            self._request_validator('jsd_d524614e122d53d68324daf1681eb753_v3_1_0')\
                .validate(_payload)

        e_url = ('/ers/config/selfregportal')
        endpoint_full_url = apply_path_params(e_url, path_params)

        request_params = {'data': _payload} if is_xml_payload else {'json': _payload}
        if with_custom_headers:
            _api_response = self._session.post(endpoint_full_url, params=_params,
                                               headers=_headers,
                                               **request_params)
        else:
            _api_response = self._session.post(endpoint_full_url, params=_params,
                                               **request_params)

        return self._object_factory('bpm_d524614e122d53d68324daf1681eb753_v3_1_0', _api_response)

    def create(self,
               customizations=None,
               description=None,
               name=None,
               portal_test_url=None,
               portal_type=None,
               settings=None,
               headers=None,
               payload=None,
               active_validation=True,
               **query_parameters):
        """Alias for `create_self_registered_portal <#ciscoisesdk.
        api.v3_1_0.self_registered_portal.
        SelfRegisteredPortal.create_self_registered_portal>`_
        """
        return self.create_self_registered_portal(
            customizations=customizations,
            description=description,
            name=name,
            portal_test_url=portal_test_url,
            portal_type=portal_type,
            settings=settings,
            payload=payload,
            active_validation=active_validation,
            headers=headers,
            **query_parameters
        )

    def get_version(self,
                    headers=None,
                    **query_parameters):
        """This API helps to retrieve the version information related to
        the self registered portal.

        Args:
            headers(dict): Dictionary of HTTP Headers to send with the Request
                .
            **query_parameters: Additional query parameters (provides
                support for parameters that may be added in the future).

        Returns:

            RestResponse: REST response with following properties:

              - headers(MyDict): response headers.
              - response(MyDict): response body as a MyDict object. Access the object's properties by using the dot notation
                or the bracket notation.
              - content(bytes): representation of the request's response
              - text(str): representation of the request's response

        Raises:
            TypeError: If the parameter types are incorrect.
            MalformedRequest: If the request body created is invalid.
            ApiError: If the Identity Services Engine cloud returns an error.
        """
        check_type(headers, dict)

        if headers is not None:
            if 'Content-Type' in headers:
                check_type(headers.get('Content-Type'),
                           basestring, may_be_none=False)
            if 'Accept' in headers:
                check_type(headers.get('Accept'),
                           basestring, may_be_none=False)

        with_custom_headers = False
        _headers = self._session.headers or {}
        if headers:
            _headers.update(dict_of_str(headers))
            with_custom_headers = True

        _params = {
        }
        _params.update(query_parameters)
        _params = dict_from_items_with_values(_params)

        path_params = {
        }

        e_url = ('/ers/config/selfregportal/versioninfo')
        endpoint_full_url = apply_path_params(e_url, path_params)
        if with_custom_headers:
            _api_response = self._session.get(endpoint_full_url, params=_params,
                                              headers=_headers)
        else:
            _api_response = self._session.get(endpoint_full_url, params=_params)

        return self._object_factory('bpm_d8cc0e6962558c58d263f53b857cff0_v3_1_0', _api_response)
