# Licensed under a 3-clause BSD style license, see LICENSE.
from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

from ..identifiers import IDs, ConstantIDs
from ..parser import POperator, PFunction, Parser, PConstant


__all__ = [
    'root_parser',
]


config = [
    POperator(IDs.MINUS, '-', rhs_only=True),
    POperator(IDs.PLUS, '+', rhs_only=True),
    POperator(IDs.ADD, '+'),
    POperator(IDs.SUB, '-'),
    POperator(IDs.MUL, '*'),
    POperator(IDs.DIV, '/'),
    POperator(IDs.MOD, '%'),
    POperator(IDs.POW, '**'),
    POperator(IDs.LSHIFT, '<<'),
    POperator(IDs.RSHIFT, '>>'),

    POperator(IDs.EQ, '=='),
    POperator(IDs.NEQ, '!='),
    POperator(IDs.GT, '>'),
    POperator(IDs.GTEQ, '>='),
    POperator(IDs.LT, '<'),
    POperator(IDs.LTEQ, '<='),

    POperator(IDs.AND, '&&'),
    POperator(IDs.OR, '||'),
    POperator(IDs.XOR, '^'),
    POperator(IDs.NOT, '!', rhs_only=True),

    PFunction(IDs.SQRT, 'sqrt'),
    PFunction(IDs.SQRT, 'TMath::Sqrt'),
    PFunction(IDs.ABS, 'TMath::Abs'),

    PFunction(IDs.LOG, 'log'),
    PFunction(IDs.LOG, 'TMath::Log'),
    PFunction(IDs.LOG2, 'log2'),
    PFunction(IDs.LOG2, 'TMath::Log2'),
    PFunction(IDs.LOG10, 'log10'),
    PFunction(IDs.LOG10, 'TMath::Log10'),

    PFunction(IDs.EXP, 'exp'),
    PFunction(IDs.EXP, 'TMath::Exp'),

    PFunction(IDs.SIN, 'sin'),
    PFunction(IDs.SIN, 'TMath::Sin'),
    PFunction(IDs.ASIN, 'arcsin'),
    PFunction(IDs.ASIN, 'TMath::ASin'),
    PFunction(IDs.COS, 'cos'),
    PFunction(IDs.COS, 'TMath::Cos'),
    PFunction(IDs.ACOS, 'arccos'),
    PFunction(IDs.ACOS, 'TMath::ACos'),
    PFunction(IDs.TAN, 'tan'),
    PFunction(IDs.TAN, 'TMath::Tan'),
    PFunction(IDs.ATAN, 'arctan'),
    PFunction(IDs.ATAN, 'TMath::ATan'),
    PFunction(IDs.ATAN2, 'arctan2', 2),
    PFunction(IDs.ATAN2, 'TMath::ATan2', 2),

    PFunction(IDs.COSH, 'TMath::CosH'),
    PFunction(IDs.ACOSH, 'TMath::ACosH'),
    PFunction(IDs.SINH, 'TMath::SinH'),
    PFunction(IDs.ASINH, 'TMath::ASinH'),
    PFunction(IDs.TANH, 'TMath::TanH'),
    PFunction(IDs.ATANH, 'TMath::ATanH'),

    PFunction(IDs.BESSELI0, 'TMath::BesselI0'),
    PFunction(IDs.BESSELI1, 'TMath::BesselI1'),
    PFunction(IDs.BESSELJ0, 'TMath::BesselJ0'),
    PFunction(IDs.BESSELJ1, 'TMath::BesselJ1'),
    PFunction(IDs.BESSELK0, 'TMath::BesselK0'),
    PFunction(IDs.BESSELK1, 'TMath::BesselK1'),
    PFunction(IDs.BESSELY0, 'TMath::BesselY0'),
    PFunction(IDs.BESSELY1, 'TMath::BesselY1'),
    PFunction(IDs.CEIL, 'TMath::Ceil'),
    PFunction(IDs.CEILNINT, 'TMath::CeilNint'),
    PFunction(IDs.DILOG, 'TMath::DiLog'),
    PFunction(IDs.ERF, 'TMath::Erf'),
    PFunction(IDs.ERFC, 'TMath::Erfc'),
    PFunction(IDs.ERFCINVERSE, 'TMath::ErfcInverse'),
    PFunction(IDs.ERFINVERSE, 'TMath::ErfInverse'),
    PFunction(IDs.EVEN, 'TMath::Even'),
    PFunction(IDs.FACTORIAL, 'TMath::Factorial'),
    PFunction(IDs.FLOOR, 'TMath::Floor'),
    PFunction(IDs.FLOORNINT, 'TMath::FloorNint'),
    PFunction(IDs.FREQ, 'TMath::Freq'),
    PFunction(IDs.KOLMOGOROVPROB, 'TMath::KolmogorovProb'),
    PFunction(IDs.LANDAUI, 'TMath::LandauI'),
    PFunction(IDs.LNGAMMA, 'TMath::LnGamma'),
    PFunction(IDs.NEXTPRIME, 'TMath::NextPrime'),
    PFunction(IDs.NORMQUANTILE, 'TMath::NormQuantile'),
    PFunction(IDs.ODD, 'TMath::Odd'),
    PFunction(IDs.SQUARE, 'TMath::Sq'),
    PFunction(IDs.STRUVEH0, 'TMath::StruveH0'),
    PFunction(IDs.STRUVEH1, 'TMath::StruveH1'),
    PFunction(IDs.STRUVEL0, 'TMath::StruveL0'),
    PFunction(IDs.STRUVEL1, 'TMath::StruveL1'),

    PFunction(IDs.BESSELI, 'TMath::BesselI', 2),
    PFunction(IDs.BESSELK, 'TMath::BesselK', 2),
    PFunction(IDs.BETA, 'TMath::Beta', 2),
    PFunction(IDs.BINOMIAL, 'TMath::Binomial', 2),
    PFunction(IDs.CHISQUAREQUANTILE, 'TMath::ChisquareQuantile', 2),
    PFunction(IDs.LDEXP, 'TMath::Ldexp', 2),
    PFunction(IDs.PERMUTE, 'TMath::Permute', 2),
    PFunction(IDs.POISSON, 'TMath::Poisson', 2),
    PFunction(IDs.POISSONI, 'TMath::PoissonI', 2),
    PFunction(IDs.PROB, 'TMath::Prob', 2),
    PFunction(IDs.STUDENT, 'TMath::Student', 2),
    PFunction(IDs.STUDENTI, 'TMath::StudentI', 2),

    PFunction(IDs.AREEQUALABS, 'TMath::AreEqualAbs', 3),
    PFunction(IDs.AREEQUALREL, 'TMath::AreEqualRel', 3),
    PFunction(IDs.BETACF, 'TMath::BetaCf', 3),
    PFunction(IDs.BETADIST, 'TMath::BetaDist', 3),
    PFunction(IDs.BETADISTI, 'TMath::BetaDistI', 3),
    PFunction(IDs.BETAINCOMPLETE, 'TMath::BetaIncomplete', 3),
    PFunction(IDs.BINOMIALI, 'TMath::BinomialI', 3),
    PFunction(IDs.BUBBLEHIGH, 'TMath::BubbleHigh', 3),
    PFunction(IDs.BUBBLELOW, 'TMath::BubbleLow', 3),
    PFunction(IDs.FDIST, 'TMath::FDist', 3),
    PFunction(IDs.FDISTI, 'TMath::FDistI', 3),
    PFunction(IDs.VAVILOV, 'TMath::Vavilov', 3),
    PFunction(IDs.VAVILOVI, 'TMath::VavilovI', 3),

    PFunction(IDs.ROOTSCUBIC, 'TMath::RootsCubic', 4),
    PFunction(IDs.QUANTILES, 'TMath::Quantiles', 5),

    # PFunction(IDs., 'TMath::BreitWigner()'),
    # PFunction(IDs., 'TMath::CauchyDist()'),
    # PFunction(IDs., 'TMath::Finite()'),
    # PFunction(IDs., 'TMath::Gamma()'),
    # PFunction(IDs., 'TMath::GammaDist()'),
    # PFunction(IDs., 'TMath::Gaus()'),
    # PFunction(IDs., 'TMath::Hash()'),
    # PFunction(IDs., 'TMath::Hypot()'),
    # PFunction(IDs., 'TMath::IsNaN()'),
    # PFunction(IDs., 'TMath::KolmogorovTest()'),
    # PFunction(IDs., 'TMath::Landau()'),
    # PFunction(IDs., 'TMath::LaplaceDist()'),
    # PFunction(IDs., 'TMath::LaplaceDistI()'),
    # PFunction(IDs., 'TMath::LogNormal()'),
    # PFunction(IDs., 'TMath::Max()'),
    # PFunction(IDs., 'TMath::Min()'),
    # PFunction(IDs., 'TMath::Nint<double>()'),
    # PFunction(IDs., 'TMath::Normalize()'),
    # PFunction(IDs., 'TMath::Power()'),
    # PFunction(IDs., 'TMath::Range()'),
    # PFunction(IDs., 'TMath::Sign()'),
    # PFunction(IDs., 'TMath::Sign<double, double>()'),
    # PFunction(IDs., 'TMath::SignBit()'),
    # PFunction(IDs., 'TMath::StudentQuantile()'),
    # PFunction(IDs., 'TMath::Voigt()'),
]

constants = [
    PConstant(ConstantIDs.TRUE, 'true'),
    PConstant(ConstantIDs.FALSE, 'false'),
    PConstant(ConstantIDs.INFINITY, 'TMath::Infinity()'),
    PConstant(ConstantIDs.NAN, 'TMath::QuietNaN()'),
    # PConstant(ConstantIDs., 'TMath::SignalingNaN()'),

    PConstant(ConstantIDs.SQRT2, 'sqrt2'),
    PConstant(ConstantIDs.SQRT2, 'TMath::Sqrt2()'),
    PConstant(ConstantIDs.E, 'e'),
    PConstant(ConstantIDs.E, 'TMath::E()'),
    PConstant(ConstantIDs.PI, 'pi'),
    PConstant(ConstantIDs.PI, 'TMath::Pi()'),
    PConstant(ConstantIDs.INVPI, 'TMath::InvPi()'),
    PConstant(ConstantIDs.PIOVER2, 'TMath::PiOver2()'),
    PConstant(ConstantIDs.PIOVER4, 'TMath::PiOver4()'),
    PConstant(ConstantIDs.TAU, 'TMath::TwoPi()'),
    PConstant(ConstantIDs.LN10, 'ln10'),
    PConstant(ConstantIDs.LN10, 'TMath::Ln10()'),
    PConstant(ConstantIDs.LOG10E, 'TMath::LogE()'),
    PConstant(ConstantIDs.DEG2RAD, 'TMath::DegToRad()'),
    PConstant(ConstantIDs.RAD2DEG, 'TMath::RadToDeg()'),

    PConstant(ConstantIDs.AVOGADRO, 'TMath::Na()'),
    PConstant(ConstantIDs.AVOGADRO_ERR, 'TMath::NaUncertainty()'),
    PConstant(ConstantIDs.BOLTZMANN, 'TMath::K()'),
    PConstant(ConstantIDs.BOLTZMANN_CGS, 'TMath::Kcgs()'),
    PConstant(ConstantIDs.BOLTZMANN_ERR, 'TMath::KUncertainty()'),
    PConstant(ConstantIDs.C, 'TMath::C()'),
    PConstant(ConstantIDs.C_CGS, 'TMath::Ccgs()'),
    PConstant(ConstantIDs.C_ERR, 'TMath::CUncertainty()'),
    PConstant(ConstantIDs.DRY_AIR_GAS, 'TMath::Rgair()'),
    PConstant(ConstantIDs.ELEMENTARY_CHARGE, 'TMath::Qe()'),
    PConstant(ConstantIDs.ELEMENTARY_CHARGE_ERR, 'TMath::QeUncertainty()'),
    PConstant(ConstantIDs.EULER_MASCHERONI, 'TMath::EulerGamma()'),
    PConstant(ConstantIDs.G, 'TMath::G()'),
    PConstant(ConstantIDs.G_CGS, 'TMath::Gcgs()'),
    PConstant(ConstantIDs.G_ERR, 'TMath::GUncertainty()'),
    PConstant(ConstantIDs.G_OVER_HBARC, 'TMath::GhbarC()'),
    PConstant(ConstantIDs.G_OVER_HBARC_ERR, 'TMath::GhbarCUncertainty()'),
    PConstant(ConstantIDs.GRAV_ACCEL, 'TMath::Gn()'),
    PConstant(ConstantIDs.GRAV_ACCEL_ERR, 'TMath::GnUncertainty()'),
    PConstant(ConstantIDs.H, 'TMath::H()'),
    PConstant(ConstantIDs.H_CGS, 'TMath::Hcgs()'),
    PConstant(ConstantIDs.H_ERR, 'TMath::HUncertainty()'),
    PConstant(ConstantIDs.HBAR, 'TMath::Hbar()'),
    PConstant(ConstantIDs.HBAR_CGS, 'TMath::Hbarcgs()'),
    PConstant(ConstantIDs.HBAR_ERR, 'TMath::HbarUncertainty()'),
    PConstant(ConstantIDs.HxC, 'TMath::HC()'),
    PConstant(ConstantIDs.HxC_CGS, 'TMath::HCcgs()'),
    PConstant(ConstantIDs.MOL_WEIGHT_DRY_AIR, 'TMath::MWair()'),
    PConstant(ConstantIDs.STEFAN_BOLTZMANN, 'TMath::Sigma()'),
    PConstant(ConstantIDs.STEFAN_BOLTZMANN_ERR, 'TMath::SigmaUncertainty()'),
    PConstant(ConstantIDs.UNIVERSAL_GAS, 'TMath::R()'),
    PConstant(ConstantIDs.UNIVERSAL_GAS_ERR, 'TMath::RUncertainty()'),
]

root_parser = Parser('ROOT', config, constants)
