/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.util.Collections;
import java.util.Set;
import org.semanticweb.owlapi.change.SetOntologyIDData;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitor;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitorEx;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class SetOntologyID
extends OWLOntologyChange {
    private final OWLOntologyID ontologyID;
    private final OWLOntologyID newOntologyID;

    public SetOntologyID(OWLOntology ont, OWLOntologyID ontologyID) {
        super(ont);
        this.ontologyID = ont.getOntologyID();
        this.newOntologyID = ontologyID;
    }

    public SetOntologyID(OWLOntology ont, IRI ontologyIRI) {
        this(ont, new OWLOntologyID(ontologyIRI));
    }

    @Override
    public SetOntologyIDData getChangeData() {
        return new SetOntologyIDData(this.newOntologyID);
    }

    @Override
    public Set<OWLEntity> getSignature() {
        return Collections.emptySet();
    }

    @Override
    public boolean isImportChange() {
        return false;
    }

    @Override
    public boolean isAxiomChange() {
        return false;
    }

    @Override
    public boolean isAddAxiom() {
        return false;
    }

    @Override
    public OWLAxiom getAxiom() {
        throw new UnsupportedOperationException("Not an axiom change");
    }

    public OWLOntologyID getOriginalOntologyID() {
        return this.ontologyID;
    }

    public OWLOntologyID getNewOntologyID() {
        return this.newOntologyID;
    }

    @Override
    public void accept(OWLOntologyChangeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLOntologyChangeVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SetOntologyID(");
        sb.append(this.getNewOntologyID().toString());
        sb.append(" OntologyID(");
        sb.append(this.getOntology().getOntologyID());
        sb.append(")");
        sb.append(")");
        return sb.toString();
    }

    public int hashCode() {
        return 57 + this.ontologyID.hashCode() + this.newOntologyID.hashCode() * 3;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SetOntologyID)) {
            return false;
        }
        SetOntologyID change = (SetOntologyID)obj;
        return change.getOriginalOntologyID().equals(this.ontologyID) && change.getNewOntologyID().equals(this.getNewOntologyID());
    }
}

