/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.process.inf;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.riot.process.inf.InferenceProcessorRDFS;
import org.apache.jena.riot.process.inf.InferenceSetupRDFS;

class InferenceProcessorTriples
implements Sink<Triple> {
    private final Sink<Triple> output;
    private final InferenceSetupRDFS rdfsSetup;
    private final InferenceProcessorRDFS rdfs;

    public InferenceProcessorTriples(Sink<Triple> output, InferenceSetupRDFS rdfsSetup) {
        this.output = output;
        this.rdfsSetup = rdfsSetup;
        this.rdfs = new InferenceProcessorRDFS(rdfsSetup){

            @Override
            public void derive(Node s, Node p, Node o) {
                InferenceProcessorTriples.this.output.send(new Triple(s, p, o));
            }
        };
    }

    @Override
    public void send(Triple triple) {
        this.output.send(triple);
        this.rdfs.process(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    @Override
    public void flush() {
        this.output.flush();
    }

    @Override
    public void close() {
        this.output.close();
    }
}

