/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.Map;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.tbox.impl.TBoxExpImpl;
import org.mindswap.pellet.tbox.impl.TermDefinition;

public class TBoxBase {
    public static Logger log = Logger.getLogger(TBoxBase.class.getName());
    protected KnowledgeBase kb;
    protected TBoxExpImpl tbox;
    protected Map<ATermAppl, TermDefinition> termhash = CollectionUtils.makeIdentityMap();

    public TBoxBase(TBoxExpImpl tBoxExpImpl) {
        this.tbox = tBoxExpImpl;
        this.kb = tBoxExpImpl.getKB();
    }

    public boolean addDef(ATermAppl aTermAppl) {
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
        if (this.termhash.containsKey(aTermAppl2)) {
            this.getTD((ATerm)aTermAppl2).addDef(aTermAppl);
        } else {
            TermDefinition termDefinition = new TermDefinition();
            termDefinition.addDef(aTermAppl);
            this.termhash.put(aTermAppl2, termDefinition);
        }
        return true;
    }

    public boolean removeDef(ATermAppl aTermAppl) {
        boolean bl = false;
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
        TermDefinition termDefinition = this.getTD((ATerm)aTermAppl2);
        if (termDefinition != null) {
            bl = termDefinition.removeDef(aTermAppl);
        }
        return bl;
    }

    public boolean contains(ATerm aTerm) {
        return this.termhash.containsKey(aTerm);
    }

    public TermDefinition getTD(ATerm aTerm) {
        return this.termhash.get(aTerm);
    }

    public boolean isEmpty() {
        return this.termhash.size() == 0;
    }

    public int size() {
        return this.termhash.size();
    }
}

