/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.NodeMerge;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.branch.MaxBranch;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.rule.AbstractTableauRule;
import org.mindswap.pellet.utils.SetUtils;

public class MaxRule
extends AbstractTableauRule {
    public MaxRule(CompletionStrategy completionStrategy) {
        super(completionStrategy, NodeSelector.MAX_NUMBER, AbstractTableauRule.BlockingType.INDIRECT);
    }

    @Override
    public void apply(Individual individual) {
        if (!individual.canApply(5)) {
            return;
        }
        List<ATermAppl> list = individual.getTypes(5);
        for (int i = 0; i < list.size(); ++i) {
            ATermAppl aTermAppl = list.get(i);
            this.applyMaxRule(individual, aTermAppl);
            if (this.strategy.getABox().isClosed()) {
                return;
            }
            if (!individual.isMerged()) continue;
            return;
        }
        individual.applyNext[5] = list.size();
    }

    protected void applyMaxRule(Individual individual, ATermAppl aTermAppl) {
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
        Role role = this.strategy.getABox().getRole(aTermAppl2.getArgument(0));
        int n = ((ATermInt)aTermAppl2.getArgument(1)).getInt() - 1;
        ATermAppl aTermAppl3 = (ATermAppl)aTermAppl2.getArgument(2);
        DependencySet dependencySet = individual.getDepends((ATerm)aTermAppl);
        if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && dependencySet == null) {
            return;
        }
        if (n == 1) {
            this.applyFunctionalMaxRule(individual, role, aTermAppl3, dependencySet);
            if (this.strategy.getABox().isClosed()) {
                return;
            }
        } else {
            boolean bl = true;
            while (bl) {
                bl = this.applyMaxRule(individual, role, aTermAppl3, n, dependencySet);
                if (this.strategy.getABox().isClosed()) {
                    return;
                }
                if (individual.isMerged()) {
                    return;
                }
                if (!bl) continue;
                dependencySet = dependencySet.union(new DependencySet(this.strategy.getABox().getBranches().size()), this.strategy.getABox().doExplanation());
            }
        }
    }

    protected boolean applyMaxRule(Individual individual, Role role, ATermAppl aTermAppl, int n, DependencySet dependencySet) {
        EdgeList edgeList = individual.getRNeighborEdges(role);
        Set<Node> set = edgeList.getFilteredNeighbors(individual, aTermAppl);
        int n2 = set.size();
        if (n == 0 && n2 > 0) {
            for (int i = 0; i < edgeList.size(); ++i) {
                Edge edge = edgeList.edgeAt(i);
                Node node = edge.getNeighbor(individual);
                DependencySet dependencySet2 = node.getDepends((ATerm)aTermAppl);
                if (dependencySet2 == null) continue;
                Role role2 = edge.getRole();
                DependencySet dependencySet3 = role.getExplainSubOrInv(role2);
                dependencySet = dependencySet.union(dependencySet3, this.strategy.getABox().doExplanation());
                dependencySet = dependencySet.union(edge.getDepends(), this.strategy.getABox().doExplanation());
                dependencySet = dependencySet.union(dependencySet2, this.strategy.getABox().doExplanation());
            }
            this.strategy.getABox().setClash(Clash.maxCardinality(individual, dependencySet, role.getName(), 0));
            return false;
        }
        if (n2 <= n) {
            return false;
        }
        ArrayList<NodeMerge> arrayList = new ArrayList<NodeMerge>();
        DependencySet dependencySet4 = this.findMergeNodes(set, individual, arrayList);
        dependencySet = dependencySet.union(dependencySet4, this.strategy.getABox().doExplanation());
        if (arrayList.size() == 0) {
            DependencySet dependencySet5 = individual.hasDistinctRNeighborsForMax(role, n + 1, aTermAppl);
            if (dependencySet5 == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Cannot determine the exact clash dependency for " + individual);
                }
                this.strategy.getABox().setClash(Clash.maxCardinality(individual, dependencySet));
                return false;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Early clash detection for max rule worked " + individual + " has more than " + n + " " + role + " edges " + dependencySet.union(dependencySet5, this.strategy.getABox().doExplanation()) + " " + individual.getRNeighborEdges(role).getNeighbors(individual));
            }
            if (this.strategy.getABox().doExplanation()) {
                this.strategy.getABox().setClash(Clash.maxCardinality(individual, dependencySet.union(dependencySet5, this.strategy.getABox().doExplanation()), role.getName(), n));
            } else {
                this.strategy.getABox().setClash(Clash.maxCardinality(individual, dependencySet.union(dependencySet5, this.strategy.getABox().doExplanation())));
            }
            return false;
        }
        MaxBranch maxBranch = new MaxBranch(this.strategy.getABox(), this.strategy, individual, role, n, aTermAppl, arrayList, dependencySet);
        this.strategy.addBranch(maxBranch);
        if (!maxBranch.tryNext()) {
            return false;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("hasMore: " + (n2 > n + 1));
        }
        return n2 > n + 1;
    }

    DependencySet findMergeNodes(Set<Node> set, Individual individual, List<NodeMerge> list) {
        DependencySet dependencySet = DependencySet.INDEPENDENT;
        ArrayList<Node> arrayList = new ArrayList<Node>(set);
        for (int i = 0; i < arrayList.size(); ++i) {
            Node node = (Node)arrayList.get(i);
            for (int j = i + 1; j < arrayList.size(); ++j) {
                Node node2 = (Node)arrayList.get(j);
                if (node.isDifferent(node2)) {
                    dependencySet = dependencySet.union(node.getDifferenceDependency(node2), this.strategy.getABox().doExplanation());
                    continue;
                }
                if (node2.getNominalLevel() < node.getNominalLevel()) {
                    list.add(new NodeMerge(node, node2));
                    continue;
                }
                if (node.isNominal()) {
                    list.add(new NodeMerge(node2, node));
                    continue;
                }
                if (node.hasSuccessor(individual)) {
                    list.add(new NodeMerge(node2, node));
                    continue;
                }
                list.add(new NodeMerge(node, node2));
            }
        }
        return dependencySet;
    }

    public void applyFunctionalMaxRule(Individual individual, Role role, ATermAppl aTermAppl, DependencySet dependencySet) {
        Set<Role> set = role.getFunctionalSupers();
        if (set.isEmpty()) {
            set = SetUtils.singleton(role);
        }
        block0: for (Role role2 : set) {
            Edge edge;
            int n;
            Set<Node> set2;
            EdgeList edgeList;
            if (PelletOptions.USE_TRACING) {
                dependencySet = dependencySet.union(role.getExplainSuper((ATerm)role2.getName()), this.strategy.getABox().doExplanation()).union(role2.getExplainFunctional(), this.strategy.getABox().doExplanation());
            }
            if ((edgeList = individual.getRNeighborEdges(role2)).size() <= 1 || (set2 = edgeList.getFilteredNeighbors(individual, aTermAppl)).size() <= 1) continue;
            Node node = null;
            int n2 = edgeList.size();
            for (n = 0; n < n2; ++n) {
                edge = edgeList.edgeAt(n);
                node = edge.getNeighbor(individual);
                if (node.isPruned() || !set2.contains(node)) continue;
                dependencySet = dependencySet.union(edge.getDepends(), this.strategy.getABox().doExplanation());
                dependencySet = dependencySet.union(node.getDepends((ATerm)aTermAppl), this.strategy.getABox().doExplanation());
                dependencySet = dependencySet.union(role2.getExplainSubOrInv(edge.getRole()), this.strategy.getABox().doExplanation());
                break;
            }
            ++n;
            while (n < n2) {
                edge = edgeList.edgeAt(n);
                Node node2 = edge.getNeighbor(individual);
                if (!node2.isPruned() && set2.contains(node2) && !node.isSame(node2)) {
                    Node node3;
                    dependencySet = dependencySet.union(edge.getDepends(), this.strategy.getABox().doExplanation());
                    dependencySet = dependencySet.union(node2.getDepends((ATerm)aTermAppl), this.strategy.getABox().doExplanation());
                    dependencySet = dependencySet.union(role2.getExplainSubOrInv(edge.getRole()), this.strategy.getABox().doExplanation());
                    if (node2.isDifferent(node)) {
                        dependencySet = dependencySet.union(node.getDepends((ATerm)aTermAppl), this.strategy.getABox().doExplanation());
                        dependencySet = dependencySet.union(node2.getDepends((ATerm)aTermAppl), this.strategy.getABox().doExplanation());
                        dependencySet = dependencySet.union(node2.getDifferenceDependency(node), this.strategy.getABox().doExplanation());
                        if (role2.isFunctional()) {
                            this.strategy.getABox().setClash(Clash.functionalCardinality(individual, dependencySet, role2.getName()));
                            continue block0;
                        }
                        this.strategy.getABox().setClash(Clash.maxCardinality(individual, dependencySet, role2.getName(), 1));
                        continue block0;
                    }
                    if (individual.isNominal() && node.isBlockable() && node2.isBlockable() && node.hasSuccessor(individual) && node2.hasSuccessor(individual)) {
                        node3 = this.strategy.createFreshIndividual(null, dependencySet);
                        this.strategy.addEdge(individual, role2, node3, dependencySet);
                        continue block0;
                    }
                    if (node2.getNominalLevel() < node.getNominalLevel() || !node.isNominal() && node2.hasSuccessor(individual)) {
                        node3 = node;
                        node = node2;
                        node2 = node3;
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("FUNC: " + individual + " for prop " + role2 + " merge " + node2 + " -> " + node + " " + dependencySet);
                    }
                    this.strategy.mergeTo(node2, node, dependencySet);
                    if (this.strategy.getABox().isClosed()) {
                        return;
                    }
                    if (node.isPruned()) {
                        dependencySet = dependencySet.union(node.getMergeDependency(true), this.strategy.getABox().doExplanation());
                        node = node.getSame();
                    }
                }
                ++n;
            }
        }
    }
}

