/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.CollectionUtils;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.compose.MultiUnion;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.utils.iterator.IteratorUtils;

public class PelletGraphListener
implements GraphListener {
    private KnowledgeBase kb;
    private Graph rootGraph;
    private Set<Graph> leafGraphs;
    private Set<Graph> changedGraphs;
    private boolean statementDeleted;

    public PelletGraphListener(Graph graph, KnowledgeBase knowledgeBase) {
        this.rootGraph = graph;
        this.kb = knowledgeBase;
        this.leafGraphs = CollectionUtils.makeSet();
        this.changedGraphs = CollectionUtils.makeSet();
        this.statementDeleted = false;
        this.collectLeafGraphs(graph, Collections.emptySet());
    }

    private void addABoxTriple(Triple triple) {
        ATermAppl aTermAppl = JenaUtils.makeATerm(triple.getSubject());
        ATermAppl aTermAppl2 = JenaUtils.makeATerm(triple.getObject());
        if (triple.getPredicate().equals((Object)RDF.type.asNode())) {
            if (!this.kb.getIndividuals().contains(aTermAppl)) {
                this.kb.addIndividual(aTermAppl);
            }
            this.kb.addType(aTermAppl, aTermAppl2);
        } else {
            if (!this.kb.getIndividuals().contains(aTermAppl)) {
                this.kb.addIndividual(aTermAppl);
            }
            if (!triple.getObject().isLiteral() && !this.kb.getIndividuals().contains(aTermAppl2)) {
                this.kb.addIndividual(aTermAppl2);
            }
            ATermAppl aTermAppl3 = JenaUtils.makeATerm(triple.getPredicate());
            this.kb.addPropertyValue(aTermAppl3, aTermAppl, aTermAppl2);
        }
    }

    private void deleteABoxTriple(Triple triple) {
        ATermAppl aTermAppl = JenaUtils.makeATerm(triple.getSubject());
        ATermAppl aTermAppl2 = JenaUtils.makeATerm(triple.getObject());
        if (triple.getPredicate().equals((Object)RDF.type.asNode())) {
            if (this.kb.isIndividual((ATerm)aTermAppl)) {
                this.kb.removeType(aTermAppl, aTermAppl2);
            }
        } else if (this.kb.isIndividual((ATerm)aTermAppl) && this.kb.isIndividual((ATerm)aTermAppl2)) {
            ATermAppl aTermAppl3 = JenaUtils.makeATerm(triple.getPredicate());
            this.kb.removePropertyValue(aTermAppl3, aTermAppl, aTermAppl2);
        }
    }

    private void collectLeafGraphs(Graph graph, Set<Graph> set) {
        if (graph instanceof MultiUnion) {
            MultiUnion multiUnion = (MultiUnion)graph;
            if (multiUnion.getBaseGraph() != null) {
                this.collectLeafGraphs(multiUnion.getBaseGraph(), set);
            }
            Iterator iterator = multiUnion.getSubGraphs().iterator();
            while (iterator.hasNext()) {
                this.collectLeafGraphs((Graph)iterator.next(), set);
            }
        } else if (graph instanceof InfGraph) {
            this.collectLeafGraphs(((InfGraph)graph).getRawGraph(), set);
        } else if (this.leafGraphs.add(graph) && !set.contains(graph)) {
            this.changedGraphs.add(graph);
            graph.getEventManager().register((GraphListener)this);
        }
    }

    private boolean canUpdateIncrementally(Graph graph) {
        return PelletOptions.PROCESS_JENA_UPDATES_INCREMENTALLY && !this.statementDeleted && !this.changedGraphs.contains(graph);
    }

    public void dispose() {
        for (Graph graph : this.leafGraphs) {
            graph.getEventManager().unregister((GraphListener)this);
        }
        this.leafGraphs.clear();
        this.changedGraphs.clear();
        this.statementDeleted = false;
    }

    public boolean isChanged() {
        if (this.statementDeleted || !this.changedGraphs.isEmpty()) {
            return true;
        }
        this.getChangedGraphs();
        return this.statementDeleted || !this.changedGraphs.isEmpty();
    }

    public Set<Graph> getChangedGraphs() {
        Set<Graph> set = this.leafGraphs;
        this.leafGraphs = CollectionUtils.makeSet();
        this.collectLeafGraphs(this.rootGraph, set);
        for (Graph graph : set) {
            if (this.leafGraphs.contains(graph)) continue;
            this.statementDeleted = true;
            graph.getEventManager().unregister((GraphListener)this);
        }
        if (this.statementDeleted) {
            return null;
        }
        return this.changedGraphs;
    }

    public Set<Graph> getLeafGraphs() {
        return this.leafGraphs;
    }

    private boolean isABoxChange(Triple triple) {
        Node node = triple.getObject();
        Node node2 = triple.getPredicate();
        if (node2.equals((Object)RDF.type.asNode())) {
            if (node.isBlank()) {
                return false;
            }
            ATermAppl aTermAppl = JenaUtils.makeATerm(node);
            if (!this.kb.isClass((ATerm)aTermAppl)) {
                return false;
            }
        } else {
            ATermAppl aTermAppl = JenaUtils.makeATerm(node2);
            if (!this.kb.isProperty((ATerm)aTermAppl)) {
                return false;
            }
        }
        return true;
    }

    public void notifyAddArray(Graph graph, Triple[] tripleArray) {
        this.notifyAddIterator(graph, IteratorUtils.iterator(tripleArray));
    }

    public void notifyAddGraph(Graph graph, Graph graph2) {
        this.notifyAddIterator(graph, (Iterator<Triple>)graph2.find((TripleMatch)Triple.ANY));
    }

    public void notifyAddIterator(Graph graph, Iterator<Triple> iterator) {
        boolean bl = this.canUpdateIncrementally(graph);
        if (bl) {
            while (iterator.hasNext()) {
                Triple triple = iterator.next();
                if (!this.isABoxChange(triple)) {
                    bl = false;
                    break;
                }
                this.addABoxTriple(triple);
            }
        }
        if (!bl) {
            this.changedGraphs.add(graph);
        }
    }

    public void notifyAddList(Graph graph, List<Triple> list) {
        this.notifyAddIterator(graph, list.iterator());
    }

    public void notifyAddTriple(Graph graph, Triple triple) {
        if (this.canUpdateIncrementally(graph) && this.isABoxChange(triple)) {
            this.addABoxTriple(triple);
        } else {
            this.changedGraphs.add(graph);
        }
    }

    public void notifyDeleteArray(Graph graph, Triple[] tripleArray) {
        this.notifyDeleteIterator(graph, IteratorUtils.iterator(tripleArray));
    }

    public void notifyDeleteGraph(Graph graph, Graph graph2) {
        this.notifyDeleteIterator(graph, (Iterator<Triple>)graph2.find((TripleMatch)Triple.ANY));
    }

    public void notifyDeleteIterator(Graph graph, Iterator<Triple> iterator) {
        boolean bl = this.canUpdateIncrementally(graph);
        if (bl) {
            while (iterator.hasNext()) {
                Triple triple = iterator.next();
                if (!this.isABoxChange(triple)) {
                    bl = false;
                    break;
                }
                this.deleteABoxTriple(triple);
            }
        }
        if (!bl) {
            this.statementDeleted = true;
            this.changedGraphs.add(graph);
        }
    }

    public void notifyDeleteList(Graph graph, List<Triple> list) {
        this.notifyDeleteIterator(graph, list.iterator());
    }

    public void notifyDeleteTriple(Graph graph, Triple triple) {
        if (this.canUpdateIncrementally(graph) && this.isABoxChange(triple)) {
            this.deleteABoxTriple(triple);
        } else {
            this.statementDeleted = true;
            this.changedGraphs.add(graph);
        }
    }

    public void notifyEvent(Graph graph, Object object) {
        this.statementDeleted = true;
    }

    public void reset() {
        this.changedGraphs.clear();
        this.statementDeleted = false;
    }
}

